"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosInfo = void 0;
const ros_element_1 = require("./ros-element");
class RosInfo extends ros_element_1.RosElement {
    /**
     * Creates properties for this stack.
     * @param scope The parent construct.
     * @param props The value of the property.
     */
    constructor(scope, id, info) {
        super(scope, id);
        if (id !== RosInfo.formatVersion && id !== RosInfo.description && id !== RosInfo.metadata) {
            throw new Error(`The RosInfo id should be in these following scopes: formatVersion, description, Metadata.\n
        Use RosInfo.formatVersion, RosInfo.description and RosInfo.metadata to assign this parameter.
      `);
        }
        if (id === RosInfo.formatVersion && info !== RosInfo.v20150901) {
            throw new Error(`If you want to define the format version, you should use RosInfo.vXXXXX.\n
        ROS CDK support the folloowing version: RosInfo.v20150901
      `);
        }
        this.infoType = id;
        this._value = info;
    }
    /**
     * @internal
     */
    _toRosTemplate() {
        const temp = {};
        temp[this.infoType] = this._value;
        return temp;
    }
}
exports.RosInfo = RosInfo;
RosInfo.formatVersion = 'ROSTemplateFormatVersion';
RosInfo.description = 'Description';
RosInfo.metadata = 'Metadata';
RosInfo.v20150901 = '2015-09-01';
//# sourceMappingURL=data:application/json;base64,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