"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosCondition = void 0;
const ros_element_1 = require("./ros-element");
/**
 * Represents a RosTemplate condition, for resources which must be conditionally created and
 * the determination must be made at deploy time.
 */
class RosCondition extends ros_element_1.RosElement {
    /**
     * Build a new condition. The condition must be constructed with a condition token,
     * that the condition is based on.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.expression = props && props.expression;
    }
    /**
     * @internal
     */
    _toRosTemplate() {
        if (!this.expression) {
            return {};
        }
        return {
            Conditions: {
                [this.logicalId]: this.expression,
            },
        };
    }
    /**
     * Synthesizes the condition.
     */
    resolve(_context) {
        return { Condition: this.logicalId };
    }
}
exports.RosCondition = RosCondition;
//# sourceMappingURL=data:application/json;base64,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