import { Construct, IConstruct } from "./construct-compat";
import { RosResource } from "./ros-resource";
import { RemovalPolicy } from "./ros-removal-policy";
import { RosCondition } from "./ros-condition";
import { Stack } from "./stack";
/**
 * Interface for the Resource construct.
 */
export interface IResource extends IConstruct {
    /**
     * The stack in which this resource is defined.
     */
    readonly stack: Stack;
}
/**
 * Construction properties for {@link Resource}.
 */
export interface ResourceProps {
    /**
     * The value passed in by users to the physical name prop of the resource.
     *
     * - `undefined` implies that a physical name will be allocated during deployment.
     * - a concrete value implies a specific physical name
     * - `PhysicalName.GENERATE_IF_NEEDED` is a marker that indicates that a physical will only be generated
     *   by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated.
     *
     * @default - The physical name will be allocated at deployment time
     */
    readonly physicalName?: string;
}
/**
 * A construct which represents a resource.
 */
export declare abstract class Resource extends Construct implements IResource {
    readonly stack: Stack;
    resource: RosResource | undefined;
    /**
     * Returns a string-encoded token that resolves to the physical name that
     * should be passed to the ROS resource.
     *
     * This value will resolve to one of the following:
     * - a concrete value (e.g. `"my-awesome-bucket"`)
     * - `undefined`, when a name should be generated by ROS
     * - a concrete name generated automatically during synthesis, in
     *   cross-environment scenarios.
     *
     * @experimental
     */
    protected readonly physicalName: string;
    private _physicalName;
    private readonly _allowCrossEnvironment;
    constructor(scope: Construct, id: string, props?: ResourceProps);
    addDependency(resource: Resource): void;
    applyRemovalPolicy(policy: RemovalPolicy): void;
    addCondition(condition: RosCondition): void;
    addResourceDesc(desc: string): void;
    setMetadata(key: string, value: any): void;
    getAtt(name: string): string;
    /**
     * Called when this resource is referenced across environments
     * (account/region) to order to request that a physical name will be generated
     * for this resource during synthesis, so the resource can be referenced
     * through it's absolute name/arn.
     *
     * @internal
     */
    _enableCrossEnvironment(): void;
    protected generatePhysicalName(): string;
}
