# auto generated by update_py.py

from collections import defaultdict
from typing import List, Optional, Type, Tuple, Dict, DefaultDict
from functools import partial
import os
import threading
import importlib
import datetime
import time
import enum
import traceback
import json
import math
import copy
import sys


from read_protobuf import read_protobuf
from feishuconnector import FeishuConnector
import numpy as np
import pandas as pd

from tlclient.linker.constant import FistType, HeartBeatStatus, ReadableEnum
from tlclient.linker.logger import get_log_default_path
from tlclient.trader.pb_msg.message_pb2 import GatewayPosition, GatewayTrades
from tlclient.trader.client import Client
from tlclient.trader.pb_msg import message_pb
from tlclient.trader.config import Configurator
from tlclient.trader.constant import Side, ExchangeID, PosiDirection, PosDetail, OffsetFlag, AssetType


SECONDS_TO_WAIT_FOR_CHECKING_TGS = 3
DEFAULT_TRADE_START_TIME = '09:00'
DEFAULT_TG_MG_READY_TIME = '08:43'
DEFAULT_NIGHT_TRADE_START_TIME = '21:00'
DEFAULT_NIGHT_TG_MG_READY_TME = '20:43'
DEFAULT_SWITCH_DAY_TIME = '16:00'
DEFAULT_REPORT_TIME = '15:22'
DEFAULT_TRADE_ORDER_TIME = '14:56'
DEFAULT_TRADE_DEADLINE_TIME = '14:57'
DEFAULT_OURS_NAME = 'next_oms'
DEFAULT_ENV_NAME = 'env_oms'
DEFAULT_SECRET_SYMBOL = ''


def _abs_floor(x):
    """
    >>> abs_floor = lambda x: np.sign(x) * np.floor(abs(x))
    >>> abs_floor(-1.2)
    -1.0
    >>> abs_floor(1.2)
    1.0
    >>> abs_floor(15.6)
    15.0
    """
    return np.sign(x) * np.floor(abs(x))


class TradeDataTag(ReadableEnum, enum.IntEnum):

    TRADES = 1
    POSITION = 2
    ACCOUNT = 3
    POSITION_BEFORE = 4


class NextOMSAlgoSPI:
    def __init__(self, ctx):
        self._ctx = ctx

    def append_trade_with_tag(self, df):
        return self._ctx._datas_api.append_trade_with_tag(df)


class NextOMSDataAPIBase:

    def __init__(self, logger):
        self.logger = logger

    def init(self):
        pass

    # to be overrided
    def append_trade_data(self, tag: TradeDataTag, data, raw_data=None) -> bool:
        pass

    # to be overrided
    def get_raw_signal(self, the_date: datetime.date) -> pd.DataFrame:
        pass

    # to be overrided
    def get_df_allo(self) -> pd.DataFrame:
        pass

    # to be overrided
    def get_trade_signal(self, the_date: datetime.date) -> pd.DataFrame:
        pass

    # to be overrided
    def get_trade_targets(self, the_date: datetime.date) -> pd.DataFrame:
        pass

    # to be overrided
    def update_final_orders(self, df: pd.DataFrame):
        pass

    # to be overrided
    def append_trade_with_tag(self, df: pd.DataFrame):
        pass

    # to be overrided
    def get_position_with_tag(self, the_date: datetime.date) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_future_info(self, tickers: List[str] = []) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_future_price(self, the_date, tickers: List[str] = []) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_stock_price(self, the_date, tickers: List[str] = []) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def get_trading_day_list(self, start_date=None, end_date=None) -> Optional[pd.DataFrame]:
        pass

    # to be overrided
    def notify_simple_msg(self, msg: str, title: str):
        pass

    # to be overrided
    def send_df_image(self, df: pd.DataFrame, title: str):
        pass

    # to be overrided
    def init_db(self):
        pass


class NextOMS(Client):

    @staticmethod
    def _calc_side_for_netoff_orders(x: float) -> str:
        assert not math.isclose(x, 0), f'order num should not be ZERO {x}'
        return Side.read(Side.BUY if x > 0 else Side.SELL)

    @staticmethod
    def _calc_offset_flag_for_netoff_orders(x: pd.Series) -> Tuple[str, int]:
        assert not math.isclose(x.order, 0), f'order num should not be ZERO {x}'
        if np.sign(x.target) != np.sign(x.order):
            # FIXME: 这里区分 close or close today or close yesterday 有点麻烦 就先简化成均为 close 了
            return OffsetFlag.read(OffsetFlag.CLOSE), 2
        else:
            return OffsetFlag.read(OffsetFlag.OPEN), 1

    def _groupby_func_for_netoff_symbol(self, x):
        symbol = x.symbol.array[-1]
        one_order = x.copy()
        try:
            with self._tg_mg_lock:
                traded_price, trade_time_in_nano = self._settlement_prices[symbol]
            one_order['traded_price'] = traded_price
            one_order['trade_time'] = trade_time_in_nano / 1e9
        except KeyError:
            self.logger.warning(f'[_timer_t_func] can not find settlement price or trade time of (symbol){symbol}')
            one_order['traded_price'] = np.nan
            one_order['trade_time'] = np.nan

        one_order['by_human'] = False
        one_order['exchange'] = one_order.exchange.map(ExchangeID.read)
        one_order['side'] = one_order.order.apply(NextOMS._calc_side_for_netoff_orders)
        one_order[['offset_flag', 'offset_flag_sort_flag']] = one_order[['target', 'order']].apply(NextOMS._calc_offset_flag_for_netoff_orders, axis=1)
        one_order['order'] = one_order.order.abs()
        one_order['date'] = one_order.trading_day
        one_order = one_order.rename(columns={
            'order': 'traded_vol',
            'account': 'account_id',
        })
        one_order = one_order.sort_values(by=['account_id', 'exchange', 'symbol', 'traded_vol', 'offset_flag_sort_flag'])
        one_order = one_order.drop(columns=['target', 'method', 'params', 'offset_flag_sort_flag'])
        self.logger.info(f'[_timer_t_func] to append netoff orders to db for {symbol} (tickers_data):\r\n{one_order}')
        self._datas_api.append_trade_with_tag(one_order)

    def _timer_t_func(self):
        report_time = getattr(self._oms_config, 'report_time', DEFAULT_REPORT_TIME)
        report_time = pd.to_datetime(report_time, infer_datetime_format=True).time()
        self.logger.info(f'[_timer_t_func] started (report_time){report_time}')
        while not self.is_stopped():
            now_time = datetime.datetime.now()
            if (now_time.time() >= report_time) and (now_time.time() <= self._switch_day_time):
                with self._tg_mg_lock:
                    tg_list = self._tg_list
                self.logger.info(f'[_timer_t_func] to req reports (tg_list){tg_list}')
                if tg_list is not None:
                    for one_tg in tg_list:
                        for tag in [TradeDataTag.TRADES, TradeDataTag.POSITION, TradeDataTag.ACCOUNT]:
                            with self._tg_mg_lock:
                                if one_tg in self._tgs_processing[tag] or one_tg in self._tgs_done[tag]:
                                    continue
                            self.logger.info(f'[_timer_t_func] to req report on {one_tg} (tag){tag}')
                            with self._tg_mg_lock:
                                self._tgs_processing[tag].add(one_tg)
                            if tag == TradeDataTag.TRADES:
                                self.req_trades_today(one_tg)
                            elif tag == TradeDataTag.POSITION:
                                self.req_position(one_tg)
                            elif tag == TradeDataTag.ACCOUNT:
                                self.req_account(one_tg)

                with self._algo_lock:
                    netoff_orders = copy.deepcopy(self._netoff_orders)
                    self._netoff_orders.clear()

                self.logger.info(f'[_timer_t_func] to write back netoff orders (netoff orders){netoff_orders}')
                for (method, account), df in netoff_orders.items():
                    if df is None:
                        continue
                    self.logger.info(f'[_timer_t_func] process netoff orders for (method){method} (account){account}')
                    df.groupby(by='symbol', sort=False).apply(self._groupby_func_for_netoff_symbol)

            time.sleep(60)
        self.logger.info(f'[_timer_t_func] stopping...')

    def __init__(self, data_impl_pkg: str, fist_name: str = None):
        assert data_impl_pkg is not None, f"datas' class pkg must be a valid package name (data_impl_pkg){data_impl_pkg}"
        try:
            data_impl_mod = importlib.import_module(f'data_impls.{data_impl_pkg}')
        except ModuleNotFoundError as e:
            print(f"can not import the data's class file (file_path){data_impl_pkg} (e){e}")
            raise e

        # load config
        # TODO: may support to reload
        oms_configs = {}
        for one in ('OMS_CONFIG_PATH', 'OMS_DB_MODE'):
            try:
                oms_configs[one] = os.environ[one]
            except KeyError:
                oms_configs[one] = None
        self._configure = Configurator(oms_configs['OMS_CONFIG_PATH'])

        feishu_settings = self._configure.get_feishu_settings()
        self._fc = FeishuConnector(feishu_settings.webhook)
        self._fc.init(feishu_settings.app_id, feishu_settings.app_secret)

        self._oms_config = self._configure.get_oms_settings()
        env_name = getattr(self._oms_config, 'env_name', None)
        super().__init__(name=fist_name if fist_name is not None else DEFAULT_OURS_NAME, env_name=env_name if env_name is not None else DEFAULT_ENV_NAME, addr=self._configure._config['master_rep'], fist_type=FistType.ORDER_MANAGER)
        self._secret_symbol = getattr(self._oms_config, 'secret_symbol', DEFAULT_SECRET_SYMBOL)
        trade_config = getattr(self._oms_config, 'trade', None)
        if trade_config is not None:
            self._trade_order_time = trade_config['order_time']
            self._trade_deadline_time = trade_config['deadline_time']
        else:
            self._trade_order_time = None
            self._trade_deadline_time = None

        self._tg_list = None
        self.logger.info(f'[__init__] (oms_configs){oms_configs} (feishu_settings){feishu_settings} (data_impl_pkg){data_impl_pkg} (secret_symbol){self._secret_symbol}')
        self._datas_api: Type[NextOMSDataAPIBase] = getattr(data_impl_mod, 'OMSDataAPI')(self._configure, self.logger)

        self._netoff_orders: DefaultDict[Tuple[str, str], pd.DataFrame] = {}
        self._settlement_prices: Dict[str, float] = {}
        self._tg_mg_lock = threading.Lock()
        self._tg_mg_cv = threading.Condition(self._tg_mg_lock)
        self._tg_status = {}
        self._mg_status = {}
        self._algo_threads = {}
        self._tgs_processing = defaultdict(set)
        self._tgs_done = defaultdict(set)
        self._algo_lock = threading.Lock()
        self._algos_in_thread = {}
        self._timer_t = threading.Thread(target=self._timer_t_func, name=f'{self.fist_name}_timer')
        self._temp_thread_stop_flag = False

    def init(self, trade_router=None, market_router=None):
        now_time = datetime.datetime.now()
        switch_day_time = getattr(self._oms_config, 'switch_day_time', DEFAULT_SWITCH_DAY_TIME)
        self._switch_day_time = pd.to_datetime(switch_day_time, infer_datetime_format=True).time()
        self.logger.info(f'[__init__] (now){now_time} (switch_day_time){self._switch_day_time}')
        if now_time.time() > self._switch_day_time:
            # next trading day
            today_date = now_time.date()
            trading_day_list = self._datas_api.get_trading_day_list(start_date=today_date)
            if trading_day_list is None or trading_day_list.shape[0] < 2:
                raise Exception(f'failed to get trading day list from DB (trading_day_list){trading_day_list}')
            trading_day_list = trading_day_list[trading_day_list.trade_date > today_date]
            self._the_date = trading_day_list.trade_date.sort_values().array[0]
        else:
            self._the_date = now_time.date()

        trading_days = self._datas_api.get_trading_day_list(start_date=self._the_date-datetime.timedelta(days=100), end_date=self._the_date)
        if trading_days is None or trading_days.shape[0] <= 1:
            assert f'can not get trading list, (trading_days){trading_days} (trade_date){self._the_date}'

        self._last_trade_date = pd.to_datetime(trading_days.trade_date.iat[-2], infer_datetime_format=True).date()
        self.logger.info(f'[__init__] (the_date){self._the_date} (last_trade_date){self._last_trade_date}')

        tg_mg_ready_time = getattr(self._oms_config, 'tg_ready_time', DEFAULT_TG_MG_READY_TIME)
        self._tg_mg_ready_time = pd.to_datetime(tg_mg_ready_time, infer_datetime_format=True).time()

        night_tg_mg_ready_time = getattr(self._oms_config, 'night_tg_ready_time', DEFAULT_NIGHT_TG_MG_READY_TME)
        self._night_tg_mg_ready_time = pd.to_datetime(night_tg_mg_ready_time, infer_datetime_format=True).time()
        self.logger.info(f'[__init__] (tg_mg_ready_time){self._tg_mg_ready_time} (night_tg_mg_ready_time){self._night_tg_mg_ready_time}')

        self._datas_api.init()
        self.init_trade('trade1' if trade_router is None else trade_router)
        self.init_market('market1' if market_router is None else market_router)

    # overrided
    def on_gateway_connection_change(self, obj, frame_nano):
        self.logger.info(f'[on_gateway_connection_change] (obj){obj} (frame_nano){frame_nano}')
        with self._tg_mg_lock:
            if obj.fist_type == FistType.TRADE_GATEWAY:
                self._tg_status[obj.fist_name] = obj.connected
            elif obj.fist_type == FistType.MARKET_GATEWAY:
                self._mg_status[obj.fist_name] = obj.connected

    # overrided
    def on_gateway_heart_beat(self, obj, frame_nano):
        self.logger.info(f'[on_gateway_heart_beat] (obj){obj} (frame_nano){frame_nano}')
        with self._tg_mg_lock:
            if obj.fist_type == FistType.TRADE_GATEWAY:
                self._tg_status[obj.fist_name] = obj.hb_status == HeartBeatStatus.HEALTHY
            elif obj.fist_type == FistType.MARKET_GATEWAY:
                self._mg_status[obj.fist_name] = obj.hb_status == HeartBeatStatus.HEALTHY

    # overrided
    def on_rsp_account(self, obj, frame_nano):
        self.logger.info(f'[on_rsp_account] (obj){obj} (frame_nano){frame_nano}')

        with self._tg_mg_lock:
            self._tg_status[obj.account_id] = True
            self._tg_mg_cv.notify_all()

            if obj.account_id in self._tgs_processing[TradeDataTag.ACCOUNT]:
                the_data = {}
                for one in obj.ListFields():
                    if one[0].name not in ('req_id', ):
                        the_data[one[0].name] = one[1]
                the_data['date'] = self._the_date.isoformat()
                self.logger.info(f'[on_rsp_account] (the_data){the_data}')
                pd.Series(the_data).to_csv(f'{get_log_default_path()}/tmp_acc.csv')
                self._datas_api.append_trade_data(TradeDataTag.ACCOUNT, the_data)

                self._tgs_done[TradeDataTag.ACCOUNT].add(obj.account_id)
                self._tgs_processing[TradeDataTag.ACCOUNT].remove(obj.account_id)

    # overrided
    def on_rsp_position(self, obj, frame_nano):
        self.logger.info(f'[on_rsp_position] (obj){obj} (frame_nano){frame_nano}')

        with self._tg_mg_lock:
            if obj.account_id in (self._tgs_processing[TradeDataTag.POSITION] | self._tgs_processing[TradeDataTag.POSITION_BEFORE]):
                is_done = False
                today_pos = obj.SerializeToString()
                try:
                    df = read_protobuf(today_pos, GatewayPosition, flatten=False)
                except (FileNotFoundError, ValueError) as e:
                    if (obj.err_id == 0) and (len(obj.positions) == 0):
                        self.logger.info(f'[on_rsp_position] empty data')
                        is_done = True
                    else:
                        self.logger.warning(f'[on_rsp_position] read_protobuf failed (e_type){type(e)} (e){e}')
                else:
                    filtered = []
                    for _, row in df.iterrows():
                        try:
                            if row.at['err_id'] != 0:
                                self.logger.warning(f'[on_rsp_position] err_id != 0 (row){row} (df){df}')
                                break
                        except KeyError:
                            pass
                        pos = row.positions
                        try:
                            # if (pos['position'] != 0) or (pos['yd_pos'] != 0):
                            filtered.append(pos)
                        except KeyError:
                            pass
                    else:
                        is_done = True
                        if filtered:
                            data_df = pd.DataFrame(filtered).drop(columns='security_type', errors='ignore')
                            if isinstance(data_df, pd.Series):
                                data_df = data_df.to_frame().T
                            self.logger.info(f'[on_rsp_position] df after filtered\r\n{data_df}')
                            data_df['direction'] = data_df.direction.map(PosiDirection.read)
                            data_df['exchange'] = data_df.exchange.map(lambda x: message_pb.Exchange.Name(x).split('_', 1)[-1])
                            data_df['date'] = self._the_date.isoformat()
                            data_df['account_id'] = df.account_id.array[0]
                            if obj.account_id in self._tgs_processing[TradeDataTag.POSITION]:
                                raw_data_df = data_df.copy()
                                for one in ['pnl', 'realized_pnl', 'unrealized_pnl', 'frz_pos', 'position', 'yd_pos', 'avail_pos', 'pos_cost', 'margin']:
                                    if one in set(data_df.columns.array):
                                        data_df[one] = data_df[one].astype(str)
                                self.logger.info(f'[on_rsp_position] df final\r\n{data_df}')
                                data_df.to_csv(f'{get_log_default_path()}/tmp_pos.csv')
                                is_done = self._datas_api.append_trade_data(TradeDataTag.POSITION, data_df, raw_data_df) and is_done
                            if obj.account_id in self._tgs_processing[TradeDataTag.POSITION_BEFORE]:
                                self.logger.info(f'[on_rsp_position] df final\r\n{data_df}')
                                is_done = self._datas_api.append_trade_data(TradeDataTag.POSITION_BEFORE, data_df, data_df) and is_done
                        else:
                            self.logger.info(f'[on_rsp_position] empty data after filtered')

                if obj.account_id in self._tgs_processing[TradeDataTag.POSITION]:
                    self._tgs_processing[TradeDataTag.POSITION].remove(obj.account_id)
                    self._tgs_done[TradeDataTag.POSITION].add(obj.account_id)
                if obj.account_id in self._tgs_processing[TradeDataTag.POSITION_BEFORE]:
                    self._tgs_processing[TradeDataTag.POSITION_BEFORE].remove(obj.account_id)
                    self._tgs_done[TradeDataTag.POSITION_BEFORE].add(obj.account_id)

                if not is_done:
                    self._datas_api.notify_simple_msg(msg='failed to retrieve pos info', title=self._the_date)

    # overrided
    def on_rsp_trades_today(self, obj, frame_nano):
        '''
        处理请求查询当日成交的回报

        obj: GatewayTrades
        '''
        self.logger.info(f'[on_rsp_trades_today] (obj){obj} (frame_nano){frame_nano}')

        with self._tg_mg_lock:
            if obj.account_id in self._tgs_processing[TradeDataTag.TRADES]:

                is_done = False
                today_trades = obj.SerializeToString()
                try:
                    df = read_protobuf(today_trades, GatewayTrades, flatten=False)
                except (FileNotFoundError, ValueError) as e:
                    if (obj.err_id == 0) and (len(obj.trades) == 0):
                        self.logger.info(f'[on_rsp_trades_today] empty data')
                        is_done = True
                    else:
                        self.logger.warning(f'[on_rsp_trades_today] read_protobuf failed (e_type){type(e)} (e){e} (err_id){obj.err_id}')
                else:
                    filtered = []
                    for _, row in df.iterrows():
                        try:
                            if row.at['err_id'] != 0:
                                self.logger.warning(f'[on_rsp_trades_today] err_id != 0 (row){row} (df){df}')
                                break
                        except KeyError:
                            pass
                        filtered.append(row.trades)
                    else:
                        data_df = pd.DataFrame(filtered).drop(columns=['security_type'])
                        if isinstance(data_df, pd.Series):
                            data_df = data_df.to_frame().T
                        self.logger.info(f'[on_rsp_trades_today] df after filtered\r\n{data_df}')
                        data_df['side'] = data_df.side.map(lambda x: message_pb.Side.Name(x).split('_', 1)[-1])
                        data_df['exchange'] = data_df.exchange.map(lambda x: message_pb.Exchange.Name(x).split('_', 1)[-1])
                        data_df['offset_flag'] = data_df.offset_flag.map(lambda x: message_pb.OffsetFlag.Name(x).split('_', 2)[-1])
                        if 'order_type' in data_df.columns:
                            data_df['order_type'] = data_df.order_type.map(lambda x: message_pb.OrderType.Name(x).split('_', 2)[-1])
                        data_df['trade_time'] = data_df.trade_time.map(lambda x: x['seconds'])
                        data_df['date'] = self._the_date.isoformat()
                        data_df['account_id'] = df.account_id.array[0]
                        raw_data_df = data_df.copy()
                        for one in ['order_id']:
                            if one in set(data_df.columns.array):
                                data_df[one] = data_df[one].astype(str)
                        self.logger.info(f'[on_rsp_trades_today] df final\r\n{data_df}')
                        data_df.to_csv(f'{get_log_default_path()}/tmp_trades.csv')
                        # self.logger.info(f'[on_rsp_trades_today] (columns){data_df.columns.to_list()} (records){data_df.to_dict(orient="records")}')
                        is_done = self._datas_api.append_trade_data(TradeDataTag.TRADES, data_df, raw_data_df)

                self._tgs_done[TradeDataTag.TRADES].add(obj.account_id)
                self._tgs_processing[TradeDataTag.TRADES].remove(obj.account_id)
                if not is_done:
                    self._datas_api.notify_simple_msg(msg='failed to retrieve trades info', title=self._the_date)

    # overrided
    def on_mkt_snap(self, obj, msg_type, frame_nano):
        ticker = obj.ticker.decode()
        # if (not math.isclose(obj.settlement_price, 0)) and (not np.isfinite(obj.settlement_price)):
        if (not math.isclose(obj.settlement_price, 0)) and (not math.isclose(obj.settlement_price, sys.float_info.max)):
            with self._tg_mg_lock:
                self._settlement_prices[ticker] = (obj.settlement_price, frame_nano)
            self.logger.info(f'[on_mkt_snap] got settlement price of ticker {ticker} (settlement_price){obj.settlement_price} (frame_nano){frame_nano}')

    # overrided
    def on_close(self):
        self.logger.info('[on_close]')
        super().on_close()

        with self._tg_mg_lock:
            self._tg_mg_cv.notify_all()

    @staticmethod
    def _to_volume(x):
        if x.asset_type == AssetType.FUTURES:
            return np.fix(x.target_qty)
        elif x.asset_type == AssetType.STOCK:
            # 不在这里转换成手数的整倍数 交给交易程序
            return np.fix(x.target_qty)
        else:
            assert False, f'not support the asset type {x.asset_type} (x){x}'

    def _simple(self, ori_orders):
        orders = ori_orders.copy()
        orders['method'] = 'SMART_TWAP'
        orders['params'] = json.dumps({'start_time': DEFAULT_TRADE_ORDER_TIME if self._trade_order_time is None else self._trade_order_time, 'end_time': DEFAULT_TRADE_DEADLINE_TIME if self._trade_deadline_time is None else self._trade_deadline_time})
        orders['target'] = orders[['asset_type', 'target_qty']].apply(NextOMS._to_volume, axis=1)
        return orders

    def _simple_default(self) -> Tuple[str, str]:
        method = 'SMART_TWAP'
        params = json.dumps({'start_time': DEFAULT_TRADE_ORDER_TIME if self._trade_order_time is None else self._trade_order_time, 'end_time': DEFAULT_TRADE_DEADLINE_TIME if self._trade_deadline_time is None else self._trade_deadline_time})
        return method, params

    def _intraday(self, ori_orders):
        time_params = {'start_time': DEFAULT_TRADE_ORDER_TIME if self._trade_order_time is None else self._trade_order_time, 'end_time': DEFAULT_TRADE_DEADLINE_TIME if self._trade_deadline_time is None else self._trade_deadline_time}
        order_start = ori_orders.copy()
        order_start['target'] = np.fix(order_start.target_qty)
        order_start['method'] = 'SMART_TWAP'
        order_start['params'] = json.dumps(time_params)
        order_end = ori_orders.copy()
        order_end['target'] = 0
        order_end['method'] = 'SMART_TWAP'
        order_end['params'] = json.dumps(time_params)
        return pd.concat([order_start, order_end])

    def _generate_target(self, x, sigs) -> Optional[pd.DataFrame]:
        orders = []
        for row in x.itertuples(index=False):
            strategy = row.strategy
            amt = row.amount
            trade_method = row.method
            trade_order = sigs.loc[sigs['strategy'] == strategy, :].copy()
            if trade_order.empty:
                self.logger.info(f'[generate_target] {strategy} has no signal in {self._the_date}')
                assert False, f'every strategy should at least has one target everyday (strategy){strategy}'
            else:
                trade_order['target_mv'] = trade_order.signal.mul(amt)
                trade_order['target_qty'] = trade_order['target_mv'] / trade_order['face_value']
                trade_order = trade_order.loc[:, ['symbol', 'exchange', 'strategy', 'trading_day', 'target_qty', 'asset_type']].groupby(by=['exchange', 'symbol', 'strategy', 'trading_day', 'asset_type']).sum(numeric_only=False).reset_index()
                # 这里每个策略信号内部会综合
                orders.append(getattr(self, f'_{trade_method}')(trade_order))
                self.logger.info(f'[generate_target] order appended (orders):\r\n{orders}')
        if orders:
            return pd.concat(orders)

    @staticmethod
    def _apply_for_em_exchange_id(x):
        if pd.isnull(x.exchange):
            return

        if x.exchange == ExchangeID.SSE:
            return f'{x.symbol}.SH'
        elif x.exchange == ExchangeID.SZE:
            return f'{x.symbol}.SZ'
        elif x.exchange == ExchangeID.BSE:
            return f'{x.symbol}.BJ'
        else:
            assert False, f'not support the exchange ID {x.exchange} (x){x}'

    def generate_targets(self) -> Tuple[pd.DataFrame, pd.DataFrame]:
        # prepare signals
        sigs = self._datas_api.get_raw_signal(self._the_date)
        self.logger.info(f'[generate_targets] (raw signal):\r\n{sigs}')

        future_sigs = sigs.loc[sigs.asset_type == AssetType.FUTURES, :]
        future_info = self._datas_api.get_future_info(list(future_sigs.symbol.array))
        self.logger.info(f'[generate_targets] (future_info):\r\n{future_info}')
        future_sigs = future_sigs.join(future_info.set_index('trading_code')[['em_id', 'contract_mul']], on='symbol')
        self.logger.info(f'[generate_targets] (future_sigs joined future_info):\r\n{future_sigs}')
        future_price = self._datas_api.get_future_price(self._last_trade_date, future_sigs.em_id.dropna().to_list())
        self.logger.info(f'[generate_targets] (future_price):\r\n{future_price}')
        future_sigs = future_sigs.join(future_price.set_index('em_id')[['clear']], on='em_id')
        self.logger.info(f'[generate_targets] (future_sigs joined future_price):\r\n{future_sigs}')
        future_sigs['face_value'] = future_sigs.clear * future_sigs.contract_mul
        future_sigs = future_sigs.drop(columns=['em_id', 'contract_mul', 'clear'])
        self.logger.info(f'[generate_targets] (future_sigs):\r\n{future_sigs}')

        stock_sigs = sigs.loc[sigs.asset_type == AssetType.STOCK, :]
        if not stock_sigs.empty:
            stock_sigs['em_id'] = stock_sigs[['symbol', 'exchange']].apply(NextOMS._apply_for_em_exchange_id, axis=1)
            stock_price = self._datas_api.get_stock_price(self._last_trade_date, stock_sigs.em_id.dropna().to_list())
            self.logger.info(f'[generate_targets] (stock_price):\r\n{stock_price}')
            stock_sigs = stock_sigs.join(stock_price.set_index('stock_id')[['close']], on='em_id')
            stock_sigs = stock_sigs.rename(columns={'close': 'face_value'}).drop(columns=['em_id'])
        self.logger.info(f'[generate_targets] (stock_sigs):\r\n{stock_sigs}')

        df_allo = self._datas_api.get_df_allo()
        self.logger.info(f'[generate_targets] (df_allo){df_allo}')
        ods_df = df_allo.groupby(by='account', sort=False).apply(self._generate_target, sigs=pd.concat([future_sigs, stock_sigs]))
        self.logger.info(f'[generate_targets] (ods_df){ods_df}')
        if not ods_df.empty:
            ods_df = ods_df.droplevel(1).reset_index()
            self.logger.info(f'[generate_targets] (ods_df):\r\n{ods_df}')
            ods_df = ods_df.loc[(ods_df.target != 0) | (ods_df.symbol == self._secret_symbol), :].drop(columns='target_qty').rename(columns={
                'strategy': 'label',
            })
            ods_df['exchange'] = ods_df.exchange.astype(int)
        # if ods_df.empty:
        #     msg = 'orders generated should not be empty!!'
        #     self._datas_api.notify_simple_msg(msg, title=self._the_date)
        #     assert False, msg
        return ods_df, df_allo

    def _tg_mg_cv_func(self, tg_list) -> bool:
        if self.is_stopped():
            return True

        results = {}
        for one in tg_list:
            try:
                if self._tg_status[one]:
                    results[one] = True
            except KeyError:
                pass
        if (sorted(tg_list) == sorted(results.keys())) and all(results.values()):
            return True
        return False

    def _check_tgs(self, tg_list: List[str]):
        results = {}
        with self._tg_mg_lock:
            for one in tg_list:
                try:
                    if self._tg_status[one]:
                        results[one] = True
                except KeyError:
                    pass
        tg_list_set = set(tg_list)
        results_key_set = set(results.keys())
        if (tg_list_set == results_key_set) and all(results.values()):
            return
        to_check_again = tg_list_set - results_key_set
        self.logger.info(f'[check_tgs] tgs to check (part1) {to_check_again}')
        to_check_again |= set([k for k, v in results.items() if not v])
        self.logger.info(f'[check_tgs] tgs to check (all) {to_check_again}')
        return list(to_check_again)

    def check_tgs(self, tg_list: List[str]) -> Optional[List[str]]:
        self.logger.info(f'[tg_list] to check tgs {tg_list}')
        to_check_again = self._check_tgs(tg_list)
        if to_check_again is None:
            self.logger.info(f'[check_tgs] all tgs in {tg_list} are ready')
            return

        for one in to_check_again:
            self.logger.info(f'[check_tgs] req account on {one}')
            self.req_account(one)
        with self._tg_mg_cv:
            result = self._tg_mg_cv.wait_for(partial(self._tg_mg_cv_func, tg_list), timeout=SECONDS_TO_WAIT_FOR_CHECKING_TGS)
        if self.is_stopped():
            self.logger.warning('[check_tgs] signal received, exit now')
        if result:
            self.logger.info(f'[check_tgs] all tgs in {tg_list} are ready')
            return

        self.logger.error('[check_tgs] to check tgs last time')
        return self._check_tgs(tg_list)

    # deprecated, use _groupby_func_for_netoff instead
    @staticmethod
    def _groupby_func_for_netoff_bak_algo(x, netoff_orders, groupby_key):
        print(x)
        # 以 groupby 的 by 分组 判断组内有1个还是多个 target (即如果不同策略有相同的 target 需要在这里把这个信息给存下来)
        # 这里我们以 netoff_orders 作为 OUT 参数了
        if x.shape[0] > 1:
            # 存放未被 netoff 的 targets
            left_targets = []
            # 获得每个 target 的符号
            x['sign'] = np.sign(x.target)
            # 将所有 target 分成正负两组
            x_pos_sign = x.loc[x.sign >= 0, :]
            x_neg_sign = x.loc[x.sign < 0, :]
            # 分别计算两组的 target 总和
            pos_target_sum = x_pos_sign.target.sum()
            neg_target_sum = x_neg_sign.target.sum()
            # 分类讨论最终剩余 netoff 的不同情况
            if pos_target_sum >= abs(neg_target_sum):
                # 正的 target 不小于 负的 target，注意此时 netoff 是负数
                netoff = neg_target_sum
                if math.isclose(netoff, 0):
                    # 如果 netoff 是 0 直接返回原始数据即可
                    return x.drop(columns='sign')
                # 遍历每一个正 target
                for _, one in x_pos_sign.iterrows():
                    if abs(netoff) >= one.target:
                        # 如果这部分正 target 需要被 netoff
                        netoff += one.target
                        # 记录被 netoff 的 target
                        netoff_orders.append(one)
                    else:
                        # 如果这部分正 target 不会完全被 netoff
                        if not math.isclose(netoff, 0):
                            # 记录被 netoff 的 target
                            one_copy = one.copy()
                            one_copy['target'] = abs(netoff)
                            netoff_orders.append(one_copy)
                            # 更新 target 且 netoff 做完了
                            one['target'] = one.target + netoff
                            netoff = 0
                        # 将这一条 target 记录下来
                        left_targets.append(one)
                # 遍历每一个负 target
                netoff = neg_target_sum
                for _, one in x_neg_sign.iterrows():
                    if abs(netoff) >= abs(one.target):
                        # 记录被 netoff 的 target
                        netoff -= one.target
                        netoff_orders.append(one)
                    else:
                        # 每一个负 target 都应该被 netoff
                        assert False, '!!!'
            else:
                # 正的 target 小于 负的 target，注意此时 netoff 是正数
                netoff = pos_target_sum
                if math.isclose(netoff, 0):
                    return x.drop(columns='sign')
                # 遍历每一个负 target 剩余逻辑与对应的 if 分支类似
                for _, one in x_neg_sign.iterrows():
                    if netoff >= abs(one.target):
                        netoff += one.target
                        netoff_orders.append(one)
                    else:
                        if not math.isclose(netoff, 0):
                            one_copy = one.copy()
                            one_copy['target'] = -netoff
                            netoff_orders.append(one_copy)
                            one['target'] = one.target + netoff
                            netoff = 0
                        left_targets.append(one)
                netoff = pos_target_sum
                for _, one in x_pos_sign.iterrows():
                    if netoff >= one.target:
                        netoff -= one.target
                        netoff_orders.append(one)
                    else:
                        assert False, '!!!!!'
            if not left_targets:
                return
            return pd.DataFrame(left_targets).drop(columns='sign')
        else:
            # 如果组内只有 1 个 target 只需要直接返回这个 df 即可
            # 按道理来说返沪 series 更好 但这里是为了和对应的 if 分支返沪的数据结构保持一致
            return x

    @staticmethod
    def _groupby_func_for_netoff(x, netoff_orders_list):
        print(x)
        # 以 groupby 的 by 分组 判断组内有1个还是多个 target (即如果不同策略有相同的 target 需要在这里把这个信息给存下来)
        # 这里我们以 netoff_orders 作为 OUT 参数了
        if x.shape[0] > 1:
            # 存放未被 netoff 的 targets
            left_targets = []
            target_sum = x.order.sum()
            if target_sum > 0:
                # 最后是多头 由大到小排序
                x = x.sort_values(by='order', ascending=False)
            elif target_sum < 0:
                # 最后是空头 由小到大排序
                x = x.sort_values(by='order')
            else:
                # 最后是 0 需要把所有项都 netoff
                netoff_orders_list.append(x.loc[x.order != 0, :])
                return

            # 存放被 netoff 的 orders
            netoff_orders = []
            # 获得每个 target 的符号
            x['sign'] = np.sign(x.order)
            for _, one in x.iterrows():
                if one.sign != np.sign(target_sum):
                    # 如果和最终符号不一样 且不等于0 表明需要被 netoff
                    if not math.isclose(one.order, 0):
                        netoff_orders.append(one)
                else:
                    if abs(one.order) <= abs(target_sum):
                        # 符号一样 且 target_sum 没有用完 表明需要去下单 但需要把 target_sum 减下来
                        if not math.isclose(one.order, 0):
                            target_sum -= one.order
                            left_targets.append(one)
                    else:
                        if math.isclose(target_sum, 0):
                            # target_sum 没有了 剩余全部被 netoff
                            netoff_orders.append(one)
                        else:
                            # target_sum 只有一部分了 只对相应这部分下单 剩余部分被 netoff 同时把 target_sum 置成 0
                            one_to_target = one.copy()
                            one_to_target['order'] = target_sum
                            left_targets.append(one_to_target)
                            one['order'] -= target_sum
                            netoff_orders.append(one)
                            target_sum = 0
            if netoff_orders:
                netoff_orders_list.append(pd.DataFrame(netoff_orders).drop(columns='sign'))
            if not left_targets:
                return
            return pd.DataFrame(left_targets).drop(columns='sign')
        else:
            # 如果组内只有 1 个 order 只需要直接返回这个 df 即可
            # 按道理来说返回 series 更好 但这里是为了和对应的 if 分支返回的数据结构保持一致
            return x.loc[x.order != 0, :]

    def _set_target_orders(self, method: str, account: str, targets_df: pd.DataFrame):
        # get targets
        self.logger.info(f'[_set_target_orders] targets to set (method){method} (account){account} (targets_df):\r\n{targets_df}')

        pos_with_tag = self._datas_api.get_position_with_tag(self._last_trade_date)
        pos_with_tag = pos_with_tag.loc[pos_with_tag.account_id == account]
        self.logger.info(f'[_set_target_orders] (pos_with_tag){pos_with_tag} (account){account}')
        pos_with_tag['exchange'] = pos_with_tag.exchange.map(ExchangeID.parse)
        self.logger.info(f'[_set_target_orders] finally (pos_with_tag){pos_with_tag} (account){account}')

        # get holding
        contract_num = defaultdict(PosDetail)
        for row in pos_with_tag.itertuples(index=False):
            composite_key = (row.exchange, row.symbol, row.label)
            if PosiDirection.parse(row.direction) in (PosiDirection.LONG, PosiDirection.NET, PosiDirection.NOT_AVAILABLE):
                contract_num[composite_key].td_l += row.position - row.yd_pos
                contract_num[composite_key].yd_l += row.yd_pos
            else:
                contract_num[composite_key].td_s += row.position - row.yd_pos
                contract_num[composite_key].yd_s += row.yd_pos
        for (exchange, symbol, label), pos_detail in contract_num.items():
            self.logger.info(f'[_set_target_orders] after calc pos with tag (exchange){exchange} (symbol){symbol} (label){label} (td_l){pos_detail.td_l} (td_s){pos_detail.td_s} (yd_l){pos_detail.yd_l} (yd_s){pos_detail.yd_s}')

        if contract_num:
            contract_num_df = pd.DataFrame([one.to_dict() for one in contract_num.values()], index=contract_num.keys()).rename_axis(index=['exchange', 'symbol', 'label'])
            self.logger.info(f'[_set_target_orders] contract_num_df:\r\n{contract_num_df}')
            contract_num_sum = contract_num_df.td_l + contract_num_df.yd_l - contract_num_df.td_s - contract_num_df.yd_s

            # compute execution target
            the_targets = targets_df.set_index(['exchange', 'symbol', 'label'])
            self.logger.info(f'[_set_target_orders] the_targets:\r\n{the_targets}')
            left_pos_to_close = contract_num_sum.index.difference(the_targets.index)
            self.logger.info(f'[_set_target_orders] (left_pos_to_close){left_pos_to_close}')
            the_targets = pd.concat([the_targets, contract_num_sum.rename('contract_sum')], axis=1)
            the_targets['target'] = the_targets.target.fillna(0)
            self.logger.info(f'[_set_target_orders] the_targets:\r\n{the_targets}')
            the_targets['order'] = the_targets.target.sub(the_targets.contract_sum, fill_value=0)
            self.logger.info(f'[_set_target_orders] the_targets:\r\n{the_targets}')
            the_targets = the_targets.ffill().bfill().drop(columns='contract_sum').reset_index()
        else:
            the_targets = targets_df
            the_targets['order'] = the_targets.target

        self.logger.info(f'[_set_target_orders] the_targets:\r\n{the_targets}')
        netoff_orders_list = []
        groupby_key = ['exchange', 'symbol', 'params']
        the_orders = the_targets.groupby(by=groupby_key, sort=False, group_keys=False).apply(NextOMS._groupby_func_for_netoff, netoff_orders_list=netoff_orders_list)  # .droplevel(len(groupby_key)).reset_index()
        the_orders['is_internal'] = False
        self.logger.info(f'[_set_target_orders] (the orders):\r\n{the_orders}')

        with self._algo_lock:
            the_key = (method, account)
            if netoff_orders_list:
                netoff_orders = pd.concat(netoff_orders_list)
                netoff_orders['is_internal'] = True
                self._netoff_orders[the_key] = netoff_orders
            else:
                self._netoff_orders[the_key] = None
            self.logger.info(f'[_set_target_orders] (netoff orders):\r\n{self._netoff_orders[the_key]}')
            whole_data = pd.concat([the_orders, self._netoff_orders[the_key]])
        self._datas_api.send_df_image(whole_data[(whole_data.is_internal == True) | (whole_data.order != 0)], f'{self._the_date}')
        self._datas_api.update_final_orders(whole_data)

        the_orders['start_time'] = the_orders.params.apply(lambda x: pd.to_datetime(json.loads(x)['start_time'], infer_datetime_format=True))
        the_orders['end_time'] = the_orders.params.apply(lambda x: pd.to_datetime(json.loads(x)['end_time'], infer_datetime_format=True))
        # 过滤掉无效 exchange 的 targets
        tickers_to_filtered = the_orders[the_orders.exchange == ExchangeID.NOT_AVAILABLE]
        if not tickers_to_filtered.empty:
            self._datas_api.notify_simple_msg(msg=f'{tickers_to_filtered.ticker.to_list()} will be filtered out', title='Unknown TICKERS')
        the_orders = the_orders.loc[the_orders.exchange != ExchangeID.NOT_AVAILABLE, :]
        self.logger.info(f'[_set_target_orders] (final the orders):\r\n{the_orders}')
        self._datas_api.send_df_image(the_orders, f'{self._the_date}')

        d = []
        for t_pos in the_orders.itertuples(index=False):
            ticker = t_pos.symbol
            t_num = t_pos.order
            exchange = t_pos.exchange
            start_time = t_pos.start_time
            end_time = t_pos.end_time
            label = t_pos.label
            if t_num > 0:
                # close short first
                short_total = contract_num[(exchange, ticker, label)].short_total()
                if short_total >= t_num:
                    d.append({'ticker': ticker, 'volume': t_num, 'target_type': 'close_short', 'exchange': exchange, 'start_time': start_time, 'end_time': end_time, 'label': label})
                else:
                    if short_total > 0:
                        d.append({'ticker': ticker, 'volume': short_total, 'target_type': 'close_short', 'exchange': exchange, 'start_time': start_time, 'end_time': end_time, 'label': label})
                        t_num -= short_total
                    d.append({'ticker': ticker, 'volume': t_num, 'target_type': 'open_long', 'exchange': exchange, 'start_time': start_time, 'end_time': end_time, 'label': label})
            elif t_num < 0:
                to_sell = -t_num
                long_total = contract_num[(exchange, ticker, label)].long_total()
                if long_total >= to_sell:
                    d.append({'ticker': ticker, 'volume': to_sell, 'target_type': 'close_long', 'exchange': exchange, 'start_time': start_time, 'end_time': end_time, 'label': label})
                else:
                    if long_total > 0:
                        d.append({'ticker': ticker, 'volume': long_total, 'target_type': 'close_long', 'exchange': exchange, 'start_time': start_time, 'end_time': end_time, 'label': label})
                        to_sell -= long_total
                    d.append({'ticker': ticker, 'volume': to_sell, 'target_type': 'open_short', 'exchange': exchange, 'start_time': start_time, 'end_time': end_time, 'label': label})
            else:
                pass
        return pos_with_tag, d

    def _algo_thread_func(self, method, account, algo_method, targets_df):
        if targets_df is None:
            # TODO:
            return

        pos_with_tag, d = self._set_target_orders(method, account, targets_df)
        try:
            the_algo = getattr(algo_method, 'TradeExecutor')(method, account, targets_df.asset_type.array[0], self._configure, NextOMSAlgoSPI(self))
            with self._algo_lock:
                self._algos_in_thread[(method, account)] = the_algo
            the_algo.init(pos_with_tag, d)
            the_algo.start()
            the_algo.join()
        except Exception as e:
            msg = f'(e){e} (e_type){type(e)} tb:\n{traceback.format_exc()}'
            self._datas_api.notify_simple_msg(msg=msg, title=self._the_date)
            self.logger.info(msg)

    def _groupby_func2(self, method, algo_method, x):
        account = x.account.array[0]
        self.logger.info(f'[_groupby_func2] (method){method} (algo_method){algo_method} (account){account} (x):\r\n{x}')
        t = threading.Thread(target=self._algo_thread_func, name=method, daemon=False, kwargs={
            'method': method,
            'account': account,
            'algo_method': algo_method,
            'targets_df': pd.DataFrame(data=x.to_numpy(), index=x.index.copy(deep=True), columns=x.columns),
        })
        self._algo_threads[(method, account)] = t
        self.logger.info(f'[_groupby_func2] to start a trade executor (method){method} (targets):\r\n{x}')
        t.start()

    def _groupby_func(self, x):
        method = x.method.array[0]
        try:
            algo_method = importlib.import_module(f'algos.{method}')
        except ModuleNotFoundError as e:
            msg = f'can not import the method module (method){method} (e){e}'
            self.logger.warning(msg)
            self._datas_api.notify_simple_msg(msg=msg, title=self._the_date)
        else:
            x.groupby(by='account', sort=False).apply(partial(self._groupby_func2, method, algo_method))

    def _groupby_func_for_empty_targets(self, x):
        # TODO:
        method, params = getattr(self, f'_{x.method.array[0]}_default')()
        try:
            algo_method = importlib.import_module(f'algos.{method}')
        except ModuleNotFoundError as e:
            msg = f'can not import the method module (method){method} (e){e}'
            self.logger.warning(msg)
            self._datas_api.notify_simple_msg(msg=msg, title=self._the_date)
        else:
            account = x.account.array[0]
            self.logger.info(f'[start] (method){method} (algo_method){algo_method} (account){account}')
            t = threading.Thread(target=self._algo_thread_func, name=method, daemon=False, kwargs={
                'method': method,
                'account': account,
                'algo_method': algo_method,
                'targets_df': None,
            })
            self._algo_threads[(method, account)] = t
            self.logger.info(f'[start] to start a trade executor (method){method}')
            t.start()

    def _push_targets_to_feishu(self, df):
        orders = df.loc[df.symbol != self._secret_symbol, ['account', 'symbol', 'target', 'label', 'method']]
        scout_uri = getattr(self._oms_config, 'scout_uri', '')
        self._fc.send_webhook_msg(
            target='trade', title=f'final account targets {self._the_date}', content=orders.to_markdown(index=False), success=True,
            buttons=[
                ('详情', scout_uri),
            ]
        )
        self.logger.info(f'[_push_targets_to_feishu] to feishu done (orders){orders}')

    def _temp_thread_for_wait(self, time_point_to_reach: datetime.time, cond_for_wait: threading.Condition):
        while not self._temp_thread_stop_flag:
            now_time = datetime.datetime.now().time()
            if now_time >= time_point_to_reach:
                self.logger.info(f'[_temp_thread_for_wait] reach the {time_point_to_reach}, to notify the main thread')
                with cond_for_wait:
                    cond_for_wait.notify_all()
            if self.is_stopped():
                with cond_for_wait:
                    cond_for_wait.notify_all()
                break
            time.sleep(2)
        self._temp_thread_stop_flag = False

    def start(self):
        super().start()

        targets_df, df_allo = self.generate_targets()
        self._push_targets_to_feishu(targets_df)

        # check the signal if it's confirmed
        while not self.is_stopped():
            signal_df = self._datas_api.get_trade_signal(self._the_date)
            self.logger.info(f'(signal_df final)\r\n{signal_df}')
            is_confirmed = False
            if not signal_df.empty:
                the_key_item = signal_df.loc[signal_df.update_time.idxmax(), :]
                if the_key_item.confirm.upper() == 'Yes'.upper():
                    is_confirmed = True
                else:
                    msg = f'[start] not confirmed, wait some seconds to recheck'
                    self._datas_api.notify_simple_msg(msg=msg, title=self._the_date)
                    self.logger.info(f'{msg} (today){self._the_date}')
            else:
                msg = f'[start] no signal item today, wait some seconds to recheck'
                self._datas_api.notify_simple_msg(msg=msg, title=self._the_date)
                self.logger.info(f'{msg} (today){self._the_date}')
            if is_confirmed:
                self.logger.info(f'[start] confirmed, next step (today){self._the_date}')
                break
            time.sleep(60)
        else:
            self.logger.info(f'[start] stopped, exit now... (today){self._the_date}')
            return

        if targets_df.empty:
            msg = f'[start] empty target, use the accounts in allocation to check (today){self._the_date}'
            self.logger.info(msg)
            self._datas_api.notify_simple_msg(msg=msg, title=self._the_date)
            tg_list = list(set(df_allo.account.array))
        else:
            self.logger.info(f'[start] (targets df):\r\n{targets_df}')
            tg_list = list(set(targets_df.account.array))

        with self._tg_mg_lock:
            self._tg_list = tg_list

        now_time = datetime.datetime.now().time()
        if now_time >= self._switch_day_time:
            time_point_to_reach = self._night_tg_mg_ready_time
        else:
            time_point_to_reach = self._tg_mg_ready_time
        self.logger.info(f'[start] (now_time){now_time} (waiting...)-> (time_point_to_reach){time_point_to_reach}')
        cond_for_wait = threading.Condition()
        temp_t = threading.Thread(target=self._temp_thread_for_wait, name='temp_t_in_oms', daemon=False, kwargs={
            'time_point_to_reach': time_point_to_reach,
            'cond_for_wait': cond_for_wait,
        })
        temp_t.start()
        with cond_for_wait:
            cond_for_wait.wait_for(lambda: (datetime.datetime.now().time() >= time_point_to_reach) or self.is_stopped())
        self._temp_thread_stop_flag = True
        temp_t.join()

        result = self.check_tgs(tg_list)
        if result is not None and result:
            msg = f'tg(s) {result} is(are) not ready'
            self._datas_api.notify_simple_msg(msg=msg, title=self._the_date)
            time.sleep(2)
            raise Exception(msg)
        trade_start_time = getattr(self._oms_config, 'trade_start_time', DEFAULT_TRADE_START_TIME)
        trade_start_time = pd.to_datetime(trade_start_time, infer_datetime_format=True).time()
        if datetime.datetime.now().time() < trade_start_time:
            with self._tg_mg_lock:
                self.logger.info(f'[start] to req pos before trade (tg_list){self._tg_list}')
                for one_tg in self._tg_list:
                    self._tgs_processing[TradeDataTag.POSITION_BEFORE].add(one_tg)
                    self._tg_mg_lock.release()
                    self.req_position(one_tg)
                    self._tg_mg_lock.acquire()

        if self.is_stopped():
            return

        self.logger.info(f'[start] to start trade executors')
        if not targets_df.empty:
            targets_df.groupby(by='method', sort=False).apply(self._groupby_func)
        else:
            self.logger.info(f'[start] empty target, use the method and account in allocation to trade')
            df_allo.groupby(by=['account', 'method'], sort=False).apply(self._groupby_func_for_empty_targets)

        # 在最后再启动它
        self._timer_t.start()

    def join(self):
        super().join()

        for (method, account), t in self._algo_threads.items():
            if t.is_alive():
                try:
                    with self._algo_lock:
                        obj = self._algos_in_thread[(method, account)]
                    obj.stop()
                except KeyError:
                    pass
                t.join()
            self.logger.info(f'[join] (method){method} (account){account} done')
        if self._timer_t.is_alive():
            self._timer_t.join()

    def test_req(self, tag, tg_name):
        super().start()
        with self._tg_mg_lock:
            self._tgs_processing[tag].add(tg_name)
        if tag == TradeDataTag.TRADES:
            self.req_trades_today(tg_name)
        elif tag == TradeDataTag.POSITION:
            self.req_position(tg_name)
        elif tag == TradeDataTag.ACCOUNT:
            self.req_account(tg_name)
        self._timer_t.start()

    def refresh_reqs(self, tg_list: List[str]):
        super().start()
        self._tg_list = tg_list
        self._timer_t.start()


if __name__ == '__main__':
    n_oms = NextOMS('oms')
    n_oms.init()
    n_oms.start()
    n_oms.join()
    # n_oms.test_req(TradeDataTag.ACCOUNT, 'chaoyangmen')
    # print(n_oms.generate_targets())
