# auto generated by update_py.py

import pandas as pd
import pymongo

from tlclient.trader.utils import Singleton
from tlclient.trader.config import Configurator


class MongoConnector(metaclass=Singleton):

    def __init__(self, config: Configurator) -> None:
        self._settings = config.get_mongo_settings()
        self._client = None

    def get_client(self, db_name=None):
        if self._client is None:
            conn_str = f'mongodb://{self._settings.username}:{self._settings.password}@{self._settings.host}/'
            self._client = pymongo.MongoClient(conn_str, serverSelectionTimeoutMS=5000)
            try:
                print(self._client.server_info(), db_name)
            except Exception:
                print("Unable to connect to the server.")
        if db_name is None:
            db_name = self._settings.db
        return self._client[db_name]

    def put(self, collection, key, obj, db_name=None) -> pymongo.results.UpdateResult:
        data = {'_id': key, '_content': obj}
        return self.get_client(db_name=db_name)[collection].replace_one({"_id": key}, data, True)

    def put_by_filter(self, collection, filter, obj, db_name=None) -> pymongo.results.UpdateResult:
        new_filter = {f'_content.{k}': v for k, v in filter.items()}
        data = {'_content': obj}
        return self.get_client(db_name=db_name)[collection].replace_one(new_filter, data, True)

    def insert_many(self, collection, obj, db_name=None):
        data = [{'_content': one} for one in obj]
        return self.get_client(db_name=db_name)[collection].insert_many(data)

    def get(self, collection, key, db_name=None):
        _data = self.get_client(db_name=db_name)[collection].find_one({"_id": key})
        if isinstance(_data, dict):
            return _data['_content']
        return

    def get_by_filter(self, collection, filter, db_name=None):
        new_filter = {f'_content.{k}': v for k, v in filter.items()}
        _data = self.get_client(db_name=db_name)[collection].find(new_filter)
        if _data is None:
            return
        return [one['_content'] for one in _data]

    def get_collections(self, db_name=None):
        # get collection list
        return self.get_client(db_name=db_name).list_collection_names()

    def get_items(self, collection, db_name=None):
        # get all items from collection
        cursor = self.get_client(db_name=db_name)[collection].find({})
        return {item['_id']: item['_content'] for item in cursor}

    def put_signal(self, sig_name: str, signal: pd.DataFrame, tag: str):
        _sig = signal.copy()
        _sig['trade_date'] = pd.to_datetime(_sig.trade_date, infer_datetime_format=True)
        self.put(tag, sig_name, _sig.to_dict('records'))

    def get_signal(self, sig_name: str, tag: str) -> pd.DataFrame:
        _sig = pd.DataFrame.from_dict(self.get(tag, sig_name))
        _sig['trade_date'] = _sig.trade_date.dt.date
        return _sig


'''
    def put_signal(self, sig_name: str, signal: pd.DataFrame):
        _tmp = signal.groupby(by='trade_date', sort=False, group_keys=False).apply(lambda x: x.drop(columns='trade_date').to_dict(orient='records'))
        for idx, row in _tmp.iteritems():
            self.put(sig_name, pd.to_datetime(idx, infer_datetime_format=True), row)

    def get_signal(self, sig_name: str) -> pd.DataFrame:
        df_list: List[pd.DataFrame] = []
        signal = MongoConnector().get_items(sig_name)
        for idx, v in signal.items():
            df = pd.DataFrame(v)
            df['trade_date'] = idx.date()
            df_list.append(df)
        return pd.concat(df_list)

    def append_one(self, db, collection, key, obj):
        data = {'_id': key}
        data.update(obj)
        return self._client[db][collection].insert_one(data)

    def get2(self, db, collection, key):
        return self._client[db][collection].find_one({"_id": key})

    def insert(self, db, collection, key, obj, upsert=True):
        self._client[db][collection].replace_one({"_id": key}, obj, upsert)

    # def _append_list(self, dbName, collectionName, d):
    #     db = self.dbClient[dbName]
    #     collection = db[collectionName]
    #     ids = collection.insert_many(d)
    #     return ids

    def query(self, db, collectionName, flt=None, since=None, limit=None, sort_key=None):
        collection = self._client[db][collectionName]
        if flt is None:
            if since is not None:
                flt = {'dbTime': {'$gte': since}}
            else:
                flt = {}
        else:
            if since is not None and 'dbTime' not in flt:
                flt['dbTime'] = {'$gte': since}
        if limit is not None:
            if sort_key is None:
                cursor = list(collection.find(flt).limit(limit))
            else:
                cursor = list(collection.find(flt).limit(limit).sort(sort_key, pymongo.DESCENDING))
        else:
            if sort_key is None:
                cursor = list(collection.find(flt))
        if len(cursor) > 0:
            return pd.DataFrame(cursor).drop('_id', axis=1).sort_index()
'''

if __name__ == '__main__':
    config_path = None
    print(Configurator(config_path).get_mongo_settings())
    connector = MongoConnector()
    connector.put('test', 'IF', {'contract': 'IF2209', 'lol': 'IF'})
    connector.put('test', 'IF2', {'1': 'IF2209', 'lol': 'IF'})
    a = connector.get('test', 'IF')
    print(a)
    print(connector.get('test', None))
    print(connector.get_items('test'))
    print(connector.get_collections())
