# auto generated by update_py.py
from contextlib import contextmanager

from sqlalchemy import create_engine
from sqlalchemy.orm import scoped_session, sessionmaker

from ..config import Configurator


class DatabaseConnector:

    def _log(self, msg: str, method='info'):
        if self.logger is None:
            print(msg)
        else:
            getattr(self.logger, method)(msg)

    def __init__(self, config: Configurator, db_mode=None, db=None, logger=None):
        self.logger = logger
        self._db_config = config.get_db_settings(db_mode)
        if db is not None:
            self._db_config.db = db
        self._db_conn_str = self._db_config.to_conn_str()
        self._log(f'connecting to {self._db_config}')

        self._engine = None
        self._session_maker = None
        self._scoped_session_maker = None

        self._connect()

    def _connect(self):
        self._engine = create_engine(self._db_conn_str, pool_pre_ping=True)
        self._session_maker = sessionmaker(bind=self._engine)
        self._scoped_session_maker = scoped_session(self._session_maker)

    @contextmanager
    def get_session(self, scoped=True, managed=True):
        if self._engine is None:
            self._connect()
        session = self._scoped_session_maker() if scoped else self._session_maker()
        yield session
        if managed:
            session.close()

    def get_engine(self):
        if self._engine is None:
            self._connect()
        return self._engine

    def __str__(self):
        return str(self._db_config)
