"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .workflowrunoutputmodel import (
    WorkflowRunOutputModel,
    WorkflowRunOutputModelTypedDict,
)
from comfydeploy.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from pydantic import model_serializer
from typing import Any, List, Optional
from typing_extensions import NotRequired, TypedDict


class WorkflowRunModelTypedDict(TypedDict):
    id: str
    workflow_version_id: Nullable[str]
    workflow_inputs: Nullable[Any]
    workflow_id: str
    workflow_api: Nullable[Any]
    machine_id: Nullable[str]
    origin: str
    status: str
    created_at: datetime
    updated_at: datetime
    gpu_event_id: Nullable[str]
    gpu: Nullable[str]
    machine_version: Nullable[str]
    machine_type: Nullable[str]
    modal_function_call_id: Nullable[str]
    user_id: Nullable[str]
    org_id: Nullable[str]
    live_status: Nullable[str]
    webhook: Nullable[str]
    webhook_status: Nullable[str]
    number: int
    duration: Nullable[float]
    cold_start_duration: Nullable[float]
    cold_start_duration_total: Nullable[float]
    run_duration: Nullable[float]
    ended_at: NotRequired[Nullable[datetime]]
    queued_at: NotRequired[Nullable[datetime]]
    started_at: NotRequired[Nullable[datetime]]
    progress: NotRequired[float]
    is_realtime: NotRequired[bool]
    webhook_intermediate_status: NotRequired[bool]
    outputs: NotRequired[List[WorkflowRunOutputModelTypedDict]]


class WorkflowRunModel(BaseModel):
    id: str

    workflow_version_id: Nullable[str]

    workflow_inputs: Nullable[Any]

    workflow_id: str

    workflow_api: Nullable[Any]

    machine_id: Nullable[str]

    origin: str

    status: str

    created_at: datetime

    updated_at: datetime

    gpu_event_id: Nullable[str]

    gpu: Nullable[str]

    machine_version: Nullable[str]

    machine_type: Nullable[str]

    modal_function_call_id: Nullable[str]

    user_id: Nullable[str]

    org_id: Nullable[str]

    live_status: Nullable[str]

    webhook: Nullable[str]

    webhook_status: Nullable[str]

    number: int

    duration: Nullable[float]

    cold_start_duration: Nullable[float]

    cold_start_duration_total: Nullable[float]

    run_duration: Nullable[float]

    ended_at: OptionalNullable[datetime] = UNSET

    queued_at: OptionalNullable[datetime] = UNSET

    started_at: OptionalNullable[datetime] = UNSET

    progress: Optional[float] = 0

    is_realtime: Optional[bool] = False

    webhook_intermediate_status: Optional[bool] = False

    outputs: Optional[List[WorkflowRunOutputModel]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "ended_at",
            "queued_at",
            "started_at",
            "progress",
            "is_realtime",
            "webhook_intermediate_status",
            "outputs",
        ]
        nullable_fields = [
            "workflow_version_id",
            "workflow_inputs",
            "workflow_api",
            "machine_id",
            "gpu_event_id",
            "gpu",
            "machine_version",
            "machine_type",
            "modal_function_call_id",
            "user_id",
            "org_id",
            "live_status",
            "webhook",
            "webhook_status",
            "duration",
            "cold_start_duration",
            "cold_start_duration_total",
            "run_duration",
            "ended_at",
            "queued_at",
            "started_at",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
