"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from comfydeploy.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import Any, List, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


class Two(str, Enum):
    COMFY_UI_DEPLOY_EXTERNAL_TEXT = "ComfyUIDeployExternalText"
    COMFY_UI_DEPLOY_EXTERNAL_TEXT_ANY = "ComfyUIDeployExternalTextAny"
    COMFY_UI_DEPLOY_EXTERNAL_TEXT_SINGLE_LINE = "ComfyUIDeployExternalTextSingleLine"
    COMFY_UI_DEPLOY_EXTERNAL_IMAGE = "ComfyUIDeployExternalImage"
    COMFY_UI_DEPLOY_EXTERNAL_IMAGE_ALPHA = "ComfyUIDeployExternalImageAlpha"
    COMFY_UI_DEPLOY_EXTERNAL_NUMBER = "ComfyUIDeployExternalNumber"
    COMFY_UI_DEPLOY_EXTERNAL_NUMBER_INT = "ComfyUIDeployExternalNumberInt"
    COMFY_UI_DEPLOY_EXTERNAL_LORA = "ComfyUIDeployExternalLora"
    COMFY_UI_DEPLOY_EXTERNAL_CHECKPOINT = "ComfyUIDeployExternalCheckpoint"
    COMFY_DEPLOY_WEBSCOKET_IMAGE_INPUT = "ComfyDeployWebscoketImageInput"
    COMFY_UI_DEPLOY_EXTERNAL_IMAGE_BATCH = "ComfyUIDeployExternalImageBatch"
    COMFY_UI_DEPLOY_EXTERNAL_VIDEO = "ComfyUIDeployExternalVideo"
    COMFY_UI_DEPLOY_EXTERNAL_BOOLEAN = "ComfyUIDeployExternalBoolean"
    COMFY_UI_DEPLOY_EXTERNAL_NUMBER_SLIDER = "ComfyUIDeployExternalNumberSlider"
    COMFY_UI_DEPLOY_EXTERNAL_NUMBER_SLIDER_INT = "ComfyUIDeployExternalNumberSliderInt"
    COMFY_UI_DEPLOY_EXTERNAL_ENUM = "ComfyUIDeployExternalEnum"


ClassTypeTypedDict = TypeAliasType("ClassTypeTypedDict", Union[str, Two])


ClassType = TypeAliasType("ClassType", Union[str, Two])


class ModelInputTypedDict(TypedDict):
    input_id: str
    class_type: ClassTypeTypedDict
    required: bool
    default_value: NotRequired[Nullable[Any]]
    min_value: NotRequired[Nullable[Any]]
    max_value: NotRequired[Nullable[Any]]
    display_name: NotRequired[Nullable[str]]
    description: NotRequired[Nullable[str]]
    enum_values: NotRequired[Nullable[List[str]]]


class ModelInput(BaseModel):
    input_id: str

    class_type: ClassType

    required: bool

    default_value: OptionalNullable[Any] = UNSET

    min_value: OptionalNullable[Any] = UNSET

    max_value: OptionalNullable[Any] = UNSET

    display_name: OptionalNullable[str] = UNSET

    description: OptionalNullable[str] = UNSET

    enum_values: OptionalNullable[List[str]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "default_value",
            "min_value",
            "max_value",
            "display_name",
            "description",
            "enum_values",
        ]
        nullable_fields = [
            "default_value",
            "min_value",
            "max_value",
            "display_name",
            "description",
            "enum_values",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
