"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from comfydeploy.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing import Any, List, Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


DefaultValueTypedDict = TypeAliasType(
    "DefaultValueTypedDict", Union[str, int, float, bool, List[Any]]
)


DefaultValue = TypeAliasType("DefaultValue", Union[str, int, float, bool, List[Any]])


MinValueTypedDict = TypeAliasType("MinValueTypedDict", Union[int, float])


MinValue = TypeAliasType("MinValue", Union[int, float])


MaxValueTypedDict = TypeAliasType("MaxValueTypedDict", Union[int, float])


MaxValue = TypeAliasType("MaxValue", Union[int, float])


StepTypedDict = TypeAliasType("StepTypedDict", Union[int, float])
r"""Step for number slider input types"""


Step = TypeAliasType("Step", Union[int, float])
r"""Step for number slider input types"""


class InputModelTypedDict(TypedDict):
    type: str
    class_type: str
    input_id: str
    default_value: NotRequired[Nullable[DefaultValueTypedDict]]
    min_value: NotRequired[Nullable[MinValueTypedDict]]
    max_value: NotRequired[Nullable[MaxValueTypedDict]]
    display_name: NotRequired[str]
    description: NotRequired[str]
    enum_options: NotRequired[Nullable[List[str]]]
    r"""Options for enum input type"""
    step: NotRequired[Nullable[StepTypedDict]]
    r"""Step for number slider input types"""


class InputModel(BaseModel):
    type: str

    class_type: str

    input_id: str

    default_value: OptionalNullable[DefaultValue] = UNSET

    min_value: OptionalNullable[MinValue] = UNSET

    max_value: OptionalNullable[MaxValue] = UNSET

    display_name: Optional[str] = ""

    description: Optional[str] = ""

    enum_options: OptionalNullable[List[str]] = UNSET
    r"""Options for enum input type"""

    step: OptionalNullable[Step] = UNSET
    r"""Step for number slider input types"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "default_value",
            "min_value",
            "max_value",
            "display_name",
            "description",
            "enum_options",
            "step",
        ]
        nullable_fields = [
            "default_value",
            "min_value",
            "max_value",
            "enum_options",
            "step",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
