"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from comfydeploy.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from datetime import datetime
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class AssetResponseTypedDict(TypedDict):
    id: str
    name: str
    is_folder: bool
    path: str
    created_at: datetime
    updated_at: datetime
    user_id: NotRequired[Nullable[str]]
    org_id: NotRequired[Nullable[str]]
    file_size: NotRequired[Nullable[int]]
    url: NotRequired[Nullable[str]]
    mime_type: NotRequired[Nullable[str]]
    deleted: NotRequired[Nullable[bool]]


class AssetResponse(BaseModel):
    id: str

    name: str

    is_folder: bool

    path: str

    created_at: datetime

    updated_at: datetime

    user_id: OptionalNullable[str] = UNSET

    org_id: OptionalNullable[str] = UNSET

    file_size: OptionalNullable[int] = UNSET

    url: OptionalNullable[str] = UNSET

    mime_type: OptionalNullable[str] = UNSET

    deleted: OptionalNullable[bool] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "user_id",
            "org_id",
            "file_size",
            "url",
            "mime_type",
            "deleted",
        ]
        nullable_fields = [
            "user_id",
            "org_id",
            "file_size",
            "url",
            "mime_type",
            "deleted",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
