# Generated by Django 3.1.2 on 2020-10-28 19:32

import ckeditor.fields
from django.db import migrations, models
import django.db.models.deletion
import formulaic.validators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Field',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=500)),
                ('display_name', models.CharField(max_length=1000)),
                ('data_name', models.CharField(max_length=200)),
                ('slug', models.SlugField(max_length=200)),
                ('required', models.BooleanField()),
                ('help_text', models.CharField(blank=True, max_length=500, null=True)),
                ('subtype', models.CharField(max_length=100)),
                ('model_class', models.CharField(max_length=100)),
                ('position', models.PositiveIntegerField(verbose_name='Position')),
                ('enabled', models.BooleanField()),
                ('css_class', models.CharField(blank=True, max_length=120, null=True)),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='contenttypes.ContentType')),
            ],
            options={
                'ordering': ['position'],
            },
        ),
        migrations.CreateModel(
            name='Form',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=500)),
                ('slug', models.SlugField(max_length=200)),
                ('success_message', models.TextField(blank=True, null=True)),
                ('archived', models.BooleanField()),
            ],
            options={
                'ordering': ('archived', 'name'),
            },
        ),
        migrations.CreateModel(
            name='Option',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250)),
                ('value', models.CharField(max_length=250)),
                ('position', models.PositiveIntegerField(verbose_name='Position')),
            ],
            options={
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='OptionGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250)),
                ('position', models.PositiveIntegerField(verbose_name='Position')),
            ],
            options={
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='OptionList',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250)),
            ],
        ),
        migrations.CreateModel(
            name='PrivacyPolicy',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250)),
                ('text', ckeditor.fields.RichTextField(validators=[formulaic.validators.validate_mixed_content])),
            ],
            options={
                'verbose_name_plural': 'Privacy policies',
            },
        ),
        migrations.CreateModel(
            name='Rule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('operator', models.CharField(choices=[('and', 'And'), ('or', 'Or')], max_length=3)),
                ('position', models.IntegerField()),
                ('form', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='formulaic.Form')),
            ],
            options={
                'ordering': ('position',),
            },
        ),
        migrations.CreateModel(
            name='Submission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField()),
                ('source', models.CharField(blank=True, help_text='Name of the specific form placement the user filled out (e.g. sidebar-subscribe)', max_length=200, null=True)),
                ('metadata_serialized', models.TextField(help_text='Serialized JSON object storing arbitrary submission-related metadata')),
                ('form', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='formulaic.Form')),
            ],
        ),
        migrations.CreateModel(
            name='BooleanField',
            fields=[
                ('field_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='formulaic.Field')),
                ('default_checked', models.BooleanField()),
            ],
            bases=('formulaic.Field',),
        ),
        migrations.CreateModel(
            name='HiddenField',
            fields=[
                ('field_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='formulaic.Field')),
                ('value', models.CharField(blank=True, max_length=500, null=True)),
            ],
            bases=('formulaic.Field',),
        ),
        migrations.CreateModel(
            name='TextField',
            fields=[
                ('field_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='formulaic.Field')),
                ('textarea_rows', models.PositiveIntegerField(blank=True, null=True)),
            ],
            bases=('formulaic.Field',),
        ),
        migrations.CreateModel(
            name='SubmissionKeyValue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key', models.CharField(db_index=True, max_length=200)),
                ('value_charfield', models.CharField(blank=True, max_length=500, null=True)),
                ('value_textfield', models.TextField(blank=True, null=True)),
                ('field', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='formulaic.Field')),
                ('submission', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='values', to='formulaic.Submission')),
            ],
        ),
        migrations.CreateModel(
            name='RuleResult',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('action', models.CharField(choices=[('show', 'Show'), ('hide', 'Hide'), ('require', 'Require (Override)'), ('optional', 'Optional (Override)'), ('change-option-group', 'Change Option Group')], max_length=50)),
                ('field', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='formulaic.Field')),
                ('option_group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='formulaic.OptionGroup')),
                ('rule', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='results', to='formulaic.Rule')),
            ],
        ),
        migrations.CreateModel(
            name='RuleCondition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('position', models.PositiveIntegerField()),
                ('operator', models.CharField(choices=[('is', 'is'), ('is_not', 'is_not'), ('contains', 'contains'), ('does_not_contain', 'does_not_contain'), ('begins_with', 'begins_with'), ('ends_with', 'ends_with'), ('greater_than', 'greater_than'), ('less_than', 'less_than'), ('any_selected', 'any_selected'), ('all_selected', 'all_selected')], max_length=30)),
                ('value_string', models.TextField()),
                ('field', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='formulaic.Field')),
                ('rule', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='conditions', to='formulaic.Rule')),
            ],
            options={
                'ordering': ('position',),
            },
        ),
        migrations.AddField(
            model_name='optiongroup',
            name='list',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='groups', to='formulaic.OptionList'),
        ),
        migrations.AddField(
            model_name='optiongroup',
            name='options',
            field=models.ManyToManyField(related_name='groups', to='formulaic.Option'),
        ),
        migrations.AddField(
            model_name='option',
            name='list',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='formulaic.OptionList'),
        ),
        migrations.AddField(
            model_name='form',
            name='privacy_policy',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='formulaic.PrivacyPolicy'),
        ),
        migrations.AddField(
            model_name='field',
            name='form',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='formulaic.Form'),
        ),
        migrations.CreateModel(
            name='DisplayCondition',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('values', models.TextField()),
                ('value_option', models.CharField(choices=[('is', 'is'), ('is_not', 'is not')], max_length=15)),
                ('affected_field', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='affecting_conditions', to='formulaic.Field')),
                ('watched_field', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='watching_conditions', to='formulaic.Field')),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='field',
            unique_together={('form', 'slug')},
        ),
        migrations.CreateModel(
            name='ChoiceField',
            fields=[
                ('field_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='formulaic.Field')),
                ('minimum_selections', models.PositiveIntegerField(blank=True, null=True)),
                ('maximum_selections', models.PositiveIntegerField(blank=True, null=True)),
                ('default_options_string', models.CharField(blank=True, max_length=200, null=True)),
                ('default_text', models.CharField(blank=True, max_length=200, null=True)),
                ('option_group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='formulaic.OptionGroup')),
                ('option_list', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='formulaic.OptionList')),
            ],
            bases=('formulaic.Field',),
        ),
    ]
