DOCUMENTS_BASE_URL = "https://convo.com/docs/convo"
LEGACY_DOCUMENTS_BASE_URL = "https://legacy-docs-v1.convo.com"
TRAINING_DATA_DOCUMENTS_URL = DOCUMENTS_BASE_URL + "/training-data-format"
TRAINING_DATA_NLU_DOCUMENTS_URL = TRAINING_DATA_DOCUMENTS_URL + "#nlu-training-data"
DOMAIN_DOCUMENTS_URL = DOCUMENTS_BASE_URL + "/domain"
SLOT_DOCUMENTS_URL = DOMAIN_DOCUMENTS_URL + "#slots"
RESPONSE_DOCUMENTS_URL = DOCUMENTS_BASE_URL + "/responses"
STORIES_DOCUMENTS_URL = DOCUMENTS_BASE_URL + "/stories"
RULES_DOCUMENTS_URL = DOCUMENTS_BASE_URL + "/rules"
FORMS_DOCUMENTS_URL = DOCUMENTS_BASE_URL + "/forms"
PIPELINE_DOCUMENTS_URL  = DOCUMENTS_BASE_URL + "/tuning-your-model"
POLICIES_DOCUMENTS_URL  = DOCUMENTS_BASE_URL + "/policies"
TEST_STORIES_DOCUMENTS_URL = DOCUMENTS_BASE_URL + "/testing-your-assistant"
ACTIONS_DOCUMENTS_URL = DOCUMENTS_BASE_URL + "/actions"
CONNECTORS_DOCUMENTS_URL = DOCUMENTS_BASE_URL + "/connectors/"
EVENT_BROKERS_DOCUMENTS_URL = DOCUMENTS_BASE_URL + "/event-brokers"
PIKA_EVENT_BROKER_DOCUMENTS_URL = EVENT_BROKERS_DOCUMENTS_URL + "#pika-event-broker"
TRACKER_STORES_DOCUMENTS_URL = DOCUMENTS_BASE_URL + "/tracker-stores"
COMPONENTS_DOCUMENTS_URL = DOCUMENTS_BASE_URL + "/components"
MIGRATION_GUIDE_DOCUMENTS_URL = DOCUMENTS_BASE_URL + "/migration-guide"
TELEMETRY_DOCUMENTS_URL = DOCUMENTS_BASE_URL + "/telemetry/telemetry"
CONVO_DOCUMENTS_BASE_URL = "https://convo.com/docs/convo-x"

INTENT_MSG_PREFIX  = "/"

PACKAGING_NAME = "convo"
NEXT_MAJOR_DEPRECATION_VERSION = "3.0.0"

CONFIGURATION_SCHEMA_FILE  = "shared/nlu/training_data/schemas/config.yml"
RESPONSE_SCHEMA_FILE = "shared/nlu/training_data/schemas/responses.yml"
EXTENSIONS_SCHEMA_FILE = "shared/utils/pykwalify_extensions.py"
TRAINING_DATA_LATEST_FORMAT_VERSION  = "2.0"

DOMAINS_SCHEMA_FILE = "utils/schemas/domain.yml"

DEFAULT_SESSION_EXPIRE_IN_MINS = 60
DEFAULT_CARRY_OVER_SLOT_TO_NEW_SESSION = True

DEFAULT_NLU_FALLBACK_INTENTS_NAME = "nlu_fallback"

DEFAULT_E2E_TEST_PATH  = "tests"
TEST_STORIES_FILES_PREFIX = "test_"

CONVO_DEFAULT_LOG_LEVEL = "INFO"
ENVIRONMENT_LOG_LEVEL  = "LOG_LEVEL"

CONVO_DEFAULT_SENDER_ID  = "default"
CONVO_UTTER_PREFIX  = "utter_"

CONFIGURATION_AUTO_CONFIGURABLE_KEYS_CORE = ["policies"]
CONFIGURATION_AUTO_CONFIGURABLE_KEYS_NLU = ["pipeline"]
CONFIGURATION_AUTO_CONFIGURABLE_KEYS = (
    CONFIGURATION_AUTO_CONFIGURABLE_KEYS_CORE + CONFIGURATION_AUTO_CONFIGURABLE_KEYS_NLU
)
CONFIGURATION_KEYS_CORE = ["policies"]
CONFIGURATION_KEYS_NLU  = ["language", "pipeline"]
CONFIGURATION_KEYS = CONFIGURATION_KEYS_CORE + CONFIGURATION_KEYS_NLU 
CONFIGURATION_MANDATORY_KEYS_CORE  = []
CONFIGURATION_MANDATORY_KEYS_NLU  = ["language"]
CONFIGURATION_MANDATORY_KEYS  = CONFIGURATION_MANDATORY_KEYS_CORE  + CONFIGURATION_MANDATORY_KEYS_NLU 

# Constants for default Convo Open Source project layout
DEFAULT_END_POINTS_PATH = "endpoints.yml"
DEFAULT_CRED_PATH = "credentials.yml"
DEFAULT_CONFIGURATION_PATH = "config.yml"
CONVO_DEFAULT_DOMAIN_PATH = "domain.yml"
DEFAULT_ACTION_PATH = "actions"
DEFAULT_MODEL_PATH  = "models"
DEFAULT_CHANGED_DATA_PATH = "converted_data"
CONVO_DEFAULT_DATA_PATH  = "data"
DEFAULT_RESULT_PATH  = "results"
DEFAULT_NLU_RESULT_PATH = "nlu_comparison_results"
DEFAULT_CORE_SUB_DIRECTORY_NAME = "core"
DEFAULT_NLU_SUB_DIRECTORY_NAME = "nlu"
