"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HeaderMatch = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Used to generate header matching methods.
 *
 * @stability stable
 */
class HeaderMatch {
    /**
     * The value of the header with the given name in the request must match the specified value exactly.
     *
     * @param headerName the name of the header to match against.
     * @param headerValue The exact value to test against.
     * @stability stable
     */
    static valueIs(headerName, headerValue) {
        return new HeaderMatchImpl(headerName, false, { exact: headerValue });
    }
    /**
     * The value of the header with the given name in the request must not match the specified value exactly.
     *
     * @param headerName the name of the header to match against.
     * @param headerValue The exact value to test against.
     * @stability stable
     */
    static valueIsNot(headerName, headerValue) {
        return new HeaderMatchImpl(headerName, true, { exact: headerValue });
    }
    /**
     * The value of the header with the given name in the request must start with the specified characters.
     *
     * @param headerName the name of the header to match against.
     * @param prefix The prefix to test against.
     * @stability stable
     */
    static valueStartsWith(headerName, prefix) {
        return new HeaderMatchImpl(headerName, false, { prefix });
    }
    /**
     * The value of the header with the given name in the request must not start with the specified characters.
     *
     * @param headerName the name of the header to match against.
     * @param prefix The prefix to test against.
     * @stability stable
     */
    static valueDoesNotStartWith(headerName, prefix) {
        return new HeaderMatchImpl(headerName, true, { prefix });
    }
    /**
     * The value of the header with the given name in the request must end with the specified characters.
     *
     * @param headerName the name of the header to match against.
     * @param suffix The suffix to test against.
     * @stability stable
     */
    static valueEndsWith(headerName, suffix) {
        return new HeaderMatchImpl(headerName, false, { suffix });
    }
    /**
     * The value of the header with the given name in the request must not end with the specified characters.
     *
     * @param headerName the name of the header to match against.
     * @param suffix The suffix to test against.
     * @stability stable
     */
    static valueDoesNotEndWith(headerName, suffix) {
        return new HeaderMatchImpl(headerName, true, { suffix });
    }
    /**
     * The value of the header with the given name in the request must include the specified characters.
     *
     * @param headerName the name of the header to match against.
     * @param regex The regex to test against.
     * @stability stable
     */
    static valueMatchesRegex(headerName, regex) {
        return new HeaderMatchImpl(headerName, false, { regex });
    }
    /**
     * The value of the header with the given name in the request must not include the specified characters.
     *
     * @param headerName the name of the header to match against.
     * @param regex The regex to test against.
     * @stability stable
     */
    static valueDoesNotMatchRegex(headerName, regex) {
        return new HeaderMatchImpl(headerName, true, { regex });
    }
    /**
     * The value of the header with the given name in the request must be in a range of values.
     *
     * @param headerName the name of the header to match against.
     * @param start Match on values starting at and including this value.
     * @param end Match on values up to but not including this value.
     * @stability stable
     */
    static valuesIsInRange(headerName, start, end) {
        return new HeaderMatchImpl(headerName, false, {
            range: {
                start,
                end,
            },
        });
    }
    /**
     * The value of the header with the given name in the request must not be in a range of values.
     *
     * @param headerName the name of the header to match against.
     * @param start Match on values starting at and including this value.
     * @param end Match on values up to but not including this value.
     * @stability stable
     */
    static valuesIsNotInRange(headerName, start, end) {
        return new HeaderMatchImpl(headerName, true, {
            range: {
                start,
                end,
            },
        });
    }
}
exports.HeaderMatch = HeaderMatch;
_a = JSII_RTTI_SYMBOL_1;
HeaderMatch[_a] = { fqn: "@aws-cdk/aws-appmesh.HeaderMatch", version: "1.124.0" };
class HeaderMatchImpl extends HeaderMatch {
    constructor(headerName, invert, matchProperty) {
        super();
        this.headerName = headerName;
        this.invert = invert;
        this.matchProperty = matchProperty;
    }
    bind(_scope) {
        return {
            headerMatch: {
                name: this.headerName,
                invert: this.invert,
                match: this.matchProperty,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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