# -*- coding: utf-8 -*-
# Generated by Django 1.9.7 on 2016-06-22 21:31
from __future__ import absolute_import, unicode_literals

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import deux.services


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0007_alter_validators_add_error_messages'),
    ]

    operations = [
        migrations.CreateModel(
            name='MultiFactorAuth',
            fields=[
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='multi_factor_auth', serialize=False, to=settings.AUTH_USER_MODEL)),
                ('phone_number', models.CharField(blank=True, default='', max_length=15, validators=[django.core.validators.RegexValidator(message='Please enter a valid phone number.', regex='^(\\d{7,15})$')])),
                ('challenge_type', models.CharField(blank=True, choices=[('sms', 'SMS'), ('', 'Off')], default='', max_length=16)),
                ('backup_key', models.CharField(blank=True, default='', help_text='Hex-Encoded Secret Key', max_length=32)),
                ('sms_secret_key', models.CharField(default=deux.services.generate_key, help_text='Hex-Encoded Secret Key', max_length=32)),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
