# `lz_drip` Project #

The `lz_drip` project contains plug-ins for the `drip_feed` command that is part of the `drip_drip` package.

The `drip_feed` command can either take the name of the plug-in as it argument, or the name can be specified in the `DRIP_DROPPER` environmental variable.

It should be noted that any `INI` file and section discussed below can be declared either as `drip_drip` options (`-i` and `-s` respectively) or as environmental variables (`DRIP_INI_FILE` and `DRIP_INI_SECTION` respectively.)


## `lz_drip:SpadeReception` plug-in ##

The `lz_drip:SpadeReception` plug-in is used to `drip_feed` SPADE bundles from a receiving dropbox, i.e. one to which a remote SPADE copies its files, to a "shadow" receiving dropbox, i.e. one from which the localSPADE reads the files. Using this plug-in avoids the shadow dropbox from becoming too full, under which circumstances the local SPADE's performance can be severely degraded.

The configuration for this plugin is defined within section of the `INI` file provided with the command. This section should contain the following:

* source: The location of the receiving dropbox;
* destination: The location of the "shadow" receiving dropbox; and
* threshold: The maximum number of bundles allowed in the "shadow" receiving dropbox.

Here is an example `INI` file.

    [usdc.surf.raw.in]
    source = /global/cfs/cdirs/lz/spade/receiving/surf
    destination = /global/cfs/cdirs/lz/spade/receiving/surf.shadow
    threshold = 100

These values can also be set by environmental variables, in which chase the variable supersedes any value in the `INI` file.

* `FILE_DRIP_SOURCE`
* `FILE_DRIP_DESTINATION`
* `FILE_DRIP_THRESHOLD`


## `salt_arrival` ##
