try:
	from zcrmsdk.src.com.zoho.crm.api.util import Constants
	from zcrmsdk.src.com.zoho.api.exception import SDKException
except Exception:
	from ..util import Constants
	from zcrmsdk.src.com.zoho.api.exception import SDKException


class Theme(object):
	def __init__(self):
		"""Creates an instance of Theme"""

		self.__normal_tab = None
		self.__selected_tab = None
		self.__new_background = None
		self.__background = None
		self.__screen = None
		self.__type = None
		self.__key_modified = dict()

	def get_normal_tab(self):
		"""
		The method to get the normal_tab

		Returns:
			TabTheme: An instance of TabTheme
		"""

		return self.__normal_tab

	def set_normal_tab(self, normal_tab):
		"""
		The method to set the value to normal_tab

		Parameters:
			normal_tab (TabTheme) : An instance of TabTheme
		"""

		try:
			from zcrmsdk.src.com.zoho.crm.api.users.tab_theme import TabTheme
		except Exception:
			from .tab_theme import TabTheme

		if not isinstance(normal_tab, TabTheme):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: normal_tab EXPECTED TYPE: TabTheme', None, None)
		
		self.__normal_tab = normal_tab
		self.__key_modified['normal_tab'] = 1

	def get_selected_tab(self):
		"""
		The method to get the selected_tab

		Returns:
			TabTheme: An instance of TabTheme
		"""

		return self.__selected_tab

	def set_selected_tab(self, selected_tab):
		"""
		The method to set the value to selected_tab

		Parameters:
			selected_tab (TabTheme) : An instance of TabTheme
		"""

		try:
			from zcrmsdk.src.com.zoho.crm.api.users.tab_theme import TabTheme
		except Exception:
			from .tab_theme import TabTheme

		if not isinstance(selected_tab, TabTheme):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: selected_tab EXPECTED TYPE: TabTheme', None, None)
		
		self.__selected_tab = selected_tab
		self.__key_modified['selected_tab'] = 1

	def get_new_background(self):
		"""
		The method to get the new_background

		Returns:
			string: A string value
		"""

		return self.__new_background

	def set_new_background(self, new_background):
		"""
		The method to set the value to new_background

		Parameters:
			new_background (string) : A string value
		"""

		if not isinstance(new_background, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: new_background EXPECTED TYPE: str', None, None)
		
		self.__new_background = new_background
		self.__key_modified['new_background'] = 1

	def get_background(self):
		"""
		The method to get the background

		Returns:
			string: A string value
		"""

		return self.__background

	def set_background(self, background):
		"""
		The method to set the value to background

		Parameters:
			background (string) : A string value
		"""

		if not isinstance(background, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: background EXPECTED TYPE: str', None, None)
		
		self.__background = background
		self.__key_modified['background'] = 1

	def get_screen(self):
		"""
		The method to get the screen

		Returns:
			string: A string value
		"""

		return self.__screen

	def set_screen(self, screen):
		"""
		The method to set the value to screen

		Parameters:
			screen (string) : A string value
		"""

		if not isinstance(screen, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: screen EXPECTED TYPE: str', None, None)
		
		self.__screen = screen
		self.__key_modified['screen'] = 1

	def get_type(self):
		"""
		The method to get the type

		Returns:
			string: A string value
		"""

		return self.__type

	def set_type(self, type):
		"""
		The method to set the value to type

		Parameters:
			type (string) : A string value
		"""

		if not isinstance(type, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: type EXPECTED TYPE: str', None, None)
		
		self.__type = type
		self.__key_modified['type'] = 1

	def is_key_modified(self, key):
		"""
		The method to check if the user has modified the given key

		Parameters:
			key (string) : A string value

		Returns:
			int: A int value
		"""

		if not isinstance(key, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: key EXPECTED TYPE: str', None, None)
		
		if key in self.__key_modified:
			return self.__key_modified.get(key)
		
		return None

	def set_key_modified(self, key, modification):
		"""
		The method to mark the given key as modified

		Parameters:
			key (string) : A string value
			modification (int) : A int value
		"""

		if not isinstance(key, str):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: key EXPECTED TYPE: str', None, None)
		
		if not isinstance(modification, int):
			raise SDKException(Constants.DATA_TYPE_ERROR, 'KEY: modification EXPECTED TYPE: int', None, None)
		
		self.__key_modified[key] = modification
