## Welcome to Backblaze's unofficial python wrapper!

This is a unofficial asynchronous & synchronous wrapper for Backblaze's B2 API.

The awaiting version requires Python ``3.7`` or above!

### Features:

- Full API coverage.
- Static typing with [PyRight](https://github.com/microsoft/pyright).
- Background authentication.
- Asynchronous & synchronous support.
- Easy to use with an object oriented design.
- Unit testing.
- Upload URL caching.
- Rate limit handler.

### Install

- Pip:``pip3 install backblaze``
- Git:``pip3 install git+https://github.com/WardPearce/backblaze.git``

### Examples

- [Upload file](/examples/file_uploader.py)
- Have an example? Make a PR!

### Documentation

[Documentation](https://backblaze.readthedocs.io/en/latest/)

### Thanks to

- [Encode for creating HTTPX](https://www.python-httpx.org/)
