"""Mapping of GBD sequelae.

This code is automatically generated by gbd_mapping_generator/sequela_builder.py

Any manual changes will be lost.
"""
from .id import s_id, hs_id, me_id
from .sequela_template import Healthstate, Sequela, Sequelae


sequelae = Sequelae(**{
    'mild_chronic_digestive_disease_due_to_chagas_disease': Sequela(
        name='mild_chronic_digestive_disease_due_to_chagas_disease',
        kind='sequela',
        gbd_id=s_id(126),
        me_id=me_id(1453),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'hepatomegaly_due_to_schistosomiasis': Sequela(
        name='hepatomegaly_due_to_schistosomiasis',
        kind='sequela',
        gbd_id=s_id(139),
        me_id=me_id(1471),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'dysuria_due_to_schistosomiasis': Sequela(
        name='dysuria_due_to_schistosomiasis',
        kind='sequela',
        gbd_id=s_id(141),
        me_id=me_id(1473),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'bladder_pathology_due_to_schistosomiasis': Sequela(
        name='bladder_pathology_due_to_schistosomiasis',
        kind='sequela',
        gbd_id=s_id(142),
        me_id=me_id(1474),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'hydronephrosis_due_to_schistosomiasis': Sequela(
        name='hydronephrosis_due_to_schistosomiasis',
        kind='sequela',
        gbd_id=s_id(143),
        me_id=me_id(1475),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'mild_abdominopelvic_problems_due_to_ascariasis': Sequela(
        name='mild_abdominopelvic_problems_due_to_ascariasis',
        kind='sequela',
        gbd_id=s_id(164),
        me_id=me_id(1514),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'mild_abdominopelvic_problems_due_to_trichuriasis': Sequela(
        name='mild_abdominopelvic_problems_due_to_trichuriasis',
        kind='sequela',
        gbd_id=s_id(167),
        me_id=me_id(1517),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'mild_abdominopelvic_problems_due_to_hookworm_disease': Sequela(
        name='mild_abdominopelvic_problems_due_to_hookworm_disease',
        kind='sequela',
        gbd_id=s_id(170),
        me_id=me_id(1520),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'mild_abdominal_pain_due_to_endometriosis': Sequela(
        name='mild_abdominal_pain_due_to_endometriosis',
        kind='sequela',
        gbd_id=s_id(520),
        me_id=me_id(9745),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'abdominal_pain_due_to_premenstrual_syndrome': Sequela(
        name='abdominal_pain_due_to_premenstrual_syndrome',
        kind='sequela',
        gbd_id=s_id(524),
        me_id=me_id(2081),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'mild_other_gynecological_disorders': Sequela(
        name='mild_other_gynecological_disorders',
        kind='sequela',
        gbd_id=s_id(844),
        me_id=me_id(2915),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'abdominal_pain_due_to_genital_prolapse': Sequela(
        name='abdominal_pain_due_to_genital_prolapse',
        kind='sequela',
        gbd_id=s_id(859),
        me_id=me_id(2940),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'mild_abdominal_pain_due_to_uterine_fibroids_without_anemia': Sequela(
        name='mild_abdominal_pain_due_to_uterine_fibroids_without_anemia',
        kind='sequela',
        gbd_id=s_id(1109),
        me_id=me_id(3331),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'chronic_abdominal_pain_due_to_congenital_diaphragmatic_hernia': Sequela(
        name='chronic_abdominal_pain_due_to_congenital_diaphragmatic_hernia',
        kind='sequela',
        gbd_id=s_id(1604),
        me_id=me_id(11078),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'dysphagia_or_acid_reflux_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract': Sequela(
        name='dysphagia_or_acid_reflux_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract',
        kind='sequela',
        gbd_id=s_id(1652),
        me_id=me_id(11155),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'chronic_abdominal_pain_due_to_congenital_malformations_of_the_abdominal_wall': Sequela(
        name='chronic_abdominal_pain_due_to_congenital_malformations_of_the_abdominal_wall',
        kind='sequela',
        gbd_id=s_id(1682),
        me_id=me_id(11165),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'acid_reflux_dyspahgia_and_or_constipation_due_to_other_congenital_malformations_of_the_digestive_tract': Sequela(
        name='acid_reflux_dyspahgia_and_or_constipation_due_to_other_congenital_malformations_of_the_digestive_tract',
        kind='sequela',
        gbd_id=s_id(1700),
        me_id=me_id(11171),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies': Sequela(
        name='recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies',
        kind='sequela',
        gbd_id=s_id(1721),
        me_id=me_id(11035),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract': Sequela(
        name='recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract',
        kind='sequela',
        gbd_id=s_id(1862),
        me_id=me_id(11365),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'mild_symptomatic_episodes_gallbladder_and_biliary_diseases': Sequela(
        name='mild_symptomatic_episodes_gallbladder_and_biliary_diseases',
        kind='sequela',
        gbd_id=s_id(4586),
        me_id=me_id(16283),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'mild_symptomatic_inguinal_femoral_and_abdominal_hernia': Sequela(
        name='mild_symptomatic_inguinal_femoral_and_abdominal_hernia',
        kind='sequela',
        gbd_id=s_id(4595),
        me_id=me_id(16286),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'mild_chronic_pancreatitis': Sequela(
        name='mild_chronic_pancreatitis',
        kind='sequela',
        gbd_id=s_id(4610),
        me_id=me_id(16293),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'mild_urolithiasis_episodes': Sequela(
        name='mild_urolithiasis_episodes',
        kind='sequela',
        gbd_id=s_id(4631),
        me_id=me_id(16300),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'mildly_symptomatic_pud_with_no_anemia': Sequela(
        name='mildly_symptomatic_pud_with_no_anemia',
        kind='sequela',
        gbd_id=s_id(4970),
        me_id=me_id(16214),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'mildly_symptomatic_gastritis_duodenitis_with_no_anemia': Sequela(
        name='mildly_symptomatic_gastritis_duodenitis_with_no_anemia',
        kind='sequela',
        gbd_id=s_id(5003),
        me_id=me_id(16230),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'mild_to_moderate_gerd_symptomatic_days': Sequela(
        name='mild_to_moderate_gerd_symptomatic_days',
        kind='sequela',
        gbd_id=s_id(7184),
        me_id=me_id(20396),
        healthstate=Healthstate(
            name='abdominopelvic_problem_mild',
            kind='healthstate',
            gbd_id=hs_id(544),
        ),
    ),
    'intestinal_perforation_due_to_paratyphoid': Sequela(
        name='intestinal_perforation_due_to_paratyphoid',
        kind='sequela',
        gbd_id=s_id(13),
        me_id=me_id(1256),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'moderate_chronic_digestive_disease_due_to_chagas_disease': Sequela(
        name='moderate_chronic_digestive_disease_due_to_chagas_disease',
        kind='sequela',
        gbd_id=s_id(127),
        me_id=me_id(1454),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'ascites_due_to_schistosomiasis': Sequela(
        name='ascites_due_to_schistosomiasis',
        kind='sequela',
        gbd_id=s_id(140),
        me_id=me_id(1472),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'abdominal_problems_due_to_cystic_echinococcosis': Sequela(
        name='abdominal_problems_due_to_cystic_echinococcosis',
        kind='sequela',
        gbd_id=s_id(147),
        me_id=me_id(1485),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'maternal_hemorrhage_less_than__1l_blood_lost': Sequela(
        name='maternal_hemorrhage_less_than__1l_blood_lost',
        kind='sequela',
        gbd_id=s_id(180),
        me_id=me_id(1536),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'maternal_abortive_outcome': Sequela(
        name='maternal_abortive_outcome',
        kind='sequela',
        gbd_id=s_id(191),
        me_id=me_id(3644),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'moderate_pelvic_inflammatory_diseases_due_to_chlamydial_infection': Sequela(
        name='moderate_pelvic_inflammatory_diseases_due_to_chlamydial_infection',
        kind='sequela',
        gbd_id=s_id(215),
        me_id=me_id(1631),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'moderate_pelvic_inflammatory_diseases_due_to_gonococcal_infection': Sequela(
        name='moderate_pelvic_inflammatory_diseases_due_to_gonococcal_infection',
        kind='sequela',
        gbd_id=s_id(220),
        me_id=me_id(1637),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'moderate_pelvic_inflammatory_diseases_due_to_other_sexually_transmitted_diseases': Sequela(
        name='moderate_pelvic_inflammatory_diseases_due_to_other_sexually_transmitted_diseases',
        kind='sequela',
        gbd_id=s_id(224),
        me_id=me_id(1643),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'moderate_abdominal_pain_due_to_endometriosis': Sequela(
        name='moderate_abdominal_pain_due_to_endometriosis',
        kind='sequela',
        gbd_id=s_id(521),
        me_id=me_id(9746),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'moderate_other_gynecological_disorders': Sequela(
        name='moderate_other_gynecological_disorders',
        kind='sequela',
        gbd_id=s_id(845),
        me_id=me_id(2916),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'heavy_clonorchiasis_due_to_food_borne_trematodiases': Sequela(
        name='heavy_clonorchiasis_due_to_food_borne_trematodiases',
        kind='sequela',
        gbd_id=s_id(908),
        me_id=me_id(3002),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'heavy_fascioliasis_due_to_food_borne_trematodiases': Sequela(
        name='heavy_fascioliasis_due_to_food_borne_trematodiases',
        kind='sequela',
        gbd_id=s_id(909),
        me_id=me_id(3003),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'heavy_intestinal_fluke_infection_due_to_food_borne_trematodiases': Sequela(
        name='heavy_intestinal_fluke_infection_due_to_food_borne_trematodiases',
        kind='sequela',
        gbd_id=s_id(910),
        me_id=me_id(3004),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'heavy_opisthorchiasis_due_to_food_borne_trematodiases': Sequela(
        name='heavy_opisthorchiasis_due_to_food_borne_trematodiases',
        kind='sequela',
        gbd_id=s_id(911),
        me_id=me_id(3005),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'chronic_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract': Sequela(
        name='chronic_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract',
        kind='sequela',
        gbd_id=s_id(1655),
        me_id=me_id(11156),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'constipation_due_to_congenital_malformations_of_the_abdominal_wall': Sequela(
        name='constipation_due_to_congenital_malformations_of_the_abdominal_wall',
        kind='sequela',
        gbd_id=s_id(1679),
        me_id=me_id(11164),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'chronic_abdominal_pain_and_or_nausea_due_to_other_congenital_malformations_of_the_digestive_tract': Sequela(
        name='chronic_abdominal_pain_and_or_nausea_due_to_other_congenital_malformations_of_the_digestive_tract',
        kind='sequela',
        gbd_id=s_id(1703),
        me_id=me_id(11172),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'moderate_symptomatic_episodes_gallbladder_and_biliary_diseases': Sequela(
        name='moderate_symptomatic_episodes_gallbladder_and_biliary_diseases',
        kind='sequela',
        gbd_id=s_id(4589),
        me_id=me_id(16284),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'moderate_symptomatic_inguinal_femoral_and_abdominal_hernia': Sequela(
        name='moderate_symptomatic_inguinal_femoral_and_abdominal_hernia',
        kind='sequela',
        gbd_id=s_id(4598),
        me_id=me_id(16287),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'moderate_chronic_pancreatitis': Sequela(
        name='moderate_chronic_pancreatitis',
        kind='sequela',
        gbd_id=s_id(4613),
        me_id=me_id(16294),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'moderate_urolithiasis_episodes': Sequela(
        name='moderate_urolithiasis_episodes',
        kind='sequela',
        gbd_id=s_id(4634),
        me_id=me_id(16301),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'moderately_symptomatic_pud_with_no_anemia': Sequela(
        name='moderately_symptomatic_pud_with_no_anemia',
        kind='sequela',
        gbd_id=s_id(4973),
        me_id=me_id(16215),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'moderately_symptomatic_gastritis_duodenitis_with_no_anemia': Sequela(
        name='moderately_symptomatic_gastritis_duodenitis_with_no_anemia',
        kind='sequela',
        gbd_id=s_id(5006),
        me_id=me_id(16231),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'ectopic_pregnancy': Sequela(
        name='ectopic_pregnancy',
        kind='sequela',
        gbd_id=s_id(5165),
        me_id=me_id(10485),
        healthstate=Healthstate(
            name='abdominopelvic_problem_moderate',
            kind='healthstate',
            gbd_id=hs_id(545),
        ),
    ),
    'intestinal_perforation_due_to_typhoid': Sequela(
        name='intestinal_perforation_due_to_typhoid',
        kind='sequela',
        gbd_id=s_id(9),
        me_id=me_id(1251),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'maternal_hemorrhage_greater_than__1l_blood_lost': Sequela(
        name='maternal_hemorrhage_greater_than__1l_blood_lost',
        kind='sequela',
        gbd_id=s_id(181),
        me_id=me_id(1537),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'obstructed_labor_acute_event': Sequela(
        name='obstructed_labor_acute_event',
        kind='sequela',
        gbd_id=s_id(188),
        me_id=me_id(3641),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'severe_pelvic_inflammatory_diseases_due_to_chlamydial_infection': Sequela(
        name='severe_pelvic_inflammatory_diseases_due_to_chlamydial_infection',
        kind='sequela',
        gbd_id=s_id(216),
        me_id=me_id(1632),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'severe_pelvic_inflammatory_diseases_due_to_gonococcal_infection': Sequela(
        name='severe_pelvic_inflammatory_diseases_due_to_gonococcal_infection',
        kind='sequela',
        gbd_id=s_id(221),
        me_id=me_id(1638),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'severe_pelvic_inflammatory_diseases_due_to_other_sexually_transmitted_diseases': Sequela(
        name='severe_pelvic_inflammatory_diseases_due_to_other_sexually_transmitted_diseases',
        kind='sequela',
        gbd_id=s_id(225),
        me_id=me_id(1644),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'appendicitis': Sequela(
        name='appendicitis',
        kind='sequela',
        gbd_id=s_id(445),
        me_id=me_id(24547),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'paralytic_ileus_and_intestinal_obstruction': Sequela(
        name='paralytic_ileus_and_intestinal_obstruction',
        kind='sequela',
        gbd_id=s_id(446),
        me_id=me_id(24548),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'vascular_intestinal_disorders': Sequela(
        name='vascular_intestinal_disorders',
        kind='sequela',
        gbd_id=s_id(448),
        me_id=me_id(24648),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'severe_other_gynecological_disorders': Sequela(
        name='severe_other_gynecological_disorders',
        kind='sequela',
        gbd_id=s_id(846),
        me_id=me_id(2917),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'severe_abdominal_pain_due_to_endometriosis': Sequela(
        name='severe_abdominal_pain_due_to_endometriosis',
        kind='sequela',
        gbd_id=s_id(941),
        me_id=me_id(9747),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'severe_symptomatic_episodes_gallbladder_and_biliary_diseases': Sequela(
        name='severe_symptomatic_episodes_gallbladder_and_biliary_diseases',
        kind='sequela',
        gbd_id=s_id(4592),
        me_id=me_id(16285),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'severe_symptomatic_inguinal_femoral_and_abdominal_hernia': Sequela(
        name='severe_symptomatic_inguinal_femoral_and_abdominal_hernia',
        kind='sequela',
        gbd_id=s_id(4601),
        me_id=me_id(16288),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'severe_chronic_pancreatitis': Sequela(
        name='severe_chronic_pancreatitis',
        kind='sequela',
        gbd_id=s_id(4616),
        me_id=me_id(16295),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'severe_urolithiasis_episodes': Sequela(
        name='severe_urolithiasis_episodes',
        kind='sequela',
        gbd_id=s_id(4637),
        me_id=me_id(16302),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'severe_acute_uncomplicated_pud_with_no_anemia': Sequela(
        name='severe_acute_uncomplicated_pud_with_no_anemia',
        kind='sequela',
        gbd_id=s_id(7199),
        me_id=me_id(20293),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'severe_acute_uncomplicated_gastritis_duodenitis_with_no_anemia': Sequela(
        name='severe_acute_uncomplicated_gastritis_duodenitis_with_no_anemia',
        kind='sequela',
        gbd_id=s_id(7211),
        me_id=me_id(20309),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'extreme_hyperbilirubinemia_due_to_hemolytic_disease_and_other_neonatal_jaundice_without_kernicterus': Sequela(
        name='extreme_hyperbilirubinemia_due_to_hemolytic_disease_and_other_neonatal_jaundice_without_kernicterus',
        kind='sequela',
        gbd_id=s_id(7223),
        me_id=me_id(19813),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(546),
        ),
    ),
    'severe_acute_uncomplicated_pud_with_mild_anemia': Sequela(
        name='severe_acute_uncomplicated_pud_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(7202),
        me_id=me_id(20294),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe_and_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2684),
        ),
    ),
    'severe_acute_uncomplicated_gastritis_duodenitis_with_mild_anemia': Sequela(
        name='severe_acute_uncomplicated_gastritis_duodenitis_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(7214),
        me_id=me_id(20310),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe_and_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2684),
        ),
    ),
    'severe_acute_uncomplicated_pud_with_moderate_anemia': Sequela(
        name='severe_acute_uncomplicated_pud_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(7205),
        me_id=me_id(20295),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe_and_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2690),
        ),
    ),
    'severe_acute_uncomplicated_gastritis_duodenitis_with_moderate_anemia': Sequela(
        name='severe_acute_uncomplicated_gastritis_duodenitis_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(7217),
        me_id=me_id(20311),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe_and_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2690),
        ),
    ),
    'severe_acute_uncomplicated_pud_with_severe_anemia': Sequela(
        name='severe_acute_uncomplicated_pud_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(7208),
        me_id=me_id(20296),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe_and_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(2693),
        ),
    ),
    'severe_acute_uncomplicated_gastritis_duodenitis_with_severe_anemia': Sequela(
        name='severe_acute_uncomplicated_gastritis_duodenitis_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(7220),
        me_id=me_id(20312),
        healthstate=Healthstate(
            name='abdominopelvic_problem_severe_and_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(2693),
        ),
    ),
    'acute_myocardial_infarction_first_2_days': Sequela(
        name='acute_myocardial_infarction_first_2_days',
        kind='sequela',
        gbd_id=s_id(378),
        me_id=me_id(1815),
        healthstate=Healthstate(
            name='acute_myocardial_infarction_days_1_2',
            kind='healthstate',
            gbd_id=hs_id(374),
        ),
    ),
    'acute_myocardial_infarction_3_to_28_days': Sequela(
        name='acute_myocardial_infarction_3_to_28_days',
        kind='sequela',
        gbd_id=s_id(379),
        me_id=me_id(1816),
        healthstate=Healthstate(
            name='acute_myocardial_infarction_days_3_28',
            kind='healthstate',
            gbd_id=hs_id(375),
        ),
    ),
    'aids_without_anemia': Sequela(
        name='aids_without_anemia',
        kind='sequela',
        gbd_id=s_id(5096),
        me_id=me_id(16336),
        healthstate=Healthstate(
            name='aids_cases_not_receiving_arv_treatment',
            kind='healthstate',
            gbd_id=hs_id(362),
        ),
    ),
    'aids_with_mild_anemia': Sequela(
        name='aids_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(5087),
        me_id=me_id(16333),
        healthstate=Healthstate(
            name='aids_cases_not_receiving_arv_treatment_and_anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(2552),
        ),
    ),
    'aids_with_moderate_anemia': Sequela(
        name='aids_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(5090),
        me_id=me_id(16334),
        healthstate=Healthstate(
            name='aids_cases_not_receiving_arv_treatment_and_anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(2555),
        ),
    ),
    'aids_with_severe_anemia': Sequela(
        name='aids_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5093),
        me_id=me_id(16335),
        healthstate=Healthstate(
            name='aids_cases_not_receiving_arv_treatment_and_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(2558),
        ),
    ),
    'mild_alcohol_dependence': Sequela(
        name='mild_alcohol_dependence',
        kind='sequela',
        gbd_id=s_id(468),
        me_id=me_id(1968),
        healthstate=Healthstate(
            name='alcohol_use_disorder_mild',
            kind='healthstate',
            gbd_id=hs_id(424),
        ),
    ),
    'moderate_alcohol_dependence': Sequela(
        name='moderate_alcohol_dependence',
        kind='sequela',
        gbd_id=s_id(469),
        me_id=me_id(1969),
        healthstate=Healthstate(
            name='alcohol_use_disorder_moderate',
            kind='healthstate',
            gbd_id=hs_id(425),
        ),
    ),
    'severe_alcohol_dependence': Sequela(
        name='severe_alcohol_dependence',
        kind='sequela',
        gbd_id=s_id(470),
        me_id=me_id(1970),
        healthstate=Healthstate(
            name='alcohol_use_disorder_severe',
            kind='healthstate',
            gbd_id=hs_id(426),
        ),
    ),
    'very_mild_alcohol_dependence': Sequela(
        name='very_mild_alcohol_dependence',
        kind='sequela',
        gbd_id=s_id(678),
        me_id=me_id(2643),
        healthstate=Healthstate(
            name='alcohol_use_disorder_very_mild',
            kind='healthstate',
            gbd_id=hs_id(747),
        ),
    ),
    'severe_amphetamine_dependence': Sequela(
        name='severe_amphetamine_dependence',
        kind='sequela',
        gbd_id=s_id(806),
        me_id=me_id(2829),
        healthstate=Healthstate(
            name='amphetamine_dependence',
            kind='healthstate',
            gbd_id=hs_id(431),
        ),
    ),
    'mild_amphetamine_dependence': Sequela(
        name='mild_amphetamine_dependence',
        kind='sequela',
        gbd_id=s_id(679),
        me_id=me_id(2644),
        healthstate=Healthstate(
            name='amphetamine_dependence_mild',
            kind='healthstate',
            gbd_id=hs_id(583),
        ),
    ),
    'mild_anemia_due_to_schistosomiasis': Sequela(
        name='mild_anemia_due_to_schistosomiasis',
        kind='sequela',
        gbd_id=s_id(144),
        me_id=me_id(1476),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'mild_anemia_due_to_hookworm_disease': Sequela(
        name='mild_anemia_due_to_hookworm_disease',
        kind='sequela',
        gbd_id=s_id(172),
        me_id=me_id(1522),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'mild_anemia_due_to_other_neglected_tropical_diseases': Sequela(
        name='mild_anemia_due_to_other_neglected_tropical_diseases',
        kind='sequela',
        gbd_id=s_id(177),
        me_id=me_id(1532),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'mild_anemia_due_to_maternal_hemorrhage': Sequela(
        name='mild_anemia_due_to_maternal_hemorrhage',
        kind='sequela',
        gbd_id=s_id(182),
        me_id=me_id(1538),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'mild_iron_deficiency_anemia': Sequela(
        name='mild_iron_deficiency_anemia',
        kind='sequela',
        gbd_id=s_id(206),
        me_id=me_id(1621),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'mild_anemia_due_to_other_infectious_diseases': Sequela(
        name='mild_anemia_due_to_other_infectious_diseases',
        kind='sequela',
        gbd_id=s_id(240),
        me_id=me_id(1666),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'mild_anemia_due_to_menstrual_disorders': Sequela(
        name='mild_anemia_due_to_menstrual_disorders',
        kind='sequela',
        gbd_id=s_id(525),
        me_id=me_id(2082),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'mild_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias': Sequela(
        name='mild_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias',
        kind='sequela',
        gbd_id=s_id(531),
        me_id=me_id(2119),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'mild_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders': Sequela(
        name='mild_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders',
        kind='sequela',
        gbd_id=s_id(537),
        me_id=me_id(2131),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'mild_anemia_due_to_b_thalassemia_trait': Sequela(
        name='mild_anemia_due_to_b_thalassemia_trait',
        kind='sequela',
        gbd_id=s_id(645),
        me_id=me_id(2485),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'mild_anemia_due_to_hemoglobin_e_trait': Sequela(
        name='mild_anemia_due_to_hemoglobin_e_trait',
        kind='sequela',
        gbd_id=s_id(648),
        me_id=me_id(2489),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'mild_anemia_due_to_sickle_cell_trait': Sequela(
        name='mild_anemia_due_to_sickle_cell_trait',
        kind='sequela',
        gbd_id=s_id(651),
        me_id=me_id(2502),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'mild_anemia_due_to_hemizygous_g6pd_trait': Sequela(
        name='mild_anemia_due_to_hemizygous_g6pd_trait',
        kind='sequela',
        gbd_id=s_id(654),
        me_id=me_id(2506),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'stage_3_chronic_kidney_disease_and_mild_anemia_due_to_hypertension': Sequela(
        name='stage_3_chronic_kidney_disease_and_mild_anemia_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(1016),
        me_id=me_id(3191),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'stage_3_chronic_kidney_disease_and_mild_anemia_due_to_glomerulonephritis': Sequela(
        name='stage_3_chronic_kidney_disease_and_mild_anemia_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(1024),
        me_id=me_id(3202),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'stage_3_chronic_kidney_disease_and_mild_anemia_due_to_other_causes': Sequela(
        name='stage_3_chronic_kidney_disease_and_mild_anemia_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(1032),
        me_id=me_id(3213),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'mild_anemia_due_to_malaria_parasitemia_pfpr': Sequela(
        name='mild_anemia_due_to_malaria_parasitemia_pfpr',
        kind='sequela',
        gbd_id=s_id(1057),
        me_id=me_id(19391),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'mild_anemia_due_to_g6pd_deficiency': Sequela(
        name='mild_anemia_due_to_g6pd_deficiency',
        kind='sequela',
        gbd_id=s_id(1120),
        me_id=me_id(3350),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'asymptomatic_pud_with_mild_anemia': Sequela(
        name='asymptomatic_pud_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(4976),
        me_id=me_id(16216),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'asymptomatic_gastritis_duodenitis_with_mild_anemia': Sequela(
        name='asymptomatic_gastritis_duodenitis_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(5009),
        me_id=me_id(16232),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'stage_3_chronic_kidney_disease_and_mild_anemia_due_to_type_1_diabetes_mellitus': Sequela(
        name='stage_3_chronic_kidney_disease_and_mild_anemia_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5225),
        me_id=me_id(19413),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'stage_3_chronic_kidney_disease_and_mild_anemia_due_to_type_2_diabetes_mellitus': Sequela(
        name='stage_3_chronic_kidney_disease_and_mild_anemia_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5228),
        me_id=me_id(19414),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'vitamin_a_deficiency_with_mild_anemia': Sequela(
        name='vitamin_a_deficiency_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(5393),
        me_id=me_id(19737),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'mild_anemia_due_to_malaria_vivax_pvpr': Sequela(
        name='mild_anemia_due_to_malaria_vivax_pvpr',
        kind='sequela',
        gbd_id=s_id(5606),
        me_id=me_id(19395),
        healthstate=Healthstate(
            name='anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(547),
        ),
    ),
    'beta_thalassemia_major_with_mild_anemia': Sequela(
        name='beta_thalassemia_major_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(1061),
        me_id=me_id(3271),
        healthstate=Healthstate(
            name='anemia_mild_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(860),
        ),
    ),
    'hemoglobin_e_beta_thalassemia_with_mild_anemia': Sequela(
        name='hemoglobin_e_beta_thalassemia_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(1065),
        me_id=me_id(3278),
        healthstate=Healthstate(
            name='anemia_mild_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(860),
        ),
    ),
    'hemoglobin_h_disease_with_mild_anemia': Sequela(
        name='hemoglobin_h_disease_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(1069),
        me_id=me_id(3285),
        healthstate=Healthstate(
            name='anemia_mild_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(860),
        ),
    ),
    'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_mild_anemia': Sequela(
        name='homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(1079),
        me_id=me_id(3301),
        healthstate=Healthstate(
            name='anemia_mild_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(860),
        ),
    ),
    'hemoglobin_sc_disease_with_mild_anemia': Sequela(
        name='hemoglobin_sc_disease_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(1089),
        me_id=me_id(3311),
        healthstate=Healthstate(
            name='anemia_mild_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(860),
        ),
    ),
    'mild_sickle_cell_beta_thalassemia_with_mild_anemia': Sequela(
        name='mild_sickle_cell_beta_thalassemia_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(1099),
        me_id=me_id(3321),
        healthstate=Healthstate(
            name='anemia_mild_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(860),
        ),
    ),
    'early_hiv_with_mild_anemia': Sequela(
        name='early_hiv_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(5051),
        me_id=me_id(16321),
        healthstate=Healthstate(
            name='anemia_mild_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(860),
        ),
    ),
    'moderate_anemia_due_to_schistosomiasis': Sequela(
        name='moderate_anemia_due_to_schistosomiasis',
        kind='sequela',
        gbd_id=s_id(145),
        me_id=me_id(1477),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'moderate_anemia_due_to_hookworm_disease': Sequela(
        name='moderate_anemia_due_to_hookworm_disease',
        kind='sequela',
        gbd_id=s_id(173),
        me_id=me_id(1523),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'moderate_anemia_due_to_other_neglected_tropical_diseases': Sequela(
        name='moderate_anemia_due_to_other_neglected_tropical_diseases',
        kind='sequela',
        gbd_id=s_id(178),
        me_id=me_id(1533),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'moderate_anemia_due_to_maternal_hemorrhage': Sequela(
        name='moderate_anemia_due_to_maternal_hemorrhage',
        kind='sequela',
        gbd_id=s_id(183),
        me_id=me_id(1539),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'moderate_iron_deficiency_anemia': Sequela(
        name='moderate_iron_deficiency_anemia',
        kind='sequela',
        gbd_id=s_id(207),
        me_id=me_id(1622),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'moderate_anemia_due_to_other_infectious_diseases': Sequela(
        name='moderate_anemia_due_to_other_infectious_diseases',
        kind='sequela',
        gbd_id=s_id(241),
        me_id=me_id(1667),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'moderate_anemia_due_to_menstrual_disorders': Sequela(
        name='moderate_anemia_due_to_menstrual_disorders',
        kind='sequela',
        gbd_id=s_id(526),
        me_id=me_id(2083),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'moderate_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias': Sequela(
        name='moderate_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias',
        kind='sequela',
        gbd_id=s_id(532),
        me_id=me_id(2120),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'moderate_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders': Sequela(
        name='moderate_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders',
        kind='sequela',
        gbd_id=s_id(538),
        me_id=me_id(2132),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'moderate_anemia_due_to_b_thalassemia_trait': Sequela(
        name='moderate_anemia_due_to_b_thalassemia_trait',
        kind='sequela',
        gbd_id=s_id(646),
        me_id=me_id(2486),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'moderate_anemia_due_to_hemoglobin_e_trait': Sequela(
        name='moderate_anemia_due_to_hemoglobin_e_trait',
        kind='sequela',
        gbd_id=s_id(649),
        me_id=me_id(2490),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'moderate_anemia_due_to_sickle_cell_trait': Sequela(
        name='moderate_anemia_due_to_sickle_cell_trait',
        kind='sequela',
        gbd_id=s_id(652),
        me_id=me_id(2503),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'moderate_anemia_due_to_hemizygous_g6pd_trait': Sequela(
        name='moderate_anemia_due_to_hemizygous_g6pd_trait',
        kind='sequela',
        gbd_id=s_id(655),
        me_id=me_id(2507),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_hypertension': Sequela(
        name='stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(1017),
        me_id=me_id(3192),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_glomerulonephritis': Sequela(
        name='stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(1025),
        me_id=me_id(3203),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_other_causes': Sequela(
        name='stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(1033),
        me_id=me_id(3214),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'moderate_anemia_due_to_malaria_parasitemia_pfpr': Sequela(
        name='moderate_anemia_due_to_malaria_parasitemia_pfpr',
        kind='sequela',
        gbd_id=s_id(1058),
        me_id=me_id(19392),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'moderate_anemia_due_to_g6pd_deficiency': Sequela(
        name='moderate_anemia_due_to_g6pd_deficiency',
        kind='sequela',
        gbd_id=s_id(1121),
        me_id=me_id(3351),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'asymptomatic_pud_with_moderate_anemia': Sequela(
        name='asymptomatic_pud_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(4979),
        me_id=me_id(16217),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'asymptomatic_gastritis_duodenitis_with_moderate_anemia': Sequela(
        name='asymptomatic_gastritis_duodenitis_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(5012),
        me_id=me_id(16233),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_type_1_diabetes_mellitus': Sequela(
        name='stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5219),
        me_id=me_id(19411),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_type_2_diabetes_mellitus': Sequela(
        name='stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5222),
        me_id=me_id(19412),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'vitamin_a_deficiency_with_moderate_anemia': Sequela(
        name='vitamin_a_deficiency_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(5396),
        me_id=me_id(19738),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'moderate_anemia_due_to_malaria_vivax_pvpr': Sequela(
        name='moderate_anemia_due_to_malaria_vivax_pvpr',
        kind='sequela',
        gbd_id=s_id(5609),
        me_id=me_id(19396),
        healthstate=Healthstate(
            name='anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(548),
        ),
    ),
    'beta_thalassemia_major_with_moderate_anemia': Sequela(
        name='beta_thalassemia_major_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(1062),
        me_id=me_id(3272),
        healthstate=Healthstate(
            name='anemia_moderate_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(861),
        ),
    ),
    'hemoglobin_e_beta_thalassemia_with_moderate_anemia': Sequela(
        name='hemoglobin_e_beta_thalassemia_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(1066),
        me_id=me_id(3279),
        healthstate=Healthstate(
            name='anemia_moderate_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(861),
        ),
    ),
    'hemoglobin_h_disease_with_moderate_anemia': Sequela(
        name='hemoglobin_h_disease_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(1070),
        me_id=me_id(3286),
        healthstate=Healthstate(
            name='anemia_moderate_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(861),
        ),
    ),
    'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_moderate_anemia': Sequela(
        name='homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(1080),
        me_id=me_id(3302),
        healthstate=Healthstate(
            name='anemia_moderate_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(861),
        ),
    ),
    'hemoglobin_sc_disease_with_moderate_anemia': Sequela(
        name='hemoglobin_sc_disease_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(1090),
        me_id=me_id(3312),
        healthstate=Healthstate(
            name='anemia_moderate_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(861),
        ),
    ),
    'mild_sickle_cell_beta_thalassemia_with_moderate_anemia': Sequela(
        name='mild_sickle_cell_beta_thalassemia_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(1100),
        me_id=me_id(3322),
        healthstate=Healthstate(
            name='anemia_moderate_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(861),
        ),
    ),
    'early_hiv_with_moderate_anemia': Sequela(
        name='early_hiv_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(5054),
        me_id=me_id(16322),
        healthstate=Healthstate(
            name='anemia_moderate_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(861),
        ),
    ),
    'severe_anemia_due_to_schistosomiasis': Sequela(
        name='severe_anemia_due_to_schistosomiasis',
        kind='sequela',
        gbd_id=s_id(146),
        me_id=me_id(1478),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'severe_anemia_due_to_hookworm_disease': Sequela(
        name='severe_anemia_due_to_hookworm_disease',
        kind='sequela',
        gbd_id=s_id(174),
        me_id=me_id(1524),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'severe_anemia_due_to_other_neglected_tropical_diseases': Sequela(
        name='severe_anemia_due_to_other_neglected_tropical_diseases',
        kind='sequela',
        gbd_id=s_id(179),
        me_id=me_id(1534),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'severe_anemia_due_to_maternal_hemorrhage': Sequela(
        name='severe_anemia_due_to_maternal_hemorrhage',
        kind='sequela',
        gbd_id=s_id(184),
        me_id=me_id(1540),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'severe_iron_deficiency_anemia': Sequela(
        name='severe_iron_deficiency_anemia',
        kind='sequela',
        gbd_id=s_id(208),
        me_id=me_id(1623),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'severe_anemia_due_to_other_infectious_diseases': Sequela(
        name='severe_anemia_due_to_other_infectious_diseases',
        kind='sequela',
        gbd_id=s_id(242),
        me_id=me_id(1668),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'severe_anemia_due_to_menstrual_disorders': Sequela(
        name='severe_anemia_due_to_menstrual_disorders',
        kind='sequela',
        gbd_id=s_id(527),
        me_id=me_id(2084),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'severe_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias': Sequela(
        name='severe_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias',
        kind='sequela',
        gbd_id=s_id(533),
        me_id=me_id(2121),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'severe_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders': Sequela(
        name='severe_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders',
        kind='sequela',
        gbd_id=s_id(539),
        me_id=me_id(2133),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'severe_anemia_due_to_b_thalassemia_trait': Sequela(
        name='severe_anemia_due_to_b_thalassemia_trait',
        kind='sequela',
        gbd_id=s_id(647),
        me_id=me_id(2487),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'severe_anemia_due_to_hemoglobin_e_trait': Sequela(
        name='severe_anemia_due_to_hemoglobin_e_trait',
        kind='sequela',
        gbd_id=s_id(650),
        me_id=me_id(2491),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'severe_anemia_due_to_sickle_cell_trait': Sequela(
        name='severe_anemia_due_to_sickle_cell_trait',
        kind='sequela',
        gbd_id=s_id(653),
        me_id=me_id(2504),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'severe_anemia_due_to_hemizygous_g6pd_trait': Sequela(
        name='severe_anemia_due_to_hemizygous_g6pd_trait',
        kind='sequela',
        gbd_id=s_id(656),
        me_id=me_id(2508),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'stage_3_chronic_kidney_disease_and_severe_anemia_due_to_hypertension': Sequela(
        name='stage_3_chronic_kidney_disease_and_severe_anemia_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(1018),
        me_id=me_id(3193),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'stage_3_chronic_kidney_disease_and_severe_anemia_due_to_glomerulonephritis': Sequela(
        name='stage_3_chronic_kidney_disease_and_severe_anemia_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(1026),
        me_id=me_id(3204),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'stage_3_chronic_kidney_disease_and_severe_anemia_due_to_other_causes': Sequela(
        name='stage_3_chronic_kidney_disease_and_severe_anemia_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(1034),
        me_id=me_id(3215),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'severe_anemia_due_to_malaria_parasitemia_pfpr': Sequela(
        name='severe_anemia_due_to_malaria_parasitemia_pfpr',
        kind='sequela',
        gbd_id=s_id(1059),
        me_id=me_id(19393),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'severe_anemia_due_to_g6pd_deficiency': Sequela(
        name='severe_anemia_due_to_g6pd_deficiency',
        kind='sequela',
        gbd_id=s_id(1122),
        me_id=me_id(3352),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'asymptomatic_pud_with_severe_anemia': Sequela(
        name='asymptomatic_pud_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(4982),
        me_id=me_id(16218),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'asymptomatic_gastritis_duodenitis_with_severe_anemia': Sequela(
        name='asymptomatic_gastritis_duodenitis_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5015),
        me_id=me_id(16234),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'stage_3_chronic_kidney_disease_and_severe_anemia_due_to_type_1_diabetes_mellitus': Sequela(
        name='stage_3_chronic_kidney_disease_and_severe_anemia_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5213),
        me_id=me_id(19409),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'stage_3_chronic_kidney_disease_and_severe_anemia_due_to_type_2_diabetes_mellitus': Sequela(
        name='stage_3_chronic_kidney_disease_and_severe_anemia_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5216),
        me_id=me_id(19410),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'vitamin_a_deficiency_with_severe_anemia': Sequela(
        name='vitamin_a_deficiency_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5399),
        me_id=me_id(19739),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'severe_anemia_due_to_malaria_vivax_pvpr': Sequela(
        name='severe_anemia_due_to_malaria_vivax_pvpr',
        kind='sequela',
        gbd_id=s_id(5612),
        me_id=me_id(19397),
        healthstate=Healthstate(
            name='anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(549),
        ),
    ),
    'beta_thalassemia_major_with_severe_anemia': Sequela(
        name='beta_thalassemia_major_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1063),
        me_id=me_id(3273),
        healthstate=Healthstate(
            name='anemia_severe_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(862),
        ),
    ),
    'hemoglobin_e_beta_thalassemia_with_severe_anemia': Sequela(
        name='hemoglobin_e_beta_thalassemia_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1067),
        me_id=me_id(3280),
        healthstate=Healthstate(
            name='anemia_severe_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(862),
        ),
    ),
    'hemoglobin_h_disease_with_severe_anemia': Sequela(
        name='hemoglobin_h_disease_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1071),
        me_id=me_id(3287),
        healthstate=Healthstate(
            name='anemia_severe_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(862),
        ),
    ),
    'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_severe_anemia': Sequela(
        name='homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1081),
        me_id=me_id(3303),
        healthstate=Healthstate(
            name='anemia_severe_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(862),
        ),
    ),
    'hemoglobin_sc_disease_with_severe_anemia': Sequela(
        name='hemoglobin_sc_disease_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1091),
        me_id=me_id(3313),
        healthstate=Healthstate(
            name='anemia_severe_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(862),
        ),
    ),
    'mild_sickle_cell_beta_thalassemia_with_severe_anemia': Sequela(
        name='mild_sickle_cell_beta_thalassemia_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1101),
        me_id=me_id(3323),
        healthstate=Healthstate(
            name='anemia_severe_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(862),
        ),
    ),
    'early_hiv_with_severe_anemia': Sequela(
        name='early_hiv_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5057),
        me_id=me_id(16323),
        healthstate=Healthstate(
            name='anemia_severe_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(862),
        ),
    ),
    'mild_angina_due_to_ischemic_heart_disease': Sequela(
        name='mild_angina_due_to_ischemic_heart_disease',
        kind='sequela',
        gbd_id=s_id(380),
        me_id=me_id(1818),
        healthstate=Healthstate(
            name='angina_pectoris_mild',
            kind='healthstate',
            gbd_id=hs_id(376),
        ),
    ),
    'moderate_angina_due_to_ischemic_heart_disease': Sequela(
        name='moderate_angina_due_to_ischemic_heart_disease',
        kind='sequela',
        gbd_id=s_id(381),
        me_id=me_id(1819),
        healthstate=Healthstate(
            name='angina_pectoris_moderate',
            kind='healthstate',
            gbd_id=hs_id(377),
        ),
    ),
    'severe_angina_due_to_ischemic_heart_disease': Sequela(
        name='severe_angina_due_to_ischemic_heart_disease',
        kind='sequela',
        gbd_id=s_id(382),
        me_id=me_id(1820),
        healthstate=Healthstate(
            name='angina_pectoris_severe',
            kind='healthstate',
            gbd_id=hs_id(378),
        ),
    ),
    'anorexia_nervosa': Sequela(
        name='anorexia_nervosa',
        kind='sequela',
        gbd_id=s_id(483),
        me_id=me_id(1993),
        healthstate=Healthstate(
            name='anorexia_nervosa',
            kind='healthstate',
            gbd_id=hs_id(444),
        ),
    ),
    'mild_anxiety_disorders': Sequela(
        name='mild_anxiety_disorders',
        kind='sequela',
        gbd_id=s_id(480),
        me_id=me_id(1990),
        healthstate=Healthstate(
            name='anxiety_disorders_mild',
            kind='healthstate',
            gbd_id=hs_id(434),
        ),
    ),
    'mild_other_mental_disorders': Sequela(
        name='mild_other_mental_disorders',
        kind='sequela',
        gbd_id=s_id(492),
        me_id=me_id(2004),
        healthstate=Healthstate(
            name='anxiety_disorders_mild',
            kind='healthstate',
            gbd_id=hs_id(434),
        ),
    ),
    'moderate_anxiety_disorders': Sequela(
        name='moderate_anxiety_disorders',
        kind='sequela',
        gbd_id=s_id(481),
        me_id=me_id(1991),
        healthstate=Healthstate(
            name='anxiety_disorders_moderate',
            kind='healthstate',
            gbd_id=hs_id(435),
        ),
    ),
    'moderate_other_mental_disorders': Sequela(
        name='moderate_other_mental_disorders',
        kind='sequela',
        gbd_id=s_id(680),
        me_id=me_id(2645),
        healthstate=Healthstate(
            name='anxiety_disorders_moderate',
            kind='healthstate',
            gbd_id=hs_id(435),
        ),
    ),
    'severe_anxiety_disorders': Sequela(
        name='severe_anxiety_disorders',
        kind='sequela',
        gbd_id=s_id(482),
        me_id=me_id(1992),
        healthstate=Healthstate(
            name='anxiety_disorders_severe',
            kind='healthstate',
            gbd_id=hs_id(436),
        ),
    ),
    'severe_other_mental_disorders': Sequela(
        name='severe_other_mental_disorders',
        kind='sequela',
        gbd_id=s_id(681),
        me_id=me_id(2646),
        healthstate=Healthstate(
            name='anxiety_disorders_severe',
            kind='healthstate',
            gbd_id=hs_id(436),
        ),
    ),
    'controlled_asthma': Sequela(
        name='controlled_asthma',
        kind='sequela',
        gbd_id=s_id(431),
        me_id=me_id(1908),
        healthstate=Healthstate(
            name='asthma_controlled',
            kind='healthstate',
            gbd_id=hs_id(402),
        ),
    ),
    'partially_controlled_asthma': Sequela(
        name='partially_controlled_asthma',
        kind='sequela',
        gbd_id=s_id(432),
        me_id=me_id(1909),
        healthstate=Healthstate(
            name='asthma_partially_controlled',
            kind='healthstate',
            gbd_id=hs_id(403),
        ),
    ),
    'uncontrolled_asthma': Sequela(
        name='uncontrolled_asthma',
        kind='sequela',
        gbd_id=s_id(433),
        me_id=me_id(1910),
        healthstate=Healthstate(
            name='asthma_uncontrolled',
            kind='healthstate',
            gbd_id=hs_id(404),
        ),
    ),
    'prevalence_of_detectable_microfiliaria_due_to_lymphatic_filariasis': Sequela(
        name='prevalence_of_detectable_microfiliaria_due_to_lymphatic_filariasis',
        kind='sequela',
        gbd_id=s_id(149),
        me_id=me_id(10519),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_atrial_fibrillation_and_flutter': Sequela(
        name='asymptomatic_atrial_fibrillation_and_flutter',
        kind='sequela',
        gbd_id=s_id(809),
        me_id=me_id(2837),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'attention_deficit_hyperactivity_disorder_currently_without_symptoms': Sequela(
        name='attention_deficit_hyperactivity_disorder_currently_without_symptoms',
        kind='sequela',
        gbd_id=s_id(811),
        me_id=me_id(2853),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_alcohol_dependence': Sequela(
        name='asymptomatic_alcohol_dependence',
        kind='sequela',
        gbd_id=s_id(812),
        me_id=me_id(2854),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_fetal_alcohol_syndrome': Sequela(
        name='asymptomatic_fetal_alcohol_syndrome',
        kind='sequela',
        gbd_id=s_id(813),
        me_id=me_id(2855),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'anxiety_disorders_currently_without_symptoms': Sequela(
        name='anxiety_disorders_currently_without_symptoms',
        kind='sequela',
        gbd_id=s_id(814),
        me_id=me_id(2856),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'conduct_disorder_currently_without_symptoms': Sequela(
        name='conduct_disorder_currently_without_symptoms',
        kind='sequela',
        gbd_id=s_id(816),
        me_id=me_id(2858),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_cannabis_dependence': Sequela(
        name='asymptomatic_cannabis_dependence',
        kind='sequela',
        gbd_id=s_id(817),
        me_id=me_id(2859),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_opioid_dependence': Sequela(
        name='asymptomatic_opioid_dependence',
        kind='sequela',
        gbd_id=s_id(818),
        me_id=me_id(2860),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_cocaine_dependence': Sequela(
        name='asymptomatic_cocaine_dependence',
        kind='sequela',
        gbd_id=s_id(819),
        me_id=me_id(2861),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'dysthymia_currently_without_symptoms': Sequela(
        name='dysthymia_currently_without_symptoms',
        kind='sequela',
        gbd_id=s_id(821),
        me_id=me_id(2863),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'major_depressive_disorder_currently_without_symptoms': Sequela(
        name='major_depressive_disorder_currently_without_symptoms',
        kind='sequela',
        gbd_id=s_id(822),
        me_id=me_id(2864),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_gout': Sequela(
        name='asymptomatic_gout',
        kind='sequela',
        gbd_id=s_id(824),
        me_id=me_id(2866),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_asthma': Sequela(
        name='asymptomatic_asthma',
        kind='sequela',
        gbd_id=s_id(830),
        me_id=me_id(2873),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_genital_herpes': Sequela(
        name='asymptomatic_genital_herpes',
        kind='sequela',
        gbd_id=s_id(831),
        me_id=me_id(2888),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_endometriosis': Sequela(
        name='asymptomatic_endometriosis',
        kind='sequela',
        gbd_id=s_id(832),
        me_id=me_id(9744),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_amphetamine_dependence': Sequela(
        name='asymptomatic_amphetamine_dependence',
        kind='sequela',
        gbd_id=s_id(833),
        me_id=me_id(2890),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_other_cardiovascular_diseases': Sequela(
        name='asymptomatic_other_cardiovascular_diseases',
        kind='sequela',
        gbd_id=s_id(839),
        me_id=me_id(2909),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_other_gynecological_disorders': Sequela(
        name='asymptomatic_other_gynecological_disorders',
        kind='sequela',
        gbd_id=s_id(843),
        me_id=me_id(2914),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'other_mental_disorders_currently_without_symptoms': Sequela(
        name='other_mental_disorders_currently_without_symptoms',
        kind='sequela',
        gbd_id=s_id(851),
        me_id=me_id(2927),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_premenstrual_syndrome': Sequela(
        name='asymptomatic_premenstrual_syndrome',
        kind='sequela',
        gbd_id=s_id(853),
        me_id=me_id(2934),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_polycystic_ovarian_syndrome': Sequela(
        name='asymptomatic_polycystic_ovarian_syndrome',
        kind='sequela',
        gbd_id=s_id(855),
        me_id=me_id(9741),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_genital_prolapse': Sequela(
        name='asymptomatic_genital_prolapse',
        kind='sequela',
        gbd_id=s_id(858),
        me_id=me_id(2939),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_acute_hepatitis_a': Sequela(
        name='asymptomatic_acute_hepatitis_a',
        kind='sequela',
        gbd_id=s_id(862),
        me_id=me_id(2943),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_acute_hepatitis_b': Sequela(
        name='asymptomatic_acute_hepatitis_b',
        kind='sequela',
        gbd_id=s_id(863),
        me_id=me_id(2944),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_acute_hepatitis_c': Sequela(
        name='asymptomatic_acute_hepatitis_c',
        kind='sequela',
        gbd_id=s_id(864),
        me_id=me_id(2945),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_acute_hepatitis_e': Sequela(
        name='asymptomatic_acute_hepatitis_e',
        kind='sequela',
        gbd_id=s_id(865),
        me_id=me_id(2946),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_retinopathy_of_prematurity': Sequela(
        name='asymptomatic_retinopathy_of_prematurity',
        kind='sequela',
        gbd_id=s_id(866),
        me_id=me_id(2947),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_other_skin_and_subcutaneous_diseases': Sequela(
        name='asymptomatic_other_skin_and_subcutaneous_diseases',
        kind='sequela',
        gbd_id=s_id(898),
        me_id=me_id(2981),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'chronic_hepatitis_b_without_cirrhosis': Sequela(
        name='chronic_hepatitis_b_without_cirrhosis',
        kind='sequela',
        gbd_id=s_id(902),
        me_id=me_id(20169),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'chronic_hepatitis_c_without_cirrhosis': Sequela(
        name='chronic_hepatitis_c_without_cirrhosis',
        kind='sequela',
        gbd_id=s_id(903),
        me_id=me_id(20170),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_endocrine_metabolic_blood_and_immune_disorders': Sequela(
        name='asymptomatic_endocrine_metabolic_blood_and_immune_disorders',
        kind='sequela',
        gbd_id=s_id(904),
        me_id=me_id(2995),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_turner_syndrome': Sequela(
        name='asymptomatic_turner_syndrome',
        kind='sequela',
        gbd_id=s_id(914),
        me_id=me_id(3021),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_chlamydial_infection': Sequela(
        name='asymptomatic_chlamydial_infection',
        kind='sequela',
        gbd_id=s_id(918),
        me_id=me_id(3043),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_gonococcal_infection': Sequela(
        name='asymptomatic_gonococcal_infection',
        kind='sequela',
        gbd_id=s_id(920),
        me_id=me_id(3045),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_trichomoniasis_infection': Sequela(
        name='asymptomatic_trichomoniasis_infection',
        kind='sequela',
        gbd_id=s_id(922),
        me_id=me_id(3047),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_chronic_obstructive_pulmonary_disease': Sequela(
        name='asymptomatic_chronic_obstructive_pulmonary_disease',
        kind='sequela',
        gbd_id=s_id(929),
        me_id=me_id(3065),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_down_syndrome': Sequela(
        name='asymptomatic_down_syndrome',
        kind='sequela',
        gbd_id=s_id(930),
        me_id=me_id(9829),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_other_chromosomal_abnormalities': Sequela(
        name='asymptomatic_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(931),
        me_id=me_id(9854),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_klinefelter_syndrome': Sequela(
        name='asymptomatic_klinefelter_syndrome',
        kind='sequela',
        gbd_id=s_id(933),
        me_id=me_id(3070),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_chagas_disease': Sequela(
        name='asymptomatic_chagas_disease',
        kind='sequela',
        gbd_id=s_id(935),
        me_id=me_id(3077),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_caries_of_deciduous_teeth': Sequela(
        name='asymptomatic_caries_of_deciduous_teeth',
        kind='sequela',
        gbd_id=s_id(943),
        me_id=me_id(3091),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_caries_of_permanent_teeth': Sequela(
        name='asymptomatic_caries_of_permanent_teeth',
        kind='sequela',
        gbd_id=s_id(944),
        me_id=me_id(3092),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_edentulism_and_severe_tooth_loss': Sequela(
        name='asymptomatic_edentulism_and_severe_tooth_loss',
        kind='sequela',
        gbd_id=s_id(945),
        me_id=me_id(3093),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_chronic_ischemic_stroke': Sequela(
        name='asymptomatic_chronic_ischemic_stroke',
        kind='sequela',
        gbd_id=s_id(946),
        me_id=me_id(3095),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_chronic_intracerebral_hemorrhage': Sequela(
        name='asymptomatic_chronic_intracerebral_hemorrhage',
        kind='sequela',
        gbd_id=s_id(947),
        me_id=me_id(3096),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_silicosis': Sequela(
        name='asymptomatic_silicosis',
        kind='sequela',
        gbd_id=s_id(948),
        me_id=me_id(3097),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_asbestosis': Sequela(
        name='asymptomatic_asbestosis',
        kind='sequela',
        gbd_id=s_id(949),
        me_id=me_id(3098),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_coal_workers_pneumoconiosis': Sequela(
        name='asymptomatic_coal_workers_pneumoconiosis',
        kind='sequela',
        gbd_id=s_id(950),
        me_id=me_id(3099),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_other_pneumoconiosis': Sequela(
        name='asymptomatic_other_pneumoconiosis',
        kind='sequela',
        gbd_id=s_id(951),
        me_id=me_id(3100),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_interstitial_lung_disease_and_pulmonary_sarcoidosis': Sequela(
        name='asymptomatic_interstitial_lung_disease_and_pulmonary_sarcoidosis',
        kind='sequela',
        gbd_id=s_id(952),
        me_id=me_id(3101),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_angina_due_to_ischemic_heart_disease': Sequela(
        name='asymptomatic_angina_due_to_ischemic_heart_disease',
        kind='sequela',
        gbd_id=s_id(953),
        me_id=me_id(3102),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_onchocerciasis': Sequela(
        name='asymptomatic_onchocerciasis',
        kind='sequela',
        gbd_id=s_id(956),
        me_id=me_id(3107),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_ascariasis': Sequela(
        name='asymptomatic_ascariasis',
        kind='sequela',
        gbd_id=s_id(957),
        me_id=me_id(3109),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_trichuriasis': Sequela(
        name='asymptomatic_trichuriasis',
        kind='sequela',
        gbd_id=s_id(958),
        me_id=me_id(3110),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_clonorchiasis': Sequela(
        name='asymptomatic_clonorchiasis',
        kind='sequela',
        gbd_id=s_id(959),
        me_id=me_id(3112),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_fascioliasis': Sequela(
        name='asymptomatic_fascioliasis',
        kind='sequela',
        gbd_id=s_id(960),
        me_id=me_id(3113),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_intestinal_fluke_infection': Sequela(
        name='asymptomatic_intestinal_fluke_infection',
        kind='sequela',
        gbd_id=s_id(961),
        me_id=me_id(3114),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_opisthorchiasis': Sequela(
        name='asymptomatic_opisthorchiasis',
        kind='sequela',
        gbd_id=s_id(962),
        me_id=me_id(3115),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_paragonimiasis': Sequela(
        name='asymptomatic_paragonimiasis',
        kind='sequela',
        gbd_id=s_id(963),
        me_id=me_id(3116),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_peripheral_arterial_disease': Sequela(
        name='asymptomatic_peripheral_arterial_disease',
        kind='sequela',
        gbd_id=s_id(964),
        me_id=me_id(3118),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_benign_prostatic_hyperplasia': Sequela(
        name='asymptomatic_benign_prostatic_hyperplasia',
        kind='sequela',
        gbd_id=s_id(965),
        me_id=me_id(3119),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_uterine_fibroids': Sequela(
        name='asymptomatic_uterine_fibroids',
        kind='sequela',
        gbd_id=s_id(967),
        me_id=me_id(3121),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_other_musculoskeletal_disorders': Sequela(
        name='asymptomatic_other_musculoskeletal_disorders',
        kind='sequela',
        gbd_id=s_id(968),
        me_id=me_id(3123),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_hookworm_disease': Sequela(
        name='asymptomatic_hookworm_disease',
        kind='sequela',
        gbd_id=s_id(974),
        me_id=me_id(3139),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'stage_3_chronic_kidney_disease_without_anemia_due_to_hypertension': Sequela(
        name='stage_3_chronic_kidney_disease_without_anemia_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(1019),
        me_id=me_id(3194),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'stage_3_chronic_kidney_disease_without_anemia_due_to_glomerulonephritis': Sequela(
        name='stage_3_chronic_kidney_disease_without_anemia_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(1027),
        me_id=me_id(3205),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'stage_3_chronic_kidney_disease_without_anemia_due_to_other_causes': Sequela(
        name='stage_3_chronic_kidney_disease_without_anemia_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(1035),
        me_id=me_id(3216),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_ischemic_heart_disease_following_myocardial_infarction': Sequela(
        name='asymptomatic_ischemic_heart_disease_following_myocardial_infarction',
        kind='sequela',
        gbd_id=s_id(1040),
        me_id=me_id(3233),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_seborrhoeic_dermatitis': Sequela(
        name='asymptomatic_seborrhoeic_dermatitis',
        kind='sequela',
        gbd_id=s_id(1046),
        me_id=me_id(3250),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_contact_dermatitis': Sequela(
        name='asymptomatic_contact_dermatitis',
        kind='sequela',
        gbd_id=s_id(1047),
        me_id=me_id(3251),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_b_thalassemia_trait': Sequela(
        name='asymptomatic_b_thalassemia_trait',
        kind='sequela',
        gbd_id=s_id(1050),
        me_id=me_id(3255),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_hemoglobin_e_trait': Sequela(
        name='asymptomatic_hemoglobin_e_trait',
        kind='sequela',
        gbd_id=s_id(1051),
        me_id=me_id(3256),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_sickle_cell_trait': Sequela(
        name='asymptomatic_sickle_cell_trait',
        kind='sequela',
        gbd_id=s_id(1052),
        me_id=me_id(3257),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_hemizygous_g6pd_trait': Sequela(
        name='asymptomatic_hemizygous_g6pd_trait',
        kind='sequela',
        gbd_id=s_id(1053),
        me_id=me_id(3258),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_malaria_parasitemia_pfpr': Sequela(
        name='asymptomatic_malaria_parasitemia_pfpr',
        kind='sequela',
        gbd_id=s_id(1056),
        me_id=me_id(3266),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_yellow_fever': Sequela(
        name='asymptomatic_yellow_fever',
        kind='sequela',
        gbd_id=s_id(1112),
        me_id=me_id(3338),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_g6pd_deficiency': Sequela(
        name='asymptomatic_g6pd_deficiency',
        kind='sequela',
        gbd_id=s_id(1126),
        me_id=me_id(3356),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_gallbladder_and_biliary_diseases': Sequela(
        name='asymptomatic_gallbladder_and_biliary_diseases',
        kind='sequela',
        gbd_id=s_id(1135),
        me_id=me_id(9535),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_early_syphilis_infection': Sequela(
        name='asymptomatic_early_syphilis_infection',
        kind='sequela',
        gbd_id=s_id(1202),
        me_id=me_id(3949),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_neonatal_preterm_birth_less_than_28_weeks': Sequela(
        name='asymptomatic_neonatal_preterm_birth_less_than_28_weeks',
        kind='sequela',
        gbd_id=s_id(1246),
        me_id=me_id(9978),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_neonatal_preterm_birth_28_less_than_32_wks': Sequela(
        name='asymptomatic_neonatal_preterm_birth_28_less_than_32_wks',
        kind='sequela',
        gbd_id=s_id(1247),
        me_id=me_id(9979),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_neonatal_preterm_birth_32_less_than_37wks': Sequela(
        name='asymptomatic_neonatal_preterm_birth_32_less_than_37wks',
        kind='sequela',
        gbd_id=s_id(1248),
        me_id=me_id(9980),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='asymptomatic_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(1249),
        me_id=me_id(9981),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='asymptomatic_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1250),
        me_id=me_id(9982),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_acute_other_sense_organ_diseases': Sequela(
        name='asymptomatic_acute_other_sense_organ_diseases',
        kind='sequela',
        gbd_id=s_id(1333),
        me_id=me_id(10311),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_chronic_other_sense_organ_diseases': Sequela(
        name='asymptomatic_chronic_other_sense_organ_diseases',
        kind='sequela',
        gbd_id=s_id(1337),
        me_id=me_id(10315),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_medication_overuse_headache_due_to_migraine': Sequela(
        name='asymptomatic_medication_overuse_headache_due_to_migraine',
        kind='sequela',
        gbd_id=s_id(1346),
        me_id=me_id(10848),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_medication_overuse_headache_due_to_tension_type_headache': Sequela(
        name='asymptomatic_medication_overuse_headache_due_to_tension_type_headache',
        kind='sequela',
        gbd_id=s_id(1352),
        me_id=me_id(10851),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_zika_infection': Sequela(
        name='asymptomatic_zika_infection',
        kind='sequela',
        gbd_id=s_id(1520),
        me_id=me_id(11028),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_congenital_diaphragmatic_hernia': Sequela(
        name='asymptomatic_congenital_diaphragmatic_hernia',
        kind='sequela',
        gbd_id=s_id(1601),
        me_id=me_id(11077),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_congenital_atresia_and_or_stenosis_of_the_digestive_tract': Sequela(
        name='asymptomatic_congenital_atresia_and_or_stenosis_of_the_digestive_tract',
        kind='sequela',
        gbd_id=s_id(1649),
        me_id=me_id(11154),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_congenital_malformations_of_the_abdominal_wall_after_treatment': Sequela(
        name='asymptomatic_congenital_malformations_of_the_abdominal_wall_after_treatment',
        kind='sequela',
        gbd_id=s_id(1673),
        me_id=me_id(11162),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_other_congenital_malformations_of_the_digestive_tract': Sequela(
        name='asymptomatic_other_congenital_malformations_of_the_digestive_tract',
        kind='sequela',
        gbd_id=s_id(1697),
        me_id=me_id(11170),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_congenital_genital_anomalies': Sequela(
        name='asymptomatic_congenital_genital_anomalies',
        kind='sequela',
        gbd_id=s_id(1709),
        me_id=me_id(11031),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='asymptomatic_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(1757),
        me_id=me_id(11392),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_congenital_anomalies_of_the_urinary_tract': Sequela(
        name='asymptomatic_congenital_anomalies_of_the_urinary_tract',
        kind='sequela',
        gbd_id=s_id(1850),
        me_id=me_id(11361),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_encephalocele_following_treatment': Sequela(
        name='asymptomatic_encephalocele_following_treatment',
        kind='sequela',
        gbd_id=s_id(1907),
        me_id=me_id(11268),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'moderate_wasting_without_edema': Sequela(
        name='moderate_wasting_without_edema',
        kind='sequela',
        gbd_id=s_id(2033),
        me_id=me_id(10981),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_vitamin_a_deficiency': Sequela(
        name='asymptomatic_vitamin_a_deficiency',
        kind='sequela',
        gbd_id=s_id(2189),
        me_id=me_id(11610),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'latent_tuberculosis_infection': Sequela(
        name='latent_tuberculosis_infection',
        kind='sequela',
        gbd_id=s_id(2192),
        me_id=me_id(24730),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_ulcerative_colitis': Sequela(
        name='asymptomatic_ulcerative_colitis',
        kind='sequela',
        gbd_id=s_id(4604),
        me_id=me_id(16289),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_crohns_disease': Sequela(
        name='asymptomatic_crohns_disease',
        kind='sequela',
        gbd_id=s_id(4607),
        me_id=me_id(16291),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_multiple_sclerosis': Sequela(
        name='asymptomatic_multiple_sclerosis',
        kind='sequela',
        gbd_id=s_id(4949),
        me_id=me_id(15810),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_pud_with_no_anemia': Sequela(
        name='asymptomatic_pud_with_no_anemia',
        kind='sequela',
        gbd_id=s_id(5045),
        me_id=me_id(16219),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_gastritis_duodenitis_with_no_anemia': Sequela(
        name='asymptomatic_gastritis_duodenitis_with_no_anemia',
        kind='sequela',
        gbd_id=s_id(5048),
        me_id=me_id(16235),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_compensated': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_compensated',
        kind='sequela',
        gbd_id=s_id(5135),
        me_id=me_id(11655),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_compensated': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_compensated',
        kind='sequela',
        gbd_id=s_id(5138),
        me_id=me_id(11656),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_compensated': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_compensated',
        kind='sequela',
        gbd_id=s_id(5141),
        me_id=me_id(11657),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_other_cause_compensated': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_other_cause_compensated',
        kind='sequela',
        gbd_id=s_id(5144),
        me_id=me_id(11658),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_adult_tertiary_syphilis': Sequela(
        name='asymptomatic_adult_tertiary_syphilis',
        kind='sequela',
        gbd_id=s_id(5156),
        me_id=me_id(16416),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_chronic_subarachnoid_hemorrhage': Sequela(
        name='asymptomatic_chronic_subarachnoid_hemorrhage',
        kind='sequela',
        gbd_id=s_id(5183),
        me_id=me_id(19566),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'stage_3_chronic_kidney_disease_without_anemia_due_to_type_1_diabetes_mellitus': Sequela(
        name='stage_3_chronic_kidney_disease_without_anemia_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5231),
        me_id=me_id(19415),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'stage_3_chronic_kidney_disease_without_anemia_due_to_type_2_diabetes_mellitus': Sequela(
        name='stage_3_chronic_kidney_disease_without_anemia_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5234),
        me_id=me_id(19416),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_calcific_aortic_valve_disease': Sequela(
        name='asymptomatic_calcific_aortic_valve_disease',
        kind='sequela',
        gbd_id=s_id(5288),
        me_id=me_id(19386),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_degenerative_mitral_valve_disease': Sequela(
        name='asymptomatic_degenerative_mitral_valve_disease',
        kind='sequela',
        gbd_id=s_id(5303),
        me_id=me_id(19387),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_nash_compensated': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_nash_compensated',
        kind='sequela',
        gbd_id=s_id(5387),
        me_id=me_id(19681),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'benign_and_in_situ_intestinal_neoplasms': Sequela(
        name='benign_and_in_situ_intestinal_neoplasms',
        kind='sequela',
        gbd_id=s_id(5408),
        me_id=me_id(18760),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'benign_and_in_situ_cervical_and_uterine_neoplasms': Sequela(
        name='benign_and_in_situ_cervical_and_uterine_neoplasms',
        kind='sequela',
        gbd_id=s_id(5411),
        me_id=me_id(18761),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'other_benign_and_in_situ_neoplasms': Sequela(
        name='other_benign_and_in_situ_neoplasms',
        kind='sequela',
        gbd_id=s_id(5414),
        me_id=me_id(18762),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'non_alcoholic_fatty_liver_disease_nafld_non_alcoholic_steatohepatitis_nash': Sequela(
        name='non_alcoholic_fatty_liver_disease_nafld_non_alcoholic_steatohepatitis_nash',
        kind='sequela',
        gbd_id=s_id(5477),
        me_id=me_id(20089),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_type_1_diabetes_mellitus': Sequela(
        name='stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5540),
        me_id=me_id(19831),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_type_2_diabetes_mellitus': Sequela(
        name='stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5543),
        me_id=me_id(19832),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_hypertension': Sequela(
        name='stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(5546),
        me_id=me_id(19833),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_glomerulonephritis': Sequela(
        name='stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(5549),
        me_id=me_id(19834),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_other_causes': Sequela(
        name='stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(5552),
        me_id=me_id(19835),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'menstrual_disorders_without_anemia': Sequela(
        name='menstrual_disorders_without_anemia',
        kind='sequela',
        gbd_id=s_id(5558),
        me_id=me_id(19806),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_malaria_vivax_pvpr': Sequela(
        name='asymptomatic_malaria_vivax_pvpr',
        kind='sequela',
        gbd_id=s_id(5615),
        me_id=me_id(19398),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_rheumatoid_arthritis': Sequela(
        name='asymptomatic_rheumatoid_arthritis',
        kind='sequela',
        gbd_id=s_id(7163),
        me_id=me_id(20013),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_probable_migraine': Sequela(
        name='asymptomatic_probable_migraine',
        kind='sequela',
        gbd_id=s_id(7169),
        me_id=me_id(20184),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_definite_migraine': Sequela(
        name='asymptomatic_definite_migraine',
        kind='sequela',
        gbd_id=s_id(7175),
        me_id=me_id(20186),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_osteoarthritis_of_the_knee': Sequela(
        name='asymptomatic_osteoarthritis_of_the_knee',
        kind='sequela',
        gbd_id=s_id(7178),
        me_id=me_id(20012),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_osteoarthritis_of_the_hip': Sequela(
        name='asymptomatic_osteoarthritis_of_the_hip',
        kind='sequela',
        gbd_id=s_id(7181),
        me_id=me_id(20011),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'mild_to_moderate_gerd_asymptomatic_days': Sequela(
        name='mild_to_moderate_gerd_asymptomatic_days',
        kind='sequela',
        gbd_id=s_id(7187),
        me_id=me_id(20397),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'severe_gerd_asymptomatic_days': Sequela(
        name='severe_gerd_asymptomatic_days',
        kind='sequela',
        gbd_id=s_id(7193),
        me_id=me_id(20287),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_chronic_pancreatitis': Sequela(
        name='asymptomatic_chronic_pancreatitis',
        kind='sequela',
        gbd_id=s_id(7196),
        me_id=me_id(20290),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'basal_cell_carcinoma_without_disfigurement': Sequela(
        name='basal_cell_carcinoma_without_disfigurement',
        kind='sequela',
        gbd_id=s_id(7226),
        me_id=me_id(9757),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_symptomatic_inguinal_femoral_and_abdominal_hernia': Sequela(
        name='asymptomatic_symptomatic_inguinal_femoral_and_abdominal_hernia',
        kind='sequela',
        gbd_id=s_id(23049),
        me_id=me_id(9542),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_osteoarthritis_of_the_hand_and_foot': Sequela(
        name='asymptomatic_osteoarthritis_of_the_hand_and_foot',
        kind='sequela',
        gbd_id=s_id(23051),
        me_id=me_id(24817),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_osteoarthritis_other': Sequela(
        name='asymptomatic_osteoarthritis_other',
        kind='sequela',
        gbd_id=s_id(23052),
        me_id=me_id(24821),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_probable_tension_type_headache': Sequela(
        name='asymptomatic_probable_tension_type_headache',
        kind='sequela',
        gbd_id=s_id(23054),
        me_id=me_id(24388),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'asymptomatic_definite_tension_type_headache': Sequela(
        name='asymptomatic_definite_tension_type_headache',
        kind='sequela',
        gbd_id=s_id(23056),
        me_id=me_id(24390),
        healthstate=Healthstate(
            name='asymptomatic',
            kind='healthstate',
            gbd_id=hs_id(799),
        ),
    ),
    'mild_behavioral_problems_due_to_encephalitis': Sequela(
        name='mild_behavioral_problems_due_to_encephalitis',
        kind='sequela',
        gbd_id=s_id(793),
        me_id=me_id(2810),
        healthstate=Healthstate(
            name='attention_deficit_hyperactivity_disorder',
            kind='healthstate',
            gbd_id=hs_id(446),
        ),
    ),
    'symptomatic_attention_deficit_hyperactivity_disorder': Sequela(
        name='symptomatic_attention_deficit_hyperactivity_disorder',
        kind='sequela',
        gbd_id=s_id(810),
        me_id=me_id(2852),
        healthstate=Healthstate(
            name='attention_deficit_hyperactivity_disorder',
            kind='healthstate',
            gbd_id=hs_id(446),
        ),
    ),
    'mild_behavioral_problems_due_to_meningitis': Sequela(
        name='mild_behavioral_problems_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22873),
        me_id=me_id(24062),
        healthstate=Healthstate(
            name='attention_deficit_hyperactivity_disorder',
            kind='healthstate',
            gbd_id=hs_id(446),
        ),
    ),
    'autism_spectrum_disorders_with_borderline_intellectual_disability': Sequela(
        name='autism_spectrum_disorders_with_borderline_intellectual_disability',
        kind='sequela',
        gbd_id=s_id(1328),
        me_id=me_id(19788),
        healthstate=Healthstate(
            name='autism_spectrum_disorder_with_borderline_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(2618),
        ),
    ),
    'autism_spectrum_disorders_with_mild_intellectual_disability': Sequela(
        name='autism_spectrum_disorders_with_mild_intellectual_disability',
        kind='sequela',
        gbd_id=s_id(1329),
        me_id=me_id(19789),
        healthstate=Healthstate(
            name='autism_spectrum_disorder_with_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(2621),
        ),
    ),
    'autism_spectrum_disorders_with_moderate_intellectual_disability': Sequela(
        name='autism_spectrum_disorders_with_moderate_intellectual_disability',
        kind='sequela',
        gbd_id=s_id(1330),
        me_id=me_id(19790),
        healthstate=Healthstate(
            name='autism_spectrum_disorder_with_moderate_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(2624),
        ),
    ),
    'autism_spectrum_disorders_with_profound_intellectual_disability': Sequela(
        name='autism_spectrum_disorders_with_profound_intellectual_disability',
        kind='sequela',
        gbd_id=s_id(1332),
        me_id=me_id(19792),
        healthstate=Healthstate(
            name='autism_spectrum_disorder_with_profound_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(2630),
        ),
    ),
    'autism_spectrum_disorders_with_severe_intellectual_disability': Sequela(
        name='autism_spectrum_disorders_with_severe_intellectual_disability',
        kind='sequela',
        gbd_id=s_id(1331),
        me_id=me_id(19791),
        healthstate=Healthstate(
            name='autism_spectrum_disorder_with_severe_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(2627),
        ),
    ),
    'autism_spectrum_disorders_without_intellectual_disability': Sequela(
        name='autism_spectrum_disorders_without_intellectual_disability',
        kind='sequela',
        gbd_id=s_id(1327),
        me_id=me_id(19781),
        healthstate=Healthstate(
            name='autism_spectrum_disorder_without_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(2612),
        ),
    ),
    'most_severe_low_back_pain_with_leg_pain': Sequela(
        name='most_severe_low_back_pain_with_leg_pain',
        kind='sequela',
        gbd_id=s_id(554),
        me_id=me_id(2152),
        healthstate=Healthstate(
            name='back_pain_most_severe_with_leg_pain',
            kind='healthstate',
            gbd_id=hs_id(473),
        ),
    ),
    'most_severe_low_back_pain_without_leg_pain': Sequela(
        name='most_severe_low_back_pain_without_leg_pain',
        kind='sequela',
        gbd_id=s_id(555),
        me_id=me_id(2153),
        healthstate=Healthstate(
            name='back_pain_most_severe_without_leg_pain',
            kind='healthstate',
            gbd_id=hs_id(472),
        ),
    ),
    'severe_low_back_pain_with_leg_pain': Sequela(
        name='severe_low_back_pain_with_leg_pain',
        kind='sequela',
        gbd_id=s_id(552),
        me_id=me_id(2150),
        healthstate=Healthstate(
            name='back_pain_severe_with_leg_pain',
            kind='healthstate',
            gbd_id=hs_id(471),
        ),
    ),
    'severe_low_back_pain_without_leg_pain': Sequela(
        name='severe_low_back_pain_without_leg_pain',
        kind='sequela',
        gbd_id=s_id(553),
        me_id=me_id(2151),
        healthstate=Healthstate(
            name='back_pain_severe_without_leg_pain',
            kind='healthstate',
            gbd_id=hs_id(470),
        ),
    ),
    'symptomatic_benign_prostatic_hyperplasia': Sequela(
        name='symptomatic_benign_prostatic_hyperplasia',
        kind='sequela',
        gbd_id=s_id(966),
        me_id=me_id(3120),
        healthstate=Healthstate(
            name='benign_prostatic_hypertrophy_symptomatic_cases',
            kind='healthstate',
            gbd_id=hs_id(397),
        ),
    ),
    'bipolar_disorder_manic_state': Sequela(
        name='bipolar_disorder_manic_state',
        kind='sequela',
        gbd_id=s_id(478),
        me_id=me_id(1987),
        healthstate=Healthstate(
            name='bipolar_disorder_manic_episode',
            kind='healthstate',
            gbd_id=hs_id(440),
        ),
    ),
    'bipolar_disorder_residual_state': Sequela(
        name='bipolar_disorder_residual_state',
        kind='sequela',
        gbd_id=s_id(479),
        me_id=me_id(1988),
        healthstate=Healthstate(
            name='bipolar_disorder_residual_state',
            kind='healthstate',
            gbd_id=hs_id(441),
        ),
    ),
    'borderline_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='borderline_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1217),
        me_id=me_id(9824),
        healthstate=Healthstate(
            name='borderline_intellectual_disability_with_congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(897),
        ),
    ),
    'borderline_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='borderline_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1228),
        me_id=me_id(9848),
        healthstate=Healthstate(
            name='borderline_intellectual_disability_with_congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(897),
        ),
    ),
    'borderline_intellectual_disability_with_infertility_due_to_klinefelter_syndrome': Sequela(
        name='borderline_intellectual_disability_with_infertility_due_to_klinefelter_syndrome',
        kind='sequela',
        gbd_id=s_id(691),
        me_id=me_id(2659),
        healthstate=Healthstate(
            name='borderline_intellectual_disability_with_primary_infertility',
            kind='healthstate',
            gbd_id=hs_id(788),
        ),
    ),
    'borderline_idiopathic_developmental_intellectual_disability': Sequela(
        name='borderline_idiopathic_developmental_intellectual_disability',
        kind='sequela',
        gbd_id=s_id(487),
        me_id=me_id(1999),
        healthstate=Healthstate(
            name='borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(450),
        ),
    ),
    'borderline_intellectual_disability_due_to_klinefelter_syndrome': Sequela(
        name='borderline_intellectual_disability_due_to_klinefelter_syndrome',
        kind='sequela',
        gbd_id=s_id(572),
        me_id=me_id(2213),
        healthstate=Healthstate(
            name='borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(450),
        ),
    ),
    'borderline_intellectual_disability_due_to_encephalitis': Sequela(
        name='borderline_intellectual_disability_due_to_encephalitis',
        kind='sequela',
        gbd_id=s_id(796),
        me_id=me_id(3488),
        healthstate=Healthstate(
            name='borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(450),
        ),
    ),
    'borderline_intellectual_disability_due_to_down_syndrome': Sequela(
        name='borderline_intellectual_disability_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1212),
        me_id=me_id(9819),
        healthstate=Healthstate(
            name='borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(450),
        ),
    ),
    'borderline_intellectual_disability_due_to_other_chromosomal_abnormalities': Sequela(
        name='borderline_intellectual_disability_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1223),
        me_id=me_id(9843),
        healthstate=Healthstate(
            name='borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(450),
        ),
    ),
    'borderline_intellectual_disability_due_to_encephalocele': Sequela(
        name='borderline_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(1910),
        me_id=me_id(11269),
        healthstate=Healthstate(
            name='borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(450),
        ),
    ),
    'borderline_intellectual_disability_due_to_meningitis': Sequela(
        name='borderline_intellectual_disability_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22868),
        me_id=me_id(24055),
        healthstate=Healthstate(
            name='borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(450),
        ),
    ),
    'borderline_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='borderline_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(1928),
        me_id=me_id(11275),
        healthstate=Healthstate(
            name='borderline_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2369),
        ),
    ),
    'bulimia_nervosa': Sequela(
        name='bulimia_nervosa',
        kind='sequela',
        gbd_id=s_id(484),
        me_id=me_id(1994),
        healthstate=Healthstate(
            name='bulimia_nervosa',
            kind='healthstate',
            gbd_id=hs_id(445),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_esophageal_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_esophageal_cancer',
        kind='sequela',
        gbd_id=s_id(244),
        me_id=me_id(1670),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_stomach_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_stomach_cancer',
        kind='sequela',
        gbd_id=s_id(248),
        me_id=me_id(1674),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_hepatitis_b': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_hepatitis_b',
        kind='sequela',
        gbd_id=s_id(252),
        me_id=me_id(1682),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_hepatitis_c': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_hepatitis_c',
        kind='sequela',
        gbd_id=s_id(256),
        me_id=me_id(1686),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_alcohol_use': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_alcohol_use',
        kind='sequela',
        gbd_id=s_id(260),
        me_id=me_id(1690),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_other_causes': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(264),
        me_id=me_id(1694),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_larynx_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_larynx_cancer',
        kind='sequela',
        gbd_id=s_id(268),
        me_id=me_id(1698),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_lung_bronchus_and_trachea_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_lung_bronchus_and_trachea_cancer',
        kind='sequela',
        gbd_id=s_id(273),
        me_id=me_id(1703),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_breast_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_breast_cancer',
        kind='sequela',
        gbd_id=s_id(277),
        me_id=me_id(1707),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_cervical_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_cervical_cancer',
        kind='sequela',
        gbd_id=s_id(282),
        me_id=me_id(1712),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_uterine_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_uterine_cancer',
        kind='sequela',
        gbd_id=s_id(286),
        me_id=me_id(1716),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_prostate_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_prostate_cancer',
        kind='sequela',
        gbd_id=s_id(290),
        me_id=me_id(1720),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_colon_and_rectum_cancers': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_colon_and_rectum_cancers',
        kind='sequela',
        gbd_id=s_id(296),
        me_id=me_id(1727),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_mouth_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_mouth_cancer',
        kind='sequela',
        gbd_id=s_id(301),
        me_id=me_id(1732),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_nasopharynx_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_nasopharynx_cancer',
        kind='sequela',
        gbd_id=s_id(305),
        me_id=me_id(1736),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_other_pharynx_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_other_pharynx_cancer',
        kind='sequela',
        gbd_id=s_id(309),
        me_id=me_id(1740),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_gallbladder_and_biliary_tract_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_gallbladder_and_biliary_tract_cancer',
        kind='sequela',
        gbd_id=s_id(313),
        me_id=me_id(1744),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_pancreatic_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_pancreatic_cancer',
        kind='sequela',
        gbd_id=s_id(317),
        me_id=me_id(1748),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_malignant_skin_melanoma': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_malignant_skin_melanoma',
        kind='sequela',
        gbd_id=s_id(321),
        me_id=me_id(1752),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_ovarian_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_ovarian_cancer',
        kind='sequela',
        gbd_id=s_id(329),
        me_id=me_id(1761),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_testicular_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_testicular_cancer',
        kind='sequela',
        gbd_id=s_id(333),
        me_id=me_id(1765),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_kidney_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_kidney_cancer',
        kind='sequela',
        gbd_id=s_id(337),
        me_id=me_id(1769),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_bladder_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_bladder_cancer',
        kind='sequela',
        gbd_id=s_id(341),
        me_id=me_id(1773),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_brain_and_central_nervous_system_cancers': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_brain_and_central_nervous_system_cancers',
        kind='sequela',
        gbd_id=s_id(346),
        me_id=me_id(1778),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_thyroid_cancer': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_thyroid_cancer',
        kind='sequela',
        gbd_id=s_id(350),
        me_id=me_id(1782),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_mesothelioma': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_mesothelioma',
        kind='sequela',
        gbd_id=s_id(354),
        me_id=me_id(1786),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_hodgkin_disease': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_hodgkin_disease',
        kind='sequela',
        gbd_id=s_id(358),
        me_id=me_id(1790),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_multiple_myeloma': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_multiple_myeloma',
        kind='sequela',
        gbd_id=s_id(366),
        me_id=me_id(1798),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_acute_lymphoid_leukemia': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_acute_lymphoid_leukemia',
        kind='sequela',
        gbd_id=s_id(1186),
        me_id=me_id(9476),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_acute_myeloid_leukemia': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_acute_myeloid_leukemia',
        kind='sequela',
        gbd_id=s_id(1187),
        me_id=me_id(9486),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_chronic_lymphoid_leukemia': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_chronic_lymphoid_leukemia',
        kind='sequela',
        gbd_id=s_id(1188),
        me_id=me_id(9481),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_chronic_myeloid_leukemia': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_chronic_myeloid_leukemia',
        kind='sequela',
        gbd_id=s_id(1189),
        me_id=me_id(9491),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_other_leukemia': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_other_leukemia',
        kind='sequela',
        gbd_id=s_id(1484),
        me_id=me_id(10737),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_nash': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_nash',
        kind='sequela',
        gbd_id=s_id(5417),
        me_id=me_id(18764),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_other_malignant_neoplasms': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_other_malignant_neoplasms',
        kind='sequela',
        gbd_id=s_id(5864),
        me_id=me_id(19824),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_burkitt_lymphoma': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_burkitt_lymphoma',
        kind='sequela',
        gbd_id=s_id(22892),
        me_id=me_id(23778),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_other_non_hodgkin_lymphoma': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_other_non_hodgkin_lymphoma',
        kind='sequela',
        gbd_id=s_id(22896),
        me_id=me_id(23783),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_hepatoblastoma': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_hepatoblastoma',
        kind='sequela',
        gbd_id=s_id(22900),
        me_id=me_id(23788),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_retinoblastoma': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_retinoblastoma',
        kind='sequela',
        gbd_id=s_id(22912),
        me_id=me_id(23798),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_other_eye_cancers': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_other_eye_cancers',
        kind='sequela',
        gbd_id=s_id(22916),
        me_id=me_id(23803),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_soft_tissue_and_other_extraosseous_sarcomas': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_soft_tissue_and_other_extraosseous_sarcomas',
        kind='sequela',
        gbd_id=s_id(22920),
        me_id=me_id(23808),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_malignant_bone_tumors': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_malignant_bone_tumors',
        kind='sequela',
        gbd_id=s_id(22924),
        me_id=me_id(23813),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'diagnosis_and_primary_therapy_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors': Sequela(
        name='diagnosis_and_primary_therapy_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors',
        kind='sequela',
        gbd_id=s_id(22928),
        me_id=me_id(23818),
        healthstate=Healthstate(
            name='cancer_diagnosis_and_primary_therapy',
            kind='healthstate',
            gbd_id=hs_id(368),
        ),
    ),
    'metastatic_phase_of_esophageal_cancer': Sequela(
        name='metastatic_phase_of_esophageal_cancer',
        kind='sequela',
        gbd_id=s_id(246),
        me_id=me_id(1672),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_stomach_cancer': Sequela(
        name='metastatic_phase_of_stomach_cancer',
        kind='sequela',
        gbd_id=s_id(250),
        me_id=me_id(1676),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_liver_cancer_due_to_hepatitis_b': Sequela(
        name='metastatic_phase_of_liver_cancer_due_to_hepatitis_b',
        kind='sequela',
        gbd_id=s_id(254),
        me_id=me_id(1684),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_liver_cancer_due_to_hepatitis_c': Sequela(
        name='metastatic_phase_of_liver_cancer_due_to_hepatitis_c',
        kind='sequela',
        gbd_id=s_id(258),
        me_id=me_id(1688),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_liver_cancer_due_to_alcohol_use': Sequela(
        name='metastatic_phase_of_liver_cancer_due_to_alcohol_use',
        kind='sequela',
        gbd_id=s_id(262),
        me_id=me_id(1692),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_liver_cancer_due_to_other_causes': Sequela(
        name='metastatic_phase_of_liver_cancer_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(266),
        me_id=me_id(1696),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_larynx_cancer': Sequela(
        name='metastatic_phase_of_larynx_cancer',
        kind='sequela',
        gbd_id=s_id(270),
        me_id=me_id(1700),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_lung_bronchus_and_trachea_cancer': Sequela(
        name='metastatic_phase_of_lung_bronchus_and_trachea_cancer',
        kind='sequela',
        gbd_id=s_id(275),
        me_id=me_id(1705),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_breast_cancer': Sequela(
        name='metastatic_phase_of_breast_cancer',
        kind='sequela',
        gbd_id=s_id(279),
        me_id=me_id(1709),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_cervical_cancer': Sequela(
        name='metastatic_phase_of_cervical_cancer',
        kind='sequela',
        gbd_id=s_id(284),
        me_id=me_id(1714),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_uterine_cancer': Sequela(
        name='metastatic_phase_of_uterine_cancer',
        kind='sequela',
        gbd_id=s_id(288),
        me_id=me_id(1718),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_prostate_cancer': Sequela(
        name='metastatic_phase_of_prostate_cancer',
        kind='sequela',
        gbd_id=s_id(292),
        me_id=me_id(1722),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_colon_and_rectum_cancers': Sequela(
        name='metastatic_phase_of_colon_and_rectum_cancers',
        kind='sequela',
        gbd_id=s_id(298),
        me_id=me_id(1729),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_mouth_cancer': Sequela(
        name='metastatic_phase_of_mouth_cancer',
        kind='sequela',
        gbd_id=s_id(303),
        me_id=me_id(1734),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_nasopharynx_cancer': Sequela(
        name='metastatic_phase_of_nasopharynx_cancer',
        kind='sequela',
        gbd_id=s_id(307),
        me_id=me_id(1738),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_other_pharynx_cancer': Sequela(
        name='metastatic_phase_of_other_pharynx_cancer',
        kind='sequela',
        gbd_id=s_id(311),
        me_id=me_id(1742),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_gallbladder_and_biliary_tract_cancer': Sequela(
        name='metastatic_phase_of_gallbladder_and_biliary_tract_cancer',
        kind='sequela',
        gbd_id=s_id(315),
        me_id=me_id(1746),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_pancreatic_cancer': Sequela(
        name='metastatic_phase_of_pancreatic_cancer',
        kind='sequela',
        gbd_id=s_id(319),
        me_id=me_id(1750),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_malignant_skin_melanoma': Sequela(
        name='metastatic_phase_of_malignant_skin_melanoma',
        kind='sequela',
        gbd_id=s_id(323),
        me_id=me_id(1754),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_ovarian_cancer': Sequela(
        name='metastatic_phase_of_ovarian_cancer',
        kind='sequela',
        gbd_id=s_id(331),
        me_id=me_id(1763),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_testicular_cancer': Sequela(
        name='metastatic_phase_of_testicular_cancer',
        kind='sequela',
        gbd_id=s_id(335),
        me_id=me_id(1767),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_kidney_cancer': Sequela(
        name='metastatic_phase_of_kidney_cancer',
        kind='sequela',
        gbd_id=s_id(339),
        me_id=me_id(1771),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_bladder_cancer': Sequela(
        name='metastatic_phase_of_bladder_cancer',
        kind='sequela',
        gbd_id=s_id(343),
        me_id=me_id(1775),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_brain_and_central_nervous_system_cancers': Sequela(
        name='metastatic_phase_of_brain_and_central_nervous_system_cancers',
        kind='sequela',
        gbd_id=s_id(348),
        me_id=me_id(1780),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_thyroid_cancer': Sequela(
        name='metastatic_phase_of_thyroid_cancer',
        kind='sequela',
        gbd_id=s_id(352),
        me_id=me_id(1784),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_mesothelioma': Sequela(
        name='metastatic_phase_of_mesothelioma',
        kind='sequela',
        gbd_id=s_id(356),
        me_id=me_id(1788),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_hodgkin_disease': Sequela(
        name='metastatic_phase_of_hodgkin_disease',
        kind='sequela',
        gbd_id=s_id(360),
        me_id=me_id(1792),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_multiple_myeloma': Sequela(
        name='metastatic_phase_of_multiple_myeloma',
        kind='sequela',
        gbd_id=s_id(368),
        me_id=me_id(1800),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_acute_lymphoid_leukemia': Sequela(
        name='metastatic_phase_of_acute_lymphoid_leukemia',
        kind='sequela',
        gbd_id=s_id(1194),
        me_id=me_id(9478),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_acute_myeloid_leukemia': Sequela(
        name='metastatic_phase_of_acute_myeloid_leukemia',
        kind='sequela',
        gbd_id=s_id(1195),
        me_id=me_id(9488),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_chronic_lymphoid_leukemia': Sequela(
        name='metastatic_phase_of_chronic_lymphoid_leukemia',
        kind='sequela',
        gbd_id=s_id(1196),
        me_id=me_id(9483),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_chronic_myeloid_leukemia': Sequela(
        name='metastatic_phase_of_chronic_myeloid_leukemia',
        kind='sequela',
        gbd_id=s_id(1197),
        me_id=me_id(9493),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_other_leukemia': Sequela(
        name='metastatic_phase_of_other_leukemia',
        kind='sequela',
        gbd_id=s_id(1481),
        me_id=me_id(10739),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_liver_cancer_due_to_nash': Sequela(
        name='metastatic_phase_of_liver_cancer_due_to_nash',
        kind='sequela',
        gbd_id=s_id(5423),
        me_id=me_id(18766),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_other_malignant_neoplasms': Sequela(
        name='metastatic_phase_of_other_malignant_neoplasms',
        kind='sequela',
        gbd_id=s_id(5870),
        me_id=me_id(19826),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_burkitt_lymphoma': Sequela(
        name='metastatic_phase_of_burkitt_lymphoma',
        kind='sequela',
        gbd_id=s_id(22894),
        me_id=me_id(23780),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_other_non_hodgkin_lymphoma': Sequela(
        name='metastatic_phase_of_other_non_hodgkin_lymphoma',
        kind='sequela',
        gbd_id=s_id(22898),
        me_id=me_id(23785),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_hepatoblastoma': Sequela(
        name='metastatic_phase_of_hepatoblastoma',
        kind='sequela',
        gbd_id=s_id(22902),
        me_id=me_id(23790),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_retinoblastoma': Sequela(
        name='metastatic_phase_of_retinoblastoma',
        kind='sequela',
        gbd_id=s_id(22914),
        me_id=me_id(23800),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_other_eye_cancers': Sequela(
        name='metastatic_phase_of_other_eye_cancers',
        kind='sequela',
        gbd_id=s_id(22918),
        me_id=me_id(23805),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_soft_tissue_and_other_extraosseous_sarcomas': Sequela(
        name='metastatic_phase_of_soft_tissue_and_other_extraosseous_sarcomas',
        kind='sequela',
        gbd_id=s_id(22922),
        me_id=me_id(23810),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_malignant_bone_tumors': Sequela(
        name='metastatic_phase_of_malignant_bone_tumors',
        kind='sequela',
        gbd_id=s_id(22926),
        me_id=me_id(23815),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'metastatic_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors': Sequela(
        name='metastatic_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors',
        kind='sequela',
        gbd_id=s_id(22930),
        me_id=me_id(23820),
        healthstate=Healthstate(
            name='cancer_metastatic',
            kind='healthstate',
            gbd_id=hs_id(369),
        ),
    ),
    'severe_cannabis_dependence': Sequela(
        name='severe_cannabis_dependence',
        kind='sequela',
        gbd_id=s_id(807),
        me_id=me_id(2830),
        healthstate=Healthstate(
            name='cannabis_dependence',
            kind='healthstate',
            gbd_id=hs_id(430),
        ),
    ),
    'mild_cannabis_dependence': Sequela(
        name='mild_cannabis_dependence',
        kind='sequela',
        gbd_id=s_id(686),
        me_id=me_id(2651),
        healthstate=Healthstate(
            name='cannabis_dependence_mild',
            kind='healthstate',
            gbd_id=hs_id(586),
        ),
    ),
    'atrial_fibrillation_and_flutter_due_to_chagas_disease': Sequela(
        name='atrial_fibrillation_and_flutter_due_to_chagas_disease',
        kind='sequela',
        gbd_id=s_id(125),
        me_id=me_id(1452),
        healthstate=Healthstate(
            name='cardiac_conduction_disorders_and_cardiac_dysrhythmias',
            kind='healthstate',
            gbd_id=hs_id(379),
        ),
    ),
    'symptomatic_atrial_fibrillation_and_flutter': Sequela(
        name='symptomatic_atrial_fibrillation_and_flutter',
        kind='sequela',
        gbd_id=s_id(913),
        me_id=me_id(3007),
        healthstate=Healthstate(
            name='cardiac_conduction_disorders_and_cardiac_dysrhythmias',
            kind='healthstate',
            gbd_id=hs_id(379),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_hypertension': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(1418),
        me_id=me_id(10897),
        healthstate=Healthstate(
            name='chronic_kidney_disease_stage_iv',
            kind='healthstate',
            gbd_id=hs_id(391),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_glomerulonephritis': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(1430),
        me_id=me_id(10901),
        healthstate=Healthstate(
            name='chronic_kidney_disease_stage_iv',
            kind='healthstate',
            gbd_id=hs_id(391),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_other_causes': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(1442),
        me_id=me_id(10905),
        healthstate=Healthstate(
            name='chronic_kidney_disease_stage_iv',
            kind='healthstate',
            gbd_id=hs_id(391),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_type_1_diabetes_mellitus': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5255),
        me_id=me_id(19423),
        healthstate=Healthstate(
            name='chronic_kidney_disease_stage_iv',
            kind='healthstate',
            gbd_id=hs_id(391),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_type_2_diabetes_mellitus': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5258),
        me_id=me_id(19424),
        healthstate=Healthstate(
            name='chronic_kidney_disease_stage_iv',
            kind='healthstate',
            gbd_id=hs_id(391),
        ),
    ),
    'symptomatic_claudication_due_to_peripheral_arterial_disease': Sequela(
        name='symptomatic_claudication_due_to_peripheral_arterial_disease',
        kind='sequela',
        gbd_id=s_id(1041),
        me_id=me_id(3234),
        healthstate=Healthstate(
            name='claudication',
            kind='healthstate',
            gbd_id=hs_id(380),
        ),
    ),
    'severe_cocaine_dependence': Sequela(
        name='severe_cocaine_dependence',
        kind='sequela',
        gbd_id=s_id(805),
        me_id=me_id(2828),
        healthstate=Healthstate(
            name='cocaine_dependence',
            kind='healthstate',
            gbd_id=hs_id(432),
        ),
    ),
    'other_drug_use_disorders': Sequela(
        name='other_drug_use_disorders',
        kind='sequela',
        gbd_id=s_id(474),
        me_id=me_id(20416),
        healthstate=Healthstate(
            name='cocaine_dependence_mild',
            kind='healthstate',
            gbd_id=hs_id(580),
        ),
    ),
    'mild_cocaine_dependence': Sequela(
        name='mild_cocaine_dependence',
        kind='sequela',
        gbd_id=s_id(687),
        me_id=me_id(2652),
        healthstate=Healthstate(
            name='cocaine_dependence_mild',
            kind='healthstate',
            gbd_id=hs_id(580),
        ),
    ),
    'symptomatic_conduct_disorder': Sequela(
        name='symptomatic_conduct_disorder',
        kind='sequela',
        gbd_id=s_id(815),
        me_id=me_id(2857),
        healthstate=Healthstate(
            name='conduct_disorder',
            kind='healthstate',
            gbd_id=hs_id(447),
        ),
    ),
    'congenital_heart_disease_due_to_turner_syndrome': Sequela(
        name='congenital_heart_disease_due_to_turner_syndrome',
        kind='sequela',
        gbd_id=s_id(570),
        me_id=me_id(2207),
        healthstate=Healthstate(
            name='congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(574),
        ),
    ),
    'isolated_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='isolated_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(838),
        me_id=me_id(9830),
        healthstate=Healthstate(
            name='congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(574),
        ),
    ),
    'isolated_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='isolated_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(934),
        me_id=me_id(9855),
        healthstate=Healthstate(
            name='congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(574),
        ),
    ),
    'congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_other_congenital_cardiovascular_anomalies': Sequela(
        name='congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_other_congenital_cardiovascular_anomalies',
        kind='sequela',
        gbd_id=s_id(4640),
        me_id=me_id(15820),
        healthstate=Healthstate(
            name='congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(574),
        ),
    ),
    'congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4658),
        me_id=me_id(15844),
        healthstate=Healthstate(
            name='congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(574),
        ),
    ),
    'congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4730),
        me_id=me_id(15868),
        healthstate=Healthstate(
            name='congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(574),
        ),
    ),
    'congenital_heart_disease_without_heart_failure_or_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_without_heart_failure_or_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4802),
        me_id=me_id(15892),
        healthstate=Healthstate(
            name='congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(574),
        ),
    ),
    'congenital_heart_disease_without_heart_failure_or_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_without_heart_failure_or_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4874),
        me_id=me_id(15916),
        healthstate=Healthstate(
            name='congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(574),
        ),
    ),
    'congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies': Sequela(
        name='congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies',
        kind='sequela',
        gbd_id=s_id(4643),
        me_id=me_id(15821),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2519),
        ),
    ),
    'congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4661),
        me_id=me_id(15845),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2519),
        ),
    ),
    'congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4733),
        me_id=me_id(15869),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2519),
        ),
    ),
    'congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4805),
        me_id=me_id(15893),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2519),
        ),
    ),
    'congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4877),
        me_id=me_id(15917),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2519),
        ),
    ),
    'congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(5804),
        me_id=me_id(20046),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_borderline_intellectual_functioning_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2669),
        ),
    ),
    'congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(5807),
        me_id=me_id(20047),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_borderline_intellectual_functioning_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2669),
        ),
    ),
    'congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(5810),
        me_id=me_id(20048),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_borderline_intellectual_functioning_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2669),
        ),
    ),
    'congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(5813),
        me_id=me_id(20049),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_borderline_intellectual_functioning_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2669),
        ),
    ),
    'congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(5792),
        me_id=me_id(20042),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2666),
        ),
    ),
    'congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(5795),
        me_id=me_id(20043),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2666),
        ),
    ),
    'congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(5798),
        me_id=me_id(20044),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2666),
        ),
    ),
    'congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(5801),
        me_id=me_id(20045),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2666),
        ),
    ),
    'congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies': Sequela(
        name='congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies',
        kind='sequela',
        gbd_id=s_id(4646),
        me_id=me_id(15822),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_mild',
            kind='healthstate',
            gbd_id=hs_id(2522),
        ),
    ),
    'congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4664),
        me_id=me_id(15846),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_mild',
            kind='healthstate',
            gbd_id=hs_id(2522),
        ),
    ),
    'congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4736),
        me_id=me_id(15870),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_mild',
            kind='healthstate',
            gbd_id=hs_id(2522),
        ),
    ),
    'congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4808),
        me_id=me_id(15894),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_mild',
            kind='healthstate',
            gbd_id=hs_id(2522),
        ),
    ),
    'congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4880),
        me_id=me_id(15918),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_mild',
            kind='healthstate',
            gbd_id=hs_id(2522),
        ),
    ),
    'congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(5816),
        me_id=me_id(20050),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_mild_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2672),
        ),
    ),
    'congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(5819),
        me_id=me_id(20051),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_mild_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2672),
        ),
    ),
    'congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(5822),
        me_id=me_id(20052),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_mild_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2672),
        ),
    ),
    'congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(5825),
        me_id=me_id(20053),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_mild_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2672),
        ),
    ),
    'congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies': Sequela(
        name='congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies',
        kind='sequela',
        gbd_id=s_id(4649),
        me_id=me_id(15823),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_moderate',
            kind='healthstate',
            gbd_id=hs_id(2525),
        ),
    ),
    'congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4667),
        me_id=me_id(15847),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_moderate',
            kind='healthstate',
            gbd_id=hs_id(2525),
        ),
    ),
    'congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4739),
        me_id=me_id(15871),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_moderate',
            kind='healthstate',
            gbd_id=hs_id(2525),
        ),
    ),
    'congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4811),
        me_id=me_id(15895),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_moderate',
            kind='healthstate',
            gbd_id=hs_id(2525),
        ),
    ),
    'congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4883),
        me_id=me_id(15919),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_moderate',
            kind='healthstate',
            gbd_id=hs_id(2525),
        ),
    ),
    'congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(5828),
        me_id=me_id(20054),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_moderate_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2675),
        ),
    ),
    'congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(5831),
        me_id=me_id(20057),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_moderate_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2675),
        ),
    ),
    'congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(5834),
        me_id=me_id(20055),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_moderate_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2675),
        ),
    ),
    'congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(5837),
        me_id=me_id(20056),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_moderate_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2675),
        ),
    ),
    'congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies': Sequela(
        name='congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies',
        kind='sequela',
        gbd_id=s_id(4655),
        me_id=me_id(15825),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_profound',
            kind='healthstate',
            gbd_id=hs_id(2531),
        ),
    ),
    'congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4673),
        me_id=me_id(15849),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_profound',
            kind='healthstate',
            gbd_id=hs_id(2531),
        ),
    ),
    'congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4745),
        me_id=me_id(15873),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_profound',
            kind='healthstate',
            gbd_id=hs_id(2531),
        ),
    ),
    'congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4817),
        me_id=me_id(15897),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_profound',
            kind='healthstate',
            gbd_id=hs_id(2531),
        ),
    ),
    'congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4889),
        me_id=me_id(15921),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_profound',
            kind='healthstate',
            gbd_id=hs_id(2531),
        ),
    ),
    'congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(5852),
        me_id=me_id(20062),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_profound_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2681),
        ),
    ),
    'congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(5855),
        me_id=me_id(20063),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_profound_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2681),
        ),
    ),
    'congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(5858),
        me_id=me_id(20064),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_profound_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2681),
        ),
    ),
    'congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(5861),
        me_id=me_id(20065),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_profound_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2681),
        ),
    ),
    'congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies': Sequela(
        name='congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies',
        kind='sequela',
        gbd_id=s_id(4652),
        me_id=me_id(15824),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_severe',
            kind='healthstate',
            gbd_id=hs_id(2528),
        ),
    ),
    'congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4670),
        me_id=me_id(15848),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_severe',
            kind='healthstate',
            gbd_id=hs_id(2528),
        ),
    ),
    'congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4742),
        me_id=me_id(15872),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_severe',
            kind='healthstate',
            gbd_id=hs_id(2528),
        ),
    ),
    'congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4814),
        me_id=me_id(15896),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_severe',
            kind='healthstate',
            gbd_id=hs_id(2528),
        ),
    ),
    'congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4886),
        me_id=me_id(15920),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_severe',
            kind='healthstate',
            gbd_id=hs_id(2528),
        ),
    ),
    'congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(5840),
        me_id=me_id(20058),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_severe_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2678),
        ),
    ),
    'congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(5843),
        me_id=me_id(20061),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_severe_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2678),
        ),
    ),
    'congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(5846),
        me_id=me_id(20059),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_severe_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2678),
        ),
    ),
    'congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(5849),
        me_id=me_id(20060),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_intellectual_disability_mental_retardation_severe_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2678),
        ),
    ),
    'congenital_heart_disease_and_mild_dementia_due_to_down_syndrome': Sequela(
        name='congenital_heart_disease_and_mild_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1237),
        me_id=me_id(9818),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_mild_dementia',
            kind='healthstate',
            gbd_id=hs_id(911),
        ),
    ),
    'congenital_heart_disease_and_mild_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='congenital_heart_disease_and_mild_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1243),
        me_id=me_id(9842),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_mild_dementia',
            kind='healthstate',
            gbd_id=hs_id(911),
        ),
    ),
    'congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4676),
        me_id=me_id(15850),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2294),
        ),
    ),
    'congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4748),
        me_id=me_id(15874),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2294),
        ),
    ),
    'congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4820),
        me_id=me_id(15898),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2294),
        ),
    ),
    'congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4892),
        me_id=me_id(15922),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2294),
        ),
    ),
    'congenital_heart_disease_and_moderate_dementia_due_to_down_syndrome': Sequela(
        name='congenital_heart_disease_and_moderate_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1238),
        me_id=me_id(9944),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_moderate_dementia',
            kind='healthstate',
            gbd_id=hs_id(912),
        ),
    ),
    'congenital_heart_disease_and_moderate_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='congenital_heart_disease_and_moderate_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1244),
        me_id=me_id(9954),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_moderate_dementia',
            kind='healthstate',
            gbd_id=hs_id(912),
        ),
    ),
    'congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4694),
        me_id=me_id(15856),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2297),
        ),
    ),
    'congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4766),
        me_id=me_id(15880),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2297),
        ),
    ),
    'congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4838),
        me_id=me_id(15904),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2297),
        ),
    ),
    'congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4910),
        me_id=me_id(15928),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2297),
        ),
    ),
    'congenital_heart_disease_and_severe_dementia_due_to_down_syndrome': Sequela(
        name='congenital_heart_disease_and_severe_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1239),
        me_id=me_id(9945),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_severe_dementia',
            kind='healthstate',
            gbd_id=hs_id(913),
        ),
    ),
    'congenital_heart_disease_and_severe_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='congenital_heart_disease_and_severe_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1245),
        me_id=me_id(9955),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_severe_dementia',
            kind='healthstate',
            gbd_id=hs_id(913),
        ),
    ),
    'congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4712),
        me_id=me_id(15862),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2300),
        ),
    ),
    'congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4784),
        me_id=me_id(15886),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2300),
        ),
    ),
    'congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4856),
        me_id=me_id(15910),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2300),
        ),
    ),
    'congenital_heart_disease_and_severe_heart_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_and_severe_heart_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4928),
        me_id=me_id(15934),
        healthstate=Healthstate(
            name='congenital_heart_disease_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2300),
        ),
    ),
    'congenital_heart_disease_with_infertility_due_to_turner_syndrome': Sequela(
        name='congenital_heart_disease_with_infertility_due_to_turner_syndrome',
        kind='sequela',
        gbd_id=s_id(688),
        me_id=me_id(2653),
        healthstate=Healthstate(
            name='congenital_heart_disease_with_primary_infertility',
            kind='healthstate',
            gbd_id=hs_id(787),
        ),
    ),
    'congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4679),
        me_id=me_id(15851),
        healthstate=Healthstate(
            name='congenital_heart_disease_borderline_intellectual_functioning_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2303),
        ),
    ),
    'congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4751),
        me_id=me_id(15875),
        healthstate=Healthstate(
            name='congenital_heart_disease_borderline_intellectual_functioning_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2303),
        ),
    ),
    'congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4823),
        me_id=me_id(15899),
        healthstate=Healthstate(
            name='congenital_heart_disease_borderline_intellectual_functioning_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2303),
        ),
    ),
    'congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4895),
        me_id=me_id(15923),
        healthstate=Healthstate(
            name='congenital_heart_disease_borderline_intellectual_functioning_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2303),
        ),
    ),
    'congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4697),
        me_id=me_id(15857),
        healthstate=Healthstate(
            name='congenital_heart_disease_borderline_intellectual_functioning_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2306),
        ),
    ),
    'congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4769),
        me_id=me_id(15881),
        healthstate=Healthstate(
            name='congenital_heart_disease_borderline_intellectual_functioning_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2306),
        ),
    ),
    'congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4841),
        me_id=me_id(15905),
        healthstate=Healthstate(
            name='congenital_heart_disease_borderline_intellectual_functioning_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2306),
        ),
    ),
    'congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4913),
        me_id=me_id(15929),
        healthstate=Healthstate(
            name='congenital_heart_disease_borderline_intellectual_functioning_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2306),
        ),
    ),
    'borderline_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='borderline_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1267),
        me_id=me_id(10157),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_dementia_borderline_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(914),
        ),
    ),
    'borderline_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='borderline_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1282),
        me_id=me_id(10187),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_dementia_borderline_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(914),
        ),
    ),
    'mild_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='mild_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1268),
        me_id=me_id(10158),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_dementia_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(915),
        ),
    ),
    'mild_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='mild_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1283),
        me_id=me_id(10188),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_dementia_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(915),
        ),
    ),
    'moderate_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='moderate_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1269),
        me_id=me_id(10159),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_dementia_moderate_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(916),
        ),
    ),
    'moderate_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='moderate_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1284),
        me_id=me_id(10189),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_dementia_moderate_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(916),
        ),
    ),
    'profound_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='profound_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1271),
        me_id=me_id(10161),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_dementia_profound_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(918),
        ),
    ),
    'profound_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='profound_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1286),
        me_id=me_id(10191),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_dementia_profound_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(918),
        ),
    ),
    'severe_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='severe_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1270),
        me_id=me_id(10160),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_dementia_severe_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(917),
        ),
    ),
    'severe_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='severe_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1285),
        me_id=me_id(10190),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_dementia_severe_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(917),
        ),
    ),
    'congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4682),
        me_id=me_id(15852),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2312),
        ),
    ),
    'congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4754),
        me_id=me_id(15876),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2312),
        ),
    ),
    'congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4826),
        me_id=me_id(15900),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2312),
        ),
    ),
    'congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4898),
        me_id=me_id(15924),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2312),
        ),
    ),
    'congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4700),
        me_id=me_id(15858),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2315),
        ),
    ),
    'congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4772),
        me_id=me_id(15882),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2315),
        ),
    ),
    'congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4844),
        me_id=me_id(15906),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2315),
        ),
    ),
    'congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4916),
        me_id=me_id(15930),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2315),
        ),
    ),
    'congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4718),
        me_id=me_id(15864),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_intellectual_disability_and_servere_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2318),
        ),
    ),
    'congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4790),
        me_id=me_id(15888),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_intellectual_disability_and_servere_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2318),
        ),
    ),
    'congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4862),
        me_id=me_id(15912),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_intellectual_disability_and_servere_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2318),
        ),
    ),
    'congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4934),
        me_id=me_id(15936),
        healthstate=Healthstate(
            name='congenital_heart_disease_mild_intellectual_disability_and_servere_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2318),
        ),
    ),
    'borderline_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='borderline_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1272),
        me_id=me_id(10162),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_dementia_borderline_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(919),
        ),
    ),
    'borderline_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='borderline_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1287),
        me_id=me_id(10192),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_dementia_borderline_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(919),
        ),
    ),
    'mild_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='mild_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1273),
        me_id=me_id(10163),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_dementia_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(920),
        ),
    ),
    'mild_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='mild_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1288),
        me_id=me_id(10193),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_dementia_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(920),
        ),
    ),
    'moderate_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='moderate_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1274),
        me_id=me_id(10164),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_dementia_moderate_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(921),
        ),
    ),
    'moderate_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='moderate_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1289),
        me_id=me_id(10194),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_dementia_moderate_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(921),
        ),
    ),
    'profound_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='profound_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1276),
        me_id=me_id(10166),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_dementia_profound_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(923),
        ),
    ),
    'profound_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='profound_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1291),
        me_id=me_id(10196),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_dementia_profound_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(923),
        ),
    ),
    'severe_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='severe_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1275),
        me_id=me_id(10165),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_dementia_severe_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(922),
        ),
    ),
    'severe_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='severe_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1290),
        me_id=me_id(10195),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_dementia_severe_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(922),
        ),
    ),
    'congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4685),
        me_id=me_id(15853),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2321),
        ),
    ),
    'congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4757),
        me_id=me_id(15877),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2321),
        ),
    ),
    'congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4829),
        me_id=me_id(15901),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2321),
        ),
    ),
    'congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4901),
        me_id=me_id(15925),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2321),
        ),
    ),
    'congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4703),
        me_id=me_id(15859),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2324),
        ),
    ),
    'congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4775),
        me_id=me_id(15883),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2324),
        ),
    ),
    'congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4847),
        me_id=me_id(15907),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2324),
        ),
    ),
    'congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4919),
        me_id=me_id(15931),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2324),
        ),
    ),
    'congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4721),
        me_id=me_id(15865),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2327),
        ),
    ),
    'congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4793),
        me_id=me_id(15889),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2327),
        ),
    ),
    'congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4865),
        me_id=me_id(15913),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2327),
        ),
    ),
    'congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4937),
        me_id=me_id(15937),
        healthstate=Healthstate(
            name='congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2327),
        ),
    ),
    'congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4691),
        me_id=me_id(15855),
        healthstate=Healthstate(
            name='congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2339),
        ),
    ),
    'congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4763),
        me_id=me_id(15879),
        healthstate=Healthstate(
            name='congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2339),
        ),
    ),
    'congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4835),
        me_id=me_id(15903),
        healthstate=Healthstate(
            name='congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2339),
        ),
    ),
    'congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4907),
        me_id=me_id(15927),
        healthstate=Healthstate(
            name='congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2339),
        ),
    ),
    'congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4709),
        me_id=me_id(15861),
        healthstate=Healthstate(
            name='congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2342),
        ),
    ),
    'congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4781),
        me_id=me_id(15885),
        healthstate=Healthstate(
            name='congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2342),
        ),
    ),
    'congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4853),
        me_id=me_id(15909),
        healthstate=Healthstate(
            name='congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2342),
        ),
    ),
    'congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4925),
        me_id=me_id(15933),
        healthstate=Healthstate(
            name='congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2342),
        ),
    ),
    'congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4727),
        me_id=me_id(15867),
        healthstate=Healthstate(
            name='congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2345),
        ),
    ),
    'congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4799),
        me_id=me_id(15891),
        healthstate=Healthstate(
            name='congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2345),
        ),
    ),
    'congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4871),
        me_id=me_id(15915),
        healthstate=Healthstate(
            name='congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2345),
        ),
    ),
    'congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4943),
        me_id=me_id(15939),
        healthstate=Healthstate(
            name='congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2345),
        ),
    ),
    'borderline_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='borderline_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1277),
        me_id=me_id(10167),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_dementia_borderline_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(924),
        ),
    ),
    'borderline_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='borderline_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1292),
        me_id=me_id(10197),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_dementia_borderline_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(924),
        ),
    ),
    'mild_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='mild_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1278),
        me_id=me_id(10168),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_dementia_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(925),
        ),
    ),
    'mild_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='mild_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1293),
        me_id=me_id(10198),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_dementia_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(925),
        ),
    ),
    'moderate_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='moderate_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1279),
        me_id=me_id(10169),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_dementia_moderate_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(926),
        ),
    ),
    'moderate_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='moderate_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1294),
        me_id=me_id(10199),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_dementia_moderate_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(926),
        ),
    ),
    'profound_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='profound_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1281),
        me_id=me_id(10171),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_dementia_profound_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(928),
        ),
    ),
    'profound_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='profound_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1296),
        me_id=me_id(10201),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_dementia_profound_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(928),
        ),
    ),
    'severe_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='severe_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1280),
        me_id=me_id(10170),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_dementia_severe_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(927),
        ),
    ),
    'severe_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='severe_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1295),
        me_id=me_id(10200),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_dementia_severe_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(927),
        ),
    ),
    'congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4688),
        me_id=me_id(15854),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2330),
        ),
    ),
    'congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4760),
        me_id=me_id(15878),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2330),
        ),
    ),
    'congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4832),
        me_id=me_id(15902),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2330),
        ),
    ),
    'congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4904),
        me_id=me_id(15926),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2330),
        ),
    ),
    'congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4706),
        me_id=me_id(15860),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2333),
        ),
    ),
    'congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4778),
        me_id=me_id(15884),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2333),
        ),
    ),
    'congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4850),
        me_id=me_id(15908),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2333),
        ),
    ),
    'congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4922),
        me_id=me_id(15932),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2333),
        ),
    ),
    'congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4724),
        me_id=me_id(15866),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2336),
        ),
    ),
    'congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4796),
        me_id=me_id(15890),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2336),
        ),
    ),
    'congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4868),
        me_id=me_id(15914),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2336),
        ),
    ),
    'congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4940),
        me_id=me_id(15938),
        healthstate=Healthstate(
            name='congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2336),
        ),
    ),
    'congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects': Sequela(
        name='congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects',
        kind='sequela',
        gbd_id=s_id(4715),
        me_id=me_id(15863),
        healthstate=Healthstate(
            name='congenital_heart_disease_borderline_intellectual_functioning_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2309),
        ),
    ),
    'congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects': Sequela(
        name='congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects',
        kind='sequela',
        gbd_id=s_id(4787),
        me_id=me_id(15887),
        healthstate=Healthstate(
            name='congenital_heart_disease_borderline_intellectual_functioning_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2309),
        ),
    ),
    'congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus': Sequela(
        name='congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus',
        kind='sequela',
        gbd_id=s_id(4859),
        me_id=me_id(15911),
        healthstate=Healthstate(
            name='congenital_heart_disease_borderline_intellectual_functioning_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2309),
        ),
    ),
    'congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect': Sequela(
        name='congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect',
        kind='sequela',
        gbd_id=s_id(4931),
        me_id=me_id(15935),
        healthstate=Healthstate(
            name='congenital_heart_disease_borderline_intellectual_functioning_and_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(2309),
        ),
    ),
    'chronic_respiratory_disease_due_to_cystic_echinococcosis': Sequela(
        name='chronic_respiratory_disease_due_to_cystic_echinococcosis',
        kind='sequela',
        gbd_id=s_id(148),
        me_id=me_id(1486),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_mild',
            kind='healthstate',
            gbd_id=hs_id(405),
        ),
    ),
    'mild_chronic_obstructive_pulmonary_disease': Sequela(
        name='mild_chronic_obstructive_pulmonary_disease',
        kind='sequela',
        gbd_id=s_id(421),
        me_id=me_id(1873),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_mild',
            kind='healthstate',
            gbd_id=hs_id(405),
        ),
    ),
    'mild_silicosis': Sequela(
        name='mild_silicosis',
        kind='sequela',
        gbd_id=s_id(423),
        me_id=me_id(1880),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_mild',
            kind='healthstate',
            gbd_id=hs_id(405),
        ),
    ),
    'mild_asbestosis': Sequela(
        name='mild_asbestosis',
        kind='sequela',
        gbd_id=s_id(425),
        me_id=me_id(1887),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_mild',
            kind='healthstate',
            gbd_id=hs_id(405),
        ),
    ),
    'mild_coal_workers_pneumoconiosis': Sequela(
        name='mild_coal_workers_pneumoconiosis',
        kind='sequela',
        gbd_id=s_id(427),
        me_id=me_id(1894),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_mild',
            kind='healthstate',
            gbd_id=hs_id(405),
        ),
    ),
    'mild_other_pneumoconiosis': Sequela(
        name='mild_other_pneumoconiosis',
        kind='sequela',
        gbd_id=s_id(429),
        me_id=me_id(1901),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_mild',
            kind='healthstate',
            gbd_id=hs_id(405),
        ),
    ),
    'mild_interstitial_lung_disease_and_pulmonary_sarcoidosis': Sequela(
        name='mild_interstitial_lung_disease_and_pulmonary_sarcoidosis',
        kind='sequela',
        gbd_id=s_id(434),
        me_id=me_id(1912),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_mild',
            kind='healthstate',
            gbd_id=hs_id(405),
        ),
    ),
    'mild_respiratory_problems_due_to_motor_neuron_disease': Sequela(
        name='mild_respiratory_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1179),
        me_id=me_id(9707),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_mild',
            kind='healthstate',
            gbd_id=hs_id(405),
        ),
    ),
    'mild_paragonimiasis_due_to_food_borne_trematodiases': Sequela(
        name='mild_paragonimiasis_due_to_food_borne_trematodiases',
        kind='sequela',
        gbd_id=s_id(1341),
        me_id=me_id(10327),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_mild',
            kind='healthstate',
            gbd_id=hs_id(405),
        ),
    ),
    'mild_chronic_respiratory_problems_and_breathlessness_due_to_congenital_diaphragmatic_hernia': Sequela(
        name='mild_chronic_respiratory_problems_and_breathlessness_due_to_congenital_diaphragmatic_hernia',
        kind='sequela',
        gbd_id=s_id(1610),
        me_id=me_id(11080),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_mild',
            kind='healthstate',
            gbd_id=hs_id(405),
        ),
    ),
    'chronic_respiratory_problems_including_difficulty_breaking_and_recurrent_upper_respiratory_infections_due_to_atresia_and_or_stenosis_of_the_digestive_tract': Sequela(
        name='chronic_respiratory_problems_including_difficulty_breaking_and_recurrent_upper_respiratory_infections_due_to_atresia_and_or_stenosis_of_the_digestive_tract',
        kind='sequela',
        gbd_id=s_id(1658),
        me_id=me_id(11157),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_mild',
            kind='healthstate',
            gbd_id=hs_id(405),
        ),
    ),
    'moderate_chronic_obstructive_pulmonary_disease': Sequela(
        name='moderate_chronic_obstructive_pulmonary_disease',
        kind='sequela',
        gbd_id=s_id(422),
        me_id=me_id(1874),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_moderate',
            kind='healthstate',
            gbd_id=hs_id(406),
        ),
    ),
    'moderate_silicosis': Sequela(
        name='moderate_silicosis',
        kind='sequela',
        gbd_id=s_id(424),
        me_id=me_id(1881),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_moderate',
            kind='healthstate',
            gbd_id=hs_id(406),
        ),
    ),
    'moderate_asbestosis': Sequela(
        name='moderate_asbestosis',
        kind='sequela',
        gbd_id=s_id(426),
        me_id=me_id(1888),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_moderate',
            kind='healthstate',
            gbd_id=hs_id(406),
        ),
    ),
    'moderate_coal_workers_pneumoconiosis': Sequela(
        name='moderate_coal_workers_pneumoconiosis',
        kind='sequela',
        gbd_id=s_id(428),
        me_id=me_id(1895),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_moderate',
            kind='healthstate',
            gbd_id=hs_id(406),
        ),
    ),
    'moderate_other_pneumoconiosis': Sequela(
        name='moderate_other_pneumoconiosis',
        kind='sequela',
        gbd_id=s_id(430),
        me_id=me_id(1902),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_moderate',
            kind='healthstate',
            gbd_id=hs_id(406),
        ),
    ),
    'moderate_interstitial_lung_disease_and_pulmonary_sarcoidosis': Sequela(
        name='moderate_interstitial_lung_disease_and_pulmonary_sarcoidosis',
        kind='sequela',
        gbd_id=s_id(435),
        me_id=me_id(1913),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_moderate',
            kind='healthstate',
            gbd_id=hs_id(406),
        ),
    ),
    'moderate_respiratory_problems_due_to_motor_neuron_disease': Sequela(
        name='moderate_respiratory_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1180),
        me_id=me_id(9708),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_moderate',
            kind='healthstate',
            gbd_id=hs_id(406),
        ),
    ),
    'moderate_paragonimiasis_due_to_food_borne_trematodiases': Sequela(
        name='moderate_paragonimiasis_due_to_food_borne_trematodiases',
        kind='sequela',
        gbd_id=s_id(1342),
        me_id=me_id(10328),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_moderate',
            kind='healthstate',
            gbd_id=hs_id(406),
        ),
    ),
    'severe_chronic_obstructive_pulmonary_disease_without_heart_failure': Sequela(
        name='severe_chronic_obstructive_pulmonary_disease_without_heart_failure',
        kind='sequela',
        gbd_id=s_id(983),
        me_id=me_id(3152),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_severe',
            kind='healthstate',
            gbd_id=hs_id(407),
        ),
    ),
    'severe_silicosis_without_heart_failure': Sequela(
        name='severe_silicosis_without_heart_failure',
        kind='sequela',
        gbd_id=s_id(987),
        me_id=me_id(3156),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_severe',
            kind='healthstate',
            gbd_id=hs_id(407),
        ),
    ),
    'severe_asbestosis_without_heart_failure': Sequela(
        name='severe_asbestosis_without_heart_failure',
        kind='sequela',
        gbd_id=s_id(991),
        me_id=me_id(3160),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_severe',
            kind='healthstate',
            gbd_id=hs_id(407),
        ),
    ),
    'severe_coal_workers_pneumoconiosis_without_heart_failure': Sequela(
        name='severe_coal_workers_pneumoconiosis_without_heart_failure',
        kind='sequela',
        gbd_id=s_id(995),
        me_id=me_id(3164),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_severe',
            kind='healthstate',
            gbd_id=hs_id(407),
        ),
    ),
    'severe_other_pneumoconiosis_without_heart_failure': Sequela(
        name='severe_other_pneumoconiosis_without_heart_failure',
        kind='sequela',
        gbd_id=s_id(999),
        me_id=me_id(3168),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_severe',
            kind='healthstate',
            gbd_id=hs_id(407),
        ),
    ),
    'severe_interstitial_lung_disease_and_pulmonary_sarcoidosis_without_heart_failure': Sequela(
        name='severe_interstitial_lung_disease_and_pulmonary_sarcoidosis_without_heart_failure',
        kind='sequela',
        gbd_id=s_id(1003),
        me_id=me_id(3172),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_severe',
            kind='healthstate',
            gbd_id=hs_id(407),
        ),
    ),
    'severe_respiratory_problems_due_to_motor_neuron_disease': Sequela(
        name='severe_respiratory_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1181),
        me_id=me_id(9709),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_severe',
            kind='healthstate',
            gbd_id=hs_id(407),
        ),
    ),
    'severe_paragonimiasis_due_to_food_borne_trematodiases': Sequela(
        name='severe_paragonimiasis_due_to_food_borne_trematodiases',
        kind='sequela',
        gbd_id=s_id(1343),
        me_id=me_id(10329),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_severe',
            kind='healthstate',
            gbd_id=hs_id(407),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_severe_asbestosis': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_severe_asbestosis',
        kind='sequela',
        gbd_id=s_id(5771),
        me_id=me_id(20176),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_severe_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2663),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease',
        kind='sequela',
        gbd_id=s_id(5774),
        me_id=me_id(20174),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_severe_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2663),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_severe_coal_workers_pneumoconiosis': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_severe_coal_workers_pneumoconiosis',
        kind='sequela',
        gbd_id=s_id(5777),
        me_id=me_id(20177),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_severe_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2663),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis',
        kind='sequela',
        gbd_id=s_id(5780),
        me_id=me_id(20179),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_severe_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2663),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_severe_other_pneumoconiosis': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_severe_other_pneumoconiosis',
        kind='sequela',
        gbd_id=s_id(5783),
        me_id=me_id(20178),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_severe_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2663),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_severe_silicosis': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_severe_silicosis',
        kind='sequela',
        gbd_id=s_id(5786),
        me_id=me_id(20175),
        healthstate=Healthstate(
            name='copd_and_other_chronic_respiratory_problems_severe_and_generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(2663),
        ),
    ),
    'ulcerative_colitis_with_mild_anemia': Sequela(
        name='ulcerative_colitis_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(5567),
        me_id=me_id(18861),
        healthstate=Healthstate(
            name='crohn_disease_or_ulcerative_colitis',
            kind='healthstate',
            gbd_id=hs_id(396),
        ),
    ),
    'ulcerative_colitis_with_moderate_anemia': Sequela(
        name='ulcerative_colitis_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(5570),
        me_id=me_id(18862),
        healthstate=Healthstate(
            name='crohn_disease_or_ulcerative_colitis',
            kind='healthstate',
            gbd_id=hs_id(396),
        ),
    ),
    'ulcerative_colitis_with_severe_anemia': Sequela(
        name='ulcerative_colitis_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5573),
        me_id=me_id(18863),
        healthstate=Healthstate(
            name='crohn_disease_or_ulcerative_colitis',
            kind='healthstate',
            gbd_id=hs_id(396),
        ),
    ),
    'ulcerative_colitis_without_anemia': Sequela(
        name='ulcerative_colitis_without_anemia',
        kind='sequela',
        gbd_id=s_id(5576),
        me_id=me_id(19990),
        healthstate=Healthstate(
            name='crohn_disease_or_ulcerative_colitis',
            kind='healthstate',
            gbd_id=hs_id(396),
        ),
    ),
    'crohns_disease_with_mild_anemia': Sequela(
        name='crohns_disease_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(5579),
        me_id=me_id(18864),
        healthstate=Healthstate(
            name='crohn_disease_or_ulcerative_colitis',
            kind='healthstate',
            gbd_id=hs_id(396),
        ),
    ),
    'crohns_disease_with_moderate_anemia': Sequela(
        name='crohns_disease_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(5582),
        me_id=me_id(18865),
        healthstate=Healthstate(
            name='crohn_disease_or_ulcerative_colitis',
            kind='healthstate',
            gbd_id=hs_id(396),
        ),
    ),
    'crohns_disease_with_severe_anemia': Sequela(
        name='crohns_disease_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5585),
        me_id=me_id(18866),
        healthstate=Healthstate(
            name='crohn_disease_or_ulcerative_colitis',
            kind='healthstate',
            gbd_id=hs_id(396),
        ),
    ),
    'crohns_disease_without_anemia': Sequela(
        name='crohns_disease_without_anemia',
        kind='sequela',
        gbd_id=s_id(5588),
        me_id=me_id(19991),
        healthstate=Healthstate(
            name='crohn_disease_or_ulcerative_colitis',
            kind='healthstate',
            gbd_id=hs_id(396),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_without_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_without_anemia',
        kind='sequela',
        gbd_id=s_id(23029),
        me_id=me_id(23840),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver',
            kind='healthstate',
            gbd_id=hs_id(394),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_no_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_no_anemia',
        kind='sequela',
        gbd_id=s_id(23033),
        me_id=me_id(23844),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver',
            kind='healthstate',
            gbd_id=hs_id(394),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_without_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_without_anemia',
        kind='sequela',
        gbd_id=s_id(23037),
        me_id=me_id(23848),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver',
            kind='healthstate',
            gbd_id=hs_id(394),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_no_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_no_anemia',
        kind='sequela',
        gbd_id=s_id(23041),
        me_id=me_id(23856),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver',
            kind='healthstate',
            gbd_id=hs_id(394),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_no_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_no_anemia',
        kind='sequela',
        gbd_id=s_id(23045),
        me_id=me_id(23852),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver',
            kind='healthstate',
            gbd_id=hs_id(394),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_mild_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(23030),
        me_id=me_id(23841),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver_and_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2720),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_mild_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(23034),
        me_id=me_id(23845),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver_and_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2720),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_mild_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(23038),
        me_id=me_id(23849),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver_and_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2720),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_mild_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(23042),
        me_id=me_id(23857),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver_and_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2720),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_mild_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(23046),
        me_id=me_id(23853),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver_and_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2720),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_moderate_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(23031),
        me_id=me_id(23842),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver_and_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2721),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_moderate_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(23035),
        me_id=me_id(23846),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver_and_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2721),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_moderate_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(23039),
        me_id=me_id(23850),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver_and_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2721),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_moderate_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(23043),
        me_id=me_id(23858),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver_and_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2721),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_moderate_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(23047),
        me_id=me_id(23854),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver_and_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2721),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_severe_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(23032),
        me_id=me_id(23843),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver_and_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(2722),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_severe_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(23036),
        me_id=me_id(23847),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver_and_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(2722),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_severe_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(23040),
        me_id=me_id(23851),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver_and_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(2722),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_severe_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(23044),
        me_id=me_id(23859),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver_and_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(2722),
        ),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_severe_anemia': Sequela(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(23048),
        me_id=me_id(23855),
        healthstate=Healthstate(
            name='decompensated_cirrhosis_of_the_liver_and_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(2722),
        ),
    ),
    'mild_alzheimers_disease_and_other_dementias': Sequela(
        name='mild_alzheimers_disease_and_other_dementias',
        kind='sequela',
        gbd_id=s_id(452),
        me_id=me_id(1944),
        healthstate=Healthstate(
            name='dementia_mild',
            kind='healthstate',
            gbd_id=hs_id(408),
        ),
    ),
    'mild_dementia_due_to_down_syndrome': Sequela(
        name='mild_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1234),
        me_id=me_id(9938),
        healthstate=Healthstate(
            name='dementia_mild',
            kind='healthstate',
            gbd_id=hs_id(408),
        ),
    ),
    'mild_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='mild_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1240),
        me_id=me_id(9948),
        healthstate=Healthstate(
            name='dementia_mild',
            kind='healthstate',
            gbd_id=hs_id(408),
        ),
    ),
    'moderate_alzheimers_disease_and_other_dementias': Sequela(
        name='moderate_alzheimers_disease_and_other_dementias',
        kind='sequela',
        gbd_id=s_id(453),
        me_id=me_id(1945),
        healthstate=Healthstate(
            name='dementia_moderate',
            kind='healthstate',
            gbd_id=hs_id(409),
        ),
    ),
    'moderate_dementia_due_to_down_syndrome': Sequela(
        name='moderate_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1235),
        me_id=me_id(9939),
        healthstate=Healthstate(
            name='dementia_moderate',
            kind='healthstate',
            gbd_id=hs_id(409),
        ),
    ),
    'moderate_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='moderate_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1241),
        me_id=me_id(9949),
        healthstate=Healthstate(
            name='dementia_moderate',
            kind='healthstate',
            gbd_id=hs_id(409),
        ),
    ),
    'severe_alzheimers_disease_and_other_dementias': Sequela(
        name='severe_alzheimers_disease_and_other_dementias',
        kind='sequela',
        gbd_id=s_id(454),
        me_id=me_id(1946),
        healthstate=Healthstate(
            name='dementia_severe',
            kind='healthstate',
            gbd_id=hs_id(410),
        ),
    ),
    'severe_dementia_due_to_down_syndrome': Sequela(
        name='severe_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1236),
        me_id=me_id(9940),
        healthstate=Healthstate(
            name='dementia_severe',
            kind='healthstate',
            gbd_id=hs_id(410),
        ),
    ),
    'severe_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='severe_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1242),
        me_id=me_id(9950),
        healthstate=Healthstate(
            name='dementia_severe',
            kind='healthstate',
            gbd_id=hs_id(410),
        ),
    ),
    'pain_due_to_caries_of_deciduous_teeth': Sequela(
        name='pain_due_to_caries_of_deciduous_teeth',
        kind='sequela',
        gbd_id=s_id(662),
        me_id=me_id(2582),
        healthstate=Healthstate(
            name='dental_caries_symptomatic',
            kind='healthstate',
            gbd_id=hs_id(551),
        ),
    ),
    'pain_due_to_caries_of_permanent_teeth': Sequela(
        name='pain_due_to_caries_of_permanent_teeth',
        kind='sequela',
        gbd_id=s_id(663),
        me_id=me_id(2583),
        healthstate=Healthstate(
            name='dental_caries_symptomatic',
            kind='healthstate',
            gbd_id=hs_id(551),
        ),
    ),
    'diabetic_neuropathy_due_to_diabetes_mellitus_type_1_without_diabetic_foot_or_amputation': Sequela(
        name='diabetic_neuropathy_due_to_diabetes_mellitus_type_1_without_diabetic_foot_or_amputation',
        kind='sequela',
        gbd_id=s_id(5432),
        me_id=me_id(19710),
        healthstate=Healthstate(
            name='diabetic_neuropathy',
            kind='healthstate',
            gbd_id=hs_id(390),
        ),
    ),
    'diabetic_neuropathy_due_to_diabetes_mellitus_type_2_without_diabetic_foot_or_amputation': Sequela(
        name='diabetic_neuropathy_due_to_diabetes_mellitus_type_2_without_diabetic_foot_or_amputation',
        kind='sequela',
        gbd_id=s_id(5456),
        me_id=me_id(19724),
        healthstate=Healthstate(
            name='diabetic_neuropathy',
            kind='healthstate',
            gbd_id=hs_id(390),
        ),
    ),
    'diabetic_foot_due_to_neuropathy_due_to_diabetes_mellitus_type_1': Sequela(
        name='diabetic_foot_due_to_neuropathy_due_to_diabetes_mellitus_type_1',
        kind='sequela',
        gbd_id=s_id(5429),
        me_id=me_id(19708),
        healthstate=Healthstate(
            name='diabetic_neuropathy_with_diabetic_foot',
            kind='healthstate',
            gbd_id=hs_id(838),
        ),
    ),
    'diabetic_foot_due_to_neuropathy_due_to_diabetes_mellitus_type_2': Sequela(
        name='diabetic_foot_due_to_neuropathy_due_to_diabetes_mellitus_type_2',
        kind='sequela',
        gbd_id=s_id(5453),
        me_id=me_id(19722),
        healthstate=Healthstate(
            name='diabetic_neuropathy_with_diabetic_foot',
            kind='healthstate',
            gbd_id=hs_id(838),
        ),
    ),
    'diabetic_neuropathy_and_amputation_with_treatment_due_to_diabetes_mellitus_type_1': Sequela(
        name='diabetic_neuropathy_and_amputation_with_treatment_due_to_diabetes_mellitus_type_1',
        kind='sequela',
        gbd_id=s_id(5435),
        me_id=me_id(19711),
        healthstate=Healthstate(
            name='diabetic_neuropathy_with_treated_amputation',
            kind='healthstate',
            gbd_id=hs_id(839),
        ),
    ),
    'diabetic_neuropathy_and_amputation_with_treatment_due_to_diabetes_mellitus_type_2': Sequela(
        name='diabetic_neuropathy_and_amputation_with_treatment_due_to_diabetes_mellitus_type_2',
        kind='sequela',
        gbd_id=s_id(5459),
        me_id=me_id(19725),
        healthstate=Healthstate(
            name='diabetic_neuropathy_with_treated_amputation',
            kind='healthstate',
            gbd_id=hs_id(839),
        ),
    ),
    'diabetic_neuropathy_and_amputation_without_treatment_due_to_diabetes_mellitus_type_1': Sequela(
        name='diabetic_neuropathy_and_amputation_without_treatment_due_to_diabetes_mellitus_type_1',
        kind='sequela',
        gbd_id=s_id(5438),
        me_id=me_id(19712),
        healthstate=Healthstate(
            name='diabetic_neuropathy_with_untreated_amputation',
            kind='healthstate',
            gbd_id=hs_id(840),
        ),
    ),
    'diabetic_neuropathy_and_amputation_without_treatment_due_to_diabetes_mellitus_type_2': Sequela(
        name='diabetic_neuropathy_and_amputation_without_treatment_due_to_diabetes_mellitus_type_2',
        kind='sequela',
        gbd_id=s_id(5462),
        me_id=me_id(19726),
        healthstate=Healthstate(
            name='diabetic_neuropathy_with_untreated_amputation',
            kind='healthstate',
            gbd_id=hs_id(840),
        ),
    ),
    'mild_diarrhea_due_to_schistosomiasis': Sequela(
        name='mild_diarrhea_due_to_schistosomiasis',
        kind='sequela',
        gbd_id=s_id(137),
        me_id=me_id(1469),
        healthstate=Healthstate(
            name='diarrhea_mild',
            kind='healthstate',
            gbd_id=hs_id(355),
        ),
    ),
    'mild_diarrheal_diseases': Sequela(
        name='mild_diarrheal_diseases',
        kind='sequela',
        gbd_id=s_id(665),
        me_id=me_id(2608),
        healthstate=Healthstate(
            name='diarrhea_mild',
            kind='healthstate',
            gbd_id=hs_id(355),
        ),
    ),
    'moderate_diarrheal_diseases': Sequela(
        name='moderate_diarrheal_diseases',
        kind='sequela',
        gbd_id=s_id(666),
        me_id=me_id(2609),
        healthstate=Healthstate(
            name='diarrhea_moderate',
            kind='healthstate',
            gbd_id=hs_id(356),
        ),
    ),
    'severe_diarrheal_diseases': Sequela(
        name='severe_diarrheal_diseases',
        kind='sequela',
        gbd_id=s_id(667),
        me_id=me_id(2610),
        healthstate=Healthstate(
            name='diarrhea_severe',
            kind='healthstate',
            gbd_id=hs_id(357),
        ),
    ),
    'hirsutism_and_primary_infertility_due_to_polycystic_ovarian_syndrome': Sequela(
        name='hirsutism_and_primary_infertility_due_to_polycystic_ovarian_syndrome',
        kind='sequela',
        gbd_id=s_id(857),
        me_id=me_id(2938),
        healthstate=Healthstate(
            name='disfigurement_level_1_and_primary_infertility',
            kind='healthstate',
            gbd_id=hs_id(800),
        ),
    ),
    'atypical_genitalia_and_primary_infertility_due_to_congenital_genital_anomalies': Sequela(
        name='atypical_genitalia_and_primary_infertility_due_to_congenital_genital_anomalies',
        kind='sequela',
        gbd_id=s_id(1727),
        me_id=me_id(11037),
        healthstate=Healthstate(
            name='disfigurement_level_1_and_primary_infertility',
            kind='healthstate',
            gbd_id=hs_id(800),
        ),
    ),
    'secondary_infertility_due_to_polycystic_ovarian_syndrome': Sequela(
        name='secondary_infertility_due_to_polycystic_ovarian_syndrome',
        kind='sequela',
        gbd_id=s_id(940),
        me_id=me_id(3088),
        healthstate=Healthstate(
            name='disfigurement_level_1_and_secondary_infertility',
            kind='healthstate',
            gbd_id=hs_id(821),
        ),
    ),
    'visible_goiter_without_symptoms': Sequela(
        name='visible_goiter_without_symptoms',
        kind='sequela',
        gbd_id=s_id(200),
        me_id=me_id(1611),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'disfigurement_level_1_due_to_leprosy': Sequela(
        name='disfigurement_level_1_due_to_leprosy',
        kind='sequela',
        gbd_id=s_id(237),
        me_id=me_id(1663),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'mild_alopecia_areata': Sequela(
        name='mild_alopecia_areata',
        kind='sequela',
        gbd_id=s_id(601),
        me_id=me_id(2277),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'pruritus': Sequela(
        name='pruritus',
        kind='sequela',
        gbd_id=s_id(603),
        me_id=me_id(2280),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'disfigurement_due_to_basal_cell_carcinoma': Sequela(
        name='disfigurement_due_to_basal_cell_carcinoma',
        kind='sequela',
        gbd_id=s_id(657),
        me_id=me_id(2514),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'mild_skin_disease_without_itch_due_to_onchocerciasis': Sequela(
        name='mild_skin_disease_without_itch_due_to_onchocerciasis',
        kind='sequela',
        gbd_id=s_id(673),
        me_id=me_id(2620),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'hirsutism_due_to_polycystic_ovarian_syndrome': Sequela(
        name='hirsutism_due_to_polycystic_ovarian_syndrome',
        kind='sequela',
        gbd_id=s_id(856),
        me_id=me_id(9742),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'symptomatic_other_skin_and_subcutaneous_diseases': Sequela(
        name='symptomatic_other_skin_and_subcutaneous_diseases',
        kind='sequela',
        gbd_id=s_id(899),
        me_id=me_id(2982),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'disfigurement_level_1_due_to_orofacial_clefts': Sequela(
        name='disfigurement_level_1_due_to_orofacial_clefts',
        kind='sequela',
        gbd_id=s_id(923),
        me_id=me_id(3056),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'mild_chronic_other_sense_organ_diseases': Sequela(
        name='mild_chronic_other_sense_organ_diseases',
        kind='sequela',
        gbd_id=s_id(1339),
        me_id=me_id(10317),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'disfigurement_level_1_due_to_polydactyly_and_syndactyly': Sequela(
        name='disfigurement_level_1_due_to_polydactyly_and_syndactyly',
        kind='sequela',
        gbd_id=s_id(1550),
        me_id=me_id(11108),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'disfigurement_due_to_congenital_diaphragmatic_hernia': Sequela(
        name='disfigurement_due_to_congenital_diaphragmatic_hernia',
        kind='sequela',
        gbd_id=s_id(1607),
        me_id=me_id(11079),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'disfigurement_from_scars_following_treatment_for_congenital_malformations_of_the_abdominal_wall': Sequela(
        name='disfigurement_from_scars_following_treatment_for_congenital_malformations_of_the_abdominal_wall',
        kind='sequela',
        gbd_id=s_id(1676),
        me_id=me_id(11163),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'atypical_genitalia_due_to_congenital_genital_anomalies': Sequela(
        name='atypical_genitalia_due_to_congenital_genital_anomalies',
        kind='sequela',
        gbd_id=s_id(1712),
        me_id=me_id(11032),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'atypical_genitalia_due_to_congenital_anomalies_of_the_urinary_tract': Sequela(
        name='atypical_genitalia_due_to_congenital_anomalies_of_the_urinary_tract',
        kind='sequela',
        gbd_id=s_id(1853),
        me_id=me_id(11362),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'mild_disfigurement_due_to_squamous_cell_carcinoma': Sequela(
        name='mild_disfigurement_due_to_squamous_cell_carcinoma',
        kind='sequela',
        gbd_id=s_id(2039),
        me_id=me_id(11519),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'mild_acne_vulgaris': Sequela(
        name='mild_acne_vulgaris',
        kind='sequela',
        gbd_id=s_id(4619),
        me_id=me_id(16296),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'non_disabling_symptomatic_acne': Sequela(
        name='non_disabling_symptomatic_acne',
        kind='sequela',
        gbd_id=s_id(5618),
        me_id=me_id(20010),
        healthstate=Healthstate(
            name='disfigurement_level_1',
            kind='healthstate',
            gbd_id=hs_id(553),
        ),
    ),
    'mild_skin_disease_due_to_onchocerciasis': Sequela(
        name='mild_skin_disease_due_to_onchocerciasis',
        kind='sequela',
        gbd_id=s_id(152),
        me_id=me_id(1495),
        healthstate=Healthstate(
            name='disfigurement_level_1_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(556),
        ),
    ),
    'mild_atopic_dermatitis': Sequela(
        name='mild_atopic_dermatitis',
        kind='sequela',
        gbd_id=s_id(588),
        me_id=me_id(2248),
        healthstate=Healthstate(
            name='disfigurement_level_1_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(556),
        ),
    ),
    'mild_psoriasis': Sequela(
        name='mild_psoriasis',
        kind='sequela',
        gbd_id=s_id(591),
        me_id=me_id(2252),
        healthstate=Healthstate(
            name='disfigurement_level_1_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(556),
        ),
    ),
    'scabies': Sequela(
        name='scabies',
        kind='sequela',
        gbd_id=s_id(596),
        me_id=me_id(2262),
        healthstate=Healthstate(
            name='disfigurement_level_1_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(556),
        ),
    ),
    'mild_urticaria': Sequela(
        name='mild_urticaria',
        kind='sequela',
        gbd_id=s_id(604),
        me_id=me_id(2284),
        healthstate=Healthstate(
            name='disfigurement_level_1_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(556),
        ),
    ),
    'mild_decubitus_ulcer': Sequela(
        name='mild_decubitus_ulcer',
        kind='sequela',
        gbd_id=s_id(606),
        me_id=me_id(2287),
        healthstate=Healthstate(
            name='disfigurement_level_1_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(556),
        ),
    ),
    'mild_contact_dermatitis': Sequela(
        name='mild_contact_dermatitis',
        kind='sequela',
        gbd_id=s_id(659),
        me_id=me_id(2575),
        healthstate=Healthstate(
            name='disfigurement_level_1_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(556),
        ),
    ),
    'symptomatic_seborrhoeic_dermatitis': Sequela(
        name='symptomatic_seborrhoeic_dermatitis',
        kind='sequela',
        gbd_id=s_id(661),
        me_id=me_id(2579),
        healthstate=Healthstate(
            name='disfigurement_level_1_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(556),
        ),
    ),
    'skin_disfigurement_due_to_trypanosoma_brucei_gambiense': Sequela(
        name='skin_disfigurement_due_to_trypanosoma_brucei_gambiense',
        kind='sequela',
        gbd_id=s_id(1454),
        me_id=me_id(10918),
        healthstate=Healthstate(
            name='disfigurement_level_1_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(556),
        ),
    ),
    'skin_disfigurement_due_to_trypanosoma_brucei_rhodesiense': Sequela(
        name='skin_disfigurement_due_to_trypanosoma_brucei_rhodesiense',
        kind='sequela',
        gbd_id=s_id(1463),
        me_id=me_id(10920),
        healthstate=Healthstate(
            name='disfigurement_level_1_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(556),
        ),
    ),
    'mild_pain_due_to_guinea_worm_emergence': Sequela(
        name='mild_pain_due_to_guinea_worm_emergence',
        kind='sequela',
        gbd_id=s_id(2204),
        me_id=me_id(11647),
        healthstate=Healthstate(
            name='disfigurement_level_1_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(556),
        ),
    ),
    'cutaneous_and_mucocutaneous_leishmaniasis': Sequela(
        name='cutaneous_and_mucocutaneous_leishmaniasis',
        kind='sequela',
        gbd_id=s_id(133),
        me_id=me_id(1461),
        healthstate=Healthstate(
            name='disfigurement_level_2',
            kind='healthstate',
            gbd_id=hs_id(554),
        ),
    ),
    'disfigurement_level_2_due_to_leprosy': Sequela(
        name='disfigurement_level_2_due_to_leprosy',
        kind='sequela',
        gbd_id=s_id(238),
        me_id=me_id(1664),
        healthstate=Healthstate(
            name='disfigurement_level_2',
            kind='healthstate',
            gbd_id=hs_id(554),
        ),
    ),
    'severe_viral_warts': Sequela(
        name='severe_viral_warts',
        kind='sequela',
        gbd_id=s_id(599),
        me_id=me_id(2272),
        healthstate=Healthstate(
            name='disfigurement_level_2',
            kind='healthstate',
            gbd_id=hs_id(554),
        ),
    ),
    'severe_alopecia_areata': Sequela(
        name='severe_alopecia_areata',
        kind='sequela',
        gbd_id=s_id(602),
        me_id=me_id(2278),
        healthstate=Healthstate(
            name='disfigurement_level_2',
            kind='healthstate',
            gbd_id=hs_id(554),
        ),
    ),
    'severe_molluscum_contagiosum': Sequela(
        name='severe_molluscum_contagiosum',
        kind='sequela',
        gbd_id=s_id(901),
        me_id=me_id(2985),
        healthstate=Healthstate(
            name='disfigurement_level_2',
            kind='healthstate',
            gbd_id=hs_id(554),
        ),
    ),
    'disfigurement_level_2_due_to_orofacial_clefts': Sequela(
        name='disfigurement_level_2_due_to_orofacial_clefts',
        kind='sequela',
        gbd_id=s_id(924),
        me_id=me_id(3057),
        healthstate=Healthstate(
            name='disfigurement_level_2',
            kind='healthstate',
            gbd_id=hs_id(554),
        ),
    ),
    'disfigurement_level_2_due_to_congenital_limb_deficiency': Sequela(
        name='disfigurement_level_2_due_to_congenital_limb_deficiency',
        kind='sequela',
        gbd_id=s_id(1553),
        me_id=me_id(11109),
        healthstate=Healthstate(
            name='disfigurement_level_2',
            kind='healthstate',
            gbd_id=hs_id(554),
        ),
    ),
    'disfigurement_level_2_due_to_other_congenital_musculoskeletal_anomalies': Sequela(
        name='disfigurement_level_2_due_to_other_congenital_musculoskeletal_anomalies',
        kind='sequela',
        gbd_id=s_id(1577),
        me_id=me_id(11117),
        healthstate=Healthstate(
            name='disfigurement_level_2',
            kind='healthstate',
            gbd_id=hs_id(554),
        ),
    ),
    'moderate_disfigurement_due_to_squamous_cell_carcinoma': Sequela(
        name='moderate_disfigurement_due_to_squamous_cell_carcinoma',
        kind='sequela',
        gbd_id=s_id(2042),
        me_id=me_id(11520),
        healthstate=Healthstate(
            name='disfigurement_level_2',
            kind='healthstate',
            gbd_id=hs_id(554),
        ),
    ),
    'moderate_acne_vulgaris': Sequela(
        name='moderate_acne_vulgaris',
        kind='sequela',
        gbd_id=s_id(4622),
        me_id=me_id(16297),
        healthstate=Healthstate(
            name='disfigurement_level_2',
            kind='healthstate',
            gbd_id=hs_id(554),
        ),
    ),
    'moderate_skin_disease_due_to_onchocerciasis': Sequela(
        name='moderate_skin_disease_due_to_onchocerciasis',
        kind='sequela',
        gbd_id=s_id(153),
        me_id=me_id(1496),
        healthstate=Healthstate(
            name='disfigurement_level_2_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(557),
        ),
    ),
    'moderate_atopic_dermatitis': Sequela(
        name='moderate_atopic_dermatitis',
        kind='sequela',
        gbd_id=s_id(589),
        me_id=me_id(2249),
        healthstate=Healthstate(
            name='disfigurement_level_2_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(557),
        ),
    ),
    'moderate_psoriasis': Sequela(
        name='moderate_psoriasis',
        kind='sequela',
        gbd_id=s_id(592),
        me_id=me_id(2253),
        healthstate=Healthstate(
            name='disfigurement_level_2_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(557),
        ),
    ),
    'severe_urticaria': Sequela(
        name='severe_urticaria',
        kind='sequela',
        gbd_id=s_id(605),
        me_id=me_id(2285),
        healthstate=Healthstate(
            name='disfigurement_level_2_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(557),
        ),
    ),
    'moderate_decubitus_ulcer': Sequela(
        name='moderate_decubitus_ulcer',
        kind='sequela',
        gbd_id=s_id(607),
        me_id=me_id(2288),
        healthstate=Healthstate(
            name='disfigurement_level_2_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(557),
        ),
    ),
    'severe_skin_disease_due_to_onchocerciasis': Sequela(
        name='severe_skin_disease_due_to_onchocerciasis',
        kind='sequela',
        gbd_id=s_id(658),
        me_id=me_id(2515),
        healthstate=Healthstate(
            name='disfigurement_level_2_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(557),
        ),
    ),
    'moderate_contact_dermatitis': Sequela(
        name='moderate_contact_dermatitis',
        kind='sequela',
        gbd_id=s_id(660),
        me_id=me_id(2576),
        healthstate=Healthstate(
            name='disfigurement_level_2_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(557),
        ),
    ),
    'disfigurement_level_2_with_pain_due_to_congenital_limb_deficiency': Sequela(
        name='disfigurement_level_2_with_pain_due_to_congenital_limb_deficiency',
        kind='sequela',
        gbd_id=s_id(1556),
        me_id=me_id(11110),
        healthstate=Healthstate(
            name='disfigurement_level_2_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(557),
        ),
    ),
    'disfigurement_level_2_with_pain_due_to_other_congenital_musculoskeletal_anomalies': Sequela(
        name='disfigurement_level_2_with_pain_due_to_other_congenital_musculoskeletal_anomalies',
        kind='sequela',
        gbd_id=s_id(1580),
        me_id=me_id(11118),
        healthstate=Healthstate(
            name='disfigurement_level_2_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(557),
        ),
    ),
    'severe_skin_disease_without_itch_due_to_onchocerciasis': Sequela(
        name='severe_skin_disease_without_itch_due_to_onchocerciasis',
        kind='sequela',
        gbd_id=s_id(674),
        me_id=me_id(2621),
        healthstate=Healthstate(
            name='disfigurement_level_3',
            kind='healthstate',
            gbd_id=hs_id(555),
        ),
    ),
    'severe_acne_vulgaris': Sequela(
        name='severe_acne_vulgaris',
        kind='sequela',
        gbd_id=s_id(4625),
        me_id=me_id(16298),
        healthstate=Healthstate(
            name='disfigurement_level_3',
            kind='healthstate',
            gbd_id=hs_id(555),
        ),
    ),
    'severe_disfigurement_due_to_adult_tertiary_syphilis': Sequela(
        name='severe_disfigurement_due_to_adult_tertiary_syphilis',
        kind='sequela',
        gbd_id=s_id(5147),
        me_id=me_id(16412),
        healthstate=Healthstate(
            name='disfigurement_level_3',
            kind='healthstate',
            gbd_id=hs_id(555),
        ),
    ),
    'severe_atopic_dermatitis': Sequela(
        name='severe_atopic_dermatitis',
        kind='sequela',
        gbd_id=s_id(590),
        me_id=me_id(2250),
        healthstate=Healthstate(
            name='disfigurement_level_3_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(558),
        ),
    ),
    'severe_psoriasis': Sequela(
        name='severe_psoriasis',
        kind='sequela',
        gbd_id=s_id(593),
        me_id=me_id(2254),
        healthstate=Healthstate(
            name='disfigurement_level_3_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(558),
        ),
    ),
    'severe_decubitus_ulcer': Sequela(
        name='severe_decubitus_ulcer',
        kind='sequela',
        gbd_id=s_id(608),
        me_id=me_id(2289),
        healthstate=Healthstate(
            name='disfigurement_level_3_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(558),
        ),
    ),
    'severe_disfigurement_due_to_squamous_cell_carcinoma': Sequela(
        name='severe_disfigurement_due_to_squamous_cell_carcinoma',
        kind='sequela',
        gbd_id=s_id(2045),
        me_id=me_id(11521),
        healthstate=Healthstate(
            name='disfigurement_level_3_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(558),
        ),
    ),
    'blindness_due_to_trachoma': Sequela(
        name='blindness_due_to_trachoma',
        kind='sequela',
        gbd_id=s_id(156),
        me_id=me_id(3614),
        healthstate=Healthstate(
            name='distance_vision_blindness',
            kind='healthstate',
            gbd_id=hs_id(468),
        ),
    ),
    'blindness_due_to_vitamin_a_deficiency': Sequela(
        name='blindness_due_to_vitamin_a_deficiency',
        kind='sequela',
        gbd_id=s_id(205),
        me_id=me_id(3887),
        healthstate=Healthstate(
            name='distance_vision_blindness',
            kind='healthstate',
            gbd_id=hs_id(468),
        ),
    ),
    'blindness_due_to_glaucoma': Sequela(
        name='blindness_due_to_glaucoma',
        kind='sequela',
        gbd_id=s_id(611),
        me_id=me_id(3917),
        healthstate=Healthstate(
            name='distance_vision_blindness',
            kind='healthstate',
            gbd_id=hs_id(468),
        ),
    ),
    'blindness_due_to_cataract': Sequela(
        name='blindness_due_to_cataract',
        kind='sequela',
        gbd_id=s_id(614),
        me_id=me_id(3920),
        healthstate=Healthstate(
            name='distance_vision_blindness',
            kind='healthstate',
            gbd_id=hs_id(468),
        ),
    ),
    'blindness_due_to_macular_degeneration': Sequela(
        name='blindness_due_to_macular_degeneration',
        kind='sequela',
        gbd_id=s_id(617),
        me_id=me_id(3923),
        healthstate=Healthstate(
            name='distance_vision_blindness',
            kind='healthstate',
            gbd_id=hs_id(468),
        ),
    ),
    'blindness_due_to_uncorrected_refractive_error': Sequela(
        name='blindness_due_to_uncorrected_refractive_error',
        kind='sequela',
        gbd_id=s_id(620),
        me_id=me_id(2310),
        healthstate=Healthstate(
            name='distance_vision_blindness',
            kind='healthstate',
            gbd_id=hs_id(468),
        ),
    ),
    'blindness_due_to_other_vision_loss': Sequela(
        name='blindness_due_to_other_vision_loss',
        kind='sequela',
        gbd_id=s_id(636),
        me_id=me_id(3926),
        healthstate=Healthstate(
            name='distance_vision_blindness',
            kind='healthstate',
            gbd_id=hs_id(468),
        ),
    ),
    'blindness_due_to_retinopathy_of_prematurity': Sequela(
        name='blindness_due_to_retinopathy_of_prematurity',
        kind='sequela',
        gbd_id=s_id(867),
        me_id=me_id(3647),
        healthstate=Healthstate(
            name='distance_vision_blindness',
            kind='healthstate',
            gbd_id=hs_id(468),
        ),
    ),
    'blindness_due_to_encephalitis': Sequela(
        name='blindness_due_to_encephalitis',
        kind='sequela',
        gbd_id=s_id(874),
        me_id=me_id(3509),
        healthstate=Healthstate(
            name='distance_vision_blindness',
            kind='healthstate',
            gbd_id=hs_id(468),
        ),
    ),
    'blindness_due_to_onchocerciasis': Sequela(
        name='blindness_due_to_onchocerciasis',
        kind='sequela',
        gbd_id=s_id(875),
        me_id=me_id(3611),
        healthstate=Healthstate(
            name='distance_vision_blindness',
            kind='healthstate',
            gbd_id=hs_id(468),
        ),
    ),
    'blindness_due_to_diabetes_mellitus_type_1_retinopathy': Sequela(
        name='blindness_due_to_diabetes_mellitus_type_1_retinopathy',
        kind='sequela',
        gbd_id=s_id(5450),
        me_id=me_id(19719),
        healthstate=Healthstate(
            name='distance_vision_blindness',
            kind='healthstate',
            gbd_id=hs_id(468),
        ),
    ),
    'blindness_due_to_diabetes_mellitus_type_2_retinopathy': Sequela(
        name='blindness_due_to_diabetes_mellitus_type_2_retinopathy',
        kind='sequela',
        gbd_id=s_id(5474),
        me_id=me_id(19733),
        healthstate=Healthstate(
            name='distance_vision_blindness',
            kind='healthstate',
            gbd_id=hs_id(468),
        ),
    ),
    'blindness_due_to_meningitis': Sequela(
        name='blindness_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22861),
        me_id=me_id(24043),
        healthstate=Healthstate(
            name='distance_vision_blindness',
            kind='healthstate',
            gbd_id=hs_id(468),
        ),
    ),
    'mild_vision_impairment_due_to_retinopathy_of_prematurity': Sequela(
        name='mild_vision_impairment_due_to_retinopathy_of_prematurity',
        kind='sequela',
        gbd_id=s_id(193),
        me_id=me_id(1577),
        healthstate=Healthstate(
            name='distance_vision_mild_impairment',
            kind='healthstate',
            gbd_id=hs_id(465),
        ),
    ),
    'moderate_vision_impairment_due_to_trachoma': Sequela(
        name='moderate_vision_impairment_due_to_trachoma',
        kind='sequela',
        gbd_id=s_id(154),
        me_id=me_id(1501),
        healthstate=Healthstate(
            name='distance_vision_moderate_impairment',
            kind='healthstate',
            gbd_id=hs_id(466),
        ),
    ),
    'moderate_vision_impairment_loss_due_to_vitamin_a_deficiency': Sequela(
        name='moderate_vision_impairment_loss_due_to_vitamin_a_deficiency',
        kind='sequela',
        gbd_id=s_id(203),
        me_id=me_id(1618),
        healthstate=Healthstate(
            name='distance_vision_moderate_impairment',
            kind='healthstate',
            gbd_id=hs_id(466),
        ),
    ),
    'moderate_vision_impairment_due_to_glaucoma': Sequela(
        name='moderate_vision_impairment_due_to_glaucoma',
        kind='sequela',
        gbd_id=s_id(609),
        me_id=me_id(2292),
        healthstate=Healthstate(
            name='distance_vision_moderate_impairment',
            kind='healthstate',
            gbd_id=hs_id(466),
        ),
    ),
    'moderate_vision_impairment_due_to_cataract': Sequela(
        name='moderate_vision_impairment_due_to_cataract',
        kind='sequela',
        gbd_id=s_id(612),
        me_id=me_id(2297),
        healthstate=Healthstate(
            name='distance_vision_moderate_impairment',
            kind='healthstate',
            gbd_id=hs_id(466),
        ),
    ),
    'moderate_vision_impairment_due_to_macular_degeneration': Sequela(
        name='moderate_vision_impairment_due_to_macular_degeneration',
        kind='sequela',
        gbd_id=s_id(615),
        me_id=me_id(2302),
        healthstate=Healthstate(
            name='distance_vision_moderate_impairment',
            kind='healthstate',
            gbd_id=hs_id(466),
        ),
    ),
    'moderate_vision_impairment_due_to_uncorrected_refractive_error': Sequela(
        name='moderate_vision_impairment_due_to_uncorrected_refractive_error',
        kind='sequela',
        gbd_id=s_id(618),
        me_id=me_id(2307),
        healthstate=Healthstate(
            name='distance_vision_moderate_impairment',
            kind='healthstate',
            gbd_id=hs_id(466),
        ),
    ),
    'moderate_vision_impairment_due_to_other_vision_loss': Sequela(
        name='moderate_vision_impairment_due_to_other_vision_loss',
        kind='sequela',
        gbd_id=s_id(634),
        me_id=me_id(2326),
        healthstate=Healthstate(
            name='distance_vision_moderate_impairment',
            kind='healthstate',
            gbd_id=hs_id(466),
        ),
    ),
    'moderate_vision_impairment_due_to_onchocerciasis': Sequela(
        name='moderate_vision_impairment_due_to_onchocerciasis',
        kind='sequela',
        gbd_id=s_id(876),
        me_id=me_id(2957),
        healthstate=Healthstate(
            name='distance_vision_moderate_impairment',
            kind='healthstate',
            gbd_id=hs_id(466),
        ),
    ),
    'moderate_vision_impairment_due_to_retinopathy_of_prematurity': Sequela(
        name='moderate_vision_impairment_due_to_retinopathy_of_prematurity',
        kind='sequela',
        gbd_id=s_id(915),
        me_id=me_id(3027),
        healthstate=Healthstate(
            name='distance_vision_moderate_impairment',
            kind='healthstate',
            gbd_id=hs_id(466),
        ),
    ),
    'moderate_vision_impairment_due_to_encephalitis': Sequela(
        name='moderate_vision_impairment_due_to_encephalitis',
        kind='sequela',
        gbd_id=s_id(1151),
        me_id=me_id(9462),
        healthstate=Healthstate(
            name='distance_vision_moderate_impairment',
            kind='healthstate',
            gbd_id=hs_id(466),
        ),
    ),
    'moderate_vision_impairment_due_to_diabetes_mellitus_type_1_retinopathy': Sequela(
        name='moderate_vision_impairment_due_to_diabetes_mellitus_type_1_retinopathy',
        kind='sequela',
        gbd_id=s_id(5444),
        me_id=me_id(19716),
        healthstate=Healthstate(
            name='distance_vision_moderate_impairment',
            kind='healthstate',
            gbd_id=hs_id(466),
        ),
    ),
    'moderate_vision_impairment_due_to_diabetes_mellitus_type_2_retinopathy': Sequela(
        name='moderate_vision_impairment_due_to_diabetes_mellitus_type_2_retinopathy',
        kind='sequela',
        gbd_id=s_id(5468),
        me_id=me_id(19730),
        healthstate=Healthstate(
            name='distance_vision_moderate_impairment',
            kind='healthstate',
            gbd_id=hs_id(466),
        ),
    ),
    'moderate_vision_impairment_due_to_meningitis': Sequela(
        name='moderate_vision_impairment_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22882),
        me_id=me_id(24181),
        healthstate=Healthstate(
            name='distance_vision_moderate_impairment',
            kind='healthstate',
            gbd_id=hs_id(466),
        ),
    ),
    'monocular_distance_vision_loss_due_to_encephalitis': Sequela(
        name='monocular_distance_vision_loss_due_to_encephalitis',
        kind='sequela',
        gbd_id=s_id(797),
        me_id=me_id(2814),
        healthstate=Healthstate(
            name='distance_vision_monocular',
            kind='healthstate',
            gbd_id=hs_id(704),
        ),
    ),
    'monocular_distance_vision_loss_due_to_meningitis': Sequela(
        name='monocular_distance_vision_loss_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22869),
        me_id=me_id(24057),
        healthstate=Healthstate(
            name='distance_vision_monocular',
            kind='healthstate',
            gbd_id=hs_id(704),
        ),
    ),
    'severe_vision_impairment_due_to_trachoma': Sequela(
        name='severe_vision_impairment_due_to_trachoma',
        kind='sequela',
        gbd_id=s_id(155),
        me_id=me_id(1502),
        healthstate=Healthstate(
            name='distance_vision_severe_impairment',
            kind='healthstate',
            gbd_id=hs_id(467),
        ),
    ),
    'severe_vision_impairment_loss_due_to_vitamin_a_deficiency': Sequela(
        name='severe_vision_impairment_loss_due_to_vitamin_a_deficiency',
        kind='sequela',
        gbd_id=s_id(204),
        me_id=me_id(1619),
        healthstate=Healthstate(
            name='distance_vision_severe_impairment',
            kind='healthstate',
            gbd_id=hs_id(467),
        ),
    ),
    'severe_vision_impairment_due_to_glaucoma': Sequela(
        name='severe_vision_impairment_due_to_glaucoma',
        kind='sequela',
        gbd_id=s_id(610),
        me_id=me_id(2293),
        healthstate=Healthstate(
            name='distance_vision_severe_impairment',
            kind='healthstate',
            gbd_id=hs_id(467),
        ),
    ),
    'severe_vision_impairment_due_to_cataract': Sequela(
        name='severe_vision_impairment_due_to_cataract',
        kind='sequela',
        gbd_id=s_id(613),
        me_id=me_id(2298),
        healthstate=Healthstate(
            name='distance_vision_severe_impairment',
            kind='healthstate',
            gbd_id=hs_id(467),
        ),
    ),
    'severe_vision_impairment_due_to_macular_degeneration': Sequela(
        name='severe_vision_impairment_due_to_macular_degeneration',
        kind='sequela',
        gbd_id=s_id(616),
        me_id=me_id(2303),
        healthstate=Healthstate(
            name='distance_vision_severe_impairment',
            kind='healthstate',
            gbd_id=hs_id(467),
        ),
    ),
    'severe_vision_impairment_due_to_uncorrected_refractive_error': Sequela(
        name='severe_vision_impairment_due_to_uncorrected_refractive_error',
        kind='sequela',
        gbd_id=s_id(619),
        me_id=me_id(2308),
        healthstate=Healthstate(
            name='distance_vision_severe_impairment',
            kind='healthstate',
            gbd_id=hs_id(467),
        ),
    ),
    'severe_vision_impairment_due_to_other_vision_loss': Sequela(
        name='severe_vision_impairment_due_to_other_vision_loss',
        kind='sequela',
        gbd_id=s_id(635),
        me_id=me_id(2327),
        healthstate=Healthstate(
            name='distance_vision_severe_impairment',
            kind='healthstate',
            gbd_id=hs_id(467),
        ),
    ),
    'severe_vision_impairment_due_to_onchocerciasis': Sequela(
        name='severe_vision_impairment_due_to_onchocerciasis',
        kind='sequela',
        gbd_id=s_id(877),
        me_id=me_id(2958),
        healthstate=Healthstate(
            name='distance_vision_severe_impairment',
            kind='healthstate',
            gbd_id=hs_id(467),
        ),
    ),
    'severe_vision_impairment_due_to_retinopathy_of_prematurity': Sequela(
        name='severe_vision_impairment_due_to_retinopathy_of_prematurity',
        kind='sequela',
        gbd_id=s_id(916),
        me_id=me_id(3028),
        healthstate=Healthstate(
            name='distance_vision_severe_impairment',
            kind='healthstate',
            gbd_id=hs_id(467),
        ),
    ),
    'severe_vision_impairment_due_to_encephalitis': Sequela(
        name='severe_vision_impairment_due_to_encephalitis',
        kind='sequela',
        gbd_id=s_id(1152),
        me_id=me_id(9463),
        healthstate=Healthstate(
            name='distance_vision_severe_impairment',
            kind='healthstate',
            gbd_id=hs_id(467),
        ),
    ),
    'severe_vision_impairment_due_to_diabetes_mellitus_type_1_retinopathy': Sequela(
        name='severe_vision_impairment_due_to_diabetes_mellitus_type_1_retinopathy',
        kind='sequela',
        gbd_id=s_id(5447),
        me_id=me_id(19717),
        healthstate=Healthstate(
            name='distance_vision_severe_impairment',
            kind='healthstate',
            gbd_id=hs_id(467),
        ),
    ),
    'severe_vision_impairment_due_to_diabetes_mellitus_type_2_retinopathy': Sequela(
        name='severe_vision_impairment_due_to_diabetes_mellitus_type_2_retinopathy',
        kind='sequela',
        gbd_id=s_id(5471),
        me_id=me_id(19731),
        healthstate=Healthstate(
            name='distance_vision_severe_impairment',
            kind='healthstate',
            gbd_id=hs_id(467),
        ),
    ),
    'severe_vision_impairment_due_to_meningitis': Sequela(
        name='severe_vision_impairment_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22883),
        me_id=me_id(24182),
        healthstate=Healthstate(
            name='distance_vision_severe_impairment',
            kind='healthstate',
            gbd_id=hs_id(467),
        ),
    ),
    'acute_otitis_media': Sequela(
        name='acute_otitis_media',
        kind='sequela',
        gbd_id=s_id(18),
        me_id=me_id(1281),
        healthstate=Healthstate(
            name='ear_pain',
            kind='healthstate',
            gbd_id=hs_id(365),
        ),
    ),
    'severe_infectious_complications_due_to_chronic_otitis_media': Sequela(
        name='severe_infectious_complications_due_to_chronic_otitis_media',
        kind='sequela',
        gbd_id=s_id(829),
        me_id=me_id(2871),
        healthstate=Healthstate(
            name='ear_pain',
            kind='healthstate',
            gbd_id=hs_id(365),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_without_anemia_due_to_type_1_diabetes_mellitus': Sequela(
        name='end_stage_renal_disease_on_dialysis_without_anemia_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(23019),
        me_id=me_id(23441),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis',
            kind='healthstate',
            gbd_id=hs_id(393),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_without_anemia_due_to_type_2_diabetes_mellitus': Sequela(
        name='end_stage_renal_disease_on_dialysis_without_anemia_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(23020),
        me_id=me_id(23442),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis',
            kind='healthstate',
            gbd_id=hs_id(393),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_without_anemia_due_to_hypertension': Sequela(
        name='end_stage_renal_disease_on_dialysis_without_anemia_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(23021),
        me_id=me_id(23443),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis',
            kind='healthstate',
            gbd_id=hs_id(393),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_without_anemia_due_to_glomerulonephritis': Sequela(
        name='end_stage_renal_disease_on_dialysis_without_anemia_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(23022),
        me_id=me_id(23444),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis',
            kind='healthstate',
            gbd_id=hs_id(393),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_without_anemia_due_to_other_and_unspecified_causes': Sequela(
        name='end_stage_renal_disease_on_dialysis_without_anemia_due_to_other_and_unspecified_causes',
        kind='sequela',
        gbd_id=s_id(23023),
        me_id=me_id(23445),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis',
            kind='healthstate',
            gbd_id=hs_id(393),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_type_1_diabetes_mellitus': Sequela(
        name='end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(22989),
        me_id=me_id(23411),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis_and_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2694),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_type_2_diabetes_mellitus': Sequela(
        name='end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(22990),
        me_id=me_id(23412),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis_and_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2694),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_hypertension': Sequela(
        name='end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(22991),
        me_id=me_id(23413),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis_and_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2694),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_glomerulonephritis': Sequela(
        name='end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(22992),
        me_id=me_id(23414),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis_and_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2694),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_other_and_unspecified_causes': Sequela(
        name='end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_other_and_unspecified_causes',
        kind='sequela',
        gbd_id=s_id(22993),
        me_id=me_id(23415),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis_and_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2694),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_type_1_diabetes_mellitus': Sequela(
        name='end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(22999),
        me_id=me_id(23421),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis_and_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2724),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_type_2_diabetes_mellitus': Sequela(
        name='end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(23000),
        me_id=me_id(23422),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis_and_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2724),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_hypertension': Sequela(
        name='end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(23001),
        me_id=me_id(23423),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis_and_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2724),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_glomerulonephritis': Sequela(
        name='end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(23002),
        me_id=me_id(23424),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis_and_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2724),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_other_and_unspecified_causes': Sequela(
        name='end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_other_and_unspecified_causes',
        kind='sequela',
        gbd_id=s_id(23003),
        me_id=me_id(23425),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis_and_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2724),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_type_1_diabetes_mellitus': Sequela(
        name='end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(23009),
        me_id=me_id(23431),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis_and_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(2725),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_type_2_diabetes_mellitus': Sequela(
        name='end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(23010),
        me_id=me_id(23432),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis_and_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(2725),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_hypertension': Sequela(
        name='end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(23011),
        me_id=me_id(23433),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis_and_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(2725),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_glomerulonephritis': Sequela(
        name='end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(23012),
        me_id=me_id(23434),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis_and_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(2725),
        ),
    ),
    'end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_other_and_unspecified_causes': Sequela(
        name='end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_other_and_unspecified_causes',
        kind='sequela',
        gbd_id=s_id(23013),
        me_id=me_id(23435),
        healthstate=Healthstate(
            name='end_stage_renal_disease_on_dialysis_and_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(2725),
        ),
    ),
    'end_stage_renal_disease_after_transplant_due_to_hypertension': Sequela(
        name='end_stage_renal_disease_after_transplant_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(501),
        me_id=me_id(2033),
        healthstate=Healthstate(
            name='end_stage_renal_disease_with_kidney_transplant',
            kind='healthstate',
            gbd_id=hs_id(392),
        ),
    ),
    'end_stage_renal_disease_after_transplant_due_to_glomerulonephritis': Sequela(
        name='end_stage_renal_disease_after_transplant_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(504),
        me_id=me_id(2041),
        healthstate=Healthstate(
            name='end_stage_renal_disease_with_kidney_transplant',
            kind='healthstate',
            gbd_id=hs_id(392),
        ),
    ),
    'end_stage_renal_disease_after_transplant_due_to_other_and_unspecified_causes': Sequela(
        name='end_stage_renal_disease_after_transplant_due_to_other_and_unspecified_causes',
        kind='sequela',
        gbd_id=s_id(507),
        me_id=me_id(2049),
        healthstate=Healthstate(
            name='end_stage_renal_disease_with_kidney_transplant',
            kind='healthstate',
            gbd_id=hs_id(392),
        ),
    ),
    'end_stage_renal_disease_after_transplant_due_to_type_1_diabetes_mellitus': Sequela(
        name='end_stage_renal_disease_after_transplant_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5201),
        me_id=me_id(19405),
        healthstate=Healthstate(
            name='end_stage_renal_disease_with_kidney_transplant',
            kind='healthstate',
            gbd_id=hs_id(392),
        ),
    ),
    'end_stage_renal_disease_after_transplant_due_to_type_2_diabetes_mellitus': Sequela(
        name='end_stage_renal_disease_after_transplant_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5204),
        me_id=me_id(19406),
        healthstate=Healthstate(
            name='end_stage_renal_disease_with_kidney_transplant',
            kind='healthstate',
            gbd_id=hs_id(392),
        ),
    ),
    'hydrocele_due_to_lymphatic_filariasis': Sequela(
        name='hydrocele_due_to_lymphatic_filariasis',
        kind='sequela',
        gbd_id=s_id(151),
        me_id=me_id(1493),
        healthstate=Healthstate(
            name='epididymo_orchitis',
            kind='healthstate',
            gbd_id=hs_id(358),
        ),
    ),
    'epididymo_orchitis_due_to_chlamydial_infection': Sequela(
        name='epididymo_orchitis_due_to_chlamydial_infection',
        kind='sequela',
        gbd_id=s_id(214),
        me_id=me_id(1630),
        healthstate=Healthstate(
            name='epididymo_orchitis',
            kind='healthstate',
            gbd_id=hs_id(358),
        ),
    ),
    'epididymo_orchitis_due_to_gonococcal_infection': Sequela(
        name='epididymo_orchitis_due_to_gonococcal_infection',
        kind='sequela',
        gbd_id=s_id(219),
        me_id=me_id(1636),
        healthstate=Healthstate(
            name='epididymo_orchitis',
            kind='healthstate',
            gbd_id=hs_id(358),
        ),
    ),
    'cerebral_paragonimiasis': Sequela(
        name='cerebral_paragonimiasis',
        kind='sequela',
        gbd_id=s_id(175),
        me_id=me_id(3617),
        healthstate=Healthstate(
            name='epilepsy',
            kind='healthstate',
            gbd_id=hs_id(772),
        ),
    ),
    'neurocysticercosis_with_epilepsy': Sequela(
        name='neurocysticercosis_with_epilepsy',
        kind='sequela',
        gbd_id=s_id(689),
        me_id=me_id(3605),
        healthstate=Healthstate(
            name='epilepsy',
            kind='healthstate',
            gbd_id=hs_id(772),
        ),
    ),
    'epilepsy_due_to_echinococcosis': Sequela(
        name='epilepsy_due_to_echinococcosis',
        kind='sequela',
        gbd_id=s_id(787),
        me_id=me_id(3608),
        healthstate=Healthstate(
            name='epilepsy',
            kind='healthstate',
            gbd_id=hs_id(772),
        ),
    ),
    'epilepsy_due_to_encephalitis': Sequela(
        name='epilepsy_due_to_encephalitis',
        kind='sequela',
        gbd_id=s_id(803),
        me_id=me_id(3506),
        healthstate=Healthstate(
            name='epilepsy',
            kind='healthstate',
            gbd_id=hs_id(772),
        ),
    ),
    'epilepsy_due_to_meningitis': Sequela(
        name='epilepsy_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22865),
        me_id=me_id(24050),
        healthstate=Healthstate(
            name='epilepsy',
            kind='healthstate',
            gbd_id=hs_id(772),
        ),
    ),
    'idiopathic_severe_epilepsy': Sequela(
        name='idiopathic_severe_epilepsy',
        kind='sequela',
        gbd_id=s_id(460),
        me_id=me_id(1953),
        healthstate=Healthstate(
            name='epilepsy_seizures_greater_than___once_a_month',
            kind='healthstate',
            gbd_id=hs_id(745),
        ),
    ),
    'idiopathic_less_severe_epilepsy': Sequela(
        name='idiopathic_less_severe_epilepsy',
        kind='sequela',
        gbd_id=s_id(459),
        me_id=me_id(1952),
        healthstate=Healthstate(
            name='epilepsy_seizures_1_11_per_year',
            kind='healthstate',
            gbd_id=hs_id(746),
        ),
    ),
    'mild_fetal_alcohol_syndrome': Sequela(
        name='mild_fetal_alcohol_syndrome',
        kind='sequela',
        gbd_id=s_id(471),
        me_id=me_id(9970),
        healthstate=Healthstate(
            name='fetal_alcohol_syndrome_mild',
            kind='healthstate',
            gbd_id=hs_id(427),
        ),
    ),
    'moderate_fetal_alcohol_syndrome': Sequela(
        name='moderate_fetal_alcohol_syndrome',
        kind='sequela',
        gbd_id=s_id(472),
        me_id=me_id(3905),
        healthstate=Healthstate(
            name='fetal_alcohol_syndrome_moderate',
            kind='healthstate',
            gbd_id=hs_id(428),
        ),
    ),
    'severe_fetal_alcohol_syndrome': Sequela(
        name='severe_fetal_alcohol_syndrome',
        kind='sequela',
        gbd_id=s_id(473),
        me_id=me_id(3908),
        healthstate=Healthstate(
            name='fetal_alcohol_syndrome_severe',
            kind='healthstate',
            gbd_id=hs_id(429),
        ),
    ),
    'hematemesis_due_to_schistosomiasis': Sequela(
        name='hematemesis_due_to_schistosomiasis',
        kind='sequela',
        gbd_id=s_id(138),
        me_id=me_id(1470),
        healthstate=Healthstate(
            name='gastric_bleeding',
            kind='healthstate',
            gbd_id=hs_id(395),
        ),
    ),
    'gastrointestinal_bleeding_due_to_typhoid': Sequela(
        name='gastrointestinal_bleeding_due_to_typhoid',
        kind='sequela',
        gbd_id=s_id(971),
        me_id=me_id(3134),
        healthstate=Healthstate(
            name='gastric_bleeding',
            kind='healthstate',
            gbd_id=hs_id(395),
        ),
    ),
    'complicated_pud_with_no_anemia': Sequela(
        name='complicated_pud_with_no_anemia',
        kind='sequela',
        gbd_id=s_id(5624),
        me_id=me_id(19841),
        healthstate=Healthstate(
            name='gastric_bleeding',
            kind='healthstate',
            gbd_id=hs_id(395),
        ),
    ),
    'complicated_gastritis_duodenitis_with_no_anemia': Sequela(
        name='complicated_gastritis_duodenitis_with_no_anemia',
        kind='sequela',
        gbd_id=s_id(5675),
        me_id=me_id(19888),
        healthstate=Healthstate(
            name='gastric_bleeding',
            kind='healthstate',
            gbd_id=hs_id(395),
        ),
    ),
    'complicated_pud_with_mild_anemia': Sequela(
        name='complicated_pud_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(5627),
        me_id=me_id(19842),
        healthstate=Healthstate(
            name='gastric_bleeding_and_anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(2648),
        ),
    ),
    'complicated_gastritis_duodenitis_with_mild_anemia': Sequela(
        name='complicated_gastritis_duodenitis_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(5678),
        me_id=me_id(19889),
        healthstate=Healthstate(
            name='gastric_bleeding_and_anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(2648),
        ),
    ),
    'complicated_pud_with_moderate_anemia': Sequela(
        name='complicated_pud_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(5630),
        me_id=me_id(19843),
        healthstate=Healthstate(
            name='gastric_bleeding_and_anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(2651),
        ),
    ),
    'complicated_gastritis_duodenitis_with_moderate_anemia': Sequela(
        name='complicated_gastritis_duodenitis_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(5681),
        me_id=me_id(19890),
        healthstate=Healthstate(
            name='gastric_bleeding_and_anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(2651),
        ),
    ),
    'complicated_pud_with_severe_anemia': Sequela(
        name='complicated_pud_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5633),
        me_id=me_id(19844),
        healthstate=Healthstate(
            name='gastric_bleeding_and_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(2654),
        ),
    ),
    'complicated_gastritis_duodenitis_with_severe_anemia': Sequela(
        name='complicated_gastritis_duodenitis_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5684),
        me_id=me_id(19891),
        healthstate=Healthstate(
            name='gastric_bleeding_and_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(2654),
        ),
    ),
    'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_without_anemia': Sequela(
        name='homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_without_anemia',
        kind='sequela',
        gbd_id=s_id(1073),
        me_id=me_id(3295),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_and_severe_abdominopelvic_problem',
            kind='healthstate',
            gbd_id=hs_id(814),
        ),
    ),
    'hemoglobin_sc_disease_with_vaso_occlusive_crisis_without_anemia': Sequela(
        name='hemoglobin_sc_disease_with_vaso_occlusive_crisis_without_anemia',
        kind='sequela',
        gbd_id=s_id(1084),
        me_id=me_id(3306),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_and_severe_abdominopelvic_problem',
            kind='healthstate',
            gbd_id=hs_id(814),
        ),
    ),
    'mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_without_anemia': Sequela(
        name='mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_without_anemia',
        kind='sequela',
        gbd_id=s_id(1094),
        me_id=me_id(3316),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_and_severe_abdominopelvic_problem',
            kind='healthstate',
            gbd_id=hs_id(814),
        ),
    ),
    'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_stroke_without_anemia': Sequela(
        name='homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_stroke_without_anemia',
        kind='sequela',
        gbd_id=s_id(1076),
        me_id=me_id(3298),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_long_term_consequences_due_to_stroke',
            kind='healthstate',
            gbd_id=hs_id(815),
        ),
    ),
    'hemoglobin_sc_disease_with_stroke_without_anemia': Sequela(
        name='hemoglobin_sc_disease_with_stroke_without_anemia',
        kind='sequela',
        gbd_id=s_id(1086),
        me_id=me_id(3308),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_long_term_consequences_due_to_stroke',
            kind='healthstate',
            gbd_id=hs_id(815),
        ),
    ),
    'mild_sickle_cell_beta_thalassemia_with_stroke_without_anemia': Sequela(
        name='mild_sickle_cell_beta_thalassemia_with_stroke_without_anemia',
        kind='sequela',
        gbd_id=s_id(1096),
        me_id=me_id(3318),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_long_term_consequences_due_to_stroke',
            kind='healthstate',
            gbd_id=hs_id(815),
        ),
    ),
    'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_stroke_and_severe_anemia': Sequela(
        name='homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_stroke_and_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1075),
        me_id=me_id(3297),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_long_term_consequences_due_to_stroke_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(858),
        ),
    ),
    'hemoglobin_sc_disease_with_stroke_and_severe_anemia': Sequela(
        name='hemoglobin_sc_disease_with_stroke_and_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1085),
        me_id=me_id(3307),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_long_term_consequences_due_to_stroke_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(858),
        ),
    ),
    'mild_sickle_cell_beta_thalassemia_with_stroke_and_severe_anemia': Sequela(
        name='mild_sickle_cell_beta_thalassemia_with_stroke_and_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1095),
        me_id=me_id(3317),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_long_term_consequences_due_to_stroke_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(858),
        ),
    ),
    'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_stroke_without_anemia': Sequela(
        name='homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_stroke_without_anemia',
        kind='sequela',
        gbd_id=s_id(1078),
        me_id=me_id(3300),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_long_term_consequences_due_to_stroke_severe_abdominopelvic_problem',
            kind='healthstate',
            gbd_id=hs_id(816),
        ),
    ),
    'hemoglobin_sc_disease_with_vaso_occlusive_crisis_and_stroke_without_anemia': Sequela(
        name='hemoglobin_sc_disease_with_vaso_occlusive_crisis_and_stroke_without_anemia',
        kind='sequela',
        gbd_id=s_id(1088),
        me_id=me_id(3310),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_long_term_consequences_due_to_stroke_severe_abdominopelvic_problem',
            kind='healthstate',
            gbd_id=hs_id(816),
        ),
    ),
    'mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_stroke_without_anemia': Sequela(
        name='mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_stroke_without_anemia',
        kind='sequela',
        gbd_id=s_id(1098),
        me_id=me_id(3320),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_long_term_consequences_due_to_stroke_severe_abdominopelvic_problem',
            kind='healthstate',
            gbd_id=hs_id(816),
        ),
    ),
    'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_stroke_and_severe_anemia': Sequela(
        name='homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_stroke_and_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1077),
        me_id=me_id(3299),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_long_term_consequences_due_to_stroke_severe_abdominopelvic_problem_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(859),
        ),
    ),
    'hemoglobin_sc_disease_with_vaso_occlusive_crisis_stroke_and_severe_anemia': Sequela(
        name='hemoglobin_sc_disease_with_vaso_occlusive_crisis_stroke_and_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1087),
        me_id=me_id(3309),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_long_term_consequences_due_to_stroke_severe_abdominopelvic_problem_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(859),
        ),
    ),
    'mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_stroke_and_severe_anemia': Sequela(
        name='mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_stroke_and_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1097),
        me_id=me_id(3319),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_long_term_consequences_due_to_stroke_severe_abdominopelvic_problem_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(859),
        ),
    ),
    'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_without_anemia': Sequela(
        name='homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_without_anemia',
        kind='sequela',
        gbd_id=s_id(1072),
        me_id=me_id(3294),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_about_diagnosis',
            kind='healthstate',
            gbd_id=hs_id(560),
        ),
    ),
    'hemoglobin_sc_disease_without_anemia': Sequela(
        name='hemoglobin_sc_disease_without_anemia',
        kind='sequela',
        gbd_id=s_id(1082),
        me_id=me_id(3304),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_about_diagnosis',
            kind='healthstate',
            gbd_id=hs_id(560),
        ),
    ),
    'mild_sickle_cell_beta_thalassemia_without_anemia': Sequela(
        name='mild_sickle_cell_beta_thalassemia_without_anemia',
        kind='sequela',
        gbd_id=s_id(1092),
        me_id=me_id(3314),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_about_diagnosis',
            kind='healthstate',
            gbd_id=hs_id(560),
        ),
    ),
    'hemoglobin_h_disease_without_anemia': Sequela(
        name='hemoglobin_h_disease_without_anemia',
        kind='sequela',
        gbd_id=s_id(1113),
        me_id=me_id(3343),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_about_diagnosis',
            kind='healthstate',
            gbd_id=hs_id(560),
        ),
    ),
    'beta_thalassemia_major_without_anemia': Sequela(
        name='beta_thalassemia_major_without_anemia',
        kind='sequela',
        gbd_id=s_id(1114),
        me_id=me_id(3344),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_about_diagnosis',
            kind='healthstate',
            gbd_id=hs_id(560),
        ),
    ),
    'hemoglobin_e_beta_thalassemia_without_anemia': Sequela(
        name='hemoglobin_e_beta_thalassemia_without_anemia',
        kind='sequela',
        gbd_id=s_id(1115),
        me_id=me_id(3345),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_about_diagnosis',
            kind='healthstate',
            gbd_id=hs_id(560),
        ),
    ),
    'diagnosis_of_motor_neuron_disease': Sequela(
        name='diagnosis_of_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1183),
        me_id=me_id(9710),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_about_diagnosis',
            kind='healthstate',
            gbd_id=hs_id(560),
        ),
    ),
    'early_hiv_without_anemia': Sequela(
        name='early_hiv_without_anemia',
        kind='sequela',
        gbd_id=s_id(5060),
        me_id=me_id(16324),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_about_diagnosis',
            kind='healthstate',
            gbd_id=hs_id(560),
        ),
    ),
    'other_combined_sequelae_of_homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia': Sequela(
        name='other_combined_sequelae_of_homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia',
        kind='sequela',
        gbd_id=s_id(23057),
        me_id=me_id(3357),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_about_diagnosis',
            kind='healthstate',
            gbd_id=hs_id(560),
        ),
    ),
    'other_combined_sequelae_of_hemoglobin_sc_disease': Sequela(
        name='other_combined_sequelae_of_hemoglobin_sc_disease',
        kind='sequela',
        gbd_id=s_id(23058),
        me_id=me_id(3358),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_about_diagnosis',
            kind='healthstate',
            gbd_id=hs_id(560),
        ),
    ),
    'other_combined_sequelae_of_mild_sickle_cell_beta_thalassemia_exclusivity_adjustment': Sequela(
        name='other_combined_sequelae_of_mild_sickle_cell_beta_thalassemia_exclusivity_adjustment',
        kind='sequela',
        gbd_id=s_id(23059),
        me_id=me_id(3359),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_anxiety_about_diagnosis',
            kind='healthstate',
            gbd_id=hs_id(560),
        ),
    ),
    'controlled_phase_of_esophageal_cancer': Sequela(
        name='controlled_phase_of_esophageal_cancer',
        kind='sequela',
        gbd_id=s_id(245),
        me_id=me_id(1671),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_stomach_cancer': Sequela(
        name='controlled_phase_of_stomach_cancer',
        kind='sequela',
        gbd_id=s_id(249),
        me_id=me_id(1675),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_liver_cancer_due_to_hepatitis_b': Sequela(
        name='controlled_phase_of_liver_cancer_due_to_hepatitis_b',
        kind='sequela',
        gbd_id=s_id(253),
        me_id=me_id(1683),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_liver_cancer_due_to_hepatitis_c': Sequela(
        name='controlled_phase_of_liver_cancer_due_to_hepatitis_c',
        kind='sequela',
        gbd_id=s_id(257),
        me_id=me_id(1687),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_liver_cancer_due_to_alcohol_use': Sequela(
        name='controlled_phase_of_liver_cancer_due_to_alcohol_use',
        kind='sequela',
        gbd_id=s_id(261),
        me_id=me_id(1691),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_liver_cancer_due_to_other_causes': Sequela(
        name='controlled_phase_of_liver_cancer_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(265),
        me_id=me_id(1695),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_lung_bronchus_and_trachea_cancer': Sequela(
        name='controlled_phase_of_lung_bronchus_and_trachea_cancer',
        kind='sequela',
        gbd_id=s_id(274),
        me_id=me_id(1704),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_cervical_cancer': Sequela(
        name='controlled_phase_of_cervical_cancer',
        kind='sequela',
        gbd_id=s_id(283),
        me_id=me_id(1713),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_uterine_cancer': Sequela(
        name='controlled_phase_of_uterine_cancer',
        kind='sequela',
        gbd_id=s_id(287),
        me_id=me_id(1717),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_mouth_cancer': Sequela(
        name='controlled_phase_of_mouth_cancer',
        kind='sequela',
        gbd_id=s_id(302),
        me_id=me_id(1733),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_nasopharynx_cancer': Sequela(
        name='controlled_phase_of_nasopharynx_cancer',
        kind='sequela',
        gbd_id=s_id(306),
        me_id=me_id(1737),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_other_pharynx_cancer': Sequela(
        name='controlled_phase_of_other_pharynx_cancer',
        kind='sequela',
        gbd_id=s_id(310),
        me_id=me_id(1741),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_gallbladder_and_biliary_tract_cancer': Sequela(
        name='controlled_phase_of_gallbladder_and_biliary_tract_cancer',
        kind='sequela',
        gbd_id=s_id(314),
        me_id=me_id(1745),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_pancreatic_cancer': Sequela(
        name='controlled_phase_of_pancreatic_cancer',
        kind='sequela',
        gbd_id=s_id(318),
        me_id=me_id(1749),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_malignant_skin_melanoma': Sequela(
        name='controlled_phase_of_malignant_skin_melanoma',
        kind='sequela',
        gbd_id=s_id(322),
        me_id=me_id(1753),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_ovarian_cancer': Sequela(
        name='controlled_phase_of_ovarian_cancer',
        kind='sequela',
        gbd_id=s_id(330),
        me_id=me_id(1762),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_testicular_cancer': Sequela(
        name='controlled_phase_of_testicular_cancer',
        kind='sequela',
        gbd_id=s_id(334),
        me_id=me_id(1766),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_kidney_cancer': Sequela(
        name='controlled_phase_of_kidney_cancer',
        kind='sequela',
        gbd_id=s_id(338),
        me_id=me_id(1770),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_brain_and_central_nervous_system_cancers': Sequela(
        name='controlled_phase_of_brain_and_central_nervous_system_cancers',
        kind='sequela',
        gbd_id=s_id(347),
        me_id=me_id(1779),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_thyroid_cancer': Sequela(
        name='controlled_phase_of_thyroid_cancer',
        kind='sequela',
        gbd_id=s_id(351),
        me_id=me_id(1783),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_mesothelioma': Sequela(
        name='controlled_phase_of_mesothelioma',
        kind='sequela',
        gbd_id=s_id(355),
        me_id=me_id(1787),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_hodgkin_disease': Sequela(
        name='controlled_phase_of_hodgkin_disease',
        kind='sequela',
        gbd_id=s_id(359),
        me_id=me_id(1791),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_multiple_myeloma': Sequela(
        name='controlled_phase_of_multiple_myeloma',
        kind='sequela',
        gbd_id=s_id(367),
        me_id=me_id(1799),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'idiopathic_seizure_free_treated_epilepsy': Sequela(
        name='idiopathic_seizure_free_treated_epilepsy',
        kind='sequela',
        gbd_id=s_id(458),
        me_id=me_id(1951),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'other_hypertensive_disorders_of_pregnancy': Sequela(
        name='other_hypertensive_disorders_of_pregnancy',
        kind='sequela',
        gbd_id=s_id(676),
        me_id=me_id(2625),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'rheumatic_heart_disease_without_heart_failure': Sequela(
        name='rheumatic_heart_disease_without_heart_failure',
        kind='sequela',
        gbd_id=s_id(1116),
        me_id=me_id(3346),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_acute_lymphoid_leukemia': Sequela(
        name='controlled_phase_of_acute_lymphoid_leukemia',
        kind='sequela',
        gbd_id=s_id(1190),
        me_id=me_id(9477),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_acute_myeloid_leukemia': Sequela(
        name='controlled_phase_of_acute_myeloid_leukemia',
        kind='sequela',
        gbd_id=s_id(1191),
        me_id=me_id(9487),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_chronic_lymphoid_leukemia': Sequela(
        name='controlled_phase_of_chronic_lymphoid_leukemia',
        kind='sequela',
        gbd_id=s_id(1192),
        me_id=me_id(9482),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_chronic_myeloid_leukemia': Sequela(
        name='controlled_phase_of_chronic_myeloid_leukemia',
        kind='sequela',
        gbd_id=s_id(1193),
        me_id=me_id(9492),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_other_leukemia': Sequela(
        name='controlled_phase_of_other_leukemia',
        kind='sequela',
        gbd_id=s_id(1490),
        me_id=me_id(10738),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'calcific_aortic_valve_disease_after_valve_intervention': Sequela(
        name='calcific_aortic_valve_disease_after_valve_intervention',
        kind='sequela',
        gbd_id=s_id(5285),
        me_id=me_id(19578),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'degenerative_mitral_valve_disease_after_valve_intervention': Sequela(
        name='degenerative_mitral_valve_disease_after_valve_intervention',
        kind='sequela',
        gbd_id=s_id(5300),
        me_id=me_id(19582),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'myelodysplastic_myeloproliferative_and_other_hematopoietic_neoplasms': Sequela(
        name='myelodysplastic_myeloproliferative_and_other_hematopoietic_neoplasms',
        kind='sequela',
        gbd_id=s_id(5405),
        me_id=me_id(18759),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_liver_cancer_due_to_nash': Sequela(
        name='controlled_phase_of_liver_cancer_due_to_nash',
        kind='sequela',
        gbd_id=s_id(5420),
        me_id=me_id(18765),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'uncomplicated_diabetes_mellitus_type_1': Sequela(
        name='uncomplicated_diabetes_mellitus_type_1',
        kind='sequela',
        gbd_id=s_id(5441),
        me_id=me_id(19706),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'uncomplicated_diabetes_mellitus_type_2': Sequela(
        name='uncomplicated_diabetes_mellitus_type_2',
        kind='sequela',
        gbd_id=s_id(5465),
        me_id=me_id(19720),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_breast_cancer_without_mastectomy': Sequela(
        name='controlled_phase_of_breast_cancer_without_mastectomy',
        kind='sequela',
        gbd_id=s_id(5489),
        me_id=me_id(18779),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_prostate_cancer_without_impotence_or_incontinence': Sequela(
        name='controlled_phase_of_prostate_cancer_without_impotence_or_incontinence',
        kind='sequela',
        gbd_id=s_id(5501),
        me_id=me_id(18783),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_larynx_cancer_without_laryngectomy': Sequela(
        name='controlled_phase_of_larynx_cancer_without_laryngectomy',
        kind='sequela',
        gbd_id=s_id(5513),
        me_id=me_id(18787),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_colon_and_rectum_cancers_without_stoma': Sequela(
        name='controlled_phase_of_colon_and_rectum_cancers_without_stoma',
        kind='sequela',
        gbd_id=s_id(5522),
        me_id=me_id(18790),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_bladder_cancer_without_incontinence': Sequela(
        name='controlled_phase_of_bladder_cancer_without_incontinence',
        kind='sequela',
        gbd_id=s_id(5531),
        me_id=me_id(18793),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_ischemic_heart_disease': Sequela(
        name='controlled_medically_managed_heart_failure_due_ischemic_heart_disease',
        kind='sequela',
        gbd_id=s_id(5726),
        me_id=me_id(20028),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_alcoholic_cardiomyopathy': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_alcoholic_cardiomyopathy',
        kind='sequela',
        gbd_id=s_id(5729),
        me_id=me_id(20066),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_calcific_aortic_valve_disease': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_calcific_aortic_valve_disease',
        kind='sequela',
        gbd_id=s_id(5732),
        me_id=me_id(20069),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_chagas_disease': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_chagas_disease',
        kind='sequela',
        gbd_id=s_id(5735),
        me_id=me_id(20026),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_degenerative_mitral_valve_disease': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_degenerative_mitral_valve_disease',
        kind='sequela',
        gbd_id=s_id(5738),
        me_id=me_id(20070),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_endocarditis': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_endocarditis',
        kind='sequela',
        gbd_id=s_id(5741),
        me_id=me_id(20030),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders',
        kind='sequela',
        gbd_id=s_id(5744),
        me_id=me_id(20041),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_g6pd_deficiency': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_g6pd_deficiency',
        kind='sequela',
        gbd_id=s_id(5747),
        me_id=me_id(20039),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_hypertensive_heart_disease': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_hypertensive_heart_disease',
        kind='sequela',
        gbd_id=s_id(5750),
        me_id=me_id(20029),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_myocarditis': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_myocarditis',
        kind='sequela',
        gbd_id=s_id(5753),
        me_id=me_id(20067),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_other_cardiomyopathy': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_other_cardiomyopathy',
        kind='sequela',
        gbd_id=s_id(5756),
        me_id=me_id(20068),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_other_cardiovascular_disease': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_other_cardiovascular_disease',
        kind='sequela',
        gbd_id=s_id(5759),
        me_id=me_id(20031),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias',
        kind='sequela',
        gbd_id=s_id(5762),
        me_id=me_id(20040),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_other_non_rheumatic_valve_disease': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_other_non_rheumatic_valve_disease',
        kind='sequela',
        gbd_id=s_id(5765),
        me_id=me_id(20071),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_rheumatic_heart_disease': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_rheumatic_heart_disease',
        kind='sequela',
        gbd_id=s_id(5768),
        me_id=me_id(20180),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_thalassemias': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_thalassemias',
        kind='sequela',
        gbd_id=s_id(5789),
        me_id=me_id(20038),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_other_malignant_neoplasms': Sequela(
        name='controlled_phase_of_other_malignant_neoplasms',
        kind='sequela',
        gbd_id=s_id(5867),
        me_id=me_id(19825),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_burkitt_lymphoma': Sequela(
        name='controlled_phase_of_burkitt_lymphoma',
        kind='sequela',
        gbd_id=s_id(22893),
        me_id=me_id(23779),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_other_non_hodgkin_lymphoma': Sequela(
        name='controlled_phase_of_other_non_hodgkin_lymphoma',
        kind='sequela',
        gbd_id=s_id(22897),
        me_id=me_id(23784),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_hepatoblastoma': Sequela(
        name='controlled_phase_of_hepatoblastoma',
        kind='sequela',
        gbd_id=s_id(22901),
        me_id=me_id(23789),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_retinoblastoma': Sequela(
        name='controlled_phase_of_retinoblastoma',
        kind='sequela',
        gbd_id=s_id(22913),
        me_id=me_id(23799),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_other_eye_cancers': Sequela(
        name='controlled_phase_of_other_eye_cancers',
        kind='sequela',
        gbd_id=s_id(22917),
        me_id=me_id(23804),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_soft_tissue_and_other_extraosseous_sarcomas': Sequela(
        name='controlled_phase_of_soft_tissue_and_other_extraosseous_sarcomas',
        kind='sequela',
        gbd_id=s_id(22921),
        me_id=me_id(23809),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_malignant_bone_tumors': Sequela(
        name='controlled_phase_of_malignant_bone_tumors',
        kind='sequela',
        gbd_id=s_id(22925),
        me_id=me_id(23814),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors': Sequela(
        name='controlled_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors',
        kind='sequela',
        gbd_id=s_id(22929),
        me_id=me_id(23819),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'controlled_medically_managed_heart_failure_due_to_pulmonary_arterial_hypertension': Sequela(
        name='controlled_medically_managed_heart_failure_due_to_pulmonary_arterial_hypertension',
        kind='sequela',
        gbd_id=s_id(22932),
        me_id=me_id(23945),
        healthstate=Healthstate(
            name='generic_uncomplicated_disease_worry_and_daily_medication',
            kind='healthstate',
            gbd_id=hs_id(559),
        ),
    ),
    'symptomatic_episodes_of_gout': Sequela(
        name='symptomatic_episodes_of_gout',
        kind='sequela',
        gbd_id=s_id(823),
        me_id=me_id(2865),
        healthstate=Healthstate(
            name='gout_acute',
            kind='healthstate',
            gbd_id=hs_id(485),
        ),
    ),
    'symptomatic_medication_overuse_headache_due_to_migraine': Sequela(
        name='symptomatic_medication_overuse_headache_due_to_migraine',
        kind='sequela',
        gbd_id=s_id(1349),
        me_id=me_id(10849),
        healthstate=Healthstate(
            name='headache_medication_overuse',
            kind='healthstate',
            gbd_id=hs_id(413),
        ),
    ),
    'symptomatic_medication_overuse_headache_due_to_tension_type_headache': Sequela(
        name='symptomatic_medication_overuse_headache_due_to_tension_type_headache',
        kind='sequela',
        gbd_id=s_id(1355),
        me_id=me_id(10852),
        healthstate=Healthstate(
            name='headache_medication_overuse',
            kind='healthstate',
            gbd_id=hs_id(413),
        ),
    ),
    'symptomatic_probable_migraine': Sequela(
        name='symptomatic_probable_migraine',
        kind='sequela',
        gbd_id=s_id(7166),
        me_id=me_id(20183),
        healthstate=Healthstate(
            name='headache_migraine',
            kind='healthstate',
            gbd_id=hs_id(411),
        ),
    ),
    'symptomatic_definite_migraine': Sequela(
        name='symptomatic_definite_migraine',
        kind='sequela',
        gbd_id=s_id(7172),
        me_id=me_id(20185),
        healthstate=Healthstate(
            name='headache_migraine',
            kind='healthstate',
            gbd_id=hs_id(411),
        ),
    ),
    'symptomatic_probable_tension_type_headache': Sequela(
        name='symptomatic_probable_tension_type_headache',
        kind='sequela',
        gbd_id=s_id(23053),
        me_id=me_id(24387),
        healthstate=Healthstate(
            name='headache_tension_type',
            kind='healthstate',
            gbd_id=hs_id(412),
        ),
    ),
    'symptomatic_definite_tension_type_headache': Sequela(
        name='symptomatic_definite_tension_type_headache',
        kind='sequela',
        gbd_id=s_id(23055),
        me_id=me_id(24389),
        healthstate=Healthstate(
            name='headache_tension_type',
            kind='healthstate',
            gbd_id=hs_id(412),
        ),
    ),
    'complete_hearing_loss_due_to_other_congenital_anomalies': Sequela(
        name='complete_hearing_loss_due_to_other_congenital_anomalies',
        kind='sequela',
        gbd_id=s_id(582),
        me_id=me_id(2241),
        healthstate=Healthstate(
            name='hearing_loss_complete',
            kind='healthstate',
            gbd_id=hs_id(459),
        ),
    ),
    'complete_hearing_loss_due_to_age_related_and_other_hearing_loss': Sequela(
        name='complete_hearing_loss_due_to_age_related_and_other_hearing_loss',
        kind='sequela',
        gbd_id=s_id(631),
        me_id=me_id(2322),
        healthstate=Healthstate(
            name='hearing_loss_complete',
            kind='healthstate',
            gbd_id=hs_id(459),
        ),
    ),
    'complete_hearing_loss_due_to_meningitis': Sequela(
        name='complete_hearing_loss_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22880),
        me_id=me_id(24070),
        healthstate=Healthstate(
            name='hearing_loss_complete',
            kind='healthstate',
            gbd_id=hs_id(459),
        ),
    ),
    'complete_hearing_loss_with_ringing_due_to_other_congenital_anomalies': Sequela(
        name='complete_hearing_loss_with_ringing_due_to_other_congenital_anomalies',
        kind='sequela',
        gbd_id=s_id(583),
        me_id=me_id(2242),
        healthstate=Healthstate(
            name='hearing_loss_complete_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(464),
        ),
    ),
    'complete_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss': Sequela(
        name='complete_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss',
        kind='sequela',
        gbd_id=s_id(632),
        me_id=me_id(2323),
        healthstate=Healthstate(
            name='hearing_loss_complete_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(464),
        ),
    ),
    'complete_hearing_loss_with_ringing_due_to_meningitis': Sequela(
        name='complete_hearing_loss_with_ringing_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22875),
        me_id=me_id(24064),
        healthstate=Healthstate(
            name='hearing_loss_complete_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(464),
        ),
    ),
    'mild_hearing_loss_due_to_other_congenital_anomalies': Sequela(
        name='mild_hearing_loss_due_to_other_congenital_anomalies',
        kind='sequela',
        gbd_id=s_id(576),
        me_id=me_id(2235),
        healthstate=Healthstate(
            name='hearing_loss_mild',
            kind='healthstate',
            gbd_id=hs_id(455),
        ),
    ),
    'mild_hearing_loss_due_to_age_related_and_other_hearing_loss': Sequela(
        name='mild_hearing_loss_due_to_age_related_and_other_hearing_loss',
        kind='sequela',
        gbd_id=s_id(621),
        me_id=me_id(2312),
        healthstate=Healthstate(
            name='hearing_loss_mild',
            kind='healthstate',
            gbd_id=hs_id(455),
        ),
    ),
    'mild_hearing_loss_due_to_chronic_otitis_media': Sequela(
        name='mild_hearing_loss_due_to_chronic_otitis_media',
        kind='sequela',
        gbd_id=s_id(1054),
        me_id=me_id(3261),
        healthstate=Healthstate(
            name='hearing_loss_mild',
            kind='healthstate',
            gbd_id=hs_id(455),
        ),
    ),
    'mild_hearing_loss_due_to_meningitis': Sequela(
        name='mild_hearing_loss_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22877),
        me_id=me_id(24067),
        healthstate=Healthstate(
            name='hearing_loss_mild',
            kind='healthstate',
            gbd_id=hs_id(455),
        ),
    ),
    'mild_hearing_loss_with_ringing_due_to_other_congenital_anomalies': Sequela(
        name='mild_hearing_loss_with_ringing_due_to_other_congenital_anomalies',
        kind='sequela',
        gbd_id=s_id(577),
        me_id=me_id(2236),
        healthstate=Healthstate(
            name='hearing_loss_mild_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(460),
        ),
    ),
    'mild_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss': Sequela(
        name='mild_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss',
        kind='sequela',
        gbd_id=s_id(622),
        me_id=me_id(2313),
        healthstate=Healthstate(
            name='hearing_loss_mild_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(460),
        ),
    ),
    'mild_hearing_loss_with_ringing_due_to_chronic_otitis_media': Sequela(
        name='mild_hearing_loss_with_ringing_due_to_chronic_otitis_media',
        kind='sequela',
        gbd_id=s_id(1055),
        me_id=me_id(3262),
        healthstate=Healthstate(
            name='hearing_loss_mild_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(460),
        ),
    ),
    'mild_hearing_loss_with_ringing_due_to_meningitis': Sequela(
        name='mild_hearing_loss_with_ringing_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22871),
        me_id=me_id(24060),
        healthstate=Healthstate(
            name='hearing_loss_mild_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(460),
        ),
    ),
    'moderate_hearing_loss_due_to_other_congenital_anomalies': Sequela(
        name='moderate_hearing_loss_due_to_other_congenital_anomalies',
        kind='sequela',
        gbd_id=s_id(578),
        me_id=me_id(2237),
        healthstate=Healthstate(
            name='hearing_loss_moderate',
            kind='healthstate',
            gbd_id=hs_id(456),
        ),
    ),
    'moderate_hearing_loss_due_to_age_related_and_other_hearing_loss': Sequela(
        name='moderate_hearing_loss_due_to_age_related_and_other_hearing_loss',
        kind='sequela',
        gbd_id=s_id(623),
        me_id=me_id(2314),
        healthstate=Healthstate(
            name='hearing_loss_moderate',
            kind='healthstate',
            gbd_id=hs_id(456),
        ),
    ),
    'moderate_hearing_loss_due_to_chronic_otitis_media': Sequela(
        name='moderate_hearing_loss_due_to_chronic_otitis_media',
        kind='sequela',
        gbd_id=s_id(1104),
        me_id=me_id(3326),
        healthstate=Healthstate(
            name='hearing_loss_moderate',
            kind='healthstate',
            gbd_id=hs_id(456),
        ),
    ),
    'moderate_hearing_loss_due_to_meningitis': Sequela(
        name='moderate_hearing_loss_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22866),
        me_id=me_id(24053),
        healthstate=Healthstate(
            name='hearing_loss_moderate',
            kind='healthstate',
            gbd_id=hs_id(456),
        ),
    ),
    'moderate_hearing_loss_with_ringing_due_to_other_congenital_anomalies': Sequela(
        name='moderate_hearing_loss_with_ringing_due_to_other_congenital_anomalies',
        kind='sequela',
        gbd_id=s_id(579),
        me_id=me_id(2238),
        healthstate=Healthstate(
            name='hearing_loss_moderate_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(461),
        ),
    ),
    'moderate_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss': Sequela(
        name='moderate_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss',
        kind='sequela',
        gbd_id=s_id(624),
        me_id=me_id(2315),
        healthstate=Healthstate(
            name='hearing_loss_moderate_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(461),
        ),
    ),
    'moderate_hearing_loss_with_ringing_due_to_chronic_otitis_media': Sequela(
        name='moderate_hearing_loss_with_ringing_due_to_chronic_otitis_media',
        kind='sequela',
        gbd_id=s_id(1105),
        me_id=me_id(3327),
        healthstate=Healthstate(
            name='hearing_loss_moderate_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(461),
        ),
    ),
    'moderate_hearing_loss_with_ringing_due_to_meningitis': Sequela(
        name='moderate_hearing_loss_with_ringing_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22862),
        me_id=me_id(24045),
        healthstate=Healthstate(
            name='hearing_loss_moderate_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(461),
        ),
    ),
    'moderately_severe_hearing_loss_due_to_other_congenital_anomalies': Sequela(
        name='moderately_severe_hearing_loss_due_to_other_congenital_anomalies',
        kind='sequela',
        gbd_id=s_id(584),
        me_id=me_id(2243),
        healthstate=Healthstate(
            name='hearing_loss_moderately_severe',
            kind='healthstate',
            gbd_id=hs_id(575),
        ),
    ),
    'moderately_severe_hearing_loss_due_to_age_related_and_other_hearing_loss': Sequela(
        name='moderately_severe_hearing_loss_due_to_age_related_and_other_hearing_loss',
        kind='sequela',
        gbd_id=s_id(625),
        me_id=me_id(2316),
        healthstate=Healthstate(
            name='hearing_loss_moderately_severe',
            kind='healthstate',
            gbd_id=hs_id(575),
        ),
    ),
    'moderately_severe_hearing_loss_due_to_meningitis': Sequela(
        name='moderately_severe_hearing_loss_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22858),
        me_id=me_id(24038),
        healthstate=Healthstate(
            name='hearing_loss_moderately_severe',
            kind='healthstate',
            gbd_id=hs_id(575),
        ),
    ),
    'moderately_severe_hearing_loss_with_ringing_due_to_other_congenital_anomalies': Sequela(
        name='moderately_severe_hearing_loss_with_ringing_due_to_other_congenital_anomalies',
        kind='sequela',
        gbd_id=s_id(585),
        me_id=me_id(2244),
        healthstate=Healthstate(
            name='hearing_loss_moderately_severe_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(576),
        ),
    ),
    'moderately_severe_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss': Sequela(
        name='moderately_severe_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss',
        kind='sequela',
        gbd_id=s_id(626),
        me_id=me_id(2317),
        healthstate=Healthstate(
            name='hearing_loss_moderately_severe_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(576),
        ),
    ),
    'moderately_severe_hearing_loss_with_ringing_due_to_meningitis': Sequela(
        name='moderately_severe_hearing_loss_with_ringing_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22879),
        me_id=me_id(24069),
        healthstate=Healthstate(
            name='hearing_loss_moderately_severe_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(576),
        ),
    ),
    'profound_hearing_loss_due_to_other_congenital_anomalies': Sequela(
        name='profound_hearing_loss_due_to_other_congenital_anomalies',
        kind='sequela',
        gbd_id=s_id(586),
        me_id=me_id(2245),
        healthstate=Healthstate(
            name='hearing_loss_profound',
            kind='healthstate',
            gbd_id=hs_id(458),
        ),
    ),
    'profound_hearing_loss_due_to_age_related_and_other_hearing_loss': Sequela(
        name='profound_hearing_loss_due_to_age_related_and_other_hearing_loss',
        kind='sequela',
        gbd_id=s_id(629),
        me_id=me_id(2320),
        healthstate=Healthstate(
            name='hearing_loss_profound',
            kind='healthstate',
            gbd_id=hs_id(458),
        ),
    ),
    'profound_hearing_loss_due_to_meningitis': Sequela(
        name='profound_hearing_loss_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22863),
        me_id=me_id(24046),
        healthstate=Healthstate(
            name='hearing_loss_profound',
            kind='healthstate',
            gbd_id=hs_id(458),
        ),
    ),
    'profound_hearing_loss_with_ringing_due_to_other_congenital_anomalies': Sequela(
        name='profound_hearing_loss_with_ringing_due_to_other_congenital_anomalies',
        kind='sequela',
        gbd_id=s_id(587),
        me_id=me_id(2246),
        healthstate=Healthstate(
            name='hearing_loss_profound_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(463),
        ),
    ),
    'profound_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss': Sequela(
        name='profound_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss',
        kind='sequela',
        gbd_id=s_id(630),
        me_id=me_id(2321),
        healthstate=Healthstate(
            name='hearing_loss_profound_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(463),
        ),
    ),
    'profound_hearing_loss_with_ringing_due_to_meningitis': Sequela(
        name='profound_hearing_loss_with_ringing_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22859),
        me_id=me_id(24039),
        healthstate=Healthstate(
            name='hearing_loss_profound_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(463),
        ),
    ),
    'severe_hearing_loss_due_to_other_congenital_anomalies': Sequela(
        name='severe_hearing_loss_due_to_other_congenital_anomalies',
        kind='sequela',
        gbd_id=s_id(581),
        me_id=me_id(2240),
        healthstate=Healthstate(
            name='hearing_loss_severe',
            kind='healthstate',
            gbd_id=hs_id(457),
        ),
    ),
    'severe_hearing_loss_due_to_age_related_and_other_hearing_loss': Sequela(
        name='severe_hearing_loss_due_to_age_related_and_other_hearing_loss',
        kind='sequela',
        gbd_id=s_id(628),
        me_id=me_id(2319),
        healthstate=Healthstate(
            name='hearing_loss_severe',
            kind='healthstate',
            gbd_id=hs_id(457),
        ),
    ),
    'severe_hearing_loss_due_to_meningitis': Sequela(
        name='severe_hearing_loss_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22874),
        me_id=me_id(24063),
        healthstate=Healthstate(
            name='hearing_loss_severe',
            kind='healthstate',
            gbd_id=hs_id(457),
        ),
    ),
    'severe_hearing_loss_with_ringing_due_to_other_congenital_anomalies': Sequela(
        name='severe_hearing_loss_with_ringing_due_to_other_congenital_anomalies',
        kind='sequela',
        gbd_id=s_id(580),
        me_id=me_id(2239),
        healthstate=Healthstate(
            name='hearing_loss_severe_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(462),
        ),
    ),
    'severe_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss': Sequela(
        name='severe_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss',
        kind='sequela',
        gbd_id=s_id(627),
        me_id=me_id(2318),
        healthstate=Healthstate(
            name='hearing_loss_severe_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(462),
        ),
    ),
    'severe_hearing_loss_with_ringing_due_to_meningitis': Sequela(
        name='severe_hearing_loss_with_ringing_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22867),
        me_id=me_id(24054),
        healthstate=Healthstate(
            name='hearing_loss_severe_with_ringing',
            kind='healthstate',
            gbd_id=hs_id(462),
        ),
    ),
    'mild_heart_failure_due_to_chagas_disease': Sequela(
        name='mild_heart_failure_due_to_chagas_disease',
        kind='sequela',
        gbd_id=s_id(128),
        me_id=me_id(1455),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_heart_failure_due_to_ischemic_heart_disease': Sequela(
        name='mild_heart_failure_due_to_ischemic_heart_disease',
        kind='sequela',
        gbd_id=s_id(383),
        me_id=me_id(1821),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_heart_failure_due_to_hypertensive_heart_disease': Sequela(
        name='mild_heart_failure_due_to_hypertensive_heart_disease',
        kind='sequela',
        gbd_id=s_id(406),
        me_id=me_id(1850),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_heart_failure_due_to_endocarditis': Sequela(
        name='mild_heart_failure_due_to_endocarditis',
        kind='sequela',
        gbd_id=s_id(415),
        me_id=me_id(1865),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_heart_failure_due_to_other_cardiovascular_diseases': Sequela(
        name='mild_heart_failure_due_to_other_cardiovascular_diseases',
        kind='sequela',
        gbd_id=s_id(418),
        me_id=me_id(1869),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_heart_failure_due_to_thalassemias': Sequela(
        name='mild_heart_failure_due_to_thalassemias',
        kind='sequela',
        gbd_id=s_id(528),
        me_id=me_id(2094),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias': Sequela(
        name='mild_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias',
        kind='sequela',
        gbd_id=s_id(534),
        me_id=me_id(2122),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders': Sequela(
        name='mild_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders',
        kind='sequela',
        gbd_id=s_id(540),
        me_id=me_id(2134),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_other_cardiovascular_diseases': Sequela(
        name='mild_other_cardiovascular_diseases',
        kind='sequela',
        gbd_id=s_id(840),
        me_id=me_id(2910),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_heart_failure_due_to_rheumatic_heart_disease': Sequela(
        name='mild_heart_failure_due_to_rheumatic_heart_disease',
        kind='sequela',
        gbd_id=s_id(1117),
        me_id=me_id(3347),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_heart_failure_due_to_g6pd_deficiency': Sequela(
        name='mild_heart_failure_due_to_g6pd_deficiency',
        kind='sequela',
        gbd_id=s_id(1123),
        me_id=me_id(3353),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_heart_failure_due_to_myocarditis': Sequela(
        name='mild_heart_failure_due_to_myocarditis',
        kind='sequela',
        gbd_id=s_id(1523),
        me_id=me_id(11216),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_heart_failure_due_to_alcoholic_cardiomyopathy': Sequela(
        name='mild_heart_failure_due_to_alcoholic_cardiomyopathy',
        kind='sequela',
        gbd_id=s_id(1532),
        me_id=me_id(11219),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_heart_failure_due_to_other_cardiomyopathy': Sequela(
        name='mild_heart_failure_due_to_other_cardiomyopathy',
        kind='sequela',
        gbd_id=s_id(1541),
        me_id=me_id(11222),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_heart_failure_due_to_calcific_aortic_valve_disease': Sequela(
        name='mild_heart_failure_due_to_calcific_aortic_valve_disease',
        kind='sequela',
        gbd_id=s_id(5291),
        me_id=me_id(19579),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_heart_failure_due_to_degenerative_mitral_valve_disease': Sequela(
        name='mild_heart_failure_due_to_degenerative_mitral_valve_disease',
        kind='sequela',
        gbd_id=s_id(5306),
        me_id=me_id(19583),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_heart_failure_due_to_other_non_rheumatic_valve_disease': Sequela(
        name='mild_heart_failure_due_to_other_non_rheumatic_valve_disease',
        kind='sequela',
        gbd_id=s_id(5321),
        me_id=me_id(19588),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'mild_heart_failure_due_to_pulmonary_arterial_hypertension': Sequela(
        name='mild_heart_failure_due_to_pulmonary_arterial_hypertension',
        kind='sequela',
        gbd_id=s_id(22933),
        me_id=me_id(23946),
        healthstate=Healthstate(
            name='heart_failure_mild',
            kind='healthstate',
            gbd_id=hs_id(381),
        ),
    ),
    'moderate_heart_failure_due_to_chagas_disease': Sequela(
        name='moderate_heart_failure_due_to_chagas_disease',
        kind='sequela',
        gbd_id=s_id(129),
        me_id=me_id(1456),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_heart_failure_due_to_ischemic_heart_disease': Sequela(
        name='moderate_heart_failure_due_to_ischemic_heart_disease',
        kind='sequela',
        gbd_id=s_id(384),
        me_id=me_id(1822),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_heart_failure_due_to_hypertensive_heart_disease': Sequela(
        name='moderate_heart_failure_due_to_hypertensive_heart_disease',
        kind='sequela',
        gbd_id=s_id(407),
        me_id=me_id(1851),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_heart_failure_due_to_endocarditis': Sequela(
        name='moderate_heart_failure_due_to_endocarditis',
        kind='sequela',
        gbd_id=s_id(416),
        me_id=me_id(1866),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_heart_failure_due_to_other_cardiovascular_diseases': Sequela(
        name='moderate_heart_failure_due_to_other_cardiovascular_diseases',
        kind='sequela',
        gbd_id=s_id(419),
        me_id=me_id(1870),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_heart_failure_due_to_thalassemias': Sequela(
        name='moderate_heart_failure_due_to_thalassemias',
        kind='sequela',
        gbd_id=s_id(529),
        me_id=me_id(2095),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias': Sequela(
        name='moderate_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias',
        kind='sequela',
        gbd_id=s_id(535),
        me_id=me_id(2123),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders': Sequela(
        name='moderate_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders',
        kind='sequela',
        gbd_id=s_id(541),
        me_id=me_id(2135),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_other_cardiovascular_diseases': Sequela(
        name='moderate_other_cardiovascular_diseases',
        kind='sequela',
        gbd_id=s_id(841),
        me_id=me_id(2911),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_heart_failure_due_to_rheumatic_heart_disease': Sequela(
        name='moderate_heart_failure_due_to_rheumatic_heart_disease',
        kind='sequela',
        gbd_id=s_id(1118),
        me_id=me_id(3348),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_heart_failure_due_to_g6pd_deficiency': Sequela(
        name='moderate_heart_failure_due_to_g6pd_deficiency',
        kind='sequela',
        gbd_id=s_id(1124),
        me_id=me_id(3354),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_heart_failure_due_to_myocarditis': Sequela(
        name='moderate_heart_failure_due_to_myocarditis',
        kind='sequela',
        gbd_id=s_id(1526),
        me_id=me_id(11217),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_heart_failure_due_to_alcoholic_cardiomyopathy': Sequela(
        name='moderate_heart_failure_due_to_alcoholic_cardiomyopathy',
        kind='sequela',
        gbd_id=s_id(1535),
        me_id=me_id(11220),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_heart_failure_due_to_other_cardiomyopathy': Sequela(
        name='moderate_heart_failure_due_to_other_cardiomyopathy',
        kind='sequela',
        gbd_id=s_id(1544),
        me_id=me_id(11223),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_heart_failure_due_to_calcific_aortic_valve_disease': Sequela(
        name='moderate_heart_failure_due_to_calcific_aortic_valve_disease',
        kind='sequela',
        gbd_id=s_id(5294),
        me_id=me_id(19580),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_heart_failure_due_to_degenerative_mitral_valve_disease': Sequela(
        name='moderate_heart_failure_due_to_degenerative_mitral_valve_disease',
        kind='sequela',
        gbd_id=s_id(5309),
        me_id=me_id(19584),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_heart_failure_due_to_other_non_rheumatic_valve_disease': Sequela(
        name='moderate_heart_failure_due_to_other_non_rheumatic_valve_disease',
        kind='sequela',
        gbd_id=s_id(5324),
        me_id=me_id(19589),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'moderate_heart_failure_due_to_pulmonary_arterial_hypertension': Sequela(
        name='moderate_heart_failure_due_to_pulmonary_arterial_hypertension',
        kind='sequela',
        gbd_id=s_id(22934),
        me_id=me_id(23947),
        healthstate=Healthstate(
            name='heart_failure_moderate',
            kind='healthstate',
            gbd_id=hs_id(382),
        ),
    ),
    'severe_heart_failure_due_to_chagas_disease': Sequela(
        name='severe_heart_failure_due_to_chagas_disease',
        kind='sequela',
        gbd_id=s_id(130),
        me_id=me_id(1457),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_heart_failure_due_to_ischemic_heart_disease': Sequela(
        name='severe_heart_failure_due_to_ischemic_heart_disease',
        kind='sequela',
        gbd_id=s_id(385),
        me_id=me_id(1823),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_heart_failure_due_to_hypertensive_heart_disease': Sequela(
        name='severe_heart_failure_due_to_hypertensive_heart_disease',
        kind='sequela',
        gbd_id=s_id(408),
        me_id=me_id(1852),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_heart_failure_due_to_endocarditis': Sequela(
        name='severe_heart_failure_due_to_endocarditis',
        kind='sequela',
        gbd_id=s_id(417),
        me_id=me_id(1867),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_heart_failure_due_to_other_cardiovascular_diseases': Sequela(
        name='severe_heart_failure_due_to_other_cardiovascular_diseases',
        kind='sequela',
        gbd_id=s_id(420),
        me_id=me_id(1871),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_heart_failure_due_to_thalassemias': Sequela(
        name='severe_heart_failure_due_to_thalassemias',
        kind='sequela',
        gbd_id=s_id(530),
        me_id=me_id(2096),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias': Sequela(
        name='severe_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias',
        kind='sequela',
        gbd_id=s_id(536),
        me_id=me_id(2124),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders': Sequela(
        name='severe_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders',
        kind='sequela',
        gbd_id=s_id(542),
        me_id=me_id(2136),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_other_cardiovascular_diseases': Sequela(
        name='severe_other_cardiovascular_diseases',
        kind='sequela',
        gbd_id=s_id(842),
        me_id=me_id(2912),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_heart_failure_due_to_rheumatic_heart_disease': Sequela(
        name='severe_heart_failure_due_to_rheumatic_heart_disease',
        kind='sequela',
        gbd_id=s_id(1119),
        me_id=me_id(3349),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_heart_failure_due_to_g6pd_deficiency': Sequela(
        name='severe_heart_failure_due_to_g6pd_deficiency',
        kind='sequela',
        gbd_id=s_id(1125),
        me_id=me_id(3355),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_heart_failure_due_to_myocarditis': Sequela(
        name='severe_heart_failure_due_to_myocarditis',
        kind='sequela',
        gbd_id=s_id(1529),
        me_id=me_id(11218),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_heart_failure_due_to_alcoholic_cardiomyopathy': Sequela(
        name='severe_heart_failure_due_to_alcoholic_cardiomyopathy',
        kind='sequela',
        gbd_id=s_id(1538),
        me_id=me_id(11221),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_heart_failure_due_to_other_cardiomyopathy': Sequela(
        name='severe_heart_failure_due_to_other_cardiomyopathy',
        kind='sequela',
        gbd_id=s_id(1547),
        me_id=me_id(11224),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_heart_failure_due_to_calcific_aortic_valve_disease': Sequela(
        name='severe_heart_failure_due_to_calcific_aortic_valve_disease',
        kind='sequela',
        gbd_id=s_id(5297),
        me_id=me_id(19581),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_heart_failure_due_to_degenerative_mitral_valve_disease': Sequela(
        name='severe_heart_failure_due_to_degenerative_mitral_valve_disease',
        kind='sequela',
        gbd_id=s_id(5312),
        me_id=me_id(19585),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_heart_failure_due_to_other_non_rheumatic_valve_disease': Sequela(
        name='severe_heart_failure_due_to_other_non_rheumatic_valve_disease',
        kind='sequela',
        gbd_id=s_id(5327),
        me_id=me_id(19590),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_heart_failure_due_to_pulmonary_arterial_hypertension': Sequela(
        name='severe_heart_failure_due_to_pulmonary_arterial_hypertension',
        kind='sequela',
        gbd_id=s_id(22935),
        me_id=me_id(23948),
        healthstate=Healthstate(
            name='heart_failure_severe',
            kind='healthstate',
            gbd_id=hs_id(383),
        ),
    ),
    'severe_opioid_dependence': Sequela(
        name='severe_opioid_dependence',
        kind='sequela',
        gbd_id=s_id(804),
        me_id=me_id(2827),
        healthstate=Healthstate(
            name='heroin_and_other_opioid_dependence',
            kind='healthstate',
            gbd_id=hs_id(433),
        ),
    ),
    'mild_opioid_dependence': Sequela(
        name='mild_opioid_dependence',
        kind='sequela',
        gbd_id=s_id(690),
        me_id=me_id(2658),
        healthstate=Healthstate(
            name='heroin_and_other_opioid_dependence_mild',
            kind='healthstate',
            gbd_id=hs_id(577),
        ),
    ),
    'herpes_zoster': Sequela(
        name='herpes_zoster',
        kind='sequela',
        gbd_id=s_id(120),
        me_id=me_id(1441),
        healthstate=Healthstate(
            name='herpes_zoster',
            kind='healthstate',
            gbd_id=hs_id(359),
        ),
    ),
    'symptomatic_hiv_without_anemia': Sequela(
        name='symptomatic_hiv_without_anemia',
        kind='sequela',
        gbd_id=s_id(5072),
        me_id=me_id(16328),
        healthstate=Healthstate(
            name='hiv_cases_symptomatic_pre_aids',
            kind='healthstate',
            gbd_id=hs_id(360),
        ),
    ),
    'symptomatic_hiv_with_mild_anemia': Sequela(
        name='symptomatic_hiv_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(5063),
        me_id=me_id(16325),
        healthstate=Healthstate(
            name='hiv_cases_symptomatic_pre_aids_and_anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(2534),
        ),
    ),
    'symptomatic_hiv_with_moderate_anemia': Sequela(
        name='symptomatic_hiv_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(5066),
        me_id=me_id(16326),
        healthstate=Healthstate(
            name='hiv_cases_symptomatic_pre_aids_and_anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(2537),
        ),
    ),
    'symptomatic_hiv_with_severe_anemia': Sequela(
        name='symptomatic_hiv_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5069),
        me_id=me_id(16327),
        healthstate=Healthstate(
            name='hiv_cases_symptomatic_pre_aids_and_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(2540),
        ),
    ),
    'hiv_aids_with_antiretroviral_treatment_without_anemia': Sequela(
        name='hiv_aids_with_antiretroviral_treatment_without_anemia',
        kind='sequela',
        gbd_id=s_id(5084),
        me_id=me_id(16332),
        healthstate=Healthstate(
            name='hiv_aids_cases_receiving_arv_treatment',
            kind='healthstate',
            gbd_id=hs_id(361),
        ),
    ),
    'hiv_aids_with_antiretroviral_treatment_with_mild_anemia': Sequela(
        name='hiv_aids_with_antiretroviral_treatment_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(5075),
        me_id=me_id(16329),
        healthstate=Healthstate(
            name='hiv_aids_cases_receiving_arv_treatment_and_anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(2543),
        ),
    ),
    'hiv_aids_with_antiretroviral_treatment_with_moderate_anemia': Sequela(
        name='hiv_aids_with_antiretroviral_treatment_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(5078),
        me_id=me_id(16330),
        healthstate=Healthstate(
            name='hiv_aids_cases_receiving_arv_treatment_and_anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(2546),
        ),
    ),
    'hiv_aids_with_antiretroviral_treatment_with_severe_anemia': Sequela(
        name='hiv_aids_with_antiretroviral_treatment_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5081),
        me_id=me_id(16331),
        healthstate=Healthstate(
            name='hiv_aids_cases_receiving_arv_treatment_and_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(2549),
        ),
    ),
    'moderate_endocrine_metabolic_blood_and_immune_disorders': Sequela(
        name='moderate_endocrine_metabolic_blood_and_immune_disorders',
        kind='sequela',
        gbd_id=s_id(906),
        me_id=me_id(2997),
        healthstate=Healthstate(
            name='hyperthyroidism',
            kind='healthstate',
            gbd_id=hs_id(813),
        ),
    ),
    'mild_endocrine_metabolic_blood_and_immune_disorders': Sequela(
        name='mild_endocrine_metabolic_blood_and_immune_disorders',
        kind='sequela',
        gbd_id=s_id(905),
        me_id=me_id(2996),
        healthstate=Healthstate(
            name='hypothyroidism',
            kind='healthstate',
            gbd_id=hs_id(812),
        ),
    ),
    'impotence_due_to_congenital_genital_anomalies': Sequela(
        name='impotence_due_to_congenital_genital_anomalies',
        kind='sequela',
        gbd_id=s_id(1718),
        me_id=me_id(11034),
        healthstate=Healthstate(
            name='impotence',
            kind='healthstate',
            gbd_id=hs_id(399),
        ),
    ),
    'impotence_due_to_congenital_anomalies_of_the_urinary_tract': Sequela(
        name='impotence_due_to_congenital_anomalies_of_the_urinary_tract',
        kind='sequela',
        gbd_id=s_id(1859),
        me_id=me_id(11364),
        healthstate=Healthstate(
            name='impotence',
            kind='healthstate',
            gbd_id=hs_id(399),
        ),
    ),
    'impotence_from_prostate_cancer_beyond_ten_years': Sequela(
        name='impotence_from_prostate_cancer_beyond_ten_years',
        kind='sequela',
        gbd_id=s_id(5504),
        me_id=me_id(18784),
        healthstate=Healthstate(
            name='impotence',
            kind='healthstate',
            gbd_id=hs_id(399),
        ),
    ),
    'controlled_phase_of_prostate_cancer_with_impotence': Sequela(
        name='controlled_phase_of_prostate_cancer_with_impotence',
        kind='sequela',
        gbd_id=s_id(5495),
        me_id=me_id(18781),
        healthstate=Healthstate(
            name='impotence_and_generic_medication',
            kind='healthstate',
            gbd_id=hs_id(895),
        ),
    ),
    'controlled_phase_of_prostate_cancer_with_incontinence': Sequela(
        name='controlled_phase_of_prostate_cancer_with_incontinence',
        kind='sequela',
        gbd_id=s_id(5498),
        me_id=me_id(18782),
        healthstate=Healthstate(
            name='incontinence_and_generic_medication',
            kind='healthstate',
            gbd_id=hs_id(896),
        ),
    ),
    'controlled_phase_of_bladder_cancer_with_incontinence': Sequela(
        name='controlled_phase_of_bladder_cancer_with_incontinence',
        kind='sequela',
        gbd_id=s_id(5528),
        me_id=me_id(18792),
        healthstate=Healthstate(
            name='incontinence_and_generic_medication',
            kind='healthstate',
            gbd_id=hs_id(896),
        ),
    ),
    'acute_paratyphoid_infection': Sequela(
        name='acute_paratyphoid_infection',
        kind='sequela',
        gbd_id=s_id(10),
        me_id=me_id(1253),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'mild_upper_respiratory_infections': Sequela(
        name='mild_upper_respiratory_infections',
        kind='sequela',
        gbd_id=s_id(15),
        me_id=me_id(1277),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'chickenpox': Sequela(
        name='chickenpox',
        kind='sequela',
        gbd_id=s_id(119),
        me_id=me_id(1440),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'mild_malaria': Sequela(
        name='mild_malaria',
        kind='sequela',
        gbd_id=s_id(121),
        me_id=me_id(9762),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'mild_schistosomiasis': Sequela(
        name='mild_schistosomiasis',
        kind='sequela',
        gbd_id=s_id(136),
        me_id=me_id(1468),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'mild_urinary_tract_infections': Sequela(
        name='mild_urinary_tract_infections',
        kind='sequela',
        gbd_id=s_id(510),
        me_id=me_id(2056),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'impetigo': Sequela(
        name='impetigo',
        kind='sequela',
        gbd_id=s_id(594),
        me_id=me_id(2258),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'abscess_and_other_bacterial_skin_diseases': Sequela(
        name='abscess_and_other_bacterial_skin_diseases',
        kind='sequela',
        gbd_id=s_id(595),
        me_id=me_id(2261),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'tinea_capitis': Sequela(
        name='tinea_capitis',
        kind='sequela',
        gbd_id=s_id(597),
        me_id=me_id(2265),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'mild_viral_warts': Sequela(
        name='mild_viral_warts',
        kind='sequela',
        gbd_id=s_id(598),
        me_id=me_id(2270),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'other_fungal_skin_diseases': Sequela(
        name='other_fungal_skin_diseases',
        kind='sequela',
        gbd_id=s_id(672),
        me_id=me_id(2616),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'symptomatic_genital_herpes': Sequela(
        name='symptomatic_genital_herpes',
        kind='sequela',
        gbd_id=s_id(788),
        me_id=me_id(2799),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'mild_molluscum_contagiosum': Sequela(
        name='mild_molluscum_contagiosum',
        kind='sequela',
        gbd_id=s_id(900),
        me_id=me_id(2984),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'mild_chlamydial_infection': Sequela(
        name='mild_chlamydial_infection',
        kind='sequela',
        gbd_id=s_id(917),
        me_id=me_id(3042),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'mild_gonococcal_infection': Sequela(
        name='mild_gonococcal_infection',
        kind='sequela',
        gbd_id=s_id(919),
        me_id=me_id(3044),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'acute_trichomoniasis_infection': Sequela(
        name='acute_trichomoniasis_infection',
        kind='sequela',
        gbd_id=s_id(921),
        me_id=me_id(3046),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'mild_cellulitis': Sequela(
        name='mild_cellulitis',
        kind='sequela',
        gbd_id=s_id(969),
        me_id=me_id(3125),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'mild_other_oral_disorders': Sequela(
        name='mild_other_oral_disorders',
        kind='sequela',
        gbd_id=s_id(1048),
        me_id=me_id(3252),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'mild_early_syphilis_infection': Sequela(
        name='mild_early_syphilis_infection',
        kind='sequela',
        gbd_id=s_id(1203),
        me_id=me_id(3950),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'mild_acute_other_sense_organ_diseases': Sequela(
        name='mild_acute_other_sense_organ_diseases',
        kind='sequela',
        gbd_id=s_id(1334),
        me_id=me_id(10312),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild',
            kind='healthstate',
            gbd_id=hs_id(351),
        ),
    ),
    'mild_malaria_with_mild_anemia': Sequela(
        name='mild_malaria_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(5027),
        me_id=me_id(16384),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild_with_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2483),
        ),
    ),
    'mild_malaria_with_moderate_anemia': Sequela(
        name='mild_malaria_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(5030),
        me_id=me_id(16385),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild_with_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2486),
        ),
    ),
    'mild_malaria_with_severe_anemia': Sequela(
        name='mild_malaria_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5033),
        me_id=me_id(16386),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_mild_with_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(2489),
        ),
    ),
    'acute_typhoid_infection': Sequela(
        name='acute_typhoid_infection',
        kind='sequela',
        gbd_id=s_id(7),
        me_id=me_id(1249),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_paratyphoid_fever': Sequela(
        name='moderate_paratyphoid_fever',
        kind='sequela',
        gbd_id=s_id(11),
        me_id=me_id(1254),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_upper_respiratory_infections': Sequela(
        name='moderate_upper_respiratory_infections',
        kind='sequela',
        gbd_id=s_id(16),
        me_id=me_id(1278),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_diphtheria': Sequela(
        name='moderate_diphtheria',
        kind='sequela',
        gbd_id=s_id(113),
        me_id=me_id(1422),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'whooping_cough': Sequela(
        name='whooping_cough',
        kind='sequela',
        gbd_id=s_id(115),
        me_id=me_id(1424),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_measles': Sequela(
        name='moderate_measles',
        kind='sequela',
        gbd_id=s_id(117),
        me_id=me_id(1437),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_malaria': Sequela(
        name='moderate_malaria',
        kind='sequela',
        gbd_id=s_id(122),
        me_id=me_id(9763),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'acute_chagas_disease': Sequela(
        name='acute_chagas_disease',
        kind='sequela',
        gbd_id=s_id(124),
        me_id=me_id(1451),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_visceral_leishmaniasis': Sequela(
        name='moderate_visceral_leishmaniasis',
        kind='sequela',
        gbd_id=s_id(131),
        me_id=me_id(1459),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_dengue': Sequela(
        name='moderate_dengue',
        kind='sequela',
        gbd_id=s_id(157),
        me_id=me_id(1506),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_yellow_fever': Sequela(
        name='moderate_yellow_fever',
        kind='sequela',
        gbd_id=s_id(160),
        me_id=me_id(1510),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_acute_hepatitis_a': Sequela(
        name='moderate_acute_hepatitis_a',
        kind='sequela',
        gbd_id=s_id(229),
        me_id=me_id(1649),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_acute_hepatitis_b': Sequela(
        name='moderate_acute_hepatitis_b',
        kind='sequela',
        gbd_id=s_id(231),
        me_id=me_id(1653),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_acute_hepatitis_c': Sequela(
        name='moderate_acute_hepatitis_c',
        kind='sequela',
        gbd_id=s_id(233),
        me_id=me_id(1657),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_acute_hepatitis_e': Sequela(
        name='moderate_acute_hepatitis_e',
        kind='sequela',
        gbd_id=s_id(235),
        me_id=me_id(1660),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'acute_myocarditis': Sequela(
        name='acute_myocarditis',
        kind='sequela',
        gbd_id=s_id(409),
        me_id=me_id(1855),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_endocarditis': Sequela(
        name='moderate_endocarditis',
        kind='sequela',
        gbd_id=s_id(413),
        me_id=me_id(1863),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'acute_glomerulonephritis': Sequela(
        name='acute_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(497),
        me_id=me_id(24695),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_urinary_tract_infections': Sequela(
        name='moderate_urinary_tract_infections',
        kind='sequela',
        gbd_id=s_id(511),
        me_id=me_id(2057),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_lower_respiratory_infections': Sequela(
        name='moderate_lower_respiratory_infections',
        kind='sequela',
        gbd_id=s_id(669),
        me_id=me_id(2613),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'other_maternal_infections': Sequela(
        name='other_maternal_infections',
        kind='sequela',
        gbd_id=s_id(938),
        me_id=me_id(3626),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_infection_due_to_initial_genital_herpes_episode': Sequela(
        name='moderate_infection_due_to_initial_genital_herpes_episode',
        kind='sequela',
        gbd_id=s_id(942),
        me_id=me_id(3090),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'severe_other_oral_disorders': Sequela(
        name='severe_other_oral_disorders',
        kind='sequela',
        gbd_id=s_id(1049),
        me_id=me_id(3253),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_acute_other_sense_organ_diseases': Sequela(
        name='moderate_acute_other_sense_organ_diseases',
        kind='sequela',
        gbd_id=s_id(1335),
        me_id=me_id(10313),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'acute_zika_infection': Sequela(
        name='acute_zika_infection',
        kind='sequela',
        gbd_id=s_id(1511),
        me_id=me_id(10401),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_cellulitis': Sequela(
        name='moderate_cellulitis',
        kind='sequela',
        gbd_id=s_id(4628),
        me_id=me_id(16299),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'acute_adenolymphangitis_due_to_lymphatic_filariasis': Sequela(
        name='acute_adenolymphangitis_due_to_lymphatic_filariasis',
        kind='sequela',
        gbd_id=s_id(4946),
        me_id=me_id(15811),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'cardiovascular_complications_due_to_adult_tertiary_syphilis': Sequela(
        name='cardiovascular_complications_due_to_adult_tertiary_syphilis',
        kind='sequela',
        gbd_id=s_id(5153),
        me_id=me_id(16415),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate',
            kind='healthstate',
            gbd_id=hs_id(352),
        ),
    ),
    'moderate_malaria_with_mild_anemia': Sequela(
        name='moderate_malaria_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(5036),
        me_id=me_id(16387),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate_with_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2492),
        ),
    ),
    'moderate_malaria_with_moderate_anemia': Sequela(
        name='moderate_malaria_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(5039),
        me_id=me_id(16388),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate_with_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2495),
        ),
    ),
    'moderate_malaria_with_severe_anemia': Sequela(
        name='moderate_malaria_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5042),
        me_id=me_id(16389),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_moderate_with_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(2498),
        ),
    ),
    'severe_typhoid_fever': Sequela(
        name='severe_typhoid_fever',
        kind='sequela',
        gbd_id=s_id(8),
        me_id=me_id(1250),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'severe_paratyphoid_fever': Sequela(
        name='severe_paratyphoid_fever',
        kind='sequela',
        gbd_id=s_id(12),
        me_id=me_id(1255),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'acute_viral_meningitis': Sequela(
        name='acute_viral_meningitis',
        kind='sequela',
        gbd_id=s_id(111),
        me_id=me_id(24161),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'acute_encephalitis': Sequela(
        name='acute_encephalitis',
        kind='sequela',
        gbd_id=s_id(112),
        me_id=me_id(1419),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'severe_diphtheria': Sequela(
        name='severe_diphtheria',
        kind='sequela',
        gbd_id=s_id(114),
        me_id=me_id(1423),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'severe_tetanus': Sequela(
        name='severe_tetanus',
        kind='sequela',
        gbd_id=s_id(116),
        me_id=me_id(1426),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'severe_measles': Sequela(
        name='severe_measles',
        kind='sequela',
        gbd_id=s_id(118),
        me_id=me_id(1438),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'severe_malaria': Sequela(
        name='severe_malaria',
        kind='sequela',
        gbd_id=s_id(123),
        me_id=me_id(9764),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'severe_visceral_leishmaniasis': Sequela(
        name='severe_visceral_leishmaniasis',
        kind='sequela',
        gbd_id=s_id(132),
        me_id=me_id(1460),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'severe_dengue': Sequela(
        name='severe_dengue',
        kind='sequela',
        gbd_id=s_id(158),
        me_id=me_id(1507),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'severe_yellow_fever': Sequela(
        name='severe_yellow_fever',
        kind='sequela',
        gbd_id=s_id(161),
        me_id=me_id(1511),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'rabies': Sequela(
        name='rabies',
        kind='sequela',
        gbd_id=s_id(162),
        me_id=me_id(1512),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'severe_acute_hepatitis_a': Sequela(
        name='severe_acute_hepatitis_a',
        kind='sequela',
        gbd_id=s_id(230),
        me_id=me_id(1650),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'severe_acute_hepatitis_b': Sequela(
        name='severe_acute_hepatitis_b',
        kind='sequela',
        gbd_id=s_id(232),
        me_id=me_id(1654),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'severe_acute_hepatitis_c': Sequela(
        name='severe_acute_hepatitis_c',
        kind='sequela',
        gbd_id=s_id(234),
        me_id=me_id(1658),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'severe_acute_hepatitis_e': Sequela(
        name='severe_acute_hepatitis_e',
        kind='sequela',
        gbd_id=s_id(236),
        me_id=me_id(1661),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'severe_endocarditis': Sequela(
        name='severe_endocarditis',
        kind='sequela',
        gbd_id=s_id(414),
        me_id=me_id(1864),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'severe_lower_respiratory_infections': Sequela(
        name='severe_lower_respiratory_infections',
        kind='sequela',
        gbd_id=s_id(670),
        me_id=me_id(2614),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'puerperal_sepsis': Sequela(
        name='puerperal_sepsis',
        kind='sequela',
        gbd_id=s_id(937),
        me_id=me_id(3623),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'severe_cellulitis': Sequela(
        name='severe_cellulitis',
        kind='sequela',
        gbd_id=s_id(970),
        me_id=me_id(3126),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'ebola_cases': Sequela(
        name='ebola_cases',
        kind='sequela',
        gbd_id=s_id(1184),
        me_id=me_id(9668),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'severe_acute_ints': Sequela(
        name='severe_acute_ints',
        kind='sequela',
        gbd_id=s_id(5555),
        me_id=me_id(19680),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'acute_meningitis': Sequela(
        name='acute_meningitis',
        kind='sequela',
        gbd_id=s_id(22878),
        me_id=me_id(24068),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe',
            kind='healthstate',
            gbd_id=hs_id(353),
        ),
    ),
    'acute_pancreatitis': Sequela(
        name='acute_pancreatitis',
        kind='sequela',
        gbd_id=s_id(5621),
        me_id=me_id(15812),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe_and_abdominopelvic_problem_severe',
            kind='healthstate',
            gbd_id=hs_id(2657),
        ),
    ),
    'severe_malaria_with_mild_anemia': Sequela(
        name='severe_malaria_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(5018),
        me_id=me_id(16377),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe_with_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2474),
        ),
    ),
    'severe_malaria_with_moderate_anemia': Sequela(
        name='severe_malaria_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(5021),
        me_id=me_id(16378),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe_with_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2477),
        ),
    ),
    'severe_malaria_with_severe_anemia': Sequela(
        name='severe_malaria_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5024),
        me_id=me_id(16379),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe_with_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(2480),
        ),
    ),
    'beta_thalassemia_major_severe_infection_with_severe_anemia': Sequela(
        name='beta_thalassemia_major_severe_infection_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1060),
        me_id=me_id(3270),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe_generic_uncomplicated_disease_anxiety_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(856),
        ),
    ),
    'hemoglobin_e_beta_thalassemia_severe_infection_with_severe_anemia': Sequela(
        name='hemoglobin_e_beta_thalassemia_severe_infection_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1064),
        me_id=me_id(3277),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe_generic_uncomplicated_disease_anxiety_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(856),
        ),
    ),
    'hemoglobin_h_disease_severe_infection_with_severe_anemia': Sequela(
        name='hemoglobin_h_disease_severe_infection_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1068),
        me_id=me_id(3284),
        healthstate=Healthstate(
            name='infectious_disease_acute_episode_severe_generic_uncomplicated_disease_anxiety_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(856),
        ),
    ),
    'post_dengue_chronic_fatigue_syndrome': Sequela(
        name='post_dengue_chronic_fatigue_syndrome',
        kind='sequela',
        gbd_id=s_id(159),
        me_id=me_id(1508),
        healthstate=Healthstate(
            name='infectious_disease_post_acute_consequences_fatigue_emotional_lability_insomnia',
            kind='healthstate',
            gbd_id=hs_id(354),
        ),
    ),
    'post_ebola_chronic_fatigue_syndrome': Sequela(
        name='post_ebola_chronic_fatigue_syndrome',
        kind='sequela',
        gbd_id=s_id(1185),
        me_id=me_id(9669),
        healthstate=Healthstate(
            name='infectious_disease_post_acute_consequences_fatigue_emotional_lability_insomnia',
            kind='healthstate',
            gbd_id=hs_id(354),
        ),
    ),
    'primary_infertility_due_to_chlamydial_infection': Sequela(
        name='primary_infertility_due_to_chlamydial_infection',
        kind='sequela',
        gbd_id=s_id(217),
        me_id=me_id(1633),
        healthstate=Healthstate(
            name='infertility_primary',
            kind='healthstate',
            gbd_id=hs_id(400),
        ),
    ),
    'primary_infertility_due_to_gonococcal_infection': Sequela(
        name='primary_infertility_due_to_gonococcal_infection',
        kind='sequela',
        gbd_id=s_id(222),
        me_id=me_id(1639),
        healthstate=Healthstate(
            name='infertility_primary',
            kind='healthstate',
            gbd_id=hs_id(400),
        ),
    ),
    'primary_infertility_due_to_other_sexually_transmitted_diseases': Sequela(
        name='primary_infertility_due_to_other_sexually_transmitted_diseases',
        kind='sequela',
        gbd_id=s_id(226),
        me_id=me_id(1645),
        healthstate=Healthstate(
            name='infertility_primary',
            kind='healthstate',
            gbd_id=hs_id(400),
        ),
    ),
    'idiopathic_primary_male_infertility': Sequela(
        name='idiopathic_primary_male_infertility',
        kind='sequela',
        gbd_id=s_id(514),
        me_id=me_id(2061),
        healthstate=Healthstate(
            name='infertility_primary',
            kind='healthstate',
            gbd_id=hs_id(400),
        ),
    ),
    'primary_infertility_due_to_polycystic_ovarian_syndrome': Sequela(
        name='primary_infertility_due_to_polycystic_ovarian_syndrome',
        kind='sequela',
        gbd_id=s_id(517),
        me_id=me_id(2069),
        healthstate=Healthstate(
            name='infertility_primary',
            kind='healthstate',
            gbd_id=hs_id(400),
        ),
    ),
    'idiopathic_primary_female_infertility': Sequela(
        name='idiopathic_primary_female_infertility',
        kind='sequela',
        gbd_id=s_id(518),
        me_id=me_id(2071),
        healthstate=Healthstate(
            name='infertility_primary',
            kind='healthstate',
            gbd_id=hs_id(400),
        ),
    ),
    'primary_infertility_due_to_endometriosis': Sequela(
        name='primary_infertility_due_to_endometriosis',
        kind='sequela',
        gbd_id=s_id(522),
        me_id=me_id(2076),
        healthstate=Healthstate(
            name='infertility_primary',
            kind='healthstate',
            gbd_id=hs_id(400),
        ),
    ),
    'primary_infertility_due_to_turner_syndrome': Sequela(
        name='primary_infertility_due_to_turner_syndrome',
        kind='sequela',
        gbd_id=s_id(571),
        me_id=me_id(2208),
        healthstate=Healthstate(
            name='infertility_primary',
            kind='healthstate',
            gbd_id=hs_id(400),
        ),
    ),
    'primary_infertility_due_to_klinefelter_syndrome': Sequela(
        name='primary_infertility_due_to_klinefelter_syndrome',
        kind='sequela',
        gbd_id=s_id(932),
        me_id=me_id(3069),
        healthstate=Healthstate(
            name='infertility_primary',
            kind='healthstate',
            gbd_id=hs_id(400),
        ),
    ),
    'primary_infertility_due_to_congenital_genital_anomalies': Sequela(
        name='primary_infertility_due_to_congenital_genital_anomalies',
        kind='sequela',
        gbd_id=s_id(1715),
        me_id=me_id(11033),
        healthstate=Healthstate(
            name='infertility_primary',
            kind='healthstate',
            gbd_id=hs_id(400),
        ),
    ),
    'secondary_infertility_due_to_chlamydial_infection': Sequela(
        name='secondary_infertility_due_to_chlamydial_infection',
        kind='sequela',
        gbd_id=s_id(218),
        me_id=me_id(1634),
        healthstate=Healthstate(
            name='infertility_secondary',
            kind='healthstate',
            gbd_id=hs_id(401),
        ),
    ),
    'secondary_infertility_due_to_gonococcal_infection': Sequela(
        name='secondary_infertility_due_to_gonococcal_infection',
        kind='sequela',
        gbd_id=s_id(223),
        me_id=me_id(1640),
        healthstate=Healthstate(
            name='infertility_secondary',
            kind='healthstate',
            gbd_id=hs_id(401),
        ),
    ),
    'secondary_infertility_due_to_other_sexually_transmitted_diseases': Sequela(
        name='secondary_infertility_due_to_other_sexually_transmitted_diseases',
        kind='sequela',
        gbd_id=s_id(227),
        me_id=me_id(1646),
        healthstate=Healthstate(
            name='infertility_secondary',
            kind='healthstate',
            gbd_id=hs_id(401),
        ),
    ),
    'idiopathic_secondary_male_infertility': Sequela(
        name='idiopathic_secondary_male_infertility',
        kind='sequela',
        gbd_id=s_id(515),
        me_id=me_id(2062),
        healthstate=Healthstate(
            name='infertility_secondary',
            kind='healthstate',
            gbd_id=hs_id(401),
        ),
    ),
    'idiopathic_secondary_female_infertility': Sequela(
        name='idiopathic_secondary_female_infertility',
        kind='sequela',
        gbd_id=s_id(519),
        me_id=me_id(2072),
        healthstate=Healthstate(
            name='infertility_secondary',
            kind='healthstate',
            gbd_id=hs_id(401),
        ),
    ),
    'secondary_infertility_due_to_endometriosis': Sequela(
        name='secondary_infertility_due_to_endometriosis',
        kind='sequela',
        gbd_id=s_id(523),
        me_id=me_id(2077),
        healthstate=Healthstate(
            name='infertility_secondary',
            kind='healthstate',
            gbd_id=hs_id(401),
        ),
    ),
    'infertility_due_to_puerperal_sepsis': Sequela(
        name='infertility_due_to_puerperal_sepsis',
        kind='sequela',
        gbd_id=s_id(675),
        me_id=me_id(2624),
        healthstate=Healthstate(
            name='infertility_secondary',
            kind='healthstate',
            gbd_id=hs_id(401),
        ),
    ),
    'hirsutism_and_secondary_infertility_due_to_polycystic_ovarian_syndrome': Sequela(
        name='hirsutism_and_secondary_infertility_due_to_polycystic_ovarian_syndrome',
        kind='sequela',
        gbd_id=s_id(939),
        me_id=me_id(3087),
        healthstate=Healthstate(
            name='infertility_secondary',
            kind='healthstate',
            gbd_id=hs_id(401),
        ),
    ),
    'mild_idiopathic_developmental_intellectual_disability': Sequela(
        name='mild_idiopathic_developmental_intellectual_disability',
        kind='sequela',
        gbd_id=s_id(488),
        me_id=me_id(2000),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_mild',
            kind='healthstate',
            gbd_id=hs_id(451),
        ),
    ),
    'mild_intellectual_disability_due_to_klinefelter_syndrome': Sequela(
        name='mild_intellectual_disability_due_to_klinefelter_syndrome',
        kind='sequela',
        gbd_id=s_id(573),
        me_id=me_id(2214),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_mild',
            kind='healthstate',
            gbd_id=hs_id(451),
        ),
    ),
    'mild_intellectual_disability_due_to_encephalitis': Sequela(
        name='mild_intellectual_disability_due_to_encephalitis',
        kind='sequela',
        gbd_id=s_id(798),
        me_id=me_id(3491),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_mild',
            kind='healthstate',
            gbd_id=hs_id(451),
        ),
    ),
    'mild_intellectual_disability_due_to_down_syndrome': Sequela(
        name='mild_intellectual_disability_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1213),
        me_id=me_id(9820),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_mild',
            kind='healthstate',
            gbd_id=hs_id(451),
        ),
    ),
    'mild_intellectual_disability_due_to_other_chromosomal_abnormalities': Sequela(
        name='mild_intellectual_disability_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1224),
        me_id=me_id(9844),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_mild',
            kind='healthstate',
            gbd_id=hs_id(451),
        ),
    ),
    'developmental_delay_or_mild_intellectual_disability_due_to_congenital_diaphragmatic_hernia': Sequela(
        name='developmental_delay_or_mild_intellectual_disability_due_to_congenital_diaphragmatic_hernia',
        kind='sequela',
        gbd_id=s_id(1613),
        me_id=me_id(11081),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_mild',
            kind='healthstate',
            gbd_id=hs_id(451),
        ),
    ),
    'mild_intellectual_disability_due_to_encephalocele': Sequela(
        name='mild_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(1913),
        me_id=me_id(11270),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_mild',
            kind='healthstate',
            gbd_id=hs_id(451),
        ),
    ),
    'mild_intellectual_disability_due_to_meningitis': Sequela(
        name='mild_intellectual_disability_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22864),
        me_id=me_id(24047),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_mild',
            kind='healthstate',
            gbd_id=hs_id(451),
        ),
    ),
    'moderate_idiopathic_developmental_intellectual_disability': Sequela(
        name='moderate_idiopathic_developmental_intellectual_disability',
        kind='sequela',
        gbd_id=s_id(489),
        me_id=me_id(2001),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_moderate',
            kind='healthstate',
            gbd_id=hs_id(452),
        ),
    ),
    'moderate_intellectual_disability_due_to_down_syndrome': Sequela(
        name='moderate_intellectual_disability_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1214),
        me_id=me_id(9821),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_moderate',
            kind='healthstate',
            gbd_id=hs_id(452),
        ),
    ),
    'moderate_intellectual_disability_due_to_other_chromosomal_abnormalities': Sequela(
        name='moderate_intellectual_disability_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1225),
        me_id=me_id(9845),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_moderate',
            kind='healthstate',
            gbd_id=hs_id(452),
        ),
    ),
    'moderate_intellectual_disability_due_to_encephalocele': Sequela(
        name='moderate_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(1916),
        me_id=me_id(11271),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_moderate',
            kind='healthstate',
            gbd_id=hs_id(452),
        ),
    ),
    'profound_idiopathic_developmental_intellectual_disability': Sequela(
        name='profound_idiopathic_developmental_intellectual_disability',
        kind='sequela',
        gbd_id=s_id(491),
        me_id=me_id(2003),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_profound',
            kind='healthstate',
            gbd_id=hs_id(454),
        ),
    ),
    'profound_intellectual_disability_due_to_down_syndrome': Sequela(
        name='profound_intellectual_disability_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1216),
        me_id=me_id(9823),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_profound',
            kind='healthstate',
            gbd_id=hs_id(454),
        ),
    ),
    'profound_intellectual_disability_due_to_other_chromosomal_abnormalities': Sequela(
        name='profound_intellectual_disability_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1227),
        me_id=me_id(9847),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_profound',
            kind='healthstate',
            gbd_id=hs_id(454),
        ),
    ),
    'profound_intellectual_disability_due_to_encephalocele': Sequela(
        name='profound_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(1922),
        me_id=me_id(11273),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_profound',
            kind='healthstate',
            gbd_id=hs_id(454),
        ),
    ),
    'visible_goiter_with_profound_intellectual_disability_due_to_iodine_deficiency': Sequela(
        name='visible_goiter_with_profound_intellectual_disability_due_to_iodine_deficiency',
        kind='sequela',
        gbd_id=s_id(202),
        me_id=me_id(1613),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_profound_and_iodine_deficiency_goiter',
            kind='healthstate',
            gbd_id=hs_id(2579),
        ),
    ),
    'severe_idiopathic_developmental_intellectual_disability': Sequela(
        name='severe_idiopathic_developmental_intellectual_disability',
        kind='sequela',
        gbd_id=s_id(490),
        me_id=me_id(2002),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_severe',
            kind='healthstate',
            gbd_id=hs_id(453),
        ),
    ),
    'severe_intellectual_disability_due_to_down_syndrome': Sequela(
        name='severe_intellectual_disability_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1215),
        me_id=me_id(9822),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_severe',
            kind='healthstate',
            gbd_id=hs_id(453),
        ),
    ),
    'severe_intellectual_disability_due_to_other_chromosomal_abnormalities': Sequela(
        name='severe_intellectual_disability_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1226),
        me_id=me_id(9846),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_severe',
            kind='healthstate',
            gbd_id=hs_id(453),
        ),
    ),
    'severe_intellectual_disability_due_to_encephalocele': Sequela(
        name='severe_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(1919),
        me_id=me_id(11272),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_severe',
            kind='healthstate',
            gbd_id=hs_id(453),
        ),
    ),
    'visible_goiter_with_severe_intellectual_disability_due_to_iodine_deficiency': Sequela(
        name='visible_goiter_with_severe_intellectual_disability_due_to_iodine_deficiency',
        kind='sequela',
        gbd_id=s_id(201),
        me_id=me_id(1612),
        healthstate=Healthstate(
            name='intellectual_disability_mental_retardation_severe_and_iodine_deficiency_goiter',
            kind='healthstate',
            gbd_id=hs_id(2582),
        ),
    ),
    'heavy_infestation_of_ascariasis': Sequela(
        name='heavy_infestation_of_ascariasis',
        kind='sequela',
        gbd_id=s_id(163),
        me_id=me_id(1513),
        healthstate=Healthstate(
            name='intestinal_nematode_infections_symptomatic',
            kind='healthstate',
            gbd_id=hs_id(363),
        ),
    ),
    'heavy_infestation_of_trichuriasis': Sequela(
        name='heavy_infestation_of_trichuriasis',
        kind='sequela',
        gbd_id=s_id(166),
        me_id=me_id(1516),
        healthstate=Healthstate(
            name='intestinal_nematode_infections_symptomatic',
            kind='healthstate',
            gbd_id=hs_id(363),
        ),
    ),
    'heavy_infestation_of_hookworm': Sequela(
        name='heavy_infestation_of_hookworm',
        kind='sequela',
        gbd_id=s_id(169),
        me_id=me_id(1519),
        healthstate=Healthstate(
            name='intestinal_nematode_infections_symptomatic',
            kind='healthstate',
            gbd_id=hs_id(363),
        ),
    ),
    'moderate_wasting_with_edema': Sequela(
        name='moderate_wasting_with_edema',
        kind='sequela',
        gbd_id=s_id(198),
        me_id=me_id(1606),
        healthstate=Healthstate(
            name='kwashiorkor',
            kind='healthstate',
            gbd_id=hs_id(562),
        ),
    ),
    'severe_wasting_with_edema': Sequela(
        name='severe_wasting_with_edema',
        kind='sequela',
        gbd_id=s_id(2036),
        me_id=me_id(1608),
        healthstate=Healthstate(
            name='kwashiorkor_and_severe_wasting',
            kind='healthstate',
            gbd_id=hs_id(2438),
        ),
    ),
    'atypical_genitalia_and_impotence_due_to_congenital_genital_anomalies': Sequela(
        name='atypical_genitalia_and_impotence_due_to_congenital_genital_anomalies',
        kind='sequela',
        gbd_id=s_id(1730),
        me_id=me_id(11038),
        healthstate=Healthstate(
            name='level_1_disfigurement_and_impotence',
            kind='healthstate',
            gbd_id=hs_id(2273),
        ),
    ),
    'atypical_genitalia_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract': Sequela(
        name='atypical_genitalia_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract',
        kind='sequela',
        gbd_id=s_id(1871),
        me_id=me_id(11368),
        healthstate=Healthstate(
            name='level_1_disfigurement_and_impotence',
            kind='healthstate',
            gbd_id=hs_id(2273),
        ),
    ),
    'incontinence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract': Sequela(
        name='incontinence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract',
        kind='sequela',
        gbd_id=s_id(1874),
        me_id=me_id(11369),
        healthstate=Healthstate(
            name='level_1_disfigurement_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2351),
        ),
    ),
    'chronic_abdominal_pain_and_disfigurement_due_to_congenital_diaphragmatic_hernia': Sequela(
        name='chronic_abdominal_pain_and_disfigurement_due_to_congenital_diaphragmatic_hernia',
        kind='sequela',
        gbd_id=s_id(1616),
        me_id=me_id(11082),
        healthstate=Healthstate(
            name='level_1_disfigurement_with_itch_pain_and_mild_abdominopelvic_problem',
            kind='healthstate',
            gbd_id=hs_id(2228),
        ),
    ),
    'disfigurement_and_mild_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia': Sequela(
        name='disfigurement_and_mild_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia',
        kind='sequela',
        gbd_id=s_id(1625),
        me_id=me_id(11085),
        healthstate=Healthstate(
            name='level_1_disfigurement_with_itch_pain_and_mild_copd_and_other_chronic_respiratory_problems',
            kind='healthstate',
            gbd_id=hs_id(2237),
        ),
    ),
    'disfigurement_and_developmental_delay_due_to_congenital_diaphragmatic_hernia': Sequela(
        name='disfigurement_and_developmental_delay_due_to_congenital_diaphragmatic_hernia',
        kind='sequela',
        gbd_id=s_id(1628),
        me_id=me_id(11086),
        healthstate=Healthstate(
            name='level_1_disfigurement_with_itch_pain_and_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(2240),
        ),
    ),
    'disfigurement_level_2_with_pain_and_mild_motor_impairment_due_to_congenital_limb_deficiency': Sequela(
        name='disfigurement_level_2_with_pain_and_mild_motor_impairment_due_to_congenital_limb_deficiency',
        kind='sequela',
        gbd_id=s_id(1571),
        me_id=me_id(11115),
        healthstate=Healthstate(
            name='level_2_disfigurement_with_itch_pain_and_mild_motor_impairment',
            kind='healthstate',
            gbd_id=hs_id(2222),
        ),
    ),
    'disfigurement_level_2_with_pain_and_mild_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies': Sequela(
        name='disfigurement_level_2_with_pain_and_mild_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies',
        kind='sequela',
        gbd_id=s_id(1595),
        me_id=me_id(11123),
        healthstate=Healthstate(
            name='level_2_disfigurement_with_itch_pain_and_mild_motor_impairment',
            kind='healthstate',
            gbd_id=hs_id(2222),
        ),
    ),
    'disfigurement_level_2_with_pain_and_moderate_motor_impairment_due_to_congenital_limb_deficiency': Sequela(
        name='disfigurement_level_2_with_pain_and_moderate_motor_impairment_due_to_congenital_limb_deficiency',
        kind='sequela',
        gbd_id=s_id(1574),
        me_id=me_id(11116),
        healthstate=Healthstate(
            name='level_2_disfigurement_with_itch_pain_and_moderate_motor_impairment',
            kind='healthstate',
            gbd_id=hs_id(2225),
        ),
    ),
    'disfigurement_level_2_with_pain_and_moderate_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies': Sequela(
        name='disfigurement_level_2_with_pain_and_moderate_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies',
        kind='sequela',
        gbd_id=s_id(1598),
        me_id=me_id(11124),
        healthstate=Healthstate(
            name='level_2_disfigurement_with_itch_pain_and_moderate_motor_impairment',
            kind='healthstate',
            gbd_id=hs_id(2225),
        ),
    ),
    'disfigurement_level_2_and_mild_motor_impairment_due_to_congenital_limb_deficiency': Sequela(
        name='disfigurement_level_2_and_mild_motor_impairment_due_to_congenital_limb_deficiency',
        kind='sequela',
        gbd_id=s_id(1565),
        me_id=me_id(11113),
        healthstate=Healthstate(
            name='level_2_disfigurement_with_mild_motor_impairment',
            kind='healthstate',
            gbd_id=hs_id(2216),
        ),
    ),
    'disfigurement_level_2_and_mild_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies': Sequela(
        name='disfigurement_level_2_and_mild_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies',
        kind='sequela',
        gbd_id=s_id(1589),
        me_id=me_id(11121),
        healthstate=Healthstate(
            name='level_2_disfigurement_with_mild_motor_impairment',
            kind='healthstate',
            gbd_id=hs_id(2216),
        ),
    ),
    'disfigurement_level_2_and_moderate_motor_impairment_due_to_congenital_limb_deficiency': Sequela(
        name='disfigurement_level_2_and_moderate_motor_impairment_due_to_congenital_limb_deficiency',
        kind='sequela',
        gbd_id=s_id(1568),
        me_id=me_id(11114),
        healthstate=Healthstate(
            name='level_2_disfigurement_with_moderate_motor_impairment',
            kind='healthstate',
            gbd_id=hs_id(2219),
        ),
    ),
    'disfigurement_level_2_and_moderate_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies': Sequela(
        name='disfigurement_level_2_and_moderate_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies',
        kind='sequela',
        gbd_id=s_id(1592),
        me_id=me_id(11122),
        healthstate=Healthstate(
            name='level_2_disfigurement_with_moderate_motor_impairment',
            kind='healthstate',
            gbd_id=hs_id(2219),
        ),
    ),
    'severe_disfigurement_and_cardiovascular_complications_due_to_adult_tertiary_syphilis': Sequela(
        name='severe_disfigurement_and_cardiovascular_complications_due_to_adult_tertiary_syphilis',
        kind='sequela',
        gbd_id=s_id(2051),
        me_id=me_id(16411),
        healthstate=Healthstate(
            name='level_3_disfigurement_and_moderate_infectious_disease_acute_episode',
            kind='healthstate',
            gbd_id=hs_id(2444),
        ),
    ),
    'severe_disfigurement_and_neurological_problems_due_to_adult_tertiary_syphilis': Sequela(
        name='severe_disfigurement_and_neurological_problems_due_to_adult_tertiary_syphilis',
        kind='sequela',
        gbd_id=s_id(2054),
        me_id=me_id(16410),
        healthstate=Healthstate(
            name='level_3_disfigurement_and_moderate_motor_plus_cognitive_impairments',
            kind='healthstate',
            gbd_id=hs_id(2447),
        ),
    ),
    'severe_disfigurement_neurological_problems_and_cardiovascular_complications_due_to_adult_tertiary_syphilis': Sequela(
        name='severe_disfigurement_neurological_problems_and_cardiovascular_complications_due_to_adult_tertiary_syphilis',
        kind='sequela',
        gbd_id=s_id(2057),
        me_id=me_id(16409),
        healthstate=Healthstate(
            name='level_3_disfigurement_moderate_motor_plus_cognitive_impairments_and_moderate_infectious_disease_acute_episode',
            kind='healthstate',
            gbd_id=hs_id(2450),
        ),
    ),
    'mild_low_back_pain_without_leg_pain': Sequela(
        name='mild_low_back_pain_without_leg_pain',
        kind='sequela',
        gbd_id=s_id(683),
        me_id=me_id(2648),
        healthstate=Healthstate(
            name='low_back_pain_mild',
            kind='healthstate',
            gbd_id=hs_id(748),
        ),
    ),
    'moderate_low_back_pain_without_leg_pain': Sequela(
        name='moderate_low_back_pain_without_leg_pain',
        kind='sequela',
        gbd_id=s_id(685),
        me_id=me_id(2650),
        healthstate=Healthstate(
            name='low_back_pain_moderate',
            kind='healthstate',
            gbd_id=hs_id(749),
        ),
    ),
    'lymphedema_due_to_lymphatic_filariasis': Sequela(
        name='lymphedema_due_to_lymphatic_filariasis',
        kind='sequela',
        gbd_id=s_id(150),
        me_id=me_id(1492),
        healthstate=Healthstate(
            name='lymphatic_filariasis_symptomatic',
            kind='healthstate',
            gbd_id=hs_id(364),
        ),
    ),
    'mild_major_depressive_disorder': Sequela(
        name='mild_major_depressive_disorder',
        kind='sequela',
        gbd_id=s_id(475),
        me_id=me_id(1982),
        healthstate=Healthstate(
            name='major_depressive_disorder_mild_episode',
            kind='healthstate',
            gbd_id=hs_id(437),
        ),
    ),
    'depression_due_to_premenstrual_syndrome': Sequela(
        name='depression_due_to_premenstrual_syndrome',
        kind='sequela',
        gbd_id=s_id(700),
        me_id=me_id(2676),
        healthstate=Healthstate(
            name='major_depressive_disorder_mild_episode',
            kind='healthstate',
            gbd_id=hs_id(437),
        ),
    ),
    'symptomatic_dysthymia': Sequela(
        name='symptomatic_dysthymia',
        kind='sequela',
        gbd_id=s_id(820),
        me_id=me_id(2862),
        healthstate=Healthstate(
            name='major_depressive_disorder_mild_episode',
            kind='healthstate',
            gbd_id=hs_id(437),
        ),
    ),
    'moderate_major_depressive_disorder': Sequela(
        name='moderate_major_depressive_disorder',
        kind='sequela',
        gbd_id=s_id(476),
        me_id=me_id(1983),
        healthstate=Healthstate(
            name='major_depressive_disorder_moderate_episode',
            kind='healthstate',
            gbd_id=hs_id(438),
        ),
    ),
    'bipolar_disorder_depressive_state': Sequela(
        name='bipolar_disorder_depressive_state',
        kind='sequela',
        gbd_id=s_id(644),
        me_id=me_id(2474),
        healthstate=Healthstate(
            name='major_depressive_disorder_moderate_episode',
            kind='healthstate',
            gbd_id=hs_id(438),
        ),
    ),
    'severe_major_depressive_disorder': Sequela(
        name='severe_major_depressive_disorder',
        kind='sequela',
        gbd_id=s_id(477),
        me_id=me_id(1984),
        healthstate=Healthstate(
            name='major_depressive_disorder_severe_episode',
            kind='healthstate',
            gbd_id=hs_id(439),
        ),
    ),
    'mastectomy_from_breast_cancer_beyond_ten_years': Sequela(
        name='mastectomy_from_breast_cancer_beyond_ten_years',
        kind='sequela',
        gbd_id=s_id(5492),
        me_id=me_id(18780),
        healthstate=Healthstate(
            name='mastectomy',
            kind='healthstate',
            gbd_id=hs_id(370),
        ),
    ),
    'controlled_phase_of_breast_cancer_with_mastectomy': Sequela(
        name='controlled_phase_of_breast_cancer_with_mastectomy',
        kind='sequela',
        gbd_id=s_id(5486),
        me_id=me_id(18778),
        healthstate=Healthstate(
            name='mastectomy_and_generic_medication',
            kind='healthstate',
            gbd_id=hs_id(894),
        ),
    ),
    'abdominal_pain_and_depression_due_to_premenstrual_syndrome': Sequela(
        name='abdominal_pain_and_depression_due_to_premenstrual_syndrome',
        kind='sequela',
        gbd_id=s_id(854),
        me_id=me_id(2935),
        healthstate=Healthstate(
            name='mild_abdominal_pain_and_mild_depression',
            kind='healthstate',
            gbd_id=hs_id(808),
        ),
    ),
    'mild_abdominal_pain_and_primary_infertility_due_to_endometriosis': Sequela(
        name='mild_abdominal_pain_and_primary_infertility_due_to_endometriosis',
        kind='sequela',
        gbd_id=s_id(878),
        me_id=me_id(2959),
        healthstate=Healthstate(
            name='mild_abdominal_pain_and_primary_infertility',
            kind='healthstate',
            gbd_id=hs_id(801),
        ),
    ),
    'primary_infertility_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies': Sequela(
        name='primary_infertility_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies',
        kind='sequela',
        gbd_id=s_id(1733),
        me_id=me_id(11039),
        healthstate=Healthstate(
            name='mild_abdominal_pain_and_primary_infertility',
            kind='healthstate',
            gbd_id=hs_id(801),
        ),
    ),
    'mild_abdominal_pain_and_secondary_infertility_due_to_endometriosis': Sequela(
        name='mild_abdominal_pain_and_secondary_infertility_due_to_endometriosis',
        kind='sequela',
        gbd_id=s_id(881),
        me_id=me_id(2962),
        healthstate=Healthstate(
            name='mild_abdominal_pain_and_secondary_infertility',
            kind='healthstate',
            gbd_id=hs_id(804),
        ),
    ),
    'abdominal_pain_and_stress_incontinence_due_to_genital_prolapse': Sequela(
        name='abdominal_pain_and_stress_incontinence_due_to_genital_prolapse',
        kind='sequela',
        gbd_id=s_id(861),
        me_id=me_id(2942),
        healthstate=Healthstate(
            name='mild_abdominal_pain_and_stress_incontinence',
            kind='healthstate',
            gbd_id=hs_id(807),
        ),
    ),
    'mild_abdominal_pain_due_to_uterine_fibroids_with_mild_anemia': Sequela(
        name='mild_abdominal_pain_due_to_uterine_fibroids_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(1106),
        me_id=me_id(2065),
        healthstate=Healthstate(
            name='mild_abdominal_pain_with_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(865),
        ),
    ),
    'mildly_symptomatic_pud_with_mild_anemia': Sequela(
        name='mildly_symptomatic_pud_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(4952),
        me_id=me_id(16205),
        healthstate=Healthstate(
            name='mild_abdominal_pain_with_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(865),
        ),
    ),
    'mildy_symptomatic_gastritis_duodenitis_with_mild_anemia': Sequela(
        name='mildy_symptomatic_gastritis_duodenitis_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(4985),
        me_id=me_id(16221),
        healthstate=Healthstate(
            name='mild_abdominal_pain_with_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(865),
        ),
    ),
    'mild_abdominal_pain_due_to_uterine_fibroids_with_moderate_anemia': Sequela(
        name='mild_abdominal_pain_due_to_uterine_fibroids_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(1107),
        me_id=me_id(2066),
        healthstate=Healthstate(
            name='mild_abdominal_pain_with_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(866),
        ),
    ),
    'mildly_symptomatic_pud_with_moderate_anemia': Sequela(
        name='mildly_symptomatic_pud_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(4958),
        me_id=me_id(16208),
        healthstate=Healthstate(
            name='mild_abdominal_pain_with_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(866),
        ),
    ),
    'mildly_symptomatic_gastritis_duodenitis_with_moderate_anemia': Sequela(
        name='mildly_symptomatic_gastritis_duodenitis_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(4991),
        me_id=me_id(16224),
        healthstate=Healthstate(
            name='mild_abdominal_pain_with_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(866),
        ),
    ),
    'mild_abdominal_pain_due_to_uterine_fibroids_with_severe_anemia': Sequela(
        name='mild_abdominal_pain_due_to_uterine_fibroids_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1108),
        me_id=me_id(2067),
        healthstate=Healthstate(
            name='mild_abdominal_pain_with_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(867),
        ),
    ),
    'mildly_symptomatic_pud_with_severe_anemia': Sequela(
        name='mildly_symptomatic_pud_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(4964),
        me_id=me_id(16211),
        healthstate=Healthstate(
            name='mild_abdominal_pain_with_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(867),
        ),
    ),
    'moderately_symptomatic_pud_with_severe_anemia': Sequela(
        name='moderately_symptomatic_pud_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(4967),
        me_id=me_id(16212),
        healthstate=Healthstate(
            name='mild_abdominal_pain_with_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(867),
        ),
    ),
    'mildy_symptomatic_gastritis_duodenitis_with_severe_anemia': Sequela(
        name='mildy_symptomatic_gastritis_duodenitis_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(4997),
        me_id=me_id(16227),
        healthstate=Healthstate(
            name='mild_abdominal_pain_with_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(867),
        ),
    ),
    'impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies': Sequela(
        name='impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies',
        kind='sequela',
        gbd_id=s_id(1736),
        me_id=me_id(11040),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_and_impotence',
            kind='healthstate',
            gbd_id=hs_id(2264),
        ),
    ),
    'impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract': Sequela(
        name='impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract',
        kind='sequela',
        gbd_id=s_id(1877),
        me_id=me_id(11370),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_and_impotence',
            kind='healthstate',
            gbd_id=hs_id(2264),
        ),
    ),
    'constipation_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall': Sequela(
        name='constipation_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall',
        kind='sequela',
        gbd_id=s_id(1685),
        me_id=me_id(11166),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_and_level_1_disfigurement',
            kind='healthstate',
            gbd_id=hs_id(2282),
        ),
    ),
    'atypical_genital_and_recurrent_urinary_tract_infections_and_other_abdominal_issues_due_to_congenital_genital_anomalies': Sequela(
        name='atypical_genital_and_recurrent_urinary_tract_infections_and_other_abdominal_issues_due_to_congenital_genital_anomalies',
        kind='sequela',
        gbd_id=s_id(1724),
        me_id=me_id(11036),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_and_level_1_disfigurement',
            kind='healthstate',
            gbd_id=hs_id(2282),
        ),
    ),
    'atypical_genital_and_recurrent_urinary_tract_infections_and_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract': Sequela(
        name='atypical_genital_and_recurrent_urinary_tract_infections_and_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract',
        kind='sequela',
        gbd_id=s_id(1865),
        me_id=me_id(11366),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_and_level_1_disfigurement',
            kind='healthstate',
            gbd_id=hs_id(2282),
        ),
    ),
    'atypical_genitalia_and_incontinence_due_to_congenital_anomalies_of_the_urinary_tract': Sequela(
        name='atypical_genitalia_and_incontinence_due_to_congenital_anomalies_of_the_urinary_tract',
        kind='sequela',
        gbd_id=s_id(1868),
        me_id=me_id(11367),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_and_level_1_disfigurement',
            kind='healthstate',
            gbd_id=hs_id(2282),
        ),
    ),
    'chronic_abdominal_pain_and_mild_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia': Sequela(
        name='chronic_abdominal_pain_and_mild_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia',
        kind='sequela',
        gbd_id=s_id(1619),
        me_id=me_id(11083),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_and_mild_copd_and_other_chronic_respiratory_problems',
            kind='healthstate',
            gbd_id=hs_id(2231),
        ),
    ),
    'chronic_respiratory_problems_and_dysphagia_or_acid_reflux_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract': Sequela(
        name='chronic_respiratory_problems_and_dysphagia_or_acid_reflux_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract',
        kind='sequela',
        gbd_id=s_id(1661),
        me_id=me_id(11158),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_and_mild_copd_and_other_chronic_respiratory_problems',
            kind='healthstate',
            gbd_id=hs_id(2231),
        ),
    ),
    'chronic_respiratory_problems_and_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract': Sequela(
        name='chronic_respiratory_problems_and_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract',
        kind='sequela',
        gbd_id=s_id(1664),
        me_id=me_id(11159),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_and_mild_copd_and_other_chronic_respiratory_problems',
            kind='healthstate',
            gbd_id=hs_id(2231),
        ),
    ),
    'chronic_abdominal_pain_and_developmental_delay_due_to_congenital_diaphragmatic_hernia': Sequela(
        name='chronic_abdominal_pain_and_developmental_delay_due_to_congenital_diaphragmatic_hernia',
        kind='sequela',
        gbd_id=s_id(1622),
        me_id=me_id(11084),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_and_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(2234),
        ),
    ),
    'dysphagia_or_acid_reflux_and_chronic_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract': Sequela(
        name='dysphagia_or_acid_reflux_and_chronic_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract',
        kind='sequela',
        gbd_id=s_id(1667),
        me_id=me_id(11160),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_and_moderate_abdominopelvic_problem',
            kind='healthstate',
            gbd_id=hs_id(2291),
        ),
    ),
    'constipation_and_chronic_abdominal_pain_due_to_congenital_malformations_of_the_abdominal_wall': Sequela(
        name='constipation_and_chronic_abdominal_pain_due_to_congenital_malformations_of_the_abdominal_wall',
        kind='sequela',
        gbd_id=s_id(1691),
        me_id=me_id(11168),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_and_moderate_abdominopelvic_problem',
            kind='healthstate',
            gbd_id=hs_id(2291),
        ),
    ),
    'chronic_abdominal_pain_and_or_nausea_with_acid_reflux_dyspahgia_and_or_constipation_due_to_other_congenital_malformations_of_the_digestive_tract': Sequela(
        name='chronic_abdominal_pain_and_or_nausea_with_acid_reflux_dyspahgia_and_or_constipation_due_to_other_congenital_malformations_of_the_digestive_tract',
        kind='sequela',
        gbd_id=s_id(1706),
        me_id=me_id(11173),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_and_moderate_abdominopelvic_problem',
            kind='healthstate',
            gbd_id=hs_id(2291),
        ),
    ),
    'chronic_abdominal_pain_disfigurement_and_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia': Sequela(
        name='chronic_abdominal_pain_disfigurement_and_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia',
        kind='sequela',
        gbd_id=s_id(1634),
        me_id=me_id(11088),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_mild_copd_and_other_chronic_respiratory_problems_and_level_1_disfigurement_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(2246),
        ),
    ),
    'chronic_abdominal_pain_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia': Sequela(
        name='chronic_abdominal_pain_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia',
        kind='sequela',
        gbd_id=s_id(1640),
        me_id=me_id(11090),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_mild_copd_and_other_chronic_respiratory_problems_and_level_1_disfigurement_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(2246),
        ),
    ),
    'infertility_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies': Sequela(
        name='infertility_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies',
        kind='sequela',
        gbd_id=s_id(1751),
        me_id=me_id(11045),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_primary_infertility_and_impotence',
            kind='healthstate',
            gbd_id=hs_id(2261),
        ),
    ),
    'atypical_genitalia_infertility_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies': Sequela(
        name='atypical_genitalia_infertility_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies',
        kind='sequela',
        gbd_id=s_id(1754),
        me_id=me_id(11046),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_primary_infertility_impotence_and_level_1_disfigurement',
            kind='healthstate',
            gbd_id=hs_id(2258),
        ),
    ),
    'atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies': Sequela(
        name='atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies',
        kind='sequela',
        gbd_id=s_id(1745),
        me_id=me_id(11043),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_level_1_disfigurement_and_impotence',
            kind='healthstate',
            gbd_id=hs_id(2276),
        ),
    ),
    'atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract': Sequela(
        name='atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract',
        kind='sequela',
        gbd_id=s_id(1886),
        me_id=me_id(11373),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_level_1_disfigurement_and_impotence',
            kind='healthstate',
            gbd_id=hs_id(2276),
        ),
    ),
    'atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_infertility_due_to_congenital_genital_anomalies': Sequela(
        name='atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_infertility_due_to_congenital_genital_anomalies',
        kind='sequela',
        gbd_id=s_id(1742),
        me_id=me_id(11042),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_level_1_disfigurement_and_primary_infertility',
            kind='healthstate',
            gbd_id=hs_id(2270),
        ),
    ),
    'atypical_genitalia_infertility_and_impotence_due_to_congenital_genital_anomalies': Sequela(
        name='atypical_genitalia_infertility_and_impotence_due_to_congenital_genital_anomalies',
        kind='sequela',
        gbd_id=s_id(1748),
        me_id=me_id(11044),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_level_1_disfigurement_and_primary_infertility',
            kind='healthstate',
            gbd_id=hs_id(2270),
        ),
    ),
    'chronic_abdominal_pain_disfigurement_developmental_delay_and_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia': Sequela(
        name='chronic_abdominal_pain_disfigurement_developmental_delay_and_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia',
        kind='sequela',
        gbd_id=s_id(1646),
        me_id=me_id(11092),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_mild_copd_and_other_chronic_respiratory_problems_mild_intellectual_disability_and_level_1_disfigurement_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(2255),
        ),
    ),
    'chronic_abdominal_pain_disfigurement_and_developmental_delay_due_to_congenital_diaphragmatic_hernia': Sequela(
        name='chronic_abdominal_pain_disfigurement_and_developmental_delay_due_to_congenital_diaphragmatic_hernia',
        kind='sequela',
        gbd_id=s_id(1637),
        me_id=me_id(11089),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_mild_intellectual_disability_and_level_1_disfigurement_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(2249),
        ),
    ),
    'constipation_chronic_abdominal_pain_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall': Sequela(
        name='constipation_chronic_abdominal_pain_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall',
        kind='sequela',
        gbd_id=s_id(1694),
        me_id=me_id(11169),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_moderate_abdominopelvic_problem_and_level_1_disfigurement',
            kind='healthstate',
            gbd_id=hs_id(2285),
        ),
    ),
    'dysphagia_or_acid_reflux_chronic_abdominal_pain_and_chronic_respiratory_problems_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract': Sequela(
        name='dysphagia_or_acid_reflux_chronic_abdominal_pain_and_chronic_respiratory_problems_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract',
        kind='sequela',
        gbd_id=s_id(1670),
        me_id=me_id(11161),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_moderate_abdominopelvic_problem_and_mild_copd_and_other_chronic_respiratory_problems',
            kind='healthstate',
            gbd_id=hs_id(2288),
        ),
    ),
    'incontinence_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract': Sequela(
        name='incontinence_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract',
        kind='sequela',
        gbd_id=s_id(1892),
        me_id=me_id(11375),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_urinary_incontinence_and_impotence',
            kind='healthstate',
            gbd_id=hs_id(2360),
        ),
    ),
    'atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_incontinence_due_to_congenital_anomalies_of_the_urinary_tract': Sequela(
        name='atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_incontinence_due_to_congenital_anomalies_of_the_urinary_tract',
        kind='sequela',
        gbd_id=s_id(1883),
        me_id=me_id(11372),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_urinary_incontinence_and_level_1_disfigurement',
            kind='healthstate',
            gbd_id=hs_id(2357),
        ),
    ),
    'atypical_genitalia_incontinence_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract': Sequela(
        name='atypical_genitalia_incontinence_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract',
        kind='sequela',
        gbd_id=s_id(1889),
        me_id=me_id(11374),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_urinary_incontinence_and_level_1_disfigurement',
            kind='healthstate',
            gbd_id=hs_id(2357),
        ),
    ),
    'atypical_genitalia_incontinence_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract': Sequela(
        name='atypical_genitalia_incontinence_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract',
        kind='sequela',
        gbd_id=s_id(1895),
        me_id=me_id(11376),
        healthstate=Healthstate(
            name='mild_abdominopelvic_problem_urinary_incontinence_impotence_and_level_1_disfigurement',
            kind='healthstate',
            gbd_id=hs_id(2363),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_hypertension': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(1373),
        me_id=me_id(10870),
        healthstate=Healthstate(
            name='mild_anemia_and_terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(2456),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_glomerulonephritis': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(1385),
        me_id=me_id(10874),
        healthstate=Healthstate(
            name='mild_anemia_and_terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(2456),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_other_causes': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(1397),
        me_id=me_id(10878),
        healthstate=Healthstate(
            name='mild_anemia_and_terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(2456),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_1_diabetes_mellitus': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5273),
        me_id=me_id(19429),
        healthstate=Healthstate(
            name='mild_anemia_and_terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(2456),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_2_diabetes_mellitus': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5276),
        me_id=me_id(19430),
        healthstate=Healthstate(
            name='mild_anemia_and_terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(2456),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_hypertension': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(1421),
        me_id=me_id(10898),
        healthstate=Healthstate(
            name='mild_anemia_with_stage_iv_ckd',
            kind='healthstate',
            gbd_id=hs_id(835),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_glomerulonephritis': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(1433),
        me_id=me_id(10902),
        healthstate=Healthstate(
            name='mild_anemia_with_stage_iv_ckd',
            kind='healthstate',
            gbd_id=hs_id(835),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_other_causes': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(1445),
        me_id=me_id(10906),
        healthstate=Healthstate(
            name='mild_anemia_with_stage_iv_ckd',
            kind='healthstate',
            gbd_id=hs_id(835),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_1_diabetes_mellitus': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5249),
        me_id=me_id(19421),
        healthstate=Healthstate(
            name='mild_anemia_with_stage_iv_ckd',
            kind='healthstate',
            gbd_id=hs_id(835),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_2_diabetes_mellitus': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5252),
        me_id=me_id(19422),
        healthstate=Healthstate(
            name='mild_anemia_with_stage_iv_ckd',
            kind='healthstate',
            gbd_id=hs_id(835),
        ),
    ),
    'disfigurement_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia': Sequela(
        name='disfigurement_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia',
        kind='sequela',
        gbd_id=s_id(1643),
        me_id=me_id(11091),
        healthstate=Healthstate(
            name='mild_copd_and_other_chronic_respiratory_problems_mild_intellectual_disability_and_level_1_disfigurement_with_itch_pain',
            kind='healthstate',
            gbd_id=hs_id(2252),
        ),
    ),
    'borderline_intellectual_disability_and_mild_dementia_due_to_down_syndrome': Sequela(
        name='borderline_intellectual_disability_and_mild_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1301),
        me_id=me_id(10252),
        healthstate=Healthstate(
            name='mild_dementia_borderline_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(929),
        ),
    ),
    'borderline_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='borderline_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1316),
        me_id=me_id(10282),
        healthstate=Healthstate(
            name='mild_dementia_borderline_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(929),
        ),
    ),
    'mild_intellectual_disability_and_mild_dementia_due_to_down_syndrome': Sequela(
        name='mild_intellectual_disability_and_mild_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1300),
        me_id=me_id(10251),
        healthstate=Healthstate(
            name='mild_dementia_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(930),
        ),
    ),
    'mild_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='mild_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1315),
        me_id=me_id(10281),
        healthstate=Healthstate(
            name='mild_dementia_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(930),
        ),
    ),
    'moderate_intellectual_disability_and_mild_dementia_due_to_down_syndrome': Sequela(
        name='moderate_intellectual_disability_and_mild_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1299),
        me_id=me_id(10250),
        healthstate=Healthstate(
            name='mild_dementia_moderate_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(931),
        ),
    ),
    'moderate_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='moderate_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1314),
        me_id=me_id(10280),
        healthstate=Healthstate(
            name='mild_dementia_moderate_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(931),
        ),
    ),
    'profound_intellectual_disability_and_mild_dementia_due_to_down_syndrome': Sequela(
        name='profound_intellectual_disability_and_mild_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1297),
        me_id=me_id(10248),
        healthstate=Healthstate(
            name='mild_dementia_profound_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(933),
        ),
    ),
    'profound_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='profound_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1312),
        me_id=me_id(10278),
        healthstate=Healthstate(
            name='mild_dementia_profound_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(933),
        ),
    ),
    'severe_intellectual_disability_and_mild_dementia_due_to_down_syndrome': Sequela(
        name='severe_intellectual_disability_and_mild_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1298),
        me_id=me_id(10249),
        healthstate=Healthstate(
            name='mild_dementia_severe_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(932),
        ),
    ),
    'severe_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='severe_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1313),
        me_id=me_id(10279),
        healthstate=Healthstate(
            name='mild_dementia_severe_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(932),
        ),
    ),
    '_mild_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia': Sequela(
        name='_mild_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia',
        kind='sequela',
        gbd_id=s_id(1631),
        me_id=me_id(11087),
        healthstate=Healthstate(
            name='mild_intellectual_disability_and_mild_copd_and_other_chronic_respiratory_problem',
            kind='healthstate',
            gbd_id=hs_id(2243),
        ),
    ),
    'mild_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='mild_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(1931),
        me_id=me_id(11276),
        healthstate=Healthstate(
            name='mild_intellectual_disability_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2372),
        ),
    ),
    'mild_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='mild_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1218),
        me_id=me_id(9825),
        healthstate=Healthstate(
            name='mild_intellectual_disability_with_congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(898),
        ),
    ),
    'mild_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='mild_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1229),
        me_id=me_id(9849),
        healthstate=Healthstate(
            name='mild_intellectual_disability_with_congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(898),
        ),
    ),
    'mild_intellectual_disability_with_infertility_due_to_klinefelter_syndrome': Sequela(
        name='mild_intellectual_disability_with_infertility_due_to_klinefelter_syndrome',
        kind='sequela',
        gbd_id=s_id(574),
        me_id=me_id(2218),
        healthstate=Healthstate(
            name='mild_intellectual_disability_with_primary_infertility',
            kind='healthstate',
            gbd_id=hs_id(774),
        ),
    ),
    'mild_low_back_pain_with_leg_pain': Sequela(
        name='mild_low_back_pain_with_leg_pain',
        kind='sequela',
        gbd_id=s_id(682),
        me_id=me_id(2647),
        healthstate=Healthstate(
            name='mild_low_back_pain_with_leg_pain',
            kind='healthstate',
            gbd_id=hs_id(764),
        ),
    ),
    'mild_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida': Sequela(
        name='mild_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1952),
        me_id=me_id(11283),
        healthstate=Healthstate(
            name='mild_motor_impairment_and_borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2384),
        ),
    ),
    'mild_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele': Sequela(
        name='mild_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2096),
        me_id=me_id(11536),
        healthstate=Healthstate(
            name='mild_motor_impairment_and_borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2384),
        ),
    ),
    'mild_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease': Sequela(
        name='mild_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1163),
        me_id=me_id(9695),
        healthstate=Healthstate(
            name='mild_motor_impairment_and_mild_respiratory_problems',
            kind='healthstate',
            gbd_id=hs_id(877),
        ),
    ),
    'mild_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida': Sequela(
        name='mild_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1970),
        me_id=me_id(11289),
        healthstate=Healthstate(
            name='mild_motor_impairment_and_moderate_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2396),
        ),
    ),
    'mild_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele': Sequela(
        name='mild_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2114),
        me_id=me_id(11542),
        healthstate=Healthstate(
            name='mild_motor_impairment_and_moderate_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2396),
        ),
    ),
    'mild_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease': Sequela(
        name='mild_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(22733),
        me_id=me_id(9696),
        healthstate=Healthstate(
            name='mild_motor_impairment_and_moderate_respiratory_problems',
            kind='healthstate',
            gbd_id=hs_id(878),
        ),
    ),
    'mild_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida': Sequela(
        name='mild_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1979),
        me_id=me_id(11292),
        healthstate=Healthstate(
            name='mild_motor_impairment_and_severe_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2399),
        ),
    ),
    'mild_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele': Sequela(
        name='mild_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2123),
        me_id=me_id(11545),
        healthstate=Healthstate(
            name='mild_motor_impairment_and_severe_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2399),
        ),
    ),
    'mild_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease': Sequela(
        name='mild_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1164),
        me_id=me_id(9697),
        healthstate=Healthstate(
            name='mild_motor_impairment_and_severe_respiratory_problems',
            kind='healthstate',
            gbd_id=hs_id(879),
        ),
    ),
    'mild_motor_impairment_and_speech_problems_due_to_motor_neuron_disease': Sequela(
        name='mild_motor_impairment_and_speech_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1156),
        me_id=me_id(9682),
        healthstate=Healthstate(
            name='mild_motor_impairment_and_speech_problems',
            kind='healthstate',
            gbd_id=hs_id(886),
        ),
    ),
    'mild_motor_impairment_and_incontinence_due_to_spina_bifida': Sequela(
        name='mild_motor_impairment_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2024),
        me_id=me_id(11307),
        healthstate=Healthstate(
            name='mild_motor_impairment_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2432),
        ),
    ),
    'mild_motor_impairment_and_incontinence_due_to_encephalocele': Sequela(
        name='mild_motor_impairment_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2087),
        me_id=me_id(11533),
        healthstate=Healthstate(
            name='mild_motor_impairment_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2432),
        ),
    ),
    'mild_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease': Sequela(
        name='mild_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1153),
        me_id=me_id(9679),
        healthstate=Healthstate(
            name='mild_motor_impairment_with_mild_respiratory_problems_and_speech_problems',
            kind='healthstate',
            gbd_id=hs_id(868),
        ),
    ),
    'mild_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease': Sequela(
        name='mild_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1154),
        me_id=me_id(9680),
        healthstate=Healthstate(
            name='mild_motor_impairment_with_moderate_respiratory_problems_and_speech_problems',
            kind='healthstate',
            gbd_id=hs_id(869),
        ),
    ),
    'mild_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida': Sequela(
        name='mild_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2060),
        me_id=me_id(11523),
        healthstate=Healthstate(
            name='mild_motor_impairment_with_profound_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(2597),
        ),
    ),
    'mild_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease': Sequela(
        name='mild_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1155),
        me_id=me_id(9681),
        healthstate=Healthstate(
            name='mild_motor_impairment_with_severe_respiratory_problems_and_speech_problems',
            kind='healthstate',
            gbd_id=hs_id(870),
        ),
    ),
    'mild_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida': Sequela(
        name='mild_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1988),
        me_id=me_id(11295),
        healthstate=Healthstate(
            name='mild_motor_impairment_borderline_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2405),
        ),
    ),
    'mild_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='mild_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2141),
        me_id=me_id(11551),
        healthstate=Healthstate(
            name='mild_motor_impairment_borderline_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2405),
        ),
    ),
    'mild_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida': Sequela(
        name='mild_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1997),
        me_id=me_id(11298),
        healthstate=Healthstate(
            name='mild_motor_impairment_mild_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2414),
        ),
    ),
    'mild_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='mild_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2150),
        me_id=me_id(11554),
        healthstate=Healthstate(
            name='mild_motor_impairment_mild_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2414),
        ),
    ),
    'mild_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida': Sequela(
        name='mild_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2006),
        me_id=me_id(11301),
        healthstate=Healthstate(
            name='mild_motor_impairment_moderate_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2420),
        ),
    ),
    'mild_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='mild_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2159),
        me_id=me_id(11557),
        healthstate=Healthstate(
            name='mild_motor_impairment_moderate_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2420),
        ),
    ),
    'mild_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida': Sequela(
        name='mild_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2069),
        me_id=me_id(11526),
        healthstate=Healthstate(
            name='mild_motor_impairment_profound_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2453),
        ),
    ),
    'moderate_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='moderate_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2180),
        me_id=me_id(11564),
        healthstate=Healthstate(
            name='mild_motor_impairment_profound_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2453),
        ),
    ),
    'mild_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida': Sequela(
        name='mild_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2015),
        me_id=me_id(11304),
        healthstate=Healthstate(
            name='mild_motor_impairment_servere_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2426),
        ),
    ),
    'mild_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='mild_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2168),
        me_id=me_id(11560),
        healthstate=Healthstate(
            name='mild_motor_impairment_servere_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2426),
        ),
    ),
    'mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease': Sequela(
        name='mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1176),
        me_id=me_id(9691),
        healthstate=Healthstate(
            name='mild_respiratory_and_speech_problems',
            kind='healthstate',
            gbd_id=hs_id(889),
        ),
    ),
    'moderate_abdominal_pain_and_primary_infertility_due_to_endometriosis': Sequela(
        name='moderate_abdominal_pain_and_primary_infertility_due_to_endometriosis',
        kind='sequela',
        gbd_id=s_id(879),
        me_id=me_id(2960),
        healthstate=Healthstate(
            name='moderate_abdominal_pain_and_primary_infertility',
            kind='healthstate',
            gbd_id=hs_id(802),
        ),
    ),
    'moderate_abdominal_pain_and_secondary_infertility_due_to_endometriosis': Sequela(
        name='moderate_abdominal_pain_and_secondary_infertility_due_to_endometriosis',
        kind='sequela',
        gbd_id=s_id(882),
        me_id=me_id(2963),
        healthstate=Healthstate(
            name='moderate_abdominal_pain_and_secondary_infertility',
            kind='healthstate',
            gbd_id=hs_id(805),
        ),
    ),
    'eclampsia': Sequela(
        name='eclampsia',
        kind='sequela',
        gbd_id=s_id(186),
        me_id=me_id(3635),
        healthstate=Healthstate(
            name='moderate_abdominal_pain_and_severe_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(826),
        ),
    ),
    'moderately_symptomatic_pud_with_mild_anemia': Sequela(
        name='moderately_symptomatic_pud_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(4955),
        me_id=me_id(16206),
        healthstate=Healthstate(
            name='moderate_abdominal_pain_with_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2465),
        ),
    ),
    'moderately_symptomatic_gastritis_duodenitis_with_mild_anemia': Sequela(
        name='moderately_symptomatic_gastritis_duodenitis_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(4988),
        me_id=me_id(16222),
        healthstate=Healthstate(
            name='moderate_abdominal_pain_with_mild_anemia',
            kind='healthstate',
            gbd_id=hs_id(2465),
        ),
    ),
    'moderately_symptomatic_pud_with_moderate_anemia': Sequela(
        name='moderately_symptomatic_pud_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(4961),
        me_id=me_id(16209),
        healthstate=Healthstate(
            name='moderate_abdominal_pain_with_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2468),
        ),
    ),
    'moderately_symptomatic_gastritis_duodenitis_with_moderate_anemia': Sequela(
        name='moderately_symptomatic_gastritis_duodenitis_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(4994),
        me_id=me_id(16225),
        healthstate=Healthstate(
            name='moderate_abdominal_pain_with_moderate_anemia',
            kind='healthstate',
            gbd_id=hs_id(2468),
        ),
    ),
    'moderately_symptomatic_gastritis_duodenitis_with_severe_anemia': Sequela(
        name='moderately_symptomatic_gastritis_duodenitis_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5000),
        me_id=me_id(16228),
        healthstate=Healthstate(
            name='moderate_abdominal_pain_with_severe_anemia',
            kind='healthstate',
            gbd_id=hs_id(2471),
        ),
    ),
    'severe_pre_eclampsia': Sequela(
        name='severe_pre_eclampsia',
        kind='sequela',
        gbd_id=s_id(185),
        me_id=me_id(1542),
        healthstate=Healthstate(
            name='moderate_abdominal_pain_tension_type_headaches_mild_motor_plus_cognitive_impairment',
            kind='healthstate',
            gbd_id=hs_id(824),
        ),
    ),
    'homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_severe_anemia': Sequela(
        name='homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1074),
        me_id=me_id(3296),
        healthstate=Healthstate(
            name='moderate_abdominal_pain_anemia_severe_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(857),
        ),
    ),
    'hemoglobin_sc_disease_with_vaso_occlusive_crisis_and_severe_anemia': Sequela(
        name='hemoglobin_sc_disease_with_vaso_occlusive_crisis_and_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1083),
        me_id=me_id(3305),
        healthstate=Healthstate(
            name='moderate_abdominal_pain_anemia_severe_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(857),
        ),
    ),
    'mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_severe_anemia': Sequela(
        name='mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_severe_anemia',
        kind='sequela',
        gbd_id=s_id(1093),
        me_id=me_id(3315),
        healthstate=Healthstate(
            name='moderate_abdominal_pain_anemia_severe_generic_uncomplicated_disease_anxiety',
            kind='healthstate',
            gbd_id=hs_id(857),
        ),
    ),
    'chronic_abdominal_pain_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall': Sequela(
        name='chronic_abdominal_pain_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall',
        kind='sequela',
        gbd_id=s_id(1688),
        me_id=me_id(11167),
        healthstate=Healthstate(
            name='moderate_abdominopelvic_problem_and_level_1_disfigurement',
            kind='healthstate',
            gbd_id=hs_id(2267),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_hypertension': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(1376),
        me_id=me_id(10871),
        healthstate=Healthstate(
            name='moderate_anemia_and_terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(2459),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_glomerulonephritis': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(1388),
        me_id=me_id(10875),
        healthstate=Healthstate(
            name='moderate_anemia_and_terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(2459),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_other_causes': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(1400),
        me_id=me_id(10879),
        healthstate=Healthstate(
            name='moderate_anemia_and_terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(2459),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_1_diabetes_mellitus': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5267),
        me_id=me_id(19427),
        healthstate=Healthstate(
            name='moderate_anemia_and_terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(2459),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_2_diabetes_mellitus': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5270),
        me_id=me_id(19428),
        healthstate=Healthstate(
            name='moderate_anemia_and_terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(2459),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_hypertension': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(1424),
        me_id=me_id(10899),
        healthstate=Healthstate(
            name='moderate_anemia_with_stage_iv_ckd',
            kind='healthstate',
            gbd_id=hs_id(836),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_glomerulonephritis': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(1436),
        me_id=me_id(10903),
        healthstate=Healthstate(
            name='moderate_anemia_with_stage_iv_ckd',
            kind='healthstate',
            gbd_id=hs_id(836),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_other_causes': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(1448),
        me_id=me_id(10907),
        healthstate=Healthstate(
            name='moderate_anemia_with_stage_iv_ckd',
            kind='healthstate',
            gbd_id=hs_id(836),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_1_diabetes_mellitus': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5243),
        me_id=me_id(19419),
        healthstate=Healthstate(
            name='moderate_anemia_with_stage_iv_ckd',
            kind='healthstate',
            gbd_id=hs_id(836),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_2_diabetes_mellitus': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5246),
        me_id=me_id(19420),
        healthstate=Healthstate(
            name='moderate_anemia_with_stage_iv_ckd',
            kind='healthstate',
            gbd_id=hs_id(836),
        ),
    ),
    'borderline_intellectual_disability_and_moderate_dementia_due_to_down_syndrome': Sequela(
        name='borderline_intellectual_disability_and_moderate_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1306),
        me_id=me_id(10257),
        healthstate=Healthstate(
            name='moderate_dementia_borderline_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(934),
        ),
    ),
    'borderline_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='borderline_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1321),
        me_id=me_id(10287),
        healthstate=Healthstate(
            name='moderate_dementia_borderline_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(934),
        ),
    ),
    'mild_intellectual_disability_and_moderate_dementia_due_to_down_syndrome': Sequela(
        name='mild_intellectual_disability_and_moderate_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1305),
        me_id=me_id(10256),
        healthstate=Healthstate(
            name='moderate_dementia_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(935),
        ),
    ),
    'mild_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='mild_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1320),
        me_id=me_id(10286),
        healthstate=Healthstate(
            name='moderate_dementia_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(935),
        ),
    ),
    'moderate_intellectual_disability_and_moderate_dementia_due_to_down_syndrome': Sequela(
        name='moderate_intellectual_disability_and_moderate_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1304),
        me_id=me_id(10255),
        healthstate=Healthstate(
            name='moderate_dementia_moderate_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(936),
        ),
    ),
    'moderate_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='moderate_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1319),
        me_id=me_id(10285),
        healthstate=Healthstate(
            name='moderate_dementia_moderate_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(936),
        ),
    ),
    'profound_intellectual_disability_and_moderate_dementia_due_to_down_syndrome': Sequela(
        name='profound_intellectual_disability_and_moderate_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1302),
        me_id=me_id(10253),
        healthstate=Healthstate(
            name='moderate_dementia_profound_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(938),
        ),
    ),
    'profound_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='profound_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1317),
        me_id=me_id(10283),
        healthstate=Healthstate(
            name='moderate_dementia_profound_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(938),
        ),
    ),
    'severe_intellectual_disability_and_moderate_dementia_due_to_down_syndrome': Sequela(
        name='severe_intellectual_disability_and_moderate_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1303),
        me_id=me_id(10254),
        healthstate=Healthstate(
            name='moderate_dementia_severe_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(937),
        ),
    ),
    'severe_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='severe_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1318),
        me_id=me_id(10284),
        healthstate=Healthstate(
            name='moderate_dementia_severe_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(937),
        ),
    ),
    'moderate_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='moderate_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(1934),
        me_id=me_id(11277),
        healthstate=Healthstate(
            name='moderate_intellectual_disability_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2375),
        ),
    ),
    'moderate_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='moderate_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1219),
        me_id=me_id(9826),
        healthstate=Healthstate(
            name='moderate_intellectual_disability_with_congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(899),
        ),
    ),
    'moderate_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='moderate_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1230),
        me_id=me_id(9850),
        healthstate=Healthstate(
            name='moderate_intellectual_disability_with_congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(899),
        ),
    ),
    'moderate_low_back_pain_with_leg_pain': Sequela(
        name='moderate_low_back_pain_with_leg_pain',
        kind='sequela',
        gbd_id=s_id(684),
        me_id=me_id(2649),
        healthstate=Healthstate(
            name='moderate_low_back_pain_with_leg_pain',
            kind='healthstate',
            gbd_id=hs_id(765),
        ),
    ),
    'moderate_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida': Sequela(
        name='moderate_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1955),
        me_id=me_id(11284),
        healthstate=Healthstate(
            name='moderate_motor_impairment_and_borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2387),
        ),
    ),
    'moderate_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele': Sequela(
        name='moderate_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2099),
        me_id=me_id(11537),
        healthstate=Healthstate(
            name='moderate_motor_impairment_and_borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2387),
        ),
    ),
    'moderate_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida': Sequela(
        name='moderate_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1964),
        me_id=me_id(11287),
        healthstate=Healthstate(
            name='moderate_motor_impairment_and_mild_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2393),
        ),
    ),
    'moderate_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele': Sequela(
        name='moderate_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2108),
        me_id=me_id(11540),
        healthstate=Healthstate(
            name='moderate_motor_impairment_and_mild_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2393),
        ),
    ),
    'moderate_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease': Sequela(
        name='moderate_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1165),
        me_id=me_id(9699),
        healthstate=Healthstate(
            name='moderate_motor_impairment_and_mild_respiratory_problems',
            kind='healthstate',
            gbd_id=hs_id(880),
        ),
    ),
    'moderate_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease': Sequela(
        name='moderate_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1166),
        me_id=me_id(9700),
        healthstate=Healthstate(
            name='moderate_motor_impairment_and_moderate_respiratory_problems',
            kind='healthstate',
            gbd_id=hs_id(881),
        ),
    ),
    'moderate_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida': Sequela(
        name='moderate_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1982),
        me_id=me_id(11293),
        healthstate=Healthstate(
            name='moderate_motor_impairment_and_severe_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2402),
        ),
    ),
    'moderate_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele': Sequela(
        name='moderate_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2126),
        me_id=me_id(11546),
        healthstate=Healthstate(
            name='moderate_motor_impairment_and_severe_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2402),
        ),
    ),
    'moderate_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease': Sequela(
        name='moderate_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1167),
        me_id=me_id(9701),
        healthstate=Healthstate(
            name='moderate_motor_impairment_and_severe_respiratory_problems',
            kind='healthstate',
            gbd_id=hs_id(882),
        ),
    ),
    'moderate_motor_impairment_and_speech_problems_due_to_motor_neuron_disease': Sequela(
        name='moderate_motor_impairment_and_speech_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1171),
        me_id=me_id(9686),
        healthstate=Healthstate(
            name='moderate_motor_impairment_and_speech_problems',
            kind='healthstate',
            gbd_id=hs_id(887),
        ),
    ),
    'moderate_motor_impairment_and_incontinence_due_to_spina_bifida': Sequela(
        name='moderate_motor_impairment_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2027),
        me_id=me_id(11308),
        healthstate=Healthstate(
            name='moderate_motor_impairment_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2435),
        ),
    ),
    'moderate_motor_impairment_and_incontinence_due_to_encephalocele': Sequela(
        name='moderate_motor_impairment_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2090),
        me_id=me_id(11534),
        healthstate=Healthstate(
            name='moderate_motor_impairment_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2435),
        ),
    ),
    'moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks': Sequela(
        name='moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks',
        kind='sequela',
        gbd_id=s_id(743),
        me_id=me_id(3671),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(775),
        ),
    ),
    'moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks': Sequela(
        name='moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks',
        kind='sequela',
        gbd_id=s_id(744),
        me_id=me_id(3713),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(775),
        ),
    ),
    'moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks': Sequela(
        name='moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks',
        kind='sequela',
        gbd_id=s_id(745),
        me_id=me_id(3755),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(775),
        ),
    ),
    'moderate_motor_impairment_with_blindness_due_to_neonatal_tetanus': Sequela(
        name='moderate_motor_impairment_with_blindness_due_to_neonatal_tetanus',
        kind='sequela',
        gbd_id=s_id(746),
        me_id=me_id(3521),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(775),
        ),
    ),
    'moderate_motor_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='moderate_motor_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(747),
        me_id=me_id(3803),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(775),
        ),
    ),
    'moderate_motor_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice': Sequela(
        name='moderate_motor_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice',
        kind='sequela',
        gbd_id=s_id(748),
        me_id=me_id(3845),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(775),
        ),
    ),
    'moderate_motor_impairment_with_blindness_due_to_malaria': Sequela(
        name='moderate_motor_impairment_with_blindness_due_to_malaria',
        kind='sequela',
        gbd_id=s_id(885),
        me_id=me_id(3563),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(775),
        ),
    ),
    'moderate_motor_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='moderate_motor_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1254),
        me_id=me_id(9620),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(775),
        ),
    ),
    'moderate_motor_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice': Sequela(
        name='moderate_motor_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice',
        kind='sequela',
        gbd_id=s_id(749),
        me_id=me_id(3851),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(777),
        ),
    ),
    'moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(750),
        me_id=me_id(3809),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(777),
        ),
    ),
    'moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks': Sequela(
        name='moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks',
        kind='sequela',
        gbd_id=s_id(751),
        me_id=me_id(3761),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(777),
        ),
    ),
    'moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks': Sequela(
        name='moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks',
        kind='sequela',
        gbd_id=s_id(752),
        me_id=me_id(3719),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(777),
        ),
    ),
    'moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks': Sequela(
        name='moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks',
        kind='sequela',
        gbd_id=s_id(753),
        me_id=me_id(3677),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(777),
        ),
    ),
    'moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus': Sequela(
        name='moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus',
        kind='sequela',
        gbd_id=s_id(754),
        me_id=me_id(3527),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(777),
        ),
    ),
    'moderate_motor_impairment_with_blindness_and_epilepsy_due_to_malaria': Sequela(
        name='moderate_motor_impairment_with_blindness_and_epilepsy_due_to_malaria',
        kind='sequela',
        gbd_id=s_id(887),
        me_id=me_id(3569),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(777),
        ),
    ),
    'moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1256),
        me_id=me_id(9622),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(777),
        ),
    ),
    'moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks': Sequela(
        name='moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks',
        kind='sequela',
        gbd_id=s_id(755),
        me_id=me_id(3758),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(776),
        ),
    ),
    'moderate_motor_impairment_with_epilepsy_due_to_neonatal_tetanus': Sequela(
        name='moderate_motor_impairment_with_epilepsy_due_to_neonatal_tetanus',
        kind='sequela',
        gbd_id=s_id(756),
        me_id=me_id(3524),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(776),
        ),
    ),
    'moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks': Sequela(
        name='moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks',
        kind='sequela',
        gbd_id=s_id(757),
        me_id=me_id(3716),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(776),
        ),
    ),
    'moderate_motor_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='moderate_motor_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(758),
        me_id=me_id(3806),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(776),
        ),
    ),
    'moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks': Sequela(
        name='moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks',
        kind='sequela',
        gbd_id=s_id(759),
        me_id=me_id(3674),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(776),
        ),
    ),
    'moderate_motor_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice': Sequela(
        name='moderate_motor_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice',
        kind='sequela',
        gbd_id=s_id(760),
        me_id=me_id(3848),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(776),
        ),
    ),
    'moderate_motor_impairment_with_epilepsy_due_to_malaria': Sequela(
        name='moderate_motor_impairment_with_epilepsy_due_to_malaria',
        kind='sequela',
        gbd_id=s_id(886),
        me_id=me_id(3566),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(776),
        ),
    ),
    'moderate_motor_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='moderate_motor_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1255),
        me_id=me_id(9621),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(776),
        ),
    ),
    'moderate_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease': Sequela(
        name='moderate_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1157),
        me_id=me_id(9683),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_mild_respiratory_problems_and_speech_problems',
            kind='healthstate',
            gbd_id=hs_id(871),
        ),
    ),
    'moderate_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease': Sequela(
        name='moderate_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1158),
        me_id=me_id(9684),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_moderate_respiratory_problems_and_speech_problems',
            kind='healthstate',
            gbd_id=hs_id(872),
        ),
    ),
    'moderate_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida': Sequela(
        name='moderate_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2063),
        me_id=me_id(11524),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_profound_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(2600),
        ),
    ),
    'moderate_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida': Sequela(
        name='moderate_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2072),
        me_id=me_id(11527),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_profound_intellectual_disability_and_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2603),
        ),
    ),
    'moderate_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease': Sequela(
        name='moderate_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1159),
        me_id=me_id(9685),
        healthstate=Healthstate(
            name='moderate_motor_impairment_with_severe_respiratory_problems_and_speech_problems',
            kind='healthstate',
            gbd_id=hs_id(873),
        ),
    ),
    'moderate_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida': Sequela(
        name='moderate_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1991),
        me_id=me_id(11296),
        healthstate=Healthstate(
            name='moderate_motor_impairment_borderline_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2408),
        ),
    ),
    'moderate_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='moderate_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2144),
        me_id=me_id(11552),
        healthstate=Healthstate(
            name='moderate_motor_impairment_borderline_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2408),
        ),
    ),
    'moderate_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida': Sequela(
        name='moderate_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2000),
        me_id=me_id(11299),
        healthstate=Healthstate(
            name='moderate_motor_impairment_mild_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2417),
        ),
    ),
    'moderate_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='moderate_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2153),
        me_id=me_id(11555),
        healthstate=Healthstate(
            name='moderate_motor_impairment_mild_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2417),
        ),
    ),
    'moderate_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida': Sequela(
        name='moderate_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2009),
        me_id=me_id(11302),
        healthstate=Healthstate(
            name='moderate_motor_impairment_moderate_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2423),
        ),
    ),
    'moderate_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='moderate_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2162),
        me_id=me_id(11558),
        healthstate=Healthstate(
            name='moderate_motor_impairment_moderate_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2423),
        ),
    ),
    'moderate_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida': Sequela(
        name='moderate_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2018),
        me_id=me_id(11305),
        healthstate=Healthstate(
            name='moderate_motor_impairment_servere_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2429),
        ),
    ),
    'moderate_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='moderate_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2171),
        me_id=me_id(11561),
        healthstate=Healthstate(
            name='moderate_motor_impairment_servere_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2429),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice',
        kind='sequela',
        gbd_id=s_id(701),
        me_id=me_id(3854),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(778),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks',
        kind='sequela',
        gbd_id=s_id(702),
        me_id=me_id(3722),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(778),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks',
        kind='sequela',
        gbd_id=s_id(703),
        me_id=me_id(3680),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(778),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks',
        kind='sequela',
        gbd_id=s_id(704),
        me_id=me_id(3764),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(778),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(705),
        me_id=me_id(3812),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(778),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_tetanus': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_tetanus',
        kind='sequela',
        gbd_id=s_id(706),
        me_id=me_id(3530),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(778),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_blindness_due_to_malaria': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_blindness_due_to_malaria',
        kind='sequela',
        gbd_id=s_id(888),
        me_id=me_id(3572),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(778),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1257),
        me_id=me_id(9623),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(778),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks',
        kind='sequela',
        gbd_id=s_id(707),
        me_id=me_id(3770),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(780),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks',
        kind='sequela',
        gbd_id=s_id(708),
        me_id=me_id(3686),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(780),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks',
        kind='sequela',
        gbd_id=s_id(709),
        me_id=me_id(3728),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(780),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus',
        kind='sequela',
        gbd_id=s_id(710),
        me_id=me_id(3536),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(780),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice',
        kind='sequela',
        gbd_id=s_id(711),
        me_id=me_id(3860),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(780),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(712),
        me_id=me_id(3818),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(780),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_malaria': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_malaria',
        kind='sequela',
        gbd_id=s_id(890),
        me_id=me_id(3578),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(780),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1259),
        me_id=me_id(9625),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(780),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks',
        kind='sequela',
        gbd_id=s_id(713),
        me_id=me_id(3767),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(779),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_tetanus': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_tetanus',
        kind='sequela',
        gbd_id=s_id(714),
        me_id=me_id(3533),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(779),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice',
        kind='sequela',
        gbd_id=s_id(715),
        me_id=me_id(3857),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(779),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(716),
        me_id=me_id(3815),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(779),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks',
        kind='sequela',
        gbd_id=s_id(717),
        me_id=me_id(3683),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(779),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks',
        kind='sequela',
        gbd_id=s_id(718),
        me_id=me_id(3725),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(779),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_malaria': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_malaria',
        kind='sequela',
        gbd_id=s_id(889),
        me_id=me_id(3575),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(779),
        ),
    ),
    'moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1258),
        me_id=me_id(9624),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(779),
        ),
    ),
    'neurological_problems_and_cardiovascular_complications_due_to_adult_tertiary_syphilis': Sequela(
        name='neurological_problems_and_cardiovascular_complications_due_to_adult_tertiary_syphilis',
        kind='sequela',
        gbd_id=s_id(2048),
        me_id=me_id(16413),
        healthstate=Healthstate(
            name='moderate_motor_plus_cognitive_impairments_and_moderate_infectious_disease_acute_episode',
            kind='healthstate',
            gbd_id=hs_id(2441),
        ),
    ),
    'moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease': Sequela(
        name='moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1177),
        me_id=me_id(9692),
        healthstate=Healthstate(
            name='moderate_respiratory_and_speech_problems',
            kind='healthstate',
            gbd_id=hs_id(890),
        ),
    ),
    'mild_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='mild_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(195),
        me_id=me_id(3797),
        healthstate=Healthstate(
            name='motor_impairment_mild',
            kind='healthstate',
            gbd_id=hs_id(565),
        ),
    ),
    'mild_motor_impairment_due_to_neonatal_tetanus': Sequela(
        name='mild_motor_impairment_due_to_neonatal_tetanus',
        kind='sequela',
        gbd_id=s_id(785),
        me_id=me_id(3512),
        healthstate=Healthstate(
            name='motor_impairment_mild',
            kind='healthstate',
            gbd_id=hs_id(565),
        ),
    ),
    'mild_motor_impairment_due_to_long_term_due_to_encephalitis': Sequela(
        name='mild_motor_impairment_due_to_long_term_due_to_encephalitis',
        kind='sequela',
        gbd_id=s_id(794),
        me_id=me_id(3482),
        healthstate=Healthstate(
            name='motor_impairment_mild',
            kind='healthstate',
            gbd_id=hs_id(565),
        ),
    ),
    'mild_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks': Sequela(
        name='mild_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks',
        kind='sequela',
        gbd_id=s_id(868),
        me_id=me_id(3650),
        healthstate=Healthstate(
            name='motor_impairment_mild',
            kind='healthstate',
            gbd_id=hs_id(565),
        ),
    ),
    'mild_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks': Sequela(
        name='mild_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks',
        kind='sequela',
        gbd_id=s_id(869),
        me_id=me_id(3656),
        healthstate=Healthstate(
            name='motor_impairment_mild',
            kind='healthstate',
            gbd_id=hs_id(565),
        ),
    ),
    'mild_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks': Sequela(
        name='mild_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks',
        kind='sequela',
        gbd_id=s_id(870),
        me_id=me_id(3662),
        healthstate=Healthstate(
            name='motor_impairment_mild',
            kind='healthstate',
            gbd_id=hs_id(565),
        ),
    ),
    'mild_motor_impairment_due_to_motor_neuron_disease': Sequela(
        name='mild_motor_impairment_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1173),
        me_id=me_id(9698),
        healthstate=Healthstate(
            name='motor_impairment_mild',
            kind='healthstate',
            gbd_id=hs_id(565),
        ),
    ),
    'mild_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='mild_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1252),
        me_id=me_id(9618),
        healthstate=Healthstate(
            name='motor_impairment_mild',
            kind='healthstate',
            gbd_id=hs_id(565),
        ),
    ),
    'mild_motor_impairment_due_to_spina_bifida': Sequela(
        name='mild_motor_impairment_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1943),
        me_id=me_id(11280),
        healthstate=Healthstate(
            name='motor_impairment_mild',
            kind='healthstate',
            gbd_id=hs_id(565),
        ),
    ),
    'mild_motor_impairment_due_to_encephalocele': Sequela(
        name='mild_motor_impairment_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2078),
        me_id=me_id(11530),
        healthstate=Healthstate(
            name='motor_impairment_mild',
            kind='healthstate',
            gbd_id=hs_id(565),
        ),
    ),
    'mild_motor_impairment_due_to_long_term_due_to_meningitis': Sequela(
        name='mild_motor_impairment_due_to_long_term_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22872),
        me_id=me_id(24061),
        healthstate=Healthstate(
            name='motor_impairment_mild',
            kind='healthstate',
            gbd_id=hs_id(565),
        ),
    ),
    'moderate_motor_impairment_due_to_neonatal_tetanus': Sequela(
        name='moderate_motor_impairment_due_to_neonatal_tetanus',
        kind='sequela',
        gbd_id=s_id(737),
        me_id=me_id(3518),
        healthstate=Healthstate(
            name='motor_impairment_moderate',
            kind='healthstate',
            gbd_id=hs_id(566),
        ),
    ),
    'moderate_motor_impairment_due_to_hemolytic_disease_and_other_neonatal_jaundice': Sequela(
        name='moderate_motor_impairment_due_to_hemolytic_disease_and_other_neonatal_jaundice',
        kind='sequela',
        gbd_id=s_id(738),
        me_id=me_id(3842),
        healthstate=Healthstate(
            name='motor_impairment_moderate',
            kind='healthstate',
            gbd_id=hs_id(566),
        ),
    ),
    'moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks': Sequela(
        name='moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks',
        kind='sequela',
        gbd_id=s_id(739),
        me_id=me_id(3710),
        healthstate=Healthstate(
            name='motor_impairment_moderate',
            kind='healthstate',
            gbd_id=hs_id(566),
        ),
    ),
    'moderate_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='moderate_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(740),
        me_id=me_id(3800),
        healthstate=Healthstate(
            name='motor_impairment_moderate',
            kind='healthstate',
            gbd_id=hs_id(566),
        ),
    ),
    'moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks': Sequela(
        name='moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks',
        kind='sequela',
        gbd_id=s_id(741),
        me_id=me_id(3668),
        healthstate=Healthstate(
            name='motor_impairment_moderate',
            kind='healthstate',
            gbd_id=hs_id(566),
        ),
    ),
    'moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks': Sequela(
        name='moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks',
        kind='sequela',
        gbd_id=s_id(742),
        me_id=me_id(3752),
        healthstate=Healthstate(
            name='motor_impairment_moderate',
            kind='healthstate',
            gbd_id=hs_id(566),
        ),
    ),
    'moderate_motor_impairment_due_to_encephalitis': Sequela(
        name='moderate_motor_impairment_due_to_encephalitis',
        kind='sequela',
        gbd_id=s_id(799),
        me_id=me_id(3494),
        healthstate=Healthstate(
            name='motor_impairment_moderate',
            kind='healthstate',
            gbd_id=hs_id(566),
        ),
    ),
    'moderate_motor_impairment_due_to_malaria': Sequela(
        name='moderate_motor_impairment_due_to_malaria',
        kind='sequela',
        gbd_id=s_id(884),
        me_id=me_id(3560),
        healthstate=Healthstate(
            name='motor_impairment_moderate',
            kind='healthstate',
            gbd_id=hs_id(566),
        ),
    ),
    'moderate_motor_impairment_due_to_motor_neuron_disease': Sequela(
        name='moderate_motor_impairment_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1174),
        me_id=me_id(9702),
        healthstate=Healthstate(
            name='motor_impairment_moderate',
            kind='healthstate',
            gbd_id=hs_id(566),
        ),
    ),
    'moderate_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='moderate_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1253),
        me_id=me_id(9619),
        healthstate=Healthstate(
            name='motor_impairment_moderate',
            kind='healthstate',
            gbd_id=hs_id(566),
        ),
    ),
    'moderate_motor_impairment_due_to_spina_bifida': Sequela(
        name='moderate_motor_impairment_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1946),
        me_id=me_id(11281),
        healthstate=Healthstate(
            name='motor_impairment_moderate',
            kind='healthstate',
            gbd_id=hs_id(566),
        ),
    ),
    'moderate_motor_impairment_due_to_encephalocele': Sequela(
        name='moderate_motor_impairment_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2081),
        me_id=me_id(11531),
        healthstate=Healthstate(
            name='motor_impairment_moderate',
            kind='healthstate',
            gbd_id=hs_id(566),
        ),
    ),
    'moderate_motor_impairment_due_to_meningitis': Sequela(
        name='moderate_motor_impairment_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22860),
        me_id=me_id(24040),
        healthstate=Healthstate(
            name='motor_impairment_moderate',
            kind='healthstate',
            gbd_id=hs_id(566),
        ),
    ),
    'severe_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='severe_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(761),
        me_id=me_id(3821),
        healthstate=Healthstate(
            name='motor_impairment_severe',
            kind='healthstate',
            gbd_id=hs_id(567),
        ),
    ),
    'severe_motor_impairment_severe_due_to_hemolytic_disease_and_other_neonatal_jaundice': Sequela(
        name='severe_motor_impairment_severe_due_to_hemolytic_disease_and_other_neonatal_jaundice',
        kind='sequela',
        gbd_id=s_id(762),
        me_id=me_id(3863),
        healthstate=Healthstate(
            name='motor_impairment_severe',
            kind='healthstate',
            gbd_id=hs_id(567),
        ),
    ),
    'severe_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks': Sequela(
        name='severe_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks',
        kind='sequela',
        gbd_id=s_id(763),
        me_id=me_id(3689),
        healthstate=Healthstate(
            name='motor_impairment_severe',
            kind='healthstate',
            gbd_id=hs_id(567),
        ),
    ),
    'severe_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks': Sequela(
        name='severe_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks',
        kind='sequela',
        gbd_id=s_id(764),
        me_id=me_id(3773),
        healthstate=Healthstate(
            name='motor_impairment_severe',
            kind='healthstate',
            gbd_id=hs_id(567),
        ),
    ),
    'severe_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks': Sequela(
        name='severe_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks',
        kind='sequela',
        gbd_id=s_id(765),
        me_id=me_id(3731),
        healthstate=Healthstate(
            name='motor_impairment_severe',
            kind='healthstate',
            gbd_id=hs_id(567),
        ),
    ),
    'severe_motor_impairment_due_to_neonatal_tetanus': Sequela(
        name='severe_motor_impairment_due_to_neonatal_tetanus',
        kind='sequela',
        gbd_id=s_id(766),
        me_id=me_id(3539),
        healthstate=Healthstate(
            name='motor_impairment_severe',
            kind='healthstate',
            gbd_id=hs_id(567),
        ),
    ),
    'severe_motor_impairment_due_to_encephalitis': Sequela(
        name='severe_motor_impairment_due_to_encephalitis',
        kind='sequela',
        gbd_id=s_id(800),
        me_id=me_id(3497),
        healthstate=Healthstate(
            name='motor_impairment_severe',
            kind='healthstate',
            gbd_id=hs_id(567),
        ),
    ),
    'severe_motor_impairment_due_to_malaria': Sequela(
        name='severe_motor_impairment_due_to_malaria',
        kind='sequela',
        gbd_id=s_id(891),
        me_id=me_id(3581),
        healthstate=Healthstate(
            name='motor_impairment_severe',
            kind='healthstate',
            gbd_id=hs_id(567),
        ),
    ),
    'severe_motor_impairment_due_to_motor_neuron_disease': Sequela(
        name='severe_motor_impairment_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1175),
        me_id=me_id(9706),
        healthstate=Healthstate(
            name='motor_impairment_severe',
            kind='healthstate',
            gbd_id=hs_id(567),
        ),
    ),
    'severe_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='severe_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1260),
        me_id=me_id(9626),
        healthstate=Healthstate(
            name='motor_impairment_severe',
            kind='healthstate',
            gbd_id=hs_id(567),
        ),
    ),
    'severe_motor_impairment_due_to_spina_bifida': Sequela(
        name='severe_motor_impairment_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1949),
        me_id=me_id(11282),
        healthstate=Healthstate(
            name='motor_impairment_severe',
            kind='healthstate',
            gbd_id=hs_id(567),
        ),
    ),
    'severe_motor_impairment_due_to_encephalocele': Sequela(
        name='severe_motor_impairment_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2084),
        me_id=me_id(11532),
        healthstate=Healthstate(
            name='motor_impairment_severe',
            kind='healthstate',
            gbd_id=hs_id(567),
        ),
    ),
    'severe_motor_impairment_due_to_meningitis': Sequela(
        name='severe_motor_impairment_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22881),
        me_id=me_id(24071),
        healthstate=Healthstate(
            name='motor_impairment_severe',
            kind='healthstate',
            gbd_id=hs_id(567),
        ),
    ),
    'mild_motor_plus_cognitive_impairments_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='mild_motor_plus_cognitive_impairments_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(194),
        me_id=me_id(3794),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_mild',
            kind='healthstate',
            gbd_id=hs_id(568),
        ),
    ),
    'mild_motor_plus_cognitive_impairments_due_to_neonatal_tetanus': Sequela(
        name='mild_motor_plus_cognitive_impairments_due_to_neonatal_tetanus',
        kind='sequela',
        gbd_id=s_id(786),
        me_id=me_id(3515),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_mild',
            kind='healthstate',
            gbd_id=hs_id(568),
        ),
    ),
    'mild_motor_plus_cognitive_impairments_due_to_encephalitis': Sequela(
        name='mild_motor_plus_cognitive_impairments_due_to_encephalitis',
        kind='sequela',
        gbd_id=s_id(795),
        me_id=me_id(3485),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_mild',
            kind='healthstate',
            gbd_id=hs_id(568),
        ),
    ),
    'mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_less_than_28wks': Sequela(
        name='mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_less_than_28wks',
        kind='sequela',
        gbd_id=s_id(871),
        me_id=me_id(3653),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_mild',
            kind='healthstate',
            gbd_id=hs_id(568),
        ),
    ),
    'mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_28_32wks': Sequela(
        name='mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_28_32wks',
        kind='sequela',
        gbd_id=s_id(872),
        me_id=me_id(3659),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_mild',
            kind='healthstate',
            gbd_id=hs_id(568),
        ),
    ),
    'mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_32_36wks': Sequela(
        name='mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_32_36wks',
        kind='sequela',
        gbd_id=s_id(873),
        me_id=me_id(3665),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_mild',
            kind='healthstate',
            gbd_id=hs_id(568),
        ),
    ),
    'mild_motor_plus_cognitive_impairments_due_to_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='mild_motor_plus_cognitive_impairments_due_to_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1251),
        me_id=me_id(9617),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_mild',
            kind='healthstate',
            gbd_id=hs_id(568),
        ),
    ),
    'mild_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida': Sequela(
        name='mild_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1961),
        me_id=me_id(11286),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_mild',
            kind='healthstate',
            gbd_id=hs_id(568),
        ),
    ),
    'mild_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele': Sequela(
        name='mild_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2105),
        me_id=me_id(11539),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_mild',
            kind='healthstate',
            gbd_id=hs_id(568),
        ),
    ),
    'mild_motor_plus_cognitive_impairments_due_to_meningitis': Sequela(
        name='mild_motor_plus_cognitive_impairments_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22857),
        me_id=me_id(24036),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_mild',
            kind='healthstate',
            gbd_id=hs_id(568),
        ),
    ),
    'moderate_motor_plus_cognitive_impairments_due_to_encephalitis': Sequela(
        name='moderate_motor_plus_cognitive_impairments_due_to_encephalitis',
        kind='sequela',
        gbd_id=s_id(801),
        me_id=me_id(3500),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_moderate',
            kind='healthstate',
            gbd_id=hs_id(569),
        ),
    ),
    'moderate_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida': Sequela(
        name='moderate_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1973),
        me_id=me_id(11290),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_moderate',
            kind='healthstate',
            gbd_id=hs_id(569),
        ),
    ),
    'moderate_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele': Sequela(
        name='moderate_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2117),
        me_id=me_id(11543),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_moderate',
            kind='healthstate',
            gbd_id=hs_id(569),
        ),
    ),
    'neurological_problems_due_to_adult_tertiary_syphilis': Sequela(
        name='neurological_problems_due_to_adult_tertiary_syphilis',
        kind='sequela',
        gbd_id=s_id(5150),
        me_id=me_id(16414),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_moderate',
            kind='healthstate',
            gbd_id=hs_id(569),
        ),
    ),
    'moderate_motor_plus_cognitive_impairments_due_to_meningitis': Sequela(
        name='moderate_motor_plus_cognitive_impairments_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22876),
        me_id=me_id(24065),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_moderate',
            kind='healthstate',
            gbd_id=hs_id(569),
        ),
    ),
    'severe_motor_plus_cognitive_impairments_due_to_encephalitis': Sequela(
        name='severe_motor_plus_cognitive_impairments_due_to_encephalitis',
        kind='sequela',
        gbd_id=s_id(802),
        me_id=me_id(3503),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_severe',
            kind='healthstate',
            gbd_id=hs_id(570),
        ),
    ),
    'sleeping_sickness_due_to_trypanosoma_brucei_gambiense': Sequela(
        name='sleeping_sickness_due_to_trypanosoma_brucei_gambiense',
        kind='sequela',
        gbd_id=s_id(1457),
        me_id=me_id(10919),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_severe',
            kind='healthstate',
            gbd_id=hs_id(570),
        ),
    ),
    'sleeping_sickness_due_to_trypanosoma_brucei_rhodesiense': Sequela(
        name='sleeping_sickness_due_to_trypanosoma_brucei_rhodesiense',
        kind='sequela',
        gbd_id=s_id(1460),
        me_id=me_id(10921),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_severe',
            kind='healthstate',
            gbd_id=hs_id(570),
        ),
    ),
    'severe_motor_and_cognitive_impairment_due_to_edward_syndrome_or_patau_syndrome': Sequela(
        name='severe_motor_and_cognitive_impairment_due_to_edward_syndrome_or_patau_syndrome',
        kind='sequela',
        gbd_id=s_id(1898),
        me_id=me_id(11310),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_severe',
            kind='healthstate',
            gbd_id=hs_id(570),
        ),
    ),
    'severe_motor_and_cognitive_impairment_due_to_anencephaly': Sequela(
        name='severe_motor_and_cognitive_impairment_due_to_anencephaly',
        kind='sequela',
        gbd_id=s_id(1904),
        me_id=me_id(15791),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_severe',
            kind='healthstate',
            gbd_id=hs_id(570),
        ),
    ),
    'severe_motor_plus_cognitive_impairments_due_to_meningitis': Sequela(
        name='severe_motor_plus_cognitive_impairments_due_to_meningitis',
        kind='sequela',
        gbd_id=s_id(22870),
        me_id=me_id(24058),
        healthstate=Healthstate(
            name='motor_plus_cognitive_impairments_severe',
            kind='healthstate',
            gbd_id=hs_id(570),
        ),
    ),
    'mild_multiple_sclerosis': Sequela(
        name='mild_multiple_sclerosis',
        kind='sequela',
        gbd_id=s_id(461),
        me_id=me_id(1956),
        healthstate=Healthstate(
            name='multiple_sclerosis_mild',
            kind='healthstate',
            gbd_id=hs_id(414),
        ),
    ),
    'moderate_multiple_sclerosis': Sequela(
        name='moderate_multiple_sclerosis',
        kind='sequela',
        gbd_id=s_id(462),
        me_id=me_id(1957),
        healthstate=Healthstate(
            name='multiple_sclerosis_moderate',
            kind='healthstate',
            gbd_id=hs_id(415),
        ),
    ),
    'severe_multiple_sclerosis': Sequela(
        name='severe_multiple_sclerosis',
        kind='sequela',
        gbd_id=s_id(463),
        me_id=me_id(1958),
        healthstate=Healthstate(
            name='multiple_sclerosis_severe',
            kind='healthstate',
            gbd_id=hs_id(416),
        ),
    ),
    'moderate_rheumatoid_arthritis': Sequela(
        name='moderate_rheumatoid_arthritis',
        kind='sequela',
        gbd_id=s_id(544),
        me_id=me_id(2139),
        healthstate=Healthstate(
            name='musculoskeletal_problems_generalized_moderate',
            kind='healthstate',
            gbd_id=hs_id(483),
        ),
    ),
    'other_musculoskeletal_disorders_severity_level_5': Sequela(
        name='other_musculoskeletal_disorders_severity_level_5',
        kind='sequela',
        gbd_id=s_id(563),
        me_id=me_id(2164),
        healthstate=Healthstate(
            name='musculoskeletal_problems_generalized_moderate',
            kind='healthstate',
            gbd_id=hs_id(483),
        ),
    ),
    'severe_rheumatoid_arthritis': Sequela(
        name='severe_rheumatoid_arthritis',
        kind='sequela',
        gbd_id=s_id(545),
        me_id=me_id(2140),
        healthstate=Healthstate(
            name='musculoskeletal_problems_generalized_severe',
            kind='healthstate',
            gbd_id=hs_id(484),
        ),
    ),
    'polyarticular_gout': Sequela(
        name='polyarticular_gout',
        kind='sequela',
        gbd_id=s_id(560),
        me_id=me_id(2160),
        healthstate=Healthstate(
            name='musculoskeletal_problems_generalized_severe',
            kind='healthstate',
            gbd_id=hs_id(484),
        ),
    ),
    'other_musculoskeletal_disorders_severity_level_6': Sequela(
        name='other_musculoskeletal_disorders_severity_level_6',
        kind='sequela',
        gbd_id=s_id(564),
        me_id=me_id(2165),
        healthstate=Healthstate(
            name='musculoskeletal_problems_generalized_severe',
            kind='healthstate',
            gbd_id=hs_id(484),
        ),
    ),
    'mild_osteoarthritis_of_the_hip': Sequela(
        name='mild_osteoarthritis_of_the_hip',
        kind='sequela',
        gbd_id=s_id(546),
        me_id=me_id(2142),
        healthstate=Healthstate(
            name='musculoskeletal_problems_lower_limbs_mild',
            kind='healthstate',
            gbd_id=hs_id(478),
        ),
    ),
    'mild_osteoarthritis_of_the_knee': Sequela(
        name='mild_osteoarthritis_of_the_knee',
        kind='sequela',
        gbd_id=s_id(549),
        me_id=me_id(2146),
        healthstate=Healthstate(
            name='musculoskeletal_problems_lower_limbs_mild',
            kind='healthstate',
            gbd_id=hs_id(478),
        ),
    ),
    'other_musculoskeletal_disorders_severity_level_1': Sequela(
        name='other_musculoskeletal_disorders_severity_level_1',
        kind='sequela',
        gbd_id=s_id(565),
        me_id=me_id(2166),
        healthstate=Healthstate(
            name='musculoskeletal_problems_lower_limbs_mild',
            kind='healthstate',
            gbd_id=hs_id(478),
        ),
    ),
    'mild_osteoarthritis_of_the_hand_and_foot': Sequela(
        name='mild_osteoarthritis_of_the_hand_and_foot',
        kind='sequela',
        gbd_id=s_id(22886),
        me_id=me_id(24814),
        healthstate=Healthstate(
            name='musculoskeletal_problems_lower_limbs_mild',
            kind='healthstate',
            gbd_id=hs_id(478),
        ),
    ),
    'mild_osteoarthritis_other': Sequela(
        name='mild_osteoarthritis_other',
        kind='sequela',
        gbd_id=s_id(22889),
        me_id=me_id(24818),
        healthstate=Healthstate(
            name='musculoskeletal_problems_lower_limbs_mild',
            kind='healthstate',
            gbd_id=hs_id(478),
        ),
    ),
    'moderate_osteoarthritis_of_the_hip': Sequela(
        name='moderate_osteoarthritis_of_the_hip',
        kind='sequela',
        gbd_id=s_id(547),
        me_id=me_id(2143),
        healthstate=Healthstate(
            name='musculoskeletal_problems_lower_limbs_moderate',
            kind='healthstate',
            gbd_id=hs_id(479),
        ),
    ),
    'moderate_osteoarthritis_of_the_knee': Sequela(
        name='moderate_osteoarthritis_of_the_knee',
        kind='sequela',
        gbd_id=s_id(550),
        me_id=me_id(2147),
        healthstate=Healthstate(
            name='musculoskeletal_problems_lower_limbs_moderate',
            kind='healthstate',
            gbd_id=hs_id(479),
        ),
    ),
    'moderate_pain_and_limited_mobility_due_to_guinea_worm': Sequela(
        name='moderate_pain_and_limited_mobility_due_to_guinea_worm',
        kind='sequela',
        gbd_id=s_id(5537),
        me_id=me_id(19838),
        healthstate=Healthstate(
            name='musculoskeletal_problems_lower_limbs_moderate',
            kind='healthstate',
            gbd_id=hs_id(479),
        ),
    ),
    'moderate_osteoarthritis_of_the_hand_and_foot': Sequela(
        name='moderate_osteoarthritis_of_the_hand_and_foot',
        kind='sequela',
        gbd_id=s_id(22887),
        me_id=me_id(24815),
        healthstate=Healthstate(
            name='musculoskeletal_problems_lower_limbs_moderate',
            kind='healthstate',
            gbd_id=hs_id(479),
        ),
    ),
    'moderate_osteoarthritis_other': Sequela(
        name='moderate_osteoarthritis_other',
        kind='sequela',
        gbd_id=s_id(22890),
        me_id=me_id(24819),
        healthstate=Healthstate(
            name='musculoskeletal_problems_lower_limbs_moderate',
            kind='healthstate',
            gbd_id=hs_id(479),
        ),
    ),
    'severe_osteoarthritis_of_the_hip': Sequela(
        name='severe_osteoarthritis_of_the_hip',
        kind='sequela',
        gbd_id=s_id(548),
        me_id=me_id(2144),
        healthstate=Healthstate(
            name='musculoskeletal_problems_lower_limbs_severe',
            kind='healthstate',
            gbd_id=hs_id(480),
        ),
    ),
    'severe_osteoarthritis_of_the_knee': Sequela(
        name='severe_osteoarthritis_of_the_knee',
        kind='sequela',
        gbd_id=s_id(551),
        me_id=me_id(2148),
        healthstate=Healthstate(
            name='musculoskeletal_problems_lower_limbs_severe',
            kind='healthstate',
            gbd_id=hs_id(480),
        ),
    ),
    'other_musculoskeletal_disorders_severity_level_4': Sequela(
        name='other_musculoskeletal_disorders_severity_level_4',
        kind='sequela',
        gbd_id=s_id(566),
        me_id=me_id(2167),
        healthstate=Healthstate(
            name='musculoskeletal_problems_lower_limbs_severe',
            kind='healthstate',
            gbd_id=hs_id(480),
        ),
    ),
    'severe_osteoarthritis_of_the_hand_and_foot': Sequela(
        name='severe_osteoarthritis_of_the_hand_and_foot',
        kind='sequela',
        gbd_id=s_id(22888),
        me_id=me_id(24816),
        healthstate=Healthstate(
            name='musculoskeletal_problems_lower_limbs_severe',
            kind='healthstate',
            gbd_id=hs_id(480),
        ),
    ),
    'severe_osteoarthritis_other': Sequela(
        name='severe_osteoarthritis_other',
        kind='sequela',
        gbd_id=s_id(22891),
        me_id=me_id(24820),
        healthstate=Healthstate(
            name='musculoskeletal_problems_lower_limbs_severe',
            kind='healthstate',
            gbd_id=hs_id(480),
        ),
    ),
    'other_musculoskeletal_disorders_severity_level_2': Sequela(
        name='other_musculoskeletal_disorders_severity_level_2',
        kind='sequela',
        gbd_id=s_id(561),
        me_id=me_id(2162),
        healthstate=Healthstate(
            name='musculoskeletal_problems_upper_limbs_mild',
            kind='healthstate',
            gbd_id=hs_id(481),
        ),
    ),
    'mild_rheumatoid_arthritis': Sequela(
        name='mild_rheumatoid_arthritis',
        kind='sequela',
        gbd_id=s_id(543),
        me_id=me_id(2138),
        healthstate=Healthstate(
            name='musculoskeletal_problems_upper_limbs_moderate',
            kind='healthstate',
            gbd_id=hs_id(482),
        ),
    ),
    'other_musculoskeletal_disorders_severity_level_3': Sequela(
        name='other_musculoskeletal_disorders_severity_level_3',
        kind='sequela',
        gbd_id=s_id(562),
        me_id=me_id(2163),
        healthstate=Healthstate(
            name='musculoskeletal_problems_upper_limbs_moderate',
            kind='healthstate',
            gbd_id=hs_id(482),
        ),
    ),
    'mild_neck_pain': Sequela(
        name='mild_neck_pain',
        kind='sequela',
        gbd_id=s_id(556),
        me_id=me_id(2155),
        healthstate=Healthstate(
            name='neck_pain_mild',
            kind='healthstate',
            gbd_id=hs_id(474),
        ),
    ),
    'moderate_neck_pain': Sequela(
        name='moderate_neck_pain',
        kind='sequela',
        gbd_id=s_id(558),
        me_id=me_id(2157),
        healthstate=Healthstate(
            name='neck_pain_moderate',
            kind='healthstate',
            gbd_id=hs_id(476),
        ),
    ),
    'most_severe_neck_pain': Sequela(
        name='most_severe_neck_pain',
        kind='sequela',
        gbd_id=s_id(559),
        me_id=me_id(2158),
        healthstate=Healthstate(
            name='neck_pain_most_severe',
            kind='healthstate',
            gbd_id=hs_id(477),
        ),
    ),
    'severe_neck_pain': Sequela(
        name='severe_neck_pain',
        kind='sequela',
        gbd_id=s_id(557),
        me_id=me_id(2156),
        healthstate=Healthstate(
            name='neck_pain_severe',
            kind='healthstate',
            gbd_id=hs_id(475),
        ),
    ),
    'severe_gerd_symptomatic_days': Sequela(
        name='severe_gerd_symptomatic_days',
        kind='sequela',
        gbd_id=s_id(7190),
        me_id=me_id(20286),
        healthstate=Healthstate(
            name='often_has_a_burning_sensation_in_the_back_of_the_chest_after_eating',
            kind='healthstate',
            gbd_id=hs_id(2633),
        ),
    ),
    'mild_parkinsons_disease': Sequela(
        name='mild_parkinsons_disease',
        kind='sequela',
        gbd_id=s_id(455),
        me_id=me_id(1948),
        healthstate=Healthstate(
            name='parkinson_disease_mild',
            kind='healthstate',
            gbd_id=hs_id(421),
        ),
    ),
    'moderate_parkinsons_disease': Sequela(
        name='moderate_parkinsons_disease',
        kind='sequela',
        gbd_id=s_id(456),
        me_id=me_id(1949),
        healthstate=Healthstate(
            name='parkinson_disease_moderate',
            kind='healthstate',
            gbd_id=hs_id(422),
        ),
    ),
    'severe_parkinsons_disease': Sequela(
        name='severe_parkinsons_disease',
        kind='sequela',
        gbd_id=s_id(457),
        me_id=me_id(1950),
        healthstate=Healthstate(
            name='parkinson_disease_severe',
            kind='healthstate',
            gbd_id=hs_id(423),
        ),
    ),
    'chronic_periodontal_diseases': Sequela(
        name='chronic_periodontal_diseases',
        kind='sequela',
        gbd_id=s_id(936),
        me_id=me_id(3083),
        healthstate=Healthstate(
            name='periodontitis',
            kind='healthstate',
            gbd_id=hs_id(550),
        ),
    ),
    'other_intestinal_infectious_diseases': Sequela(
        name='other_intestinal_infectious_diseases',
        kind='sequela',
        gbd_id=s_id(14),
        me_id=me_id(1257),
        healthstate=Healthstate(
            name='post_como_calculation_for_residuals_yll_yld_ratio_other_methods',
            kind='healthstate',
            gbd_id=hs_id(639),
        ),
    ),
    'acute_infection_due_to_other_neglected_tropical_diseases': Sequela(
        name='acute_infection_due_to_other_neglected_tropical_diseases',
        kind='sequela',
        gbd_id=s_id(176),
        me_id=me_id(1531),
        healthstate=Healthstate(
            name='post_como_calculation_for_residuals_yll_yld_ratio_other_methods',
            kind='healthstate',
            gbd_id=hs_id(639),
        ),
    ),
    'other_maternal_disorders': Sequela(
        name='other_maternal_disorders',
        kind='sequela',
        gbd_id=s_id(192),
        me_id=me_id(1556),
        healthstate=Healthstate(
            name='post_como_calculation_for_residuals_yll_yld_ratio_other_methods',
            kind='healthstate',
            gbd_id=hs_id(639),
        ),
    ),
    'other_neonatal_disorders': Sequela(
        name='other_neonatal_disorders',
        kind='sequela',
        gbd_id=s_id(197),
        me_id=me_id(1605),
        healthstate=Healthstate(
            name='post_como_calculation_for_residuals_yll_yld_ratio_other_methods',
            kind='healthstate',
            gbd_id=hs_id(639),
        ),
    ),
    'other_nutritional_deficiencies': Sequela(
        name='other_nutritional_deficiencies',
        kind='sequela',
        gbd_id=s_id(212),
        me_id=me_id(1627),
        healthstate=Healthstate(
            name='post_como_calculation_for_residuals_yll_yld_ratio_other_methods',
            kind='healthstate',
            gbd_id=hs_id(639),
        ),
    ),
    'other_chronic_respiratory_diseases': Sequela(
        name='other_chronic_respiratory_diseases',
        kind='sequela',
        gbd_id=s_id(436),
        me_id=me_id(1918),
        healthstate=Healthstate(
            name='post_como_calculation_for_residuals_yll_yld_ratio_other_methods',
            kind='healthstate',
            gbd_id=hs_id(639),
        ),
    ),
    'other_digestive_diseases': Sequela(
        name='other_digestive_diseases',
        kind='sequela',
        gbd_id=s_id(451),
        me_id=me_id(1942),
        healthstate=Healthstate(
            name='post_como_calculation_for_residuals_yll_yld_ratio_other_methods',
            kind='healthstate',
            gbd_id=hs_id(639),
        ),
    ),
    'other_neurological_disorders': Sequela(
        name='other_neurological_disorders',
        kind='sequela',
        gbd_id=s_id(464),
        me_id=me_id(1962),
        healthstate=Healthstate(
            name='post_como_calculation_for_residuals_yll_yld_ratio_other_methods',
            kind='healthstate',
            gbd_id=hs_id(639),
        ),
    ),
    'other_urinary_diseases': Sequela(
        name='other_urinary_diseases',
        kind='sequela',
        gbd_id=s_id(516),
        me_id=me_id(2063),
        healthstate=Healthstate(
            name='post_como_calculation_for_residuals_yll_yld_ratio_other_methods',
            kind='healthstate',
            gbd_id=hs_id(639),
        ),
    ),
    'other_hemoglobinopathies_and_hemolytic_anemias_residual': Sequela(
        name='other_hemoglobinopathies_and_hemolytic_anemias_residual',
        kind='sequela',
        gbd_id=s_id(789),
        me_id=me_id(2800),
        healthstate=Healthstate(
            name='post_como_calculation_for_residuals_yll_yld_ratio_other_methods',
            kind='healthstate',
            gbd_id=hs_id(639),
        ),
    ),
    'other_sexually_transmitted_diseases_residual': Sequela(
        name='other_sexually_transmitted_diseases_residual',
        kind='sequela',
        gbd_id=s_id(808),
        me_id=me_id(2831),
        healthstate=Healthstate(
            name='post_como_calculation_for_residuals_yll_yld_ratio_other_methods',
            kind='healthstate',
            gbd_id=hs_id(639),
        ),
    ),
    'other_infectious_diseases': Sequela(
        name='other_infectious_diseases',
        kind='sequela',
        gbd_id=s_id(5159),
        me_id=me_id(16430),
        healthstate=Healthstate(
            name='post_como_calculation_for_residuals_yll_yld_ratio_other_methods',
            kind='healthstate',
            gbd_id=hs_id(639),
        ),
    ),
    'other_congenital_birth_defects': Sequela(
        name='other_congenital_birth_defects',
        kind='sequela',
        gbd_id=s_id(5162),
        me_id=me_id(16427),
        healthstate=Healthstate(
            name='post_como_calculation_for_residuals_yll_yld_ratio_other_methods',
            kind='healthstate',
            gbd_id=hs_id(639),
        ),
    ),
    'near_vision_loss': Sequela(
        name='near_vision_loss',
        kind='sequela',
        gbd_id=s_id(5483),
        me_id=me_id(20969),
        healthstate=Healthstate(
            name='presbyopia',
            kind='healthstate',
            gbd_id=hs_id(469),
        ),
    ),
    'infertility_and_impotence_due_to_congenital_genital_anomalies': Sequela(
        name='infertility_and_impotence_due_to_congenital_genital_anomalies',
        kind='sequela',
        gbd_id=s_id(1739),
        me_id=me_id(11041),
        healthstate=Healthstate(
            name='primary_infertility_and_impotence',
            kind='healthstate',
            gbd_id=hs_id(2279),
        ),
    ),
    'profound_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='profound_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(1940),
        me_id=me_id(11279),
        healthstate=Healthstate(
            name='profound_intellectual_disability_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2381),
        ),
    ),
    'profound_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='profound_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1221),
        me_id=me_id(9828),
        healthstate=Healthstate(
            name='profound_intellectual_disability_with_congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(901),
        ),
    ),
    'profound_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='profound_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1232),
        me_id=me_id(9852),
        healthstate=Healthstate(
            name='profound_intellectual_disability_with_congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(901),
        ),
    ),
    'rectovaginal_fistula': Sequela(
        name='rectovaginal_fistula',
        kind='sequela',
        gbd_id=s_id(189),
        me_id=me_id(1553),
        healthstate=Healthstate(
            name='rectovaginal_fistula',
            kind='healthstate',
            gbd_id=hs_id(571),
        ),
    ),
    'schizophrenia_acute_state': Sequela(
        name='schizophrenia_acute_state',
        kind='sequela',
        gbd_id=s_id(466),
        me_id=me_id(1965),
        healthstate=Healthstate(
            name='schizophrenia_acute_state',
            kind='healthstate',
            gbd_id=hs_id(442),
        ),
    ),
    'schizophrenia_residual_state': Sequela(
        name='schizophrenia_residual_state',
        kind='sequela',
        gbd_id=s_id(467),
        me_id=me_id(1966),
        healthstate=Healthstate(
            name='schizophrenia_residual_state',
            kind='healthstate',
            gbd_id=hs_id(443),
        ),
    ),
    'severe_abdominal_pain_and_primary_infertility_due_to_endometriosis': Sequela(
        name='severe_abdominal_pain_and_primary_infertility_due_to_endometriosis',
        kind='sequela',
        gbd_id=s_id(880),
        me_id=me_id(2961),
        healthstate=Healthstate(
            name='severe_abdominal_pain_and_primary_infertility',
            kind='healthstate',
            gbd_id=hs_id(803),
        ),
    ),
    'severe_abdominal_pain_and_secondary_infertility_due_to_endometriosis': Sequela(
        name='severe_abdominal_pain_and_secondary_infertility_due_to_endometriosis',
        kind='sequela',
        gbd_id=s_id(883),
        me_id=me_id(2964),
        healthstate=Healthstate(
            name='severe_abdominal_pain_and_secondary_infertility',
            kind='healthstate',
            gbd_id=hs_id(806),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_hypertension': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(1379),
        me_id=me_id(10872),
        healthstate=Healthstate(
            name='severe_anemia_and_terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(2462),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_glomerulonephritis': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(1391),
        me_id=me_id(10876),
        healthstate=Healthstate(
            name='severe_anemia_and_terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(2462),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_other_causes': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(1403),
        me_id=me_id(10880),
        healthstate=Healthstate(
            name='severe_anemia_and_terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(2462),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_1_diabetes_mellitus': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5261),
        me_id=me_id(19425),
        healthstate=Healthstate(
            name='severe_anemia_and_terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(2462),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_2_diabetes_mellitus': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5264),
        me_id=me_id(19426),
        healthstate=Healthstate(
            name='severe_anemia_and_terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(2462),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_hypertension': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(1427),
        me_id=me_id(10900),
        healthstate=Healthstate(
            name='severe_anemia_with_stage_iv_ckd',
            kind='healthstate',
            gbd_id=hs_id(837),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_glomerulonephritis': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(1439),
        me_id=me_id(10904),
        healthstate=Healthstate(
            name='severe_anemia_with_stage_iv_ckd',
            kind='healthstate',
            gbd_id=hs_id(837),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_other_causes': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(1451),
        me_id=me_id(10908),
        healthstate=Healthstate(
            name='severe_anemia_with_stage_iv_ckd',
            kind='healthstate',
            gbd_id=hs_id(837),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_1_diabetes_mellitus': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5237),
        me_id=me_id(19417),
        healthstate=Healthstate(
            name='severe_anemia_with_stage_iv_ckd',
            kind='healthstate',
            gbd_id=hs_id(837),
        ),
    ),
    'stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_2_diabetes_mellitus': Sequela(
        name='stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5240),
        me_id=me_id(19418),
        healthstate=Healthstate(
            name='severe_anemia_with_stage_iv_ckd',
            kind='healthstate',
            gbd_id=hs_id(837),
        ),
    ),
    'mild_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease': Sequela(
        name='mild_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease',
        kind='sequela',
        gbd_id=s_id(980),
        me_id=me_id(3149),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(850),
        ),
    ),
    'mild_heart_failure_due_to_severe_silicosis': Sequela(
        name='mild_heart_failure_due_to_severe_silicosis',
        kind='sequela',
        gbd_id=s_id(984),
        me_id=me_id(3153),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(850),
        ),
    ),
    'mild_heart_failure_due_to_severe_asbestosis': Sequela(
        name='mild_heart_failure_due_to_severe_asbestosis',
        kind='sequela',
        gbd_id=s_id(988),
        me_id=me_id(3157),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(850),
        ),
    ),
    'mild_heart_failure_due_to_severe_coal_workers_pneumoconiosis': Sequela(
        name='mild_heart_failure_due_to_severe_coal_workers_pneumoconiosis',
        kind='sequela',
        gbd_id=s_id(992),
        me_id=me_id(3161),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(850),
        ),
    ),
    'mild_heart_failure_due_to_severe_other_pneumoconiosis': Sequela(
        name='mild_heart_failure_due_to_severe_other_pneumoconiosis',
        kind='sequela',
        gbd_id=s_id(996),
        me_id=me_id(3165),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(850),
        ),
    ),
    'mild_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis': Sequela(
        name='mild_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis',
        kind='sequela',
        gbd_id=s_id(1000),
        me_id=me_id(3169),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_mild_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(850),
        ),
    ),
    'moderate_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease': Sequela(
        name='moderate_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease',
        kind='sequela',
        gbd_id=s_id(981),
        me_id=me_id(3150),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(851),
        ),
    ),
    'moderate_heart_failure_due_to_severe_silicosis': Sequela(
        name='moderate_heart_failure_due_to_severe_silicosis',
        kind='sequela',
        gbd_id=s_id(985),
        me_id=me_id(3154),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(851),
        ),
    ),
    'moderate_heart_failure_due_to_severe_asbestosis': Sequela(
        name='moderate_heart_failure_due_to_severe_asbestosis',
        kind='sequela',
        gbd_id=s_id(989),
        me_id=me_id(3158),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(851),
        ),
    ),
    'moderate_heart_failure_due_to_severe_coal_workers_pneumoconiosis': Sequela(
        name='moderate_heart_failure_due_to_severe_coal_workers_pneumoconiosis',
        kind='sequela',
        gbd_id=s_id(993),
        me_id=me_id(3162),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(851),
        ),
    ),
    'moderate_heart_failure_due_to_severe_other_pneumoconiosis': Sequela(
        name='moderate_heart_failure_due_to_severe_other_pneumoconiosis',
        kind='sequela',
        gbd_id=s_id(997),
        me_id=me_id(3166),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(851),
        ),
    ),
    'moderate_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis': Sequela(
        name='moderate_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis',
        kind='sequela',
        gbd_id=s_id(1001),
        me_id=me_id(3170),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_moderate_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(851),
        ),
    ),
    'severe_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease': Sequela(
        name='severe_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease',
        kind='sequela',
        gbd_id=s_id(982),
        me_id=me_id(3151),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(852),
        ),
    ),
    'severe_heart_failure_due_to_severe_silicosis': Sequela(
        name='severe_heart_failure_due_to_severe_silicosis',
        kind='sequela',
        gbd_id=s_id(986),
        me_id=me_id(3155),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(852),
        ),
    ),
    'severe_heart_failure_due_to_severe_asbestosis': Sequela(
        name='severe_heart_failure_due_to_severe_asbestosis',
        kind='sequela',
        gbd_id=s_id(990),
        me_id=me_id(3159),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(852),
        ),
    ),
    'severe_heart_failure_due_to_severe_coal_workers_pneumoconiosis': Sequela(
        name='severe_heart_failure_due_to_severe_coal_workers_pneumoconiosis',
        kind='sequela',
        gbd_id=s_id(994),
        me_id=me_id(3163),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(852),
        ),
    ),
    'severe_heart_failure_due_to_severe_other_pneumoconiosis': Sequela(
        name='severe_heart_failure_due_to_severe_other_pneumoconiosis',
        kind='sequela',
        gbd_id=s_id(998),
        me_id=me_id(3167),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(852),
        ),
    ),
    'severe_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis': Sequela(
        name='severe_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis',
        kind='sequela',
        gbd_id=s_id(1002),
        me_id=me_id(3171),
        healthstate=Healthstate(
            name='severe_copd_and_other_chronic_respiratory_with_severe_heart_failure',
            kind='healthstate',
            gbd_id=hs_id(852),
        ),
    ),
    'borderline_intellectual_disability_and_severe_dementia_due_to_down_syndrome': Sequela(
        name='borderline_intellectual_disability_and_severe_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1311),
        me_id=me_id(10262),
        healthstate=Healthstate(
            name='severe_dementia_borderline_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(939),
        ),
    ),
    'borderline_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='borderline_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1326),
        me_id=me_id(10292),
        healthstate=Healthstate(
            name='severe_dementia_borderline_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(939),
        ),
    ),
    'mild_intellectual_disability_and_severe_dementia_due_to_down_syndrome': Sequela(
        name='mild_intellectual_disability_and_severe_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1310),
        me_id=me_id(10261),
        healthstate=Healthstate(
            name='severe_dementia_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(940),
        ),
    ),
    'mild_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='mild_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1325),
        me_id=me_id(10291),
        healthstate=Healthstate(
            name='severe_dementia_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(940),
        ),
    ),
    'moderate_intellectual_disability_and_severe_dementia_due_to_down_syndrome': Sequela(
        name='moderate_intellectual_disability_and_severe_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1309),
        me_id=me_id(10260),
        healthstate=Healthstate(
            name='severe_dementia_moderate_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(941),
        ),
    ),
    'moderate_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='moderate_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1324),
        me_id=me_id(10290),
        healthstate=Healthstate(
            name='severe_dementia_moderate_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(941),
        ),
    ),
    'profound_intellectual_disability_and_severe_dementia_due_to_down_syndrome': Sequela(
        name='profound_intellectual_disability_and_severe_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1307),
        me_id=me_id(10258),
        healthstate=Healthstate(
            name='severe_dementia_profound_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(943),
        ),
    ),
    'profound_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='profound_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1322),
        me_id=me_id(10288),
        healthstate=Healthstate(
            name='severe_dementia_profound_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(943),
        ),
    ),
    'severe_intellectual_disability_and_severe_dementia_due_to_down_syndrome': Sequela(
        name='severe_intellectual_disability_and_severe_dementia_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1308),
        me_id=me_id(10259),
        healthstate=Healthstate(
            name='severe_dementia_severe_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(942),
        ),
    ),
    'severe_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities': Sequela(
        name='severe_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1323),
        me_id=me_id(10289),
        healthstate=Healthstate(
            name='severe_dementia_severe_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(942),
        ),
    ),
    'severe_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='severe_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(1937),
        me_id=me_id(11278),
        healthstate=Healthstate(
            name='severe_intellectual_disability_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2378),
        ),
    ),
    'severe_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome': Sequela(
        name='severe_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome',
        kind='sequela',
        gbd_id=s_id(1220),
        me_id=me_id(9827),
        healthstate=Healthstate(
            name='severe_intellectual_disability_with_congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(900),
        ),
    ),
    'severe_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities': Sequela(
        name='severe_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities',
        kind='sequela',
        gbd_id=s_id(1231),
        me_id=me_id(9851),
        healthstate=Healthstate(
            name='severe_intellectual_disability_with_congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(900),
        ),
    ),
    'severe_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida': Sequela(
        name='severe_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1958),
        me_id=me_id(11285),
        healthstate=Healthstate(
            name='severe_motor_impairment_and_borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2390),
        ),
    ),
    'severe_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele': Sequela(
        name='severe_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2102),
        me_id=me_id(11538),
        healthstate=Healthstate(
            name='severe_motor_impairment_and_borderline_intellectual_functioning',
            kind='healthstate',
            gbd_id=hs_id(2390),
        ),
    ),
    'severe_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease': Sequela(
        name='severe_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1168),
        me_id=me_id(9703),
        healthstate=Healthstate(
            name='severe_motor_impairment_and_mild_respiratory_problems',
            kind='healthstate',
            gbd_id=hs_id(883),
        ),
    ),
    'severe_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease': Sequela(
        name='severe_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1169),
        me_id=me_id(9704),
        healthstate=Healthstate(
            name='severe_motor_impairment_and_moderate_respiratory_problems',
            kind='healthstate',
            gbd_id=hs_id(884),
        ),
    ),
    'severe_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease': Sequela(
        name='severe_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1170),
        me_id=me_id(9705),
        healthstate=Healthstate(
            name='severe_motor_impairment_and_severe_respiratory_problems',
            kind='healthstate',
            gbd_id=hs_id(885),
        ),
    ),
    'severe_motor_impairment_and_speech_problems_due_to_motor_neuron_disease': Sequela(
        name='severe_motor_impairment_and_speech_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1172),
        me_id=me_id(9690),
        healthstate=Healthstate(
            name='severe_motor_impairment_and_speech_problems',
            kind='healthstate',
            gbd_id=hs_id(888),
        ),
    ),
    'severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks': Sequela(
        name='severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks',
        kind='sequela',
        gbd_id=s_id(767),
        me_id=me_id(3734),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(781),
        ),
    ),
    'severe_motor_impairment_with_blindness_due_to_neonatal_tetanus': Sequela(
        name='severe_motor_impairment_with_blindness_due_to_neonatal_tetanus',
        kind='sequela',
        gbd_id=s_id(768),
        me_id=me_id(3542),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(781),
        ),
    ),
    'severe_motor_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice': Sequela(
        name='severe_motor_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice',
        kind='sequela',
        gbd_id=s_id(769),
        me_id=me_id(3866),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(781),
        ),
    ),
    'severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks': Sequela(
        name='severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks',
        kind='sequela',
        gbd_id=s_id(770),
        me_id=me_id(3692),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(781),
        ),
    ),
    'severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks': Sequela(
        name='severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks',
        kind='sequela',
        gbd_id=s_id(771),
        me_id=me_id(3776),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(781),
        ),
    ),
    'severe_motor_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='severe_motor_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(772),
        me_id=me_id(3824),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(781),
        ),
    ),
    'severe_motor_impairment_with_blindness_due_to_malaria': Sequela(
        name='severe_motor_impairment_with_blindness_due_to_malaria',
        kind='sequela',
        gbd_id=s_id(892),
        me_id=me_id(3584),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(781),
        ),
    ),
    'severe_motor_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='severe_motor_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1261),
        me_id=me_id(9627),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(781),
        ),
    ),
    'severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus': Sequela(
        name='severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus',
        kind='sequela',
        gbd_id=s_id(773),
        me_id=me_id(3548),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(783),
        ),
    ),
    'severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks': Sequela(
        name='severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks',
        kind='sequela',
        gbd_id=s_id(774),
        me_id=me_id(3698),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(783),
        ),
    ),
    'severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks': Sequela(
        name='severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks',
        kind='sequela',
        gbd_id=s_id(775),
        me_id=me_id(3740),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(783),
        ),
    ),
    'severe_motor_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice': Sequela(
        name='severe_motor_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice',
        kind='sequela',
        gbd_id=s_id(776),
        me_id=me_id(3872),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(783),
        ),
    ),
    'severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks': Sequela(
        name='severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks',
        kind='sequela',
        gbd_id=s_id(777),
        me_id=me_id(3782),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(783),
        ),
    ),
    'severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(778),
        me_id=me_id(3830),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(783),
        ),
    ),
    'severe_motor_impairment_with_blindness_and_epilepsy_due_to_malaria': Sequela(
        name='severe_motor_impairment_with_blindness_and_epilepsy_due_to_malaria',
        kind='sequela',
        gbd_id=s_id(894),
        me_id=me_id(3590),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(783),
        ),
    ),
    'severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1263),
        me_id=me_id(9629),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(783),
        ),
    ),
    'severe_motor_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='severe_motor_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(779),
        me_id=me_id(3827),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(782),
        ),
    ),
    'severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks': Sequela(
        name='severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks',
        kind='sequela',
        gbd_id=s_id(780),
        me_id=me_id(3779),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(782),
        ),
    ),
    'severe_motor_impairment_with_epilepsy_due_to_neonatal_tetanus': Sequela(
        name='severe_motor_impairment_with_epilepsy_due_to_neonatal_tetanus',
        kind='sequela',
        gbd_id=s_id(781),
        me_id=me_id(3545),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(782),
        ),
    ),
    'severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks': Sequela(
        name='severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks',
        kind='sequela',
        gbd_id=s_id(782),
        me_id=me_id(3695),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(782),
        ),
    ),
    'severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks': Sequela(
        name='severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks',
        kind='sequela',
        gbd_id=s_id(783),
        me_id=me_id(3737),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(782),
        ),
    ),
    'severe_motor_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice': Sequela(
        name='severe_motor_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice',
        kind='sequela',
        gbd_id=s_id(784),
        me_id=me_id(3869),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(782),
        ),
    ),
    'severe_motor_impairment_with_epilepsy_due_to_malaria': Sequela(
        name='severe_motor_impairment_with_epilepsy_due_to_malaria',
        kind='sequela',
        gbd_id=s_id(893),
        me_id=me_id(3587),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(782),
        ),
    ),
    'severe_motor_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='severe_motor_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1262),
        me_id=me_id(9628),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(782),
        ),
    ),
    'severe_motor_impairment_and_incontinence_due_to_spina_bifida': Sequela(
        name='severe_motor_impairment_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2030),
        me_id=me_id(11309),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_incontinence',
            kind='healthstate',
            gbd_id=hs_id(766),
        ),
    ),
    'severe_motor_impairment_and_incontinence_due_to_encephalocele': Sequela(
        name='severe_motor_impairment_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2093),
        me_id=me_id(11535),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_incontinence',
            kind='healthstate',
            gbd_id=hs_id(766),
        ),
    ),
    'mild_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele': Sequela(
        name='mild_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2132),
        me_id=me_id(11548),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_incontinence',
            kind='healthstate',
            gbd_id=hs_id(766),
        ),
    ),
    'moderate_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele': Sequela(
        name='moderate_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2135),
        me_id=me_id(11549),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_incontinence',
            kind='healthstate',
            gbd_id=hs_id(766),
        ),
    ),
    'severe_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele': Sequela(
        name='severe_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2138),
        me_id=me_id(11550),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_incontinence',
            kind='healthstate',
            gbd_id=hs_id(766),
        ),
    ),
    'mild_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='mild_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2177),
        me_id=me_id(11563),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_incontinence',
            kind='healthstate',
            gbd_id=hs_id(766),
        ),
    ),
    'severe_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida': Sequela(
        name='severe_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1967),
        me_id=me_id(11288),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(907),
        ),
    ),
    'severe_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele': Sequela(
        name='severe_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2111),
        me_id=me_id(11541),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_mild_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(907),
        ),
    ),
    'severe_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida': Sequela(
        name='severe_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2003),
        me_id=me_id(11300),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_mild_intellectual_disability_and_incontinence',
            kind='healthstate',
            gbd_id=hs_id(903),
        ),
    ),
    'severe_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='severe_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2156),
        me_id=me_id(11556),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_mild_intellectual_disability_and_incontinence',
            kind='healthstate',
            gbd_id=hs_id(903),
        ),
    ),
    'severe_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease': Sequela(
        name='severe_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1160),
        me_id=me_id(9687),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_mild_respiratory_problems_and_speech_problems',
            kind='healthstate',
            gbd_id=hs_id(874),
        ),
    ),
    'severe_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida': Sequela(
        name='severe_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1976),
        me_id=me_id(11291),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_moderate_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(908),
        ),
    ),
    'severe_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele': Sequela(
        name='severe_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2120),
        me_id=me_id(11544),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_moderate_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(908),
        ),
    ),
    'severe_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida': Sequela(
        name='severe_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2012),
        me_id=me_id(11303),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_moderate_intellectual_disability_and_incontinence',
            kind='healthstate',
            gbd_id=hs_id(904),
        ),
    ),
    'severe_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='severe_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2165),
        me_id=me_id(11559),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_moderate_intellectual_disability_and_incontinence',
            kind='healthstate',
            gbd_id=hs_id(904),
        ),
    ),
    'severe_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease': Sequela(
        name='severe_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1161),
        me_id=me_id(9688),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_moderate_respiratory_problems_and_speech_problems',
            kind='healthstate',
            gbd_id=hs_id(875),
        ),
    ),
    'severe_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida': Sequela(
        name='severe_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2066),
        me_id=me_id(11525),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_profound_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(910),
        ),
    ),
    'severe_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida': Sequela(
        name='severe_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2075),
        me_id=me_id(11528),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_profound_intellectual_disability_and_incontinence',
            kind='healthstate',
            gbd_id=hs_id(906),
        ),
    ),
    'severe_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida': Sequela(
        name='severe_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1985),
        me_id=me_id(11294),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_severe_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(909),
        ),
    ),
    'severe_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele': Sequela(
        name='severe_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2129),
        me_id=me_id(11547),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_severe_intellectual_disability',
            kind='healthstate',
            gbd_id=hs_id(909),
        ),
    ),
    'severe_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida': Sequela(
        name='severe_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(2021),
        me_id=me_id(11306),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_severe_intellectual_disability_and_incontinence',
            kind='healthstate',
            gbd_id=hs_id(905),
        ),
    ),
    'severe_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='severe_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2174),
        me_id=me_id(11562),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_severe_intellectual_disability_and_incontinence',
            kind='healthstate',
            gbd_id=hs_id(905),
        ),
    ),
    'severe_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='severe_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2183),
        me_id=me_id(11565),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_severe_intellectual_disability_and_incontinence',
            kind='healthstate',
            gbd_id=hs_id(905),
        ),
    ),
    'severe_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease': Sequela(
        name='severe_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1162),
        me_id=me_id(9689),
        healthstate=Healthstate(
            name='severe_motor_impairment_with_severe_respiratory_problems_and_speech_problems',
            kind='healthstate',
            gbd_id=hs_id(876),
        ),
    ),
    'severe_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida': Sequela(
        name='severe_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida',
        kind='sequela',
        gbd_id=s_id(1994),
        me_id=me_id(11297),
        healthstate=Healthstate(
            name='severe_motor_impairment_borderline_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2411),
        ),
    ),
    'severe_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele': Sequela(
        name='severe_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(2147),
        me_id=me_id(11553),
        healthstate=Healthstate(
            name='severe_motor_impairment_borderline_intellectual_functioning_and_urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(2411),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_tetanus': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_tetanus',
        kind='sequela',
        gbd_id=s_id(719),
        me_id=me_id(3551),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(784),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks',
        kind='sequela',
        gbd_id=s_id(720),
        me_id=me_id(3743),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(784),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks',
        kind='sequela',
        gbd_id=s_id(721),
        me_id=me_id(3785),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(784),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice',
        kind='sequela',
        gbd_id=s_id(722),
        me_id=me_id(3875),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(784),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(723),
        me_id=me_id(3833),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(784),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks',
        kind='sequela',
        gbd_id=s_id(724),
        me_id=me_id(3701),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(784),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_blindness_due_to_malaria': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_blindness_due_to_malaria',
        kind='sequela',
        gbd_id=s_id(895),
        me_id=me_id(3593),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(784),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1264),
        me_id=me_id(9630),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_blindness',
            kind='healthstate',
            gbd_id=hs_id(784),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks',
        kind='sequela',
        gbd_id=s_id(725),
        me_id=me_id(3749),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(786),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks',
        kind='sequela',
        gbd_id=s_id(726),
        me_id=me_id(3707),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(786),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice',
        kind='sequela',
        gbd_id=s_id(727),
        me_id=me_id(3881),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(786),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(728),
        me_id=me_id(3839),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(786),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks',
        kind='sequela',
        gbd_id=s_id(729),
        me_id=me_id(3791),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(786),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus',
        kind='sequela',
        gbd_id=s_id(730),
        me_id=me_id(3557),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(786),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_malaria': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_malaria',
        kind='sequela',
        gbd_id=s_id(897),
        me_id=me_id(3599),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(786),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1266),
        me_id=me_id(9632),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(786),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks',
        kind='sequela',
        gbd_id=s_id(731),
        me_id=me_id(3704),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(785),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='sequela',
        gbd_id=s_id(732),
        me_id=me_id(3836),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(785),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice',
        kind='sequela',
        gbd_id=s_id(733),
        me_id=me_id(3878),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(785),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks',
        kind='sequela',
        gbd_id=s_id(734),
        me_id=me_id(3788),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(785),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks',
        kind='sequela',
        gbd_id=s_id(735),
        me_id=me_id(3746),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(785),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_tetanus': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_tetanus',
        kind='sequela',
        gbd_id=s_id(736),
        me_id=me_id(3554),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(785),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_malaria': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_malaria',
        kind='sequela',
        gbd_id=s_id(896),
        me_id=me_id(3596),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(785),
        ),
    ),
    'severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections': Sequela(
        name='severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections',
        kind='sequela',
        gbd_id=s_id(1265),
        me_id=me_id(9631),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(785),
        ),
    ),
    'congenital_zika_syndrome': Sequela(
        name='congenital_zika_syndrome',
        kind='sequela',
        gbd_id=s_id(1517),
        me_id=me_id(10403),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairment_with_epilepsy',
            kind='healthstate',
            gbd_id=hs_id(785),
        ),
    ),
    'severe_motor_and_cognitive_impairment_with_congenital_heart_disease_due_to_edward_syndrome_or_patau_syndrome': Sequela(
        name='severe_motor_and_cognitive_impairment_with_congenital_heart_disease_due_to_edward_syndrome_or_patau_syndrome',
        kind='sequela',
        gbd_id=s_id(1901),
        me_id=me_id(11311),
        healthstate=Healthstate(
            name='severe_motor_plus_cognitive_impairments_and_congenital_heart_disease',
            kind='healthstate',
            gbd_id=hs_id(2366),
        ),
    ),
    'severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease': Sequela(
        name='severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1178),
        me_id=me_id(9693),
        healthstate=Healthstate(
            name='severe_respiratory_and_speech_problems',
            kind='healthstate',
            gbd_id=hs_id(891),
        ),
    ),
    'difficulty_eating_due_to_edentulism_and_severe_tooth_loss': Sequela(
        name='difficulty_eating_due_to_edentulism_and_severe_tooth_loss',
        kind='sequela',
        gbd_id=s_id(664),
        me_id=me_id(2584),
        healthstate=Healthstate(
            name='severe_tooth_loss',
            kind='healthstate',
            gbd_id=hs_id(552),
        ),
    ),
    'severe_wasting_due_to_ascariasis': Sequela(
        name='severe_wasting_due_to_ascariasis',
        kind='sequela',
        gbd_id=s_id(165),
        me_id=me_id(1515),
        healthstate=Healthstate(
            name='severe_wasting',
            kind='healthstate',
            gbd_id=hs_id(563),
        ),
    ),
    'severe_wasting_due_to_trichuriasis': Sequela(
        name='severe_wasting_due_to_trichuriasis',
        kind='sequela',
        gbd_id=s_id(168),
        me_id=me_id(1518),
        healthstate=Healthstate(
            name='severe_wasting',
            kind='healthstate',
            gbd_id=hs_id(563),
        ),
    ),
    'severe_wasting_due_to_hookworm_disease': Sequela(
        name='severe_wasting_due_to_hookworm_disease',
        kind='sequela',
        gbd_id=s_id(171),
        me_id=me_id(1521),
        healthstate=Healthstate(
            name='severe_wasting',
            kind='healthstate',
            gbd_id=hs_id(563),
        ),
    ),
    'severe_wasting_without_edema': Sequela(
        name='severe_wasting_without_edema',
        kind='sequela',
        gbd_id=s_id(199),
        me_id=me_id(1607),
        healthstate=Healthstate(
            name='severe_wasting',
            kind='healthstate',
            gbd_id=hs_id(563),
        ),
    ),
    'speech_problems_due_to_motor_neuron_disease': Sequela(
        name='speech_problems_due_to_motor_neuron_disease',
        kind='sequela',
        gbd_id=s_id(1182),
        me_id=me_id(9694),
        healthstate=Healthstate(
            name='speech_problems',
            kind='healthstate',
            gbd_id=hs_id(564),
        ),
    ),
    'laryngectomy_from_larynx_cancer_beyond_ten_years': Sequela(
        name='laryngectomy_from_larynx_cancer_beyond_ten_years',
        kind='sequela',
        gbd_id=s_id(5516),
        me_id=me_id(18788),
        healthstate=Healthstate(
            name='speech_problems',
            kind='healthstate',
            gbd_id=hs_id(564),
        ),
    ),
    'controlled_phase_of_larynx_cancer_with_laryngectomy': Sequela(
        name='controlled_phase_of_larynx_cancer_with_laryngectomy',
        kind='sequela',
        gbd_id=s_id(5510),
        me_id=me_id(18786),
        healthstate=Healthstate(
            name='speech_problems_and_generic_medication',
            kind='healthstate',
            gbd_id=hs_id(893),
        ),
    ),
    'disfigurement_level_2_and_speech_problems_due_to_orofacial_clefts': Sequela(
        name='disfigurement_level_2_and_speech_problems_due_to_orofacial_clefts',
        kind='sequela',
        gbd_id=s_id(925),
        me_id=me_id(3058),
        healthstate=Healthstate(
            name='speech_problems_with_disfigurement_level_2',
            kind='healthstate',
            gbd_id=hs_id(773),
        ),
    ),
    'guillain_barre_syndrome_due_to_upper_respiratory_infections': Sequela(
        name='guillain_barre_syndrome_due_to_upper_respiratory_infections',
        kind='sequela',
        gbd_id=s_id(17),
        me_id=me_id(1280),
        healthstate=Healthstate(
            name='spinal_cord_lesion_below_neck_level_treated',
            kind='healthstate',
            gbd_id=hs_id(540),
        ),
    ),
    'guillain_barre_syndrome_due_to_other_infectious_diseases': Sequela(
        name='guillain_barre_syndrome_due_to_other_infectious_diseases',
        kind='sequela',
        gbd_id=s_id(243),
        me_id=me_id(1669),
        healthstate=Healthstate(
            name='spinal_cord_lesion_below_neck_level_treated',
            kind='healthstate',
            gbd_id=hs_id(540),
        ),
    ),
    'guillain_barre_syndrome_due_to_other_neurological_disorders': Sequela(
        name='guillain_barre_syndrome_due_to_other_neurological_disorders',
        kind='sequela',
        gbd_id=s_id(465),
        me_id=me_id(1963),
        healthstate=Healthstate(
            name='spinal_cord_lesion_below_neck_level_treated',
            kind='healthstate',
            gbd_id=hs_id(540),
        ),
    ),
    'guillain_barre_syndrome_due_to_diarrheal_diseases': Sequela(
        name='guillain_barre_syndrome_due_to_diarrheal_diseases',
        kind='sequela',
        gbd_id=s_id(668),
        me_id=me_id(2611),
        healthstate=Healthstate(
            name='spinal_cord_lesion_below_neck_level_treated',
            kind='healthstate',
            gbd_id=hs_id(540),
        ),
    ),
    'guillain_barre_syndrome_due_to_lower_respiratory_infections': Sequela(
        name='guillain_barre_syndrome_due_to_lower_respiratory_infections',
        kind='sequela',
        gbd_id=s_id(671),
        me_id=me_id(2615),
        healthstate=Healthstate(
            name='spinal_cord_lesion_below_neck_level_treated',
            kind='healthstate',
            gbd_id=hs_id(540),
        ),
    ),
    'guillain_barre_syndrome_due_to_zika_infection': Sequela(
        name='guillain_barre_syndrome_due_to_zika_infection',
        kind='sequela',
        gbd_id=s_id(1514),
        me_id=me_id(10402),
        healthstate=Healthstate(
            name='spinal_cord_lesion_below_neck_level_treated',
            kind='healthstate',
            gbd_id=hs_id(540),
        ),
    ),
    'stoma_from_colon_and_rectum_cancers_beyond_ten_years': Sequela(
        name='stoma_from_colon_and_rectum_cancers_beyond_ten_years',
        kind='sequela',
        gbd_id=s_id(5525),
        me_id=me_id(18791),
        healthstate=Healthstate(
            name='stoma',
            kind='healthstate',
            gbd_id=hs_id(371),
        ),
    ),
    'controlled_phase_of_colon_and_rectum_cancers_with_stoma': Sequela(
        name='controlled_phase_of_colon_and_rectum_cancers_with_stoma',
        kind='sequela',
        gbd_id=s_id(5519),
        me_id=me_id(18789),
        healthstate=Healthstate(
            name='stoma_and_generic_medication',
            kind='healthstate',
            gbd_id=hs_id(892),
        ),
    ),
    'stress_incontinence_due_to_genital_prolapse': Sequela(
        name='stress_incontinence_due_to_genital_prolapse',
        kind='sequela',
        gbd_id=s_id(860),
        me_id=me_id(2941),
        healthstate=Healthstate(
            name='stress_incontinence',
            kind='healthstate',
            gbd_id=hs_id(793),
        ),
    ),
    'acute_ischemic_stroke_severity_level_1': Sequela(
        name='acute_ischemic_stroke_severity_level_1',
        kind='sequela',
        gbd_id=s_id(386),
        me_id=me_id(1827),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_mild',
            kind='healthstate',
            gbd_id=hs_id(384),
        ),
    ),
    'chronic_ischemic_stroke_severity_level_1': Sequela(
        name='chronic_ischemic_stroke_severity_level_1',
        kind='sequela',
        gbd_id=s_id(391),
        me_id=me_id(1833),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_mild',
            kind='healthstate',
            gbd_id=hs_id(384),
        ),
    ),
    'acute_intracerebral_hemorrhage_severity_level_1': Sequela(
        name='acute_intracerebral_hemorrhage_severity_level_1',
        kind='sequela',
        gbd_id=s_id(396),
        me_id=me_id(1839),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_mild',
            kind='healthstate',
            gbd_id=hs_id(384),
        ),
    ),
    'chronic_intracerebral_hemorrhage_severity_level_1': Sequela(
        name='chronic_intracerebral_hemorrhage_severity_level_1',
        kind='sequela',
        gbd_id=s_id(401),
        me_id=me_id(1845),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_mild',
            kind='healthstate',
            gbd_id=hs_id(384),
        ),
    ),
    'acute_subarachnoid_hemorrhage_severity_level_1': Sequela(
        name='acute_subarachnoid_hemorrhage_severity_level_1',
        kind='sequela',
        gbd_id=s_id(5168),
        me_id=me_id(19561),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_mild',
            kind='healthstate',
            gbd_id=hs_id(384),
        ),
    ),
    'chronic_subarachnoid_hemorrhage_severity_level_1': Sequela(
        name='chronic_subarachnoid_hemorrhage_severity_level_1',
        kind='sequela',
        gbd_id=s_id(5186),
        me_id=me_id(19567),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_mild',
            kind='healthstate',
            gbd_id=hs_id(384),
        ),
    ),
    'acute_ischemic_stroke_severity_level_2': Sequela(
        name='acute_ischemic_stroke_severity_level_2',
        kind='sequela',
        gbd_id=s_id(387),
        me_id=me_id(1828),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_moderate',
            kind='healthstate',
            gbd_id=hs_id(385),
        ),
    ),
    'chronic_ischemic_stroke_severity_level_2': Sequela(
        name='chronic_ischemic_stroke_severity_level_2',
        kind='sequela',
        gbd_id=s_id(392),
        me_id=me_id(1834),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_moderate',
            kind='healthstate',
            gbd_id=hs_id(385),
        ),
    ),
    'acute_intracerebral_hemorrhage_severity_level_2': Sequela(
        name='acute_intracerebral_hemorrhage_severity_level_2',
        kind='sequela',
        gbd_id=s_id(397),
        me_id=me_id(1840),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_moderate',
            kind='healthstate',
            gbd_id=hs_id(385),
        ),
    ),
    'chronic_intracerebral_hemorrhage_severity_level_2': Sequela(
        name='chronic_intracerebral_hemorrhage_severity_level_2',
        kind='sequela',
        gbd_id=s_id(402),
        me_id=me_id(1846),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_moderate',
            kind='healthstate',
            gbd_id=hs_id(385),
        ),
    ),
    'acute_subarachnoid_hemorrhage_severity_level_2': Sequela(
        name='acute_subarachnoid_hemorrhage_severity_level_2',
        kind='sequela',
        gbd_id=s_id(5171),
        me_id=me_id(19562),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_moderate',
            kind='healthstate',
            gbd_id=hs_id(385),
        ),
    ),
    'chronic_subarachnoid_hemorrhage_severity_level_2': Sequela(
        name='chronic_subarachnoid_hemorrhage_severity_level_2',
        kind='sequela',
        gbd_id=s_id(5189),
        me_id=me_id(19568),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_moderate',
            kind='healthstate',
            gbd_id=hs_id(385),
        ),
    ),
    'acute_ischemic_stroke_severity_level_3': Sequela(
        name='acute_ischemic_stroke_severity_level_3',
        kind='sequela',
        gbd_id=s_id(389),
        me_id=me_id(1830),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_moderate_plus_cognition_problems',
            kind='healthstate',
            gbd_id=hs_id(386),
        ),
    ),
    'chronic_ischemic_stroke_severity_level_3': Sequela(
        name='chronic_ischemic_stroke_severity_level_3',
        kind='sequela',
        gbd_id=s_id(394),
        me_id=me_id(1836),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_moderate_plus_cognition_problems',
            kind='healthstate',
            gbd_id=hs_id(386),
        ),
    ),
    'acute_intracerebral_hemorrhage_severity_level_3': Sequela(
        name='acute_intracerebral_hemorrhage_severity_level_3',
        kind='sequela',
        gbd_id=s_id(399),
        me_id=me_id(1842),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_moderate_plus_cognition_problems',
            kind='healthstate',
            gbd_id=hs_id(386),
        ),
    ),
    'chronic_intracerebral_hemorrhage_severity_level_3': Sequela(
        name='chronic_intracerebral_hemorrhage_severity_level_3',
        kind='sequela',
        gbd_id=s_id(404),
        me_id=me_id(1848),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_moderate_plus_cognition_problems',
            kind='healthstate',
            gbd_id=hs_id(386),
        ),
    ),
    'acute_subarachnoid_hemorrhage_severity_level_3': Sequela(
        name='acute_subarachnoid_hemorrhage_severity_level_3',
        kind='sequela',
        gbd_id=s_id(5174),
        me_id=me_id(19563),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_moderate_plus_cognition_problems',
            kind='healthstate',
            gbd_id=hs_id(386),
        ),
    ),
    'chronic_subarachnoid_hemorrhage_severity_level_3': Sequela(
        name='chronic_subarachnoid_hemorrhage_severity_level_3',
        kind='sequela',
        gbd_id=s_id(5192),
        me_id=me_id(19569),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_moderate_plus_cognition_problems',
            kind='healthstate',
            gbd_id=hs_id(386),
        ),
    ),
    'acute_ischemic_stroke_severity_level_4': Sequela(
        name='acute_ischemic_stroke_severity_level_4',
        kind='sequela',
        gbd_id=s_id(388),
        me_id=me_id(1829),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_severe',
            kind='healthstate',
            gbd_id=hs_id(387),
        ),
    ),
    'chronic_ischemic_stroke_severity_level_4': Sequela(
        name='chronic_ischemic_stroke_severity_level_4',
        kind='sequela',
        gbd_id=s_id(393),
        me_id=me_id(1835),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_severe',
            kind='healthstate',
            gbd_id=hs_id(387),
        ),
    ),
    'acute_intracerebral_hemorrhage_severity_level_4': Sequela(
        name='acute_intracerebral_hemorrhage_severity_level_4',
        kind='sequela',
        gbd_id=s_id(398),
        me_id=me_id(1841),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_severe',
            kind='healthstate',
            gbd_id=hs_id(387),
        ),
    ),
    'chronic_intracerebral_hemorrhage_severity_level_4': Sequela(
        name='chronic_intracerebral_hemorrhage_severity_level_4',
        kind='sequela',
        gbd_id=s_id(403),
        me_id=me_id(1847),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_severe',
            kind='healthstate',
            gbd_id=hs_id(387),
        ),
    ),
    'acute_subarachnoid_hemorrhage_severity_level_4': Sequela(
        name='acute_subarachnoid_hemorrhage_severity_level_4',
        kind='sequela',
        gbd_id=s_id(5177),
        me_id=me_id(19564),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_severe',
            kind='healthstate',
            gbd_id=hs_id(387),
        ),
    ),
    'chronic_subarachnoid_hemorrhage_severity_level_4': Sequela(
        name='chronic_subarachnoid_hemorrhage_severity_level_4',
        kind='sequela',
        gbd_id=s_id(5195),
        me_id=me_id(19570),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_severe',
            kind='healthstate',
            gbd_id=hs_id(387),
        ),
    ),
    'acute_ischemic_stroke_severity_level_5': Sequela(
        name='acute_ischemic_stroke_severity_level_5',
        kind='sequela',
        gbd_id=s_id(390),
        me_id=me_id(1831),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_severe_plus_cognition_problems',
            kind='healthstate',
            gbd_id=hs_id(388),
        ),
    ),
    'chronic_ischemic_stroke_severity_level_5': Sequela(
        name='chronic_ischemic_stroke_severity_level_5',
        kind='sequela',
        gbd_id=s_id(395),
        me_id=me_id(1837),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_severe_plus_cognition_problems',
            kind='healthstate',
            gbd_id=hs_id(388),
        ),
    ),
    'acute_intracerebral_hemorrhage_severity_level_5': Sequela(
        name='acute_intracerebral_hemorrhage_severity_level_5',
        kind='sequela',
        gbd_id=s_id(400),
        me_id=me_id(1843),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_severe_plus_cognition_problems',
            kind='healthstate',
            gbd_id=hs_id(388),
        ),
    ),
    'chronic_intracerebral_hemorrhage_severity_level_5': Sequela(
        name='chronic_intracerebral_hemorrhage_severity_level_5',
        kind='sequela',
        gbd_id=s_id(405),
        me_id=me_id(1849),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_severe_plus_cognition_problems',
            kind='healthstate',
            gbd_id=hs_id(388),
        ),
    ),
    'acute_subarachnoid_hemorrhage_severity_level_5': Sequela(
        name='acute_subarachnoid_hemorrhage_severity_level_5',
        kind='sequela',
        gbd_id=s_id(5180),
        me_id=me_id(19565),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_severe_plus_cognition_problems',
            kind='healthstate',
            gbd_id=hs_id(388),
        ),
    ),
    'chronic_subarachnoid_hemorrhage_severity_level_5': Sequela(
        name='chronic_subarachnoid_hemorrhage_severity_level_5',
        kind='sequela',
        gbd_id=s_id(5198),
        me_id=me_id(19571),
        healthstate=Healthstate(
            name='stroke_long_term_consequences_severe_plus_cognition_problems',
            kind='healthstate',
            gbd_id=hs_id(388),
        ),
    ),
    'long_term_sequelae_of_severe_pre_eclampsia': Sequela(
        name='long_term_sequelae_of_severe_pre_eclampsia',
        kind='sequela',
        gbd_id=s_id(187),
        me_id=me_id(1546),
        healthstate=Healthstate(
            name='tension_type_headaches_mild_motor_plus_cognitive_impairment',
            kind='healthstate',
            gbd_id=hs_id(825),
        ),
    ),
    'long_term_sequelae_of_eclampsia': Sequela(
        name='long_term_sequelae_of_eclampsia',
        kind='sequela',
        gbd_id=s_id(677),
        me_id=me_id(2627),
        healthstate=Healthstate(
            name='tension_type_headaches_mild_motor_plus_cognitive_impairment',
            kind='healthstate',
            gbd_id=hs_id(825),
        ),
    ),
    'terminal_phase_of_esophageal_cancer': Sequela(
        name='terminal_phase_of_esophageal_cancer',
        kind='sequela',
        gbd_id=s_id(247),
        me_id=me_id(1673),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_stomach_cancer': Sequela(
        name='terminal_phase_of_stomach_cancer',
        kind='sequela',
        gbd_id=s_id(251),
        me_id=me_id(1677),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_liver_cancer_due_to_hepatitis_b': Sequela(
        name='terminal_phase_of_liver_cancer_due_to_hepatitis_b',
        kind='sequela',
        gbd_id=s_id(255),
        me_id=me_id(1685),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_liver_cancer_due_to_hepatitis_c': Sequela(
        name='terminal_phase_of_liver_cancer_due_to_hepatitis_c',
        kind='sequela',
        gbd_id=s_id(259),
        me_id=me_id(1689),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_liver_cancer_due_to_alcohol_use': Sequela(
        name='terminal_phase_of_liver_cancer_due_to_alcohol_use',
        kind='sequela',
        gbd_id=s_id(263),
        me_id=me_id(1693),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_liver_cancer_due_to_other_causes': Sequela(
        name='terminal_phase_of_liver_cancer_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(267),
        me_id=me_id(1697),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_larynx_cancer': Sequela(
        name='terminal_phase_of_larynx_cancer',
        kind='sequela',
        gbd_id=s_id(271),
        me_id=me_id(1701),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_lung_bronchus_and_trachea_cancer': Sequela(
        name='terminal_phase_of_lung_bronchus_and_trachea_cancer',
        kind='sequela',
        gbd_id=s_id(276),
        me_id=me_id(1706),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_breast_cancer': Sequela(
        name='terminal_phase_of_breast_cancer',
        kind='sequela',
        gbd_id=s_id(280),
        me_id=me_id(1710),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_cervical_cancer': Sequela(
        name='terminal_phase_of_cervical_cancer',
        kind='sequela',
        gbd_id=s_id(285),
        me_id=me_id(1715),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_uterine_cancer': Sequela(
        name='terminal_phase_of_uterine_cancer',
        kind='sequela',
        gbd_id=s_id(289),
        me_id=me_id(1719),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_prostate_cancer': Sequela(
        name='terminal_phase_of_prostate_cancer',
        kind='sequela',
        gbd_id=s_id(293),
        me_id=me_id(1723),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_colon_and_rectum_cancers': Sequela(
        name='terminal_phase_of_colon_and_rectum_cancers',
        kind='sequela',
        gbd_id=s_id(299),
        me_id=me_id(1730),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_mouth_cancer': Sequela(
        name='terminal_phase_of_mouth_cancer',
        kind='sequela',
        gbd_id=s_id(304),
        me_id=me_id(1735),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_nasopharynx_cancer': Sequela(
        name='terminal_phase_of_nasopharynx_cancer',
        kind='sequela',
        gbd_id=s_id(308),
        me_id=me_id(1739),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_other_pharynx_cancer': Sequela(
        name='terminal_phase_of_other_pharynx_cancer',
        kind='sequela',
        gbd_id=s_id(312),
        me_id=me_id(1743),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_gallbladder_and_biliary_tract_cancer': Sequela(
        name='terminal_phase_of_gallbladder_and_biliary_tract_cancer',
        kind='sequela',
        gbd_id=s_id(316),
        me_id=me_id(1747),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_pancreatic_cancer': Sequela(
        name='terminal_phase_of_pancreatic_cancer',
        kind='sequela',
        gbd_id=s_id(320),
        me_id=me_id(1751),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_malignant_skin_melanoma': Sequela(
        name='terminal_phase_of_malignant_skin_melanoma',
        kind='sequela',
        gbd_id=s_id(324),
        me_id=me_id(1755),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_ovarian_cancer': Sequela(
        name='terminal_phase_of_ovarian_cancer',
        kind='sequela',
        gbd_id=s_id(332),
        me_id=me_id(1764),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_testicular_cancer': Sequela(
        name='terminal_phase_of_testicular_cancer',
        kind='sequela',
        gbd_id=s_id(336),
        me_id=me_id(1768),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_kidney_cancer': Sequela(
        name='terminal_phase_of_kidney_cancer',
        kind='sequela',
        gbd_id=s_id(340),
        me_id=me_id(1772),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_bladder_cancer': Sequela(
        name='terminal_phase_of_bladder_cancer',
        kind='sequela',
        gbd_id=s_id(344),
        me_id=me_id(1776),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_brain_and_central_nervous_system_cancers': Sequela(
        name='terminal_phase_of_brain_and_central_nervous_system_cancers',
        kind='sequela',
        gbd_id=s_id(349),
        me_id=me_id(1781),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_thyroid_cancer': Sequela(
        name='terminal_phase_of_thyroid_cancer',
        kind='sequela',
        gbd_id=s_id(353),
        me_id=me_id(1785),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_mesothelioma': Sequela(
        name='terminal_phase_of_mesothelioma',
        kind='sequela',
        gbd_id=s_id(357),
        me_id=me_id(1789),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_hodgkin_disease': Sequela(
        name='terminal_phase_of_hodgkin_disease',
        kind='sequela',
        gbd_id=s_id(361),
        me_id=me_id(1793),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_multiple_myeloma': Sequela(
        name='terminal_phase_of_multiple_myeloma',
        kind='sequela',
        gbd_id=s_id(369),
        me_id=me_id(1801),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_acute_lymphoid_leukemia': Sequela(
        name='terminal_phase_of_acute_lymphoid_leukemia',
        kind='sequela',
        gbd_id=s_id(1198),
        me_id=me_id(9479),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_acute_myeloid_leukemia': Sequela(
        name='terminal_phase_of_acute_myeloid_leukemia',
        kind='sequela',
        gbd_id=s_id(1199),
        me_id=me_id(9489),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_chronic_lymphoid_leukemia': Sequela(
        name='terminal_phase_of_chronic_lymphoid_leukemia',
        kind='sequela',
        gbd_id=s_id(1200),
        me_id=me_id(9484),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_chronic_myeloid_leukemia': Sequela(
        name='terminal_phase_of_chronic_myeloid_leukemia',
        kind='sequela',
        gbd_id=s_id(1201),
        me_id=me_id(9494),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_other_leukemia': Sequela(
        name='terminal_phase_of_other_leukemia',
        kind='sequela',
        gbd_id=s_id(1487),
        me_id=me_id(18821),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_other_malignant_neoplasms': Sequela(
        name='terminal_phase_of_other_malignant_neoplasms',
        kind='sequela',
        gbd_id=s_id(5873),
        me_id=me_id(19827),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_burkitt_lymphoma': Sequela(
        name='terminal_phase_of_burkitt_lymphoma',
        kind='sequela',
        gbd_id=s_id(22895),
        me_id=me_id(23781),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_other_non_hodgkin_lymphoma': Sequela(
        name='terminal_phase_of_other_non_hodgkin_lymphoma',
        kind='sequela',
        gbd_id=s_id(22899),
        me_id=me_id(23786),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_hepatoblastoma': Sequela(
        name='terminal_phase_of_hepatoblastoma',
        kind='sequela',
        gbd_id=s_id(22903),
        me_id=me_id(23791),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_retinoblastoma': Sequela(
        name='terminal_phase_of_retinoblastoma',
        kind='sequela',
        gbd_id=s_id(22915),
        me_id=me_id(23801),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_other_eye_cancers': Sequela(
        name='terminal_phase_of_other_eye_cancers',
        kind='sequela',
        gbd_id=s_id(22919),
        me_id=me_id(23806),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_soft_tissue_and_other_extraosseous_sarcomas': Sequela(
        name='terminal_phase_of_soft_tissue_and_other_extraosseous_sarcomas',
        kind='sequela',
        gbd_id=s_id(22923),
        me_id=me_id(23811),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_malignant_bone_tumors': Sequela(
        name='terminal_phase_of_malignant_bone_tumors',
        kind='sequela',
        gbd_id=s_id(22927),
        me_id=me_id(23816),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'terminal_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors': Sequela(
        name='terminal_phase_of_neuroblastoma_and_other_peripheral_nervous_cell_tumors',
        kind='sequela',
        gbd_id=s_id(22931),
        me_id=me_id(23821),
        healthstate=Healthstate(
            name='terminal_phase_with_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(372),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_hypertension': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_hypertension',
        kind='sequela',
        gbd_id=s_id(1370),
        me_id=me_id(10869),
        healthstate=Healthstate(
            name='terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(373),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_glomerulonephritis': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_glomerulonephritis',
        kind='sequela',
        gbd_id=s_id(1382),
        me_id=me_id(10873),
        healthstate=Healthstate(
            name='terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(373),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_other_causes': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_other_causes',
        kind='sequela',
        gbd_id=s_id(1394),
        me_id=me_id(10877),
        healthstate=Healthstate(
            name='terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(373),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_type_1_diabetes_mellitus': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_type_1_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5279),
        me_id=me_id(19431),
        healthstate=Healthstate(
            name='terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(373),
        ),
    ),
    'stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_type_2_diabetes_mellitus': Sequela(
        name='stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_type_2_diabetes_mellitus',
        kind='sequela',
        gbd_id=s_id(5282),
        me_id=me_id(19432),
        healthstate=Healthstate(
            name='terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(373),
        ),
    ),
    'terminal_phase_of_liver_cancer_due_to_nash': Sequela(
        name='terminal_phase_of_liver_cancer_due_to_nash',
        kind='sequela',
        gbd_id=s_id(5426),
        me_id=me_id(18767),
        healthstate=Healthstate(
            name='terminal_phase_without_medication_for_cancers_end_stage_kidney_liver_disease',
            kind='healthstate',
            gbd_id=hs_id(373),
        ),
    ),
    'severe_endocrine_metabolic_blood_and_immune_disorders': Sequela(
        name='severe_endocrine_metabolic_blood_and_immune_disorders',
        kind='sequela',
        gbd_id=s_id(907),
        me_id=me_id(2998),
        healthstate=Healthstate(
            name='thrombocytopenic_purpura',
            kind='healthstate',
            gbd_id=hs_id(811),
        ),
    ),
    'hiv_aids_drug_susceptible_tuberculosis_without_anemia': Sequela(
        name='hiv_aids_drug_susceptible_tuberculosis_without_anemia',
        kind='sequela',
        gbd_id=s_id(5108),
        me_id=me_id(16340),
        healthstate=Healthstate(
            name='tuberculosis_hiv_infected',
            kind='healthstate',
            gbd_id=hs_id(367),
        ),
    ),
    'hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_without_anemia': Sequela(
        name='hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_without_anemia',
        kind='sequela',
        gbd_id=s_id(5120),
        me_id=me_id(16344),
        healthstate=Healthstate(
            name='tuberculosis_hiv_infected',
            kind='healthstate',
            gbd_id=hs_id(367),
        ),
    ),
    'hiv_aids_extensively_drug_resistant_tuberculosis_without_anemia': Sequela(
        name='hiv_aids_extensively_drug_resistant_tuberculosis_without_anemia',
        kind='sequela',
        gbd_id=s_id(5132),
        me_id=me_id(16348),
        healthstate=Healthstate(
            name='tuberculosis_hiv_infected',
            kind='healthstate',
            gbd_id=hs_id(367),
        ),
    ),
    'hiv_aids_drug_susceptible_tuberculosis_with_mild_anemia': Sequela(
        name='hiv_aids_drug_susceptible_tuberculosis_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(5099),
        me_id=me_id(16337),
        healthstate=Healthstate(
            name='tuberculosis_hiv_infected_and_anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(2561),
        ),
    ),
    'hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_mild_anemia': Sequela(
        name='hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(5111),
        me_id=me_id(16341),
        healthstate=Healthstate(
            name='tuberculosis_hiv_infected_and_anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(2561),
        ),
    ),
    'hiv_aids_extensively_drug_resistant_tuberculosis_with_mild_anemia': Sequela(
        name='hiv_aids_extensively_drug_resistant_tuberculosis_with_mild_anemia',
        kind='sequela',
        gbd_id=s_id(5123),
        me_id=me_id(16345),
        healthstate=Healthstate(
            name='tuberculosis_hiv_infected_and_anemia_mild',
            kind='healthstate',
            gbd_id=hs_id(2561),
        ),
    ),
    'hiv_aids_drug_susceptible_tuberculosis_with_moderate_anemia': Sequela(
        name='hiv_aids_drug_susceptible_tuberculosis_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(5102),
        me_id=me_id(16338),
        healthstate=Healthstate(
            name='tuberculosis_hiv_infected_and_anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(2564),
        ),
    ),
    'hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_moderate_anemia': Sequela(
        name='hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(5114),
        me_id=me_id(16342),
        healthstate=Healthstate(
            name='tuberculosis_hiv_infected_and_anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(2564),
        ),
    ),
    'hiv_aids_extensively_drug_resistant_tuberculosis_with_moderate_anemia': Sequela(
        name='hiv_aids_extensively_drug_resistant_tuberculosis_with_moderate_anemia',
        kind='sequela',
        gbd_id=s_id(5126),
        me_id=me_id(16346),
        healthstate=Healthstate(
            name='tuberculosis_hiv_infected_and_anemia_moderate',
            kind='healthstate',
            gbd_id=hs_id(2564),
        ),
    ),
    'hiv_aids_drug_susceptible_tuberculosis_with_severe_anemia': Sequela(
        name='hiv_aids_drug_susceptible_tuberculosis_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5105),
        me_id=me_id(16339),
        healthstate=Healthstate(
            name='tuberculosis_hiv_infected_and_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(2567),
        ),
    ),
    'hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_severe_anemia': Sequela(
        name='hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5117),
        me_id=me_id(16343),
        healthstate=Healthstate(
            name='tuberculosis_hiv_infected_and_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(2567),
        ),
    ),
    'hiv_aids_extensively_drug_resistant_tuberculosis_with_severe_anemia': Sequela(
        name='hiv_aids_extensively_drug_resistant_tuberculosis_with_severe_anemia',
        kind='sequela',
        gbd_id=s_id(5129),
        me_id=me_id(16347),
        healthstate=Healthstate(
            name='tuberculosis_hiv_infected_and_anemia_severe',
            kind='healthstate',
            gbd_id=hs_id(2567),
        ),
    ),
    'drug_susceptible_tuberculosis': Sequela(
        name='drug_susceptible_tuberculosis',
        kind='sequela',
        gbd_id=s_id(1493),
        me_id=me_id(10829),
        healthstate=Healthstate(
            name='tuberculosis_not_hiv_infected',
            kind='healthstate',
            gbd_id=hs_id(366),
        ),
    ),
    'multidrug_resistant_tuberculosis_without_extensive_drug_resistance': Sequela(
        name='multidrug_resistant_tuberculosis_without_extensive_drug_resistance',
        kind='sequela',
        gbd_id=s_id(1496),
        me_id=me_id(10830),
        healthstate=Healthstate(
            name='tuberculosis_not_hiv_infected',
            kind='healthstate',
            gbd_id=hs_id(366),
        ),
    ),
    'extensively_drug_resistant_tuberculosis': Sequela(
        name='extensively_drug_resistant_tuberculosis',
        kind='sequela',
        gbd_id=s_id(1499),
        me_id=me_id(10831),
        healthstate=Healthstate(
            name='tuberculosis_not_hiv_infected',
            kind='healthstate',
            gbd_id=hs_id(366),
        ),
    ),
    'incontinence_due_to_congenital_anomalies_of_the_urinary_tract': Sequela(
        name='incontinence_due_to_congenital_anomalies_of_the_urinary_tract',
        kind='sequela',
        gbd_id=s_id(1856),
        me_id=me_id(11363),
        healthstate=Healthstate(
            name='urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(398),
        ),
    ),
    'incontinence_due_to_encephalocele': Sequela(
        name='incontinence_due_to_encephalocele',
        kind='sequela',
        gbd_id=s_id(1925),
        me_id=me_id(11274),
        healthstate=Healthstate(
            name='urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(398),
        ),
    ),
    'incontinence_from_prostate_cancer_beyond_ten_years': Sequela(
        name='incontinence_from_prostate_cancer_beyond_ten_years',
        kind='sequela',
        gbd_id=s_id(5507),
        me_id=me_id(18785),
        healthstate=Healthstate(
            name='urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(398),
        ),
    ),
    'incontinence_from_bladder_cancer_beyond_ten_years': Sequela(
        name='incontinence_from_bladder_cancer_beyond_ten_years',
        kind='sequela',
        gbd_id=s_id(5534),
        me_id=me_id(18794),
        healthstate=Healthstate(
            name='urinary_incontinence',
            kind='healthstate',
            gbd_id=hs_id(398),
        ),
    ),
    'incontinence_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract': Sequela(
        name='incontinence_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract',
        kind='sequela',
        gbd_id=s_id(1880),
        me_id=me_id(11371),
        healthstate=Healthstate(
            name='urinary_incontinence_and_impotence',
            kind='healthstate',
            gbd_id=hs_id(2354),
        ),
    ),
    'moderate_chronic_other_sense_organ_diseases': Sequela(
        name='moderate_chronic_other_sense_organ_diseases',
        kind='sequela',
        gbd_id=s_id(1340),
        me_id=me_id(10318),
        healthstate=Healthstate(
            name='vertigo',
            kind='healthstate',
            gbd_id=hs_id(823),
        ),
    ),
    'vertigo_with_mild_hearing_loss_due_to_chronic_otitis_media': Sequela(
        name='vertigo_with_mild_hearing_loss_due_to_chronic_otitis_media',
        kind='sequela',
        gbd_id=s_id(972),
        me_id=me_id(3137),
        healthstate=Healthstate(
            name='vertigo_with_mild_hearing_loss',
            kind='healthstate',
            gbd_id=hs_id(827),
        ),
    ),
    'vertigo_with_mild_hearing_loss_and_ringing_due_to_chronic_otitis_media': Sequela(
        name='vertigo_with_mild_hearing_loss_and_ringing_due_to_chronic_otitis_media',
        kind='sequela',
        gbd_id=s_id(973),
        me_id=me_id(3138),
        healthstate=Healthstate(
            name='vertigo_with_mild_hearing_loss_and_ringing',
            kind='healthstate',
            gbd_id=hs_id(828),
        ),
    ),
    'vertigo_with_moderate_hearing_loss_due_to_chronic_otitis_media': Sequela(
        name='vertigo_with_moderate_hearing_loss_due_to_chronic_otitis_media',
        kind='sequela',
        gbd_id=s_id(1102),
        me_id=me_id(3324),
        healthstate=Healthstate(
            name='vertigo_with_moderate_hearing_loss',
            kind='healthstate',
            gbd_id=hs_id(863),
        ),
    ),
    'vertigo_with_moderate_hearing_loss_and_ringing_due_to_chronic_otitis_media': Sequela(
        name='vertigo_with_moderate_hearing_loss_and_ringing_due_to_chronic_otitis_media',
        kind='sequela',
        gbd_id=s_id(1103),
        me_id=me_id(3325),
        healthstate=Healthstate(
            name='vertigo_with_moderate_hearing_loss_and_ringing',
            kind='healthstate',
            gbd_id=hs_id(864),
        ),
    ),
    'vesicovaginal_fistula': Sequela(
        name='vesicovaginal_fistula',
        kind='sequela',
        gbd_id=s_id(190),
        me_id=me_id(1554),
        healthstate=Healthstate(
            name='vesicovaginal_fistula',
            kind='healthstate',
            gbd_id=hs_id(572),
        ),
    ),
})
