"""Mapping of GBD causes.

This code is automatically generated by gbd_mapping_generator/cause_builder.py

Any manual changes will be lost.
"""
from .id import c_id, me_id, UNKNOWN
from .base_template import Restrictions
from .cause_template import Cause, Causes
from .sequela import sequelae
from .etiology import etiologies


causes = Causes(**{
    'all_causes': Cause(
        name='all_causes',
        kind='cause',
        gbd_id=c_id(294),
        me_id=UNKNOWN,
        level=0,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'communicable_maternal_neonatal_and_nutritional_diseases': Cause(
        name='communicable_maternal_neonatal_and_nutritional_diseases',
        kind='cause',
        gbd_id=c_id(295),
        me_id=UNKNOWN,
        level=1,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'tuberculosis': Cause(
        name='tuberculosis',
        kind='cause',
        gbd_id=c_id(297),
        me_id=me_id(1175),
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'hiv_aids': Cause(
        name='hiv_aids',
        kind='cause',
        gbd_id=c_id(298),
        me_id=me_id(9368),
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'hiv_aids_resulting_in_other_diseases': Cause(
        name='hiv_aids_resulting_in_other_diseases',
        kind='cause',
        gbd_id=c_id(300),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.early_hiv_with_mild_anemia, sequelae.early_hiv_with_moderate_anemia, 
                  sequelae.early_hiv_with_severe_anemia, sequelae.early_hiv_without_anemia, 
                  sequelae.symptomatic_hiv_with_mild_anemia, sequelae.symptomatic_hiv_with_moderate_anemia, 
                  sequelae.symptomatic_hiv_with_severe_anemia, sequelae.symptomatic_hiv_without_anemia, 
                  sequelae.hiv_aids_with_antiretroviral_treatment_with_mild_anemia, 
                  sequelae.hiv_aids_with_antiretroviral_treatment_with_moderate_anemia, 
                  sequelae.hiv_aids_with_antiretroviral_treatment_with_severe_anemia, 
                  sequelae.hiv_aids_with_antiretroviral_treatment_without_anemia, sequelae.aids_with_mild_anemia, 
                  sequelae.aids_with_moderate_anemia, sequelae.aids_with_severe_anemia, sequelae.aids_without_anemia, ),
        etiologies=(),
    ),
    'diarrheal_diseases': Cause(
        name='diarrheal_diseases',
        kind='cause',
        gbd_id=c_id(302),
        me_id=me_id(1181),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_diarrheal_diseases, sequelae.moderate_diarrheal_diseases, 
                  sequelae.severe_diarrheal_diseases, sequelae.guillain_barre_syndrome_due_to_diarrheal_diseases, ),
        etiologies=(etiologies.cholera, etiologies.non_typhoidal_salmonella, etiologies.shigella, 
                    etiologies.enteropathogenic_e_coli, etiologies.enterotoxigenic_e_coli, etiologies.campylobacter, 
                    etiologies.entamoeba, etiologies.cryptosporidium, etiologies.rotavirus, etiologies.aeromonas, 
                    etiologies.clostridium_difficile, etiologies.norovirus, etiologies.adenovirus, ),
    ),
    'typhoid_fever': Cause(
        name='typhoid_fever',
        kind='cause',
        gbd_id=c_id(319),
        me_id=me_id(1247),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.acute_typhoid_infection, sequelae.severe_typhoid_fever, 
                  sequelae.intestinal_perforation_due_to_typhoid, sequelae.gastrointestinal_bleeding_due_to_typhoid, ),
        etiologies=(),
    ),
    'paratyphoid_fever': Cause(
        name='paratyphoid_fever',
        kind='cause',
        gbd_id=c_id(320),
        me_id=me_id(1252),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.acute_paratyphoid_infection, sequelae.moderate_paratyphoid_fever, 
                  sequelae.severe_paratyphoid_fever, sequelae.intestinal_perforation_due_to_paratyphoid, ),
        etiologies=(),
    ),
    'other_intestinal_infectious_diseases': Cause(
        name='other_intestinal_infectious_diseases',
        kind='cause',
        gbd_id=c_id(321),
        me_id=me_id(1257),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=4,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.other_intestinal_infectious_diseases, ),
        etiologies=(),
    ),
    'lower_respiratory_infections': Cause(
        name='lower_respiratory_infections',
        kind='cause',
        gbd_id=c_id(322),
        me_id=me_id(1258),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_lower_respiratory_infections, sequelae.severe_lower_respiratory_infections, 
                  sequelae.guillain_barre_syndrome_due_to_lower_respiratory_infections, ),
        etiologies=(etiologies.influenza, etiologies.pneumococcus, etiologies.h_influenzae_type_b, 
                    etiologies.respiratory_syncytial_virus, ),
    ),
    'upper_respiratory_infections': Cause(
        name='upper_respiratory_infections',
        kind='cause',
        gbd_id=c_id(328),
        me_id=me_id(1276),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_upper_respiratory_infections, sequelae.moderate_upper_respiratory_infections, 
                  sequelae.guillain_barre_syndrome_due_to_upper_respiratory_infections, ),
        etiologies=(),
    ),
    'otitis_media': Cause(
        name='otitis_media',
        kind='cause',
        gbd_id=c_id(329),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.acute_otitis_media, sequelae.severe_infectious_complications_due_to_chronic_otitis_media, 
                  sequelae.vertigo_with_mild_hearing_loss_due_to_chronic_otitis_media, 
                  sequelae.vertigo_with_mild_hearing_loss_and_ringing_due_to_chronic_otitis_media, 
                  sequelae.mild_hearing_loss_due_to_chronic_otitis_media, 
                  sequelae.mild_hearing_loss_with_ringing_due_to_chronic_otitis_media, 
                  sequelae.vertigo_with_moderate_hearing_loss_due_to_chronic_otitis_media, 
                  sequelae.vertigo_with_moderate_hearing_loss_and_ringing_due_to_chronic_otitis_media, 
                  sequelae.moderate_hearing_loss_due_to_chronic_otitis_media, 
                  sequelae.moderate_hearing_loss_with_ringing_due_to_chronic_otitis_media, ),
        etiologies=(),
    ),
    'meningitis': Cause(
        name='meningitis',
        kind='cause',
        gbd_id=c_id(332),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.acute_viral_meningitis, sequelae.mild_motor_plus_cognitive_impairments_due_to_meningitis, 
                  sequelae.moderately_severe_hearing_loss_due_to_meningitis, 
                  sequelae.profound_hearing_loss_with_ringing_due_to_meningitis, 
                  sequelae.moderate_motor_impairment_due_to_meningitis, sequelae.blindness_due_to_meningitis, 
                  sequelae.moderate_hearing_loss_with_ringing_due_to_meningitis, 
                  sequelae.profound_hearing_loss_due_to_meningitis, 
                  sequelae.mild_intellectual_disability_due_to_meningitis, sequelae.epilepsy_due_to_meningitis, 
                  sequelae.moderate_hearing_loss_due_to_meningitis, 
                  sequelae.severe_hearing_loss_with_ringing_due_to_meningitis, 
                  sequelae.borderline_intellectual_disability_due_to_meningitis, 
                  sequelae.monocular_distance_vision_loss_due_to_meningitis, 
                  sequelae.severe_motor_plus_cognitive_impairments_due_to_meningitis, 
                  sequelae.mild_hearing_loss_with_ringing_due_to_meningitis, 
                  sequelae.mild_motor_impairment_due_to_long_term_due_to_meningitis, 
                  sequelae.mild_behavioral_problems_due_to_meningitis, 
                  sequelae.severe_hearing_loss_due_to_meningitis, 
                  sequelae.complete_hearing_loss_with_ringing_due_to_meningitis, 
                  sequelae.moderate_motor_plus_cognitive_impairments_due_to_meningitis, 
                  sequelae.mild_hearing_loss_due_to_meningitis, sequelae.acute_meningitis, 
                  sequelae.moderately_severe_hearing_loss_with_ringing_due_to_meningitis, 
                  sequelae.complete_hearing_loss_due_to_meningitis, 
                  sequelae.severe_motor_impairment_due_to_meningitis, 
                  sequelae.moderate_vision_impairment_due_to_meningitis, 
                  sequelae.severe_vision_impairment_due_to_meningitis, ),
        etiologies=(),
    ),
    'encephalitis': Cause(
        name='encephalitis',
        kind='cause',
        gbd_id=c_id(337),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.acute_encephalitis, sequelae.mild_behavioral_problems_due_to_encephalitis, 
                  sequelae.mild_motor_impairment_due_to_long_term_due_to_encephalitis, 
                  sequelae.mild_motor_plus_cognitive_impairments_due_to_encephalitis, 
                  sequelae.borderline_intellectual_disability_due_to_encephalitis, 
                  sequelae.monocular_distance_vision_loss_due_to_encephalitis, 
                  sequelae.mild_intellectual_disability_due_to_encephalitis, 
                  sequelae.moderate_motor_impairment_due_to_encephalitis, 
                  sequelae.severe_motor_impairment_due_to_encephalitis, 
                  sequelae.moderate_motor_plus_cognitive_impairments_due_to_encephalitis, 
                  sequelae.severe_motor_plus_cognitive_impairments_due_to_encephalitis, 
                  sequelae.epilepsy_due_to_encephalitis, sequelae.blindness_due_to_encephalitis, 
                  sequelae.moderate_vision_impairment_due_to_encephalitis, 
                  sequelae.severe_vision_impairment_due_to_encephalitis, ),
        etiologies=(),
    ),
    'diphtheria': Cause(
        name='diphtheria',
        kind='cause',
        gbd_id=c_id(338),
        me_id=me_id(1421),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=15,
            yld_age_group_id_start=4,
            yld_age_group_id_end=15,
        ),
        sequelae=(sequelae.moderate_diphtheria, sequelae.severe_diphtheria, ),
        etiologies=(),
    ),
    'whooping_cough': Cause(
        name='whooping_cough',
        kind='cause',
        gbd_id=c_id(339),
        me_id=me_id(1424),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=15,
            yld_age_group_id_start=4,
            yld_age_group_id_end=15,
        ),
        sequelae=(sequelae.whooping_cough, ),
        etiologies=(),
    ),
    'tetanus': Cause(
        name='tetanus',
        kind='cause',
        gbd_id=c_id(340),
        me_id=me_id(1425),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.severe_tetanus, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_tetanus, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_tetanus, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_tetanus, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_tetanus, 
                  sequelae.moderate_motor_impairment_due_to_neonatal_tetanus, 
                  sequelae.moderate_motor_impairment_with_blindness_due_to_neonatal_tetanus, 
                  sequelae.moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus, 
                  sequelae.moderate_motor_impairment_with_epilepsy_due_to_neonatal_tetanus, 
                  sequelae.severe_motor_impairment_due_to_neonatal_tetanus, 
                  sequelae.severe_motor_impairment_with_blindness_due_to_neonatal_tetanus, 
                  sequelae.severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_tetanus, 
                  sequelae.severe_motor_impairment_with_epilepsy_due_to_neonatal_tetanus, 
                  sequelae.mild_motor_impairment_due_to_neonatal_tetanus, 
                  sequelae.mild_motor_plus_cognitive_impairments_due_to_neonatal_tetanus, ),
        etiologies=(),
    ),
    'measles': Cause(
        name='measles',
        kind='cause',
        gbd_id=c_id(341),
        me_id=me_id(1436),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=15,
            yld_age_group_id_start=4,
            yld_age_group_id_end=15,
        ),
        sequelae=(sequelae.moderate_measles, sequelae.severe_measles, ),
        etiologies=(),
    ),
    'varicella_and_herpes_zoster': Cause(
        name='varicella_and_herpes_zoster',
        kind='cause',
        gbd_id=c_id(342),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.chickenpox, sequelae.herpes_zoster, ),
        etiologies=(),
    ),
    'neglected_tropical_diseases_and_malaria': Cause(
        name='neglected_tropical_diseases_and_malaria',
        kind='cause',
        gbd_id=c_id(344),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'malaria': Cause(
        name='malaria',
        kind='cause',
        gbd_id=c_id(345),
        me_id=me_id(3055),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_malaria, sequelae.moderate_malaria, sequelae.severe_malaria, 
                  sequelae.moderate_motor_impairment_due_to_malaria, 
                  sequelae.moderate_motor_impairment_with_blindness_due_to_malaria, 
                  sequelae.moderate_motor_impairment_with_epilepsy_due_to_malaria, 
                  sequelae.moderate_motor_impairment_with_blindness_and_epilepsy_due_to_malaria, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_blindness_due_to_malaria, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_malaria, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_malaria, 
                  sequelae.severe_motor_impairment_due_to_malaria, 
                  sequelae.severe_motor_impairment_with_blindness_due_to_malaria, 
                  sequelae.severe_motor_impairment_with_epilepsy_due_to_malaria, 
                  sequelae.severe_motor_impairment_with_blindness_and_epilepsy_due_to_malaria, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_blindness_due_to_malaria, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_malaria, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_malaria, 
                  sequelae.asymptomatic_malaria_parasitemia_pfpr, 
                  sequelae.mild_anemia_due_to_malaria_parasitemia_pfpr, 
                  sequelae.moderate_anemia_due_to_malaria_parasitemia_pfpr, 
                  sequelae.severe_anemia_due_to_malaria_parasitemia_pfpr, sequelae.severe_malaria_with_mild_anemia, 
                  sequelae.severe_malaria_with_moderate_anemia, sequelae.severe_malaria_with_severe_anemia, 
                  sequelae.mild_malaria_with_mild_anemia, sequelae.mild_malaria_with_moderate_anemia, 
                  sequelae.mild_malaria_with_severe_anemia, sequelae.moderate_malaria_with_mild_anemia, 
                  sequelae.moderate_malaria_with_moderate_anemia, sequelae.moderate_malaria_with_severe_anemia, 
                  sequelae.mild_anemia_due_to_malaria_vivax_pvpr, sequelae.moderate_anemia_due_to_malaria_vivax_pvpr, 
                  sequelae.severe_anemia_due_to_malaria_vivax_pvpr, sequelae.asymptomatic_malaria_vivax_pvpr, ),
        etiologies=(),
    ),
    'chagas_disease': Cause(
        name='chagas_disease',
        kind='cause',
        gbd_id=c_id(346),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.acute_chagas_disease, sequelae.atrial_fibrillation_and_flutter_due_to_chagas_disease, 
                  sequelae.mild_chronic_digestive_disease_due_to_chagas_disease, 
                  sequelae.moderate_chronic_digestive_disease_due_to_chagas_disease, 
                  sequelae.mild_heart_failure_due_to_chagas_disease, 
                  sequelae.moderate_heart_failure_due_to_chagas_disease, 
                  sequelae.severe_heart_failure_due_to_chagas_disease, sequelae.asymptomatic_chagas_disease, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_chagas_disease, ),
        etiologies=(),
    ),
    'leishmaniasis': Cause(
        name='leishmaniasis',
        kind='cause',
        gbd_id=c_id(347),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=4,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'visceral_leishmaniasis': Cause(
        name='visceral_leishmaniasis',
        kind='cause',
        gbd_id=c_id(348),
        me_id=me_id(1458),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=4,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_visceral_leishmaniasis, sequelae.severe_visceral_leishmaniasis, ),
        etiologies=(),
    ),
    'cutaneous_and_mucocutaneous_leishmaniasis': Cause(
        name='cutaneous_and_mucocutaneous_leishmaniasis',
        kind='cause',
        gbd_id=c_id(349),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=4,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.cutaneous_and_mucocutaneous_leishmaniasis, ),
        etiologies=(),
    ),
    'african_trypanosomiasis': Cause(
        name='african_trypanosomiasis',
        kind='cause',
        gbd_id=c_id(350),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.skin_disfigurement_due_to_trypanosoma_brucei_gambiense, 
                  sequelae.sleeping_sickness_due_to_trypanosoma_brucei_gambiense, 
                  sequelae.sleeping_sickness_due_to_trypanosoma_brucei_rhodesiense, 
                  sequelae.skin_disfigurement_due_to_trypanosoma_brucei_rhodesiense, ),
        etiologies=(),
    ),
    'schistosomiasis': Cause(
        name='schistosomiasis',
        kind='cause',
        gbd_id=c_id(351),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=4,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_schistosomiasis, sequelae.mild_diarrhea_due_to_schistosomiasis, 
                  sequelae.hematemesis_due_to_schistosomiasis, sequelae.hepatomegaly_due_to_schistosomiasis, 
                  sequelae.ascites_due_to_schistosomiasis, sequelae.dysuria_due_to_schistosomiasis, 
                  sequelae.bladder_pathology_due_to_schistosomiasis, sequelae.hydronephrosis_due_to_schistosomiasis, 
                  sequelae.mild_anemia_due_to_schistosomiasis, sequelae.moderate_anemia_due_to_schistosomiasis, 
                  sequelae.severe_anemia_due_to_schistosomiasis, ),
        etiologies=(),
    ),
    'cysticercosis': Cause(
        name='cysticercosis',
        kind='cause',
        gbd_id=c_id(352),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.neurocysticercosis_with_epilepsy, ),
        etiologies=(),
    ),
    'cystic_echinococcosis': Cause(
        name='cystic_echinococcosis',
        kind='cause',
        gbd_id=c_id(353),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.abdominal_problems_due_to_cystic_echinococcosis, 
                  sequelae.chronic_respiratory_disease_due_to_cystic_echinococcosis, 
                  sequelae.epilepsy_due_to_echinococcosis, ),
        etiologies=(),
    ),
    'lymphatic_filariasis': Cause(
        name='lymphatic_filariasis',
        kind='cause',
        gbd_id=c_id(354),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.prevalence_of_detectable_microfiliaria_due_to_lymphatic_filariasis, 
                  sequelae.lymphedema_due_to_lymphatic_filariasis, sequelae.hydrocele_due_to_lymphatic_filariasis, 
                  sequelae.acute_adenolymphangitis_due_to_lymphatic_filariasis, ),
        etiologies=(),
    ),
    'onchocerciasis': Cause(
        name='onchocerciasis',
        kind='cause',
        gbd_id=c_id(355),
        me_id=me_id(1494),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_skin_disease_due_to_onchocerciasis, 
                  sequelae.moderate_skin_disease_due_to_onchocerciasis, 
                  sequelae.severe_skin_disease_due_to_onchocerciasis, 
                  sequelae.mild_skin_disease_without_itch_due_to_onchocerciasis, 
                  sequelae.severe_skin_disease_without_itch_due_to_onchocerciasis, 
                  sequelae.blindness_due_to_onchocerciasis, 
                  sequelae.moderate_vision_impairment_due_to_onchocerciasis, 
                  sequelae.severe_vision_impairment_due_to_onchocerciasis, sequelae.asymptomatic_onchocerciasis, ),
        etiologies=(),
    ),
    'trachoma': Cause(
        name='trachoma',
        kind='cause',
        gbd_id=c_id(356),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_vision_impairment_due_to_trachoma, 
                  sequelae.severe_vision_impairment_due_to_trachoma, sequelae.blindness_due_to_trachoma, ),
        etiologies=(),
    ),
    'dengue': Cause(
        name='dengue',
        kind='cause',
        gbd_id=c_id(357),
        me_id=me_id(1505),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=3,
            yll_age_group_id_end=235,
            yld_age_group_id_start=3,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_dengue, sequelae.severe_dengue, sequelae.post_dengue_chronic_fatigue_syndrome, ),
        etiologies=(),
    ),
    'yellow_fever': Cause(
        name='yellow_fever',
        kind='cause',
        gbd_id=c_id(358),
        me_id=me_id(1509),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=3,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_yellow_fever, sequelae.severe_yellow_fever, sequelae.asymptomatic_yellow_fever, ),
        etiologies=(),
    ),
    'rabies': Cause(
        name='rabies',
        kind='cause',
        gbd_id=c_id(359),
        me_id=me_id(1512),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=4,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.rabies, ),
        etiologies=(),
    ),
    'intestinal_nematode_infections': Cause(
        name='intestinal_nematode_infections',
        kind='cause',
        gbd_id=c_id(360),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=4,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'ascariasis': Cause(
        name='ascariasis',
        kind='cause',
        gbd_id=c_id(361),
        me_id=me_id(23667),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=4,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.heavy_infestation_of_ascariasis, sequelae.mild_abdominopelvic_problems_due_to_ascariasis, 
                  sequelae.severe_wasting_due_to_ascariasis, sequelae.asymptomatic_ascariasis, ),
        etiologies=(),
    ),
    'trichuriasis': Cause(
        name='trichuriasis',
        kind='cause',
        gbd_id=c_id(362),
        me_id=me_id(23668),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=4,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.heavy_infestation_of_trichuriasis, 
                  sequelae.mild_abdominopelvic_problems_due_to_trichuriasis, 
                  sequelae.severe_wasting_due_to_trichuriasis, sequelae.asymptomatic_trichuriasis, ),
        etiologies=(),
    ),
    'hookworm_disease': Cause(
        name='hookworm_disease',
        kind='cause',
        gbd_id=c_id(363),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=4,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.heavy_infestation_of_hookworm, 
                  sequelae.mild_abdominopelvic_problems_due_to_hookworm_disease, 
                  sequelae.severe_wasting_due_to_hookworm_disease, sequelae.mild_anemia_due_to_hookworm_disease, 
                  sequelae.moderate_anemia_due_to_hookworm_disease, sequelae.severe_anemia_due_to_hookworm_disease, 
                  sequelae.asymptomatic_hookworm_disease, ),
        etiologies=(),
    ),
    'food_borne_trematodiases': Cause(
        name='food_borne_trematodiases',
        kind='cause',
        gbd_id=c_id(364),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.cerebral_paragonimiasis, sequelae.heavy_clonorchiasis_due_to_food_borne_trematodiases, 
                  sequelae.heavy_fascioliasis_due_to_food_borne_trematodiases, 
                  sequelae.heavy_intestinal_fluke_infection_due_to_food_borne_trematodiases, 
                  sequelae.heavy_opisthorchiasis_due_to_food_borne_trematodiases, 
                  sequelae.asymptomatic_clonorchiasis, sequelae.asymptomatic_fascioliasis, 
                  sequelae.asymptomatic_intestinal_fluke_infection, sequelae.asymptomatic_opisthorchiasis, 
                  sequelae.asymptomatic_paragonimiasis, sequelae.mild_paragonimiasis_due_to_food_borne_trematodiases, 
                  sequelae.moderate_paragonimiasis_due_to_food_borne_trematodiases, 
                  sequelae.severe_paragonimiasis_due_to_food_borne_trematodiases, ),
        etiologies=(),
    ),
    'other_neglected_tropical_diseases': Cause(
        name='other_neglected_tropical_diseases',
        kind='cause',
        gbd_id=c_id(365),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.acute_infection_due_to_other_neglected_tropical_diseases, 
                  sequelae.mild_anemia_due_to_other_neglected_tropical_diseases, 
                  sequelae.moderate_anemia_due_to_other_neglected_tropical_diseases, 
                  sequelae.severe_anemia_due_to_other_neglected_tropical_diseases, ),
        etiologies=(),
    ),
    'maternal_disorders': Cause(
        name='maternal_disorders',
        kind='cause',
        gbd_id=c_id(366),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=14,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'maternal_hemorrhage': Cause(
        name='maternal_hemorrhage',
        kind='cause',
        gbd_id=c_id(367),
        me_id=me_id(1535),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=14,
            yld_age_group_id_start=7,
            yld_age_group_id_end=14,
        ),
        sequelae=(sequelae.maternal_hemorrhage_less_than__1l_blood_lost, 
                  sequelae.maternal_hemorrhage_greater_than__1l_blood_lost, 
                  sequelae.mild_anemia_due_to_maternal_hemorrhage, 
                  sequelae.moderate_anemia_due_to_maternal_hemorrhage, 
                  sequelae.severe_anemia_due_to_maternal_hemorrhage, ),
        etiologies=(),
    ),
    'maternal_sepsis_and_other_maternal_infections': Cause(
        name='maternal_sepsis_and_other_maternal_infections',
        kind='cause',
        gbd_id=c_id(368),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=14,
            yld_age_group_id_start=7,
            yld_age_group_id_end=14,
        ),
        sequelae=(sequelae.infertility_due_to_puerperal_sepsis, sequelae.puerperal_sepsis, 
                  sequelae.other_maternal_infections, ),
        etiologies=(),
    ),
    'maternal_hypertensive_disorders': Cause(
        name='maternal_hypertensive_disorders',
        kind='cause',
        gbd_id=c_id(369),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=14,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.severe_pre_eclampsia, sequelae.eclampsia, 
                  sequelae.long_term_sequelae_of_severe_pre_eclampsia, 
                  sequelae.other_hypertensive_disorders_of_pregnancy, sequelae.long_term_sequelae_of_eclampsia, ),
        etiologies=(),
    ),
    'maternal_obstructed_labor_and_uterine_rupture': Cause(
        name='maternal_obstructed_labor_and_uterine_rupture',
        kind='cause',
        gbd_id=c_id(370),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=14,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.obstructed_labor_acute_event, sequelae.rectovaginal_fistula, 
                  sequelae.vesicovaginal_fistula, ),
        etiologies=(),
    ),
    'ectopic_pregnancy': Cause(
        name='ectopic_pregnancy',
        kind='cause',
        gbd_id=c_id(374),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=14,
            yld_age_group_id_start=7,
            yld_age_group_id_end=14,
        ),
        sequelae=(sequelae.ectopic_pregnancy, ),
        etiologies=(),
    ),
    'indirect_maternal_deaths': Cause(
        name='indirect_maternal_deaths',
        kind='cause',
        gbd_id=c_id(375),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=True,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=14,
            yld_age_group_id_start=None,
            yld_age_group_id_end=None,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'late_maternal_deaths': Cause(
        name='late_maternal_deaths',
        kind='cause',
        gbd_id=c_id(376),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=True,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=14,
            yld_age_group_id_start=None,
            yld_age_group_id_end=None,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'other_maternal_disorders': Cause(
        name='other_maternal_disorders',
        kind='cause',
        gbd_id=c_id(379),
        me_id=me_id(1556),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=14,
            yld_age_group_id_start=7,
            yld_age_group_id_end=14,
        ),
        sequelae=(sequelae.other_maternal_disorders, ),
        etiologies=(),
    ),
    'neonatal_disorders': Cause(
        name='neonatal_disorders',
        kind='cause',
        gbd_id=c_id(380),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=4,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'neonatal_preterm_birth': Cause(
        name='neonatal_preterm_birth',
        kind='cause',
        gbd_id=c_id(381),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=4,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_vision_impairment_due_to_retinopathy_of_prematurity, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks, 
                  sequelae.moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks, 
                  sequelae.moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks, 
                  sequelae.moderate_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks, 
                  sequelae.moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks, 
                  sequelae.moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks, 
                  sequelae.moderate_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks, 
                  sequelae.moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks, 
                  sequelae.moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks, 
                  sequelae.moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks, 
                  sequelae.moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks, 
                  sequelae.moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks, 
                  sequelae.moderate_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks, 
                  sequelae.severe_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks, 
                  sequelae.severe_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks, 
                  sequelae.severe_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks, 
                  sequelae.severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_28_32wks, 
                  sequelae.severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_less_than_28wks, 
                  sequelae.severe_motor_impairment_with_blindness_due_to_neonatal_preterm_birth_complications_32_36wks, 
                  sequelae.severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks, 
                  sequelae.severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks, 
                  sequelae.severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks, 
                  sequelae.severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_32_36wks, 
                  sequelae.severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_less_than_28wks, 
                  sequelae.severe_motor_impairment_with_epilepsy_due_to_neonatal_preterm_birth_complications_28_32wks, 
                  sequelae.asymptomatic_retinopathy_of_prematurity, 
                  sequelae.blindness_due_to_retinopathy_of_prematurity, 
                  sequelae.mild_motor_impairment_due_to_neonatal_preterm_birth_complications_less_than_28wks, 
                  sequelae.mild_motor_impairment_due_to_neonatal_preterm_birth_complications_28_32wks, 
                  sequelae.mild_motor_impairment_due_to_neonatal_preterm_birth_complications_32_36wks, 
                  sequelae.mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_less_than_28wks, 
                  sequelae.mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_28_32wks, 
                  sequelae.mild_motor_plus_cognitive_impairments_due_to_neonatal_preterm_birth_complications_32_36wks, 
                  sequelae.moderate_vision_impairment_due_to_retinopathy_of_prematurity, 
                  sequelae.severe_vision_impairment_due_to_retinopathy_of_prematurity, 
                  sequelae.asymptomatic_neonatal_preterm_birth_less_than_28_weeks, 
                  sequelae.asymptomatic_neonatal_preterm_birth_28_less_than_32_wks, 
                  sequelae.asymptomatic_neonatal_preterm_birth_32_less_than_37wks, ),
        etiologies=(),
    ),
    'neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma': Cause(
        name='neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma',
        kind='cause',
        gbd_id=c_id(382),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=4,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_motor_plus_cognitive_impairments_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                  sequelae.mild_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                  sequelae.moderate_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                  sequelae.moderate_motor_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                  sequelae.moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                  sequelae.moderate_motor_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                  sequelae.severe_motor_impairment_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                  sequelae.severe_motor_impairment_with_blindness_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                  sequelae.severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                  sequelae.severe_motor_impairment_with_epilepsy_due_to_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, 
                  sequelae.asymptomatic_neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma, ),
        etiologies=(),
    ),
    'neonatal_sepsis_and_other_neonatal_infections': Cause(
        name='neonatal_sepsis_and_other_neonatal_infections',
        kind='cause',
        gbd_id=c_id(383),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=4,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.asymptomatic_neonatal_sepsis_and_other_neonatal_infections, 
                  sequelae.mild_motor_plus_cognitive_impairments_due_to_neonatal_sepsis_and_other_neonatal_infections, 
                  sequelae.mild_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections, 
                  sequelae.moderate_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections, 
                  sequelae.moderate_motor_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections, 
                  sequelae.moderate_motor_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections, 
                  sequelae.moderate_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections, 
                  sequelae.severe_motor_impairment_due_to_neonatal_sepsis_and_other_neonatal_infections, 
                  sequelae.severe_motor_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections, 
                  sequelae.severe_motor_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections, 
                  sequelae.severe_motor_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_blindness_due_to_neonatal_sepsis_and_other_neonatal_infections, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_neonatal_sepsis_and_other_neonatal_infections, ),
        etiologies=(),
    ),
    'hemolytic_disease_and_other_neonatal_jaundice': Cause(
        name='hemolytic_disease_and_other_neonatal_jaundice',
        kind='cause',
        gbd_id=c_id(384),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=4,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_motor_plus_cognitive_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice, 
                  sequelae.moderate_motor_plus_cognitive_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice, 
                  sequelae.severe_motor_plus_cognitive_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice, 
                  sequelae.moderate_motor_impairment_due_to_hemolytic_disease_and_other_neonatal_jaundice, 
                  sequelae.moderate_motor_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice, 
                  sequelae.moderate_motor_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice, 
                  sequelae.moderate_motor_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice, 
                  sequelae.severe_motor_impairment_severe_due_to_hemolytic_disease_and_other_neonatal_jaundice, 
                  sequelae.severe_motor_impairment_with_blindness_due_to_hemolytic_disease_and_other_neonatal_jaundice, 
                  sequelae.severe_motor_impairment_with_blindness_and_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice, 
                  sequelae.severe_motor_impairment_with_epilepsy_due_to_hemolytic_disease_and_other_neonatal_jaundice, 
                  sequelae.extreme_hyperbilirubinemia_due_to_hemolytic_disease_and_other_neonatal_jaundice_without_kernicterus, ),
        etiologies=(),
    ),
    'other_neonatal_disorders': Cause(
        name='other_neonatal_disorders',
        kind='cause',
        gbd_id=c_id(385),
        me_id=me_id(1605),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=4,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.other_neonatal_disorders, ),
        etiologies=(),
    ),
    'nutritional_deficiencies': Cause(
        name='nutritional_deficiencies',
        kind='cause',
        gbd_id=c_id(386),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'protein_energy_malnutrition': Cause(
        name='protein_energy_malnutrition',
        kind='cause',
        gbd_id=c_id(387),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_wasting_with_edema, sequelae.severe_wasting_without_edema, 
                  sequelae.moderate_wasting_without_edema, sequelae.severe_wasting_with_edema, ),
        etiologies=(),
    ),
    'iodine_deficiency': Cause(
        name='iodine_deficiency',
        kind='cause',
        gbd_id=c_id(388),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.visible_goiter_without_symptoms, 
                  sequelae.visible_goiter_with_severe_intellectual_disability_due_to_iodine_deficiency, 
                  sequelae.visible_goiter_with_profound_intellectual_disability_due_to_iodine_deficiency, ),
        etiologies=(),
    ),
    'vitamin_a_deficiency': Cause(
        name='vitamin_a_deficiency',
        kind='cause',
        gbd_id=c_id(389),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_vision_impairment_loss_due_to_vitamin_a_deficiency, 
                  sequelae.severe_vision_impairment_loss_due_to_vitamin_a_deficiency, 
                  sequelae.blindness_due_to_vitamin_a_deficiency, sequelae.asymptomatic_vitamin_a_deficiency, 
                  sequelae.vitamin_a_deficiency_with_mild_anemia, sequelae.vitamin_a_deficiency_with_moderate_anemia, 
                  sequelae.vitamin_a_deficiency_with_severe_anemia, ),
        etiologies=(),
    ),
    'dietary_iron_deficiency': Cause(
        name='dietary_iron_deficiency',
        kind='cause',
        gbd_id=c_id(390),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_iron_deficiency_anemia, sequelae.moderate_iron_deficiency_anemia, 
                  sequelae.severe_iron_deficiency_anemia, ),
        etiologies=(),
    ),
    'other_nutritional_deficiencies': Cause(
        name='other_nutritional_deficiencies',
        kind='cause',
        gbd_id=c_id(391),
        me_id=me_id(1627),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=4,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.other_nutritional_deficiencies, ),
        etiologies=(),
    ),
    'sexually_transmitted_infections_excluding_hiv': Cause(
        name='sexually_transmitted_infections_excluding_hiv',
        kind='cause',
        gbd_id=c_id(393),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'syphilis': Cause(
        name='syphilis',
        kind='cause',
        gbd_id=c_id(394),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.asymptomatic_early_syphilis_infection, sequelae.mild_early_syphilis_infection, 
                  sequelae.neurological_problems_and_cardiovascular_complications_due_to_adult_tertiary_syphilis, 
                  sequelae.severe_disfigurement_and_cardiovascular_complications_due_to_adult_tertiary_syphilis, 
                  sequelae.severe_disfigurement_and_neurological_problems_due_to_adult_tertiary_syphilis, 
                  sequelae.severe_disfigurement_neurological_problems_and_cardiovascular_complications_due_to_adult_tertiary_syphilis, 
                  sequelae.severe_disfigurement_due_to_adult_tertiary_syphilis, 
                  sequelae.neurological_problems_due_to_adult_tertiary_syphilis, 
                  sequelae.cardiovascular_complications_due_to_adult_tertiary_syphilis, 
                  sequelae.asymptomatic_adult_tertiary_syphilis, ),
        etiologies=(),
    ),
    'chlamydial_infection': Cause(
        name='chlamydial_infection',
        kind='cause',
        gbd_id=c_id(395),
        me_id=me_id(1629),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.epididymo_orchitis_due_to_chlamydial_infection, 
                  sequelae.moderate_pelvic_inflammatory_diseases_due_to_chlamydial_infection, 
                  sequelae.severe_pelvic_inflammatory_diseases_due_to_chlamydial_infection, 
                  sequelae.primary_infertility_due_to_chlamydial_infection, 
                  sequelae.secondary_infertility_due_to_chlamydial_infection, sequelae.mild_chlamydial_infection, 
                  sequelae.asymptomatic_chlamydial_infection, ),
        etiologies=(),
    ),
    'gonococcal_infection': Cause(
        name='gonococcal_infection',
        kind='cause',
        gbd_id=c_id(396),
        me_id=me_id(1635),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.epididymo_orchitis_due_to_gonococcal_infection, 
                  sequelae.moderate_pelvic_inflammatory_diseases_due_to_gonococcal_infection, 
                  sequelae.severe_pelvic_inflammatory_diseases_due_to_gonococcal_infection, 
                  sequelae.primary_infertility_due_to_gonococcal_infection, 
                  sequelae.secondary_infertility_due_to_gonococcal_infection, sequelae.mild_gonococcal_infection, 
                  sequelae.asymptomatic_gonococcal_infection, ),
        etiologies=(),
    ),
    'trichomoniasis': Cause(
        name='trichomoniasis',
        kind='cause',
        gbd_id=c_id(397),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.acute_trichomoniasis_infection, sequelae.asymptomatic_trichomoniasis_infection, ),
        etiologies=(),
    ),
    'genital_herpes': Cause(
        name='genital_herpes',
        kind='cause',
        gbd_id=c_id(398),
        me_id=me_id(1642),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.symptomatic_genital_herpes, sequelae.asymptomatic_genital_herpes, 
                  sequelae.moderate_infection_due_to_initial_genital_herpes_episode, ),
        etiologies=(),
    ),
    'other_sexually_transmitted_infections': Cause(
        name='other_sexually_transmitted_infections',
        kind='cause',
        gbd_id=c_id(399),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_pelvic_inflammatory_diseases_due_to_other_sexually_transmitted_diseases, 
                  sequelae.severe_pelvic_inflammatory_diseases_due_to_other_sexually_transmitted_diseases, 
                  sequelae.primary_infertility_due_to_other_sexually_transmitted_diseases, 
                  sequelae.secondary_infertility_due_to_other_sexually_transmitted_diseases, 
                  sequelae.other_sexually_transmitted_diseases_residual, ),
        etiologies=(),
    ),
    'acute_hepatitis': Cause(
        name='acute_hepatitis',
        kind='cause',
        gbd_id=c_id(400),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'acute_hepatitis_a': Cause(
        name='acute_hepatitis_a',
        kind='cause',
        gbd_id=c_id(401),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_acute_hepatitis_a, sequelae.severe_acute_hepatitis_a, 
                  sequelae.asymptomatic_acute_hepatitis_a, ),
        etiologies=(),
    ),
    'acute_hepatitis_b': Cause(
        name='acute_hepatitis_b',
        kind='cause',
        gbd_id=c_id(402),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_acute_hepatitis_b, sequelae.severe_acute_hepatitis_b, 
                  sequelae.asymptomatic_acute_hepatitis_b, ),
        etiologies=(),
    ),
    'acute_hepatitis_c': Cause(
        name='acute_hepatitis_c',
        kind='cause',
        gbd_id=c_id(403),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_acute_hepatitis_c, sequelae.severe_acute_hepatitis_c, 
                  sequelae.asymptomatic_acute_hepatitis_c, ),
        etiologies=(),
    ),
    'acute_hepatitis_e': Cause(
        name='acute_hepatitis_e',
        kind='cause',
        gbd_id=c_id(404),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_acute_hepatitis_e, sequelae.severe_acute_hepatitis_e, 
                  sequelae.asymptomatic_acute_hepatitis_e, ),
        etiologies=(),
    ),
    'leprosy': Cause(
        name='leprosy',
        kind='cause',
        gbd_id=c_id(405),
        me_id=me_id(1662),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.disfigurement_level_1_due_to_leprosy, sequelae.disfigurement_level_2_due_to_leprosy, ),
        etiologies=(),
    ),
    'other_unspecified_infectious_diseases': Cause(
        name='other_unspecified_infectious_diseases',
        kind='cause',
        gbd_id=c_id(408),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_anemia_due_to_other_infectious_diseases, 
                  sequelae.moderate_anemia_due_to_other_infectious_diseases, 
                  sequelae.severe_anemia_due_to_other_infectious_diseases, 
                  sequelae.guillain_barre_syndrome_due_to_other_infectious_diseases, 
                  sequelae.other_infectious_diseases, ),
        etiologies=(),
    ),
    'non_communicable_diseases': Cause(
        name='non_communicable_diseases',
        kind='cause',
        gbd_id=c_id(409),
        me_id=UNKNOWN,
        level=1,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'neoplasms': Cause(
        name='neoplasms',
        kind='cause',
        gbd_id=c_id(410),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'esophageal_cancer': Cause(
        name='esophageal_cancer',
        kind='cause',
        gbd_id=c_id(411),
        me_id=me_id(9469),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=9,
            yll_age_group_id_end=235,
            yld_age_group_id_start=9,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_esophageal_cancer, 
                  sequelae.controlled_phase_of_esophageal_cancer, sequelae.metastatic_phase_of_esophageal_cancer, 
                  sequelae.terminal_phase_of_esophageal_cancer, ),
        etiologies=(),
    ),
    'stomach_cancer': Cause(
        name='stomach_cancer',
        kind='cause',
        gbd_id=c_id(414),
        me_id=me_id(9509),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_stomach_cancer, 
                  sequelae.controlled_phase_of_stomach_cancer, sequelae.metastatic_phase_of_stomach_cancer, 
                  sequelae.terminal_phase_of_stomach_cancer, ),
        etiologies=(),
    ),
    'liver_cancer': Cause(
        name='liver_cancer',
        kind='cause',
        gbd_id=c_id(417),
        me_id=me_id(9495),
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'liver_cancer_due_to_hepatitis_b': Cause(
        name='liver_cancer_due_to_hepatitis_b',
        kind='cause',
        gbd_id=c_id(418),
        me_id=me_id(9665),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_hepatitis_b, 
                  sequelae.controlled_phase_of_liver_cancer_due_to_hepatitis_b, 
                  sequelae.metastatic_phase_of_liver_cancer_due_to_hepatitis_b, 
                  sequelae.terminal_phase_of_liver_cancer_due_to_hepatitis_b, ),
        etiologies=(),
    ),
    'liver_cancer_due_to_hepatitis_c': Cause(
        name='liver_cancer_due_to_hepatitis_c',
        kind='cause',
        gbd_id=c_id(419),
        me_id=me_id(9666),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_hepatitis_c, 
                  sequelae.controlled_phase_of_liver_cancer_due_to_hepatitis_c, 
                  sequelae.metastatic_phase_of_liver_cancer_due_to_hepatitis_c, 
                  sequelae.terminal_phase_of_liver_cancer_due_to_hepatitis_c, ),
        etiologies=(),
    ),
    'liver_cancer_due_to_alcohol_use': Cause(
        name='liver_cancer_due_to_alcohol_use',
        kind='cause',
        gbd_id=c_id(420),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_alcohol_use, 
                  sequelae.controlled_phase_of_liver_cancer_due_to_alcohol_use, 
                  sequelae.metastatic_phase_of_liver_cancer_due_to_alcohol_use, 
                  sequelae.terminal_phase_of_liver_cancer_due_to_alcohol_use, ),
        etiologies=(),
    ),
    'larynx_cancer': Cause(
        name='larynx_cancer',
        kind='cause',
        gbd_id=c_id(423),
        me_id=me_id(9473),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=9,
            yll_age_group_id_end=235,
            yld_age_group_id_start=9,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_larynx_cancer, 
                  sequelae.metastatic_phase_of_larynx_cancer, sequelae.terminal_phase_of_larynx_cancer, 
                  sequelae.controlled_phase_of_larynx_cancer_with_laryngectomy, 
                  sequelae.controlled_phase_of_larynx_cancer_without_laryngectomy, 
                  sequelae.laryngectomy_from_larynx_cancer_beyond_ten_years, ),
        etiologies=(),
    ),
    'tracheal_bronchus_and_lung_cancer': Cause(
        name='tracheal_bronchus_and_lung_cancer',
        kind='cause',
        gbd_id=c_id(426),
        me_id=me_id(9496),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_lung_bronchus_and_trachea_cancer, 
                  sequelae.controlled_phase_of_lung_bronchus_and_trachea_cancer, 
                  sequelae.metastatic_phase_of_lung_bronchus_and_trachea_cancer, 
                  sequelae.terminal_phase_of_lung_bronchus_and_trachea_cancer, ),
        etiologies=(),
    ),
    'breast_cancer': Cause(
        name='breast_cancer',
        kind='cause',
        gbd_id=c_id(429),
        me_id=me_id(9466),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_breast_cancer, 
                  sequelae.metastatic_phase_of_breast_cancer, sequelae.terminal_phase_of_breast_cancer, 
                  sequelae.controlled_phase_of_breast_cancer_with_mastectomy, 
                  sequelae.controlled_phase_of_breast_cancer_without_mastectomy, 
                  sequelae.mastectomy_from_breast_cancer_beyond_ten_years, ),
        etiologies=(),
    ),
    'cervical_cancer': Cause(
        name='cervical_cancer',
        kind='cause',
        gbd_id=c_id(432),
        me_id=me_id(9467),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_cervical_cancer, 
                  sequelae.controlled_phase_of_cervical_cancer, sequelae.metastatic_phase_of_cervical_cancer, 
                  sequelae.terminal_phase_of_cervical_cancer, ),
        etiologies=(),
    ),
    'uterine_cancer': Cause(
        name='uterine_cancer',
        kind='cause',
        gbd_id=c_id(435),
        me_id=me_id(9512),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=9,
            yll_age_group_id_end=235,
            yld_age_group_id_start=9,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_uterine_cancer, 
                  sequelae.controlled_phase_of_uterine_cancer, sequelae.metastatic_phase_of_uterine_cancer, 
                  sequelae.terminal_phase_of_uterine_cancer, ),
        etiologies=(),
    ),
    'prostate_cancer': Cause(
        name='prostate_cancer',
        kind='cause',
        gbd_id=c_id(438),
        me_id=me_id(9508),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=True,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=9,
            yll_age_group_id_end=235,
            yld_age_group_id_start=9,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_prostate_cancer, 
                  sequelae.metastatic_phase_of_prostate_cancer, sequelae.terminal_phase_of_prostate_cancer, 
                  sequelae.controlled_phase_of_prostate_cancer_with_impotence, 
                  sequelae.controlled_phase_of_prostate_cancer_with_incontinence, 
                  sequelae.controlled_phase_of_prostate_cancer_without_impotence_or_incontinence, 
                  sequelae.impotence_from_prostate_cancer_beyond_ten_years, 
                  sequelae.incontinence_from_prostate_cancer_beyond_ten_years, ),
        etiologies=(),
    ),
    'colon_and_rectum_cancer': Cause(
        name='colon_and_rectum_cancer',
        kind='cause',
        gbd_id=c_id(441),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=6,
            yll_age_group_id_end=235,
            yld_age_group_id_start=6,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_colon_and_rectum_cancers, 
                  sequelae.metastatic_phase_of_colon_and_rectum_cancers, 
                  sequelae.terminal_phase_of_colon_and_rectum_cancers, 
                  sequelae.controlled_phase_of_colon_and_rectum_cancers_with_stoma, 
                  sequelae.controlled_phase_of_colon_and_rectum_cancers_without_stoma, 
                  sequelae.stoma_from_colon_and_rectum_cancers_beyond_ten_years, ),
        etiologies=(),
    ),
    'lip_and_oral_cavity_cancer': Cause(
        name='lip_and_oral_cavity_cancer',
        kind='cause',
        gbd_id=c_id(444),
        me_id=me_id(9500),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=6,
            yll_age_group_id_end=235,
            yld_age_group_id_start=6,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_mouth_cancer, 
                  sequelae.controlled_phase_of_mouth_cancer, sequelae.metastatic_phase_of_mouth_cancer, 
                  sequelae.terminal_phase_of_mouth_cancer, ),
        etiologies=(),
    ),
    'nasopharynx_cancer': Cause(
        name='nasopharynx_cancer',
        kind='cause',
        gbd_id=c_id(447),
        me_id=me_id(9502),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=6,
            yll_age_group_id_end=235,
            yld_age_group_id_start=6,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_nasopharynx_cancer, 
                  sequelae.controlled_phase_of_nasopharynx_cancer, sequelae.metastatic_phase_of_nasopharynx_cancer, 
                  sequelae.terminal_phase_of_nasopharynx_cancer, ),
        etiologies=(),
    ),
    'other_pharynx_cancer': Cause(
        name='other_pharynx_cancer',
        kind='cause',
        gbd_id=c_id(450),
        me_id=me_id(9505),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=9,
            yll_age_group_id_end=235,
            yld_age_group_id_start=9,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_other_pharynx_cancer, 
                  sequelae.controlled_phase_of_other_pharynx_cancer, 
                  sequelae.metastatic_phase_of_other_pharynx_cancer, sequelae.terminal_phase_of_other_pharynx_cancer, ),
        etiologies=(),
    ),
    'gallbladder_and_biliary_tract_cancer': Cause(
        name='gallbladder_and_biliary_tract_cancer',
        kind='cause',
        gbd_id=c_id(453),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=9,
            yll_age_group_id_end=235,
            yld_age_group_id_start=9,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_gallbladder_and_biliary_tract_cancer, 
                  sequelae.controlled_phase_of_gallbladder_and_biliary_tract_cancer, 
                  sequelae.metastatic_phase_of_gallbladder_and_biliary_tract_cancer, 
                  sequelae.terminal_phase_of_gallbladder_and_biliary_tract_cancer, ),
        etiologies=(),
    ),
    'pancreatic_cancer': Cause(
        name='pancreatic_cancer',
        kind='cause',
        gbd_id=c_id(456),
        me_id=me_id(9507),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_pancreatic_cancer, 
                  sequelae.controlled_phase_of_pancreatic_cancer, sequelae.metastatic_phase_of_pancreatic_cancer, 
                  sequelae.terminal_phase_of_pancreatic_cancer, ),
        etiologies=(),
    ),
    'malignant_skin_melanoma': Cause(
        name='malignant_skin_melanoma',
        kind='cause',
        gbd_id=c_id(459),
        me_id=me_id(9498),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_malignant_skin_melanoma, 
                  sequelae.controlled_phase_of_malignant_skin_melanoma, 
                  sequelae.metastatic_phase_of_malignant_skin_melanoma, 
                  sequelae.terminal_phase_of_malignant_skin_melanoma, ),
        etiologies=(),
    ),
    'non_melanoma_skin_cancer': Cause(
        name='non_melanoma_skin_cancer',
        kind='cause',
        gbd_id=c_id(462),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=9,
            yll_age_group_id_end=235,
            yld_age_group_id_start=9,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'ovarian_cancer': Cause(
        name='ovarian_cancer',
        kind='cause',
        gbd_id=c_id(465),
        me_id=me_id(9506),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=6,
            yll_age_group_id_end=235,
            yld_age_group_id_start=6,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_ovarian_cancer, 
                  sequelae.controlled_phase_of_ovarian_cancer, sequelae.metastatic_phase_of_ovarian_cancer, 
                  sequelae.terminal_phase_of_ovarian_cancer, ),
        etiologies=(),
    ),
    'testicular_cancer': Cause(
        name='testicular_cancer',
        kind='cause',
        gbd_id=c_id(468),
        me_id=me_id(9510),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=True,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_testicular_cancer, 
                  sequelae.controlled_phase_of_testicular_cancer, sequelae.metastatic_phase_of_testicular_cancer, 
                  sequelae.terminal_phase_of_testicular_cancer, ),
        etiologies=(),
    ),
    'kidney_cancer': Cause(
        name='kidney_cancer',
        kind='cause',
        gbd_id=c_id(471),
        me_id=me_id(9472),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_kidney_cancer, 
                  sequelae.controlled_phase_of_kidney_cancer, sequelae.metastatic_phase_of_kidney_cancer, 
                  sequelae.terminal_phase_of_kidney_cancer, ),
        etiologies=(),
    ),
    'bladder_cancer': Cause(
        name='bladder_cancer',
        kind='cause',
        gbd_id=c_id(474),
        me_id=me_id(9464),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_bladder_cancer, 
                  sequelae.metastatic_phase_of_bladder_cancer, sequelae.terminal_phase_of_bladder_cancer, 
                  sequelae.controlled_phase_of_bladder_cancer_with_incontinence, 
                  sequelae.controlled_phase_of_bladder_cancer_without_incontinence, 
                  sequelae.incontinence_from_bladder_cancer_beyond_ten_years, ),
        etiologies=(),
    ),
    'brain_and_central_nervous_system_cancer': Cause(
        name='brain_and_central_nervous_system_cancer',
        kind='cause',
        gbd_id=c_id(477),
        me_id=me_id(9465),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_brain_and_central_nervous_system_cancers, 
                  sequelae.controlled_phase_of_brain_and_central_nervous_system_cancers, 
                  sequelae.metastatic_phase_of_brain_and_central_nervous_system_cancers, 
                  sequelae.terminal_phase_of_brain_and_central_nervous_system_cancers, ),
        etiologies=(),
    ),
    'thyroid_cancer': Cause(
        name='thyroid_cancer',
        kind='cause',
        gbd_id=c_id(480),
        me_id=me_id(9511),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=6,
            yll_age_group_id_end=235,
            yld_age_group_id_start=6,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_thyroid_cancer, 
                  sequelae.controlled_phase_of_thyroid_cancer, sequelae.metastatic_phase_of_thyroid_cancer, 
                  sequelae.terminal_phase_of_thyroid_cancer, ),
        etiologies=(),
    ),
    'mesothelioma': Cause(
        name='mesothelioma',
        kind='cause',
        gbd_id=c_id(483),
        me_id=me_id(9499),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=9,
            yll_age_group_id_end=235,
            yld_age_group_id_start=9,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_mesothelioma, 
                  sequelae.controlled_phase_of_mesothelioma, sequelae.metastatic_phase_of_mesothelioma, 
                  sequelae.terminal_phase_of_mesothelioma, ),
        etiologies=(),
    ),
    'hodgkin_lymphoma': Cause(
        name='hodgkin_lymphoma',
        kind='cause',
        gbd_id=c_id(484),
        me_id=me_id(9471),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_hodgkin_disease, 
                  sequelae.controlled_phase_of_hodgkin_disease, sequelae.metastatic_phase_of_hodgkin_disease, 
                  sequelae.terminal_phase_of_hodgkin_disease, ),
        etiologies=(),
    ),
    'non_hodgkin_lymphoma': Cause(
        name='non_hodgkin_lymphoma',
        kind='cause',
        gbd_id=c_id(485),
        me_id=me_id(9497),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'multiple_myeloma': Cause(
        name='multiple_myeloma',
        kind='cause',
        gbd_id=c_id(486),
        me_id=me_id(9501),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=9,
            yll_age_group_id_end=235,
            yld_age_group_id_start=9,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_multiple_myeloma, 
                  sequelae.controlled_phase_of_multiple_myeloma, sequelae.metastatic_phase_of_multiple_myeloma, 
                  sequelae.terminal_phase_of_multiple_myeloma, ),
        etiologies=(),
    ),
    'leukemia': Cause(
        name='leukemia',
        kind='cause',
        gbd_id=c_id(487),
        me_id=me_id(9474),
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'other_neoplasms': Cause(
        name='other_neoplasms',
        kind='cause',
        gbd_id=c_id(490),
        me_id=me_id(9504),
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'cardiovascular_diseases': Cause(
        name='cardiovascular_diseases',
        kind='cause',
        gbd_id=c_id(491),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'rheumatic_heart_disease': Cause(
        name='rheumatic_heart_disease',
        kind='cause',
        gbd_id=c_id(492),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.rheumatic_heart_disease_without_heart_failure, 
                  sequelae.mild_heart_failure_due_to_rheumatic_heart_disease, 
                  sequelae.moderate_heart_failure_due_to_rheumatic_heart_disease, 
                  sequelae.severe_heart_failure_due_to_rheumatic_heart_disease, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_rheumatic_heart_disease, ),
        etiologies=(),
    ),
    'ischemic_heart_disease': Cause(
        name='ischemic_heart_disease',
        kind='cause',
        gbd_id=c_id(493),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.acute_myocardial_infarction_first_2_days, 
                  sequelae.acute_myocardial_infarction_3_to_28_days, 
                  sequelae.mild_angina_due_to_ischemic_heart_disease, 
                  sequelae.moderate_angina_due_to_ischemic_heart_disease, 
                  sequelae.severe_angina_due_to_ischemic_heart_disease, 
                  sequelae.mild_heart_failure_due_to_ischemic_heart_disease, 
                  sequelae.moderate_heart_failure_due_to_ischemic_heart_disease, 
                  sequelae.severe_heart_failure_due_to_ischemic_heart_disease, 
                  sequelae.asymptomatic_angina_due_to_ischemic_heart_disease, 
                  sequelae.asymptomatic_ischemic_heart_disease_following_myocardial_infarction, 
                  sequelae.controlled_medically_managed_heart_failure_due_ischemic_heart_disease, ),
        etiologies=(),
    ),
    'stroke': Cause(
        name='stroke',
        kind='cause',
        gbd_id=c_id(494),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'ischemic_stroke': Cause(
        name='ischemic_stroke',
        kind='cause',
        gbd_id=c_id(495),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.acute_ischemic_stroke_severity_level_1, sequelae.acute_ischemic_stroke_severity_level_2, 
                  sequelae.acute_ischemic_stroke_severity_level_4, sequelae.acute_ischemic_stroke_severity_level_3, 
                  sequelae.acute_ischemic_stroke_severity_level_5, sequelae.chronic_ischemic_stroke_severity_level_1, 
                  sequelae.chronic_ischemic_stroke_severity_level_2, 
                  sequelae.chronic_ischemic_stroke_severity_level_4, 
                  sequelae.chronic_ischemic_stroke_severity_level_3, 
                  sequelae.chronic_ischemic_stroke_severity_level_5, sequelae.asymptomatic_chronic_ischemic_stroke, ),
        etiologies=(),
    ),
    'intracerebral_hemorrhage': Cause(
        name='intracerebral_hemorrhage',
        kind='cause',
        gbd_id=c_id(496),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.acute_intracerebral_hemorrhage_severity_level_1, 
                  sequelae.acute_intracerebral_hemorrhage_severity_level_2, 
                  sequelae.acute_intracerebral_hemorrhage_severity_level_4, 
                  sequelae.acute_intracerebral_hemorrhage_severity_level_3, 
                  sequelae.acute_intracerebral_hemorrhage_severity_level_5, 
                  sequelae.chronic_intracerebral_hemorrhage_severity_level_1, 
                  sequelae.chronic_intracerebral_hemorrhage_severity_level_2, 
                  sequelae.chronic_intracerebral_hemorrhage_severity_level_4, 
                  sequelae.chronic_intracerebral_hemorrhage_severity_level_3, 
                  sequelae.chronic_intracerebral_hemorrhage_severity_level_5, 
                  sequelae.asymptomatic_chronic_intracerebral_hemorrhage, ),
        etiologies=(),
    ),
    'subarachnoid_hemorrhage': Cause(
        name='subarachnoid_hemorrhage',
        kind='cause',
        gbd_id=c_id(497),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.acute_subarachnoid_hemorrhage_severity_level_1, 
                  sequelae.acute_subarachnoid_hemorrhage_severity_level_2, 
                  sequelae.acute_subarachnoid_hemorrhage_severity_level_3, 
                  sequelae.acute_subarachnoid_hemorrhage_severity_level_4, 
                  sequelae.acute_subarachnoid_hemorrhage_severity_level_5, 
                  sequelae.asymptomatic_chronic_subarachnoid_hemorrhage, 
                  sequelae.chronic_subarachnoid_hemorrhage_severity_level_1, 
                  sequelae.chronic_subarachnoid_hemorrhage_severity_level_2, 
                  sequelae.chronic_subarachnoid_hemorrhage_severity_level_3, 
                  sequelae.chronic_subarachnoid_hemorrhage_severity_level_4, 
                  sequelae.chronic_subarachnoid_hemorrhage_severity_level_5, ),
        etiologies=(),
    ),
    'hypertensive_heart_disease': Cause(
        name='hypertensive_heart_disease',
        kind='cause',
        gbd_id=c_id(498),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_heart_failure_due_to_hypertensive_heart_disease, 
                  sequelae.moderate_heart_failure_due_to_hypertensive_heart_disease, 
                  sequelae.severe_heart_failure_due_to_hypertensive_heart_disease, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_hypertensive_heart_disease, ),
        etiologies=(),
    ),
    'cardiomyopathy_and_myocarditis': Cause(
        name='cardiomyopathy_and_myocarditis',
        kind='cause',
        gbd_id=c_id(499),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'atrial_fibrillation_and_flutter': Cause(
        name='atrial_fibrillation_and_flutter',
        kind='cause',
        gbd_id=c_id(500),
        me_id=me_id(1859),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=11,
            yll_age_group_id_end=235,
            yld_age_group_id_start=11,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.asymptomatic_atrial_fibrillation_and_flutter, 
                  sequelae.symptomatic_atrial_fibrillation_and_flutter, ),
        etiologies=(),
    ),
    'aortic_aneurysm': Cause(
        name='aortic_aneurysm',
        kind='cause',
        gbd_id=c_id(501),
        me_id=me_id(1860),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=True,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=None,
            yld_age_group_id_end=None,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'peripheral_artery_disease': Cause(
        name='peripheral_artery_disease',
        kind='cause',
        gbd_id=c_id(502),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=13,
            yll_age_group_id_end=235,
            yld_age_group_id_start=13,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.asymptomatic_peripheral_arterial_disease, 
                  sequelae.symptomatic_claudication_due_to_peripheral_arterial_disease, ),
        etiologies=(),
    ),
    'endocarditis': Cause(
        name='endocarditis',
        kind='cause',
        gbd_id=c_id(503),
        me_id=me_id(1862),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_endocarditis, sequelae.severe_endocarditis, 
                  sequelae.mild_heart_failure_due_to_endocarditis, 
                  sequelae.moderate_heart_failure_due_to_endocarditis, 
                  sequelae.severe_heart_failure_due_to_endocarditis, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_endocarditis, ),
        etiologies=(),
    ),
    'non_rheumatic_valvular_heart_disease': Cause(
        name='non_rheumatic_valvular_heart_disease',
        kind='cause',
        gbd_id=c_id(504),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'chronic_respiratory_diseases': Cause(
        name='chronic_respiratory_diseases',
        kind='cause',
        gbd_id=c_id(508),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'chronic_obstructive_pulmonary_disease': Cause(
        name='chronic_obstructive_pulmonary_disease',
        kind='cause',
        gbd_id=c_id(509),
        me_id=me_id(1872),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=4,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_chronic_obstructive_pulmonary_disease, 
                  sequelae.moderate_chronic_obstructive_pulmonary_disease, 
                  sequelae.asymptomatic_chronic_obstructive_pulmonary_disease, 
                  sequelae.mild_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease, 
                  sequelae.moderate_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease, 
                  sequelae.severe_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease, 
                  sequelae.severe_chronic_obstructive_pulmonary_disease_without_heart_failure, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_severe_chronic_obstructive_pulmonary_disease, ),
        etiologies=(),
    ),
    'pneumoconiosis': Cause(
        name='pneumoconiosis',
        kind='cause',
        gbd_id=c_id(510),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'silicosis': Cause(
        name='silicosis',
        kind='cause',
        gbd_id=c_id(511),
        me_id=me_id(1879),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_silicosis, sequelae.moderate_silicosis, sequelae.asymptomatic_silicosis, 
                  sequelae.mild_heart_failure_due_to_severe_silicosis, 
                  sequelae.moderate_heart_failure_due_to_severe_silicosis, 
                  sequelae.severe_heart_failure_due_to_severe_silicosis, 
                  sequelae.severe_silicosis_without_heart_failure, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_severe_silicosis, ),
        etiologies=(),
    ),
    'asbestosis': Cause(
        name='asbestosis',
        kind='cause',
        gbd_id=c_id(512),
        me_id=me_id(1886),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_asbestosis, sequelae.moderate_asbestosis, sequelae.asymptomatic_asbestosis, 
                  sequelae.mild_heart_failure_due_to_severe_asbestosis, 
                  sequelae.moderate_heart_failure_due_to_severe_asbestosis, 
                  sequelae.severe_heart_failure_due_to_severe_asbestosis, 
                  sequelae.severe_asbestosis_without_heart_failure, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_severe_asbestosis, ),
        etiologies=(),
    ),
    'coal_workers_pneumoconiosis': Cause(
        name='coal_workers_pneumoconiosis',
        kind='cause',
        gbd_id=c_id(513),
        me_id=me_id(3052),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_coal_workers_pneumoconiosis, sequelae.moderate_coal_workers_pneumoconiosis, 
                  sequelae.asymptomatic_coal_workers_pneumoconiosis, 
                  sequelae.mild_heart_failure_due_to_severe_coal_workers_pneumoconiosis, 
                  sequelae.moderate_heart_failure_due_to_severe_coal_workers_pneumoconiosis, 
                  sequelae.severe_heart_failure_due_to_severe_coal_workers_pneumoconiosis, 
                  sequelae.severe_coal_workers_pneumoconiosis_without_heart_failure, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_severe_coal_workers_pneumoconiosis, ),
        etiologies=(),
    ),
    'other_pneumoconiosis': Cause(
        name='other_pneumoconiosis',
        kind='cause',
        gbd_id=c_id(514),
        me_id=me_id(1900),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_other_pneumoconiosis, sequelae.moderate_other_pneumoconiosis, 
                  sequelae.asymptomatic_other_pneumoconiosis, 
                  sequelae.mild_heart_failure_due_to_severe_other_pneumoconiosis, 
                  sequelae.moderate_heart_failure_due_to_severe_other_pneumoconiosis, 
                  sequelae.severe_heart_failure_due_to_severe_other_pneumoconiosis, 
                  sequelae.severe_other_pneumoconiosis_without_heart_failure, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_severe_other_pneumoconiosis, ),
        etiologies=(),
    ),
    'asthma': Cause(
        name='asthma',
        kind='cause',
        gbd_id=c_id(515),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.controlled_asthma, sequelae.partially_controlled_asthma, sequelae.uncontrolled_asthma, 
                  sequelae.asymptomatic_asthma, ),
        etiologies=(),
    ),
    'interstitial_lung_disease_and_pulmonary_sarcoidosis': Cause(
        name='interstitial_lung_disease_and_pulmonary_sarcoidosis',
        kind='cause',
        gbd_id=c_id(516),
        me_id=me_id(1911),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_interstitial_lung_disease_and_pulmonary_sarcoidosis, 
                  sequelae.moderate_interstitial_lung_disease_and_pulmonary_sarcoidosis, 
                  sequelae.asymptomatic_interstitial_lung_disease_and_pulmonary_sarcoidosis, 
                  sequelae.mild_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis, 
                  sequelae.moderate_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis, 
                  sequelae.severe_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis, 
                  sequelae.severe_interstitial_lung_disease_and_pulmonary_sarcoidosis_without_heart_failure, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_severe_interstitial_lung_disease_and_pulmonary_sarcoidosis, ),
        etiologies=(),
    ),
    'other_chronic_respiratory_diseases': Cause(
        name='other_chronic_respiratory_diseases',
        kind='cause',
        gbd_id=c_id(520),
        me_id=me_id(1918),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.other_chronic_respiratory_diseases, ),
        etiologies=(),
    ),
    'cirrhosis_and_other_chronic_liver_diseases': Cause(
        name='cirrhosis_and_other_chronic_liver_diseases',
        kind='cause',
        gbd_id=c_id(521),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b': Cause(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b',
        kind='cause',
        gbd_id=c_id(522),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.chronic_hepatitis_b_without_cirrhosis, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_compensated, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_without_anemia, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_mild_anemia, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_moderate_anemia, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b_decompensated_with_severe_anemia, ),
        etiologies=(),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c': Cause(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c',
        kind='cause',
        gbd_id=c_id(523),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.chronic_hepatitis_c_without_cirrhosis, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_compensated, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_no_anemia, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_mild_anemia, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_moderate_anemia, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c_decompensated_with_severe_anemia, ),
        etiologies=(),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_use': Cause(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_use',
        kind='cause',
        gbd_id=c_id(524),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_compensated, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_without_anemia, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_mild_anemia, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_moderate_anemia, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_decompensated_with_severe_anemia, ),
        etiologies=(),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_other_causes': Cause(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_other_causes',
        kind='cause',
        gbd_id=c_id(525),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_other_cause_compensated, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_no_anemia, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_mild_anemia, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_moderate_anemia, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_other_decompensated_with_severe_anemia, ),
        etiologies=(),
    ),
    'digestive_diseases': Cause(
        name='digestive_diseases',
        kind='cause',
        gbd_id=c_id(526),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'peptic_ulcer_disease': Cause(
        name='peptic_ulcer_disease',
        kind='cause',
        gbd_id=c_id(527),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mildly_symptomatic_pud_with_mild_anemia, 
                  sequelae.moderately_symptomatic_pud_with_mild_anemia, 
                  sequelae.mildly_symptomatic_pud_with_moderate_anemia, 
                  sequelae.moderately_symptomatic_pud_with_moderate_anemia, 
                  sequelae.mildly_symptomatic_pud_with_severe_anemia, 
                  sequelae.moderately_symptomatic_pud_with_severe_anemia, 
                  sequelae.mildly_symptomatic_pud_with_no_anemia, sequelae.moderately_symptomatic_pud_with_no_anemia, 
                  sequelae.asymptomatic_pud_with_mild_anemia, sequelae.asymptomatic_pud_with_moderate_anemia, 
                  sequelae.asymptomatic_pud_with_severe_anemia, sequelae.asymptomatic_pud_with_no_anemia, 
                  sequelae.complicated_pud_with_no_anemia, sequelae.complicated_pud_with_mild_anemia, 
                  sequelae.complicated_pud_with_moderate_anemia, sequelae.complicated_pud_with_severe_anemia, 
                  sequelae.severe_acute_uncomplicated_pud_with_no_anemia, 
                  sequelae.severe_acute_uncomplicated_pud_with_mild_anemia, 
                  sequelae.severe_acute_uncomplicated_pud_with_moderate_anemia, 
                  sequelae.severe_acute_uncomplicated_pud_with_severe_anemia, ),
        etiologies=(),
    ),
    'gastritis_and_duodenitis': Cause(
        name='gastritis_and_duodenitis',
        kind='cause',
        gbd_id=c_id(528),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mildy_symptomatic_gastritis_duodenitis_with_mild_anemia, 
                  sequelae.moderately_symptomatic_gastritis_duodenitis_with_mild_anemia, 
                  sequelae.mildly_symptomatic_gastritis_duodenitis_with_moderate_anemia, 
                  sequelae.moderately_symptomatic_gastritis_duodenitis_with_moderate_anemia, 
                  sequelae.mildy_symptomatic_gastritis_duodenitis_with_severe_anemia, 
                  sequelae.moderately_symptomatic_gastritis_duodenitis_with_severe_anemia, 
                  sequelae.mildly_symptomatic_gastritis_duodenitis_with_no_anemia, 
                  sequelae.moderately_symptomatic_gastritis_duodenitis_with_no_anemia, 
                  sequelae.asymptomatic_gastritis_duodenitis_with_mild_anemia, 
                  sequelae.asymptomatic_gastritis_duodenitis_with_moderate_anemia, 
                  sequelae.asymptomatic_gastritis_duodenitis_with_severe_anemia, 
                  sequelae.asymptomatic_gastritis_duodenitis_with_no_anemia, 
                  sequelae.complicated_gastritis_duodenitis_with_no_anemia, 
                  sequelae.complicated_gastritis_duodenitis_with_mild_anemia, 
                  sequelae.complicated_gastritis_duodenitis_with_moderate_anemia, 
                  sequelae.complicated_gastritis_duodenitis_with_severe_anemia, 
                  sequelae.severe_acute_uncomplicated_gastritis_duodenitis_with_no_anemia, 
                  sequelae.severe_acute_uncomplicated_gastritis_duodenitis_with_mild_anemia, 
                  sequelae.severe_acute_uncomplicated_gastritis_duodenitis_with_moderate_anemia, 
                  sequelae.severe_acute_uncomplicated_gastritis_duodenitis_with_severe_anemia, ),
        etiologies=(),
    ),
    'appendicitis': Cause(
        name='appendicitis',
        kind='cause',
        gbd_id=c_id(529),
        me_id=me_id(24547),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.appendicitis, ),
        etiologies=(),
    ),
    'paralytic_ileus_and_intestinal_obstruction': Cause(
        name='paralytic_ileus_and_intestinal_obstruction',
        kind='cause',
        gbd_id=c_id(530),
        me_id=me_id(24548),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.paralytic_ileus_and_intestinal_obstruction, ),
        etiologies=(),
    ),
    'inguinal_femoral_and_abdominal_hernia': Cause(
        name='inguinal_femoral_and_abdominal_hernia',
        kind='cause',
        gbd_id=c_id(531),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_symptomatic_inguinal_femoral_and_abdominal_hernia, 
                  sequelae.moderate_symptomatic_inguinal_femoral_and_abdominal_hernia, 
                  sequelae.severe_symptomatic_inguinal_femoral_and_abdominal_hernia, 
                  sequelae.asymptomatic_symptomatic_inguinal_femoral_and_abdominal_hernia, ),
        etiologies=(),
    ),
    'inflammatory_bowel_disease': Cause(
        name='inflammatory_bowel_disease',
        kind='cause',
        gbd_id=c_id(532),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.asymptomatic_ulcerative_colitis, sequelae.asymptomatic_crohns_disease, 
                  sequelae.ulcerative_colitis_with_mild_anemia, sequelae.ulcerative_colitis_with_moderate_anemia, 
                  sequelae.ulcerative_colitis_with_severe_anemia, sequelae.ulcerative_colitis_without_anemia, 
                  sequelae.crohns_disease_with_mild_anemia, sequelae.crohns_disease_with_moderate_anemia, 
                  sequelae.crohns_disease_with_severe_anemia, sequelae.crohns_disease_without_anemia, ),
        etiologies=(),
    ),
    'vascular_intestinal_disorders': Cause(
        name='vascular_intestinal_disorders',
        kind='cause',
        gbd_id=c_id(533),
        me_id=me_id(24648),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.vascular_intestinal_disorders, ),
        etiologies=(),
    ),
    'gallbladder_and_biliary_diseases': Cause(
        name='gallbladder_and_biliary_diseases',
        kind='cause',
        gbd_id=c_id(534),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.asymptomatic_gallbladder_and_biliary_diseases, 
                  sequelae.mild_symptomatic_episodes_gallbladder_and_biliary_diseases, 
                  sequelae.moderate_symptomatic_episodes_gallbladder_and_biliary_diseases, 
                  sequelae.severe_symptomatic_episodes_gallbladder_and_biliary_diseases, ),
        etiologies=(),
    ),
    'pancreatitis': Cause(
        name='pancreatitis',
        kind='cause',
        gbd_id=c_id(535),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_chronic_pancreatitis, sequelae.moderate_chronic_pancreatitis, 
                  sequelae.severe_chronic_pancreatitis, sequelae.acute_pancreatitis, 
                  sequelae.asymptomatic_chronic_pancreatitis, ),
        etiologies=(),
    ),
    'gastroesophageal_reflux_disease': Cause(
        name='gastroesophageal_reflux_disease',
        kind='cause',
        gbd_id=c_id(536),
        me_id=me_id(18664),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=4,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_to_moderate_gerd_symptomatic_days, sequelae.mild_to_moderate_gerd_asymptomatic_days, 
                  sequelae.severe_gerd_symptomatic_days, sequelae.severe_gerd_asymptomatic_days, ),
        etiologies=(),
    ),
    'other_digestive_diseases': Cause(
        name='other_digestive_diseases',
        kind='cause',
        gbd_id=c_id(541),
        me_id=me_id(1942),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.other_digestive_diseases, ),
        etiologies=(),
    ),
    'neurological_disorders': Cause(
        name='neurological_disorders',
        kind='cause',
        gbd_id=c_id(542),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'alzheimers_disease_and_other_dementias': Cause(
        name='alzheimers_disease_and_other_dementias',
        kind='cause',
        gbd_id=c_id(543),
        me_id=me_id(1943),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=13,
            yll_age_group_id_end=235,
            yld_age_group_id_start=13,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_alzheimers_disease_and_other_dementias, 
                  sequelae.moderate_alzheimers_disease_and_other_dementias, 
                  sequelae.severe_alzheimers_disease_and_other_dementias, ),
        etiologies=(),
    ),
    'parkinsons_disease': Cause(
        name='parkinsons_disease',
        kind='cause',
        gbd_id=c_id(544),
        me_id=me_id(1947),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=9,
            yll_age_group_id_end=235,
            yld_age_group_id_start=9,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_parkinsons_disease, sequelae.moderate_parkinsons_disease, 
                  sequelae.severe_parkinsons_disease, ),
        etiologies=(),
    ),
    'idiopathic_epilepsy': Cause(
        name='idiopathic_epilepsy',
        kind='cause',
        gbd_id=c_id(545),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.idiopathic_seizure_free_treated_epilepsy, sequelae.idiopathic_less_severe_epilepsy, 
                  sequelae.idiopathic_severe_epilepsy, ),
        etiologies=(),
    ),
    'multiple_sclerosis': Cause(
        name='multiple_sclerosis',
        kind='cause',
        gbd_id=c_id(546),
        me_id=me_id(1955),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=6,
            yll_age_group_id_end=235,
            yld_age_group_id_start=6,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_multiple_sclerosis, sequelae.moderate_multiple_sclerosis, 
                  sequelae.severe_multiple_sclerosis, sequelae.asymptomatic_multiple_sclerosis, ),
        etiologies=(),
    ),
    'migraine': Cause(
        name='migraine',
        kind='cause',
        gbd_id=c_id(547),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=6,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.asymptomatic_medication_overuse_headache_due_to_migraine, 
                  sequelae.symptomatic_medication_overuse_headache_due_to_migraine, 
                  sequelae.symptomatic_probable_migraine, sequelae.asymptomatic_probable_migraine, 
                  sequelae.symptomatic_definite_migraine, sequelae.asymptomatic_definite_migraine, ),
        etiologies=(),
    ),
    'tension_type_headache': Cause(
        name='tension_type_headache',
        kind='cause',
        gbd_id=c_id(548),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=6,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.asymptomatic_medication_overuse_headache_due_to_tension_type_headache, 
                  sequelae.symptomatic_medication_overuse_headache_due_to_tension_type_headache, 
                  sequelae.symptomatic_probable_tension_type_headache, 
                  sequelae.asymptomatic_probable_tension_type_headache, 
                  sequelae.symptomatic_definite_tension_type_headache, 
                  sequelae.asymptomatic_definite_tension_type_headache, ),
        etiologies=(),
    ),
    'motor_neuron_disease': Cause(
        name='motor_neuron_disease',
        kind='cause',
        gbd_id=c_id(554),
        me_id=me_id(3940),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease, 
                  sequelae.mild_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease, 
                  sequelae.mild_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease, 
                  sequelae.mild_motor_impairment_and_speech_problems_due_to_motor_neuron_disease, 
                  sequelae.moderate_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease, 
                  sequelae.moderate_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease, 
                  sequelae.moderate_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease, 
                  sequelae.severe_motor_impairment_mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease, 
                  sequelae.severe_motor_impairment_moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease, 
                  sequelae.severe_motor_impairment_severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease, 
                  sequelae.mild_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease, 
                  sequelae.mild_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease, 
                  sequelae.moderate_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease, 
                  sequelae.moderate_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease, 
                  sequelae.moderate_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease, 
                  sequelae.severe_motor_impairment_and_mild_respiratory_problems_due_to_motor_neuron_disease, 
                  sequelae.severe_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease, 
                  sequelae.severe_motor_impairment_and_severe_respiratory_problems_due_to_motor_neuron_disease, 
                  sequelae.moderate_motor_impairment_and_speech_problems_due_to_motor_neuron_disease, 
                  sequelae.severe_motor_impairment_and_speech_problems_due_to_motor_neuron_disease, 
                  sequelae.mild_motor_impairment_due_to_motor_neuron_disease, 
                  sequelae.moderate_motor_impairment_due_to_motor_neuron_disease, 
                  sequelae.severe_motor_impairment_due_to_motor_neuron_disease, 
                  sequelae.mild_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease, 
                  sequelae.moderate_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease, 
                  sequelae.severe_respiratory_problems_and_speech_problems_due_to_motor_neuron_disease, 
                  sequelae.mild_respiratory_problems_due_to_motor_neuron_disease, 
                  sequelae.moderate_respiratory_problems_due_to_motor_neuron_disease, 
                  sequelae.severe_respiratory_problems_due_to_motor_neuron_disease, 
                  sequelae.speech_problems_due_to_motor_neuron_disease, sequelae.diagnosis_of_motor_neuron_disease, 
                  sequelae.mild_motor_impairment_and_moderate_respiratory_problems_due_to_motor_neuron_disease, ),
        etiologies=(),
    ),
    'other_neurological_disorders': Cause(
        name='other_neurological_disorders',
        kind='cause',
        gbd_id=c_id(557),
        me_id=me_id(1962),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=4,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.other_neurological_disorders, 
                  sequelae.guillain_barre_syndrome_due_to_other_neurological_disorders, ),
        etiologies=(),
    ),
    'mental_disorders': Cause(
        name='mental_disorders',
        kind='cause',
        gbd_id=c_id(558),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'schizophrenia': Cause(
        name='schizophrenia',
        kind='cause',
        gbd_id=c_id(559),
        me_id=me_id(1964),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.schizophrenia_acute_state, sequelae.schizophrenia_residual_state, ),
        etiologies=(),
    ),
    'alcohol_use_disorders': Cause(
        name='alcohol_use_disorders',
        kind='cause',
        gbd_id=c_id(560),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_alcohol_dependence, sequelae.moderate_alcohol_dependence, 
                  sequelae.severe_alcohol_dependence, sequelae.mild_fetal_alcohol_syndrome, 
                  sequelae.moderate_fetal_alcohol_syndrome, sequelae.severe_fetal_alcohol_syndrome, 
                  sequelae.very_mild_alcohol_dependence, sequelae.asymptomatic_alcohol_dependence, 
                  sequelae.asymptomatic_fetal_alcohol_syndrome, ),
        etiologies=(),
    ),
    'drug_use_disorders': Cause(
        name='drug_use_disorders',
        kind='cause',
        gbd_id=c_id(561),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'opioid_use_disorders': Cause(
        name='opioid_use_disorders',
        kind='cause',
        gbd_id=c_id(562),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_opioid_dependence, sequelae.severe_opioid_dependence, 
                  sequelae.asymptomatic_opioid_dependence, ),
        etiologies=(),
    ),
    'cocaine_use_disorders': Cause(
        name='cocaine_use_disorders',
        kind='cause',
        gbd_id=c_id(563),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_cocaine_dependence, sequelae.severe_cocaine_dependence, 
                  sequelae.asymptomatic_cocaine_dependence, ),
        etiologies=(),
    ),
    'amphetamine_use_disorders': Cause(
        name='amphetamine_use_disorders',
        kind='cause',
        gbd_id=c_id(564),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_amphetamine_dependence, sequelae.severe_amphetamine_dependence, 
                  sequelae.asymptomatic_amphetamine_dependence, ),
        etiologies=(),
    ),
    'cannabis_use_disorders': Cause(
        name='cannabis_use_disorders',
        kind='cause',
        gbd_id=c_id(565),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_cannabis_dependence, sequelae.severe_cannabis_dependence, 
                  sequelae.asymptomatic_cannabis_dependence, ),
        etiologies=(),
    ),
    'other_drug_use_disorders': Cause(
        name='other_drug_use_disorders',
        kind='cause',
        gbd_id=c_id(566),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.other_drug_use_disorders, ),
        etiologies=(),
    ),
    'depressive_disorders': Cause(
        name='depressive_disorders',
        kind='cause',
        gbd_id=c_id(567),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'major_depressive_disorder': Cause(
        name='major_depressive_disorder',
        kind='cause',
        gbd_id=c_id(568),
        me_id=me_id(1981),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_major_depressive_disorder, sequelae.moderate_major_depressive_disorder, 
                  sequelae.severe_major_depressive_disorder, 
                  sequelae.major_depressive_disorder_currently_without_symptoms, ),
        etiologies=(),
    ),
    'dysthymia': Cause(
        name='dysthymia',
        kind='cause',
        gbd_id=c_id(569),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.symptomatic_dysthymia, sequelae.dysthymia_currently_without_symptoms, ),
        etiologies=(),
    ),
    'bipolar_disorder': Cause(
        name='bipolar_disorder',
        kind='cause',
        gbd_id=c_id(570),
        me_id=me_id(1986),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.bipolar_disorder_manic_state, sequelae.bipolar_disorder_residual_state, 
                  sequelae.bipolar_disorder_depressive_state, ),
        etiologies=(),
    ),
    'anxiety_disorders': Cause(
        name='anxiety_disorders',
        kind='cause',
        gbd_id=c_id(571),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_anxiety_disorders, sequelae.moderate_anxiety_disorders, 
                  sequelae.severe_anxiety_disorders, sequelae.anxiety_disorders_currently_without_symptoms, ),
        etiologies=(),
    ),
    'eating_disorders': Cause(
        name='eating_disorders',
        kind='cause',
        gbd_id=c_id(572),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=6,
            yll_age_group_id_end=13,
            yld_age_group_id_start=6,
            yld_age_group_id_end=13,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'anorexia_nervosa': Cause(
        name='anorexia_nervosa',
        kind='cause',
        gbd_id=c_id(573),
        me_id=me_id(1993),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=6,
            yll_age_group_id_end=13,
            yld_age_group_id_start=6,
            yld_age_group_id_end=13,
        ),
        sequelae=(sequelae.anorexia_nervosa, ),
        etiologies=(),
    ),
    'bulimia_nervosa': Cause(
        name='bulimia_nervosa',
        kind='cause',
        gbd_id=c_id(574),
        me_id=me_id(1994),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=6,
            yll_age_group_id_end=13,
            yld_age_group_id_start=6,
            yld_age_group_id_end=13,
        ),
        sequelae=(sequelae.bulimia_nervosa, ),
        etiologies=(),
    ),
    'autism_spectrum_disorders': Cause(
        name='autism_spectrum_disorders',
        kind='cause',
        gbd_id=c_id(575),
        me_id=me_id(18668),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.autism_spectrum_disorders_without_intellectual_disability, 
                  sequelae.autism_spectrum_disorders_with_borderline_intellectual_disability, 
                  sequelae.autism_spectrum_disorders_with_mild_intellectual_disability, 
                  sequelae.autism_spectrum_disorders_with_moderate_intellectual_disability, 
                  sequelae.autism_spectrum_disorders_with_severe_intellectual_disability, 
                  sequelae.autism_spectrum_disorders_with_profound_intellectual_disability, ),
        etiologies=(),
    ),
    'attention_deficit_hyperactivity_disorder': Cause(
        name='attention_deficit_hyperactivity_disorder',
        kind='cause',
        gbd_id=c_id(578),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.symptomatic_attention_deficit_hyperactivity_disorder, 
                  sequelae.attention_deficit_hyperactivity_disorder_currently_without_symptoms, ),
        etiologies=(),
    ),
    'conduct_disorder': Cause(
        name='conduct_disorder',
        kind='cause',
        gbd_id=c_id(579),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=6,
            yld_age_group_id_end=7,
        ),
        sequelae=(sequelae.symptomatic_conduct_disorder, sequelae.conduct_disorder_currently_without_symptoms, ),
        etiologies=(),
    ),
    'idiopathic_developmental_intellectual_disability': Cause(
        name='idiopathic_developmental_intellectual_disability',
        kind='cause',
        gbd_id=c_id(582),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.borderline_idiopathic_developmental_intellectual_disability, 
                  sequelae.mild_idiopathic_developmental_intellectual_disability, 
                  sequelae.moderate_idiopathic_developmental_intellectual_disability, 
                  sequelae.severe_idiopathic_developmental_intellectual_disability, 
                  sequelae.profound_idiopathic_developmental_intellectual_disability, ),
        etiologies=(),
    ),
    'other_mental_disorders': Cause(
        name='other_mental_disorders',
        kind='cause',
        gbd_id=c_id(585),
        me_id=me_id(2926),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_other_mental_disorders, sequelae.moderate_other_mental_disorders, 
                  sequelae.severe_other_mental_disorders, sequelae.other_mental_disorders_currently_without_symptoms, ),
        etiologies=(),
    ),
    'diabetes_mellitus': Cause(
        name='diabetes_mellitus',
        kind='cause',
        gbd_id=c_id(587),
        me_id=me_id(2005),
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'acute_glomerulonephritis': Cause(
        name='acute_glomerulonephritis',
        kind='cause',
        gbd_id=c_id(588),
        me_id=me_id(24695),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.acute_glomerulonephritis, ),
        etiologies=(),
    ),
    'chronic_kidney_disease': Cause(
        name='chronic_kidney_disease',
        kind='cause',
        gbd_id=c_id(589),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'chronic_kidney_disease_due_to_hypertension': Cause(
        name='chronic_kidney_disease_due_to_hypertension',
        kind='cause',
        gbd_id=c_id(591),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.end_stage_renal_disease_after_transplant_due_to_hypertension, 
                  sequelae.stage_3_chronic_kidney_disease_and_mild_anemia_due_to_hypertension, 
                  sequelae.stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_hypertension, 
                  sequelae.stage_3_chronic_kidney_disease_and_severe_anemia_due_to_hypertension, 
                  sequelae.stage_3_chronic_kidney_disease_without_anemia_due_to_hypertension, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_hypertension, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_hypertension, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_hypertension, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_hypertension, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_hypertension, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_hypertension, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_hypertension, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_hypertension, 
                  sequelae.stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_hypertension, 
                  sequelae.end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_hypertension, 
                  sequelae.end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_hypertension, 
                  sequelae.end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_hypertension, 
                  sequelae.end_stage_renal_disease_on_dialysis_without_anemia_due_to_hypertension, ),
        etiologies=(),
    ),
    'chronic_kidney_disease_due_to_glomerulonephritis': Cause(
        name='chronic_kidney_disease_due_to_glomerulonephritis',
        kind='cause',
        gbd_id=c_id(592),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.end_stage_renal_disease_after_transplant_due_to_glomerulonephritis, 
                  sequelae.stage_3_chronic_kidney_disease_and_mild_anemia_due_to_glomerulonephritis, 
                  sequelae.stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_glomerulonephritis, 
                  sequelae.stage_3_chronic_kidney_disease_and_severe_anemia_due_to_glomerulonephritis, 
                  sequelae.stage_3_chronic_kidney_disease_without_anemia_due_to_glomerulonephritis, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_glomerulonephritis, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_glomerulonephritis, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_glomerulonephritis, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_glomerulonephritis, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_glomerulonephritis, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_glomerulonephritis, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_glomerulonephritis, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_glomerulonephritis, 
                  sequelae.stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_glomerulonephritis, 
                  sequelae.end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_glomerulonephritis, 
                  sequelae.end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_glomerulonephritis, 
                  sequelae.end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_glomerulonephritis, 
                  sequelae.end_stage_renal_disease_on_dialysis_without_anemia_due_to_glomerulonephritis, ),
        etiologies=(),
    ),
    'chronic_kidney_disease_due_to_other_and_unspecified_causes': Cause(
        name='chronic_kidney_disease_due_to_other_and_unspecified_causes',
        kind='cause',
        gbd_id=c_id(593),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.end_stage_renal_disease_after_transplant_due_to_other_and_unspecified_causes, 
                  sequelae.stage_3_chronic_kidney_disease_and_mild_anemia_due_to_other_causes, 
                  sequelae.stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_other_causes, 
                  sequelae.stage_3_chronic_kidney_disease_and_severe_anemia_due_to_other_causes, 
                  sequelae.stage_3_chronic_kidney_disease_without_anemia_due_to_other_causes, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_other_causes, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_other_causes, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_other_causes, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_other_causes, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_other_causes, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_other_causes, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_other_causes, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_other_causes, 
                  sequelae.stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_other_causes, 
                  sequelae.end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_other_and_unspecified_causes, 
                  sequelae.end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_other_and_unspecified_causes, 
                  sequelae.end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_other_and_unspecified_causes, 
                  sequelae.end_stage_renal_disease_on_dialysis_without_anemia_due_to_other_and_unspecified_causes, ),
        etiologies=(),
    ),
    'urinary_diseases_and_male_infertility': Cause(
        name='urinary_diseases_and_male_infertility',
        kind='cause',
        gbd_id=c_id(594),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'urinary_tract_infections_and_interstitial_nephritis': Cause(
        name='urinary_tract_infections_and_interstitial_nephritis',
        kind='cause',
        gbd_id=c_id(595),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_urinary_tract_infections, sequelae.moderate_urinary_tract_infections, ),
        etiologies=(),
    ),
    'urolithiasis': Cause(
        name='urolithiasis',
        kind='cause',
        gbd_id=c_id(596),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_urolithiasis_episodes, sequelae.moderate_urolithiasis_episodes, 
                  sequelae.severe_urolithiasis_episodes, ),
        etiologies=(),
    ),
    'benign_prostatic_hyperplasia': Cause(
        name='benign_prostatic_hyperplasia',
        kind='cause',
        gbd_id=c_id(597),
        me_id=me_id(2060),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=True,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=13,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.asymptomatic_benign_prostatic_hyperplasia, 
                  sequelae.symptomatic_benign_prostatic_hyperplasia, ),
        etiologies=(),
    ),
    'male_infertility': Cause(
        name='male_infertility',
        kind='cause',
        gbd_id=c_id(598),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=True,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=9,
            yld_age_group_id_end=16,
        ),
        sequelae=(sequelae.idiopathic_primary_male_infertility, sequelae.idiopathic_secondary_male_infertility, ),
        etiologies=(),
    ),
    'other_urinary_diseases': Cause(
        name='other_urinary_diseases',
        kind='cause',
        gbd_id=c_id(602),
        me_id=me_id(2063),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.other_urinary_diseases, ),
        etiologies=(),
    ),
    'gynecological_diseases': Cause(
        name='gynecological_diseases',
        kind='cause',
        gbd_id=c_id(603),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'uterine_fibroids': Cause(
        name='uterine_fibroids',
        kind='cause',
        gbd_id=c_id(604),
        me_id=me_id(2064),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.asymptomatic_uterine_fibroids, 
                  sequelae.mild_abdominal_pain_due_to_uterine_fibroids_with_mild_anemia, 
                  sequelae.mild_abdominal_pain_due_to_uterine_fibroids_with_moderate_anemia, 
                  sequelae.mild_abdominal_pain_due_to_uterine_fibroids_with_severe_anemia, 
                  sequelae.mild_abdominal_pain_due_to_uterine_fibroids_without_anemia, ),
        etiologies=(),
    ),
    'polycystic_ovarian_syndrome': Cause(
        name='polycystic_ovarian_syndrome',
        kind='cause',
        gbd_id=c_id(605),
        me_id=me_id(2068),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=7,
            yld_age_group_id_end=14,
        ),
        sequelae=(sequelae.primary_infertility_due_to_polycystic_ovarian_syndrome, 
                  sequelae.asymptomatic_polycystic_ovarian_syndrome, 
                  sequelae.hirsutism_due_to_polycystic_ovarian_syndrome, 
                  sequelae.hirsutism_and_primary_infertility_due_to_polycystic_ovarian_syndrome, 
                  sequelae.hirsutism_and_secondary_infertility_due_to_polycystic_ovarian_syndrome, 
                  sequelae.secondary_infertility_due_to_polycystic_ovarian_syndrome, ),
        etiologies=(),
    ),
    'female_infertility': Cause(
        name='female_infertility',
        kind='cause',
        gbd_id=c_id(606),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=9,
            yld_age_group_id_end=14,
        ),
        sequelae=(sequelae.idiopathic_primary_female_infertility, sequelae.idiopathic_secondary_female_infertility, ),
        etiologies=(),
    ),
    'endometriosis': Cause(
        name='endometriosis',
        kind='cause',
        gbd_id=c_id(607),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=14,
            yld_age_group_id_start=7,
            yld_age_group_id_end=14,
        ),
        sequelae=(sequelae.mild_abdominal_pain_due_to_endometriosis, 
                  sequelae.moderate_abdominal_pain_due_to_endometriosis, 
                  sequelae.primary_infertility_due_to_endometriosis, 
                  sequelae.secondary_infertility_due_to_endometriosis, sequelae.asymptomatic_endometriosis, 
                  sequelae.mild_abdominal_pain_and_primary_infertility_due_to_endometriosis, 
                  sequelae.moderate_abdominal_pain_and_primary_infertility_due_to_endometriosis, 
                  sequelae.severe_abdominal_pain_and_primary_infertility_due_to_endometriosis, 
                  sequelae.mild_abdominal_pain_and_secondary_infertility_due_to_endometriosis, 
                  sequelae.moderate_abdominal_pain_and_secondary_infertility_due_to_endometriosis, 
                  sequelae.severe_abdominal_pain_and_secondary_infertility_due_to_endometriosis, 
                  sequelae.severe_abdominal_pain_due_to_endometriosis, ),
        etiologies=(),
    ),
    'genital_prolapse': Cause(
        name='genital_prolapse',
        kind='cause',
        gbd_id=c_id(608),
        me_id=me_id(2078),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.asymptomatic_genital_prolapse, sequelae.abdominal_pain_due_to_genital_prolapse, 
                  sequelae.stress_incontinence_due_to_genital_prolapse, 
                  sequelae.abdominal_pain_and_stress_incontinence_due_to_genital_prolapse, ),
        etiologies=(),
    ),
    'premenstrual_syndrome': Cause(
        name='premenstrual_syndrome',
        kind='cause',
        gbd_id=c_id(609),
        me_id=me_id(2079),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=7,
            yld_age_group_id_end=14,
        ),
        sequelae=(sequelae.abdominal_pain_due_to_premenstrual_syndrome, 
                  sequelae.depression_due_to_premenstrual_syndrome, sequelae.asymptomatic_premenstrual_syndrome, 
                  sequelae.abdominal_pain_and_depression_due_to_premenstrual_syndrome, ),
        etiologies=(),
    ),
    'other_gynecological_diseases': Cause(
        name='other_gynecological_diseases',
        kind='cause',
        gbd_id=c_id(612),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_anemia_due_to_menstrual_disorders, 
                  sequelae.moderate_anemia_due_to_menstrual_disorders, 
                  sequelae.severe_anemia_due_to_menstrual_disorders, 
                  sequelae.asymptomatic_other_gynecological_disorders, sequelae.mild_other_gynecological_disorders, 
                  sequelae.moderate_other_gynecological_disorders, sequelae.severe_other_gynecological_disorders, 
                  sequelae.menstrual_disorders_without_anemia, ),
        etiologies=(),
    ),
    'hemoglobinopathies_and_hemolytic_anemias': Cause(
        name='hemoglobinopathies_and_hemolytic_anemias',
        kind='cause',
        gbd_id=c_id(613),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'thalassemias': Cause(
        name='thalassemias',
        kind='cause',
        gbd_id=c_id(614),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_heart_failure_due_to_thalassemias, 
                  sequelae.moderate_heart_failure_due_to_thalassemias, 
                  sequelae.severe_heart_failure_due_to_thalassemias, 
                  sequelae.beta_thalassemia_major_severe_infection_with_severe_anemia, 
                  sequelae.beta_thalassemia_major_with_mild_anemia, 
                  sequelae.beta_thalassemia_major_with_moderate_anemia, 
                  sequelae.beta_thalassemia_major_with_severe_anemia, 
                  sequelae.hemoglobin_e_beta_thalassemia_severe_infection_with_severe_anemia, 
                  sequelae.hemoglobin_e_beta_thalassemia_with_mild_anemia, 
                  sequelae.hemoglobin_e_beta_thalassemia_with_moderate_anemia, 
                  sequelae.hemoglobin_e_beta_thalassemia_with_severe_anemia, 
                  sequelae.hemoglobin_h_disease_severe_infection_with_severe_anemia, 
                  sequelae.hemoglobin_h_disease_with_mild_anemia, sequelae.hemoglobin_h_disease_with_moderate_anemia, 
                  sequelae.hemoglobin_h_disease_with_severe_anemia, sequelae.hemoglobin_h_disease_without_anemia, 
                  sequelae.beta_thalassemia_major_without_anemia, 
                  sequelae.hemoglobin_e_beta_thalassemia_without_anemia, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_thalassemias, ),
        etiologies=(),
    ),
    'sickle_cell_disorders': Cause(
        name='sickle_cell_disorders',
        kind='cause',
        gbd_id=c_id(615),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_without_anemia, 
                  sequelae.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_without_anemia, 
                  sequelae.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_severe_anemia, 
                  sequelae.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_stroke_and_severe_anemia, 
                  sequelae.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_stroke_without_anemia, 
                  sequelae.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_stroke_and_severe_anemia, 
                  sequelae.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_stroke_without_anemia, 
                  sequelae.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_mild_anemia, 
                  sequelae.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_moderate_anemia, 
                  sequelae.homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia_with_severe_anemia, 
                  sequelae.hemoglobin_sc_disease_without_anemia, 
                  sequelae.hemoglobin_sc_disease_with_vaso_occlusive_crisis_and_severe_anemia, 
                  sequelae.hemoglobin_sc_disease_with_vaso_occlusive_crisis_without_anemia, 
                  sequelae.hemoglobin_sc_disease_with_stroke_and_severe_anemia, 
                  sequelae.hemoglobin_sc_disease_with_stroke_without_anemia, 
                  sequelae.hemoglobin_sc_disease_with_vaso_occlusive_crisis_stroke_and_severe_anemia, 
                  sequelae.hemoglobin_sc_disease_with_vaso_occlusive_crisis_and_stroke_without_anemia, 
                  sequelae.hemoglobin_sc_disease_with_mild_anemia, 
                  sequelae.hemoglobin_sc_disease_with_moderate_anemia, 
                  sequelae.hemoglobin_sc_disease_with_severe_anemia, 
                  sequelae.mild_sickle_cell_beta_thalassemia_without_anemia, 
                  sequelae.mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_severe_anemia, 
                  sequelae.mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_without_anemia, 
                  sequelae.mild_sickle_cell_beta_thalassemia_with_stroke_and_severe_anemia, 
                  sequelae.mild_sickle_cell_beta_thalassemia_with_stroke_without_anemia, 
                  sequelae.mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_stroke_and_severe_anemia, 
                  sequelae.mild_sickle_cell_beta_thalassemia_with_vaso_occlusive_crisis_and_stroke_without_anemia, 
                  sequelae.mild_sickle_cell_beta_thalassemia_with_mild_anemia, 
                  sequelae.mild_sickle_cell_beta_thalassemia_with_moderate_anemia, 
                  sequelae.mild_sickle_cell_beta_thalassemia_with_severe_anemia, 
                  sequelae.other_combined_sequelae_of_homozygous_sickle_cell_and_severe_sickle_cell_beta_thalassemia, 
                  sequelae.other_combined_sequelae_of_hemoglobin_sc_disease, 
                  sequelae.other_combined_sequelae_of_mild_sickle_cell_beta_thalassemia_exclusivity_adjustment, ),
        etiologies=(),
    ),
    'g6pd_deficiency': Cause(
        name='g6pd_deficiency',
        kind='cause',
        gbd_id=c_id(616),
        me_id=me_id(2112),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_anemia_due_to_g6pd_deficiency, sequelae.moderate_anemia_due_to_g6pd_deficiency, 
                  sequelae.severe_anemia_due_to_g6pd_deficiency, sequelae.mild_heart_failure_due_to_g6pd_deficiency, 
                  sequelae.moderate_heart_failure_due_to_g6pd_deficiency, 
                  sequelae.severe_heart_failure_due_to_g6pd_deficiency, sequelae.asymptomatic_g6pd_deficiency, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_g6pd_deficiency, ),
        etiologies=(),
    ),
    'other_hemoglobinopathies_and_hemolytic_anemias': Cause(
        name='other_hemoglobinopathies_and_hemolytic_anemias',
        kind='cause',
        gbd_id=c_id(618),
        me_id=me_id(2800),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias, 
                  sequelae.moderate_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias, 
                  sequelae.severe_anemia_due_to_other_hemoglobinopathies_and_hemolytic_anemias, 
                  sequelae.mild_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias, 
                  sequelae.moderate_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias, 
                  sequelae.severe_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias, 
                  sequelae.other_hemoglobinopathies_and_hemolytic_anemias_residual, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_other_hemoglobinopathies_and_hemolytic_anemias, ),
        etiologies=(),
    ),
    'endocrine_metabolic_blood_and_immune_disorders': Cause(
        name='endocrine_metabolic_blood_and_immune_disorders',
        kind='cause',
        gbd_id=c_id(619),
        me_id=me_id(2125),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders, 
                  sequelae.moderate_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders, 
                  sequelae.severe_anemia_due_to_endocrine_metabolic_blood_and_immune_disorders, 
                  sequelae.mild_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders, 
                  sequelae.moderate_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders, 
                  sequelae.severe_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders, 
                  sequelae.asymptomatic_endocrine_metabolic_blood_and_immune_disorders, 
                  sequelae.mild_endocrine_metabolic_blood_and_immune_disorders, 
                  sequelae.moderate_endocrine_metabolic_blood_and_immune_disorders, 
                  sequelae.severe_endocrine_metabolic_blood_and_immune_disorders, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_endocrine_metabolic_blood_and_immune_disorders, ),
        etiologies=(),
    ),
    'musculoskeletal_disorders': Cause(
        name='musculoskeletal_disorders',
        kind='cause',
        gbd_id=c_id(626),
        me_id=me_id(25707),
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=6,
            yll_age_group_id_end=235,
            yld_age_group_id_start=6,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'rheumatoid_arthritis': Cause(
        name='rheumatoid_arthritis',
        kind='cause',
        gbd_id=c_id(627),
        me_id=me_id(2137),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=6,
            yll_age_group_id_end=235,
            yld_age_group_id_start=6,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_rheumatoid_arthritis, sequelae.moderate_rheumatoid_arthritis, 
                  sequelae.severe_rheumatoid_arthritis, sequelae.asymptomatic_rheumatoid_arthritis, ),
        etiologies=(),
    ),
    'osteoarthritis': Cause(
        name='osteoarthritis',
        kind='cause',
        gbd_id=c_id(628),
        me_id=me_id(25708),
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=11,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'low_back_pain': Cause(
        name='low_back_pain',
        kind='cause',
        gbd_id=c_id(630),
        me_id=me_id(2149),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=6,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.severe_low_back_pain_with_leg_pain, sequelae.severe_low_back_pain_without_leg_pain, 
                  sequelae.most_severe_low_back_pain_with_leg_pain, 
                  sequelae.most_severe_low_back_pain_without_leg_pain, sequelae.mild_low_back_pain_with_leg_pain, 
                  sequelae.mild_low_back_pain_without_leg_pain, sequelae.moderate_low_back_pain_with_leg_pain, 
                  sequelae.moderate_low_back_pain_without_leg_pain, ),
        etiologies=(),
    ),
    'neck_pain': Cause(
        name='neck_pain',
        kind='cause',
        gbd_id=c_id(631),
        me_id=me_id(2154),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=6,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_neck_pain, sequelae.severe_neck_pain, sequelae.moderate_neck_pain, 
                  sequelae.most_severe_neck_pain, ),
        etiologies=(),
    ),
    'gout': Cause(
        name='gout',
        kind='cause',
        gbd_id=c_id(632),
        me_id=me_id(25712),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.polyarticular_gout, sequelae.symptomatic_episodes_of_gout, sequelae.asymptomatic_gout, ),
        etiologies=(),
    ),
    'other_musculoskeletal_disorders': Cause(
        name='other_musculoskeletal_disorders',
        kind='cause',
        gbd_id=c_id(639),
        me_id=me_id(3136),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=6,
            yll_age_group_id_end=235,
            yld_age_group_id_start=6,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.other_musculoskeletal_disorders_severity_level_2, 
                  sequelae.other_musculoskeletal_disorders_severity_level_3, 
                  sequelae.other_musculoskeletal_disorders_severity_level_5, 
                  sequelae.other_musculoskeletal_disorders_severity_level_6, 
                  sequelae.other_musculoskeletal_disorders_severity_level_1, 
                  sequelae.other_musculoskeletal_disorders_severity_level_4, 
                  sequelae.asymptomatic_other_musculoskeletal_disorders, ),
        etiologies=(),
    ),
    'other_non_communicable_diseases': Cause(
        name='other_non_communicable_diseases',
        kind='cause',
        gbd_id=c_id(640),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'congenital_birth_defects': Cause(
        name='congenital_birth_defects',
        kind='cause',
        gbd_id=c_id(641),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=17,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'neural_tube_defects': Cause(
        name='neural_tube_defects',
        kind='cause',
        gbd_id=c_id(642),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=17,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.severe_motor_and_cognitive_impairment_due_to_anencephaly, 
                  sequelae.asymptomatic_encephalocele_following_treatment, 
                  sequelae.borderline_intellectual_disability_due_to_encephalocele, 
                  sequelae.mild_intellectual_disability_due_to_encephalocele, 
                  sequelae.moderate_intellectual_disability_due_to_encephalocele, 
                  sequelae.severe_intellectual_disability_due_to_encephalocele, 
                  sequelae.profound_intellectual_disability_due_to_encephalocele, 
                  sequelae.incontinence_due_to_encephalocele, 
                  sequelae.borderline_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.mild_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.moderate_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.severe_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.profound_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.mild_motor_impairment_due_to_spina_bifida, 
                  sequelae.moderate_motor_impairment_due_to_spina_bifida, 
                  sequelae.severe_motor_impairment_due_to_spina_bifida, 
                  sequelae.mild_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida, 
                  sequelae.moderate_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida, 
                  sequelae.severe_motor_impairment_and_borderline_intellectual_disability_due_to_spina_bifida, 
                  sequelae.mild_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida, 
                  sequelae.moderate_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida, 
                  sequelae.severe_motor_impairment_and_mild_intellectual_disability_due_to_spina_bifida, 
                  sequelae.mild_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida, 
                  sequelae.moderate_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida, 
                  sequelae.severe_motor_impairment_and_moderate_intellectual_disability_due_to_spina_bifida, 
                  sequelae.mild_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida, 
                  sequelae.moderate_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida, 
                  sequelae.severe_motor_impairment_and_severe_intellectual_disability_due_to_spina_bifida, 
                  sequelae.mild_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida, 
                  sequelae.moderate_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida, 
                  sequelae.severe_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_spina_bifida, 
                  sequelae.mild_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida, 
                  sequelae.moderate_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida, 
                  sequelae.severe_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_spina_bifida, 
                  sequelae.mild_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida, 
                  sequelae.moderate_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida, 
                  sequelae.severe_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_spina_bifida, 
                  sequelae.mild_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida, 
                  sequelae.moderate_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida, 
                  sequelae.severe_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_spina_bifida, 
                  sequelae.mild_motor_impairment_and_incontinence_due_to_spina_bifida, 
                  sequelae.moderate_motor_impairment_and_incontinence_due_to_spina_bifida, 
                  sequelae.severe_motor_impairment_and_incontinence_due_to_spina_bifida, 
                  sequelae.mild_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida, 
                  sequelae.moderate_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida, 
                  sequelae.severe_motor_impairment_and_profound_intellectual_disability_due_to_spina_bifida, 
                  sequelae.mild_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida, 
                  sequelae.moderate_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida, 
                  sequelae.severe_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_spina_bifida, 
                  sequelae.mild_motor_impairment_due_to_encephalocele, 
                  sequelae.moderate_motor_impairment_due_to_encephalocele, 
                  sequelae.severe_motor_impairment_due_to_encephalocele, 
                  sequelae.mild_motor_impairment_and_incontinence_due_to_encephalocele, 
                  sequelae.moderate_motor_impairment_and_incontinence_due_to_encephalocele, 
                  sequelae.severe_motor_impairment_and_incontinence_due_to_encephalocele, 
                  sequelae.mild_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele, 
                  sequelae.moderate_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele, 
                  sequelae.severe_motor_impairment_and_borderline_intellectual_disability_due_to_encephalocele, 
                  sequelae.mild_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele, 
                  sequelae.moderate_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele, 
                  sequelae.severe_motor_impairment_and_mild_intellectual_disability_due_to_encephalocele, 
                  sequelae.mild_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele, 
                  sequelae.moderate_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele, 
                  sequelae.severe_motor_impairment_and_moderate_intellectual_disability_due_to_encephalocele, 
                  sequelae.mild_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele, 
                  sequelae.moderate_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele, 
                  sequelae.severe_motor_impairment_and_severe_intellectual_disability_due_to_encephalocele, 
                  sequelae.mild_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele, 
                  sequelae.moderate_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele, 
                  sequelae.severe_motor_impairment_and_profound_intellectual_disability_due_to_encephalocele, 
                  sequelae.mild_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.moderate_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.severe_motor_impairment_borderline_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.mild_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.moderate_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.severe_motor_impairment_mild_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.mild_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.moderate_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.severe_motor_impairment_moderate_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.mild_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.moderate_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.severe_motor_impairment_severe_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.mild_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.moderate_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele, 
                  sequelae.severe_motor_impairment_profound_intellectual_disability_and_incontinence_due_to_encephalocele, ),
        etiologies=(),
    ),
    'congenital_heart_anomalies': Cause(
        name='congenital_heart_anomalies',
        kind='cause',
        gbd_id=c_id(643),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=17,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.asymptomatic_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_other_congenital_cardiovascular_anomalies, 
                  sequelae.congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies, 
                  sequelae.congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies, 
                  sequelae.congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies, 
                  sequelae.congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies, 
                  sequelae.congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_other_congenital_cardiovascular_anomalies, 
                  sequelae.congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_without_intellectual_disability_or_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_without_heart_failure_or_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_and_severe_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_without_heart_failure_or_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_and_borderline_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_and_mild_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_and_moderate_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_and_severe_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_and_profound_intellectual_disability_without_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_and_mild_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_borderline_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_mild_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_moderate_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_severe_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_profound_intellectual_disability_and_mild_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_and_moderate_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_borderline_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_mild_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_moderate_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_severe_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_profound_intellectual_disability_and_moderate_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_and_severe_heart_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_borderline_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_mild_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_moderate_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_severe_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_profound_intellectual_disability_and_severe_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_and_controlled_medically_managed_heart_failure_without_intellectual_disability_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_borderline_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_mild_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_moderate_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, 
                  sequelae.congenital_heart_disease_profound_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_critical_malformations_of_great_vessels_congenital_valvular_heart_disease_and_patent_ductus_arteriosus, 
                  sequelae.congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_severe_congenital_heart_anomalies_excluding_single_ventricle_heart_defects, 
                  sequelae.congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_single_ventricle_and_single_ventricle_pathway_heart_defects, 
                  sequelae.congenital_heart_disease_severe_intellectual_disability_and_controlled_medically_managed_heart_failure_due_to_ventricular_septal_defect_and_atrial_septal_defect, ),
        etiologies=(),
    ),
    'orofacial_clefts': Cause(
        name='orofacial_clefts',
        kind='cause',
        gbd_id=c_id(644),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=4,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.disfigurement_level_1_due_to_orofacial_clefts, 
                  sequelae.disfigurement_level_2_due_to_orofacial_clefts, 
                  sequelae.disfigurement_level_2_and_speech_problems_due_to_orofacial_clefts, ),
        etiologies=(),
    ),
    'down_syndrome': Cause(
        name='down_syndrome',
        kind='cause',
        gbd_id=c_id(645),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=17,
            yld_age_group_id_start=2,
            yld_age_group_id_end=17,
        ),
        sequelae=(sequelae.isolated_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.asymptomatic_down_syndrome, 
                  sequelae.borderline_intellectual_disability_due_to_down_syndrome, 
                  sequelae.mild_intellectual_disability_due_to_down_syndrome, 
                  sequelae.moderate_intellectual_disability_due_to_down_syndrome, 
                  sequelae.severe_intellectual_disability_due_to_down_syndrome, 
                  sequelae.profound_intellectual_disability_due_to_down_syndrome, 
                  sequelae.borderline_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.mild_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.moderate_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.severe_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.profound_intellectual_disability_with_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.mild_dementia_due_to_down_syndrome, sequelae.moderate_dementia_due_to_down_syndrome, 
                  sequelae.severe_dementia_due_to_down_syndrome, 
                  sequelae.congenital_heart_disease_and_mild_dementia_due_to_down_syndrome, 
                  sequelae.congenital_heart_disease_and_moderate_dementia_due_to_down_syndrome, 
                  sequelae.congenital_heart_disease_and_severe_dementia_due_to_down_syndrome, 
                  sequelae.borderline_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.mild_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.moderate_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.severe_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.profound_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.borderline_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.mild_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.moderate_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.severe_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.profound_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.borderline_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.mild_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.moderate_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.severe_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.profound_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_down_syndrome, 
                  sequelae.profound_intellectual_disability_and_mild_dementia_due_to_down_syndrome, 
                  sequelae.severe_intellectual_disability_and_mild_dementia_due_to_down_syndrome, 
                  sequelae.moderate_intellectual_disability_and_mild_dementia_due_to_down_syndrome, 
                  sequelae.mild_intellectual_disability_and_mild_dementia_due_to_down_syndrome, 
                  sequelae.borderline_intellectual_disability_and_mild_dementia_due_to_down_syndrome, 
                  sequelae.profound_intellectual_disability_and_moderate_dementia_due_to_down_syndrome, 
                  sequelae.severe_intellectual_disability_and_moderate_dementia_due_to_down_syndrome, 
                  sequelae.moderate_intellectual_disability_and_moderate_dementia_due_to_down_syndrome, 
                  sequelae.mild_intellectual_disability_and_moderate_dementia_due_to_down_syndrome, 
                  sequelae.borderline_intellectual_disability_and_moderate_dementia_due_to_down_syndrome, 
                  sequelae.profound_intellectual_disability_and_severe_dementia_due_to_down_syndrome, 
                  sequelae.severe_intellectual_disability_and_severe_dementia_due_to_down_syndrome, 
                  sequelae.moderate_intellectual_disability_and_severe_dementia_due_to_down_syndrome, 
                  sequelae.mild_intellectual_disability_and_severe_dementia_due_to_down_syndrome, 
                  sequelae.borderline_intellectual_disability_and_severe_dementia_due_to_down_syndrome, ),
        etiologies=(),
    ),
    'turner_syndrome': Cause(
        name='turner_syndrome',
        kind='cause',
        gbd_id=c_id(646),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.congenital_heart_disease_due_to_turner_syndrome, 
                  sequelae.primary_infertility_due_to_turner_syndrome, 
                  sequelae.congenital_heart_disease_with_infertility_due_to_turner_syndrome, 
                  sequelae.asymptomatic_turner_syndrome, ),
        etiologies=(),
    ),
    'klinefelter_syndrome': Cause(
        name='klinefelter_syndrome',
        kind='cause',
        gbd_id=c_id(647),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=True,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.borderline_intellectual_disability_due_to_klinefelter_syndrome, 
                  sequelae.mild_intellectual_disability_due_to_klinefelter_syndrome, 
                  sequelae.mild_intellectual_disability_with_infertility_due_to_klinefelter_syndrome, 
                  sequelae.borderline_intellectual_disability_with_infertility_due_to_klinefelter_syndrome, 
                  sequelae.primary_infertility_due_to_klinefelter_syndrome, 
                  sequelae.asymptomatic_klinefelter_syndrome, ),
        etiologies=(),
    ),
    'other_chromosomal_abnormalities': Cause(
        name='other_chromosomal_abnormalities',
        kind='cause',
        gbd_id=c_id(648),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=17,
            yld_age_group_id_start=2,
            yld_age_group_id_end=17,
        ),
        sequelae=(sequelae.asymptomatic_other_chromosomal_abnormalities, 
                  sequelae.isolated_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.borderline_intellectual_disability_due_to_other_chromosomal_abnormalities, 
                  sequelae.mild_intellectual_disability_due_to_other_chromosomal_abnormalities, 
                  sequelae.moderate_intellectual_disability_due_to_other_chromosomal_abnormalities, 
                  sequelae.severe_intellectual_disability_due_to_other_chromosomal_abnormalities, 
                  sequelae.profound_intellectual_disability_due_to_other_chromosomal_abnormalities, 
                  sequelae.borderline_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.mild_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.moderate_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.severe_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.profound_intellectual_disability_with_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.mild_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.moderate_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.severe_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.congenital_heart_disease_and_mild_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.congenital_heart_disease_and_moderate_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.congenital_heart_disease_and_severe_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.borderline_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.mild_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.moderate_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.severe_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.profound_intellectual_disability_mild_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.borderline_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.mild_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.moderate_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.severe_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.profound_intellectual_disability_moderate_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.borderline_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.mild_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.moderate_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.severe_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.profound_intellectual_disability_severe_dementia_and_congenital_heart_disease_due_to_other_chromosomal_abnormalities, 
                  sequelae.profound_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.severe_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.moderate_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.mild_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.borderline_intellectual_disability_and_mild_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.profound_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.severe_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.moderate_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.mild_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.borderline_intellectual_disability_and_moderate_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.profound_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.severe_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.moderate_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.mild_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.borderline_intellectual_disability_and_severe_dementia_due_to_other_chromosomal_abnormalities, 
                  sequelae.severe_motor_and_cognitive_impairment_due_to_edward_syndrome_or_patau_syndrome, 
                  sequelae.severe_motor_and_cognitive_impairment_with_congenital_heart_disease_due_to_edward_syndrome_or_patau_syndrome, ),
        etiologies=(),
    ),
    'congenital_musculoskeletal_and_limb_anomalies': Cause(
        name='congenital_musculoskeletal_and_limb_anomalies',
        kind='cause',
        gbd_id=c_id(649),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=17,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.disfigurement_level_1_due_to_polydactyly_and_syndactyly, 
                  sequelae.disfigurement_level_2_due_to_congenital_limb_deficiency, 
                  sequelae.disfigurement_level_2_with_pain_due_to_congenital_limb_deficiency, 
                  sequelae.disfigurement_level_2_and_mild_motor_impairment_due_to_congenital_limb_deficiency, 
                  sequelae.disfigurement_level_2_and_moderate_motor_impairment_due_to_congenital_limb_deficiency, 
                  sequelae.disfigurement_level_2_with_pain_and_mild_motor_impairment_due_to_congenital_limb_deficiency, 
                  sequelae.disfigurement_level_2_with_pain_and_moderate_motor_impairment_due_to_congenital_limb_deficiency, 
                  sequelae.disfigurement_level_2_due_to_other_congenital_musculoskeletal_anomalies, 
                  sequelae.disfigurement_level_2_with_pain_due_to_other_congenital_musculoskeletal_anomalies, 
                  sequelae.disfigurement_level_2_and_mild_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies, 
                  sequelae.disfigurement_level_2_and_moderate_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies, 
                  sequelae.disfigurement_level_2_with_pain_and_mild_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies, 
                  sequelae.disfigurement_level_2_with_pain_and_moderate_motor_impairment_due_to_other_congenital_musculoskeletal_anomalies, ),
        etiologies=(),
    ),
    'urogenital_congenital_anomalies': Cause(
        name='urogenital_congenital_anomalies',
        kind='cause',
        gbd_id=c_id(650),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=17,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.asymptomatic_congenital_genital_anomalies, 
                  sequelae.atypical_genitalia_due_to_congenital_genital_anomalies, 
                  sequelae.primary_infertility_due_to_congenital_genital_anomalies, 
                  sequelae.impotence_due_to_congenital_genital_anomalies, 
                  sequelae.recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies, 
                  sequelae.atypical_genital_and_recurrent_urinary_tract_infections_and_other_abdominal_issues_due_to_congenital_genital_anomalies, 
                  sequelae.atypical_genitalia_and_primary_infertility_due_to_congenital_genital_anomalies, 
                  sequelae.atypical_genitalia_and_impotence_due_to_congenital_genital_anomalies, 
                  sequelae.primary_infertility_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies, 
                  sequelae.impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_genital_anomalies, 
                  sequelae.infertility_and_impotence_due_to_congenital_genital_anomalies, 
                  sequelae.atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_infertility_due_to_congenital_genital_anomalies, 
                  sequelae.atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies, 
                  sequelae.atypical_genitalia_infertility_and_impotence_due_to_congenital_genital_anomalies, 
                  sequelae.infertility_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies, 
                  sequelae.atypical_genitalia_infertility_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_genital_anomalies, 
                  sequelae.asymptomatic_congenital_anomalies_of_the_urinary_tract, 
                  sequelae.atypical_genitalia_due_to_congenital_anomalies_of_the_urinary_tract, 
                  sequelae.incontinence_due_to_congenital_anomalies_of_the_urinary_tract, 
                  sequelae.impotence_due_to_congenital_anomalies_of_the_urinary_tract, 
                  sequelae.recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract, 
                  sequelae.atypical_genital_and_recurrent_urinary_tract_infections_and_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract, 
                  sequelae.atypical_genitalia_and_incontinence_due_to_congenital_anomalies_of_the_urinary_tract, 
                  sequelae.atypical_genitalia_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract, 
                  sequelae.incontinence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract, 
                  sequelae.impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_due_to_congenital_anomalies_of_the_urinary_tract, 
                  sequelae.incontinence_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract, 
                  sequelae.atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_incontinence_due_to_congenital_anomalies_of_the_urinary_tract, 
                  sequelae.atypical_genitalia_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract, 
                  sequelae.atypical_genitalia_incontinence_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract, 
                  sequelae.incontinence_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract, 
                  sequelae.atypical_genitalia_incontinence_impotence_and_recurrent_urinary_tract_infections_or_other_abdominal_issues_and_impotence_due_to_congenital_anomalies_of_the_urinary_tract, ),
        etiologies=(),
    ),
    'digestive_congenital_anomalies': Cause(
        name='digestive_congenital_anomalies',
        kind='cause',
        gbd_id=c_id(651),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=17,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.asymptomatic_congenital_diaphragmatic_hernia, 
                  sequelae.chronic_abdominal_pain_due_to_congenital_diaphragmatic_hernia, 
                  sequelae.disfigurement_due_to_congenital_diaphragmatic_hernia, 
                  sequelae.mild_chronic_respiratory_problems_and_breathlessness_due_to_congenital_diaphragmatic_hernia, 
                  sequelae.developmental_delay_or_mild_intellectual_disability_due_to_congenital_diaphragmatic_hernia, 
                  sequelae.chronic_abdominal_pain_and_disfigurement_due_to_congenital_diaphragmatic_hernia, 
                  sequelae.chronic_abdominal_pain_and_mild_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia, 
                  sequelae.chronic_abdominal_pain_and_developmental_delay_due_to_congenital_diaphragmatic_hernia, 
                  sequelae.disfigurement_and_mild_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia, 
                  sequelae.disfigurement_and_developmental_delay_due_to_congenital_diaphragmatic_hernia, 
                  sequelae._mild_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia, 
                  sequelae.chronic_abdominal_pain_disfigurement_and_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia, 
                  sequelae.chronic_abdominal_pain_disfigurement_and_developmental_delay_due_to_congenital_diaphragmatic_hernia, 
                  sequelae.chronic_abdominal_pain_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia, 
                  sequelae.disfigurement_chronic_respiratory_problems_and_developmental_delay_due_to_congenital_diaphragmatic_hernia, 
                  sequelae.chronic_abdominal_pain_disfigurement_developmental_delay_and_chronic_respiratory_problems_due_to_congenital_diaphragmatic_hernia, 
                  sequelae.asymptomatic_congenital_atresia_and_or_stenosis_of_the_digestive_tract, 
                  sequelae.dysphagia_or_acid_reflux_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract, 
                  sequelae.chronic_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract, 
                  sequelae.chronic_respiratory_problems_including_difficulty_breaking_and_recurrent_upper_respiratory_infections_due_to_atresia_and_or_stenosis_of_the_digestive_tract, 
                  sequelae.chronic_respiratory_problems_and_dysphagia_or_acid_reflux_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract, 
                  sequelae.chronic_respiratory_problems_and_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract, 
                  sequelae.dysphagia_or_acid_reflux_and_chronic_abdominal_pain_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract, 
                  sequelae.dysphagia_or_acid_reflux_chronic_abdominal_pain_and_chronic_respiratory_problems_due_to_congenital_atresia_and_or_stenosis_of_the_digestive_tract, 
                  sequelae.asymptomatic_congenital_malformations_of_the_abdominal_wall_after_treatment, 
                  sequelae.disfigurement_from_scars_following_treatment_for_congenital_malformations_of_the_abdominal_wall, 
                  sequelae.constipation_due_to_congenital_malformations_of_the_abdominal_wall, 
                  sequelae.chronic_abdominal_pain_due_to_congenital_malformations_of_the_abdominal_wall, 
                  sequelae.constipation_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall, 
                  sequelae.chronic_abdominal_pain_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall, 
                  sequelae.constipation_and_chronic_abdominal_pain_due_to_congenital_malformations_of_the_abdominal_wall, 
                  sequelae.constipation_chronic_abdominal_pain_and_concern_about_scars_due_to_congenital_malformations_of_the_abdominal_wall, 
                  sequelae.asymptomatic_other_congenital_malformations_of_the_digestive_tract, 
                  sequelae.acid_reflux_dyspahgia_and_or_constipation_due_to_other_congenital_malformations_of_the_digestive_tract, 
                  sequelae.chronic_abdominal_pain_and_or_nausea_due_to_other_congenital_malformations_of_the_digestive_tract, 
                  sequelae.chronic_abdominal_pain_and_or_nausea_with_acid_reflux_dyspahgia_and_or_constipation_due_to_other_congenital_malformations_of_the_digestive_tract, ),
        etiologies=(),
    ),
    'other_congenital_birth_defects': Cause(
        name='other_congenital_birth_defects',
        kind='cause',
        gbd_id=c_id(652),
        me_id=me_id(16427),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=17,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_hearing_loss_due_to_other_congenital_anomalies, 
                  sequelae.mild_hearing_loss_with_ringing_due_to_other_congenital_anomalies, 
                  sequelae.moderate_hearing_loss_due_to_other_congenital_anomalies, 
                  sequelae.moderate_hearing_loss_with_ringing_due_to_other_congenital_anomalies, 
                  sequelae.severe_hearing_loss_with_ringing_due_to_other_congenital_anomalies, 
                  sequelae.severe_hearing_loss_due_to_other_congenital_anomalies, 
                  sequelae.complete_hearing_loss_due_to_other_congenital_anomalies, 
                  sequelae.complete_hearing_loss_with_ringing_due_to_other_congenital_anomalies, 
                  sequelae.moderately_severe_hearing_loss_due_to_other_congenital_anomalies, 
                  sequelae.moderately_severe_hearing_loss_with_ringing_due_to_other_congenital_anomalies, 
                  sequelae.profound_hearing_loss_due_to_other_congenital_anomalies, 
                  sequelae.profound_hearing_loss_with_ringing_due_to_other_congenital_anomalies, 
                  sequelae.other_congenital_birth_defects, ),
        etiologies=(),
    ),
    'skin_and_subcutaneous_diseases': Cause(
        name='skin_and_subcutaneous_diseases',
        kind='cause',
        gbd_id=c_id(653),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'dermatitis': Cause(
        name='dermatitis',
        kind='cause',
        gbd_id=c_id(654),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'psoriasis': Cause(
        name='psoriasis',
        kind='cause',
        gbd_id=c_id(655),
        me_id=me_id(2251),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_psoriasis, sequelae.moderate_psoriasis, sequelae.severe_psoriasis, ),
        etiologies=(),
    ),
    'cellulitis': Cause(
        name='cellulitis',
        kind='cause',
        gbd_id=c_id(656),
        me_id=me_id(2255),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_cellulitis, sequelae.severe_cellulitis, sequelae.moderate_cellulitis, ),
        etiologies=(),
    ),
    'pyoderma': Cause(
        name='pyoderma',
        kind='cause',
        gbd_id=c_id(657),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.impetigo, sequelae.abscess_and_other_bacterial_skin_diseases, ),
        etiologies=(),
    ),
    'scabies': Cause(
        name='scabies',
        kind='cause',
        gbd_id=c_id(658),
        me_id=me_id(2262),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.scabies, ),
        etiologies=(),
    ),
    'fungal_skin_diseases': Cause(
        name='fungal_skin_diseases',
        kind='cause',
        gbd_id=c_id(659),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.tinea_capitis, sequelae.other_fungal_skin_diseases, ),
        etiologies=(),
    ),
    'viral_skin_diseases': Cause(
        name='viral_skin_diseases',
        kind='cause',
        gbd_id=c_id(660),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_viral_warts, sequelae.severe_viral_warts, sequelae.mild_molluscum_contagiosum, 
                  sequelae.severe_molluscum_contagiosum, ),
        etiologies=(),
    ),
    'acne_vulgaris': Cause(
        name='acne_vulgaris',
        kind='cause',
        gbd_id=c_id(661),
        me_id=me_id(2275),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=6,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_acne_vulgaris, sequelae.moderate_acne_vulgaris, sequelae.severe_acne_vulgaris, 
                  sequelae.non_disabling_symptomatic_acne, ),
        etiologies=(),
    ),
    'alopecia_areata': Cause(
        name='alopecia_areata',
        kind='cause',
        gbd_id=c_id(662),
        me_id=me_id(2276),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_alopecia_areata, sequelae.severe_alopecia_areata, ),
        etiologies=(),
    ),
    'pruritus': Cause(
        name='pruritus',
        kind='cause',
        gbd_id=c_id(663),
        me_id=me_id(2280),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.pruritus, ),
        etiologies=(),
    ),
    'urticaria': Cause(
        name='urticaria',
        kind='cause',
        gbd_id=c_id(664),
        me_id=me_id(2283),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_urticaria, sequelae.severe_urticaria, ),
        etiologies=(),
    ),
    'decubitus_ulcer': Cause(
        name='decubitus_ulcer',
        kind='cause',
        gbd_id=c_id(665),
        me_id=me_id(2286),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_decubitus_ulcer, sequelae.moderate_decubitus_ulcer, sequelae.severe_decubitus_ulcer, ),
        etiologies=(),
    ),
    'other_skin_and_subcutaneous_diseases': Cause(
        name='other_skin_and_subcutaneous_diseases',
        kind='cause',
        gbd_id=c_id(668),
        me_id=me_id(2290),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.asymptomatic_other_skin_and_subcutaneous_diseases, 
                  sequelae.symptomatic_other_skin_and_subcutaneous_diseases, ),
        etiologies=(),
    ),
    'sense_organ_diseases': Cause(
        name='sense_organ_diseases',
        kind='cause',
        gbd_id=c_id(669),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'glaucoma': Cause(
        name='glaucoma',
        kind='cause',
        gbd_id=c_id(670),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=9,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_vision_impairment_due_to_glaucoma, 
                  sequelae.severe_vision_impairment_due_to_glaucoma, sequelae.blindness_due_to_glaucoma, ),
        etiologies=(),
    ),
    'cataract': Cause(
        name='cataract',
        kind='cause',
        gbd_id=c_id(671),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=9,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_vision_impairment_due_to_cataract, 
                  sequelae.severe_vision_impairment_due_to_cataract, sequelae.blindness_due_to_cataract, ),
        etiologies=(),
    ),
    'age_related_macular_degeneration': Cause(
        name='age_related_macular_degeneration',
        kind='cause',
        gbd_id=c_id(672),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=14,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_vision_impairment_due_to_macular_degeneration, 
                  sequelae.severe_vision_impairment_due_to_macular_degeneration, 
                  sequelae.blindness_due_to_macular_degeneration, ),
        etiologies=(),
    ),
    'age_related_and_other_hearing_loss': Cause(
        name='age_related_and_other_hearing_loss',
        kind='cause',
        gbd_id=c_id(674),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_hearing_loss_due_to_age_related_and_other_hearing_loss, 
                  sequelae.mild_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss, 
                  sequelae.moderate_hearing_loss_due_to_age_related_and_other_hearing_loss, 
                  sequelae.moderate_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss, 
                  sequelae.moderately_severe_hearing_loss_due_to_age_related_and_other_hearing_loss, 
                  sequelae.moderately_severe_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss, 
                  sequelae.severe_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss, 
                  sequelae.severe_hearing_loss_due_to_age_related_and_other_hearing_loss, 
                  sequelae.profound_hearing_loss_due_to_age_related_and_other_hearing_loss, 
                  sequelae.profound_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss, 
                  sequelae.complete_hearing_loss_due_to_age_related_and_other_hearing_loss, 
                  sequelae.complete_hearing_loss_with_ringing_due_to_age_related_and_other_hearing_loss, ),
        etiologies=(),
    ),
    'other_vision_loss': Cause(
        name='other_vision_loss',
        kind='cause',
        gbd_id=c_id(675),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_vision_impairment_due_to_other_vision_loss, 
                  sequelae.severe_vision_impairment_due_to_other_vision_loss, 
                  sequelae.blindness_due_to_other_vision_loss, ),
        etiologies=(),
    ),
    'other_sense_organ_diseases': Cause(
        name='other_sense_organ_diseases',
        kind='cause',
        gbd_id=c_id(679),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.asymptomatic_acute_other_sense_organ_diseases, 
                  sequelae.mild_acute_other_sense_organ_diseases, sequelae.moderate_acute_other_sense_organ_diseases, 
                  sequelae.asymptomatic_chronic_other_sense_organ_diseases, 
                  sequelae.mild_chronic_other_sense_organ_diseases, 
                  sequelae.moderate_chronic_other_sense_organ_diseases, ),
        etiologies=(),
    ),
    'oral_disorders': Cause(
        name='oral_disorders',
        kind='cause',
        gbd_id=c_id(680),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'caries_of_deciduous_teeth': Cause(
        name='caries_of_deciduous_teeth',
        kind='cause',
        gbd_id=c_id(681),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=6,
        ),
        sequelae=(sequelae.pain_due_to_caries_of_deciduous_teeth, sequelae.asymptomatic_caries_of_deciduous_teeth, ),
        etiologies=(),
    ),
    'caries_of_permanent_teeth': Cause(
        name='caries_of_permanent_teeth',
        kind='cause',
        gbd_id=c_id(682),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=6,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.pain_due_to_caries_of_permanent_teeth, sequelae.asymptomatic_caries_of_permanent_teeth, ),
        etiologies=(),
    ),
    'periodontal_diseases': Cause(
        name='periodontal_diseases',
        kind='cause',
        gbd_id=c_id(683),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.chronic_periodontal_diseases, ),
        etiologies=(),
    ),
    'edentulism': Cause(
        name='edentulism',
        kind='cause',
        gbd_id=c_id(684),
        me_id=me_id(2337),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=9,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.difficulty_eating_due_to_edentulism_and_severe_tooth_loss, 
                  sequelae.asymptomatic_edentulism_and_severe_tooth_loss, ),
        etiologies=(),
    ),
    'other_oral_disorders': Cause(
        name='other_oral_disorders',
        kind='cause',
        gbd_id=c_id(685),
        me_id=me_id(3254),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_other_oral_disorders, sequelae.severe_other_oral_disorders, ),
        etiologies=(),
    ),
    'sudden_infant_death_syndrome': Cause(
        name='sudden_infant_death_syndrome',
        kind='cause',
        gbd_id=c_id(686),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=True,
            yld_only=False,
            yll_age_group_id_start=3,
            yll_age_group_id_end=3,
            yld_age_group_id_start=None,
            yld_age_group_id_end=None,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'injuries': Cause(
        name='injuries',
        kind='cause',
        gbd_id=c_id(687),
        me_id=UNKNOWN,
        level=1,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'transport_injuries': Cause(
        name='transport_injuries',
        kind='cause',
        gbd_id=c_id(688),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'road_injuries': Cause(
        name='road_injuries',
        kind='cause',
        gbd_id=c_id(689),
        me_id=me_id(2339),
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'pedestrian_road_injuries': Cause(
        name='pedestrian_road_injuries',
        kind='cause',
        gbd_id=c_id(690),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'cyclist_road_injuries': Cause(
        name='cyclist_road_injuries',
        kind='cause',
        gbd_id=c_id(691),
        me_id=me_id(2586),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'motorcyclist_road_injuries': Cause(
        name='motorcyclist_road_injuries',
        kind='cause',
        gbd_id=c_id(692),
        me_id=me_id(2587),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'motor_vehicle_road_injuries': Cause(
        name='motor_vehicle_road_injuries',
        kind='cause',
        gbd_id=c_id(693),
        me_id=me_id(2588),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'other_road_injuries': Cause(
        name='other_road_injuries',
        kind='cause',
        gbd_id=c_id(694),
        me_id=me_id(2589),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'other_transport_injuries': Cause(
        name='other_transport_injuries',
        kind='cause',
        gbd_id=c_id(695),
        me_id=me_id(2340),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'unintentional_injuries': Cause(
        name='unintentional_injuries',
        kind='cause',
        gbd_id=c_id(696),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'falls': Cause(
        name='falls',
        kind='cause',
        gbd_id=c_id(697),
        me_id=me_id(2341),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'drowning': Cause(
        name='drowning',
        kind='cause',
        gbd_id=c_id(698),
        me_id=me_id(2342),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'fire_heat_and_hot_substances': Cause(
        name='fire_heat_and_hot_substances',
        kind='cause',
        gbd_id=c_id(699),
        me_id=me_id(2343),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'poisonings': Cause(
        name='poisonings',
        kind='cause',
        gbd_id=c_id(700),
        me_id=me_id(2344),
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'poisoning_by_carbon_monoxide': Cause(
        name='poisoning_by_carbon_monoxide',
        kind='cause',
        gbd_id=c_id(701),
        me_id=me_id(18658),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'poisoning_by_other_means': Cause(
        name='poisoning_by_other_means',
        kind='cause',
        gbd_id=c_id(703),
        me_id=me_id(18659),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'exposure_to_mechanical_forces': Cause(
        name='exposure_to_mechanical_forces',
        kind='cause',
        gbd_id=c_id(704),
        me_id=me_id(2345),
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'unintentional_firearm_injuries': Cause(
        name='unintentional_firearm_injuries',
        kind='cause',
        gbd_id=c_id(705),
        me_id=me_id(2590),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'other_exposure_to_mechanical_forces': Cause(
        name='other_exposure_to_mechanical_forces',
        kind='cause',
        gbd_id=c_id(707),
        me_id=me_id(2592),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'adverse_effects_of_medical_treatment': Cause(
        name='adverse_effects_of_medical_treatment',
        kind='cause',
        gbd_id=c_id(708),
        me_id=me_id(2346),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'animal_contact': Cause(
        name='animal_contact',
        kind='cause',
        gbd_id=c_id(709),
        me_id=me_id(2347),
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'venomous_animal_contact': Cause(
        name='venomous_animal_contact',
        kind='cause',
        gbd_id=c_id(710),
        me_id=me_id(2593),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'non_venomous_animal_contact': Cause(
        name='non_venomous_animal_contact',
        kind='cause',
        gbd_id=c_id(711),
        me_id=me_id(2594),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'foreign_body': Cause(
        name='foreign_body',
        kind='cause',
        gbd_id=c_id(712),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'pulmonary_aspiration_and_foreign_body_in_airway': Cause(
        name='pulmonary_aspiration_and_foreign_body_in_airway',
        kind='cause',
        gbd_id=c_id(713),
        me_id=me_id(2348),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'foreign_body_in_eyes': Cause(
        name='foreign_body_in_eyes',
        kind='cause',
        gbd_id=c_id(714),
        me_id=me_id(2595),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'foreign_body_in_other_body_part': Cause(
        name='foreign_body_in_other_body_part',
        kind='cause',
        gbd_id=c_id(715),
        me_id=me_id(2596),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'other_unintentional_injuries': Cause(
        name='other_unintentional_injuries',
        kind='cause',
        gbd_id=c_id(716),
        me_id=me_id(2349),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'self_harm_and_interpersonal_violence': Cause(
        name='self_harm_and_interpersonal_violence',
        kind='cause',
        gbd_id=c_id(717),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'self_harm': Cause(
        name='self_harm',
        kind='cause',
        gbd_id=c_id(718),
        me_id=me_id(2350),
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'self_harm_by_firearm': Cause(
        name='self_harm_by_firearm',
        kind='cause',
        gbd_id=c_id(721),
        me_id=me_id(10726),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'self_harm_by_other_specified_means': Cause(
        name='self_harm_by_other_specified_means',
        kind='cause',
        gbd_id=c_id(723),
        me_id=me_id(10727),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=235,
            yld_age_group_id_start=7,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'interpersonal_violence': Cause(
        name='interpersonal_violence',
        kind='cause',
        gbd_id=c_id(724),
        me_id=me_id(2351),
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'physical_violence_by_firearm': Cause(
        name='physical_violence_by_firearm',
        kind='cause',
        gbd_id=c_id(725),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'physical_violence_by_sharp_object': Cause(
        name='physical_violence_by_sharp_object',
        kind='cause',
        gbd_id=c_id(726),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'physical_violence_by_other_means': Cause(
        name='physical_violence_by_other_means',
        kind='cause',
        gbd_id=c_id(727),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'exposure_to_forces_of_nature': Cause(
        name='exposure_to_forces_of_nature',
        kind='cause',
        gbd_id=c_id(729),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'maternal_deaths_aggravated_by_hiv_aids': Cause(
        name='maternal_deaths_aggravated_by_hiv_aids',
        kind='cause',
        gbd_id=c_id(741),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=True,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=14,
            yld_age_group_id_start=None,
            yld_age_group_id_end=None,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'thalassemias_trait': Cause(
        name='thalassemias_trait',
        kind='cause',
        gbd_id=c_id(837),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_anemia_due_to_b_thalassemia_trait, 
                  sequelae.moderate_anemia_due_to_b_thalassemia_trait, 
                  sequelae.severe_anemia_due_to_b_thalassemia_trait, sequelae.mild_anemia_due_to_hemoglobin_e_trait, 
                  sequelae.moderate_anemia_due_to_hemoglobin_e_trait, 
                  sequelae.severe_anemia_due_to_hemoglobin_e_trait, sequelae.asymptomatic_b_thalassemia_trait, 
                  sequelae.asymptomatic_hemoglobin_e_trait, ),
        etiologies=(),
    ),
    'sickle_cell_trait': Cause(
        name='sickle_cell_trait',
        kind='cause',
        gbd_id=c_id(838),
        me_id=me_id(2501),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_anemia_due_to_sickle_cell_trait, sequelae.moderate_anemia_due_to_sickle_cell_trait, 
                  sequelae.severe_anemia_due_to_sickle_cell_trait, sequelae.asymptomatic_sickle_cell_trait, ),
        etiologies=(),
    ),
    'g6pd_trait': Cause(
        name='g6pd_trait',
        kind='cause',
        gbd_id=c_id(839),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_anemia_due_to_hemizygous_g6pd_trait, 
                  sequelae.moderate_anemia_due_to_hemizygous_g6pd_trait, 
                  sequelae.severe_anemia_due_to_hemizygous_g6pd_trait, sequelae.asymptomatic_hemizygous_g6pd_trait, ),
        etiologies=(),
    ),
    'environmental_heat_and_cold_exposure': Cause(
        name='environmental_heat_and_cold_exposure',
        kind='cause',
        gbd_id=c_id(842),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'ebola': Cause(
        name='ebola',
        kind='cause',
        gbd_id=c_id(843),
        me_id=me_id(9668),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.ebola_cases, sequelae.post_ebola_chronic_fatigue_syndrome, ),
        etiologies=(),
    ),
    'acute_lymphoid_leukemia': Cause(
        name='acute_lymphoid_leukemia',
        kind='cause',
        gbd_id=c_id(845),
        me_id=me_id(9475),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_acute_lymphoid_leukemia, 
                  sequelae.controlled_phase_of_acute_lymphoid_leukemia, 
                  sequelae.metastatic_phase_of_acute_lymphoid_leukemia, 
                  sequelae.terminal_phase_of_acute_lymphoid_leukemia, ),
        etiologies=(),
    ),
    'chronic_lymphoid_leukemia': Cause(
        name='chronic_lymphoid_leukemia',
        kind='cause',
        gbd_id=c_id(846),
        me_id=me_id(9480),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=9,
            yll_age_group_id_end=235,
            yld_age_group_id_start=9,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_chronic_lymphoid_leukemia, 
                  sequelae.controlled_phase_of_chronic_lymphoid_leukemia, 
                  sequelae.metastatic_phase_of_chronic_lymphoid_leukemia, 
                  sequelae.terminal_phase_of_chronic_lymphoid_leukemia, ),
        etiologies=(),
    ),
    'acute_myeloid_leukemia': Cause(
        name='acute_myeloid_leukemia',
        kind='cause',
        gbd_id=c_id(847),
        me_id=me_id(9485),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_acute_myeloid_leukemia, 
                  sequelae.controlled_phase_of_acute_myeloid_leukemia, 
                  sequelae.metastatic_phase_of_acute_myeloid_leukemia, 
                  sequelae.terminal_phase_of_acute_myeloid_leukemia, ),
        etiologies=(),
    ),
    'chronic_myeloid_leukemia': Cause(
        name='chronic_myeloid_leukemia',
        kind='cause',
        gbd_id=c_id(848),
        me_id=me_id(9490),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_chronic_myeloid_leukemia, 
                  sequelae.controlled_phase_of_chronic_myeloid_leukemia, 
                  sequelae.metastatic_phase_of_chronic_myeloid_leukemia, 
                  sequelae.terminal_phase_of_chronic_myeloid_leukemia, ),
        etiologies=(),
    ),
    'non_melanoma_skin_cancer_squamous_cell_carcinoma': Cause(
        name='non_melanoma_skin_cancer_squamous_cell_carcinoma',
        kind='cause',
        gbd_id=c_id(849),
        me_id=me_id(9503),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=9,
            yll_age_group_id_end=235,
            yld_age_group_id_start=9,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_disfigurement_due_to_squamous_cell_carcinoma, 
                  sequelae.moderate_disfigurement_due_to_squamous_cell_carcinoma, 
                  sequelae.severe_disfigurement_due_to_squamous_cell_carcinoma, ),
        etiologies=(),
    ),
    'non_melanoma_skin_cancer_basal_cell_carcinoma': Cause(
        name='non_melanoma_skin_cancer_basal_cell_carcinoma',
        kind='cause',
        gbd_id=c_id(850),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=9,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.disfigurement_due_to_basal_cell_carcinoma, 
                  sequelae.basal_cell_carcinoma_without_disfigurement, ),
        etiologies=(),
    ),
    'executions_and_police_conflict': Cause(
        name='executions_and_police_conflict',
        kind='cause',
        gbd_id=c_id(854),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'drug_susceptible_tuberculosis': Cause(
        name='drug_susceptible_tuberculosis',
        kind='cause',
        gbd_id=c_id(934),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.drug_susceptible_tuberculosis, ),
        etiologies=(),
    ),
    'zika_virus': Cause(
        name='zika_virus',
        kind='cause',
        gbd_id=c_id(935),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.acute_zika_infection, sequelae.guillain_barre_syndrome_due_to_zika_infection, 
                  sequelae.congenital_zika_syndrome, sequelae.asymptomatic_zika_infection, ),
        etiologies=(),
    ),
    'guinea_worm_disease': Cause(
        name='guinea_worm_disease',
        kind='cause',
        gbd_id=c_id(936),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_pain_due_to_guinea_worm_emergence, 
                  sequelae.moderate_pain_and_limited_mobility_due_to_guinea_worm, ),
        etiologies=(),
    ),
    'alcoholic_cardiomyopathy': Cause(
        name='alcoholic_cardiomyopathy',
        kind='cause',
        gbd_id=c_id(938),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_heart_failure_due_to_alcoholic_cardiomyopathy, 
                  sequelae.moderate_heart_failure_due_to_alcoholic_cardiomyopathy, 
                  sequelae.severe_heart_failure_due_to_alcoholic_cardiomyopathy, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_alcoholic_cardiomyopathy, ),
        etiologies=(),
    ),
    'sexual_violence': Cause(
        name='sexual_violence',
        kind='cause',
        gbd_id=c_id(941),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'myocarditis': Cause(
        name='myocarditis',
        kind='cause',
        gbd_id=c_id(942),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.acute_myocarditis, sequelae.mild_heart_failure_due_to_myocarditis, 
                  sequelae.moderate_heart_failure_due_to_myocarditis, 
                  sequelae.severe_heart_failure_due_to_myocarditis, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_myocarditis, ),
        etiologies=(),
    ),
    'other_leukemia': Cause(
        name='other_leukemia',
        kind='cause',
        gbd_id=c_id(943),
        me_id=me_id(23665),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.metastatic_phase_of_other_leukemia, 
                  sequelae.diagnosis_and_primary_therapy_phase_of_other_leukemia, 
                  sequelae.terminal_phase_of_other_leukemia, sequelae.controlled_phase_of_other_leukemia, ),
        etiologies=(),
    ),
    'other_cardiomyopathy': Cause(
        name='other_cardiomyopathy',
        kind='cause',
        gbd_id=c_id(944),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_heart_failure_due_to_other_cardiomyopathy, 
                  sequelae.moderate_heart_failure_due_to_other_cardiomyopathy, 
                  sequelae.severe_heart_failure_due_to_other_cardiomyopathy, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_other_cardiomyopathy, ),
        etiologies=(),
    ),
    'conflict_and_terrorism': Cause(
        name='conflict_and_terrorism',
        kind='cause',
        gbd_id=c_id(945),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'multidrug_resistant_tuberculosis_without_extensive_drug_resistance': Cause(
        name='multidrug_resistant_tuberculosis_without_extensive_drug_resistance',
        kind='cause',
        gbd_id=c_id(946),
        me_id=me_id(10830),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.multidrug_resistant_tuberculosis_without_extensive_drug_resistance, ),
        etiologies=(),
    ),
    'extensively_drug_resistant_tuberculosis': Cause(
        name='extensively_drug_resistant_tuberculosis',
        kind='cause',
        gbd_id=c_id(947),
        me_id=me_id(10831),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.extensively_drug_resistant_tuberculosis, ),
        etiologies=(),
    ),
    'hiv_aids_drug_susceptible_tuberculosis': Cause(
        name='hiv_aids_drug_susceptible_tuberculosis',
        kind='cause',
        gbd_id=c_id(948),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.hiv_aids_drug_susceptible_tuberculosis_with_mild_anemia, 
                  sequelae.hiv_aids_drug_susceptible_tuberculosis_with_moderate_anemia, 
                  sequelae.hiv_aids_drug_susceptible_tuberculosis_with_severe_anemia, 
                  sequelae.hiv_aids_drug_susceptible_tuberculosis_without_anemia, ),
        etiologies=(),
    ),
    'hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance': Cause(
        name='hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance',
        kind='cause',
        gbd_id=c_id(949),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_mild_anemia, 
                  sequelae.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_moderate_anemia, 
                  sequelae.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_with_severe_anemia, 
                  sequelae.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance_without_anemia, ),
        etiologies=(),
    ),
    'hiv_aids_extensively_drug_resistant_tuberculosis': Cause(
        name='hiv_aids_extensively_drug_resistant_tuberculosis',
        kind='cause',
        gbd_id=c_id(950),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.hiv_aids_extensively_drug_resistant_tuberculosis_with_mild_anemia, 
                  sequelae.hiv_aids_extensively_drug_resistant_tuberculosis_with_moderate_anemia, 
                  sequelae.hiv_aids_extensively_drug_resistant_tuberculosis_with_severe_anemia, 
                  sequelae.hiv_aids_extensively_drug_resistant_tuberculosis_without_anemia, ),
        etiologies=(),
    ),
    'latent_tuberculosis_infection': Cause(
        name='latent_tuberculosis_infection',
        kind='cause',
        gbd_id=c_id(954),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.latent_tuberculosis_infection, ),
        etiologies=(),
    ),
    'hiv_aids_and_sexually_transmitted_infections': Cause(
        name='hiv_aids_and_sexually_transmitted_infections',
        kind='cause',
        gbd_id=c_id(955),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'respiratory_infections_and_tuberculosis': Cause(
        name='respiratory_infections_and_tuberculosis',
        kind='cause',
        gbd_id=c_id(956),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=3,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'enteric_infections': Cause(
        name='enteric_infections',
        kind='cause',
        gbd_id=c_id(957),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'typhoid_and_paratyphoid': Cause(
        name='typhoid_and_paratyphoid',
        kind='cause',
        gbd_id=c_id(958),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=3,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'invasive_non_typhoidal_salmonella_ints': Cause(
        name='invasive_non_typhoidal_salmonella_ints',
        kind='cause',
        gbd_id=c_id(959),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=3,
            yll_age_group_id_end=235,
            yld_age_group_id_start=3,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.severe_acute_ints, ),
        etiologies=(),
    ),
    'other_infectious_diseases': Cause(
        name='other_infectious_diseases',
        kind='cause',
        gbd_id=c_id(961),
        me_id=me_id(16430),
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'maternal_and_neonatal_disorders': Cause(
        name='maternal_and_neonatal_disorders',
        kind='cause',
        gbd_id=c_id(962),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=14,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'myelodysplastic_myeloproliferative_and_other_hematopoietic_neoplasms': Cause(
        name='myelodysplastic_myeloproliferative_and_other_hematopoietic_neoplasms',
        kind='cause',
        gbd_id=c_id(964),
        me_id=me_id(18759),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.myelodysplastic_myeloproliferative_and_other_hematopoietic_neoplasms, ),
        etiologies=(),
    ),
    'benign_and_in_situ_intestinal_neoplasms': Cause(
        name='benign_and_in_situ_intestinal_neoplasms',
        kind='cause',
        gbd_id=c_id(965),
        me_id=me_id(18760),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.benign_and_in_situ_intestinal_neoplasms, ),
        etiologies=(),
    ),
    'benign_and_in_situ_cervical_and_uterine_neoplasms': Cause(
        name='benign_and_in_situ_cervical_and_uterine_neoplasms',
        kind='cause',
        gbd_id=c_id(966),
        me_id=me_id(18761),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.benign_and_in_situ_cervical_and_uterine_neoplasms, ),
        etiologies=(),
    ),
    'other_benign_and_in_situ_neoplasms': Cause(
        name='other_benign_and_in_situ_neoplasms',
        kind='cause',
        gbd_id=c_id(967),
        me_id=me_id(18762),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.other_benign_and_in_situ_neoplasms, ),
        etiologies=(),
    ),
    'non_rheumatic_calcific_aortic_valve_disease': Cause(
        name='non_rheumatic_calcific_aortic_valve_disease',
        kind='cause',
        gbd_id=c_id(968),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.calcific_aortic_valve_disease_after_valve_intervention, 
                  sequelae.asymptomatic_calcific_aortic_valve_disease, 
                  sequelae.mild_heart_failure_due_to_calcific_aortic_valve_disease, 
                  sequelae.moderate_heart_failure_due_to_calcific_aortic_valve_disease, 
                  sequelae.severe_heart_failure_due_to_calcific_aortic_valve_disease, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_calcific_aortic_valve_disease, ),
        etiologies=(),
    ),
    'non_rheumatic_degenerative_mitral_valve_disease': Cause(
        name='non_rheumatic_degenerative_mitral_valve_disease',
        kind='cause',
        gbd_id=c_id(969),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.degenerative_mitral_valve_disease_after_valve_intervention, 
                  sequelae.asymptomatic_degenerative_mitral_valve_disease, 
                  sequelae.mild_heart_failure_due_to_degenerative_mitral_valve_disease, 
                  sequelae.moderate_heart_failure_due_to_degenerative_mitral_valve_disease, 
                  sequelae.severe_heart_failure_due_to_degenerative_mitral_valve_disease, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_degenerative_mitral_valve_disease, ),
        etiologies=(),
    ),
    'other_non_rheumatic_valve_diseases': Cause(
        name='other_non_rheumatic_valve_diseases',
        kind='cause',
        gbd_id=c_id(970),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_heart_failure_due_to_other_non_rheumatic_valve_disease, 
                  sequelae.moderate_heart_failure_due_to_other_non_rheumatic_valve_disease, 
                  sequelae.severe_heart_failure_due_to_other_non_rheumatic_valve_disease, 
                  sequelae.controlled_medically_managed_heart_failure_due_to_other_non_rheumatic_valve_disease, ),
        etiologies=(),
    ),
    'cirrhosis_and_other_chronic_liver_diseases_due_to_nafld': Cause(
        name='cirrhosis_and_other_chronic_liver_diseases_due_to_nafld',
        kind='cause',
        gbd_id=c_id(971),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_nash_compensated, 
                  sequelae.non_alcoholic_fatty_liver_disease_nafld_non_alcoholic_steatohepatitis_nash, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_no_anemia, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_mild_anemia, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_moderate_anemia, 
                  sequelae.cirrhosis_and_other_chronic_liver_diseases_due_to_nash_decompensated_with_severe_anemia, ),
        etiologies=(),
    ),
    'headache_disorders': Cause(
        name='headache_disorders',
        kind='cause',
        gbd_id=c_id(972),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=6,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'substance_use_disorders': Cause(
        name='substance_use_disorders',
        kind='cause',
        gbd_id=c_id(973),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'diabetes_and_kidney_diseases': Cause(
        name='diabetes_and_kidney_diseases',
        kind='cause',
        gbd_id=c_id(974),
        me_id=UNKNOWN,
        level=2,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'diabetes_mellitus_type_1': Cause(
        name='diabetes_mellitus_type_1',
        kind='cause',
        gbd_id=c_id(975),
        me_id=me_id(18655),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diabetic_foot_due_to_neuropathy_due_to_diabetes_mellitus_type_1, 
                  sequelae.diabetic_neuropathy_due_to_diabetes_mellitus_type_1_without_diabetic_foot_or_amputation, 
                  sequelae.diabetic_neuropathy_and_amputation_with_treatment_due_to_diabetes_mellitus_type_1, 
                  sequelae.diabetic_neuropathy_and_amputation_without_treatment_due_to_diabetes_mellitus_type_1, 
                  sequelae.uncomplicated_diabetes_mellitus_type_1, 
                  sequelae.moderate_vision_impairment_due_to_diabetes_mellitus_type_1_retinopathy, 
                  sequelae.severe_vision_impairment_due_to_diabetes_mellitus_type_1_retinopathy, 
                  sequelae.blindness_due_to_diabetes_mellitus_type_1_retinopathy, ),
        etiologies=(),
    ),
    'diabetes_mellitus_type_2': Cause(
        name='diabetes_mellitus_type_2',
        kind='cause',
        gbd_id=c_id(976),
        me_id=me_id(18656),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diabetic_foot_due_to_neuropathy_due_to_diabetes_mellitus_type_2, 
                  sequelae.diabetic_neuropathy_due_to_diabetes_mellitus_type_2_without_diabetic_foot_or_amputation, 
                  sequelae.diabetic_neuropathy_and_amputation_with_treatment_due_to_diabetes_mellitus_type_2, 
                  sequelae.diabetic_neuropathy_and_amputation_without_treatment_due_to_diabetes_mellitus_type_2, 
                  sequelae.uncomplicated_diabetes_mellitus_type_2, 
                  sequelae.moderate_vision_impairment_due_to_diabetes_mellitus_type_2_retinopathy, 
                  sequelae.severe_vision_impairment_due_to_diabetes_mellitus_type_2_retinopathy, 
                  sequelae.blindness_due_to_diabetes_mellitus_type_2_retinopathy, ),
        etiologies=(),
    ),
    'atopic_dermatitis': Cause(
        name='atopic_dermatitis',
        kind='cause',
        gbd_id=c_id(977),
        me_id=me_id(2247),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_atopic_dermatitis, sequelae.moderate_atopic_dermatitis, 
                  sequelae.severe_atopic_dermatitis, ),
        etiologies=(),
    ),
    'contact_dermatitis': Cause(
        name='contact_dermatitis',
        kind='cause',
        gbd_id=c_id(978),
        me_id=me_id(2574),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_contact_dermatitis, sequelae.moderate_contact_dermatitis, 
                  sequelae.asymptomatic_contact_dermatitis, ),
        etiologies=(),
    ),
    'seborrhoeic_dermatitis': Cause(
        name='seborrhoeic_dermatitis',
        kind='cause',
        gbd_id=c_id(979),
        me_id=me_id(2578),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=5,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.symptomatic_seborrhoeic_dermatitis, sequelae.asymptomatic_seborrhoeic_dermatitis, ),
        etiologies=(),
    ),
    'bacterial_skin_diseases': Cause(
        name='bacterial_skin_diseases',
        kind='cause',
        gbd_id=c_id(980),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'blindness_and_vision_loss': Cause(
        name='blindness_and_vision_loss',
        kind='cause',
        gbd_id=c_id(981),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'upper_digestive_system_diseases': Cause(
        name='upper_digestive_system_diseases',
        kind='cause',
        gbd_id=c_id(992),
        me_id=UNKNOWN,
        level=3,
        most_detailed=False,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=5,
            yll_age_group_id_end=235,
            yld_age_group_id_start=4,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'maternal_abortion_and_miscarriage': Cause(
        name='maternal_abortion_and_miscarriage',
        kind='cause',
        gbd_id=c_id(995),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=True,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=7,
            yll_age_group_id_end=14,
            yld_age_group_id_start=7,
            yld_age_group_id_end=14,
        ),
        sequelae=(sequelae.maternal_abortive_outcome, ),
        etiologies=(),
    ),
    'liver_cancer_due_to_nash': Cause(
        name='liver_cancer_due_to_nash',
        kind='cause',
        gbd_id=c_id(996),
        me_id=me_id(19776),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.diagnosis_and_primary_therapy_phase_of_liver_cancer_due_to_nash, 
                  sequelae.controlled_phase_of_liver_cancer_due_to_nash, 
                  sequelae.metastatic_phase_of_liver_cancer_due_to_nash, 
                  sequelae.terminal_phase_of_liver_cancer_due_to_nash, ),
        etiologies=(),
    ),
    'chronic_kidney_disease_due_to_diabetes_mellitus_type_1': Cause(
        name='chronic_kidney_disease_due_to_diabetes_mellitus_type_1',
        kind='cause',
        gbd_id=c_id(997),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=4,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.end_stage_renal_disease_after_transplant_due_to_type_1_diabetes_mellitus, 
                  sequelae.stage_3_chronic_kidney_disease_and_severe_anemia_due_to_type_1_diabetes_mellitus, 
                  sequelae.stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_type_1_diabetes_mellitus, 
                  sequelae.stage_3_chronic_kidney_disease_and_mild_anemia_due_to_type_1_diabetes_mellitus, 
                  sequelae.stage_3_chronic_kidney_disease_without_anemia_due_to_type_1_diabetes_mellitus, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_1_diabetes_mellitus, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_1_diabetes_mellitus, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_1_diabetes_mellitus, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_type_1_diabetes_mellitus, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_1_diabetes_mellitus, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_1_diabetes_mellitus, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_1_diabetes_mellitus, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_type_1_diabetes_mellitus, 
                  sequelae.stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_type_1_diabetes_mellitus, 
                  sequelae.end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_type_1_diabetes_mellitus, 
                  sequelae.end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_type_1_diabetes_mellitus, 
                  sequelae.end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_type_1_diabetes_mellitus, 
                  sequelae.end_stage_renal_disease_on_dialysis_without_anemia_due_to_type_1_diabetes_mellitus, ),
        etiologies=(),
    ),
    'chronic_kidney_disease_due_to_diabetes_mellitus_type_2': Cause(
        name='chronic_kidney_disease_due_to_diabetes_mellitus_type_2',
        kind='cause',
        gbd_id=c_id(998),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.end_stage_renal_disease_after_transplant_due_to_type_2_diabetes_mellitus, 
                  sequelae.stage_3_chronic_kidney_disease_and_severe_anemia_due_to_type_2_diabetes_mellitus, 
                  sequelae.stage_3_chronic_kidney_disease_and_moderate_anemia_due_to_type_2_diabetes_mellitus, 
                  sequelae.stage_3_chronic_kidney_disease_and_mild_anemia_due_to_type_2_diabetes_mellitus, 
                  sequelae.stage_3_chronic_kidney_disease_without_anemia_due_to_type_2_diabetes_mellitus, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_2_diabetes_mellitus, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_2_diabetes_mellitus, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_2_diabetes_mellitus, 
                  sequelae.stage_4_chronic_kidney_disease_untreated_without_anemia_due_to_type_2_diabetes_mellitus, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_and_severe_anemia_due_to_type_2_diabetes_mellitus, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_and_moderate_anemia_due_to_type_2_diabetes_mellitus, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_and_mild_anemia_due_to_type_2_diabetes_mellitus, 
                  sequelae.stage_5_chronic_kidney_disease_untreated_without_anemia_due_to_type_2_diabetes_mellitus, 
                  sequelae.stage_1_2_chronic_kidney_disease_with_preserved_gfr_due_to_type_2_diabetes_mellitus, 
                  sequelae.end_stage_renal_disease_on_dialysis_and_mild_anemia_due_to_type_2_diabetes_mellitus, 
                  sequelae.end_stage_renal_disease_on_dialysis_and_moderate_anemia_due_to_type_2_diabetes_mellitus, 
                  sequelae.end_stage_renal_disease_on_dialysis_and_severe_anemia_due_to_type_2_diabetes_mellitus, 
                  sequelae.end_stage_renal_disease_on_dialysis_without_anemia_due_to_type_2_diabetes_mellitus, ),
        etiologies=(),
    ),
    'refraction_disorders': Cause(
        name='refraction_disorders',
        kind='cause',
        gbd_id=c_id(999),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.moderate_vision_impairment_due_to_uncorrected_refractive_error, 
                  sequelae.severe_vision_impairment_due_to_uncorrected_refractive_error, 
                  sequelae.blindness_due_to_uncorrected_refractive_error, ),
        etiologies=(),
    ),
    'near_vision_loss': Cause(
        name='near_vision_loss',
        kind='cause',
        gbd_id=c_id(1000),
        me_id=me_id(2424),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.near_vision_loss, ),
        etiologies=(),
    ),
    'osteoarthritis_hip': Cause(
        name='osteoarthritis_hip',
        kind='cause',
        gbd_id=c_id(1014),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=11,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_osteoarthritis_of_the_hip, sequelae.moderate_osteoarthritis_of_the_hip, 
                  sequelae.severe_osteoarthritis_of_the_hip, sequelae.asymptomatic_osteoarthritis_of_the_hip, ),
        etiologies=(),
    ),
    'osteoarthritis_knee': Cause(
        name='osteoarthritis_knee',
        kind='cause',
        gbd_id=c_id(1015),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=11,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_osteoarthritis_of_the_knee, sequelae.moderate_osteoarthritis_of_the_knee, 
                  sequelae.severe_osteoarthritis_of_the_knee, sequelae.asymptomatic_osteoarthritis_of_the_knee, ),
        etiologies=(),
    ),
    'osteoarthritis_hand': Cause(
        name='osteoarthritis_hand',
        kind='cause',
        gbd_id=c_id(1016),
        me_id=me_id(23745),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=11,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_osteoarthritis_of_the_hand_and_foot, 
                  sequelae.moderate_osteoarthritis_of_the_hand_and_foot, 
                  sequelae.severe_osteoarthritis_of_the_hand_and_foot, 
                  sequelae.asymptomatic_osteoarthritis_of_the_hand_and_foot, ),
        etiologies=(),
    ),
    'osteoarthritis_other': Cause(
        name='osteoarthritis_other',
        kind='cause',
        gbd_id=c_id(1017),
        me_id=me_id(23747),
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=True,
            yll_age_group_id_start=None,
            yll_age_group_id_end=None,
            yld_age_group_id_start=11,
            yld_age_group_id_end=235,
        ),
        sequelae=(sequelae.mild_osteoarthritis_other, sequelae.moderate_osteoarthritis_other, 
                  sequelae.severe_osteoarthritis_other, sequelae.asymptomatic_osteoarthritis_other, ),
        etiologies=(),
    ),
    'liver_cancer_due_to_other_causes': Cause(
        name='liver_cancer_due_to_other_causes',
        kind='cause',
        gbd_id=c_id(1021),
        me_id=UNKNOWN,
        level=4,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'other_malignant_neoplasms': Cause(
        name='other_malignant_neoplasms',
        kind='cause',
        gbd_id=c_id(1022),
        me_id=UNKNOWN,
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'other_cardiovascular_and_circulatory_diseases': Cause(
        name='other_cardiovascular_and_circulatory_diseases',
        kind='cause',
        gbd_id=c_id(1023),
        me_id=me_id(1868),
        level=3,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'total_burden_related_to_hepatitis_b': Cause(
        name='total_burden_related_to_hepatitis_b',
        kind='cause',
        gbd_id=c_id(1026),
        me_id=UNKNOWN,
        level=1,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'total_burden_related_to_hepatitis_c': Cause(
        name='total_burden_related_to_hepatitis_c',
        kind='cause',
        gbd_id=c_id(1027),
        me_id=UNKNOWN,
        level=1,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=4,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'total_burden_related_to_non_alcoholic_fatty_liver_disease_nafld': Cause(
        name='total_burden_related_to_non_alcoholic_fatty_liver_disease_nafld',
        kind='cause',
        gbd_id=c_id(1028),
        me_id=UNKNOWN,
        level=1,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=8,
            yll_age_group_id_end=235,
            yld_age_group_id_start=8,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
    'total_cancers': Cause(
        name='total_cancers',
        kind='cause',
        gbd_id=c_id(1029),
        me_id=UNKNOWN,
        level=1,
        most_detailed=True,
        parent=None,
        restrictions=Restrictions(
            male_only=False,
            female_only=False,
            yll_only=False,
            yld_only=False,
            yll_age_group_id_start=2,
            yll_age_group_id_end=235,
            yld_age_group_id_start=2,
            yld_age_group_id_end=235,
        ),
        sequelae=(),
        etiologies=(),
    ),
})

causes.all_causes.sub_causes = (causes.communicable_maternal_neonatal_and_nutritional_diseases,
                                causes.non_communicable_diseases, causes.injuries,
                                causes.total_burden_related_to_hepatitis_b, causes.total_burden_related_to_hepatitis_c,
                                causes.total_burden_related_to_non_alcoholic_fatty_liver_disease_nafld,
                                causes.total_cancers, )

causes.communicable_maternal_neonatal_and_nutritional_diseases.parent = causes.all_causes
causes.communicable_maternal_neonatal_and_nutritional_diseases.sub_causes = (causes.neglected_tropical_diseases_and_malaria,
                                                                             causes.nutritional_deficiencies,
                                                                             causes.hiv_aids_and_sexually_transmitted_infections,
                                                                             causes.respiratory_infections_and_tuberculosis,
                                                                             causes.enteric_infections,
                                                                             causes.other_infectious_diseases,
                                                                             causes.maternal_and_neonatal_disorders, )

causes.tuberculosis.parent = causes.respiratory_infections_and_tuberculosis
causes.tuberculosis.sub_causes = (causes.drug_susceptible_tuberculosis,
                                  causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance,
                                  causes.extensively_drug_resistant_tuberculosis, causes.latent_tuberculosis_infection,
                                  )

causes.hiv_aids.parent = causes.hiv_aids_and_sexually_transmitted_infections
causes.hiv_aids.sub_causes = (causes.hiv_aids_resulting_in_other_diseases,
                              causes.hiv_aids_drug_susceptible_tuberculosis,
                              causes.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance,
                              causes.hiv_aids_extensively_drug_resistant_tuberculosis, )

causes.hiv_aids_resulting_in_other_diseases.parent = causes.hiv_aids

causes.diarrheal_diseases.parent = causes.enteric_infections

causes.typhoid_fever.parent = causes.typhoid_and_paratyphoid

causes.paratyphoid_fever.parent = causes.typhoid_and_paratyphoid

causes.other_intestinal_infectious_diseases.parent = causes.enteric_infections

causes.lower_respiratory_infections.parent = causes.respiratory_infections_and_tuberculosis

causes.upper_respiratory_infections.parent = causes.respiratory_infections_and_tuberculosis

causes.otitis_media.parent = causes.respiratory_infections_and_tuberculosis

causes.meningitis.parent = causes.other_infectious_diseases

causes.encephalitis.parent = causes.other_infectious_diseases

causes.diphtheria.parent = causes.other_infectious_diseases

causes.whooping_cough.parent = causes.other_infectious_diseases

causes.tetanus.parent = causes.other_infectious_diseases

causes.measles.parent = causes.other_infectious_diseases

causes.varicella_and_herpes_zoster.parent = causes.other_infectious_diseases

causes.neglected_tropical_diseases_and_malaria.parent = causes.communicable_maternal_neonatal_and_nutritional_diseases
causes.neglected_tropical_diseases_and_malaria.sub_causes = (causes.malaria, causes.chagas_disease,
                                                             causes.leishmaniasis, causes.african_trypanosomiasis,
                                                             causes.schistosomiasis, causes.cysticercosis,
                                                             causes.cystic_echinococcosis, causes.lymphatic_filariasis,
                                                             causes.onchocerciasis, causes.trachoma, causes.dengue,
                                                             causes.yellow_fever, causes.rabies,
                                                             causes.intestinal_nematode_infections,
                                                             causes.food_borne_trematodiases,
                                                             causes.other_neglected_tropical_diseases, causes.leprosy,
                                                             causes.ebola, causes.zika_virus,
                                                             causes.guinea_worm_disease, )

causes.malaria.parent = causes.neglected_tropical_diseases_and_malaria

causes.chagas_disease.parent = causes.neglected_tropical_diseases_and_malaria

causes.leishmaniasis.parent = causes.neglected_tropical_diseases_and_malaria
causes.leishmaniasis.sub_causes = (causes.visceral_leishmaniasis, causes.cutaneous_and_mucocutaneous_leishmaniasis, )

causes.visceral_leishmaniasis.parent = causes.leishmaniasis

causes.cutaneous_and_mucocutaneous_leishmaniasis.parent = causes.leishmaniasis

causes.african_trypanosomiasis.parent = causes.neglected_tropical_diseases_and_malaria

causes.schistosomiasis.parent = causes.neglected_tropical_diseases_and_malaria

causes.cysticercosis.parent = causes.neglected_tropical_diseases_and_malaria

causes.cystic_echinococcosis.parent = causes.neglected_tropical_diseases_and_malaria

causes.lymphatic_filariasis.parent = causes.neglected_tropical_diseases_and_malaria

causes.onchocerciasis.parent = causes.neglected_tropical_diseases_and_malaria

causes.trachoma.parent = causes.neglected_tropical_diseases_and_malaria

causes.dengue.parent = causes.neglected_tropical_diseases_and_malaria

causes.yellow_fever.parent = causes.neglected_tropical_diseases_and_malaria

causes.rabies.parent = causes.neglected_tropical_diseases_and_malaria

causes.intestinal_nematode_infections.parent = causes.neglected_tropical_diseases_and_malaria
causes.intestinal_nematode_infections.sub_causes = (causes.ascariasis, causes.trichuriasis, causes.hookworm_disease, )

causes.ascariasis.parent = causes.intestinal_nematode_infections

causes.trichuriasis.parent = causes.intestinal_nematode_infections

causes.hookworm_disease.parent = causes.intestinal_nematode_infections

causes.food_borne_trematodiases.parent = causes.neglected_tropical_diseases_and_malaria

causes.other_neglected_tropical_diseases.parent = causes.neglected_tropical_diseases_and_malaria

causes.maternal_disorders.parent = causes.maternal_and_neonatal_disorders
causes.maternal_disorders.sub_causes = (causes.maternal_hemorrhage,
                                        causes.maternal_sepsis_and_other_maternal_infections,
                                        causes.maternal_hypertensive_disorders,
                                        causes.maternal_obstructed_labor_and_uterine_rupture, causes.ectopic_pregnancy,
                                        causes.indirect_maternal_deaths, causes.late_maternal_deaths,
                                        causes.other_maternal_disorders, causes.maternal_deaths_aggravated_by_hiv_aids,
                                        causes.maternal_abortion_and_miscarriage, )

causes.maternal_hemorrhage.parent = causes.maternal_disorders

causes.maternal_sepsis_and_other_maternal_infections.parent = causes.maternal_disorders

causes.maternal_hypertensive_disorders.parent = causes.maternal_disorders

causes.maternal_obstructed_labor_and_uterine_rupture.parent = causes.maternal_disorders

causes.ectopic_pregnancy.parent = causes.maternal_disorders

causes.indirect_maternal_deaths.parent = causes.maternal_disorders

causes.late_maternal_deaths.parent = causes.maternal_disorders

causes.other_maternal_disorders.parent = causes.maternal_disorders

causes.neonatal_disorders.parent = causes.maternal_and_neonatal_disorders
causes.neonatal_disorders.sub_causes = (causes.neonatal_preterm_birth,
                                        causes.neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma,
                                        causes.neonatal_sepsis_and_other_neonatal_infections,
                                        causes.hemolytic_disease_and_other_neonatal_jaundice,
                                        causes.other_neonatal_disorders, )

causes.neonatal_preterm_birth.parent = causes.neonatal_disorders

causes.neonatal_encephalopathy_due_to_birth_asphyxia_and_trauma.parent = causes.neonatal_disorders

causes.neonatal_sepsis_and_other_neonatal_infections.parent = causes.neonatal_disorders

causes.hemolytic_disease_and_other_neonatal_jaundice.parent = causes.neonatal_disorders

causes.other_neonatal_disorders.parent = causes.neonatal_disorders

causes.nutritional_deficiencies.parent = causes.communicable_maternal_neonatal_and_nutritional_diseases
causes.nutritional_deficiencies.sub_causes = (causes.protein_energy_malnutrition, causes.iodine_deficiency,
                                              causes.vitamin_a_deficiency, causes.dietary_iron_deficiency,
                                              causes.other_nutritional_deficiencies, )

causes.protein_energy_malnutrition.parent = causes.nutritional_deficiencies

causes.iodine_deficiency.parent = causes.nutritional_deficiencies

causes.vitamin_a_deficiency.parent = causes.nutritional_deficiencies

causes.dietary_iron_deficiency.parent = causes.nutritional_deficiencies

causes.other_nutritional_deficiencies.parent = causes.nutritional_deficiencies

causes.sexually_transmitted_infections_excluding_hiv.parent = causes.hiv_aids_and_sexually_transmitted_infections
causes.sexually_transmitted_infections_excluding_hiv.sub_causes = (causes.syphilis, causes.chlamydial_infection,
                                                                   causes.gonococcal_infection, causes.trichomoniasis,
                                                                   causes.genital_herpes,
                                                                   causes.other_sexually_transmitted_infections, )

causes.syphilis.parent = causes.sexually_transmitted_infections_excluding_hiv

causes.chlamydial_infection.parent = causes.sexually_transmitted_infections_excluding_hiv

causes.gonococcal_infection.parent = causes.sexually_transmitted_infections_excluding_hiv

causes.trichomoniasis.parent = causes.sexually_transmitted_infections_excluding_hiv

causes.genital_herpes.parent = causes.sexually_transmitted_infections_excluding_hiv

causes.other_sexually_transmitted_infections.parent = causes.sexually_transmitted_infections_excluding_hiv

causes.acute_hepatitis.parent = causes.other_infectious_diseases
causes.acute_hepatitis.sub_causes = (causes.acute_hepatitis_a, causes.acute_hepatitis_b, causes.acute_hepatitis_c,
                                     causes.acute_hepatitis_e, )

causes.acute_hepatitis_a.parent = causes.acute_hepatitis

causes.acute_hepatitis_b.parent = causes.acute_hepatitis

causes.acute_hepatitis_c.parent = causes.acute_hepatitis

causes.acute_hepatitis_e.parent = causes.acute_hepatitis

causes.leprosy.parent = causes.neglected_tropical_diseases_and_malaria

causes.other_unspecified_infectious_diseases.parent = causes.other_infectious_diseases

causes.non_communicable_diseases.parent = causes.all_causes
causes.non_communicable_diseases.sub_causes = (causes.neoplasms, causes.cardiovascular_diseases,
                                               causes.chronic_respiratory_diseases, causes.digestive_diseases,
                                               causes.neurological_disorders, causes.mental_disorders,
                                               causes.musculoskeletal_disorders,
                                               causes.other_non_communicable_diseases,
                                               causes.skin_and_subcutaneous_diseases, causes.sense_organ_diseases,
                                               causes.substance_use_disorders, causes.diabetes_and_kidney_diseases, )

causes.neoplasms.parent = causes.non_communicable_diseases
causes.neoplasms.sub_causes = (causes.esophageal_cancer, causes.stomach_cancer, causes.liver_cancer,
                               causes.larynx_cancer, causes.tracheal_bronchus_and_lung_cancer, causes.breast_cancer,
                               causes.cervical_cancer, causes.uterine_cancer, causes.prostate_cancer,
                               causes.colon_and_rectum_cancer, causes.lip_and_oral_cavity_cancer,
                               causes.nasopharynx_cancer, causes.other_pharynx_cancer,
                               causes.gallbladder_and_biliary_tract_cancer, causes.pancreatic_cancer,
                               causes.malignant_skin_melanoma, causes.non_melanoma_skin_cancer, causes.ovarian_cancer,
                               causes.testicular_cancer, causes.kidney_cancer, causes.bladder_cancer,
                               causes.brain_and_central_nervous_system_cancer, causes.thyroid_cancer,
                               causes.mesothelioma, causes.hodgkin_lymphoma, causes.non_hodgkin_lymphoma,
                               causes.multiple_myeloma, causes.leukemia, causes.other_neoplasms,
                               causes.other_malignant_neoplasms, )

causes.esophageal_cancer.parent = causes.neoplasms

causes.stomach_cancer.parent = causes.neoplasms

causes.liver_cancer.parent = causes.neoplasms
causes.liver_cancer.sub_causes = (causes.liver_cancer_due_to_hepatitis_b, causes.liver_cancer_due_to_hepatitis_c,
                                  causes.liver_cancer_due_to_alcohol_use, causes.liver_cancer_due_to_nash,
                                  causes.liver_cancer_due_to_other_causes, )

causes.liver_cancer_due_to_hepatitis_b.parent = causes.liver_cancer

causes.liver_cancer_due_to_hepatitis_c.parent = causes.liver_cancer

causes.liver_cancer_due_to_alcohol_use.parent = causes.liver_cancer

causes.larynx_cancer.parent = causes.neoplasms

causes.tracheal_bronchus_and_lung_cancer.parent = causes.neoplasms

causes.breast_cancer.parent = causes.neoplasms

causes.cervical_cancer.parent = causes.neoplasms

causes.uterine_cancer.parent = causes.neoplasms

causes.prostate_cancer.parent = causes.neoplasms

causes.colon_and_rectum_cancer.parent = causes.neoplasms

causes.lip_and_oral_cavity_cancer.parent = causes.neoplasms

causes.nasopharynx_cancer.parent = causes.neoplasms

causes.other_pharynx_cancer.parent = causes.neoplasms

causes.gallbladder_and_biliary_tract_cancer.parent = causes.neoplasms

causes.pancreatic_cancer.parent = causes.neoplasms

causes.malignant_skin_melanoma.parent = causes.neoplasms

causes.non_melanoma_skin_cancer.parent = causes.neoplasms
causes.non_melanoma_skin_cancer.sub_causes = (causes.non_melanoma_skin_cancer_squamous_cell_carcinoma,
                                              causes.non_melanoma_skin_cancer_basal_cell_carcinoma, )

causes.ovarian_cancer.parent = causes.neoplasms

causes.testicular_cancer.parent = causes.neoplasms

causes.kidney_cancer.parent = causes.neoplasms

causes.bladder_cancer.parent = causes.neoplasms

causes.brain_and_central_nervous_system_cancer.parent = causes.neoplasms

causes.thyroid_cancer.parent = causes.neoplasms

causes.mesothelioma.parent = causes.neoplasms

causes.hodgkin_lymphoma.parent = causes.neoplasms

causes.non_hodgkin_lymphoma.parent = causes.neoplasms

causes.multiple_myeloma.parent = causes.neoplasms

causes.leukemia.parent = causes.neoplasms
causes.leukemia.sub_causes = (causes.acute_lymphoid_leukemia, causes.chronic_lymphoid_leukemia,
                              causes.acute_myeloid_leukemia, causes.chronic_myeloid_leukemia, causes.other_leukemia, )

causes.other_neoplasms.parent = causes.neoplasms
causes.other_neoplasms.sub_causes = (causes.myelodysplastic_myeloproliferative_and_other_hematopoietic_neoplasms,
                                     causes.benign_and_in_situ_intestinal_neoplasms,
                                     causes.benign_and_in_situ_cervical_and_uterine_neoplasms,
                                     causes.other_benign_and_in_situ_neoplasms, )

causes.cardiovascular_diseases.parent = causes.non_communicable_diseases
causes.cardiovascular_diseases.sub_causes = (causes.rheumatic_heart_disease, causes.ischemic_heart_disease,
                                             causes.stroke, causes.hypertensive_heart_disease,
                                             causes.cardiomyopathy_and_myocarditis,
                                             causes.atrial_fibrillation_and_flutter, causes.aortic_aneurysm,
                                             causes.peripheral_artery_disease, causes.endocarditis,
                                             causes.non_rheumatic_valvular_heart_disease,
                                             causes.other_cardiovascular_and_circulatory_diseases, )

causes.rheumatic_heart_disease.parent = causes.cardiovascular_diseases

causes.ischemic_heart_disease.parent = causes.cardiovascular_diseases

causes.stroke.parent = causes.cardiovascular_diseases
causes.stroke.sub_causes = (causes.ischemic_stroke, causes.intracerebral_hemorrhage, causes.subarachnoid_hemorrhage, )

causes.ischemic_stroke.parent = causes.stroke

causes.intracerebral_hemorrhage.parent = causes.stroke

causes.subarachnoid_hemorrhage.parent = causes.stroke

causes.hypertensive_heart_disease.parent = causes.cardiovascular_diseases

causes.cardiomyopathy_and_myocarditis.parent = causes.cardiovascular_diseases
causes.cardiomyopathy_and_myocarditis.sub_causes = (causes.alcoholic_cardiomyopathy, causes.myocarditis,
                                                    causes.other_cardiomyopathy, )

causes.atrial_fibrillation_and_flutter.parent = causes.cardiovascular_diseases

causes.aortic_aneurysm.parent = causes.cardiovascular_diseases

causes.peripheral_artery_disease.parent = causes.cardiovascular_diseases

causes.endocarditis.parent = causes.cardiovascular_diseases

causes.non_rheumatic_valvular_heart_disease.parent = causes.cardiovascular_diseases
causes.non_rheumatic_valvular_heart_disease.sub_causes = (causes.non_rheumatic_calcific_aortic_valve_disease,
                                                          causes.non_rheumatic_degenerative_mitral_valve_disease,
                                                          causes.other_non_rheumatic_valve_diseases, )

causes.chronic_respiratory_diseases.parent = causes.non_communicable_diseases
causes.chronic_respiratory_diseases.sub_causes = (causes.chronic_obstructive_pulmonary_disease, causes.pneumoconiosis,
                                                  causes.asthma,
                                                  causes.interstitial_lung_disease_and_pulmonary_sarcoidosis,
                                                  causes.other_chronic_respiratory_diseases, )

causes.chronic_obstructive_pulmonary_disease.parent = causes.chronic_respiratory_diseases

causes.pneumoconiosis.parent = causes.chronic_respiratory_diseases
causes.pneumoconiosis.sub_causes = (causes.silicosis, causes.asbestosis, causes.coal_workers_pneumoconiosis,
                                    causes.other_pneumoconiosis, )

causes.silicosis.parent = causes.pneumoconiosis

causes.asbestosis.parent = causes.pneumoconiosis

causes.coal_workers_pneumoconiosis.parent = causes.pneumoconiosis

causes.other_pneumoconiosis.parent = causes.pneumoconiosis

causes.asthma.parent = causes.chronic_respiratory_diseases

causes.interstitial_lung_disease_and_pulmonary_sarcoidosis.parent = causes.chronic_respiratory_diseases

causes.other_chronic_respiratory_diseases.parent = causes.chronic_respiratory_diseases

causes.cirrhosis_and_other_chronic_liver_diseases.parent = causes.digestive_diseases
causes.cirrhosis_and_other_chronic_liver_diseases.sub_causes = (causes.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b,
                                                                causes.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c,
                                                                causes.cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_use,
                                                                causes.cirrhosis_and_other_chronic_liver_diseases_due_to_other_causes,
                                                                causes.cirrhosis_and_other_chronic_liver_diseases_due_to_nafld,
                                                                )

causes.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_b.parent = causes.cirrhosis_and_other_chronic_liver_diseases

causes.cirrhosis_and_other_chronic_liver_diseases_due_to_hepatitis_c.parent = causes.cirrhosis_and_other_chronic_liver_diseases

causes.cirrhosis_and_other_chronic_liver_diseases_due_to_alcohol_use.parent = causes.cirrhosis_and_other_chronic_liver_diseases

causes.cirrhosis_and_other_chronic_liver_diseases_due_to_other_causes.parent = causes.cirrhosis_and_other_chronic_liver_diseases

causes.digestive_diseases.parent = causes.non_communicable_diseases
causes.digestive_diseases.sub_causes = (causes.cirrhosis_and_other_chronic_liver_diseases, causes.appendicitis,
                                        causes.paralytic_ileus_and_intestinal_obstruction,
                                        causes.inguinal_femoral_and_abdominal_hernia,
                                        causes.inflammatory_bowel_disease, causes.vascular_intestinal_disorders,
                                        causes.gallbladder_and_biliary_diseases, causes.pancreatitis,
                                        causes.other_digestive_diseases, causes.upper_digestive_system_diseases, )

causes.peptic_ulcer_disease.parent = causes.upper_digestive_system_diseases

causes.gastritis_and_duodenitis.parent = causes.upper_digestive_system_diseases

causes.appendicitis.parent = causes.digestive_diseases

causes.paralytic_ileus_and_intestinal_obstruction.parent = causes.digestive_diseases

causes.inguinal_femoral_and_abdominal_hernia.parent = causes.digestive_diseases

causes.inflammatory_bowel_disease.parent = causes.digestive_diseases

causes.vascular_intestinal_disorders.parent = causes.digestive_diseases

causes.gallbladder_and_biliary_diseases.parent = causes.digestive_diseases

causes.pancreatitis.parent = causes.digestive_diseases

causes.gastroesophageal_reflux_disease.parent = causes.upper_digestive_system_diseases

causes.other_digestive_diseases.parent = causes.digestive_diseases

causes.neurological_disorders.parent = causes.non_communicable_diseases
causes.neurological_disorders.sub_causes = (causes.alzheimers_disease_and_other_dementias, causes.parkinsons_disease,
                                            causes.idiopathic_epilepsy, causes.multiple_sclerosis,
                                            causes.motor_neuron_disease, causes.other_neurological_disorders,
                                            causes.headache_disorders, )

causes.alzheimers_disease_and_other_dementias.parent = causes.neurological_disorders

causes.parkinsons_disease.parent = causes.neurological_disorders

causes.idiopathic_epilepsy.parent = causes.neurological_disorders

causes.multiple_sclerosis.parent = causes.neurological_disorders

causes.migraine.parent = causes.headache_disorders

causes.tension_type_headache.parent = causes.headache_disorders

causes.motor_neuron_disease.parent = causes.neurological_disorders

causes.other_neurological_disorders.parent = causes.neurological_disorders

causes.mental_disorders.parent = causes.non_communicable_diseases
causes.mental_disorders.sub_causes = (causes.schizophrenia, causes.depressive_disorders, causes.bipolar_disorder,
                                      causes.anxiety_disorders, causes.eating_disorders,
                                      causes.autism_spectrum_disorders,
                                      causes.attention_deficit_hyperactivity_disorder, causes.conduct_disorder,
                                      causes.idiopathic_developmental_intellectual_disability,
                                      causes.other_mental_disorders, )

causes.schizophrenia.parent = causes.mental_disorders

causes.alcohol_use_disorders.parent = causes.substance_use_disorders

causes.drug_use_disorders.parent = causes.substance_use_disorders
causes.drug_use_disorders.sub_causes = (causes.opioid_use_disorders, causes.cocaine_use_disorders,
                                        causes.amphetamine_use_disorders, causes.cannabis_use_disorders,
                                        causes.other_drug_use_disorders, )

causes.opioid_use_disorders.parent = causes.drug_use_disorders

causes.cocaine_use_disorders.parent = causes.drug_use_disorders

causes.amphetamine_use_disorders.parent = causes.drug_use_disorders

causes.cannabis_use_disorders.parent = causes.drug_use_disorders

causes.other_drug_use_disorders.parent = causes.drug_use_disorders

causes.depressive_disorders.parent = causes.mental_disorders
causes.depressive_disorders.sub_causes = (causes.major_depressive_disorder, causes.dysthymia, )

causes.major_depressive_disorder.parent = causes.depressive_disorders

causes.dysthymia.parent = causes.depressive_disorders

causes.bipolar_disorder.parent = causes.mental_disorders

causes.anxiety_disorders.parent = causes.mental_disorders

causes.eating_disorders.parent = causes.mental_disorders
causes.eating_disorders.sub_causes = (causes.anorexia_nervosa, causes.bulimia_nervosa, )

causes.anorexia_nervosa.parent = causes.eating_disorders

causes.bulimia_nervosa.parent = causes.eating_disorders

causes.autism_spectrum_disorders.parent = causes.mental_disorders

causes.attention_deficit_hyperactivity_disorder.parent = causes.mental_disorders

causes.conduct_disorder.parent = causes.mental_disorders

causes.idiopathic_developmental_intellectual_disability.parent = causes.mental_disorders

causes.other_mental_disorders.parent = causes.mental_disorders

causes.diabetes_mellitus.parent = causes.diabetes_and_kidney_diseases
causes.diabetes_mellitus.sub_causes = (causes.diabetes_mellitus_type_1, causes.diabetes_mellitus_type_2, )

causes.acute_glomerulonephritis.parent = causes.diabetes_and_kidney_diseases

causes.chronic_kidney_disease.parent = causes.diabetes_and_kidney_diseases
causes.chronic_kidney_disease.sub_causes = (causes.chronic_kidney_disease_due_to_hypertension,
                                            causes.chronic_kidney_disease_due_to_glomerulonephritis,
                                            causes.chronic_kidney_disease_due_to_other_and_unspecified_causes,
                                            causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_1,
                                            causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2, )

causes.chronic_kidney_disease_due_to_hypertension.parent = causes.chronic_kidney_disease

causes.chronic_kidney_disease_due_to_glomerulonephritis.parent = causes.chronic_kidney_disease

causes.chronic_kidney_disease_due_to_other_and_unspecified_causes.parent = causes.chronic_kidney_disease

causes.urinary_diseases_and_male_infertility.parent = causes.other_non_communicable_diseases
causes.urinary_diseases_and_male_infertility.sub_causes = (causes.urinary_tract_infections_and_interstitial_nephritis,
                                                           causes.urolithiasis, causes.benign_prostatic_hyperplasia,
                                                           causes.male_infertility, causes.other_urinary_diseases, )

causes.urinary_tract_infections_and_interstitial_nephritis.parent = causes.urinary_diseases_and_male_infertility

causes.urolithiasis.parent = causes.urinary_diseases_and_male_infertility

causes.benign_prostatic_hyperplasia.parent = causes.urinary_diseases_and_male_infertility

causes.male_infertility.parent = causes.urinary_diseases_and_male_infertility

causes.other_urinary_diseases.parent = causes.urinary_diseases_and_male_infertility

causes.gynecological_diseases.parent = causes.other_non_communicable_diseases
causes.gynecological_diseases.sub_causes = (causes.uterine_fibroids, causes.polycystic_ovarian_syndrome,
                                            causes.female_infertility, causes.endometriosis, causes.genital_prolapse,
                                            causes.premenstrual_syndrome, causes.other_gynecological_diseases, )

causes.uterine_fibroids.parent = causes.gynecological_diseases

causes.polycystic_ovarian_syndrome.parent = causes.gynecological_diseases

causes.female_infertility.parent = causes.gynecological_diseases

causes.endometriosis.parent = causes.gynecological_diseases

causes.genital_prolapse.parent = causes.gynecological_diseases

causes.premenstrual_syndrome.parent = causes.gynecological_diseases

causes.other_gynecological_diseases.parent = causes.gynecological_diseases

causes.hemoglobinopathies_and_hemolytic_anemias.parent = causes.other_non_communicable_diseases
causes.hemoglobinopathies_and_hemolytic_anemias.sub_causes = (causes.thalassemias, causes.sickle_cell_disorders,
                                                              causes.g6pd_deficiency,
                                                              causes.other_hemoglobinopathies_and_hemolytic_anemias,
                                                              causes.thalassemias_trait, causes.sickle_cell_trait,
                                                              causes.g6pd_trait, )

causes.thalassemias.parent = causes.hemoglobinopathies_and_hemolytic_anemias

causes.sickle_cell_disorders.parent = causes.hemoglobinopathies_and_hemolytic_anemias

causes.g6pd_deficiency.parent = causes.hemoglobinopathies_and_hemolytic_anemias

causes.other_hemoglobinopathies_and_hemolytic_anemias.parent = causes.hemoglobinopathies_and_hemolytic_anemias

causes.endocrine_metabolic_blood_and_immune_disorders.parent = causes.other_non_communicable_diseases

causes.musculoskeletal_disorders.parent = causes.non_communicable_diseases
causes.musculoskeletal_disorders.sub_causes = (causes.rheumatoid_arthritis, causes.osteoarthritis,
                                               causes.low_back_pain, causes.neck_pain, causes.gout,
                                               causes.other_musculoskeletal_disorders, )

causes.rheumatoid_arthritis.parent = causes.musculoskeletal_disorders

causes.osteoarthritis.parent = causes.musculoskeletal_disorders
causes.osteoarthritis.sub_causes = (causes.osteoarthritis_hip, causes.osteoarthritis_knee, causes.osteoarthritis_hand,
                                    causes.osteoarthritis_other, )

causes.low_back_pain.parent = causes.musculoskeletal_disorders

causes.neck_pain.parent = causes.musculoskeletal_disorders

causes.gout.parent = causes.musculoskeletal_disorders

causes.other_musculoskeletal_disorders.parent = causes.musculoskeletal_disorders

causes.other_non_communicable_diseases.parent = causes.non_communicable_diseases
causes.other_non_communicable_diseases.sub_causes = (causes.urinary_diseases_and_male_infertility,
                                                     causes.gynecological_diseases,
                                                     causes.hemoglobinopathies_and_hemolytic_anemias,
                                                     causes.endocrine_metabolic_blood_and_immune_disorders,
                                                     causes.congenital_birth_defects, causes.oral_disorders,
                                                     causes.sudden_infant_death_syndrome, )

causes.congenital_birth_defects.parent = causes.other_non_communicable_diseases
causes.congenital_birth_defects.sub_causes = (causes.neural_tube_defects, causes.congenital_heart_anomalies,
                                              causes.orofacial_clefts, causes.down_syndrome, causes.turner_syndrome,
                                              causes.klinefelter_syndrome, causes.other_chromosomal_abnormalities,
                                              causes.congenital_musculoskeletal_and_limb_anomalies,
                                              causes.urogenital_congenital_anomalies,
                                              causes.digestive_congenital_anomalies,
                                              causes.other_congenital_birth_defects, )

causes.neural_tube_defects.parent = causes.congenital_birth_defects

causes.congenital_heart_anomalies.parent = causes.congenital_birth_defects

causes.orofacial_clefts.parent = causes.congenital_birth_defects

causes.down_syndrome.parent = causes.congenital_birth_defects

causes.turner_syndrome.parent = causes.congenital_birth_defects

causes.klinefelter_syndrome.parent = causes.congenital_birth_defects

causes.other_chromosomal_abnormalities.parent = causes.congenital_birth_defects

causes.congenital_musculoskeletal_and_limb_anomalies.parent = causes.congenital_birth_defects

causes.urogenital_congenital_anomalies.parent = causes.congenital_birth_defects

causes.digestive_congenital_anomalies.parent = causes.congenital_birth_defects

causes.other_congenital_birth_defects.parent = causes.congenital_birth_defects

causes.skin_and_subcutaneous_diseases.parent = causes.non_communicable_diseases
causes.skin_and_subcutaneous_diseases.sub_causes = (causes.dermatitis, causes.psoriasis, causes.scabies,
                                                    causes.fungal_skin_diseases, causes.viral_skin_diseases,
                                                    causes.acne_vulgaris, causes.alopecia_areata, causes.pruritus,
                                                    causes.urticaria, causes.decubitus_ulcer,
                                                    causes.other_skin_and_subcutaneous_diseases,
                                                    causes.bacterial_skin_diseases, )

causes.dermatitis.parent = causes.skin_and_subcutaneous_diseases
causes.dermatitis.sub_causes = (causes.atopic_dermatitis, causes.contact_dermatitis, causes.seborrhoeic_dermatitis, )

causes.psoriasis.parent = causes.skin_and_subcutaneous_diseases

causes.cellulitis.parent = causes.bacterial_skin_diseases

causes.pyoderma.parent = causes.bacterial_skin_diseases

causes.scabies.parent = causes.skin_and_subcutaneous_diseases

causes.fungal_skin_diseases.parent = causes.skin_and_subcutaneous_diseases

causes.viral_skin_diseases.parent = causes.skin_and_subcutaneous_diseases

causes.acne_vulgaris.parent = causes.skin_and_subcutaneous_diseases

causes.alopecia_areata.parent = causes.skin_and_subcutaneous_diseases

causes.pruritus.parent = causes.skin_and_subcutaneous_diseases

causes.urticaria.parent = causes.skin_and_subcutaneous_diseases

causes.decubitus_ulcer.parent = causes.skin_and_subcutaneous_diseases

causes.other_skin_and_subcutaneous_diseases.parent = causes.skin_and_subcutaneous_diseases

causes.sense_organ_diseases.parent = causes.non_communicable_diseases
causes.sense_organ_diseases.sub_causes = (causes.age_related_and_other_hearing_loss, causes.other_sense_organ_diseases,
                                          causes.blindness_and_vision_loss, )

causes.glaucoma.parent = causes.blindness_and_vision_loss

causes.cataract.parent = causes.blindness_and_vision_loss

causes.age_related_macular_degeneration.parent = causes.blindness_and_vision_loss

causes.age_related_and_other_hearing_loss.parent = causes.sense_organ_diseases

causes.other_vision_loss.parent = causes.blindness_and_vision_loss

causes.other_sense_organ_diseases.parent = causes.sense_organ_diseases

causes.oral_disorders.parent = causes.other_non_communicable_diseases
causes.oral_disorders.sub_causes = (causes.caries_of_deciduous_teeth, causes.caries_of_permanent_teeth,
                                    causes.periodontal_diseases, causes.edentulism, causes.other_oral_disorders, )

causes.caries_of_deciduous_teeth.parent = causes.oral_disorders

causes.caries_of_permanent_teeth.parent = causes.oral_disorders

causes.periodontal_diseases.parent = causes.oral_disorders

causes.edentulism.parent = causes.oral_disorders

causes.other_oral_disorders.parent = causes.oral_disorders

causes.sudden_infant_death_syndrome.parent = causes.other_non_communicable_diseases

causes.injuries.parent = causes.all_causes
causes.injuries.sub_causes = (causes.transport_injuries, causes.unintentional_injuries,
                              causes.self_harm_and_interpersonal_violence, )

causes.transport_injuries.parent = causes.injuries
causes.transport_injuries.sub_causes = (causes.road_injuries, causes.other_transport_injuries, )

causes.road_injuries.parent = causes.transport_injuries
causes.road_injuries.sub_causes = (causes.pedestrian_road_injuries, causes.cyclist_road_injuries,
                                   causes.motorcyclist_road_injuries, causes.motor_vehicle_road_injuries,
                                   causes.other_road_injuries, )

causes.pedestrian_road_injuries.parent = causes.road_injuries

causes.cyclist_road_injuries.parent = causes.road_injuries

causes.motorcyclist_road_injuries.parent = causes.road_injuries

causes.motor_vehicle_road_injuries.parent = causes.road_injuries

causes.other_road_injuries.parent = causes.road_injuries

causes.other_transport_injuries.parent = causes.transport_injuries

causes.unintentional_injuries.parent = causes.injuries
causes.unintentional_injuries.sub_causes = (causes.falls, causes.drowning, causes.fire_heat_and_hot_substances,
                                            causes.poisonings, causes.exposure_to_mechanical_forces,
                                            causes.adverse_effects_of_medical_treatment, causes.animal_contact,
                                            causes.foreign_body, causes.other_unintentional_injuries,
                                            causes.exposure_to_forces_of_nature,
                                            causes.environmental_heat_and_cold_exposure, )

causes.falls.parent = causes.unintentional_injuries

causes.drowning.parent = causes.unintentional_injuries

causes.fire_heat_and_hot_substances.parent = causes.unintentional_injuries

causes.poisonings.parent = causes.unintentional_injuries
causes.poisonings.sub_causes = (causes.poisoning_by_carbon_monoxide, causes.poisoning_by_other_means, )

causes.poisoning_by_carbon_monoxide.parent = causes.poisonings

causes.poisoning_by_other_means.parent = causes.poisonings

causes.exposure_to_mechanical_forces.parent = causes.unintentional_injuries
causes.exposure_to_mechanical_forces.sub_causes = (causes.unintentional_firearm_injuries,
                                                   causes.other_exposure_to_mechanical_forces, )

causes.unintentional_firearm_injuries.parent = causes.exposure_to_mechanical_forces

causes.other_exposure_to_mechanical_forces.parent = causes.exposure_to_mechanical_forces

causes.adverse_effects_of_medical_treatment.parent = causes.unintentional_injuries

causes.animal_contact.parent = causes.unintentional_injuries
causes.animal_contact.sub_causes = (causes.venomous_animal_contact, causes.non_venomous_animal_contact, )

causes.venomous_animal_contact.parent = causes.animal_contact

causes.non_venomous_animal_contact.parent = causes.animal_contact

causes.foreign_body.parent = causes.unintentional_injuries
causes.foreign_body.sub_causes = (causes.pulmonary_aspiration_and_foreign_body_in_airway, causes.foreign_body_in_eyes,
                                  causes.foreign_body_in_other_body_part, )

causes.pulmonary_aspiration_and_foreign_body_in_airway.parent = causes.foreign_body

causes.foreign_body_in_eyes.parent = causes.foreign_body

causes.foreign_body_in_other_body_part.parent = causes.foreign_body

causes.other_unintentional_injuries.parent = causes.unintentional_injuries

causes.self_harm_and_interpersonal_violence.parent = causes.injuries
causes.self_harm_and_interpersonal_violence.sub_causes = (causes.self_harm, causes.interpersonal_violence,
                                                          causes.executions_and_police_conflict,
                                                          causes.conflict_and_terrorism, )

causes.self_harm.parent = causes.self_harm_and_interpersonal_violence
causes.self_harm.sub_causes = (causes.self_harm_by_firearm, causes.self_harm_by_other_specified_means, )

causes.self_harm_by_firearm.parent = causes.self_harm

causes.self_harm_by_other_specified_means.parent = causes.self_harm

causes.interpersonal_violence.parent = causes.self_harm_and_interpersonal_violence
causes.interpersonal_violence.sub_causes = (causes.physical_violence_by_firearm,
                                            causes.physical_violence_by_sharp_object,
                                            causes.physical_violence_by_other_means, causes.sexual_violence, )

causes.physical_violence_by_firearm.parent = causes.interpersonal_violence

causes.physical_violence_by_sharp_object.parent = causes.interpersonal_violence

causes.physical_violence_by_other_means.parent = causes.interpersonal_violence

causes.exposure_to_forces_of_nature.parent = causes.unintentional_injuries

causes.maternal_deaths_aggravated_by_hiv_aids.parent = causes.maternal_disorders

causes.thalassemias_trait.parent = causes.hemoglobinopathies_and_hemolytic_anemias

causes.sickle_cell_trait.parent = causes.hemoglobinopathies_and_hemolytic_anemias

causes.g6pd_trait.parent = causes.hemoglobinopathies_and_hemolytic_anemias

causes.environmental_heat_and_cold_exposure.parent = causes.unintentional_injuries

causes.ebola.parent = causes.neglected_tropical_diseases_and_malaria

causes.acute_lymphoid_leukemia.parent = causes.leukemia

causes.chronic_lymphoid_leukemia.parent = causes.leukemia

causes.acute_myeloid_leukemia.parent = causes.leukemia

causes.chronic_myeloid_leukemia.parent = causes.leukemia

causes.non_melanoma_skin_cancer_squamous_cell_carcinoma.parent = causes.non_melanoma_skin_cancer

causes.non_melanoma_skin_cancer_basal_cell_carcinoma.parent = causes.non_melanoma_skin_cancer

causes.executions_and_police_conflict.parent = causes.self_harm_and_interpersonal_violence

causes.drug_susceptible_tuberculosis.parent = causes.tuberculosis

causes.zika_virus.parent = causes.neglected_tropical_diseases_and_malaria

causes.guinea_worm_disease.parent = causes.neglected_tropical_diseases_and_malaria

causes.alcoholic_cardiomyopathy.parent = causes.cardiomyopathy_and_myocarditis

causes.sexual_violence.parent = causes.interpersonal_violence

causes.myocarditis.parent = causes.cardiomyopathy_and_myocarditis

causes.other_leukemia.parent = causes.leukemia

causes.other_cardiomyopathy.parent = causes.cardiomyopathy_and_myocarditis

causes.conflict_and_terrorism.parent = causes.self_harm_and_interpersonal_violence

causes.multidrug_resistant_tuberculosis_without_extensive_drug_resistance.parent = causes.tuberculosis

causes.extensively_drug_resistant_tuberculosis.parent = causes.tuberculosis

causes.hiv_aids_drug_susceptible_tuberculosis.parent = causes.hiv_aids

causes.hiv_aids_multidrug_resistant_tuberculosis_without_extensive_drug_resistance.parent = causes.hiv_aids

causes.hiv_aids_extensively_drug_resistant_tuberculosis.parent = causes.hiv_aids

causes.latent_tuberculosis_infection.parent = causes.tuberculosis

causes.hiv_aids_and_sexually_transmitted_infections.parent = causes.communicable_maternal_neonatal_and_nutritional_diseases
causes.hiv_aids_and_sexually_transmitted_infections.sub_causes = (causes.hiv_aids,
                                                                  causes.sexually_transmitted_infections_excluding_hiv,
                                                                  )

causes.respiratory_infections_and_tuberculosis.parent = causes.communicable_maternal_neonatal_and_nutritional_diseases
causes.respiratory_infections_and_tuberculosis.sub_causes = (causes.tuberculosis, causes.lower_respiratory_infections,
                                                             causes.upper_respiratory_infections, causes.otitis_media,
                                                             )

causes.enteric_infections.parent = causes.communicable_maternal_neonatal_and_nutritional_diseases
causes.enteric_infections.sub_causes = (causes.diarrheal_diseases, causes.other_intestinal_infectious_diseases,
                                        causes.typhoid_and_paratyphoid, causes.invasive_non_typhoidal_salmonella_ints,
                                        )

causes.typhoid_and_paratyphoid.parent = causes.enteric_infections
causes.typhoid_and_paratyphoid.sub_causes = (causes.typhoid_fever, causes.paratyphoid_fever, )

causes.invasive_non_typhoidal_salmonella_ints.parent = causes.enteric_infections

causes.other_infectious_diseases.parent = causes.communicable_maternal_neonatal_and_nutritional_diseases
causes.other_infectious_diseases.sub_causes = (causes.meningitis, causes.encephalitis, causes.diphtheria,
                                               causes.whooping_cough, causes.tetanus, causes.measles,
                                               causes.varicella_and_herpes_zoster, causes.acute_hepatitis,
                                               causes.other_unspecified_infectious_diseases, )

causes.maternal_and_neonatal_disorders.parent = causes.communicable_maternal_neonatal_and_nutritional_diseases
causes.maternal_and_neonatal_disorders.sub_causes = (causes.maternal_disorders, causes.neonatal_disorders, )

causes.myelodysplastic_myeloproliferative_and_other_hematopoietic_neoplasms.parent = causes.other_neoplasms

causes.benign_and_in_situ_intestinal_neoplasms.parent = causes.other_neoplasms

causes.benign_and_in_situ_cervical_and_uterine_neoplasms.parent = causes.other_neoplasms

causes.other_benign_and_in_situ_neoplasms.parent = causes.other_neoplasms

causes.non_rheumatic_calcific_aortic_valve_disease.parent = causes.non_rheumatic_valvular_heart_disease

causes.non_rheumatic_degenerative_mitral_valve_disease.parent = causes.non_rheumatic_valvular_heart_disease

causes.other_non_rheumatic_valve_diseases.parent = causes.non_rheumatic_valvular_heart_disease

causes.cirrhosis_and_other_chronic_liver_diseases_due_to_nafld.parent = causes.cirrhosis_and_other_chronic_liver_diseases

causes.headache_disorders.parent = causes.neurological_disorders
causes.headache_disorders.sub_causes = (causes.migraine, causes.tension_type_headache, )

causes.substance_use_disorders.parent = causes.non_communicable_diseases
causes.substance_use_disorders.sub_causes = (causes.alcohol_use_disorders, causes.drug_use_disorders, )

causes.diabetes_and_kidney_diseases.parent = causes.non_communicable_diseases
causes.diabetes_and_kidney_diseases.sub_causes = (causes.diabetes_mellitus, causes.acute_glomerulonephritis,
                                                  causes.chronic_kidney_disease, )

causes.diabetes_mellitus_type_1.parent = causes.diabetes_mellitus

causes.diabetes_mellitus_type_2.parent = causes.diabetes_mellitus

causes.atopic_dermatitis.parent = causes.dermatitis

causes.contact_dermatitis.parent = causes.dermatitis

causes.seborrhoeic_dermatitis.parent = causes.dermatitis

causes.bacterial_skin_diseases.parent = causes.skin_and_subcutaneous_diseases
causes.bacterial_skin_diseases.sub_causes = (causes.cellulitis, causes.pyoderma, )

causes.blindness_and_vision_loss.parent = causes.sense_organ_diseases
causes.blindness_and_vision_loss.sub_causes = (causes.glaucoma, causes.cataract,
                                               causes.age_related_macular_degeneration, causes.other_vision_loss,
                                               causes.refraction_disorders, causes.near_vision_loss, )

causes.upper_digestive_system_diseases.parent = causes.digestive_diseases
causes.upper_digestive_system_diseases.sub_causes = (causes.peptic_ulcer_disease, causes.gastritis_and_duodenitis,
                                                     causes.gastroesophageal_reflux_disease, )

causes.maternal_abortion_and_miscarriage.parent = causes.maternal_disorders

causes.liver_cancer_due_to_nash.parent = causes.liver_cancer

causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_1.parent = causes.chronic_kidney_disease

causes.chronic_kidney_disease_due_to_diabetes_mellitus_type_2.parent = causes.chronic_kidney_disease

causes.refraction_disorders.parent = causes.blindness_and_vision_loss

causes.near_vision_loss.parent = causes.blindness_and_vision_loss

causes.osteoarthritis_hip.parent = causes.osteoarthritis

causes.osteoarthritis_knee.parent = causes.osteoarthritis

causes.osteoarthritis_hand.parent = causes.osteoarthritis

causes.osteoarthritis_other.parent = causes.osteoarthritis

causes.liver_cancer_due_to_other_causes.parent = causes.liver_cancer

causes.other_malignant_neoplasms.parent = causes.neoplasms

causes.other_cardiovascular_and_circulatory_diseases.parent = causes.cardiovascular_diseases

causes.total_burden_related_to_hepatitis_b.parent = causes.all_causes

causes.total_burden_related_to_hepatitis_c.parent = causes.all_causes

causes.total_burden_related_to_non_alcoholic_fatty_liver_disease_nafld.parent = causes.all_causes

causes.total_cancers.parent = causes.all_causes

