# -*- coding: utf-8 -*-
"""modul_partof_(ekspart).ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1cRCUN0tsJGjcOOjI8igSOCKK9s8_h6eK
"""

"""# Alternatif

### alternatif wsd
"""

import numpy as np
import pandas as pd
from nltk import pos_tag
from nltk.corpus import stopwords, wordnet as wn
from nltk.tokenize import word_tokenize 
from nltk.stem.wordnet import WordNetLemmatizer
from pywsd import disambiguate
from pywsd.similarity import similarity_by_path
from tabulate import tabulate

stops = set(stopwords.words("english"))
lem = WordNetLemmatizer()


class ukur_partOf_alternatif:
  def __init__(self):
    pass

  def fulldataset(self, data, inputSRS):
    xl = pd.ExcelFile(data)
    dfs = {sh:xl.parse(sh) for sh in xl.sheet_names}
    kalimat = dfs[inputSRS]
    kalimat_semua = kalimat.head(len(kalimat))
    return kalimat_semua

  def preprocessing(self, data):
    xl = pd.ExcelFile(data)
    for sh in xl.sheet_names:
      df = xl.parse(sh)
      print('Processing: [{}] ...'.format(sh))
      print(df.head())

  # cleaning text
  def apply_cleaning_function_to_list(self, X):
      cleaned_X = []
      for element in X:
          cleaned_X.append(ukur_partOf_alternatif.clean_text(self, raw_text= element))
      return cleaned_X

  def clean_text(self, raw_text):
      text = raw_text.lower()
      tokens = word_tokenize(text)
      token_words = [w for w in tokens if w.isalpha()]
      lemma_words = [lem.lemmatize(w) for w in token_words]
      meaningful_words = [w for w in lemma_words if not w in stops]
      joined_words = ( " ".join(meaningful_words))
      return joined_words    

  def convert_tag(self, tag):
      tag_dict = {'N': 'n', 'J': 'a', 'R': 'r', 'V': 'v'}
      try:
          return tag_dict[tag[0]]
      except KeyError:
          return None

  def doc_to_synsets(self, doc):
      tokens = word_tokenize(doc)
      pos = pos_tag(tokens)
      tags = [tag[1] for tag in pos]
      wntag = [ukur_partOf_alternatif.convert_tag(self, tag) for tag in tags]
      ans = list(zip(tokens,wntag))
      sets = [wn.synsets(x,y) for x,y in ans]
      final = [val[0] for val in sets if len(val) > 0]
      return final

  def similarity_score(self, s1, s2):
      s =[]
      for i1 in s1:
          r = []
          scores = [x for x in [i1.path_similarity(i2) for i2 in s2] if x is not None]
          if scores:
              s.append(max(scores))
      return sum(s)/len(s)

  def document_path_similarity(self, doc1, doc2):
      synsets1 = ukur_partOf_alternatif.doc_to_synsets(self, doc1)
      synsets2 = ukur_partOf_alternatif.doc_to_synsets(self, doc2)
      return (ukur_partOf_alternatif.similarity_score(self, synsets1, synsets2) + ukur_partOf_alternatif.similarity_score(self, synsets2, synsets1)) / 2

if __name__ == "__main__":
  try:
      myUkur = ukur_partOf_alternatif()
      a = myUkur.fulldataset(data, inputSRS)
      list_req1 = list(a['Requirement Statement'])
      id_req1 = list(a['ID'])
      cleaned1 = myUkur.apply_cleaning_function_to_list(X= list_req1)
      synsets1 = [myUkur.doc_to_synsets(x) for x in cleaned1]

      b = myUkur.fulldataset(data, inputSRS)
      list_req2 = list(b['Requirement Statement'])
      id_req2 = list(b['ID'])
      cleaned2 = myUkur.apply_cleaning_function_to_list(X= list_req2)
      synsets2 = [myUkur.doc_to_synsets(x) for x in cleaned2]

      data_list = []
      for idx, num in enumerate(synsets1):
        a = [myUkur.similarity_score(num, angka) for idy, angka in enumerate(synsets2)]
        data_list.append(a)

      df_a = pd.DataFrame(data_list, index= id_req1, columns= id_req2)
      print("data berdasarkan synset")
      print(tabulate(df_a, headers = 'keys', tablefmt = 'psql'))   


      data_list = []
      for idx, num in enumerate(cleaned1):
        a = [myUkur.document_path_similarity(num, angka) for idy, angka in enumerate(cleaned2)]
        data_list.append(a)

      print("\ndata berdasarkan dokumen")
      df_b = pd.DataFrame(data_list, index, columns)
      print(tabulate(df_b, headers = 'keys', tablefmt = 'psql'))   

      word1 = [disambiguate(x) for x in cleaned1]
      word1_synset = [[n[1] for n in y] for y in word1]
      word1_kata = [[n[0] for n in y] for y in word1]

      word2 = [disambiguate(x) for x in cleaned2]
      word2_synset = [[n[1] for n in y] for y in word2]
      word2_kata = [[n[0] for n in y] for y in word2]

      id1 = 7 #data index1
      id2 = 19 #data index2
      data_list = []
      for num in word1_synset[id1]:
        a = [(similarity_by_path(num, angka, option= "wup")) for angka in word2_synset[id2] if num and angka is not None]
        data_list.append(a)

      df_sem = pd.DataFrame(data_list, index= word1_kata[id1], columns= word2_kata[id2])
      print("\ndata berdasarkan dokumen")
      print(tabulate(df_sem, headers = 'keys', tablefmt = 'psql'))   
  except OSError as err:
    print("OS error: {0}".format(err))
