"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasNoMessage = exports.hasMessage = exports.findMessage = void 0;
const section_1 = require("./section");
function findMessage(messages, constructPath, props = {}) {
    const section = messages;
    const result = section_1.matchSection(filterPath(section, constructPath), props);
    if (!result.match) {
        return {};
    }
    return result.matches;
}
exports.findMessage = findMessage;
function hasMessage(messages, constructPath, props) {
    const section = messages;
    const result = section_1.matchSection(filterPath(section, constructPath), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return 'No messages found in the stack';
    }
    handleTrace(result.closestResult.target);
    return [
        `Stack has ${result.analyzedCount} messages, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasMessage = hasMessage;
function hasNoMessage(messages, constructPath, props) {
    const section = messages;
    const result = section_1.matchSection(filterPath(section, constructPath), props);
    if (!result.match) {
        return;
    }
    return [
        `Expected no matches, but stack has ${Object.keys(result.matches).length} messages as follows:`,
        section_1.formatAllMatches(result.matches),
    ].join('\n');
}
exports.hasNoMessage = hasNoMessage;
// We redact the stack trace by default because it is unnecessarily long and unintelligible.
// If there is a use case for rendering the trace, we can add it later.
function handleTrace(match, redact = true) {
    if (redact && match.entry?.trace !== undefined) {
        match.entry.trace = 'redacted';
    }
    ;
}
function filterPath(section, path) {
    // default signal for all paths is '*'
    if (path === '*')
        return section;
    return Object.entries(section ?? {})
        .filter(([_, v]) => v.id === path)
        .reduce((agg, [k, v]) => { return { ...agg, [k]: v }; }, {});
}
//# sourceMappingURL=data:application/json;base64,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