def buf(x):
    return bytes(x) + bytes(64 - len(x))


MODE_GAME = buf([0x5A, 0xD1, 0x01, 0x01, 0x01])

MODE_MOUSE = buf([0x5A, 0xD1, 0x01, 0x01, 0x03])

REMAP_DPAD_UD = buf(
    [
        0x5A,
        0xD1,
        0x02,
        0x01,
        0x2C,
        0x01,
        0x09,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x05,
        0x00,
        0x00,
        0x19,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x01,
        0x0A,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x04,
        0x00,
        0x00,
        0x00,
        0x00,
        0x03,
        0x8C,
        0x88,
        0x76,
    ]
)

REMAP_DPAD_LR = buf(
    [
        0x5A,
        0xD1,
        0x02,
        0x02,
        0x2C,
        0x01,
        0x0B,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x04,
        0x00,
        0x00,
        0x00,
        0x00,
        0x02,
        0x82,
        0x23,
        0x00,
        0x00,
        0x00,
        0x01,
        0x0C,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x04,
        0x00,
        0x00,
        0x00,
        0x00,
        0x02,
        0x82,
        0x0D,
    ]
)

REMAP_JOYSTICKS = buf(
    [
        0x5A,
        0xD1,
        0x02,
        0x03,
        0x2C,
        0x01,
        0x07,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x01,
        0x08,
    ]
)

REMAP_SHOULDERS = buf(
    [
        0x5A,
        0xD1,
        0x02,
        0x04,
        0x2C,
        0x01,
        0x05,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x01,
        0x06,
    ]
)

REMAP_AB = buf(
    [
        0x5A,
        0xD1,
        0x02,
        0x05,
        0x2C,
        0x01,
        0x01,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x05,
        0x00,
        0x00,
        0x16,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x01,
        0x02,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x04,
        0x00,
        0x00,
        0x00,
        0x00,
        0x02,
        0x82,
        0x31,
    ]
)

REMAP_XY = buf(
    [
        0x5A,
        0xD1,
        0x02,
        0x06,
        0x2C,
        0x01,
        0x03,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x04,
        0x00,
        0x00,
        0x00,
        0x00,
        0x02,
        0x82,
        0x4D,
        0x00,
        0x00,
        0x00,
        0x01,
        0x04,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x05,
        0x00,
        0x00,
        0x1E,
    ]
)

REMAP_VIEW_MENU = buf(
    [
        0x5A,
        0xD1,
        0x02,
        0x07,
        0x2C,
        0x01,
        0x11,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x01,
        0x12,
    ]
)

REMAP_M1M2_DEFAULT = buf(
    [
        0x5A,
        0xD1,
        0x02,
        0x08,
        0x2C,
        0x02,
        0x00,
        0x8E,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x02,
        0x00,
        0x8E,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x02,
        0x00,
        0x8F,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x02,
        0x00,
        0x8F,
    ]
)

REMAP_M1M2_F17F18 = buf(
    [
        0x5A,
        0xD1,
        0x02,
        0x08,
        0x2C,
        0x02,
        0x00,
        0x28,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x02,
        0x00,
        0x30,
    ]
)

REMAP_TRIGGERS = buf(
    [
        0x5A,
        0xD1,
        0x02,
        0x09,
        0x2C,
        0x01,
        0x0D,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x01,
        0x0E,
    ]
)

# Not verified this is the case
REMAP_M1M2_F17F18_MOUSE = buf(
    [
        0x5A,
        0xD1,
        0x02,
        0x08,
        0x2C,
        0x02,
        0x00,
        0x28,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x02,
        0x00,
        0x30,
    ]
)

FLUSH_BUFFER = buf([0x5A, 0xD1, 0x0A, 0x01])

COMMIT_RESET = [
    buf([0x5A, 0xD1, 0x0F, 0x20]),
    buf([0x5A, 0xD1, 0x06, 0x02, 0x64, 0x64]),
    buf([0x5A, 0xD1, 0x04, 0x04, 0x00, 0x64, 0x00, 0x64]),
    buf([0x5A, 0xD1, 0x05, 0x04, 0x00, 0x64, 0x00, 0x64]),
]

COMMANDS_GAME = [
    MODE_GAME,
    FLUSH_BUFFER,
    REMAP_DPAD_LR,
    FLUSH_BUFFER,
    REMAP_DPAD_UD,
    FLUSH_BUFFER,
    REMAP_JOYSTICKS,
    FLUSH_BUFFER,
    REMAP_SHOULDERS,
    FLUSH_BUFFER,
    REMAP_AB,
    FLUSH_BUFFER,
    REMAP_XY,
    FLUSH_BUFFER,
    REMAP_VIEW_MENU,
    FLUSH_BUFFER,
    REMAP_M1M2_F17F18,
    FLUSH_BUFFER,
    REMAP_TRIGGERS,
    *COMMIT_RESET,
]

COMMANDS_MOUSE = [
    MODE_MOUSE,
    FLUSH_BUFFER,
    buf(
        [
            0x5A,
            0xD1,
            0x02,
            0x01,
            0x2C,
            0x02,
            0x00,
            0x98,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x05,
            0x00,
            0x00,
            0x19,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x02,
            0x00,
            0x99,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x04,
            0x00,
            0x00,
            0x00,
            0x00,
            0x03,
            0x8C,
            0x88,
            0x76,
        ]
    ),
    FLUSH_BUFFER,
    buf(
        [
            0x5A,
            0xD1,
            0x02,
            0x02,
            0x2C,
            0x02,
            0x00,
            0x9A,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x04,
            0x00,
            0x00,
            0x00,
            0x00,
            0x02,
            0x82,
            0x23,
            0x00,
            0x00,
            0x00,
            0x02,
            0x00,
            0x9B,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x04,
            0x00,
            0x00,
            0x00,
            0x00,
            0x02,
            0x82,
            0x0D,
        ]
    ),
    FLUSH_BUFFER,
    buf(
        [
            0x5A,
            0xD1,
            0x02,
            0x03,
            0x2C,
            0x02,
            0x00,
            0x88,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x03,
            0x00,
            0x00,
            0x00,
            0x01,
        ]
    ),
    FLUSH_BUFFER,
    buf(
        [
            0x5A,
            0xD1,
            0x02,
            0x04,
            0x2C,
            0x02,
            0x00,
            0x0D,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x03,
            0x00,
            0x00,
            0x00,
            0x01,
        ]
    ),
    FLUSH_BUFFER,
    buf(
        [
            0x5A,
            0xD1,
            0x02,
            0x05,
            0x2C,
            0x02,
            0x00,
            0x5A,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x05,
            0x00,
            0x00,
            0x16,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x02,
            0x00,
            0x76,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x04,
            0x00,
            0x00,
            0x00,
            0x00,
            0x02,
            0x82,
            0x31,
        ]
    ),
    FLUSH_BUFFER,
    buf(
        [
            0x5A,
            0xD1,
            0x02,
            0x06,
            0x2C,
            0x02,
            0x00,
            0x97,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x04,
            0x00,
            0x00,
            0x00,
            0x00,
            0x02,
            0x82,
            0x4D,
            0x00,
            0x00,
            0x00,
            0x02,
            0x00,
            0x96,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x05,
            0x00,
            0x00,
            0x1E,
        ]
    ),
    FLUSH_BUFFER,
    buf(
        [
            0x5A,
            0xD1,
            0x02,
            0x07,
            0x2C,
            0x01,
            0x11,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x01,
            0x12,
        ]
    ),
    FLUSH_BUFFER,
    REMAP_M1M2_F17F18_MOUSE,
    FLUSH_BUFFER,
    buf(
        [
            0x5A,
            0xD1,
            0x02,
            0x09,
            0x2C,
            0x04,
            0x00,
            0x00,
            0x00,
            0x00,
            0x02,
            0x88,
            0x0D,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x03,
            0x00,
            0x00,
            0x00,
            0x02,
        ]
    ),
    *COMMIT_RESET,
]

RGB_APPLY = buf([0x5A, 0xB4])
RGB_SET = buf([0x5A, 0xB5])

RGB_INIT_1 = buf([0x5D, 0xB9])
RGB_INIT_2 = buf(
    [
        0x5D,
        0x41,
        0x53,
        0x55,
        0x53,
        0x20,
        0x54,
        0x65,
        0x63,
        0x68,
        0x2E,
        0x49,
        0x6E,
        0x63,
        0x2E,
    ]
)
