import logging

logging.basicConfig(level=logging.INFO)


def record_mouse() -> None:
    """
    Public function to start recording of mouse input
    """
    from gameart.inputs import mousetracker

    mousetracker._record_mouse()


def draw_mouse_tracks(csv_file_path: str, output_folder: str = "") -> None:
    """
    Public function to draw mousetracking-art based on csv file input
    which was generated by the method 'record_mouse'

    Args:
        csv_file_path (str): argument to provide path to csv file.
        output_folder (str, optional): argument to provide an output path.
    """
    from gameart.draw import art

    art._draw_mouse_tracks(csv_file_path, output_folder=output_folder)
