# -*- coding: utf-8 -*-
# flake8:noqa
# isort:skip_file
# vim:et:ft=python:nowrap:sts=4:sw=4:ts=4
##############################################################################
# Note: Generated by soapfish.wsdl2py at 2017-07-18 17:07:13.378291
#       Try to avoid editing it if you might need to regenerate it.
##############################################################################

from soapfish import soap, xsd

BaseHeader = xsd.ComplexType
from pyfva.soap import settings

from pyfva import load_module_responder

receptorclient = load_module_responder(settings.RECEPTOR_CLIENT)

##############################################################################
# Schemas


# http://bccr.fva.cr/


class ResultadoDeFirma(xsd.ComplexType):
    INHERITANCE = None
    INDICATOR = xsd.Sequence
    IdDeLaSolicitud = xsd.Element(xsd.Int, minOccurs=1)
    DocumentoFirmado = xsd.Element(
        xsd.Base64Binary, minOccurs=1, nillable=True)
    FueExitosa = xsd.Element(xsd.Boolean, minOccurs=1)
    CodigoDeError = xsd.Element(xsd.Int, minOccurs=1)
    IDAlgoritmoHashDocumentoFirmado = xsd.Element(xsd.Int, minOccurs=1)
    HashDocumentoFirmado = xsd.Element(xsd.String, minOccurs=0)
    HashDelDocumentoFirmadoEnBytes = xsd.Element(xsd.Base64Binary, minOccurs=0)

    @classmethod
    def create(cls, IdDeLaSolicitud, DocumentoFirmado, FueExitosa,
               CodigoDeError, IDAlgoritmoHashDocumentoFirmado, HashDocumentoFirmado=None, 
               HashDelDocumentoFirmadoEnBytes=None):
        instance = cls()
        instance.IdDeLaSolicitud = IdDeLaSolicitud
        instance.DocumentoFirmado = DocumentoFirmado
        instance.FueExitosa = FueExitosa
        instance.CodigoDeError = CodigoDeError
        instance.IDAlgoritmoHashDocumentoFirmado = IDAlgoritmoHashDocumentoFirmado
        if HashDocumentoFirmado is not None:
            instance.HashDocumentoFirmado = HashDocumentoFirmado

        if HashDelDocumentoFirmadoEnBytes is not None:
            instance.HashDelDocumentoFirmadoEnBytes = HashDelDocumentoFirmadoEnBytes
        return instance


class NotifiqueLaRespuesta(xsd.ComplexType):
    INHERITANCE = None
    INDICATOR = xsd.Sequence
    elResultado = xsd.Element(ResultadoDeFirma, minOccurs=0)

    @classmethod
    def create(cls):
        instance = cls()
        return instance


class NotifiqueLaRespuestaResponse(xsd.ComplexType):
    pass


class ValideElServicio(xsd.ComplexType):
    pass


class ValideElServicioResponse(xsd.ComplexType):
    INHERITANCE = None
    INDICATOR = xsd.Sequence
    ValideElServicioResult = xsd.Element(xsd.Boolean, minOccurs=1)

    @classmethod
    def create(cls, ValideElServicioResult):
        instance = cls()
        instance.ValideElServicioResult = ValideElServicioResult
        return instance


Schema_c49e7 = xsd.Schema(
    imports=[],
    includes=[],
    targetNamespace=settings.RECEPTOR_HOST,
    elementFormDefault='qualified',
    simpleTypes=[],
    attributeGroups=[],
    groups=[],
    complexTypes=[ResultadoDeFirma],
    elements={'NotifiqueLaRespuesta': xsd.Element(NotifiqueLaRespuesta()), 'NotifiqueLaRespuestaResponse': xsd.Element(NotifiqueLaRespuestaResponse(
    )), 'ValideElServicio': xsd.Element(ValideElServicio()), 'ValideElServicioResponse': xsd.Element(ValideElServicioResponse())},
)


##############################################################################
# Operations


def NotifiqueLaRespuesta(request, NotifiqueLaRespuesta):
    result = NotifiqueLaRespuesta.elResultado

    data = {
        'id_solicitud': result.IdDeLaSolicitud,
        'documento': result.DocumentoFirmado,
        'fue_exitosa': result.FueExitosa,
        'codigo_error': result.CodigoDeError,
        'hash_docfirmado': result.HashDocumentoFirmado,
        'hash_id': result.IDAlgoritmoHashDocumentoFirmado,
        'hash_bytes': result.HashDelDocumentoFirmadoEnBytes
    }

    dev = receptorclient.reciba_notificacion(data)
    return NotifiqueLaRespuestaResponse()


def ValideElServicio(request, ValideElServicio):
    dev = receptorclient.valide_servicio()
    return ValideElServicioResponse.create(dev)


##############################################################################
# Methods


NotifiqueLaRespuesta_method = xsd.Method(
    function=NotifiqueLaRespuesta,
    soapAction=settings.RECEPTOR_HOST + 'NotifiqueLaRespuesta',
    input='NotifiqueLaRespuesta',
    inputPartName='parameters',
    output='NotifiqueLaRespuestaResponse',
    outputPartName='parameters',
    operationName='NotifiqueLaRespuesta',
    style='document',
)


ValideElServicio_method = xsd.Method(
    function=ValideElServicio,
    soapAction=settings.RECEPTOR_HOST + 'ValideElServicio',
    input='ValideElServicio',
    inputPartName='parameters',
    output='ValideElServicioResponse',
    outputPartName='parameters',
    operationName='ValideElServicio',
    style='document',
)


##############################################################################
# SOAP Service


ResultadoDeSolicitudSoap_SERVICE = soap.Service(
    name='ResultadoDeSolicitudSoap',
    targetNamespace=settings.RECEPTOR_HOST,
    location='${scheme}://${host}/'+settings.WS_URL_NOTIFICATION,
    schemas=[Schema_c49e7],
    version=soap.SOAPVersion.SOAP12,
    methods=[NotifiqueLaRespuesta_method, ValideElServicio_method],
)


##############################################################################


# NOTE: Uncomment the following lines to turn on dispatching for Django:
# from soapfish.django_ import django_dispatcher
# dispatcher = django_dispatcher(ResultadoDeSolicitudSoap_SERVICE)


# NOTE: Put these lines in the urls.py for your project or application:
# urlpatterns += patterns('',
#     (r'^wcfv2\/Bccr\.Sinpe\.Fva\.EntidadDePruebas\.Notificador\/ResultadoDeSolicitud\.asmx$', '<module>.dispatcher'),
# )
