/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.util.NumberUtil;
import com.sas.util.transforms.StringToBooleanTransform;
import com.sas.util.transforms.StringToByteTransform;
import com.sas.util.transforms.StringToDoubleTransform;
import com.sas.util.transforms.StringToFloatTransform;
import com.sas.util.transforms.StringToIntegerTransform;
import com.sas.util.transforms.StringToShortTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

@SASScope
public class RBBase {
    public static final String RB_KEY = "RBBase.";
    private ResourceBundle resourceBundle;
    private Hashtable localeBundles;
    private static final String DEFAULT_RESOURCE_BUNDLE_NAME = "Resources";
    private String resourceBundleName;
    private static Map transformMap;

    protected RBBase() {
        this(DEFAULT_RESOURCE_BUNDLE_NAME);
    }

    protected RBBase(String resourceBundleName) {
        transformMap = new HashMap();
        transformMap.put("java.lang.Boolean", StringToBooleanTransform.defaultInstance);
        transformMap.put("java.lang.Byte", StringToByteTransform.defaultInstance);
        transformMap.put("java.lang.Double", StringToDoubleTransform.defaultInstance);
        transformMap.put("java.lang.Float", StringToFloatTransform.defaultInstance);
        transformMap.put("java.lang.Integer", StringToIntegerTransform.defaultInstance);
        transformMap.put("java.lang.Short", StringToShortTransform.defaultInstance);
        this.resourceBundleName = resourceBundleName;
    }

    private String resourceName() {
        String className = this.getClass().getName();
        int dot = className.lastIndexOf(46);
        return dot == -1 ? this.resourceBundleName : className.substring(0, dot) + "." + this.resourceBundleName;
    }

    protected final String _getStringResource(String key) {
        return this._getStringResource(key, Locale.getDefault());
    }

    protected final String _getStringResource(String key, Locale locale) {
        try {
            return this._getResources(locale).getString(key);
        }
        catch (MissingResourceException r) {
            throw r;
        }
        catch (Exception e) {
            throw new MissingResourceException(e.getMessage(), this.resourceName(), key);
        }
    }

    protected final ResourceBundle _getResources() {
        return this._getResources(Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ResourceBundle _getResources(Locale locale) {
        try {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (locale.equals(Locale.getDefault())) {
                RBBase rBBase = this;
                synchronized (rBBase) {
                    if (this.resourceBundle == null || !this.resourceBundle.getLocale().equals(locale)) {
                        this.resourceBundle = ResourceBundle.getBundle(this.resourceName(), locale, this.getClass().getClassLoader());
                    }
                }
                return this.resourceBundle;
            }
            ResourceBundle localeBundle = null;
            if (this.localeBundles == null) {
                this.localeBundles = new Hashtable();
            } else {
                localeBundle = (ResourceBundle)this.localeBundles.get(locale);
            }
            if (localeBundle != null) {
                return localeBundle;
            }
            RBBase rBBase = this;
            synchronized (rBBase) {
                localeBundle = ResourceBundle.getBundle(this.resourceName(), locale, this.getClass().getClassLoader());
                this.localeBundles.put(locale, localeBundle);
            }
            return localeBundle;
        }
        catch (MissingResourceException r) {
            System.out.println("Missing resource bundle " + this.resourceName() + " for locale " + locale);
            throw r;
        }
    }

    public boolean getResourceAsBoolean(String resourceName) {
        return RBBase.getResourceAsBoolean(this, resourceName, Locale.getDefault());
    }

    public boolean getResourceAsBoolean(String resourceName, Locale locale) {
        return RBBase.getResourceAsBoolean(this, resourceName, locale);
    }

    public byte getResourceAsByte(String resourceName) {
        return RBBase.getResourceAsByte(this, resourceName, Locale.getDefault());
    }

    public byte getResourceAsByte(String resourceName, Locale locale) {
        return RBBase.getResourceAsByte(this, resourceName, locale);
    }

    public char getResourceAsChar(String resourceName) {
        return RBBase.getResourceAsChar(this, resourceName, Locale.getDefault());
    }

    public char getResourceAsChar(String resourceName, Locale locale) {
        return RBBase.getResourceAsChar(this, resourceName, locale);
    }

    public double getResourceAsDouble(String resourceName) {
        return RBBase.getResourceAsDouble(this, resourceName, Locale.getDefault());
    }

    public double getResourceAsDouble(String resourceName, Locale locale) {
        return RBBase.getResourceAsDouble(this, resourceName, locale);
    }

    public float getResourceAsFloat(String resourceName) {
        return RBBase.getResourceAsFloat(this, resourceName, Locale.getDefault());
    }

    public float getResourceAsFloat(String resourceName, Locale locale) {
        return RBBase.getResourceAsFloat(this, resourceName, locale);
    }

    public int getResourceAsInt(String resourceName) {
        return RBBase.getResourceAsInt(this, resourceName, Locale.getDefault());
    }

    public int getResourceAsInt(String resourceName, Locale locale) {
        return RBBase.getResourceAsInt(this, resourceName, locale);
    }

    public long getResourceAsLong(String resourceName) {
        return RBBase.getResourceAsLong(this, resourceName, Locale.getDefault());
    }

    public long getResourceAsLong(String resourceName, Locale locale) {
        return RBBase.getResourceAsLong(this, resourceName, locale);
    }

    public short getResourceAsShort(String resourceName) {
        return RBBase.getResourceAsShort(this, resourceName, Locale.getDefault());
    }

    public short getResourceAsShort(String resourceName, Locale locale) {
        return RBBase.getResourceAsShort(this, resourceName, locale);
    }

    public Object getResourceAsObject(String resourceName, Class targetClass) {
        return RBBase.getResourceAsObject(this, resourceName, targetClass, Locale.getDefault());
    }

    public Object getResourceAsObject(String resourceName, Class targetClass, Locale locale) {
        return RBBase.getResourceAsObject(this, resourceName, targetClass, locale);
    }

    public Object getResourceAsObject(String resourceName, TransformInterface transform) {
        return RBBase.getResourceAsObject(this, resourceName, transform, Locale.getDefault());
    }

    public Object getResourceAsObject(String resourceName, TransformInterface transform, Locale locale) {
        return RBBase.getResourceAsObject(this, resourceName, transform, locale);
    }

    public static boolean getResourceAsBoolean(RBBase rb, String resourceName) {
        return RBBase.getResourceAsBoolean(rb, resourceName, Locale.getDefault());
    }

    public static boolean getResourceAsBoolean(RBBase rb, String resourceName, Locale locale) {
        String stringValue = rb._getStringResource(resourceName, locale);
        return Boolean.valueOf(stringValue);
    }

    public static byte getResourceAsByte(RBBase rb, String resourceName) {
        return RBBase.getResourceAsByte(rb, resourceName, Locale.getDefault());
    }

    public static byte getResourceAsByte(RBBase rb, String resourceName, Locale locale) {
        String stringValue = rb._getStringResource(resourceName, locale);
        return Byte.parseByte(stringValue);
    }

    public static char getResourceAsChar(RBBase rb, String resourceName) {
        return RBBase.getResourceAsChar(rb, resourceName, Locale.getDefault());
    }

    public static char getResourceAsChar(RBBase rb, String resourceName, Locale locale) {
        String stringValue = rb._getStringResource(resourceName, locale);
        if (stringValue.length() >= 1) {
            return stringValue.charAt(0);
        }
        return '\u0000';
    }

    public static double getResourceAsDouble(RBBase rb, String resourceName) {
        return RBBase.getResourceAsDouble(rb, resourceName, Locale.getDefault());
    }

    public static double getResourceAsDouble(RBBase rb, String resourceName, Locale locale) {
        String stringValue = rb._getStringResource(resourceName, locale);
        return NumberUtil.doubleValueOf(stringValue);
    }

    public static float getResourceAsFloat(RBBase rb, String resourceName) {
        return RBBase.getResourceAsFloat(rb, resourceName, Locale.getDefault());
    }

    public static float getResourceAsFloat(RBBase rb, String resourceName, Locale locale) {
        String stringValue = rb._getStringResource(resourceName, locale);
        return NumberUtil.floatValueOf(stringValue);
    }

    public static int getResourceAsInt(RBBase rb, String resourceName) {
        return RBBase.getResourceAsInt(rb, resourceName, Locale.getDefault());
    }

    public static int getResourceAsInt(RBBase rb, String resourceName, Locale locale) {
        String stringValue = rb._getStringResource(resourceName, locale);
        return Integer.valueOf(stringValue);
    }

    public static long getResourceAsLong(RBBase rb, String resourceName) {
        return RBBase.getResourceAsLong(rb, resourceName, Locale.getDefault());
    }

    public static long getResourceAsLong(RBBase rb, String resourceName, Locale locale) {
        String stringValue = rb._getStringResource(resourceName, locale);
        return Long.valueOf(stringValue);
    }

    public static short getResourceAsShort(RBBase rb, String resourceName) {
        return RBBase.getResourceAsShort(rb, resourceName, Locale.getDefault());
    }

    public static short getResourceAsShort(RBBase rb, String resourceName, Locale locale) {
        String stringValue = rb._getStringResource(resourceName, locale);
        return Short.valueOf(stringValue);
    }

    public static Object getResourceAsObject(RBBase rb, String resourceName, Class targetClass) {
        return RBBase.getResourceAsObject(rb, resourceName, targetClass, Locale.getDefault());
    }

    public static Object getResourceAsObject(RBBase rb, String resourceName, Class targetClass, Locale locale) {
        TransformInterface transform = RBBase.getStringTransform(targetClass);
        return RBBase.getResourceAsObject(rb, resourceName, transform, locale);
    }

    public static Object getResourceAsObject(RBBase rb, String resourceName, TransformInterface transform) {
        return RBBase.getResourceAsObject(rb, resourceName, transform, Locale.getDefault());
    }

    public static Object getResourceAsObject(RBBase rb, String resourceName, TransformInterface transform, Locale locale) {
        String stringValue = rb._getStringResource(resourceName, locale);
        Object transformedValue = stringValue;
        if (transform != null) {
            try {
                transformedValue = transform.transform(transformedValue);
            }
            catch (TransformException te) {
                te.printStackTrace();
            }
        }
        return transformedValue;
    }

    private static TransformInterface getStringTransform(Class outputClass) {
        return (TransformInterface)transformMap.get(outputClass.getName());
    }
}

