/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.SelectionHandlerInterface;
import com.sas.iom.orb.SelectionHub;
import com.sas.iom.orb.SelectionHubActivation;
import com.sas.iom.orb.ThreadPool;
import com.sas.iom.orb.WorkException;
import com.sas.iom.orb.WorkInterface;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;

@SASScope
public class SelectionHubKey {
    private SelectableChannel channel;
    private int interestOps;
    private SelectionHandlerInterface handler;
    private ThreadPool threadPool;
    private Thread spokeThread;
    private SelectionHubActivation activation;
    private SelectionKey delegate;
    private IOException registrationException;
    private int restarts;

    protected SelectionHubKey(SelectionHub hub, SelectableChannel channel, int initialInterestOps, SelectionHandlerInterface handler) {
        this.channel = channel;
        this.interestOps = initialInterestOps;
        this.handler = handler;
        this.threadPool = hub.getThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.checkThread();
        SelectionHubKey selectionHubKey = this;
        synchronized (selectionHubKey) {
            this.delegate.cancel();
            this.delegate = null;
        }
    }

    public SelectableChannel channel() {
        this.checkThread();
        return this.channel;
    }

    public int interestOps() {
        this.checkThread();
        int ops = this.delegate.interestOps();
        return ops;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interestOps(int ops) {
        this.checkThread();
        SelectionHubKey selectionHubKey = this;
        synchronized (selectionHubKey) {
            this.interestOps = ops;
            this.delegate.interestOps(ops);
        }
    }

    public boolean isAcceptable() {
        this.checkThread();
        boolean acceptable = this.delegate.isAcceptable();
        return acceptable;
    }

    public boolean isConnectable() {
        this.checkThread();
        boolean connectable = this.delegate.isConnectable();
        return connectable;
    }

    public boolean isReadable() {
        this.checkThread();
        boolean readable = this.delegate.isReadable();
        return readable;
    }

    public boolean isValid() {
        this.checkThread();
        boolean valid = this.delegate.isValid();
        return valid;
    }

    public boolean isWritable() {
        this.checkThread();
        boolean writable = this.delegate.isWritable();
        return writable;
    }

    public void executeDaemon(WorkInterface task) throws WorkException {
        this.checkThread();
        this.threadPool.executeDaemon(task);
    }

    protected SelectableChannel getChannel() {
        return this.channel;
    }

    protected int getInterestOps() {
        return this.interestOps;
    }

    protected void setInterestOps(int i) {
        this.interestOps = i;
    }

    protected SelectionHandlerInterface getHandler() {
        return this.handler;
    }

    protected void setSpokeThread(Thread t) {
        this.spokeThread = t;
    }

    protected SelectionHubActivation getActivation() {
        return this.activation;
    }

    protected void setActivation(SelectionHubActivation act) {
        this.activation = act;
    }

    protected SelectionKey getDelegate() {
        return this.delegate;
    }

    protected void setDelegate(SelectionKey key) {
        this.delegate = key;
    }

    protected IOException getRegistrationException() {
        return this.registrationException;
    }

    protected void setRegistrationException(IOException ex) {
        this.registrationException = ex;
    }

    protected int getRestarts() {
        return this.restarts;
    }

    protected void addRestart() {
        ++this.restarts;
    }

    protected void removeRestart() {
        --this.restarts;
    }

    private void checkThread() {
        if (!Thread.currentThread().equals(this.spokeThread)) {
            throw new SecurityException();
        }
    }
}

