/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.io.InputStreamHeaderInterface;
import com.sas.iom.InputStreamHeader;
import com.sas.iom.RB;
import com.sas.iom.SASCache.ICacheReader;
import com.sas.iom.SASCache.ICacheService;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class InputStream
extends java.io.InputStream {
    private ICacheReader _iCacheReader = null;
    private ICacheService _iCacheService = null;
    private byte[] _buffer = null;
    private int _offsetOfNextAvailableInBuffer = 0;
    private int _lengthAvailableInBuffer = 0;
    private boolean _eof = false;
    private boolean _headerAvailable = false;
    private Map _responseHeaders = null;
    private InputStreamHeader _header = null;

    public InputStream(ICacheReader iCacheReader, ICacheService iCacheService) {
        this._iCacheReader = iCacheReader;
        this._iCacheService = iCacheService;
    }

    public InputStreamHeaderInterface getHeader() {
        if (this._header == null) {
            try {
                this._header = new InputStreamHeader(this);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return this._header;
    }

    public byte[] getData() throws IOException {
        return this.getData(true);
    }

    public byte[] getData(boolean closeStream) throws IOException {
        byte[] data = new byte[]{};
        int BUFFER_LENGTH = 4096;
        BufferedInputStream bis = new BufferedInputStream(this, BUFFER_LENGTH);
        if (bis.available() > 0) {
            int numBytes;
            byte[] buffer = new byte[BUFFER_LENGTH];
            while ((numBytes = bis.read(buffer, 0, BUFFER_LENGTH)) >= 0) {
                byte[] newData = new byte[data.length + numBytes];
                System.arraycopy(data, 0, newData, 0, data.length);
                for (int i = 0; i < numBytes; ++i) {
                    newData[data.length + i] = buffer[i];
                }
                data = newData;
            }
            if (closeStream) {
                bis.close();
            }
        }
        return data;
    }

    public String getDataAsString() throws IOException {
        return this.getDataAsString(null, true);
    }

    public String getDataAsString(String encoding, boolean closeStream) throws IOException {
        int numChars;
        StringBuffer data = new StringBuffer();
        int BUFFER_LENGTH = 4096;
        BufferedReader br = null;
        if (encoding == null) {
            br = new BufferedReader(new InputStreamReader(this));
        } else {
            try {
                br = new BufferedReader(new InputStreamReader((java.io.InputStream)this, encoding), BUFFER_LENGTH);
            }
            catch (UnsupportedEncodingException ue) {
                throw new IOException(RB.getStringResource("InputStream.unsupportedEncodingException.ex.txt"));
            }
        }
        char[] buffer = new char[BUFFER_LENGTH];
        while ((numChars = br.read(buffer, 0, BUFFER_LENGTH)) >= 0) {
            data.append(buffer, 0, numChars);
        }
        if (closeStream) {
            br.close();
        }
        return data.toString();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.read(null, 0, (int)n);
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) > 0) {
            return b[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            if (this._offsetOfNextAvailableInBuffer >= this._lengthAvailableInBuffer) {
                if (this._eof) {
                    if (i == 0) {
                        return -1;
                    }
                    return i;
                }
                if (i > 0 && this.available() <= 0) {
                    return i;
                }
                this.getMore();
                if (this._lengthAvailableInBuffer == 0) {
                    if (this._eof && i == 0) {
                        return -1;
                    }
                    return i;
                }
            }
            if (b != null) {
                b[i + off] = this._buffer[this._offsetOfNextAvailableInBuffer];
            }
            ++this._offsetOfNextAvailableInBuffer;
        }
        return len;
    }

    @Override
    public int available() throws IOException {
        int bytesOnServer = 0;
        try {
            bytesOnServer = this._iCacheReader.Available();
        }
        catch (GenericError e) {
            throw new IOException(e.getMessage());
        }
        return this._lengthAvailableInBuffer - this._offsetOfNextAvailableInBuffer + bytesOnServer;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this._iCacheReader != null) {
                this._iCacheReader.Close();
            }
        }
        catch (GenericError e) {
            throw new IOException(MessageFormat.format(RB.getStringResource("InputStream.closeException.fmt.ex.txt"), e.getMessage()));
        }
    }

    private void getMore() throws IOException {
        this._lengthAvailableInBuffer = 0;
        this._offsetOfNextAvailableInBuffer = 0;
        try {
            OctetSeqHolder binaryData = new OctetSeqHolder();
            int ret = 0;
            if (this._iCacheReader != null) {
                ret = this._iCacheReader.Read(4096, binaryData);
            }
            this._buffer = binaryData.value;
            this._lengthAvailableInBuffer = this._buffer.length;
            if (this._lengthAvailableInBuffer > 0) {
                this._headerAvailable = true;
            }
            if (ret == -1) {
                this._eof = true;
            }
        }
        catch (GenericError e) {
            throw new IOException(MessageFormat.format(RB.getStringResource("InputStream.readException.fmt.ex.txt"), e.getMessage()));
        }
    }

    Map getResponseHeaders() throws IOException {
        if (this._responseHeaders == null) {
            StringSeqHolder names = new StringSeqHolder();
            StringSeqHolder values = new StringSeqHolder();
            try {
                if (this._iCacheService != null && this._iCacheReader != null) {
                    if (!this._headerAvailable) {
                        OctetSeqHolder binaryData = new OctetSeqHolder();
                        this._iCacheReader.Read(0, binaryData);
                        this._headerAvailable = true;
                    }
                    this._iCacheService.GetCacheProperties(this._iCacheReader.GetUUID(), names, values);
                }
            }
            catch (GenericError e) {
                throw new IOException(MessageFormat.format(RB.getStringResource("InputStream.getPropertiesException.fmt.ex.txt"), e.getMessage()));
            }
            this._responseHeaders = new HashMap();
            String[] nameArray = names.value;
            String[] valuesArray = values.value;
            for (int i = 0; i < nameArray.length; ++i) {
                if (!nameArray[i].startsWith("HTTP:")) continue;
                this._responseHeaders.put(nameArray[i].substring(5), valuesArray[i]);
            }
        }
        return this._responseHeaders;
    }

    boolean headerAvailable() {
        return this._headerAvailable;
    }
}

