from fitsnap3lib.lib.sym_ACE.gen_labels import *
from sympy.combinatorics import Permutation

import sys
sys.path.append('../')

# sylow_2_subgroups generated from gap code: https://www.gap-system.org
sylow_2_s4=[ ((0,),(1,),(2,),(3,)), ((2,3),), ((0,1),), ((0,1),(2,3)), ((0,2),(1,3)), ((0,2,1,3),), ((0,3,1,2),), ((0,3),(1,2)) ]

sylow_2_s6=[ ((0,),(1,),(2,),(3,),(4,),(5,)), ((4,5),), ((2,3),), ((2,3),(4,5)), ((0,1),), ((0,1),(4,5)), ((0,1),(2,3)),
  ((0,1),(2,3),(4,5)), ((0,2),(1,3)), ((0,2),(1,3),(4,5)), ((0,2,1,3),), ((0,2,1,3),(4,5)),
  ((0,3,1,2),), ((0,3,1,2),(4,5)), ((0,3),(1,2)), ((0,3),(1,2),(4,5)) ]

# add in extra conjugations for s6

extras = [
((4, 5),) ,
((2, 3),) ,
((2, 3), (4, 5)) ,
((2, 4), (3, 5)) ,
((2, 4, 3, 5),) ,
((2, 5, 3, 4),) ,
((2, 5), (3, 4)) ,
((0, 1),) ,
((0, 1), (4, 5)) ,
((0, 1), (2, 3)) ,
((0, 1), (2, 3), (4, 5)) ,
((0, 1), (2, 4), (3, 5)) ,
((0, 1), (2, 4, 3, 5)) ,
((0, 1), (2, 5, 3, 4)) ,
((0, 1), (2, 5), (3, 4)) ,
((0, 2), (1, 3)) ,
((0, 2), (1, 3), (4, 5)) ,
((0, 2, 1, 3),) ,
((0, 2, 1, 3), (4, 5)) ,
((0, 2, 4, 1, 3, 5),) ,
((0, 2, 5, 1, 3, 4),) ,
((0, 3, 1, 2),) ,
((0, 3, 1, 2), (4, 5)) ,
((0, 3), (1, 2)) ,
((0, 3), (1, 2), (4, 5)) ,
((0, 3, 5, 1, 2, 4),) ,
((0, 3, 4, 1, 2, 5),) ,
((0, 4, 3, 1, 5, 2),) ,
((0, 4, 2, 1, 5, 3),) ,
((0, 4), (1, 5)) ,
((0, 4, 1, 5),) ,
((0, 4), (1, 5), (2, 3)) ,
((0, 4, 1, 5), (2, 3)) ,
((0, 5, 3, 1, 4, 2),) ,
((0, 5, 2, 1, 4, 3),) ,
((0, 5, 1, 4),) ,
((0, 5), (1, 4)) ,
((0, 5, 1, 4), (2, 3)) ,
((0, 5), (1, 4), (2, 3)) 
]


extras = [p for p in extras if p not in sylow_2_s6]

sylow_2_s6.extend(extras)

sylow_2_s8=[ ((0,),(1,),(2,),(3,),(4,),(5,),(6,),(7,)), ((6,7),), ((4,5),), ((4,5),(6,7)), ((4,6),(5,7)), ((4,6,5,7)), ((4,7,5,6)), ((4,7),(5,6)),
  ((2,3),), ((2,3),(6,7)), ((2,3),(4,5)), ((2,3),(4,5),(6,7)), ((2,3),(4,6),(5,7)),
  ((2,3),(4,6,5,7)), ((2,3),(4,7,5,6)), ((2,3),(4,7),(5,6)), ((0,1),), ((0,1),(6,7)),
  ((0,1),(4,5)), ((0,1),(4,5),(6,7)), ((0,1),(4,6),(5,7)), ((0,1),(4,6,5,7)),
  ((0,1),(4,7,5,6)), ((0,1),(4,7),(5,6)), ((0,1),(2,3)), ((0,1),(2,3),(6,7)),
  ((0,1),(2,3),(4,5)), ((0,1),(2,3),(4,5),(6,7)), ((0,1),(2,3),(4,6),(5,7)),
  ((0,1),(2,3),(4,6,5,7)), ((0,1),(2,3),(4,7,5,6)), ((0,1),(2,3),(4,7),(5,6)), ((0,2),(1,3)),
  ((0,2),(1,3),(6,7)), ((0,2),(1,3),(4,5)), ((0,2),(1,3),(4,5),(6,7)),
  ((0,2),(1,3),(4,6),(5,7)), ((0,2),(1,3),(4,6,5,7)), ((0,2),(1,3),(4,7,5,6)),
  ((0,2),(1,3),(4,7),(5,6)), ((0,2,1,3),), ((0,2,1,3),(6,7)), ((0,2,1,3),(4,5)),
  ((0,2,1,3),(4,5),(6,7)), ((0,2,1,3),(4,6),(5,7)), ((0,2,1,3),(4,6,5,7)),
  ((0,2,1,3),(4,7,5,6)), ((0,2,1,3),(4,7),(5,6)), ((0,3,1,2),), ((0,3,1,2),(6,7)),
  ((0,3,1,2),(4,5)), ((0,3,1,2),(4,5),(6,7)), ((0,3,1,2),(4,6),(5,7)),
  ((0,3,1,2),(4,6,5,7)), ((0,3,1,2),(4,7,5,6)), ((0,3,1,2),(4,7),(5,6)), ((0,3),(1,2)),
  ((0,3),(1,2),(6,7)), ((0,3),(1,2),(4,5)), ((0,3),(1,2),(4,5),(6,7)),
  ((0,3),(1,2),(4,6),(5,7)), ((0,3),(1,2),(4,6,5,7)), ((0,3),(1,2),(4,7,5,6)),
  ((0,3),(1,2),(4,7),(5,6)), ((0,4),(1,5),(2,6),(3,7)), ((0,4),(1,5),(2,6,3,7)),
  ((0,4,1,5),(2,6),(3,7)), ((0,4,1,5),(2,6,3,7)), ((0,4,2,6),(1,5,3,7)),
  ((0,4,2,6,1,5,3,7),), ((0,4,3,7,1,5,2,6),), ((0,4,3,7),(1,5,2,6)),
  ((0,4),(1,5),(2,7,3,6)), ((0,4),(1,5),(2,7),(3,6)), ((0,4,1,5),(2,7,3,6)),
  ((0,4,1,5),(2,7),(3,6)), ((0,4,2,7,1,5,3,6),), ((0,4,2,7),(1,5,3,6)),
  ((0,4,3,6),(1,5,2,7)), ((0,4,3,6,1,5,2,7),), ((0,5,1,4),(2,6),(3,7)),
  ((0,5,1,4),(2,6,3,7)), ((0,5),(1,4),(2,6),(3,7)), ((0,5),(1,4),(2,6,3,7)),
  ((0,5,3,7,1,4,2,6),), ((0,5,3,7),(1,4,2,6)), ((0,5,2,6),(1,4,3,7)),
  ((0,5,2,6,1,4,3,7),), ((0,5,1,4),(2,7,3,6)), ((0,5,1,4),(2,7),(3,6)),
  ((0,5),(1,4),(2,7,3,6)), ((0,5),(1,4),(2,7),(3,6)), ((0,5,3,6),(1,4,2,7)),
  ((0,5,3,6,1,4,2,7),), ((0,5,2,7,1,4,3,6),), ((0,5,2,7),(1,4,3,6)),
  ((0,6,2,4),(1,7,3,5)), ((0,6,3,5,1,7,2,4),), ((0,6,2,4,1,7,3,5),),
  ((0,6,3,5),(1,7,2,4)), ((0,6),(1,7),(2,4),(3,5)), ((0,6,1,7),(2,4),(3,5)),
  ((0,6),(1,7),(2,4,3,5)), ((0,6,1,7),(2,4,3,5)), ((0,6,2,5,1,7,3,4),),
  ((0,6,3,4),(1,7,2,5)), ((0,6,2,5),(1,7,3,4)), ((0,6,3,4,1,7,2,5),),
  ((0,6),(1,7),(2,5,3,4)), ((0,6,1,7),(2,5,3,4)), ((0,6),(1,7),(2,5),(3,4)),
  ((0,6,1,7),(2,5),(3,4)), ((0,7,3,5,1,6,2,4),), ((0,7,2,4),(1,6,3,5)),
  ((0,7,3,5),(1,6,2,4)), ((0,7,2,4,1,6,3,5),), ((0,7,1,6),(2,4),(3,5)),
  ((0,7),(1,6),(2,4),(3,5)), ((0,7,1,6),(2,4,3,5)), ((0,7),(1,6),(2,4,3,5)),
  ((0,7,3,4),(1,6,2,5)), ((0,7,2,5,1,6,3,4),), ((0,7,3,4,1,6,2,5),),
  ((0,7,2,5),(1,6,3,4)), ((0,7,1,6),(2,5,3,4)), ((0,7),(1,6),(2,5,3,4)),
  ((0,7,1,6),(2,5),(3,4)), ((0,7),(1,6),(2,5),(3,4)) ]

# subtree symmetries 
s4_subtree_syms  = [((0,1),), ((2,3),)]

s6_subtree_syms=sylow_2_s4.copy() + [((4,5),)]

# Conjugations and fusions with subtree symmetries 
fusion6 =[((2, 4), (3, 5)),
 ((2, 4, 3, 5),),
 ((2, 5, 3, 4),),
 ((2, 5), (3, 4)),
 ((0, 1), (2, 4), (3, 5)),
 ((0, 1), (2, 4, 3, 5)),
 ((0, 1), (2, 5, 3, 4)),
 ((0, 1), (2, 5), (3, 4)),
 ((0, 2, 4, 1, 3, 5),),
 ((0, 2, 5, 1, 3, 4),),
 ((0, 3, 5, 1, 2, 4),),
 ((0, 3, 4, 1, 2, 5),),
 ((0, 4, 3, 1, 5, 2),),
 ((0, 4, 2, 1, 5, 3),),
 ((0, 4), (1, 5)),
 ((0, 4, 1, 5),),
 ((0, 4), (1, 5), (2, 3)),
 ((0, 4, 1, 5), (2, 3)),
 ((0, 5, 3, 1, 4, 2),),
 ((0, 5, 2, 1, 4, 3),),
 ((0, 5, 1, 4),),
 ((0, 5), (1, 4)),
 ((0, 5, 1, 4), (2, 3)),
 ((0, 5), (1, 4), (2, 3))]


fusion8 = [((4, 6, 5, 7),),
 ((4, 7, 5, 6),),
 ((2, 4), (3, 5)),
 ((2, 4), (3, 5), (6, 7)),
 ((2, 4, 3, 5),),
 ((2, 4, 3, 5), (6, 7)),
 ((2, 4, 6, 3, 5, 7),),
 ((2, 4, 7, 3, 5, 6),),
 ((2, 5, 3, 4),),
 ((2, 5, 3, 4), (6, 7)),
 ((2, 5), (3, 4)),
 ((2, 5), (3, 4), (6, 7)),
 ((2, 5, 7, 3, 4, 6),),
 ((2, 5, 6, 3, 4, 7),),
 ((2, 6, 5, 3, 7, 4),),
 ((2, 6, 4, 3, 7, 5),),
 ((2, 6), (3, 7)),
 ((2, 6, 3, 7),),
 ((2, 6), (3, 7), (4, 5)),
 ((2, 6, 3, 7), (4, 5)),
 ((2, 7, 5, 3, 6, 4),),
 ((2, 7, 4, 3, 6, 5),),
 ((2, 7, 3, 6),),
 ((2, 7), (3, 6)),
 ((2, 7, 3, 6), (4, 5)),
 ((2, 7), (3, 6), (4, 5)),
 ((0, 1), (2, 4), (3, 5)),
 ((0, 1), (2, 4), (3, 5), (6, 7)),
 ((0, 1), (2, 4, 3, 5)),
 ((0, 1), (2, 4, 3, 5), (6, 7)),
 ((0, 1), (2, 4, 6, 3, 5, 7)),
 ((0, 1), (2, 4, 7, 3, 5, 6)),
 ((0, 1), (2, 5, 3, 4)),
 ((0, 1), (2, 5, 3, 4), (6, 7)),
 ((0, 1), (2, 5), (3, 4)),
 ((0, 1), (2, 5), (3, 4), (6, 7)),
 ((0, 1), (2, 5, 7, 3, 4, 6)),
 ((0, 1), (2, 5, 6, 3, 4, 7)),
 ((0, 1), (2, 6, 5, 3, 7, 4)),
 ((0, 1), (2, 6, 4, 3, 7, 5)),
 ((0, 1), (2, 6), (3, 7)),
 ((0, 1), (2, 6, 3, 7)),
 ((0, 1), (2, 6), (3, 7), (4, 5)),
 ((0, 1), (2, 6, 3, 7), (4, 5)),
 ((0, 1), (2, 7, 5, 3, 6, 4)),
 ((0, 1), (2, 7, 4, 3, 6, 5)),
 ((0, 1), (2, 7, 3, 6)),
 ((0, 1), (2, 7), (3, 6)),
 ((0, 1), (2, 7, 3, 6), (4, 5)),
 ((0, 1), (2, 7), (3, 6), (4, 5)),
 ((0, 2, 4, 1, 3, 5),),
 ((0, 2, 4, 1, 3, 5), (6, 7)),
 ((0, 2, 4, 6), (1, 3, 5, 7)),
 ((0, 2, 4, 6, 1, 3, 5, 7),),
 ((0, 2, 4, 7, 1, 3, 5, 6),),
 ((0, 2, 4, 7), (1, 3, 5, 6)),
 ((0, 2, 5, 1, 3, 4),),
 ((0, 2, 5, 1, 3, 4), (6, 7)),
 ((0, 2, 5, 7, 1, 3, 4, 6),),
 ((0, 2, 5, 7), (1, 3, 4, 6)),
 ((0, 2, 5, 6), (1, 3, 4, 7)),
 ((0, 2, 5, 6, 1, 3, 4, 7),),
 ((0, 2, 6, 4), (1, 3, 7, 5)),
 ((0, 2, 6, 5, 1, 3, 7, 4),),
 ((0, 2, 6, 4, 1, 3, 7, 5),),
 ((0, 2, 6, 5), (1, 3, 7, 4)),
 ((0, 2, 6, 1, 3, 7),),
 ((0, 2, 6, 1, 3, 7), (4, 5)),
 ((0, 2, 7, 5, 1, 3, 6, 4),),
 ((0, 2, 7, 4), (1, 3, 6, 5)),
 ((0, 2, 7, 5), (1, 3, 6, 4)),
 ((0, 2, 7, 4, 1, 3, 6, 5),),
 ((0, 2, 7, 1, 3, 6),),
 ((0, 2, 7, 1, 3, 6), (4, 5)),
 ((0, 3, 5, 1, 2, 4),),
 ((0, 3, 5, 1, 2, 4), (6, 7)),
 ((0, 3, 5, 7, 1, 2, 4, 6),),
 ((0, 3, 5, 7), (1, 2, 4, 6)),
 ((0, 3, 5, 6), (1, 2, 4, 7)),
 ((0, 3, 5, 6, 1, 2, 4, 7),),
 ((0, 3, 4, 1, 2, 5),),
 ((0, 3, 4, 1, 2, 5), (6, 7)),
 ((0, 3, 4, 6), (1, 2, 5, 7)),
 ((0, 3, 4, 6, 1, 2, 5, 7),),
 ((0, 3, 4, 7, 1, 2, 5, 6),),
 ((0, 3, 4, 7), (1, 2, 5, 6)),
 ((0, 3, 7, 5, 1, 2, 6, 4),),
 ((0, 3, 7, 4), (1, 2, 6, 5)),
 ((0, 3, 7, 5), (1, 2, 6, 4)),
 ((0, 3, 7, 4, 1, 2, 6, 5),),
 ((0, 3, 7, 1, 2, 6),),
 ((0, 3, 7, 1, 2, 6), (4, 5)),
 ((0, 3, 6, 4), (1, 2, 7, 5)),
 ((0, 3, 6, 5, 1, 2, 7, 4),),
 ((0, 3, 6, 4, 1, 2, 7, 5),),
 ((0, 3, 6, 5), (1, 2, 7, 4)),
 ((0, 3, 6, 1, 2, 7),),
 ((0, 3, 6, 1, 2, 7), (4, 5)),
 ((0, 4, 3, 1, 5, 2),),
 ((0, 4, 3, 1, 5, 2), (6, 7)),
 ((0, 4, 6, 2), (1, 5, 7, 3)),
 ((0, 4, 6, 3, 1, 5, 7, 2),),
 ((0, 4, 7, 3, 1, 5, 6, 2),),
 ((0, 4, 7, 2), (1, 5, 6, 3)),
 ((0, 4, 2, 1, 5, 3),),
 ((0, 4, 2, 1, 5, 3), (6, 7)),
 ((0, 4, 6, 2, 1, 5, 7, 3),),
 ((0, 4, 6, 3), (1, 5, 7, 2)),
 ((0, 4, 7, 3), (1, 5, 6, 2)),
 ((0, 4, 7, 2, 1, 5, 6, 3),),
 ((0, 4), (1, 5)),
 ((0, 4), (1, 5), (6, 7)),
 ((0, 4, 1, 5),),
 ((0, 4, 1, 5), (6, 7)),
 ((0, 4, 6, 1, 5, 7),),
 ((0, 4, 7, 1, 5, 6),),
 ((0, 4), (1, 5), (2, 3)),
 ((0, 4), (1, 5), (2, 3), (6, 7)),
 ((0, 4, 1, 5), (2, 3)),
 ((0, 4, 1, 5), (2, 3), (6, 7)),
 ((0, 4, 6, 1, 5, 7), (2, 3)),
 ((0, 4, 7, 1, 5, 6), (2, 3)),
 ((0, 5, 3, 1, 4, 2),),
 ((0, 5, 3, 1, 4, 2), (6, 7)),
 ((0, 5, 7, 3, 1, 4, 6, 2),),
 ((0, 5, 7, 2), (1, 4, 6, 3)),
 ((0, 5, 6, 2), (1, 4, 7, 3)),
 ((0, 5, 6, 3, 1, 4, 7, 2),),
 ((0, 5, 2, 1, 4, 3),),
 ((0, 5, 2, 1, 4, 3), (6, 7)),
 ((0, 5, 7, 3), (1, 4, 6, 2)),
 ((0, 5, 7, 2, 1, 4, 6, 3),),
 ((0, 5, 6, 2, 1, 4, 7, 3),),
 ((0, 5, 6, 3), (1, 4, 7, 2)),
 ((0, 5, 1, 4),),
 ((0, 5, 1, 4), (6, 7)),
 ((0, 5), (1, 4)),
 ((0, 5), (1, 4), (6, 7)),
 ((0, 5, 7, 1, 4, 6),),
 ((0, 5, 6, 1, 4, 7),),
 ((0, 5, 1, 4), (2, 3)),
 ((0, 5, 1, 4), (2, 3), (6, 7)),
 ((0, 5), (1, 4), (2, 3)),
 ((0, 5), (1, 4), (2, 3), (6, 7)),
 ((0, 5, 7, 1, 4, 6), (2, 3)),
 ((0, 5, 6, 1, 4, 7), (2, 3)),
 ((0, 6, 4, 2), (1, 7, 5, 3)),
 ((0, 6, 5, 3, 1, 7, 4, 2),),
 ((0, 6, 4, 3, 1, 7, 5, 2),),
 ((0, 6, 5, 2), (1, 7, 4, 3)),
 ((0, 6, 3, 1, 7, 2),),
 ((0, 6, 3, 1, 7, 2), (4, 5)),
 ((0, 6, 4, 2, 1, 7, 5, 3),),
 ((0, 6, 5, 3), (1, 7, 4, 2)),
 ((0, 6, 4, 3), (1, 7, 5, 2)),
 ((0, 6, 5, 2, 1, 7, 4, 3),),
 ((0, 6, 2, 1, 7, 3),),
 ((0, 6, 2, 1, 7, 3), (4, 5)),
 ((0, 6, 5, 1, 7, 4),),
 ((0, 6, 4, 1, 7, 5),),
 ((0, 6), (1, 7)),
 ((0, 6, 1, 7),),
 ((0, 6), (1, 7), (4, 5)),
 ((0, 6, 1, 7), (4, 5)),
 ((0, 6, 5, 1, 7, 4), (2, 3)),
 ((0, 6, 4, 1, 7, 5), (2, 3)),
 ((0, 6), (1, 7), (2, 3)),
 ((0, 6, 1, 7), (2, 3)),
 ((0, 6), (1, 7), (2, 3), (4, 5)),
 ((0, 6, 1, 7), (2, 3), (4, 5)),
 ((0, 7, 5, 3, 1, 6, 4, 2),),
 ((0, 7, 4, 2), (1, 6, 5, 3)),
 ((0, 7, 5, 2), (1, 6, 4, 3)),
 ((0, 7, 4, 3, 1, 6, 5, 2),),
 ((0, 7, 3, 1, 6, 2),),
 ((0, 7, 3, 1, 6, 2), (4, 5)),
 ((0, 7, 5, 3), (1, 6, 4, 2)),
 ((0, 7, 4, 2, 1, 6, 5, 3),),
 ((0, 7, 5, 2, 1, 6, 4, 3),),
 ((0, 7, 4, 3), (1, 6, 5, 2)),
 ((0, 7, 2, 1, 6, 3),),
 ((0, 7, 2, 1, 6, 3), (4, 5)),
 ((0, 7, 5, 1, 6, 4),),
 ((0, 7, 4, 1, 6, 5),),
 ((0, 7, 1, 6),),
 ((0, 7), (1, 6)),
 ((0, 7, 1, 6), (4, 5)),
 ((0, 7), (1, 6), (4, 5)),
 ((0, 7, 5, 1, 6, 4), (2, 3)),
 ((0, 7, 4, 1, 6, 5), (2, 3)),
 ((0, 7, 1, 6), (2, 3)),
 ((0, 7), (1, 6), (2, 3)),
 ((0, 7, 1, 6), (2, 3), (4, 5)),
 ((0, 7), (1, 6), (2, 3), (4, 5))]


def filled_perm(tups,rank):
	allinds = list(range(rank))
	try:
		remainders = [ i for i in allinds if i not in flatten(tups)]
		alltups = tups + tuple([tuple([k]) for k in remainders])
	except TypeError:
		remainders = [ i for i in allinds if i not in flatten(flatten(tups))]
		alltups = tups + tuple([tuple([k]) for k in remainders])
	return alltups

def base_automorphisms(l,subtree=False):
	# base automorphism groups for most practical descriptor labels.
	if len(l) == 4 or len(l) == 5:
		if not subtree:
			all_ops = sylow_2_s4
		else:
			all_ops = s4_subtree_syms
	elif len(l) == 6 or len(l) == 7:
		if not subtree:
			all_ops = sylow_2_s6
		else:
			all_ops = s6_subtree_syms
	elif len(l) == 8 or len(l) == 9:
		if not subtree:
			all_ops = sylow_2_s8
		else:
			all_ops = s8_subtree_syms
	else:
		raise ValueError()

	all_ops.sort(key=lambda x: x,reverse=True)
	all_ops.sort(key=lambda x: tuple([len(k) for k in x]),reverse=True)

	all_ops = [filled_perm(op,len(l)) for op in all_ops]

	all_parts = []
	for op in all_ops:
		orbits = [len(x) for x in op]
		partition = tuple(orbits)
		all_parts.append(partition)
	unique_parts = list(set(all_parts))
	unique_parts.sort(key=lambda x: len(x),reverse=True)
	unique_parts.sort(key=lambda x: x,reverse=True)
	op_per_part = {p:[] for p in unique_parts}
	for op_part in zip(all_ops,all_parts):
		this_op,this_part = op_part
		op_per_part[this_part].append(this_op)

	if tuple([len(l)]) not in unique_parts:
		unique_parts = [tuple([len(l)])] + unique_parts
		op_per_part[tuple([len(l)])] = [  tuple([ tuple([i]) for i in  range(len(l))]) ]
	organized_automorphisms = {p: sorted(op_per_part[p]) for p in unique_parts} 
	return organized_automorphisms

def get_auto_part(l,part,add_degen_autos=False,part_only=False,subtree=False):
	
	# grows the automorphism group for a given l vector,
	#   and returns permutation operations belonging to specific set of orbits
	#   in the partition 'part' 
	#   add_degen_autos (logical) : flag to grow automorphism group based on degeneracy
	#   part_only (logical) : flag to return automorphisms within one set of orbits

	N = len(l)
	G_N_per_part = base_automorphisms(l,subtree)
	if part_only:
		applied_perms = [tuple(Permutation(filled_perm(pi,len(l)))(l)) for pi in G_N_per_part[part]]
	elif not part_only:
		applied_perms = [tuple(Permutation(filled_perm(pi,len(l)))(l)) for pi in flatten(G_N_per_part.values())]
	autos = []
	if add_degen_autos:
		perms = [p for p in itertools.permutations(range(N))]	
		for perm in perms:
			P = Permutation(perm)
			cyc = P.full_cyclic_form
			cyc = tuple([tuple(k) for k in cyc])
			this_applied = P(l)
			if tuple(this_applied) in applied_perms:
				autos.append(cyc)
	if part_only:
		return_lst = sorted(list(set(G_N_per_part[part] + autos)))
	elif not part_only:
		return_lst = sorted(list(set(flatten(G_N_per_part.values()) + autos)))
	return return_lst

