from enum import IntEnum, unique


@unique
class CTS3ErrorCode(IntEnum):
    """Error codes"""

    """
    Generic error codes
    """
    RET_OK = 0x0000
    RET_UNKNOWN_COMMAND = 0x0001
    RET_INVALID_PARAMETER = 0x0003
    RET_BAD_PARMS = 0x0006
    RET_BAD_POINTER = 0x0011
    RET_NOTAVAILABLE = 0x0012
    RET_INVALID_EEPROM = 0x0017
    RET_INVALID_USER_CALIB = 0x0018
    RET_INVALID_SYS_CALIB = 0x0019
    RET_MEMORY_ALLOC = 0x001A
    RET_COUPLER_NOT_DETECTED = 0x001C
    RET_API_NOT_AVAILABLE = 0x001D
    RET_SYSTEM_TIMEOUT = 0x001E
    RET_BUFFER_TOO_SMALL = 0x001F
    RET_COUPLER_ABORT = 0x0020
    RET_RECOVERY_MODE = 0x0035
    RET_NOT_INITIALIZED = 0x0036
    RET_INIT_FAILED = 0x0038
    RET_BUSY = 0x0039
    CRET_INVALID_LICENSE = 0x0187

    """
    Communication port error codes
    """
    RET_PORT_INVALID_NUMBER = 0x0C1C
    RET_PORT_NOT_OPEN = 0x0C1D

    """
    Firmware update error codes
    """
    RET_FIRM_GPG_DECRYPT_FAIL = 0x0CEE
    RET_FIRM_GPG_NO_KEY = 0x0CEF

    """
    Embedded licenses error codes
    """
    RET_WIBU_NOT_OPEN = 0x0CF8
    RET_WIBU_FAILED = 0x0CFA
    RET_WIBU_NOT_WRITTEN = 0x0CFB
    RET_WIBU_RX_ERROR = 0x0CFC

    """
    File management error codes
    """
    ERR_MODULE_NOT_FOUND = 0x0135
    ERR_OPEN_FILE_FAILED = 0x0280
    ERR_DOWNLOAD_FILE_FAILED = 0x0281
    ERR_UPLOAD_FILE_FAILED = 0x0282

    """
    Resource management error codes
    """
    RET_RESOURCE_NOT_OPEN = 0x0E74
    RET_RESOURCE_INVALID_ID = 0x0E75
    RET_RESOURCE_ALREADY_OPEN = 0x0F3E

    """
    Measurement error codes
    """
    CRET_MEASURE_RUNNING = 0x00E0
    CRET_NO_MEASURE_PENDING = 0x00E1
    ERR_INVALID_IMPEDANCE_CALIBRATION_TABLE = 0x01F8
    ERR_NO_CABLE_INFORMATION = 0x01F9
    ERR_NO_HEAD_INFORMATION = 0x01FA
    ERR_RESONANCE_FREQUENCY_MEASUREMENT = 0x01FB
    ERR_RF_FIELD_TOO_HIGH = 0x020B
    ERR_TRANSMIT_MEASURE_TO_FILE_FAILED = 0x0213
    ERR_MEASUREMENT_OUT_OF_RANGE = 0x0216

    """
    DAQ error codes
    """
    RET_DAQ_BUSY = 0x0E12
    RET_DAQ_CHANNEL_NOT_SET = 0x0E13
    RET_DAQ_OVERVOLTAGE = 0x0E14

    """
    WLC error codes
    """
    RET_WLC_STOP_REQUEST = 0x0400
    RET_WLC_IMPEDANCE_CHANGE = 0x0401

    """
    Protocol Analyzer error codes
    """
    CRET_DOWNLOAD_RUNNING = 0x010E
    CRET_NO_DOWNLOAD_RUNNING = 0x010F
    CRET_SPY_FIFO_OVERRUN = 0x0110

    """
    Sequencer error codes
    """
    CRET_SEQUENCER_NO_SUCH_SEQUENCEID = 0x011A
    CRET_SEQUENCER_ERROR = 0x0121

    """
    High-level simulator error codes
    """
    ERRSIM_NO_PPS_REQUEST_PENDING = 0x00C8
    CRET_SIM_NO_EVENT = 0x0186
    CRET_SIMULATOR_NOT_RUNNING = 0x0188
    CRET_RULE_NOT_FOUND = 0x0189
    CRET_SIMULATOR_NOT_INITIALIZED = 0x018A
    CRET_WRONG_SIMU = 0x01BB
    CRET_WRONG_FILTER = 0x01BC
    CRET_FPGA_SIMU_RAM_FULL = 0x01C8
    ERRSIM_NO_FRAME_AVAILABLE = 0x02D4
    ERRSIM_NO_APDU_AVAILABLE = 0x02D5
    ERRSIM_NO_RATS_PENDING = 0x02D7
    ERRSIM_NO_ATTRIB_PENDING = 0x02DA
    ERRSIM_NO_SPARAM_AVAILABLE = 0x02DB
    ERRSIM_WRONG_NFC_ATR_REQ = 0x02DF
    ERRSIM_WRONG_NFC_PSL_REQ = 0x02E1
    ERRSIM_WRONG_NFC_WUP_REQ = 0x02E2
    ERRSIM_WRONG_NFC_DSL_REQ = 0x02E3
    ERRSIM_WRONG_NFC_RLS_REQ = 0x02E4
    ERRSIM_NO_ATR_REQ_PENDING = 0x02E5
    ERRSIM_NO_WUP_REQ_PENDING = 0x02E6
    ERRSIM_NO_PSL_REQ_PENDING = 0x02E7
    ERRSIM_NO_NFC_DATA_AVAILABLE = 0x02E8
    ERRSIM_NO_DEP_REQ_AVAILABLE = 0x02E9
    ERRSIM_WRONG_NFC_POLL_REQ = 0x02EA
    ERRSIM_WRONG_NFC_ACK_NACK = 0x02EB
    ERRSIM_WRONG_NFC_ATTENTION = 0x02EC
    ERRSIM_WRONG_NFC_FRAME = 0x02ED
    ERRSIM_WRONG_NFC_DEPREQ_NAD = 0x02EE
    ERRSIM_WRONG_NFC_DEPREQ_DID = 0x02EF
    ERRSIM_WRONG_NFC_DEPREQ_INF = 0x02F0
    ERRSIM_NFC_UNEXPECTED_FRAME = 0x02F1
    ERRSIM_WRONG_NFC_FRAME_CRC = 0x02F2

    """
    Contactless error codes
    """
    CRET_ANTITEARING = 0x00F0
    ERR_TIMEOUTRX = 0x0190
    ERR_COLLISION = 0x0191
    ERR_ANTICOL_FAILED = 0x0192
    ERR_PARITY = 0x0193
    ERR_BITCOUNTERR = 0x0195
    ERR_CRC = 0x0197
    RET_WRONG_TYPE = 0x0198
    ERR_ANSWER_TO_HALT_DETECTED = 0x0199
    ERR_ATS_INVALID_LENGTH = 0x019A
    ERR_INVALID_ATS_CRC = 0x019B
    ERR_INVALID_ATS_T0 = 0x019C
    ERR_INVALID_ATS_FSCI = 0x019D
    ERR_INVALID_ATS_TC1 = 0x019F
    ERR_INVALID_ATS_TA1 = 0x01A0
    ERR_INCONSISTENT_RECEIVED_FRAME = 0x01A1
    ERR_INVALID_ANSWER_TO_HALT = 0x01A2
    ERR_WRONG_ATTRIB = 0x01A3
    ERR_DESELECT_SENT = 0x01A4
    ERR_DATA_RATE_NOT_SUPPORTED = 0x01A5
    ERR_INVALID_ANSWER_TO_DESELECT = 0x01A6
    ERR_RF_FIELD_TOO_LOW = 0x01A7
    ERR_TIMEOUTRX_CMD1 = 0x01A9
    ERR_UNEXPECTED_RX = 0x01AB
    ERR_FELICA_INVALID_LENGTH = 0x01AE
    ERR_FELICA_INVALID_SYNC_CODE = 0x01AF
    ERR_PPS_INVALID_ANSWER = 0x01B1
    ERR_VICINITY_ERROR_FLAG_SET = 0x01B2
    ERR_VICINITY_WRONG_ANSWER = 0x01B3
    ERR_VICINITY_UID_UNKNOWN = 0x01B4
    ERR_RF_FIELD_NOT_REACHED = 0x0200
    ERR_PROTOCOL_ERROR_DETECTED = 0x0201
    ERR_PROTOCOL_STOP_TIMEOUT_DETECTED = 0x0202
    ERR_INVALID_CHANNEL = 0x0214
    ERR_INVALID_NFC_CONFIGURATION = 0x0258
    ERR_LENGTH_NFC_RECEIVED_FRAME = 0x0259
    ERR_INVALID_NFC_START_BYTE = 0x025A
    ERR_INVALID_NFC_RECEIVED_CRC = 0x025B
    ERR_INVALID_ATR_RES = 0x025C
    ERR_INVALID_DSL_RES = 0x025D
    ERR_FAILED_AFTER_ERROR_RECOVERY = 0x025E
    ERR_NFC_ACT_INI_TRANSMIT_FAILED = 0x0260
    ERR_NFC_ACT_TGT_TRANSMIT_FAILED = 0x0261
    ERR_NOT_IN_TARGET_PASSIVE_MODE = 0x0265
    ERR_ADJUST_THRESHOLD_RF_FIELD = 0x0266
    ERR_NOT_IN_TARGET_ACTIVE_MODE = 0x0269
    ERR_NAK_RECEIVED = 0x026C
    ERR_AUTHENTICATION_FAILED = 0x026D
    ERR_INVALID_PSL_RES = 0x026E
    ERR_INVALID_WUP_RES = 0x026F
    ERR_NOT_IN_INITIATOR_ACTIVE_MODE = 0x0270
    ERR_INVALID_SPARAMETER_ANSWER = 0x0271
    ERR_RF_FIELD_NOT_SWITCHED_ACT = 0x0272
    ERR_NO_VALID_ATR_REQ_RECEIVED = 0x0274
    ERR_FWEC_INVALID_NUMBER_OF_BYTES = 0x0275
    ERR_TIME_FDT_MAX = 0x0276
    ERR_TIME_FDT_MIN = 0x0277
    ERR_TIME_TR1_MAX = 0x0278
    ERR_TIME_TR1_MIN = 0x0279
    ERR_FWEC_WRONG_SYNC = 0x027B
    ERR_PHASE_DRIFT = 0x027E
    CRET_NO_PROBE = 0x0370
    CRET_WRONG_PROBE = 0x0371

    """
    Card emulation error codes
    """
    ERR_RX_FRAME_TIMEOUT = 0x02BD
    ERR_WRONG_FRAME_A = 0x02BF
    ERR_RX_FRAME_CRCA = 0x02C0
    ERR_WRONG_FRAME_B = 0x02C4
    ERR_RX_FRAME_CRCB = 0x02C5
    ERR_TX_FRAME_TIMEOUT = 0x02CD
    ERR_WRONG_FRAME_F = 0x02CE
    ERR_RX_FRAME_CRCF = 0x02CF
    ERR_SCENARIO_TIMEOUT = 0x02D0
    ERR_RECEIVED_FRAME_NOT_MATCH = 0x02D1

    """
    NFC analog measurement library error codes
    """
    ERR_SCIENTIFIC_LIBRARY_GENERIC = 0x021C
    ERR_SCIENTIFIC_LIBRARY_WRONG_RANGE = 0x021D
    ERR_SCIENTIFIC_LIBRARY_UNSUPPORTED_MEAS = 0x021E

    """
    Auto-tests error codes
    """
    RET_FAIL = 0x1389
    RET_UNCONCLUSIVE = 0x138A
    RET_NOT_APPLICABLE = 0x138B
    RET_WARNING = 0x138D

    """
    System error codes
    """
    ERR_SYSTEM = 0x1770
    ERR_SYSTEM_DISK_SPACE = 0x1771
    ERR_SYSTEM_STDLIB = 0x17D4
    ERR_SYSTEM_PTHREAD = 0x1838

    """
    Communication library error codes
    """
    DLLCOMERROR = -1
    DLLNOABORTCONNEXION = -2
    DLLNOANSWERTOABORT = -3
    DLLDESYNCHRO = -6
    DLL_ANSWER_TO_ABORT_RECEIVED = -7
    DLL_UNABLE_TO_RETRIEVE_IPADDRESS = -8
    DLL_USB_ALREADY_ALLOCATED = -9
    DLL_WRONG_MODE = -10
    DLL_MPDEVICEDRIVER_NOTFOUND = -11
    DLL_FILE_DOES_NOT_EXIST = -13
    DLL_MEMORY_ALLOC = -14
    DLL_INVALID_HANDLER = -22
    DLL_NO_USB_DEVICE = -23
    DLL_FILE_OPEN = -24
    DLL_SYSTEM_PTHREAD = -25
    DLL_CONNECTION_CLOSED = -26


@unique
class MifareErrorCode(IntEnum):
    """MIFARE error codes"""
    MI_OK = 0x00
    MI_NOTAGERR = 0x01
    MI_CRCERR = 0x02
    MI_AUTHERR = 0x04
    MI_PARITYERR = 0x05
    MI_CODEERR = 0x06
    MI_SERNRERR = 0x08
    MI_NOTAUTHERR = 0x0A
    MI_BITCOUNTERR = 0x0B
    MI_BYTECOUNTERR = 0x0C
    MI_WRITEERR = 0x0F
    MI_OVFLERR = 0x13
    MI_FRAMINGERR = 0x15
    MI_COLLERR = 0x18
    MI_INTERFACEERR = 0x1A
    MI_ACCESSTIMEOUT = 0x1B
    MI_VALERR = 0x7C
