"""Broadworks OCI-P Interface Type Classes"""
# Autogenerated from the Broadworks XML Schemas.
# Do not edit as changes will be overwritten.
# Generated on 2020-10-01T14:03:08.891866
from classforge import Field

from .base import ElementInfo as E
from .base import OCIType


class AccessDevice(OCIType):
    """
    Uniquely identifies an Identity/device profile created anywhere in the system.
    """

    _ELEMENTS = (
        E(
            "device_level",
            "deviceLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* deviceLevel
    device_level = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class AccessDeviceKey(OCIType):
    """
    Key to uniquely identify a system, service provider, or group device.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* groupId
    group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class AccountAuthorizationCodeEntry(OCIType):
    """
    Account/Authorization Code.
    """

    _ELEMENTS = (
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class AgentStatistics(OCIType):
    """
    Contains Call Center Agent statistics for a given time frame.
    """

    _ELEMENTS = (
        E(
            "number_of_calls_handled",
            "numberOfCallsHandled",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_calls_unanswered",
            "numberOfCallsUnanswered",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "average_call_seconds",
            "averageCallSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "total_talk_seconds",
            "totalTalkSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "total_staffed_seconds",
            "totalStaffedSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* numberOfCallsHandled
    number_of_calls_handled = Field(
        type=int,
        required=True,
    )
    #: int: *Required* numberOfCallsUnanswered
    number_of_calls_unanswered = Field(
        type=int,
        required=True,
    )
    #: int: *Required* averageCallSeconds
    average_call_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* totalTalkSeconds
    total_talk_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* totalStaffedSeconds
    total_staffed_seconds = Field(
        type=int,
        required=True,
    )


class AlternateNumberEntry(OCIType):
    """
    Alternate Number Entry.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "ring_pattern",
            "ringPattern",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* ringPattern
    ring_pattern = Field(
        type=str,
        required=False,
    )


class AlternateNumberEntry17(OCIType):
    """
    Alternate Number Entry.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "ring_pattern",
            "ringPattern",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* ringPattern
    ring_pattern = Field(
        type=str,
        required=False,
    )


class AlternateNumberEntry21(OCIType):
    """
    Alternate Number Entry.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "ring_pattern",
            "ringPattern",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* ringPattern
    ring_pattern = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class AnnouncementFileKey(OCIType):
    """
    Uniquely identifies a file within a group or user repository.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_file_type",
            "mediaFileType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* mediaFileType
    media_file_type = Field(
        type=str,
        required=True,
    )


class AnnouncementFileLevelKey(OCIType):
    """
    Uniquely identifies a file within a group or user repository.
    Includes level to distinguish between group and user announcements
    in scenarios where both are listed.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_file_type",
            "mediaFileType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "level",
            "level",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* mediaFileType
    media_file_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* level
    level = Field(
        type=str,
        required=True,
    )


class AssignedGroupServicesEntry(OCIType):
    """
    Assigned Group Services List Entry.
    The isActive element is true, false, or could be missing completely.
    """

    _ELEMENTS = (
        E(
            "service_name",
            "serviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceName
    service_name = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* isActive
    is_active = Field(
        type=bool,
        required=False,
    )


class AssignedUserServicesEntry(OCIType):
    """
    Assigned User Services List Entry.
    The isActive element is true, false, or could be missing completely.
    """

    _ELEMENTS = (
        E(
            "service_name",
            "serviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceName
    service_name = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* isActive
    is_active = Field(
        type=bool,
        required=False,
    )


class AttendantConsoleReplacementDisplayColumnList(OCIType):
    """
    A list of attendant console display columns that replaces a previously configured list.
    By convention, an element of this type may be set nil to clear the list.
    """

    _ELEMENTS = (
        E(
            "display_column",
            "displayColumn",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* displayColumn
    display_column = Field(
        type=str,
        required=True,
    )


class AutoAttendantKeyConfigurationReadEntry(OCIType):
    """
    The read configuration entry of a key for Auto Attendant.
    The following data elements are only used in AS data mode:
    audioFileDescription
    audioMediaType
    videoFileDescription
    videoMediaType
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type",
            "audioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_media_type",
            "videoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMediaType
    audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMediaType
    video_media_type = Field(
        type=str,
        required=False,
    )


class AutoAttendantKeyConfigurationReadEntry19(OCIType):
    """
    The read configuration entry of a key for Auto
    Attendant.
    The following data elements are only
    used in AS data
    mode:
    audioFileDescription
    audioMediaType
    videoFileDescription
    videoMediaType
    submenuId
    The following
    data elements are only valid for Standard Auto
    Attendants:
    submenuId
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type",
            "audioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_media_type",
            "videoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "submenu_id",
            "submenuId",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMediaType
    audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMediaType
    video_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* submenuId
    submenu_id = Field(
        type=str,
        required=False,
    )


class BasicCallLogsEntry(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.
    Replaced By CallLogsEntry
    """

    _ELEMENTS = (
        E(
            "country_code",
            "countryCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "time",
            "time",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* countryCode
    country_code = Field(
        type=str,
        required=False,
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* time
    time = Field(
        type=str,
        required=True,
    )


class BroadWorksMobilityAlertingMobileNumberReplacementList(OCIType):
    """
    A list of Mobile Numbers to be alerted.
    By convention, an element of this type may be set nil to clear the list.
    """

    _ELEMENTS = (
        E(
            "mobile_number",
            "mobileNumber",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mobileNumber
    mobile_number = Field(
        type=str,
        required=True,
    )


class BroadWorksMobilityUserMobileIdentityEntry(OCIType):
    """
    User's Mobile Identity Read Entry
    """

    _ELEMENTS = (
        E(
            "mobile_number",
            "mobileNumber",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "is_primary",
            "isPrimary",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_alerting",
            "enableAlerting",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mobileNumber
    mobile_number = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* isPrimary
    is_primary = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableAlerting
    enable_alerting = Field(
        type=bool,
        required=True,
    )


class BroadWorksMobilityUserMobileIdentityModifyEntry(OCIType):
    """
    User's Mobile Identity Modify Entry
    """

    _ELEMENTS = (
        E(
            "mobile_number",
            "mobileNumber",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "is_primary",
            "isPrimary",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_alerting",
            "enableAlerting",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* mobileNumber
    mobile_number = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* isPrimary
    is_primary = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableAlerting
    enable_alerting = Field(
        type=bool,
        required=False,
    )


class CPEDeviceOptions(OCIType):
    """
    CPE device's options.
    Replaced By CPEDeviceOptions14sp6
    """

    _ELEMENTS = (
        E(
            "enable_monitoring",
            "enableMonitoring",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "reset_event",
            "resetEvent",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "config_type",
            "configType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "system_file_name",
            "systemFileName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_file_format",
            "deviceFileFormat",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* enableMonitoring
    enable_monitoring = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* resetEvent
    reset_event = Field(
        type=str,
        required=False,
    )
    #: str: *Required* configType
    config_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* systemFileName
    system_file_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceFileFormat
    device_file_format = Field(
        type=str,
        required=True,
    )


class CallCenterAgentAvailability(OCIType):
    """
    Specifies an agent's login state (availability) for a particular Call Center.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "available",
            "available",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* available
    available = Field(
        type=bool,
        required=True,
    )


class CallCenterAgentDailyStatistics13mp8(OCIType):
    """
    Contains Call Center Agent statistics for one day.
    """

    _ELEMENTS = (
        E(
            "number_of_calls_received",
            "numberOfCallsReceived",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_calls_not_answered",
            "numberOfCallsNotAnswered",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "average_time_per_call_seconds",
            "averageTimePerCallSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "time_in_calls_seconds",
            "timeInCallsSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "time_logged_off_seconds",
            "timeLoggedOffSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "time_logged_on_and_idle_seconds",
            "timeLoggedOnAndIdleSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* numberOfCallsReceived
    number_of_calls_received = Field(
        type=int,
        required=True,
    )
    #: int: *Required* numberOfCallsNotAnswered
    number_of_calls_not_answered = Field(
        type=int,
        required=True,
    )
    #: int: *Required* averageTimePerCallSeconds
    average_time_per_call_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* timeInCallsSeconds
    time_in_calls_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* timeLoggedOffSeconds
    time_logged_off_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* timeLoggedOnAndIdleSeconds
    time_logged_on_and_idle_seconds = Field(
        type=int,
        required=True,
    )


class CallCenterAgentSettings(OCIType):
    """
    Specifies an agent's settings for a particular Call Center.
    The skillLevel only applies to Premium agents.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "available",
            "available",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "skill_level",
            "skillLevel",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* available
    available = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* skillLevel
    skill_level = Field(
        type=int,
        required=False,
    )


class CallCenterAgentThresholdProfileReplacementNotificationEmailList(OCIType):
    """
    List of email addresses to which the Agent Threshold Profile email is sent. The
    list replaces a previously configured list.
    """

    _ELEMENTS = (
        E(
            "email_address",
            "emailAddress",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* emailAddress
    email_address = Field(
        type=str,
        required=True,
    )


class CallCenterAgentUnavailableCodeStateModify(OCIType):
    """
    Contains a Call Center Agent Unavailable Code and its active state
    """

    _ELEMENTS = (
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )


class CallCenterAnnouncementDescriptionList(OCIType):
    """
    Contains list of file descriptions for audio or video files
    """

    _ELEMENTS = (
        E(
            "file_description1",
            "fileDescription1",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "file_description2",
            "fileDescription2",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "file_description3",
            "fileDescription3",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "file_description4",
            "fileDescription4",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* fileDescription1
    file_description1 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* fileDescription2
    file_description2 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* fileDescription3
    file_description3 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* fileDescription4
    file_description4 = Field(
        type=str,
        required=False,
    )


class CallCenterAnnouncementMediaFileTypeList(OCIType):
    """
    Contains list of file media types for audio or video files
    """

    _ELEMENTS = (
        E(
            "media_type1",
            "mediaType1",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "media_type2",
            "mediaType2",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "media_type3",
            "mediaType3",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "media_type4",
            "mediaType4",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* mediaType1
    media_type1 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* mediaType2
    media_type2 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* mediaType3
    media_type3 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* mediaType4
    media_type4 = Field(
        type=str,
        required=False,
    )


class CallCenterAnnouncementURLList(OCIType):
    """
    Contains list of urls
    """

    _ELEMENTS = (
        E(
            "url1",
            "url1",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "url2",
            "url2",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "url3",
            "url3",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "url4",
            "url4",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* url1
    url1 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* url2
    url2 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* url3
    url3 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* url4
    url4 = Field(
        type=str,
        required=False,
    )


class CallCenterAnnouncementURLListModify(OCIType):
    """
    Contains a list of URLs for modify.
    """

    _ELEMENTS = (
        E(
            "url1",
            "url1",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "url2",
            "url2",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "url3",
            "url3",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "url4",
            "url4",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* url1
    url1 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* url2
    url2 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* url3
    url3 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* url4
    url4 = Field(
        type=str,
        required=False,
    )


class CallCenterMusicOnHoldSourceModify(OCIType):
    """
    Contains the music on hold source configuration.
    """

    _ELEMENTS = (
        E(
            "audio_file_preferred_codec",
            "audioFilePreferredCodec",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Optional* audioFilePreferredCodec
    audio_file_preferred_codec = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )


class CallCenterMusicOnHoldSourceRead(OCIType):
    """
    Contains the music on hold source configuration.
    """

    _ELEMENTS = (
        E(
            "audio_file_preferred_codec",
            "audioFilePreferredCodec",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(
        type=str,
        required=True,
    )
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )


class CallCenterQueueStatistics13mp8(OCIType):
    """
    Contains Call Center Queue statistics.
    """

    _ELEMENTS = (
        E(
            "number_of_incoming_calls",
            "numberOfIncomingCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_calls_queued",
            "numberOfCallsQueued",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_busy_overflows",
            "numberOfBusyOverflows",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_calls_answered",
            "numberOfCallsAnswered",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "average_time_with_agent_seconds",
            "averageTimeWithAgentSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "average_time_in_queue_seconds",
            "averageTimeInQueueSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "average_number_of_agents_busy",
            "averageNumberOfAgentsBusy",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "average_number_of_agents_logged_off",
            "averageNumberOfAgentsLoggedOff",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "average_hold_time_before_call_loss_seconds",
            "averageHoldTimeBeforeCallLossSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* numberOfIncomingCalls
    number_of_incoming_calls = Field(
        type=int,
        required=True,
    )
    #: int: *Required* numberOfCallsQueued
    number_of_calls_queued = Field(
        type=int,
        required=True,
    )
    #: int: *Required* numberOfBusyOverflows
    number_of_busy_overflows = Field(
        type=int,
        required=True,
    )
    #: int: *Required* numberOfCallsAnswered
    number_of_calls_answered = Field(
        type=int,
        required=True,
    )
    #: int: *Required* averageTimeWithAgentSeconds
    average_time_with_agent_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* averageTimeInQueueSeconds
    average_time_in_queue_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* averageNumberOfAgentsBusy
    average_number_of_agents_busy = Field(
        type=int,
        required=True,
    )
    #: int: *Required* averageNumberOfAgentsLoggedOff
    average_number_of_agents_logged_off = Field(
        type=int,
        required=True,
    )
    #: int: *Required* averageHoldTimeBeforeCallLossSeconds
    average_hold_time_before_call_loss_seconds = Field(
        type=int,
        required=True,
    )


class CallCenterQueueStatistics14sp9(OCIType):
    """
    Contains Call Center Queue statistics.
    """

    _ELEMENTS = (
        E(
            "number_of_busy_overflows",
            "numberOfBusyOverflows",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_calls_answered",
            "numberOfCallsAnswered",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_calls_abandoned",
            "numberOfCallsAbandoned",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_calls_transferred",
            "numberOfCallsTransferred",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_calls_timedout",
            "numberOfCallsTimedout",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "average_number_of_agents_talking",
            "averageNumberOfAgentsTalking",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "average_number_of_agents_staffed",
            "averageNumberOfAgentsStaffed",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "average_wait_seconds",
            "averageWaitSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "average_abandonment_seconds",
            "averageAbandonmentSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* numberOfBusyOverflows
    number_of_busy_overflows = Field(
        type=int,
        required=True,
    )
    #: int: *Required* numberOfCallsAnswered
    number_of_calls_answered = Field(
        type=int,
        required=True,
    )
    #: int: *Required* numberOfCallsAbandoned
    number_of_calls_abandoned = Field(
        type=int,
        required=True,
    )
    #: int: *Required* numberOfCallsTransferred
    number_of_calls_transferred = Field(
        type=int,
        required=True,
    )
    #: int: *Required* numberOfCallsTimedout
    number_of_calls_timedout = Field(
        type=int,
        required=True,
    )
    #: int: *Required* averageNumberOfAgentsTalking
    average_number_of_agents_talking = Field(
        type=int,
        required=True,
    )
    #: int: *Required* averageNumberOfAgentsStaffed
    average_number_of_agents_staffed = Field(
        type=int,
        required=True,
    )
    #: int: *Required* averageWaitSeconds
    average_wait_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* averageAbandonmentSeconds
    average_abandonment_seconds = Field(
        type=int,
        required=True,
    )


class CallCenterQueueThresholdReplacementNotificationEmailList(OCIType):
    """
    List of email addresses to which the Call Center Queue Threshold email is sent.
    The list replaces a previously configured list.
    """

    _ELEMENTS = (
        E(
            "email_address",
            "emailAddress",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* emailAddress
    email_address = Field(
        type=str,
        required=True,
    )


class CallCenterReportAbandonedCallThresholdReplacementList(OCIType):
    """
    A list of call center reporting abandoned call threshold seconds that replaces a
    previously configured list.
    """

    _ELEMENTS = (
        E(
            "abandoned_call_threshold_seconds",
            "abandonedCallThresholdSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* abandonedCallThresholdSeconds
    abandoned_call_threshold_seconds = Field(
        type=int,
        required=True,
    )


class CallCenterReportCurrentInterval(OCIType):
    """
    The call center enhanced reporting report current interval, for example, current week.
    """

    _ELEMENTS = (
        E(
            "time_unit",
            "timeUnit",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* timeUnit
    time_unit = Field(
        type=str,
        required=True,
    )


class CallCenterReportDataTemplateInfo(OCIType):
    """
    Call center reporting data template info.
    """

    _ELEMENTS = (
        E(
            "data_template",
            "dataTemplate",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "report_type",
            "reportType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_realtime_report",
            "isRealtimeReport",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_agent_param_required",
            "isAgentParamRequired",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_call_center_param_required",
            "isCallCenterParamRequired",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_call_center_dnis_param_required",
            "isCallCenterDnisParamRequired",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_sampling_period_param_required",
            "isSamplingPeriodParamRequired",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_call_completion_threshold_param_required",
            "isCallCompletionThresholdParamRequired",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_short_duration_threshold_param_required",
            "isShortDurationThresholdParamRequired",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_service_level_threshold_param_required",
            "isServiceLevelThresholdParamRequired",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_service_level_inclusions_param_required",
            "isServiceLevelInclusionsParamRequired",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_service_level_objective_threshold_param_required",
            "isServiceLevelObjectiveThresholdParamRequired",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_abandoned_call_threshold_param_required",
            "isAbandonedCallThresholdParamRequired",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* dataTemplate
    data_template = Field(
        type=str,
        required=True,
    )
    #: str: *Required* reportType
    report_type = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isRealtimeReport
    is_realtime_report = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* isAgentParamRequired
    is_agent_param_required = Field(
        type=str,
        required=True,
    )
    #: str: *Required* isCallCenterParamRequired
    is_call_center_param_required = Field(
        type=str,
        required=True,
    )
    #: str: *Required* isCallCenterDnisParamRequired
    is_call_center_dnis_param_required = Field(
        type=str,
        required=True,
    )
    #: str: *Required* isSamplingPeriodParamRequired
    is_sampling_period_param_required = Field(
        type=str,
        required=True,
    )
    #: str: *Required* isCallCompletionThresholdParamRequired
    is_call_completion_threshold_param_required = Field(
        type=str,
        required=True,
    )
    #: str: *Required* isShortDurationThresholdParamRequired
    is_short_duration_threshold_param_required = Field(
        type=str,
        required=True,
    )
    #: str: *Required* isServiceLevelThresholdParamRequired
    is_service_level_threshold_param_required = Field(
        type=str,
        required=True,
    )
    #: str: *Required* isServiceLevelInclusionsParamRequired
    is_service_level_inclusions_param_required = Field(
        type=str,
        required=True,
    )
    #: str: *Required* isServiceLevelObjectiveThresholdParamRequired
    is_service_level_objective_threshold_param_required = Field(
        type=str,
        required=True,
    )
    #: str: *Required* isAbandonedCallThresholdParamRequired
    is_abandoned_call_threshold_param_required = Field(
        type=str,
        required=True,
    )


class CallCenterReportDataTemplateQueryFilterValueReplacementList(OCIType):
    """
    A list of call center reporting data template query filter values that replaces a
    previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "filter_value",
            "filterValue",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* filterValue
    filter_value = Field(
        type=str,
        required=True,
    )


class CallCenterReportPastInterval(OCIType):
    """
    The call center enhanced reporting report past interval, for example, last 24 month.
    """

    _ELEMENTS = (
        E(
            "number",
            "number",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "time_unit",
            "timeUnit",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* number
    number = Field(
        type=int,
        required=True,
    )
    #: str: *Required* timeUnit
    time_unit = Field(
        type=str,
        required=True,
    )


class CallCenterReportReplacementEmailList(OCIType):
    """
    A list of call center reporting email addresses that replaces a previously
    configured list.
    """

    _ELEMENTS = (
        E(
            "email_address",
            "emailAddress",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* emailAddress
    email_address = Field(
        type=str,
        required=True,
    )


class CallCenterReportServiceLevelThresholdReplacementList(OCIType):
    """
    A list of call center reporting service level threshold seconds that replaces a
    previously configured list.
    """

    _ELEMENTS = (
        E(
            "service_level_threshold_seconds",
            "serviceLevelThresholdSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* serviceLevelThresholdSeconds
    service_level_threshold_seconds = Field(
        type=int,
        required=True,
    )


class CallCenterReportTemplateKey(OCIType):
    """
    Uniquely identifies a call center report template created in the system.
    """

    _ELEMENTS = (
        E(
            "template_level",
            "templateLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "template_name",
            "templateName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* templateLevel
    template_level = Field(
        type=str,
        required=True,
    )
    #: str: *Required* templateName
    template_name = Field(
        type=str,
        required=True,
    )


class CallCenterRoutingPriorityOrder(OCIType):
    """
    Call center routing order
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "priority",
            "priority",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* priority
    priority = Field(
        type=str,
        required=True,
    )


class CallCenterScheduledReportAgentSelection(OCIType):
    """
    Either all agents or list of agents.
    """

    _ELEMENTS = (
        E(
            "all_agent",
            "allAgent",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "agent_user_id",
            "agentUserId",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* allAgent
    all_agent = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* agentUserId
    agent_user_id = Field(
        type=str,
        required=False,
    )


class CallCenterScheduledReportAgentSelectionAdminRead(OCIType):
    """
    Either all agents or 2 list of agents: one for current and one for past (deleted) agents.
    This is used when an admin reads a Scheduled Report.
    Each agent table has the following column headings:
    "User Id", "Last Name", "First Name", "Hiragana Last Name" and "Hiragana First Name".
    """

    _ELEMENTS = (
        E(
            "all_agent",
            "allAgent",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "current_agent_table",
            "currentAgentTable",
            list,
            True,
            True,
            False,
            True,
        ),
        E(
            "past_agent_table",
            "pastAgentTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: bool: *Optional* allAgent
    all_agent = Field(
        type=bool,
        required=False,
    )
    #: list: *Required* currentAgentTable  *Tabular*
    current_agent_table = Field(
        type=list,
        required=True,
    )
    #: list: *Required* pastAgentTable  *Tabular*
    past_agent_table = Field(
        type=list,
        required=True,
    )


class CallCenterScheduledReportAgentSelectionRead(OCIType):
    """
    Either all agents or list of agents.
    The agent table has the following column headings:
    "User Id", "Last Name", "First Name", "Hiragana Last Name" and "Hiragana First Name".
    """

    _ELEMENTS = (
        E(
            "all_agent",
            "allAgent",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "agent_table",
            "agentTable",
            list,
            True,
            False,
            False,
            True,
        ),
    )
    #: bool: *Optional* allAgent
    all_agent = Field(
        type=bool,
        required=False,
    )
    #: list: *Optional* agentTable  *Tabular*
    agent_table = Field(
        type=list,
        required=False,
    )


class CallCenterScheduledReportCallCenterSelection(OCIType):
    """
    Either all call centers or list of call centers.
    """

    _ELEMENTS = (
        E(
            "all_call_center",
            "allCallCenter",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* allCallCenter
    all_call_center = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* serviceUserId
    service_user_id = Field(
        type=str,
        required=False,
    )


class CallCenterScheduledReportCallCenterSelectionRead(OCIType):
    """
    User for admin read. Either all call centers or 2 lists of call centers: one for
    current and one for deleted call centers.
    """

    _ELEMENTS = (
        E(
            "all_call_center",
            "allCallCenter",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "current_user_id",
            "currentUserId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "past_user_id",
            "pastUserId",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* allCallCenter
    all_call_center = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* currentUserId
    current_user_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* pastUserId
    past_user_id = Field(
        type=str,
        required=False,
    )


class CallCenterScheduledReportDNISSelection(OCIType):
    """
    Either all DNIS under the specified Call Center or list of DNIS.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "all_dnis",
            "allDNIS",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* allDNIS
    all_dnis = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* name
    name = Field(
        type=str,
        required=False,
    )


class CallCenterScheduledReportDNISSelectionRead(OCIType):
    """
    Either all DNIS under the specified Call Center or 2 lists of DNIS, one for
    current one for past (deleted).
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "deleted",
            "deleted",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "all_dnis",
            "allDNIS",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "current_name",
            "currentName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "past_name",
            "pastName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* deleted
    deleted = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allDNIS
    all_dnis = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* currentName
    current_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* pastName
    past_name = Field(
        type=str,
        required=False,
    )


class CallCenterScheduledReportServiceLevelInclusions(OCIType):
    """
    The call center enhanced reporting scheduled report inclusions related to the
    Service Level thresholds
    """

    _ELEMENTS = (
        E(
            "include_overflow_time_transfered_in_service_level",
            "includeOverflowTimeTransferedInServiceLevel",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_other_transfers_in_service_level",
            "includeOtherTransfersInServiceLevel",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "abandoned_calls_in_service_level",
            "abandonedCallsInServiceLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "abandoned_call_interval_seconds",
            "abandonedCallIntervalSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* includeOverflowTimeTransferedInServiceLevel
    include_overflow_time_transfered_in_service_level = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeOtherTransfersInServiceLevel
    include_other_transfers_in_service_level = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* abandonedCallsInServiceLevel
    abandoned_calls_in_service_level = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* abandonedCallIntervalSeconds
    abandoned_call_interval_seconds = Field(
        type=int,
        required=False,
    )


class CallCenterScheduledReportServiceLevelInclusionsModify(OCIType):
    """
    The call center enhanced reporting scheduled report modified inclusions related
    to the Service Level thresholds
    """

    _ELEMENTS = (
        E(
            "include_overflow_time_transfered_in_service_level",
            "includeOverflowTimeTransferedInServiceLevel",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_other_transfers_in_service_level",
            "includeOtherTransfersInServiceLevel",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "abandoned_calls_in_service_level",
            "abandonedCallsInServiceLevel",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "abandoned_call_interval_seconds",
            "abandonedCallIntervalSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* includeOverflowTimeTransferedInServiceLevel
    include_overflow_time_transfered_in_service_level = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* includeOtherTransfersInServiceLevel
    include_other_transfers_in_service_level = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* abandonedCallsInServiceLevel
    abandoned_calls_in_service_level = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* abandonedCallIntervalSeconds
    abandoned_call_interval_seconds = Field(
        type=int,
        required=False,
    )


class CallCenterSkillAgentList(OCIType):
    """
    A list of agents for a particular skill Level.
    """

    _ELEMENTS = (
        E(
            "skill_level",
            "skillLevel",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "agent",
            "agent",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: int: *Required* skillLevel
    skill_level = Field(
        type=int,
        required=True,
    )
    #: list(str): *Optional* agent  *Array*
    agent = Field(
        type=list,
        required=False,
    )


class CallCenterStatisticsRange(OCIType):
    """
    Statistics Range
    """

    _ELEMENTS = (
        E(
            "start",
            "start",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "end",
            "end",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* start
    start = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* end
    end = Field(
        type=str,
        required=False,
    )


class CallDispositionCodeActivation(OCIType):
    """
    Contains a Call Center Call Disposition Code and its active state
    """

    _ELEMENTS = (
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )


class CallDispositionCodeWithLevel(OCIType):
    """
    Contains a Call Center Call Disposition Code and its Level
    """

    _ELEMENTS = (
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "level",
            "level",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* level
    level = Field(
        type=str,
        required=True,
    )


class CallLogsEntry(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.
    """

    _ELEMENTS = (
        E(
            "country_code",
            "countryCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_log_id",
            "callLogId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "time",
            "time",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* countryCode
    country_code = Field(
        type=str,
        required=False,
    )
    #: str: *Required* callLogId
    call_log_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* time
    time = Field(
        type=str,
        required=True,
    )


class CallMeNowToDnCriteria(OCIType):
    """
    The To dn criteria used on the call me now external number.
    """

    _ELEMENTS = (
        E(
            "to_dn_criteria_selection",
            "toDnCriteriaSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* toDnCriteriaSelection
    to_dn_criteria_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )


class CallToNumber(OCIType):
    """
    Call to Number.
    """

    _ELEMENTS = (
        E(
            "type",
            "type",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "number",
            "number",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* type
    type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* number
    number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )


class CollaborateBridgeMaximumParticipants(OCIType):
    """
    Maximum number of Collaborate bridge participants. Can either be unlimited or
    limited to a value between 3 and 999999.
    """

    _ELEMENTS = (
        E(
            "unlimited",
            "unlimited",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "quantity",
            "quantity",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* unlimited
    unlimited = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* quantity
    quantity = Field(
        type=int,
        required=False,
    )


class CollaborateGracePeriodDuration(OCIType):
    """
    Collaborate grace period duration.
    """

    _ELEMENTS = (
        E(
            "hours",
            "hours",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "minutes",
            "minutes",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* hours
    hours = Field(
        type=int,
        required=True,
    )
    #: int: *Required* minutes
    minutes = Field(
        type=int,
        required=True,
    )


class CollaborateRoomSchedule(OCIType):
    """
    Collaborate room schedule.
    """

    _ELEMENTS = (
        E(
            "schedule_reservationless",
            "scheduleReservationless",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "schedule_one_time",
            "scheduleOneTime",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "schedule_recurring",
            "scheduleRecurring",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Optional* scheduleReservationless
    schedule_reservationless = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* scheduleOneTime
    schedule_one_time = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* scheduleRecurring
    schedule_recurring = Field(
        type=str,
        required=False,
    )


class CollaborateRoomScheduleDuration(OCIType):
    """
    Collaborate room schedule duration.
    """

    _ELEMENTS = (
        E(
            "hours",
            "hours",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "minutes",
            "minutes",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* hours
    hours = Field(
        type=int,
        required=True,
    )
    #: int: *Required* minutes
    minutes = Field(
        type=int,
        required=True,
    )


class CommPilotExpressEmailNotify(OCIType):
    """
    CommPilot Express Email Notify configuration used in the context of a get.
    """

    _ELEMENTS = (
        E(
            "send_email",
            "sendEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "email_address",
            "emailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* sendEmail
    send_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* emailAddress
    email_address = Field(
        type=str,
        required=False,
    )


class CommPilotExpressEmailNotifyModify(OCIType):
    """
    CommPilot Express Email Notify configuration used in the context of a modify.
    """

    _ELEMENTS = (
        E(
            "send_email",
            "sendEmail",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "email_address",
            "emailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* sendEmail
    send_email = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* emailAddress
    email_address = Field(
        type=str,
        required=False,
    )


class CommPilotExpressRedirection(OCIType):
    """
    CommPilot Express type to transfer to voice Mail or forward to a number
    used in the context of a get.
    """

    _ELEMENTS = (
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "forwarding_phone_number",
            "forwardingPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* forwardingPhoneNumber
    forwarding_phone_number = Field(
        type=str,
        required=False,
    )


class CommPilotExpressRedirectionModify(OCIType):
    """
    CommPilot Express type to transfer to voice Mail or forward to a number
    used in the context of a modify.
    """

    _ELEMENTS = (
        E(
            "action",
            "action",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "forwarding_phone_number",
            "forwardingPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* action
    action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* forwardingPhoneNumber
    forwarding_phone_number = Field(
        type=str,
        required=False,
    )


class CommPilotExpressRedirectionWithException(OCIType):
    """
    CommPilot Express type to transfer to voice mail or forward to a number
    with certain exceptions used in the context of a get.
    """

    _ELEMENTS = (
        E(
            "send_calls_to_voice_mail_except_excluded_numbers",
            "sendCallsToVoiceMailExceptExcludedNumbers",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "excluded_phone_number01",
            "excludedPhoneNumber01",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "excluded_phone_number02",
            "excludedPhoneNumber02",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "excluded_phone_number03",
            "excludedPhoneNumber03",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "forward_excluded_numbers_to",
            "forwardExcludedNumbersTo",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* sendCallsToVoiceMailExceptExcludedNumbers
    send_calls_to_voice_mail_except_excluded_numbers = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* excludedPhoneNumber01
    excluded_phone_number01 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* excludedPhoneNumber02
    excluded_phone_number02 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* excludedPhoneNumber03
    excluded_phone_number03 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* forwardExcludedNumbersTo
    forward_excluded_numbers_to = Field(
        type=str,
        required=False,
    )


class CommPilotExpressRedirectionWithExceptionModify(OCIType):
    """
    CommPilot Express type to transfer to voice mail or forward to a number
    with certain exceptions used in the context of a modify.
    """

    _ELEMENTS = (
        E(
            "send_calls_to_voice_mail_except_excluded_numbers",
            "sendCallsToVoiceMailExceptExcludedNumbers",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "excluded_phone_number01",
            "excludedPhoneNumber01",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "excluded_phone_number02",
            "excludedPhoneNumber02",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "excluded_phone_number03",
            "excludedPhoneNumber03",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "forward_excluded_numbers_to",
            "forwardExcludedNumbersTo",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* sendCallsToVoiceMailExceptExcludedNumbers
    send_calls_to_voice_mail_except_excluded_numbers = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* excludedPhoneNumber01
    excluded_phone_number01 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* excludedPhoneNumber02
    excluded_phone_number02 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* excludedPhoneNumber03
    excluded_phone_number03 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* forwardExcludedNumbersTo
    forward_excluded_numbers_to = Field(
        type=str,
        required=False,
    )


class CommPilotExpressSREmailNotify(OCIType):
    """
    CommPilot Express SR Email Notify configuration used in the context of a get.
    """

    _ELEMENTS = (
        E(
            "send_email",
            "sendEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "email_address",
            "emailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* sendEmail
    send_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* emailAddress
    email_address = Field(
        type=str,
        required=False,
    )


class CommPilotExpressSREmailNotifyModify(OCIType):
    """
    CommPilot Express SR Email Notify configuration used in the context of a modify.
    """

    _ELEMENTS = (
        E(
            "send_email",
            "sendEmail",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "email_address",
            "emailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* sendEmail
    send_email = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* emailAddress
    email_address = Field(
        type=str,
        required=False,
    )


class CommPilotExpressSRRedirection(OCIType):
    """
    CommPilot Express SR type to transfer to voice Mail or forward to a number
    used in the context of a get.
    """

    _ELEMENTS = (
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "forwarding_phone_number",
            "forwardingPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* forwardingPhoneNumber
    forwarding_phone_number = Field(
        type=str,
        required=False,
    )


class CommPilotExpressSRRedirectionModify(OCIType):
    """
    CommPilot Express SR type to transfer to voice Mail or forward to a number
    used in the context of a modify.
    """

    _ELEMENTS = (
        E(
            "action",
            "action",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "forwarding_phone_number",
            "forwardingPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* action
    action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* forwardingPhoneNumber
    forwarding_phone_number = Field(
        type=str,
        required=False,
    )


class CommPilotExpressSRRedirectionWithException(OCIType):
    """
    CommPilot Express SR type to transfer to voice mail or forward to a number
    with certain exceptions used in the context of a get.
    """

    _ELEMENTS = (
        E(
            "send_calls_to_voice_mail_except_excluded_numbers",
            "sendCallsToVoiceMailExceptExcludedNumbers",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "excluded_phone_number01",
            "excludedPhoneNumber01",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "excluded_phone_number02",
            "excludedPhoneNumber02",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "excluded_phone_number03",
            "excludedPhoneNumber03",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "forward_excluded_numbers_to",
            "forwardExcludedNumbersTo",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* sendCallsToVoiceMailExceptExcludedNumbers
    send_calls_to_voice_mail_except_excluded_numbers = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* excludedPhoneNumber01
    excluded_phone_number01 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* excludedPhoneNumber02
    excluded_phone_number02 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* excludedPhoneNumber03
    excluded_phone_number03 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* forwardExcludedNumbersTo
    forward_excluded_numbers_to = Field(
        type=str,
        required=False,
    )


class CommPilotExpressSRRedirectionWithExceptionModify(OCIType):
    """
    CommPilot Express SR type to transfer to voice mail or forward to a number
    with certain exceptions used in the context of a modify.
    """

    _ELEMENTS = (
        E(
            "send_calls_to_voice_mail_except_excluded_numbers",
            "sendCallsToVoiceMailExceptExcludedNumbers",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "excluded_phone_number01",
            "excludedPhoneNumber01",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "excluded_phone_number02",
            "excludedPhoneNumber02",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "excluded_phone_number03",
            "excludedPhoneNumber03",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "forward_excluded_numbers_to",
            "forwardExcludedNumbersTo",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* sendCallsToVoiceMailExceptExcludedNumbers
    send_calls_to_voice_mail_except_excluded_numbers = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* excludedPhoneNumber01
    excluded_phone_number01 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* excludedPhoneNumber02
    excluded_phone_number02 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* excludedPhoneNumber03
    excluded_phone_number03 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* forwardExcludedNumbersTo
    forward_excluded_numbers_to = Field(
        type=str,
        required=False,
    )


class CommPilotExpressSRRedirectionWithRing(OCIType):
    """
    CommPilot Express SR Forward Number Entry with number of times to ring.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_of_times_to_ring",
            "numberOfTimesToRing",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: int: *Required* numberOfTimesToRing
    number_of_times_to_ring = Field(
        type=int,
        required=True,
    )


class CommunicationBarringAuthorizationCodeEntry(OCIType):
    """
    Communication Barring Authorization Code entry.
    """

    _ELEMENTS = (
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class CommunicationBarringCallMeNowRule(OCIType):
    """
    Communication Barring Call Me Now Rule
    """

    _ELEMENTS = (
        E(
            "criteria",
            "criteria",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_timeout_seconds",
            "callTimeoutSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* criteria
    criteria = Field(
        type=str,
        required=True,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* callTimeoutSeconds
    call_timeout_seconds = Field(
        type=int,
        required=False,
    )


class CommunicationBarringIncomingRule(OCIType):
    """
    Communication Barring Incoming Rule
    """

    _ELEMENTS = (
        E(
            "digit_pattern_criteria",
            "digitPatternCriteria",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_timeout_seconds",
            "callTimeoutSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_schedule",
            "timeSchedule",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "holiday_schedule",
            "holidaySchedule",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "priority",
            "priority",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* digitPatternCriteria
    digit_pattern_criteria = Field(
        type=str,
        required=True,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* callTimeoutSeconds
    call_timeout_seconds = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* timeSchedule
    time_schedule = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* holidaySchedule
    holiday_schedule = Field(
        type=str,
        required=False,
    )
    #: str: *Required* priority
    priority = Field(
        type=str,
        required=True,
    )


class CommunicationBarringIncomingRule19sp1(OCIType):
    """
    Communication Barring Incoming Rule
    """

    _ELEMENTS = (
        E(
            "digit_pattern_criteria",
            "digitPatternCriteria",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "incoming_criteria",
            "incomingCriteria",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_timeout_seconds",
            "callTimeoutSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_schedule",
            "timeSchedule",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "holiday_schedule",
            "holidaySchedule",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "priority",
            "priority",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* digitPatternCriteria
    digit_pattern_criteria = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* incomingCriteria
    incoming_criteria = Field(
        type=str,
        required=False,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* callTimeoutSeconds
    call_timeout_seconds = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* timeSchedule
    time_schedule = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* holidaySchedule
    holiday_schedule = Field(
        type=str,
        required=False,
    )
    #: str: *Required* priority
    priority = Field(
        type=str,
        required=True,
    )


class CommunicationBarringOriginatingRule(OCIType):
    """
    Communication Barring Originating Rule
    """

    _ELEMENTS = (
        E(
            "criteria",
            "criteria",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "treatment_id",
            "treatmentId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "transfer_number",
            "transferNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_timeout_seconds",
            "callTimeoutSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* criteria
    criteria = Field(
        type=str,
        required=True,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* treatmentId
    treatment_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* transferNumber
    transfer_number = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* callTimeoutSeconds
    call_timeout_seconds = Field(
        type=int,
        required=False,
    )


class CommunicationBarringOriginatingRule15sp2(OCIType):
    """
    Communication Barring Originating Rule
    """

    _ELEMENTS = (
        E(
            "criteria",
            "criteria",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "treatment_id",
            "treatmentId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "transfer_number",
            "transferNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* criteria
    criteria = Field(
        type=str,
        required=True,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* treatmentId
    treatment_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* transferNumber
    transfer_number = Field(
        type=str,
        required=False,
    )


class CommunicationBarringProfileReplacementList(OCIType):
    """
    A list of communication barring profiles that replaces a previously configured list.
    By convention, an element of this type may be set nil to clear the list.
    """

    _ELEMENTS = (
        E(
            "profile_name",
            "profileName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* profileName
    profile_name = Field(
        type=str,
        required=True,
    )


class CommunicationBarringRedirectingRule(OCIType):
    """
    Communication Barring Redirecting Rule
    """

    _ELEMENTS = (
        E(
            "criteria",
            "criteria",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_timeout_seconds",
            "callTimeoutSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* criteria
    criteria = Field(
        type=str,
        required=True,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* callTimeoutSeconds
    call_timeout_seconds = Field(
        type=int,
        required=False,
    )


class CommunicationBarringRedirectingRule15sp2(OCIType):
    """
    Communication Barring Redirecting Rule
    """

    _ELEMENTS = (
        E(
            "criteria",
            "criteria",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* criteria
    criteria = Field(
        type=str,
        required=True,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )


class Contact(OCIType):
    """
    Contact information.
    """

    _ELEMENTS = (
        E(
            "contact_name",
            "contactName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "contact_number",
            "contactNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "contact_email",
            "contactEmail",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* contactName
    contact_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* contactNumber
    contact_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* contactEmail
    contact_email = Field(
        type=str,
        required=False,
    )


class CriteriaActivation(OCIType):
    """
    Criteria active status indicator
    """

    _ELEMENTS = (
        E(
            "criteria_name",
            "criteriaName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* criteriaName
    criteria_name = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )


class CriteriaFromDn(OCIType):
    """
    The from dn criteria used within an add/get request.
    """

    _ELEMENTS = (
        E(
            "from_dn_criteria_selection",
            "fromDnCriteriaSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_anonymous_callers",
            "includeAnonymousCallers",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_unavailable_callers",
            "includeUnavailableCallers",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* fromDnCriteriaSelection
    from_dn_criteria_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* includeAnonymousCallers
    include_anonymous_callers = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeUnavailableCallers
    include_unavailable_callers = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )


class CriteriaReplacementDNList(OCIType):
    """
    A list of criteria DNs that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )


class CustomContactDirectoryEntry(OCIType):
    """
    Represents either an existing user's Id or an existing Virtual
    On-Net user's DN. For a DN the groupId is used to make it unique
    within an Enterprise, however the groupId is not used with Service
    Providers.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "virtual_on_net_phone_number",
            "virtualOnNetPhoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* userId
    user_id = Field(
        type=str,
        required=False,
    )
    #: str: *Required* virtualOnNetPhoneNumber
    virtual_on_net_phone_number = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* groupId
    group_id = Field(
        type=str,
        required=False,
    )


class DNISKey(OCIType):
    """
    Uniquely identifies a Call Center DNIS.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class DNRange(OCIType):
    """
    Directory number range. The minimum and maximum values are inclusive.
    """

    _ELEMENTS = (
        E(
            "min_phone_number",
            "minPhoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_phone_number",
            "maxPhoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* minPhoneNumber
    min_phone_number = Field(
        type=str,
        required=True,
    )
    #: str: *Required* maxPhoneNumber
    max_phone_number = Field(
        type=str,
        required=True,
    )


class DefaultNetworkClassOfService(OCIType):
    """
    The default Network Class of Service to set during assignation/unassignation.
    """

    _ELEMENTS = (
        E(
            "use_existing",
            "useExisting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_class_of_service_name",
            "networkClassOfServiceName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* useExisting
    use_existing = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* networkClassOfServiceName
    network_class_of_service_name = Field(
        type=str,
        required=False,
    )


class DepartmentKey(OCIType):
    """
    Uniquely identifies a department system-wide.
    Departments are contained in either an enterprise or a group. Enterprise
    departments can be
    used by any or all groups within the enterprise. Department names are unique
    within a group and
    within an enterprise, but the same department name can exist in 2 different
    groups or in both
    a group and its parent enterprise. Therefore, to uniquely identify a department,
    we must know
    the department name and which enterprise or group contains the department.
    This type is extended by group and enterprise department keys.
    """

    _ELEMENTS = ()


class DeviceManagementAutoRebuildConfigEntry(OCIType):
    """
    Contains one automatic rebuild configuration list entry.
    """

    _ELEMENTS = (
        E(
            "oci_request_prefix",
            "ociRequestPrefix",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "auto_rebuild_enabled",
            "autoRebuildEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* ociRequestPrefix
    oci_request_prefix = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* autoRebuildEnabled
    auto_rebuild_enabled = Field(
        type=bool,
        required=False,
    )


class DeviceManagementDeviceTypeOptionsRead(OCIType):
    """
    Device Management System device type options.
    """

    _ELEMENTS = (
        E(
            "device_access_protocol",
            "deviceAccessProtocol",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_mode",
            "tagMode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_set",
            "tagSet",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_device_profile_custom_tag_set",
            "allowDeviceProfileCustomTagSet",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_group_custom_tag_set",
            "allowGroupCustomTagSet",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "send_email_upon_reset_failure",
            "sendEmailUponResetFailure",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_access_net_address",
            "deviceAccessNetAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_port",
            "deviceAccessPort",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_context",
            "deviceAccessContext",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_uri",
            "deviceAccessURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_device_language",
            "defaultDeviceLanguage",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_device_encoding",
            "defaultDeviceEncoding",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_device_credentials",
            "accessDeviceCredentials",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_http_digest_authentication",
            "useHttpDigestAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mac_based_file_authentication",
            "macBasedFileAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mac_in_non_request_uri",
            "macInNonRequestURI",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mac_format_in_non_request_uri",
            "macFormatInNonRequestURI",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* deviceAccessProtocol
    device_access_protocol = Field(
        type=str,
        required=True,
    )
    #: str: *Required* tagMode
    tag_mode = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* tagSet
    tag_set = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* allowDeviceProfileCustomTagSet
    allow_device_profile_custom_tag_set = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowGroupCustomTagSet
    allow_group_custom_tag_set = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* sendEmailUponResetFailure
    send_email_upon_reset_failure = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* deviceAccessNetAddress
    device_access_net_address = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* deviceAccessPort
    device_access_port = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* deviceAccessContext
    device_access_context = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* deviceAccessURI
    device_access_uri = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultDeviceLanguage
    default_device_language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultDeviceEncoding
    default_device_encoding = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* accessDeviceCredentials
    access_device_credentials = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useHttpDigestAuthentication
    use_http_digest_authentication = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* macBasedFileAuthentication
    mac_based_file_authentication = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* macInNonRequestURI
    mac_in_non_request_uri = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(
        type=str,
        required=False,
    )


class DeviceManagementDeviceTypeOptionsRead16(OCIType):
    """
    Device Management System device type options.
    """

    _ELEMENTS = (
        E(
            "device_access_protocol",
            "deviceAccessProtocol",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_mode",
            "tagMode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_set",
            "tagSet",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_device_profile_custom_tag_set",
            "allowDeviceProfileCustomTagSet",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_group_custom_tag_set",
            "allowGroupCustomTagSet",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "send_email_upon_reset_failure",
            "sendEmailUponResetFailure",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_access_net_address",
            "deviceAccessNetAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_port",
            "deviceAccessPort",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_context",
            "deviceAccessContext",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_uri",
            "deviceAccessURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_device_language",
            "defaultDeviceLanguage",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_device_encoding",
            "defaultDeviceEncoding",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_device_credentials",
            "accessDeviceCredentials",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_http_digest_authentication",
            "useHttpDigestAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mac_based_file_authentication",
            "macBasedFileAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mac_in_non_request_uri",
            "macInNonRequestURI",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mac_format_in_non_request_uri",
            "macFormatInNonRequestURI",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* deviceAccessProtocol
    device_access_protocol = Field(
        type=str,
        required=True,
    )
    #: str: *Required* tagMode
    tag_mode = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* tagSet
    tag_set = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* allowDeviceProfileCustomTagSet
    allow_device_profile_custom_tag_set = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowGroupCustomTagSet
    allow_group_custom_tag_set = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* sendEmailUponResetFailure
    send_email_upon_reset_failure = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* deviceAccessNetAddress
    device_access_net_address = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* deviceAccessPort
    device_access_port = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* deviceAccessContext
    device_access_context = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* deviceAccessURI
    device_access_uri = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultDeviceLanguage
    default_device_language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultDeviceEncoding
    default_device_encoding = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* accessDeviceCredentials
    access_device_credentials = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useHttpDigestAuthentication
    use_http_digest_authentication = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* macBasedFileAuthentication
    mac_based_file_authentication = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* macInNonRequestURI
    mac_in_non_request_uri = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(
        type=str,
        required=False,
    )


class DeviceManagementLanguageMapping(OCIType):
    """
    Maps a BroadWorks language to a device-equivalent language.
    """

    _ELEMENTS = (
        E(
            "broad_works_language",
            "broadWorksLanguage",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_language",
            "deviceLanguage",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* broadWorksLanguage
    broad_works_language = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceLanguage
    device_language = Field(
        type=str,
        required=True,
    )


class DeviceManagementUserNamePassword(OCIType):
    """
    Access device credentials.
    """

    _ELEMENTS = (
        E(
            "user_name",
            "userName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userName
    user_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* password
    password = Field(
        type=str,
        required=True,
    )


class DeviceManagementUserNamePassword16(OCIType):
    """
    Access device credentials.
    """

    _ELEMENTS = (
        E(
            "user_name",
            "userName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userName
    user_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* password
    password = Field(
        type=str,
        required=True,
    )


class DialableCallerIDCriteriaPriorityOrder(OCIType):
    """
    Dialable Caller ID routing order
    """

    _ELEMENTS = (
        E(
            "criteria_name",
            "criteriaName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "priority",
            "priority",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* criteriaName
    criteria_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* priority
    priority = Field(
        type=str,
        required=True,
    )


class EnhancedCallLogsAccountAuthorizationCodeFilter(OCIType):
    """
    Filter criteria based on the account code.
    When "callsWithCodes" is set to true, all call logs with account/authorization
    codes are returned.
    When it set to false, all call logs without account/authorization codes are returned.
    """

    _ELEMENTS = (
        E(
            "calls_with_codes",
            "callsWithCodes",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "account_authorization_code",
            "accountAuthorizationCode",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* callsWithCodes
    calls_with_codes = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* accountAuthorizationCode
    account_authorization_code = Field(
        type=str,
        required=False,
    )


class EnhancedCallLogsCallAuthorizationCodeFilter(OCIType):
    """
    Filter criteria based on call authorization code. Note that this code
    filter is different than EnhancedCallLogsAccountAuthorizationCodeFilter,
    which applies strictly to codes entered using the account/authorization
    code service.
    When "callsWithCodes" is set to true, all call logs with authorization
    codes are returned.
    When it set to false, all call logs without authorization codes are
    returned.
    If "authorizationCode" is set, all call logs matching that specific
    authorization code are returned.
    """

    _ELEMENTS = (
        E(
            "calls_with_codes",
            "callsWithCodes",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "authorization_code",
            "authorizationCode",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* callsWithCodes
    calls_with_codes = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* authorizationCode
    authorization_code = Field(
        type=str,
        required=False,
    )


class EnhancedCallLogsEntry(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.
    Replaced By CallLogsEntry
    """

    _ELEMENTS = (
        E(
            "country_code",
            "countryCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "time",
            "time",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* countryCode
    country_code = Field(
        type=str,
        required=False,
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* time
    time = Field(
        type=str,
        required=True,
    )


class EnhancedCallLogsRedirectedCallSelection(OCIType):
    """
    Redirected call selection.
    When " redirectedCall " is set to true, all call logs with redirected call are
    returned. When it
    set to false, all call logs without redirected call are returned.
    The redirected call can be defined by including a subset of Service Invocation
    Disposition here.
    If none included, any call has a ServiceInvocationDisposition  value defined in
    ServiceInvocationDisposition
    is considered as a redirected call.
    """

    _ELEMENTS = (
        E(
            "redirected_call",
            "redirectedCall",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "redirect_type",
            "redirectType",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: bool: *Required* redirectedCall
    redirected_call = Field(
        type=bool,
        required=True,
    )
    #: list(str): *Optional* redirectType  *Array*
    redirect_type = Field(
        type=list,
        required=False,
    )


class EnhancedCallLogsRedirectedCallSelection21(OCIType):
    """
    Redirected call selection.
    When " redirectedCall " is set to true, all call logs with redirected call are
    returned. When it
    set to false, all call logs without redirected call are returned.
    The redirected call can be defined by including a subset of Service Invocation
    Disposition here.
    If none included, any call has a ServiceInvocationDisposition  value defined in
    ServiceInvocationDisposition
    is considered as a redirected call.
    """

    _ELEMENTS = (
        E(
            "redirected_call",
            "redirectedCall",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "redirect_type",
            "redirectType",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: bool: *Required* redirectedCall
    redirected_call = Field(
        type=bool,
        required=True,
    )
    #: list(str): *Optional* redirectType  *Array*
    redirect_type = Field(
        type=list,
        required=False,
    )


class EnhancedCallLogsResponsePagingControl(OCIType):
    """
    Used in enhanced call logs group and enterprise queries to restrict the set of result
    rows when making a request that can result in a large dataset. The client specifies the
    starting row and the number of rows requested.
    The server only provides those rows in results, if available.
    """

    _ELEMENTS = (
        E(
            "response_start_index",
            "responseStartIndex",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "response_page_size",
            "responsePageSize",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* responseStartIndex
    response_start_index = Field(
        type=int,
        required=True,
    )
    #: int: *Required* responsePageSize
    response_page_size = Field(
        type=int,
        required=True,
    )


class EnhancedCallLogsTimeRange(OCIType):
    """
    Time range used to filter call logs.
    """

    _ELEMENTS = (
        E(
            "start_date_time",
            "startDateTime",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "end_date_time",
            "endDateTime",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* startDateTime
    start_date_time = Field(
        type=str,
        required=True,
    )
    #: str: *Required* endDateTime
    end_date_time = Field(
        type=str,
        required=True,
    )


class EnterpriseDepartmentKey(OCIType):
    """
    Uniquely identifies a department defined within an enterprise.
    To uniquely identify an enterprise department, we must know the department name and which
    enterprise contains the department.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class EnterpriseTrunkTrunkGroupKey(OCIType):
    """
    Identifies a trunk group within an Enterprise Trunk where the service provider id
    is already known.
    """

    _ELEMENTS = (
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_group_name",
            "trunkGroupName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* trunkGroupName
    trunk_group_name = Field(
        type=str,
        required=True,
    )


class EnterpriseVoiceVPNDigitManipulation(OCIType):
    """
    Enterprise Voice VPN Digit Manipulation Entry.
    """

    _ELEMENTS = ()


class EnterpriseVoiceVPNDigitManipulationNoValue(OCIType):
    """
    Enterprise Voice VPN Digit Manipulation Entry that has no value.
    """

    _ELEMENTS = (
        E(
            "operation",
            "operation",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* operation
    operation = Field(
        type=str,
        required=True,
    )


class EnterpriseVoiceVPNDigitManipulationOptionalValue(OCIType):
    """
    Enterprise Voice VPN Digit Manipulation Entry that optionally has a value.
    """

    _ELEMENTS = (
        E(
            "operation",
            "operation",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* operation
    operation = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* value
    value = Field(
        type=str,
        required=False,
    )


class EnterpriseVoiceVPNDigitManipulationRequiredValue(OCIType):
    """
    Enterprise Voice VPN Digit Manipulation Entry that has a value.
    """

    _ELEMENTS = (
        E(
            "operation",
            "operation",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* operation
    operation = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )


class EnterpriseVoiceVPNTreatmentEntry(OCIType):
    """
    Enterprise Voice VPN Treatment entry
    """

    _ELEMENTS = (
        E(
            "id",
            "id",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* id
    id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class EstimatedWaitMessageOptionsModify(OCIType):
    """
    Estimated Wait Message Options
    """

    _ELEMENTS = (
        E(
            "enabled",
            "enabled",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "operating_mode",
            "operatingMode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "play_position_high_volume",
            "playPositionHighVolume",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "play_time_high_volume",
            "playTimeHighVolume",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "maximum_positions",
            "maximumPositions",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "maximum_waiting_minutes",
            "maximumWaitingMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_call_handling_minutes",
            "defaultCallHandlingMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "play_updated_ewm",
            "playUpdatedEWM",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_between_ewm_updates_seconds",
            "timeBetweenEWMUpdatesSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* enabled
    enabled = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* operatingMode
    operating_mode = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* playPositionHighVolume
    play_position_high_volume = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* playTimeHighVolume
    play_time_high_volume = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maximumPositions
    maximum_positions = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maximumWaitingMinutes
    maximum_waiting_minutes = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* defaultCallHandlingMinutes
    default_call_handling_minutes = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* playUpdatedEWM
    play_updated_ewm = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* timeBetweenEWMUpdatesSeconds
    time_between_ewm_updates_seconds = Field(
        type=int,
        required=False,
    )


class EstimatedWaitMessageOptionsRead(OCIType):
    """
    Estimated Wait Message Options

    Replaced by EstimatedWaitMessageOptionsRead17sp4
    """

    _ELEMENTS = (
        E(
            "enabled",
            "enabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "operating_mode",
            "operatingMode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "play_position_high_volume",
            "playPositionHighVolume",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "play_time_high_volume",
            "playTimeHighVolume",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "maximum_positions",
            "maximumPositions",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "maximum_waiting_minutes",
            "maximumWaitingMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "default_call_handling_minutes",
            "defaultCallHandlingMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* enabled
    enabled = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* operatingMode
    operating_mode = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* playPositionHighVolume
    play_position_high_volume = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* playTimeHighVolume
    play_time_high_volume = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maximumPositions
    maximum_positions = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maximumWaitingMinutes
    maximum_waiting_minutes = Field(
        type=int,
        required=True,
    )
    #: int: *Required* defaultCallHandlingMinutes
    default_call_handling_minutes = Field(
        type=int,
        required=True,
    )


class EstimatedWaitMessageOptionsRead17sp4(OCIType):
    """
    Estimated Wait Message Options
    """

    _ELEMENTS = (
        E(
            "enabled",
            "enabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "operating_mode",
            "operatingMode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "play_position_high_volume",
            "playPositionHighVolume",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "play_time_high_volume",
            "playTimeHighVolume",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "maximum_positions",
            "maximumPositions",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "maximum_waiting_minutes",
            "maximumWaitingMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "default_call_handling_minutes",
            "defaultCallHandlingMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "play_updated_ewm",
            "playUpdatedEWM",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "time_between_ewm_updates_seconds",
            "timeBetweenEWMUpdatesSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* enabled
    enabled = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* operatingMode
    operating_mode = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* playPositionHighVolume
    play_position_high_volume = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* playTimeHighVolume
    play_time_high_volume = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maximumPositions
    maximum_positions = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maximumWaitingMinutes
    maximum_waiting_minutes = Field(
        type=int,
        required=True,
    )
    #: int: *Required* defaultCallHandlingMinutes
    default_call_handling_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* playUpdatedEWM
    play_updated_ewm = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* timeBetweenEWMUpdatesSeconds
    time_between_ewm_updates_seconds = Field(
        type=int,
        required=False,
    )


class ExchangeUserNamePassword(OCIType):
    """
    Exchange server user name and password.
    """

    _ELEMENTS = (
        E(
            "user_name",
            "userName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userName
    user_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* password
    password = Field(
        type=str,
        required=True,
    )


class ExecutiveAssistantOptInStatus(OCIType):
    """
    Executive assistant Opt-in status with executive.
    """

    _ELEMENTS = (
        E(
            "executive_user_id",
            "executiveUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "opt_in",
            "optIn",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* executiveUserId
    executive_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* optIn
    opt_in = Field(
        type=bool,
        required=True,
    )


class ExecutiveCallFilteringCriteriaFromDn(OCIType):
    """
    The from dn criteria used within an executive call filtering criteria add/get request.
    """

    _ELEMENTS = (
        E(
            "from_dn_criteria_selection",
            "fromDnCriteriaSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_anonymous_callers",
            "includeAnonymousCallers",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_unavailable_callers",
            "includeUnavailableCallers",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* fromDnCriteriaSelection
    from_dn_criteria_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* includeAnonymousCallers
    include_anonymous_callers = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeUnavailableCallers
    include_unavailable_callers = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )


class ExtendedMixedCallLogsEntry(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.
    "countryCode" is the user's country code
    The following time elements are represented as timestamp, i.e., the number of milliseconds
    since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation
    message (e.g. for
    placed calls) or receives a call invitation message (e.g. for missed/received calls).
    "answerTime" represents the time when the call is answered by the terminating party.
    "detachTime" represents the time when the call is successfully redirected by the system.
    "releaseTime" represents the time when the call is released. This time corresponds to the
    moment the call is released by the system, and not necessarily when one party
    hangs up, since this
    does not always mean the call is released (e.g. Emergency/911 calls).
    The elements "userGroupId", "userId","userPrimaryDn" and "userPrimaryExtension"
    are only returned when the enterprise or group level requests are used.

    Replaced by ExtendedMixedCallLogsEntry17sp4.
    Originally deprecated in release 20.
    """

    _ELEMENTS = (
        E(
            "call_log_type",
            "callLogType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "country_code",
            "countryCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_log_id",
            "callLogId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_id",
            "callId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "subscriber_type",
            "subscriberType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "dialed_number",
            "dialedNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "called_number",
            "calledNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_translated_address",
            "networkTranslatedAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_asserted_number",
            "callingAssertedNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_presentation_number",
            "callingPresentationNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_presentation_number_source",
            "callingPresentationNumberSource",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_presentation_name",
            "callingPresentationName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_presentation_indicator",
            "callingPresentationIndicator",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_group_id",
            "callingGroupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "called_directory_name",
            "calledDirectoryName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "called_group_id",
            "calledGroupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "connected_number",
            "connectedNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "connected_number_source",
            "connectedNumberSource",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "connected_name",
            "connectedName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "connected_presentation_indicator",
            "connectedPresentationIndicator",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "type_of_network",
            "typeOfNetwork",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_category",
            "callCategory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "basic_call_type",
            "basicCallType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "configurable_call_type",
            "configurableCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_call_indicator",
            "alternateCallIndicator",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "virtual_on_net_call_type",
            "virtualOnNetCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time",
            "time",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "start_time",
            "startTime",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "answer_time",
            "answerTime",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "release_time",
            "releaseTime",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "detached_time",
            "detachedTime",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "detached_answer_time",
            "detachedAnswerTime",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "outgoing_dnis",
            "outgoingDnis",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_disposition",
            "serviceInvocationDisposition",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_dialed_number",
            "serviceInvocationDialedNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_called_number",
            "serviceInvocationCalledNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_network_translated_address",
            "serviceInvocationNetworkTranslatedAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_type_of_network",
            "serviceInvocationTypeOfNetwork",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_call_category",
            "serviceInvocationCallCategory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_basic_call_type",
            "serviceInvocationBasicCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_configurable_call_type",
            "serviceInvocationConfigurableCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_alternate_call_indicator",
            "serviceInvocationAlternateCallIndicator",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_virtual_on_net_call_type",
            "serviceInvocationVirtualOnNetCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_called_directory_name",
            "serviceInvocationCalledDirectoryName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_called_group_id",
            "serviceInvocationCalledGroupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_number",
            "redirectingNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_name",
            "redirectingName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_presentation_indicator",
            "redirectingPresentationIndicator",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_reason",
            "RedirectingReason",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "account_authorization_code",
            "accountAuthorizationCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_group_id",
            "userGroupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_primary_dn",
            "userPrimaryDn",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_primary_extension",
            "userPrimaryExtension",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* callLogType
    call_log_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* countryCode
    country_code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callLogId
    call_log_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callId
    call_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* subscriberType
    subscriber_type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* dialedNumber
    dialed_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* calledNumber
    called_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* networkTranslatedAddress
    network_translated_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingAssertedNumber
    calling_asserted_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingPresentationNumber
    calling_presentation_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingPresentationNumberSource
    calling_presentation_number_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingPresentationName
    calling_presentation_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* callingPresentationIndicator
    calling_presentation_indicator = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* callingGroupId
    calling_group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* calledDirectoryName
    called_directory_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* calledGroupId
    called_group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* connectedNumber
    connected_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* connectedNumberSource
    connected_number_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* connectedName
    connected_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* connectedPresentationIndicator
    connected_presentation_indicator = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* typeOfNetwork
    type_of_network = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callCategory
    call_category = Field(
        type=str,
        required=False,
    )
    #: str: *Required* basicCallType
    basic_call_type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* configurableCallType
    configurable_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateCallIndicator
    alternate_call_indicator = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* virtualOnNetCallType
    virtual_on_net_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Required* time
    time = Field(
        type=str,
        required=True,
    )
    #: int: *Required* startTime
    start_time = Field(
        type=int,
        required=True,
    )
    #: int: *Optional* answerTime
    answer_time = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* releaseTime
    release_time = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* detachedTime
    detached_time = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* detachedAnswerTime
    detached_answer_time = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* outgoingDnis
    outgoing_dnis = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationDisposition
    service_invocation_disposition = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationDialedNumber
    service_invocation_dialed_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationCalledNumber
    service_invocation_called_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationNetworkTranslatedAddress
    service_invocation_network_translated_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationTypeOfNetwork
    service_invocation_type_of_network = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationCallCategory
    service_invocation_call_category = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationBasicCallType
    service_invocation_basic_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationConfigurableCallType
    service_invocation_configurable_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationAlternateCallIndicator
    service_invocation_alternate_call_indicator = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationVirtualOnNetCallType
    service_invocation_virtual_on_net_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationCalledDirectoryName
    service_invocation_called_directory_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationCalledGroupId
    service_invocation_called_group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* redirectingNumber
    redirecting_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* redirectingName
    redirecting_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* redirectingPresentationIndicator
    redirecting_presentation_indicator = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* RedirectingReason
    redirecting_reason = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* accountAuthorizationCode
    account_authorization_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userGroupId
    user_group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userId
    user_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userPrimaryDn
    user_primary_dn = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userPrimaryExtension
    user_primary_extension = Field(
        type=str,
        required=False,
    )


class ExtendedMixedCallLogsEntry17sp4(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.
    "countryCode" is the user's country code
    The following time elements are represented as timestamp, i.e., the number of milliseconds
    since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation
    message (e.g. for
    placed calls) or receives a call invitation message (e.g. for missed/received calls).
    "answerTime" represents the time when the call is answered by the terminating party.
    "detachedTime" represents the time when the call is successfully redirected by the system.
    "releaseTime" represents the time when the call is released. This time corresponds to the
    moment the call is released by the system, and not necessarily when one party
    hangs up, since this
    does not always mean the call is released (e.g. Emergency/911 calls).
    The elements "userGroupId", "userId","userPrimaryDn" and "userPrimaryExtension"
    are only returned when the enterprise or group level requests are used.
    The following elements are only used in AS data mode:
    callAuthorizationCode
    """

    _ELEMENTS = (
        E(
            "call_log_type",
            "callLogType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "country_code",
            "countryCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_log_id",
            "callLogId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_id",
            "callId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "subscriber_type",
            "subscriberType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "dialed_number",
            "dialedNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "called_number",
            "calledNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_translated_address",
            "networkTranslatedAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_asserted_number",
            "callingAssertedNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_presentation_number",
            "callingPresentationNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_presentation_number_source",
            "callingPresentationNumberSource",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_presentation_name",
            "callingPresentationName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_presentation_indicator",
            "callingPresentationIndicator",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_group_id",
            "callingGroupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "called_directory_name",
            "calledDirectoryName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "called_group_id",
            "calledGroupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "connected_number",
            "connectedNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "connected_number_source",
            "connectedNumberSource",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "connected_name",
            "connectedName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "connected_presentation_indicator",
            "connectedPresentationIndicator",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "type_of_network",
            "typeOfNetwork",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_category",
            "callCategory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "basic_call_type",
            "basicCallType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "configurable_call_type",
            "configurableCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_call_indicator",
            "alternateCallIndicator",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "virtual_on_net_call_type",
            "virtualOnNetCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time",
            "time",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "start_time",
            "startTime",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "answer_time",
            "answerTime",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "release_time",
            "releaseTime",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "detached_time",
            "detachedTime",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "detached_answer_time",
            "detachedAnswerTime",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "outgoing_dnis",
            "outgoingDnis",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_disposition",
            "serviceInvocationDisposition",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_dialed_number",
            "serviceInvocationDialedNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_called_number",
            "serviceInvocationCalledNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_network_translated_address",
            "serviceInvocationNetworkTranslatedAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_type_of_network",
            "serviceInvocationTypeOfNetwork",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_call_category",
            "serviceInvocationCallCategory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_basic_call_type",
            "serviceInvocationBasicCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_configurable_call_type",
            "serviceInvocationConfigurableCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_alternate_call_indicator",
            "serviceInvocationAlternateCallIndicator",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_virtual_on_net_call_type",
            "serviceInvocationVirtualOnNetCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_called_directory_name",
            "serviceInvocationCalledDirectoryName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_called_group_id",
            "serviceInvocationCalledGroupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_number",
            "redirectingNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_name",
            "redirectingName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_presentation_indicator",
            "redirectingPresentationIndicator",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_reason",
            "RedirectingReason",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "account_authorization_code",
            "accountAuthorizationCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_authorization_code",
            "callAuthorizationCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_group_id",
            "userGroupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_primary_dn",
            "userPrimaryDn",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_primary_extension",
            "userPrimaryExtension",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* callLogType
    call_log_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* countryCode
    country_code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callLogId
    call_log_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callId
    call_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* subscriberType
    subscriber_type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* dialedNumber
    dialed_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* calledNumber
    called_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* networkTranslatedAddress
    network_translated_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingAssertedNumber
    calling_asserted_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingPresentationNumber
    calling_presentation_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingPresentationNumberSource
    calling_presentation_number_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingPresentationName
    calling_presentation_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* callingPresentationIndicator
    calling_presentation_indicator = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* callingGroupId
    calling_group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* calledDirectoryName
    called_directory_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* calledGroupId
    called_group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* connectedNumber
    connected_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* connectedNumberSource
    connected_number_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* connectedName
    connected_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* connectedPresentationIndicator
    connected_presentation_indicator = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* typeOfNetwork
    type_of_network = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callCategory
    call_category = Field(
        type=str,
        required=False,
    )
    #: str: *Required* basicCallType
    basic_call_type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* configurableCallType
    configurable_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateCallIndicator
    alternate_call_indicator = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* virtualOnNetCallType
    virtual_on_net_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Required* time
    time = Field(
        type=str,
        required=True,
    )
    #: int: *Required* startTime
    start_time = Field(
        type=int,
        required=True,
    )
    #: int: *Optional* answerTime
    answer_time = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* releaseTime
    release_time = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* detachedTime
    detached_time = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* detachedAnswerTime
    detached_answer_time = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* outgoingDnis
    outgoing_dnis = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationDisposition
    service_invocation_disposition = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationDialedNumber
    service_invocation_dialed_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationCalledNumber
    service_invocation_called_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationNetworkTranslatedAddress
    service_invocation_network_translated_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationTypeOfNetwork
    service_invocation_type_of_network = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationCallCategory
    service_invocation_call_category = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationBasicCallType
    service_invocation_basic_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationConfigurableCallType
    service_invocation_configurable_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationAlternateCallIndicator
    service_invocation_alternate_call_indicator = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationVirtualOnNetCallType
    service_invocation_virtual_on_net_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationCalledDirectoryName
    service_invocation_called_directory_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationCalledGroupId
    service_invocation_called_group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* redirectingNumber
    redirecting_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* redirectingName
    redirecting_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* redirectingPresentationIndicator
    redirecting_presentation_indicator = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* RedirectingReason
    redirecting_reason = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* accountAuthorizationCode
    account_authorization_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callAuthorizationCode
    call_authorization_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userGroupId
    user_group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userId
    user_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userPrimaryDn
    user_primary_dn = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userPrimaryExtension
    user_primary_extension = Field(
        type=str,
        required=False,
    )


class ExtendedMixedCallLogsEntry20(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.
    "countryCode" is the user's country code
    The following time elements are represented as timestamp, i.e., the number of milliseconds
    since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation
    message (e.g. for
    placed calls) or receives a call invitation message (e.g. for missed/received calls).
    "answerTime" represents the time when the call is answered by the terminating party.
    "detachedTime" represents the time when the call is successfully redirected by the system.
    "releaseTime" represents the time when the call is released. This time corresponds to the
    moment the call is released by the system, and not necessarily when one party
    hangs up, since this
    does not always mean the call is released (e.g. Emergency/911 calls).
    The elements "userGroupId", "userId","userPrimaryDn" and "userPrimaryExtension"
    are only returned when the enterprise or group level requests are used.
    The following elements are only used in AS data mode:
    callAuthorizationCode
    callSecurityClassification
    """

    _ELEMENTS = (
        E(
            "call_log_type",
            "callLogType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "country_code",
            "countryCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_log_id",
            "callLogId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_id",
            "callId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "subscriber_type",
            "subscriberType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "dialed_number",
            "dialedNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "called_number",
            "calledNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_translated_address",
            "networkTranslatedAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_asserted_number",
            "callingAssertedNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_presentation_number",
            "callingPresentationNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_presentation_number_source",
            "callingPresentationNumberSource",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_presentation_name",
            "callingPresentationName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_presentation_indicator",
            "callingPresentationIndicator",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_group_id",
            "callingGroupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "called_directory_name",
            "calledDirectoryName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "called_group_id",
            "calledGroupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "connected_number",
            "connectedNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "connected_number_source",
            "connectedNumberSource",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "connected_name",
            "connectedName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "connected_presentation_indicator",
            "connectedPresentationIndicator",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "type_of_network",
            "typeOfNetwork",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_category",
            "callCategory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "basic_call_type",
            "basicCallType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "configurable_call_type",
            "configurableCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_call_indicator",
            "alternateCallIndicator",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "virtual_on_net_call_type",
            "virtualOnNetCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time",
            "time",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "start_time",
            "startTime",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "answer_time",
            "answerTime",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "release_time",
            "releaseTime",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "detached_time",
            "detachedTime",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "detached_answer_time",
            "detachedAnswerTime",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "outgoing_dnis",
            "outgoingDnis",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_disposition",
            "serviceInvocationDisposition",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_dialed_number",
            "serviceInvocationDialedNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_called_number",
            "serviceInvocationCalledNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_network_translated_address",
            "serviceInvocationNetworkTranslatedAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_type_of_network",
            "serviceInvocationTypeOfNetwork",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_call_category",
            "serviceInvocationCallCategory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_basic_call_type",
            "serviceInvocationBasicCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_configurable_call_type",
            "serviceInvocationConfigurableCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_alternate_call_indicator",
            "serviceInvocationAlternateCallIndicator",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_virtual_on_net_call_type",
            "serviceInvocationVirtualOnNetCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_called_directory_name",
            "serviceInvocationCalledDirectoryName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_called_group_id",
            "serviceInvocationCalledGroupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_number",
            "redirectingNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_name",
            "redirectingName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_presentation_indicator",
            "redirectingPresentationIndicator",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_reason",
            "RedirectingReason",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "account_authorization_code",
            "accountAuthorizationCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_authorization_code",
            "callAuthorizationCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_group_id",
            "userGroupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_primary_dn",
            "userPrimaryDn",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_primary_extension",
            "userPrimaryExtension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "security_classification",
            "securityClassification",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* callLogType
    call_log_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* countryCode
    country_code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callLogId
    call_log_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callId
    call_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* subscriberType
    subscriber_type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* dialedNumber
    dialed_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* calledNumber
    called_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* networkTranslatedAddress
    network_translated_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingAssertedNumber
    calling_asserted_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingPresentationNumber
    calling_presentation_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingPresentationNumberSource
    calling_presentation_number_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingPresentationName
    calling_presentation_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* callingPresentationIndicator
    calling_presentation_indicator = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* callingGroupId
    calling_group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* calledDirectoryName
    called_directory_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* calledGroupId
    called_group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* connectedNumber
    connected_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* connectedNumberSource
    connected_number_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* connectedName
    connected_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* connectedPresentationIndicator
    connected_presentation_indicator = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* typeOfNetwork
    type_of_network = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callCategory
    call_category = Field(
        type=str,
        required=False,
    )
    #: str: *Required* basicCallType
    basic_call_type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* configurableCallType
    configurable_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateCallIndicator
    alternate_call_indicator = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* virtualOnNetCallType
    virtual_on_net_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Required* time
    time = Field(
        type=str,
        required=True,
    )
    #: int: *Required* startTime
    start_time = Field(
        type=int,
        required=True,
    )
    #: int: *Optional* answerTime
    answer_time = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* releaseTime
    release_time = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* detachedTime
    detached_time = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* detachedAnswerTime
    detached_answer_time = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* outgoingDnis
    outgoing_dnis = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationDisposition
    service_invocation_disposition = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationDialedNumber
    service_invocation_dialed_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationCalledNumber
    service_invocation_called_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationNetworkTranslatedAddress
    service_invocation_network_translated_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationTypeOfNetwork
    service_invocation_type_of_network = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationCallCategory
    service_invocation_call_category = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationBasicCallType
    service_invocation_basic_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationConfigurableCallType
    service_invocation_configurable_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationAlternateCallIndicator
    service_invocation_alternate_call_indicator = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationVirtualOnNetCallType
    service_invocation_virtual_on_net_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationCalledDirectoryName
    service_invocation_called_directory_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationCalledGroupId
    service_invocation_called_group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* redirectingNumber
    redirecting_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* redirectingName
    redirecting_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* redirectingPresentationIndicator
    redirecting_presentation_indicator = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* RedirectingReason
    redirecting_reason = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* accountAuthorizationCode
    account_authorization_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callAuthorizationCode
    call_authorization_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userGroupId
    user_group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userId
    user_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userPrimaryDn
    user_primary_dn = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userPrimaryExtension
    user_primary_extension = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* securityClassification
    security_classification = Field(
        type=str,
        required=False,
    )


class ExtendedMixedCallLogsEntry21(OCIType):
    """
    Extended Call Log entry describing a placed, received, or missed call.
    "countryCode" is the user's country code
    The following time elements are represented as timestamp, i.e., the number of milliseconds
    since January 1, 1970, 00:00:00 GMT.
    "startTime" represents the time when the system sends out a call invitation
    message (e.g. for
    placed calls) or receives a call invitation message (e.g. for missed/received calls).
    "answerTime" represents the time when the call is answered by the terminating party.
    "detachedTime" represents the time when the call is successfully redirected by the system.
    "releaseTime" represents the time when the call is released. This time corresponds to the
    moment the call is released by the system, and not necessarily when one party
    hangs up, since this
    does not always mean the call is released (e.g. Emergency/911 calls).
    The elements "userGroupId", "userId","userPrimaryDn" and "userPrimaryExtension"
    are only returned when the enterprise or group level requests are used.
    The following elements are only used in AS data mode:
    callAuthorizationCode
    securityClassification
    """

    _ELEMENTS = (
        E(
            "call_log_type",
            "callLogType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "country_code",
            "countryCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_log_id",
            "callLogId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_id",
            "callId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "subscriber_type",
            "subscriberType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "dialed_number",
            "dialedNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "called_number",
            "calledNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_translated_address",
            "networkTranslatedAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_asserted_number",
            "callingAssertedNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_presentation_number",
            "callingPresentationNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_presentation_number_source",
            "callingPresentationNumberSource",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_presentation_name",
            "callingPresentationName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_presentation_indicator",
            "callingPresentationIndicator",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_group_id",
            "callingGroupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "called_directory_name",
            "calledDirectoryName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "called_group_id",
            "calledGroupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "connected_number",
            "connectedNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "connected_number_source",
            "connectedNumberSource",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "connected_name",
            "connectedName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "connected_presentation_indicator",
            "connectedPresentationIndicator",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "type_of_network",
            "typeOfNetwork",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_category",
            "callCategory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "basic_call_type",
            "basicCallType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "configurable_call_type",
            "configurableCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_call_indicator",
            "alternateCallIndicator",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "virtual_on_net_call_type",
            "virtualOnNetCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time",
            "time",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "start_time",
            "startTime",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "answer_time",
            "answerTime",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "release_time",
            "releaseTime",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "detached_time",
            "detachedTime",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "detached_answer_time",
            "detachedAnswerTime",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "outgoing_dnis",
            "outgoingDnis",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_disposition",
            "serviceInvocationDisposition",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_dialed_number",
            "serviceInvocationDialedNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_called_number",
            "serviceInvocationCalledNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_network_translated_address",
            "serviceInvocationNetworkTranslatedAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_type_of_network",
            "serviceInvocationTypeOfNetwork",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_call_category",
            "serviceInvocationCallCategory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_basic_call_type",
            "serviceInvocationBasicCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_configurable_call_type",
            "serviceInvocationConfigurableCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_alternate_call_indicator",
            "serviceInvocationAlternateCallIndicator",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_virtual_on_net_call_type",
            "serviceInvocationVirtualOnNetCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_called_directory_name",
            "serviceInvocationCalledDirectoryName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_invocation_called_group_id",
            "serviceInvocationCalledGroupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_number",
            "redirectingNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_name",
            "redirectingName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_presentation_indicator",
            "redirectingPresentationIndicator",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_reason",
            "RedirectingReason",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "account_authorization_code",
            "accountAuthorizationCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_authorization_code",
            "callAuthorizationCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_group_id",
            "userGroupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_primary_dn",
            "userPrimaryDn",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_primary_extension",
            "userPrimaryExtension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "security_classification",
            "securityClassification",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* callLogType
    call_log_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* countryCode
    country_code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callLogId
    call_log_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callId
    call_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* subscriberType
    subscriber_type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* dialedNumber
    dialed_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* calledNumber
    called_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* networkTranslatedAddress
    network_translated_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingAssertedNumber
    calling_asserted_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingPresentationNumber
    calling_presentation_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingPresentationNumberSource
    calling_presentation_number_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingPresentationName
    calling_presentation_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* callingPresentationIndicator
    calling_presentation_indicator = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* callingGroupId
    calling_group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* calledDirectoryName
    called_directory_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* calledGroupId
    called_group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* connectedNumber
    connected_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* connectedNumberSource
    connected_number_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* connectedName
    connected_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* connectedPresentationIndicator
    connected_presentation_indicator = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* typeOfNetwork
    type_of_network = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callCategory
    call_category = Field(
        type=str,
        required=False,
    )
    #: str: *Required* basicCallType
    basic_call_type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* configurableCallType
    configurable_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateCallIndicator
    alternate_call_indicator = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* virtualOnNetCallType
    virtual_on_net_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Required* time
    time = Field(
        type=str,
        required=True,
    )
    #: int: *Required* startTime
    start_time = Field(
        type=int,
        required=True,
    )
    #: int: *Optional* answerTime
    answer_time = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* releaseTime
    release_time = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* detachedTime
    detached_time = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* detachedAnswerTime
    detached_answer_time = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* outgoingDnis
    outgoing_dnis = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationDisposition
    service_invocation_disposition = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationDialedNumber
    service_invocation_dialed_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationCalledNumber
    service_invocation_called_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationNetworkTranslatedAddress
    service_invocation_network_translated_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationTypeOfNetwork
    service_invocation_type_of_network = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationCallCategory
    service_invocation_call_category = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationBasicCallType
    service_invocation_basic_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationConfigurableCallType
    service_invocation_configurable_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationAlternateCallIndicator
    service_invocation_alternate_call_indicator = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationVirtualOnNetCallType
    service_invocation_virtual_on_net_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationCalledDirectoryName
    service_invocation_called_directory_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceInvocationCalledGroupId
    service_invocation_called_group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* redirectingNumber
    redirecting_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* redirectingName
    redirecting_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* redirectingPresentationIndicator
    redirecting_presentation_indicator = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* RedirectingReason
    redirecting_reason = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* accountAuthorizationCode
    account_authorization_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callAuthorizationCode
    call_authorization_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userGroupId
    user_group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userId
    user_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userPrimaryDn
    user_primary_dn = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userPrimaryExtension
    user_primary_extension = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* securityClassification
    security_classification = Field(
        type=str,
        required=False,
    )


class ExtensionRange(OCIType):
    """
    Extension range. The minimum and maximum values are inclusive.
    """

    _ELEMENTS = (
        E(
            "min_extension",
            "minExtension",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_extension",
            "maxExtension",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* minExtension
    min_extension = Field(
        type=str,
        required=True,
    )
    #: str: *Required* maxExtension
    max_extension = Field(
        type=str,
        required=True,
    )


class ExtensionRange17(OCIType):
    """
    Extension range. The minimum and maximum values are inclusive.
    """

    _ELEMENTS = (
        E(
            "min_extension",
            "minExtension",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_extension",
            "maxExtension",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* minExtension
    min_extension = Field(
        type=str,
        required=True,
    )
    #: str: *Required* maxExtension
    max_extension = Field(
        type=str,
        required=True,
    )


class FeatureAccessCodeEntry(OCIType):
    """
    Feature Access Code Entry
    """

    _ELEMENTS = (
        E(
            "feature_access_code_name",
            "featureAccessCodeName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "main_code",
            "mainCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_code",
            "alternateCode",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* featureAccessCodeName
    feature_access_code_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* mainCode
    main_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateCode
    alternate_code = Field(
        type=str,
        required=False,
    )


class FeatureAccessCodeModifyEntry(OCIType):
    """
    Feature Access Code Entry to be used in all the system, service provider and
    group modify commands.
    """

    _ELEMENTS = (
        E(
            "feature_access_code_name",
            "featureAccessCodeName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "main_code",
            "mainCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_code",
            "alternateCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_fac",
            "enableFAC",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* featureAccessCodeName
    feature_access_code_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* mainCode
    main_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateCode
    alternate_code = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* enableFAC
    enable_fac = Field(
        type=bool,
        required=False,
    )


class FeatureAccessCodeReadEntry(OCIType):
    """
    Feature Access Code Entry to be used in all GET commands.
    """

    _ELEMENTS = (
        E(
            "feature_access_code_name",
            "featureAccessCodeName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "main_code",
            "mainCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_code",
            "alternateCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_fac",
            "enableFAC",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* featureAccessCodeName
    feature_access_code_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* mainCode
    main_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateCode
    alternate_code = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* enableFAC
    enable_fac = Field(
        type=bool,
        required=False,
    )


class FileRepositoryProtocolFTP(OCIType):
    """
    Attributes of the FTP protocol when the file repository interface is using FTP.
    """

    _ELEMENTS = (
        E(
            "ftp_passive",
            "ftpPassive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "net_address",
            "netAddress",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* ftpPassive
    ftp_passive = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* netAddress
    net_address = Field(
        type=str,
        required=True,
    )


class FileRepositoryProtocolFTP16(OCIType):
    """
    Attributes of the FTP protocol when the file repository interface is using FTP.
    """

    _ELEMENTS = (
        E(
            "ftp_passive",
            "ftpPassive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "net_address",
            "netAddress",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "ftp_remote_verification",
            "ftpRemoteVerification",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* ftpPassive
    ftp_passive = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* netAddress
    net_address = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* ftpRemoteVerification
    ftp_remote_verification = Field(
        type=bool,
        required=True,
    )


class FileRepositoryProtocolWebDAV(OCIType):
    """
    Attributes of the WebDav protocol when the file repository interface is using WebDav.
    """

    _ELEMENTS = (
        E(
            "secure",
            "secure",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "net_address",
            "netAddress",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* secure
    secure = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* netAddress
    net_address = Field(
        type=str,
        required=True,
    )


class FileRepositoryProtocolWebDAV20(OCIType):
    """
    Attributes of the WebDav protocol when the file repository interface is using WebDav.
    """

    _ELEMENTS = (
        E(
            "secure",
            "secure",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "net_address",
            "netAddress",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "extended_file_capture_support",
            "extendedFileCaptureSupport",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* secure
    secure = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* netAddress
    net_address = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* extendedFileCaptureSupport
    extended_file_capture_support = Field(
        type=bool,
        required=True,
    )


class FileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or
    the contents of a file to transfer.
    """

    _ELEMENTS = (
        E(
            "source_file_name",
            "sourceFileName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "file_content",
            "fileContent",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* sourceFileName
    source_file_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* fileContent
    file_content = Field(
        type=str,
        required=False,
    )


class FindMeFollowMeAlertingGroupReplacementOutgoingDNSIPURIorUserIdList(OCIType):
    """
    A list of phone numbers/sipuris or user ids that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userId
    user_id = Field(
        type=str,
        required=False,
    )


class GroupDepartmentKey(OCIType):
    """
    Uniquely identifies a department defined within a group.
    To uniquely identify a group department, we must know the department name and which
    group contains the department.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupEnterpriseTrunkPriorityWeightedTrunkGroup(OCIType):
    """
    Trunk group details (order and weight) for each trunk group
    """

    _ELEMENTS = (
        E(
            "trunk_group",
            "trunkGroup",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "priority",
            "priority",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "weight",
            "weight",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* trunkGroup
    trunk_group = Field(
        type=str,
        required=True,
    )
    #: int: *Required* priority
    priority = Field(
        type=int,
        required=True,
    )
    #: int: *Required* weight
    weight = Field(
        type=int,
        required=True,
    )


class GroupHuntGroupGetInstanceRequest17sp1V1(OCIType):
    """
    Request to get all the information of a Hunt Group instance.
    The response is either GroupHuntGroupGetInstanceResponse17sp1V1 or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupPreferredCarrierName(OCIType):
    """
    Group can either use it's service provider/enterprise's preferred carrier or use it's own.
    The group carrier name is exposed if it was previously configured.
    """

    _ELEMENTS = (
        E(
            "use_service_provider_preferred_carrier",
            "useServiceProviderPreferredCarrier",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "carrier",
            "carrier",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* useServiceProviderPreferredCarrier
    use_service_provider_preferred_carrier = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* carrier
    carrier = Field(
        type=str,
        required=False,
    )


class GroupPreferredCarrierNameModify(OCIType):
    """
    Group can either use it's service provider/enterprise's preferred carrier or use it's own.
    You can use the Service Provider preferred carrier without clearing the group
    carrier name -- in this case, the group carrier name is retained.
    """

    _ELEMENTS = (
        E(
            "use_service_provider_preferred_carrier",
            "useServiceProviderPreferredCarrier",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "carrier",
            "carrier",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* useServiceProviderPreferredCarrier
    use_service_provider_preferred_carrier = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* carrier
    carrier = Field(
        type=str,
        required=False,
    )


class Holiday(OCIType):
    """
    Holiday entry.
    """

    _ELEMENTS = (
        E(
            "holiday_name",
            "holidayName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "start_date",
            "startDate",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "end_date",
            "endDate",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* holidayName
    holiday_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* startDate
    start_date = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* endDate
    end_date = Field(
        type=str,
        required=False,
    )


class HolidaySchedule(OCIType):
    """
    Holiday Schedule.
    """

    _ELEMENTS = (
        E(
            "type",
            "type",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* type
    type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class HourMinute(OCIType):
    """
    Represents a specific time with hour and minute granularity
    """

    _ELEMENTS = (
        E(
            "hour",
            "hour",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "minute",
            "minute",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* hour
    hour = Field(
        type=int,
        required=True,
    )
    #: int: *Required* minute
    minute = Field(
        type=int,
        required=True,
    )


class HuntAgentWeight(OCIType):
    """
    The weighted call distribution weight for an agent.
    """

    _ELEMENTS = (
        E(
            "agent_user_id",
            "agentUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "weight",
            "weight",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* agentUserId
    agent_user_id = Field(
        type=str,
        required=True,
    )
    #: int: *Required* weight
    weight = Field(
        type=int,
        required=True,
    )


class IPAddressRange(OCIType):
    """
    IP Address Range.
    """

    _ELEMENTS = (
        E(
            "min_ip_address",
            "minIpAddress",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_ip_address",
            "maxIpAddress",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* minIpAddress
    min_ip_address = Field(
        type=str,
        required=True,
    )
    #: str: *Required* maxIpAddress
    max_ip_address = Field(
        type=str,
        required=True,
    )


class IncomingCallingPlanDigitPatternPermission(OCIType):
    """
    Indicates whether calls from specified digit patterns are permitted.
    """

    _ELEMENTS = (
        E(
            "digit_pattern_name",
            "digitPatternName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow",
            "allow",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* digitPatternName
    digit_pattern_name = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allow
    allow = Field(
        type=bool,
        required=True,
    )


class InterceptDNListEntry(OCIType):
    """
    Intercept User Entry containing the phone number and a Description.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class LDAPEntryField(OCIType):
    """
    One name value pair for a LDAP entry.
    """

    _ELEMENTS = (
        E(
            "attribute_name",
            "attributeName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "attribute_value",
            "attributeValue",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* attributeName
    attribute_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* attributeValue
    attribute_value = Field(
        type=str,
        required=False,
    )


class LDAPPage(OCIType):
    """
    Type to retrieve a particular page or the last page.
    """

    _ELEMENTS = (
        E(
            "last_page",
            "lastPage",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "number",
            "number",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* lastPage
    last_page = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* number
    number = Field(
        type=int,
        required=False,
    )


class LabeledFileNameResource(OCIType):
    """
    Represents an existing file for the application server to use, along with
    a description and mediaType.
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_type",
            "mediaType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "source_file_name",
            "sourceFileName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* description
    description = Field(
        type=str,
        required=True,
    )
    #: str: *Required* mediaType
    media_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sourceFileName
    source_file_name = Field(
        type=str,
        required=True,
    )


class LabeledFileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or
    the contents of a file to transfer with a description.
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "source_file_name",
            "sourceFileName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "content",
            "content",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* description
    description = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* sourceFileName
    source_file_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* content
    content = Field(
        type=str,
        required=False,
    )


class LabeledMediaFileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or
    the contents of a file to transfer with a description.
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_type",
            "mediaType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "source_file_name",
            "sourceFileName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "content",
            "content",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* description
    description = Field(
        type=str,
        required=True,
    )
    #: str: *Required* mediaType
    media_type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* sourceFileName
    source_file_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* content
    content = Field(
        type=str,
        required=False,
    )


class MWIDeliveryToMobileEndpointTemplateActivation(OCIType):
    """
    MWI Delivery To Mobile Endpoint enabled status indicator
    """

    _ELEMENTS = (
        E(
            "language",
            "language",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "type",
            "type",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_enabled",
            "isEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* language
    language = Field(
        type=str,
        required=True,
    )
    #: str: *Required* type
    type = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isEnabled
    is_enabled = Field(
        type=bool,
        required=True,
    )


class MWIDeliveryToMobileEndpointTemplateLine(OCIType):
    """
    MWI Delivery To Mobile Endpoint template section associated with a specific tag.
    """

    _ELEMENTS = (
        E(
            "prefix",
            "prefix",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "tag",
            "tag",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "postfix",
            "postfix",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* prefix
    prefix = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* tag
    tag = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* postfix
    postfix = Field(
        type=str,
        required=False,
    )


class MaliciousCallTraceTimePeriod(OCIType):
    """
    Modify the user level data associated with Malicious Call Trace.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "start_date_time",
            "startDateTime",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "stop_date_time",
            "stopDateTime",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* startDateTime
    start_date_time = Field(
        type=str,
        required=True,
    )
    #: str: *Required* stopDateTime
    stop_date_time = Field(
        type=str,
        required=True,
    )


class MeetMeConferencingConferenceDuration(OCIType):
    """
    Conference duration.
    """

    _ELEMENTS = (
        E(
            "hours",
            "hours",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "minutes",
            "minutes",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* hours
    hours = Field(
        type=int,
        required=True,
    )
    #: int: *Required* minutes
    minutes = Field(
        type=int,
        required=True,
    )


class MeetMeConferencingConferenceKey(OCIType):
    """
    Identifier for conference.
    """

    _ELEMENTS = (
        E(
            "bridge_id",
            "bridgeId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "conference_id",
            "conferenceId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* bridgeId
    bridge_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* conferenceId
    conference_id = Field(
        type=str,
        required=True,
    )


class MeetMeConferencingConferencePorts(OCIType):
    """
    Number of conference ports. Can either be unlimited or limited to a value between
    0 and 999999.
    """

    _ELEMENTS = (
        E(
            "unlimited",
            "unlimited",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "quantity",
            "quantity",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* unlimited
    unlimited = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* quantity
    quantity = Field(
        type=int,
        required=False,
    )


class MeetMeConferencingConferenceRecordingKey(OCIType):
    """
    Identifier for conference recording. startTime is the recording start timestamp.
    """

    _ELEMENTS = (
        E(
            "bridge_id",
            "bridgeId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "conference_id",
            "conferenceId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "start_time",
            "startTime",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* bridgeId
    bridge_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* conferenceId
    conference_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* startTime
    start_time = Field(
        type=str,
        required=True,
    )


class MeetMeConferencingConferenceSchedule(OCIType):
    """
    Conference schedule.
    """

    _ELEMENTS = (
        E(
            "schedule_reservationless",
            "scheduleReservationless",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "schedule_one_time",
            "scheduleOneTime",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "schedule_recurring",
            "scheduleRecurring",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Optional* scheduleReservationless
    schedule_reservationless = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* scheduleOneTime
    schedule_one_time = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* scheduleRecurring
    schedule_recurring = Field(
        type=str,
        required=False,
    )


class MixedCallLogsEntry(OCIType):
    """
    Call Log entry describing a placed, received, or missed call.
    """

    _ELEMENTS = (
        E(
            "call_log_type",
            "callLogType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "country_code",
            "countryCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_log_id",
            "callLogId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "time",
            "time",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* callLogType
    call_log_type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* countryCode
    country_code = Field(
        type=str,
        required=False,
    )
    #: str: *Required* callLogId
    call_log_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* time
    time = Field(
        type=str,
        required=True,
    )


class MusicOnHoldSourceAdd(OCIType):
    """
    Contains the music on hold source configuration.
    """

    _ELEMENTS = (
        E(
            "audio_file_preferred_codec",
            "audioFilePreferredCodec",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "external_source",
            "externalSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(
        type=str,
        required=True,
    )
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* externalSource
    external_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldSourceAdd16(OCIType):
    """
    Contains the music on hold source configuration.
    """

    _ELEMENTS = (
        E(
            "audio_file_preferred_codec",
            "audioFilePreferredCodec",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "external_source",
            "externalSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(
        type=str,
        required=True,
    )
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* externalSource
    external_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldSourceAdd20(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced By MusicOnHoldSourceAdd21
    """

    _ELEMENTS = (
        E(
            "audio_file_preferred_codec",
            "audioFilePreferredCodec",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "external_source",
            "externalSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(
        type=str,
        required=True,
    )
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* externalSource
    external_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldSourceAdd21(OCIType):
    """
    Contains the music on hold source configuration.
    The following elements are only used in HSS data mode and ignored in AS data mode:
    labeledMediaFiles
    The following elements are only used in AS data mode and ignored in HSS data mode:
    announcementMediaFiles
    """

    _ELEMENTS = (
        E(
            "audio_file_preferred_codec",
            "audioFilePreferredCodec",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "labeled_custom_source_media_files",
            "labeledCustomSourceMediaFiles",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "announcement_custom_source_media_files",
            "announcementCustomSourceMediaFiles",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "external_source",
            "externalSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(
        type=str,
        required=True,
    )
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* labeledCustomSourceMediaFiles
    labeled_custom_source_media_files = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* announcementCustomSourceMediaFiles
    announcement_custom_source_media_files = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* externalSource
    external_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldSourceModify(OCIType):
    """
    Contains the music on hold source configuration.
    """

    _ELEMENTS = (
        E(
            "audio_file_preferred_codec",
            "audioFilePreferredCodec",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "external_source",
            "externalSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Optional* audioFilePreferredCodec
    audio_file_preferred_codec = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* externalSource
    external_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldSourceModify16(OCIType):
    """
    Contains the music on hold source configuration.
    """

    _ELEMENTS = (
        E(
            "audio_file_preferred_codec",
            "audioFilePreferredCodec",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "external_source",
            "externalSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Optional* audioFilePreferredCodec
    audio_file_preferred_codec = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* externalSource
    external_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldSourceModify20(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced By MusicOnHoldSourceModify21
    """

    _ELEMENTS = (
        E(
            "audio_file_preferred_codec",
            "audioFilePreferredCodec",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "external_source",
            "externalSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Optional* audioFilePreferredCodec
    audio_file_preferred_codec = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* externalSource
    external_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldSourceModify21(OCIType):
    """
    Contains the music on hold source configuration.
    The following elements are only used in HSS data mode and ignored in AS data mode:
    labeledMediaFiles
    The following elements are only used in AS data mode and ignored in HSS data mode:
    announcementMediaFiles
    """

    _ELEMENTS = (
        E(
            "audio_file_preferred_codec",
            "audioFilePreferredCodec",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "labeled_custom_source_media_files",
            "labeledCustomSourceMediaFiles",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "announcement_custom_source_media_files",
            "announcementCustomSourceMediaFiles",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "external_source",
            "externalSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Optional* audioFilePreferredCodec
    audio_file_preferred_codec = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* labeledCustomSourceMediaFiles
    labeled_custom_source_media_files = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* announcementCustomSourceMediaFiles
    announcement_custom_source_media_files = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* externalSource
    external_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldSourceRead(OCIType):
    """
    Contains the music on hold source configuration.
    """

    _ELEMENTS = (
        E(
            "audio_file_preferred_codec",
            "audioFilePreferredCodec",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "external_source",
            "externalSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(
        type=str,
        required=True,
    )
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* externalSource
    external_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldSourceRead16(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced By MusicOnHoldSourceRead19.
    """

    _ELEMENTS = (
        E(
            "audio_file_preferred_codec",
            "audioFilePreferredCodec",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "external_source",
            "externalSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(
        type=str,
        required=True,
    )
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* externalSource
    external_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldSourceRead19(OCIType):
    """
    Contains the music on hold source configuration.
    """

    _ELEMENTS = (
        E(
            "audio_file_preferred_codec",
            "audioFilePreferredCodec",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "external_source",
            "externalSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(
        type=str,
        required=True,
    )
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* externalSource
    external_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldSourceRead20(OCIType):
    """
    Contains the music on hold source configuration.

    Replaced By MusicOnHoldSourceRead21
    """

    _ELEMENTS = (
        E(
            "audio_file_preferred_codec",
            "audioFilePreferredCodec",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "external_source",
            "externalSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(
        type=str,
        required=True,
    )
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* externalSource
    external_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldSourceRead21(OCIType):
    """
    Contains the music on hold source configuration.
    The following elements are only used in HSS data mode and not returned in AS data mode:
    labeledCustomSourceMediaFiles
    The following elements are only used in AS data mode and not returned in HSS data mode:
    announcementMediaFiles
    """

    _ELEMENTS = (
        E(
            "audio_file_preferred_codec",
            "audioFilePreferredCodec",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "labeled_custom_source_media_files",
            "labeledCustomSourceMediaFiles",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "announcement_custom_source_media_files",
            "announcementCustomSourceMediaFiles",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "external_source",
            "externalSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Required* audioFilePreferredCodec
    audio_file_preferred_codec = Field(
        type=str,
        required=True,
    )
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* labeledCustomSourceMediaFiles
    labeled_custom_source_media_files = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* announcementCustomSourceMediaFiles
    announcement_custom_source_media_files = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* externalSource
    external_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldUserSourceModify(OCIType):
    """
    Contains the music on hold user source configuration.
    """

    _ELEMENTS = (
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Optional* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldUserSourceModify16(OCIType):
    """
    Contains the music on hold user source
    configuration.
    """

    _ELEMENTS = (
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Optional* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldUserSourceModify20(OCIType):
    """
    Contains the music on hold user source configuration.
    """

    _ELEMENTS = (
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Optional* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldUserSourceRead(OCIType):
    """
    Contains the music on hold user source configuration.
    """

    _ELEMENTS = (
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldUserSourceRead16(OCIType):
    """
    Contains the music on hold user source configuration.
    """

    _ELEMENTS = (
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )


class MusicOnHoldUserSourceRead20(OCIType):
    """
    Contains the music on hold user source configuration.
    """

    _ELEMENTS = (
        E(
            "message_source_selection",
            "messageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "custom_source",
            "customSource",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Required* messageSourceSelection
    message_source_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* customSource
    custom_source = Field(
        type=str,
        required=False,
    )


class NameDialingName(OCIType):
    """
    Name dialing last and first names.
    """

    _ELEMENTS = (
        E(
            "name_dialing_last_name",
            "nameDialingLastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name_dialing_first_name",
            "nameDialingFirstName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* nameDialingLastName
    name_dialing_last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* nameDialingFirstName
    name_dialing_first_name = Field(
        type=str,
        required=True,
    )


class NetworkClassOfServiceCommunicationBarringProfile(OCIType):
    """
    Communication Barring Profile defined as part of the Network Class
    Of Service. There can be only one primary profile within a Network
    Class Of Service.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_primary",
            "isPrimary",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isPrimary
    is_primary = Field(
        type=bool,
        required=True,
    )


class OutgoingCallingPlanAuthorizationCodeEntry(OCIType):
    """
    Outgoing Calling Plan Authorization Code.
    """

    _ELEMENTS = (
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class OutgoingCallingPlanCallMeNowPermissions(OCIType):
    """
    Outgoing Calling Plan for Call Me Now call permissions.
    """

    _ELEMENTS = (
        E(
            "group",
            "group",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "local",
            "local",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "toll_free",
            "tollFree",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "toll",
            "toll",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "international",
            "international",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "operator_assisted",
            "operatorAssisted",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "chargeable_directory_assisted",
            "chargeableDirectoryAssisted",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "special_services_i",
            "specialServicesI",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "special_services_ii",
            "specialServicesII",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "premium_services_i",
            "premiumServicesI",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "premium_services_ii",
            "premiumServicesII",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "casual",
            "casual",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "url_dialing",
            "urlDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "unknown",
            "unknown",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* group
    group = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* local
    local = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* tollFree
    toll_free = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* toll
    toll = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* international
    international = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* operatorAssisted
    operator_assisted = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* chargeableDirectoryAssisted
    chargeable_directory_assisted = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* specialServicesI
    special_services_i = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* specialServicesII
    special_services_ii = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* premiumServicesI
    premium_services_i = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* premiumServicesII
    premium_services_ii = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* casual
    casual = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* urlDialing
    url_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* unknown
    unknown = Field(
        type=bool,
        required=True,
    )


class OutgoingCallingPlanCallMeNowPermissionsModify(OCIType):
    """
    Modify outgoing Calling Plan for Call Me Now call permissions.
    """

    _ELEMENTS = (
        E(
            "group",
            "group",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "local",
            "local",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "toll_free",
            "tollFree",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "toll",
            "toll",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "international",
            "international",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "operator_assisted",
            "operatorAssisted",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "chargeable_directory_assisted",
            "chargeableDirectoryAssisted",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "special_services_i",
            "specialServicesI",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "special_services_ii",
            "specialServicesII",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "premium_services_i",
            "premiumServicesI",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "premium_services_ii",
            "premiumServicesII",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "casual",
            "casual",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "url_dialing",
            "urlDialing",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "unknown",
            "unknown",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* group
    group = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* local
    local = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* tollFree
    toll_free = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* toll
    toll = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* international
    international = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* operatorAssisted
    operator_assisted = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* chargeableDirectoryAssisted
    chargeable_directory_assisted = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* specialServicesI
    special_services_i = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* specialServicesII
    special_services_ii = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* premiumServicesI
    premium_services_i = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* premiumServicesII
    premium_services_ii = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* casual
    casual = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* urlDialing
    url_dialing = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* unknown
    unknown = Field(
        type=bool,
        required=False,
    )


class OutgoingCallingPlanDigitPatternCallMeNowPermission(OCIType):
    """
    Indicates whether Call Me Now calls using specified digit patterns are permitted.
    """

    _ELEMENTS = (
        E(
            "digit_pattern_name",
            "digitPatternName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "permission",
            "permission",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* digitPatternName
    digit_pattern_name = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* permission
    permission = Field(
        type=bool,
        required=True,
    )


class OutgoingCallingPlanDigitPatternOriginatingPermission(OCIType):
    """
    Indicates whether originating calls using specified digit patterns are permitted.
    """

    _ELEMENTS = (
        E(
            "digit_pattern_name",
            "digitPatternName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "permission",
            "permission",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* digitPatternName
    digit_pattern_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* permission
    permission = Field(
        type=str,
        required=True,
    )


class OutgoingCallingPlanDigitPatternRedirectingPermission(OCIType):
    """
    Indicates whether redirecting calls using specified digit patterns are permitted.
    """

    _ELEMENTS = (
        E(
            "digit_pattern_name",
            "digitPatternName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "permission",
            "permission",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* digitPatternName
    digit_pattern_name = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* permission
    permission = Field(
        type=bool,
        required=True,
    )


class OutgoingCallingPlanOriginatingPermissions(OCIType):
    """
    Outgoing Calling Plan originating call permissions.
    """

    _ELEMENTS = (
        E(
            "group",
            "group",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "local",
            "local",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "toll_free",
            "tollFree",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "toll",
            "toll",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "international",
            "international",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "operator_assisted",
            "operatorAssisted",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "chargeable_directory_assisted",
            "chargeableDirectoryAssisted",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "special_services_i",
            "specialServicesI",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "special_services_ii",
            "specialServicesII",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "premium_services_i",
            "premiumServicesI",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "premium_services_ii",
            "premiumServicesII",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "casual",
            "casual",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "url_dialing",
            "urlDialing",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "unknown",
            "unknown",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* group
    group = Field(
        type=str,
        required=True,
    )
    #: str: *Required* local
    local = Field(
        type=str,
        required=True,
    )
    #: str: *Required* tollFree
    toll_free = Field(
        type=str,
        required=True,
    )
    #: str: *Required* toll
    toll = Field(
        type=str,
        required=True,
    )
    #: str: *Required* international
    international = Field(
        type=str,
        required=True,
    )
    #: str: *Required* operatorAssisted
    operator_assisted = Field(
        type=str,
        required=True,
    )
    #: str: *Required* chargeableDirectoryAssisted
    chargeable_directory_assisted = Field(
        type=str,
        required=True,
    )
    #: str: *Required* specialServicesI
    special_services_i = Field(
        type=str,
        required=True,
    )
    #: str: *Required* specialServicesII
    special_services_ii = Field(
        type=str,
        required=True,
    )
    #: str: *Required* premiumServicesI
    premium_services_i = Field(
        type=str,
        required=True,
    )
    #: str: *Required* premiumServicesII
    premium_services_ii = Field(
        type=str,
        required=True,
    )
    #: str: *Required* casual
    casual = Field(
        type=str,
        required=True,
    )
    #: str: *Required* urlDialing
    url_dialing = Field(
        type=str,
        required=True,
    )
    #: str: *Required* unknown
    unknown = Field(
        type=str,
        required=True,
    )


class OutgoingCallingPlanOriginatingPermissionsModify(OCIType):
    """
    Outgoing Calling Plan originating call permissions.
    """

    _ELEMENTS = (
        E(
            "group",
            "group",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "local",
            "local",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "toll_free",
            "tollFree",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "toll",
            "toll",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "international",
            "international",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "operator_assisted",
            "operatorAssisted",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "chargeable_directory_assisted",
            "chargeableDirectoryAssisted",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "special_services_i",
            "specialServicesI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "special_services_ii",
            "specialServicesII",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "premium_services_i",
            "premiumServicesI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "premium_services_ii",
            "premiumServicesII",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "casual",
            "casual",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "url_dialing",
            "urlDialing",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "unknown",
            "unknown",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* group
    group = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* local
    local = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* tollFree
    toll_free = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* toll
    toll = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* international
    international = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* operatorAssisted
    operator_assisted = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* chargeableDirectoryAssisted
    chargeable_directory_assisted = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* specialServicesI
    special_services_i = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* specialServicesII
    special_services_ii = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* premiumServicesI
    premium_services_i = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* premiumServicesII
    premium_services_ii = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* casual
    casual = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* urlDialing
    url_dialing = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* unknown
    unknown = Field(
        type=str,
        required=False,
    )


class OutgoingCallingPlanRedirectedPermissions(OCIType):
    """
    Outgoing Calling Plan being forwarded/transferred permissions.
    """

    _ELEMENTS = (
        E(
            "outside_group",
            "outsideGroup",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* outsideGroup
    outside_group = Field(
        type=bool,
        required=True,
    )


class OutgoingCallingPlanRedirectedPermissionsModify(OCIType):
    """
    Outgoing Calling Plan being forwarded/transferred permissions.
    """

    _ELEMENTS = (
        E(
            "outside_group",
            "outsideGroup",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* outsideGroup
    outside_group = Field(
        type=bool,
        required=False,
    )


class OutgoingCallingPlanRedirectingPermissions(OCIType):
    """
    Outgoing Calling Plan initiating call forwards/transfer permissions.
    """

    _ELEMENTS = (
        E(
            "group",
            "group",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "local",
            "local",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "toll_free",
            "tollFree",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "toll",
            "toll",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "international",
            "international",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "operator_assisted",
            "operatorAssisted",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "chargeable_directory_assisted",
            "chargeableDirectoryAssisted",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "special_services_i",
            "specialServicesI",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "special_services_ii",
            "specialServicesII",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "premium_services_i",
            "premiumServicesI",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "premium_services_ii",
            "premiumServicesII",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "casual",
            "casual",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "url_dialing",
            "urlDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "unknown",
            "unknown",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* group
    group = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* local
    local = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* tollFree
    toll_free = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* toll
    toll = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* international
    international = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* operatorAssisted
    operator_assisted = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* chargeableDirectoryAssisted
    chargeable_directory_assisted = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* specialServicesI
    special_services_i = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* specialServicesII
    special_services_ii = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* premiumServicesI
    premium_services_i = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* premiumServicesII
    premium_services_ii = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* casual
    casual = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* urlDialing
    url_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* unknown
    unknown = Field(
        type=bool,
        required=True,
    )


class OutgoingCallingPlanRedirectingPermissionsModify(OCIType):
    """
    Outgoing Calling Plan initiating call forwards/transfer permissions.
    """

    _ELEMENTS = (
        E(
            "group",
            "group",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "local",
            "local",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "toll_free",
            "tollFree",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "toll",
            "toll",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "international",
            "international",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "operator_assisted",
            "operatorAssisted",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "chargeable_directory_assisted",
            "chargeableDirectoryAssisted",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "special_services_i",
            "specialServicesI",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "special_services_ii",
            "specialServicesII",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "premium_services_i",
            "premiumServicesI",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "premium_services_ii",
            "premiumServicesII",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "casual",
            "casual",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "url_dialing",
            "urlDialing",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "unknown",
            "unknown",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* group
    group = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* local
    local = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* tollFree
    toll_free = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* toll
    toll = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* international
    international = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* operatorAssisted
    operator_assisted = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* chargeableDirectoryAssisted
    chargeable_directory_assisted = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* specialServicesI
    special_services_i = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* specialServicesII
    special_services_ii = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* premiumServicesI
    premium_services_i = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* premiumServicesII
    premium_services_ii = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* casual
    casual = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* urlDialing
    url_dialing = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* unknown
    unknown = Field(
        type=bool,
        required=False,
    )


class OutgoingCallingPlanTransferNumbers(OCIType):
    """
    Outgoing Calling Plan transfer numbers.
    """

    _ELEMENTS = (
        E(
            "phone_number01",
            "phoneNumber01",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number02",
            "phoneNumber02",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number03",
            "phoneNumber03",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* phoneNumber01
    phone_number01 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber02
    phone_number02 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber03
    phone_number03 = Field(
        type=str,
        required=False,
    )


class OutgoingCallingPlanTransferNumbersModify(OCIType):
    """
    Outgoing Calling Plan transfer numbers.
    """

    _ELEMENTS = (
        E(
            "phone_number01",
            "phoneNumber01",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number02",
            "phoneNumber02",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number03",
            "phoneNumber03",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* phoneNumber01
    phone_number01 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber02
    phone_number02 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber03
    phone_number03 = Field(
        type=str,
        required=False,
    )


class OutgoingPinholeDigitPlanDigitPatternCallMeNowPermission(OCIType):
    """
    Indicates whether Call Me Now calls using specified Pinhole digit patterns are permitted.
    """

    _ELEMENTS = (
        E(
            "digit_pattern_name",
            "digitPatternName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "permission",
            "permission",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* digitPatternName
    digit_pattern_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* permission
    permission = Field(
        type=str,
        required=True,
    )


class OutgoingPinholeDigitPlanDigitPatternOriginatingPermission(OCIType):
    """
    Indicates whether originating calls using specified Pinhole digit patterns are permitted.
    """

    _ELEMENTS = (
        E(
            "digit_pattern_name",
            "digitPatternName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "permission",
            "permission",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* digitPatternName
    digit_pattern_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* permission
    permission = Field(
        type=str,
        required=True,
    )


class OutgoingPinholeDigitPlanDigitPatternRedirectingPermission(OCIType):
    """
    Indicates whether redirecting calls using specified Pinhole digit patterns are permitted.
    """

    _ELEMENTS = (
        E(
            "digit_pattern_name",
            "digitPatternName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "permission",
            "permission",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* digitPatternName
    digit_pattern_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* permission
    permission = Field(
        type=str,
        required=True,
    )


class PhoneListEntry(OCIType):
    """
    Phone list entry.
    """

    _ELEMENTS = (
        E(
            "entry_name",
            "entryName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* entryName
    entry_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )


class PriorityAlertCriteriaFromDn(OCIType):
    """
    The from dn criteria used within an add/get request.
    """

    _ELEMENTS = (
        E(
            "from_dn_criteria_selection",
            "fromDnCriteriaSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_anonymous_callers",
            "includeAnonymousCallers",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_unavailable_callers",
            "includeUnavailableCallers",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* fromDnCriteriaSelection
    from_dn_criteria_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* includeAnonymousCallers
    include_anonymous_callers = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeUnavailableCallers
    include_unavailable_callers = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )


class PublicUserIdentity(OCIType):
    """
    Public User Identity
    """

    _ELEMENTS = (
        E(
            "sip_uri",
            "sipURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "tel_uri",
            "telURI",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* sipURI
    sip_uri = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* telURI
    tel_uri = Field(
        type=str,
        required=False,
    )


class RandomPort(OCIType):
    """
    Represents either a random port number, or a specific port number.
    """

    _ELEMENTS = (
        E(
            "random",
            "random",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "port",
            "port",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* random
    random = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* port
    port = Field(
        type=int,
        required=False,
    )


class Recurrence(OCIType):
    """
    Defines recurrence.
    """

    _ELEMENTS = (
        E(
            "recur_daily",
            "recurDaily",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "recur_weekly",
            "recurWeekly",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "recur_monthly_by_day",
            "recurMonthlyByDay",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "recur_monthly_by_week",
            "recurMonthlyByWeek",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "recur_yearly_by_day",
            "recurYearlyByDay",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "recur_yearly_by_week",
            "recurYearlyByWeek",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "recur_for_ever",
            "recurForEver",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "recur_end_date",
            "recurEndDate",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "recur_end_occurrence",
            "recurEndOccurrence",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* recurDaily
    recur_daily = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* recurWeekly
    recur_weekly = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* recurMonthlyByDay
    recur_monthly_by_day = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* recurMonthlyByWeek
    recur_monthly_by_week = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* recurYearlyByDay
    recur_yearly_by_day = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* recurYearlyByWeek
    recur_yearly_by_week = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* recurForEver
    recur_for_ever = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* recurEndDate
    recur_end_date = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* recurEndOccurrence
    recur_end_occurrence = Field(
        type=int,
        required=False,
    )


class ReplacementCallProcessingPolicyProfileSubscriberTypeList(OCIType):
    """
    A list of CallProcessingPolicyProfileSubscriberType. The list replaces a
    previously configured list.
    """

    _ELEMENTS = (
        E(
            "subscriber_type",
            "subscriberType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* subscriberType
    subscriber_type = Field(
        type=str,
        required=True,
    )


class ReplacementCallProcessingPolicyProfileSubscriberTypeList20(OCIType):
    """
    A list of CallProcessingPolicyProfileSubscriberType20. The list replaces a
    previously configured list.
    """

    _ELEMENTS = (
        E(
            "subscriber_type",
            "subscriberType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* subscriberType
    subscriber_type = Field(
        type=str,
        required=True,
    )


class ReplacementCallProcessingPolicyProfileSubscriberTypeList21(OCIType):
    """
    A list of CallProcessingPolicyProfileSubscriberType21. The list replaces a
    previously configured list.
    """

    _ELEMENTS = (
        E(
            "subscriber_type",
            "subscriberType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* subscriberType
    subscriber_type = Field(
        type=str,
        required=True,
    )


class ReplacementCommunicationBarringAlternateCallIndicatorList(OCIType):
    """
    A list of Communication Barring Alternate Call Indicator that replaces
    a previously configured list. By convention, an element of this type
    may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "alternate_call_indicator",
            "alternateCallIndicator",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* alternateCallIndicator
    alternate_call_indicator = Field(
        type=str,
        required=True,
    )


class ReplacementCommunicationBarringCallTypeList(OCIType):
    """
    A list of Communication Barring Call Types that replaces a previously
    configured list. By convention, an element of this type may be set
    nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "call_type",
            "callType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* callType
    call_type = Field(
        type=str,
        required=True,
    )


class ReplacementContactList(OCIType):
    """
    A list of SIP contacts that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "contact",
            "contact",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* contact
    contact = Field(
        type=str,
        required=True,
    )


class ReplacementDNList(OCIType):
    """
    A list of dns that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )


class ReplacementEnterpriseTrunkTrunkGroupList(OCIType):
    """
    A list of Group Trunk Krunk Group Names that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "trunk_group",
            "trunkGroup",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* trunkGroup
    trunk_group = Field(
        type=str,
        required=True,
    )


class ReplacementGroupEnterpriseTrunkTrunkGroupList(OCIType):
    """
    A list of Group Trunk Krunk Group Names that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "trunk_group",
            "trunkGroup",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* trunkGroup
    trunk_group = Field(
        type=str,
        required=True,
    )


class ReplacementMediaNameList(OCIType):
    """
    A list of media that replaces a previously configured list.
    """

    _ELEMENTS = (
        E(
            "media_name",
            "mediaName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mediaName
    media_name = Field(
        type=str,
        required=True,
    )


class ReplacementNumberPortabilityStatusList(OCIType):
    """
    A list of Number Portability Query Statuses that replaces a previously
    configured list. By convention, an element of this type may be set
    to nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "status",
            "status",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* status
    status = Field(
        type=str,
        required=True,
    )


class ReplacementOCICallControlApplicationIdList(OCIType):
    """
    A list of applicationIds that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "application_id",
            "applicationId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* applicationId
    application_id = Field(
        type=str,
        required=True,
    )


class ReplacementOutgoingDNList(OCIType):
    """
    A list of outgoing dns that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )


class ReplacementOutgoingDNorSIPURIList(OCIType):
    """
    A list of phone numbers or sipuris that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )


class ReplacementSIPAliasList(OCIType):
    """
    A list of SIP aliases that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "sip_alias",
            "sipAlias",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* sipAlias
    sip_alias = Field(
        type=str,
        required=True,
    )


class ReplacementServicePackNameList(OCIType):
    """
    A list of service packs that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "service_pack_name",
            "servicePackName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* servicePackName
    service_pack_name = Field(
        type=str,
        required=True,
    )


class ReplacementUserIdList(OCIType):
    """
    A list of userIds that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class ReplacementUserServiceList(OCIType):
    """
    A list of user services that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "service_name",
            "serviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceName
    service_name = Field(
        type=str,
        required=True,
    )


class ReplacementVirtualOnNetCallTypeNameList(OCIType):
    """
    A list of Virtual On-Net Call Types that replaces a previously
    configured list. By convention, an element of this type may be set
    to nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "virtual_on_net_call_type_name",
            "virtualOnNetCallTypeName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* virtualOnNetCallTypeName
    virtual_on_net_call_type_name = Field(
        type=str,
        required=True,
    )


class ReplacementZoneList(OCIType):
    """
    Contains an ordered list of zones to use to replace the current list of zones in
    an Office Zone.
    """

    _ELEMENTS = (
        E(
            "zone_name",
            "zoneName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* zoneName
    zone_name = Field(
        type=str,
        required=True,
    )


class ResponsePagingControl(OCIType):
    """
    Used in queries to restrict the set of result rows when making a request that can
    result in
    a large dataset. The client specifies the starting row and the number of rows requested.
    The server only provides those rows in results, if available.
    """

    _ELEMENTS = (
        E(
            "response_start_index",
            "responseStartIndex",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "response_page_size",
            "responsePageSize",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* responseStartIndex
    response_start_index = Field(
        type=int,
        required=True,
    )
    #: int: *Required* responsePageSize
    response_page_size = Field(
        type=int,
        required=True,
    )


class ScheduleKey(OCIType):
    """
    Uniquely identifies Holiday and Time Schedules within a level(System, Service
    Provider, Group or User level).
    """

    _ELEMENTS = (
        E(
            "schedule_name",
            "scheduleName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "schedule_type",
            "scheduleType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* scheduleName
    schedule_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* scheduleType
    schedule_type = Field(
        type=str,
        required=True,
    )


class SearchCriteria(OCIType):
    """
    Abstract base type for specifying search criteria. A search criteria is an
    optional element
    used to restrict the number of rows returned when requesting a potentially large set of
    data from the provisioning server.
    """

    _ELEMENTS = ()


class SearchCriteriaAccessDeviceEndpointPrivateIdentity(OCIType):
    """
    Criteria for searching for a private identity.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaAccessDeviceVersion(OCIType):
    """
    Criteria for searching for an Access Device Version.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaAgentThresholdProfile(OCIType):
    """
    Criteria for searching a Call Center Agent Threshold Profile.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaAlternateTrunkIdentity(OCIType):
    """
    Criteria for searching for a particular fully specified alternate trunk identity.
    In IMS mode, it only applies to the user part of alternate trunk identity.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaAlternateTrunkIdentityDomain(OCIType):
    """
    Criteria for searching for alternate trunk identity domain part.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaAnnouncementFileName(OCIType):
    """
    Criteria for searching for an Announcement File Name.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaCallCenterName(OCIType):
    """
    Criteria for searching for a call center
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaCallCenterReportTemplateName(OCIType):
    """
    Criteria for searching for a particular call center enhanced reporting report template.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaCallCenterScheduledReportName(OCIType):
    """
    Criteria for searching for a call center enhanced reporting scheduled report name.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaDepartmentName(OCIType):
    """
    Criteria for searching for a user's department.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaDeviceMACAddress(OCIType):
    """
    Criteria for searching for device MAC address.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaDeviceManagementEventAdditionalInfo(OCIType):
    """
    Criteria for searching for a particular additional info of a DeviceManagement event.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaDeviceManagementEventLoginId(OCIType):
    """
    Criteria for searching for a particular login id.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaDeviceName(OCIType):
    """
    Criteria for searching for device name.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaDeviceNetAddress(OCIType):
    """
    Criteria for searching for device network address.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaDeviceSerialNumber(OCIType):
    """
    Criteria for searching for device serial number.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaDeviceType(OCIType):
    """
    Criteria for searching for device type.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaDigitPattern(OCIType):
    """
    Criteria for searching for digit pattern.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaDn(OCIType):
    """
    Criteria for searching for a DN.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaEmailAddress(OCIType):
    """
    Criteria for searching for a email address.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaEnterpriseCommonPhoneListName(OCIType):
    """
    Criteria for searching for a name in an enterprise common phone list.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaEnterpriseCommonPhoneListNumber(OCIType):
    """
    Criteria for searching for a phone number in an enterprise common phone list.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaEnterpriseTrunkName(OCIType):
    """
    Criteria for searching for an Enterprise Trunk name.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaExactCallCenterScheduledReportCreatedBySupervisor(OCIType):
    """
    Criteria for searching for call center scheduled report created by a
    supervisor or administrator.
    """

    _ELEMENTS = (
        E(
            "created_by_supervisor",
            "createdBySupervisor",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* createdBySupervisor
    created_by_supervisor = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaExactCallCenterScheduledReportGroup(OCIType):
    """
    Criteria for searching for a particular fully specified call center scheduled
    report's group.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactCallCenterScheduledReportServiceProvider(OCIType):
    """
    Criteria for searching for a particular call center scheduled report's service provider.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactCustomContactDirectory(OCIType):
    """
    Criteria for searching for a particular fully specified custom contact directory.
    """

    _ELEMENTS = (
        E(
            "custom_contact_directory_name",
            "customContactDirectoryName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* customContactDirectoryName
    custom_contact_directory_name = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactDeviceLevel(OCIType):
    """
    Criteria for searching for a particular device level.
    """

    _ELEMENTS = (
        E(
            "device_level",
            "deviceLevel",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* deviceLevel
    device_level = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactDeviceManagementEventAction(OCIType):
    """
    Criteria for searching for a particular fully specified DeviceManagement event action.
    """

    _ELEMENTS = (
        E(
            "dm_event_action",
            "dmEventAction",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* dmEventAction
    dm_event_action = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactDeviceManagementEventLevel(OCIType):
    """
    Criteria for searching for a particular fully specified DeviceManagement event level.
    """

    _ELEMENTS = (
        E(
            "dm_event_level",
            "dmEventLevel",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* dmEventLevel
    dm_event_level = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactDeviceManagementEventStatusCompleted(OCIType):
    """
    Criteria for searching for a particular fully specified Device Management
    completed event status.
    """

    _ELEMENTS = (
        E(
            "dm_event_status_completed",
            "dmEventStatusCompleted",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* dmEventStatusCompleted
    dm_event_status_completed = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactDeviceManagementEventStatusInProgressOrPending(OCIType):
    """
    Criteria for searching for a particular fully specified Device Management event
    in progress or pending status.
    """

    _ELEMENTS = (
        E(
            "dm_event_status_in_progress_or_pending",
            "dmEventStatusInProgressOrPending",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* dmEventStatusInProgressOrPending
    dm_event_status_in_progress_or_pending = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactDeviceManagementEventType(OCIType):
    """
    Criteria for searching for a particular fully specified DeviceManagement event type.
    """

    _ELEMENTS = (
        E(
            "dm_event_type",
            "dmEventType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* dmEventType
    dm_event_type = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactDeviceServiceProvider(OCIType):
    """
    Criteria for searching for a particular fully specified service provider
    associated with a device.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactDeviceType(OCIType):
    """
    Criteria for searching for a particular fully specified device type.
    """

    _ELEMENTS = (
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactDnActivation(OCIType):
    """
    Criteria for searching for a particular Dn activation state.
    """

    _ELEMENTS = (
        E(
            "activated",
            "activated",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* activated
    activated = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaExactEndpointType(OCIType):
    """
    Criteria for searching for a particular endpoint type.
    """

    _ELEMENTS = (
        E(
            "endpoint_type",
            "endpointType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* endpointType
    endpoint_type = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactMobileNetwork(OCIType):
    """
    Criteria for searching for a particular BroadWorks Mobility Mobile Network.
    """

    _ELEMENTS = (
        E(
            "mobile_network_name",
            "mobileNetworkName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mobileNetworkName
    mobile_network_name = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactOrganizationType(OCIType):
    """
    Criteria for searching for an organization type.
    """

    _ELEMENTS = (
        E(
            "organization_type",
            "organizationType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* organizationType
    organization_type = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactPolicySelection(OCIType):
    """
    Criteria for searching for a particular Voice VPN policy selection.
    """

    _ELEMENTS = (
        E(
            "policy_selection",
            "policySelection",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* policySelection
    policy_selection = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactPortNumber(OCIType):
    """
    Criteria for searching for a port number.
    """

    _ELEMENTS = (
        E(
            "port",
            "port",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* port
    port = Field(
        type=int,
        required=True,
    )


class SearchCriteriaExactServiceProvider(OCIType):
    """
    Criteria for searching for a particular fully specified service provider.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactServiceType(OCIType):
    """
    Criteria for searching for a particular fully specified service type.
    """

    _ELEMENTS = (
        E(
            "service_type",
            "serviceType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceType
    service_type = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactSignalingAddressType(OCIType):
    """
    Criteria for searching for a particular fully specified SignalingAddressType.
    """

    _ELEMENTS = (
        E(
            "profile",
            "profile",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* profile
    profile = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactSkillLevel(OCIType):
    """
    Criteria for searching for a skill Level.
    """

    _ELEMENTS = (
        E(
            "skill_level",
            "skillLevel",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* skillLevel
    skill_level = Field(
        type=int,
        required=True,
    )


class SearchCriteriaExactUserGroup(OCIType):
    """
    Criteria for searching for a particular fully specified user's group.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactUserInTrunkGroup(OCIType):
    """
    Criteria for searching for user in/not in a trunk group.
    """

    _ELEMENTS = (
        E(
            "user_in_trunk_group",
            "userInTrunkGroup",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* userInTrunkGroup
    user_in_trunk_group = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaExactUserNetworkClassOfService(OCIType):
    """
    Criteria for searching for users with a specified network class of service.
    """

    _ELEMENTS = (
        E(
            "network_class_of_service",
            "networkClassOfService",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* networkClassOfService
    network_class_of_service = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactUserRouteListAssigned(OCIType):
    """
    Criteria for searching for users with/without Route List feature assigned.
    """

    _ELEMENTS = (
        E(
            "route_list_assigned",
            "routeListAssigned",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* routeListAssigned
    route_list_assigned = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaExactUserRouteListAssignment(OCIType):
    """
    Criteria for searching for users with Route List feature assignment.
    """

    _ELEMENTS = (
        E(
            "assigned",
            "assigned",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* assigned
    assigned = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaExactUserType(OCIType):
    """
    Criteria for searching for a particular User Type.
    """

    _ELEMENTS = (
        E(
            "user_type",
            "userType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userType
    user_type = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactVirtualOnNetCallTypeName(OCIType):
    """
    Criteria for searching for a particular fully specified Virtual On-Net Call Type Name.
    """

    _ELEMENTS = (
        E(
            "virtual_on_net_call_type_name",
            "virtualOnNetCallTypeName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* virtualOnNetCallTypeName
    virtual_on_net_call_type_name = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExtension(OCIType):
    """
    Criteria for searching for an extension.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaGroupCommonPhoneListName(OCIType):
    """
    Criteria for searching for a name in a group common phone list.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaGroupCommonPhoneListNumber(OCIType):
    """
    Criteria for searching for a phone number in a group common phone list.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaGroupId(OCIType):
    """
    Criteria for searching for a group ID.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaGroupLocationCode(OCIType):
    """
    Criteria for searching for a group location dialing code.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaGroupName(OCIType):
    """
    Criteria for searching for a group name.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaHomeMscAddress(OCIType):
    """
    Criteria for searching for a system Home Network Msc Address.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaIMRN(OCIType):
    """
    Criteria for searching for an IMRN Number.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaImpId(OCIType):
    """
    Criteria for searching for a user's IMP Id.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaLinePortDomain(OCIType):
    """
    Criteria for searching for device line/port, or SIPURI domain part.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaLinePortUserPart(OCIType):
    """
    Criteria for searching for device line/port, or SIPURI user part.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaLoginId(OCIType):
    """
    Criteria for searching for a Login Id.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaMobilePhoneNumber(OCIType):
    """
    Criteria for searching for a user's mobile phone number.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaMobileSubscriberDirectoryNumber(OCIType):
    """
    Criteria for searching for a BroadWorks Mobility Mobile Subscriber Directory Number.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaNumberPortabilityQueryDigitPattern(OCIType):
    """
    Criteria for searching for digit pattern.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaNumberPortabilityStatus(OCIType):
    """
    Criteria for searching for number portability status.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaOutgoingDNorSIPURI(OCIType):
    """
    Criteria for searching for a phone number or SIPURI.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaPersonalAssistantExclusionNumber(OCIType):
    """
    Criteria for searching for Personal Assistant Exclusion Number.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaPersonalAssistantExclusionNumberDescription(OCIType):
    """
    Criteria for searching Personal Assistant Exclusion Number's Description.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaPhysicalLocation(OCIType):
    """
    Criteria for searching for a Physical Location.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaRegistrationURI(OCIType):
    """
    Criteria for searching for a RegistrationURI.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaRoamingMscAddress(OCIType):
    """
    Criteria for searching for a system Roaming Network Msc Address.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaRoutePointName(OCIType):
    """
    Criteria for searching for a route point
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaSIPContact(OCIType):
    """
    Criteria for searching for a SIP Contact.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaServiceCode(OCIType):
    """
    Criteria for searching for a Service Code.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaServiceCodeDescription(OCIType):
    """
    Criteria for searching for a Service Code description.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaServiceInstanceName(OCIType):
    """
    Criteria for searching for a service instance name.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaServiceProviderId(OCIType):
    """
    Criteria for searching for a service provider ID.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaServiceProviderName(OCIType):
    """
    Criteria for searching for a service provider name.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaServiceProviderNumberPortabilityQueryDigitPattern(OCIType):
    """
    Criteria for searching for digit pattern.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaSystemServiceDn(OCIType):
    """
    Criteria for searching for a system service DN.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaTrunkGroupName(OCIType):
    """
    Criteria for searching for a trunk group
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaUserFirstName(OCIType):
    """
    Criteria for searching for a user's first name.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaUserId(OCIType):
    """
    Criteria for searching for a user's userId.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaUserLastName(OCIType):
    """
    Criteria for searching for a user's last name.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaUserPersonalPhoneListName(OCIType):
    """
    Criteria for searching for a name in a user personal phone list.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaUserPersonalPhoneListNumber(OCIType):
    """
    Criteria for searching for a phone number in a user personal phone list.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaYahooId(OCIType):
    """
    Criteria for searching for a user's yahoo id.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SearchCriteriaZoneIPAddress(OCIType):
    """
    Criteria for searching for a system zone's IP Address.
    """

    _ELEMENTS = (
        E(
            "mode",
            "mode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "value",
            "value",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_insensitive",
            "isCaseInsensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mode
    mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* value
    value = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isCaseInsensitive
    is_case_insensitive = Field(
        type=bool,
        required=True,
    )


class SelectiveCallRejectionCriteriaCallType(OCIType):
    """
    The call type criteria used within an add/get request.
    """

    _ELEMENTS = (
        E(
            "from_dn_criteria_selection",
            "fromDnCriteriaSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_anonymous_callers",
            "includeAnonymousCallers",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_unavailable_callers",
            "includeUnavailableCallers",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* fromDnCriteriaSelection
    from_dn_criteria_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* includeAnonymousCallers
    include_anonymous_callers = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeUnavailableCallers
    include_unavailable_callers = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )


class SequentialRingLocation(OCIType):
    """
    Sequential Ring Location.
    Replaced By SequentialRingLocation14sp4
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_of_rings",
            "numberOfRings",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: int: *Required* numberOfRings
    number_of_rings = Field(
        type=int,
        required=True,
    )


class SequentialRingLocation14sp4(OCIType):
    """
    Sequential Ring Location.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_of_rings",
            "numberOfRings",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "answer_confirmation_required",
            "answerConfirmationRequired",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: int: *Required* numberOfRings
    number_of_rings = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* answerConfirmationRequired
    answer_confirmation_required = Field(
        type=bool,
        required=True,
    )


class SequentialRingLocationModify(OCIType):
    """
    Sequential Ring Location.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_of_rings",
            "numberOfRings",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "answer_confirmation_required",
            "answerConfirmationRequired",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* numberOfRings
    number_of_rings = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* answerConfirmationRequired
    answer_confirmation_required = Field(
        type=bool,
        required=False,
    )


class ServiceActivation(OCIType):
    """
    Service Instance active status indicator
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )


class ServiceProviderCommunicationBarringHierarchicalCallMeNowRule(OCIType):
    """
    Service Provider Communication Barring Hierarchical Call Me Now Rule
    """

    _ELEMENTS = (
        E(
            "criteria",
            "criteria",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "digit_pattern_criteria",
            "digitPatternCriteria",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_timeout_seconds",
            "callTimeoutSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_schedule",
            "timeSchedule",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "holiday_schedule",
            "holidaySchedule",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "priority",
            "priority",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* criteria
    criteria = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* digitPatternCriteria
    digit_pattern_criteria = Field(
        type=str,
        required=False,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* callTimeoutSeconds
    call_timeout_seconds = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* timeSchedule
    time_schedule = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* holidaySchedule
    holiday_schedule = Field(
        type=str,
        required=False,
    )
    #: str: *Required* priority
    priority = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringHierarchicalOriginatingRule(OCIType):
    """
    Service Provider Communication Barring Hierarchical Originating Rule
    """

    _ELEMENTS = (
        E(
            "criteria",
            "criteria",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "digit_pattern_criteria",
            "digitPatternCriteria",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "treatment_id",
            "treatmentId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "transfer_number",
            "transferNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_timeout_seconds",
            "callTimeoutSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_schedule",
            "timeSchedule",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "holiday_schedule",
            "holidaySchedule",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "priority",
            "priority",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* criteria
    criteria = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* digitPatternCriteria
    digit_pattern_criteria = Field(
        type=str,
        required=False,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* treatmentId
    treatment_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* transferNumber
    transfer_number = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* callTimeoutSeconds
    call_timeout_seconds = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* timeSchedule
    time_schedule = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* holidaySchedule
    holiday_schedule = Field(
        type=str,
        required=False,
    )
    #: str: *Required* priority
    priority = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringHierarchicalRedirectingRule(OCIType):
    """
    Service Provider Communication Barring Hierarchical Redirecting Rule
    """

    _ELEMENTS = (
        E(
            "criteria",
            "criteria",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "digit_pattern_criteria",
            "digitPatternCriteria",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_timeout_seconds",
            "callTimeoutSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_schedule",
            "timeSchedule",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "holiday_schedule",
            "holidaySchedule",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "priority",
            "priority",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* criteria
    criteria = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* digitPatternCriteria
    digit_pattern_criteria = Field(
        type=str,
        required=False,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* callTimeoutSeconds
    call_timeout_seconds = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* timeSchedule
    time_schedule = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* holidaySchedule
    holiday_schedule = Field(
        type=str,
        required=False,
    )
    #: str: *Required* priority
    priority = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringProfileGetRequest19sp1V2(OCIType):
    """
    Get an existing Communication Barring Profile.
    The response is either a ServiceProviderCommunicationBarringProfileGetResponse19sp1V2
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class ServiceScriptsFileResource(OCIType):
    """
    Service Scripts File Resource for uploading file content.
    """

    _ELEMENTS = (
        E(
            "file_name",
            "fileName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "script_content",
            "scriptContent",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* fileName
    file_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* scriptContent
    script_content = Field(
        type=str,
        required=True,
    )


class SimultaneousRingNumber(OCIType):
    """
    Simultaneous Ring number entry.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "answer_confirmation_required",
            "answerConfirmationRequired",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* answerConfirmationRequired
    answer_confirmation_required = Field(
        type=bool,
        required=True,
    )


class SortByEnterpriseCommonPhoneListName(OCIType):
    """
    The sort criteria specifies the enterprise common phone list name as the
    column for the sort, whether sort is ascending or descending, and
    whether the sort is case sensitive.
    """

    _ELEMENTS = (
        E(
            "is_ascending",
            "isAscending",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_sensitive",
            "isCaseSensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isAscending
    is_ascending = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(
        type=bool,
        required=True,
    )


class SortByEnterpriseCommonPhoneListNumber(OCIType):
    """
    The sort criteria specifies the enterprise common phone list number as as the column
    for the sort, whether sort is ascending or descending, and whether the sort is
    case sensitive.
    """

    _ELEMENTS = (
        E(
            "is_ascending",
            "isAscending",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_sensitive",
            "isCaseSensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isAscending
    is_ascending = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(
        type=bool,
        required=True,
    )


class SortByGroupCommonPhoneListName(OCIType):
    """
    The sort criteria specifies the group common phone list name as the column for
    the sort, whether
    the sort is ascending or descending, and whether the sort is case sensitive.
    """

    _ELEMENTS = (
        E(
            "is_ascending",
            "isAscending",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_sensitive",
            "isCaseSensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isAscending
    is_ascending = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(
        type=bool,
        required=True,
    )


class SortByGroupCommonPhoneListNumber(OCIType):
    """
    The sort criteria specifies the group common phone list number as the column for
    the sort, whether
    sort is ascending or descending, and whether the sort is case sensitive.
    """

    _ELEMENTS = (
        E(
            "is_ascending",
            "isAscending",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_sensitive",
            "isCaseSensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isAscending
    is_ascending = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(
        type=bool,
        required=True,
    )


class SortByUserDepartment(OCIType):
    """
    The sort criteria specifies the user department name as the column for the sort,
    whether the
    sort is ascending or descending, and whether the sort is case sensitive.
    """

    _ELEMENTS = (
        E(
            "is_ascending",
            "isAscending",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_sensitive",
            "isCaseSensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isAscending
    is_ascending = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(
        type=bool,
        required=True,
    )


class SortByUserFirstName(OCIType):
    """
    The sort criteria specifies the user first name as the column for the sort, whether the
    sort is ascending or descending, and whether the sort is case sensitive.
    """

    _ELEMENTS = (
        E(
            "is_ascending",
            "isAscending",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_sensitive",
            "isCaseSensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isAscending
    is_ascending = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(
        type=bool,
        required=True,
    )


class SortByUserLastName(OCIType):
    """
    The sort criteria specifies the user last name as the column for the sort, whether the
    sort is ascending or descending, and whether the sort is case sensitive.
    """

    _ELEMENTS = (
        E(
            "is_ascending",
            "isAscending",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_sensitive",
            "isCaseSensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isAscending
    is_ascending = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(
        type=bool,
        required=True,
    )


class SortByUserPersonalPhoneListName(OCIType):
    """
    The sort criteria specifies the user personal phone list name as the column for
    the sort, whether
    sort is ascending or descending, and whether the sort is case sensitive.
    """

    _ELEMENTS = (
        E(
            "is_ascending",
            "isAscending",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_sensitive",
            "isCaseSensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isAscending
    is_ascending = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(
        type=bool,
        required=True,
    )


class SortByUserPersonalPhoneListNumber(OCIType):
    """
    The sort criteria specifies the user personal phone list number as the column for
    the sort, whether the sort is ascending or descending, and whether the
    sort is case sensitive.
    """

    _ELEMENTS = (
        E(
            "is_ascending",
            "isAscending",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_sensitive",
            "isCaseSensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isAscending
    is_ascending = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(
        type=bool,
        required=True,
    )


class SortCriteria(OCIType):
    """
    The sort criteria specifies whether sort is ascending or descending, and
    whether the sort is case sensitive. Sort order defaults to
    ascending and case sensitive.
    """

    _ELEMENTS = (
        E(
            "is_ascending",
            "isAscending",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_case_sensitive",
            "isCaseSensitive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isAscending
    is_ascending = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isCaseSensitive
    is_case_sensitive = Field(
        type=bool,
        required=True,
    )


class SpeedDial100Entry(OCIType):
    """
    Modify the speed dial 100 prefix setting for a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "speed_code",
            "speedCode",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: int: *Required* speedCode
    speed_code = Field(
        type=int,
        required=True,
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class SpeedDial100EntryModify(OCIType):
    """
    Modify the speed dial 100 prefix setting for a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "speed_code",
            "speedCode",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: int: *Required* speedCode
    speed_code = Field(
        type=int,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class SpeedDial8Entry(OCIType):
    """
    Modify the speed dial 8 prefix setting for a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "speed_code",
            "speedCode",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: int: *Required* speedCode
    speed_code = Field(
        type=int,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class StreetAddress(OCIType):
    """
    Street address information.
    """

    _ELEMENTS = (
        E(
            "address_line1",
            "addressLine1",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "address_line2",
            "addressLine2",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "city",
            "city",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "state_or_province",
            "stateOrProvince",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "state_or_province_display_name",
            "stateOrProvinceDisplayName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "zip_or_postal_code",
            "zipOrPostalCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "country",
            "country",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* addressLine1
    address_line1 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* addressLine2
    address_line2 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* city
    city = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* stateOrProvince
    state_or_province = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* stateOrProvinceDisplayName
    state_or_province_display_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* zipOrPostalCode
    zip_or_postal_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* country
    country = Field(
        type=str,
        required=False,
    )


class SystemCommunicationBarringProfileGetRequest19sp1V2(OCIType):
    """
    Get an existing Communication Barring Profile.
    The response is either a SystemCommunicationBarringProfileGetResponse19sp1V2
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class SystemSIPDeviceTypeGetRequest18sp1V2(OCIType):
    """
    Request to get a sip device type.
    See Also: ``SystemDeviceTypeGetRequest()``
    The response is either ``SystemSIPDeviceTypeGetResponse19()`` or ``ErrorResponse()``.

    Replaced By ``SystemSIPDeviceTypeGetRequest19()``.
    """

    _ELEMENTS = (
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )


class TimeInterval(OCIType):
    """
    Time Interval.
    """

    _ELEMENTS = (
        E(
            "start_day_of_week",
            "startDayOfWeek",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "start_hour",
            "startHour",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "start_minute",
            "startMinute",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "end_day_of_week",
            "endDayOfWeek",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "end_hour",
            "endHour",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "end_minute",
            "endMinute",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* startDayOfWeek
    start_day_of_week = Field(
        type=str,
        required=True,
    )
    #: int: *Required* startHour
    start_hour = Field(
        type=int,
        required=True,
    )
    #: int: *Required* startMinute
    start_minute = Field(
        type=int,
        required=True,
    )
    #: str: *Required* endDayOfWeek
    end_day_of_week = Field(
        type=str,
        required=True,
    )
    #: int: *Required* endHour
    end_hour = Field(
        type=int,
        required=True,
    )
    #: int: *Required* endMinute
    end_minute = Field(
        type=int,
        required=True,
    )


class TimeSchedule(OCIType):
    """
    The from dn criteria.
    """

    _ELEMENTS = (
        E(
            "type",
            "type",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* type
    type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class TrunkGroupDeviceEndpointAdd(OCIType):
    """
    Trunk group device endpoint used in the context of modify.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )


class TrunkGroupDeviceEndpointModify(OCIType):
    """
    Trunk group device endpoint used in the context of modify.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )


class TrunkGroupDeviceEndpointRead(OCIType):
    """
    Trunk group device endpoint.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "static_registration_capable",
            "staticRegistrationCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_domain",
            "useDomain",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useDomain
    use_domain = Field(
        type=bool,
        required=True,
    )


class TrunkGroupDeviceEndpointRead14sp4(OCIType):
    """
    Trunk group device endpoint.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "static_registration_capable",
            "staticRegistrationCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_domain",
            "useDomain",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_pilot_user",
            "isPilotUser",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useDomain
    use_domain = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isPilotUser
    is_pilot_user = Field(
        type=bool,
        required=True,
    )


class TrunkGroupDeviceMultipleContactEndpointAdd(OCIType):
    """
    Trunk group device endpoint used in the context of modify that can have multiple contacts.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )


class TrunkGroupDeviceMultipleContactEndpointRead(OCIType):
    """
    Trunk group device endpoint that can have multiple contacts.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "static_registration_capable",
            "staticRegistrationCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_domain",
            "useDomain",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_pilot_user",
            "isPilotUser",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useDomain
    use_domain = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isPilotUser
    is_pilot_user = Field(
        type=bool,
        required=True,
    )


class TrunkGroupKey(OCIType):
    """
    Uniquely identifies a Trunk Group system-wide.
    The trunkGroupName is unique within a group, but not unique system-wide.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class UnboundedNonNegativeInt(OCIType):
    """
    Unbounded Quantity. Can either be unlimited or a non-negative int quantity.
    """

    _ELEMENTS = (
        E(
            "unlimited",
            "unlimited",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "quantity",
            "quantity",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* unlimited
    unlimited = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* quantity
    quantity = Field(
        type=int,
        required=False,
    )


class UnboundedPositiveInt(OCIType):
    """
    Unbounded Quantity. Can either be unlimited or a positive int quantity.
    """

    _ELEMENTS = (
        E(
            "unlimited",
            "unlimited",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "quantity",
            "quantity",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* unlimited
    unlimited = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* quantity
    quantity = Field(
        type=int,
        required=False,
    )


class UserDisplayNames(OCIType):
    """
    The parts of a user's display name that a client can display in whatever way is
    appropriate
    for the client application.
    """

    _ELEMENTS = (
        E(
            "last_name",
            "lastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "first_name",
            "firstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "hiragana_last_name",
            "hiraganaLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_first_name",
            "hiraganaFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* lastName
    last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* firstName
    first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(
        type=str,
        required=False,
    )


class UserEndpointKey(OCIType):
    """
    Key to uniquely identify a user endpoint.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )


class UserEnhancedCallLogsGetListResponse17sp4V2(OCIType):
    """
    Response to UserEnhancedCallLogsGetListRequest17sp4V2.
    Total numbers of rows is:
    - the total number of retrievable logs of the call log type that was specified in
    the UserEnhancedCallLogsGetListRequest17sp4V2,
    if a call log type was specified in the request.
    - the total number of retrievable logs, if no call log type was specified in the request.
    A list of MixedCallLogsEntry will be returned if the call logs are stored on CDS
    A list of ExtendedMixedCallLogsEntry17sp4 will be returned if the call logs are
    stored on DBS
    The logs are sorted by date/time of the call.
    """

    _ELEMENTS = (
        E(
            "total_number_of_rows",
            "totalNumberOfRows",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "legacy_entry",
            "legacyEntry",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "extended_entry",
            "extendedEntry",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: int: *Required* totalNumberOfRows
    total_number_of_rows = Field(
        type=int,
        required=True,
    )
    #: str: *Optional* legacyEntry
    legacy_entry = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extendedEntry
    extended_entry = Field(
        type=str,
        required=False,
    )


class UserFeatureAccessCodeModifyEntry(OCIType):
    """
    Feature Access Code Entry to be used in all user modify command.
    """

    _ELEMENTS = (
        E(
            "feature_access_code_name",
            "featureAccessCodeName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_fac",
            "enableFAC",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* featureAccessCodeName
    feature_access_code_name = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* enableFAC
    enable_fac = Field(
        type=bool,
        required=False,
    )


class UserPreferredCarrierName(OCIType):
    """
    User can either use it's group's preferred carrier or use it's own.
    The user carrier name is exposed if it was previously configured.
    """

    _ELEMENTS = (
        E(
            "use_group_preferred_carrier",
            "useGroupPreferredCarrier",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "carrier",
            "carrier",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupPreferredCarrier
    use_group_preferred_carrier = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* carrier
    carrier = Field(
        type=str,
        required=False,
    )


class UserPreferredCarrierNameModify(OCIType):
    """
    User can either use it's group's preferred carrier or use it's own.
    You can use the group's preferred carrier without clearing the user carrier name --
    in this case, the user carrier name is retained.
    """

    _ELEMENTS = (
        E(
            "use_group_preferred_carrier",
            "useGroupPreferredCarrier",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "carrier",
            "carrier",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupPreferredCarrier
    use_group_preferred_carrier = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* carrier
    carrier = Field(
        type=str,
        required=False,
    )


class UserTwoStageDialingGetRequest13Mp20(OCIType):
    """
    Request the user level data associated with Two Stage Dialing.
    The response is either a UserTwoStageDialingGetResponse13Mp20 or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class UserTwoStageDialingGetResponse13Mp20(OCIType):
    """
    Response to UserTwoStageDialingGetRequest13Mp20.
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_activation_with_user_addresses",
            "allowActivationWithUserAddresses",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowActivationWithUserAddresses
    allow_activation_with_user_addresses = Field(
        type=bool,
        required=True,
    )


class VerifyTranslationAndRoutingOrigination(OCIType):
    """
    Verification Translation and Routing origination
    value.
    """

    _ELEMENTS = (
        E(
            "line_port",
            "linePort",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone",
            "phone",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "url",
            "url",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* linePort
    line_port = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phone
    phone = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userId
    user_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* url
    url = Field(
        type=str,
        required=False,
    )


class VirtualOnNetUser(OCIType):
    """
    Virtual On-Net User.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "first_name",
            "firstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "last_name",
            "lastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "virtual_on_net_call_type_name",
            "virtualOnNetCallTypeName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )
    #: str: *Required* extension
    extension = Field(
        type=str,
        required=True,
    )
    #: str: *Required* firstName
    first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* lastName
    last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* virtualOnNetCallTypeName
    virtual_on_net_call_type_name = Field(
        type=str,
        required=True,
    )


class VoiceMessagingAlternateNoAnswerGreetingRead(OCIType):
    """
    The configuration of a alternate no answer greeting.
    It is used when geting a user's voice messaging greeting.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFile
    audio_file = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFile
    video_file = Field(
        type=str,
        required=False,
    )


class VoiceMessagingAlternateNoAnswerGreetingRead16(OCIType):
    """
    The configuration of a alternate no answer greeting.
    It is used when geting a user's voice messaging greeting.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type",
            "audioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_media_type",
            "videoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFile
    audio_file = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMediaType
    audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFile
    video_file = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMediaType
    video_media_type = Field(
        type=str,
        required=False,
    )


class AccessDeviceEndpointAdd(OCIType):
    """
    Access device end point used in the context of add.
    Port numbers are only used by devices with static line ordering.
    """

    _ELEMENTS = (
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "port_number",
            "portNumber",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: AccessDevice: *Required* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* portNumber
    port_number = Field(
        type=int,
        required=False,
    )


class AccessDeviceEndpointKey(OCIType):
    """
    Access device end point in the context of a modify or delete command.
    """

    _ELEMENTS = (
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: AccessDevice: *Required* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )


class AccessDeviceEndpointModify(OCIType):
    """
    Access device end point used in the context of modify.
    Port numbers are only used by devices with static line ordering.
    """

    _ELEMENTS = (
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "port_number",
            "portNumber",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: AccessDevice: *Required* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* portNumber
    port_number = Field(
        type=int,
        required=False,
    )


class AccessDeviceEndpointRead14(OCIType):
    """
    Access device end point.
    """

    _ELEMENTS = (
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "static_registration_capable",
            "staticRegistrationCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_domain",
            "useDomain",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: AccessDevice: *Required* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useDomain
    use_domain = Field(
        type=bool,
        required=True,
    )


class AccessDeviceEndpointWithPortNumberRead(OCIType):
    """
    Access device end point.
    Port numbers are only used by devices with static line ordering.
    """

    _ELEMENTS = (
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "static_registration_capable",
            "staticRegistrationCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_domain",
            "useDomain",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "port_number",
            "portNumber",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: AccessDevice: *Required* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useDomain
    use_domain = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* portNumber
    port_number = Field(
        type=int,
        required=False,
    )


class AccessDeviceMultipleContactEndpointAdd(OCIType):
    """
    Access device end point used in the context of add that can have more than one
    contact defined.
    Only Static Registration capabable devices may have more than one contact defined.
    Port numbers are only used by devices with static line ordering.
    """

    _ELEMENTS = (
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "port_number",
            "portNumber",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: AccessDevice: *Required* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* portNumber
    port_number = Field(
        type=int,
        required=False,
    )


class AccessDeviceMultipleContactEndpointModify(OCIType):
    """
    Access device end point used in the context of modify that can have more than one
    contact defined.
    Only Static Registration capabable devices may have more than one contact defined.
    Port numbers are only used by devices with static line ordering.
    """

    _ELEMENTS = (
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            False,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "contact_list",
            "contactList",
            ReplacementContactList,
            True,
            False,
            False,
            False,
        ),
        E(
            "port_number",
            "portNumber",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: AccessDevice: *Optional* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=False,
    )
    #: str: *Optional* linePort
    line_port = Field(
        type=str,
        required=False,
    )
    #: ReplacementContactList: *Optional* contactList
    contact_list = Field(
        type=ReplacementContactList,
        required=False,
    )
    #: int: *Optional* portNumber
    port_number = Field(
        type=int,
        required=False,
    )


class AccessDeviceMultipleContactEndpointRead(OCIType):
    """
    Access device end point that can have multiple contacts.

    Replaced by AccessDeviceMultipleContactEndpointRead19.
    """

    _ELEMENTS = (
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "static_registration_capable",
            "staticRegistrationCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_domain",
            "useDomain",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: AccessDevice: *Required* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useDomain
    use_domain = Field(
        type=bool,
        required=True,
    )


class AccessDeviceMultipleContactEndpointRead19(OCIType):
    """
    Access device end point that can have multiple contacts.
    Port numbers are only used by devices with static line ordering.

    Replaced by AccessDeviceMultipleContactEndpointRead20.
    """

    _ELEMENTS = (
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "static_registration_capable",
            "staticRegistrationCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_domain",
            "useDomain",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "port_number",
            "portNumber",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: AccessDevice: *Required* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useDomain
    use_domain = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* portNumber
    port_number = Field(
        type=int,
        required=False,
    )


class AccessDeviceMultipleContactEndpointRead20(OCIType):
    """
    Access device end point that can have multiple contacts.
    Port numbers are only used by devices with static line ordering.
    """

    _ELEMENTS = (
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "static_registration_capable",
            "staticRegistrationCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_domain",
            "useDomain",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "port_number",
            "portNumber",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "support_visual_device_management",
            "supportVisualDeviceManagement",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: AccessDevice: *Required* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useDomain
    use_domain = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* portNumber
    port_number = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* supportVisualDeviceManagement
    support_visual_device_management = Field(
        type=bool,
        required=True,
    )


class AccessDeviceMultipleIdentityAndContactEndpointRead(OCIType):
    """
    Access device end point that can have multiple contacts.
    The endpoint is identified by its linePort (public Identity) and possibly a
    private Identity.
    Port numbers are only used by devices with static line ordering.
    The following elements are only used in HSS data mode and not returned in AS data mode:
    privateIdentity
    The following elements are only used in AS data mode and a value false is
    returned in the HSS mode:
    supportVisualDeviceManagement
    """

    _ELEMENTS = (
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "private_identity",
            "privateIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "static_registration_capable",
            "staticRegistrationCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_domain",
            "useDomain",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "port_number",
            "portNumber",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "support_visual_device_management",
            "supportVisualDeviceManagement",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: AccessDevice: *Required* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* privateIdentity
    private_identity = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useDomain
    use_domain = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* portNumber
    port_number = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* supportVisualDeviceManagement
    support_visual_device_management = Field(
        type=bool,
        required=True,
    )


class AutoAttendantKeyConfigurationEntry(OCIType):
    """
    The configuration entry of a key for Auto Attendant.
    The following data elements are only used in AS data mode:
    audioFile
    videoFile
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: LabeledMediaFileResource: *Optional* audioFile
    audio_file = Field(
        type=LabeledMediaFileResource,
        required=False,
    )
    #: LabeledMediaFileResource: *Optional* videoFile
    video_file = Field(
        type=LabeledMediaFileResource,
        required=False,
    )


class AutoAttendantKeyConfigurationEntry19(OCIType):
    """
    The configuration entry of a key for Auto
    Attendant.
    The following data elements are only used in
    AS data
    mode:
    audioFile
    videoFile
    submenuId
    The following data elements are only valid for Standard Auto
    Attendants:
    submenuId
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "submenu_id",
            "submenuId",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: LabeledMediaFileResource: *Optional* audioFile
    audio_file = Field(
        type=LabeledMediaFileResource,
        required=False,
    )
    #: LabeledMediaFileResource: *Optional* videoFile
    video_file = Field(
        type=LabeledMediaFileResource,
        required=False,
    )
    #: str: *Optional* submenuId
    submenu_id = Field(
        type=str,
        required=False,
    )


class AutoAttendantKeyConfigurationEntry20(OCIType):
    """
    The configuration entry of a key for Auto Attendant.
    The following data elements are only used in AS data mode:
    audioFile
    videoFile
    submenuId
    The following data elements are only valid for Standard Auto
    Attendants:
    submenuId
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "submenu_id",
            "submenuId",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* audioFile
    audio_file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* videoFile
    video_file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: str: *Optional* submenuId
    submenu_id = Field(
        type=str,
        required=False,
    )


class AutoAttendantKeyConfigurationModifyEntry(OCIType):
    """
    The modify configuration entry of a key for Auto
    Attendant.
    The following data elements are only
    used in AS data
    mode:
    audioFile
    videoFile
    submenuId
    The following data elements are only valid for Standard Auto
    Attendants:
    submenuId
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "submenu_id",
            "submenuId",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: LabeledMediaFileResource: *Optional* audioFile
    audio_file = Field(
        type=LabeledMediaFileResource,
        required=False,
    )
    #: LabeledMediaFileResource: *Optional* videoFile
    video_file = Field(
        type=LabeledMediaFileResource,
        required=False,
    )
    #: str: *Optional* submenuId
    submenu_id = Field(
        type=str,
        required=False,
    )


class AutoAttendantKeyConfigurationModifyEntry20(OCIType):
    """
    The modify configuration entry of a key for Auto Attendant.
    The following data elements are only used in AS data mode:
    audioFile
    videoFile
    submenuId
    The following data elements are only valid for Standard Auto
    Attendants:
    submenuId
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "submenu_id",
            "submenuId",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* audioFile
    audio_file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* videoFile
    video_file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: str: *Optional* submenuId
    submenu_id = Field(
        type=str,
        required=False,
    )


class AutoAttendantKeyConfigurationReadEntry20(OCIType):
    """
    The read configuration entry of a key for Auto Attendant.
    The following data elements are only used in AS data mode:
    submenuId
    The following data elements are only valid for Standard Auto
    Attendants:
    submenuId
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "submenu_id",
            "submenuId",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* audioFile
    audio_file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* videoFile
    video_file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: str: *Optional* submenuId
    submenu_id = Field(
        type=str,
        required=False,
    )


class AutoAttendantKeyReadConfiguration(OCIType):
    """
    The read configuration of a key for Auto Attendant.
    """

    _ELEMENTS = (
        E(
            "key",
            "key",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "entry",
            "entry",
            AutoAttendantKeyConfigurationReadEntry,
            True,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* key
    key = Field(
        type=str,
        required=True,
    )
    #: AutoAttendantKeyConfigurationReadEntry: *Required* entry
    entry = Field(
        type=AutoAttendantKeyConfigurationReadEntry,
        required=True,
    )


class AutoAttendantKeyReadConfiguration19(OCIType):
    """
    The read configuration of a key for Auto
    Attendant.
    """

    _ELEMENTS = (
        E(
            "key",
            "key",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "entry",
            "entry",
            AutoAttendantKeyConfigurationReadEntry19,
            True,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* key
    key = Field(
        type=str,
        required=True,
    )
    #: AutoAttendantKeyConfigurationReadEntry19: *Required* entry
    entry = Field(
        type=AutoAttendantKeyConfigurationReadEntry19,
        required=True,
    )


class CPEDeviceOptionsRead(OCIType):
    """
    CPE device's options.
    """

    _ELEMENTS = (
        E(
            "enable_monitoring",
            "enableMonitoring",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "reset_event",
            "resetEvent",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "config_type",
            "configType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "system_file_name",
            "systemFileName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_file_format",
            "deviceFileFormat",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_management_device_type_options",
            "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptionsRead,
            True,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* enableMonitoring
    enable_monitoring = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* resetEvent
    reset_event = Field(
        type=str,
        required=False,
    )
    #: str: *Required* configType
    config_type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* systemFileName
    system_file_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* deviceFileFormat
    device_file_format = Field(
        type=str,
        required=False,
    )
    #: DeviceManagementDeviceTypeOptionsRead: *Optional*
    #: deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeOptionsRead,
        required=False,
    )


class CPEDeviceOptionsRead16(OCIType):
    """
    CPE device's options.
    """

    _ELEMENTS = (
        E(
            "enable_monitoring",
            "enableMonitoring",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "reset_event",
            "resetEvent",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "config_type",
            "configType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "system_file_name",
            "systemFileName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_file_format",
            "deviceFileFormat",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_management_device_type_options",
            "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptionsRead16,
            True,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* enableMonitoring
    enable_monitoring = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* resetEvent
    reset_event = Field(
        type=str,
        required=False,
    )
    #: str: *Required* configType
    config_type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* systemFileName
    system_file_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* deviceFileFormat
    device_file_format = Field(
        type=str,
        required=False,
    )
    #: DeviceManagementDeviceTypeOptionsRead16: *Optional*
    #: deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeOptionsRead16,
        required=False,
    )


class CPEDeviceOptionsRead16sp1(OCIType):
    """
    CPE device's options.
    """

    _ELEMENTS = (
        E(
            "enable_monitoring",
            "enableMonitoring",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "config_type",
            "configType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "system_file_name",
            "systemFileName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_file_format",
            "deviceFileFormat",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_management_device_type_options",
            "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptionsRead16,
            True,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* enableMonitoring
    enable_monitoring = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* configType
    config_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* systemFileName
    system_file_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* deviceFileFormat
    device_file_format = Field(
        type=str,
        required=False,
    )
    #: DeviceManagementDeviceTypeOptionsRead16: *Optional*
    #: deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeOptionsRead16,
        required=False,
    )


class CallCenterAgentStatistics13mp8(OCIType):
    """
    Contains Call Center statistics for a specified agent.
    """

    _ELEMENTS = (
        E(
            "agent_user_id",
            "agentUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "agent_display_names",
            "agentDisplayNames",
            UserDisplayNames,
            True,
            True,
            False,
            False,
        ),
        E(
            "available",
            "available",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "statistics_yesterday",
            "statisticsYesterday",
            CallCenterAgentDailyStatistics13mp8,
            True,
            True,
            False,
            False,
        ),
        E(
            "statistics_today",
            "statisticsToday",
            CallCenterAgentDailyStatistics13mp8,
            True,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* agentUserId
    agent_user_id = Field(
        type=str,
        required=True,
    )
    #: UserDisplayNames: *Required* agentDisplayNames
    agent_display_names = Field(
        type=UserDisplayNames,
        required=True,
    )
    #: bool: *Required* available
    available = Field(
        type=bool,
        required=True,
    )
    #: CallCenterAgentDailyStatistics13mp8: *Required* statisticsYesterday
    statistics_yesterday = Field(
        type=CallCenterAgentDailyStatistics13mp8,
        required=True,
    )
    #: CallCenterAgentDailyStatistics13mp8: *Required* statisticsToday
    statistics_today = Field(
        type=CallCenterAgentDailyStatistics13mp8,
        required=True,
    )


class CallCenterAgentStatistics14sp9(OCIType):
    """
    Contains Call Center statistics for a specified agent.
    """

    _ELEMENTS = (
        E(
            "agent_user_id",
            "agentUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "agent_display_names",
            "agentDisplayNames",
            UserDisplayNames,
            True,
            True,
            False,
            False,
        ),
        E(
            "available",
            "available",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "statistics",
            "statistics",
            AgentStatistics,
            True,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* agentUserId
    agent_user_id = Field(
        type=str,
        required=True,
    )
    #: UserDisplayNames: *Required* agentDisplayNames
    agent_display_names = Field(
        type=UserDisplayNames,
        required=True,
    )
    #: bool: *Required* available
    available = Field(
        type=bool,
        required=True,
    )
    #: AgentStatistics: *Required* statistics
    statistics = Field(
        type=AgentStatistics,
        required=True,
    )


class CallCenterAnnouncementFileListModify(OCIType):
    """
    Contains a list of audio or video files to modify.
    """

    _ELEMENTS = (
        E(
            "file1",
            "file1",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "file2",
            "file2",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "file3",
            "file3",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "file4",
            "file4",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
    )
    #: LabeledMediaFileResource: *Optional* file1
    file1 = Field(
        type=LabeledMediaFileResource,
        required=False,
    )
    #: LabeledMediaFileResource: *Optional* file2
    file2 = Field(
        type=LabeledMediaFileResource,
        required=False,
    )
    #: LabeledMediaFileResource: *Optional* file3
    file3 = Field(
        type=LabeledMediaFileResource,
        required=False,
    )
    #: LabeledMediaFileResource: *Optional* file4
    file4 = Field(
        type=LabeledMediaFileResource,
        required=False,
    )


class CallCenterAnnouncementFileListModify20(OCIType):
    """
    Contains a list of announcement repository files
    """

    _ELEMENTS = (
        E(
            "file1",
            "file1",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "file2",
            "file2",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "file3",
            "file3",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "file4",
            "file4",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
    )
    #: AnnouncementFileLevelKey: *Optional* file1
    file1 = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* file2
    file2 = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* file3
    file3 = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* file4
    file4 = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )


class CallCenterAnnouncementFileListRead20(OCIType):
    """
    Contains a list of announcement repository files
    """

    _ELEMENTS = (
        E(
            "file1",
            "file1",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "file2",
            "file2",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "file3",
            "file3",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "file4",
            "file4",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
    )
    #: AnnouncementFileLevelKey: *Optional* file1
    file1 = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* file2
    file2 = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* file3
    file3 = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* file4
    file4 = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )


class CallCenterReplacementSkilledAgents(OCIType):
    """
    A list of agents grouped by skill levels.
    """

    _ELEMENTS = (
        E(
            "skill_level",
            "skillLevel",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "agents",
            "agents",
            ReplacementUserIdList,
            True,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* skillLevel
    skill_level = Field(
        type=int,
        required=True,
    )
    #: ReplacementUserIdList: *Required* agents
    agents = Field(
        type=ReplacementUserIdList,
        required=True,
    )


class CallCenterReportIntervalDates(OCIType):
    """
    The call center enhanced reporting report interval, using dates.
    """

    _ELEMENTS = (
        E(
            "start_date",
            "startDate",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "start_time",
            "startTime",
            HourMinute,
            True,
            True,
            False,
            False,
        ),
        E(
            "end_date",
            "endDate",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "end_time",
            "endTime",
            HourMinute,
            True,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* startDate
    start_date = Field(
        type=str,
        required=True,
    )
    #: HourMinute: *Required* startTime
    start_time = Field(
        type=HourMinute,
        required=True,
    )
    #: str: *Required* endDate
    end_date = Field(
        type=str,
        required=True,
    )
    #: HourMinute: *Required* endTime
    end_time = Field(
        type=HourMinute,
        required=True,
    )


class CallCenterReportScheduleRecurrence(OCIType):
    """
    A recurring schedule for call center enhanced reporting scheduled report.
    """

    _ELEMENTS = (
        E(
            "time_zone",
            "timeZone",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "start_date",
            "startDate",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "schedule_time",
            "scheduleTime",
            HourMinute,
            True,
            True,
            False,
            False,
        ),
        E(
            "recurrence",
            "recurrence",
            Recurrence,
            True,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* timeZone
    time_zone = Field(
        type=str,
        required=True,
    )
    #: str: *Required* startDate
    start_date = Field(
        type=str,
        required=True,
    )
    #: HourMinute: *Required* scheduleTime
    schedule_time = Field(
        type=HourMinute,
        required=True,
    )
    #: Recurrence: *Required* recurrence
    recurrence = Field(
        type=Recurrence,
        required=True,
    )


class CallCenterReportScheduleTime(OCIType):
    """
    A scheduled time for call center enhanced reporting scheduled report.
    """

    _ELEMENTS = (
        E(
            "time_zone",
            "timeZone",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "schedule_date",
            "scheduleDate",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "schedule_time",
            "scheduleTime",
            HourMinute,
            True,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* timeZone
    time_zone = Field(
        type=str,
        required=True,
    )
    #: str: *Required* scheduleDate
    schedule_date = Field(
        type=str,
        required=True,
    )
    #: HourMinute: *Required* scheduleTime
    schedule_time = Field(
        type=HourMinute,
        required=True,
    )


class CallMeNowToDnCriteriaModify(OCIType):
    """
    The To dn criteria used on the call me now external number to be modified.
    """

    _ELEMENTS = (
        E(
            "to_dn_criteria_selection",
            "toDnCriteriaSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number_list",
            "phoneNumberList",
            CriteriaReplacementDNList,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* toDnCriteriaSelection
    to_dn_criteria_selection = Field(
        type=str,
        required=False,
    )
    #: CriteriaReplacementDNList: *Optional* phoneNumberList
    phone_number_list = Field(
        type=CriteriaReplacementDNList,
        required=False,
    )


class CommPilotExpressAvailableInOffice(OCIType):
    """
    CommPilot Express Available In Office Settings.
    """

    _ELEMENTS = (
        E(
            "additional_phone_number_to_ring",
            "additionalPhoneNumberToRing",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "busy_setting",
            "busySetting",
            CommPilotExpressRedirection,
            True,
            True,
            False,
            False,
        ),
        E(
            "no_answer_setting",
            "noAnswerSetting",
            CommPilotExpressRedirection,
            True,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* additionalPhoneNumberToRing
    additional_phone_number_to_ring = Field(
        type=str,
        required=False,
    )
    #: CommPilotExpressRedirection: *Required* busySetting
    busy_setting = Field(
        type=CommPilotExpressRedirection,
        required=True,
    )
    #: CommPilotExpressRedirection: *Required* noAnswerSetting
    no_answer_setting = Field(
        type=CommPilotExpressRedirection,
        required=True,
    )


class CommPilotExpressAvailableInOfficeModify(OCIType):
    """
    CommPilot Express Available In Office Settings.
    """

    _ELEMENTS = (
        E(
            "additional_phone_number_to_ring",
            "additionalPhoneNumberToRing",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "busy_setting",
            "busySetting",
            CommPilotExpressRedirectionModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "no_answer_setting",
            "noAnswerSetting",
            CommPilotExpressRedirectionModify,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* additionalPhoneNumberToRing
    additional_phone_number_to_ring = Field(
        type=str,
        required=False,
    )
    #: CommPilotExpressRedirectionModify: *Optional* busySetting
    busy_setting = Field(
        type=CommPilotExpressRedirectionModify,
        required=False,
    )
    #: CommPilotExpressRedirectionModify: *Optional* noAnswerSetting
    no_answer_setting = Field(
        type=CommPilotExpressRedirectionModify,
        required=False,
    )


class CommPilotExpressAvailableOutOfOffice(OCIType):
    """
    CommPilot Express Available Out Of Office Configuration used in the context of a get.
    """

    _ELEMENTS = (
        E(
            "incoming_calls",
            "incomingCalls",
            CommPilotExpressRedirection,
            True,
            True,
            False,
            False,
        ),
        E(
            "incoming_call_notify",
            "incomingCallNotify",
            CommPilotExpressEmailNotify,
            True,
            True,
            False,
            False,
        ),
    )
    #: CommPilotExpressRedirection: *Required* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressRedirection,
        required=True,
    )
    #: CommPilotExpressEmailNotify: *Required* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressEmailNotify,
        required=True,
    )


class CommPilotExpressAvailableOutOfOfficeModify(OCIType):
    """
    CommPilot Express Available Out Of Office Configuration used in the context of a modify.
    """

    _ELEMENTS = (
        E(
            "incoming_calls",
            "incomingCalls",
            CommPilotExpressRedirectionModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "incoming_call_notify",
            "incomingCallNotify",
            CommPilotExpressEmailNotifyModify,
            True,
            False,
            False,
            False,
        ),
    )
    #: CommPilotExpressRedirectionModify: *Optional* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressRedirectionModify,
        required=False,
    )
    #: CommPilotExpressEmailNotifyModify: *Optional* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressEmailNotifyModify,
        required=False,
    )


class CommPilotExpressBusy(OCIType):
    """
    CommPilot Express Available In Office Configuration used in the context of a get.
    """

    _ELEMENTS = (
        E(
            "incoming_calls",
            "incomingCalls",
            CommPilotExpressRedirectionWithException,
            True,
            True,
            False,
            False,
        ),
        E(
            "voice_mail_notify",
            "voiceMailNotify",
            CommPilotExpressEmailNotify,
            True,
            True,
            False,
            False,
        ),
    )
    #: CommPilotExpressRedirectionWithException: *Required* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressRedirectionWithException,
        required=True,
    )
    #: CommPilotExpressEmailNotify: *Required* voiceMailNotify
    voice_mail_notify = Field(
        type=CommPilotExpressEmailNotify,
        required=True,
    )


class CommPilotExpressBusyModify(OCIType):
    """
    CommPilot Express Available In Office Configuration used in the context of a modify.
    """

    _ELEMENTS = (
        E(
            "incoming_calls",
            "incomingCalls",
            CommPilotExpressRedirectionWithExceptionModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "voice_mail_notify",
            "voiceMailNotify",
            CommPilotExpressEmailNotifyModify,
            True,
            False,
            False,
            False,
        ),
    )
    #: CommPilotExpressRedirectionWithExceptionModify: *Optional* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressRedirectionWithExceptionModify,
        required=False,
    )
    #: CommPilotExpressEmailNotifyModify: *Optional* voiceMailNotify
    voice_mail_notify = Field(
        type=CommPilotExpressEmailNotifyModify,
        required=False,
    )


class CommPilotExpressSRBusy(OCIType):
    """
    CommPilot Express SR Available In Office Configuration used in the context of a get.
    """

    _ELEMENTS = (
        E(
            "incoming_calls",
            "incomingCalls",
            CommPilotExpressSRRedirectionWithException,
            True,
            True,
            False,
            False,
        ),
        E(
            "incoming_call_notify",
            "incomingCallNotify",
            CommPilotExpressSREmailNotify,
            True,
            True,
            False,
            False,
        ),
    )
    #: CommPilotExpressSRRedirectionWithException: *Required* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressSRRedirectionWithException,
        required=True,
    )
    #: CommPilotExpressSREmailNotify: *Required* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressSREmailNotify,
        required=True,
    )


class CommPilotExpressSRBusyModify(OCIType):
    """
    CommPilot Express SR Available In Office Configuration used in the context of a modify.
    """

    _ELEMENTS = (
        E(
            "incoming_calls",
            "incomingCalls",
            CommPilotExpressSRRedirectionWithExceptionModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "incoming_call_notify",
            "incomingCallNotify",
            CommPilotExpressSREmailNotifyModify,
            True,
            False,
            False,
            False,
        ),
    )
    #: CommPilotExpressSRRedirectionWithExceptionModify: *Optional* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressSRRedirectionWithExceptionModify,
        required=False,
    )
    #: CommPilotExpressSREmailNotifyModify: *Optional* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressSREmailNotifyModify,
        required=False,
    )


class CommPilotExpressSRRedirectionWithRingList(OCIType):
    """
    CommPilot Express SR Forward Numbers with number of times to ring.
    """

    _ELEMENTS = (
        E(
            "number_entry",
            "numberEntry",
            CommPilotExpressSRRedirectionWithRing,
            True,
            False,
            False,
            False,
        ),
    )
    #: CommPilotExpressSRRedirectionWithRing: *Optional* numberEntry
    number_entry = Field(
        type=CommPilotExpressSRRedirectionWithRing,
        required=False,
    )


class CommPilotExpressSRUnavailable(OCIType):
    """
    CommPilot Express SR Unavailable Configuration used in the context of a get.
    """

    _ELEMENTS = (
        E(
            "incoming_calls",
            "incomingCalls",
            CommPilotExpressSRRedirectionWithException,
            True,
            True,
            False,
            False,
        ),
        E(
            "incoming_call_notify",
            "incomingCallNotify",
            CommPilotExpressSREmailNotify,
            True,
            True,
            False,
            False,
        ),
    )
    #: CommPilotExpressSRRedirectionWithException: *Required* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressSRRedirectionWithException,
        required=True,
    )
    #: CommPilotExpressSREmailNotify: *Required* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressSREmailNotify,
        required=True,
    )


class CommPilotExpressSRUnavailableModify(OCIType):
    """
    CommPilot Express SR Unavailable Configuration used in the context of a modify.
    """

    _ELEMENTS = (
        E(
            "incoming_calls",
            "incomingCalls",
            CommPilotExpressSRRedirectionWithExceptionModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "incoming_call_notify",
            "incomingCallNotify",
            CommPilotExpressSREmailNotifyModify,
            True,
            False,
            False,
            False,
        ),
    )
    #: CommPilotExpressSRRedirectionWithExceptionModify: *Optional* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressSRRedirectionWithExceptionModify,
        required=False,
    )
    #: CommPilotExpressSREmailNotifyModify: *Optional* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressSREmailNotifyModify,
        required=False,
    )


class CommPilotExpressUnavailable(OCIType):
    """
    CommPilot Express Unavailable Configuration used in the context of a get.
    """

    _ELEMENTS = (
        E(
            "incoming_calls",
            "incomingCalls",
            CommPilotExpressRedirectionWithException,
            True,
            True,
            False,
            False,
        ),
        E(
            "voice_mail_greeting",
            "voiceMailGreeting",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: CommPilotExpressRedirectionWithException: *Required* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressRedirectionWithException,
        required=True,
    )
    #: str: *Required* voiceMailGreeting
    voice_mail_greeting = Field(
        type=str,
        required=True,
    )


class CommPilotExpressUnavailableModify(OCIType):
    """
    CommPilot Express Unavailable Configuration used in the context of a modify.
    """

    _ELEMENTS = (
        E(
            "incoming_calls",
            "incomingCalls",
            CommPilotExpressRedirectionWithExceptionModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "voice_mail_greeting",
            "voiceMailGreeting",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: CommPilotExpressRedirectionWithExceptionModify: *Optional* incomingCalls
    incoming_calls = Field(
        type=CommPilotExpressRedirectionWithExceptionModify,
        required=False,
    )
    #: str: *Optional* voiceMailGreeting
    voice_mail_greeting = Field(
        type=str,
        required=False,
    )


class CriteriaFromDnModify(OCIType):
    """
    The from dn criteria used within a modify request.
    """

    _ELEMENTS = (
        E(
            "from_dn_criteria_selection",
            "fromDnCriteriaSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_anonymous_callers",
            "includeAnonymousCallers",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_unavailable_callers",
            "includeUnavailableCallers",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number_list",
            "phoneNumberList",
            CriteriaReplacementDNList,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* fromDnCriteriaSelection
    from_dn_criteria_selection = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* includeAnonymousCallers
    include_anonymous_callers = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* includeUnavailableCallers
    include_unavailable_callers = Field(
        type=bool,
        required=False,
    )
    #: CriteriaReplacementDNList: *Optional* phoneNumberList
    phone_number_list = Field(
        type=CriteriaReplacementDNList,
        required=False,
    )


class DeviceManagementDeviceTypeModifyOptions(OCIType):
    """
    Device Management System device type options during a modify request.
    """

    _ELEMENTS = (
        E(
            "device_access_protocol",
            "deviceAccessProtocol",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "tag_mode",
            "tagMode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "tag_set",
            "tagSet",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_device_profile_custom_tag_set",
            "allowDeviceProfileCustomTagSet",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_group_custom_tag_set",
            "allowGroupCustomTagSet",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "send_email_upon_reset_failure",
            "sendEmailUponResetFailure",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_net_address",
            "deviceAccessNetAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_port",
            "deviceAccessPort",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_context",
            "deviceAccessContext",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_device_language",
            "defaultDeviceLanguage",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_device_encoding",
            "defaultDeviceEncoding",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_device_credentials",
            "accessDeviceCredentials",
            DeviceManagementUserNamePassword,
            True,
            False,
            False,
            False,
        ),
        E(
            "use_http_digest_authentication",
            "useHttpDigestAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_based_file_authentication",
            "macBasedFileAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_in_non_request_uri",
            "macInNonRequestURI",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_format_in_non_request_uri",
            "macFormatInNonRequestURI",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* deviceAccessProtocol
    device_access_protocol = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* tagMode
    tag_mode = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* tagSet
    tag_set = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* allowDeviceProfileCustomTagSet
    allow_device_profile_custom_tag_set = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowGroupCustomTagSet
    allow_group_custom_tag_set = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* sendEmailUponResetFailure
    send_email_upon_reset_failure = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* deviceAccessNetAddress
    device_access_net_address = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* deviceAccessPort
    device_access_port = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* deviceAccessContext
    device_access_context = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultDeviceLanguage
    default_device_language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultDeviceEncoding
    default_device_encoding = Field(
        type=str,
        required=False,
    )
    #: DeviceManagementUserNamePassword: *Optional* accessDeviceCredentials
    access_device_credentials = Field(
        type=DeviceManagementUserNamePassword,
        required=False,
    )
    #: bool: *Optional* useHttpDigestAuthentication
    use_http_digest_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* macBasedFileAuthentication
    mac_based_file_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* macInNonRequestURI
    mac_in_non_request_uri = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(
        type=str,
        required=False,
    )


class DeviceManagementDeviceTypeModifyOptions16(OCIType):
    """
    Device Management System device type options during a modify request.
    """

    _ELEMENTS = (
        E(
            "device_access_protocol",
            "deviceAccessProtocol",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "tag_mode",
            "tagMode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "tag_set",
            "tagSet",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_device_profile_custom_tag_set",
            "allowDeviceProfileCustomTagSet",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_group_custom_tag_set",
            "allowGroupCustomTagSet",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "send_email_upon_reset_failure",
            "sendEmailUponResetFailure",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_net_address",
            "deviceAccessNetAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_port",
            "deviceAccessPort",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_context",
            "deviceAccessContext",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_device_language",
            "defaultDeviceLanguage",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_device_encoding",
            "defaultDeviceEncoding",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_device_credentials",
            "accessDeviceCredentials",
            DeviceManagementUserNamePassword16,
            True,
            False,
            False,
            False,
        ),
        E(
            "use_http_digest_authentication",
            "useHttpDigestAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_based_file_authentication",
            "macBasedFileAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_in_non_request_uri",
            "macInNonRequestURI",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_format_in_non_request_uri",
            "macFormatInNonRequestURI",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* deviceAccessProtocol
    device_access_protocol = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* tagMode
    tag_mode = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* tagSet
    tag_set = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* allowDeviceProfileCustomTagSet
    allow_device_profile_custom_tag_set = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowGroupCustomTagSet
    allow_group_custom_tag_set = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* sendEmailUponResetFailure
    send_email_upon_reset_failure = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* deviceAccessNetAddress
    device_access_net_address = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* deviceAccessPort
    device_access_port = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* deviceAccessContext
    device_access_context = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultDeviceLanguage
    default_device_language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultDeviceEncoding
    default_device_encoding = Field(
        type=str,
        required=False,
    )
    #: DeviceManagementUserNamePassword16: *Optional* accessDeviceCredentials
    access_device_credentials = Field(
        type=DeviceManagementUserNamePassword16,
        required=False,
    )
    #: bool: *Optional* useHttpDigestAuthentication
    use_http_digest_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* macBasedFileAuthentication
    mac_based_file_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* macInNonRequestURI
    mac_in_non_request_uri = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(
        type=str,
        required=False,
    )


class DeviceManagementDeviceTypeOptions(OCIType):
    """
    Device Management System device type options.
    """

    _ELEMENTS = (
        E(
            "device_access_protocol",
            "deviceAccessProtocol",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_mode",
            "tagMode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_set",
            "tagSet",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_device_profile_custom_tag_set",
            "allowDeviceProfileCustomTagSet",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_group_custom_tag_set",
            "allowGroupCustomTagSet",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "send_email_upon_reset_failure",
            "sendEmailUponResetFailure",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_access_net_address",
            "deviceAccessNetAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_port",
            "deviceAccessPort",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_context",
            "deviceAccessContext",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_uri",
            "deviceAccessURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_device_language",
            "defaultDeviceLanguage",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_device_encoding",
            "defaultDeviceEncoding",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_device_credentials",
            "accessDeviceCredentials",
            DeviceManagementUserNamePassword,
            True,
            False,
            False,
            False,
        ),
        E(
            "use_http_digest_authentication",
            "useHttpDigestAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mac_based_file_authentication",
            "macBasedFileAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mac_in_non_request_uri",
            "macInNonRequestURI",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mac_format_in_non_request_uri",
            "macFormatInNonRequestURI",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* deviceAccessProtocol
    device_access_protocol = Field(
        type=str,
        required=True,
    )
    #: str: *Required* tagMode
    tag_mode = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* tagSet
    tag_set = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* allowDeviceProfileCustomTagSet
    allow_device_profile_custom_tag_set = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowGroupCustomTagSet
    allow_group_custom_tag_set = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* sendEmailUponResetFailure
    send_email_upon_reset_failure = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* deviceAccessNetAddress
    device_access_net_address = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* deviceAccessPort
    device_access_port = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* deviceAccessContext
    device_access_context = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* deviceAccessURI
    device_access_uri = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultDeviceLanguage
    default_device_language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultDeviceEncoding
    default_device_encoding = Field(
        type=str,
        required=False,
    )
    #: DeviceManagementUserNamePassword: *Optional* accessDeviceCredentials
    access_device_credentials = Field(
        type=DeviceManagementUserNamePassword,
        required=False,
    )
    #: bool: *Required* useHttpDigestAuthentication
    use_http_digest_authentication = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* macBasedFileAuthentication
    mac_based_file_authentication = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* macInNonRequestURI
    mac_in_non_request_uri = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(
        type=str,
        required=False,
    )


class DeviceManagementDeviceTypeOptions16(OCIType):
    """
    Device Management System device type options.
    """

    _ELEMENTS = (
        E(
            "device_access_protocol",
            "deviceAccessProtocol",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_mode",
            "tagMode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_set",
            "tagSet",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_device_profile_custom_tag_set",
            "allowDeviceProfileCustomTagSet",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_group_custom_tag_set",
            "allowGroupCustomTagSet",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "send_email_upon_reset_failure",
            "sendEmailUponResetFailure",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_access_net_address",
            "deviceAccessNetAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_port",
            "deviceAccessPort",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_context",
            "deviceAccessContext",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_access_uri",
            "deviceAccessURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_device_language",
            "defaultDeviceLanguage",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_device_encoding",
            "defaultDeviceEncoding",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_device_credentials",
            "accessDeviceCredentials",
            DeviceManagementUserNamePassword16,
            True,
            False,
            False,
            False,
        ),
        E(
            "use_http_digest_authentication",
            "useHttpDigestAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mac_based_file_authentication",
            "macBasedFileAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mac_in_non_request_uri",
            "macInNonRequestURI",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mac_format_in_non_request_uri",
            "macFormatInNonRequestURI",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* deviceAccessProtocol
    device_access_protocol = Field(
        type=str,
        required=True,
    )
    #: str: *Required* tagMode
    tag_mode = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* tagSet
    tag_set = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* allowDeviceProfileCustomTagSet
    allow_device_profile_custom_tag_set = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowGroupCustomTagSet
    allow_group_custom_tag_set = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* sendEmailUponResetFailure
    send_email_upon_reset_failure = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* deviceAccessNetAddress
    device_access_net_address = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* deviceAccessPort
    device_access_port = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* deviceAccessContext
    device_access_context = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* deviceAccessURI
    device_access_uri = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultDeviceLanguage
    default_device_language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultDeviceEncoding
    default_device_encoding = Field(
        type=str,
        required=False,
    )
    #: DeviceManagementUserNamePassword16: *Optional* accessDeviceCredentials
    access_device_credentials = Field(
        type=DeviceManagementUserNamePassword16,
        required=False,
    )
    #: bool: *Required* useHttpDigestAuthentication
    use_http_digest_authentication = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* macBasedFileAuthentication
    mac_based_file_authentication = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* macInNonRequestURI
    mac_in_non_request_uri = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(
        type=str,
        required=False,
    )


class EnhancedCallLogsNumberFilter(OCIType):
    """
    Filter criteria based on the called number or number called.
    """

    _ELEMENTS = (
        E(
            "include_basic_call_type",
            "includeBasicCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_call_category",
            "includeCallCategory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_configurable_call_type",
            "includeConfigurableCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "search_criteria_dialed_number",
            "searchCriteriaDialedNumber",
            SearchCriteriaOutgoingDNorSIPURI,
            True,
            False,
            False,
            False,
        ),
        E(
            "search_criteria_called_number",
            "searchCriteriaCalledNumber",
            SearchCriteriaOutgoingDNorSIPURI,
            True,
            False,
            False,
            False,
        ),
        E(
            "search_criteria_network_translated_number",
            "searchCriteriaNetworkTranslatedNumber",
            SearchCriteriaOutgoingDNorSIPURI,
            True,
            False,
            False,
            False,
        ),
        E(
            "search_criteria_calling_presentation_number",
            "searchCriteriaCallingPresentationNumber",
            SearchCriteriaOutgoingDNorSIPURI,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* includeBasicCallType
    include_basic_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* includeCallCategory
    include_call_category = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* includeConfigurableCallType
    include_configurable_call_type = Field(
        type=str,
        required=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional* searchCriteriaDialedNumber
    search_criteria_dialed_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI,
        required=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional* searchCriteriaCalledNumber
    search_criteria_called_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI,
        required=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional* searchCriteriaNetworkTranslatedNumber
    search_criteria_network_translated_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI,
        required=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional*
    #: searchCriteriaCallingPresentationNumber
    search_criteria_calling_presentation_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI,
        required=False,
    )


class EnhancedCallLogsRedirectedNumberFilter(OCIType):
    """
    Filter criteria based on the transferred/forwarded number.
    """

    _ELEMENTS = (
        E(
            "redirected_call",
            "redirectedCall",
            EnhancedCallLogsRedirectedCallSelection,
            True,
            False,
            False,
            False,
        ),
        E(
            "include_service_invocation_basic_call_type",
            "includeServiceInvocationBasicCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_service_invocation_call_category",
            "includeServiceInvocationCallCategory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_service_invocation_configurable_call_type",
            "includeServiceInvocationConfigurableCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "search_criteria_service_invocation_dialed_number",
            "searchCriteriaServiceInvocationDialedNumber",
            SearchCriteriaOutgoingDNorSIPURI,
            True,
            False,
            False,
            False,
        ),
        E(
            "search_criteria_service_invocation_called_number",
            "searchCriteriaServiceInvocationCalledNumber",
            SearchCriteriaOutgoingDNorSIPURI,
            True,
            False,
            False,
            False,
        ),
        E(
            "search_criteria_service_invocation_network_translated_number",
            "searchCriteriaServiceInvocationNetworkTranslatedNumber",
            SearchCriteriaOutgoingDNorSIPURI,
            True,
            False,
            False,
            False,
        ),
    )
    #: EnhancedCallLogsRedirectedCallSelection: *Optional* redirectedCall
    redirected_call = Field(
        type=EnhancedCallLogsRedirectedCallSelection,
        required=False,
    )
    #: str: *Optional* includeServiceInvocationBasicCallType
    include_service_invocation_basic_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* includeServiceInvocationCallCategory
    include_service_invocation_call_category = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* includeServiceInvocationConfigurableCallType
    include_service_invocation_configurable_call_type = Field(
        type=str,
        required=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional*
    #: searchCriteriaServiceInvocationDialedNumber
    search_criteria_service_invocation_dialed_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI,
        required=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional*
    #: searchCriteriaServiceInvocationCalledNumber
    search_criteria_service_invocation_called_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI,
        required=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional*
    #: searchCriteriaServiceInvocationNetworkTranslatedNumber
    search_criteria_service_invocation_network_translated_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI,
        required=False,
    )


class EnhancedCallLogsRedirectedNumberFilter21(OCIType):
    """
    Filter criteria based on the transferred/forwarded number.
    """

    _ELEMENTS = (
        E(
            "redirected_call",
            "redirectedCall",
            EnhancedCallLogsRedirectedCallSelection21,
            True,
            False,
            False,
            False,
        ),
        E(
            "include_service_invocation_basic_call_type",
            "includeServiceInvocationBasicCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_service_invocation_call_category",
            "includeServiceInvocationCallCategory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_service_invocation_configurable_call_type",
            "includeServiceInvocationConfigurableCallType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "search_criteria_service_invocation_dialed_number",
            "searchCriteriaServiceInvocationDialedNumber",
            SearchCriteriaOutgoingDNorSIPURI,
            True,
            False,
            False,
            False,
        ),
        E(
            "search_criteria_service_invocation_called_number",
            "searchCriteriaServiceInvocationCalledNumber",
            SearchCriteriaOutgoingDNorSIPURI,
            True,
            False,
            False,
            False,
        ),
        E(
            "search_criteria_service_invocation_network_translated_number",
            "searchCriteriaServiceInvocationNetworkTranslatedNumber",
            SearchCriteriaOutgoingDNorSIPURI,
            True,
            False,
            False,
            False,
        ),
    )
    #: EnhancedCallLogsRedirectedCallSelection21: *Optional* redirectedCall
    redirected_call = Field(
        type=EnhancedCallLogsRedirectedCallSelection21,
        required=False,
    )
    #: str: *Optional* includeServiceInvocationBasicCallType
    include_service_invocation_basic_call_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* includeServiceInvocationCallCategory
    include_service_invocation_call_category = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* includeServiceInvocationConfigurableCallType
    include_service_invocation_configurable_call_type = Field(
        type=str,
        required=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional*
    #: searchCriteriaServiceInvocationDialedNumber
    search_criteria_service_invocation_dialed_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI,
        required=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional*
    #: searchCriteriaServiceInvocationCalledNumber
    search_criteria_service_invocation_called_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI,
        required=False,
    )
    #: SearchCriteriaOutgoingDNorSIPURI: *Optional*
    #: searchCriteriaServiceInvocationNetworkTranslatedNumber
    search_criteria_service_invocation_network_translated_number = Field(
        type=SearchCriteriaOutgoingDNorSIPURI,
        required=False,
    )


class EnterpriseAccessDevice(OCIType):
    """
    Uniquely identifies an access device accessible for an enterprise. It could be a
    system level device, an enterprise level device or a group level device.
    """

    _ELEMENTS = (
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: AccessDevice: *Required* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=True,
    )
    #: str: *Optional* groupId
    group_id = Field(
        type=str,
        required=False,
    )


class EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup(OCIType):
    """
    Trunk group details (order and weight) for each trunk group
    """

    _ELEMENTS = (
        E(
            "trunk_group",
            "trunkGroup",
            EnterpriseTrunkTrunkGroupKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "priority",
            "priority",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "weight",
            "weight",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: EnterpriseTrunkTrunkGroupKey: *Required* trunkGroup
    trunk_group = Field(
        type=EnterpriseTrunkTrunkGroupKey,
        required=True,
    )
    #: int: *Required* priority
    priority = Field(
        type=int,
        required=True,
    )
    #: int: *Required* weight
    weight = Field(
        type=int,
        required=True,
    )


class EnterpriseTrunkPriorityWeightedTrunkGroup(OCIType):
    """
    Trunk group details (order and weight) for each trunk group
    """

    _ELEMENTS = (
        E(
            "trunk_group",
            "trunkGroup",
            EnterpriseTrunkTrunkGroupKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "priority",
            "priority",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "weight",
            "weight",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: EnterpriseTrunkTrunkGroupKey: *Required* trunkGroup
    trunk_group = Field(
        type=EnterpriseTrunkTrunkGroupKey,
        required=True,
    )
    #: int: *Required* priority
    priority = Field(
        type=int,
        required=True,
    )
    #: int: *Required* weight
    weight = Field(
        type=int,
        required=True,
    )


class ExecutiveCallFilteringCriteriaFromDnModify(OCIType):
    """
    The from dn criteria used within an executive call filtering criteria modify request.
    """

    _ELEMENTS = (
        E(
            "from_dn_criteria_selection",
            "fromDnCriteriaSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_anonymous_callers",
            "includeAnonymousCallers",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_unavailable_callers",
            "includeUnavailableCallers",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number_list",
            "phoneNumberList",
            CriteriaReplacementDNList,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* fromDnCriteriaSelection
    from_dn_criteria_selection = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* includeAnonymousCallers
    include_anonymous_callers = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* includeUnavailableCallers
    include_unavailable_callers = Field(
        type=bool,
        required=False,
    )
    #: CriteriaReplacementDNList: *Optional* phoneNumberList
    phone_number_list = Field(
        type=CriteriaReplacementDNList,
        required=False,
    )


class ExtendedFileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or
    the contents of a file to transfer and an URL.
    """

    _ELEMENTS = (
        E(
            "file",
            "file",
            LabeledFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "url",
            "url",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: LabeledFileResource: *Optional* file
    file = Field(
        type=LabeledFileResource,
        required=False,
    )
    #: str: *Optional* url
    url = Field(
        type=str,
        required=False,
    )


class ExtendedMediaFileLevelResource20(OCIType):
    """
    Represents either an existing file for the application server to use, or
    the contents of a file to transfer and an URL.
    """

    _ELEMENTS = (
        E(
            "file",
            "file",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "url",
            "url",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: AnnouncementFileLevelKey: *Optional* file
    file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: str: *Optional* url
    url = Field(
        type=str,
        required=False,
    )


class ExtendedMediaFileResource(OCIType):
    """
    Represents either an existing file for the application server to use, or
    the contents of a file to transfer and an URL.
    """

    _ELEMENTS = (
        E(
            "file",
            "file",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "url",
            "url",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: LabeledMediaFileResource: *Optional* file
    file = Field(
        type=LabeledMediaFileResource,
        required=False,
    )
    #: str: *Optional* url
    url = Field(
        type=str,
        required=False,
    )


class ExtendedMediaFileResource20(OCIType):
    """
    Represents either an existing file for the application server to use, or
    the contents of a file to transfer and an URL.
    """

    _ELEMENTS = (
        E(
            "file",
            "file",
            AnnouncementFileKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "url",
            "url",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: AnnouncementFileKey: *Optional* file
    file = Field(
        type=AnnouncementFileKey,
        required=False,
    )
    #: str: *Optional* url
    url = Field(
        type=str,
        required=False,
    )


class GroupServiceAuthorization(OCIType):
    """
    Authorize (with quantity) or unauthorize a group service.
    """

    _ELEMENTS = (
        E(
            "service_name",
            "serviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "authorized_quantity",
            "authorizedQuantity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "unauthorized",
            "unauthorized",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceName
    service_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* authorizedQuantity
    authorized_quantity = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* unauthorized
    unauthorized = Field(
        type=bool,
        required=False,
    )


class GroupTrunkGroupGetInstanceRequest14sp9A(OCIType):
    """
    Get a Trunk Group Instance's profile.
    The response is either a GroupTrunkGroupGetInstanceResponse14sp9A or an
    ``ErrorResponse()``.
    The response contains a hosted user table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name".
    """

    _ELEMENTS = (
        E(
            "trunk_group_key",
            "trunkGroupKey",
            TrunkGroupKey,
            True,
            True,
            False,
            False,
        ),
    )
    #: TrunkGroupKey: *Required* trunkGroupKey
    trunk_group_key = Field(
        type=TrunkGroupKey,
        required=True,
    )


class GroupTrunkGroupGetInstanceRequest17sp4V2(OCIType):
    """
    Get a Trunk Group Instance's profile.
    The response is either a GroupTrunkGroupGetInstanceResponse17sp4V2 or an
    ``ErrorResponse()``.
    The response contains a hosted user table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name".

    Replaced By ``GroupTrunkGroupGetInstanceRequest19V2()``
    """

    _ELEMENTS = (
        E(
            "trunk_group_key",
            "trunkGroupKey",
            TrunkGroupKey,
            True,
            True,
            False,
            False,
        ),
    )
    #: TrunkGroupKey: *Required* trunkGroupKey
    trunk_group_key = Field(
        type=TrunkGroupKey,
        required=True,
    )


class GroupTrunkGroupGetInstanceRequest19sp1V2(OCIType):
    """
    Get a Trunk Group Instance's profile.
    The response is either a GroupTrunkGroupGetInstanceResponse19sp1V2 or an
    ``ErrorResponse()``.
    The response contains a hosted user table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name", "Phone Number", "Extension",
    "Department", "Email Address".

    Replaced By ``GroupTrunkGroupGetInstanceRequest20sp1()``
    """

    _ELEMENTS = (
        E(
            "trunk_group_key",
            "trunkGroupKey",
            TrunkGroupKey,
            True,
            True,
            False,
            False,
        ),
    )
    #: TrunkGroupKey: *Required* trunkGroupKey
    trunk_group_key = Field(
        type=TrunkGroupKey,
        required=True,
    )


class GroupTrunkGroupGetInstanceResponse14sp9A(OCIType):
    """
    Response to GroupTrunkGroupGetInstanceRequest14sp9A.
    Returns the profile information for the Trunk Group.
    Contains a hosted user table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name".
    """

    _ELEMENTS = (
        E(
            "pilot_user_id",
            "pilotUserId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            False,
            False,
            False,
        ),
        E(
            "max_active_calls",
            "maxActiveCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_incoming_calls",
            "maxIncomingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_outgoing_calls",
            "maxOutgoingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_bursting",
            "enableBursting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "bursting_max_active_calls",
            "burstingMaxActiveCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "bursting_max_incoming_calls",
            "burstingMaxIncomingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "bursting_max_outgoing_calls",
            "burstingMaxOutgoingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_action",
            "capacityExceededAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_forward_address",
            "capacityExceededForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_reroute_trunk_group_key",
            "capacityExceededRerouteTrunkGroupKey",
            TrunkGroupKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_initial_calls",
            "capacityExceededTrapInitialCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_offset_calls",
            "capacityExceededTrapOffsetCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "unreachable_destination_action",
            "unreachableDestinationAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "unreachable_destination_forward_address",
            "unreachableDestinationForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "unreachable_destination_reroute_trunk_group_key",
            "unreachableDestinationRerouteTrunkGroupKey",
            TrunkGroupKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "unreachable_destination_trap_initial_calls",
            "unreachableDestinationTrapInitialCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "unreachable_destination_trap_offset_calls",
            "unreachableDestinationTrapOffsetCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "invitation_timeout",
            "invitationTimeout",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "require_authentication",
            "requireAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "sip_authentication_user_name",
            "sipAuthenticationUserName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hosted_user_table",
            "hostedUserTable",
            list,
            True,
            False,
            False,
            True,
        ),
        E(
            "trunk_group_identity",
            "trunkGroupIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "otg_dtg_identity",
            "otgDtgIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_trunk_group_identity",
            "includeTrunkGroupIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_dtg_identity",
            "includeDtgIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_network_address_identity",
            "enableNetworkAddressIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_unscreened_calls",
            "allowUnscreenedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_unscreened_emergency_calls",
            "allowUnscreenedEmergencyCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "pilot_user_calling_line_identity_policy",
            "pilotUserCallingLineIdentityPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "pilot_user_charge_number_policy",
            "pilotUserChargeNumberPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_forwarding_always_action",
            "callForwardingAlwaysAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_forwarding_always_forward_address",
            "callForwardingAlwaysForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_forwarding_always_reroute_trunk_group_key",
            "callForwardingAlwaysRerouteTrunkGroupKey",
            TrunkGroupKey,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* pilotUserId
    pilot_user_id = Field(
        type=str,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: AccessDevice: *Optional* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=False,
    )
    #: int: *Required* maxActiveCalls
    max_active_calls = Field(
        type=int,
        required=True,
    )
    #: int: *Optional* maxIncomingCalls
    max_incoming_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxOutgoingCalls
    max_outgoing_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* enableBursting
    enable_bursting = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* burstingMaxActiveCalls
    bursting_max_active_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* burstingMaxIncomingCalls
    bursting_max_incoming_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* burstingMaxOutgoingCalls
    bursting_max_outgoing_calls = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* capacityExceededAction
    capacity_exceeded_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* capacityExceededForwardAddress
    capacity_exceeded_forward_address = Field(
        type=str,
        required=False,
    )
    #: TrunkGroupKey: *Optional* capacityExceededRerouteTrunkGroupKey
    capacity_exceeded_reroute_trunk_group_key = Field(
        type=TrunkGroupKey,
        required=False,
    )
    #: int: *Required* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(
        type=int,
        required=True,
    )
    #: int: *Required* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(
        type=int,
        required=True,
    )
    #: str: *Optional* unreachableDestinationAction
    unreachable_destination_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* unreachableDestinationForwardAddress
    unreachable_destination_forward_address = Field(
        type=str,
        required=False,
    )
    #: TrunkGroupKey: *Optional* unreachableDestinationRerouteTrunkGroupKey
    unreachable_destination_reroute_trunk_group_key = Field(
        type=TrunkGroupKey,
        required=False,
    )
    #: int: *Required* unreachableDestinationTrapInitialCalls
    unreachable_destination_trap_initial_calls = Field(
        type=int,
        required=True,
    )
    #: int: *Required* unreachableDestinationTrapOffsetCalls
    unreachable_destination_trap_offset_calls = Field(
        type=int,
        required=True,
    )
    #: int: *Required* invitationTimeout
    invitation_timeout = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* requireAuthentication
    require_authentication = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* sipAuthenticationUserName
    sip_authentication_user_name = Field(
        type=str,
        required=False,
    )
    #: list: *Optional* hostedUserTable  *Tabular*
    hosted_user_table = Field(
        type=list,
        required=False,
    )
    #: str: *Optional* trunkGroupIdentity
    trunk_group_identity = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* otgDtgIdentity
    otg_dtg_identity = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* includeTrunkGroupIdentity
    include_trunk_group_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeDtgIdentity
    include_dtg_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableNetworkAddressIdentity
    enable_network_address_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowUnscreenedCalls
    allow_unscreened_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowUnscreenedEmergencyCalls
    allow_unscreened_emergency_calls = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* pilotUserCallingLineIdentityPolicy
    pilot_user_calling_line_identity_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* pilotUserChargeNumberPolicy
    pilot_user_charge_number_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* callForwardingAlwaysAction
    call_forwarding_always_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callForwardingAlwaysForwardAddress
    call_forwarding_always_forward_address = Field(
        type=str,
        required=False,
    )
    #: TrunkGroupKey: *Optional* callForwardingAlwaysRerouteTrunkGroupKey
    call_forwarding_always_reroute_trunk_group_key = Field(
        type=TrunkGroupKey,
        required=False,
    )


class GroupTrunkGroupGetInstanceResponse17sp4V2(OCIType):
    """
    Response to GroupTrunkGroupGetInstanceRequest17sp4V2.
    Returns the profile information for the Trunk Group.
    Contains a hosted user table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name".

    Replaced By ``GroupTrunkGroupGetInstanceResponse19V2()``
    """

    _ELEMENTS = (
        E(
            "pilot_user_id",
            "pilotUserId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            False,
            False,
            False,
        ),
        E(
            "max_active_calls",
            "maxActiveCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_incoming_calls",
            "maxIncomingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_outgoing_calls",
            "maxOutgoingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_bursting",
            "enableBursting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "bursting_max_active_calls",
            "burstingMaxActiveCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "bursting_max_incoming_calls",
            "burstingMaxIncomingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "bursting_max_outgoing_calls",
            "burstingMaxOutgoingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_action",
            "capacityExceededAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_forward_address",
            "capacityExceededForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_reroute_trunk_group_key",
            "capacityExceededRerouteTrunkGroupKey",
            TrunkGroupKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_initial_calls",
            "capacityExceededTrapInitialCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_offset_calls",
            "capacityExceededTrapOffsetCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "unreachable_destination_action",
            "unreachableDestinationAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "unreachable_destination_forward_address",
            "unreachableDestinationForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "unreachable_destination_reroute_trunk_group_key",
            "unreachableDestinationRerouteTrunkGroupKey",
            TrunkGroupKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "invitation_timeout",
            "invitationTimeout",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "require_authentication",
            "requireAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "sip_authentication_user_name",
            "sipAuthenticationUserName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hosted_user_table",
            "hostedUserTable",
            list,
            True,
            False,
            False,
            True,
        ),
        E(
            "trunk_group_identity",
            "trunkGroupIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "otg_dtg_identity",
            "otgDtgIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_termination_to_trunk_group_identity",
            "allowTerminationToTrunkGroupIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_termination_to_dtg_identity",
            "allowTerminationToDtgIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_trunk_group_identity",
            "includeTrunkGroupIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_dtg_identity",
            "includeDtgIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_trunk_group_identity_for_network_calls",
            "includeTrunkGroupIdentityForNetworkCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_otg_identity_for_network_calls",
            "includeOtgIdentityForNetworkCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_network_address_identity",
            "enableNetworkAddressIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_unscreened_calls",
            "allowUnscreenedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_unscreened_emergency_calls",
            "allowUnscreenedEmergencyCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "pilot_user_calling_line_identity_policy",
            "pilotUserCallingLineIdentityPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "pilot_user_charge_number_policy",
            "pilotUserChargeNumberPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_forwarding_always_action",
            "callForwardingAlwaysAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_forwarding_always_forward_address",
            "callForwardingAlwaysForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_forwarding_always_reroute_trunk_group_key",
            "callForwardingAlwaysRerouteTrunkGroupKey",
            TrunkGroupKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "peering_domain",
            "peeringDomain",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "route_to_peering_domain",
            "routeToPeeringDomain",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "prefix_enabled",
            "prefixEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "prefix",
            "prefix",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "stateful_rerouting_enabled",
            "statefulReroutingEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "send_continuous_options_message",
            "sendContinuousOptionsMessage",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "continuous_options_sending_interval_seconds",
            "continuousOptionsSendingIntervalSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "failure_options_sending_interval_seconds",
            "failureOptionsSendingIntervalSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "failure_threshold_counter",
            "failureThresholdCounter",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "success_threshold_counter",
            "successThresholdCounter",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "invite_failure_threshold_counter",
            "inviteFailureThresholdCounter",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "invite_failure_threshold_window_seconds",
            "inviteFailureThresholdWindowSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_group_state",
            "trunkGroupState",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "pilot_user_calling_line_asserted_identity_policy",
            "pilotUserCallingLineAssertedIdentityPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_system_calling_line_asserted_identity_policy",
            "useSystemCallingLineAssertedIdentityPolicy",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* pilotUserId
    pilot_user_id = Field(
        type=str,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: AccessDevice: *Optional* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=False,
    )
    #: int: *Required* maxActiveCalls
    max_active_calls = Field(
        type=int,
        required=True,
    )
    #: int: *Optional* maxIncomingCalls
    max_incoming_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxOutgoingCalls
    max_outgoing_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* enableBursting
    enable_bursting = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* burstingMaxActiveCalls
    bursting_max_active_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* burstingMaxIncomingCalls
    bursting_max_incoming_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* burstingMaxOutgoingCalls
    bursting_max_outgoing_calls = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* capacityExceededAction
    capacity_exceeded_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* capacityExceededForwardAddress
    capacity_exceeded_forward_address = Field(
        type=str,
        required=False,
    )
    #: TrunkGroupKey: *Optional* capacityExceededRerouteTrunkGroupKey
    capacity_exceeded_reroute_trunk_group_key = Field(
        type=TrunkGroupKey,
        required=False,
    )
    #: int: *Required* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(
        type=int,
        required=True,
    )
    #: int: *Required* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(
        type=int,
        required=True,
    )
    #: str: *Optional* unreachableDestinationAction
    unreachable_destination_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* unreachableDestinationForwardAddress
    unreachable_destination_forward_address = Field(
        type=str,
        required=False,
    )
    #: TrunkGroupKey: *Optional* unreachableDestinationRerouteTrunkGroupKey
    unreachable_destination_reroute_trunk_group_key = Field(
        type=TrunkGroupKey,
        required=False,
    )
    #: int: *Required* invitationTimeout
    invitation_timeout = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* requireAuthentication
    require_authentication = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* sipAuthenticationUserName
    sip_authentication_user_name = Field(
        type=str,
        required=False,
    )
    #: list: *Optional* hostedUserTable  *Tabular*
    hosted_user_table = Field(
        type=list,
        required=False,
    )
    #: str: *Optional* trunkGroupIdentity
    trunk_group_identity = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* otgDtgIdentity
    otg_dtg_identity = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* allowTerminationToTrunkGroupIdentity
    allow_termination_to_trunk_group_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowTerminationToDtgIdentity
    allow_termination_to_dtg_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeTrunkGroupIdentity
    include_trunk_group_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeDtgIdentity
    include_dtg_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeTrunkGroupIdentityForNetworkCalls
    include_trunk_group_identity_for_network_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeOtgIdentityForNetworkCalls
    include_otg_identity_for_network_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableNetworkAddressIdentity
    enable_network_address_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowUnscreenedCalls
    allow_unscreened_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowUnscreenedEmergencyCalls
    allow_unscreened_emergency_calls = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* pilotUserCallingLineIdentityPolicy
    pilot_user_calling_line_identity_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* pilotUserChargeNumberPolicy
    pilot_user_charge_number_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* callForwardingAlwaysAction
    call_forwarding_always_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callForwardingAlwaysForwardAddress
    call_forwarding_always_forward_address = Field(
        type=str,
        required=False,
    )
    #: TrunkGroupKey: *Optional* callForwardingAlwaysRerouteTrunkGroupKey
    call_forwarding_always_reroute_trunk_group_key = Field(
        type=TrunkGroupKey,
        required=False,
    )
    #: str: *Optional* peeringDomain
    peering_domain = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* routeToPeeringDomain
    route_to_peering_domain = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* prefixEnabled
    prefix_enabled = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* prefix
    prefix = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* statefulReroutingEnabled
    stateful_rerouting_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* sendContinuousOptionsMessage
    send_continuous_options_message = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* continuousOptionsSendingIntervalSeconds
    continuous_options_sending_interval_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* failureOptionsSendingIntervalSeconds
    failure_options_sending_interval_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* failureThresholdCounter
    failure_threshold_counter = Field(
        type=int,
        required=True,
    )
    #: int: *Required* successThresholdCounter
    success_threshold_counter = Field(
        type=int,
        required=True,
    )
    #: int: *Required* inviteFailureThresholdCounter
    invite_failure_threshold_counter = Field(
        type=int,
        required=True,
    )
    #: int: *Required* inviteFailureThresholdWindowSeconds
    invite_failure_threshold_window_seconds = Field(
        type=int,
        required=True,
    )
    #: str: *Required* trunkGroupState
    trunk_group_state = Field(
        type=str,
        required=True,
    )
    #: str: *Required* pilotUserCallingLineAssertedIdentityPolicy
    pilot_user_calling_line_asserted_identity_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* useSystemCallingLineAssertedIdentityPolicy
    use_system_calling_line_asserted_identity_policy = Field(
        type=bool,
        required=True,
    )


class GroupTrunkGroupGetInstanceResponse19sp1V2(OCIType):
    """
    Response to GroupTrunkGroupGetInstanceRequest19sp1V2.
    Returns the profile information for the Trunk Group.
    Contains a hosted user table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name", "Phone Number",
    "Extension", "Department", "Email Address".

    Replaced By ``GroupTrunkGroupGetInstanceResponse20sp1()``
    """

    _ELEMENTS = (
        E(
            "pilot_user_id",
            "pilotUserId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            False,
            False,
            False,
        ),
        E(
            "max_active_calls",
            "maxActiveCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_incoming_calls",
            "maxIncomingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_outgoing_calls",
            "maxOutgoingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_bursting",
            "enableBursting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "bursting_max_active_calls",
            "burstingMaxActiveCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "bursting_max_incoming_calls",
            "burstingMaxIncomingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "bursting_max_outgoing_calls",
            "burstingMaxOutgoingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_action",
            "capacityExceededAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_forward_address",
            "capacityExceededForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_reroute_trunk_group_key",
            "capacityExceededRerouteTrunkGroupKey",
            TrunkGroupKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_initial_calls",
            "capacityExceededTrapInitialCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_offset_calls",
            "capacityExceededTrapOffsetCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "unreachable_destination_action",
            "unreachableDestinationAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "unreachable_destination_forward_address",
            "unreachableDestinationForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "unreachable_destination_reroute_trunk_group_key",
            "unreachableDestinationRerouteTrunkGroupKey",
            TrunkGroupKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "invitation_timeout",
            "invitationTimeout",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "require_authentication",
            "requireAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "sip_authentication_user_name",
            "sipAuthenticationUserName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hosted_user_table",
            "hostedUserTable",
            list,
            True,
            False,
            False,
            True,
        ),
        E(
            "trunk_group_identity",
            "trunkGroupIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "otg_dtg_identity",
            "otgDtgIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_termination_to_trunk_group_identity",
            "allowTerminationToTrunkGroupIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_termination_to_dtg_identity",
            "allowTerminationToDtgIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_trunk_group_identity",
            "includeTrunkGroupIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_dtg_identity",
            "includeDtgIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_trunk_group_identity_for_network_calls",
            "includeTrunkGroupIdentityForNetworkCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_otg_identity_for_network_calls",
            "includeOtgIdentityForNetworkCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_network_address_identity",
            "enableNetworkAddressIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_unscreened_calls",
            "allowUnscreenedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_unscreened_emergency_calls",
            "allowUnscreenedEmergencyCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "pilot_user_calling_line_identity_for_external_calls_policy",
            "pilotUserCallingLineIdentityForExternalCallsPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "pilot_user_charge_number_policy",
            "pilotUserChargeNumberPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_forwarding_always_action",
            "callForwardingAlwaysAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_forwarding_always_forward_address",
            "callForwardingAlwaysForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_forwarding_always_reroute_trunk_group_key",
            "callForwardingAlwaysRerouteTrunkGroupKey",
            TrunkGroupKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "peering_domain",
            "peeringDomain",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "route_to_peering_domain",
            "routeToPeeringDomain",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "prefix_enabled",
            "prefixEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "prefix",
            "prefix",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "stateful_rerouting_enabled",
            "statefulReroutingEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "send_continuous_options_message",
            "sendContinuousOptionsMessage",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "continuous_options_sending_interval_seconds",
            "continuousOptionsSendingIntervalSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "failure_options_sending_interval_seconds",
            "failureOptionsSendingIntervalSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "failure_threshold_counter",
            "failureThresholdCounter",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "success_threshold_counter",
            "successThresholdCounter",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "invite_failure_threshold_counter",
            "inviteFailureThresholdCounter",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "invite_failure_threshold_window_seconds",
            "inviteFailureThresholdWindowSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_group_state",
            "trunkGroupState",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "pilot_user_calling_line_asserted_identity_policy",
            "pilotUserCallingLineAssertedIdentityPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_system_calling_line_asserted_identity_policy",
            "useSystemCallingLineAssertedIdentityPolicy",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "total_active_incoming_calls",
            "totalActiveIncomingCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "total_active_outgoing_calls",
            "totalActiveOutgoingCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "pilot_user_call_optimization_policy",
            "pilotUserCallOptimizationPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_source_for_screened_calls_policy",
            "clidSourceForScreenedCallsPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_system_clid_source_for_screened_calls_policy",
            "useSystemCLIDSourceForScreenedCallsPolicy",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_lookup_policy",
            "userLookupPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_system_user_lookup_policy",
            "useSystemUserLookupPolicy",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "pilot_user_calling_line_identity_for_emergency_calls_policy",
            "pilotUserCallingLineIdentityForEmergencyCallsPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* pilotUserId
    pilot_user_id = Field(
        type=str,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: AccessDevice: *Optional* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=False,
    )
    #: int: *Required* maxActiveCalls
    max_active_calls = Field(
        type=int,
        required=True,
    )
    #: int: *Optional* maxIncomingCalls
    max_incoming_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxOutgoingCalls
    max_outgoing_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* enableBursting
    enable_bursting = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* burstingMaxActiveCalls
    bursting_max_active_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* burstingMaxIncomingCalls
    bursting_max_incoming_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* burstingMaxOutgoingCalls
    bursting_max_outgoing_calls = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* capacityExceededAction
    capacity_exceeded_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* capacityExceededForwardAddress
    capacity_exceeded_forward_address = Field(
        type=str,
        required=False,
    )
    #: TrunkGroupKey: *Optional* capacityExceededRerouteTrunkGroupKey
    capacity_exceeded_reroute_trunk_group_key = Field(
        type=TrunkGroupKey,
        required=False,
    )
    #: int: *Required* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(
        type=int,
        required=True,
    )
    #: int: *Required* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(
        type=int,
        required=True,
    )
    #: str: *Optional* unreachableDestinationAction
    unreachable_destination_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* unreachableDestinationForwardAddress
    unreachable_destination_forward_address = Field(
        type=str,
        required=False,
    )
    #: TrunkGroupKey: *Optional* unreachableDestinationRerouteTrunkGroupKey
    unreachable_destination_reroute_trunk_group_key = Field(
        type=TrunkGroupKey,
        required=False,
    )
    #: int: *Required* invitationTimeout
    invitation_timeout = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* requireAuthentication
    require_authentication = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* sipAuthenticationUserName
    sip_authentication_user_name = Field(
        type=str,
        required=False,
    )
    #: list: *Optional* hostedUserTable  *Tabular*
    hosted_user_table = Field(
        type=list,
        required=False,
    )
    #: str: *Optional* trunkGroupIdentity
    trunk_group_identity = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* otgDtgIdentity
    otg_dtg_identity = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* allowTerminationToTrunkGroupIdentity
    allow_termination_to_trunk_group_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowTerminationToDtgIdentity
    allow_termination_to_dtg_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeTrunkGroupIdentity
    include_trunk_group_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeDtgIdentity
    include_dtg_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeTrunkGroupIdentityForNetworkCalls
    include_trunk_group_identity_for_network_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeOtgIdentityForNetworkCalls
    include_otg_identity_for_network_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableNetworkAddressIdentity
    enable_network_address_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowUnscreenedCalls
    allow_unscreened_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowUnscreenedEmergencyCalls
    allow_unscreened_emergency_calls = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* pilotUserCallingLineIdentityForExternalCallsPolicy
    pilot_user_calling_line_identity_for_external_calls_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* pilotUserChargeNumberPolicy
    pilot_user_charge_number_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* callForwardingAlwaysAction
    call_forwarding_always_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callForwardingAlwaysForwardAddress
    call_forwarding_always_forward_address = Field(
        type=str,
        required=False,
    )
    #: TrunkGroupKey: *Optional* callForwardingAlwaysRerouteTrunkGroupKey
    call_forwarding_always_reroute_trunk_group_key = Field(
        type=TrunkGroupKey,
        required=False,
    )
    #: str: *Optional* peeringDomain
    peering_domain = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* routeToPeeringDomain
    route_to_peering_domain = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* prefixEnabled
    prefix_enabled = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* prefix
    prefix = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* statefulReroutingEnabled
    stateful_rerouting_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* sendContinuousOptionsMessage
    send_continuous_options_message = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* continuousOptionsSendingIntervalSeconds
    continuous_options_sending_interval_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* failureOptionsSendingIntervalSeconds
    failure_options_sending_interval_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* failureThresholdCounter
    failure_threshold_counter = Field(
        type=int,
        required=True,
    )
    #: int: *Required* successThresholdCounter
    success_threshold_counter = Field(
        type=int,
        required=True,
    )
    #: int: *Required* inviteFailureThresholdCounter
    invite_failure_threshold_counter = Field(
        type=int,
        required=True,
    )
    #: int: *Required* inviteFailureThresholdWindowSeconds
    invite_failure_threshold_window_seconds = Field(
        type=int,
        required=True,
    )
    #: str: *Required* trunkGroupState
    trunk_group_state = Field(
        type=str,
        required=True,
    )
    #: str: *Required* pilotUserCallingLineAssertedIdentityPolicy
    pilot_user_calling_line_asserted_identity_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* useSystemCallingLineAssertedIdentityPolicy
    use_system_calling_line_asserted_identity_policy = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* totalActiveIncomingCalls
    total_active_incoming_calls = Field(
        type=int,
        required=True,
    )
    #: int: *Required* totalActiveOutgoingCalls
    total_active_outgoing_calls = Field(
        type=int,
        required=True,
    )
    #: str: *Required* pilotUserCallOptimizationPolicy
    pilot_user_call_optimization_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* clidSourceForScreenedCallsPolicy
    clid_source_for_screened_calls_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* useSystemCLIDSourceForScreenedCallsPolicy
    use_system_clid_source_for_screened_calls_policy = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* userLookupPolicy
    user_lookup_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* useSystemUserLookupPolicy
    use_system_user_lookup_policy = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* pilotUserCallingLineIdentityForEmergencyCallsPolicy
    pilot_user_calling_line_identity_for_emergency_calls_policy = Field(
        type=str,
        required=True,
    )


class GroupTrunkGroupModifyInstanceRequest14sp9A(OCIType):
    """
    Modify a Trunk Group Instance in a group.
    The access device cannot be modified or cleared if there are any users assigned
    to the Trunk Group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "trunk_group_key",
            "trunkGroupKey",
            TrunkGroupKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "new_name",
            "newName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "pilot_user_id",
            "pilotUserId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            False,
            False,
            False,
        ),
        E(
            "max_active_calls",
            "maxActiveCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_incoming_calls",
            "maxIncomingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_outgoing_calls",
            "maxOutgoingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_bursting",
            "enableBursting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "bursting_max_active_calls",
            "burstingMaxActiveCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "bursting_max_incoming_calls",
            "burstingMaxIncomingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "bursting_max_outgoing_calls",
            "burstingMaxOutgoingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_action",
            "capacityExceededAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_forward_address",
            "capacityExceededForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_reroute_trunk_group_key",
            "capacityExceededRerouteTrunkGroupKey",
            TrunkGroupKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_initial_calls",
            "capacityExceededTrapInitialCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_offset_calls",
            "capacityExceededTrapOffsetCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "unreachable_destination_action",
            "unreachableDestinationAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "unreachable_destination_forward_address",
            "unreachableDestinationForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "unreachable_destination_reroute_trunk_group_key",
            "unreachableDestinationRerouteTrunkGroupKey",
            TrunkGroupKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "unreachable_destination_trap_initial_calls",
            "unreachableDestinationTrapInitialCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "unreachable_destination_trap_offset_calls",
            "unreachableDestinationTrapOffsetCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "invitation_timeout",
            "invitationTimeout",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "require_authentication",
            "requireAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "sip_authentication_user_name",
            "sipAuthenticationUserName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "sip_authentication_password",
            "sipAuthenticationPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hosted_user_id_list",
            "hostedUserIdList",
            ReplacementUserIdList,
            True,
            False,
            False,
            False,
        ),
        E(
            "trunk_group_identity",
            "trunkGroupIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "otg_dtg_identity",
            "otgDtgIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_trunk_group_identity",
            "includeTrunkGroupIdentity",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_dtg_identity",
            "includeDtgIdentity",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_network_address_identity",
            "enableNetworkAddressIdentity",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_unscreened_calls",
            "allowUnscreenedCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_unscreened_emergency_calls",
            "allowUnscreenedEmergencyCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "pilot_user_calling_line_identity_policy",
            "pilotUserCallingLineIdentityPolicy",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "pilot_user_charge_number_policy",
            "pilotUserChargeNumberPolicy",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_forwarding_always_action",
            "callForwardingAlwaysAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_forwarding_always_forward_address",
            "callForwardingAlwaysForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_forwarding_always_reroute_trunk_group_key",
            "callForwardingAlwaysRerouteTrunkGroupKey",
            TrunkGroupKey,
            True,
            False,
            False,
            False,
        ),
    )
    #: TrunkGroupKey: *Required* trunkGroupKey
    trunk_group_key = Field(
        type=TrunkGroupKey,
        required=True,
    )
    #: str: *Optional* newName
    new_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* pilotUserId
    pilot_user_id = Field(
        type=str,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: AccessDevice: *Optional* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=False,
    )
    #: int: *Optional* maxActiveCalls
    max_active_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxIncomingCalls
    max_incoming_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxOutgoingCalls
    max_outgoing_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* enableBursting
    enable_bursting = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* burstingMaxActiveCalls
    bursting_max_active_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* burstingMaxIncomingCalls
    bursting_max_incoming_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* burstingMaxOutgoingCalls
    bursting_max_outgoing_calls = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* capacityExceededAction
    capacity_exceeded_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* capacityExceededForwardAddress
    capacity_exceeded_forward_address = Field(
        type=str,
        required=False,
    )
    #: TrunkGroupKey: *Optional* capacityExceededRerouteTrunkGroupKey
    capacity_exceeded_reroute_trunk_group_key = Field(
        type=TrunkGroupKey,
        required=False,
    )
    #: int: *Optional* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* unreachableDestinationAction
    unreachable_destination_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* unreachableDestinationForwardAddress
    unreachable_destination_forward_address = Field(
        type=str,
        required=False,
    )
    #: TrunkGroupKey: *Optional* unreachableDestinationRerouteTrunkGroupKey
    unreachable_destination_reroute_trunk_group_key = Field(
        type=TrunkGroupKey,
        required=False,
    )
    #: int: *Optional* unreachableDestinationTrapInitialCalls
    unreachable_destination_trap_initial_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* unreachableDestinationTrapOffsetCalls
    unreachable_destination_trap_offset_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* invitationTimeout
    invitation_timeout = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* requireAuthentication
    require_authentication = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* sipAuthenticationUserName
    sip_authentication_user_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* sipAuthenticationPassword
    sip_authentication_password = Field(
        type=str,
        required=False,
    )
    #: ReplacementUserIdList: *Optional* hostedUserIdList
    hosted_user_id_list = Field(
        type=ReplacementUserIdList,
        required=False,
    )
    #: str: *Optional* trunkGroupIdentity
    trunk_group_identity = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* otgDtgIdentity
    otg_dtg_identity = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* includeTrunkGroupIdentity
    include_trunk_group_identity = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* includeDtgIdentity
    include_dtg_identity = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableNetworkAddressIdentity
    enable_network_address_identity = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowUnscreenedCalls
    allow_unscreened_calls = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowUnscreenedEmergencyCalls
    allow_unscreened_emergency_calls = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* pilotUserCallingLineIdentityPolicy
    pilot_user_calling_line_identity_policy = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* pilotUserChargeNumberPolicy
    pilot_user_charge_number_policy = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callForwardingAlwaysAction
    call_forwarding_always_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callForwardingAlwaysForwardAddress
    call_forwarding_always_forward_address = Field(
        type=str,
        required=False,
    )
    #: TrunkGroupKey: *Optional* callForwardingAlwaysRerouteTrunkGroupKey
    call_forwarding_always_reroute_trunk_group_key = Field(
        type=TrunkGroupKey,
        required=False,
    )


class IncomingCallingPlanDepartmentPermissions(OCIType):
    """
    Allows or disallows various types of incoming calls for a specified department.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "department_full_path_name",
            "departmentFullPathName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_from_within_group",
            "allowFromWithinGroup",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_from_outside_group",
            "allowFromOutsideGroup",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_collect_calls",
            "allowCollectCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern_permission",
            "digitPatternPermission",
            IncomingCallingPlanDigitPatternPermission,
            True,
            False,
            True,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: str: *Required* departmentFullPathName
    department_full_path_name = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowFromWithinGroup
    allow_from_within_group = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* allowFromOutsideGroup
    allow_from_outside_group = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowCollectCalls
    allow_collect_calls = Field(
        type=bool,
        required=True,
    )
    #: list(IncomingCallingPlanDigitPatternPermission): *Optional* digitPatternPermission
    #:  *Array*
    digit_pattern_permission = Field(
        type=list,
        required=False,
    )


class IncomingCallingPlanDepartmentPermissionsModify(OCIType):
    """
    Allows or disallows various types of incoming calls for a specified department.
    For use when modifing settings.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "allow_from_within_group",
            "allowFromWithinGroup",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_from_outside_group",
            "allowFromOutsideGroup",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_collect_calls",
            "allowCollectCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "digit_pattern_permission",
            "digitPatternPermission",
            IncomingCallingPlanDigitPatternPermission,
            True,
            False,
            True,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: bool: *Optional* allowFromWithinGroup
    allow_from_within_group = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* allowFromOutsideGroup
    allow_from_outside_group = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* allowCollectCalls
    allow_collect_calls = Field(
        type=bool,
        required=False,
    )
    #: list(IncomingCallingPlanDigitPatternPermission): *Optional* digitPatternPermission
    #:  *Array*
    digit_pattern_permission = Field(
        type=list,
        required=False,
    )


class IncomingCallingPlanPermissions(OCIType):
    """
    Allows or disallows various types of incoming calls for a user or group -- not
    any particular department.
    """

    _ELEMENTS = (
        E(
            "allow_from_within_group",
            "allowFromWithinGroup",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_from_outside_group",
            "allowFromOutsideGroup",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_collect_calls",
            "allowCollectCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern_permission",
            "digitPatternPermission",
            IncomingCallingPlanDigitPatternPermission,
            True,
            False,
            True,
            False,
        ),
    )
    #: bool: *Required* allowFromWithinGroup
    allow_from_within_group = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* allowFromOutsideGroup
    allow_from_outside_group = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowCollectCalls
    allow_collect_calls = Field(
        type=bool,
        required=True,
    )
    #: list(IncomingCallingPlanDigitPatternPermission): *Optional* digitPatternPermission
    #:  *Array*
    digit_pattern_permission = Field(
        type=list,
        required=False,
    )


class IncomingCallingPlanPermissionsModify(OCIType):
    """
    Allows or disallows various types of incoming calls for a user or group -- not
    any particular department.
    For use when modifing settings.
    """

    _ELEMENTS = (
        E(
            "allow_from_within_group",
            "allowFromWithinGroup",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_from_outside_group",
            "allowFromOutsideGroup",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_collect_calls",
            "allowCollectCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "digit_pattern_permission",
            "digitPatternPermission",
            IncomingCallingPlanDigitPatternPermission,
            True,
            False,
            True,
            False,
        ),
    )
    #: bool: *Optional* allowFromWithinGroup
    allow_from_within_group = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* allowFromOutsideGroup
    allow_from_outside_group = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* allowCollectCalls
    allow_collect_calls = Field(
        type=bool,
        required=False,
    )
    #: list(IncomingCallingPlanDigitPatternPermission): *Optional* digitPatternPermission
    #:  *Array*
    digit_pattern_permission = Field(
        type=list,
        required=False,
    )


class MWIDeliveryToMobileEndpointTemplateBody(OCIType):
    """
    MWI Delivery To Mobile Endpoint template body.
    """

    _ELEMENTS = (
        E(
            "line",
            "line",
            MWIDeliveryToMobileEndpointTemplateLine,
            True,
            True,
            False,
            False,
        ),
    )
    #: MWIDeliveryToMobileEndpointTemplateLine: *Required* line
    line = Field(
        type=MWIDeliveryToMobileEndpointTemplateLine,
        required=True,
    )


class OutgoingCallingPlanCallMeNowDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan for Call Me Now call permissions for a department.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "permissions",
            "permissions",
            OutgoingCallingPlanCallMeNowPermissions,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )
    #: OutgoingCallingPlanCallMeNowPermissions: *Required* permissions
    permissions = Field(
        type=OutgoingCallingPlanCallMeNowPermissions,
        required=True,
    )


class OutgoingCallingPlanCallMeNowDepartmentPermissionsModify(OCIType):
    """
    Modify outgoing Calling Plan for Call Me Now call permissions for a department.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "permissions",
            "permissions",
            OutgoingCallingPlanCallMeNowPermissionsModify,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: OutgoingCallingPlanCallMeNowPermissionsModify: *Required* permissions
    permissions = Field(
        type=OutgoingCallingPlanCallMeNowPermissionsModify,
        required=True,
    )


class OutgoingCallingPlanDepartmentAuthorizationCodes(OCIType):
    """
    Outgoing Calling Plan Authorization Code for a department.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code_entry",
            "codeEntry",
            OutgoingCallingPlanAuthorizationCodeEntry,
            True,
            False,
            True,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )
    #: list(OutgoingCallingPlanAuthorizationCodeEntry): *Optional* codeEntry  *Array*
    code_entry = Field(
        type=list,
        required=False,
    )


class OutgoingCallingPlanDepartmentTransferNumbers(OCIType):
    """
    Outgoing Calling Plan transfer numbers for a department.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "transfer_numbers",
            "transferNumbers",
            OutgoingCallingPlanTransferNumbers,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )
    #: OutgoingCallingPlanTransferNumbers: *Required* transferNumbers
    transfer_numbers = Field(
        type=OutgoingCallingPlanTransferNumbers,
        required=True,
    )


class OutgoingCallingPlanDepartmentTransferNumbersModify(OCIType):
    """
    Outgoing Calling Plan transfer numbers for a department.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "transfer_numbers",
            "transferNumbers",
            OutgoingCallingPlanTransferNumbersModify,
            True,
            False,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: OutgoingCallingPlanTransferNumbersModify: *Optional* transferNumbers
    transfer_numbers = Field(
        type=OutgoingCallingPlanTransferNumbersModify,
        required=False,
    )


class OutgoingCallingPlanDigitPatternCallMeNowPermissions(OCIType):
    """
    Outgoing Calling Plan Call Me Now call permissions for specified digit patterns.
    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions",
            "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternCallMeNowPermission,
            True,
            True,
            False,
            False,
        ),
    )
    #: OutgoingCallingPlanDigitPatternCallMeNowPermission: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternCallMeNowPermission,
        required=True,
    )


class OutgoingCallingPlanDigitPatternOriginatingPermissions(OCIType):
    """
    Outgoing Calling Plan originating call permissions for specified digit patterns.
    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions",
            "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternOriginatingPermission,
            True,
            True,
            False,
            False,
        ),
    )
    #: OutgoingCallingPlanDigitPatternOriginatingPermission: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternOriginatingPermission,
        required=True,
    )


class OutgoingCallingPlanDigitPatternRedirectingPermissions(OCIType):
    """
    Outgoing Calling Plan redirecting call permissions for specified digit patterns.
    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions",
            "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternRedirectingPermission,
            True,
            True,
            False,
            False,
        ),
    )
    #: OutgoingCallingPlanDigitPatternRedirectingPermission: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternRedirectingPermission,
        required=True,
    )


class OutgoingCallingPlanGroupAuthorizationCodes(OCIType):
    """
    Outgoing Calling Plan Authorization Code for the group default.
    """

    _ELEMENTS = (
        E(
            "code_entry",
            "codeEntry",
            OutgoingCallingPlanAuthorizationCodeEntry,
            True,
            False,
            True,
            False,
        ),
    )
    #: list(OutgoingCallingPlanAuthorizationCodeEntry): *Optional* codeEntry  *Array*
    code_entry = Field(
        type=list,
        required=False,
    )


class OutgoingCallingPlanOriginatingDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan originating call permissions for a department.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "permissions",
            "permissions",
            OutgoingCallingPlanOriginatingPermissions,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )
    #: OutgoingCallingPlanOriginatingPermissions: *Required* permissions
    permissions = Field(
        type=OutgoingCallingPlanOriginatingPermissions,
        required=True,
    )


class OutgoingCallingPlanOriginatingDepartmentPermissionsModify(OCIType):
    """
    Outgoing Calling Plan originating call permissions for a department.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "permissions",
            "permissions",
            OutgoingCallingPlanOriginatingPermissionsModify,
            True,
            False,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: OutgoingCallingPlanOriginatingPermissionsModify: *Optional* permissions
    permissions = Field(
        type=OutgoingCallingPlanOriginatingPermissionsModify,
        required=False,
    )


class OutgoingCallingPlanRedirectedDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan being forwarded/transferred permissions for a department.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "permissions",
            "permissions",
            OutgoingCallingPlanRedirectedPermissions,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )
    #: OutgoingCallingPlanRedirectedPermissions: *Required* permissions
    permissions = Field(
        type=OutgoingCallingPlanRedirectedPermissions,
        required=True,
    )


class OutgoingCallingPlanRedirectedDepartmentPermissionsModify(OCIType):
    """
    Outgoing Calling Plan being forwarded/transferred permissions for a department.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "permissions",
            "permissions",
            OutgoingCallingPlanRedirectedPermissionsModify,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: OutgoingCallingPlanRedirectedPermissionsModify: *Required* permissions
    permissions = Field(
        type=OutgoingCallingPlanRedirectedPermissionsModify,
        required=True,
    )


class OutgoingCallingPlanRedirectingDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan initiating call forwards/transfer permissions for a department.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "permissions",
            "permissions",
            OutgoingCallingPlanRedirectingPermissions,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )
    #: OutgoingCallingPlanRedirectingPermissions: *Required* permissions
    permissions = Field(
        type=OutgoingCallingPlanRedirectingPermissions,
        required=True,
    )


class OutgoingCallingPlanRedirectingDepartmentPermissionsModify(OCIType):
    """
    Outgoing Calling Plan initiating call forwards/transfer permissions for a department.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "permissions",
            "permissions",
            OutgoingCallingPlanRedirectingPermissionsModify,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: OutgoingCallingPlanRedirectingPermissionsModify: *Required* permissions
    permissions = Field(
        type=OutgoingCallingPlanRedirectingPermissionsModify,
        required=True,
    )


class OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan Call Me Now call permissions for specified digit patterns.
    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions",
            "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternCallMeNowPermission,
            True,
            True,
            False,
            False,
        ),
    )
    #: OutgoingPinholeDigitPlanDigitPatternCallMeNowPermission: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternCallMeNowPermission,
        required=True,
    )


class OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan originating call permissions for specified digit patterns.
    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions",
            "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternOriginatingPermission,
            True,
            True,
            False,
            False,
        ),
    )
    #: OutgoingPinholeDigitPlanDigitPatternOriginatingPermission: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternOriginatingPermission,
        required=True,
    )


class OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan redirecting call permissions for specified digit patterns.
    """

    _ELEMENTS = (
        E(
            "digit_pattern_permissions",
            "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternRedirectingPermission,
            True,
            True,
            False,
            False,
        ),
    )
    #: OutgoingPinholeDigitPlanDigitPatternRedirectingPermission: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternRedirectingPermission,
        required=True,
    )


class PriorityAlertCriteriaFromDnModify(OCIType):
    """
    The from dn criteria used within a modify request.
    """

    _ELEMENTS = (
        E(
            "from_dn_criteria_selection",
            "fromDnCriteriaSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_anonymous_callers",
            "includeAnonymousCallers",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_unavailable_callers",
            "includeUnavailableCallers",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number_list",
            "phoneNumberList",
            CriteriaReplacementDNList,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* fromDnCriteriaSelection
    from_dn_criteria_selection = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* includeAnonymousCallers
    include_anonymous_callers = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* includeUnavailableCallers
    include_unavailable_callers = Field(
        type=bool,
        required=False,
    )
    #: CriteriaReplacementDNList: *Optional* phoneNumberList
    phone_number_list = Field(
        type=CriteriaReplacementDNList,
        required=False,
    )


class ReplacementCallToNumberList(OCIType):
    """
    A list of Call to Numbers that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    For the callToNumbers, the extension element is not used and the number element
    is only used when the type is BroadWorks Mobility.
    """

    _ELEMENTS = (
        E(
            "call_to_number",
            "callToNumber",
            CallToNumber,
            True,
            True,
            False,
            False,
        ),
    )
    #: CallToNumber: *Required* callToNumber
    call_to_number = Field(
        type=CallToNumber,
        required=True,
    )


class ReplacementCommunicationBarringCallMeNowRuleList(OCIType):
    """
    A list of Communication Barring CallMeNow Rules that replaces a
    previously configured list. By convention, an element of this type
    may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "rule",
            "rule",
            CommunicationBarringCallMeNowRule,
            True,
            True,
            False,
            False,
        ),
    )
    #: CommunicationBarringCallMeNowRule: *Required* rule
    rule = Field(
        type=CommunicationBarringCallMeNowRule,
        required=True,
    )


class ReplacementCommunicationBarringIncomingRuleList(OCIType):
    """
    A list of Communication Barring Incoming Rules that replaces a
    previously configured list. By convention, an element of this type
    may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "rule",
            "rule",
            CommunicationBarringIncomingRule,
            True,
            True,
            False,
            False,
        ),
    )
    #: CommunicationBarringIncomingRule: *Required* rule
    rule = Field(
        type=CommunicationBarringIncomingRule,
        required=True,
    )


class ReplacementCommunicationBarringIncomingRuleList19sp1(OCIType):
    """
    A list of Communication Barring Incoming Rules that replaces a
    previously configured list. By convention, an element of this type
    may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "rule",
            "rule",
            CommunicationBarringIncomingRule19sp1,
            True,
            True,
            False,
            False,
        ),
    )
    #: CommunicationBarringIncomingRule19sp1: *Required* rule
    rule = Field(
        type=CommunicationBarringIncomingRule19sp1,
        required=True,
    )


class ReplacementCommunicationBarringOriginatingRuleList(OCIType):
    """
    A list of Communication Barring Originating Rules that replaces a
    previously configured list. By convention, an element of this type
    may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "rule",
            "rule",
            CommunicationBarringOriginatingRule,
            True,
            True,
            False,
            False,
        ),
    )
    #: CommunicationBarringOriginatingRule: *Required* rule
    rule = Field(
        type=CommunicationBarringOriginatingRule,
        required=True,
    )


class ReplacementCommunicationBarringRedirectingRuleList(OCIType):
    """
    A list of Communication Barring Redirecting Rules that replaces a
    previously configured list. By convention, an element of this type
    may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "rule",
            "rule",
            CommunicationBarringRedirectingRule,
            True,
            True,
            False,
            False,
        ),
    )
    #: CommunicationBarringRedirectingRule: *Required* rule
    rule = Field(
        type=CommunicationBarringRedirectingRule,
        required=True,
    )


class ReplacementCustomContactDirectoryEntryList(OCIType):
    """
    A list of userIds and/or Virtual On-Net user DNs that replaces a previously
    configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "entry",
            "entry",
            CustomContactDirectoryEntry,
            True,
            True,
            False,
            False,
        ),
    )
    #: CustomContactDirectoryEntry: *Required* entry
    entry = Field(
        type=CustomContactDirectoryEntry,
        required=True,
    )


class ReplacementDeviceList(OCIType):
    """
    A list of devices that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "device",
            "device",
            AccessDevice,
            True,
            True,
            False,
            False,
        ),
    )
    #: AccessDevice: *Required* device
    device = Field(
        type=AccessDevice,
        required=True,
    )


class ReplacementEnterpriseEnterpriseTrunkTrunkGroupKeyList(OCIType):
    """
    A list of Enterprise Trunk Krunk Group Keys that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "trunk_group",
            "trunkGroup",
            EnterpriseTrunkTrunkGroupKey,
            True,
            True,
            False,
            False,
        ),
    )
    #: EnterpriseTrunkTrunkGroupKey: *Required* trunkGroup
    trunk_group = Field(
        type=EnterpriseTrunkTrunkGroupKey,
        required=True,
    )


class ReplacementEnterpriseTrunkTrunkGroupKeyList(OCIType):
    """
    A list of Enterprise Trunk Krunk Group Keys that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "trunk_group_list",
            "trunkGroupList",
            EnterpriseTrunkTrunkGroupKey,
            True,
            True,
            False,
            False,
        ),
    )
    #: EnterpriseTrunkTrunkGroupKey: *Required* trunkGroupList
    trunk_group_list = Field(
        type=EnterpriseTrunkTrunkGroupKey,
        required=True,
    )


class ReplacementGroupEnterpriseTrunkPriorityWeightedTrunkGroupList(OCIType):
    """
    A list of enterprise trunk priority weighted trunk groups in a group that
    replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "trunk_group",
            "trunkGroup",
            GroupEnterpriseTrunkPriorityWeightedTrunkGroup,
            True,
            True,
            False,
            False,
        ),
    )
    #: GroupEnterpriseTrunkPriorityWeightedTrunkGroup: *Required* trunkGroup
    trunk_group = Field(
        type=GroupEnterpriseTrunkPriorityWeightedTrunkGroup,
        required=True,
    )


class ScheduleEvents(OCIType):
    """
    Retrives all Holiday or Time Event details for a given schedulel Level.
    """

    _ELEMENTS = (
        E(
            "eventname",
            "eventname",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "start_date",
            "startDate",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "all_day_event",
            "allDayEvent",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "start_time",
            "startTime",
            HourMinute,
            True,
            True,
            False,
            False,
        ),
        E(
            "end_time",
            "endTime",
            HourMinute,
            True,
            True,
            False,
            False,
        ),
        E(
            "end_date",
            "endDate",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "recurrence",
            "recurrence",
            Recurrence,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* eventname
    eventname = Field(
        type=str,
        required=True,
    )
    #: str: *Required* startDate
    start_date = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* allDayEvent
    all_day_event = Field(
        type=bool,
        required=False,
    )
    #: HourMinute: *Required* startTime
    start_time = Field(
        type=HourMinute,
        required=True,
    )
    #: HourMinute: *Required* endTime
    end_time = Field(
        type=HourMinute,
        required=True,
    )
    #: str: *Required* endDate
    end_date = Field(
        type=str,
        required=True,
    )
    #: Recurrence: *Optional* recurrence
    recurrence = Field(
        type=Recurrence,
        required=False,
    )


class ScheduleGlobalKey(OCIType):
    """
    Uniquely identifies Holiday and Time Schedules throughout all System, Service
    Provider, Group and User level.
    """

    _ELEMENTS = (
        E(
            "schedule_key",
            "scheduleKey",
            ScheduleKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "schedule_level",
            "scheduleLevel",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: ScheduleKey: *Required* scheduleKey
    schedule_key = Field(
        type=ScheduleKey,
        required=True,
    )
    #: str: *Required* scheduleLevel
    schedule_level = Field(
        type=str,
        required=True,
    )


class SearchCriteriaExactCallCenterReportTemplateKey(OCIType):
    """
    Criteria for searching for a particular call center enhanced reporting report template.
    """

    _ELEMENTS = (
        E(
            "report_template",
            "reportTemplate",
            CallCenterReportTemplateKey,
            True,
            True,
            False,
            False,
        ),
    )
    #: CallCenterReportTemplateKey: *Required* reportTemplate
    report_template = Field(
        type=CallCenterReportTemplateKey,
        required=True,
    )


class SearchCriteriaExactDnDepartment(OCIType):
    """
    Criteria for searching for a particular fully specified DN's department.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )


class SearchCriteriaExactUserDepartment(OCIType):
    """
    Criteria for searching for a particular fully specified user's department.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )


class SelectiveCallRejectionCriteriaCallTypeModify(OCIType):
    """
    The call type criteria used within a modify request.
    """

    _ELEMENTS = (
        E(
            "from_dn_criteria_selection",
            "fromDnCriteriaSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_anonymous_callers",
            "includeAnonymousCallers",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_unavailable_callers",
            "includeUnavailableCallers",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number_list",
            "phoneNumberList",
            CriteriaReplacementDNList,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* fromDnCriteriaSelection
    from_dn_criteria_selection = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* includeAnonymousCallers
    include_anonymous_callers = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* includeUnavailableCallers
    include_unavailable_callers = Field(
        type=bool,
        required=False,
    )
    #: CriteriaReplacementDNList: *Optional* phoneNumberList
    phone_number_list = Field(
        type=CriteriaReplacementDNList,
        required=False,
    )


class ServiceInstanceAddProfile(OCIType):
    """
    Service Profile Information for group service.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "hiragana_last_name",
            "hiraganaLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_first_name",
            "hiraganaFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone",
            "timeZone",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alias",
            "alias",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "public_user_identity",
            "publicUserIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_phone_number",
            "callingLineIdPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* password
    password = Field(
        type=str,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZone
    time_zone = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alias
    alias = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* publicUserIdentity
    public_user_identity = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(
        type=str,
        required=False,
    )


class ServiceInstanceAddProfileCallCenter(OCIType):
    """
    Service Profile Information for a call center.
    Password is required.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "hiragana_last_name",
            "hiraganaLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_first_name",
            "hiraganaFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone",
            "timeZone",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alias",
            "alias",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "public_user_identity",
            "publicUserIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_phone_number",
            "callingLineIdPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: str: *Required* password
    password = Field(
        type=str,
        required=True,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZone
    time_zone = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alias
    alias = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* publicUserIdentity
    public_user_identity = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(
        type=str,
        required=False,
    )


class ServiceInstanceAddProfileFlexibleSeatingHost(OCIType):
    """
    Service Profile Information for a flexible seating host.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "hiragana_last_name",
            "hiraganaLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_first_name",
            "hiraganaFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone",
            "timeZone",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_phone_number",
            "callingLineIdPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* password
    password = Field(
        type=str,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZone
    time_zone = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(
        type=str,
        required=False,
    )


class ServiceInstanceAddProfileTrunkGroup(OCIType):
    """
    Service Profile Information for a trunk group.
    The publicUserIdentity element is not part of ServiceInstanceAddProfileTrunkGroup.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "hiragana_last_name",
            "hiraganaLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_first_name",
            "hiraganaFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone",
            "timeZone",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alias",
            "alias",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_phone_number",
            "callingLineIdPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* password
    password = Field(
        type=str,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZone
    time_zone = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alias
    alias = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(
        type=str,
        required=False,
    )


class ServiceInstanceModifyProfile(OCIType):
    """
    Service Profile Information for group service used when modifying an existing
    service instance.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_last_name",
            "hiraganaLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_first_name",
            "hiraganaFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone",
            "timeZone",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "sip_alias_list",
            "sipAliasList",
            ReplacementSIPAliasList,
            True,
            False,
            False,
            False,
        ),
        E(
            "public_user_identity",
            "publicUserIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_phone_number",
            "callingLineIdPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* name
    name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* password
    password = Field(
        type=str,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZone
    time_zone = Field(
        type=str,
        required=False,
    )
    #: ReplacementSIPAliasList: *Optional* sipAliasList
    sip_alias_list = Field(
        type=ReplacementSIPAliasList,
        required=False,
    )
    #: str: *Optional* publicUserIdentity
    public_user_identity = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(
        type=str,
        required=False,
    )


class ServiceInstanceModifyProfileFlexibleSeatingHost(OCIType):
    """
    Service Profile Information for a flexible seating host
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_last_name",
            "hiraganaLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_first_name",
            "hiraganaFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone",
            "timeZone",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_phone_number",
            "callingLineIdPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* name
    name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* password
    password = Field(
        type=str,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZone
    time_zone = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(
        type=str,
        required=False,
    )


class ServiceInstanceModifyProfileTrunkGroup(OCIType):
    """
    Service Profile Information for a trunk group used when modifying an existing
    service instance.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_last_name",
            "hiraganaLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_first_name",
            "hiraganaFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone",
            "timeZone",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "sip_alias_list",
            "sipAliasList",
            ReplacementSIPAliasList,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* name
    name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* password
    password = Field(
        type=str,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZone
    time_zone = Field(
        type=str,
        required=False,
    )
    #: ReplacementSIPAliasList: *Optional* sipAliasList
    sip_alias_list = Field(
        type=ReplacementSIPAliasList,
        required=False,
    )


class ServiceInstanceReadProfile(OCIType):
    """
    Service Profile Information for group service.
    It is identical to the ServiceInstanceAddProfile, but without the password.
    Prior to release 14 this was called ServiceInstanceProfile.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "hiragana_last_name",
            "hiraganaLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_first_name",
            "hiraganaFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone",
            "timeZone",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone_display_name",
            "timeZoneDisplayName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alias",
            "alias",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "public_user_identity",
            "publicUserIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZone
    time_zone = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZoneDisplayName
    time_zone_display_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alias
    alias = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* publicUserIdentity
    public_user_identity = Field(
        type=str,
        required=False,
    )


class ServiceInstanceReadProfile17(OCIType):
    """
    Service Profile Information for group service.
    It is identical to the ServiceInstanceAddProfile, but without the password.

    Replaced By ServiceInstanceReadProfile17sp4
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "hiragana_last_name",
            "hiraganaLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_first_name",
            "hiraganaFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone",
            "timeZone",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone_display_name",
            "timeZoneDisplayName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alias",
            "alias",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "public_user_identity",
            "publicUserIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZone
    time_zone = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZoneDisplayName
    time_zone_display_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alias
    alias = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* publicUserIdentity
    public_user_identity = Field(
        type=str,
        required=False,
    )


class ServiceInstanceReadProfile17sp4(OCIType):
    """
    Service Profile Information for group service.

    Replaced By ServiceInstanceReadProfile19sp1
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "hiragana_last_name",
            "hiraganaLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_first_name",
            "hiraganaFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "country_code",
            "countryCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "national_prefix",
            "nationalPrefix",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone",
            "timeZone",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone_display_name",
            "timeZoneDisplayName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alias",
            "alias",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "public_user_identity",
            "publicUserIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* countryCode
    country_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* nationalPrefix
    national_prefix = Field(
        type=str,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZone
    time_zone = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZoneDisplayName
    time_zone_display_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alias
    alias = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* publicUserIdentity
    public_user_identity = Field(
        type=str,
        required=False,
    )


class ServiceInstanceReadProfile19sp1(OCIType):
    """
    Service Profile Information for group service.

    The callingLineIdPhoneNumber is no longer being formatted for display purpose.
    The value is returned exactly the same as being stored.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "hiragana_last_name",
            "hiraganaLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_first_name",
            "hiraganaFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "country_code",
            "countryCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "national_prefix",
            "nationalPrefix",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone",
            "timeZone",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone_display_name",
            "timeZoneDisplayName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alias",
            "alias",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "public_user_identity",
            "publicUserIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_phone_number",
            "callingLineIdPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* countryCode
    country_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* nationalPrefix
    national_prefix = Field(
        type=str,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZone
    time_zone = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZoneDisplayName
    time_zone_display_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alias
    alias = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* publicUserIdentity
    public_user_identity = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(
        type=str,
        required=False,
    )


class ServicePackAuthorization(OCIType):
    """
    Authorize (with quantity) or unauthorize a service pack.
    """

    _ELEMENTS = (
        E(
            "service_pack_name",
            "servicePackName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "authorized_quantity",
            "authorizedQuantity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "unauthorized",
            "unauthorized",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* servicePackName
    service_pack_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* authorizedQuantity
    authorized_quantity = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* unauthorized
    unauthorized = Field(
        type=bool,
        required=False,
    )


class ServiceProviderCommunicationBarringProfileGetResponse19sp1V2(OCIType):
    """
    Response to the ServiceProviderCommunicationBarringProfileGetRequest19sp1V2.
    The response contains the Communication Barring Profile information.
    The incoming, originating, redirecting and call me now rules are returned in
    ascending priority order.
    The following elements are only used in AS data mode:
    callMeNowDefaultAction
    callMeNowDefaultCallTimeout
    callMeNowRule
    applyToAttendedCallTransfers
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "originating_default_action",
            "originatingDefaultAction",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "originating_default_treatment_id",
            "originatingDefaultTreatmentId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "originating_default_transfer_number",
            "originatingDefaultTransferNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "originating_default_call_timeout",
            "originatingDefaultCallTimeout",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "originating_rule",
            "originatingRule",
            ServiceProviderCommunicationBarringHierarchicalOriginatingRule,
            True,
            False,
            True,
            False,
        ),
        E(
            "redirecting_default_action",
            "redirectingDefaultAction",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "redirecting_default_call_timeout",
            "redirectingDefaultCallTimeout",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_rule",
            "redirectingRule",
            ServiceProviderCommunicationBarringHierarchicalRedirectingRule,
            True,
            False,
            True,
            False,
        ),
        E(
            "call_me_now_default_action",
            "callMeNowDefaultAction",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_me_now_default_call_timeout",
            "callMeNowDefaultCallTimeout",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_me_now_rule",
            "callMeNowRule",
            ServiceProviderCommunicationBarringHierarchicalCallMeNowRule,
            True,
            False,
            True,
            False,
        ),
        E(
            "incoming_default_action",
            "incomingDefaultAction",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "incoming_default_call_timeout",
            "incomingDefaultCallTimeout",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "incoming_rule",
            "incomingRule",
            CommunicationBarringIncomingRule19sp1,
            True,
            False,
            True,
            False,
        ),
        E(
            "is_default",
            "isDefault",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "apply_to_attended_call_transfers",
            "applyToAttendedCallTransfers",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: str: *Required* originatingDefaultAction
    originating_default_action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* originatingDefaultTreatmentId
    originating_default_treatment_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* originatingDefaultTransferNumber
    originating_default_transfer_number = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* originatingDefaultCallTimeout
    originating_default_call_timeout = Field(
        type=int,
        required=False,
    )
    #: list(ServiceProviderCommunicationBarringHierarchicalOriginatingRule): *Optional*
    #: originatingRule  *Array*
    originating_rule = Field(
        type=list,
        required=False,
    )
    #: str: *Required* redirectingDefaultAction
    redirecting_default_action = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* redirectingDefaultCallTimeout
    redirecting_default_call_timeout = Field(
        type=int,
        required=False,
    )
    #: list(ServiceProviderCommunicationBarringHierarchicalRedirectingRule): *Optional*
    #: redirectingRule  *Array*
    redirecting_rule = Field(
        type=list,
        required=False,
    )
    #: str: *Required* callMeNowDefaultAction
    call_me_now_default_action = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* callMeNowDefaultCallTimeout
    call_me_now_default_call_timeout = Field(
        type=int,
        required=False,
    )
    #: list(ServiceProviderCommunicationBarringHierarchicalCallMeNowRule): *Optional*
    #: callMeNowRule  *Array*
    call_me_now_rule = Field(
        type=list,
        required=False,
    )
    #: str: *Required* incomingDefaultAction
    incoming_default_action = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* incomingDefaultCallTimeout
    incoming_default_call_timeout = Field(
        type=int,
        required=False,
    )
    #: list(CommunicationBarringIncomingRule19sp1): *Optional* incomingRule  *Array*
    incoming_rule = Field(
        type=list,
        required=False,
    )
    #: bool: *Required* isDefault
    is_default = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* applyToAttendedCallTransfers
    apply_to_attended_call_transfers = Field(
        type=bool,
        required=True,
    )


class ServiceProviderReplacementCommunicationBarringHierarchicalCallMeNowRuleList(
    OCIType,
):
    """
    A list of Service Provider Communication Barring Hierarchical Call Me Now Rules
    that replaces a previously configured list. By convention, an element of this type
    may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "rule",
            "rule",
            ServiceProviderCommunicationBarringHierarchicalCallMeNowRule,
            True,
            True,
            False,
            False,
        ),
    )
    #: ServiceProviderCommunicationBarringHierarchicalCallMeNowRule: *Required* rule
    rule = Field(
        type=ServiceProviderCommunicationBarringHierarchicalCallMeNowRule,
        required=True,
    )


class ServiceProviderReplacementCommunicationBarringHierarchicalOriginatingRuleList(
    OCIType,
):
    """
    A list of Service Provider Communication Barring Hierarchical Originating Rules
    that replaces a previously configured list. By convention, an element of this type
    may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "rule",
            "rule",
            ServiceProviderCommunicationBarringHierarchicalOriginatingRule,
            True,
            True,
            False,
            False,
        ),
    )
    #: ServiceProviderCommunicationBarringHierarchicalOriginatingRule: *Required* rule
    rule = Field(
        type=ServiceProviderCommunicationBarringHierarchicalOriginatingRule,
        required=True,
    )


class ServiceProviderReplacementCommunicationBarringHierarchicalRedirectingRuleList(
    OCIType,
):
    """
    A list of Service Provider Communication Barring Hierarchical Redirecting Rules
    that replaces a previously configured list. By convention, an element of this type
    may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "rule",
            "rule",
            ServiceProviderCommunicationBarringHierarchicalRedirectingRule,
            True,
            True,
            False,
            False,
        ),
    )
    #: ServiceProviderCommunicationBarringHierarchicalRedirectingRule: *Required* rule
    rule = Field(
        type=ServiceProviderCommunicationBarringHierarchicalRedirectingRule,
        required=True,
    )


class ShInterfaceUserIdDataEntry(OCIType):
    """
    ShInterface User Id Data Entry.
    """

    _ELEMENTS = (
        E(
            "user_type",
            "userType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "public_user_identity",
            "publicUserIdentity",
            PublicUserIdentity,
            True,
            True,
            False,
            False,
        ),
        E(
            "endpoint_type",
            "endpointType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "scscf_name",
            "SCSCFName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "ims_user_state",
            "IMSUserState",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userType
    user_type = Field(
        type=str,
        required=True,
    )
    #: PublicUserIdentity: *Required* publicUserIdentity
    public_user_identity = Field(
        type=PublicUserIdentity,
        required=True,
    )
    #: str: *Required* endpointType
    endpoint_type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* SCSCFName
    scscf_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* IMSUserState
    ims_user_state = Field(
        type=str,
        required=True,
    )


class ShInterfaceUserListEntry(OCIType):
    """
    ShInterface User List Entry.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_type",
            "userType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "public_user_identity",
            "publicUserIdentity",
            PublicUserIdentity,
            True,
            True,
            False,
            False,
        ),
        E(
            "endpoint_type",
            "endpointType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "scscf_name",
            "SCSCFName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "ims_user_state",
            "IMSUserState",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userType
    user_type = Field(
        type=str,
        required=True,
    )
    #: PublicUserIdentity: *Required* publicUserIdentity
    public_user_identity = Field(
        type=PublicUserIdentity,
        required=True,
    )
    #: str: *Required* endpointType
    endpoint_type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* SCSCFName
    scscf_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* IMSUserState
    ims_user_state = Field(
        type=str,
        required=True,
    )


class SimultaneousRingReplacementNumberList(OCIType):
    """
    A list of Simultaneous Ring numbers that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "simultaneous_ring_number",
            "simultaneousRingNumber",
            SimultaneousRingNumber,
            True,
            True,
            False,
            False,
        ),
    )
    #: SimultaneousRingNumber: *Required* simultaneousRingNumber
    simultaneous_ring_number = Field(
        type=SimultaneousRingNumber,
        required=True,
    )


class SystemCommunicationBarringProfileGetResponse19sp1V2(OCIType):
    """
    Response to the SystemCommunicationBarringProfileGetRequest19sp1V2.
    The response contains the Communication Barring Profile information.
    The incoming rules are returned in ascending priority order.
    The following elements are only used in AS data mode:
    callMeNowDefaultAction
    callMeNowDefaultCallTimeout
    callMeNowRule
    applyToAttendedCallTransfers
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "originating_default_action",
            "originatingDefaultAction",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "originating_default_treatment_id",
            "originatingDefaultTreatmentId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "originating_default_transfer_number",
            "originatingDefaultTransferNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "originating_default_call_timeout",
            "originatingDefaultCallTimeout",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "originating_rule",
            "originatingRule",
            CommunicationBarringOriginatingRule,
            True,
            False,
            True,
            False,
        ),
        E(
            "redirecting_default_action",
            "redirectingDefaultAction",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "redirecting_default_call_timeout",
            "redirectingDefaultCallTimeout",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "redirecting_rule",
            "redirectingRule",
            CommunicationBarringRedirectingRule,
            True,
            False,
            True,
            False,
        ),
        E(
            "incoming_default_action",
            "incomingDefaultAction",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "incoming_default_call_timeout",
            "incomingDefaultCallTimeout",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "incoming_rule",
            "incomingRule",
            CommunicationBarringIncomingRule19sp1,
            True,
            False,
            True,
            False,
        ),
        E(
            "call_me_now_default_action",
            "callMeNowDefaultAction",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_me_now_default_call_timeout",
            "callMeNowDefaultCallTimeout",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_me_now_rule",
            "callMeNowRule",
            CommunicationBarringCallMeNowRule,
            True,
            False,
            True,
            False,
        ),
        E(
            "apply_to_attended_call_transfers",
            "applyToAttendedCallTransfers",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: str: *Required* originatingDefaultAction
    originating_default_action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* originatingDefaultTreatmentId
    originating_default_treatment_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* originatingDefaultTransferNumber
    originating_default_transfer_number = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* originatingDefaultCallTimeout
    originating_default_call_timeout = Field(
        type=int,
        required=False,
    )
    #: list(CommunicationBarringOriginatingRule): *Optional* originatingRule  *Array*
    originating_rule = Field(
        type=list,
        required=False,
    )
    #: str: *Required* redirectingDefaultAction
    redirecting_default_action = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* redirectingDefaultCallTimeout
    redirecting_default_call_timeout = Field(
        type=int,
        required=False,
    )
    #: list(CommunicationBarringRedirectingRule): *Optional* redirectingRule  *Array*
    redirecting_rule = Field(
        type=list,
        required=False,
    )
    #: str: *Required* incomingDefaultAction
    incoming_default_action = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* incomingDefaultCallTimeout
    incoming_default_call_timeout = Field(
        type=int,
        required=False,
    )
    #: list(CommunicationBarringIncomingRule19sp1): *Optional* incomingRule  *Array*
    incoming_rule = Field(
        type=list,
        required=False,
    )
    #: str: *Required* callMeNowDefaultAction
    call_me_now_default_action = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* callMeNowDefaultCallTimeout
    call_me_now_default_call_timeout = Field(
        type=int,
        required=False,
    )
    #: list(CommunicationBarringCallMeNowRule): *Optional* callMeNowRule  *Array*
    call_me_now_rule = Field(
        type=list,
        required=False,
    )
    #: bool: *Required* applyToAttendedCallTransfers
    apply_to_attended_call_transfers = Field(
        type=bool,
        required=True,
    )


class TrunkAddressingAdd(OCIType):
    """
    Trunk group endpoint.
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint",
            "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceEndpointAdd,
            True,
            False,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_trunk_identity",
            "alternateTrunkIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: TrunkGroupDeviceEndpointAdd: *Optional* trunkGroupDeviceEndpoint
    trunk_group_device_endpoint = Field(
        type=TrunkGroupDeviceEndpointAdd,
        required=False,
    )
    #: str: *Optional* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateTrunkIdentity
    alternate_trunk_identity = Field(
        type=str,
        required=False,
    )


class TrunkAddressingModify(OCIType):
    """
    Trunk group endpoint.
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint",
            "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceEndpointModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_trunk_identity",
            "alternateTrunkIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: TrunkGroupDeviceEndpointModify: *Optional* trunkGroupDeviceEndpoint
    trunk_group_device_endpoint = Field(
        type=TrunkGroupDeviceEndpointModify,
        required=False,
    )
    #: str: *Optional* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateTrunkIdentity
    alternate_trunk_identity = Field(
        type=str,
        required=False,
    )


class TrunkAddressingMultipleContactAdd(OCIType):
    """
    Trunk group endpoint that can have multiple contacts.
    alternateTrunkIdentityDomain is only used in IMS mode.
    Both alternateTrunkIdentity and AlternateTrunkIdentityDomain should be set at the
    same time if one is set in IMS mode.
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint",
            "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceMultipleContactEndpointAdd,
            True,
            False,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_trunk_identity",
            "alternateTrunkIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_trunk_identity_domain",
            "alternateTrunkIdentityDomain",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: TrunkGroupDeviceMultipleContactEndpointAdd: *Optional* trunkGroupDeviceEndpoint
    trunk_group_device_endpoint = Field(
        type=TrunkGroupDeviceMultipleContactEndpointAdd,
        required=False,
    )
    #: str: *Optional* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateTrunkIdentity
    alternate_trunk_identity = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateTrunkIdentityDomain
    alternate_trunk_identity_domain = Field(
        type=str,
        required=False,
    )


class TrunkAddressingMultipleContactRead(OCIType):
    """
    Trunk group endpoint that can have multiple contacts.

    Replaced By TrunkAddressingMultipleContactRead21
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint",
            "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceMultipleContactEndpointRead,
            True,
            False,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_trunk_identity",
            "alternateTrunkIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: TrunkGroupDeviceMultipleContactEndpointRead: *Optional* trunkGroupDeviceEndpoint
    trunk_group_device_endpoint = Field(
        type=TrunkGroupDeviceMultipleContactEndpointRead,
        required=False,
    )
    #: str: *Optional* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateTrunkIdentity
    alternate_trunk_identity = Field(
        type=str,
        required=False,
    )


class TrunkAddressingMultipleContactRead21(OCIType):
    """
    Trunk group endpoint that can have multiple contacts.
    alternateTrunkIdentityDomain is only used in IMS mode.
    The following elements are only used in AS data mode and ignored in HSS data mode:
    alternateTrunkIdentityDomain
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint",
            "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceMultipleContactEndpointRead,
            True,
            False,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_trunk_identity",
            "alternateTrunkIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_trunk_identity_domain",
            "alternateTrunkIdentityDomain",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: TrunkGroupDeviceMultipleContactEndpointRead: *Optional* trunkGroupDeviceEndpoint
    trunk_group_device_endpoint = Field(
        type=TrunkGroupDeviceMultipleContactEndpointRead,
        required=False,
    )
    #: str: *Optional* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateTrunkIdentity
    alternate_trunk_identity = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateTrunkIdentityDomain
    alternate_trunk_identity_domain = Field(
        type=str,
        required=False,
    )


class TrunkAddressingRead(OCIType):
    """
    Trunk group endpoint.
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint",
            "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceEndpointRead14sp4,
            True,
            False,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_trunk_identity",
            "alternateTrunkIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: TrunkGroupDeviceEndpointRead14sp4: *Optional* trunkGroupDeviceEndpoint
    trunk_group_device_endpoint = Field(
        type=TrunkGroupDeviceEndpointRead14sp4,
        required=False,
    )
    #: str: *Optional* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateTrunkIdentity
    alternate_trunk_identity = Field(
        type=str,
        required=False,
    )


class TrunkGroupDeviceMultipleContactEndpointModify(OCIType):
    """
    Trunk group device endpoint used in the context of modify that can have multiple contacts.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "contact_list",
            "contactList",
            ReplacementContactList,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* name
    name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* linePort
    line_port = Field(
        type=str,
        required=False,
    )
    #: ReplacementContactList: *Optional* contactList
    contact_list = Field(
        type=ReplacementContactList,
        required=False,
    )


class TrunkGroupMultipleContactPilotUser(OCIType):
    """
    Trunk Group pilot user information used when adding a Trunk Group.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "last_name",
            "lastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "first_name",
            "firstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "hiragana_last_name",
            "hiraganaLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_first_name",
            "hiraganaFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone",
            "timeZone",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_phone_number",
            "callingLineIdPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* lastName
    last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* firstName
    first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* password
    password = Field(
        type=str,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZone
    time_zone = Field(
        type=str,
        required=False,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(
        type=str,
        required=False,
    )


class TrunkGroupPilotUser(OCIType):
    """
    Trunk Group pilot user information used when adding a Trunk Group.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "last_name",
            "lastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "first_name",
            "firstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "hiragana_last_name",
            "hiraganaLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hiragana_first_name",
            "hiraganaFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "time_zone",
            "timeZone",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* lastName
    last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* firstName
    first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* hiraganaLastName
    hiragana_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* hiraganaFirstName
    hiragana_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* password
    password = Field(
        type=str,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* timeZone
    time_zone = Field(
        type=str,
        required=False,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )


class UserServiceAuthorization(OCIType):
    """
    Authorize (with quantity) or unauthorize a user service.
    """

    _ELEMENTS = (
        E(
            "service_name",
            "serviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "authorized_quantity",
            "authorizedQuantity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "unauthorized",
            "unauthorized",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceName
    service_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* authorizedQuantity
    authorized_quantity = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* unauthorized
    unauthorized = Field(
        type=bool,
        required=False,
    )


class VerifyTranslationAndRoutingParameters(OCIType):
    """
    Verification Translation and Routing parameters
    for creating a Verify Translation and Routing request from
    parameters.
    """

    _ELEMENTS = (
        E(
            "origination",
            "origination",
            VerifyTranslationAndRoutingOrigination,
            True,
            True,
            False,
            False,
        ),
        E(
            "destination",
            "destination",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact",
            "contact",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "diversion",
            "diversion",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: VerifyTranslationAndRoutingOrigination: *Required* origination
    origination = Field(
        type=VerifyTranslationAndRoutingOrigination,
        required=True,
    )
    #: str: *Required* destination
    destination = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* contact
    contact = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* diversion
    diversion = Field(
        type=str,
        required=False,
    )


class VirtualOnNetUserRange(OCIType):
    """
    Virtual On-Net User Range.
    """

    _ELEMENTS = (
        E(
            "dn_range",
            "dnRange",
            DNRange,
            True,
            True,
            False,
            False,
        ),
        E(
            "extension_range",
            "extensionRange",
            ExtensionRange17,
            True,
            True,
            False,
            False,
        ),
        E(
            "first_name",
            "firstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "last_name",
            "lastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "virtual_on_net_call_type_name",
            "virtualOnNetCallTypeName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: DNRange: *Required* dnRange
    dn_range = Field(
        type=DNRange,
        required=True,
    )
    #: ExtensionRange17: *Required* extensionRange
    extension_range = Field(
        type=ExtensionRange17,
        required=True,
    )
    #: str: *Required* firstName
    first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* lastName
    last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* virtualOnNetCallTypeName
    virtual_on_net_call_type_name = Field(
        type=str,
        required=True,
    )


class VoiceMessagingAlternateNoAnswerGreetingModify(OCIType):
    """
    The configuration of a alternate no answer greeting.
    It is used when modifying a user's voice messaging greeting.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            LabeledFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            LabeledFileResource,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* name
    name = Field(
        type=str,
        required=False,
    )
    #: LabeledFileResource: *Optional* audioFile
    audio_file = Field(
        type=LabeledFileResource,
        required=False,
    )
    #: LabeledFileResource: *Optional* videoFile
    video_file = Field(
        type=LabeledFileResource,
        required=False,
    )


class VoiceMessagingAlternateNoAnswerGreetingModify16(OCIType):
    """
    The configuration of a alternate no answer
    greeting.
    It is used when modifying a user's voice
    messaging
    greeting.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* name
    name = Field(
        type=str,
        required=False,
    )
    #: LabeledMediaFileResource: *Optional* audioFile
    audio_file = Field(
        type=LabeledMediaFileResource,
        required=False,
    )
    #: LabeledMediaFileResource: *Optional* videoFile
    video_file = Field(
        type=LabeledMediaFileResource,
        required=False,
    )


class VoiceMessagingAlternateNoAnswerGreetingModify20(OCIType):
    """
    The configuration of a alternate no answer greeting.
    It is used when modifying a user's voice messaging greeting.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* name
    name = Field(
        type=str,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* audioFile
    audio_file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* videoFile
    video_file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )


class VoiceMessagingAlternateNoAnswerGreetingRead20(OCIType):
    """
    The configuration of a alternate no answer greeting.
    It is used when geting a user's voice messaging greeting.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: AnnouncementFileLevelKey: *Optional* audioFile
    audio_file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* videoFile
    video_file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )


class AutoAttendantKeyConfiguration(OCIType):
    """
    The configuration of a key for Auto Attendant.
    """

    _ELEMENTS = (
        E(
            "key",
            "key",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "entry",
            "entry",
            AutoAttendantKeyConfigurationEntry,
            True,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* key
    key = Field(
        type=str,
        required=True,
    )
    #: AutoAttendantKeyConfigurationEntry: *Required* entry
    entry = Field(
        type=AutoAttendantKeyConfigurationEntry,
        required=True,
    )


class AutoAttendantKeyConfiguration19(OCIType):
    """
    The configuration of a key for Auto Attendant.
    """

    _ELEMENTS = (
        E(
            "key",
            "key",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "entry",
            "entry",
            AutoAttendantKeyConfigurationEntry19,
            True,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* key
    key = Field(
        type=str,
        required=True,
    )
    #: AutoAttendantKeyConfigurationEntry19: *Required* entry
    entry = Field(
        type=AutoAttendantKeyConfigurationEntry19,
        required=True,
    )


class AutoAttendantKeyConfiguration20(OCIType):
    """
    The configuration of a key for Auto Attendant.
    """

    _ELEMENTS = (
        E(
            "key",
            "key",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "entry",
            "entry",
            AutoAttendantKeyConfigurationEntry20,
            True,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* key
    key = Field(
        type=str,
        required=True,
    )
    #: AutoAttendantKeyConfigurationEntry20: *Required* entry
    entry = Field(
        type=AutoAttendantKeyConfigurationEntry20,
        required=True,
    )


class AutoAttendantKeyModifyConfiguration(OCIType):
    """
    The modify configuration of a key for Auto
    Attendant.
    """

    _ELEMENTS = (
        E(
            "key",
            "key",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "entry",
            "entry",
            AutoAttendantKeyConfigurationModifyEntry,
            True,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* key
    key = Field(
        type=str,
        required=True,
    )
    #: AutoAttendantKeyConfigurationModifyEntry: *Required* entry
    entry = Field(
        type=AutoAttendantKeyConfigurationModifyEntry,
        required=True,
    )


class AutoAttendantKeyModifyConfiguration20(OCIType):
    """
    The modify configuration of a key for Auto Attendant.
    """

    _ELEMENTS = (
        E(
            "key",
            "key",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "entry",
            "entry",
            AutoAttendantKeyConfigurationModifyEntry20,
            True,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* key
    key = Field(
        type=str,
        required=True,
    )
    #: AutoAttendantKeyConfigurationModifyEntry20: *Required* entry
    entry = Field(
        type=AutoAttendantKeyConfigurationModifyEntry20,
        required=True,
    )


class AutoAttendantKeyReadConfiguration20(OCIType):
    """
    The read configuration of a key for Auto Attendant.
    """

    _ELEMENTS = (
        E(
            "key",
            "key",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "entry",
            "entry",
            AutoAttendantKeyConfigurationReadEntry20,
            True,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* key
    key = Field(
        type=str,
        required=True,
    )
    #: AutoAttendantKeyConfigurationReadEntry20: *Required* entry
    entry = Field(
        type=AutoAttendantKeyConfigurationReadEntry20,
        required=True,
    )


class AutoAttendantReadMenu19(OCIType):
    """
    The configuration of the automated receptionist
    greeting
    prompt and dialing menu to be used during
    after business
    hours.
    """

    _ELEMENTS = (
        E(
            "announcement_selection",
            "announcementSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type",
            "audioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_media_type",
            "videoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "key_configuration",
            "keyConfiguration",
            AutoAttendantKeyReadConfiguration19,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* announcementSelection
    announcement_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMediaType
    audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMediaType
    video_media_type = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: AutoAttendantKeyReadConfiguration19: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyReadConfiguration19,
        required=False,
    )


class CPEDeviceModifyOptions(OCIType):
    """
    CPE device's options when used with a modify request.
    The following options are not changeable:
    configType
    systemFileName
    deviceFileFormat
    """

    _ELEMENTS = (
        E(
            "enable_monitoring",
            "enableMonitoring",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "reset_event",
            "resetEvent",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_management_device_type_options",
            "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeModifyOptions,
            True,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* enableMonitoring
    enable_monitoring = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* resetEvent
    reset_event = Field(
        type=str,
        required=False,
    )
    #: DeviceManagementDeviceTypeModifyOptions: *Optional*
    #: deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeModifyOptions,
        required=False,
    )


class CPEDeviceModifyOptions16(OCIType):
    """
    CPE device's options when used with a modify request.
    The following options are not changeable:
    configType
    systemFileName
    deviceFileFormat
    """

    _ELEMENTS = (
        E(
            "enable_monitoring",
            "enableMonitoring",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "reset_event",
            "resetEvent",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_management_device_type_options",
            "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeModifyOptions16,
            True,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* enableMonitoring
    enable_monitoring = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* resetEvent
    reset_event = Field(
        type=str,
        required=False,
    )
    #: DeviceManagementDeviceTypeModifyOptions16: *Optional*
    #: deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeModifyOptions16,
        required=False,
    )


class CPEDeviceModifyOptions16sp1(OCIType):
    """
    CPE device's options when used with a modify request.
    The following options are not changeable:
    configType
    systemFileName
    deviceFileFormat
    """

    _ELEMENTS = (
        E(
            "enable_monitoring",
            "enableMonitoring",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_management_device_type_options",
            "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeModifyOptions16,
            True,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* enableMonitoring
    enable_monitoring = Field(
        type=bool,
        required=False,
    )
    #: DeviceManagementDeviceTypeModifyOptions16: *Optional*
    #: deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeModifyOptions16,
        required=False,
    )


class CPEDeviceOptions14sp6(OCIType):
    """
    CPE device's options.
    """

    _ELEMENTS = (
        E(
            "enable_monitoring",
            "enableMonitoring",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "reset_event",
            "resetEvent",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "config_type",
            "configType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "system_file_name",
            "systemFileName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_file_format",
            "deviceFileFormat",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_management_device_type_options",
            "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptions,
            True,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* enableMonitoring
    enable_monitoring = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* resetEvent
    reset_event = Field(
        type=str,
        required=False,
    )
    #: str: *Required* configType
    config_type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* systemFileName
    system_file_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* deviceFileFormat
    device_file_format = Field(
        type=str,
        required=False,
    )
    #: DeviceManagementDeviceTypeOptions: *Optional* deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeOptions,
        required=False,
    )


class CPEDeviceOptions16(OCIType):
    """
    CPE device's options.
    """

    _ELEMENTS = (
        E(
            "enable_monitoring",
            "enableMonitoring",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "reset_event",
            "resetEvent",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "config_type",
            "configType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "system_file_name",
            "systemFileName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_file_format",
            "deviceFileFormat",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_management_device_type_options",
            "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptions16,
            True,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* enableMonitoring
    enable_monitoring = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* resetEvent
    reset_event = Field(
        type=str,
        required=False,
    )
    #: str: *Required* configType
    config_type = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* systemFileName
    system_file_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* deviceFileFormat
    device_file_format = Field(
        type=str,
        required=False,
    )
    #: DeviceManagementDeviceTypeOptions16: *Optional* deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeOptions16,
        required=False,
    )


class CPEDeviceOptions16sp1(OCIType):
    """
    CPE device's options.

    The field configType is optional to allow the use of field enableMonitoring for
    all device types being managed or not
    ie. device configuration option equals to DeviceManagement, or Legacy, or Not Supported).

    If the device configuration option is set to "Not Supported", the value of
    configType is forced set to "None" regardless
    of its current value.

    It is not allowed to add a device type with device configuration option set to
    Device Management or Legacy when the configType
    is not set.
    """

    _ELEMENTS = (
        E(
            "enable_monitoring",
            "enableMonitoring",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "config_type",
            "configType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "system_file_name",
            "systemFileName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_file_format",
            "deviceFileFormat",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_management_device_type_options",
            "deviceManagementDeviceTypeOptions",
            DeviceManagementDeviceTypeOptions16,
            True,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* enableMonitoring
    enable_monitoring = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* configType
    config_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* systemFileName
    system_file_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* deviceFileFormat
    device_file_format = Field(
        type=str,
        required=False,
    )
    #: DeviceManagementDeviceTypeOptions16: *Optional* deviceManagementDeviceTypeOptions
    device_management_device_type_options = Field(
        type=DeviceManagementDeviceTypeOptions16,
        required=False,
    )


class CallCenterMediaOnHoldSourceModify16(OCIType):
    """
    Contains the call center media on hold source configuration.
    """

    _ELEMENTS = (
        E(
            "audio_message_source_selection",
            "audioMessageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            ExtendedMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "external_audio_source",
            "externalAudioSource",
            AccessDeviceEndpointModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_message_source_selection",
            "videoMessageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            ExtendedMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "external_video_source",
            "externalVideoSource",
            AccessDeviceEndpointModify,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* audioMessageSourceSelection
    audio_message_source_selection = Field(
        type=str,
        required=False,
    )
    #: ExtendedMediaFileResource: *Optional* audioFile
    audio_file = Field(
        type=ExtendedMediaFileResource,
        required=False,
    )
    #: AccessDeviceEndpointModify: *Optional* externalAudioSource
    external_audio_source = Field(
        type=AccessDeviceEndpointModify,
        required=False,
    )
    #: str: *Optional* videoMessageSourceSelection
    video_message_source_selection = Field(
        type=str,
        required=False,
    )
    #: ExtendedMediaFileResource: *Optional* videoFile
    video_file = Field(
        type=ExtendedMediaFileResource,
        required=False,
    )
    #: AccessDeviceEndpointModify: *Optional* externalVideoSource
    external_video_source = Field(
        type=AccessDeviceEndpointModify,
        required=False,
    )


class CallCenterMediaOnHoldSourceModify17(OCIType):
    """
    Contains the call center media on hold source
    configuration.
    """

    _ELEMENTS = (
        E(
            "audio_message_source_selection",
            "audioMessageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_url_list",
            "audioUrlList",
            CallCenterAnnouncementURLListModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "audio_file_list",
            "audioFileList",
            CallCenterAnnouncementFileListModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "external_audio_source",
            "externalAudioSource",
            AccessDeviceEndpointModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_message_source_selection",
            "videoMessageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_url_list",
            "videoUrlList",
            CallCenterAnnouncementURLListModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file_list",
            "videoFileList",
            CallCenterAnnouncementFileListModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "external_video_source",
            "externalVideoSource",
            AccessDeviceEndpointModify,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* audioMessageSourceSelection
    audio_message_source_selection = Field(
        type=str,
        required=False,
    )
    #: CallCenterAnnouncementURLListModify: *Optional* audioUrlList
    audio_url_list = Field(
        type=CallCenterAnnouncementURLListModify,
        required=False,
    )
    #: CallCenterAnnouncementFileListModify: *Optional* audioFileList
    audio_file_list = Field(
        type=CallCenterAnnouncementFileListModify,
        required=False,
    )
    #: AccessDeviceEndpointModify: *Optional* externalAudioSource
    external_audio_source = Field(
        type=AccessDeviceEndpointModify,
        required=False,
    )
    #: str: *Optional* videoMessageSourceSelection
    video_message_source_selection = Field(
        type=str,
        required=False,
    )
    #: CallCenterAnnouncementURLListModify: *Optional* videoUrlList
    video_url_list = Field(
        type=CallCenterAnnouncementURLListModify,
        required=False,
    )
    #: CallCenterAnnouncementFileListModify: *Optional* videoFileList
    video_file_list = Field(
        type=CallCenterAnnouncementFileListModify,
        required=False,
    )
    #: AccessDeviceEndpointModify: *Optional* externalVideoSource
    external_video_source = Field(
        type=AccessDeviceEndpointModify,
        required=False,
    )


class CallCenterMediaOnHoldSourceModify20(OCIType):
    """
    Contains the call center media on hold source configuration.
    """

    _ELEMENTS = (
        E(
            "audio_message_source_selection",
            "audioMessageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_url_list",
            "audioUrlList",
            CallCenterAnnouncementURLListModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "audio_file_list",
            "audioFileList",
            CallCenterAnnouncementFileListModify20,
            True,
            False,
            False,
            False,
        ),
        E(
            "external_audio_source",
            "externalAudioSource",
            AccessDeviceEndpointModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_message_source_selection",
            "videoMessageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_url_list",
            "videoUrlList",
            CallCenterAnnouncementURLListModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file_list",
            "videoFileList",
            CallCenterAnnouncementFileListModify20,
            True,
            False,
            False,
            False,
        ),
        E(
            "external_video_source",
            "externalVideoSource",
            AccessDeviceEndpointModify,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* audioMessageSourceSelection
    audio_message_source_selection = Field(
        type=str,
        required=False,
    )
    #: CallCenterAnnouncementURLListModify: *Optional* audioUrlList
    audio_url_list = Field(
        type=CallCenterAnnouncementURLListModify,
        required=False,
    )
    #: CallCenterAnnouncementFileListModify20: *Optional* audioFileList
    audio_file_list = Field(
        type=CallCenterAnnouncementFileListModify20,
        required=False,
    )
    #: AccessDeviceEndpointModify: *Optional* externalAudioSource
    external_audio_source = Field(
        type=AccessDeviceEndpointModify,
        required=False,
    )
    #: str: *Optional* videoMessageSourceSelection
    video_message_source_selection = Field(
        type=str,
        required=False,
    )
    #: CallCenterAnnouncementURLListModify: *Optional* videoUrlList
    video_url_list = Field(
        type=CallCenterAnnouncementURLListModify,
        required=False,
    )
    #: CallCenterAnnouncementFileListModify20: *Optional* videoFileList
    video_file_list = Field(
        type=CallCenterAnnouncementFileListModify20,
        required=False,
    )
    #: AccessDeviceEndpointModify: *Optional* externalVideoSource
    external_video_source = Field(
        type=AccessDeviceEndpointModify,
        required=False,
    )


class CallCenterMediaOnHoldSourceRead16(OCIType):
    """
    Contains the call center media on hold source configuration.
    """

    _ELEMENTS = (
        E(
            "audio_message_source_selection",
            "audioMessageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file_url",
            "audioFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file_media_type",
            "audioFileMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "external_audio_source",
            "externalAudioSource",
            AccessDeviceEndpointRead14,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_message_source_selection",
            "videoMessageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_url",
            "videoFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_media_type",
            "videoFileMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "external_video_source",
            "externalVideoSource",
            AccessDeviceEndpointRead14,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* audioMessageSourceSelection
    audio_message_source_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioFileMediaType
    audio_file_media_type = Field(
        type=str,
        required=False,
    )
    #: AccessDeviceEndpointRead14: *Optional* externalAudioSource
    external_audio_source = Field(
        type=AccessDeviceEndpointRead14,
        required=False,
    )
    #: str: *Optional* videoMessageSourceSelection
    video_message_source_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileUrl
    video_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileMediaType
    video_file_media_type = Field(
        type=str,
        required=False,
    )
    #: AccessDeviceEndpointRead14: *Optional* externalVideoSource
    external_video_source = Field(
        type=AccessDeviceEndpointRead14,
        required=False,
    )


class CallCenterMediaOnHoldSourceRead17(OCIType):
    """
    Contains the call center media on hold source configuration.

    Replaced By CallCenterMediaOnHoldSourceRead19.
    """

    _ELEMENTS = (
        E(
            "audio_message_source_selection",
            "audioMessageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_url_list",
            "audioUrlList",
            CallCenterAnnouncementURLList,
            True,
            False,
            False,
            False,
        ),
        E(
            "audio_file_list",
            "audioFileList",
            CallCenterAnnouncementDescriptionList,
            True,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type_list",
            "audioMediaTypeList",
            CallCenterAnnouncementMediaFileTypeList,
            True,
            False,
            False,
            False,
        ),
        E(
            "external_audio_source",
            "externalAudioSource",
            AccessDeviceEndpointRead14,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_message_source_selection",
            "videoMessageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_url_list",
            "videoUrlList",
            CallCenterAnnouncementURLList,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file_list",
            "videoFileList",
            CallCenterAnnouncementDescriptionList,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_media_type_list",
            "videoMediaTypeList",
            CallCenterAnnouncementMediaFileTypeList,
            True,
            False,
            False,
            False,
        ),
        E(
            "external_video_source",
            "externalVideoSource",
            AccessDeviceEndpointRead14,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* audioMessageSourceSelection
    audio_message_source_selection = Field(
        type=str,
        required=True,
    )
    #: CallCenterAnnouncementURLList: *Optional* audioUrlList
    audio_url_list = Field(
        type=CallCenterAnnouncementURLList,
        required=False,
    )
    #: CallCenterAnnouncementDescriptionList: *Optional* audioFileList
    audio_file_list = Field(
        type=CallCenterAnnouncementDescriptionList,
        required=False,
    )
    #: CallCenterAnnouncementMediaFileTypeList: *Optional* audioMediaTypeList
    audio_media_type_list = Field(
        type=CallCenterAnnouncementMediaFileTypeList,
        required=False,
    )
    #: AccessDeviceEndpointRead14: *Optional* externalAudioSource
    external_audio_source = Field(
        type=AccessDeviceEndpointRead14,
        required=False,
    )
    #: str: *Optional* videoMessageSourceSelection
    video_message_source_selection = Field(
        type=str,
        required=False,
    )
    #: CallCenterAnnouncementURLList: *Optional* videoUrlList
    video_url_list = Field(
        type=CallCenterAnnouncementURLList,
        required=False,
    )
    #: CallCenterAnnouncementDescriptionList: *Optional* videoFileList
    video_file_list = Field(
        type=CallCenterAnnouncementDescriptionList,
        required=False,
    )
    #: CallCenterAnnouncementMediaFileTypeList: *Optional* videoMediaTypeList
    video_media_type_list = Field(
        type=CallCenterAnnouncementMediaFileTypeList,
        required=False,
    )
    #: AccessDeviceEndpointRead14: *Optional* externalVideoSource
    external_video_source = Field(
        type=AccessDeviceEndpointRead14,
        required=False,
    )


class CallCenterMediaOnHoldSourceRead19(OCIType):
    """
    Contains the call center media on hold source configuration.
    """

    _ELEMENTS = (
        E(
            "audio_message_source_selection",
            "audioMessageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_url_list",
            "audioUrlList",
            CallCenterAnnouncementURLList,
            True,
            False,
            False,
            False,
        ),
        E(
            "audio_file_list",
            "audioFileList",
            CallCenterAnnouncementDescriptionList,
            True,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type_list",
            "audioMediaTypeList",
            CallCenterAnnouncementMediaFileTypeList,
            True,
            False,
            False,
            False,
        ),
        E(
            "external_audio_source",
            "externalAudioSource",
            AccessDeviceEndpointWithPortNumberRead,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_message_source_selection",
            "videoMessageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_url_list",
            "videoUrlList",
            CallCenterAnnouncementURLList,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file_list",
            "videoFileList",
            CallCenterAnnouncementDescriptionList,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_media_type_list",
            "videoMediaTypeList",
            CallCenterAnnouncementMediaFileTypeList,
            True,
            False,
            False,
            False,
        ),
        E(
            "external_video_source",
            "externalVideoSource",
            AccessDeviceEndpointWithPortNumberRead,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* audioMessageSourceSelection
    audio_message_source_selection = Field(
        type=str,
        required=True,
    )
    #: CallCenterAnnouncementURLList: *Optional* audioUrlList
    audio_url_list = Field(
        type=CallCenterAnnouncementURLList,
        required=False,
    )
    #: CallCenterAnnouncementDescriptionList: *Optional* audioFileList
    audio_file_list = Field(
        type=CallCenterAnnouncementDescriptionList,
        required=False,
    )
    #: CallCenterAnnouncementMediaFileTypeList: *Optional* audioMediaTypeList
    audio_media_type_list = Field(
        type=CallCenterAnnouncementMediaFileTypeList,
        required=False,
    )
    #: AccessDeviceEndpointWithPortNumberRead: *Optional* externalAudioSource
    external_audio_source = Field(
        type=AccessDeviceEndpointWithPortNumberRead,
        required=False,
    )
    #: str: *Optional* videoMessageSourceSelection
    video_message_source_selection = Field(
        type=str,
        required=False,
    )
    #: CallCenterAnnouncementURLList: *Optional* videoUrlList
    video_url_list = Field(
        type=CallCenterAnnouncementURLList,
        required=False,
    )
    #: CallCenterAnnouncementDescriptionList: *Optional* videoFileList
    video_file_list = Field(
        type=CallCenterAnnouncementDescriptionList,
        required=False,
    )
    #: CallCenterAnnouncementMediaFileTypeList: *Optional* videoMediaTypeList
    video_media_type_list = Field(
        type=CallCenterAnnouncementMediaFileTypeList,
        required=False,
    )
    #: AccessDeviceEndpointWithPortNumberRead: *Optional* externalVideoSource
    external_video_source = Field(
        type=AccessDeviceEndpointWithPortNumberRead,
        required=False,
    )


class CallCenterMediaOnHoldSourceRead20(OCIType):
    """
    Contains the call center media on hold source configuration.
    """

    _ELEMENTS = (
        E(
            "audio_message_source_selection",
            "audioMessageSourceSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_url_list",
            "audioUrlList",
            CallCenterAnnouncementURLList,
            True,
            False,
            False,
            False,
        ),
        E(
            "audio_file_list",
            "audioFileList",
            CallCenterAnnouncementFileListRead20,
            True,
            False,
            False,
            False,
        ),
        E(
            "external_audio_source",
            "externalAudioSource",
            AccessDeviceEndpointWithPortNumberRead,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_message_source_selection",
            "videoMessageSourceSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_url_list",
            "videoUrlList",
            CallCenterAnnouncementURLList,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file_list",
            "videoFileList",
            CallCenterAnnouncementFileListRead20,
            True,
            False,
            False,
            False,
        ),
        E(
            "external_video_source",
            "externalVideoSource",
            AccessDeviceEndpointWithPortNumberRead,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* audioMessageSourceSelection
    audio_message_source_selection = Field(
        type=str,
        required=True,
    )
    #: CallCenterAnnouncementURLList: *Optional* audioUrlList
    audio_url_list = Field(
        type=CallCenterAnnouncementURLList,
        required=False,
    )
    #: CallCenterAnnouncementFileListRead20: *Optional* audioFileList
    audio_file_list = Field(
        type=CallCenterAnnouncementFileListRead20,
        required=False,
    )
    #: AccessDeviceEndpointWithPortNumberRead: *Optional* externalAudioSource
    external_audio_source = Field(
        type=AccessDeviceEndpointWithPortNumberRead,
        required=False,
    )
    #: str: *Optional* videoMessageSourceSelection
    video_message_source_selection = Field(
        type=str,
        required=False,
    )
    #: CallCenterAnnouncementURLList: *Optional* videoUrlList
    video_url_list = Field(
        type=CallCenterAnnouncementURLList,
        required=False,
    )
    #: CallCenterAnnouncementFileListRead20: *Optional* videoFileList
    video_file_list = Field(
        type=CallCenterAnnouncementFileListRead20,
        required=False,
    )
    #: AccessDeviceEndpointWithPortNumberRead: *Optional* externalVideoSource
    external_video_source = Field(
        type=AccessDeviceEndpointWithPortNumberRead,
        required=False,
    )


class CallCenterReportInterval(OCIType):
    """
    Report interval for call center enhanced reporting scheduled reports.
    """

    _ELEMENTS = (
        E(
            "dates",
            "dates",
            CallCenterReportIntervalDates,
            True,
            False,
            False,
            False,
        ),
        E(
            "current",
            "current",
            CallCenterReportCurrentInterval,
            True,
            False,
            False,
            False,
        ),
        E(
            "past",
            "past",
            CallCenterReportPastInterval,
            True,
            False,
            False,
            False,
        ),
    )
    #: CallCenterReportIntervalDates: *Optional* dates
    dates = Field(
        type=CallCenterReportIntervalDates,
        required=False,
    )
    #: CallCenterReportCurrentInterval: *Optional* current
    current = Field(
        type=CallCenterReportCurrentInterval,
        required=False,
    )
    #: CallCenterReportPastInterval: *Optional* past
    past = Field(
        type=CallCenterReportPastInterval,
        required=False,
    )


class CallCenterReportSchedule(OCIType):
    """
    A schedule for call center enhanced reporting scheduled report. It can either be
    a fixed time schedule
    or recurring schedule
    """

    _ELEMENTS = (
        E(
            "schedule_time",
            "scheduleTime",
            CallCenterReportScheduleTime,
            True,
            False,
            False,
            False,
        ),
        E(
            "recurrence",
            "recurrence",
            CallCenterReportScheduleRecurrence,
            True,
            False,
            False,
            False,
        ),
    )
    #: CallCenterReportScheduleTime: *Optional* scheduleTime
    schedule_time = Field(
        type=CallCenterReportScheduleTime,
        required=False,
    )
    #: CallCenterReportScheduleRecurrence: *Optional* recurrence
    recurrence = Field(
        type=CallCenterReportScheduleRecurrence,
        required=False,
    )


class CommPilotExpressSRNoAnswer(OCIType):
    """
    CommPilot Express SR No Answer Settings used in the context of a get.
    """

    _ELEMENTS = (
        E(
            "ring_forward_numbers",
            "ringForwardNumbers",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "forwarding_number_list",
            "forwardingNumberList",
            CommPilotExpressSRRedirectionWithRingList,
            True,
            True,
            False,
            False,
        ),
        E(
            "still_no_answer",
            "stillNoAnswer",
            CommPilotExpressSRRedirection,
            True,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* ringForwardNumbers
    ring_forward_numbers = Field(
        type=bool,
        required=True,
    )
    #: CommPilotExpressSRRedirectionWithRingList: *Required* forwardingNumberList
    forwarding_number_list = Field(
        type=CommPilotExpressSRRedirectionWithRingList,
        required=True,
    )
    #: CommPilotExpressSRRedirection: *Required* stillNoAnswer
    still_no_answer = Field(
        type=CommPilotExpressSRRedirection,
        required=True,
    )


class CommPilotExpressSRNoAnswerModify(OCIType):
    """
    CommPilot Express SR No Answer Settings used in the context of a modify.
    """

    _ELEMENTS = (
        E(
            "ring_foward_numbers",
            "ringFowardNumbers",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "forwarding_number_list",
            "forwardingNumberList",
            CommPilotExpressSRRedirectionWithRingList,
            True,
            False,
            False,
            False,
        ),
        E(
            "still_no_answer",
            "stillNoAnswer",
            CommPilotExpressSRRedirectionModify,
            True,
            False,
            False,
            False,
        ),
    )
    #: bool: *Optional* ringFowardNumbers
    ring_foward_numbers = Field(
        type=bool,
        required=False,
    )
    #: CommPilotExpressSRRedirectionWithRingList: *Optional* forwardingNumberList
    forwarding_number_list = Field(
        type=CommPilotExpressSRRedirectionWithRingList,
        required=False,
    )
    #: CommPilotExpressSRRedirectionModify: *Optional* stillNoAnswer
    still_no_answer = Field(
        type=CommPilotExpressSRRedirectionModify,
        required=False,
    )


class GroupHuntGroupAddInstanceRequest17sp1V1(OCIType):
    """
    Add a Hunt Group instance to a group.
    The domain is required in the serviceUserId.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    The following elements are only used in HSS data mode:
    allowMembersToControlGroupBusy, use value "false" in AS data mode
    enableGroupBusy, use value "false" in AS data mode
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_instance_profile",
            "serviceInstanceProfile",
            ServiceInstanceAddProfile,
            True,
            True,
            False,
            False,
        ),
        E(
            "policy",
            "policy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "hunt_after_no_answer",
            "huntAfterNoAnswer",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "no_answer_number_of_rings",
            "noAnswerNumberOfRings",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "forward_after_timeout",
            "forwardAfterTimeout",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "forward_timeout_seconds",
            "forwardTimeoutSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "forward_to_phone_number",
            "forwardToPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "agent_user_id",
            "agentUserId",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "allow_call_waiting_for_agents",
            "allowCallWaitingForAgents",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_members_to_control_group_busy",
            "allowMembersToControlGroupBusy",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_group_busy",
            "enableGroupBusy",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: ServiceInstanceAddProfile: *Required* serviceInstanceProfile
    service_instance_profile = Field(
        type=ServiceInstanceAddProfile,
        required=True,
    )
    #: str: *Required* policy
    policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* huntAfterNoAnswer
    hunt_after_no_answer = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* noAnswerNumberOfRings
    no_answer_number_of_rings = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* forwardAfterTimeout
    forward_after_timeout = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* forwardTimeoutSeconds
    forward_timeout_seconds = Field(
        type=int,
        required=True,
    )
    #: str: *Optional* forwardToPhoneNumber
    forward_to_phone_number = Field(
        type=str,
        required=False,
    )
    #: list(str): *Optional* agentUserId  *Array*
    agent_user_id = Field(
        type=list,
        required=False,
    )
    #: bool: *Required* allowCallWaitingForAgents
    allow_call_waiting_for_agents = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowMembersToControlGroupBusy
    allow_members_to_control_group_busy = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableGroupBusy
    enable_group_busy = Field(
        type=bool,
        required=True,
    )


class GroupHuntGroupGetInstanceResponse17sp1V1(OCIType):
    """
    Response to GroupHuntGroupGetInstanceRequest17sp1V1.
    Contains the service profile information and a table of assigned users.
    The table has column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name", "Weight".
    The following elements are only used in HSS data mode:
    allowMembersToControlGroupBusy
    enableGroupBusy
    """

    _ELEMENTS = (
        E(
            "service_instance_profile",
            "serviceInstanceProfile",
            ServiceInstanceReadProfile17,
            True,
            True,
            False,
            False,
        ),
        E(
            "policy",
            "policy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "hunt_after_no_answer",
            "huntAfterNoAnswer",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "no_answer_number_of_rings",
            "noAnswerNumberOfRings",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "forward_after_timeout",
            "forwardAfterTimeout",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "forward_timeout_seconds",
            "forwardTimeoutSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "forward_to_phone_number",
            "forwardToPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "agent_user_table",
            "agentUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
        E(
            "allow_call_waiting_for_agents",
            "allowCallWaitingForAgents",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_members_to_control_group_busy",
            "allowMembersToControlGroupBusy",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_group_busy",
            "enableGroupBusy",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: ServiceInstanceReadProfile17: *Required* serviceInstanceProfile
    service_instance_profile = Field(
        type=ServiceInstanceReadProfile17,
        required=True,
    )
    #: str: *Required* policy
    policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* huntAfterNoAnswer
    hunt_after_no_answer = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* noAnswerNumberOfRings
    no_answer_number_of_rings = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* forwardAfterTimeout
    forward_after_timeout = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* forwardTimeoutSeconds
    forward_timeout_seconds = Field(
        type=int,
        required=True,
    )
    #: str: *Optional* forwardToPhoneNumber
    forward_to_phone_number = Field(
        type=str,
        required=False,
    )
    #: list: *Required* agentUserTable  *Tabular*
    agent_user_table = Field(
        type=list,
        required=True,
    )
    #: bool: *Required* allowCallWaitingForAgents
    allow_call_waiting_for_agents = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowMembersToControlGroupBusy
    allow_members_to_control_group_busy = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableGroupBusy
    enable_group_busy = Field(
        type=bool,
        required=True,
    )


class GroupTrunkGroupAddInstanceRequest14sp9A(OCIType):
    """
    Add a Trunk Group instance to a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "pilot_user",
            "pilotUser",
            TrunkGroupPilotUser,
            True,
            False,
            False,
            False,
        ),
        E(
            "department",
            "department",
            DepartmentKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "access_device",
            "accessDevice",
            AccessDevice,
            True,
            False,
            False,
            False,
        ),
        E(
            "max_active_calls",
            "maxActiveCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_incoming_calls",
            "maxIncomingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_outgoing_calls",
            "maxOutgoingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_bursting",
            "enableBursting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "bursting_max_active_calls",
            "burstingMaxActiveCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "bursting_max_incoming_calls",
            "burstingMaxIncomingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "bursting_max_outgoing_calls",
            "burstingMaxOutgoingCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_action",
            "capacityExceededAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_forward_address",
            "capacityExceededForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_reroute_trunk_group_key",
            "capacityExceededRerouteTrunkGroupKey",
            TrunkGroupKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_initial_calls",
            "capacityExceededTrapInitialCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_offset_calls",
            "capacityExceededTrapOffsetCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "unreachable_destination_action",
            "unreachableDestinationAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "unreachable_destination_forward_address",
            "unreachableDestinationForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "unreachable_destination_reroute_trunk_group_key",
            "unreachableDestinationRerouteTrunkGroupKey",
            TrunkGroupKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "unreachable_destination_trap_initial_calls",
            "unreachableDestinationTrapInitialCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "unreachable_destination_trap_offset_calls",
            "unreachableDestinationTrapOffsetCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "invitation_timeout",
            "invitationTimeout",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "require_authentication",
            "requireAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "sip_authentication_user_name",
            "sipAuthenticationUserName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "sip_authentication_password",
            "sipAuthenticationPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "hosted_user_id",
            "hostedUserId",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "trunk_group_identity",
            "trunkGroupIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "otg_dtg_identity",
            "otgDtgIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_trunk_group_identity",
            "includeTrunkGroupIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_dtg_identity",
            "includeDtgIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_network_address_identity",
            "enableNetworkAddressIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_unscreened_calls",
            "allowUnscreenedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_unscreened_emergency_calls",
            "allowUnscreenedEmergencyCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "pilot_user_calling_line_identity_policy",
            "pilotUserCallingLineIdentityPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "pilot_user_charge_number_policy",
            "pilotUserChargeNumberPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_forwarding_always_action",
            "callForwardingAlwaysAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_forwarding_always_forward_address",
            "callForwardingAlwaysForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_forwarding_always_reroute_trunk_group_key",
            "callForwardingAlwaysRerouteTrunkGroupKey",
            TrunkGroupKey,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: TrunkGroupPilotUser: *Optional* pilotUser
    pilot_user = Field(
        type=TrunkGroupPilotUser,
        required=False,
    )
    #: DepartmentKey: *Optional* department
    department = Field(
        type=DepartmentKey,
        required=False,
    )
    #: AccessDevice: *Optional* accessDevice
    access_device = Field(
        type=AccessDevice,
        required=False,
    )
    #: int: *Required* maxActiveCalls
    max_active_calls = Field(
        type=int,
        required=True,
    )
    #: int: *Optional* maxIncomingCalls
    max_incoming_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxOutgoingCalls
    max_outgoing_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* enableBursting
    enable_bursting = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* burstingMaxActiveCalls
    bursting_max_active_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* burstingMaxIncomingCalls
    bursting_max_incoming_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* burstingMaxOutgoingCalls
    bursting_max_outgoing_calls = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* capacityExceededAction
    capacity_exceeded_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* capacityExceededForwardAddress
    capacity_exceeded_forward_address = Field(
        type=str,
        required=False,
    )
    #: TrunkGroupKey: *Optional* capacityExceededRerouteTrunkGroupKey
    capacity_exceeded_reroute_trunk_group_key = Field(
        type=TrunkGroupKey,
        required=False,
    )
    #: int: *Required* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(
        type=int,
        required=True,
    )
    #: int: *Required* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(
        type=int,
        required=True,
    )
    #: str: *Optional* unreachableDestinationAction
    unreachable_destination_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* unreachableDestinationForwardAddress
    unreachable_destination_forward_address = Field(
        type=str,
        required=False,
    )
    #: TrunkGroupKey: *Optional* unreachableDestinationRerouteTrunkGroupKey
    unreachable_destination_reroute_trunk_group_key = Field(
        type=TrunkGroupKey,
        required=False,
    )
    #: int: *Required* unreachableDestinationTrapInitialCalls
    unreachable_destination_trap_initial_calls = Field(
        type=int,
        required=True,
    )
    #: int: *Required* unreachableDestinationTrapOffsetCalls
    unreachable_destination_trap_offset_calls = Field(
        type=int,
        required=True,
    )
    #: int: *Required* invitationTimeout
    invitation_timeout = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* requireAuthentication
    require_authentication = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* sipAuthenticationUserName
    sip_authentication_user_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* sipAuthenticationPassword
    sip_authentication_password = Field(
        type=str,
        required=False,
    )
    #: list(str): *Optional* hostedUserId  *Array*
    hosted_user_id = Field(
        type=list,
        required=False,
    )
    #: str: *Optional* trunkGroupIdentity
    trunk_group_identity = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* otgDtgIdentity
    otg_dtg_identity = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* includeTrunkGroupIdentity
    include_trunk_group_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeDtgIdentity
    include_dtg_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableNetworkAddressIdentity
    enable_network_address_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowUnscreenedCalls
    allow_unscreened_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowUnscreenedEmergencyCalls
    allow_unscreened_emergency_calls = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* pilotUserCallingLineIdentityPolicy
    pilot_user_calling_line_identity_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* pilotUserChargeNumberPolicy
    pilot_user_charge_number_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* callForwardingAlwaysAction
    call_forwarding_always_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callForwardingAlwaysForwardAddress
    call_forwarding_always_forward_address = Field(
        type=str,
        required=False,
    )
    #: TrunkGroupKey: *Optional* callForwardingAlwaysRerouteTrunkGroupKey
    call_forwarding_always_reroute_trunk_group_key = Field(
        type=TrunkGroupKey,
        required=False,
    )


class OutgoingCallingPlanDigitPatternCallMeNowDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan Call Me Now call permissions for specified digit patterns.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern_permissions",
            "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternCallMeNowPermissions,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )
    #: OutgoingCallingPlanDigitPatternCallMeNowPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternCallMeNowPermissions,
        required=True,
    )


class OutgoingCallingPlanDigitPatternCallMeNowDepartmentPermissionsModify(OCIType):
    """
    Modify outgoing Calling Plan Call Me Now call permissions for specified digit patterns.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern_permissions",
            "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternCallMeNowPermissions,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: OutgoingCallingPlanDigitPatternCallMeNowPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternCallMeNowPermissions,
        required=True,
    )


class OutgoingCallingPlanDigitPatternOriginatingDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan originating call permissions for specified digit patterns.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern_permissions",
            "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternOriginatingPermissions,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )
    #: OutgoingCallingPlanDigitPatternOriginatingPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternOriginatingPermissions,
        required=True,
    )


class OutgoingCallingPlanDigitPatternOriginatingDepartmentPermissionsModify(OCIType):
    """
    Modify outgoing Calling Plan originating call permissions for specified digit patterns.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern_permissions",
            "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternOriginatingPermissions,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: OutgoingCallingPlanDigitPatternOriginatingPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternOriginatingPermissions,
        required=True,
    )


class OutgoingCallingPlanDigitPatternRedirectingDepartmentPermissions(OCIType):
    """
    Outgoing Calling Plan redirecting call permissions for specified digit patterns.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern_permissions",
            "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternRedirectingPermissions,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )
    #: OutgoingCallingPlanDigitPatternRedirectingPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternRedirectingPermissions,
        required=True,
    )


class OutgoingCallingPlanDigitPatternRedirectingDepartmentPermissionsModify(OCIType):
    """
    Modify outgoing Calling Plan redirecting call permissions for specified digit patterns.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern_permissions",
            "digitPatternPermissions",
            OutgoingCallingPlanDigitPatternRedirectingPermissions,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: OutgoingCallingPlanDigitPatternRedirectingPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingCallingPlanDigitPatternRedirectingPermissions,
        required=True,
    )


class OutgoingPinholeDigitPlanDigitPatternCallMeNowDepartmentPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan Call Me Now call permissions for a department.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "permissions",
            "permissions",
            OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )
    #: OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions: *Required* permissions
    permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions,
        required=True,
    )


class OutgoingPinholeDigitPlanDigitPatternCallMeNowDepartmentPermissionsModify(OCIType):
    """
    Modify Outgoing Pinhole Digit Plan Call Me Now call permissions for specified
    digit patterns.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern_permissions",
            "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternCallMeNowPermissions,
        required=True,
    )


class OutgoingPinholeDigitPlanDigitPatternOriginatingDepartmentPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan department originating call permissions for specified
    digit patterns.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern_permissions",
            "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )
    #: OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions,
        required=True,
    )


class OutgoingPinholeDigitPlanDigitPatternOriginatingDepartmentPermissionsModify(
    OCIType,
):
    """
    Modify Outgoing Pinhole Digit Plan originating call permissions for specified
    digit patterns.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern_permissions",
            "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternOriginatingPermissions,
        required=True,
    )


class OutgoingPinholeDigitPlanDigitPatternRedirectingDepartmentPermissions(OCIType):
    """
    Outgoing Pinhole Digit Plan initiating call forwards/transfer permissions for a
    department.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "permissions",
            "permissions",
            OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )
    #: OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions: *Required* permissions
    permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions,
        required=True,
    )


class OutgoingPinholeDigitPlanDigitPatternRedirectingDepartmentPermissionsModify(
    OCIType,
):
    """
    Modify Outgoing Pinhole Digit Plan redirecting call permissions for specified
    digit patterns.
    """

    _ELEMENTS = (
        E(
            "department_key",
            "departmentKey",
            DepartmentKey,
            True,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern_permissions",
            "digitPatternPermissions",
            OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions,
            True,
            True,
            False,
            False,
        ),
    )
    #: DepartmentKey: *Required* departmentKey
    department_key = Field(
        type=DepartmentKey,
        required=True,
    )
    #: OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions: *Required*
    #: digitPatternPermissions
    digit_pattern_permissions = Field(
        type=OutgoingPinholeDigitPlanDigitPatternRedirectingPermissions,
        required=True,
    )


class ReplacementEnterpriseDeviceList(OCIType):
    """
    A list of enterprise accessible devices that replaces a previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "device",
            "device",
            EnterpriseAccessDevice,
            True,
            True,
            False,
            False,
        ),
    )
    #: EnterpriseAccessDevice: *Required* device
    device = Field(
        type=EnterpriseAccessDevice,
        required=True,
    )


class ReplacementEnterpriseEnterpriseTrunkPriorityWeightedTrunkGroupList(OCIType):
    """
    A list of enterprise trunk priority weighted trunk groups that replaces a
    previously configured list.
    By convention, an element of this type may be set nill to clear the list.
    """

    _ELEMENTS = (
        E(
            "trunk_group",
            "trunkGroup",
            EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup,
            True,
            True,
            False,
            False,
        ),
    )
    #: EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup: *Required* trunkGroup
    trunk_group = Field(
        type=EnterpriseEnterpriseTrunkPriorityWeightedTrunkGroup,
        required=True,
    )


class SystemSIPDeviceTypeGetResponse18sp1V2(OCIType):
    """
    Response to SystemSIPDeviceTypeGetRequest18sp1V2.
    The following elements are only used in AS data mode:
    holdAnnouncementMethod
    supportRFC3398
    The following elements are only used in HSS data mode:
    enable3G4GContinuity

    The following element values are only applicable in AS data mode:
    holdNormalization=useRfc3264Hold
    """

    _ELEMENTS = (
        E(
            "is_obsolete",
            "isObsolete",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_ports",
            "numberOfPorts",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile",
            "profile",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "registration_capable",
            "registrationCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_conference_device",
            "isConferenceDevice",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_mobility_manager_device",
            "isMobilityManagerDevice",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_music_on_hold_device",
            "isMusicOnHoldDevice",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "hold_normalization",
            "holdNormalization",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "hold_announcement_method",
            "holdAnnouncementMethod",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_trusted",
            "isTrusted",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "e164_capable",
            "E164Capable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_advance",
            "routeAdvance",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "forwarding_override",
            "forwardingOverride",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "wireless_integration",
            "wirelessIntegration",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "web_based_config_url",
            "webBasedConfigURL",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "is_video_capable",
            "isVideoCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "pbx_integration",
            "PBXIntegration",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "static_registration_capable",
            "staticRegistrationCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "cpe_device_options",
            "cpeDeviceOptions",
            CPEDeviceOptionsRead16sp1,
            True,
            False,
            False,
            False,
        ),
        E(
            "protocol_choice",
            "protocolChoice",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "early_media_support",
            "earlyMediaSupport",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "authenticate_refer",
            "authenticateRefer",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "auto_config_soft_client",
            "autoConfigSoftClient",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "authentication_mode",
            "authenticationMode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "requires_broad_works_digit_collection",
            "requiresBroadWorksDigitCollection",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "requires_broad_works_call_waiting_tone",
            "requiresBroadWorksCallWaitingTone",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "requires_mwi_subscription",
            "requiresMWISubscription",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_history_info_header_on_access_side",
            "useHistoryInfoHeaderOnAccessSide",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "advice_of_charge_capable",
            "adviceOfChargeCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "reset_event",
            "resetEvent",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "support_call_center_mime_type",
            "supportCallCenterMIMEType",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_mode",
            "trunkMode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "add_p_called_party_id",
            "addPCalledPartyId",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "support_identity_in_update_and_re_invite",
            "supportIdentityInUpdateAndReInvite",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "unscreened_presentation_identity_policy",
            "unscreenedPresentationIdentityPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable3_g4_g_continuity",
            "enable3G4GContinuity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "support_emergency_disconnect_control",
            "supportEmergencyDisconnectControl",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_type_configuration_option",
            "deviceTypeConfigurationOption",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "support_rfc3398",
            "supportRFC3398",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isObsolete
    is_obsolete = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* numberOfPorts
    number_of_ports = Field(
        type=str,
        required=True,
    )
    #: str: *Required* profile
    profile = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* registrationCapable
    registration_capable = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isConferenceDevice
    is_conference_device = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isMobilityManagerDevice
    is_mobility_manager_device = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isMusicOnHoldDevice
    is_music_on_hold_device = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* holdNormalization
    hold_normalization = Field(
        type=str,
        required=True,
    )
    #: str: *Required* holdAnnouncementMethod
    hold_announcement_method = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isTrusted
    is_trusted = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* E164Capable
    e164_capable = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* routeAdvance
    route_advance = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* forwardingOverride
    forwarding_override = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* wirelessIntegration
    wireless_integration = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* webBasedConfigURL
    web_based_config_url = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* isVideoCapable
    is_video_capable = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* PBXIntegration
    pbx_integration = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(
        type=bool,
        required=True,
    )
    #: CPEDeviceOptionsRead16sp1: *Optional* cpeDeviceOptions
    cpe_device_options = Field(
        type=CPEDeviceOptionsRead16sp1,
        required=False,
    )
    #: str: *Required* protocolChoice
    protocol_choice = Field(
        type=str,
        required=True,
    )
    #: str: *Required* earlyMediaSupport
    early_media_support = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* authenticateRefer
    authenticate_refer = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* autoConfigSoftClient
    auto_config_soft_client = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* authenticationMode
    authentication_mode = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* requiresBroadWorksDigitCollection
    requires_broad_works_digit_collection = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* requiresBroadWorksCallWaitingTone
    requires_broad_works_call_waiting_tone = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* requiresMWISubscription
    requires_mwi_subscription = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useHistoryInfoHeaderOnAccessSide
    use_history_info_header_on_access_side = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* adviceOfChargeCapable
    advice_of_charge_capable = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* resetEvent
    reset_event = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* supportCallCenterMIMEType
    support_call_center_mime_type = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* trunkMode
    trunk_mode = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* addPCalledPartyId
    add_p_called_party_id = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* supportIdentityInUpdateAndReInvite
    support_identity_in_update_and_re_invite = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* unscreenedPresentationIdentityPolicy
    unscreened_presentation_identity_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enable3G4GContinuity
    enable3_g4_g_continuity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* supportEmergencyDisconnectControl
    support_emergency_disconnect_control = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* deviceTypeConfigurationOption
    device_type_configuration_option = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* supportRFC3398
    support_rfc3398 = Field(
        type=bool,
        required=True,
    )


class TrunkAddressingMultipleContactModify(OCIType):
    """
    Trunk group endpoint that can have multiple contacts.
    alternateTrunkIdentityDomainName is only used in IMS mode.
    Setting alternateTrunkIdentity or alternateTrunkIdentityDomain to nil in IMS
    mode, the other one paremter should be set to nil at the same time.
    """

    _ELEMENTS = (
        E(
            "trunk_group_device_endpoint",
            "trunkGroupDeviceEndpoint",
            TrunkGroupDeviceMultipleContactEndpointModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_trunk_identity",
            "alternateTrunkIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_trunk_identity_domain",
            "alternateTrunkIdentityDomain",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: TrunkGroupDeviceMultipleContactEndpointModify: *Optional* trunkGroupDeviceEndpoint
    trunk_group_device_endpoint = Field(
        type=TrunkGroupDeviceMultipleContactEndpointModify,
        required=False,
    )
    #: str: *Optional* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateTrunkIdentity
    alternate_trunk_identity = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* alternateTrunkIdentityDomain
    alternate_trunk_identity_domain = Field(
        type=str,
        required=False,
    )


class UserEnhancedCallLogsGetListRequest17sp4V2(OCIType):
    """
    Request user's call logs.
    If the callLogType is not specified, all types of calls logs (placed, received,
    missed) are returned.
    The filters "dateTimeRange", "numberFilter", "redirectedNumberFilter",
    "accountAuthorizationCodeFilter"
    "callAuthorizationCodeFilter" and "subscriberType" are ignored if call logs are
    stored in CDS. When
    "ReceivedOrMissed" is specified as "callLogType" and call logs are stored in CDS,
    all call logs including
    placed will be returned.
    It is possible to restrict the number of rows returned using
    responsePagingControl. If responsePagingControl
    is not specified, the value of Enhanced Call Logs system parameter
    maxNonPagedResponseSize will control
    the maximum number of call logs can be returned.
    The response is either a UserEnhancedCallLogsGetListResponse17sp4V2 or an
    ``ErrorResponse()``.
    The following elements are only used in AS data mode:
    callAuthorizationCodeFilter
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_log_type",
            "callLogType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "date_time_range",
            "dateTimeRange",
            EnhancedCallLogsTimeRange,
            True,
            True,
            False,
            False,
        ),
        E(
            "number_filter",
            "numberFilter",
            EnhancedCallLogsNumberFilter,
            True,
            False,
            False,
            False,
        ),
        E(
            "redirected_number_filter",
            "redirectedNumberFilter",
            EnhancedCallLogsRedirectedNumberFilter,
            True,
            False,
            False,
            False,
        ),
        E(
            "account_authorization_code_filter",
            "accountAuthorizationCodeFilter",
            EnhancedCallLogsAccountAuthorizationCodeFilter,
            True,
            False,
            False,
            False,
        ),
        E(
            "call_authorization_code_filter",
            "callAuthorizationCodeFilter",
            EnhancedCallLogsCallAuthorizationCodeFilter,
            True,
            False,
            False,
            False,
        ),
        E(
            "subscriber_type",
            "subscriberType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "response_paging_control",
            "responsePagingControl",
            ResponsePagingControl,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* callLogType
    call_log_type = Field(
        type=str,
        required=False,
    )
    #: EnhancedCallLogsTimeRange: *Required* dateTimeRange
    date_time_range = Field(
        type=EnhancedCallLogsTimeRange,
        required=True,
    )
    #: EnhancedCallLogsNumberFilter: *Optional* numberFilter
    number_filter = Field(
        type=EnhancedCallLogsNumberFilter,
        required=False,
    )
    #: EnhancedCallLogsRedirectedNumberFilter: *Optional* redirectedNumberFilter
    redirected_number_filter = Field(
        type=EnhancedCallLogsRedirectedNumberFilter,
        required=False,
    )
    #: EnhancedCallLogsAccountAuthorizationCodeFilter: *Optional*
    #: accountAuthorizationCodeFilter
    account_authorization_code_filter = Field(
        type=EnhancedCallLogsAccountAuthorizationCodeFilter,
        required=False,
    )
    #: EnhancedCallLogsCallAuthorizationCodeFilter: *Optional*
    #: callAuthorizationCodeFilter
    call_authorization_code_filter = Field(
        type=EnhancedCallLogsCallAuthorizationCodeFilter,
        required=False,
    )
    #: str: *Optional* subscriberType
    subscriber_type = Field(
        type=str,
        required=False,
    )
    #: ResponsePagingControl: *Optional* responsePagingControl
    response_paging_control = Field(
        type=ResponsePagingControl,
        required=False,
    )


class AutoAttendantAddMenu(OCIType):
    """
    The configuration of the automated receptionist greeting
    prompt and dialing menu to be used during after business hours.
    """

    _ELEMENTS = (
        E(
            "announcement_selection",
            "announcementSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            LabeledFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            LabeledFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "key_configuration",
            "keyConfiguration",
            AutoAttendantKeyConfiguration,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* announcementSelection
    announcement_selection = Field(
        type=str,
        required=True,
    )
    #: LabeledFileResource: *Optional* audioFile
    audio_file = Field(
        type=LabeledFileResource,
        required=False,
    )
    #: LabeledFileResource: *Optional* videoFile
    video_file = Field(
        type=LabeledFileResource,
        required=False,
    )
    #: bool: *Required* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: AutoAttendantKeyConfiguration: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyConfiguration,
        required=False,
    )


class AutoAttendantAddMenu16(OCIType):
    """
    The configuration of the automated receptionist greeting
    prompt and dialing menu to be used during after business hours.
    """

    _ELEMENTS = (
        E(
            "announcement_selection",
            "announcementSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "key_configuration",
            "keyConfiguration",
            AutoAttendantKeyConfiguration,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* announcementSelection
    announcement_selection = Field(
        type=str,
        required=True,
    )
    #: LabeledMediaFileResource: *Optional* audioFile
    audio_file = Field(
        type=LabeledMediaFileResource,
        required=False,
    )
    #: LabeledMediaFileResource: *Optional* videoFile
    video_file = Field(
        type=LabeledMediaFileResource,
        required=False,
    )
    #: bool: *Required* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: AutoAttendantKeyConfiguration: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyConfiguration,
        required=False,
    )


class AutoAttendantAddMenu19(OCIType):
    """
    The configuration of the automated receptionist
    greeting
    prompt and dialing menu to be used during
    after business
    hours.
    """

    _ELEMENTS = (
        E(
            "announcement_selection",
            "announcementSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "key_configuration",
            "keyConfiguration",
            AutoAttendantKeyConfiguration19,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* announcementSelection
    announcement_selection = Field(
        type=str,
        required=True,
    )
    #: LabeledMediaFileResource: *Optional* audioFile
    audio_file = Field(
        type=LabeledMediaFileResource,
        required=False,
    )
    #: LabeledMediaFileResource: *Optional* videoFile
    video_file = Field(
        type=LabeledMediaFileResource,
        required=False,
    )
    #: bool: *Required* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: AutoAttendantKeyConfiguration19: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyConfiguration19,
        required=False,
    )


class AutoAttendantAddMenu20(OCIType):
    """
    The configuration of the automated receptionist greeting
    prompt and dialing menu to be used during after business hours.
    """

    _ELEMENTS = (
        E(
            "announcement_selection",
            "announcementSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "key_configuration",
            "keyConfiguration",
            AutoAttendantKeyConfiguration20,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* announcementSelection
    announcement_selection = Field(
        type=str,
        required=True,
    )
    #: AnnouncementFileLevelKey: *Optional* audioFile
    audio_file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* videoFile
    video_file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: bool: *Required* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: AutoAttendantKeyConfiguration20: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyConfiguration20,
        required=False,
    )


class AutoAttendantModifyMenu(OCIType):
    """
    The configuration of the automated receptionist greeting
    prompt and dialing menu to be used during business hours.
    It is used when modifying an Auto Attendant group.
    """

    _ELEMENTS = (
        E(
            "announcement_selection",
            "announcementSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            LabeledFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            LabeledFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "key_configuration",
            "keyConfiguration",
            AutoAttendantKeyModifyConfiguration,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* announcementSelection
    announcement_selection = Field(
        type=str,
        required=False,
    )
    #: LabeledFileResource: *Optional* audioFile
    audio_file = Field(
        type=LabeledFileResource,
        required=False,
    )
    #: LabeledFileResource: *Optional* videoFile
    video_file = Field(
        type=LabeledFileResource,
        required=False,
    )
    #: bool: *Optional* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(
        type=bool,
        required=False,
    )
    #: AutoAttendantKeyModifyConfiguration: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyModifyConfiguration,
        required=False,
    )


class AutoAttendantModifyMenu16(OCIType):
    """
    The configuration of the automated receptionist
    greeting
    prompt and dialing menu to be used during
    business
    hours.
    It is used when modifying an Auto Attendant group.
    """

    _ELEMENTS = (
        E(
            "announcement_selection",
            "announcementSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            LabeledMediaFileResource,
            True,
            False,
            False,
            False,
        ),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "key_configuration",
            "keyConfiguration",
            AutoAttendantKeyModifyConfiguration,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* announcementSelection
    announcement_selection = Field(
        type=str,
        required=False,
    )
    #: LabeledMediaFileResource: *Optional* audioFile
    audio_file = Field(
        type=LabeledMediaFileResource,
        required=False,
    )
    #: LabeledMediaFileResource: *Optional* videoFile
    video_file = Field(
        type=LabeledMediaFileResource,
        required=False,
    )
    #: bool: *Optional* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(
        type=bool,
        required=False,
    )
    #: AutoAttendantKeyModifyConfiguration: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyModifyConfiguration,
        required=False,
    )


class AutoAttendantModifyMenu20(OCIType):
    """
    The configuration of the automated receptionist greeting
    prompt and dialing menu to be used during business hours.
    It is used when modifying an Auto Attendant group.
    """

    _ELEMENTS = (
        E(
            "announcement_selection",
            "announcementSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "key_configuration",
            "keyConfiguration",
            AutoAttendantKeyModifyConfiguration20,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* announcementSelection
    announcement_selection = Field(
        type=str,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* audioFile
    audio_file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* videoFile
    video_file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: bool: *Optional* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(
        type=bool,
        required=False,
    )
    #: AutoAttendantKeyModifyConfiguration20: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyModifyConfiguration20,
        required=False,
    )


class AutoAttendantReadMenu(OCIType):
    """
    The configuration of the automated receptionist greeting
    prompt and dialing menu to be used during after business hours.
    """

    _ELEMENTS = (
        E(
            "announcement_selection",
            "announcementSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "key_configuration",
            "keyConfiguration",
            AutoAttendantKeyConfiguration,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* announcementSelection
    announcement_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: AutoAttendantKeyConfiguration: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyConfiguration,
        required=False,
    )


class AutoAttendantReadMenu16(OCIType):
    """
    The configuration of the automated receptionist greeting
    prompt and dialing menu to be used during after business hours.
    """

    _ELEMENTS = (
        E(
            "announcement_selection",
            "announcementSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type",
            "audioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_media_type",
            "videoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "key_configuration",
            "keyConfiguration",
            AutoAttendantKeyConfiguration,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* announcementSelection
    announcement_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMediaType
    audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMediaType
    video_media_type = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: AutoAttendantKeyConfiguration: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyConfiguration,
        required=False,
    )


class AutoAttendantReadMenu20(OCIType):
    """
    The configuration of the automated receptionist greeting
    prompt and dialing menu to be used during after business hours.
    """

    _ELEMENTS = (
        E(
            "announcement_selection",
            "announcementSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file",
            "audioFile",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "video_file",
            "videoFile",
            AnnouncementFileLevelKey,
            True,
            False,
            False,
            False,
        ),
        E(
            "enable_first_menu_level_extension_dialing",
            "enableFirstMenuLevelExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "key_configuration",
            "keyConfiguration",
            AutoAttendantKeyReadConfiguration20,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* announcementSelection
    announcement_selection = Field(
        type=str,
        required=True,
    )
    #: AnnouncementFileLevelKey: *Optional* audioFile
    audio_file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: AnnouncementFileLevelKey: *Optional* videoFile
    video_file = Field(
        type=AnnouncementFileLevelKey,
        required=False,
    )
    #: bool: *Required* enableFirstMenuLevelExtensionDialing
    enable_first_menu_level_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: AutoAttendantKeyReadConfiguration20: *Optional* keyConfiguration
    key_configuration = Field(
        type=AutoAttendantKeyReadConfiguration20,
        required=False,
    )


class CommPilotExpressSRAvailableInOffice(OCIType):
    """
    CommPilot Express SR Available In Office Settings used in the context of a get.
    """

    _ELEMENTS = (
        E(
            "busy_setting",
            "busySetting",
            CommPilotExpressSRRedirection,
            True,
            True,
            False,
            False,
        ),
        E(
            "no_answer_setting",
            "noAnswerSetting",
            CommPilotExpressSRNoAnswer,
            True,
            True,
            False,
            False,
        ),
        E(
            "incoming_call_notify",
            "incomingCallNotify",
            CommPilotExpressSREmailNotify,
            True,
            True,
            False,
            False,
        ),
    )
    #: CommPilotExpressSRRedirection: *Required* busySetting
    busy_setting = Field(
        type=CommPilotExpressSRRedirection,
        required=True,
    )
    #: CommPilotExpressSRNoAnswer: *Required* noAnswerSetting
    no_answer_setting = Field(
        type=CommPilotExpressSRNoAnswer,
        required=True,
    )
    #: CommPilotExpressSREmailNotify: *Required* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressSREmailNotify,
        required=True,
    )


class CommPilotExpressSRAvailableInOfficeModify(OCIType):
    """
    CommPilot Express SR Available In Office Settings used in the context of a modify.
    """

    _ELEMENTS = (
        E(
            "busy_setting",
            "busySetting",
            CommPilotExpressSRRedirectionModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "no_answer_setting",
            "noAnswerSetting",
            CommPilotExpressSRNoAnswerModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "incoming_call_notify",
            "incomingCallNotify",
            CommPilotExpressSREmailNotifyModify,
            True,
            False,
            False,
            False,
        ),
    )
    #: CommPilotExpressSRRedirectionModify: *Optional* busySetting
    busy_setting = Field(
        type=CommPilotExpressSRRedirectionModify,
        required=False,
    )
    #: CommPilotExpressSRNoAnswerModify: *Optional* noAnswerSetting
    no_answer_setting = Field(
        type=CommPilotExpressSRNoAnswerModify,
        required=False,
    )
    #: CommPilotExpressSREmailNotifyModify: *Optional* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressSREmailNotifyModify,
        required=False,
    )


class CommPilotExpressSRAvailableOutOfOffice(OCIType):
    """
    CommPilot Express SR Available Out Of Office Configuration used in the context of a get.
    """

    _ELEMENTS = (
        E(
            "remote_phone_number",
            "remotePhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "no_answer_setting",
            "noAnswerSetting",
            CommPilotExpressSRNoAnswer,
            True,
            True,
            False,
            False,
        ),
        E(
            "incoming_call_notify",
            "incomingCallNotify",
            CommPilotExpressSREmailNotify,
            True,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* remotePhoneNumber
    remote_phone_number = Field(
        type=str,
        required=False,
    )
    #: CommPilotExpressSRNoAnswer: *Required* noAnswerSetting
    no_answer_setting = Field(
        type=CommPilotExpressSRNoAnswer,
        required=True,
    )
    #: CommPilotExpressSREmailNotify: *Required* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressSREmailNotify,
        required=True,
    )


class CommPilotExpressSRAvailableOutOfOfficeModify(OCIType):
    """
    CommPilot Express SR Available Out Of Office Configuration used in the context of
    a modify.
    """

    _ELEMENTS = (
        E(
            "remote_phone_number",
            "remotePhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "no_answer_setting",
            "noAnswerSetting",
            CommPilotExpressSRNoAnswerModify,
            True,
            False,
            False,
            False,
        ),
        E(
            "incoming_call_notify",
            "incomingCallNotify",
            CommPilotExpressSREmailNotifyModify,
            True,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* remotePhoneNumber
    remote_phone_number = Field(
        type=str,
        required=False,
    )
    #: CommPilotExpressSRNoAnswerModify: *Optional* noAnswerSetting
    no_answer_setting = Field(
        type=CommPilotExpressSRNoAnswerModify,
        required=False,
    )
    #: CommPilotExpressSREmailNotifyModify: *Optional* incomingCallNotify
    incoming_call_notify = Field(
        type=CommPilotExpressSREmailNotifyModify,
        required=False,
    )


class SystemSIPDeviceTypeAddRequest18sp1V2(OCIType):
    """
    Request to add a sip device type.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    The following elements are only used in HSS data mode:
    enable3G4GContinuity, use value "false" in AS data mode
    The following elements are only used in AS data mode:
    holdAnnouncementMethod, use value "useInactive" in HSS data mode
    supportRFC3398, use value "false" in HSS data mode

    The following element values are only applicable in AS data mode:
    holdNormalization=useRfc3264Hold will raise an error in HSS data mode

    Replaced By ``SystemSIPDeviceTypeAddRequest19()``.
    """

    _ELEMENTS = (
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_ports",
            "numberOfPorts",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile",
            "profile",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "registration_capable",
            "registrationCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_conference_device",
            "isConferenceDevice",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_mobility_manager_device",
            "isMobilityManagerDevice",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_music_on_hold_device",
            "isMusicOnHoldDevice",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "hold_normalization",
            "holdNormalization",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "hold_announcement_method",
            "holdAnnouncementMethod",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_trusted",
            "isTrusted",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "e164_capable",
            "E164Capable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_advance",
            "routeAdvance",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "forwarding_override",
            "forwardingOverride",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "wireless_integration",
            "wirelessIntegration",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "web_based_config_url",
            "webBasedConfigURL",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "is_video_capable",
            "isVideoCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "pbx_integration",
            "PBXIntegration",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "static_registration_capable",
            "staticRegistrationCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "cpe_device_options",
            "cpeDeviceOptions",
            CPEDeviceOptions16sp1,
            True,
            False,
            False,
            False,
        ),
        E(
            "early_media_support",
            "earlyMediaSupport",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "authenticate_refer",
            "authenticateRefer",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "auto_config_soft_client",
            "autoConfigSoftClient",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "authentication_mode",
            "authenticationMode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "requires_broad_works_digit_collection",
            "requiresBroadWorksDigitCollection",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "requires_broad_works_call_waiting_tone",
            "requiresBroadWorksCallWaitingTone",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "requires_mwi_subscription",
            "requiresMWISubscription",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_history_info_header_on_access_side",
            "useHistoryInfoHeaderOnAccessSide",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "advice_of_charge_capable",
            "adviceOfChargeCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "reset_event",
            "resetEvent",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "support_call_center_mime_type",
            "supportCallCenterMIMEType",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_mode",
            "trunkMode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "add_p_called_party_id",
            "addPCalledPartyId",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "support_identity_in_update_and_re_invite",
            "supportIdentityInUpdateAndReInvite",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "unscreened_presentation_identity_policy",
            "unscreenedPresentationIdentityPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable3_g4_g_continuity",
            "enable3G4GContinuity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "support_emergency_disconnect_control",
            "supportEmergencyDisconnectControl",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_type_configuration_option",
            "deviceTypeConfigurationOption",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "support_rfc3398",
            "supportRFC3398",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* numberOfPorts
    number_of_ports = Field(
        type=str,
        required=True,
    )
    #: str: *Required* profile
    profile = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* registrationCapable
    registration_capable = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isConferenceDevice
    is_conference_device = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isMobilityManagerDevice
    is_mobility_manager_device = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isMusicOnHoldDevice
    is_music_on_hold_device = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* holdNormalization
    hold_normalization = Field(
        type=str,
        required=True,
    )
    #: str: *Required* holdAnnouncementMethod
    hold_announcement_method = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isTrusted
    is_trusted = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* E164Capable
    e164_capable = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* routeAdvance
    route_advance = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* forwardingOverride
    forwarding_override = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* wirelessIntegration
    wireless_integration = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* webBasedConfigURL
    web_based_config_url = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* isVideoCapable
    is_video_capable = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* PBXIntegration
    pbx_integration = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* staticRegistrationCapable
    static_registration_capable = Field(
        type=bool,
        required=True,
    )
    #: CPEDeviceOptions16sp1: *Optional* cpeDeviceOptions
    cpe_device_options = Field(
        type=CPEDeviceOptions16sp1,
        required=False,
    )
    #: str: *Required* earlyMediaSupport
    early_media_support = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* authenticateRefer
    authenticate_refer = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* autoConfigSoftClient
    auto_config_soft_client = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* authenticationMode
    authentication_mode = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* requiresBroadWorksDigitCollection
    requires_broad_works_digit_collection = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* requiresBroadWorksCallWaitingTone
    requires_broad_works_call_waiting_tone = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* requiresMWISubscription
    requires_mwi_subscription = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useHistoryInfoHeaderOnAccessSide
    use_history_info_header_on_access_side = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* adviceOfChargeCapable
    advice_of_charge_capable = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* resetEvent
    reset_event = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* supportCallCenterMIMEType
    support_call_center_mime_type = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* trunkMode
    trunk_mode = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* addPCalledPartyId
    add_p_called_party_id = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* supportIdentityInUpdateAndReInvite
    support_identity_in_update_and_re_invite = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* unscreenedPresentationIdentityPolicy
    unscreened_presentation_identity_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enable3G4GContinuity
    enable3_g4_g_continuity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* supportEmergencyDisconnectControl
    support_emergency_disconnect_control = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* deviceTypeConfigurationOption
    device_type_configuration_option = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* supportRFC3398
    support_rfc3398 = Field(
        type=bool,
        required=True,
    )


# end
