"""Broadworks OCI-P Interface Request Classes"""
# Autogenerated from the Broadworks XML Schemas.
# Do not edit as changes will be overwritten.
# Generated on 2020-10-01T14:03:08.891866
from classforge import Field

import broadworks_ocip.types as OCI
from .base import ElementInfo as E
from .base import OCIRequest


class AuthenticationRequest(OCIRequest):
    """
    ``AuthenticationRequest()`` is 1st stage of the 2 stage OCI login process.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class AuthenticationVerifyRequest(OCIRequest):
    """
    ``AuthenticationVerifyRequest()`` is used to authenticate a user using the user
    Id and password. The response is a ``AuthenticationVerifyResponse()`` or an
    ``ErrorResponse()``
    Replaced By ``AuthenticationVerifyRequest14sp8()``
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* password
    password = Field(
        type=str,
        required=True,
    )


class AuthenticationVerifyRequest14sp8(OCIRequest):
    """
    ``AuthenticationVerifyRequest14sp8()`` is used to authenticate a user either by
    userId/password, userId/sip username/sip password,
    dn/passcode or a token previously authorized with the
    ``ExternalAuthenticationAuthorizeTokenRequest()``.
    The phone number may be any DN associated with a user.
    The response is a ``AuthenticationVerifyResponse14sp8()`` or an ``ErrorResponse()``
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "passcode",
            "passcode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "login_token",
            "loginToken",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "sip_authentication_user_name",
            "sipAuthenticationUserName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "sip_authentication_password",
            "sipAuthenticationPassword",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* password
    password = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )
    #: str: *Required* passcode
    passcode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* loginToken
    login_token = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sipAuthenticationUserName
    sip_authentication_user_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sipAuthenticationPassword
    sip_authentication_password = Field(
        type=str,
        required=True,
    )


class AvailabilityTestRequest(OCIRequest):
    """
    ``AvailabilityTestRequest()`` is for high-availability support. Response is
    either ``SuccessResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class DeviceManagementFileAuthLocationGetRequest(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested
    access device file. Also get the file name and path on the File Repository. The
    response is either a ``DeviceManagementFileAuthLocationGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "device_access_protocol",
            "deviceAccessProtocol",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_access_method",
            "deviceAccessMethod",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_access_uri",
            "deviceAccessURI",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_user_name",
            "accessDeviceUserName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_device_user_password",
            "accessDeviceUserPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "signed_password",
            "signedPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_address",
            "macAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "realm_name",
            "realmName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "digest_ha1_complement",
            "digestHa1Complement",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "digest_response",
            "digestResponse",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* deviceAccessProtocol
    device_access_protocol = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceAccessMethod
    device_access_method = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceAccessURI
    device_access_uri = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* accessDeviceUserName
    access_device_user_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* accessDeviceUserPassword
    access_device_user_password = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* signedPassword
    signed_password = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* macAddress
    mac_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* realmName
    realm_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* digestHa1Complement
    digest_ha1_complement = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* digestResponse
    digest_response = Field(
        type=str,
        required=False,
    )


class DeviceManagementFileAuthLocationGetRequest17(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested
    access device file.
    Also get the file name and path on the File Repository.
    The response is either a ``DeviceManagementFileAuthLocationGetResponse17()`` or
    an ``ErrorResponse()``.

    Replaced By ``DeviceManagementFileAuthLocationGetRequest18()``
    """

    _ELEMENTS = (
        E(
            "device_access_protocol",
            "deviceAccessProtocol",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_access_method",
            "deviceAccessMethod",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_access_uri",
            "deviceAccessURI",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_user_name",
            "accessDeviceUserName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_device_user_password",
            "accessDeviceUserPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "signed_password",
            "signedPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_address",
            "macAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "realm_name",
            "realmName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "digest_ha1_complement",
            "digestHa1Complement",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "digest_response",
            "digestResponse",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* deviceAccessProtocol
    device_access_protocol = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceAccessMethod
    device_access_method = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceAccessURI
    device_access_uri = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* accessDeviceUserName
    access_device_user_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* accessDeviceUserPassword
    access_device_user_password = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* signedPassword
    signed_password = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* macAddress
    mac_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* realmName
    realm_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* digestHa1Complement
    digest_ha1_complement = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* digestResponse
    digest_response = Field(
        type=str,
        required=False,
    )


class DeviceManagementFileAuthLocationGetRequest18(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested
    access device file.
    Also get the file name and path on the File Repository.
    The response is either a ``DeviceManagementFileAuthLocationGetResponse18()`` or
    an ``ErrorResponse()``.

    Replaced By ``DeviceManagementFileAuthLocationGetRequest21()``.
    """

    _ELEMENTS = (
        E(
            "device_access_protocol",
            "deviceAccessProtocol",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_access_method",
            "deviceAccessMethod",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_access_uri",
            "deviceAccessURI",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_user_name",
            "accessDeviceUserName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_device_user_password",
            "accessDeviceUserPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "signed_password",
            "signedPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_address",
            "macAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "realm_name",
            "realmName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "digest_ha1_complement",
            "digestHa1Complement",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "digest_response",
            "digestResponse",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* deviceAccessProtocol
    device_access_protocol = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceAccessMethod
    device_access_method = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceAccessURI
    device_access_uri = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* accessDeviceUserName
    access_device_user_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* accessDeviceUserPassword
    access_device_user_password = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* signedPassword
    signed_password = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* macAddress
    mac_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* realmName
    realm_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* digestHa1Complement
    digest_ha1_complement = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* digestResponse
    digest_response = Field(
        type=str,
        required=False,
    )


class DeviceManagementFileAuthLocationGetRequest21(OCIRequest):
    """
    Get the address and credentials of the File Repository hosting the requested
    access device file.
    Also get the file name and path on the File Repository.
    The response is either ``DeviceManagementFileAuthLocationGetResponse21()`` or
    ``ErrorResponse()``.
    The following elements are only used in AS data mode and will fail in HSS data mode:
    deviceToken
    """

    _ELEMENTS = (
        E(
            "device_access_protocol",
            "deviceAccessProtocol",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_access_method",
            "deviceAccessMethod",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_access_uri",
            "deviceAccessURI",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_user_name",
            "accessDeviceUserName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_device_user_password",
            "accessDeviceUserPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_token",
            "deviceToken",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "signed_password",
            "signedPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_address",
            "macAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "realm_name",
            "realmName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "digest_ha1_complement",
            "digestHa1Complement",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "digest_response",
            "digestResponse",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* deviceAccessProtocol
    device_access_protocol = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceAccessMethod
    device_access_method = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceAccessURI
    device_access_uri = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* accessDeviceUserName
    access_device_user_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* accessDeviceUserPassword
    access_device_user_password = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* deviceToken
    device_token = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* signedPassword
    signed_password = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* macAddress
    mac_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* realmName
    realm_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* digestHa1Complement
    digest_ha1_complement = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* digestResponse
    digest_response = Field(
        type=str,
        required=False,
    )


class DeviceManagementPutFileRequest(OCIRequest):
    """
    Informs BroadWorks that a file was uploaded to the repository. The response is
    always a ``SuccessResponse()``.
    """

    _ELEMENTS = (
        E(
            "device_access_uri",
            "deviceAccessURI",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "ip_address",
            "ipAddress",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* deviceAccessURI
    device_access_uri = Field(
        type=str,
        required=True,
    )
    #: str: *Required* ipAddress
    ip_address = Field(
        type=str,
        required=True,
    )


class EnterpriseBroadWorksMobileManagerActivationRequest(OCIRequest):
    """
    Activates or Deactivates the BroadWorks Mobile Manager.
    The deactivationReason is required when isActive is set to false.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "deactivation_reason",
            "deactivationReason",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* deactivationReason
    deactivation_reason = Field(
        type=str,
        required=False,
    )


class EnterpriseBroadWorksMobileManagerAddHomeZoneRequest(OCIRequest):
    """
    Add a home zone to the BroadWorks Mobile Manager.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "home_zone_domain_name",
            "homeZoneDomainName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_country_code",
            "mobileCountryCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_network_code",
            "mobileNetworkCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "location_area_code",
            "locationAreaCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "cell_identity",
            "cellIdentity",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* homeZoneDomainName
    home_zone_domain_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* mobileCountryCode
    mobile_country_code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* mobileNetworkCode
    mobile_network_code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* locationAreaCode
    location_area_code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* cellIdentity
    cell_identity = Field(
        type=str,
        required=True,
    )


class EnterpriseBroadWorksMobileManagerAddRequest(OCIRequest):
    """
    Add the BroadWorks Mobile Manager.
    Only one BroadWorks Mobile Manager can be added per
    enterprise.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "information_file",
            "informationFile",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "certificate_file",
            "certificateFile",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "local_to_carrier",
            "localToCarrier",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_tx_per_second_enabled",
            "maxTxPerSecondEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_tx_per_second",
            "maxTxPerSecond",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "tldn_enabled",
            "tldnEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "generic_number_enabled",
            "genericNumberEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_state_check_enabled",
            "mobileStateCheckEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "location_based_services_enabled",
            "locationBasedServicesEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* informationFile
    information_file = Field(
        type=str,
        required=True,
    )
    #: str: *Required* certificateFile
    certificate_file = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* localToCarrier
    local_to_carrier = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* maxTxPerSecondEnabled
    max_tx_per_second_enabled = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* maxTxPerSecond
    max_tx_per_second = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* tldnEnabled
    tldn_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* genericNumberEnabled
    generic_number_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* mobileStateCheckEnabled
    mobile_state_check_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* locationBasedServicesEnabled
    location_based_services_enabled = Field(
        type=bool,
        required=True,
    )


class EnterpriseBroadWorksMobileManagerDeleteHomeZoneListRequest(OCIRequest):
    """
    Delete a list of home zones from the BroadWorks Mobile Manager.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "home_zone_id",
            "homeZoneId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* homeZoneId
    home_zone_id = Field(
        type=str,
        required=True,
    )


class EnterpriseBroadWorksMobileManagerDeleteHomeZoneRequest(OCIRequest):
    """
    Delete a home zone from the BroadWorks Mobile Manager.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "home_zone_id",
            "homeZoneId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* homeZoneId
    home_zone_id = Field(
        type=str,
        required=True,
    )


class EnterpriseBroadWorksMobileManagerDeleteRequest(OCIRequest):
    """
    Delete the BroadWorks Mobile Manager.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseBroadWorksMobileManagerGetDomainListRequest(OCIRequest):
    """
    Get the list of domains of the BroadWorks Mobile Manager.
    The response is either ``EnterpriseBroadWorksMobileManagerGetDomainListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseBroadWorksMobileManagerGetHomeZoneListRequest(OCIRequest):
    """
    Get the list of home zones of the BroadWorks Mobile Manager.
    The response is either ``EnterpriseBroadWorksMobileManagerGetHomeZoneListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseBroadWorksMobileManagerGetHomeZoneRequest(OCIRequest):
    """
    Get a home zone from the BroadWorks Mobile Manager.
    The response is either ``EnterpriseBroadWorksMobileManagerGetHomeZoneResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "home_zone_id",
            "homeZoneId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* homeZoneId
    home_zone_id = Field(
        type=str,
        required=True,
    )


class EnterpriseBroadWorksMobileManagerGetRequest(OCIRequest):
    """
    Get the BroadWorks Mobile Manager.
    The response is either ``EnterpriseBroadWorksMobileManagerGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseBroadWorksMobileManagerModifyHomeZoneRequest(OCIRequest):
    """
    Modify an existing home zone in the BroadWorks Mobile Manager.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "home_zone_id",
            "homeZoneId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "home_zone_domain_name",
            "homeZoneDomainName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "mobile_country_code",
            "mobileCountryCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "mobile_network_code",
            "mobileNetworkCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "location_area_code",
            "locationAreaCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "cell_identity",
            "cellIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* homeZoneId
    home_zone_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* homeZoneDomainName
    home_zone_domain_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* mobileCountryCode
    mobile_country_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* mobileNetworkCode
    mobile_network_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* locationAreaCode
    location_area_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* cellIdentity
    cell_identity = Field(
        type=str,
        required=False,
    )


class EnterpriseBroadWorksMobileManagerModifyRequest(OCIRequest):
    """
    Modify the BroadWorks Mobile Manager settings.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "information_file",
            "informationFile",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "certificate_file",
            "certificateFile",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "local_to_carrier",
            "localToCarrier",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_tx_per_second_enabled",
            "maxTxPerSecondEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_tx_per_second",
            "maxTxPerSecond",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "tldn_enabled",
            "tldnEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "generic_number_enabled",
            "genericNumberEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mobile_state_check_enabled",
            "mobileStateCheckEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "location_based_services_enabled",
            "locationBasedServicesEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* informationFile
    information_file = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* certificateFile
    certificate_file = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* localToCarrier
    local_to_carrier = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* maxTxPerSecondEnabled
    max_tx_per_second_enabled = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxTxPerSecond
    max_tx_per_second = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* tldnEnabled
    tldn_enabled = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* genericNumberEnabled
    generic_number_enabled = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* mobileStateCheckEnabled
    mobile_state_check_enabled = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* locationBasedServicesEnabled
    location_based_services_enabled = Field(
        type=bool,
        required=False,
    )


class EnterpriseBroadWorksMobileManagerSendCarrierFilesRequest(OCIRequest):
    """
    Sends an email with the carrier information and certificate files.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "email_to",
            "emailTo",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emailTo
    email_to = Field(
        type=str,
        required=True,
    )


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest(
    OCIRequest,
):
    """
    Request a list of available Mobile Subscriber Directory Numbers not yet assigned
    to any user.
    The response is either ``EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterAgentThresholdProfileAddAgentListRequest(OCIRequest):
    """
    Add agent(s) to a Agent Threshold Profile.
    When an agent is assigned (added) to a profile, it is automatically unassigned
    (deleted) from the previous profile it was assigned to.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile_name",
            "profileName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "agent_user_id",
            "agentUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* profileName
    profile_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* agentUserId
    agent_user_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterAgentThresholdProfileAddRequest(OCIRequest):
    """
    Add a new Call Center Agent Threshold Profile in an Enterprise.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile_name",
            "profileName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile_description",
            "profileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_in_time_yellow",
            "thresholdAverageBusyInTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_in_time_red",
            "thresholdAverageBusyInTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_out_time_yellow",
            "thresholdAverageBusyOutTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_out_time_red",
            "thresholdAverageBusyOutTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_wrap_up_time_yellow",
            "thresholdAverageWrapUpTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_wrap_up_time_red",
            "thresholdAverageWrapUpTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_notification_email",
            "enableNotificationEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "notification_email_address",
            "notificationEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "agent_user_id",
            "agentUserId",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* profileName
    profile_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* profileDescription
    profile_description = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeYellow
    threshold_current_call_state_idle_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeRed
    threshold_current_call_state_idle_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeYellow
    threshold_current_call_state_on_call_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeRed
    threshold_current_call_state_on_call_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeYellow
    threshold_current_agent_state_unavailable_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeRed
    threshold_current_agent_state_unavailable_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeYellow
    threshold_average_busy_in_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeRed
    threshold_average_busy_in_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyOutTimeYellow
    threshold_average_busy_out_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyOutTimeRed
    threshold_average_busy_out_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageWrapUpTimeYellow
    threshold_average_wrap_up_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageWrapUpTimeRed
    threshold_average_wrap_up_time_red = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* enableNotificationEmail
    enable_notification_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* notificationEmailAddress
    notification_email_address = Field(
        type=str,
        required=False,
    )
    #: list(str): *Optional* agentUserId  *Array*
    agent_user_id = Field(
        type=list,
        required=False,
    )


class EnterpriseCallCenterAgentThresholdProfileDeleteAgentListRequest(OCIRequest):
    """
    Delete agent(s) from a Agent Threshold Profile.
    Agents cannot be unassigned (deleted) directly from the default profile, they
    need to be assigned (added) to a different profile.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile_name",
            "profileName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "agent_user_id",
            "agentUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* profileName
    profile_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* agentUserId
    agent_user_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterAgentThresholdProfileDeleteRequest(OCIRequest):
    """
    Deletes an existing Call Center Agent Threshold Profile in an Enterprise.
    The default profile cannot be deleted.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile_name",
            "profileName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* profileName
    profile_name = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterAgentThresholdProfileGetListRequest(OCIRequest):
    """
    Get the list of Call Center Agent Threshold Profiles in the Enterprise.
    The response is either ``EnterpriseCallCenterAgentThresholdProfileGetListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterAgentThresholdProfileGetRequest(OCIRequest):
    """
    Gets an existing non-default Call Center Agent Threshold Profile in an Enterprise.
    The response is either a ``EnterpriseCallCenterAgentThresholdProfileGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile_name",
            "profileName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* profileName
    profile_name = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterAgentUnavailableCodeAddRequest(OCIRequest):
    """
    Add a Call Center Agent Unavailable Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class EnterpriseCallCenterAgentUnavailableCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Agent Unavailable Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterAgentUnavailableCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Agent Unavailable Codes.
    The response is either ``EnterpriseCallCenterAgentUnavailableCodeGetListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterAgentUnavailableCodeGetRequest(OCIRequest):
    """
    Get a Call Center Agent Unavailable Code.
    The response is either ``EnterpriseCallCenterAgentUnavailableCodeGetResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterAgentUnavailableCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Agent Unavailable Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* isActive
    is_active = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest(OCIRequest):
    """
    Request the enterprise level data associated with Call Center Agents Unavailable
    Code Settings.
    The response is either an ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse()``
    or an
    ``ErrorResponse()``.

    Replaced by ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest17sp4()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest17sp4(OCIRequest):
    """
    Request the enterprise level data associated with Call Center Agents Unavailable
    Code Settings.
    The response is either an ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse17sp4()``
    or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterCallDispositionCodeAddRequest(OCIRequest):
    """
    Add a Call Center Call Disposition Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class EnterpriseCallCenterCallDispositionCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Call Disposition Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterCallDispositionCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Call Disposition Codes.
    The response is either ``EnterpriseCallCenterCallDispositionCodeGetListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterCallDispositionCodeGetRequest(OCIRequest):
    """
    Get a Call Center Call Disposition Code.
    The response is either ``EnterpriseCallCenterCallDispositionCodeGetResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterCallDispositionCodeGetUsageListRequest(OCIRequest):
    """
    Get the list of Call Centers and Route Points using the specified disposition code.
    The response is either ``EnterpriseCallCenterCallDispositionCodeGetUsageListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterCallDispositionCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Call Disposition Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* isActive
    is_active = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class EnterpriseCallCenterCurrentAndPastDNISGetListRequest(OCIRequest):
    """
    Request to get all the past and current DNIS for the Call Center for the enterprise.
    The response is either ``EnterpriseCallCenterCurrentAndPastDNISGetListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingBrandingGetRequest(OCIRequest):
    """
    Request to get the enterprise branding information.
    The response is either ``EnterpriseCallCenterEnhancedReportingBrandingGetResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListRequest(
    OCIRequest,
):
    """
    Request to get all enabled call center report template for an enterprise.
    The response is either an ``EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingGetRequest(OCIRequest):
    """
    Request to get an enterprise level call center enhanced reporting setting.
    The response is either an ``EnterpriseCallCenterEnhancedReportingGetResponse()``
    or an ``ErrorResponse()``.

    Replaced by ``EnterpriseCallCenterEnhancedReportingGetRequest19()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingGetRequest19(OCIRequest):
    """
    Request to get an enterprise level call center enhanced reporting setting.
    The response is either an ``EnterpriseCallCenterEnhancedReportingGetResponse19()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingModifyRequest(OCIRequest):
    """
    Request to modify enterprise level call center enhanced reporting settings.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Replaced by ``EnterpriseCallCenterEnhancedReportingModifyRequest19()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "reporting_server",
            "reportingServer",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "web_statistic_source",
            "webStatisticSource",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* reportingServer
    reporting_server = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* webStatisticSource
    web_statistic_source = Field(
        type=str,
        required=False,
    )


class EnterpriseCallCenterEnhancedReportingModifyRequest19(OCIRequest):
    """
    Request to modify enterprise level call center enhanced reporting settings.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "reporting_server",
            "reportingServer",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* reportingServer
    reporting_server = Field(
        type=str,
        required=False,
    )


class EnterpriseCallCenterEnhancedReportingReportTemplateDeleteRequest(OCIRequest):
    """
    Request to delete an enterprise level call center report template.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingReportTemplateGetListRequest(OCIRequest):
    """
    Request to get enterprise level call center report template list.
    The response is either an ``EnterpriseCallCenterEnhancedReportingReportTemplateGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingReportTemplateGetRequest(OCIRequest):
    """
    Request to get an enterprise level call center report template.
    The response is either an ``EnterpriseCallCenterEnhancedReportingReportTemplateGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingScheduledReportDeleteRequest(OCIRequest):
    """
    Request to delete an enterprise level call center reporting scheduled report.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest(
    OCIRequest,
):
    """
    Request to get all the call center reporting scheduled report in an enterprise
    that uses a given enterprise level report template.
    The response is either a ``EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingScheduledReportGetRequest(OCIRequest):
    """
    Request to get an enterprise level call center reporting scheduled report.
    The response is either an ``EnterpriseCallCenterEnhancedReportingScheduledReportGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterGetRequest(OCIRequest):
    """
    Request the enterprise level data associated with Call Center.
    The response is either an ``EnterpriseCallCenterGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced by ``EnterpriseCallCenterGetRequest17sp4()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterGetRequest17sp4(OCIRequest):
    """
    Request the enterprise level data associated with Call Center.
    The response is either an ``EnterpriseCallCenterGetResponse17sp4()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterGetRoutingPolicyRequest(OCIRequest):
    """
    Request the enterprise call center routing policy.
    The response is either an ``EnterpriseCallCenterGetRoutingPolicyResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterModifyRequest(OCIRequest):
    """
    Modify the enterprise level data associated with Call Center
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_system_default_guard_timer",
            "useSystemDefaultGuardTimer",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_guard_timer",
            "enableGuardTimer",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "guard_timer_seconds",
            "guardTimerSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* useSystemDefaultGuardTimer
    use_system_default_guard_timer = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableGuardTimer
    enable_guard_timer = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* guardTimerSeconds
    guard_timer_seconds = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useSystemDefaultUnavailableSettings
    use_system_default_unavailable_settings = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnNotReachable
    force_agent_unavailable_on_not_reachable = Field(
        type=bool,
        required=False,
    )


class EnterpriseCommonPhoneListDeleteListRequest(OCIRequest):
    """
    Delete one or more entries from an enterprise's common phone list.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "entry_name",
            "entryName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* entryName
    entry_name = Field(
        type=str,
        required=True,
    )


class EnterpriseCommonPhoneListModifyRequest(OCIRequest):
    """
    Modify an entry in an enterprise's common phone list.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "entry_name",
            "entryName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "new_entry_name",
            "newEntryName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* entryName
    entry_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* newEntryName
    new_entry_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )


class EnterpriseDepartmentDeleteRequest(OCIRequest):
    """
    Delete a department from an enterprise.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "enterprise_id",
            "enterpriseId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* enterpriseId
    enterprise_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )


class EnterpriseDepartmentGetAvailableParentListRequest(OCIRequest):
    """
    Get a list of enterprise level departments in an enterprise that could be the
    parent of the
    specified department. The department itself and all its decendents are not eligible to be
    the parent department.
    The response is either ``EnterpriseDepartmentGetAvailableParentListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "enterprise_id",
            "enterpriseId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* enterpriseId
    enterprise_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )


class EnterpriseDepartmentGetListRequest(OCIRequest):
    """
    Request a list of departments in an enterprise. You may request only the
    list of departments defined at the enterprise-level, or you may request
    the list of all departments in the enterprise including all the departments
    defined within the groups inside the enterprise.
    The response is either ``EnterpriseDepartmentGetListResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "enterprise_id",
            "enterpriseId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_group_departments",
            "includeGroupDepartments",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* enterpriseId
    enterprise_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* includeGroupDepartments
    include_group_departments = Field(
        type=bool,
        required=True,
    )


class EnterpriseEnterpriseTrunkAddRequest(OCIRequest):
    """
    Request to add an enterprise trunk in an enterprise.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Replaced By ``EnterpriseEnterpriseTrunkAddRequest21()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "maximum_reroute_attempts",
            "maximumRerouteAttempts",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_exhaustion_action",
            "routeExhaustionAction",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_exhaustion_forward_address",
            "routeExhaustionForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "ordered_routing",
            "orderedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "priority_weighted_routing",
            "priorityWeightedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )
    #: int: *Required* maximumRerouteAttempts
    maximum_reroute_attempts = Field(
        type=int,
        required=True,
    )
    #: str: *Required* routeExhaustionAction
    route_exhaustion_action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* orderedRouting
    ordered_routing = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(
        type=str,
        required=False,
    )


class EnterpriseEnterpriseTrunkAddRequest21(OCIRequest):
    """
    Request to add an enterprise trunk in an enterprise.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "maximum_reroute_attempts",
            "maximumRerouteAttempts",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_exhaustion_action",
            "routeExhaustionAction",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_exhaustion_forward_address",
            "routeExhaustionForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "ordered_routing",
            "orderedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "priority_weighted_routing",
            "priorityWeightedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "enable_capacity_management",
            "enableCapacityManagement",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_active_calls",
            "maxActiveCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_initial_calls",
            "capacityExceededTrapInitialCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_offset_calls",
            "capacityExceededTrapOffsetCalls",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )
    #: int: *Required* maximumRerouteAttempts
    maximum_reroute_attempts = Field(
        type=int,
        required=True,
    )
    #: str: *Required* routeExhaustionAction
    route_exhaustion_action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* orderedRouting
    ordered_routing = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* enableCapacityManagement
    enable_capacity_management = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* maxActiveCalls
    max_active_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(
        type=int,
        required=False,
    )


class EnterpriseEnterpriseTrunkAddUserListRequest(OCIRequest):
    """
    Request to add users to an enterprise trunk in an enterprise.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class EnterpriseEnterpriseTrunkDeleteRequest(OCIRequest):
    """
    Request to delete an enterprise trunk in an enterprise.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )


class EnterpriseEnterpriseTrunkDeleteUserListRequest(OCIRequest):
    """
    Request to delete users from an enterprise trunk in an enterprise.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class EnterpriseEnterpriseTrunkForceAssignUserListRequest(OCIRequest):
    """
    Request to add users to an enterprise trunk in an enterprise. If the user is
    already assigned to another enterprise trunk,
    it will be unassigned from the old enterprise trunk and assigned to the new
    enterprise trunk specified in this request.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class EnterpriseEnterpriseTrunkGetListRequest(OCIRequest):
    """
    Request to get the list of all enterprise trunks defined in an enterprise.
    The response is either a ``EnterpriseEnterpriseTrunkGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseEnterpriseTrunkGetRequest(OCIRequest):
    """
    Request to get an enterprise trunk
    The response is either an ``EnterpriseEnterpriseTrunkGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced By ``EnterpriseEnterpriseTrunkGetRequest21()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )


class EnterpriseEnterpriseTrunkGetRequest21(OCIRequest):
    """
    Request to get an enterprise trunk
    The response is either an ``EnterpriseEnterpriseTrunkGetResponse21()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )


class EnterpriseEnterpriseTrunkModifyRequest(OCIRequest):
    """
    Request to modify an enterprise trunk in an enterprise.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "new_enterprise_trunk_name",
            "newEnterpriseTrunkName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "maximum_reroute_attempts",
            "maximumRerouteAttempts",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "route_exhaustion_action",
            "routeExhaustionAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "route_exhaustion_forward_address",
            "routeExhaustionForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "ordered_routing",
            "orderedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "priority_weighted_routing",
            "priorityWeightedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "enable_capacity_management",
            "enableCapacityManagement",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_active_calls",
            "maxActiveCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_initial_calls",
            "capacityExceededTrapInitialCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_offset_calls",
            "capacityExceededTrapOffsetCalls",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* newEnterpriseTrunkName
    new_enterprise_trunk_name = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* maximumRerouteAttempts
    maximum_reroute_attempts = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* routeExhaustionAction
    route_exhaustion_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* orderedRouting
    ordered_routing = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* enableCapacityManagement
    enable_capacity_management = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxActiveCalls
    max_active_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(
        type=int,
        required=False,
    )


class EnterprisePreAlertingAnnouncementGetRequest(OCIRequest):
    """
    Get the Enterprise pre-alerting service settings.
    The response is either a ``EnterprisePreAlertingAnnouncementGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest(OCIRequest):
    """
    Request a list of number ranges that are assigned to an enterprise and still
    available for assignment to users within the enterprise.
    The response is either ``EnterpriseRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest(OCIRequest):
    """
    Request a summary table of all enterprise trunk number ranges in the enterprise.
    The response is either ``EnterpriseRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseSessionAdmissionControlGroupDeleteListRequest(OCIRequest):
    """
    Request to delete one or more session admission control groups for the enterprise.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class EnterpriseSessionAdmissionControlGroupGetListRequest(OCIRequest):
    """
    Request to get the list of session admission control group for the enterprise.
    The response is either an ``EnterpriseSessionAdmissionControlGroupGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseSessionAdmissionControlGroupGetRequest(OCIRequest):
    """
    Request to get a session admission control group for the enterprise.
    The response is either an ``EnterpriseSessionAdmissionControlGroupGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class EnterpriseSessionAdmissionControlGroupGetRequest19sp1(OCIRequest):
    """
    Request to get a session admission control group for the enterprise.
    The response is either an ``EnterpriseSessionAdmissionControlGroupGetResponse19sp1()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class EnterpriseVoiceVPNDeletePolicyRequest(OCIRequest):
    """
    Delete a enterprise voice VPN location.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "location_dialing_code",
            "locationDialingCode",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* locationDialingCode
    location_dialing_code = Field(
        type=str,
        required=True,
    )


class EnterpriseVoiceVPNGetDefaultRequest(OCIRequest):
    """
    Request the Voice VPN default settings for the enterprise.
    The response is ``EnterpriseVoiceVPNGetDefaultResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseVoiceVPNGetPolicyRequest(OCIRequest):
    """
    Request the enterprise level data associated with Voice VPN location code.
    The response is either a ``EnterpriseVoiceVPNGetPolicyResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "location_dialing_code",
            "locationDialingCode",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* locationDialingCode
    location_dialing_code = Field(
        type=str,
        required=True,
    )


class EnterpriseVoiceVPNGetRequest(OCIRequest):
    """
    Request the enterprise level data associated with Voice VPN.
    The response is either a ``EnterpriseVoiceVPNGetResponse()`` or an ``ErrorResponse()``.
    Replaced By ``EnterpriseVoiceVPNGetRequest14sp3()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseVoiceVPNGetRequest14sp3(OCIRequest):
    """
    Request the enterprise level data associated with Voice VPN.
    The response is either a ``EnterpriseVoiceVPNGetResponse14sp3()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class EnterpriseVoiceVPNModifyRequest(OCIRequest):
    """
    Modify the enterprise voice VPN level data associated with voice VPN.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_selection",
            "defaultSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "e164_selection",
            "e164Selection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_phone_context",
            "usePhoneContext",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* isActive
    is_active = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* defaultSelection
    default_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* e164Selection
    e164_selection = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* usePhoneContext
    use_phone_context = Field(
        type=bool,
        required=False,
    )


class ExternalAuthenticationAuthorizeTokenRequest(OCIRequest):
    """
    This command is part of the Portal API.
    Sent when a Web or CLI user logs in using external authentication.
    The password must be hashed. The password hashing algorithm is:
    1) The message digest of the user's plain password is calculated using the SHA algorithm.
    2) For every four bits in the 160-bit digest, starting from the first bit, it is
    converted into a character in ASCII Hex format (0 through 9, a through f).
    The result is a 40-character string, for example,
    f7a9e24777ec23212c54d7a350bc5bea5477fdbb.
    3) The above string then is used to populate the password field in the request.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "login_token",
            "loginToken",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* password
    password = Field(
        type=str,
        required=False,
    )
    #: str: *Required* loginToken
    login_token = Field(
        type=str,
        required=True,
    )


class ExternalAuthenticationCreateLoginTokenRequest(OCIRequest):
    """
    This command allows a BroadWorks or Third-Party Client Application to
    create a Single Sign-On token for a user.
    The response is either ``ExternalAuthenticationCreateLoginTokenResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceCustomTagAddRequest(OCIRequest):
    """
    Request to add a static configuration tag for a group access device.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_name",
            "tagName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_value",
            "tagValue",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* tagName
    tag_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* tagValue
    tag_value = Field(
        type=str,
        required=False,
    )


class GroupAccessDeviceCustomTagDeleteListRequest(OCIRequest):
    """
    Request to delete static configuration tags for a group access device.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_name",
            "tagName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* tagName
    tag_name = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceCustomTagGetListRequest(OCIRequest):
    """
    Request to get the list of custom configuration tags managed by the Device
    Management System, on a per-device profile basis.
    The response is either ``GroupAccessDeviceCustomTagGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceCustomTagModifyRequest(OCIRequest):
    """
    Request to modify a static configuration tag for a group access device.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_name",
            "tagName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_value",
            "tagValue",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* tagName
    tag_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* tagValue
    tag_value = Field(
        type=str,
        required=False,
    )


class GroupAccessDeviceDeleteRequest(OCIRequest):
    """
    Request to delete a specified group access device.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceFileGetListRequest(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System,
    on a per-device profile basis.
    The response is either ``GroupAccessDeviceFileGetListResponse()`` or ``ErrorResponse()``.
    Replaced By ``GroupAccessDeviceFileGetListRequest14sp8()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceFileGetListRequest14sp8(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System,
    on a per-device profile basis.
    The response is either ``GroupAccessDeviceFileGetListResponse14sp8()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceFileGetRequest(OCIRequest):
    """
    Request to get a group device profile file.
    The response is either ``GroupAccessDeviceFileGetResponse()`` or ``ErrorResponse()``.
    Replaced By ``GroupAccessDeviceFileGetRequest14sp8()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_type",
            "fileType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileType
    file_type = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceFileGetRequest14sp8(OCIRequest):
    """
    Request to get a group device profile file.
    The response is either ``GroupAccessDeviceFileGetResponse14sp8()`` or ``ErrorResponse()``.
    Replaced By ``GroupAccessDeviceFileGetRequest16sp1()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_format",
            "fileFormat",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileFormat
    file_format = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceFileGetRequest16sp1(OCIRequest):
    """
    Request to get a group device profile file.
    The response is either ``GroupAccessDeviceFileGetResponse16sp1()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_format",
            "fileFormat",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileFormat
    file_format = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceFileGetRequest20(OCIRequest):
    """
    Request to get a group device profile file.
    The response is either ``GroupAccessDeviceFileGetResponse20()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_format",
            "fileFormat",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileFormat
    file_format = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceGetAvailableDetailListRequest14(OCIRequest):
    """
    Requests the list of available access devices for assignment to a user
    within a group. The list includes devices created at the system, service
    provider, and group levels.
    The response is either ``GroupAccessDeviceGetAvailableDetailListResponse14()`` or
    ``ErrorResponse()``.

    Replaced By ``GroupAccessDeviceGetAvailableDetailListRequest19()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_music_on_hold",
            "isMusicOnHold",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "only_video_capable",
            "onlyVideoCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isMusicOnHold
    is_music_on_hold = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* onlyVideoCapable
    only_video_capable = Field(
        type=bool,
        required=True,
    )


class GroupAccessDeviceGetAvailableDetailListRequest19(OCIRequest):
    """
    Requests the list of available access devices for assignment to a user
    within a group. The list includes devices created at the system, service
    provider, and group levels.
    The response is either ``GroupAccessDeviceGetAvailableDetailListResponse19()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_music_on_hold",
            "isMusicOnHold",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "only_video_capable",
            "onlyVideoCapable",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isMusicOnHold
    is_music_on_hold = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* onlyVideoCapable
    only_video_capable = Field(
        type=bool,
        required=True,
    )


class GroupAccessDeviceGetEnhancedConfigurationTypeListRequest(OCIRequest):
    """
    Requests the list of configurable device types of devices that have already been
    added to the group.
    The response is either ``GroupAccessDeviceGetEnhancedConfigurationTypeListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceGetEnhancedConfigurationTypeRequest14(OCIRequest):
    """
    Requests the details of a specified configurable device type for a group.
    The response is either ``GroupAccessDeviceGetEnhancedConfigurationTypeResponse14()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceGetRequest14(OCIRequest):
    """
    Requests the configuration of a specified group access device.
    The response is either ``GroupAccessDeviceGetResponse14()`` or ``ErrorResponse()``.
    Replaced By ``GroupAccessDeviceGetRequest14sp3()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceGetRequest14sp3(OCIRequest):
    """
    Requests the configuration of a specified group access device.
    The response is either ``GroupAccessDeviceGetResponse14sp3()`` or ``ErrorResponse()``.
    Replaced By ``GroupAccessDeviceGetRequest14sp6()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceGetRequest14sp6(OCIRequest):
    """
    Requests the configuration of a specified group access device.
    The response is either ``GroupAccessDeviceGetResponse14sp6()`` or ``ErrorResponse()``.
    Replaced By ``GroupAccessDeviceGetRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceGetRequest16(OCIRequest):
    """
    Requests the configuration of a specified group access device.
    The response is either ``GroupAccessDeviceGetResponse16()`` or ``ErrorResponse()``.

    Replaced By ``GroupAccessDeviceGetRequest18sp1()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceGetRequest18sp1(OCIRequest):
    """
    Requests the configuration of a specified group access device.
    The response is either ``GroupAccessDeviceGetResponse18sp1()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceModifyUserRequest(OCIRequest):
    """
    Request to modify attributes for line/ports assigned on the group device profile.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    The following elements are only used in HSS data mode and ignored in AS data mode:
    privateIdentity
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "private_identity",
            "privateIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "is_primary_line_port",
            "isPrimaryLinePort",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* privateIdentity
    private_identity = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* isPrimaryLinePort
    is_primary_line_port = Field(
        type=bool,
        required=False,
    )


class GroupAccessDeviceResetRequest(OCIRequest):
    """
    Reset a specific group SIP device that supports the reset operation.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class GroupAccountAuthorizationCodesDeleteListRequest(OCIRequest):
    """
    Delete a list of account/authorization codes from a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )


class GroupAccountAuthorizationCodesGetListRequest(OCIRequest):
    """
    Request the list of account/authorization codes for a group.
    The response is either a ``GroupAccountAuthorizationCodesGetListResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupAccountAuthorizationCodesGetRequest(OCIRequest):
    """
    Request the group's account/authorization codes setting.
    The response is either a ``GroupAccountAuthorizationCodesGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupAdminAddRequest(OCIRequest):
    """
    Add a group administrator.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "first_name",
            "firstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "last_name",
            "lastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* firstName
    first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* lastName
    last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* password
    password = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )


class GroupAdminDeleteRequest(OCIRequest):
    """
    Delete a group administrator.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupAdminGetListRequest(OCIRequest):
    """
    Get a list of group and department administrators within the group.
    The response is either a ``GroupAdminGetListResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupAdminGetPolicyRequest(OCIRequest):
    """
    Requests the Group administrator's policy settings.
    The response is either ``GroupAdminGetPolicyResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupAdminGetPolicyRequest14sp1(OCIRequest):
    """
    Requests the Group administrator's policy settings.
    The response is either ``GroupAdminGetPolicyResponse14sp1()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupAdminGetPolicyRequest16sp1(OCIRequest):
    """
    Requests the Group administrator's policy settings.
    The response is either ``GroupAdminGetPolicyResponse16sp1()`` or ``ErrorResponse()``.
    Replaced By ``GroupAdminGetPolicyRequest17()``
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupAdminGetPolicyRequest16sp2(OCIRequest):
    """
    Requests the Group administrator's policy settings.
    The response is either ``GroupAdminGetPolicyResponse16sp2()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupAdminGetPolicyRequest17(OCIRequest):
    """
    Requests the Group administrator's policy settings.
    The response is either ``GroupAdminGetPolicyResponse17()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupAdminGetPolicyRequest17sp3(OCIRequest):
    """
    Requests the Group administrator's policy settings.
    The response is either ``GroupAdminGetPolicyResponse17sp3()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupAdminGetPolicyRequest18(OCIRequest):
    """
    Requests the Group administrator's policy settings.
    The response is either ``GroupAdminGetPolicyResponse18()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupAdminGetPolicyRequest19sp1(OCIRequest):
    """
    Requests the Group administrator's policy settings.
    The response is either ``GroupAdminGetPolicyResponse19sp1()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupAdminGetPolicyRequest20(OCIRequest):
    """
    Requests the Group administrator's policy settings.
    The response is either ``GroupAdminGetPolicyResponse20()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupAdminGetRequest(OCIRequest):
    """
    Get a group administrators profile.
    The response is either a ``GroupAdminGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupAdminModifyPolicyRequest(OCIRequest):
    """
    Request to modify the group administrator's policy settings.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    The following elements are only used in AS data mode:
    dialableCallerIDAccess
    verifyTranslationAndRoutingAccess
    communicationBarringUserProfileAccess (only applicable to groups in an Enterprise)
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "enhanced_service_instance_access",
            "enhancedServiceInstanceAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "feature_access_code_access",
            "featureAccessCodeAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_number_access",
            "callingLineIdNumberAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "trunk_group_access",
            "trunkGroupAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "session_admission_control_access",
            "sessionAdmissionControlAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "office_zone_access",
            "officeZoneAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "dialable_caller_id_access",
            "dialableCallerIDAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_activation_access",
            "numberActivationAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "verify_translation_and_routing_access",
            "verifyTranslationAndRoutingAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "communication_barring_user_profile_access",
            "communicationBarringUserProfileAccess",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* profileAccess
    profile_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userAccess
    user_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* adminAccess
    admin_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* departmentAccess
    department_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* featureAccessCodeAccess
    feature_access_code_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdNumberAccess
    calling_line_id_number_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceAccess
    service_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* trunkGroupAccess
    trunk_group_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* sessionAdmissionControlAccess
    session_admission_control_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* officeZoneAccess
    office_zone_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* dialableCallerIDAccess
    dialable_caller_id_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* numberActivationAccess
    number_activation_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* verifyTranslationAndRoutingAccess
    verify_translation_and_routing_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* communicationBarringUserProfileAccess
    communication_barring_user_profile_access = Field(
        type=str,
        required=False,
    )


class GroupAdminModifyRequest(OCIRequest):
    """
    Modify a group administrator.
    Since old password is not specified here, any password rule related to old password
    does not apply.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "first_name",
            "firstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "last_name",
            "lastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* firstName
    first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* lastName
    last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* password
    password = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )


class GroupAdviceOfChargeGetRequest(OCIRequest):
    """
    Request to get the list of Advice of Charge group parameters.
    The response is either ``GroupAdviceOfChargeGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupAdviceOfChargeModifyRequest(OCIRequest):
    """
    Modify the service provider level Advice Of Charge group settings.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_level_ao_c_settings",
            "useGroupLevelAoCSettings",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "delay_between_notification_seconds",
            "delayBetweenNotificationSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* useGroupLevelAoCSettings
    use_group_level_ao_c_settings = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* delayBetweenNotificationSeconds
    delay_between_notification_seconds = Field(
        type=int,
        required=False,
    )


class GroupApplicationServerSetGetRequest(OCIRequest):
    """
    Get the Application Server set for a group.
    The response is either a ``GroupApplicationServerSetGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupApplicationServerSetModifyRequest(OCIRequest):
    """
    Modify the Application Server set for a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "application_server_set_name",
            "applicationServerSetName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* applicationServerSetName
    application_server_set_name = Field(
        type=str,
        required=False,
    )


class GroupAutoAttendantDeleteInstanceRequest(OCIRequest):
    """
    Delete a Auto Attendant instance from a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupAutoAttendantGetInstanceListRequest(OCIRequest):
    """
    Get a list of Auto Attendant instances within a group.
    The response is either ``GroupAutoAttendantGetInstanceListResponse()`` or
    ``ErrorResponse()``.
    It is possible to get the instances within a specified department.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_department_name",
            "groupDepartmentName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(
        type=str,
        required=False,
    )


class GroupAutoAttendantGetInstanceRequest14(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.
    The response is either ``GroupAutoAttendantGetInstanceResponse()`` or ``ErrorResponse()``.
    Replaced By ``GroupAutoAttendantGetInstanceRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupAutoAttendantGetInstanceRequest16(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.
    The response is either ``GroupAutoAttendantGetInstanceResponse16()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupAutoAttendantGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.
    The response is either ``GroupAutoAttendantGetInstanceResponse17()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupAutoAttendantGetInstanceRequest17sp1(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.
    The response is either ``GroupAutoAttendantGetInstanceResponse17sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupAutoAttendantGetInstanceRequest19(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.
    The response is either ``GroupAutoAttendantGetInstanceResponse19()`` or
    ``ErrorResponse()``.

    Replaced By ``GroupAutoAttendantGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupAutoAttendantGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.
    The response is either ``GroupAutoAttendantGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.

    Replaced By ``GroupAutoAttendantGetInstanceRequest20()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupAutoAttendantGetInstanceRequest20(OCIRequest):
    """
    Request to get all the information of a Auto Attendant instance.
    The response is either ``GroupAutoAttendantGetInstanceResponse20()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupAutoAttendantSubmenuDeleteListRequest(OCIRequest):
    """
    Delete a submenu form an auto attendant.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    This request is only valid for Standard auto attendants.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "submenu_id",
            "submenuId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* submenuId
    submenu_id = Field(
        type=str,
        required=True,
    )


class GroupAutoAttendantSubmenuGetListRequest(OCIRequest):
    """
    Get a list of Auto Attendant Submenus.
    The response is either ``GroupAutoAttendantSubmenuGetListResponse()`` or
    ``ErrorResponse()``.
    This request is only valid for Standard auto attendants.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupAutoAttendantSubmenuGetRequest(OCIRequest):
    """
    Request to get an Auto Attendant submenu instance.
    The response is either ``GroupAutoAttendantSubmenuGetResponse()`` or ``ErrorResponse()``.
    This request is only valid for Standard auto attendants.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "submenu_id",
            "submenuId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* submenuId
    submenu_id = Field(
        type=str,
        required=True,
    )


class GroupAutoAttendantSubmenuGetRequest20(OCIRequest):
    """
    Request to get an Auto Attendant submenu instance.
    The response is either ``GroupAutoAttendantSubmenuGetResponse20()`` or
    ``ErrorResponse()``.
    This request is only valid for Standard auto attendants.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "submenu_id",
            "submenuId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* submenuId
    submenu_id = Field(
        type=str,
        required=True,
    )


class GroupAutoAttendantSubmenuGetUsageListRequest(OCIRequest):
    """
    Get a list of Auto Attendant Business Hours Menu,After Hours Menu,Holiday Menu
    and Submenus that use this submenu.
    The response is either ``GroupAutoAttendantSubmenuGetUsageListResponse()`` or
    ``ErrorResponse()``.
    This request is only valid for Standard auto attendants.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "submenu_id",
            "submenuId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* submenuId
    submenu_id = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksAnywhereDeleteInstanceRequest(OCIRequest):
    """
    Delete a BroadWorks Anywhere instance from a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksAnywhereGetInstanceListRequest(OCIRequest):
    """
    Get a list of BroadWorks Anywhere instances within a group.
    The response is either ``GroupBroadWorksAnywhereGetInstanceListResponse()`` or
    ``ErrorResponse()``.
    It is possible to get the instances within a specified department.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_department_name",
            "groupDepartmentName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(
        type=str,
        required=False,
    )


class GroupBroadWorksAnywhereGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a BroadWorks Anywhere instance.
    The response is either ``GroupBroadWorksAnywhereGetInstanceResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksAnywhereGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of a BroadWorks Anywhere instance.
    The response is either ``GroupBroadWorksAnywhereGetInstanceResponse17()`` or
    ``ErrorResponse()``.

    Replaced By ``GroupBroadWorksAnywhereGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksAnywhereGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a BroadWorks Anywhere instance.
    The response is either ``GroupBroadWorksAnywhereGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksMobileManagerActivationRequest(OCIRequest):
    """
    Activates or Deactivates the BroadWorks Mobile Manager.
    The deactivationReason is required when isActive is set to false.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "deactivation_reason",
            "deactivationReason",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* deactivationReason
    deactivation_reason = Field(
        type=str,
        required=False,
    )


class GroupBroadWorksMobileManagerAddHomeZoneRequest(OCIRequest):
    """
    Add a home zone to the BroadWorks Mobile Manager.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "home_zone_domain_name",
            "homeZoneDomainName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_country_code",
            "mobileCountryCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_network_code",
            "mobileNetworkCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "location_area_code",
            "locationAreaCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "cell_identity",
            "cellIdentity",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* homeZoneDomainName
    home_zone_domain_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* mobileCountryCode
    mobile_country_code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* mobileNetworkCode
    mobile_network_code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* locationAreaCode
    location_area_code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* cellIdentity
    cell_identity = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksMobileManagerAddRequest(OCIRequest):
    """
    Add the BroadWorks Mobile Manager.
    Only one BroadWorks Mobile Manager can be added per group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "information_file",
            "informationFile",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "certificate_file",
            "certificateFile",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "local_to_carrier",
            "localToCarrier",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_tx_per_second_enabled",
            "maxTxPerSecondEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_tx_per_second",
            "maxTxPerSecond",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "tldn_enabled",
            "tldnEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "generic_number_enabled",
            "genericNumberEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_state_check_enabled",
            "mobileStateCheckEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "location_based_services_enabled",
            "locationBasedServicesEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* informationFile
    information_file = Field(
        type=str,
        required=True,
    )
    #: str: *Required* certificateFile
    certificate_file = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* localToCarrier
    local_to_carrier = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* maxTxPerSecondEnabled
    max_tx_per_second_enabled = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* maxTxPerSecond
    max_tx_per_second = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* tldnEnabled
    tldn_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* genericNumberEnabled
    generic_number_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* mobileStateCheckEnabled
    mobile_state_check_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* locationBasedServicesEnabled
    location_based_services_enabled = Field(
        type=bool,
        required=True,
    )


class GroupBroadWorksMobileManagerDeleteHomeZoneListRequest(OCIRequest):
    """
    Delete a list of home zones from the BroadWorks Mobile Manager.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "home_zone_id",
            "homeZoneId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* homeZoneId
    home_zone_id = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksMobileManagerDeleteHomeZoneRequest(OCIRequest):
    """
    Delete a home zone from the BroadWorks Mobile Manager.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "home_zone_id",
            "homeZoneId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* homeZoneId
    home_zone_id = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksMobileManagerDeleteRequest(OCIRequest):
    """
    Delete the BroadWorks Mobile Manager.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksMobileManagerGetDomainListRequest(OCIRequest):
    """
    Get the list of domains of the BroadWorks Mobile Manager.
    The response is either ``GroupBroadWorksMobileManagerGetDomainListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksMobileManagerGetHomeZoneListRequest(OCIRequest):
    """
    Get the list of home zones of the BroadWorks Mobile Manager.
    The response is either ``GroupBroadWorksMobileManagerGetHomeZoneListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksMobileManagerGetHomeZoneRequest(OCIRequest):
    """
    Get a home zone from the BroadWorks Mobile Manager.
    The response is either ``GroupBroadWorksMobileManagerGetHomeZoneResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "home_zone_id",
            "homeZoneId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* homeZoneId
    home_zone_id = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksMobileManagerGetRequest(OCIRequest):
    """
    Get the BroadWorks Mobile Manager.
    The response is either ``GroupBroadWorksMobileManagerGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksMobileManagerModifyHomeZoneRequest(OCIRequest):
    """
    Modify an existing home zone in the BroadWorks Mobile Manager.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "home_zone_id",
            "homeZoneId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "home_zone_domain_name",
            "homeZoneDomainName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "mobile_country_code",
            "mobileCountryCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "mobile_network_code",
            "mobileNetworkCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "location_area_code",
            "locationAreaCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "cell_identity",
            "cellIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* homeZoneId
    home_zone_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* homeZoneDomainName
    home_zone_domain_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* mobileCountryCode
    mobile_country_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* mobileNetworkCode
    mobile_network_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* locationAreaCode
    location_area_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* cellIdentity
    cell_identity = Field(
        type=str,
        required=False,
    )


class GroupBroadWorksMobileManagerModifyRequest(OCIRequest):
    """
    Modify the BroadWorks Mobile Manager settings.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "information_file",
            "informationFile",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "certificate_file",
            "certificateFile",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "local_to_carrier",
            "localToCarrier",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_tx_per_second_enabled",
            "maxTxPerSecondEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_tx_per_second",
            "maxTxPerSecond",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "tldn_enabled",
            "tldnEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "generic_number_enabled",
            "genericNumberEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mobile_state_check_enabled",
            "mobileStateCheckEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "location_based_services_enabled",
            "locationBasedServicesEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* informationFile
    information_file = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* certificateFile
    certificate_file = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* localToCarrier
    local_to_carrier = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* maxTxPerSecondEnabled
    max_tx_per_second_enabled = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxTxPerSecond
    max_tx_per_second = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* tldnEnabled
    tldn_enabled = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* genericNumberEnabled
    generic_number_enabled = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* mobileStateCheckEnabled
    mobile_state_check_enabled = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* locationBasedServicesEnabled
    location_based_services_enabled = Field(
        type=bool,
        required=False,
    )


class GroupBroadWorksMobileManagerSendCarrierFilesRequest(OCIRequest):
    """
    Sends an email with the carrier information and certificate files.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "email_to",
            "emailTo",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emailTo
    email_to = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksMobilityGetRequest(OCIRequest):
    """
    Get the groups BroadWorks Mobility settings.
    The response is either a ``GroupBroadWorksMobilityGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksMobilityGetRequest19sp1(OCIRequest):
    """
    Get the group's BroadWorks Mobility settings.
    The response is either a ``GroupBroadWorksMobilityGetResponse19sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberAssignListRequest(
    OCIRequest,
):
    """
    Assign Mobile Subscriber Directory Numbers to a group. It is possible to
    add a single DN,or a list of DNs.
    .       This command is applicable only for group in a service provider and will
    fail for a group in an enterprise.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_subscriber_directory_number",
            "mobileSubscriberDirectoryNumber",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* mobileSubscriberDirectoryNumber  *Array*
    mobile_subscriber_directory_number = Field(
        type=list,
        required=False,
    )


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest(
    OCIRequest,
):
    """
    Request a list of available Mobile Subscriber Directory Numbers not yet assigned
    to any user.
    .       This command is applicable only for group in a service provider and will
    fail for a group in an enterprise.
    The response is either ``GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberUnassignListRequest(
    OCIRequest,
):
    """
    Unassign Mobile Subscriber Directory Numbers from a group. It is possible to
    unassign either: a single DN, or a list of DNs.
    .       This command is applicable only for group in a service provider and will
    fail for a group in an enterprise.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_subscriber_directory_number",
            "mobileSubscriberDirectoryNumber",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* mobileSubscriberDirectoryNumber  *Array*
    mobile_subscriber_directory_number = Field(
        type=list,
        required=False,
    )


class GroupBroadWorksMobilityModifyRequest(OCIRequest):
    """
    Modify the group level broadworks mobility service settings.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_location_services",
            "enableLocationServices",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_msrn_lookup",
            "enableMSRNLookup",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_mobile_state_checking",
            "enableMobileStateChecking",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "deny_call_originations",
            "denyCallOriginations",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "deny_call_terminations",
            "denyCallTerminations",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_announcement_suppression",
            "enableAnnouncementSuppression",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* enableLocationServices
    enable_location_services = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableMSRNLookup
    enable_msrn_lookup = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableMobileStateChecking
    enable_mobile_state_checking = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* denyCallOriginations
    deny_call_originations = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* denyCallTerminations
    deny_call_terminations = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableAnnouncementSuppression
    enable_announcement_suppression = Field(
        type=bool,
        required=False,
    )


class GroupCPEConfigRebuildConfigFileRequest(OCIRequest):
    """
    Rebuild the group default config file for the specified device type.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "force",
            "force",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* force
    force = Field(
        type=bool,
        required=False,
    )


class GroupCPEConfigRebuildDeviceConfigFileRequest(OCIRequest):
    """
    Rebuild the config file for a specified device.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "force",
            "force",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* force
    force = Field(
        type=bool,
        required=False,
    )


class GroupCPEConfigReorderDeviceLinePortsRequest(OCIRequest):
    """
    Reorder the lines of a group device. You can not add or delete line ports, only
    re-ordering the list is allowed. The ordered list of line ports can be obtained
    with the ``GroupAccessDeviceGetRequest16()`` command.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "ordered_line_port_list",
            "orderedLinePortList",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* orderedLinePortList
    ordered_line_port_list = Field(
        type=str,
        required=True,
    )


class GroupCPEConfigResetDeviceRequest(OCIRequest):
    """
    Reset a specific group device.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class GroupCPEConfigResetDeviceTypeRequest(OCIRequest):
    """
    Reset all the devices of the specified device type in a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )


class GroupCallCapacityManagementAddInstanceRequest(OCIRequest):
    """
    Adds a Call Capacity Management group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_active_calls_allowed",
            "maxActiveCallsAllowed",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_incoming_active_calls_allowed",
            "maxIncomingActiveCallsAllowed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_outgoing_active_calls_allowed",
            "maxOutgoingActiveCallsAllowed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "become_default_group_for_new_users",
            "becomeDefaultGroupForNewUsers",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: int: *Required* maxActiveCallsAllowed
    max_active_calls_allowed = Field(
        type=int,
        required=True,
    )
    #: int: *Optional* maxIncomingActiveCallsAllowed
    max_incoming_active_calls_allowed = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxOutgoingActiveCallsAllowed
    max_outgoing_active_calls_allowed = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* becomeDefaultGroupForNewUsers
    become_default_group_for_new_users = Field(
        type=bool,
        required=True,
    )
    #: list(str): *Optional* userId  *Array*
    user_id = Field(
        type=list,
        required=False,
    )


class GroupCallCapacityManagementAddUserListRequest(OCIRequest):
    """
    Adds one or more users to a Call Capacity Management group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCapacityManagementDeleteInstanceListRequest(OCIRequest):
    """
    Deletes one or more Call Capacity Management groups.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupCallCapacityManagementDeleteUserListRequest(OCIRequest):
    """
    Deletes one or more users from a Call Capacity Management group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCapacityManagementGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Call Capacity Management instances within a group.
    The response is either ``GroupCallCapacityManagementGetInstanceListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallCapacityManagementGetInstanceRequest(OCIRequest):
    """
    Gets a Call Capacity Management group.
    The response is either ``GroupCallCapacityManagementGetInstanceResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupCallCenterAddSupervisorListRequest(OCIRequest):
    """
    Add supervisor(s) to a call center.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supervisor_user_id",
            "supervisorUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* supervisorUserId
    supervisor_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterAgentThresholdProfileAddAgentListRequest(OCIRequest):
    """
    Add agent(s) to a Agent Threshold Profile.
    When an agent is assigned (added )to a profile, it is automatically unassigned
    (deleted) from the previous profile it was assigned to.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile_name",
            "profileName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "agent_user_id",
            "agentUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* profileName
    profile_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* agentUserId
    agent_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterAgentThresholdProfileAddRequest(OCIRequest):
    """
    Add a new Call Center Agent Threshold Profile in a Group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile_name",
            "profileName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile_description",
            "profileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_in_time_yellow",
            "thresholdAverageBusyInTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_in_time_red",
            "thresholdAverageBusyInTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_out_time_yellow",
            "thresholdAverageBusyOutTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_out_time_red",
            "thresholdAverageBusyOutTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_wrap_up_time_yellow",
            "thresholdAverageWrapUpTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_wrap_up_time_red",
            "thresholdAverageWrapUpTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_notification_email",
            "enableNotificationEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "notification_email_address",
            "notificationEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "agent_user_id",
            "agentUserId",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* profileName
    profile_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* profileDescription
    profile_description = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeYellow
    threshold_current_call_state_idle_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeRed
    threshold_current_call_state_idle_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeYellow
    threshold_current_call_state_on_call_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeRed
    threshold_current_call_state_on_call_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeYellow
    threshold_current_agent_state_unavailable_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeRed
    threshold_current_agent_state_unavailable_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeYellow
    threshold_average_busy_in_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeRed
    threshold_average_busy_in_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyOutTimeYellow
    threshold_average_busy_out_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyOutTimeRed
    threshold_average_busy_out_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageWrapUpTimeYellow
    threshold_average_wrap_up_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageWrapUpTimeRed
    threshold_average_wrap_up_time_red = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* enableNotificationEmail
    enable_notification_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* notificationEmailAddress
    notification_email_address = Field(
        type=str,
        required=False,
    )
    #: list(str): *Optional* agentUserId  *Array*
    agent_user_id = Field(
        type=list,
        required=False,
    )


class GroupCallCenterAgentThresholdProfileDeleteAgentListRequest(OCIRequest):
    """
    Delete agent(s) from a Agent Threshold Profile.
    Agents cannot be unassigned (deleted) directly from the default profile, they
    need to be assigned (added) to a different profile.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile_name",
            "profileName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "agent_user_id",
            "agentUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* profileName
    profile_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* agentUserId
    agent_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterAgentThresholdProfileDeleteRequest(OCIRequest):
    """
    Deletes an existing Call Center Agent Threshold Profile in a Group.
    The default profile cannot be deleted.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile_name",
            "profileName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* profileName
    profile_name = Field(
        type=str,
        required=True,
    )


class GroupCallCenterAgentThresholdProfileGetListRequest(OCIRequest):
    """
    Get the list of Call Center Agent Threshold Profiles in the Group.
    The response is either ``GroupCallCenterAgentThresholdProfileGetListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterAgentThresholdProfileGetRequest(OCIRequest):
    """
    Gets an existing non-default Call Center Agent Threshold Profile in a Group.
    The response is either a ``GroupCallCenterAgentThresholdProfileGetResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile_name",
            "profileName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* profileName
    profile_name = Field(
        type=str,
        required=True,
    )


class GroupCallCenterAgentUnavailableCodeAddRequest(OCIRequest):
    """
    Add a Call Center Agent Unavailable Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class GroupCallCenterAgentUnavailableCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Agent Unavailable Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )


class GroupCallCenterAgentUnavailableCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Agent Unavailable Codes.
    The response is either ``GroupCallCenterAgentUnavailableCodeGetListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterAgentUnavailableCodeGetRequest(OCIRequest):
    """
    Get a Call Center Agent Unavailable Code.
    The response is either ``GroupCallCenterAgentUnavailableCodeGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )


class GroupCallCenterAgentUnavailableCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Agent Unavailable Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* isActive
    is_active = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class GroupCallCenterAgentUnavailableCodeSettingsGetRequest(OCIRequest):
    """
    Request the group level data associated with Call Center Agents Unavailable Code Settings.
    The response is either an ``GroupCallCenterAgentUnavailableCodeSettingsGetResponse()``
    or an
    ``ErrorResponse()``.

    Replaced by ``GroupCallCenterAgentUnavailableCodeSettingsGetRequest17sp4()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterAgentUnavailableCodeSettingsGetRequest17sp4(OCIRequest):
    """
    Request the group level data associated with Call Center Agents Unavailable Code Settings.
    The response is either a ``GroupCallCenterAgentUnavailableCodeSettingsGetResponse17sp4()``
    or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterBouncedCallGetRequest(OCIRequest):
    """
    Get a call center's bounced call settings.
    The response is either a ``GroupCallCenterBouncedCallGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced By ``GroupCallCenterBouncedCallGetRequest17()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterBouncedCallGetRequest17(OCIRequest):
    """
    Get a call center's bounced call settings.
    The response is either a ``GroupCallCenterBouncedCallGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterBouncedCallModifyRequest(OCIRequest):
    """
    Modify a call center's bounced call settings.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_of_rings_before_bouncing_call",
            "numberOfRingsBeforeBouncingCall",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_transfer",
            "enableTransfer",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "transfer_phone_number",
            "transferPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "bounce_call_when_agent_unavailable",
            "bounceCallWhenAgentUnavailable",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "alert_call_center_call_on_hold",
            "alertCallCenterCallOnHold",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "alert_call_center_call_on_hold_seconds",
            "alertCallCenterCallOnHoldSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "bounce_call_center_call_on_hold",
            "bounceCallCenterCallOnHold",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "bounce_call_center_call_on_hold_seconds",
            "bounceCallCenterCallOnHoldSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* isActive
    is_active = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* numberOfRingsBeforeBouncingCall
    number_of_rings_before_bouncing_call = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* enableTransfer
    enable_transfer = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* bounceCallWhenAgentUnavailable
    bounce_call_when_agent_unavailable = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* alertCallCenterCallOnHold
    alert_call_center_call_on_hold = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* alertCallCenterCallOnHoldSeconds
    alert_call_center_call_on_hold_seconds = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* bounceCallCenterCallOnHold
    bounce_call_center_call_on_hold = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* bounceCallCenterCallOnHoldSeconds
    bounce_call_center_call_on_hold_seconds = Field(
        type=int,
        required=False,
    )


class GroupCallCenterCallDispositionCodeAddRequest(OCIRequest):
    """
    Add a Call Center Call Disposition Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class GroupCallCenterCallDispositionCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Call Disposition Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )


class GroupCallCenterCallDispositionCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Call Disposition  Codes.
    The response is either ``GroupCallCenterCallDispositionCodeGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterCallDispositionCodeGetRequest(OCIRequest):
    """
    Get a Call Center Call Disposition Code.
    The response is either ``GroupCallCenterCallDispositionCodeGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )


class GroupCallCenterCallDispositionCodeGetUsageListRequest(OCIRequest):
    """
    Get the list of Call Centers and Route Points using the specified disposition code.
    The response is either ``GroupCallCenterCallDispositionCodeGetUsageListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )


class GroupCallCenterCallDispositionCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Call Disposition Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* isActive
    is_active = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class GroupCallCenterComfortMessageBypassGetRequest(OCIRequest):
    """
    Get a call center's comfort message bypass settings.
    The response is either a ``GroupCallCenterComfortMessageBypassGetResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterComfortMessageBypassGetRequest17(OCIRequest):
    """
    Get a call center's comfort message bypass settings.
    The response is either a ``GroupCallCenterComfortMessageBypassGetResponse17()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterComfortMessageBypassGetRequest20(OCIRequest):
    """
    Get a call center's comfort message bypass settings.
    The response is either a ``GroupCallCenterComfortMessageBypassGetResponse20()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterCurrentAndPastDNISGetListRequest(OCIRequest):
    """
    Request to get all the past and current DNIS for the Call Center for the group.
    The response is either ``GroupCallCenterCurrentAndPastDNISGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterDeleteAgentListRequest(OCIRequest):
    """
    Delete agent(s) from a call center.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "agent_user_id",
            "agentUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* agentUserId
    agent_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterDeleteInstanceRequest(OCIRequest):
    """
    Delete a Call Center instance from a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterDeleteSupervisorListRequest(OCIRequest):
    """
    Delete supervisor(s) from a call center.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supervisor_user_id",
            "supervisorUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* supervisorUserId
    supervisor_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterDistinctiveRingingGetRequest(OCIRequest):
    """
    Get the distinctive ringing configuration values for call center.
    The response is either a ``GroupCallCenterDistinctiveRingingGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterDistinctiveRingingModifyRequest(OCIRequest):
    """
    Modify the distinctive ringing configuration values for call center.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "distinctive_ringing_call_center_calls",
            "distinctiveRingingCallCenterCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "distinctive_ringing_ring_pattern_for_call_center",
            "distinctiveRingingRingPatternForCallCenter",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* distinctiveRingingCallCenterCalls
    distinctive_ringing_call_center_calls = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* distinctiveRingingRingPatternForCallCenter
    distinctive_ringing_ring_pattern_for_call_center = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* distinctiveRingingForceDeliveryRingPattern
    distinctive_ringing_force_delivery_ring_pattern = Field(
        type=str,
        required=False,
    )


class GroupCallCenterEnhancedGetRequest(OCIRequest):
    """
    Request to get the Call Center Enhanced configuration data for a
    Call Center.
    The response is either ``GroupCallCenterEnhancedGetResponse()`` or
    ``ErrorResponse()``.

    Replaced By ``GroupCallCenterGetInstanceResponse16()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterEnhancedModifyRequest(OCIRequest):
    """
    Modify the Call Center Enhanced configuration data for a Call
    Center.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Replaced By ``GroupCallCenterModifyInstanceRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_agent_wrap_up_time",
            "overrideAgentWrapUpTime",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "wrap_up_seconds",
            "wrapUpSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* overrideAgentWrapUpTime
    override_agent_wrap_up_time = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* wrapUpSeconds
    wrap_up_seconds = Field(
        type=int,
        required=False,
    )


class GroupCallCenterEnhancedReportingBrandingGetRequest(OCIRequest):
    """
    Request to get the group branding information.
    The response is either ``GroupCallCenterEnhancedReportingBrandingGetResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterEnhancedReportingGetAvailableReportTemplateListRequest(OCIRequest):
    """
    Request to get all enabled call center report template for a group.
    The response is either a ``GroupCallCenterEnhancedReportingGetAvailableReportTemplateListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterEnhancedReportingGetRequest(OCIRequest):
    """
    Request to get a group level call center enhanced reporting setting.
    The response is either a ``GroupCallCenterEnhancedReportingGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced by ``GroupCallCenterEnhancedReportingGetRequest19()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterEnhancedReportingGetRequest19(OCIRequest):
    """
    Request to get a group level call center enhanced reporting setting.
    The response is either a ``GroupCallCenterEnhancedReportingGetResponse19()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterEnhancedReportingModifyRequest(OCIRequest):
    """
    Request to modify group level call center enhanced reporting settings.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Replaced by ``GroupCallCenterEnhancedReportingModifyRequest19()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "reporting_server",
            "reportingServer",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "web_statistic_source",
            "webStatisticSource",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* reportingServer
    reporting_server = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* webStatisticSource
    web_statistic_source = Field(
        type=str,
        required=False,
    )


class GroupCallCenterEnhancedReportingModifyRequest19(OCIRequest):
    """
    Request to modify group level call center enhanced reporting settings.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "reporting_server",
            "reportingServer",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* reportingServer
    reporting_server = Field(
        type=str,
        required=False,
    )


class GroupCallCenterEnhancedReportingReportTemplateDeleteRequest(OCIRequest):
    """
    Request to delete a group level call center report template.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupCallCenterEnhancedReportingReportTemplateGetListRequest(OCIRequest):
    """
    Request to get group level call center report template list.
    The response is either a ``GroupCallCenterEnhancedReportingReportTemplateGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterEnhancedReportingReportTemplateGetRequest(OCIRequest):
    """
    Request to get a group level call center report template.
    The response is either a ``GroupCallCenterEnhancedReportingReportTemplateGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupCallCenterEnhancedReportingScheduledReportDeleteRequest(OCIRequest):
    """
    Request to delete a group level call center reporting scheduled report.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest(
    OCIRequest,
):
    """
    Request to get all the call center reporting scheduled report in a group that
    uses a given group level report template.
    The response is either a ``GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupCallCenterEnhancedReportingScheduledReportGetRequest(OCIRequest):
    """
    Request to get a group level call center reporting scheduled report.
    The response is either a ``GroupCallCenterEnhancedReportingScheduledReportGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupCallCenterForcedForwardingGetRequest(OCIRequest):
    """
    Get a call center's forced forwarding settings.
    The response is either a ``GroupCallCenterForcedForwardingGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterForcedForwardingGetRequest17(OCIRequest):
    """
    Get a call center's forced forwarding settings.
    The response is either a ``GroupCallCenterForcedForwardingGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterForcedForwardingGetRequest20(OCIRequest):
    """
    Get a call center's forced forwarding settings.
    The response is either a ``GroupCallCenterForcedForwardingGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetAnnouncementRequest(OCIRequest):
    """
    Get a call center's announcement settings.
    The response is either a ``GroupCallCenterGetAnnouncementResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetAnnouncementRequest14sp6(OCIRequest):
    """
    Get a call center's announcement settings.
    The response is either a ``GroupCallCenterGetAnnouncementResponse14sp6()`` or an
    ``ErrorResponse()``.

    Replaced By ``GroupCallCenterGetAnnouncementRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetAnnouncementRequest16(OCIRequest):
    """
    Get a call center's announcement settings.
    The response is either a ``GroupCallCenterGetAnnouncementResponse16()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetAnnouncementRequest17(OCIRequest):
    """
    Get a call center's announcement settings.
    The response is either a ``GroupCallCenterGetAnnouncementResponse17()`` or an
    ``ErrorResponse()``.

    Replaced by ``GroupCallCenterGetAnnouncementRequest17sp4()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetAnnouncementRequest17sp4(OCIRequest):
    """
    Get a call center's announcement settings.
    The response is either a ``GroupCallCenterGetAnnouncementResponse17sp4()`` or an
    ``ErrorResponse()``.

    Replaced By ``GroupCallCenterGetAnnouncementRequest19()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetAnnouncementRequest19(OCIRequest):
    """
    Get a call center's announcement settings.
    The response is either a ``GroupCallCenterGetAnnouncementResponse19()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetAnnouncementRequest20(OCIRequest):
    """
    Get a call center's announcement settings.
    The response is either a ``GroupCallCenterGetAnnouncementResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetDNISListRequest(OCIRequest):
    """
    Get a list of DNIS that are configured for a Call Center.
    The response is either ``GroupCallCenterGetDNISListResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetDistinctiveRingingRequest(OCIRequest):
    """
    Get the distinctive ringing configuration values for call center.
    The response is either a ``GroupCallCenterGetDistinctiveRingingResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetInstanceListRequest(OCIRequest):
    """
    Get a list of Call Center instances within a group.
    The response is either ``GroupCallCenterGetInstanceListResponse()`` or
    ``ErrorResponse()``.
    It is possible to get the instances within a specified department.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_department_name",
            "groupDepartmentName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(
        type=str,
        required=False,
    )


class GroupCallCenterGetInstanceQueueStatusRequest(OCIRequest):
    """
    Get Call Center queue status.
    The response is either ``GroupCallCenterGetInstanceQueueStatusResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetInstanceRequest14(OCIRequest):
    """
    Request to get all the information of a Call Center instance.
    The response is either ``GroupCallCenterGetInstanceResponse14()`` or ``ErrorResponse()``.
    Replaced By ``GroupCallCenterGetInstanceRequest14sp3()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetInstanceRequest14sp3(OCIRequest):
    """
    Request to get all the information of a Call Center instance.
    The response is either ``GroupCallCenterGetInstanceResponse14sp3()`` or
    ``ErrorResponse()``.
    Replaced By ``GroupCallCenterGetInstanceRequest14sp9()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetInstanceRequest14sp9(OCIRequest):
    """
    Request to get all the information of a Call Center instance.
    The response is either ``GroupCallCenterGetInstanceResponse14sp9()`` or
    ``ErrorResponse()``.

    Replaced By ``GroupCallCenterGetInstanceRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetInstanceRequest16(OCIRequest):
    """
    Request to get all the information of a Call Center instance.
    The response is either ``GroupCallCenterGetInstanceResponse16()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of a Call Center instance.
    The response is either ``GroupCallCenterGetInstanceResponse17()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetInstanceRequest17sp1(OCIRequest):
    """
    Request to get all the information of a Call Center instance.
    The response is either ``GroupCallCenterGetInstanceResponse17sp1()`` or
    ``ErrorResponse()``.

    Replaced By ``GroupCallCenterGetInstanceRequest17sp3()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetInstanceRequest17sp3(OCIRequest):
    """
    Request to get all the information of a Call Center instance.
    The response is either ``GroupCallCenterGetInstanceResponse17sp3()`` or
    ``ErrorResponse()``.

    Replaced by ``GroupCallCenterGetInstanceRequest19()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetInstanceRequest19(OCIRequest):
    """
    Request to get all the information of a Call Center instance.
    The response is either ``GroupCallCenterGetInstanceResponse19()`` or ``ErrorResponse()``.

    Replaced By ``GroupCallCenterGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Call Center instance.
    The response is either ``GroupCallCenterGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetInstanceStatisticsReportingRequest(OCIRequest):
    """
    Request to get the call center statistics reporting settings.
    The response is either ``GroupCallCenterGetInstanceStatisticsReportingResponse()``
    or ``ErrorResponse()``.

    Replaced By ``GroupCallCenterGetInstanceStatisticsReportingRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetInstanceStatisticsReportingRequest16(OCIRequest):
    """
    Request to get the call center statistics reporting settings.
    The response is either ``GroupCallCenterGetInstanceStatisticsReportingResponse16()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetInstanceStatisticsReportingRequest17sp1(OCIRequest):
    """
    Request to get the call center statistics reporting settings.
    The response is either ``GroupCallCenterGetInstanceStatisticsReportingResponse17sp1()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetInstanceStatisticsRequest13mp8(OCIRequest):
    """
    Get Call Center queue and agent statistics.
    The response is either ``GroupCallCenterGetInstanceStatisticsResponse13mp8()`` or
    ``ErrorResponse()``.
    Replaced By ``GroupCallCenterGetInstanceStatisticsRequest14sp9()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetRequest(OCIRequest):
    """
    Request the Group level data associated with Call Center.
    The response is either a ``GroupCallCenterGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced by ``GroupCallCenterGetRequest17sp4()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetRequest17sp4(OCIRequest):
    """
    Request the Group level data associated with Call Center.
    The response is either a ``GroupCallCenterGetResponse17sp4()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetRoutingPolicyRequest(OCIRequest):
    """
    Request the group call center routing policy.
    The response is either a ``GroupCallCenterGetRoutingPolicyResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetSupervisorListRequest(OCIRequest):
    """
    Get a list of supervisors assigned to a call center.
    Only users in the same group or enterprise as this call center can
    successfully execute this request.
    The response is either a ``GroupCallCenterGetSupervisorListResponse()``
    or an ``ErrorResponse()``.
    Replaced By ``GroupCallCenterSupervisorReportingGetRequest()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetSupervisorListRequest16(OCIRequest):
    """
    Get a list of supervisors assigned to a call center.
    The response is either a
    ``GroupCallCenterGetSupervisorListResponse16()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetUnlicensedAgentListRequest(OCIRequest):
    """
    Get a list of unlicensed users who are preventing the Call Center from upgrading
    to another type.
    The response is either ``GroupCallCenterGetUnlicensedAgentListRequest()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_center_type",
            "callCenterType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callCenterType
    call_center_type = Field(
        type=str,
        required=True,
    )


class GroupCallCenterHolidayServiceGetRequest(OCIRequest):
    """
    Get a call center's holiday service settings.
    The response is either a ``GroupCallCenterHolidayServiceGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterHolidayServiceGetRequest17(OCIRequest):
    """
    Get a call center's holiday service settings.
    The response is either a ``GroupCallCenterHolidayServiceGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterHolidayServiceGetRequest17sp1(OCIRequest):
    """
    Get a call center's holiday service settings.
    The response is either a ``GroupCallCenterHolidayServiceGetResponse17sp1()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterHolidayServiceGetRequest20(OCIRequest):
    """
    Get a call center's holiday service settings.
    The response is either a ``GroupCallCenterHolidayServiceGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterModifyDNISParametersRequest(OCIRequest):
    """
    Modify the setting that are configured for all the DNIS in a Call Center.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "display_dnis_number",
            "displayDNISNumber",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "display_dnis_name",
            "displayDNISName",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "promote_calls_from_priority1to0",
            "promoteCallsFromPriority1to0",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "promote_calls_from_priority2to1",
            "promoteCallsFromPriority2to1",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "promote_calls_from_priority3to2",
            "promoteCallsFromPriority3to2",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "promote_calls_from_priority1to0_seconds",
            "promoteCallsFromPriority1to0Seconds",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "promote_calls_from_priority2to1_seconds",
            "promoteCallsFromPriority2to1Seconds",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "promote_calls_from_priority3to2_seconds",
            "promoteCallsFromPriority3to2Seconds",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* displayDNISNumber
    display_dnis_number = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* displayDNISName
    display_dnis_name = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* promoteCallsFromPriority1to0
    promote_calls_from_priority1to0 = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* promoteCallsFromPriority2to1
    promote_calls_from_priority2to1 = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* promoteCallsFromPriority3to2
    promote_calls_from_priority3to2 = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* promoteCallsFromPriority1to0Seconds
    promote_calls_from_priority1to0_seconds = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* promoteCallsFromPriority2to1Seconds
    promote_calls_from_priority2to1_seconds = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* promoteCallsFromPriority3to2Seconds
    promote_calls_from_priority3to2_seconds = Field(
        type=int,
        required=False,
    )


class GroupCallCenterModifyDistinctiveRingingRequest(OCIRequest):
    """
    Modify the distinctive ringing configuration values for call center.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "distinctive_ringing_call_center_calls",
            "distinctiveRingingCallCenterCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "distinctive_ringing_ring_pattern_for_call_center",
            "distinctiveRingingRingPatternForCallCenter",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* distinctiveRingingCallCenterCalls
    distinctive_ringing_call_center_calls = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* distinctiveRingingRingPatternForCallCenter
    distinctive_ringing_ring_pattern_for_call_center = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* distinctiveRingingForceDeliveryRingPattern
    distinctive_ringing_force_delivery_ring_pattern = Field(
        type=str,
        required=False,
    )


class GroupCallCenterModifyInstanceStatisticsReportingRequest(OCIRequest):
    """
    Modify the Call Center statistics reporting frequency and destination.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    Replaced By ``GroupCallCenterModifyInstanceStatisticsReportingRequest14sp9()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "clear_today_statistics",
            "clearTodayStatistics",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "generate_daily_report",
            "generateDailyReport",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "collection_period_minutes",
            "collectionPeriodMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "reporting_email_address1",
            "reportingEmailAddress1",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "reporting_email_address2",
            "reportingEmailAddress2",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* clearTodayStatistics
    clear_today_statistics = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* generateDailyReport
    generate_daily_report = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* collectionPeriodMinutes
    collection_period_minutes = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* reportingEmailAddress1
    reporting_email_address1 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* reportingEmailAddress2
    reporting_email_address2 = Field(
        type=str,
        required=False,
    )


class GroupCallCenterModifyInstanceStatisticsReportingRequest14sp9(OCIRequest):
    """
    Modify the Call Center statistics reporting frequency and destination.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "generate_daily_report",
            "generateDailyReport",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "collection_period_minutes",
            "collectionPeriodMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "reporting_email_address1",
            "reportingEmailAddress1",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "reporting_email_address2",
            "reportingEmailAddress2",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "statistics_source",
            "statisticsSource",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* generateDailyReport
    generate_daily_report = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* collectionPeriodMinutes
    collection_period_minutes = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* reportingEmailAddress1
    reporting_email_address1 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* reportingEmailAddress2
    reporting_email_address2 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* statisticsSource
    statistics_source = Field(
        type=str,
        required=False,
    )


class GroupCallCenterModifyInstanceStatisticsReportingRequest17sp1(OCIRequest):
    """
    Modify the Call Center statistics reporting frequency and destination.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "generate_daily_report",
            "generateDailyReport",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "collection_period_minutes",
            "collectionPeriodMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "reporting_email_address1",
            "reportingEmailAddress1",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "reporting_email_address2",
            "reportingEmailAddress2",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "statistics_source",
            "statisticsSource",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* generateDailyReport
    generate_daily_report = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* collectionPeriodMinutes
    collection_period_minutes = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* reportingEmailAddress1
    reporting_email_address1 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* reportingEmailAddress2
    reporting_email_address2 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* statisticsSource
    statistics_source = Field(
        type=str,
        required=False,
    )


class GroupCallCenterModifyRequest(OCIRequest):
    """
    Modify the group level data associated with Call Center and
    the active status of Call Center instances.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_system_default_guard_timer",
            "useSystemDefaultGuardTimer",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_guard_timer",
            "enableGuardTimer",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "guard_timer_seconds",
            "guardTimerSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* useSystemDefaultGuardTimer
    use_system_default_guard_timer = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableGuardTimer
    enable_guard_timer = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* guardTimerSeconds
    guard_timer_seconds = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useSystemDefaultUnavailableSettings
    use_system_default_unavailable_settings = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnNotReachable
    force_agent_unavailable_on_not_reachable = Field(
        type=bool,
        required=False,
    )


class GroupCallCenterNightServiceGetRequest(OCIRequest):
    """
    Get a call center's night service settings.
    The response is either a ``GroupCallCenterNightServiceGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterNightServiceGetRequest17(OCIRequest):
    """
    Get a call center's night service settings.
    The response is either a ``GroupCallCenterNightServiceGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterNightServiceGetRequest17sp1(OCIRequest):
    """
    Get a call center's night service settings.
    The response is either a ``GroupCallCenterNightServiceGetResponse17sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterNightServiceGetRequest20(OCIRequest):
    """
    Get a call center's night service settings.
    The response is either a ``GroupCallCenterNightServiceGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterOverflowGetRequest(OCIRequest):
    """
    Get a call center's overflow settings.
    The response is either a ``GroupCallCenterOverflowGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterOverflowGetRequest17(OCIRequest):
    """
    Get a call center's overflow settings.
    The response is either a ``GroupCallCenterOverflowGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterOverflowGetRequest20(OCIRequest):
    """
    Get a call center's overflow settings.
    The response is either a ``GroupCallCenterOverflowGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterQueueCallDispositionCodeAddRequest(OCIRequest):
    """
    Add a Call Center Call Disposition Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class GroupCallCenterQueueCallDispositionCodeDeleteRequest(OCIRequest):
    """
    Delete a Call Center Call Disposition Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )


class GroupCallCenterQueueCallDispositionCodeGetListRequest(OCIRequest):
    """
    Get the list of Call Center Level and Organization Level Call Disposition Codes.
    The response is either ``GroupCallCenterQueueCallDispositionCodeGetListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterQueueCallDispositionCodeGetRequest(OCIRequest):
    """
    Get a Call Center Call Disposition Code.
    The response is either ``GroupCallCenterQueueCallDispositionCodeGetResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )


class GroupCallCenterQueueCallDispositionCodeModifyRequest(OCIRequest):
    """
    Modify a Call Center Call Disposition Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* isActive
    is_active = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class GroupCallCenterQueueCallDispositionCodeSettingsGetRequest(OCIRequest):
    """
    Request the user level data associated with Call Center Call Disposition Code Settings.
    The response is either a ``GroupCallCenterQueueCallDispositionCodeSettingsGetResponse()``
    or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterQueueStatusNotificationGetRequest(OCIRequest):
    """
    Get the status configuration for a given call center.
    The response is either a ``GroupCallCenterQueueStatusNotificationGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterQueueStatusNotificationModifyRequest(OCIRequest):
    """
    Set the status configuration for a given call center.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_queue_status_notification",
            "enableQueueStatusNotification",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_queue_depth_threshold",
            "enableQueueDepthThreshold",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_waiting_time_threshold",
            "enableWaitingTimeThreshold",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_of_calls_threshold",
            "numberOfCallsThreshold",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "waiting_time_of_calls_threshold",
            "waitingTimeOfCallsThreshold",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* enableQueueStatusNotification
    enable_queue_status_notification = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableQueueDepthThreshold
    enable_queue_depth_threshold = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableWaitingTimeThreshold
    enable_waiting_time_threshold = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* numberOfCallsThreshold
    number_of_calls_threshold = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* waitingTimeOfCallsThreshold
    waiting_time_of_calls_threshold = Field(
        type=int,
        required=False,
    )


class GroupCallCenterQueueThresholdsGetRequest(OCIRequest):
    """
    Get a call center's queue Thresholds settings.
    The response is either a ``GroupCallCenterQueueThresholdsGetRequest()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterStrandedCallGetRequest(OCIRequest):
    """
    Get a call center's stranded call settings.
    The response is either a ``GroupCallCenterStrandedCallGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterStrandedCallGetRequest17(OCIRequest):
    """
    Get a call center's stranded call settings.
    The response is either a ``GroupCallCenterStrandedCallGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterStrandedCallGetRequest20(OCIRequest):
    """
    Get a call center's stranded call settings.
    The response is either a ``GroupCallCenterStrandedCallGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterStrandedCallUnavailableGetRequest(OCIRequest):
    """
    Get a call center's stranded calls - unavailable settings.
    The response is either a ``GroupCallCenterStrandedCallUnavailableGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterStrandedCallUnavailableGetRequest20(OCIRequest):
    """
    Get a call center's stranded calls - unavailable settings.
    The response is either a ``GroupCallCenterStrandedCallUnavailableGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallCenterSupervisorReportingGetRequest(OCIRequest):
    """
    Get a list of supervisors assigned to a call center.
    Only users in the same group or enterprise as this call center
    can successfully execute this request.
    The response is either a
    ``GroupCallCenterSupervisorReportingGetResponse()`` or an
    ``ErrorResponse()``.

    Replaced By ``GroupCallCenterGetSupervisorListRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCallParkAddInstanceRequest(OCIRequest):
    """
    Adds a Call Park group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* userId  *Array*
    user_id = Field(
        type=list,
        required=False,
    )


class GroupCallParkAddInstanceRequest16sp2(OCIRequest):
    """
    Adds a Call Park group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    The following elements are only used in AS data mode:
    recallAlternateUserId
    recallTo, use value "Parking User Only" in HSS data mode
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "recall_alternate_user_id",
            "recallAlternateUserId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "recall_to",
            "recallTo",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* userId  *Array*
    user_id = Field(
        type=list,
        required=False,
    )
    #: str: *Optional* recallAlternateUserId
    recall_alternate_user_id = Field(
        type=str,
        required=False,
    )
    #: str: *Required* recallTo
    recall_to = Field(
        type=str,
        required=True,
    )


class GroupCallParkDeleteInstanceRequest(OCIRequest):
    """
    Deletes a Call Park group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupCallParkGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Call Park group instances within a group.
    The response is either ``GroupCallParkGetInstanceListResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallParkGetInstanceRequest(OCIRequest):
    """
    Gets a Call Park group.
    The response is either ``GroupCallParkGetInstanceResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupCallParkGetInstanceRequest16sp2(OCIRequest):
    """
    Gets a Call Park group.
    The response is either ``GroupCallParkGetInstanceResponse16sp2()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupCallParkGetRequest(OCIRequest):
    """
    Gets the Call Park Group settings.
    The response is either ``GroupCallParkGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallParkGetRequest16sp2(OCIRequest):
    """
    Gets the Call Park Group settings.
    The response is either ``GroupCallParkGetResponse16sp2()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallParkModifyRequest(OCIRequest):
    """
    Modifies the Group's Call Park settings.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    The following elements are only used in AS data mode:
    recallAlternateUserId
    recallRingPattern
    recallTo
    alternateUserRecallTimerSeconds
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "recall_timer_seconds",
            "recallTimerSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "display_timer_seconds",
            "displayTimerSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_destination_announcement",
            "enableDestinationAnnouncement",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "recall_alternate_user_id",
            "recallAlternateUserId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "recall_ring_pattern",
            "recallRingPattern",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "recall_to",
            "recallTo",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "alternate_user_recall_timer_seconds",
            "alternateUserRecallTimerSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* recallTimerSeconds
    recall_timer_seconds = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* displayTimerSeconds
    display_timer_seconds = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* enableDestinationAnnouncement
    enable_destination_announcement = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* recallAlternateUserId
    recall_alternate_user_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* recallRingPattern
    recall_ring_pattern = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* recallTo
    recall_to = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* alternateUserRecallTimerSeconds
    alternate_user_recall_timer_seconds = Field(
        type=int,
        required=False,
    )


class GroupCallPickupAddInstanceRequest(OCIRequest):
    """
    Adds a Call Pickup group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* userId  *Array*
    user_id = Field(
        type=list,
        required=False,
    )


class GroupCallPickupDeleteInstanceRequest(OCIRequest):
    """
    Deletes a Call Pickup group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupCallPickupGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Call Pickup instances within a group.
    The response is either ``GroupCallPickupGetInstanceListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallPickupGetInstanceRequest(OCIRequest):
    """
    Gets a Call Pickup group.
    The response is either ``GroupCallPickupGetInstanceResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupCallProcessingGetPolicyRequest14(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.
    The response is either a ``GroupCallProcessingGetPolicyResponse14()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallProcessingGetPolicyRequest14sp1(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.
    The response is either a ``GroupCallProcessingGetPolicyResponse14sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallProcessingGetPolicyRequest14sp4(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.
    The response is either a ``GroupCallProcessingGetPolicyResponse14sp4()`` or an
    ``ErrorResponse()``.
    Replaced By : ``GroupCallProcessingGetPolicyRequest15()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallProcessingGetPolicyRequest14sp7(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.
    The response is either a ``GroupCallProcessingGetPolicyResponse14sp7()`` or an
    ``ErrorResponse()``.

    The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName)

    The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName)

    The useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations)

    The useGroupTranslationRoutingSetting attribute controls the routing and
    translation settings
    (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    Replaced By ``GroupCallProcessingGetPolicyRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallProcessingGetPolicyRequest15(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.
    The response is either a ``GroupCallProcessingGetPolicyResponse15()`` or an
    ``ErrorResponse()``.
    Replaced By ``GroupCallProcessingGetPolicyRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallProcessingGetPolicyRequest15sp2(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.
    The response is either a ``GroupCallProcessingGetPolicyResponse15sp2()`` or an
    ``ErrorResponse()``.

    The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName)

    The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName)

    The useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls, useMaxCallTimeForAnsweredCalls,
    maxCallTimeForAnsweredCallsMinutes, useMaxCallTimeForUnansweredCalls,
    maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations)

    The useGroupTranslationRoutingSetting attribute controls the routing and
    translation settings
    (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallProcessingGetPolicyRequest16(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.
    The response is either a ``GroupCallProcessingGetPolicyResponse16()`` or an
    ``ErrorResponse()``.

    The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName)

    The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName)

    The useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations)

    The useGroupTranslationRoutingSetting attribute controls the routing and
    translation settings
    (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallProcessingGetPolicyRequest16sp2(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.
    The response is either a ``GroupCallProcessingGetPolicyResponse16sp2()`` or an
    ``ErrorResponse()``.

    The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName)

    The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName)

    The useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations)

    The useGroupTranslationRoutingSetting attribute controls the routing and
    translation settings
    (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    The useGroupDCLIDSetting controls the Dialable Caller ID settings (enableDialableCallerID)
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallProcessingGetPolicyRequest17(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.
    The response is either a ``GroupCallProcessingGetPolicyResponse17()`` or an
    ``ErrorResponse()``.

    The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName)

    The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName)

    The useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations)

    The useGroupTranslationRoutingSetting attribute controls the routing and
    translation settings
    (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallProcessingGetPolicyRequest17sp3(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.
    The response is either a ``GroupCallProcessingGetPolicyResponse17sp3()`` or an
    ``ErrorResponse()``.

    The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName)

    The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName)

    The useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations)

    The useGroupTranslationRoutingSetting attribute controls the routing and
    translation settings
    (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    The useGroupDCLIDSetting controls the Dialable Caller ID settings (enableDialableCallerID)

    The following elements are only used in AS data mode:
    useGroupDCLIDSetting
    enableDialableCallerID

    Replaced by ``GroupCallProcessingGetPolicyRequest17sp4()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallProcessingGetPolicyRequest17sp4(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.
    The response is either a ``GroupCallProcessingGetPolicyResponse17sp4()`` or an
    ``ErrorResponse()``.

    The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName, allowConfigurableCLIDForRedirectingIdentity)

    The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName)

    The useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations)

    The useGroupTranslationRoutingSetting attribute controls the routing and
    translation settings
    (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    The following elements are only used in AS data mode:
    useGroupDCLIDSetting
    enableDialableCallerID

    Replaced by ``GroupCallProcessingGetPolicyRequest18()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallProcessingGetPolicyRequest18(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.
    The response is either a ``GroupCallProcessingGetPolicyResponse18()`` or an
    ``ErrorResponse()``.

    The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName, allowDepartmentCLIDNameOverride)

    The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName)

    The useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations)

    The useGroupTranslationRoutingSetting attribute controls the routing and
    translation settings
    (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    The following elements are only used in AS data mode:
    useGroupDCLIDSetting
    enableDialableCallerID
    allowDepartmentCLIDNameOverride

    Replaced By : ``GroupCallProcessingGetPolicyRequest18sp1()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallProcessingGetPolicyRequest18sp1(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.
    The response is either a ``GroupCallProcessingGetPolicyResponse18sp1()`` or an
    ``ErrorResponse()``.

    The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy, emergencyClidPolicy,
    allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowDepartmentCLIDNameOverride)

    The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName)

    The useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations)

    The useGroupTranslationRoutingSetting attribute controls the routing and
    translation settings
    (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    The following elements are only used in AS data mode:
    useGroupDCLIDSetting
    enableDialableCallerID
    allowDepartmentCLIDNameOverride
    enterpriseCallsCLIDPolicy
    groupCallsCLIDPolicy

    Replaced By ``GroupCallProcessingGetPolicyRequest19sp1()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallProcessingGetPolicyRequest19sp1(OCIRequest):
    """
    Request the group level data associated with Call Processing Policy.
    The response is either a ``GroupCallProcessingGetPolicyResponse19sp1()`` or an
    ``ErrorResponse()``.

    The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy, emergencyClidPolicy,
    allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowDepartmentCLIDNameOverride)

    The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName)

    The useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls,
    useMaxSimultaneousVideoCalls, maxSimultaneousVideoCalls,
    useMaxCallTimeForAnsweredCalls, maxCallTimeForAnsweredCallsMinutes,
    useMaxCallTimeForUnansweredCalls, maxCallTimeForUnansweredCallsMinutes,
    useMaxConcurrentRedirectedCalls, useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations)

    The useGroupTranslationRoutingSetting attribute controls the routing and
    translation settings
    (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    The following elements are only used in AS data mode:
    useGroupDCLIDSetting
    enableDialableCallerID
    allowDepartmentCLIDNameOverride
    enterpriseCallsCLIDPolicy
    groupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallProcessingModifyPolicyRequest14(OCIRequest):
    """
    Modify the group level data associated with Call Procesing Policy.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    Replaced By : ``GroupCallProcessingModifyPolicyRequest15()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_setting",
            "useGroupSetting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* useGroupSetting
    use_group_setting = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=False,
    )


class GroupCallProcessingModifyPolicyRequest14sp7(OCIRequest):
    """
    Modify the group level data associated with Call Procesing Policy.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy, emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity,
    useGroupName)

    The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName)

    The useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls, useMaxSimultaneousVideoCalls,
    maxSimultaneousVideoCalls, useMaxCallTimeForAnsweredCalls,
    maxCallTimeForAnsweredCallsMinutes, useMaxCallTimeForUnansweredCalls,
    maxCallTimeForUnansweredCallsMinutes, useMaxConcurrentRedirectedCalls,
    useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations)

    The useGroupTranslationRoutingSetting attribute controls the routing and
    translation settings (networkUsageSelection, enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    Replaced By ``GroupCallProcessingModifyPolicyRequest15sp2()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_clid_setting",
            "useGroupCLIDSetting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_group_media_setting",
            "useGroupMediaSetting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_group_call_limits_setting",
            "useGroupCallLimitsSetting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_group_translation_routing_setting",
            "useGroupTranslationRoutingSetting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_group_name",
            "useGroupName",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* useGroupCLIDSetting
    use_group_clid_setting = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useGroupMediaSetting
    use_group_media_setting = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* clidPolicy
    clid_policy = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useGroupName
    use_group_name = Field(
        type=bool,
        required=False,
    )


class GroupCallProcessingModifyPolicyRequest15(OCIRequest):
    """
    Modify the group level data associated with Call Procesing Policy.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    Replaced By ``GroupCallProcessingModifyPolicyRequest15sp2()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_setting",
            "useGroupSetting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* useGroupSetting
    use_group_setting = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=False,
    )


class GroupCallProcessingModifyPolicyRequest15sp2(OCIRequest):
    """
    Modify the group level data associated with Call Procesing Policy.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    The useGroupCLIDSetting attribute controls the CLID settings
    (clidPolicy,enterpriseCallsCLIDPolicy, groupCallsCLIDPolicy,
    emergencyClidPolicy, allowAlternateNumbersForRedirectingIdentity, useGroupName,
    allowConfigurableCLIDForRedirectingIdentity, allowDepartmentCLIDNameOverride)

    The allowDepartmentCLID attribute is automatically set to false when the
    useGroupName attribute is set to false.

    The useGroupMediaSetting attribute controls the Media settings
    (medisPolicySelection, supportedMediaSetName)

    The useGroupCallLimitsSetting attribute controls the Call Limits settings
    (useMaxSimultaneousCalls, maxSimultaneousCalls, useMaxSimultaneousVideoCalls,
    maxSimultaneousVideoCalls, useMaxCallTimeForAnsweredCalls,
    maxCallTimeForAnsweredCallsMinutes, useMaxCallTimeForUnansweredCalls,
    maxCallTimeForUnansweredCallsMinutes, useMaxConcurrentRedirectedCalls,
    useMaxFindMeFollowMeDepth, maxRedirectionDepth,
    useMaxConcurrentFindMeFollowMeInvocations, maxConcurrentFindMeFollowMeInvocations)

    The useGroupTranslationRoutingSetting attribute controls the routing and
    translation settings (networkUsageSelection,
    enforceGroupCallingLineIdentityRestriction,
    allowEnterpriseGroupCallTypingForPrivateDialingPlan,
    allowEnterpriseGroupCallTypingForPublicDialingPlan,
    overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan,
    enableEnterpriseExtensionDialing)

    The useGroupDCLIDSetting controls the Dialable Caller ID settings (enableDialableCallerID)

    The following elements are only used in AS data mode:
    useGroupDCLIDSetting
    enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride
    allowConfigurableCLIDForRedirectingIdentity
    enterpriseCallsCLIDPolicy
    groupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_clid_setting",
            "useGroupCLIDSetting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_group_media_setting",
            "useGroupMediaSetting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_group_call_limits_setting",
            "useGroupCallLimitsSetting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_group_translation_routing_setting",
            "useGroupTranslationRoutingSetting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_group_dclid_setting",
            "useGroupDCLIDSetting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_group_name",
            "useGroupName",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "block_calling_name_for_external_calls",
            "blockCallingNameForExternalCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_dialable_caller_id",
            "enableDialableCallerID",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_department_clid_name_override",
            "allowDepartmentCLIDNameOverride",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enterprise_calls_clid_policy",
            "enterpriseCallsCLIDPolicy",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "group_calls_clid_policy",
            "groupCallsCLIDPolicy",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* useGroupCLIDSetting
    use_group_clid_setting = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useGroupMediaSetting
    use_group_media_setting = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useGroupDCLIDSetting
    use_group_dclid_setting = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* clidPolicy
    clid_policy = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useGroupName
    use_group_name = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableDialableCallerID
    enable_dialable_caller_id = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* groupCallsCLIDPolicy
    group_calls_clid_policy = Field(
        type=str,
        required=False,
    )


class GroupCallRecordingGetRequest(OCIRequest):
    """
    Get the Call Recording platform for a group.
    The response is either a ``GroupCallRecordingGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallRecordingModifyRequest(OCIRequest):
    """
    Modify the Call Recording platform assignment for a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* name
    name = Field(
        type=str,
        required=False,
    )


class GroupCallingLineIdGetRequest(OCIRequest):
    """
    Get the calling line id settings for a group.
    The response is either a ``GroupCallingLineIdGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallingLineIdModifyRequest(OCIRequest):
    """
    Modify the calling line id settings for a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_number",
            "useGroupNumber",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_group_name",
            "useGroupName",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_phone_number",
            "callingLineIdPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* useGroupNumber
    use_group_number = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useGroupName
    use_group_name = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(
        type=str,
        required=False,
    )


class GroupCallingPlanAddDigitPatternRequest(OCIRequest):
    """
    Add a new calling plan digit string.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern",
            "digitPattern",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* digitPattern
    digit_pattern = Field(
        type=str,
        required=True,
    )


class GroupCallingPlanDeleteDigitPatternListRequest(OCIRequest):
    """
    Delete one or more calling plan digit strings.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupCallingPlanGetDigitPatternListRequest(OCIRequest):
    """
    Get the list of calling plan digit strings for a group.
    The response is either a ``GroupCallingPlanGetDigitPatternListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCallingPlanModifyDigitPatternRequest(OCIRequest):
    """
    Modify a calling plan digit string. The name is a key; it cannot be changed.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern",
            "digitPattern",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* digitPattern
    digit_pattern = Field(
        type=str,
        required=False,
    )


class GroupCollaborateBridgeDeleteInstanceRequest(OCIRequest):
    """
    Delete a collaborate bridge from a group.
    The request fails when attempting to delete the default collaborate bridge.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCollaborateBridgeGetInstanceListRequest(OCIRequest):
    """
    Get a list of collaborate bridges within a group.
    The response is either ``GroupCollaborateBridgeGetInstanceListResponse()`` or
    ``ErrorResponse()``.
    It is possible to get the instances within a specified department.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* departmentName
    department_name = Field(
        type=str,
        required=False,
    )


class GroupCollaborateBridgeGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a collaborate bridge.
    The response is either ``GroupCollaborateBridgeGetInstanceResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupCommPilotCallManagerGetRequest(OCIRequest):
    """
    Request the group level data associated with CommPilot Call Manager.
    The response is either a ``GroupCommPilotCallManagerGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCommPilotCallManagerModifyRequest(OCIRequest):
    """
    Modify the group level data associated with CommPilot Call Manager.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_directory",
            "groupDirectory",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* groupDirectory
    group_directory = Field(
        type=str,
        required=False,
    )


class GroupCommonPhoneListDeleteListRequest(OCIRequest):
    """
    Delete one or more entries from a group's common phone list.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "entry_name",
            "entryName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* entryName
    entry_name = Field(
        type=str,
        required=True,
    )


class GroupCommonPhoneListModifyRequest(OCIRequest):
    """
    Modify an entry in a group's common phone list.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "entry_name",
            "entryName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "new_entry_name",
            "newEntryName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* entryName
    entry_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* newEntryName
    new_entry_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )


class GroupCommunicationBarringAuthorizationCodeDeleteListRequest(OCIRequest):
    """
    Delete a list of Communication Barring Authorization codes from a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )


class GroupCommunicationBarringAuthorizationCodeGetListRequest(OCIRequest):
    """
    Get a list of Communication Barring Authorization Codes for a group.
    The response is either a ``GroupCommunicationBarringAuthorizationCodeGetListResponse()``
    or an ``ErorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCommunicationBarringGetRequest(OCIRequest):
    """
    Gets Communication Barring setting for a group.
    The response is either a ``GroupCommunicationBarringGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCommunicationBarringModifyRequest(OCIRequest):
    """
    Gets Communication Barring setting for a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_default_service_provider_profile",
            "useDefaultServiceProviderProfile",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "profile",
            "profile",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* useDefaultServiceProviderProfile
    use_default_service_provider_profile = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* profile
    profile = Field(
        type=str,
        required=False,
    )


class GroupCommunicationBarringProfileGetAssignedListRequest(OCIRequest):
    """
    Get the list of all communication barring profiles assigned to the group. The
    response is either a
    ``GroupCommunicationBarringProfileGetAssignedListResponse()`` or an ``ErrorResponse()``.
    This command only applies to groups in an Enterprise. This command will fail for
    groups in a Service Provider.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCustomContactDirectoryAddRequest(OCIRequest):
    """
    Adds a Custom Contact Directory to a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Replace by: ``GroupCustomContactDirectoryAddRequest17()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* userId
    user_id = Field(
        type=str,
        required=False,
    )


class GroupCustomContactDirectoryDeleteRequest(OCIRequest):
    """
    Deletes a Custom Contact Directory to a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupCustomContactDirectoryGetListRequest(OCIRequest):
    """
    Gets the list of Custom Contact Directories for a group.
    The response is either ``GroupCustomContactDirectoryGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCustomContactDirectoryGetRequest(OCIRequest):
    """
    Gets a Custom Contact Directory in a group.
    The response is either ``GroupCustomContactDirectoryGetResponse()`` or
    ``ErrorResponse()``.

    Replace by: ``GroupCustomContactDirectoryGetRequest17()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupCustomRingbackGroupGetRequest(OCIRequest):
    """
    Get the group's custom ring back service settings.
    The response is either a ``GroupCustomRingbackGroupGetResponse()`` or an
    ``ErrorResponse()``.
    Replaced By ``GroupCustomRingbackGroupGetRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCustomRingbackGroupGetRequest16(OCIRequest):
    """
    Get the group's custom ring back service settings.
    The response is either a ``GroupCustomRingbackGroupGetResponse16()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupCustomRingbackGroupGetRequest20(OCIRequest):
    """
    Get the group's custom ring back service settings.
    The response is either a ``GroupCustomRingbackGroupGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupDeleteRequest(OCIRequest):
    """
    Delete a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupDepartmentAdminDeleteRequest(OCIRequest):
    """
    Delete a group department administrator.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupDepartmentAdminGetRequest(OCIRequest):
    """
    Get a group department administrators profile.
    The response is either a ``GroupDepartmentAdminGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupDepartmentAdminModifyRequest(OCIRequest):
    """
    Modify a group department administrator.
    Since old password is not specified here, any password rule related to old password
    does not apply.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "first_name",
            "firstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "last_name",
            "lastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* firstName
    first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* lastName
    last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* password
    password = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )


class GroupDepartmentDeleteRequest(OCIRequest):
    """
    Delete a department from a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )


class GroupDepartmentGetAvailableParentListRequest(OCIRequest):
    """
    Get a list of departments that could be the parent department of the specified
    department. The department itself and all its descendents are not eligible to be
    the parent department. If the group belongs to an enterprise, it also returns the
    departments defined in the enterprise it belongs to.
    The response is either ``GroupDepartmentGetAvailableParentListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )


class GroupDepartmentGetListRequest(OCIRequest):
    """
    Request a list of departments in a group. You may request only the
    list of departments defined at the group-level, or you may request
    the list of all departments in the group including all the departments
    defined within the enterprise the group belongs to.
    The response is either ``GroupDepartmentGetListResponse()`` or ``ErrorResponse()``.

    Replaced By ``GroupDepartmentGetListRequest18()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_enterprise_departments",
            "includeEnterpriseDepartments",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* includeEnterpriseDepartments
    include_enterprise_departments = Field(
        type=bool,
        required=True,
    )


class GroupDepartmentGetListRequest18(OCIRequest):
    """
    Request a list of departments in a group. You may request only the
    list of departments defined at the group-level, or you may request
    the list of all departments in the group including all the departments
    defined within the enterprise the group belongs to.
    The response is either ``GroupDepartmentGetListResponse18()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_enterprise_departments",
            "includeEnterpriseDepartments",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* includeEnterpriseDepartments
    include_enterprise_departments = Field(
        type=bool,
        required=True,
    )


class GroupDepartmentGetRequest(OCIRequest):
    """
    Request the attributes of a department.
    The response is either a ``GroupDepartmentGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentName
    department_name = Field(
        type=str,
        required=True,
    )


class GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupRequest(OCIRequest):
    """
    Request the number of access device of a particular device type and group.
    If countOnlyResetSupportedDevice is true, count only access devices if the device
    type supports reset.
    Devices are counted only if their device type supports Device Management.
    An error is returned if deviceType is specified but does not support device management.
    The response is either ``GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "count_only_reset_supported_device",
            "countOnlyResetSupportedDevice",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* countOnlyResetSupportedDevice
    count_only_reset_supported_device = Field(
        type=bool,
        required=False,
    )


class GroupDeviceManagementInProgressAndPendingEventCancelRequest(OCIRequest):
    """
    Cancel pending and in progress events.  A list of individual events can
    be canceled.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "event_id",
            "eventId",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: int: *Required* eventId
    event_id = Field(
        type=int,
        required=True,
    )


class GroupDeviceTypeCustomTagAddRequest(OCIRequest):
    """
    Request to add a static configuration tag for an access device type used in a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_name",
            "tagName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_value",
            "tagValue",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* tagName
    tag_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* tagValue
    tag_value = Field(
        type=str,
        required=False,
    )


class GroupDeviceTypeCustomTagDeleteListRequest(OCIRequest):
    """
    Request to delete static configuration tags for an access device type used in a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_name",
            "tagName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* tagName
    tag_name = Field(
        type=str,
        required=True,
    )


class GroupDeviceTypeCustomTagGetListRequest(OCIRequest):
    """
    Request to get the list of custom configuration tags managed by the Device
    Management System, on a per-device type basis for a group.
    The response is either ``GroupDeviceTypeCustomTagGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )


class GroupDeviceTypeCustomTagModifyRequest(OCIRequest):
    """
    Request to modify a static configuration tag for an access device type used in a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_name",
            "tagName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_value",
            "tagValue",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* tagName
    tag_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* tagValue
    tag_value = Field(
        type=str,
        required=False,
    )


class GroupDeviceTypeFileGetListRequest(OCIRequest):
    """
    Request to get the list of device type files managed by the Device Management
    System, on a per-group basis.
    The response is either ``GroupDeviceTypeFileGetListResponse()`` or ``ErrorResponse()``.
    Replaced By ``GroupDeviceTypeFileGetListRequest14sp8()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )


class GroupDeviceTypeFileGetListRequest14sp8(OCIRequest):
    """
    Request to get the list of device type files managed by the Device Management
    System, on a per-group basis.
    The response is either ``GroupDeviceTypeFileGetListResponse14sp8()`` or
    ``ErrorResponse()``.
    Replaced By ``GroupDeviceTypeFileGetListRequest21()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )


class GroupDeviceTypeFileGetListRequest21(OCIRequest):
    """
    Request to get the list of device type files managed by the Device Management
    System, on a per-group basis.
    The response is either ``GroupDeviceTypeFileGetListResponse21()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )


class GroupDeviceTypeFileGetRequest(OCIRequest):
    """
    Request to get a group device type file.
    The response is either ``GroupDeviceTypeFileGetResponse()`` or ``ErrorResponse()``.
    Replaced By ``GroupDeviceTypeFileGetRequest14sp8()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_type",
            "fileType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileType
    file_type = Field(
        type=str,
        required=True,
    )


class GroupDeviceTypeFileGetRequest14sp8(OCIRequest):
    """
    Request to get a group device type file.
    The response is either ``GroupDeviceTypeFileGetResponse14sp8()`` or ``ErrorResponse()``.
    Replaced By ``GroupDeviceTypeFileGetRequest16sp1()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_format",
            "fileFormat",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileFormat
    file_format = Field(
        type=str,
        required=True,
    )


class GroupDeviceTypeFileGetRequest16sp1(OCIRequest):
    """
    Request to get a group device type file.
    The response is either ``GroupDeviceTypeFileGetResponse16sp1()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_type",
            "deviceType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_format",
            "fileFormat",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceType
    device_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileFormat
    file_format = Field(
        type=str,
        required=True,
    )


class GroupDialPlanPolicyAddAccessCodeRequest(OCIRequest):
    """
    Request to add a Group level Dial Plan Access Code and its all attribues.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_code",
            "accessCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_code_for_screening_services",
            "includeCodeForScreeningServices",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_secondary_dial_tone",
            "enableSecondaryDialTone",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessCode
    access_code = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* includeCodeForNetworkTranslationsAndRouting
    include_code_for_network_translations_and_routing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeCodeForScreeningServices
    include_code_for_screening_services = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableSecondaryDialTone
    enable_secondary_dial_tone = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class GroupDialPlanPolicyDeleteAccessCodeRequest(OCIRequest):
    """
    Request to delete a Group level Dial Plan Access Code and its all attribues.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_code",
            "accessCode",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessCode
    access_code = Field(
        type=str,
        required=True,
    )


class GroupDialPlanPolicyGetAccessCodeListRequest(OCIRequest):
    """
    Request the Group level data associated with Dial Plan Policy.
    The response is either a ``GroupDialPlanPolicyGetAccessCodeListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupDialPlanPolicyGetAccessCodeRequest(OCIRequest):
    """
    Request access code data associated with Group level Dial Plan Policy access codes.
    The response is either a ``GroupDialPlanPolicyGetAccessCodeResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_code",
            "accessCode",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessCode
    access_code = Field(
        type=str,
        required=True,
    )


class GroupDialPlanPolicyGetRequest(OCIRequest):
    """
    Request the Group level data associated with Dial Plan Policy.
    The response is either a ``GroupDialPlanPolicyGetResponse()`` or an ``ErrorResponse()``.

    Replaced By ``GroupDialPlanPolicyGetRequest17()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupDialPlanPolicyGetRequest17(OCIRequest):
    """
    Request the Group level data associated with Dial Plan Policy.
    The response is either a ``GroupDialPlanPolicyGetResponse17()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupDialPlanPolicyModifyAccessCodeRequest(OCIRequest):
    """
    Request to modify a Group level Dial Plan Access Code and its attribues.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_code",
            "accessCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_code_for_screening_services",
            "includeCodeForScreeningServices",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_secondary_dial_tone",
            "enableSecondaryDialTone",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessCode
    access_code = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* includeCodeForNetworkTranslationsAndRouting
    include_code_for_network_translations_and_routing = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* includeCodeForScreeningServices
    include_code_for_screening_services = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableSecondaryDialTone
    enable_secondary_dial_tone = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class GroupDialPlanPolicyModifyRequest(OCIRequest):
    """
    Modify the Group level data associated with Dial Plan Policy.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting",
            "useSetting",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "requires_access_code_for_public_calls",
            "requiresAccessCodeForPublicCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_e164_public_calls",
            "allowE164PublicCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "prefer_e164_number_format_for_callback_services",
            "preferE164NumberFormatForCallbackServices",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "public_digit_map",
            "publicDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "private_digit_map",
            "privateDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* useSetting
    use_setting = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* requiresAccessCodeForPublicCalls
    requires_access_code_for_public_calls = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowE164PublicCalls
    allow_e164_public_calls = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* preferE164NumberFormatForCallbackServices
    prefer_e164_number_format_for_callback_services = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(
        type=str,
        required=False,
    )


class GroupDialableCallerIDCriteriaAddRequest(OCIRequest):
    """
    Add a new Dialable Caller ID Criteria. Criteria are added at the bottom of the
    list with the lowest priority. The response is either a ``SuccessResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "prefix_digits",
            "prefixDigits",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "match_call_type",
            "matchCallType",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "match_alternate_call_indicator",
            "matchAlternateCallIndicator",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "match_local_category",
            "matchLocalCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_national_category",
            "matchNationalCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_interlata_category",
            "matchInterlataCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_intralata_category",
            "matchIntralataCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_international_category",
            "matchInternationalCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_private_category",
            "matchPrivateCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_emergency_category",
            "matchEmergencyCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_other_category",
            "matchOtherCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* prefixDigits
    prefix_digits = Field(
        type=str,
        required=False,
    )
    #: list(str): *Optional* matchCallType  *Array*
    match_call_type = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* matchAlternateCallIndicator  *Array*
    match_alternate_call_indicator = Field(
        type=list,
        required=False,
    )
    #: bool: *Required* matchLocalCategory
    match_local_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchNationalCategory
    match_national_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchInterlataCategory
    match_interlata_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchIntralataCategory
    match_intralata_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchInternationalCategory
    match_international_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchPrivateCategory
    match_private_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchEmergencyCategory
    match_emergency_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchOtherCategory
    match_other_category = Field(
        type=bool,
        required=True,
    )


class GroupDialableCallerIDCriteriaDeleteRequest(OCIRequest):
    """
    Delete a Dialable Caller ID Criteria.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupDialableCallerIDCriteriaGetRequest(OCIRequest):
    """
    Get an existing Dialable Caller ID Criteria.
    The response is either a
    ``GroupDialableCallerIDCriteriaGetRequest()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupDialableCallerIDGetRequest(OCIRequest):
    """
    Get the Group’s Dialable Caller ID settings and criteria list.
    The response is either a
    ``GroupDialableCallerIDGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupDigitCollectionGetRequest13mp4(OCIRequest):
    """
    Request the group's digit collection attributes.
    The response is either a ``GroupDigitCollectionGetResponse13mp4()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupDigitCollectionModifyRequest(OCIRequest):
    """
    Modifies the group's digit collection attributes.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting",
            "useSetting",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_code",
            "accessCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "public_digit_map",
            "publicDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "private_digit_map",
            "privateDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* useSetting
    use_setting = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* accessCode
    access_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(
        type=str,
        required=False,
    )


class GroupDirectoryNumberHuntingGetAvailableUserListRequest(OCIRequest):
    """
    Request to get the agents of a call center or hunt group that are available
    to be assigned to a directory number hunting group.  They are agents that
    are not already assigned to any other directory number hunting group.
    The response is either
    ``GroupDirectoryNumberHuntingGetAvailableUserListResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupDirectoryNumberHuntingGetRequest(OCIRequest):
    """
    Request to get the properties of the DNH service for a specified serviceUserId.
    It gets the agents of a call center or hunt group that are members
    of a directory number hunting group.  They are agents that are not already
    assigned to any other directory number hunting group.
    The response is either ``GroupDirectoryNumberHuntingGetResponse()`` or
    ``ErrorResponse()``.

    Replaced By ``GroupDirectoryNumberHuntingGetRequest17sp1()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupDirectoryNumberHuntingGetRequest17sp1(OCIRequest):
    """
    Request to get the properties of the DNH service for a specified serviceUserId.
    It gets the agents of a call center or hunt group that are members
    of a directory number hunting group.  They are agents that are not already
    assigned to any other directory number hunting group.
    The response is either ``GroupDirectoryNumberHuntingGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupDnGetActivationListRequest(OCIRequest):
    """
    Get the list of activated and deactivated DNs in a group.
    Ranges of DNs with identical assignment and activation properties are coalesced
    to a single table row entry.
    Only DNs assigned to a users are listed in the response when the number
    activation Mode is set to "User Activation Enabled"
    Dns assigned to the IMRN pool are not listed in the response.
    The response is either a ``GroupDnGetActivationListResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupDnGetAvailableListRequest(OCIRequest):
    """
    Get the list of DNs that are assigned to a group and still available for
    assignment to users or service instances within the group.
    Dns assigned to the IMRN pool are not listed in the response.
    The response is either a ``GroupDnGetAvailableListResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupDnGetAvailableRangesListRequest(OCIRequest):
    """
    Get a list of group DNs that are not assigned to user, service instances or IMRN pool.
    The Dns are returned in a list of DNs or DN ranges and formated in E164 format
    for display.
    The response is either a ``GroupDnGetAvailableRangeListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupDnGetDetailedAvailableListRequest(OCIRequest):
    """
    Get the list of DNs that are assigned to a group and still available for
    assignment to users within the group with the department name, if the DN
    is assigned to the department.
    Dns assigned to the IMRN pool are not listed in the response.
    The response is either a ``GroupDnGetDetailedAvailableListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupDnGetListRequest(OCIRequest):
    """
    Get the list of DNs that are assigned to a group.
    Dns assigned to the IMRN pool are not listed in the response.
    The response is either a ``GroupDnGetListResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupDnGetSummaryListRequest(OCIRequest):
    """
    Get the list of assigned and unassigned DN ranges in a group.
    Dns assigned to the IMRN pool are not listed in the response.
    The response is either a ``GroupDnGetSummaryListResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupDomainAssignListRequest(OCIRequest):
    """
    Assign a list of domains to a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "domain",
            "domain",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* domain
    domain = Field(
        type=str,
        required=True,
    )


class GroupDomainGetAssignedListRequest(OCIRequest):
    """
    Requests the list of all domains assigned to a group.
    The response is either ``GroupDomainGetAssignedListResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupDomainUnassignListRequest(OCIRequest):
    """
    Unassign a list of domains from a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "domain",
            "domain",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* domain
    domain = Field(
        type=str,
        required=True,
    )


class GroupEmergencyZonesGetHomeZoneListRequest(OCIRequest):
    """
    Request the group level data associated with Emergency Zones.
    The response is either a ``GroupEmergencyZonesGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupEmergencyZonesGetRequest(OCIRequest):
    """
    Request the group level data associated with Emergency Zones.
    The response is either a ``GroupEmergencyZonesGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupEmergencyZonesModifyHomeZoneListRequest(OCIRequest):
    """
    Modify a list of home zones and/or home zone ranges.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "home_zone_ip_address_list",
            "homeZoneIpAddressList",
            str,
            True,
            False,
            True,
            False,
        ),  # unknown
        E(
            "home_zone_ip_address_range_list",
            "homeZoneIpAddressRangeList",
            str,
            True,
            False,
            True,
            False,
        ),  # unknown
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* homeZoneIpAddressList  *Array*
    home_zone_ip_address_list = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* homeZoneIpAddressRangeList  *Array*
    home_zone_ip_address_range_list = Field(
        type=list,
        required=False,
    )


class GroupEmergencyZonesModifyRequest(OCIRequest):
    """
    Modify the group level data associated with Emergency Zones.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "emergency_zones_prohibition",
            "emergencyZonesProhibition",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "send_emergency_call_notify_email",
            "sendEmergencyCallNotifyEmail",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "emergency_call_notify_email_address",
            "emergencyCallNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* isActive
    is_active = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* emergencyZonesProhibition
    emergency_zones_prohibition = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* sendEmergencyCallNotifyEmail
    send_emergency_call_notify_email = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* emergencyCallNotifyEmailAddress
    emergency_call_notify_email_address = Field(
        type=str,
        required=False,
    )


class GroupEnterpriseTrunkAddRequest(OCIRequest):
    """
    Request to add an enterprise trunk in a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Replaced By ``GroupEnterpriseTrunkAddRequest21()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "maximum_reroute_attempts",
            "maximumRerouteAttempts",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_exhaustion_action",
            "routeExhaustionAction",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_exhaustion_forward_address",
            "routeExhaustionForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "ordered_routing",
            "orderedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "priority_weighted_routing",
            "priorityWeightedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )
    #: int: *Required* maximumRerouteAttempts
    maximum_reroute_attempts = Field(
        type=int,
        required=True,
    )
    #: str: *Required* routeExhaustionAction
    route_exhaustion_action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* orderedRouting
    ordered_routing = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(
        type=str,
        required=False,
    )


class GroupEnterpriseTrunkAddRequest21(OCIRequest):
    """
    Request to add an enterprise trunk in a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "maximum_reroute_attempts",
            "maximumRerouteAttempts",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_exhaustion_action",
            "routeExhaustionAction",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_exhaustion_forward_address",
            "routeExhaustionForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "ordered_routing",
            "orderedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "priority_weighted_routing",
            "priorityWeightedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "enable_capacity_management",
            "enableCapacityManagement",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_active_calls",
            "maxActiveCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_initial_calls",
            "capacityExceededTrapInitialCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_offset_calls",
            "capacityExceededTrapOffsetCalls",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )
    #: int: *Required* maximumRerouteAttempts
    maximum_reroute_attempts = Field(
        type=int,
        required=True,
    )
    #: str: *Required* routeExhaustionAction
    route_exhaustion_action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* orderedRouting
    ordered_routing = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* enableCapacityManagement
    enable_capacity_management = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* maxActiveCalls
    max_active_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(
        type=int,
        required=False,
    )


class GroupEnterpriseTrunkAddUserListRequest(OCIRequest):
    """
    Request to add users to an enterprise trunk in a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupEnterpriseTrunkDeleteRequest(OCIRequest):
    """
    Request to delete an enterprise trunk in a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )


class GroupEnterpriseTrunkDeleteUserListRequest(OCIRequest):
    """
    Request to delete users from an enterprise trunk in a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupEnterpriseTrunkForceAssignUserListRequest(OCIRequest):
    """
    Request to add users to an enterprise trunk in a group. If the user is already
    assigned to another enterprise trunk,
    it will be unassigned from the old enterprise trunk and assigned to the new
    enterprise trunk specified in this request.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class GroupEnterpriseTrunkGetListRequest(OCIRequest):
    """
    Request to get the list of all enterprise trunks defined in a group.
    The response is either a ``GroupEnterpriseTrunkGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupEnterpriseTrunkGetRequest(OCIRequest):
    """
    Request to get an enterprise trunk
    The response is either an ``GroupEnterpriseTrunkGetResponse()`` or an ``ErrorResponse()``.

    Replaced By ``GroupEnterpriseTrunkGetRequest21()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )


class GroupEnterpriseTrunkGetRequest21(OCIRequest):
    """
    Request to get an enterprise trunk
    The response is either an ``GroupEnterpriseTrunkGetResponse21()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )


class GroupEnterpriseTrunkModifyRequest(OCIRequest):
    """
    Request to modify an enterprise trunk in a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_trunk_name",
            "enterpriseTrunkName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "new_enterprise_trunk_name",
            "newEnterpriseTrunkName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "maximum_reroute_attempts",
            "maximumRerouteAttempts",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "route_exhaustion_action",
            "routeExhaustionAction",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "route_exhaustion_forward_address",
            "routeExhaustionForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "ordered_routing",
            "orderedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "priority_weighted_routing",
            "priorityWeightedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "enable_capacity_management",
            "enableCapacityManagement",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_active_calls",
            "maxActiveCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_initial_calls",
            "capacityExceededTrapInitialCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_offset_calls",
            "capacityExceededTrapOffsetCalls",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enterpriseTrunkName
    enterprise_trunk_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* newEnterpriseTrunkName
    new_enterprise_trunk_name = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* maximumRerouteAttempts
    maximum_reroute_attempts = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* routeExhaustionAction
    route_exhaustion_action = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* orderedRouting
    ordered_routing = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* enableCapacityManagement
    enable_capacity_management = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxActiveCalls
    max_active_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(
        type=int,
        required=False,
    )


class GroupExchangeIntegrationGetRequest(OCIRequest):
    """
    Request the group level configuration for Exchange Integration.
    The response is either a ``GroupExchangeIntegrationGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupExistingUsersAssignUserServiceListRequest(OCIRequest):
    """
    Request to assign the user services and service packs to all existing users
    within the group.
    BroadSoft recommends using this command only for small groups with less than 100
    users.  This
    command will return an error if the group has over 500 users.  The recommended way to bulk
    assign/unassign services is Service Pack Migration.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_name",
            "serviceName",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "service_pack_name",
            "servicePackName",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* serviceName  *Array*
    service_name = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(
        type=list,
        required=False,
    )


class GroupExistingUsersUnassignUserServiceListRequest(OCIRequest):
    """
    Requests to unassign the user services and service packs for all existing users
    within the group.
    BroadSoft recommends using this command only for small groups with less than 100
    users.  This
    command will return an error if the group has over 500 users.  The recommended way to bulk
    assign/unassign services is Service Pack Migration.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_name",
            "serviceName",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "service_pack_name",
            "servicePackName",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* serviceName  *Array*
    service_name = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(
        type=list,
        required=False,
    )


class GroupExtensionLengthGetRequest(OCIRequest):
    """
    Request the group's extension length.
    The response is either a ``GroupExtensionLengthGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupExtensionLengthGetRequest17(OCIRequest):
    """
    Request the group's extension length.
    The response is either a ``GroupExtensionLengthGetResponse17()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupExtensionLengthModifyRequest(OCIRequest):
    """
    Modify the group's extension length.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "extension_length",
            "extensionLength",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* extensionLength
    extension_length = Field(
        type=int,
        required=False,
    )


class GroupExtensionLengthModifyRequest17(OCIRequest):
    """
    Modify the group's extension length range.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_extension_length",
            "minExtensionLength",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_extension_length",
            "maxExtensionLength",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_extension_length",
            "defaultExtensionLength",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* minExtensionLength
    min_extension_length = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxExtensionLength
    max_extension_length = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* defaultExtensionLength
    default_extension_length = Field(
        type=int,
        required=False,
    )


class GroupFeatureAccessCodeGetListRequest(OCIRequest):
    """
    Get the list of feature access codes for a group.
    The response is either a ``GroupFeatureAccessCodeGetListResponse()`` or an
    ``ErrorResponse()``.
    Replaced By ``GroupFeatureAccessCodeGetRequest()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupFeatureAccessCodeGetRequest(OCIRequest):
    """
    Get group FAC code level and the list of feature access codes for a group.
    The response is either a ``GroupFeatureAccessCodeGetResponse()`` or an
    ``ErrorResponse()``.
    Returned Feature Access Codes may be group specific, or Service Provider Feature
    Access Codes, depending on FAC code level.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupFeatureAccessCodeGetRequest20(OCIRequest):
    """
    Get group FAC code level and the list of feature access codes for a group.
    The response is either a ``GroupFeatureAccessCodeGetResponse20()`` or an
    ``ErrorResponse()``.
    Returned Feature Access Codes may be group specific, or Service Provider
    Feature Access Codes, depending on FAC code level.

    In release 20 the "Call Recording" FAC name is changed to
    "Call Recording - Start".
    Replaced By ``GroupFeatureAccessCodeGetRequest21()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupFeatureAccessCodeGetRequest21(OCIRequest):
    """
    Get group FAC code level and the list of feature access codes for a group.
    The response is either a ``GroupFeatureAccessCodeGetResponse20()`` or an
    ``ErrorResponse()``.
    Returned Feature Access Codes may be group specific, or Service Provider
    Feature Access Codes, depending on FAC code level.

    In release 20 the "Call Recording" FAC name is changed to
    "Call Recording - Start".
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupFileRepositoryDeviceUserAddRequest(OCIRequest):
    """
    Add a new group file repository user.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_repository_name",
            "fileRepositoryName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_name",
            "userName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_put",
            "allowPut",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_delete",
            "allowDelete",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_get",
            "allowGet",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userName
    user_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* password
    password = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowPut
    allow_put = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowDelete
    allow_delete = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowGet
    allow_get = Field(
        type=bool,
        required=True,
    )


class GroupFileRepositoryDeviceUserDeleteRequest(OCIRequest):
    """
    Delete a group file repository user.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_repository_name",
            "fileRepositoryName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_name",
            "userName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userName
    user_name = Field(
        type=str,
        required=True,
    )


class GroupFileRepositoryDeviceUserGetListRequest(OCIRequest):
    """
    Request the list of group users for a file repository in the system.
    The response is either a ``GroupFileRepositoryDeviceUserGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_repository_name",
            "fileRepositoryName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(
        type=str,
        required=True,
    )


class GroupFileRepositoryDeviceUserModifyRequest(OCIRequest):
    """
    Modify a group file repository user.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_repository_name",
            "fileRepositoryName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_name",
            "userName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_put",
            "allowPut",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_delete",
            "allowDelete",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_get",
            "allowGet",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userName
    user_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* password
    password = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* allowPut
    allow_put = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowDelete
    allow_delete = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowGet
    allow_get = Field(
        type=bool,
        required=False,
    )


class GroupFindMeFollowMeAddAlertingGroupRequest(OCIRequest):
    """
    Add an alerting group to a Find-me/Follow-me instance.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "alerting_group_name",
            "alertingGroupName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "alerting_group_description",
            "alertingGroupDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_diversion_inhibitor",
            "useDiversionInhibitor",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "answer_confirmation_required",
            "answerConfirmationRequired",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_rings",
            "numberOfRings",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* alertingGroupName
    alerting_group_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* alertingGroupDescription
    alerting_group_description = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useDiversionInhibitor
    use_diversion_inhibitor = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* answerConfirmationRequired
    answer_confirmation_required = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* numberOfRings
    number_of_rings = Field(
        type=int,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userId
    user_id = Field(
        type=str,
        required=False,
    )


class GroupFindMeFollowMeDeleteAlertingGroupRequest(OCIRequest):
    """
    Delete an alerting group from a Find-me/Follow-me instance.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "alerting_group_name",
            "alertingGroupName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* alertingGroupName
    alerting_group_name = Field(
        type=str,
        required=True,
    )


class GroupFindMeFollowMeDeleteAlertingGroupSelectiveCriteriaRequest(OCIRequest):
    """
    Delete a criteria from the Find-me/Follow-me alerting group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "alerting_group_name",
            "alertingGroupName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "criteria_name",
            "criteriaName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* alertingGroupName
    alerting_group_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* criteriaName
    criteria_name = Field(
        type=str,
        required=True,
    )


class GroupFindMeFollowMeDeleteInstanceRequest(OCIRequest):
    """
    Delete a Find-me/Follow-me instance from a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupFindMeFollowMeGetAlertingGroupListRequest(OCIRequest):
    """
    Get a list of Find-me/Follow-me alerting groups within a group.
    The response is either ``GroupFindMeFollowMeGetAlertingGroupListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupFindMeFollowMeGetAlertingGroupRequest(OCIRequest):
    """
    Request to get all the information of a Find-me/Follow-me alerting group.
    The response is either ``GroupFindMeFollowMeGetAlertingGroupResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "alerting_group_name",
            "alertingGroupName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* alertingGroupName
    alerting_group_name = Field(
        type=str,
        required=True,
    )


class GroupFindMeFollowMeGetAlertingGroupSelectiveCriteriaRequest(OCIRequest):
    """
    Request to get all the information of a specific Find-me/Follow-me alerting group
    selective criteria.
    The response is either ``GroupFindMeFollowMeGetAlertingGroupResponse()`` or
    ``ErrorResponse()``.

    Replaced By ``GroupFindMeFollowMeGetAlertingGroupSelectiveCriteriaRequest21()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "alerting_group_name",
            "alertingGroupName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "criteria_name",
            "criteriaName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* alertingGroupName
    alerting_group_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* criteriaName
    criteria_name = Field(
        type=str,
        required=True,
    )


class GroupFindMeFollowMeGetAlertingGroupSelectiveCriteriaRequest21(OCIRequest):
    """
    Request to get all the information of a specific Find-me/Follow-me alerting group
    selective criteria.
    The response is either ``GroupFindMeFollowMeGetAlertingGroupResponse21()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "alerting_group_name",
            "alertingGroupName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "criteria_name",
            "criteriaName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* alertingGroupName
    alerting_group_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* criteriaName
    criteria_name = Field(
        type=str,
        required=True,
    )


class GroupFindMeFollowMeGetInstanceListRequest(OCIRequest):
    """
    Get a list of Find-me/Follow-me instances within a group.
    The response is either ``GroupFindMeFollowMeGetInstanceListResponse()`` or
    ``ErrorResponse()``.
    It is possible to get the instances within a specified department.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_department_name",
            "groupDepartmentName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(
        type=str,
        required=False,
    )


class GroupFindMeFollowMeGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a Find-me/Follow-me instance.
    The response is either ``GroupFindMeFollowMeGetInstanceResponse()`` or
    ``ErrorResponse()``.

    Replaced By ``GroupFindMeFollowMeGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupFindMeFollowMeGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Find-me/Follow-me instance.
    The response is either ``GroupFindMeFollowMeGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupFindMeFollowMeModifyAlertingGroupListRequest(OCIRequest):
    """
    Modify the priorities assigned to alerting groups
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    NOTE: The command fails if all the alerting groups defined for the user are not provided.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "alerting_group_name",
            "alertingGroupName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* alertingGroupName
    alerting_group_name = Field(
        type=str,
        required=False,
    )


class GroupFlexibleSeatingAccessDeviceGetListRequest(OCIRequest):
    """
    Requests the list of access devices available for assignment to a flexible
    seating host or guest. The list includes devices created at the system, service
    provider, and group levels that support device management.
    The response is either ``GroupFlexibleSeatingAccessDeviceGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupFlexibleSeatingHostDeleteInstanceRequest(OCIRequest):
    """
    Delete a flexible seating host instance from a group. Host cannot be deleted when
    a guest is associated to a host.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupFlexibleSeatingHostGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a flexible seating host instance.
    The response is either ``GroupFlexibleSeatingHostGetInstanceResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupFlexibleSeatingHostGuestAssociationGetRequest(OCIRequest):
    """
    Request the flexible seating host guest association details.
    The response is either a ``GroupFlexibleSeatingHostGuestAssociationGetResponse()``
    or an ``ErrorResponse()``.
    accessLevel is always set to Group for a Service Provider
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupFlexibleSeatingHostGuestAssociationModifyRequest(OCIRequest):
    """
    Modify the flexible seating host’s guest association attributes.
    The request fails if enforceAssociationLimit or associationLimitHours are changed
    when the host is associated to a guest.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_association_limit",
            "enforceAssociationLimit",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "association_limit_hours",
            "associationLimitHours",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_level",
            "accessLevel",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "remove_guest_association",
            "removeGuestAssociation",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* enforceAssociationLimit
    enforce_association_limit = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* associationLimitHours
    association_limit_hours = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* accessLevel
    access_level = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* removeGuestAssociation
    remove_guest_association = Field(
        type=bool,
        required=False,
    )


class GroupFlexibleSeatingHostRoutingPoliciesGetRequest(OCIRequest):
    """
    Get a flexible seating host’s routing policies
    The response is either a ``GroupFlexibleSeatingHostRoutingPoliciesGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupFlexibleSeatingHostRoutingPoliciesModifyRequest(OCIRequest):
    """
    Modify a flexible seating host’s routing policies
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_emergency_calls",
            "allowEmergencyCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_calls_to_voice_portal",
            "allowCallsToVoicePortal",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* allowEmergencyCalls
    allow_emergency_calls = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowCallsToVoicePortal
    allow_calls_to_voice_portal = Field(
        type=bool,
        required=False,
    )


class GroupGetDefaultRequest(OCIRequest):
    """
    Request the default profile for a group.
    The response is either a ``GroupGetDefaultResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class GroupGetRequest(OCIRequest):
    """
    Get the profile for a group.
    The response is either a ``GroupGetResponse()`` or an ``ErrorResponse()``.
    Replaced By ``GroupGetRequest14sp7()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupGetRequest14sp7(OCIRequest):
    """
    Get the profile for a group.
    The response is either a ``GroupGetResponse14sp7()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupGetUserServiceAssignedUserListRequest(OCIRequest):
    """
    Get the list of users assigned the user service or service pack.
    The response is either a ``GroupGetUserServiceAssignedUserListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_name",
            "serviceName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_pack_name",
            "servicePackName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* serviceName
    service_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* servicePackName
    service_pack_name = Field(
        type=str,
        required=False,
    )


class GroupGroupNightForwardingGetRequest(OCIRequest):
    """
    Request to get the Group Night Forwarding group parameters.
    The response is either ``GroupGroupNightForwardingGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupGroupPagingAddOriginatorListRequest(OCIRequest):
    """
    Add originator(s) to a paging group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "originator_user_id",
            "originatorUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* originatorUserId
    originator_user_id = Field(
        type=str,
        required=True,
    )


class GroupGroupPagingAddTargetListRequest(OCIRequest):
    """
    Add target(s) to a paging group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "target_user_id",
            "targetUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* targetUserId
    target_user_id = Field(
        type=str,
        required=True,
    )


class GroupGroupPagingDeleteInstanceRequest(OCIRequest):
    """
    Delete a Group Paging instance from a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupGroupPagingDeleteOriginatorListRequest(OCIRequest):
    """
    Delete originator(s) from a paging group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "originator_user_id",
            "originatorUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* originatorUserId
    originator_user_id = Field(
        type=str,
        required=True,
    )


class GroupGroupPagingDeleteTargetListRequest(OCIRequest):
    """
    Delete target(s) from a paging group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "target_user_id",
            "targetUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* targetUserId
    target_user_id = Field(
        type=str,
        required=True,
    )


class GroupGroupPagingGetInstanceListRequest(OCIRequest):
    """
    Get a list of Paging Groups instances within a group.
    The response is either ``GroupGroupPagingGetInstanceListResponse()`` or
    ``ErrorResponse()``.
    It is possible to get the instances within a specified department.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_department_name",
            "groupDepartmentName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(
        type=str,
        required=False,
    )


class GroupGroupPagingGetInstanceRequest(OCIRequest):
    """
    Replaced By ``GroupGroupPagingGetInstanceRequest17sp3()``
    Request to get all the information of a Group Paging instance.
    The response is either ``GroupGroupPagingGetInstanceResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupGroupPagingGetInstanceRequest17sp3(OCIRequest):
    """
    Request to get all the information of a Group Paging instance.
    The response is either ``GroupGroupPagingGetInstanceResponse17sp3()`` or
    ``ErrorResponse()``.

    Replaced By ``GroupGroupPagingGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupGroupPagingGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Group Paging instance.
    The response is either ``GroupGroupPagingGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupGroupPagingGetOriginatorListRequest(OCIRequest):
    """
    Get a list of originators assigned to a paging group.
    The response is either a
    ``GroupGroupPagingGetOriginatorListResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupGroupPagingGetTargetListRequest(OCIRequest):
    """
    Get a list of targets assigned to a paging group.
    The response is either a
    ``GroupGroupPagingGetTargetListResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupGroupPagingTargetsCapacityGetRequest(OCIRequest):
    """
    Request the maximum number of target users per paging group configured for a group.
    The response is either a ``GroupGroupPagingTargetsCapacityGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupGroupPagingTargetsCapacityModifyRequest(OCIRequest):
    """
    Modify the maximum number of target users per paging group configured for a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "maximum_target_users",
            "maximumTargetUsers",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* maximumTargetUsers
    maximum_target_users = Field(
        type=int,
        required=False,
    )


class GroupHolidayScheduleDeleteRequest(OCIRequest):
    """
    Delete a holiday schedule from a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "holiday_schedule_name",
            "holidayScheduleName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* holidayScheduleName
    holiday_schedule_name = Field(
        type=str,
        required=True,
    )


class GroupHolidayScheduleGetListRequest(OCIRequest):
    """
    Get a holiday schedule in a group.
    The response is either a ``GroupHolidayScheduleGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupHolidayScheduleGetRequest(OCIRequest):
    """
    Get a holiday schedule in a group.
    The response is either a ``GroupHolidayScheduleGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "holiday_schedule_name",
            "holidayScheduleName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* holidayScheduleName
    holiday_schedule_name = Field(
        type=str,
        required=True,
    )


class GroupHuntGroupDeleteInstanceRequest(OCIRequest):
    """
    Delete a Hunt Group instance from a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupHuntGroupGetInstanceListRequest(OCIRequest):
    """
    Get a list of Hunt Group instances within a group.
    The response is either ``GroupHuntGroupGetInstanceListResponse()`` or ``ErrorResponse()``.
    It is possible to get the instances within a specified department.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_department_name",
            "groupDepartmentName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(
        type=str,
        required=False,
    )


class GroupHuntGroupGetInstanceRequest14(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.
    The response is either ``GroupHuntGroupGetInstanceResponse14()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupHuntGroupGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.
    The response is either ``GroupHuntGroupGetInstanceResponse17()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupHuntGroupGetInstanceRequest17sp3(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.
    The response is either ``GroupHuntGroupGetInstanceResponse17sp3()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupHuntGroupGetInstanceRequest17sp4(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.
    The response is either ``GroupHuntGroupGetInstanceResponse17sp4()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupHuntGroupGetInstanceRequest19(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.
    The response is either ``GroupHuntGroupGetInstanceResponse19()`` or ``ErrorResponse()``.

    Replaced By ``GroupHuntGroupGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupHuntGroupGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.
    The response is either ``GroupHuntGroupGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.

    Replaced By ``GroupHuntGroupGetInstanceRequest20()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupHuntGroupGetInstanceRequest20(OCIRequest):
    """
    Request to get all the information of a Hunt Group instance.
    The response is either ``GroupHuntGroupGetInstanceResponse20()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupIMRNGetListRequest(OCIRequest):
    """
    Request a summary table of all DNs in a group IMRN pool.
    The response is either ``GroupIMRNGetListResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupIncomingCallingPlanGetListRequest(OCIRequest):
    """
    Request the group's incoming calling plan settings.
    The response is either a ``GroupIncomingCallingPlanGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupInstantGroupCallDeleteInstanceRequest(OCIRequest):
    """
    Request to delete an Instant Group Call service instance from a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupInstantGroupCallGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Instant Group Call service instances within a group.
    The response is either ``GroupInstantGroupCallGetInstanceListResponse()`` or
    ``ErrorResponse()``.
    It is possible to get the service instances within a specified department.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_department_name",
            "groupDepartmentName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(
        type=str,
        required=False,
    )


class GroupInstantGroupCallGetInstanceRequest14(OCIRequest):
    """
    Request to get all the information of an Instant Group Call service instance.
    The response is either ``GroupInstantGroupCallGetInstanceResponse14()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupInstantGroupCallGetInstanceRequest17(OCIRequest):
    """
    Request to get all the information of an Instant Group Call service instance.
    The response is either ``GroupInstantGroupCallGetInstanceResponse17()`` or
    ``ErrorResponse()``.

    Replaced By ``GroupInstantGroupCallGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupInstantGroupCallGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of an Instant Group Call service instance.
    The response is either ``GroupInstantGroupCallGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupIntegratedIMPGetRequest(OCIRequest):
    """
    Get the Integrated IMP service attributes for the group.
    The response is either ``GroupIntegratedIMPGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupIntegratedIMPModifyRequest(OCIRequest):
    """
    Modify the Integrated IMP service attributes for the group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_service_provider_setting",
            "useServiceProviderSetting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_domain",
            "serviceDomain",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* useServiceProviderSetting
    use_service_provider_setting = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* serviceDomain
    service_domain = Field(
        type=str,
        required=False,
    )


class GroupInterceptGroupGetRequest(OCIRequest):
    """
    Get the group's intercept group service settings.
    The response is either a ``GroupInterceptGroupGetResponse()`` or an ``ErrorResponse()``.
    Replaced By ``GroupInterceptGroupGetRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupInterceptGroupGetRequest16(OCIRequest):
    """
    Get the group's intercept group service settings.
    The response is either a ``GroupInterceptGroupGetResponse16()`` or an ``ErrorResponse()``.
    Replaced By ``GroupInterceptGroupGetRequest16sp1()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupInterceptGroupGetRequest16sp1(OCIRequest):
    """
    Get the group's intercept group service settings.
    The response is either a ``GroupInterceptGroupGetResponse16sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupInventoryReportGetRequest(OCIRequest):
    """
    Request the group's inventory report.
    The response is either a ``GroupInventoryReportGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_users",
            "includeUsers",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_services",
            "includeServices",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_dns",
            "includeDns",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_access_devices",
            "includeAccessDevices",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_departments",
            "includeDepartments",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "report_delivery_email_address",
            "reportDeliveryEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* includeUsers
    include_users = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeServices
    include_services = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeDns
    include_dns = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeAccessDevices
    include_access_devices = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeDepartments
    include_departments = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* reportDeliveryEmailAddress
    report_delivery_email_address = Field(
        type=str,
        required=False,
    )


class GroupLDAPIntegrationGetDirectoryRequest(OCIRequest):
    """
    Get the LDAP directory attributes for a group.
    The response is either a ``GroupLDAPIntegrationGetDirectoryResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupLDAPIntegrationGetRequest(OCIRequest):
    """
    Request the group level data associated with LDAP Integration.
    The response is either a ``GroupLDAPIntegrationGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupLDAPIntegrationModifyDirectoryRequest(OCIRequest):
    """
    Modify the LDAP directory attributes for a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_level",
            "useLevel",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "server_net_address",
            "serverNetAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "server_port",
            "serverPort",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "search_base",
            "searchBase",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_ssl",
            "useSSL",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "require_authentication",
            "requireAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "authenticated_dn",
            "authenticatedDN",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "authenticated_password",
            "authenticatedPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "is_sort_enabled",
            "isSortEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "is_paged_result_enabled",
            "isPagedResultEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "search_filter",
            "searchFilter",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_search_attribute_in_search_filter",
            "includeSearchAttributeInSearchFilter",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "column1_attribute_name",
            "column1AttributeName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column2_attribute_name",
            "column2AttributeName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column3_attribute_name",
            "column3AttributeName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column4_attribute_name",
            "column4AttributeName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column1_label",
            "column1Label",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column2_label",
            "column2Label",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column3_label",
            "column3Label",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column4_label",
            "column4Label",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "search_column",
            "searchColumn",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* useLevel
    use_level = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serverNetAddress
    server_net_address = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* serverPort
    server_port = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* searchBase
    search_base = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* useSSL
    use_ssl = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* requireAuthentication
    require_authentication = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* authenticatedDN
    authenticated_dn = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* authenticatedPassword
    authenticated_password = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* isSortEnabled
    is_sort_enabled = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* isPagedResultEnabled
    is_paged_result_enabled = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* searchFilter
    search_filter = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* includeSearchAttributeInSearchFilter
    include_search_attribute_in_search_filter = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* column1AttributeName
    column1_attribute_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column2AttributeName
    column2_attribute_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column3AttributeName
    column3_attribute_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column4AttributeName
    column4_attribute_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column1Label
    column1_label = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column2Label
    column2_label = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column3Label
    column3_label = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column4Label
    column4_label = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* searchColumn
    search_column = Field(
        type=int,
        required=False,
    )


class GroupLDAPIntegrationModifyRequest(OCIRequest):
    """
    Modify the group level data associated with LDAP Integration.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* isActive
    is_active = Field(
        type=bool,
        required=False,
    )


class GroupMWIDeliveryToMobileEndpointCustomTemplateDeleteRequest(OCIRequest):
    """
    Delete a MWI Delivery to Mobile Endpoint Custom Template.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "type",
            "type",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* language
    language = Field(
        type=str,
        required=True,
    )
    #: str: *Required* type
    type = Field(
        type=str,
        required=True,
    )


class GroupMWIDeliveryToMobileEndpointCustomTemplateGetRequest(OCIRequest):
    """
    Request a MWI Delivery to Mobile Endpoint Custom Template.
    The response is either a ``GroupMWIDeliveryToMobileEndpointCustomTemplateGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "type",
            "type",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* language
    language = Field(
        type=str,
        required=True,
    )
    #: str: *Required* type
    type = Field(
        type=str,
        required=True,
    )


class GroupMWIDeliveryToMobileEndpointGetRequest(OCIRequest):
    """
    Requests group MWI custom notifications settings.
    The response is either a ``GroupMWIDeliveryToMobileEndpointGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupMeetMeConferencingDeleteInstanceRequest(OCIRequest):
    """
    Delete a Meet-Me Conferencing bridge from a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupMeetMeConferencingGetInstanceListRequest(OCIRequest):
    """
    Get a list of Meet-Me Conferencing instances within a group.
    The response is either ``GroupMeetMeConferencingGetInstanceListResponse()`` or
    ``ErrorResponse()``.
    It is possible to get the instances within a specified department.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_name",
            "departmentName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* departmentName
    department_name = Field(
        type=str,
        required=False,
    )


class GroupMeetMeConferencingGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.
    The response is either ``GroupMeetMeConferencingGetInstanceResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupMeetMeConferencingGetInstanceRequest17sp3(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.
    The response is either ``GroupMeetMeConferencingGetInstanceResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupMeetMeConferencingGetInstanceRequest17sp4(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.
    The response is either ``GroupMeetMeConferencingGetInstanceResponse17sp4()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupMeetMeConferencingGetInstanceRequest18(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.
    The response is either ``GroupMeetMeConferencingGetInstanceResponse18()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupMeetMeConferencingGetInstanceRequest19(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.
    The response is either ``GroupMeetMeConferencingGetInstanceResponse19()`` or
    ``ErrorResponse()``.

    Replaced By ``GroupMeetMeConferencingGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupMeetMeConferencingGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Meet-Me Conferencing bridge.
    The response is either ``GroupMeetMeConferencingGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupMeetMeConferencingGetRequest(OCIRequest):
    """
    Request the group level data associated with Meet-Me Conferencing functions.
    The response is either a ``GroupMeetMeConferencingGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupMusicOnHoldGetDepartmentListRequest(OCIRequest):
    """
    Returns a list of all departments that have a Music On Hold instance.
    The response is either ``GroupMusicOnHoldGetDepartmentListResponse()`` or
    ``ErrorResponse()``.
    It is possible to get the instances within a specified department.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_department_name",
            "groupDepartmentName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(
        type=str,
        required=False,
    )


class GroupNetworkClassOfServiceAssignListRequest(OCIRequest):
    """
    Assign a list of Network Classes of Service to a group.
    The Element defaultNetworkClassOfService is required only for the first
    assignment, for subsequent assignments it is optional.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_class_of_service",
            "networkClassOfService",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "default_network_class_of_service",
            "defaultNetworkClassOfService",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* networkClassOfService  *Array*
    network_class_of_service = Field(
        type=list,
        required=False,
    )
    #: str: *Optional* defaultNetworkClassOfService
    default_network_class_of_service = Field(
        type=str,
        required=False,
    )


class GroupNetworkClassOfServiceAssignToAllUsersRequest(OCIRequest):
    """
    Assign a Network Classes of Service to all users with in a
    group. The Network Classes of Service must be currently assigned to
    the group. The response is either a ``SuccessResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_class_of_service",
            "networkClassOfService",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* networkClassOfService
    network_class_of_service = Field(
        type=str,
        required=True,
    )


class GroupNetworkClassOfServiceGetAssignedListRequest(OCIRequest):
    """
    Get a list of Network Classes of Service assigned to a group.
    The response is either a ``GroupNetworkClassOfServiceGetAssignedListResponse()``
    or an ``ErorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupNetworkClassOfServiceModifyDefaultRequest(OCIRequest):
    """
    Modifies the default Network Classes of Service of a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_class_of_service",
            "networkClassOfService",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* networkClassOfService
    network_class_of_service = Field(
        type=str,
        required=True,
    )


class GroupNetworkClassOfServiceUnassignListRequest(OCIRequest):
    """
    Unassign a list of Network Classes of Service from a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_class_of_service",
            "networkClassOfService",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "default_network_class_of_service",
            "defaultNetworkClassOfService",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* networkClassOfService  *Array*
    network_class_of_service = Field(
        type=list,
        required=False,
    )
    #: str: *Optional* defaultNetworkClassOfService
    default_network_class_of_service = Field(
        type=str,
        required=False,
    )


class GroupNewUserTemplateAssignUserServiceListRequest(OCIRequest):
    """
    Request to assign the user services and service packs to all new users created
    within the group
    after the completion of this request.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_name",
            "serviceName",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "service_pack_name",
            "servicePackName",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* serviceName  *Array*
    service_name = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(
        type=list,
        required=False,
    )


class GroupNewUserTemplateUnassignUserServiceListRequest(OCIRequest):
    """
    Requests to unassign the user services and service packs for all new users
    created within the group
    after the completion of this request.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_name",
            "serviceName",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "service_pack_name",
            "servicePackName",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* serviceName  *Array*
    service_name = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(
        type=list,
        required=False,
    )


class GroupOfficeZoneAssignListRequest(OCIRequest):
    """
    Assign a list of Office Zones to a group.
    The Element defaultOfficeZone is required only for the first assignment, for
    subsequent assignments it is optional.
    Office Zones can only be assigned if the Location-Based Calling Restrictions has
    been authorized to the group otherwise the request will fail.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "office_zone_name",
            "officeZoneName",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "default_office_zone_name",
            "defaultOfficeZoneName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* officeZoneName  *Array*
    office_zone_name = Field(
        type=list,
        required=False,
    )
    #: str: *Optional* defaultOfficeZoneName
    default_office_zone_name = Field(
        type=str,
        required=False,
    )


class GroupOfficeZoneGetAssignedListRequest(OCIRequest):
    """
    Get a list of Office Zones assigned to a group.
    The response is either a ``GroupOfficeZoneGetAssignedListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupOfficeZoneUnassignListRequest(OCIRequest):
    """
    Unassign a list of OfficeZones from a group.  Note: a new default must be
    provided if unassigning the current default.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "office_zone_name",
            "officeZoneName",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "default_office_zone_name",
            "defaultOfficeZoneName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* officeZoneName  *Array*
    office_zone_name = Field(
        type=list,
        required=False,
    )
    #: str: *Optional* defaultOfficeZoneName
    default_office_zone_name = Field(
        type=str,
        required=False,
    )


class GroupOutgoingCallingPlanAuthorizationCodeGetListRequest(OCIRequest):
    """
    Request the list of authorization codes for a group default and it's departments.
    The response is either a ``GroupOutgoingCallingPlanAuthorizationCodeGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupOutgoingCallingPlanCallMeNowGetListRequest(OCIRequest):
    """
    Request the Call Me Now call permissions for a group default and it's departments.
    The response is either a ``GroupOutgoingCallingPlanCallMeNowGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupOutgoingCallingPlanDigitPlanCallMeNowGetListRequest(OCIRequest):
    """
    Request the Call Me Now call permissions for digit patterns for a group default
    and it's departments.
    The response is either a ``GroupOutgoingCallingPlanDigitPlanCallMeNowGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupOutgoingCallingPlanDigitPlanOriginatingGetListRequest(OCIRequest):
    """
    Request the originating permissions for digit patterns for a group default and
    it's departments.
    The response is either a ``GroupOutgoingCallingPlanDigitPlanOriginatingGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupOutgoingCallingPlanDigitPlanRedirectingGetListRequest(OCIRequest):
    """
    Request the redirecting permissions for digit patterns for a group default and
    it's departments.
    The response is either a ``GroupOutgoingCallingPlanDigitPlanRedirectingGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupOutgoingCallingPlanOriginatingGetListRequest(OCIRequest):
    """
    Request the originating permissions for a group default and it's departments.
    The response is either a ``GroupOutgoingCallingPlanOriginatingGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupOutgoingCallingPlanPinholeDigitPatternAddRequest(OCIRequest):
    """
    Add a new calling plan Pinhole digit string.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern",
            "digitPattern",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* digitPattern
    digit_pattern = Field(
        type=str,
        required=True,
    )


class GroupOutgoingCallingPlanPinholeDigitPatternDeleteListRequest(OCIRequest):
    """
    Delete one or more calling plan Pinhole digit strings.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupOutgoingCallingPlanPinholeDigitPatternGetListRequest(OCIRequest):
    """
    Get the list of calling plan Pinhole digit strings for a group.
    The response is either a ``GroupOutgoingCallingPlanPinholeDigitPatternGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupOutgoingCallingPlanPinholeDigitPatternModifyRequest(OCIRequest):
    """
    Modify a calling plan Pinhole digit string. The name is a key; it cannot be changed.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern",
            "digitPattern",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* digitPattern
    digit_pattern = Field(
        type=str,
        required=False,
    )


class GroupOutgoingCallingPlanPinholeDigitPlanCallMeNowGetListRequest(OCIRequest):
    """
    Request the Call Me Now permissions for Pinhole digit patterns for a group
    default and its departments.
    The response is either a ``GroupOutgoingCallingPlanPinholeDigitPlanCallMeNowGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupOutgoingCallingPlanPinholeDigitPlanOriginatingGetListRequest(OCIRequest):
    """
    Request the originating permissions for Pinhole digit patterns for a group
    default and its departments.
    The response is either a ``GroupOutgoingCallingPlanPinholeDigitPlanOriginatingGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupOutgoingCallingPlanPinholeDigitPlanRedirectingGetListRequest(OCIRequest):
    """
    Request the redirecting permissions for Pinhole digit patterns for a group
    default and its departments.
    The response is either a ``GroupOutgoingCallingPlanPinholeDigitPlanRedirectingGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupOutgoingCallingPlanRedirectedGetListRequest(OCIRequest):
    """
    Request the call forwarded/transferred permissions for a group default and it's
    departments.
    The response is either a ``GroupOutgoingCallingPlanRedirectedGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupOutgoingCallingPlanRedirectingGetListRequest(OCIRequest):
    """
    Request the initiating call forwards/transfer permissions for a group default and
    it's departments.
    The response is either a ``GroupOutgoingCallingPlanRedirectingGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupOutgoingCallingPlanTransferNumbersGetListRequest(OCIRequest):
    """
    Request the list of transfer numbers for a group default and it's departments.
    The response is either a ``GroupOutgoingCallingPlanTransferNumbersGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupPasswordRulesGetRequest(OCIRequest):
    """
    Requests the group's password rules setting that is applicable to
    users within the group.
    The response is either ``GroupPasswordRulesGetResponse()`` or ``ErrorResponse()``.
    Repleced by: ``GroupPasswordRulesGetRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupPasswordRulesGetRequest16(OCIRequest):
    """
    Requests the group's password rules setting that is applicable to
    users within the group.
    The response is either ``GroupPasswordRulesGetResponse16()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupPasswordRulesModifyRequest(OCIRequest):
    """
    Request to modify the group's password rules setting that apply to the
    users within the group. The response is either ``SuccessResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_user_id",
            "disallowUserId",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_old_password",
            "disallowOldPassword",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_reversed_old_password",
            "disallowReversedOldPassword",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "restrict_min_digits",
            "restrictMinDigits",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "min_digits",
            "minDigits",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "restrict_min_upper_case_letters",
            "restrictMinUpperCaseLetters",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "min_upper_case_letters",
            "minUpperCaseLetters",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "restrict_min_lower_case_letters",
            "restrictMinLowerCaseLetters",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "min_lower_case_letters",
            "minLowerCaseLetters",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "min_non_alphanumeric_characters",
            "minNonAlphanumericCharacters",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "min_length",
            "minLength",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_failed_login_attempts",
            "maxFailedLoginAttempts",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "password_expires_days",
            "passwordExpiresDays",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "send_login_disabled_notify_email",
            "sendLoginDisabledNotifyEmail",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "login_disabled_notify_email_address",
            "loginDisabledNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_previous_passwords",
            "disallowPreviousPasswords",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_of_previous_passwords",
            "numberOfPreviousPasswords",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* disallowUserId
    disallow_user_id = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* disallowOldPassword
    disallow_old_password = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* disallowReversedOldPassword
    disallow_reversed_old_password = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* restrictMinDigits
    restrict_min_digits = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* minDigits
    min_digits = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* minUpperCaseLetters
    min_upper_case_letters = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* minLowerCaseLetters
    min_lower_case_letters = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* minLength
    min_length = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* passwordExpiresDays
    password_expires_days = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* disallowPreviousPasswords
    disallow_previous_passwords = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* numberOfPreviousPasswords
    number_of_previous_passwords = Field(
        type=int,
        required=False,
    )


class GroupPolicyGetRequest(OCIRequest):
    """
    Requests the Group's policy settings.
    The response is either ``GroupPolicyGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupPolicyGetRequest14sp1(OCIRequest):
    """
    Requests the Group's policy settings.
    The response is either ``GroupPolicyGetResponse14sp1()`` or ``ErrorResponse()``.
    Replaced By : ``GroupPolicyGetRequest14sp4()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupPolicyGetRequest14sp4(OCIRequest):
    """
    Requests the Group's policy settings.
    The response is either ``GroupPolicyGetResponse14sp4()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupPolicyGetRequest17(OCIRequest):
    """
    Requests the Group's policy settings.
    The response is either ``GroupPolicyGetResponse17()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupPolicyGetRequest20(OCIRequest):
    """
    Requests the Group's policy settings.
    The response is either ``GroupPolicyGetResponse20()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupPolicyModifyRequest(OCIRequest):
    """
    Request to modify the policies for a Group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_plan_access",
            "callingPlanAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension_access",
            "extensionAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "ldap_integration_access",
            "ldapIntegrationAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "voice_messaging_access",
            "voiceMessagingAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department_admin_user_access",
            "departmentAdminUserAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department_admin_trunk_group_access",
            "departmentAdminTrunkGroupAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department_admin_phone_number_extension_access",
            "departmentAdminPhoneNumberExtensionAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department_admin_calling_line_id_number_access",
            "departmentAdminCallingLineIdNumberAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_authentication_access",
            "userAuthenticationAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_group_directory_access",
            "userGroupDirectoryAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_profile_access",
            "userProfileAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_enhanced_call_log_access",
            "userEnhancedCallLogAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_auto_attendant_name_dialing_access",
            "userAutoAttendantNameDialingAccess",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* callingPlanAccess
    calling_plan_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extensionAccess
    extension_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* ldapIntegrationAccess
    ldap_integration_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* voiceMessagingAccess
    voice_messaging_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* departmentAdminUserAccess
    department_admin_user_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* departmentAdminTrunkGroupAccess
    department_admin_trunk_group_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* departmentAdminPhoneNumberExtensionAccess
    department_admin_phone_number_extension_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* departmentAdminCallingLineIdNumberAccess
    department_admin_calling_line_id_number_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userAuthenticationAccess
    user_authentication_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userGroupDirectoryAccess
    user_group_directory_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userProfileAccess
    user_profile_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userEnhancedCallLogAccess
    user_enhanced_call_log_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userAutoAttendantNameDialingAccess
    user_auto_attendant_name_dialing_access = Field(
        type=str,
        required=False,
    )


class GroupPolycomPhoneServicesGetRequest(OCIRequest):
    """
    Request the group's Polycom Phone Services attributes.
    The response is either a ``GroupPolycomPhoneServicesGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupPolycomPhoneServicesModifyRequest(OCIRequest):
    """
    Modify the group's Polycom Phone Services attributes.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_group_common_phone_list_in_directory",
            "includeGroupCommonPhoneListInDirectory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_group_custom_contact_directory_in_directory",
            "includeGroupCustomContactDirectoryInDirectory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "group_custom_contact_directory",
            "groupCustomContactDirectory",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* includeGroupCommonPhoneListInDirectory
    include_group_common_phone_list_in_directory = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* includeGroupCustomContactDirectoryInDirectory
    include_group_custom_contact_directory_in_directory = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* groupCustomContactDirectory
    group_custom_contact_directory = Field(
        type=str,
        required=False,
    )


class GroupPortalPasscodeRulesGetRequest(OCIRequest):
    """
    Requests the group's passcode rules setting.
    The response is either ``GroupPortalPasscodeRulesGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupPortalPasscodeRulesGetRequest19(OCIRequest):
    """
    Requests the group's passcode rules setting.
    The response is either ``GroupPortalPasscodeRulesGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupPortalPasscodeRulesModifyRequest(OCIRequest):
    """
    Request to modify the group's passcode rules setting.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    The following elements are only used in AS data mode:
    numberOfRepeatedDigits
    disallowRepeatedPatterns
    disallowContiguousSequences
    numberOfAscendingDigits
    numberOfDescendingDigits
    numberOfPreviousPasscodes
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_rule_level",
            "useRuleLevel",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_repeated_digits",
            "disallowRepeatedDigits",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_of_repeated_digits",
            "numberOfRepeatedDigits",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_repeated_patterns",
            "disallowRepeatedPatterns",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_contiguous_sequences",
            "disallowContiguousSequences",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_of_ascending_digits",
            "numberOfAscendingDigits",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_of_descending_digits",
            "numberOfDescendingDigits",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_user_number",
            "disallowUserNumber",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_reversed_user_number",
            "disallowReversedUserNumber",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_old_passcode",
            "disallowOldPasscode",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_of_previous_passcodes",
            "numberOfPreviousPasscodes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_reversed_old_passcode",
            "disallowReversedOldPasscode",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "min_code_length",
            "minCodeLength",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_code_length",
            "maxCodeLength",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_failed_login_attempts",
            "maxFailedLoginAttempts",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "expire_password",
            "expirePassword",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "passcode_expires_days",
            "passcodeExpiresDays",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "send_login_disabled_notify_email",
            "sendLoginDisabledNotifyEmail",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "login_disabled_notify_email_address",
            "loginDisabledNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* useRuleLevel
    use_rule_level = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* disallowRepeatedDigits
    disallow_repeated_digits = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* numberOfRepeatedDigits
    number_of_repeated_digits = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* disallowRepeatedPatterns
    disallow_repeated_patterns = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* disallowContiguousSequences
    disallow_contiguous_sequences = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* numberOfAscendingDigits
    number_of_ascending_digits = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* numberOfDescendingDigits
    number_of_descending_digits = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* disallowUserNumber
    disallow_user_number = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* disallowReversedUserNumber
    disallow_reversed_user_number = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* disallowOldPasscode
    disallow_old_passcode = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* numberOfPreviousPasscodes
    number_of_previous_passcodes = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* minCodeLength
    min_code_length = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxCodeLength
    max_code_length = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* expirePassword
    expire_password = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(
        type=str,
        required=False,
    )


class GroupPreAlertingAnnouncementGetRequest(OCIRequest):
    """
    Get the group�s PreAlertingservice settings.
    The response is either a ``GroupPreAlertingAnnouncementGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupPreAlertingAnnouncementGetRequest20(OCIRequest):
    """
    Get the group’s PreAlertingservice settings.
    The response is either a ``GroupPreAlertingAnnouncementGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupPreferredCarrierGroupGetRequest(OCIRequest):
    """
    Requests the currently configured carriers for a group.
    The response is either a ``GroupPreferredCarrierGroupGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupRouteListEnterpriseTrunkNumberRangeAssignListRequest(OCIRequest):
    """
    Assign a list of service provider number ranges to a group.
    The number ranges must have previously been added to the service provider.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_range_start",
            "numberRangeStart",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* numberRangeStart  *Array*
    number_range_start = Field(
        type=list,
        required=False,
    )


class GroupRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest(OCIRequest):
    """
    Request a list of number ranges that are assigned to a group and still available
    for assignment to users within the group.
    The response is either ``GroupRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest(OCIRequest):
    """
    Get the list of assigned and unassigned enterprise trunknumber ranges in a group.
    The response is either ``GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupRouteListEnterpriseTrunkNumberRangeUnassignListRequest(OCIRequest):
    """
    Unassign a list of service provider number ranges from a group. The number ranges
    then become available for assignment to other groups.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_range_start",
            "numberRangeStart",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* numberRangeStart  *Array*
    number_range_start = Field(
        type=list,
        required=False,
    )


class GroupRoutePointBouncedCallGetRequest(OCIRequest):
    """
    Get a route point's bounced call settings.
    The response is either a ``GroupRoutePointBouncedCallGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointBouncedCallModifyRequest(OCIRequest):
    """
    Modify a route point's bounced call settings.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_of_rings_before_bouncing_call",
            "numberOfRingsBeforeBouncingCall",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_transfer",
            "enableTransfer",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "transfer_phone_number",
            "transferPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "bounce_call_when_agent_unavailable",
            "bounceCallWhenAgentUnavailable",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* isActive
    is_active = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* numberOfRingsBeforeBouncingCall
    number_of_rings_before_bouncing_call = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* enableTransfer
    enable_transfer = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* bounceCallWhenAgentUnavailable
    bounce_call_when_agent_unavailable = Field(
        type=bool,
        required=False,
    )


class GroupRoutePointDeleteInstanceRequest(OCIRequest):
    """
    Delete a Route Point instance from a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointDistinctiveRingingGetRequest(OCIRequest):
    """
    Get the distinctive ringing configuration values for route point.
    The response is either a ``GroupRoutePointDistinctiveRingingGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointDistinctiveRingingModifyRequest(OCIRequest):
    """
    Modify the distinctive ringing configuration values for route point.

    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_distinctive_ringing",
            "enableDistinctiveRinging",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "distinctive_ringing_ring_pattern",
            "distinctiveRingingRingPattern",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* enableDistinctiveRinging
    enable_distinctive_ringing = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* distinctiveRingingRingPattern
    distinctive_ringing_ring_pattern = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* distinctiveRingingForceDeliveryRingPattern
    distinctive_ringing_force_delivery_ring_pattern = Field(
        type=str,
        required=False,
    )


class GroupRoutePointExternalSystemAssignListRequest(OCIRequest):
    """
    Assign a list of route point external systems to a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_point_external_system",
            "routePointExternalSystem",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* routePointExternalSystem  *Array*
    route_point_external_system = Field(
        type=list,
        required=False,
    )


class GroupRoutePointExternalSystemGetAssignedListRequest(OCIRequest):
    """
    Requests the list of all Route Point External Systems assigned to a group.
    The response is either ``GroupRoutePointExternalSystemGetAssignedListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointExternalSystemUnassignListRequest(OCIRequest):
    """
    Unassign a list of route point external systems from a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_point_external_system",
            "routePointExternalSystem",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* routePointExternalSystem  *Array*
    route_point_external_system = Field(
        type=list,
        required=False,
    )


class GroupRoutePointForcedForwardingGetRequest(OCIRequest):
    """
    Get a route point's forced forwarding settings.
    The response is either a ``GroupRoutePointForcedForwardingGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointForcedForwardingGetRequest20(OCIRequest):
    """
    Get a route point's forced forwarding settings.
    The response is either a ``GroupRoutePointForcedForwardingGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointGetAnnouncementRequest(OCIRequest):
    """
    Get a route point's announcement settings.
    The response is either a ``GroupRoutePointGetAnnouncementResponse()`` or an
    ``ErrorResponse()``.

    Replaced By ``GroupRoutePointGetAnnouncementRequest19()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointGetAnnouncementRequest19(OCIRequest):
    """
    Get a route point's announcement settings.
    The response is either a ``GroupRoutePointGetAnnouncementResponse19()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointGetAnnouncementRequest20(OCIRequest):
    """
    Get a route point's announcement settings.
    The response is either a ``GroupRoutePointGetAnnouncementResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointGetDNISListRequest(OCIRequest):
    """
    Get a list of DNIS that are configured for a Route Point.
    The response is either ``GroupRoutePointGetDNISListResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointGetFailoverPolicyRequest(OCIRequest):
    """
    Get the route point failover policy.
    The response is either a ``GroupRoutePointGetFailoverPolicyResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a Route Point instance.
    The response is either ``GroupRoutePointGetInstanceResponse()`` or ``ErrorResponse()``.

    Replaced By ``GroupRoutePointGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a Route Point instance.
    The response is either ``GroupRoutePointGetInstanceResponse19sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointHolidayServiceGetRequest(OCIRequest):
    """
    Get a route point's holiday service settings.
    The response is either a ``GroupRoutePointHolidayServiceGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointHolidayServiceGetRequest17sp1(OCIRequest):
    """
    Get a route point's holiday service settings.
    The response is either a ``GroupRoutePointHolidayServiceGetResponse17sp1()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointHolidayServiceGetRequest20(OCIRequest):
    """
    Get a route point's holiday service settings.
    The response is either a ``GroupRoutePointHolidayServiceGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointManualFailoverRequest(OCIRequest):
    """
    Initiate manual failover for the Route Point.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointModifyDNISParametersRequest(OCIRequest):
    """
    Modify the setting that are configured for all the DNIS in a Route Point.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "display_dnis_number",
            "displayDNISNumber",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "display_dnis_name",
            "displayDNISName",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* displayDNISNumber
    display_dnis_number = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* displayDNISName
    display_dnis_name = Field(
        type=bool,
        required=False,
    )


class GroupRoutePointModifyFailoverPolicyRequest(OCIRequest):
    """
    Modify the route point failover policy.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_failover_support",
            "enableFailoverSupport",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "external_system",
            "externalSystem",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "failover_phone_number",
            "failoverPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "per_call_enable_failover_support",
            "perCallEnableFailoverSupport",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "per_call_call_failure_timeout_seconds",
            "perCallCallFailureTimeoutSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "per_call_outbound_call_failure_timeout_seconds",
            "perCallOutboundCallFailureTimeoutSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "per_call_failover_phone_number",
            "perCallFailoverPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* enableFailoverSupport
    enable_failover_support = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* externalSystem
    external_system = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* failoverPhoneNumber
    failover_phone_number = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* perCallEnableFailoverSupport
    per_call_enable_failover_support = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* perCallCallFailureTimeoutSeconds
    per_call_call_failure_timeout_seconds = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* perCallOutboundCallFailureTimeoutSeconds
    per_call_outbound_call_failure_timeout_seconds = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* perCallFailoverPhoneNumber
    per_call_failover_phone_number = Field(
        type=str,
        required=False,
    )


class GroupRoutePointNightServiceGetRequest(OCIRequest):
    """
    Get a route point's night service settings.
    The response is either a ``GroupRoutePointNightServiceGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointNightServiceGetRequest17sp1(OCIRequest):
    """
    Get a route point's night service settings.
    The response is either a ``GroupRoutePointNightServiceGetResponse17sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointNightServiceGetRequest20(OCIRequest):
    """
    Get a route point's night service settings.
    The response is either a ``GroupRoutePointNightServiceGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointOverflowGetRequest(OCIRequest):
    """
    Get a route point's overflow settings.
    The response is either a ``GroupRoutePointOverflowGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointOverflowGetRequest20(OCIRequest):
    """
    Get a route point's overflow settings.
    The response is either a ``GroupRoutePointOverflowGetResponse20()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointQueueCallDispositionCodeAddRequest(OCIRequest):
    """
    Add a Route Point Call Disposition Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class GroupRoutePointQueueCallDispositionCodeDeleteRequest(OCIRequest):
    """
    Delete a Route Point Call Disposition Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )


class GroupRoutePointQueueCallDispositionCodeGetListRequest(OCIRequest):
    """
    Get the list of Route Point Level and Organization Level Call Disposition Codes.
    The response is either ``GroupRoutePointQueueCallDispositionCodeGetListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutePointQueueCallDispositionCodeGetRequest(OCIRequest):
    """
    Get a Route Point Call Disposition Code.
    The response is either ``GroupRoutePointQueueCallDispositionCodeGetResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )


class GroupRoutePointQueueCallDispositionCodeModifyRequest(OCIRequest):
    """
    Modify a Route Point Call Disposition Code.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "code",
            "code",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* code
    code = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* isActive
    is_active = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class GroupRoutePointQueueCallDispositionCodeSettingsGetRequest(OCIRequest):
    """
    Request the queue level data associated with Route Point Call Disposition Code Settings.
    The response is either an ``GroupRoutePointQueueCallDispositionCodeSettingsGetResponse()``
    or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupRoutingProfileGetRequest(OCIRequest):
    """
    Request the routing profile for the group.
    The response is either a ``GroupRoutingProfileGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupRoutingProfileModifyRequest(OCIRequest):
    """
    Requests to modify the routing profile for a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "routing_profile",
            "routingProfile",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* routingProfile
    routing_profile = Field(
        type=str,
        required=False,
    )


class GroupScheduleAddRequest(OCIRequest):
    """
    Add a group schedule.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "schedule_name",
            "scheduleName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "schedule_type",
            "scheduleType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* scheduleName
    schedule_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* scheduleType
    schedule_type = Field(
        type=str,
        required=True,
    )


class GroupScheduleGetListRequest(OCIRequest):
    """
    Get the list of a group schedules. The list can be filtered by schedule type.
    The response is either a ``GroupScheduleGetListResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "schedule_type",
            "scheduleType",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* scheduleType
    schedule_type = Field(
        type=str,
        required=False,
    )


class GroupScheduleGetListRequest17sp1(OCIRequest):
    """
    Get the list of schedules viewable by a group. The list can be filtered by schedule type.
    The response is either a ``GroupScheduleGetListResponse17sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "schedule_type",
            "scheduleType",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* scheduleType
    schedule_type = Field(
        type=str,
        required=False,
    )


class GroupSeriesCompletionAddInstanceRequest(OCIRequest):
    """
    Adds a Series Completion group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* userId  *Array*
    user_id = Field(
        type=list,
        required=False,
    )


class GroupSeriesCompletionDeleteInstanceRequest(OCIRequest):
    """
    Deletes a Series Completion group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupSeriesCompletionGetInstanceListRequest(OCIRequest):
    """
    Request to get a list of Series Completion instances within a group.
    The response is either ``GroupSeriesCompletionGetInstanceListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupSeriesCompletionGetInstanceRequest(OCIRequest):
    """
    Gets a Series Completion group.
    The response is either ``GroupSeriesCompletionGetInstanceResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupServiceAssignListRequest(OCIRequest):
    """
    Assign one or more group services to the group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_name",
            "serviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceName
    service_name = Field(
        type=str,
        required=True,
    )


class GroupServiceGetAuthorizationListRequest(OCIRequest):
    """
    Requests the group's service authorization status.
    The response is either ``GroupServiceGetAuthorizationListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupServiceGetAuthorizedListRequest(OCIRequest):
    """
    Requests the list of services and service packs authorized to a group.
    The response is either ``GroupServiceGetAuthorizedListResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupServiceInstancePrivacyGetRequest(OCIRequest):
    """
    Request the data associated with Privacy for a service instance.
    The response is either a ``GroupServiceInstancePrivacyGetResponse()``.
    Replaced By ``GroupServiceInstancePrivacyGetRequest17sp4()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupServiceInstancePrivacyGetRequest17sp4(OCIRequest):
    """
    Request the data associated with Privacy for a service instance.
    The response is either a ``GroupServiceInstancePrivacyGetResponse17sp4()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupServiceInstancePrivacyModifyRequest(OCIRequest):
    """
    Modify the data associated with Privacy for a service instance.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_directory_privacy",
            "enableDirectoryPrivacy",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_auto_attendant_extension_dialing_privacy",
            "enableAutoAttendantExtensionDialingPrivacy",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_auto_attendant_name_dialing_privacy",
            "enableAutoAttendantNameDialingPrivacy",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* enableDirectoryPrivacy
    enable_directory_privacy = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableAutoAttendantExtensionDialingPrivacy
    enable_auto_attendant_extension_dialing_privacy = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableAutoAttendantNameDialingPrivacy
    enable_auto_attendant_name_dialing_privacy = Field(
        type=bool,
        required=False,
    )


class GroupServiceIsAssignedRequest(OCIRequest):
    """
    Request to determine if a GroupService is assigned to the group.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_name",
            "serviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceName
    service_name = Field(
        type=str,
        required=True,
    )


class GroupServicePhoneNumberLookupRequest(OCIRequest):
    """
    Lookup if the given number is defined in the specified service in the group.
    The response is ``GroupServicePhoneNumberLookupResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_type",
            "serviceType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceType
    service_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )


class GroupServiceScriptsGroupClearLogRequest(OCIRequest):
    """
    Clear the Service Script Group Log.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupServiceScriptsGroupGetLogRequest(OCIRequest):
    """
    Request the group level data associated with Service Scripts Group Log.
    The response is either a ``GroupServiceScriptsGroupGetLogResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupServiceScriptsGroupGetRequest(OCIRequest):
    """
    Request the group level data associated with Service Scripts Group Configuration.
    The response is either a ``GroupServiceScriptsGroupGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupServiceUnassignListRequest(OCIRequest):
    """
    Unassign one or more of the group's assigned services.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_name",
            "serviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceName
    service_name = Field(
        type=str,
        required=True,
    )


class GroupSessionAdmissionControlGetRequest(OCIRequest):
    """
    Get the session admission control capacity for the group.
    The response is either a ``GroupSessionAdmissionControlGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupSessionAdmissionControlGroupDeleteListRequest(OCIRequest):
    """
    Request to delete one or more session admission control groups for the group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupSessionAdmissionControlGroupGetListRequest(OCIRequest):
    """
    Request to get the list of session admission control group for the group.
    The response is either a ``GroupSessionAdmissionControlGroupGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupSessionAdmissionControlGroupGetRequest(OCIRequest):
    """
    Request to get a session admission control group for the group.
    The response is either a ``GroupSessionAdmissionControlGroupGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupSessionAdmissionControlGroupGetRequest19sp1(OCIRequest):
    """
    Request to get a session admission control group for the group.
    The response is either a ``GroupSessionAdmissionControlGroupGetResponse19sp1()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class GroupSessionAdmissionControlModifyRequest(OCIRequest):
    """
    Request to modify session admission control capacity for the group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_aggregate_sessions",
            "restrictAggregateSessions",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_sessions",
            "maxSessions",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_user_originating_sessions",
            "maxUserOriginatingSessions",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_user_terminating_sessions",
            "maxUserTerminatingSessions",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "count_intra_group_sessions",
            "countIntraGroupSessions",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* restrictAggregateSessions
    restrict_aggregate_sessions = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxSessions
    max_sessions = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxUserOriginatingSessions
    max_user_originating_sessions = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxUserTerminatingSessions
    max_user_terminating_sessions = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* countIntraGroupSessions
    count_intra_group_sessions = Field(
        type=bool,
        required=False,
    )


class GroupShInterfaceGetUserListRequest(OCIRequest):
    """
    Returns a list of all Public User Identities and associated data in a group.
    The response is either a ``GroupShInterfaceGetUserListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupSpeedDial100GetRequest(OCIRequest):
    """
    Get the speed dial 100 service settings for a group.
    The response is either a ``GroupSpeedDial100GetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupSpeedDial100GetRequest17sp1(OCIRequest):
    """
    Get the speed dial 100 service settings for a group.
    The response is either a ``GroupSpeedDial100GetResponse17sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupSpeedDial100ModifyRequest(OCIRequest):
    """
    Modify the speed dial 100 prefix setting for a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "prefix",
            "prefix",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* prefix
    prefix = Field(
        type=str,
        required=False,
    )


class GroupThirdPartyVoiceMailSupportGetRequest(OCIRequest):
    """
    Request the group level data associated with Third-Party Voice Mail Support.
    The response is either a ``GroupThirdPartyVoiceMailSupportGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupThirdPartyVoiceMailSupportModifyRequest(OCIRequest):
    """
    Modify the Third Party Voice Mail Support settings for a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "group_server",
            "groupServer",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* isActive
    is_active = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* groupServer
    group_server = Field(
        type=str,
        required=False,
    )


class GroupTimeScheduleDeleteRequest(OCIRequest):
    """
    Delete a time schedule from a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "time_schedule_name",
            "timeScheduleName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* timeScheduleName
    time_schedule_name = Field(
        type=str,
        required=True,
    )


class GroupTimeScheduleGetListRequest(OCIRequest):
    """
    Request a list of all time schedules in a group.
    The response is either a ``GroupTimeScheduleGetListResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupTimeScheduleGetRequest(OCIRequest):
    """
    Request to get a group time schedule.
    The response is either a ``GroupTimeScheduleGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "time_schedule_name",
            "timeScheduleName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* timeScheduleName
    time_schedule_name = Field(
        type=str,
        required=True,
    )


class GroupTrunkGroupDeleteInstanceRequest(OCIRequest):
    """
    Delete a Trunk Group Instance from a group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupTrunkGroupGetAvailableDetailListRequest(OCIRequest):
    """
    Requests the list of available trunk groups within a group.
    The response is either ``GroupTrunkGroupGetAvailableDetailListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupTrunkGroupGetInstanceListRequest14(OCIRequest):
    """
    Get a list of Trunk Groups for the group or enterprise.
    It is possible to restrict the results to a particular department, or expand the
    list to the entire enterprise.
    The response is either a ``GroupTrunkGroupGetInstanceListResponse14()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_department_name",
            "groupDepartmentName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_enterprise_trunk_groups",
            "includeEnterpriseTrunkGroups",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "only_trunk_groups_with_device",
            "onlyTrunkGroupsWithDevice",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* includeEnterpriseTrunkGroups
    include_enterprise_trunk_groups = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* onlyTrunkGroupsWithDevice
    only_trunk_groups_with_device = Field(
        type=bool,
        required=False,
    )


class GroupTrunkGroupGetInstanceListRequest14sp4(OCIRequest):
    """
    Get a list of Trunk Groups for the group or enterprise.
    It is possible to restrict the results to a particular department, or expand the
    list to the entire enterprise.
    The response is either a ``GroupTrunkGroupGetInstanceListResponse14sp4()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_department_name",
            "groupDepartmentName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_enterprise_trunk_groups",
            "includeEnterpriseTrunkGroups",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "only_trunk_groups_with_device",
            "onlyTrunkGroupsWithDevice",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* includeEnterpriseTrunkGroups
    include_enterprise_trunk_groups = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* onlyTrunkGroupsWithDevice
    only_trunk_groups_with_device = Field(
        type=bool,
        required=False,
    )


class GroupTrunkGroupGetInstanceRequest14(OCIRequest):
    """
    Get a Trunk Group Instance's profile.
    The response is either a ``GroupTrunkGroupGetInstanceResponse14()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupTrunkGroupGetInstanceRequest14sp1(OCIRequest):
    """
    Get a Trunk Group Instance's profile.
    The response is either a ``GroupTrunkGroupGetInstanceResponse14sp1()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupTrunkGroupGetRequest(OCIRequest):
    """
    Get the maximum permissible active trunk group calls for the group.
    The response is either a ``GroupTrunkGroupGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupTrunkGroupGetRequest14sp1(OCIRequest):
    """
    Get the maximum and bursting maximum permissible active trunk group calls for the group.
    The response is either a ``GroupTrunkGroupGetResponse14sp1()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupTrunkGroupGetRequest14sp9(OCIRequest):
    """
    Get the maximum and bursting maximum permissible active trunk group calls for the group.
    The response is either a ``GroupTrunkGroupGetResponse14sp9()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupTrunkGroupUserCreationTaskAddRequest(OCIRequest):
    """
    Add a user creation task for a trunk group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "task_name",
            "taskName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id_format",
            "userIdFormat",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id_domain",
            "userIdDomain",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "populate_extension",
            "populateExtension",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "line_port_format",
            "linePortFormat",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "line_port_domain",
            "linePortDomain",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "populate_contact",
            "populateContact",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact_format",
            "contactFormat",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "contact_domain",
            "contactDomain",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_phone_numbers",
            "userPhoneNumbers",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "user_extensions",
            "userExtensions",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "service_pack_name",
            "servicePackName",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "user_service",
            "userService",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* taskName
    task_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userIdFormat
    user_id_format = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userIdDomain
    user_id_domain = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* populateExtension
    populate_extension = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* linePortFormat
    line_port_format = Field(
        type=str,
        required=True,
    )
    #: str: *Required* linePortDomain
    line_port_domain = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* populateContact
    populate_contact = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* contactFormat
    contact_format = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* contactDomain
    contact_domain = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userPhoneNumbers
    user_phone_numbers = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userExtensions
    user_extensions = Field(
        type=str,
        required=False,
    )
    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* userService  *Array*
    user_service = Field(
        type=list,
        required=False,
    )


class GroupTrunkGroupUserCreationTaskDeleteRequest(OCIRequest):
    """
    Delete a user creation task for a trunk group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "task_name",
            "taskName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* taskName
    task_name = Field(
        type=str,
        required=True,
    )


class GroupTrunkGroupUserCreationTaskGetListRequest(OCIRequest):
    """
    Get the list of user creation tasks for a trunk group.
    The response is either ``GroupTrunkGroupUserCreationTaskGetListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupTrunkGroupUserCreationTaskGetRequest(OCIRequest):
    """
    Request the details of a specified user creation task for a trunk group.
    The response is either ``GroupTrunkGroupUserCreationTaskGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "task_name",
            "taskName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* taskName
    task_name = Field(
        type=str,
        required=True,
    )


class GroupVirtualOnNetEnterpriseExtensionsDeleteUserRequest(OCIRequest):
    """
    Delete an existing Virtual On-Net user from a Group.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )


class GroupVirtualOnNetEnterpriseExtensionsGetUserRequest(OCIRequest):
    """
    Get an existing Virtual On-Net user from a Group.
    The response is either a
    ``GroupVirtualOnNetEnterpriseExtensionsGetUserResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )


class GroupVirtualOnNetEnterpriseExtensionsModifyUserRequest(OCIRequest):
    """
    Modify an existing Virtual On-Net user of a Group.
    The serviceProviderId, groupId and phoneNumber combination uniquely
    identifies a Virtual On-Net User.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "first_name",
            "firstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "last_name",
            "lastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "virtual_on_net_call_type_name",
            "virtualOnNetCallTypeName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumber
    phone_number = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* firstName
    first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* lastName
    last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* virtualOnNetCallTypeName
    virtual_on_net_call_type_name = Field(
        type=str,
        required=False,
    )


class GroupVoiceMessagingGroupGetPasscodeRulesRequest(OCIRequest):
    """
    Requests the group's voice portal passcode rules setting.
    The response is either ``GroupVoiceMessagingGroupGetPasscodeRulesResponse()`` or
    ``ErrorResponse()``.
    Replaced By ``GroupPortalPasscodeRulesGetRequest()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupVoiceMessagingGroupGetRequest(OCIRequest):
    """
    Requests the group's Voice Messaging settings.
    The response is either ``GroupVoiceMessagingGroupGetResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupVoiceMessagingGroupGetVoicePortalBrandingRequest(OCIRequest):
    """
    Get the group's voice portal branding settings.
    The response is either a ``GroupVoiceMessagingGroupGetVoicePortalBrandingResponse()``
    or an ``ErrorResponse()``.
    Replaced By ``GroupVoiceMessagingGroupGetVoicePortalBrandingRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupVoiceMessagingGroupGetVoicePortalBrandingRequest16(OCIRequest):
    """
    Get the group's voice portal branding settings.
    The response is either a ``GroupVoiceMessagingGroupGetVoicePortalBrandingResponse16()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupVoiceMessagingGroupGetVoicePortalBrandingRequest20(OCIRequest):
    """
    Get the group's voice portal branding settings.
    The response is either a ``GroupVoiceMessagingGroupGetVoicePortalBrandingResponse20()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupVoiceMessagingGroupGetVoicePortalRequest14(OCIRequest):
    """
    Requests the group's voice messaging settings
    The response is either ``GroupVoiceMessagingGroupGetVoicePortalResponse14()`` or
    ``ErrorResponse()``.
    Replaced by ``GroupVoiceMessagingGroupGetVoicePortalRequest15()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupVoiceMessagingGroupGetVoicePortalRequest15(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.
    The response is either ``GroupVoiceMessagingGroupGetVoicePortalResponse15()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupVoiceMessagingGroupGetVoicePortalRequest17(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.
    The response is either ``GroupVoiceMessagingGroupGetVoicePortalResponse17()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupVoiceMessagingGroupGetVoicePortalRequest17sp4(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.
    The response is either ``GroupVoiceMessagingGroupGetVoicePortalResponse17sp4()``
    or ``ErrorResponse()``.

    Replaced By ``GroupVoiceMessagingGroupGetVoicePortalRequest19sp1()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupVoiceMessagingGroupGetVoicePortalRequest19sp1(OCIRequest):
    """
    Request to get the group voice portal information for a voice messaging group.
    The response is either ``GroupVoiceMessagingGroupGetVoicePortalResponse19sp1()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )


class GroupVoiceMessagingGroupModifyPasscodeRulesRequest(OCIRequest):
    """
    Request to modify the group's voice portal passcode rules setting.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    Replaced By ``GroupPortalPasscodeRulesModifyRequest()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_rule_level",
            "useRuleLevel",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_repeated_digits",
            "disallowRepeatedDigits",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_user_number",
            "disallowUserNumber",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_reversed_user_number",
            "disallowReversedUserNumber",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_old_passcode",
            "disallowOldPasscode",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_reversed_old_passcode",
            "disallowReversedOldPasscode",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "min_code_length",
            "minCodeLength",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_code_length",
            "maxCodeLength",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_failed_login_attempts",
            "maxFailedLoginAttempts",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "expire_password",
            "expirePassword",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "passcode_expires_days",
            "passcodeExpiresDays",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "send_login_disabled_notify_email",
            "sendLoginDisabledNotifyEmail",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "login_disabled_notify_email_address",
            "loginDisabledNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* useRuleLevel
    use_rule_level = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* disallowRepeatedDigits
    disallow_repeated_digits = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* disallowUserNumber
    disallow_user_number = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* disallowReversedUserNumber
    disallow_reversed_user_number = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* disallowOldPasscode
    disallow_old_passcode = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* minCodeLength
    min_code_length = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxCodeLength
    max_code_length = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* expirePassword
    expire_password = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(
        type=str,
        required=False,
    )


class GroupVoiceMessagingGroupModifyRequest(OCIRequest):
    """
    Request to modify the group's voice messaging settings.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_mail_server_setting",
            "useMailServerSetting",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "warn_caller_before_recording_voice_message",
            "warnCallerBeforeRecordingVoiceMessage",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_users_configuring_advanced_settings",
            "allowUsersConfiguringAdvancedSettings",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_compose_or_forward_message_to_entire_group",
            "allowComposeOrForwardMessageToEntireGroup",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mail_server_net_address",
            "mailServerNetAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "mail_server_protocol",
            "mailServerProtocol",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "real_delete_for_imap",
            "realDeleteForImap",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_mailbox_length_minutes",
            "maxMailboxLengthMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "does_message_age",
            "doesMessageAge",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "hold_period_days",
            "holdPeriodDays",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* useMailServerSetting
    use_mail_server_setting = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* warnCallerBeforeRecordingVoiceMessage
    warn_caller_before_recording_voice_message = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowUsersConfiguringAdvancedSettings
    allow_users_configuring_advanced_settings = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowComposeOrForwardMessageToEntireGroup
    allow_compose_or_forward_message_to_entire_group = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* mailServerNetAddress
    mail_server_net_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* mailServerProtocol
    mail_server_protocol = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* realDeleteForImap
    real_delete_for_imap = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxMailboxLengthMinutes
    max_mailbox_length_minutes = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* doesMessageAge
    does_message_age = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* holdPeriodDays
    hold_period_days = Field(
        type=int,
        required=False,
    )


class GroupVoiceXmlDeleteInstanceRequest(OCIRequest):
    """
    Delete a VoiceXML instance from a group.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupVoiceXmlGetInstanceListRequest(OCIRequest):
    """
    Get a list of VoiceXML instances within a group.
    The response is either ``GroupVoiceXmlGetInstanceListResponse()`` or ``ErrorResponse()``.
    It is possible to get the instances within a specified department.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_department_name",
            "groupDepartmentName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* groupDepartmentName
    group_department_name = Field(
        type=str,
        required=False,
    )


class GroupVoiceXmlGetInstanceRequest(OCIRequest):
    """
    Request to get all the information of a VoiceXML instance.
    The response is either ``GroupVoiceXmlGetInstanceResponse()`` or ``ErrorResponse()``.

    Replaced By ``GroupVoiceXmlGetInstanceRequest19sp1()``
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class GroupVoiceXmlGetInstanceRequest19sp1(OCIRequest):
    """
    Request to get all the information of a VoiceXML instance.
    The response is either ``GroupVoiceXmlGetInstanceResponse19sp1()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceUserId
    service_user_id = Field(
        type=str,
        required=True,
    )


class LoginRequest13mp10(OCIRequest):
    """
    ``LoginRequest13mp10()`` is 2nd stage of the 2 stage OCI login process.
    The signedPassword is not required for external authentication login from a
    trusted host (ACL).
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "signed_password",
            "signedPassword",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* signedPassword
    signed_password = Field(
        type=str,
        required=False,
    )


class LoginRequest14sp4(OCIRequest):
    """
    ``LoginRequest14sp4()`` is 2nd stage of the 2 stage OCI login process.
    The signedPassword is not required for external authentication login from a
    trusted host (ACL).
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "signed_password",
            "signedPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "plain_text_password",
            "plainTextPassword",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* signedPassword
    signed_password = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* plainTextPassword
    plain_text_password = Field(
        type=str,
        required=False,
    )


class LogoutRequest(OCIRequest):
    """
    ``LogoutRequest()`` is sent when an OCI user logs out or when connection is lost.
    This command can be sent either to the server, or to the client from OCS.
    Response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "reason",
            "reason",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* reason
    reason = Field(
        type=str,
        required=False,
    )


class PasswordModifyRequest(OCIRequest):
    """
    Modify the password for a user/administrator.
    When oldPassword is specified, password rule applies. If oldPassword in not specified,
    any password rule related to old password does not apply.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "old_password",
            "oldPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "new_password",
            "newPassword",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* oldPassword
    old_password = Field(
        type=str,
        required=False,
    )
    #: str: *Required* newPassword
    new_password = Field(
        type=str,
        required=True,
    )


class PrimaryInfoGetRequest(OCIRequest):
    """
    Requests information about the primary server for high-availability support.
    """

    _ELEMENTS = (
        E(
            "is_private",
            "isPrivate",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_address_info_requested",
            "isAddressInfoRequested",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isPrivate
    is_private = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isAddressInfoRequested
    is_address_info_requested = Field(
        type=bool,
        required=True,
    )


class PublicClusterGetFullyQualifiedDomainNameRequest(OCIRequest):
    """
    Get the public cluster fully qualified domain name (FQDN).
    The response is either a ``PublicClusterGetFullyQualifiedDomainNameResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class ServiceProviderAccessDeviceCustomTagAddRequest(OCIRequest):
    """
    Request to add a static configuration tag for a service provider access device.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_name",
            "tagName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_value",
            "tagValue",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* tagName
    tag_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* tagValue
    tag_value = Field(
        type=str,
        required=False,
    )


class ServiceProviderAccessDeviceCustomTagDeleteListRequest(OCIRequest):
    """
    Request to delete static configuration tags for a service provider access device.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_name",
            "tagName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* tagName
    tag_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderAccessDeviceCustomTagGetListRequest(OCIRequest):
    """
    Request to get the list of custom configuration tags managed by the Device
    Management System, on a per-device profile basis.
    The response is either ``ServiceProviderAccessDeviceCustomTagGetListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderAccessDeviceCustomTagModifyRequest(OCIRequest):
    """
    Request to modify a static configuration tag for a service provider access device.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_name",
            "tagName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "tag_value",
            "tagValue",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* tagName
    tag_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* tagValue
    tag_value = Field(
        type=str,
        required=False,
    )


class ServiceProviderAccessDeviceDeleteRequest(OCIRequest):
    """
    Request to delete a specified service provider access device.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderAccessDeviceFileGetListRequest(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System,
    on a per-device profile basis.
    The response is either ``ServiceProviderAccessDeviceFileGetListResponse()`` or
    ``ErrorResponse()``.
    Replaced By ``ServiceProviderAccessDeviceFileGetListRequest14sp8()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderAccessDeviceFileGetListRequest14sp8(OCIRequest):
    """
    Request to get the list of device files managed by the Device Management System,
    on a per-device profile basis.
    The response is either ``ServiceProviderAccessDeviceFileGetListResponse14sp8()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderAccessDeviceFileGetRequest(OCIRequest):
    """
    Request to get a service provider device profile file.
    The response is either ``ServiceProviderAccessDeviceFileGetResponse()`` or
    ``ErrorResponse()``.
    Replaced By ``ServiceProviderAccessDeviceFileGetRequest14sp8()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_type",
            "fileType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileType
    file_type = Field(
        type=str,
        required=True,
    )


class ServiceProviderAccessDeviceFileGetRequest14sp8(OCIRequest):
    """
    Request to get a service provider device profile file.
    The response is either ``ServiceProviderAccessDeviceFileGetResponse14sp8()`` or
    ``ErrorResponse()``.
    Replaced By ``ServiceProviderAccessDeviceFileGetRequest16sp1()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_format",
            "fileFormat",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileFormat
    file_format = Field(
        type=str,
        required=True,
    )


class ServiceProviderAccessDeviceFileGetRequest16sp1(OCIRequest):
    """
    Request to get a service provider device profile file.
    The response is either ``ServiceProviderAccessDeviceFileGetResponse16sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_format",
            "fileFormat",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileFormat
    file_format = Field(
        type=str,
        required=True,
    )


class ServiceProviderAccessDeviceFileGetRequest20(OCIRequest):
    """
    Request to get a service provider device profile file.
    The response is either ``ServiceProviderAccessDeviceFileGetResponse20()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_format",
            "fileFormat",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileFormat
    file_format = Field(
        type=str,
        required=True,
    )


class ServiceProviderAccessDeviceGetRequest14(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.
    The response is either ``ServiceProviderAccessDeviceGetResponse14()`` or
    ``ErrorResponse()``.
    Replaced By ``ServiceProviderAccessDeviceGetRequest14sp3()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderAccessDeviceGetRequest14sp3(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.
    The response is either ``ServiceProviderAccessDeviceGetResponse14sp3()`` or
    ``ErrorResponse()``.
    Replaced By ``ServiceProviderAccessDeviceGetRequest14sp6()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderAccessDeviceGetRequest14sp6(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.
    The response is either ``ServiceProviderAccessDeviceGetResponse14sp6()`` or
    ``ErrorResponse()``.
    Replaced By ``ServiceProviderAccessDeviceGetRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderAccessDeviceGetRequest16(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.
    The response is either ``ServiceProviderAccessDeviceGetResponse16()`` or
    ``ErrorResponse()``.

    Replaced By ``ServiceProviderAccessDeviceGetRequest19()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderAccessDeviceGetRequest18sp1(OCIRequest):
    """
    Requests the configuration of a specified service provider access device.
    The response is either ``ServiceProviderAccessDeviceGetResponse18sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderAccessDeviceModifyUserRequest(OCIRequest):
    """
    Request to modify attributes for line/ports assigned on the service provider
    device profile.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    The following elements are only used in HSS data mode and ignored in AS data mode:
    privateIdentity
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "line_port",
            "linePort",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "private_identity",
            "privateIdentity",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "is_primary_line_port",
            "isPrimaryLinePort",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* linePort
    line_port = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* privateIdentity
    private_identity = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* isPrimaryLinePort
    is_primary_line_port = Field(
        type=bool,
        required=False,
    )


class ServiceProviderAccessDeviceResetRequest(OCIRequest):
    """
    Reset a specific service provider SIP device that supports the reset operation.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminAddRequest14(OCIRequest):
    """
    Add a service provider administrator.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "first_name",
            "firstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "last_name",
            "lastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "administrator_type",
            "administratorType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* firstName
    first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* lastName
    last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* password
    password = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )
    #: str: *Required* administratorType
    administrator_type = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminDeleteRequest(OCIRequest):
    """
    Delete a service provider administrator.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminGetListRequest14(OCIRequest):
    """
    Get a list of service provider administrators.
    The response is either a ``ServiceProviderAdminGetListResponse14()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminGetPolicyRequest14(OCIRequest):
    """
    Requests the service provider administrator's policy settings.
    The response is either ``ServiceProviderAdminGetPolicyResponse14()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminGetPolicyRequest16sp1(OCIRequest):
    """
    Requests the service provider administrator's policy settings.
    The response is either ``ServiceProviderAdminGetPolicyResponse16sp1()`` or
    ``ErrorResponse()``.
    Replaced By ``ServiceProviderAdminGetPolicyRequest17()``
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminGetPolicyRequest16sp2(OCIRequest):
    """
    Requests the service provider administrator's policy settings.
    The response is either ``ServiceProviderAdminGetPolicyResponse16sp2()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminGetPolicyRequest17(OCIRequest):
    """
    Requests the service provider administrator's policy settings.
    The response is either ``ServiceProviderAdminGetPolicyResponse17()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminGetPolicyRequest17sp1(OCIRequest):
    """
    Requests the service provider administrator's policy settings.
    The response is either ``ServiceProviderAdminGetPolicyResponse17sp1()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminGetPolicyRequest17sp3(OCIRequest):
    """
    Requests the service provider administrator's policy settings.
    The response is either ``ServiceProviderAdminGetPolicyResponse17sp3()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminGetPolicyRequest18(OCIRequest):
    """
    Requests the service provider administrator's policy settings.
    The response is either ``ServiceProviderAdminGetPolicyResponse18()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminGetPolicyRequest20(OCIRequest):
    """
    Requests the service provider administrator's policy settings.
    The response is either ``ServiceProviderAdminGetPolicyResponse20()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminGetRequest14(OCIRequest):
    """
    Get a service provider administrators profile.
    The response is either a ``ServiceProviderAdminGetResponse14()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminModifyPolicyRequest14(OCIRequest):
    """
    Request to modify the service provider administrator's policy settings.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    The networkPolicyAccess is only modified for the enterprise administrator.
    The following elements are only used in AS data mode:
    dialableCallerIDAccess
    verifyTranslationAndroutingAccess
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "group_access",
            "groupAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_number_access",
            "callingLineIdNumberAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_pack_access",
            "servicePackAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "session_admission_control_access",
            "sessionAdmissionControlAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "web_branding_access",
            "webBrandingAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "office_zone_access",
            "officeZoneAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "communication_barring_access",
            "communicationBarringAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_policy_access",
            "networkPolicyAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_activation_access",
            "numberActivationAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "dialable_caller_id_access",
            "dialableCallerIDAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "verify_translation_and_routing_access",
            "verifyTranslationAndRoutingAccess",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* profileAccess
    profile_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* groupAccess
    group_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* userAccess
    user_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* adminAccess
    admin_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* departmentAccess
    department_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdNumberAccess
    calling_line_id_number_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceAccess
    service_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* servicePackAccess
    service_pack_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* sessionAdmissionControlAccess
    session_admission_control_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* webBrandingAccess
    web_branding_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* officeZoneAccess
    office_zone_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* communicationBarringAccess
    communication_barring_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* numberActivationAccess
    number_activation_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* dialableCallerIDAccess
    dialable_caller_id_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* verifyTranslationAndRoutingAccess
    verify_translation_and_routing_access = Field(
        type=str,
        required=False,
    )


class ServiceProviderAdminModifyRequest(OCIRequest):
    """
    Modify a service provider administrator.
    Since old password is not specified here, any password rule related to old password
    does not apply.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "first_name",
            "firstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "last_name",
            "lastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* firstName
    first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* lastName
    last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* password
    password = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* language
    language = Field(
        type=str,
        required=False,
    )


class ServiceProviderAdviceOfChargeGetRequest(OCIRequest):
    """
    Request to get the list of Advice of Charge service provider parameters.
    The response is either ``ServiceProviderAdviceOfChargeGetResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdviceOfChargeModifyRequest(OCIRequest):
    """
    Modify the service provider level Advice Of Charge service provider settings.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_sp_level_ao_c_settings",
            "useSPLevelAoCSettings",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "delay_between_notification_seconds",
            "delayBetweenNotificationSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* useSPLevelAoCSettings
    use_sp_level_ao_c_settings = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* delayBetweenNotificationSeconds
    delay_between_notification_seconds = Field(
        type=int,
        required=False,
    )


class ServiceProviderAnswerConfirmationGetRequest(OCIRequest):
    """
    Get a service provider or enterprise's answer confirmation settings.
    The response is either a ``ServiceProviderAnswerConfirmationGetResponse()`` or an
    ``ErrorResponse()``.
    Replaced By ``ServiceProviderAnswerConfirmationGetRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderAnswerConfirmationGetRequest16(OCIRequest):
    """
    Get a service provider or enterprise's answer confirmation settings.
    The response is either a ``ServiceProviderAnswerConfirmationGetResponse16()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderApplicationServerSetGetRequest(OCIRequest):
    """
    Get the Application Server set for a service provider or enterprise.
    The response is either a ``ServiceProviderApplicationServerSetGetResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderApplicationServerSetModifyRequest(OCIRequest):
    """
    Modify the Application Server set assigned to the service provider or enterprise.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "application_server_set_name",
            "applicationServerSetName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* applicationServerSetName
    application_server_set_name = Field(
        type=str,
        required=False,
    )


class ServiceProviderBroadWorksCommunicatorGetRequest(OCIRequest):
    """
    Request to get Configuration Server for a specified service
    provider. The response is either
    a ``ServiceProviderBroadWorksCommunicatorGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderBroadWorksCommunicatorModifyRequest(OCIRequest):
    """
    Request to modify the Configuration URL. The response is either a
    ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "configuration_server_url",
            "configurationServerURL",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* configurationServerURL
    configuration_server_url = Field(
        type=str,
        required=False,
    )


class ServiceProviderBroadWorksMobilityGetRequest(OCIRequest):
    """
    Get the service provider BroadWorks Mobility service settings.
    The response is either a ``ServiceProviderBroadWorksMobilityGetResponse()`` or an
    ``ErrorResponse()``.
    Replaced By ``ServiceProviderBroadWorksMobilityGetRequest19sp1()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderBroadWorksMobilityGetRequest19sp1(OCIRequest):
    """
    Get the service provider BroadWorks Mobility service settings.
    The response is either a ``ServiceProviderBroadWorksMobilityGetResponse19sp1()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberAddListRequest(
    OCIRequest,
):
    """
    Adds Mobile Subscriber Directory Numbers to a service provider. It is possible to
    add a single DN,
    or a list of DNs.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.

    Replaced by ``ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberAddListRequest21()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_subscriber_directory_number",
            "mobileSubscriberDirectoryNumber",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* mobileSubscriberDirectoryNumber  *Array*
    mobile_subscriber_directory_number = Field(
        type=list,
        required=False,
    )


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberAddListRequest21(
    OCIRequest,
):
    """
    Adds Mobile Subscriber Directory Numbers to a service provider-mobile network
    combination. It is possible to add a single DN,
    or a list of DNs.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_network_name",
            "mobileNetworkName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_subscriber_directory_number",
            "mobileSubscriberDirectoryNumber",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* mobileNetworkName
    mobile_network_name = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* mobileSubscriberDirectoryNumber  *Array*
    mobile_subscriber_directory_number = Field(
        type=list,
        required=False,
    )


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberDeleteListRequest(
    OCIRequest,
):
    """
    Deletes Mobile Subscriber Directory Numbers from a service provider. It is
    possible to delete either: a single number,
    or a list of numbers.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_subscriber_directory_number",
            "mobileSubscriberDirectoryNumber",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* mobileSubscriberDirectoryNumber  *Array*
    mobile_subscriber_directory_number = Field(
        type=list,
        required=False,
    )


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest(
    OCIRequest,
):
    """
    Request a list of available Mobile Subscriber Directory Numbers not yet assigned
    to any group. This command is applicable only for service providers and will fail
    for enterprises.
    The response is either ``ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse()``
    or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderBroadWorksMobilityModifyRequest(OCIRequest):
    """
    Modify the service provider level BroadWorks Mobility service settings.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_location_services",
            "enableLocationServices",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_msrn_lookup",
            "enableMSRNLookup",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_mobile_state_checking",
            "enableMobileStateChecking",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "deny_call_originations",
            "denyCallOriginations",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "deny_call_terminations",
            "denyCallTerminations",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_announcement_suppression",
            "enableAnnouncementSuppression",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* enableLocationServices
    enable_location_services = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableMSRNLookup
    enable_msrn_lookup = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableMobileStateChecking
    enable_mobile_state_checking = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* denyCallOriginations
    deny_call_originations = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* denyCallTerminations
    deny_call_terminations = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableAnnouncementSuppression
    enable_announcement_suppression = Field(
        type=bool,
        required=False,
    )


class ServiceProviderCPEConfigRebuildDeviceConfigFileRequest(OCIRequest):
    """
    Rebuild the config file for a specified device.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "force",
            "force",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* force
    force = Field(
        type=bool,
        required=False,
    )


class ServiceProviderCPEConfigReorderDeviceLinePortsRequest(OCIRequest):
    """
    Reorder the lines of a Service Provider device. You can not add or delete line ports, only
    re-ordering the list is allowed. The ordered list of line ports can be obtained
    with the ``ServiceProviderAccessDeviceGetRequest()`` command.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "ordered_line_port_list",
            "orderedLinePortList",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* orderedLinePortList
    ordered_line_port_list = Field(
        type=str,
        required=True,
    )


class ServiceProviderCPEConfigResetDeviceRequest(OCIRequest):
    """
    Reset a specific service provider or enterprise device.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_name",
            "deviceName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "force",
            "force",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceName
    device_name = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* force
    force = Field(
        type=bool,
        required=False,
    )


class ServiceProviderCallProcessingGetPolicyRequest14(OCIRequest):
    """
    Request the service provider level data associated with Call Processing
    Policy. The response is either a
    ``ServiceProviderCallProcessingGetPolicyResponse14()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyRequest14sp1(OCIRequest):
    """
    Request the service provider level data associated with Call Processing
    Policy. The response is either a
    ``ServiceProviderCallProcessingGetPolicyResponse14sp1()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyRequest14sp4(OCIRequest):
    """
    Request the service provider level data associated with Call Processing
    Policy. The response is either a
    ``ServiceProviderCallProcessingGetPolicyResponse14sp4()`` or an ``ErrorResponse()``.
    Replaced By : ``ServiceProviderCallProcessingGetPolicyRequest15()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyRequest14sp7(OCIRequest):
    """
    Request the service provider level data associated with Call Processing
    Policy. The response is either a
    ``ServiceProviderCallProcessingGetPolicyResponse14sp7()`` or an ``ErrorResponse()``.

    Replaced By ``ServiceProviderCallProcessingGetPolicyRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyRequest15(OCIRequest):
    """
    Request the service provider level data associated with Call Processing
    Policy. The response is either a
    ``ServiceProviderCallProcessingGetPolicyResponse15()`` or an ``ErrorResponse()``.

    Replaced By ``ServiceProviderCallProcessingGetPolicyRequest16()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyRequest15sp2(OCIRequest):
    """
    Request the service provider level data associated with Call Processing
    Policy. The response is either a
    ``ServiceProviderCallProcessingGetPolicyResponse15sp2()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyRequest16(OCIRequest):
    """
    Request the service provider level data associated with Call Processing
    Policy. The response is either a
    ``ServiceProviderCallProcessingGetPolicyResponse16()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyRequest16sp2(OCIRequest):
    """
    Request the service provider level data associated with Call Processing
    Policy. The response is either a
    ``ServiceProviderCallProcessingGetPolicyResponse16sp2()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyRequest17(OCIRequest):
    """
    Request the service provider level data associated with Call Processing
    Policy. The response is either a
    ``ServiceProviderCallProcessingGetPolicyResponse17()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyRequest17sp3(OCIRequest):
    """
    Request the service provider level data associated with Call Processing
    Policy. The response is either a
    ``ServiceProviderCallProcessingGetPolicyResponse17sp3()`` or an ``ErrorResponse()``.

    Replaced by ``ServiceProviderCallProcessingGetPolicyResponse17sp4()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyRequest17sp4(OCIRequest):
    """
    Request the service provider level data associated with Call Processing
    Policy. The response is either a
    ``ServiceProviderCallProcessingGetPolicyResponse17sp4()`` or an ``ErrorResponse()``.
    Replaced By : ``ServiceProviderCallProcessingGetPolicyRequest18sp1()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyRequest18sp1(OCIRequest):
    """
    Request the service provider level data associated with Call Processing
    Policy. The response is either a
    ``ServiceProviderCallProcessingGetPolicyResponse18sp1()`` or an ``ErrorResponse()``.

    Replaced By ``ServiceProviderCallProcessingGetPolicyRequest19sp1()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyRequest19sp1(OCIRequest):
    """
    Request the service provider level data associated with Call Processing
    Policy. The response is either a
    ``ServiceProviderCallProcessingGetPolicyResponse18sp1()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCallProcessingModifyPolicyRequest14(OCIRequest):
    """
    Modify the service provider level data associated with Call Procesing
    Policy. The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "conference_uri",
            "conferenceURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* clidPolicy
    clid_policy = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=False,
    )


class ServiceProviderCallProcessingModifyPolicyRequest15(OCIRequest):
    """
    Modify the service provider level data associated with Call Procesing
    Policy. The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    The following elements are only used in AS data mode:
    useServiceProviderDCLIDSetting
    enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity
    enterpriseCallsCLIDPolicy
    groupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_service_provider_dclid_setting",
            "useServiceProviderDCLIDSetting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "conference_uri",
            "conferenceURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_dialable_caller_id",
            "enableDialableCallerID",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "block_calling_name_for_external_calls",
            "blockCallingNameForExternalCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enterprise_calls_clid_policy",
            "enterpriseCallsCLIDPolicy",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "group_calls_clid_policy",
            "groupCallsCLIDPolicy",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* useServiceProviderDCLIDSetting
    use_service_provider_dclid_setting = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* clidPolicy
    clid_policy = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableDialableCallerID
    enable_dialable_caller_id = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* groupCallsCLIDPolicy
    group_calls_clid_policy = Field(
        type=str,
        required=False,
    )


class ServiceProviderCommunicationBarringCriteriaAssignListRequest(OCIRequest):
    """
    Assign a list of Communication Barring Criteria to a service provider.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "criteria_name",
            "criteriaName",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* criteriaName  *Array*
    criteria_name = Field(
        type=list,
        required=False,
    )


class ServiceProviderCommunicationBarringCriteriaGetAssignedListRequest(OCIRequest):
    """
    Get a list of Communication Barring Criteria assigned to a service provider.
    The response is either a ``ServiceProviderCommunicationBarringCriteriaGetAssignedListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringCriteriaUnassignListRequest(OCIRequest):
    """
    Unassign a list of Communication Barring Criteria from a service provider.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "criteria_name",
            "criteriaName",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* criteriaName  *Array*
    criteria_name = Field(
        type=list,
        required=False,
    )


class ServiceProviderCommunicationBarringDigitPatternCriteriaAddRequest(OCIRequest):
    """
    Add a new Communication Barring Digit Pattern Criteria.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "match_digit_pattern",
            "matchDigitPattern",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: list(str): *Optional* matchDigitPattern  *Array*
    match_digit_pattern = Field(
        type=list,
        required=False,
    )


class ServiceProviderCommunicationBarringDigitPatternCriteriaDeleteRequest(OCIRequest):
    """
    Delete an existing Communication Barring Digit Pattern Criteria.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringDigitPatternCriteriaGetListRequest(OCIRequest):
    """
    Get the list of all Digit Pattern Criteria defined for the service provider.
    The response is either a ``ServiceProviderCommunicationBarringDigitPatternCriteriaGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringDigitPatternCriteriaGetRequest(OCIRequest):
    """
    Get an existing Digit Pattern Criteria.
    The response is either a ``ServiceProviderCommunicationBarringDigitPatternCriteriaGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringDigitPatternCriteriaModifyRequest(OCIRequest):
    """
    Modify an existing Communication Barring Digit Pattern Criteria.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "new_name",
            "newName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "add_match_digit_pattern",
            "addMatchDigitPattern",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "delete_match_digit_pattern",
            "deleteMatchDigitPattern",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* newName
    new_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: list(str): *Optional* addMatchDigitPattern  *Array*
    add_match_digit_pattern = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* deleteMatchDigitPattern  *Array*
    delete_match_digit_pattern = Field(
        type=list,
        required=False,
    )


class ServiceProviderCommunicationBarringIncomingCriteriaAssignListRequest(OCIRequest):
    """
    Assign a list of Communication Barring Incoming Criteria to a service provider.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "criteria_name",
            "criteriaName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* criteriaName
    criteria_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringIncomingCriteriaGetAssignedListRequest(
    OCIRequest,
):
    """
    Get a list of Communication Barring Incoming Criteria assigned to a service provider.
    The response is either a ``ServiceProviderCommunicationBarringIncomingCriteriaGetAssignedListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringIncomingCriteriaUnassignListRequest(
    OCIRequest,
):
    """
    Unassign a list of Communication Barring Incoming Criteria from a service provider.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "criteria_name",
            "criteriaName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* criteriaName
    criteria_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringProfileDeleteRequest(OCIRequest):
    """
    Deletes an existing Communication Barring Profile.  Optionally, a new default
    profile can be chosen if the current default profile is being deleted.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "default_profile",
            "defaultProfile",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* defaultProfile
    default_profile = Field(
        type=str,
        required=False,
    )


class ServiceProviderCommunicationBarringProfileGetCriteriaUsageListRequest(OCIRequest):
    """
    Get a list of Communication Barring profiles within a service provider that have
    a given Communication Barring Criteria assigned.
    The response is either a ServiceProviderCommunicationBarring
    ``ProfileGetCriteriaUsageListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "criteria_name",
            "criteriaName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* criteriaName
    criteria_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringProfileGetDigitPatternCriteriaUsageListRequest(
    OCIRequest,
):
    """
    Get the list of Profiles that use a specific Digit Pattern Criteria.
    The response is either a ``ServiceProviderCommunicationBarringProfileGetDigitPatternCriteriaUsageListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringProfileGetIncomingCriteriaUsageListRequest(
    OCIRequest,
):
    """
    Get a list of Communication Barring profiles within a service provider that have
    a given Communication Barring Incoming Criteria assigned.
    The response is either a ServiceProviderCommunicationBarring
    ``ProfileGetIncomingCriteriaUsageListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "criteria_name",
            "criteriaName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* criteriaName
    criteria_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringProfileGetListRequest(OCIRequest):
    """
    Get the list of all Communication Barring Profiles.
    The response is either a
    ``ServiceProviderCommunicationBarringProfileGetListResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringProfileGetRequest(OCIRequest):
    """
    Get an existing Communication Barring Profile.
    The response is either a ``ServiceProviderCommunicationBarringProfileGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringProfileGetRequest17sp3(OCIRequest):
    """
    Get an existing Communication Barring Profile.
    The response is either a ``ServiceProviderCommunicationBarringProfileGetResponse17sp3()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringProfileGetRequest19sp1(OCIRequest):
    """
    Get an existing Communication Barring Profile.
    The response is either a ``ServiceProviderCommunicationBarringProfileGetResponse19sp1()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringProfileModifyDefaultRequest(OCIRequest):
    """
    Modifies the default Communication Barring Profile of a Service Provider.  If a
    default has been previously selected, this command will swap the default profile
    with the profile provided.  Selecting a nil profile will cause the service
    provider to not have a default Communicaton Barring Profile.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class ServiceProviderDeleteRequest(OCIRequest):
    """
    Delete a service provider or enterprise.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderDeviceManagementInProgressAndPendingEventCancelRequest(OCIRequest):
    """
    Cancel pending and in progress events.  A list of individual events can
    be canceled.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "event_id",
            "eventId",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: int: *Required* eventId
    event_id = Field(
        type=int,
        required=True,
    )


class ServiceProviderDeviceProfileAuthenticationPasswordRulesGetRequest(OCIRequest):
    """
    Request to get the service provider level device profile authentication password
    rule settings.
    The response is either a ``ServiceProviderDeviceProfileAuthenticationPasswordRulesGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderDeviceProfileAuthenticationPasswordRulesModifyRequest(OCIRequest):
    """
    Request to modify the service provider level device profile authentication
    password rule settings. The useServiceProviderSettings element can only be
    modified by a system administrator or a provisioning administrator.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_service_provider_settings",
            "useServiceProviderSettings",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_authentication_name",
            "disallowAuthenticationName",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_old_password",
            "disallowOldPassword",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_reversed_old_password",
            "disallowReversedOldPassword",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "restrict_min_digits",
            "restrictMinDigits",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "min_digits",
            "minDigits",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "restrict_min_upper_case_letters",
            "restrictMinUpperCaseLetters",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "min_upper_case_letters",
            "minUpperCaseLetters",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "restrict_min_lower_case_letters",
            "restrictMinLowerCaseLetters",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "min_lower_case_letters",
            "minLowerCaseLetters",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "min_non_alphanumeric_characters",
            "minNonAlphanumericCharacters",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "min_length",
            "minLength",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "send_permanent_lockout_notification",
            "sendPermanentLockoutNotification",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "permanent_lockout_notify_email_address",
            "permanentLockoutNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_profile_authentication_lockout_type",
            "deviceProfileAuthenticationLockoutType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_profile_temporary_lockout_threshold",
            "deviceProfileTemporaryLockoutThreshold",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_profile_wait_algorithm",
            "deviceProfileWaitAlgorithm",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_profile_lockout_fixed_minutes",
            "deviceProfileLockoutFixedMinutes",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_profile_permanent_lockout_threshold",
            "deviceProfilePermanentLockoutThreshold",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* useServiceProviderSettings
    use_service_provider_settings = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* disallowAuthenticationName
    disallow_authentication_name = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* disallowOldPassword
    disallow_old_password = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* disallowReversedOldPassword
    disallow_reversed_old_password = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* restrictMinDigits
    restrict_min_digits = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* minDigits
    min_digits = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* minUpperCaseLetters
    min_upper_case_letters = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* minLowerCaseLetters
    min_lower_case_letters = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* minLength
    min_length = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* sendPermanentLockoutNotification
    send_permanent_lockout_notification = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* permanentLockoutNotifyEmailAddress
    permanent_lockout_notify_email_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* deviceProfileAuthenticationLockoutType
    device_profile_authentication_lockout_type = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* deviceProfileTemporaryLockoutThreshold
    device_profile_temporary_lockout_threshold = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* deviceProfileWaitAlgorithm
    device_profile_wait_algorithm = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* deviceProfileLockoutFixedMinutes
    device_profile_lockout_fixed_minutes = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* deviceProfilePermanentLockoutThreshold
    device_profile_permanent_lockout_threshold = Field(
        type=int,
        required=False,
    )


class ServiceProviderDialPlanPolicyAddAccessCodeRequest(OCIRequest):
    """
    Request to add a Service Provider level Dial Plan Access Code and its all attribues.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_code",
            "accessCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_code_for_screening_services",
            "includeCodeForScreeningServices",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_secondary_dial_tone",
            "enableSecondaryDialTone",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessCode
    access_code = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* includeCodeForNetworkTranslationsAndRouting
    include_code_for_network_translations_and_routing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeCodeForScreeningServices
    include_code_for_screening_services = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableSecondaryDialTone
    enable_secondary_dial_tone = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class ServiceProviderDialPlanPolicyDeleteAccessCodeRequest(OCIRequest):
    """
    Request to delete a Service Provider level Dial Plan Access Code and its all attribues.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_code",
            "accessCode",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessCode
    access_code = Field(
        type=str,
        required=True,
    )


class ServiceProviderDialPlanPolicyGetAccessCodeListRequest(OCIRequest):
    """
    Request the Service Provider level data associated with Dial Plan Policy.
    The response is either a ``ServiceProviderDialPlanPolicyGetAccessCodeListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderDialPlanPolicyGetAccessCodeRequest(OCIRequest):
    """
    Request access code data associated with Service Provider level Dial Plan Policy
    access codes.
    The response is either a ``ServiceProviderDialPlanPolicyGetAccessCodeResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_code",
            "accessCode",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessCode
    access_code = Field(
        type=str,
        required=True,
    )


class ServiceProviderDialPlanPolicyGetRequest(OCIRequest):
    """
    Request the Service Provider level data associated with Dial Plan Policy.
    The response is either a ``ServiceProviderDialPlanPolicyGetResponse()``
    or an ``ErrorResponse()``.

    Replaced By ``ServiceProviderDialPlanPolicyGetRequest17()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderDialPlanPolicyGetRequest17(OCIRequest):
    """
    Request the Service Provider level data associated with Dial Plan Policy.
    The response is either a ``ServiceProviderDialPlanPolicyGetResponse17()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderDialPlanPolicyModifyAccessCodeRequest(OCIRequest):
    """
    Request to modify a Service Provider level Dial Plan Access Code and its attribues.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_code",
            "accessCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_code_for_screening_services",
            "includeCodeForScreeningServices",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_secondary_dial_tone",
            "enableSecondaryDialTone",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessCode
    access_code = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* includeCodeForNetworkTranslationsAndRouting
    include_code_for_network_translations_and_routing = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* includeCodeForScreeningServices
    include_code_for_screening_services = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* enableSecondaryDialTone
    enable_secondary_dial_tone = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class ServiceProviderDialPlanPolicyModifyRequest(OCIRequest):
    """
    Modify the Service Provider level data associated with Dial Plan Policy.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "requires_access_code_for_public_calls",
            "requiresAccessCodeForPublicCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_e164_public_calls",
            "allowE164PublicCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "prefer_e164_number_format_for_callback_services",
            "preferE164NumberFormatForCallbackServices",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "public_digit_map",
            "publicDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "private_digit_map",
            "privateDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* requiresAccessCodeForPublicCalls
    requires_access_code_for_public_calls = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowE164PublicCalls
    allow_e164_public_calls = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* preferE164NumberFormatForCallbackServices
    prefer_e164_number_format_for_callback_services = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(
        type=str,
        required=False,
    )


class ServiceProviderDialableCallerIDCriteriaAddRequest(OCIRequest):
    """
    Add a new Dialable Caller ID Criteria. Criteria are added at the bottom of the
    list with the lowest priority. The response is either a ``SuccessResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "prefix_digits",
            "prefixDigits",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "match_call_type",
            "matchCallType",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "match_alternate_call_indicator",
            "matchAlternateCallIndicator",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "match_local_category",
            "matchLocalCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_national_category",
            "matchNationalCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_interlata_category",
            "matchInterlataCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_intralata_category",
            "matchIntralataCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_international_category",
            "matchInternationalCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_private_category",
            "matchPrivateCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_emergency_category",
            "matchEmergencyCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_other_category",
            "matchOtherCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* prefixDigits
    prefix_digits = Field(
        type=str,
        required=False,
    )
    #: list(str): *Optional* matchCallType  *Array*
    match_call_type = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* matchAlternateCallIndicator  *Array*
    match_alternate_call_indicator = Field(
        type=list,
        required=False,
    )
    #: bool: *Required* matchLocalCategory
    match_local_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchNationalCategory
    match_national_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchInterlataCategory
    match_interlata_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchIntralataCategory
    match_intralata_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchInternationalCategory
    match_international_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchPrivateCategory
    match_private_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchEmergencyCategory
    match_emergency_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchOtherCategory
    match_other_category = Field(
        type=bool,
        required=True,
    )


class ServiceProviderDialableCallerIDCriteriaDeleteRequest(OCIRequest):
    """
    Delete a Dialable Caller ID Criteria.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class ServiceProviderDialableCallerIDCriteriaGetRequest(OCIRequest):
    """
    Get an existing Dialable Caller ID Criteria.
    The response is either a
    ``ServiceProviderDialableCallerIDCriteriaGetRequest()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )


class ServiceProviderDialableCallerIDGetRequest(OCIRequest):
    """
    Get the service provider?s Dialable Caller ID settings and criteria list.
    The response is either a
    ``ServiceProviderDialableCallerIDGetResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderDigitCollectionGetRequest13mp4(OCIRequest):
    """
    Request the service provider's digit collection attributes.
    The response is either a ``ServiceProviderDigitCollectionGetResponse13mp4()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderDigitCollectionModifyRequest(OCIRequest):
    """
    Modifies the service provider's digit collection attributes.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_code",
            "accessCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "public_digit_map",
            "publicDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "private_digit_map",
            "privateDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* accessCode
    access_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(
        type=str,
        required=False,
    )


class ServiceProviderDnGetAvailableListRequest(OCIRequest):
    """
    Request a list of available DNs not yet assigned to any group.
    Dns assigned to the IMRN pool are not listed in the response.
    The response is either ``ServiceProviderDnGetAvailableListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderDnGetSummaryListRequest(OCIRequest):
    """
    Request a summary table of all DNs in a service provider.
    Dns assigned to the IMRN pool are not listed in the response.
    The response is either ``ServiceProviderDnGetSummaryListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderDomainAssignListRequest(OCIRequest):
    """
    Assign a list of domains to a service provider.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "domain",
            "domain",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* domain
    domain = Field(
        type=str,
        required=True,
    )


class ServiceProviderDomainGetAssignedListRequest(OCIRequest):
    """
    Requests the list of all domains assigned to a service provider.
    The response is either ``ServiceProviderDomainGetAssignedListResponse()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderDomainUnassignListRequest(OCIRequest):
    """
    Unassign a list of domains from a service provider.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "domain",
            "domain",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* domain
    domain = Field(
        type=str,
        required=True,
    )


class ServiceProviderEnhancedCallLogsGetRequest(OCIRequest):
    """
    Get the service provider's enhanced call log settings.
    The response is either a ``ServiceProviderEnhancedCallLogsGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderEnhancedCallLogsGetRequest17sp4(OCIRequest):
    """
    Get the service provider's enhanced call log settings.
    The response is either a ``ServiceProviderEnhancedCallLogsGetResponse17sp4()`` or
    an ``ErrorResponse()``.
    This command will return an ``ErrorResponse()`` if DBS is used as the call log server.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderEnhancedCallLogsModifyRequest(OCIRequest):
    """
    Modify the Service Provider level data associated with Enhanced Call Logs.
    Configures the maximum number of logged calls and maximum age of your user's call logs.
    Log entries are deleted when either of the two limits is reached.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_logged_calls",
            "maxLoggedCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_expiration_days",
            "callExpirationDays",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* maxLoggedCalls
    max_logged_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* callExpirationDays
    call_expiration_days = Field(
        type=int,
        required=False,
    )


class ServiceProviderExternalCustomRingbackGetRequest(OCIRequest):
    """
    Request the service provider level data associated with External Custom Ringback.
    The response is either a ``ServiceProviderExternalCustomRingbackGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderExternalCustomRingbackModifyRequest(OCIRequest):
    """
    Modify the service provider level data associated with External Custom Ringback.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "prefix_digits",
            "prefixDigits",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "server_net_address",
            "serverNetAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "server_port",
            "serverPort",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "timeout_seconds",
            "timeoutSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* prefixDigits
    prefix_digits = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serverNetAddress
    server_net_address = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* serverPort
    server_port = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* timeoutSeconds
    timeout_seconds = Field(
        type=int,
        required=False,
    )


class ServiceProviderFeatureAccessCodeGetListRequest(OCIRequest):
    """
    Get the list of feature access codes for a service provider or enterprise.
    The response is either a ``ServiceProviderFeatureAccessCodeGetListResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderFeatureAccessCodeGetListRequest20(OCIRequest):
    """
    Get the list of feature access codes for a service provider or enterprise.
    The response is either a ``ServiceProviderFeatureAccessCodeGetListResponse20()``
    or an ``ErrorResponse()``.

    In release 20 the "Call Recording" FAC name is changed to
    "Call Recording - Start".
    Replaced By ``ServiceProviderFeatureAccessCodeGetListRequest21()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderFeatureAccessCodeGetListRequest21(OCIRequest):
    """
    Get the list of feature access codes for a service provider or enterprise.
    The response is either a ``ServiceProviderFeatureAccessCodeGetListResponse21()``
    or an ``ErrorResponse()``.

    In release 20 the "Call Recording" FAC name is changed to
    "Call Recording - Start".
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderFileRepositoryDeviceUserAddRequest(OCIRequest):
    """
    Add a new service provider file repository user.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_repository_name",
            "fileRepositoryName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_name",
            "userName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_put",
            "allowPut",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_delete",
            "allowDelete",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_get",
            "allowGet",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userName
    user_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* password
    password = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowPut
    allow_put = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowDelete
    allow_delete = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowGet
    allow_get = Field(
        type=bool,
        required=True,
    )


class ServiceProviderFileRepositoryDeviceUserDeleteRequest(OCIRequest):
    """
    Delete a service provider file repository user.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_repository_name",
            "fileRepositoryName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_name",
            "userName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userName
    user_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderFileRepositoryDeviceUserGetListRequest(OCIRequest):
    """
    Request the list of service provider users for a file repository in the system.
    The response is either a ``ServiceProviderFileRepositoryDeviceUserGetListResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_repository_name",
            "fileRepositoryName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(
        type=str,
        required=True,
    )


class ServiceProviderFileRepositoryDeviceUserModifyRequest(OCIRequest):
    """
    Modify a service provider file repository user.
    The response is either ``SuccessResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_repository_name",
            "fileRepositoryName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_name",
            "userName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "password",
            "password",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_put",
            "allowPut",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_delete",
            "allowDelete",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_get",
            "allowGet",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileRepositoryName
    file_repository_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userName
    user_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* password
    password = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* allowPut
    allow_put = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowDelete
    allow_delete = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* allowGet
    allow_get = Field(
        type=bool,
        required=False,
    )


class ServiceProviderGetDefaultRequest(OCIRequest):
    """
    Request the default profile for a service provider or enterprise.
    The response is either a ``ServiceProviderGetDefaultResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = ()


class ServiceProviderGetRequest13mp2(OCIRequest):
    """
    Get the profile for a service provider or enterprise.
    The response is either a ``ServiceProviderGetResponse13mp2()`` or an ``ErrorResponse()``.

    Replaced By ``ServiceProviderGetRequest17sp1()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderGetRequest17sp1(OCIRequest):
    """
    Get the profile for a service provider or enterprise.
    The response is either a ``ServiceProviderGetResponse17sp1()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderGroupPagingTargetsCapacityGetRequest(OCIRequest):
    """
    Request the maximum number of target users per paging group configured for a
    service provider.
    The response is either a ``ServiceProviderGroupPagingTargetsCapacityGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderGroupPagingTargetsCapacityModifyRequest(OCIRequest):
    """
    Modify the maximum number of target users per paging group configured for a
    service provider.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "maximum_target_users",
            "maximumTargetUsers",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* maximumTargetUsers
    maximum_target_users = Field(
        type=int,
        required=False,
    )


class ServiceProviderIMRNGetListRequest(OCIRequest):
    """
    Returns a list of dns or dn ranges in a service provider IMRN pool.
    The response is either ``ServiceProviderIMRNGetListResponse()`` or ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderInCallServiceActivationGetRequest(OCIRequest):
    """
    Request the service provider's DTMF based in-call service activation trigger
    attributes.The response is either a
    ``ServiceProviderInCallServiceActivationGetResponse()`` or an ``ErrorResponse()``.

    Replaced By ``ServiceProviderInCallServiceActivationGetRequest17()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderInCallServiceActivationGetRequest17(OCIRequest):
    """
    Request the service provider's DTMF based in-call service activation trigger
    attributes.The response is either a
    ``ServiceProviderInCallServiceActivationGetResponse17()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderInCallServiceActivationModifyRequest(OCIRequest):
    """
    Modifies the service provider's DTMF based in-call service activation trigger
    attributes.The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.

    Replaced By ``ServiceProviderInCallServiceActivationModifyRequest17()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "activation_digits",
            "activationDigits",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* activationDigits
    activation_digits = Field(
        type=str,
        required=False,
    )


class ServiceProviderInCallServiceActivationModifyRequest17(OCIRequest):
    """
    Modifies the service provider's DTMF based in-call service activation trigger
    attributes.The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "flash_activation_digits",
            "flashActivationDigits",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_transfer_activation_digits",
            "callTransferActivationDigits",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* flashActivationDigits
    flash_activation_digits = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callTransferActivationDigits
    call_transfer_activation_digits = Field(
        type=str,
        required=False,
    )


class ServiceProviderIntegratedIMPGetRequest(OCIRequest):
    """
    Get the Integrated IMP service attributes for the service provider.
    The response is either ``ServiceProviderIntegratedIMPGetResponse()`` or
    ``ErrorResponse()``.

    Replaced By ``ServiceProviderIntegratedIMPGetRequest21()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderIntegratedIMPGetRequest21(OCIRequest):
    """
    Get the Integrated IMP service attributes for the service provider.
    The response is either ``ServiceProviderIntegratedIMPGetResponse21()`` or
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderIntegratedIMPModifyRequest(OCIRequest):
    """
    Modify the Integrated IMP service attributes for the service provider.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_system_service_domain",
            "useSystemServiceDomain",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_domain",
            "serviceDomain",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_port",
            "servicePort",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_system_messaging_server",
            "useSystemMessagingServer",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "provisioning_url",
            "provisioningUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "provisioning_user_id",
            "provisioningUserId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "provisioning_password",
            "provisioningPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "bosh_url",
            "boshURL",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* useSystemServiceDomain
    use_system_service_domain = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* serviceDomain
    service_domain = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* servicePort
    service_port = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* useSystemMessagingServer
    use_system_messaging_server = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* provisioningUrl
    provisioning_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* provisioningUserId
    provisioning_user_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* provisioningPassword
    provisioning_password = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* boshURL
    bosh_url = Field(
        type=str,
        required=False,
    )


class ServiceProviderLDAPIntegrationGetDirectoryRequest(OCIRequest):
    """
    Get the LDAP directory attributes for a service provider.
    The response is either a ``ServiceProviderLDAPIntegrationGetDirectoryResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderLDAPIntegrationModifyDirectoryRequest(OCIRequest):
    """
    Modify the LDAP directory attributes for a service provider.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "server_net_address",
            "serverNetAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "server_port",
            "serverPort",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "search_base",
            "searchBase",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_ssl",
            "useSSL",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "require_authentication",
            "requireAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "authenticated_dn",
            "authenticatedDN",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "authenticated_password",
            "authenticatedPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "is_sort_enabled",
            "isSortEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "is_paged_result_enabled",
            "isPagedResultEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "search_filter",
            "searchFilter",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_search_attribute_in_search_filter",
            "includeSearchAttributeInSearchFilter",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "column1_attribute_name",
            "column1AttributeName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column2_attribute_name",
            "column2AttributeName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column3_attribute_name",
            "column3AttributeName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column4_attribute_name",
            "column4AttributeName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column1_label",
            "column1Label",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column2_label",
            "column2Label",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column3_label",
            "column3Label",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column4_label",
            "column4Label",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "search_column",
            "searchColumn",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* serverNetAddress
    server_net_address = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* serverPort
    server_port = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* searchBase
    search_base = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* useSSL
    use_ssl = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* requireAuthentication
    require_authentication = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* authenticatedDN
    authenticated_dn = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* authenticatedPassword
    authenticated_password = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* isSortEnabled
    is_sort_enabled = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* isPagedResultEnabled
    is_paged_result_enabled = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* searchFilter
    search_filter = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* includeSearchAttributeInSearchFilter
    include_search_attribute_in_search_filter = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* column1AttributeName
    column1_attribute_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column2AttributeName
    column2_attribute_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column3AttributeName
    column3_attribute_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column4AttributeName
    column4_attribute_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column1Label
    column1_label = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column2Label
    column2_label = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column3Label
    column3_label = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column4Label
    column4_label = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* searchColumn
    search_column = Field(
        type=int,
        required=False,
    )


class ServiceProviderLanguageAddRequest(OCIRequest):
    """
    Request to add a language for a service provder.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* language
    language = Field(
        type=str,
        required=True,
    )


class ServiceProviderLanguageDeleteRequest(OCIRequest):
    """
    Request to delete a language from a service provider supported languages.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* language
    language = Field(
        type=str,
        required=True,
    )


class ServiceProviderLanguageGetAvailableListRequest(OCIRequest):
    """
    Request the list of languages that a user or admin in a service provider is
    allowed to use.
    The list will either be the system or service provider languages list, depending
    on the useServiceProviderLanguages flag.
    The response is either a ``ServiceProviderLanguageGetAvailableListResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderLanguageGetListRequest(OCIRequest):
    """
    Request the defined languages for a service provider.
    The response is either a ``ServiceProviderLanguageGetListResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderLanguageModifyRequest(OCIRequest):
    """
    Request to modify a language properties for a service provider/enterprise.
    If the becomeDefaultLanguage element is present, the language in this request
    Becomes the default language for the service provider/enterprise.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "become_default_language",
            "becomeDefaultLanguage",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* language
    language = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* becomeDefaultLanguage
    become_default_language = Field(
        type=bool,
        required=False,
    )


class ServiceProviderMWIDeliveryToMobileEndpointCustomTemplateDeleteRequest(OCIRequest):
    """
    Delete a MWI Delivery to Mobile Endpoint Custom Template.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "type",
            "type",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* language
    language = Field(
        type=str,
        required=True,
    )
    #: str: *Required* type
    type = Field(
        type=str,
        required=True,
    )


class ServiceProviderMWIDeliveryToMobileEndpointCustomTemplateGetRequest(OCIRequest):
    """
    Request a MWI Delivery to Mobile Endpoint Custom Template.
    The response is either a ``ServiceProviderMWIDeliveryToMobileEndpointCustomTemplateGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "type",
            "type",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* language
    language = Field(
        type=str,
        required=True,
    )
    #: str: *Required* type
    type = Field(
        type=str,
        required=True,
    )


class ServiceProviderMWIDeliveryToMobileEndpointGetRequest(OCIRequest):
    """
    Request the service provider level data associated with MWI Delivery to Mobile
    Endpoint service.
    The response is either a ``ServiceProviderMWIDeliveryToMobileEndpointGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderMaliciousCallTraceGetRequest(OCIRequest):
    """
    Get the service provider's Malicious Call Trace settings.
    The response is either a ``ServiceProviderMaliciousCallTraceGetResponse()``
    or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderMaliciousCallTraceModifyRequest(OCIRequest):
    """
    Modify the service provider's Malicious Call Trace settings.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_system_play_mct_warning_announcement",
            "useSystemPlayMCTWarningAnnouncement",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "play_mct_warning_announcement",
            "playMCTWarningAnnouncement",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Optional* useSystemPlayMCTWarningAnnouncement
    use_system_play_mct_warning_announcement = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* playMCTWarningAnnouncement
    play_mct_warning_announcement = Field(
        type=bool,
        required=False,
    )


class ServiceProviderMeetMeConferencingGetRequest(OCIRequest):
    """
    Request the service provider/enterprise level data associated with Meet-Me
    Conferencing functions.
    The response is either a ``ServiceProviderMeetMeConferencingGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderNetworkClassOfServiceAssignListRequest(OCIRequest):
    """
    Assign a list of Network Classes of Service to a service provider.
    The Element defaultNetworkClassOfService is required only
    for the first assignment,
    for subsequent assignments it is optional.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_class_of_service",
            "networkClassOfService",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "default_network_class_of_service",
            "defaultNetworkClassOfService",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* networkClassOfService  *Array*
    network_class_of_service = Field(
        type=list,
        required=False,
    )
    #: str: *Optional* defaultNetworkClassOfService
    default_network_class_of_service = Field(
        type=str,
        required=False,
    )


class ServiceProviderNetworkClassOfServiceAssignListToAllGroupsRequest(OCIRequest):
    """
    Assign a list of Network Classes of Service to all groups with in a
    service provider. If it is the first assigned Network Class of Service in
    the group, it will be set as the default one.
    The Network Classes of Service must be currently
    assigned to the service provider. The response is either a
    ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_class_of_service",
            "networkClassOfService",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* networkClassOfService
    network_class_of_service = Field(
        type=str,
        required=True,
    )


class ServiceProviderNetworkClassOfServiceAssignToAllUsersRequest(OCIRequest):
    """
    Assign a Network Classes of Service to all users with in a
    service provider. This will also assign the Network Class of Service
    to all the groups in the service provider if it is not assigned yet.
    If it is the first assigned Network Class of Service in the group,
    it will be set as the default one.
    However, the Network Classes of Service must be currently assigned to
    the service provider. The response is either a ``SuccessResponse()`` or
    an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_class_of_service",
            "networkClassOfService",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* networkClassOfService
    network_class_of_service = Field(
        type=str,
        required=True,
    )


class ServiceProviderNetworkClassOfServiceGetAssignedListRequest(OCIRequest):
    """
    Get a list of Network Classes of Service assigned to a service provider.
    The response is either a ``ServiceProviderNetworkClassOfServiceGetAssignedListResponse()``
    or an ``ErorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )


class ServiceProviderNetworkClassOfServiceModifyDefaultRequest(OCIRequest):
    """
    Modifies the default Network Classes of Service of a Service Provider.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_class_of_service",
            "networkClassOfService",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* networkClassOfService
    network_class_of_service = Field(
        type=str,
        required=True,
    )


class ServiceProviderNetworkClassOfServiceUnassignListRequest(OCIRequest):
    """
    Unassign a list of Network Classes of Service from a service provider.
    The response is either a ``SuccessResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_class_of_service",
            "networkClassOfService",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "default_network_class_of_service",
            "defaultNetworkClassOfService",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* networkClassOfService  *Array*
    network_class_of_service = Field(
        type=list,
        required=False,
    )
    #: str: *Optional* defaultNetworkClassOfService
    default_network_class_of_service = Field(
        type=str,
        required=False,
    )


class ServiceProviderNumberPortabilityQueryAddListRequest(OCIRequest):
    """
    Add a list of the Service Provider Number Portability Query Digit Patterns.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern",
            "digitPattern",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* digitPattern
    digit_pattern = Field(
        type=str,
        required=True,
    )


class ServiceProviderNumberPortabilityQueryModifyRequest(OCIRequest):
    """
    Modify the Service Provider Number Portability Query information.
    The response is either a ``SuccessResponse()`` or an ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_number_portability_query_for_outgoing_calls",
            "enableNumberPortabilityQueryForOutgoingCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_number_portability_query_for_incoming_calls",
            "enableNumberPortabilityQueryForIncomingCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_number_portability_query_for_network_calls_only",
            "enableNumberPortabilityQueryForNetworkCallsOnly",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "delete_digit_pattern",
            "deleteDigitPattern",
            str,
            False,
            False,
            True,
            False,
 