term_mappings = {
    'Cell': 'csvw:Cell',
    'Column': 'csvw:Column',
    'Datatype': 'csvw:Datatype',
    'Dialect': 'csvw:Dialect',
    'Direction': 'csvw:Direction',
    'ForeignKey': 'csvw:ForeignKey',
    'JSON': 'csvw:JSON',
    'NCName': 'xsd:NCName',
    'NMTOKEN': 'xsd:NMTOKEN',
    'Name': 'xsd:Name',
    'NumericFormat': 'csvw:NumericFormat',
    'QName': 'xsd:QName',
    'Row': 'csvw:Row',
    'Schema': 'csvw:Schema',
    'Table': 'csvw:Table',
    'TableGroup': 'csvw:TableGroup',
    'TableReference': 'csvw:TableReference',
    'Transformation': 'csvw:Transformation',
    'aboutUrl': 'csvw:aboutUrl',
    'any': 'xsd:anyAtomicType',
    'anyAtomicType': 'xsd:anyAtomicType',
    'anyURI': 'xsd:anyURI',
    'as': 'https://www.w3.org/ns/activitystreams#',
    'base': 'csvw:base',
    'base64Binary': 'xsd:base64Binary',
    'binary': 'xsd:base64Binary',
    'boolean': 'xsd:boolean',
    'byte': 'xsd:byte',
    'cc': 'http://creativecommons.org/ns#',
    'columnReference': 'csvw:columnReference',
    'columns': 'csvw:column',
    'commentPrefix': 'csvw:commentPrefix',
    'csvw': 'http://www.w3.org/ns/csvw#',
    'ctag': 'http://commontag.org/ns#',
    'datatype': 'csvw:datatype',
    'date': 'xsd:date',
    'dateTime': 'xsd:dateTime',
    'dateTimeStamp': 'xsd:dateTimeStamp',
    'datetime': 'xsd:dateTime',
    'dayTimeDuration': 'xsd:dayTimeDuration',
    'dc': 'http://purl.org/dc/terms/',
    'dc11': 'http://purl.org/dc/elements/1.1/',
    'dcat': 'http://www.w3.org/ns/dcat#',
    'dcterms': 'http://purl.org/dc/terms/',
    'dctypes': 'http://purl.org/dc/dcmitype/',
    'decimal': 'xsd:decimal',
    'decimalChar': 'csvw:decimalChar',
    'default': 'csvw:default',
    'delimiter': 'csvw:delimiter',
    'describedby': 'wrds:describedby',
    'describes': 'csvw:describes',
    'dialect': 'csvw:dialect',
    'double': 'xsd:double',
    'doubleQuote': 'csvw:doubleQuote',
    'dqv': 'http://www.w3.org/ns/dqv#',
    'duration': 'xsd:duration',
    'duv': 'https://www.w3.org/TR/vocab-duv#',
    'encoding': 'csvw:encoding',
    'float': 'xsd:float',
    'foaf': 'http://xmlns.com/foaf/0.1/',
    'foreignKeys': 'csvw:foreignKey',
    'format': 'csvw:format',
    'gDay': 'xsd:gDay',
    'gMonth': 'xsd:gMonth',
    'gMonthDay': 'xsd:gMonthDay',
    'gYear': 'xsd:gYear',
    'gYearMonth': 'xsd:gYearMonth',
    'gr': 'http://purl.org/goodrelations/v1#',
    'grddl': 'http://www.w3.org/2003/g/data-view#',
    'groupChar': 'csvw:groupChar',
    'header': 'csvw:header',
    'headerRowCount': 'csvw:headerRowCount',
    'hexBinary': 'xsd:hexBinary',
    'html': 'rdf:HTML',
    'ical': 'http://www.w3.org/2002/12/cal/icaltzd#',
    'int': 'xsd:int',
    'integer': 'xsd:integer',
    'json': 'csvw:JSON',
    'lang': 'csvw:lang',
    'language': 'xsd:language',
    'ldp': 'http://www.w3.org/ns/ldp#',
    'length': 'csvw:length',
    'license': 'xhv:license',
    'lineTerminators': 'csvw:lineTerminators',
    'long': 'xsd:long',
    'ma': 'http://www.w3.org/ns/ma-ont#',
    'maxExclusive': 'csvw:maxExclusive',
    'maxInclusive': 'csvw:maxInclusive',
    'maxLength': 'csvw:maxLength',
    'maximum': 'csvw:maxInclusive',
    'minExclusive': 'csvw:minExclusive',
    'minInclusive': 'csvw:minInclusive',
    'minLength': 'csvw:minLength',
    'minimum': 'csvw:minInclusive',
    'name': 'csvw:name',
    'negativeInteger': 'xsd:negativeInteger',
    'nonNegativeInteger': 'xsd:nonNegativeInteger',
    'nonPositiveInteger': 'xsd:nonPositiveInteger',
    'normalizedString': 'xsd:normalizedString',
    'notes': 'csvw:note',
    'null': 'csvw:null',
    'number': 'xsd:double',
    'oa': 'http://www.w3.org/ns/oa#',
    'og': 'http://ogp.me/ns#',
    'ordered': 'csvw:ordered',
    'org': 'http://www.w3.org/ns/org#',
    'owl': 'http://www.w3.org/2002/07/owl#',
    'pattern': 'csvw:pattern',
    'positiveInteger': 'xsd:positiveInteger',
    'primaryKey': 'csvw:primaryKey',
    'propertyUrl': 'csvw:propertyUrl',
    'prov': 'http://www.w3.org/ns/prov#',
    'qb': 'http://purl.org/linked-data/cube#',
    'quoteChar': 'csvw:quoteChar',
    'rdf': 'http://www.w3.org/1999/02/22-rdf-syntax-ns#',
    'rdfa': 'http://www.w3.org/ns/rdfa#',
    'rdfs': 'http://www.w3.org/2000/01/rdf-schema#',
    'reference': 'csvw:reference',
    'referencedRows': 'csvw:referencedRow',
    'required': 'csvw:required',
    'resource': 'csvw:resource',
    'rev': 'http://purl.org/stuff/rev#',
    'rif': 'http://www.w3.org/2007/rif#',
    'role': 'xhv:role',
    'row': 'csvw:row',
    'rowTitles': 'csvw:rowTitle',
    'rownum': 'csvw:rownum',
    'rr': 'http://www.w3.org/ns/r2rml#',
    'schema': 'http://schema.org/',
    'schemaReference': 'csvw:schemaReference',
    'scriptFormat': 'csvw:scriptFormat',
    'sd': 'http://www.w3.org/ns/sparql-service-description#',
    'separator': 'csvw:separator',
    'short': 'xsd:short',
    'sioc': 'http://rdfs.org/sioc/ns#',
    'skipBlankRows': 'csvw:skipBlankRows',
    'skipColumns': 'csvw:skipColumns',
    'skipInitialSpace': 'csvw:skipInitialSpace',
    'skipRows': 'csvw:skipRows',
    'skos': 'http://www.w3.org/2004/02/skos/core#',
    'skosxl': 'http://www.w3.org/2008/05/skos-xl#',
    'source': 'csvw:source',
    'string': 'xsd:string',
    'suppressOutput': 'csvw:suppressOutput',
    'tableDirection': 'csvw:tableDirection',
    'tableSchema': 'csvw:tableSchema',
    'tables': 'csvw:table',
    'targetFormat': 'csvw:targetFormat',
    'textDirection': 'csvw:textDirection',
    'time': 'xsd:time',
    'titles': 'csvw:title',
    'token': 'xsd:token',
    'transformations': 'csvw:transformations',
    'trim': 'csvw:trim',
    'unsignedByte': 'xsd:unsignedByte',
    'unsignedInt': 'xsd:unsignedInt',
    'unsignedLong': 'xsd:unsignedLong',
    'unsignedShort': 'xsd:unsignedShort',
    'uriTemplate': 'csvw:uriTemplate',
    'url': 'csvw:url',
    'v': 'http://rdf.data-vocabulary.org/#',
    'valueUrl': 'csvw:valueUrl',
    'vcard': 'http://www.w3.org/2006/vcard/ns#',
    'virtual': 'csvw:virtual',
    'void': 'http://rdfs.org/ns/void#',
    'wdr': 'http://www.w3.org/2007/05/powder#',
    'wrds': 'http://www.w3.org/2007/05/powder-s#',
    'xhv': 'http://www.w3.org/1999/xhtml/vocab#',
    'xml': 'rdf:XMLLiteral',
    'xsd': 'http://www.w3.org/2001/XMLSchema#',
    'yearMonthDuration': 'xsd:yearMonthDuration',
}

core_group_of_tables_annotations = ['id', 'notes', 'tables']

core_table_annotations = ['columns', 'tableDirection', 'foreignKeys', 'id', 'notes', 'rows', 'schema',
                          'suppressOutput', 'transformations', 'url']

core_column_annotations = ['aboutUrl', 'cells', 'datatype', 'default', 'lang', 'name', 'null', 'number', 'ordered',
                           'propertyUrl', 'required', 'separator', 'sourceNumber', 'suppressOutput', 'table',
                           'textDirection', 'titles', 'valueUrl', 'virtual']

core_row_annotations = ['cells', 'number', 'primaryKey', 'titles', 'referencedRows', 'sourceNumber', 'table']

schema_description = ['columns', 'foreignKeys', 'primaryKey', 'rowTitles', '@type', '@id']


def is_non_core_annotation(name):
    return name not in core_group_of_tables_annotations \
           and name not in core_table_annotations \
           and name not in core_column_annotations \
           and name not in core_row_annotations \
           and name not in schema_description


CONST_STANDARD_MODE = 'standard'
CONST_MINIMAL_MODE = 'minimal'

core_group_of_tables_properties = ['tables', 'dialect', 'notes', 'tableDirection', 'tableSchema', 'transformations',
                                   '@id', '@type', '@context']

core_table_properties = ['url', 'dialect', 'notes', 'suppressOutput', 'tableDirection', 'tableSchema',
                         'transformations', '@id', '@type']

inherited_properties = ['aboutUrl', 'datatype', 'default', 'lang', 'null', 'ordered', 'propertyUrl', 'required',
                        'separator', 'textDirection', 'valueUrl']

array_properties = ['tables', 'transformations', '@context', 'notes', 'foreignKeys',
                    'columns', 'lineTerminators']

array_property_item_types = {
    'columns': dict,
    'foreignKeys': dict,
    'lineTerminators': str,
    'notes': dict,
    'transformations': dict,
    'tables': dict,
}

number_datatypes = ['decimal', 'integer', 'integer', 'long', 'int', 'short', 'byte', 'nonNegativeInteger',
                    'positiveInteger', 'unsignedLong', 'unsignedInt', 'unsignedShort', 'unsignedByte',
                    'nonPositiveInteger', 'negativeInteger', 'double', 'number', 'duration', 'dayTimeDuration',
                    'yearMonthDuration', 'float']

date_datatypes = ['date', 'dateTime', 'datetime', 'dateTimeStamp']

fields_properties = {
    'transformations': {'url': True, 'scriptFormat': True, 'targetFormat': True, 'source': False, 'titles': False,
                        '@id': False, '@type': True},
    'tableGroup': {'tables': True, 'dialect': False, 'notes': False, 'tableDirection': False, 'tableSchema': False,
                   'transformations': False, '@id': False, '@type': False, '@context': True},
    'tables': {'url': True, 'dialect': False, 'notes': False, 'suppressOutput': False, 'tableDirection': False,
               'transformations': False, 'tableSchema': False, '@id': False, '@type': False},
    'columns': {'name': False, 'suppressOutput': False, 'titles': False, 'virtual': False, '@id': False,
                '@type': False, }
}
