/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.InputStreamContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AbstractGoogleAsyncWriteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ClientRequestHelper;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.LoggingMediaHttpUploaderProgressListener;
import java.io.IOException;
import java.util.concurrent.ExecutorService;

public class GoogleCloudStorageWriteChannel
extends AbstractGoogleAsyncWriteChannel<Storage.Objects.Insert, StorageObject>
implements GoogleCloudStorageItemInfo.Provider {
    private static final long MIN_LOGGING_INTERVAL_MS = 60000L;
    private final Storage gcs;
    private final StorageResourceId resourceId;
    private final CreateObjectOptions createOptions;
    private final ObjectWriteConditions writeConditions;
    private GoogleCloudStorageItemInfo completedItemInfo = null;

    public GoogleCloudStorageWriteChannel(Storage gcs, ClientRequestHelper<StorageObject> requestHelper, ExecutorService uploadThreadPool, AsyncWriteChannelOptions channelOptions, StorageResourceId resourceId, CreateObjectOptions createOptions, ObjectWriteConditions writeConditions) {
        super(requestHelper, uploadThreadPool, channelOptions);
        this.gcs = gcs;
        this.resourceId = resourceId;
        this.createOptions = createOptions;
        this.writeConditions = writeConditions;
    }

    @Override
    public Storage.Objects.Insert createRequest(InputStreamContent inputStream) throws IOException {
        StorageObject object = new StorageObject().setContentEncoding(this.createOptions.getContentEncoding()).setMetadata(GoogleCloudStorageImpl.encodeMetadata(this.createOptions.getMetadata())).setName(this.resourceId.getObjectName());
        Storage.Objects.Insert insert = this.gcs.objects().insert(this.resourceId.getBucketName(), object, inputStream).setName(this.resourceId.getObjectName()).setKmsKeyName(this.createOptions.getKmsKeyName());
        this.writeConditions.apply(insert);
        if (insert.getMediaHttpUploader() != null) {
            insert.getMediaHttpUploader().setDirectUploadEnabled(this.isDirectUploadEnabled()).setProgressListener(new LoggingMediaHttpUploaderProgressListener(this.resourceId.getObjectName(), 60000L));
        }
        return insert;
    }

    @Override
    public void handleResponse(StorageObject response) {
        this.completedItemInfo = GoogleCloudStorageImpl.createItemInfoForStorageObject(this.resourceId, response);
    }

    @Override
    protected String getContentType() {
        return this.createOptions.getContentType();
    }

    @Override
    protected String getResourceString() {
        return this.resourceId.toString();
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo() {
        return this.completedItemInfo;
    }
}

