try:
    import nutDate as dat
except:
    print('Online Test...')
    from pyNutTools import nutDate as dat
import time
import datetime

# import pytest

# pytest test/test_nutDate.py


#=============================================================================
# UNIT TEST
#=============================================================================
def test_fDte_Now_GMT():
    dte_now = dat.fDte_Now()
    dte_GMT = dat.fDte_Now_GMT()
    assert (dte_GMT.hour+8 == dte_now.hour)

def test_fDte_formatToDate():
    dte_date = '2022-02-20'
    str_format = '%Y-%m-%d'
    dte_date = dat.fDte_formatToDate(dte_date, str_format)
    assert( isinstance(dte_date, datetime.date) )
    dte_today = dat.fDte_Today()
    str_format = 'xxxx'
    dte_date = dat.fDte_formatToDate(dte_today, str_format)
    assert( isinstance(dte_date, datetime.date) )

def test_fDte_formatToDate_timestamp():
    dte_date = '2022-06-06 20:28:15.138280'
    str_format = '%Y-%m-%d %H:%M:%S.%f'
    dte_datetime = dat.fDte_formatToDatetime(dte_date, str_format)
    assert( isinstance(dte_datetime, datetime.datetime) )
    assert( dte_datetime.hour == 20 )
    assert( dte_datetime.minute == 28 )

def tes_fDte_formatToDate_auto():
    dte_date = '2022-06-06 20:28:15.138280'
    str_format = '%Y-%m-%d %H:%M:%S.%f'
    dte_datetime = dat.fDte_formatToDate_auto(dte_date)
    assert( isinstance(dte_datetime, datetime.datetime) )
    assert( dte_datetime.hour == 20 )
    assert( dte_datetime.minute == 28 )

def test_fDte_timeStamp_to_epochTime():
    dte_date = '2022-06-06 20:28:15.138280'
    str_format = '%Y-%m-%d %H:%M:%S.%f'
    dte_datetime =  dat.fDte_formatToDate_auto(dte_date)
    epochTime =     dat.fDte_timeStamp_to_epochTime(dte_datetime)
    print(epochTime)
    print(type(epochTime))
    assert (isinstance(epochTime, float))
    assert (int(epochTime) == 1654518495 )

def test_fInt_dateDifference():
    dte_today =     dat.fDte_Today()
    dte_yesterday = dat.fDte_AddDay(dte_today, -1)
    int_diff =      dat.fInt_dateDifference(dte_today, dte_yesterday)
    assert( isinstance(int_diff, int) )
    assert( int_diff == 1 )

def test_fBl_TimeIsBetween():
    dte_now =       dat.fDte_Now()
    dte_past =      dat.fDte_AddHour(dte_now, -1)
    dte_future =    dat.fDte_AddHour(dte_now, 1)
    bl_isBtw =      dat.fBl_TimeIsBetween(dte_past, dte_future, dte_now)
    assert ( isinstance(bl_isBtw, bool) )
    assert ( bl_isBtw is True )

def test_fStr_DateToString():
    dte_now =       dat.fDte_Now()
    str_dateFormat = '%Y-%m-%d'
    str_date =      dat.fStr_DateToString(dte_now, str_dateFormat = str_dateFormat)
    assert (isinstance(str_date, str))

def test_fDte_convertExcelInteger():
    int_date = 46106
    dte_date = dat.fDte_convertExcelInteger(int_date)
    print(dte_date)
    assert (isinstance(dte_date, datetime.date))
    str_date = dat.fStr_DateToString(dte_date, str_dateFormat='%Y-%m-%d')
    assert( str_date == '2026-03-25' )
    dte_date = dat.fDte_convertExcelInteger(int_date, bl_formatDate_tuple = True)
    print(dte_date)
    print(type(dte_date))
    assert (isinstance(dte_date, time.struct_time))

def test_fBl_isDate():
    assert (dat.fBl_isDate("1990-12-1") is True)
    assert (dat.fBl_isDate("2005/3") is True)
    assert (dat.fBl_isDate("Jan 19, 1990") is True)
    assert (dat.fBl_isDate("today is 2019-03-27") is False)
