## About the documentation

The documentation is built around README.md at the project root.
README.md serves as the:

- project home page
- PYPI long description
- user manual

The documentation is constructed to achieve:

- Most text is in the README.
- Python Package Index long description taken from the README.
- README is at the Github repository root.
- Examples in the README are fully syntax highlighted.
- README examples are tested by the test suite.
- Building a static copy of the documentation for offline use.
- No visible raw ReStructured text in the README rendered by Github.

### Implementation

- Github hosts the repository and renders README.md.
- readthedocs.org hosts the HTML and creates the PDF for offline use.
- Nearly everything is in README.md. These aren't:

  - index.rst - Top level of the Sphinx documentation.
  - about.rst - About the documentation (this page).
  - api.rst - Development tools API generated by
    Sphinx autodoc and napoleon.
  - recent_changes.md

### Tools

- Sphinx
- recommonmark

recommonmark enables Sphinx to parse Markdown files.

### Files

These files are at the project root:

- .readthedocs.yml
- index.rst
- README.md
- conf.py

Since conf.py is at the project root the entire project is
searched by Sphinx for document source files.  Additional
**exclude_patterns** keep out unwanted document source files.

The files below in the doc folder are not part of the documentation:

  - make_wrapped_examples.py
  - livelog.py
  - livelog_test_assertion.py
  - livelog_bad_session.py

### Read the Docs hosting

The Sphinx documentation is hosted by readthedocs.org.
The documentation build dependencies **doc/requirements.txt** are
pinned to what is currently available.

The links that start with '-' in the links section after the
license badge don't work in the developers build of Sphinx html
docs.  There is commented out code in tests/quick_links.py
to create the same links as Sphinx html suggests.  It is
not likely that code will be deployed. These links might
get renamed in a future version of phmdoctest.
