# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['l2r', 'l2r.core', 'l2r.env', 'l2r.track', 'l2r.utils']

package_data = \
{'': ['*'], 'l2r.track': ['anglesey/*', 'thruxton/*']}

install_requires = \
['Pillow>=7.2.0,<8.0.0',
 'PyYAML>=6.0,<7.0',
 'gast>=0.5,<0.6',
 'gym>=0.22,<0.23',
 'matplotlib>=3.4,<4.0',
 'numpy>=1.21,<2.0',
 'pyzmq>=19.0,<20.0',
 'requests>=2.18,<3.0',
 'scipy>=1.6,<2.0',
 'tqdm>=4.64,<5.0',
 'websocket_client>=1.3,<2.0']

setup_kwargs = {
    'name': 'l2r',
    'version': '0.0.1',
    'description': 'a OpenAI gym environment for high performance autonomous racing',
    'long_description': '# Learn-to-Race\n\nLearn-to-Race is an [OpenAI gym](https://gym.openai.com/) compliant, multimodal control environment where agents learn how to race. Unlike many simplistic learning environments, ours is built around Arrival’s high-fidelity racing simulator featuring full software-in-the-loop (SIL), and even hardware-in-the-loop (HIL), simulation capabilities. This simulator has played a key role in bringing autonomous racing technology to real life in the [Roborace series](https://roborace.com/), the world’s first extreme competition of teams developing self-driving AI.\n\n<div align="center">\n  <br>\n  <img src=\'./assets/imgs/main_figure.png\' alt=\'missing\'/ width=80%>\n  <p style="padding: 20px 20px 20px 20px;"><i>An overview of the Learn-to-Race framework</i></p>\n  <br>\n</div>\n\n## Documentation\n\nPlease visit our [official docs](https://learn-to-race.readthedocs.io) for a comprehensive guide on getting started with the environment. Happy racing!\n\n## Learn-to-Race Task\n\nWhile learning-based agents continue to demonstrate superhuman performance in many areas, we believe that they still lack in terms of generalization abilities and often require too many interactions. In summary, agents will have the ability to learn on training racetracks, but will be evaluated on their performance on an unseen evaluation track. However, the evaluation track is not *truly* unseen. Much like a Formula-1 driver, we will let agents interact with the new track for 60 minutes during a pre-evaluation stage before true evaluation.\n\n## Baseline Agents\n\nWe provide multiple baseline agents to demonstrate how to use Learn-to-Race including both classical and learning-based controllers. The first is a ``RandomActionAgent`` to show basic functionality. We also include a [Soft Actor-Critic](https://arxiv.org/abs/1801.01290v1) agent, *tabula rasa*, trained for 1000 epsiodes. On the Las Vegas track, it is able to consistently complete laps in under 2 minutes each using only visual features from the virtual camera as input.\n\n<div align="center">\n  <br>\n  <img src=\'./assets/imgs/lvms_1.gif\' alt=\'missing\'/ width=42%>\n  <p style="padding: 10px 15px 15px;"><i>Episode 1</i></p>\n  \n  <img src=\'./assets/imgs/lvms_100.gif\' alt=\'missing\' width=42%/>\n  <p style="padding: 10px 15px 15px;"><i>Episode 100</i></p>\n  \n  <img src=\'./assets/imgs/lvms_1000.gif\' alt=\'missing\' width=42%/>\n  <p style="padding: 10px 15px 15px;"><i>Episode 1000</i></p>\n  <br>\n</div>\n\n\n## Customizable Sensor Configurations\n\nOne of the key features of this environment is the ability to create arbitrary configurations of vehicle sensors. This provides users a rich sandbox for multimodal, learning based approaches. The following sensors are supported and can be placed, if applicable, at any location relative to the vehicle:\n\n- RGB cameras\n- Depth cameras\n- Ground truth segmentation cameras\n- Fisheye cameras\n- Ray trace LiDARs\n- Depth 2D LiDARs\n- Radars\n\nAdditionally, these sensors are parameterized and can be customized further; for example, cameras have modifiable image size, field-of-view, and exposure. We provide a sample configuration below which has front, birdseye, and side facing cameras both in RGB mode and with ground truth segmentation. \n\nLeft Facing                |  Front Facing             |  Right Facing             |  Birdseye\n:-------------------------:|:-------------------------:|:-------------------------:|:-------------------------:\n![LeftRGB](./assets/imgs/sample_vehicle_imgs/CameraLeftRGB.png)  | ![FrontRGB](./assets/imgs/sample_vehicle_imgs/CameraFrontRGB.png)  |  ![RightRGB](./assets/imgs/sample_vehicle_imgs/CameraRightRGB.png)  |  ![Front](./assets/imgs/sample_vehicle_imgs/CameraBirdsEye.png)\n![Left, Segmented](./assets/imgs/sample_vehicle_imgs/CameraLeftSegm.png) | ![Front, Segmented](./assets/imgs/sample_vehicle_imgs/CameraFrontSegm.png) |  ![Right, Segmented](./assets/imgs/sample_vehicle_imgs/CameraRightSegm.png) | ![Birdseye, Segmented](./assets/imgs/sample_vehicle_imgs/CameraBirdsSegm.png) \n\nPlease visit our documentation for more information about sensor customization.\n\n## Requirements\n\n**Python:** We use Learn-to-Race with Python 3.6 or 3.7.\n\n**Graphics Hardware:** An Nvidia graphics card & associated drives is required. An Nvidia 970 GTX graphics card is minimally sufficient to simply run the simulator, but a better card is recommended.\n\n**Docker:** Commonly, the racing simulator runs in a [Docker](https://www.docker.com/get-started) container.\n\n**Container GPU Access:** If running the simulator in a container, the container needs access to the GPU, so [nvidia-container-runtime](https://github.com/NVIDIA/nvidia-container-runtime) is also required.\n\n## Installation\n\nDue to the container GPU access requirement, this installation assumes a Linux operating system. If you do not have a Linux OS, we recommend running Learn-to-Race on a public cloud instance that has a sufficient GPU.\n\n1. Request access to the Racing simulator. We recommmend running the simulator as a Python subprocess which simply requires that you specify the path of the simulator in the ```env_kwargs.controller_kwargs.sim_path``` of your configuration file. Alternatively, you can run the simulator as a Docker container by setting ```env_kwargs.controller_kwargs.start_container``` to True. If you prefer the latter, you can load the docker image as follows:\n\n```bash\n$ docker load < arrival-sim-image.tar.gz\n```\n\n2. Download the source code from this repository and install the package requirements. We recommend using a virtual environment:\n\n```bash\n$ pip install virtualenv\n$ virtualenv venv                           # create new virtual environment\n$ source venv/bin/activate                  # activate the environment\n(venv) $ pip install -r requirements.txt \n```\n\n## Research\n\nPlease cite this work if you use L2R as a part of your research.\n\n```\n@misc{herman2021learntorace,\n      title={Learn-to-Race: A Multimodal Control Environment for Autonomous Racing}, \n      author={James Herman and Jonathan Francis and Siddha Ganju and Bingqing Chen and Anirudh Koul and Abhinav Gupta and Alexey Skabelkin and Ivan Zhukov and Andrey Gostev and Max Kumskoy and Eric Nyberg},\n      year={2021},\n      eprint={2103.11575},\n      archivePrefix={arXiv},\n      primaryClass={cs.RO}\n}\n``` \n',
    'author': 'Jimmy Herman',
    'author_email': 'jimmyherman29@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/learn-to-race/l2r',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
