/* Generated by re2c 1.1.1 on Fri Jul 31 19:38:26 2020 */
#line 1 "tokenizer.re"
#include <limits>

#include "tokenizer.h"
#include "parser.tab.hh"

namespace LFortran
{

void Tokenizer::set_string(const std::string &str)
{
    // The input string must be NULL terminated, otherwise the tokenizer will
    // not detect the end of string. After C++11, the std::string is guaranteed
    // to end with \0, but we check this here just in case.
    LFORTRAN_ASSERT(str[str.size()] == '\0');
    cur = (unsigned char *)(&str[0]);
    cur_line = cur;
    line_num = 1;
}

template<int base>
bool adddgt(unsigned long &u, unsigned long d)
{
    if (u > (std::numeric_limits<unsigned long>::max() - d) / base) {
        return false;
    }
    u = u * base + d;
    return true;
}

bool lex_dec(const unsigned char *s, const unsigned char *e, unsigned long &u)
{
    for (u = 0; s < e; ++s) {
        if (!adddgt<10>(u, *s - 0x30u)) {
            return false;
        }
    }
    return true;
}

#define KW(x) token(yylval.string); RET(KW_##x);
#define RET(x) token_loc(loc); return yytokentype::x;

int Tokenizer::lex(YYSTYPE &yylval, Location &loc)
{
	unsigned long u;
    for (;;) {
        tok = cur;
        
#line 52 "tokenizer.cpp"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,  24,  24,  24,  24,  24,  24,  24, 
		 24,  25,  24,  25,  24,  25,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 25,  24,  16,  24,  24,  24,  24,   8, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		158, 158, 158, 158, 158, 158, 158, 158, 
		158, 158,  24,  24,  24,  24,  24,  24, 
		 24, 156, 156, 156, 156, 156, 156, 156, 
		156, 156, 156, 156, 156, 156, 156, 156, 
		156, 156, 156, 156, 156, 156, 156, 156, 
		156, 156, 156,  24,  24,  24,  24, 216, 
		 24, 188, 188, 188, 188, 188, 188, 188, 
		188, 188, 188, 188, 188, 188, 188, 188, 
		188, 188, 188, 188, 188, 188, 188, 188, 
		188, 188, 188,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
		 24,  24,  24,  24,  24,  24,  24,  24, 
	};
	yych = *cur;
	if (yybm[0+yych] & 1) {
		goto yy6;
	}
	switch (yych) {
	case 0x00:	goto yy2;
	case '\t':
	case '\n':	goto yy9;
	case '"':	goto yy11;
	case '%':	goto yy12;
	case '\'':	goto yy14;
	case '(':	goto yy15;
	case ')':	goto yy17;
	case '*':	goto yy19;
	case '+':	goto yy21;
	case ',':	goto yy23;
	case '-':	goto yy25;
	case '.':	goto yy27;
	case '/':	goto yy28;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy30;
	case ':':	goto yy33;
	case ';':	goto yy35;
	case '<':	goto yy37;
	case '=':	goto yy39;
	case '>':	goto yy41;
	case 'A':
	case 'a':	goto yy43;
	case 'B':
	case 'b':	goto yy45;
	case 'C':
	case 'c':	goto yy46;
	case 'D':
	case 'd':	goto yy47;
	case 'E':
	case 'e':	goto yy48;
	case 'F':
	case 'f':	goto yy49;
	case 'G':
	case 'g':	goto yy50;
	case 'H':
	case 'J':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'h':
	case 'j':
	case 'x':
	case 'y':
	case 'z':	goto yy51;
	case 'I':
	case 'i':	goto yy53;
	case 'K':
	case 'k':	goto yy54;
	case 'L':
	case 'l':	goto yy55;
	case 'M':
	case 'm':	goto yy56;
	case 'N':
	case 'n':	goto yy57;
	case 'O':
	case 'o':	goto yy58;
	case 'P':
	case 'p':	goto yy59;
	case 'Q':
	case 'q':	goto yy60;
	case 'R':
	case 'r':	goto yy61;
	case 'S':
	case 's':	goto yy62;
	case 'T':
	case 't':	goto yy63;
	case 'U':
	case 'u':	goto yy64;
	case 'V':
	case 'v':	goto yy65;
	case 'W':
	case 'w':	goto yy66;
	case '[':	goto yy67;
	case ']':	goto yy69;
	case '|':	goto yy71;
	default:	goto yy4;
	}
yy2:
	++cur;
#line 73 "tokenizer.re"
	{ RET(END_OF_FILE); }
#line 186 "tokenizer.cpp"
yy4:
	++cur;
yy5:
#line 68 "tokenizer.re"
	{ token_loc(loc);
                std::string t = token();
                throw LFortran::TokenizerError("token '" + t
                    + "' is not recognized", loc, t);
            }
#line 196 "tokenizer.cpp"
yy6:
	yych = *++cur;
	if (yybm[0+yych] & 1) {
		goto yy6;
	}
#line 74 "tokenizer.re"
	{ continue; }
#line 204 "tokenizer.cpp"
yy9:
	++cur;
#line 212 "tokenizer.re"
	{
                    token_loc(loc); line_num++; cur_line=cur;
                    return yytokentype::TK_NEWLINE;
            }
#line 212 "tokenizer.cpp"
yy11:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy5;
	goto yy74;
yy12:
	++cur;
#line 228 "tokenizer.re"
	{ RET(TK_PERCENT) }
#line 222 "tokenizer.cpp"
yy14:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy5;
	goto yy79;
yy15:
	++cur;
#line 218 "tokenizer.re"
	{ RET(TK_LPAREN) }
#line 232 "tokenizer.cpp"
yy17:
	++cur;
#line 219 "tokenizer.re"
	{ RET(TK_RPAREN) }
#line 237 "tokenizer.cpp"
yy19:
	yych = *++cur;
	if (yych == '*') goto yy82;
#line 230 "tokenizer.re"
	{ RET(TK_STAR) }
#line 243 "tokenizer.cpp"
yy21:
	++cur;
#line 222 "tokenizer.re"
	{ RET(TK_PLUS) }
#line 248 "tokenizer.cpp"
yy23:
	++cur;
#line 229 "tokenizer.re"
	{ RET(TK_COMMA) }
#line 253 "tokenizer.cpp"
yy25:
	++cur;
#line 223 "tokenizer.re"
	{ RET(TK_MINUS) }
#line 258 "tokenizer.cpp"
yy27:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 'f') {
		if (yych <= '9') {
			if (yych == '.') goto yy84;
			if (yych <= '/') goto yy5;
			goto yy86;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy5;
				goto yy89;
			} else {
				if (yych <= 'd') goto yy90;
				if (yych <= 'e') goto yy92;
				goto yy93;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'k') {
				if (yych <= 'g') goto yy94;
				goto yy90;
			} else {
				if (yych <= 'l') goto yy95;
				if (yych <= 'm') goto yy90;
				goto yy96;
			}
		} else {
			if (yych <= 's') {
				if (yych <= 'o') goto yy97;
				goto yy90;
			} else {
				if (yych <= 't') goto yy98;
				if (yych <= 'z') goto yy90;
				goto yy5;
			}
		}
	}
yy28:
	yych = *++cur;
	if (yych == '/') goto yy99;
	if (yych == '=') goto yy101;
#line 227 "tokenizer.re"
	{ RET(TK_SLASH) }
#line 304 "tokenizer.cpp"
yy30:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 2) {
		goto yy30;
	}
	if (yych <= 'E') {
		if (yych == '.') {
			ctxmar = cur;
			goto yy103;
		}
		if (yych >= 'D') goto yy104;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto yy105;
		} else {
			if (yych <= 'c') goto yy32;
			if (yych <= 'e') goto yy104;
		}
	}
yy32:
#line 279 "tokenizer.re"
	{
                if (lex_dec(tok, cur, u)) {
                    yylval.n = u;
                    RET(TK_INTEGER)
                } else {
                    token_loc(loc);
                    std::string t = token();
                    throw LFortran::TokenizerError("Integer too large",
                        loc, t);
                }
            }
#line 338 "tokenizer.cpp"
yy33:
	yych = *++cur;
	if (yych == ':') goto yy106;
#line 225 "tokenizer.re"
	{ RET(TK_COLON) }
#line 344 "tokenizer.cpp"
yy35:
	++cur;
#line 226 "tokenizer.re"
	{ RET(TK_SEMICOLON) }
#line 349 "tokenizer.cpp"
yy37:
	yych = *++cur;
	if (yych == '=') goto yy108;
yy38:
#line 243 "tokenizer.re"
	{ RET(TK_LT) }
#line 356 "tokenizer.cpp"
yy39:
	yych = *++cur;
	if (yych <= '<') goto yy40;
	if (yych <= '=') goto yy110;
	if (yych <= '>') goto yy112;
yy40:
#line 224 "tokenizer.re"
	{ RET(TK_EQUAL) }
#line 365 "tokenizer.cpp"
yy41:
	yych = *++cur;
	if (yych == '=') goto yy114;
yy42:
#line 245 "tokenizer.re"
	{ RET(TK_GT) }
#line 372 "tokenizer.cpp"
yy43:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'K') {
			if (yych == 'B') goto yy116;
			goto yy52;
		} else {
			if (yych <= 'L') goto yy117;
			if (yych <= 'R') goto yy52;
			goto yy118;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'b') goto yy116;
			goto yy52;
		} else {
			if (yych <= 'l') goto yy117;
			if (yych == 's') goto yy118;
			goto yy52;
		}
	}
yy44:
#line 295 "tokenizer.re"
	{ token(yylval.string); RET(TK_NAME) }
#line 397 "tokenizer.cpp"
yy45:
	yych = *++cur;
	if (yych <= 'L') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy121;
			goto yy52;
		} else {
			if (yych <= 'I') goto yy122;
			if (yych <= 'K') goto yy52;
			goto yy123;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy121;
			goto yy52;
		} else {
			if (yych <= 'i') goto yy122;
			if (yych == 'l') goto yy123;
			goto yy52;
		}
	}
yy46:
	yych = *++cur;
	switch (yych) {
	case 'A':
	case 'a':	goto yy124;
	case 'H':
	case 'h':	goto yy125;
	case 'L':
	case 'l':	goto yy126;
	case 'O':
	case 'o':	goto yy127;
	case 'R':
	case 'r':	goto yy128;
	case 'Y':
	case 'y':	goto yy129;
	default:	goto yy52;
	}
yy47:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych <= 'E') {
			if (yych == 'A') goto yy130;
			if (yych <= 'D') goto yy52;
			goto yy131;
		} else {
			if (yych == 'I') goto yy132;
			if (yych <= 'N') goto yy52;
			goto yy133;
		}
	} else {
		if (yych <= 'e') {
			if (yych == 'a') goto yy130;
			if (yych <= 'd') goto yy52;
			goto yy131;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy52;
				goto yy132;
			} else {
				if (yych == 'o') goto yy133;
				goto yy52;
			}
		}
	}
yy48:
	yych = *++cur;
	switch (yych) {
	case 'L':
	case 'l':	goto yy135;
	case 'N':
	case 'n':	goto yy136;
	case 'Q':
	case 'q':	goto yy137;
	case 'R':
	case 'r':	goto yy138;
	case 'X':
	case 'x':	goto yy139;
	default:	goto yy52;
	}
yy49:
	yych = *++cur;
	switch (yych) {
	case 'I':
	case 'i':	goto yy140;
	case 'L':
	case 'l':	goto yy141;
	case 'O':
	case 'o':	goto yy142;
	case 'U':
	case 'u':	goto yy143;
	default:	goto yy52;
	}
yy50:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy144;
		if (yych <= 'N') goto yy52;
		goto yy145;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy52;
			goto yy144;
		} else {
			if (yych == 'o') goto yy145;
			goto yy52;
		}
	}
yy51:
	yych = *++cur;
yy52:
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
	goto yy44;
yy53:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'L') {
			if (yych == 'F') goto yy147;
			goto yy52;
		} else {
			if (yych <= 'M') goto yy149;
			if (yych <= 'N') goto yy150;
			if (yych <= 'R') goto yy52;
			goto yy152;
		}
	} else {
		if (yych <= 'm') {
			if (yych == 'f') goto yy147;
			if (yych <= 'l') goto yy52;
			goto yy149;
		} else {
			if (yych <= 'n') goto yy150;
			if (yych == 's') goto yy152;
			goto yy52;
		}
	}
yy54:
	yych = *++cur;
	if (yych == 'I') goto yy154;
	if (yych == 'i') goto yy154;
	goto yy52;
yy55:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy155;
		if (yych <= 'N') goto yy52;
		goto yy156;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy52;
			goto yy155;
		} else {
			if (yych == 'o') goto yy156;
			goto yy52;
		}
	}
yy56:
	yych = *++cur;
	if (yych == 'O') goto yy157;
	if (yych == 'o') goto yy157;
	goto yy52;
yy57:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'A') goto yy158;
			goto yy52;
		} else {
			if (yych <= 'O') goto yy159;
			if (yych <= 'T') goto yy52;
			goto yy160;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'a') goto yy158;
			goto yy52;
		} else {
			if (yych <= 'o') goto yy159;
			if (yych == 'u') goto yy160;
			goto yy52;
		}
	}
yy58:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'O') {
			if (yych == 'N') goto yy161;
			goto yy52;
		} else {
			if (yych <= 'P') goto yy162;
			if (yych <= 'T') goto yy52;
			goto yy163;
		}
	} else {
		if (yych <= 'o') {
			if (yych == 'n') goto yy161;
			goto yy52;
		} else {
			if (yych <= 'p') goto yy162;
			if (yych == 'u') goto yy163;
			goto yy52;
		}
	}
yy59:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'O') {
			if (yych == 'A') goto yy164;
			if (yych <= 'N') goto yy52;
			goto yy165;
		} else {
			if (yych == 'R') goto yy166;
			if (yych <= 'T') goto yy52;
			goto yy167;
		}
	} else {
		if (yych <= 'o') {
			if (yych == 'a') goto yy164;
			if (yych <= 'n') goto yy52;
			goto yy165;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy52;
				goto yy166;
			} else {
				if (yych == 'u') goto yy167;
				goto yy52;
			}
		}
	}
yy60:
	yych = *++cur;
	if (yych == 'U') goto yy168;
	if (yych == 'u') goto yy168;
	goto yy52;
yy61:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy169;
		if (yych <= 'D') goto yy52;
		goto yy170;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy52;
			goto yy169;
		} else {
			if (yych == 'e') goto yy170;
			goto yy52;
		}
	}
yy62:
	yych = *++cur;
	switch (yych) {
	case 'A':
	case 'a':	goto yy171;
	case 'E':
	case 'e':	goto yy172;
	case 'H':
	case 'h':	goto yy173;
	case 'O':
	case 'o':	goto yy174;
	case 'T':
	case 't':	goto yy175;
	case 'U':
	case 'u':	goto yy176;
	default:	goto yy52;
	}
yy63:
	yych = *++cur;
	switch (yych) {
	case 'A':
	case 'a':	goto yy177;
	case 'E':
	case 'e':	goto yy178;
	case 'H':
	case 'h':	goto yy179;
	case 'O':
	case 'o':	goto yy180;
	case 'Y':
	case 'y':	goto yy182;
	default:	goto yy52;
	}
yy64:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'N') goto yy183;
		if (yych <= 'R') goto yy52;
		goto yy184;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy52;
			goto yy183;
		} else {
			if (yych == 's') goto yy184;
			goto yy52;
		}
	}
yy65:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy185;
		if (yych <= 'N') goto yy52;
		goto yy186;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy52;
			goto yy185;
		} else {
			if (yych == 'o') goto yy186;
			goto yy52;
		}
	}
yy66:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'H') goto yy187;
		if (yych <= 'Q') goto yy52;
		goto yy188;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy52;
			goto yy187;
		} else {
			if (yych == 'r') goto yy188;
			goto yy52;
		}
	}
yy67:
	++cur;
#line 220 "tokenizer.re"
	{ RET(TK_LBRACKET) }
#line 732 "tokenizer.cpp"
yy69:
	++cur;
#line 221 "tokenizer.re"
	{ RET(TK_RBRACKET) }
#line 737 "tokenizer.cpp"
yy71:
	++cur;
#line 231 "tokenizer.re"
	{ RET(TK_VBAR) }
#line 742 "tokenizer.cpp"
yy73:
	yych = *++cur;
yy74:
	if (yybm[0+yych] & 8) {
		goto yy73;
	}
	if (yych >= 0x01) goto yy76;
yy75:
	cur = mar;
	if (yyaccept <= 4) {
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy5;
				} else {
					goto yy32;
				}
			} else {
				goto yy77;
			}
		} else {
			if (yyaccept == 3) {
				goto yy81;
			} else {
				goto yy88;
			}
		}
	} else {
		if (yyaccept <= 6) {
			if (yyaccept == 5) {
				goto yy44;
			} else {
				goto yy240;
			}
		} else {
			if (yyaccept == 7) {
				goto yy583;
			} else {
				goto yy682;
			}
		}
	}
yy76:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy73;
yy77:
#line 291 "tokenizer.re"
	{ token(yylval.string); RET(TK_STRING) }
#line 792 "tokenizer.cpp"
yy78:
	yych = *++cur;
yy79:
	if (yybm[0+yych] & 16) {
		goto yy78;
	}
	if (yych <= 0x00) goto yy75;
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yych == '\'') goto yy78;
yy81:
#line 292 "tokenizer.re"
	{ token(yylval.string); RET(TK_STRING) }
#line 806 "tokenizer.cpp"
yy82:
	++cur;
#line 236 "tokenizer.re"
	{ RET(TK_POW) }
#line 811 "tokenizer.cpp"
yy84:
	++cur;
#line 234 "tokenizer.re"
	{ RET(TK_DBL_DOT) }
#line 816 "tokenizer.cpp"
yy86:
	yyaccept = 4;
	yych = *(mar = ++cur);
yy87:
	if (yych <= 'E') {
		if (yych <= '/') goto yy88;
		if (yych <= '9') goto yy86;
		if (yych >= 'D') goto yy104;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto yy189;
		} else {
			if (yych <= 'c') goto yy88;
			if (yych <= 'e') goto yy104;
		}
	}
yy88:
#line 278 "tokenizer.re"
	{ token(yylval.string); RET(TK_REAL) }
#line 836 "tokenizer.cpp"
yy89:
	yych = *++cur;
	if (yych == 'n') goto yy192;
	goto yy91;
yy90:
	yych = *++cur;
yy91:
	if (yybm[0+yych] & 32) {
		goto yy90;
	}
	if (yych == '.') goto yy190;
	goto yy75;
yy92:
	yych = *++cur;
	if (yych == 'q') goto yy193;
	goto yy91;
yy93:
	yych = *++cur;
	if (yych == 'a') goto yy194;
	goto yy91;
yy94:
	yych = *++cur;
	if (yych == 'e') goto yy195;
	if (yych == 't') goto yy196;
	goto yy91;
yy95:
	yych = *++cur;
	if (yych == 'e') goto yy197;
	if (yych == 't') goto yy198;
	goto yy91;
yy96:
	yych = *++cur;
	if (yych == 'e') goto yy199;
	if (yych == 'o') goto yy200;
	goto yy91;
yy97:
	yych = *++cur;
	if (yych == 'r') goto yy201;
	goto yy91;
yy98:
	yych = *++cur;
	if (yych == 'r') goto yy202;
	goto yy91;
yy99:
	++cur;
#line 237 "tokenizer.re"
	{ RET(TK_CONCAT) }
#line 884 "tokenizer.cpp"
yy101:
	++cur;
#line 242 "tokenizer.re"
	{ RET(TK_NE) }
#line 889 "tokenizer.cpp"
yy103:
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yych <= '`') goto yy87;
	if (yych <= 'c') goto yy203;
	if (yych <= 'e') goto yy205;
	if (yych <= 'z') goto yy203;
	goto yy87;
yy104:
	yych = *++cur;
	if (yych <= ',') {
		if (yych == '+') goto yy206;
		goto yy75;
	} else {
		if (yych <= '-') goto yy206;
		if (yych <= '/') goto yy75;
		if (yych <= '9') goto yy207;
		goto yy75;
	}
yy105:
	yych = *++cur;
	if (yych <= '9') {
		if (yych <= '&') {
			if (yych == '"') goto yy73;
			goto yy75;
		} else {
			if (yych <= '\'') goto yy78;
			if (yych <= '/') goto yy75;
			goto yy209;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy75;
			if (yych <= 'Z') goto yy211;
			goto yy75;
		} else {
			if (yych == '`') goto yy75;
			if (yych <= 'z') goto yy211;
			goto yy75;
		}
	}
yy106:
	++cur;
#line 235 "tokenizer.re"
	{ RET(TK_DBL_COLON) }
#line 935 "tokenizer.cpp"
yy108:
	++cur;
#line 244 "tokenizer.re"
	{ RET(TK_LE) }
#line 940 "tokenizer.cpp"
yy110:
	++cur;
#line 241 "tokenizer.re"
	{ RET(TK_EQ) }
#line 945 "tokenizer.cpp"
yy112:
	++cur;
#line 238 "tokenizer.re"
	{ RET(TK_ARROW) }
#line 950 "tokenizer.cpp"
yy114:
	++cur;
#line 246 "tokenizer.re"
	{ RET(TK_GE) }
#line 955 "tokenizer.cpp"
yy116:
	yych = *++cur;
	if (yych == 'S') goto yy213;
	if (yych == 's') goto yy213;
	goto yy52;
yy117:
	yych = *++cur;
	if (yych == 'L') goto yy214;
	if (yych == 'l') goto yy214;
	goto yy52;
yy118:
	yych = *++cur;
	if (yych <= 'Y') {
		if (yych == 'S') goto yy216;
		if (yych <= 'X') goto yy52;
		goto yy217;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy52;
			goto yy216;
		} else {
			if (yych == 'y') goto yy217;
			goto yy52;
		}
	}
yy119:
	yyaccept = 5;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych <= '&') {
		if (yych == '"') goto yy73;
		goto yy44;
	} else {
		if (yych <= '\'') goto yy78;
		if (yych == '_') goto yy119;
		goto yy44;
	}
yy121:
	yych = *++cur;
	if (yych == 'C') goto yy218;
	if (yych == 'c') goto yy218;
	goto yy52;
yy122:
	yych = *++cur;
	if (yych == 'N') goto yy219;
	if (yych == 'n') goto yy219;
	goto yy52;
yy123:
	yych = *++cur;
	if (yych == 'O') goto yy220;
	if (yych == 'o') goto yy220;
	goto yy52;
yy124:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'L') goto yy221;
		if (yych <= 'R') goto yy52;
		goto yy222;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy52;
			goto yy221;
		} else {
			if (yych == 's') goto yy222;
			goto yy52;
		}
	}
yy125:
	yych = *++cur;
	if (yych == 'A') goto yy223;
	if (yych == 'a') goto yy223;
	goto yy52;
yy126:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy224;
		if (yych <= 'N') goto yy52;
		goto yy225;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy52;
			goto yy224;
		} else {
			if (yych == 'o') goto yy225;
			goto yy52;
		}
	}
yy127:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy52;
			goto yy226;
		} else {
			if (yych <= 'L') goto yy52;
			if (yych <= 'M') goto yy227;
			goto yy228;
		}
	} else {
		if (yych <= 'l') {
			if (yych == 'd') goto yy226;
			goto yy52;
		} else {
			if (yych <= 'm') goto yy227;
			if (yych <= 'n') goto yy228;
			goto yy52;
		}
	}
yy128:
	yych = *++cur;
	if (yych == 'I') goto yy229;
	if (yych == 'i') goto yy229;
	goto yy52;
yy129:
	yych = *++cur;
	if (yych == 'C') goto yy230;
	if (yych == 'c') goto yy230;
	goto yy52;
yy130:
	yych = *++cur;
	if (yych == 'T') goto yy231;
	if (yych == 't') goto yy231;
	goto yy52;
yy131:
	yych = *++cur;
	if (yych <= 'F') {
		if (yych == 'A') goto yy232;
		if (yych <= 'E') goto yy52;
		goto yy233;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy52;
			goto yy232;
		} else {
			if (yych == 'f') goto yy233;
			goto yy52;
		}
	}
yy132:
	yych = *++cur;
	if (yych == 'M') goto yy234;
	if (yych == 'm') goto yy234;
	goto yy52;
yy133:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy119;
	}
	if (yych <= 'W') {
		if (yych <= '@') {
			if (yych <= '/') goto yy134;
			if (yych <= '9') goto yy51;
		} else {
			if (yych == 'U') goto yy235;
			if (yych <= 'V') goto yy51;
			goto yy236;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy51;
			if (yych <= '`') goto yy134;
			if (yych <= 't') goto yy51;
			goto yy235;
		} else {
			if (yych == 'w') goto yy236;
			if (yych <= 'z') goto yy51;
		}
	}
yy134:
#line 106 "tokenizer.re"
	{ KW(DO) }
#line 1129 "tokenizer.cpp"
yy135:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'E') goto yy237;
		if (yych <= 'R') goto yy52;
		goto yy238;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy52;
			goto yy237;
		} else {
			if (yych == 's') goto yy238;
			goto yy52;
		}
	}
yy136:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy52;
			goto yy239;
		} else {
			if (yych <= 'S') goto yy52;
			if (yych <= 'T') goto yy241;
			goto yy242;
		}
	} else {
		if (yych <= 's') {
			if (yych == 'd') goto yy239;
			goto yy52;
		} else {
			if (yych <= 't') goto yy241;
			if (yych <= 'u') goto yy242;
			goto yy52;
		}
	}
yy137:
	yych = *++cur;
	if (yych == 'U') goto yy243;
	if (yych == 'u') goto yy243;
	goto yy52;
yy138:
	yych = *++cur;
	if (yych == 'R') goto yy244;
	if (yych == 'r') goto yy244;
	goto yy52;
yy139:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'I') goto yy245;
		if (yych <= 'S') goto yy52;
		goto yy246;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy52;
			goto yy245;
		} else {
			if (yych == 't') goto yy246;
			goto yy52;
		}
	}
yy140:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'L') goto yy247;
		if (yych <= 'M') goto yy52;
		goto yy248;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy52;
			goto yy247;
		} else {
			if (yych == 'n') goto yy248;
			goto yy52;
		}
	}
yy141:
	yych = *++cur;
	if (yych == 'U') goto yy249;
	if (yych == 'u') goto yy249;
	goto yy52;
yy142:
	yych = *++cur;
	if (yych == 'R') goto yy250;
	if (yych == 'r') goto yy250;
	goto yy52;
yy143:
	yych = *++cur;
	if (yych == 'N') goto yy251;
	if (yych == 'n') goto yy251;
	goto yy52;
yy144:
	yych = *++cur;
	if (yych == 'N') goto yy252;
	if (yych == 'n') goto yy252;
	goto yy52;
yy145:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 135 "tokenizer.re"
	{ KW(GO) }
#line 1234 "tokenizer.cpp"
yy147:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 136 "tokenizer.re"
	{ KW(IF) }
#line 1243 "tokenizer.cpp"
yy149:
	yych = *++cur;
	if (yych == 'P') goto yy253;
	if (yych == 'p') goto yy253;
	goto yy52;
yy150:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy119;
	}
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= '9') {
				if (yych >= '0') goto yy51;
			} else {
				if (yych <= '@') goto yy151;
				if (yych <= 'B') goto yy51;
				goto yy254;
			}
		} else {
			if (yych <= 'P') {
				if (yych == 'O') goto yy255;
				goto yy51;
			} else {
				if (yych <= 'Q') goto yy256;
				if (yych <= 'S') goto yy51;
				goto yy257;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'b') {
				if (yych <= 'Z') goto yy51;
				if (yych >= 'a') goto yy51;
			} else {
				if (yych <= 'c') goto yy254;
				if (yych <= 'n') goto yy51;
				goto yy255;
			}
		} else {
			if (yych <= 's') {
				if (yych == 'q') goto yy256;
				goto yy51;
			} else {
				if (yych <= 't') goto yy257;
				if (yych <= 'z') goto yy51;
			}
		}
	}
yy151:
#line 140 "tokenizer.re"
	{ KW(IN) }
#line 1296 "tokenizer.cpp"
yy152:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 148 "tokenizer.re"
	{ KW(IS) }
#line 1305 "tokenizer.cpp"
yy154:
	yych = *++cur;
	if (yych == 'N') goto yy258;
	if (yych == 'n') goto yy258;
	goto yy52;
yy155:
	yych = *++cur;
	if (yych == 'N') goto yy259;
	if (yych == 'n') goto yy259;
	goto yy52;
yy156:
	yych = *++cur;
	if (yych <= 'G') {
		if (yych == 'C') goto yy261;
		if (yych <= 'F') goto yy52;
		goto yy262;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy52;
			goto yy261;
		} else {
			if (yych == 'g') goto yy262;
			goto yy52;
		}
	}
yy157:
	yych = *++cur;
	if (yych <= 'L') {
		if (yych == 'D') goto yy263;
		if (yych <= 'K') goto yy52;
		goto yy264;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy52;
			goto yy263;
		} else {
			if (yych == 'l') goto yy264;
			goto yy52;
		}
	}
yy158:
	yych = *++cur;
	if (yych == 'M') goto yy265;
	if (yych == 'm') goto yy265;
	goto yy52;
yy159:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'N') goto yy266;
		if (yych <= 'O') goto yy52;
		goto yy267;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy52;
			goto yy266;
		} else {
			if (yych == 'p') goto yy267;
			goto yy52;
		}
	}
yy160:
	yych = *++cur;
	if (yych == 'L') goto yy268;
	if (yych == 'l') goto yy268;
	goto yy52;
yy161:
	yych = *++cur;
	if (yych == 'L') goto yy269;
	if (yych == 'l') goto yy269;
	goto yy52;
yy162:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'E') goto yy270;
		if (yych <= 'S') goto yy52;
		goto yy271;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy52;
			goto yy270;
		} else {
			if (yych == 't') goto yy271;
			goto yy52;
		}
	}
yy163:
	yych = *++cur;
	if (yych == 'T') goto yy272;
	if (yych == 't') goto yy272;
	goto yy52;
yy164:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'Q') goto yy52;
		if (yych <= 'R') goto yy274;
		goto yy275;
	} else {
		if (yych <= 'q') goto yy52;
		if (yych <= 'r') goto yy274;
		if (yych <= 's') goto yy275;
		goto yy52;
	}
yy165:
	yych = *++cur;
	if (yych == 'I') goto yy276;
	if (yych == 'i') goto yy276;
	goto yy52;
yy166:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'E') goto yy277;
			goto yy52;
		} else {
			if (yych <= 'I') goto yy278;
			if (yych <= 'N') goto yy52;
			goto yy279;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'e') goto yy277;
			goto yy52;
		} else {
			if (yych <= 'i') goto yy278;
			if (yych == 'o') goto yy279;
			goto yy52;
		}
	}
yy167:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'B') goto yy280;
		if (yych <= 'Q') goto yy52;
		goto yy281;
	} else {
		if (yych <= 'b') {
			if (yych <= 'a') goto yy52;
			goto yy280;
		} else {
			if (yych == 'r') goto yy281;
			goto yy52;
		}
	}
yy168:
	yych = *++cur;
	if (yych == 'I') goto yy282;
	if (yych == 'i') goto yy282;
	goto yy52;
yy169:
	yych = *++cur;
	if (yych == 'N') goto yy283;
	if (yych == 'n') goto yy283;
	goto yy52;
yy170:
	yych = *++cur;
	if (yych <= 'W') {
		if (yych <= 'C') {
			if (yych == 'A') goto yy284;
			if (yych <= 'B') goto yy52;
			goto yy285;
		} else {
			if (yych <= 'S') {
				if (yych <= 'R') goto yy52;
				goto yy286;
			} else {
				if (yych <= 'T') goto yy287;
				if (yych <= 'V') goto yy52;
				goto yy288;
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'a') {
				if (yych <= '`') goto yy52;
				goto yy284;
			} else {
				if (yych == 'c') goto yy285;
				goto yy52;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy286;
				goto yy287;
			} else {
				if (yych == 'w') goto yy288;
				goto yy52;
			}
		}
	}
yy171:
	yych = *++cur;
	if (yych == 'V') goto yy289;
	if (yych == 'v') goto yy289;
	goto yy52;
yy172:
	yych = *++cur;
	if (yych <= 'Q') {
		if (yych == 'L') goto yy290;
		if (yych <= 'P') goto yy52;
		goto yy291;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy52;
			goto yy290;
		} else {
			if (yych == 'q') goto yy291;
			goto yy52;
		}
	}
yy173:
	yych = *++cur;
	if (yych == 'A') goto yy292;
	if (yych == 'a') goto yy292;
	goto yy52;
yy174:
	yych = *++cur;
	if (yych == 'U') goto yy293;
	if (yych == 'u') goto yy293;
	goto yy52;
yy175:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy294;
		if (yych <= 'N') goto yy52;
		goto yy295;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy52;
			goto yy294;
		} else {
			if (yych == 'o') goto yy295;
			goto yy52;
		}
	}
yy176:
	yych = *++cur;
	if (yych == 'B') goto yy296;
	if (yych == 'b') goto yy296;
	goto yy52;
yy177:
	yych = *++cur;
	if (yych == 'R') goto yy297;
	if (yych == 'r') goto yy297;
	goto yy52;
yy178:
	yych = *++cur;
	if (yych == 'A') goto yy298;
	if (yych == 'a') goto yy298;
	goto yy52;
yy179:
	yych = *++cur;
	if (yych == 'E') goto yy299;
	if (yych == 'e') goto yy299;
	goto yy52;
yy180:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 201 "tokenizer.re"
	{ KW(TO) }
#line 1568 "tokenizer.cpp"
yy182:
	yych = *++cur;
	if (yych == 'P') goto yy300;
	if (yych == 'p') goto yy300;
	goto yy52;
yy183:
	yych = *++cur;
	if (yych == 'F') goto yy301;
	if (yych == 'f') goto yy301;
	goto yy52;
yy184:
	yych = *++cur;
	if (yych == 'E') goto yy302;
	if (yych == 'e') goto yy302;
	goto yy52;
yy185:
	yych = *++cur;
	if (yych == 'L') goto yy304;
	if (yych == 'l') goto yy304;
	goto yy52;
yy186:
	yych = *++cur;
	if (yych == 'L') goto yy305;
	if (yych == 'l') goto yy305;
	goto yy52;
yy187:
	yych = *++cur;
	if (yych <= 'I') {
		if (yych == 'E') goto yy306;
		if (yych <= 'H') goto yy52;
		goto yy307;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy52;
			goto yy306;
		} else {
			if (yych == 'i') goto yy307;
			goto yy52;
		}
	}
yy188:
	yych = *++cur;
	if (yych == 'I') goto yy308;
	if (yych == 'i') goto yy308;
	goto yy52;
yy189:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy75;
		if (yych <= '9') goto yy309;
		if (yych <= '@') goto yy75;
		goto yy311;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy75;
			goto yy311;
		} else {
			if (yych <= '`') goto yy75;
			if (yych <= 'z') goto yy311;
			goto yy75;
		}
	}
yy190:
	++cur;
#line 294 "tokenizer.re"
	{ token(yylval.string); RET(TK_DEF_OP) }
#line 1635 "tokenizer.cpp"
yy192:
	yych = *++cur;
	if (yych == 'd') goto yy313;
	goto yy91;
yy193:
	yych = *++cur;
	if (yych == '.') goto yy110;
	if (yych == 'v') goto yy314;
	goto yy91;
yy194:
	yych = *++cur;
	if (yych == 'l') goto yy315;
	goto yy91;
yy195:
	yych = *++cur;
	if (yych == '.') goto yy114;
	goto yy91;
yy196:
	yych = *++cur;
	if (yych == '.') goto yy316;
	goto yy91;
yy197:
	yych = *++cur;
	if (yych == '.') goto yy108;
	goto yy91;
yy198:
	yych = *++cur;
	if (yych == '.') goto yy317;
	goto yy91;
yy199:
	yych = *++cur;
	if (yych == '.') goto yy101;
	if (yych == 'q') goto yy318;
	goto yy91;
yy200:
	yych = *++cur;
	if (yych == 't') goto yy319;
	goto yy91;
yy201:
	yych = *++cur;
	if (yych == '.') goto yy320;
	goto yy91;
yy202:
	yych = *++cur;
	if (yych == 'u') goto yy322;
	goto yy91;
yy203:
	yych = *++cur;
yy204:
	if (yych == '.') goto yy323;
	if (yych <= '`') goto yy75;
	if (yych <= 'z') goto yy203;
	goto yy75;
yy205:
	yych = *++cur;
	if (yych <= ',') {
		if (yych != '+') goto yy204;
	} else {
		if (yych <= '-') goto yy206;
		if (yych <= '/') goto yy204;
		if (yych <= '9') goto yy207;
		goto yy204;
	}
yy206:
	yych = *++cur;
	if (yych <= '/') goto yy75;
	if (yych >= ':') goto yy75;
yy207:
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yych <= '/') goto yy88;
	if (yych <= '9') goto yy207;
	if (yych == '_') goto yy189;
	goto yy88;
yy209:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych == '.') {
		ctxmar = cur;
		goto yy325;
	}
	if (yych <= '/') goto yy32;
	if (yych <= '9') goto yy209;
	goto yy32;
yy211:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 128) {
		goto yy211;
	}
	if (yych == '.') {
		ctxmar = cur;
		goto yy325;
	}
	goto yy32;
yy213:
	yych = *++cur;
	if (yych == 'T') goto yy326;
	if (yych == 't') goto yy326;
	goto yy52;
yy214:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy119;
	}
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych >= '0') goto yy51;
		} else {
			if (yych <= '@') goto yy215;
			if (yych <= 'N') goto yy51;
			goto yy327;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy51;
			if (yych >= 'a') goto yy51;
		} else {
			if (yych <= 'o') goto yy327;
			if (yych <= 'z') goto yy51;
		}
	}
yy215:
#line 78 "tokenizer.re"
	{ KW(ALL) }
#line 1761 "tokenizer.cpp"
yy216:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'I') goto yy328;
		if (yych <= 'N') goto yy52;
		goto yy329;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy52;
			goto yy328;
		} else {
			if (yych == 'o') goto yy329;
			goto yy52;
		}
	}
yy217:
	yych = *++cur;
	if (yych == 'N') goto yy330;
	if (yych == 'n') goto yy330;
	goto yy52;
yy218:
	yych = *++cur;
	if (yych == 'K') goto yy331;
	if (yych == 'k') goto yy331;
	goto yy52;
yy219:
	yych = *++cur;
	if (yych == 'D') goto yy332;
	if (yych == 'd') goto yy332;
	goto yy52;
yy220:
	yych = *++cur;
	if (yych == 'C') goto yy334;
	if (yych == 'c') goto yy334;
	goto yy52;
yy221:
	yych = *++cur;
	if (yych == 'L') goto yy335;
	if (yych == 'l') goto yy335;
	goto yy52;
yy222:
	yych = *++cur;
	if (yych == 'E') goto yy337;
	if (yych == 'e') goto yy337;
	goto yy52;
yy223:
	yych = *++cur;
	if (yych == 'R') goto yy339;
	if (yych == 'r') goto yy339;
	goto yy52;
yy224:
	yych = *++cur;
	if (yych == 'S') goto yy340;
	if (yych == 's') goto yy340;
	goto yy52;
yy225:
	yych = *++cur;
	if (yych == 'S') goto yy341;
	if (yych == 's') goto yy341;
	goto yy52;
yy226:
	yych = *++cur;
	if (yych == 'I') goto yy342;
	if (yych == 'i') goto yy342;
	goto yy52;
yy227:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'M') goto yy343;
		if (yych <= 'O') goto yy52;
		goto yy344;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy52;
			goto yy343;
		} else {
			if (yych == 'p') goto yy344;
			goto yy52;
		}
	}
yy228:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'C') goto yy345;
		if (yych <= 'S') goto yy52;
		goto yy346;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy52;
			goto yy345;
		} else {
			if (yych == 't') goto yy346;
			goto yy52;
		}
	}
yy229:
	yych = *++cur;
	if (yych == 'T') goto yy347;
	if (yych == 't') goto yy347;
	goto yy52;
yy230:
	yych = *++cur;
	if (yych == 'L') goto yy348;
	if (yych == 'l') goto yy348;
	goto yy52;
yy231:
	yych = *++cur;
	if (yych == 'A') goto yy349;
	if (yych == 'a') goto yy349;
	goto yy52;
yy232:
	yych = *++cur;
	if (yych == 'L') goto yy351;
	if (yych == 'l') goto yy351;
	goto yy52;
yy233:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy352;
		if (yych <= 'D') goto yy52;
		goto yy353;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy52;
			goto yy352;
		} else {
			if (yych == 'e') goto yy353;
			goto yy52;
		}
	}
yy234:
	yych = *++cur;
	if (yych == 'E') goto yy354;
	if (yych == 'e') goto yy354;
	goto yy52;
yy235:
	yych = *++cur;
	if (yych == 'B') goto yy355;
	if (yych == 'b') goto yy355;
	goto yy52;
yy236:
	yych = *++cur;
	if (yych == 'H') goto yy356;
	if (yych == 'h') goto yy356;
	goto yy52;
yy237:
	yych = *++cur;
	if (yych == 'M') goto yy357;
	if (yych == 'm') goto yy357;
	goto yy52;
yy238:
	yych = *++cur;
	if (yych == 'E') goto yy358;
	if (yych == 'e') goto yy358;
	goto yy52;
yy239:
	yyaccept = 6;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 64) {
		goto yy119;
	}
	if (yych <= 'D') {
		if (yych <= '\r') {
			if (yych <= '\n') {
				if (yych == '\t') goto yy360;
			} else {
				if (yych != '\f') goto yy360;
			}
		} else {
			if (yych <= '/') {
				if (yych == ' ') goto yy360;
			} else {
				if (yych <= '9') goto yy51;
				if (yych <= '@') goto yy240;
				if (yych <= 'C') goto yy51;
				goto yy362;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'V') {
				if (yych == 'I') goto yy363;
				goto yy51;
			} else {
				if (yych <= 'W') goto yy364;
				if (yych <= 'Z') goto yy51;
				if (yych >= 'a') goto yy51;
			}
		} else {
			if (yych <= 'i') {
				if (yych <= 'd') goto yy362;
				if (yych <= 'h') goto yy51;
				goto yy363;
			} else {
				if (yych == 'w') goto yy364;
				if (yych <= 'z') goto yy51;
			}
		}
	}
yy240:
#line 111 "tokenizer.re"
	{ KW(END) }
#line 1964 "tokenizer.cpp"
yy241:
	yych = *++cur;
	if (yych == 'R') goto yy365;
	if (yych == 'r') goto yy365;
	goto yy52;
yy242:
	yych = *++cur;
	if (yych == 'M') goto yy366;
	if (yych == 'm') goto yy366;
	goto yy52;
yy243:
	yych = *++cur;
	if (yych == 'I') goto yy368;
	if (yych == 'i') goto yy368;
	goto yy52;
yy244:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'M') goto yy369;
		if (yych <= 'N') goto yy52;
		goto yy370;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy52;
			goto yy369;
		} else {
			if (yych == 'o') goto yy370;
			goto yy52;
		}
	}
yy245:
	yych = *++cur;
	if (yych == 'T') goto yy371;
	if (yych == 't') goto yy371;
	goto yy52;
yy246:
	yych = *++cur;
	if (yych == 'E') goto yy373;
	if (yych == 'e') goto yy373;
	goto yy52;
yy247:
	yych = *++cur;
	if (yych == 'E') goto yy374;
	if (yych == 'e') goto yy374;
	goto yy52;
yy248:
	yych = *++cur;
	if (yych == 'A') goto yy376;
	if (yych == 'a') goto yy376;
	goto yy52;
yy249:
	yych = *++cur;
	if (yych == 'S') goto yy377;
	if (yych == 's') goto yy377;
	goto yy52;
yy250:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych == 'A') goto yy378;
		if (yych <= 'L') goto yy52;
		goto yy379;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy52;
			goto yy378;
		} else {
			if (yych == 'm') goto yy379;
			goto yy52;
		}
	}
yy251:
	yych = *++cur;
	if (yych == 'C') goto yy380;
	if (yych == 'c') goto yy380;
	goto yy52;
yy252:
	yych = *++cur;
	if (yych == 'E') goto yy381;
	if (yych == 'e') goto yy381;
	goto yy52;
yy253:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'L') goto yy382;
			goto yy52;
		} else {
			if (yych <= 'O') goto yy383;
			if (yych <= 'T') goto yy52;
			goto yy384;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'l') goto yy382;
			goto yy52;
		} else {
			if (yych <= 'o') goto yy383;
			if (yych == 'u') goto yy384;
			goto yy52;
		}
	}
yy254:
	yych = *++cur;
	if (yych == 'L') goto yy385;
	if (yych == 'l') goto yy385;
	goto yy52;
yy255:
	yych = *++cur;
	if (yych == 'U') goto yy386;
	if (yych == 'u') goto yy386;
	goto yy52;
yy256:
	yych = *++cur;
	if (yych == 'U') goto yy387;
	if (yych == 'u') goto yy387;
	goto yy52;
yy257:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'E') goto yy388;
		if (yych <= 'Q') goto yy52;
		goto yy389;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy52;
			goto yy388;
		} else {
			if (yych == 'r') goto yy389;
			goto yy52;
		}
	}
yy258:
	yych = *++cur;
	if (yych == 'D') goto yy390;
	if (yych == 'd') goto yy390;
	goto yy52;
yy259:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 150 "tokenizer.re"
	{ KW(LEN) }
#line 2109 "tokenizer.cpp"
yy261:
	yych = *++cur;
	if (yych == 'A') goto yy392;
	if (yych == 'a') goto yy392;
	goto yy52;
yy262:
	yych = *++cur;
	if (yych == 'I') goto yy393;
	if (yych == 'i') goto yy393;
	goto yy52;
yy263:
	yych = *++cur;
	if (yych == 'U') goto yy394;
	if (yych == 'u') goto yy394;
	goto yy52;
yy264:
	yych = *++cur;
	if (yych == 'D') goto yy395;
	if (yych == 'd') goto yy395;
	goto yy52;
yy265:
	yych = *++cur;
	if (yych == 'E') goto yy397;
	if (yych == 'e') goto yy397;
	goto yy52;
yy266:
	yych = *++cur;
	if (yych <= '^') {
		if (yych == 'E') goto yy399;
		goto yy52;
	} else {
		if (yych <= '_') goto yy401;
		if (yych == 'e') goto yy399;
		goto yy52;
	}
yy267:
	yych = *++cur;
	if (yych == 'A') goto yy402;
	if (yych == 'a') goto yy402;
	goto yy52;
yy268:
	yych = *++cur;
	if (yych == 'L') goto yy403;
	if (yych == 'l') goto yy403;
	goto yy52;
yy269:
	yych = *++cur;
	if (yych == 'Y') goto yy404;
	if (yych == 'y') goto yy404;
	goto yy52;
yy270:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy406;
		if (yych <= 'Q') goto yy52;
		goto yy408;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy52;
			goto yy406;
		} else {
			if (yych == 'r') goto yy408;
			goto yy52;
		}
	}
yy271:
	yych = *++cur;
	if (yych == 'I') goto yy409;
	if (yych == 'i') goto yy409;
	goto yy52;
yy272:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 168 "tokenizer.re"
	{ KW(OUT) }
#line 2188 "tokenizer.cpp"
yy274:
	yych = *++cur;
	if (yych == 'A') goto yy410;
	if (yych == 'a') goto yy410;
	goto yy52;
yy275:
	yych = *++cur;
	if (yych == 'S') goto yy411;
	if (yych == 's') goto yy411;
	goto yy52;
yy276:
	yych = *++cur;
	if (yych == 'N') goto yy413;
	if (yych == 'n') goto yy413;
	goto yy52;
yy277:
	yych = *++cur;
	if (yych == 'C') goto yy414;
	if (yych == 'c') goto yy414;
	goto yy52;
yy278:
	yych = *++cur;
	if (yych <= 'V') {
		if (yych == 'N') goto yy415;
		if (yych <= 'U') goto yy52;
		goto yy416;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy52;
			goto yy415;
		} else {
			if (yych == 'v') goto yy416;
			goto yy52;
		}
	}
yy279:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych <= 'F') {
			if (yych == 'C') goto yy417;
			goto yy52;
		} else {
			if (yych <= 'G') goto yy418;
			if (yych <= 'S') goto yy52;
			goto yy419;
		}
	} else {
		if (yych <= 'f') {
			if (yych == 'c') goto yy417;
			goto yy52;
		} else {
			if (yych <= 'g') goto yy418;
			if (yych == 't') goto yy419;
			goto yy52;
		}
	}
yy280:
	yych = *++cur;
	if (yych == 'L') goto yy420;
	if (yych == 'l') goto yy420;
	goto yy52;
yy281:
	yych = *++cur;
	if (yych == 'E') goto yy421;
	if (yych == 'e') goto yy421;
	goto yy52;
yy282:
	yych = *++cur;
	if (yych == 'E') goto yy423;
	if (yych == 'e') goto yy423;
	goto yy52;
yy283:
	yych = *++cur;
	if (yych == 'K') goto yy424;
	if (yych == 'k') goto yy424;
	goto yy52;
yy284:
	yych = *++cur;
	if (yych <= 'L') {
		if (yych == 'D') goto yy426;
		if (yych <= 'K') goto yy52;
		goto yy428;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy52;
			goto yy426;
		} else {
			if (yych == 'l') goto yy428;
			goto yy52;
		}
	}
yy285:
	yych = *++cur;
	if (yych == 'U') goto yy430;
	if (yych == 'u') goto yy430;
	goto yy52;
yy286:
	yych = *++cur;
	if (yych == 'U') goto yy431;
	if (yych == 'u') goto yy431;
	goto yy52;
yy287:
	yych = *++cur;
	if (yych == 'U') goto yy432;
	if (yych == 'u') goto yy432;
	goto yy52;
yy288:
	yych = *++cur;
	if (yych == 'I') goto yy433;
	if (yych == 'i') goto yy433;
	goto yy52;
yy289:
	yych = *++cur;
	if (yych == 'E') goto yy434;
	if (yych == 'e') goto yy434;
	goto yy52;
yy290:
	yych = *++cur;
	if (yych == 'E') goto yy436;
	if (yych == 'e') goto yy436;
	goto yy52;
yy291:
	yych = *++cur;
	if (yych == 'U') goto yy437;
	if (yych == 'u') goto yy437;
	goto yy52;
yy292:
	yych = *++cur;
	if (yych == 'R') goto yy438;
	if (yych == 'r') goto yy438;
	goto yy52;
yy293:
	yych = *++cur;
	if (yych == 'R') goto yy439;
	if (yych == 'r') goto yy439;
	goto yy52;
yy294:
	yych = *++cur;
	if (yych == 'T') goto yy440;
	if (yych == 't') goto yy440;
	goto yy52;
yy295:
	yych = *++cur;
	if (yych == 'P') goto yy442;
	if (yych == 'p') goto yy442;
	goto yy52;
yy296:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'M') goto yy444;
		if (yych <= 'Q') goto yy52;
		goto yy445;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy52;
			goto yy444;
		} else {
			if (yych == 'r') goto yy445;
			goto yy52;
		}
	}
yy297:
	yych = *++cur;
	if (yych == 'G') goto yy446;
	if (yych == 'g') goto yy446;
	goto yy52;
yy298:
	yych = *++cur;
	if (yych == 'M') goto yy447;
	if (yych == 'm') goto yy447;
	goto yy52;
yy299:
	yych = *++cur;
	if (yych == 'N') goto yy449;
	if (yych == 'n') goto yy449;
	goto yy52;
yy300:
	yych = *++cur;
	if (yych == 'E') goto yy451;
	if (yych == 'e') goto yy451;
	goto yy52;
yy301:
	yych = *++cur;
	if (yych == 'O') goto yy453;
	if (yych == 'o') goto yy453;
	goto yy52;
yy302:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 204 "tokenizer.re"
	{ KW(USE) }
#line 2383 "tokenizer.cpp"
yy304:
	yych = *++cur;
	if (yych == 'U') goto yy454;
	if (yych == 'u') goto yy454;
	goto yy52;
yy305:
	yych = *++cur;
	if (yych == 'A') goto yy455;
	if (yych == 'a') goto yy455;
	goto yy52;
yy306:
	yych = *++cur;
	if (yych == 'R') goto yy456;
	if (yych == 'r') goto yy456;
	goto yy52;
yy307:
	yych = *++cur;
	if (yych == 'L') goto yy457;
	if (yych == 'l') goto yy457;
	goto yy52;
yy308:
	yych = *++cur;
	if (yych == 'T') goto yy458;
	if (yych == 't') goto yy458;
	goto yy52;
yy309:
	yych = *++cur;
	if (yych <= '/') goto yy88;
	if (yych <= '9') goto yy309;
	goto yy88;
yy311:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy88;
		if (yych <= '9') goto yy311;
		if (yych <= '@') goto yy88;
		goto yy311;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy88;
			goto yy311;
		} else {
			if (yych <= '`') goto yy88;
			if (yych <= 'z') goto yy311;
			goto yy88;
		}
	}
yy313:
	yych = *++cur;
	if (yych == '.') goto yy459;
	goto yy91;
yy314:
	yych = *++cur;
	if (yych == '.') goto yy461;
	goto yy91;
yy315:
	yych = *++cur;
	if (yych == 's') goto yy463;
	goto yy91;
yy316:
	++cur;
	goto yy42;
yy317:
	++cur;
	goto yy38;
yy318:
	yych = *++cur;
	if (yych == 'v') goto yy464;
	goto yy91;
yy319:
	yych = *++cur;
	if (yych == '.') goto yy465;
	goto yy91;
yy320:
	++cur;
#line 251 "tokenizer.re"
	{ RET(TK_OR) }
#line 2461 "tokenizer.cpp"
yy322:
	yych = *++cur;
	if (yych == 'e') goto yy467;
	goto yy91;
yy323:
	++cur;
	cur = ctxmar;
#line 265 "tokenizer.re"
	{
                if (lex_dec(tok, cur, u)) {
                    yylval.n = u;
                    RET(TK_INTEGER)
                } else {
                    token_loc(loc);
                    std::string t = token();
                    throw LFortran::TokenizerError("Integer too large",
                        loc, t);
                }
            }
#line 2481 "tokenizer.cpp"
yy325:
	yych = *++cur;
	if (yych <= '`') goto yy75;
	if (yych <= 'z') goto yy203;
	goto yy75;
yy326:
	yych = *++cur;
	if (yych == 'R') goto yy468;
	if (yych == 'r') goto yy468;
	goto yy52;
yy327:
	yych = *++cur;
	if (yych == 'C') goto yy469;
	if (yych == 'c') goto yy469;
	goto yy52;
yy328:
	yych = *++cur;
	if (yych == 'G') goto yy470;
	if (yych == 'g') goto yy470;
	goto yy52;
yy329:
	yych = *++cur;
	if (yych == 'C') goto yy471;
	if (yych == 'c') goto yy471;
	goto yy52;
yy330:
	yych = *++cur;
	if (yych == 'C') goto yy472;
	if (yych == 'c') goto yy472;
	goto yy52;
yy331:
	yych = *++cur;
	if (yych == 'S') goto yy473;
	if (yych == 's') goto yy473;
	goto yy52;
yy332:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 85 "tokenizer.re"
	{ KW(BIND) }
#line 2525 "tokenizer.cpp"
yy334:
	yych = *++cur;
	if (yych == 'K') goto yy474;
	if (yych == 'k') goto yy474;
	goto yy52;
yy335:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 87 "tokenizer.re"
	{ KW(CALL) }
#line 2539 "tokenizer.cpp"
yy337:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 88 "tokenizer.re"
	{ KW(CASE) }
#line 2548 "tokenizer.cpp"
yy339:
	yych = *++cur;
	if (yych == 'A') goto yy476;
	if (yych == 'a') goto yy476;
	goto yy52;
yy340:
	yych = *++cur;
	if (yych == 'S') goto yy477;
	if (yych == 's') goto yy477;
	goto yy52;
yy341:
	yych = *++cur;
	if (yych == 'E') goto yy479;
	if (yych == 'e') goto yy479;
	goto yy52;
yy342:
	yych = *++cur;
	if (yych == 'M') goto yy481;
	if (yych == 'm') goto yy481;
	goto yy52;
yy343:
	yych = *++cur;
	if (yych == 'O') goto yy482;
	if (yych == 'o') goto yy482;
	goto yy52;
yy344:
	yych = *++cur;
	if (yych == 'L') goto yy483;
	if (yych == 'l') goto yy483;
	goto yy52;
yy345:
	yych = *++cur;
	if (yych == 'U') goto yy484;
	if (yych == 'u') goto yy484;
	goto yy52;
yy346:
	yych = *++cur;
	if (yych <= 'I') {
		if (yych == 'A') goto yy485;
		if (yych <= 'H') goto yy52;
		goto yy486;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy52;
			goto yy485;
		} else {
			if (yych == 'i') goto yy486;
			goto yy52;
		}
	}
yy347:
	yych = *++cur;
	if (yych == 'I') goto yy487;
	if (yych == 'i') goto yy487;
	goto yy52;
yy348:
	yych = *++cur;
	if (yych == 'E') goto yy488;
	if (yych == 'e') goto yy488;
	goto yy52;
yy349:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 101 "tokenizer.re"
	{ KW(DATA) }
#line 2617 "tokenizer.cpp"
yy351:
	yych = *++cur;
	if (yych == 'L') goto yy490;
	if (yych == 'l') goto yy490;
	goto yy52;
yy352:
	yych = *++cur;
	if (yych == 'U') goto yy491;
	if (yych == 'u') goto yy491;
	goto yy52;
yy353:
	yych = *++cur;
	if (yych == 'R') goto yy492;
	if (yych == 'r') goto yy492;
	goto yy52;
yy354:
	yych = *++cur;
	if (yych == 'N') goto yy493;
	if (yych == 'n') goto yy493;
	goto yy52;
yy355:
	yych = *++cur;
	if (yych == 'L') goto yy494;
	if (yych == 'l') goto yy494;
	goto yy52;
yy356:
	yych = *++cur;
	if (yych == 'I') goto yy495;
	if (yych == 'i') goto yy495;
	goto yy52;
yy357:
	yych = *++cur;
	if (yych == 'E') goto yy496;
	if (yych == 'e') goto yy496;
	goto yy52;
yy358:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 110 "tokenizer.re"
	{ KW(ELSE) }
#line 2661 "tokenizer.cpp"
yy360:
	yych = *++cur;
	if (yych <= 'D') {
		if (yych <= '\f') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy75;
				goto yy360;
			} else {
				if (yych == '\v') goto yy360;
				goto yy75;
			}
		} else {
			if (yych <= 0x1F) {
				if (yych <= '\r') goto yy360;
				goto yy75;
			} else {
				if (yych <= ' ') goto yy360;
				if (yych <= 'C') goto yy75;
				goto yy497;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'I') {
				if (yych <= 'H') goto yy75;
				goto yy498;
			} else {
				if (yych == 'W') goto yy499;
				goto yy75;
			}
		} else {
			if (yych <= 'i') {
				if (yych <= 'd') goto yy497;
				if (yych <= 'h') goto yy75;
				goto yy498;
			} else {
				if (yych == 'w') goto yy499;
				goto yy75;
			}
		}
	}
yy362:
	yych = *++cur;
	if (yych == 'O') goto yy500;
	if (yych == 'o') goto yy500;
	goto yy52;
yy363:
	yych = *++cur;
	if (yych == 'F') goto yy502;
	if (yych == 'f') goto yy502;
	goto yy52;
yy364:
	yych = *++cur;
	if (yych == 'H') goto yy504;
	if (yych == 'h') goto yy504;
	goto yy52;
yy365:
	yych = *++cur;
	if (yych == 'Y') goto yy505;
	if (yych == 'y') goto yy505;
	goto yy52;
yy366:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy119;
	}
	if (yych <= 'E') {
		if (yych <= '9') {
			if (yych >= '0') goto yy51;
		} else {
			if (yych <= '@') goto yy367;
			if (yych <= 'D') goto yy51;
			goto yy507;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy51;
			if (yych >= 'a') goto yy51;
		} else {
			if (yych <= 'e') goto yy507;
			if (yych <= 'z') goto yy51;
		}
	}
yy367:
#line 119 "tokenizer.re"
	{ KW(ENUM) }
#line 2748 "tokenizer.cpp"
yy368:
	yych = *++cur;
	if (yych == 'V') goto yy508;
	if (yych == 'v') goto yy508;
	goto yy52;
yy369:
	yych = *++cur;
	if (yych == 'S') goto yy509;
	if (yych == 's') goto yy509;
	goto yy52;
yy370:
	yych = *++cur;
	if (yych == 'R') goto yy510;
	if (yych == 'r') goto yy510;
	goto yy52;
yy371:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 124 "tokenizer.re"
	{ KW(EXIT) }
#line 2772 "tokenizer.cpp"
yy373:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy512;
		if (yych <= 'Q') goto yy52;
		goto yy513;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy52;
			goto yy512;
		} else {
			if (yych == 'r') goto yy513;
			goto yy52;
		}
	}
yy374:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 127 "tokenizer.re"
	{ KW(FILE) }
#line 2796 "tokenizer.cpp"
yy376:
	yych = *++cur;
	if (yych == 'L') goto yy514;
	if (yych == 'l') goto yy514;
	goto yy52;
yy377:
	yych = *++cur;
	if (yych == 'H') goto yy516;
	if (yych == 'h') goto yy516;
	goto yy52;
yy378:
	yych = *++cur;
	if (yych == 'L') goto yy518;
	if (yych == 'l') goto yy518;
	goto yy52;
yy379:
	yych = *++cur;
	if (yych == 'A') goto yy519;
	if (yych == 'a') goto yy519;
	goto yy52;
yy380:
	yych = *++cur;
	if (yych == 'T') goto yy520;
	if (yych == 't') goto yy520;
	goto yy52;
yy381:
	yych = *++cur;
	if (yych == 'R') goto yy521;
	if (yych == 'r') goto yy521;
	goto yy52;
yy382:
	yych = *++cur;
	if (yych == 'I') goto yy522;
	if (yych == 'i') goto yy522;
	goto yy52;
yy383:
	yych = *++cur;
	if (yych == 'R') goto yy523;
	if (yych == 'r') goto yy523;
	goto yy52;
yy384:
	yych = *++cur;
	if (yych == 'R') goto yy524;
	if (yych == 'r') goto yy524;
	goto yy52;
yy385:
	yych = *++cur;
	if (yych == 'U') goto yy525;
	if (yych == 'u') goto yy525;
	goto yy52;
yy386:
	yych = *++cur;
	if (yych == 'T') goto yy526;
	if (yych == 't') goto yy526;
	goto yy52;
yy387:
	yych = *++cur;
	if (yych == 'I') goto yy528;
	if (yych == 'i') goto yy528;
	goto yy52;
yy388:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych <= 'M') {
			if (yych == 'G') goto yy529;
			goto yy52;
		} else {
			if (yych <= 'N') goto yy530;
			if (yych <= 'Q') goto yy52;
			goto yy531;
		}
	} else {
		if (yych <= 'm') {
			if (yych == 'g') goto yy529;
			goto yy52;
		} else {
			if (yych <= 'n') goto yy530;
			if (yych == 'r') goto yy531;
			goto yy52;
		}
	}
yy389:
	yych = *++cur;
	if (yych == 'I') goto yy532;
	if (yych == 'i') goto yy532;
	goto yy52;
yy390:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 149 "tokenizer.re"
	{ KW(KIND) }
#line 2891 "tokenizer.cpp"
yy392:
	yych = *++cur;
	if (yych == 'L') goto yy533;
	if (yych == 'l') goto yy533;
	goto yy52;
yy393:
	yych = *++cur;
	if (yych == 'C') goto yy535;
	if (yych == 'c') goto yy535;
	goto yy52;
yy394:
	yych = *++cur;
	if (yych == 'L') goto yy536;
	if (yych == 'l') goto yy536;
	goto yy52;
yy395:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 155 "tokenizer.re"
	{ KW(MOLD) }
#line 2915 "tokenizer.cpp"
yy397:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy119;
	}
	if (yych <= 'L') {
		if (yych <= '9') {
			if (yych >= '0') goto yy51;
		} else {
			if (yych <= '@') goto yy398;
			if (yych <= 'K') goto yy51;
			goto yy537;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy51;
			if (yych >= 'a') goto yy51;
		} else {
			if (yych <= 'l') goto yy537;
			if (yych <= 'z') goto yy51;
		}
	}
yy398:
#line 156 "tokenizer.re"
	{ KW(NAME) }
#line 2941 "tokenizer.cpp"
yy399:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 162 "tokenizer.re"
	{ KW(NONE) }
#line 2950 "tokenizer.cpp"
yy401:
	yyaccept = 5;
	yych = *(mar = ++cur);
	if (yych <= 'O') {
		if (yych <= '\'') {
			if (yych == '"') goto yy73;
			if (yych <= '&') goto yy52;
			goto yy78;
		} else {
			if (yych == 'I') goto yy538;
			if (yych <= 'N') goto yy52;
			goto yy539;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'R') goto yy540;
			if (yych <= 'h') goto yy52;
			goto yy538;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy52;
				goto yy539;
			} else {
				if (yych == 'r') goto yy540;
				goto yy52;
			}
		}
	}
yy402:
	yych = *++cur;
	if (yych == 'S') goto yy541;
	if (yych == 's') goto yy541;
	goto yy52;
yy403:
	yych = *++cur;
	if (yych == 'I') goto yy542;
	if (yych == 'i') goto yy542;
	goto yy52;
yy404:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 164 "tokenizer.re"
	{ KW(ONLY) }
#line 2997 "tokenizer.cpp"
yy406:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 165 "tokenizer.re"
	{ KW(OPEN) }
#line 3006 "tokenizer.cpp"
yy408:
	yych = *++cur;
	if (yych == 'A') goto yy543;
	if (yych == 'a') goto yy543;
	goto yy52;
yy409:
	yych = *++cur;
	if (yych == 'O') goto yy544;
	if (yych == 'o') goto yy544;
	goto yy52;
yy410:
	yych = *++cur;
	if (yych == 'M') goto yy545;
	if (yych == 'm') goto yy545;
	goto yy52;
yy411:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 170 "tokenizer.re"
	{ KW(PASS) }
#line 3030 "tokenizer.cpp"
yy413:
	yych = *++cur;
	if (yych == 'T') goto yy546;
	if (yych == 't') goto yy546;
	goto yy52;
yy414:
	yych = *++cur;
	if (yych == 'I') goto yy547;
	if (yych == 'i') goto yy547;
	goto yy52;
yy415:
	yych = *++cur;
	if (yych == 'T') goto yy548;
	if (yych == 't') goto yy548;
	goto yy52;
yy416:
	yych = *++cur;
	if (yych == 'A') goto yy550;
	if (yych == 'a') goto yy550;
	goto yy52;
yy417:
	yych = *++cur;
	if (yych == 'E') goto yy551;
	if (yych == 'e') goto yy551;
	goto yy52;
yy418:
	yych = *++cur;
	if (yych == 'R') goto yy552;
	if (yych == 'r') goto yy552;
	goto yy52;
yy419:
	yych = *++cur;
	if (yych == 'E') goto yy553;
	if (yych == 'e') goto yy553;
	goto yy52;
yy420:
	yych = *++cur;
	if (yych == 'I') goto yy554;
	if (yych == 'i') goto yy554;
	goto yy52;
yy421:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 179 "tokenizer.re"
	{ KW(PURE) }
#line 3079 "tokenizer.cpp"
yy423:
	yych = *++cur;
	if (yych == 'T') goto yy555;
	if (yych == 't') goto yy555;
	goto yy52;
yy424:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 181 "tokenizer.re"
	{ KW(RANK) }
#line 3093 "tokenizer.cpp"
yy426:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 182 "tokenizer.re"
	{ KW(READ) }
#line 3102 "tokenizer.cpp"
yy428:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 183 "tokenizer.re"
	{KW(REAL) }
#line 3111 "tokenizer.cpp"
yy430:
	yych = *++cur;
	if (yych == 'R') goto yy557;
	if (yych == 'r') goto yy557;
	goto yy52;
yy431:
	yych = *++cur;
	if (yych == 'L') goto yy558;
	if (yych == 'l') goto yy558;
	goto yy52;
yy432:
	yych = *++cur;
	if (yych == 'R') goto yy559;
	if (yych == 'r') goto yy559;
	goto yy52;
yy433:
	yych = *++cur;
	if (yych == 'N') goto yy560;
	if (yych == 'n') goto yy560;
	goto yy52;
yy434:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 188 "tokenizer.re"
	{ KW(SAVE) }
#line 3140 "tokenizer.cpp"
yy436:
	yych = *++cur;
	if (yych == 'C') goto yy561;
	if (yych == 'c') goto yy561;
	goto yy52;
yy437:
	yych = *++cur;
	if (yych == 'E') goto yy562;
	if (yych == 'e') goto yy562;
	goto yy52;
yy438:
	yych = *++cur;
	if (yych == 'E') goto yy563;
	if (yych == 'e') goto yy563;
	goto yy52;
yy439:
	yych = *++cur;
	if (yych == 'C') goto yy564;
	if (yych == 'c') goto yy564;
	goto yy52;
yy440:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 193 "tokenizer.re"
	{ KW(STAT) }
#line 3169 "tokenizer.cpp"
yy442:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 194 "tokenizer.re"
	{ KW(STOP) }
#line 3178 "tokenizer.cpp"
yy444:
	yych = *++cur;
	if (yych == 'O') goto yy565;
	if (yych == 'o') goto yy565;
	goto yy52;
yy445:
	yych = *++cur;
	if (yych == 'O') goto yy566;
	if (yych == 'o') goto yy566;
	goto yy52;
yy446:
	yych = *++cur;
	if (yych == 'E') goto yy567;
	if (yych == 'e') goto yy567;
	goto yy52;
yy447:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy568;
#line 198 "tokenizer.re"
	{ KW(TEAM) }
#line 3202 "tokenizer.cpp"
yy449:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 200 "tokenizer.re"
	{ KW(THEN) }
#line 3211 "tokenizer.cpp"
yy451:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 202 "tokenizer.re"
	{ KW(TYPE) }
#line 3220 "tokenizer.cpp"
yy453:
	yych = *++cur;
	if (yych == 'R') goto yy569;
	if (yych == 'r') goto yy569;
	goto yy52;
yy454:
	yych = *++cur;
	if (yych == 'E') goto yy570;
	if (yych == 'e') goto yy570;
	goto yy52;
yy455:
	yych = *++cur;
	if (yych == 'T') goto yy572;
	if (yych == 't') goto yy572;
	goto yy52;
yy456:
	yych = *++cur;
	if (yych == 'E') goto yy573;
	if (yych == 'e') goto yy573;
	goto yy52;
yy457:
	yych = *++cur;
	if (yych == 'E') goto yy575;
	if (yych == 'e') goto yy575;
	goto yy52;
yy458:
	yych = *++cur;
	if (yych == 'E') goto yy577;
	if (yych == 'e') goto yy577;
	goto yy52;
yy459:
	++cur;
#line 250 "tokenizer.re"
	{ RET(TK_AND) }
#line 3255 "tokenizer.cpp"
yy461:
	++cur;
#line 252 "tokenizer.re"
	{ RET(TK_EQV) }
#line 3260 "tokenizer.cpp"
yy463:
	yych = *++cur;
	if (yych == 'e') goto yy579;
	goto yy91;
yy464:
	yych = *++cur;
	if (yych == '.') goto yy580;
	goto yy91;
yy465:
	++cur;
#line 249 "tokenizer.re"
	{ RET(TK_NOT) }
#line 3273 "tokenizer.cpp"
yy467:
	yych = *++cur;
	if (yych == '.') goto yy582;
	goto yy91;
yy468:
	yych = *++cur;
	if (yych == 'A') goto yy584;
	if (yych == 'a') goto yy584;
	goto yy52;
yy469:
	yych = *++cur;
	if (yych == 'A') goto yy585;
	if (yych == 'a') goto yy585;
	goto yy52;
yy470:
	yych = *++cur;
	if (yych == 'N') goto yy586;
	if (yych == 'n') goto yy586;
	goto yy52;
yy471:
	yych = *++cur;
	if (yych == 'I') goto yy587;
	if (yych == 'i') goto yy587;
	goto yy52;
yy472:
	yych = *++cur;
	if (yych == 'H') goto yy588;
	if (yych == 'h') goto yy588;
	goto yy52;
yy473:
	yych = *++cur;
	if (yych == 'P') goto yy589;
	if (yych == 'p') goto yy589;
	goto yy52;
yy474:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 86 "tokenizer.re"
	{ KW(BLOCK) }
#line 3316 "tokenizer.cpp"
yy476:
	yych = *++cur;
	if (yych == 'C') goto yy590;
	if (yych == 'c') goto yy590;
	goto yy52;
yy477:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 90 "tokenizer.re"
	{ KW(CLASS) }
#line 3330 "tokenizer.cpp"
yy479:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 91 "tokenizer.re"
	{ KW(CLOSE) }
#line 3339 "tokenizer.cpp"
yy481:
	yych = *++cur;
	if (yych == 'E') goto yy591;
	if (yych == 'e') goto yy591;
	goto yy52;
yy482:
	yych = *++cur;
	if (yych == 'N') goto yy592;
	if (yych == 'n') goto yy592;
	goto yy52;
yy483:
	yych = *++cur;
	if (yych == 'E') goto yy594;
	if (yych == 'e') goto yy594;
	goto yy52;
yy484:
	yych = *++cur;
	if (yych == 'R') goto yy595;
	if (yych == 'r') goto yy595;
	goto yy52;
yy485:
	yych = *++cur;
	if (yych == 'I') goto yy596;
	if (yych == 'i') goto yy596;
	goto yy52;
yy486:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'G') goto yy597;
		if (yych <= 'M') goto yy52;
		goto yy598;
	} else {
		if (yych <= 'g') {
			if (yych <= 'f') goto yy52;
			goto yy597;
		} else {
			if (yych == 'n') goto yy598;
			goto yy52;
		}
	}
yy487:
	yych = *++cur;
	if (yych == 'C') goto yy599;
	if (yych == 'c') goto yy599;
	goto yy52;
yy488:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 100 "tokenizer.re"
	{ KW(CYCLE) }
#line 3393 "tokenizer.cpp"
yy490:
	yych = *++cur;
	if (yych == 'O') goto yy600;
	if (yych == 'o') goto yy600;
	goto yy52;
yy491:
	yych = *++cur;
	if (yych == 'L') goto yy601;
	if (yych == 'l') goto yy601;
	goto yy52;
yy492:
	yych = *++cur;
	if (yych == 'R') goto yy602;
	if (yych == 'r') goto yy602;
	goto yy52;
yy493:
	yych = *++cur;
	if (yych == 'S') goto yy603;
	if (yych == 's') goto yy603;
	goto yy52;
yy494:
	yych = *++cur;
	if (yych == 'E') goto yy604;
	if (yych == 'e') goto yy604;
	goto yy52;
yy495:
	yych = *++cur;
	if (yych == 'L') goto yy606;
	if (yych == 'l') goto yy606;
	goto yy52;
yy496:
	yych = *++cur;
	if (yych == 'N') goto yy607;
	if (yych == 'n') goto yy607;
	goto yy52;
yy497:
	yych = *++cur;
	if (yych == 'O') goto yy608;
	if (yych == 'o') goto yy608;
	goto yy75;
yy498:
	yych = *++cur;
	if (yych == 'F') goto yy610;
	if (yych == 'f') goto yy610;
	goto yy75;
yy499:
	yych = *++cur;
	if (yych == 'H') goto yy612;
	if (yych == 'h') goto yy612;
	goto yy75;
yy500:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 115 "tokenizer.re"
	{ KW(ENDDO) }
#line 3452 "tokenizer.cpp"
yy502:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 113 "tokenizer.re"
	{ KW(ENDIF) }
#line 3461 "tokenizer.cpp"
yy504:
	yych = *++cur;
	if (yych == 'E') goto yy613;
	if (yych == 'e') goto yy613;
	goto yy52;
yy505:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 118 "tokenizer.re"
	{ KW(ENTRY) }
#line 3475 "tokenizer.cpp"
yy507:
	yych = *++cur;
	if (yych == 'R') goto yy614;
	if (yych == 'r') goto yy614;
	goto yy52;
yy508:
	yych = *++cur;
	if (yych == 'A') goto yy615;
	if (yych == 'a') goto yy615;
	goto yy52;
yy509:
	yych = *++cur;
	if (yych == 'G') goto yy616;
	if (yych == 'g') goto yy616;
	goto yy52;
yy510:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 123 "tokenizer.re"
	{ KW(ERROR) }
#line 3499 "tokenizer.cpp"
yy512:
	yych = *++cur;
	if (yych == 'D') goto yy618;
	if (yych == 'd') goto yy618;
	goto yy52;
yy513:
	yych = *++cur;
	if (yych == 'N') goto yy619;
	if (yych == 'n') goto yy619;
	goto yy52;
yy514:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 128 "tokenizer.re"
	{ KW(FINAL) }
#line 3518 "tokenizer.cpp"
yy516:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 129 "tokenizer.re"
	{ KW(FLUSH) }
#line 3527 "tokenizer.cpp"
yy518:
	yych = *++cur;
	if (yych == 'L') goto yy620;
	if (yych == 'l') goto yy620;
	goto yy52;
yy519:
	yych = *++cur;
	if (yych == 'T') goto yy622;
	if (yych == 't') goto yy622;
	goto yy52;
yy520:
	yych = *++cur;
	if (yych == 'I') goto yy624;
	if (yych == 'i') goto yy624;
	goto yy52;
yy521:
	yych = *++cur;
	if (yych == 'I') goto yy625;
	if (yych == 'i') goto yy625;
	goto yy52;
yy522:
	yych = *++cur;
	if (yych == 'C') goto yy626;
	if (yych == 'c') goto yy626;
	goto yy52;
yy523:
	yych = *++cur;
	if (yych == 'T') goto yy627;
	if (yych == 't') goto yy627;
	goto yy52;
yy524:
	yych = *++cur;
	if (yych == 'E') goto yy629;
	if (yych == 'e') goto yy629;
	goto yy52;
yy525:
	yych = *++cur;
	if (yych == 'D') goto yy631;
	if (yych == 'd') goto yy631;
	goto yy52;
yy526:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 142 "tokenizer.re"
	{ KW(INOUT) }
#line 3576 "tokenizer.cpp"
yy528:
	yych = *++cur;
	if (yych == 'R') goto yy632;
	if (yych == 'r') goto yy632;
	goto yy52;
yy529:
	yych = *++cur;
	if (yych == 'E') goto yy633;
	if (yych == 'e') goto yy633;
	goto yy52;
yy530:
	yych = *++cur;
	if (yych == 'T') goto yy634;
	if (yych == 't') goto yy634;
	goto yy52;
yy531:
	yych = *++cur;
	if (yych == 'F') goto yy636;
	if (yych == 'f') goto yy636;
	goto yy52;
yy532:
	yych = *++cur;
	if (yych == 'N') goto yy637;
	if (yych == 'n') goto yy637;
	goto yy52;
yy533:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy638;
#line 151 "tokenizer.re"
	{ KW(LOCAL) }
#line 3610 "tokenizer.cpp"
yy535:
	yych = *++cur;
	if (yych == 'A') goto yy639;
	if (yych == 'a') goto yy639;
	goto yy52;
yy536:
	yych = *++cur;
	if (yych == 'E') goto yy640;
	if (yych == 'e') goto yy640;
	goto yy52;
yy537:
	yych = *++cur;
	if (yych == 'I') goto yy642;
	if (yych == 'i') goto yy642;
	goto yy52;
yy538:
	yych = *++cur;
	if (yych == 'N') goto yy643;
	if (yych == 'n') goto yy643;
	goto yy52;
yy539:
	yych = *++cur;
	if (yych == 'V') goto yy644;
	if (yych == 'v') goto yy644;
	goto yy52;
yy540:
	yych = *++cur;
	if (yych == 'E') goto yy645;
	if (yych == 'e') goto yy645;
	goto yy52;
yy541:
	yych = *++cur;
	if (yych == 'S') goto yy646;
	if (yych == 's') goto yy646;
	goto yy52;
yy542:
	yych = *++cur;
	if (yych == 'F') goto yy648;
	if (yych == 'f') goto yy648;
	goto yy52;
yy543:
	yych = *++cur;
	if (yych == 'T') goto yy649;
	if (yych == 't') goto yy649;
	goto yy52;
yy544:
	yych = *++cur;
	if (yych == 'N') goto yy650;
	if (yych == 'n') goto yy650;
	goto yy52;
yy545:
	yych = *++cur;
	if (yych == 'E') goto yy651;
	if (yych == 'e') goto yy651;
	goto yy52;
yy546:
	yych = *++cur;
	if (yych == 'E') goto yy652;
	if (yych == 'e') goto yy652;
	goto yy52;
yy547:
	yych = *++cur;
	if (yych == 'S') goto yy653;
	if (yych == 's') goto yy653;
	goto yy52;
yy548:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 173 "tokenizer.re"
	{ KW(PRINT) }
#line 3684 "tokenizer.cpp"
yy550:
	yych = *++cur;
	if (yych == 'T') goto yy654;
	if (yych == 't') goto yy654;
	goto yy52;
yy551:
	yych = *++cur;
	if (yych == 'D') goto yy655;
	if (yych == 'd') goto yy655;
	goto yy52;
yy552:
	yych = *++cur;
	if (yych == 'A') goto yy656;
	if (yych == 'a') goto yy656;
	goto yy52;
yy553:
	yych = *++cur;
	if (yych == 'C') goto yy657;
	if (yych == 'c') goto yy657;
	goto yy52;
yy554:
	yych = *++cur;
	if (yych == 'C') goto yy658;
	if (yych == 'c') goto yy658;
	goto yy52;
yy555:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 180 "tokenizer.re"
	{ KW(QUIET) }
#line 3718 "tokenizer.cpp"
yy557:
	yych = *++cur;
	if (yych == 'S') goto yy660;
	if (yych == 's') goto yy660;
	goto yy52;
yy558:
	yych = *++cur;
	if (yych == 'T') goto yy661;
	if (yych == 't') goto yy661;
	goto yy52;
yy559:
	yych = *++cur;
	if (yych == 'N') goto yy663;
	if (yych == 'n') goto yy663;
	goto yy52;
yy560:
	yych = *++cur;
	if (yych == 'D') goto yy665;
	if (yych == 'd') goto yy665;
	goto yy52;
yy561:
	yych = *++cur;
	if (yych == 'T') goto yy667;
	if (yych == 't') goto yy667;
	goto yy52;
yy562:
	yych = *++cur;
	if (yych == 'N') goto yy669;
	if (yych == 'n') goto yy669;
	goto yy52;
yy563:
	yych = *++cur;
	if (yych == 'D') goto yy670;
	if (yych == 'd') goto yy670;
	goto yy52;
yy564:
	yych = *++cur;
	if (yych == 'E') goto yy672;
	if (yych == 'e') goto yy672;
	goto yy52;
yy565:
	yych = *++cur;
	if (yych == 'D') goto yy674;
	if (yych == 'd') goto yy674;
	goto yy52;
yy566:
	yych = *++cur;
	if (yych == 'U') goto yy675;
	if (yych == 'u') goto yy675;
	goto yy52;
yy567:
	yych = *++cur;
	if (yych == 'T') goto yy676;
	if (yych == 't') goto yy676;
	goto yy52;
yy568:
	yyaccept = 5;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy73;
		if (yych <= '&') goto yy52;
		goto yy78;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy52;
			goto yy678;
		} else {
			if (yych == 'n') goto yy678;
			goto yy52;
		}
	}
yy569:
	yych = *++cur;
	if (yych == 'M') goto yy679;
	if (yych == 'm') goto yy679;
	goto yy52;
yy570:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 205 "tokenizer.re"
	{ KW(VALUE) }
#line 3803 "tokenizer.cpp"
yy572:
	yych = *++cur;
	if (yych == 'I') goto yy680;
	if (yych == 'i') goto yy680;
	goto yy52;
yy573:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 207 "tokenizer.re"
	{ KW(WHERE) }
#line 3817 "tokenizer.cpp"
yy575:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 208 "tokenizer.re"
	{ KW(WHILE) }
#line 3826 "tokenizer.cpp"
yy577:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 209 "tokenizer.re"
	{ KW(WRITE) }
#line 3835 "tokenizer.cpp"
yy579:
	yych = *++cur;
	if (yych == '.') goto yy681;
	goto yy91;
yy580:
	++cur;
#line 253 "tokenizer.re"
	{ RET(TK_NEQV) }
#line 3844 "tokenizer.cpp"
yy582:
	yyaccept = 7;
	yych = *(mar = ++cur);
	if (yych == '_') goto yy683;
yy583:
#line 257 "tokenizer.re"
	{ RET(TK_TRUE) }
#line 3852 "tokenizer.cpp"
yy584:
	yych = *++cur;
	if (yych == 'C') goto yy684;
	if (yych == 'c') goto yy684;
	goto yy52;
yy585:
	yych = *++cur;
	if (yych == 'T') goto yy685;
	if (yych == 't') goto yy685;
	goto yy52;
yy586:
	yych = *++cur;
	if (yych == 'M') goto yy686;
	if (yych == 'm') goto yy686;
	goto yy52;
yy587:
	yych = *++cur;
	if (yych == 'A') goto yy687;
	if (yych == 'a') goto yy687;
	goto yy52;
yy588:
	yych = *++cur;
	if (yych == 'R') goto yy688;
	if (yych == 'r') goto yy688;
	goto yy52;
yy589:
	yych = *++cur;
	if (yych == 'A') goto yy689;
	if (yych == 'a') goto yy689;
	goto yy52;
yy590:
	yych = *++cur;
	if (yych == 'T') goto yy690;
	if (yych == 't') goto yy690;
	goto yy52;
yy591:
	yych = *++cur;
	if (yych == 'N') goto yy691;
	if (yych == 'n') goto yy691;
	goto yy52;
yy592:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 93 "tokenizer.re"
	{ KW(COMMON) }
#line 3901 "tokenizer.cpp"
yy594:
	yych = *++cur;
	if (yych == 'X') goto yy692;
	if (yych == 'x') goto yy692;
	goto yy52;
yy595:
	yych = *++cur;
	if (yych == 'R') goto yy694;
	if (yych == 'r') goto yy694;
	goto yy52;
yy596:
	yych = *++cur;
	if (yych == 'N') goto yy695;
	if (yych == 'n') goto yy695;
	goto yy52;
yy597:
	yych = *++cur;
	if (yych == 'U') goto yy696;
	if (yych == 'u') goto yy696;
	goto yy52;
yy598:
	yych = *++cur;
	if (yych == 'U') goto yy697;
	if (yych == 'u') goto yy697;
	goto yy52;
yy599:
	yych = *++cur;
	if (yych == 'A') goto yy698;
	if (yych == 'a') goto yy698;
	goto yy52;
yy600:
	yych = *++cur;
	if (yych == 'C') goto yy699;
	if (yych == 'c') goto yy699;
	goto yy52;
yy601:
	yych = *++cur;
	if (yych == 'T') goto yy700;
	if (yych == 't') goto yy700;
	goto yy52;
yy602:
	yych = *++cur;
	if (yych == 'E') goto yy702;
	if (yych == 'e') goto yy702;
	goto yy52;
yy603:
	yych = *++cur;
	if (yych == 'I') goto yy703;
	if (yych == 'i') goto yy703;
	goto yy52;
yy604:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 108 "tokenizer.re"
	{ KW(DOUBLE) }
#line 3960 "tokenizer.cpp"
yy606:
	yych = *++cur;
	if (yych == 'E') goto yy704;
	if (yych == 'e') goto yy704;
	goto yy52;
yy607:
	yych = *++cur;
	if (yych == 'T') goto yy706;
	if (yych == 't') goto yy706;
	goto yy52;
yy608:
	++cur;
#line 114 "tokenizer.re"
	{ KW(END_DO) }
#line 3975 "tokenizer.cpp"
yy610:
	++cur;
#line 112 "tokenizer.re"
	{ KW(END_IF) }
#line 3980 "tokenizer.cpp"
yy612:
	yych = *++cur;
	if (yych == 'E') goto yy707;
	if (yych == 'e') goto yy707;
	goto yy75;
yy613:
	yych = *++cur;
	if (yych == 'R') goto yy708;
	if (yych == 'r') goto yy708;
	goto yy52;
yy614:
	yych = *++cur;
	if (yych == 'A') goto yy709;
	if (yych == 'a') goto yy709;
	goto yy52;
yy615:
	yych = *++cur;
	if (yych == 'L') goto yy710;
	if (yych == 'l') goto yy710;
	goto yy52;
yy616:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 122 "tokenizer.re"
	{ KW(ERRMSG) }
#line 4009 "tokenizer.cpp"
yy618:
	yych = *++cur;
	if (yych == 'S') goto yy711;
	if (yych == 's') goto yy711;
	goto yy52;
yy619:
	yych = *++cur;
	if (yych == 'A') goto yy713;
	if (yych == 'a') goto yy713;
	goto yy52;
yy620:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 130 "tokenizer.re"
	{ KW(FORALL) }
#line 4028 "tokenizer.cpp"
yy622:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy119;
	}
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych >= '0') goto yy51;
		} else {
			if (yych <= '@') goto yy623;
			if (yych <= 'S') goto yy51;
			goto yy714;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy51;
			if (yych >= 'a') goto yy51;
		} else {
			if (yych <= 't') goto yy714;
			if (yych <= 'z') goto yy51;
		}
	}
yy623:
#line 131 "tokenizer.re"
	{ KW(FORMAT) }
#line 4054 "tokenizer.cpp"
yy624:
	yych = *++cur;
	if (yych == 'O') goto yy715;
	if (yych == 'o') goto yy715;
	goto yy52;
yy625:
	yych = *++cur;
	if (yych == 'C') goto yy716;
	if (yych == 'c') goto yy716;
	goto yy52;
yy626:
	yych = *++cur;
	if (yych == 'I') goto yy718;
	if (yych == 'i') goto yy718;
	goto yy52;
yy627:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 138 "tokenizer.re"
	{ KW(IMPORT) }
#line 4078 "tokenizer.cpp"
yy629:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 139 "tokenizer.re"
	{ KW(IMPURE) }
#line 4087 "tokenizer.cpp"
yy631:
	yych = *++cur;
	if (yych == 'E') goto yy719;
	if (yych == 'e') goto yy719;
	goto yy52;
yy632:
	yych = *++cur;
	if (yych == 'E') goto yy721;
	if (yych == 'e') goto yy721;
	goto yy52;
yy633:
	yych = *++cur;
	if (yych == 'R') goto yy723;
	if (yych == 'r') goto yy723;
	goto yy52;
yy634:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 145 "tokenizer.re"
	{ KW(INTENT) }
#line 4111 "tokenizer.cpp"
yy636:
	yych = *++cur;
	if (yych == 'A') goto yy725;
	if (yych == 'a') goto yy725;
	goto yy52;
yy637:
	yych = *++cur;
	if (yych == 'S') goto yy726;
	if (yych == 's') goto yy726;
	goto yy52;
yy638:
	yyaccept = 5;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy73;
		if (yych <= '&') goto yy52;
		goto yy78;
	} else {
		if (yych <= 'I') {
			if (yych <= 'H') goto yy52;
			goto yy727;
		} else {
			if (yych == 'i') goto yy727;
			goto yy52;
		}
	}
yy639:
	yych = *++cur;
	if (yych == 'L') goto yy728;
	if (yych == 'l') goto yy728;
	goto yy52;
yy640:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 154 "tokenizer.re"
	{ KW(MODULE) }
#line 4151 "tokenizer.cpp"
yy642:
	yych = *++cur;
	if (yych == 'S') goto yy730;
	if (yych == 's') goto yy730;
	goto yy52;
yy643:
	yych = *++cur;
	if (yych == 'T') goto yy731;
	if (yych == 't') goto yy731;
	goto yy52;
yy644:
	yych = *++cur;
	if (yych == 'E') goto yy732;
	if (yych == 'e') goto yy732;
	goto yy52;
yy645:
	yych = *++cur;
	if (yych == 'C') goto yy733;
	if (yych == 'c') goto yy733;
	goto yy52;
yy646:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 158 "tokenizer.re"
	{ KW(NOPASS) }
#line 4180 "tokenizer.cpp"
yy648:
	yych = *++cur;
	if (yych == 'Y') goto yy734;
	if (yych == 'y') goto yy734;
	goto yy52;
yy649:
	yych = *++cur;
	if (yych == 'O') goto yy736;
	if (yych == 'o') goto yy736;
	goto yy52;
yy650:
	yych = *++cur;
	if (yych == 'A') goto yy737;
	if (yych == 'a') goto yy737;
	goto yy52;
yy651:
	yych = *++cur;
	if (yych == 'T') goto yy738;
	if (yych == 't') goto yy738;
	goto yy52;
yy652:
	yych = *++cur;
	if (yych == 'R') goto yy739;
	if (yych == 'r') goto yy739;
	goto yy52;
yy653:
	yych = *++cur;
	if (yych == 'I') goto yy741;
	if (yych == 'i') goto yy741;
	goto yy52;
yy654:
	yych = *++cur;
	if (yych == 'E') goto yy742;
	if (yych == 'e') goto yy742;
	goto yy52;
yy655:
	yych = *++cur;
	if (yych == 'U') goto yy744;
	if (yych == 'u') goto yy744;
	goto yy52;
yy656:
	yych = *++cur;
	if (yych == 'M') goto yy745;
	if (yych == 'm') goto yy745;
	goto yy52;
yy657:
	yych = *++cur;
	if (yych == 'T') goto yy747;
	if (yych == 't') goto yy747;
	goto yy52;
yy658:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 178 "tokenizer.re"
	{ KW(PUBLIC) }
#line 4239 "tokenizer.cpp"
yy660:
	yych = *++cur;
	if (yych == 'I') goto yy748;
	if (yych == 'i') goto yy748;
	goto yy52;
yy661:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 185 "tokenizer.re"
	{ KW(RESULT) }
#line 4253 "tokenizer.cpp"
yy663:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 186 "tokenizer.re"
	{ KW(RETURN) }
#line 4262 "tokenizer.cpp"
yy665:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 187 "tokenizer.re"
	{ KW(REWIND) }
#line 4271 "tokenizer.cpp"
yy667:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 189 "tokenizer.re"
	{ KW(SELECT) }
#line 4280 "tokenizer.cpp"
yy669:
	yych = *++cur;
	if (yych == 'C') goto yy749;
	if (yych == 'c') goto yy749;
	goto yy52;
yy670:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 191 "tokenizer.re"
	{ KW(SHARED) }
#line 4294 "tokenizer.cpp"
yy672:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 192 "tokenizer.re"
	{ KW(SOURCE) }
#line 4303 "tokenizer.cpp"
yy674:
	yych = *++cur;
	if (yych == 'U') goto yy750;
	if (yych == 'u') goto yy750;
	goto yy52;
yy675:
	yych = *++cur;
	if (yych == 'T') goto yy751;
	if (yych == 't') goto yy751;
	goto yy52;
yy676:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 197 "tokenizer.re"
	{ KW(TARGET) }
#line 4322 "tokenizer.cpp"
yy678:
	yych = *++cur;
	if (yych == 'U') goto yy752;
	if (yych == 'u') goto yy752;
	goto yy52;
yy679:
	yych = *++cur;
	if (yych == 'A') goto yy753;
	if (yych == 'a') goto yy753;
	goto yy52;
yy680:
	yych = *++cur;
	if (yych == 'L') goto yy754;
	if (yych == 'l') goto yy754;
	goto yy52;
yy681:
	yyaccept = 8;
	yych = *(mar = ++cur);
	if (yych == '_') goto yy755;
yy682:
#line 258 "tokenizer.re"
	{ RET(TK_FALSE) }
#line 4345 "tokenizer.cpp"
yy683:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy75;
		if (yych <= '9') goto yy756;
		if (yych <= '@') goto yy75;
		goto yy758;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy75;
			goto yy758;
		} else {
			if (yych <= '`') goto yy75;
			if (yych <= 'z') goto yy758;
			goto yy75;
		}
	}
yy684:
	yych = *++cur;
	if (yych == 'T') goto yy760;
	if (yych == 't') goto yy760;
	goto yy52;
yy685:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy762;
		if (yych <= 'D') goto yy52;
		goto yy763;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy52;
			goto yy762;
		} else {
			if (yych == 'e') goto yy763;
			goto yy52;
		}
	}
yy686:
	yych = *++cur;
	if (yych == 'E') goto yy765;
	if (yych == 'e') goto yy765;
	goto yy52;
yy687:
	yych = *++cur;
	if (yych == 'T') goto yy766;
	if (yych == 't') goto yy766;
	goto yy52;
yy688:
	yych = *++cur;
	if (yych == 'O') goto yy767;
	if (yych == 'o') goto yy767;
	goto yy52;
yy689:
	yych = *++cur;
	if (yych == 'C') goto yy768;
	if (yych == 'c') goto yy768;
	goto yy52;
yy690:
	yych = *++cur;
	if (yych == 'E') goto yy769;
	if (yych == 'e') goto yy769;
	goto yy52;
yy691:
	yych = *++cur;
	if (yych == 'S') goto yy770;
	if (yych == 's') goto yy770;
	goto yy52;
yy692:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 94 "tokenizer.re"
	{ KW(COMPLEX) }
#line 4421 "tokenizer.cpp"
yy694:
	yych = *++cur;
	if (yych == 'E') goto yy771;
	if (yych == 'e') goto yy771;
	goto yy52;
yy695:
	yych = *++cur;
	if (yych == 'S') goto yy772;
	if (yych == 's') goto yy772;
	goto yy52;
yy696:
	yych = *++cur;
	if (yych == 'O') goto yy774;
	if (yych == 'o') goto yy774;
	goto yy52;
yy697:
	yych = *++cur;
	if (yych == 'E') goto yy775;
	if (yych == 'e') goto yy775;
	goto yy52;
yy698:
	yych = *++cur;
	if (yych == 'L') goto yy777;
	if (yych == 'l') goto yy777;
	goto yy52;
yy699:
	yych = *++cur;
	if (yych == 'A') goto yy779;
	if (yych == 'a') goto yy779;
	goto yy52;
yy700:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 103 "tokenizer.re"
	{ KW(DEFAULT) }
#line 4460 "tokenizer.cpp"
yy702:
	yych = *++cur;
	if (yych == 'D') goto yy780;
	if (yych == 'd') goto yy780;
	goto yy52;
yy703:
	yych = *++cur;
	if (yych == 'O') goto yy782;
	if (yych == 'o') goto yy782;
	goto yy52;
yy704:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 107 "tokenizer.re"
	{ KW(DOWHILE) }
#line 4479 "tokenizer.cpp"
yy706:
	yych = *++cur;
	if (yych == 'A') goto yy783;
	if (yych == 'a') goto yy783;
	goto yy52;
yy707:
	yych = *++cur;
	if (yych == 'R') goto yy784;
	if (yych == 'r') goto yy784;
	goto yy75;
yy708:
	yych = *++cur;
	if (yych == 'E') goto yy785;
	if (yych == 'e') goto yy785;
	goto yy52;
yy709:
	yych = *++cur;
	if (yych == 'T') goto yy787;
	if (yych == 't') goto yy787;
	goto yy52;
yy710:
	yych = *++cur;
	if (yych == 'E') goto yy788;
	if (yych == 'e') goto yy788;
	goto yy52;
yy711:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 125 "tokenizer.re"
	{ KW(EXTENDS) }
#line 4513 "tokenizer.cpp"
yy713:
	yych = *++cur;
	if (yych == 'L') goto yy789;
	if (yych == 'l') goto yy789;
	goto yy52;
yy714:
	yych = *++cur;
	if (yych == 'E') goto yy791;
	if (yych == 'e') goto yy791;
	goto yy52;
yy715:
	yych = *++cur;
	if (yych == 'N') goto yy792;
	if (yych == 'n') goto yy792;
	goto yy52;
yy716:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 134 "tokenizer.re"
	{ KW(GENERIC) }
#line 4537 "tokenizer.cpp"
yy718:
	yych = *++cur;
	if (yych == 'T') goto yy794;
	if (yych == 't') goto yy794;
	goto yy52;
yy719:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 141 "tokenizer.re"
	{ KW(INCLUDE) }
#line 4551 "tokenizer.cpp"
yy721:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 143 "tokenizer.re"
	{ KW(INQUIRE) }
#line 4560 "tokenizer.cpp"
yy723:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 144 "tokenizer.re"
	{ KW(INTEGER) }
#line 4569 "tokenizer.cpp"
yy725:
	yych = *++cur;
	if (yych == 'C') goto yy796;
	if (yych == 'c') goto yy796;
	goto yy52;
yy726:
	yych = *++cur;
	if (yych == 'I') goto yy797;
	if (yych == 'i') goto yy797;
	goto yy52;
yy727:
	yych = *++cur;
	if (yych == 'N') goto yy798;
	if (yych == 'n') goto yy798;
	goto yy52;
yy728:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 153 "tokenizer.re"
	{ KW(LOGICAL) }
#line 4593 "tokenizer.cpp"
yy730:
	yych = *++cur;
	if (yych == 'T') goto yy799;
	if (yych == 't') goto yy799;
	goto yy52;
yy731:
	yych = *++cur;
	if (yych == 'R') goto yy801;
	if (yych == 'r') goto yy801;
	goto yy52;
yy732:
	yych = *++cur;
	if (yych == 'R') goto yy802;
	if (yych == 'r') goto yy802;
	goto yy52;
yy733:
	yych = *++cur;
	if (yych == 'U') goto yy803;
	if (yych == 'u') goto yy803;
	goto yy52;
yy734:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 163 "tokenizer.re"
	{ KW(NULLIFY) }
#line 4622 "tokenizer.cpp"
yy736:
	yych = *++cur;
	if (yych == 'R') goto yy804;
	if (yych == 'r') goto yy804;
	goto yy52;
yy737:
	yych = *++cur;
	if (yych == 'L') goto yy806;
	if (yych == 'l') goto yy806;
	goto yy52;
yy738:
	yych = *++cur;
	if (yych == 'E') goto yy808;
	if (yych == 'e') goto yy808;
	goto yy52;
yy739:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 171 "tokenizer.re"
	{ KW(POINTER) }
#line 4646 "tokenizer.cpp"
yy741:
	yych = *++cur;
	if (yych == 'O') goto yy809;
	if (yych == 'o') goto yy809;
	goto yy52;
yy742:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 174 "tokenizer.re"
	{ KW(PRIVATE) }
#line 4660 "tokenizer.cpp"
yy744:
	yych = *++cur;
	if (yych == 'R') goto yy810;
	if (yych == 'r') goto yy810;
	goto yy52;
yy745:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 176 "tokenizer.re"
	{ KW(PROGRAM) }
#line 4674 "tokenizer.cpp"
yy747:
	yych = *++cur;
	if (yych == 'E') goto yy811;
	if (yych == 'e') goto yy811;
	goto yy52;
yy748:
	yych = *++cur;
	if (yych == 'V') goto yy812;
	if (yych == 'v') goto yy812;
	goto yy52;
yy749:
	yych = *++cur;
	if (yych == 'E') goto yy813;
	if (yych == 'e') goto yy813;
	goto yy52;
yy750:
	yych = *++cur;
	if (yych == 'L') goto yy815;
	if (yych == 'l') goto yy815;
	goto yy52;
yy751:
	yych = *++cur;
	if (yych == 'I') goto yy816;
	if (yych == 'i') goto yy816;
	goto yy52;
yy752:
	yych = *++cur;
	if (yych == 'M') goto yy817;
	if (yych == 'm') goto yy817;
	goto yy52;
yy753:
	yych = *++cur;
	if (yych == 'T') goto yy818;
	if (yych == 't') goto yy818;
	goto yy52;
yy754:
	yych = *++cur;
	if (yych == 'E') goto yy819;
	if (yych == 'e') goto yy819;
	goto yy52;
yy755:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy75;
		if (yych <= '9') goto yy821;
		if (yych <= '@') goto yy75;
		goto yy823;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy75;
			goto yy823;
		} else {
			if (yych <= '`') goto yy75;
			if (yych <= 'z') goto yy823;
			goto yy75;
		}
	}
yy756:
	yych = *++cur;
	if (yych <= '/') goto yy583;
	if (yych <= '9') goto yy756;
	goto yy583;
yy758:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy583;
		if (yych <= '9') goto yy758;
		if (yych <= '@') goto yy583;
		goto yy758;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy583;
			goto yy758;
		} else {
			if (yych <= '`') goto yy583;
			if (yych <= 'z') goto yy758;
			goto yy583;
		}
	}
yy760:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 77 "tokenizer.re"
	{ KW(ABSTRACT) }
#line 4762 "tokenizer.cpp"
yy762:
	yych = *++cur;
	if (yych == 'B') goto yy825;
	if (yych == 'b') goto yy825;
	goto yy52;
yy763:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 80 "tokenizer.re"
	{ KW(ALLOCATE) }
#line 4776 "tokenizer.cpp"
yy765:
	yych = *++cur;
	if (yych == 'N') goto yy826;
	if (yych == 'n') goto yy826;
	goto yy52;
yy766:
	yych = *++cur;
	if (yych == 'E') goto yy827;
	if (yych == 'e') goto yy827;
	goto yy52;
yy767:
	yych = *++cur;
	if (yych == 'N') goto yy829;
	if (yych == 'n') goto yy829;
	goto yy52;
yy768:
	yych = *++cur;
	if (yych == 'E') goto yy830;
	if (yych == 'e') goto yy830;
	goto yy52;
yy769:
	yych = *++cur;
	if (yych == 'R') goto yy832;
	if (yych == 'r') goto yy832;
	goto yy52;
yy770:
	yych = *++cur;
	if (yych == 'I') goto yy834;
	if (yych == 'i') goto yy834;
	goto yy52;
yy771:
	yych = *++cur;
	if (yych == 'N') goto yy835;
	if (yych == 'n') goto yy835;
	goto yy52;
yy772:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 96 "tokenizer.re"
	{ KW(CONTAINS) }
#line 4820 "tokenizer.cpp"
yy774:
	yych = *++cur;
	if (yych == 'U') goto yy836;
	if (yych == 'u') goto yy836;
	goto yy52;
yy775:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 98 "tokenizer.re"
	{ KW(CONTINUE) }
#line 4834 "tokenizer.cpp"
yy777:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 99 "tokenizer.re"
	{ KW(CRITICAL) }
#line 4843 "tokenizer.cpp"
yy779:
	yych = *++cur;
	if (yych == 'T') goto yy837;
	if (yych == 't') goto yy837;
	goto yy52;
yy780:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 104 "tokenizer.re"
	{ KW(DEFERRED) }
#line 4857 "tokenizer.cpp"
yy782:
	yych = *++cur;
	if (yych == 'N') goto yy838;
	if (yych == 'n') goto yy838;
	goto yy52;
yy783:
	yych = *++cur;
	if (yych == 'L') goto yy840;
	if (yych == 'l') goto yy840;
	goto yy52;
yy784:
	yych = *++cur;
	if (yych == 'E') goto yy842;
	if (yych == 'e') goto yy842;
	goto yy75;
yy785:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 117 "tokenizer.re"
	{ KW(ENDWHERE) }
#line 4881 "tokenizer.cpp"
yy787:
	yych = *++cur;
	if (yych == 'O') goto yy844;
	if (yych == 'o') goto yy844;
	goto yy52;
yy788:
	yych = *++cur;
	if (yych == 'N') goto yy845;
	if (yych == 'n') goto yy845;
	goto yy52;
yy789:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 126 "tokenizer.re"
	{ KW(EXTERNAL) }
#line 4900 "tokenizer.cpp"
yy791:
	yych = *++cur;
	if (yych == 'D') goto yy846;
	if (yych == 'd') goto yy846;
	goto yy52;
yy792:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 133 "tokenizer.re"
	{ KW(FUNCTION) }
#line 4914 "tokenizer.cpp"
yy794:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 137 "tokenizer.re"
	{ KW(IMPLICIT) }
#line 4923 "tokenizer.cpp"
yy796:
	yych = *++cur;
	if (yych == 'E') goto yy848;
	if (yych == 'e') goto yy848;
	goto yy52;
yy797:
	yych = *++cur;
	if (yych == 'C') goto yy850;
	if (yych == 'c') goto yy850;
	goto yy52;
yy798:
	yych = *++cur;
	if (yych == 'I') goto yy852;
	if (yych == 'i') goto yy852;
	goto yy52;
yy799:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 157 "tokenizer.re"
	{ KW(NAMELIST) }
#line 4947 "tokenizer.cpp"
yy801:
	yych = *++cur;
	if (yych == 'I') goto yy853;
	if (yych == 'i') goto yy853;
	goto yy52;
yy802:
	yych = *++cur;
	if (yych == 'R') goto yy854;
	if (yych == 'r') goto yy854;
	goto yy52;
yy803:
	yych = *++cur;
	if (yych == 'R') goto yy855;
	if (yych == 'r') goto yy855;
	goto yy52;
yy804:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 166 "tokenizer.re"
	{ KW(OPERATOR) }
#line 4971 "tokenizer.cpp"
yy806:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 167 "tokenizer.re"
	{ KW(OPTIONAL) }
#line 4980 "tokenizer.cpp"
yy808:
	yych = *++cur;
	if (yych == 'R') goto yy856;
	if (yych == 'r') goto yy856;
	goto yy52;
yy809:
	yych = *++cur;
	if (yych == 'N') goto yy858;
	if (yych == 'n') goto yy858;
	goto yy52;
yy810:
	yych = *++cur;
	if (yych == 'E') goto yy860;
	if (yych == 'e') goto yy860;
	goto yy52;
yy811:
	yych = *++cur;
	if (yych == 'D') goto yy862;
	if (yych == 'd') goto yy862;
	goto yy52;
yy812:
	yych = *++cur;
	if (yych == 'E') goto yy864;
	if (yych == 'e') goto yy864;
	goto yy52;
yy813:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 190 "tokenizer.re"
	{ KW(SEQUENCE) }
#line 5014 "tokenizer.cpp"
yy815:
	yych = *++cur;
	if (yych == 'E') goto yy866;
	if (yych == 'e') goto yy866;
	goto yy52;
yy816:
	yych = *++cur;
	if (yych == 'N') goto yy868;
	if (yych == 'n') goto yy868;
	goto yy52;
yy817:
	yych = *++cur;
	if (yych == 'B') goto yy869;
	if (yych == 'b') goto yy869;
	goto yy52;
yy818:
	yych = *++cur;
	if (yych == 'T') goto yy870;
	if (yych == 't') goto yy870;
	goto yy52;
yy819:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 206 "tokenizer.re"
	{ KW(VOLATILE) }
#line 5043 "tokenizer.cpp"
yy821:
	yych = *++cur;
	if (yych <= '/') goto yy682;
	if (yych <= '9') goto yy821;
	goto yy682;
yy823:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy682;
		if (yych <= '9') goto yy823;
		if (yych <= '@') goto yy682;
		goto yy823;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy682;
			goto yy823;
		} else {
			if (yych <= '`') goto yy682;
			if (yych <= 'z') goto yy823;
			goto yy682;
		}
	}
yy825:
	yych = *++cur;
	if (yych == 'L') goto yy871;
	if (yych == 'l') goto yy871;
	goto yy52;
yy826:
	yych = *++cur;
	if (yych == 'T') goto yy872;
	if (yych == 't') goto yy872;
	goto yy52;
yy827:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 82 "tokenizer.re"
	{ KW(ASSOCIATE) }
#line 5084 "tokenizer.cpp"
yy829:
	yych = *++cur;
	if (yych == 'O') goto yy874;
	if (yych == 'o') goto yy874;
	goto yy52;
yy830:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 84 "tokenizer.re"
	{ KW(BACKSPACE) }
#line 5098 "tokenizer.cpp"
yy832:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 89 "tokenizer.re"
	{ KW(CHARACTER) }
#line 5107 "tokenizer.cpp"
yy834:
	yych = *++cur;
	if (yych == 'O') goto yy875;
	if (yych == 'o') goto yy875;
	goto yy52;
yy835:
	yych = *++cur;
	if (yych == 'T') goto yy876;
	if (yych == 't') goto yy876;
	goto yy52;
yy836:
	yych = *++cur;
	if (yych == 'S') goto yy878;
	if (yych == 's') goto yy878;
	goto yy52;
yy837:
	yych = *++cur;
	if (yych == 'E') goto yy880;
	if (yych == 'e') goto yy880;
	goto yy52;
yy838:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 105 "tokenizer.re"
	{ KW(DIMENSION) }
#line 5136 "tokenizer.cpp"
yy840:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 109 "tokenizer.re"
	{ KW(ELEMENTAL) }
#line 5145 "tokenizer.cpp"
yy842:
	++cur;
#line 116 "tokenizer.re"
	{ KW(END_WHERE) }
#line 5150 "tokenizer.cpp"
yy844:
	yych = *++cur;
	if (yych == 'R') goto yy882;
	if (yych == 'r') goto yy882;
	goto yy52;
yy845:
	yych = *++cur;
	if (yych == 'C') goto yy884;
	if (yych == 'c') goto yy884;
	goto yy52;
yy846:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 132 "tokenizer.re"
	{ KW(FORMATTED) }
#line 5169 "tokenizer.cpp"
yy848:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 146 "tokenizer.re"
	{ KW(INTERFACE) }
#line 5178 "tokenizer.cpp"
yy850:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 147 "tokenizer.re"
	{ KW(INTRINSIC) }
#line 5187 "tokenizer.cpp"
yy852:
	yych = *++cur;
	if (yych == 'T') goto yy885;
	if (yych == 't') goto yy885;
	goto yy52;
yy853:
	yych = *++cur;
	if (yych == 'N') goto yy887;
	if (yych == 'n') goto yy887;
	goto yy52;
yy854:
	yych = *++cur;
	if (yych == 'I') goto yy888;
	if (yych == 'i') goto yy888;
	goto yy52;
yy855:
	yych = *++cur;
	if (yych == 'S') goto yy889;
	if (yych == 's') goto yy889;
	goto yy52;
yy856:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 169 "tokenizer.re"
	{ KW(PARAMETER) }
#line 5216 "tokenizer.cpp"
yy858:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 172 "tokenizer.re"
	{ KW(PRECISION) }
#line 5225 "tokenizer.cpp"
yy860:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 175 "tokenizer.re"
	{ KW(PROCEDURE) }
#line 5234 "tokenizer.cpp"
yy862:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 177 "tokenizer.re"
	{ KW(PROTECTED) }
#line 5243 "tokenizer.cpp"
yy864:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 184 "tokenizer.re"
	{ KW(RECURSIVE) }
#line 5252 "tokenizer.cpp"
yy866:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 195 "tokenizer.re"
	{ KW(SUBMODULE) }
#line 5261 "tokenizer.cpp"
yy868:
	yych = *++cur;
	if (yych == 'E') goto yy890;
	if (yych == 'e') goto yy890;
	goto yy52;
yy869:
	yych = *++cur;
	if (yych == 'E') goto yy892;
	if (yych == 'e') goto yy892;
	goto yy52;
yy870:
	yych = *++cur;
	if (yych == 'E') goto yy893;
	if (yych == 'e') goto yy893;
	goto yy52;
yy871:
	yych = *++cur;
	if (yych == 'E') goto yy894;
	if (yych == 'e') goto yy894;
	goto yy52;
yy872:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 81 "tokenizer.re"
	{ KW(ASSIGNMENT) }
#line 5290 "tokenizer.cpp"
yy874:
	yych = *++cur;
	if (yych == 'U') goto yy896;
	if (yych == 'u') goto yy896;
	goto yy52;
yy875:
	yych = *++cur;
	if (yych == 'N') goto yy897;
	if (yych == 'n') goto yy897;
	goto yy52;
yy876:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 95 "tokenizer.re"
	{ KW(CONCURRENT) }
#line 5309 "tokenizer.cpp"
yy878:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 97 "tokenizer.re"
	{ KW(CONTIGUOUS) }
#line 5318 "tokenizer.cpp"
yy880:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 102 "tokenizer.re"
	{ KW(DEALLOCATE) }
#line 5327 "tokenizer.cpp"
yy882:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 120 "tokenizer.re"
	{ KW(ENUMERATOR) }
#line 5336 "tokenizer.cpp"
yy884:
	yych = *++cur;
	if (yych == 'E') goto yy899;
	if (yych == 'e') goto yy899;
	goto yy52;
yy885:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 152 "tokenizer.re"
	{ KW(LOCAL_INIT) }
#line 5350 "tokenizer.cpp"
yy887:
	yych = *++cur;
	if (yych == 'S') goto yy901;
	if (yych == 's') goto yy901;
	goto yy52;
yy888:
	yych = *++cur;
	if (yych == 'D') goto yy902;
	if (yych == 'd') goto yy902;
	goto yy52;
yy889:
	yych = *++cur;
	if (yych == 'I') goto yy903;
	if (yych == 'i') goto yy903;
	goto yy52;
yy890:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 196 "tokenizer.re"
	{ KW(SUBROUTINE) }
#line 5374 "tokenizer.cpp"
yy892:
	yych = *++cur;
	if (yych == 'R') goto yy904;
	if (yych == 'r') goto yy904;
	goto yy52;
yy893:
	yych = *++cur;
	if (yych == 'D') goto yy906;
	if (yych == 'd') goto yy906;
	goto yy52;
yy894:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 79 "tokenizer.re"
	{ KW(ALLOCATABLE) }
#line 5393 "tokenizer.cpp"
yy896:
	yych = *++cur;
	if (yych == 'S') goto yy908;
	if (yych == 's') goto yy908;
	goto yy52;
yy897:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 92 "tokenizer.re"
	{ KW(CODIMENSION) }
#line 5407 "tokenizer.cpp"
yy899:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 121 "tokenizer.re"
	{ KW(EQUIVALENCE) }
#line 5416 "tokenizer.cpp"
yy901:
	yych = *++cur;
	if (yych == 'I') goto yy910;
	if (yych == 'i') goto yy910;
	goto yy52;
yy902:
	yych = *++cur;
	if (yych == 'A') goto yy911;
	if (yych == 'a') goto yy911;
	goto yy52;
yy903:
	yych = *++cur;
	if (yych == 'V') goto yy912;
	if (yych == 'v') goto yy912;
	goto yy52;
yy904:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 199 "tokenizer.re"
	{ KW(TEAM_NUMBER) }
#line 5440 "tokenizer.cpp"
yy906:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 203 "tokenizer.re"
	{ KW(UNFORMATTED) }
#line 5449 "tokenizer.cpp"
yy908:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 83 "tokenizer.re"
	{ KW(ASYNCHRONOUS) }
#line 5458 "tokenizer.cpp"
yy910:
	yych = *++cur;
	if (yych == 'C') goto yy913;
	if (yych == 'c') goto yy913;
	goto yy52;
yy911:
	yych = *++cur;
	if (yych == 'B') goto yy915;
	if (yych == 'b') goto yy915;
	goto yy52;
yy912:
	yych = *++cur;
	if (yych == 'E') goto yy916;
	if (yych == 'e') goto yy916;
	goto yy52;
yy913:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 159 "tokenizer.re"
	{ KW(NON_INTRINSIC) }
#line 5482 "tokenizer.cpp"
yy915:
	yych = *++cur;
	if (yych == 'L') goto yy918;
	if (yych == 'l') goto yy918;
	goto yy52;
yy916:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 161 "tokenizer.re"
	{ KW(NON_RECURSIVE) }
#line 5496 "tokenizer.cpp"
yy918:
	yych = *++cur;
	if (yych == 'E') goto yy919;
	if (yych != 'e') goto yy52;
yy919:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy51;
	}
	if (yych == '_') goto yy119;
#line 160 "tokenizer.re"
	{ KW(NON_OVERRIDABLE) }
#line 5509 "tokenizer.cpp"
}
#line 296 "tokenizer.re"

    }
}

} // namespace LFortran
