#ifndef LFORTRAN_ASR_H
#define LFORTRAN_ASR_H

// Generated by grammar/asdl_cpp.py

#include <lfortran/parser/alloc.h>
#include <lfortran/parser/location.h>
#include <lfortran/casts.h>
#include <lfortran/colors.h>
#include <lfortran/exception.h>
#include <lfortran/semantics/asr_scopes.h>


namespace LFortran::ASR {

enum asrType
{
    unit, prog, mod, sub, fn, var, stmt, expr, ttype, attribute, tbind, array_index
};

struct asr_t
{
    asrType type;
    Location loc;
};

/******************************************************************************/
// Forward declarations

struct unit_t; // Sum
struct prog_t; // Sum
struct mod_t; // Sum
struct sub_t; // Sum
struct fn_t; // Sum
struct var_t; // Sum
struct stmt_t; // Sum
struct expr_t; // Sum
struct ttype_t; // Sum
enum boolopType // Simple Sum
{ // Types
    And, Or
};
enum operatorType // Simple Sum
{ // Types
    Add, Sub, Mul, Div, Pow
};
enum unaryopType // Simple Sum
{ // Types
    Invert, Not, UAdd, USub
};
enum cmpopType // Simple Sum
{ // Types
    Eq, NotEq, Lt, LtE, Gt, GtE
};
struct dimension_t; // Product
struct attribute_t; // Sum
struct attribute_arg_t; // Product
struct arg_t; // Product
struct keyword_t; // Product
struct tbind_t; // Sum
struct array_index_t; // Sum
struct do_loop_head_t; // Product
struct case_stmt_t; // Product
struct case_default_t; // Product


/******************************************************************************/
// Products declarations

struct dimension_t // Product
{
    expr_t* m_start;
    expr_t* m_end;
};
struct attribute_arg_t // Product
{
    char* m_arg;
};
struct arg_t // Product
{
    char* m_arg;
};
struct keyword_t // Product
{
    char* m_arg;
    expr_t* m_value;
};
struct do_loop_head_t // Product
{
    expr_t* m_v;
    expr_t* m_start;
    expr_t* m_end;
    expr_t* m_increment;
};
struct case_stmt_t // Product
{
    expr_t* m_test;
    stmt_t** m_body; size_t n_body; // Sequence
};
struct case_default_t // Product
{
    stmt_t** m_body; size_t n_body; // Sequence
};


/******************************************************************************/
// Sums declarations

enum unitType // Types
{
    TranslationUnit
};

struct unit_t // Sum
{
    asr_t base;
    unitType type;
};

    struct TranslationUnit_t // Constructor
    {
        unit_t base;
        SymbolTable* m_global_scope;
        asr_t** m_items; size_t n_items; // Sequence
    };
    static inline asr_t* make_TranslationUnit_t(Allocator &al, const Location &a_loc, SymbolTable* a_global_scope, asr_t** a_items, size_t n_items) {
        TranslationUnit_t *n;
        n = al.make_new<TranslationUnit_t>();
        n->base.type = unitType::TranslationUnit;
        n->base.base.type = asrType::unit;
        n->base.base.loc = a_loc;
        n->m_global_scope = a_global_scope;
        n->m_items = a_items;
        n->n_items = n_items;
        return (asr_t*)n;
    }



enum progType // Types
{
    Program
};

struct prog_t // Sum
{
    asr_t base;
    progType type;
};

    struct Program_t // Constructor
    {
        prog_t base;
        char* m_name;
        stmt_t** m_body; size_t n_body; // Sequence
        SymbolTable* m_symtab;
    };
    static inline asr_t* make_Program_t(Allocator &al, const Location &a_loc, char* a_name, stmt_t** a_body, size_t n_body, SymbolTable* a_symtab) {
        Program_t *n;
        n = al.make_new<Program_t>();
        n->base.type = progType::Program;
        n->base.base.type = asrType::prog;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_symtab = a_symtab;
        return (asr_t*)n;
    }



enum modType // Types
{
    Module
};

struct mod_t // Sum
{
    asr_t base;
    modType type;
};

    struct Module_t // Constructor
    {
        mod_t base;
        char* m_name;
        int /* object */ m_symtab;
    };
    static inline asr_t* make_Module_t(Allocator &al, const Location &a_loc, char* a_name, int /* object */ a_symtab) {
        Module_t *n;
        n = al.make_new<Module_t>();
        n->base.type = modType::Module;
        n->base.base.type = asrType::mod;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_symtab = a_symtab;
        return (asr_t*)n;
    }



enum subType // Types
{
    Subroutine
};

struct sub_t // Sum
{
    asr_t base;
    subType type;
};

    struct Subroutine_t // Constructor
    {
        sub_t base;
        char* m_name;
        expr_t** m_args; size_t n_args; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        tbind_t* m_bind;
        SymbolTable* m_symtab;
    };
    static inline asr_t* make_Subroutine_t(Allocator &al, const Location &a_loc, char* a_name, expr_t** a_args, size_t n_args, stmt_t** a_body, size_t n_body, tbind_t* a_bind, SymbolTable* a_symtab) {
        Subroutine_t *n;
        n = al.make_new<Subroutine_t>();
        n->base.type = subType::Subroutine;
        n->base.base.type = asrType::sub;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_bind = a_bind;
        n->m_symtab = a_symtab;
        return (asr_t*)n;
    }



enum fnType // Types
{
    Function
};

struct fn_t // Sum
{
    asr_t base;
    fnType type;
};

    struct Function_t // Constructor
    {
        fn_t base;
        char* m_name;
        expr_t** m_args; size_t n_args; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        tbind_t* m_bind;
        expr_t* m_return_var;
        char* m_module;
        SymbolTable* m_symtab;
    };
    static inline asr_t* make_Function_t(Allocator &al, const Location &a_loc, char* a_name, expr_t** a_args, size_t n_args, stmt_t** a_body, size_t n_body, tbind_t* a_bind, expr_t* a_return_var, char* a_module, SymbolTable* a_symtab) {
        Function_t *n;
        n = al.make_new<Function_t>();
        n->base.type = fnType::Function;
        n->base.base.type = asrType::fn;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_bind = a_bind;
        n->m_return_var = a_return_var;
        n->m_module = a_module;
        n->m_symtab = a_symtab;
        return (asr_t*)n;
    }



enum varType // Types
{
    Variable
};

struct var_t // Sum
{
    asr_t base;
    varType type;
};

    struct Variable_t // Constructor
    {
        var_t base;
        char* m_name;
        int m_intent;
        ttype_t* m_type;
    };
    static inline asr_t* make_Variable_t(Allocator &al, const Location &a_loc, char* a_name, int a_intent, ttype_t* a_type) {
        Variable_t *n;
        n = al.make_new<Variable_t>();
        n->base.type = varType::Variable;
        n->base.base.type = asrType::var;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_intent = a_intent;
        n->m_type = a_type;
        return (asr_t*)n;
    }



enum stmtType // Types
{
    Assignment, SubroutineCall, BuiltinCall, If, Where, Stop, ErrorStop, DoLoop, Select, Cycle, Exit, WhileLoop, Print
};

struct stmt_t // Sum
{
    asr_t base;
    stmtType type;
};

    struct Assignment_t // Constructor
    {
        stmt_t base;
        expr_t* m_target;
        expr_t* m_value;
    };
    static inline asr_t* make_Assignment_t(Allocator &al, const Location &a_loc, expr_t* a_target, expr_t* a_value) {
        Assignment_t *n;
        n = al.make_new<Assignment_t>();
        n->base.type = stmtType::Assignment;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_target = a_target;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct SubroutineCall_t // Constructor
    {
        stmt_t base;
        sub_t* m_name;
        expr_t** m_args; size_t n_args; // Sequence
    };
    static inline asr_t* make_SubroutineCall_t(Allocator &al, const Location &a_loc, sub_t* a_name, expr_t** a_args, size_t n_args) {
        SubroutineCall_t *n;
        n = al.make_new<SubroutineCall_t>();
        n->base.type = stmtType::SubroutineCall;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        return (asr_t*)n;
    }

    struct BuiltinCall_t // Constructor
    {
        stmt_t base;
        char* m_name;
        expr_t** m_args; size_t n_args; // Sequence
    };
    static inline asr_t* make_BuiltinCall_t(Allocator &al, const Location &a_loc, char* a_name, expr_t** a_args, size_t n_args) {
        BuiltinCall_t *n;
        n = al.make_new<BuiltinCall_t>();
        n->base.type = stmtType::BuiltinCall;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        return (asr_t*)n;
    }

    struct If_t // Constructor
    {
        stmt_t base;
        expr_t* m_test;
        stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_orelse; size_t n_orelse; // Sequence
    };
    static inline asr_t* make_If_t(Allocator &al, const Location &a_loc, expr_t* a_test, stmt_t** a_body, size_t n_body, stmt_t** a_orelse, size_t n_orelse) {
        If_t *n;
        n = al.make_new<If_t>();
        n->base.type = stmtType::If;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_orelse = a_orelse;
        n->n_orelse = n_orelse;
        return (asr_t*)n;
    }

    struct Where_t // Constructor
    {
        stmt_t base;
        expr_t* m_test;
        stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_orelse; size_t n_orelse; // Sequence
    };
    static inline asr_t* make_Where_t(Allocator &al, const Location &a_loc, expr_t* a_test, stmt_t** a_body, size_t n_body, stmt_t** a_orelse, size_t n_orelse) {
        Where_t *n;
        n = al.make_new<Where_t>();
        n->base.type = stmtType::Where;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_orelse = a_orelse;
        n->n_orelse = n_orelse;
        return (asr_t*)n;
    }

    struct Stop_t // Constructor
    {
        stmt_t base;
        int m_code;
    };
    static inline asr_t* make_Stop_t(Allocator &al, const Location &a_loc, int a_code) {
        Stop_t *n;
        n = al.make_new<Stop_t>();
        n->base.type = stmtType::Stop;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_code = a_code;
        return (asr_t*)n;
    }

    struct ErrorStop_t // Constructor
    {
        stmt_t base;
    };
    static inline asr_t* make_ErrorStop_t(Allocator &al, const Location &a_loc) {
        ErrorStop_t *n;
        n = al.make_new<ErrorStop_t>();
        n->base.type = stmtType::ErrorStop;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        return (asr_t*)n;
    }

    struct DoLoop_t // Constructor
    {
        stmt_t base;
        do_loop_head_t m_head;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_DoLoop_t(Allocator &al, const Location &a_loc, do_loop_head_t a_head, stmt_t** a_body, size_t n_body) {
        DoLoop_t *n;
        n = al.make_new<DoLoop_t>();
        n->base.type = stmtType::DoLoop;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_head = a_head;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }

    struct Select_t // Constructor
    {
        stmt_t base;
        expr_t* m_test;
        case_stmt_t* m_body; size_t n_body; // Sequence
        case_default_t m_default;
    };
    static inline asr_t* make_Select_t(Allocator &al, const Location &a_loc, expr_t* a_test, case_stmt_t* a_body, size_t n_body, case_default_t a_default) {
        Select_t *n;
        n = al.make_new<Select_t>();
        n->base.type = stmtType::Select;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_default = a_default;
        return (asr_t*)n;
    }

    struct Cycle_t // Constructor
    {
        stmt_t base;
    };
    static inline asr_t* make_Cycle_t(Allocator &al, const Location &a_loc) {
        Cycle_t *n;
        n = al.make_new<Cycle_t>();
        n->base.type = stmtType::Cycle;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        return (asr_t*)n;
    }

    struct Exit_t // Constructor
    {
        stmt_t base;
    };
    static inline asr_t* make_Exit_t(Allocator &al, const Location &a_loc) {
        Exit_t *n;
        n = al.make_new<Exit_t>();
        n->base.type = stmtType::Exit;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        return (asr_t*)n;
    }

    struct WhileLoop_t // Constructor
    {
        stmt_t base;
        expr_t* m_test;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_WhileLoop_t(Allocator &al, const Location &a_loc, expr_t* a_test, stmt_t** a_body, size_t n_body) {
        WhileLoop_t *n;
        n = al.make_new<WhileLoop_t>();
        n->base.type = stmtType::WhileLoop;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }

    struct Print_t // Constructor
    {
        stmt_t base;
        char* m_fmt;
        expr_t** m_values; size_t n_values; // Sequence
    };
    static inline asr_t* make_Print_t(Allocator &al, const Location &a_loc, char* a_fmt, expr_t** a_values, size_t n_values) {
        Print_t *n;
        n = al.make_new<Print_t>();
        n->base.type = stmtType::Print;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_fmt = a_fmt;
        n->m_values = a_values;
        n->n_values = n_values;
        return (asr_t*)n;
    }



enum exprType // Types
{
    BoolOp, BinOp, UnaryOp, Compare, FuncCall, ArrayRef, ArrayInitializer, Num, Str, VariableOld, Var, Constant
};

struct expr_t // Sum
{
    asr_t base;
    exprType type;
};

    struct BoolOp_t // Constructor
    {
        expr_t base;
        expr_t* m_left;
        boolopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
    };
    static inline asr_t* make_BoolOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, boolopType a_op, expr_t* a_right, ttype_t* a_type) {
        BoolOp_t *n;
        n = al.make_new<BoolOp_t>();
        n->base.type = exprType::BoolOp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct BinOp_t // Constructor
    {
        expr_t base;
        expr_t* m_left;
        operatorType m_op;
        expr_t* m_right;
        ttype_t* m_type;
    };
    static inline asr_t* make_BinOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, operatorType a_op, expr_t* a_right, ttype_t* a_type) {
        BinOp_t *n;
        n = al.make_new<BinOp_t>();
        n->base.type = exprType::BinOp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct UnaryOp_t // Constructor
    {
        expr_t base;
        unaryopType m_op;
        expr_t* m_operand;
        ttype_t* m_type;
    };
    static inline asr_t* make_UnaryOp_t(Allocator &al, const Location &a_loc, unaryopType a_op, expr_t* a_operand, ttype_t* a_type) {
        UnaryOp_t *n;
        n = al.make_new<UnaryOp_t>();
        n->base.type = exprType::UnaryOp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_op = a_op;
        n->m_operand = a_operand;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct Compare_t // Constructor
    {
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
    };
    static inline asr_t* make_Compare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type) {
        Compare_t *n;
        n = al.make_new<Compare_t>();
        n->base.type = exprType::Compare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct FuncCall_t // Constructor
    {
        expr_t base;
        fn_t* m_func;
        expr_t** m_args; size_t n_args; // Sequence
        keyword_t* m_keywords; size_t n_keywords; // Sequence
        ttype_t* m_type;
    };
    static inline asr_t* make_FuncCall_t(Allocator &al, const Location &a_loc, fn_t* a_func, expr_t** a_args, size_t n_args, keyword_t* a_keywords, size_t n_keywords, ttype_t* a_type) {
        FuncCall_t *n;
        n = al.make_new<FuncCall_t>();
        n->base.type = exprType::FuncCall;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_func = a_func;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_keywords = a_keywords;
        n->n_keywords = n_keywords;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct ArrayRef_t // Constructor
    {
        expr_t base;
        char* m_name;
        array_index_t** m_args; size_t n_args; // Sequence
        ttype_t* m_type;
    };
    static inline asr_t* make_ArrayRef_t(Allocator &al, const Location &a_loc, char* a_name, array_index_t** a_args, size_t n_args, ttype_t* a_type) {
        ArrayRef_t *n;
        n = al.make_new<ArrayRef_t>();
        n->base.type = exprType::ArrayRef;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct ArrayInitializer_t // Constructor
    {
        expr_t base;
        expr_t** m_args; size_t n_args; // Sequence
        ttype_t* m_type;
    };
    static inline asr_t* make_ArrayInitializer_t(Allocator &al, const Location &a_loc, expr_t** a_args, size_t n_args, ttype_t* a_type) {
        ArrayInitializer_t *n;
        n = al.make_new<ArrayInitializer_t>();
        n->base.type = exprType::ArrayInitializer;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct Num_t // Constructor
    {
        expr_t base;
        int /* object */ m_n;
        ttype_t* m_type;
    };
    static inline asr_t* make_Num_t(Allocator &al, const Location &a_loc, int /* object */ a_n, ttype_t* a_type) {
        Num_t *n;
        n = al.make_new<Num_t>();
        n->base.type = exprType::Num;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_n = a_n;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct Str_t // Constructor
    {
        expr_t base;
        char* m_s;
        ttype_t* m_type;
    };
    static inline asr_t* make_Str_t(Allocator &al, const Location &a_loc, char* a_s, ttype_t* a_type) {
        Str_t *n;
        n = al.make_new<Str_t>();
        n->base.type = exprType::Str;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_s = a_s;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct VariableOld_t // Constructor
    {
        expr_t base;
        char* m_name;
        char* m_intent;
        int m_dummy;
        ttype_t* m_type;
    };
    static inline asr_t* make_VariableOld_t(Allocator &al, const Location &a_loc, char* a_name, char* a_intent, int a_dummy, ttype_t* a_type) {
        VariableOld_t *n;
        n = al.make_new<VariableOld_t>();
        n->base.type = exprType::VariableOld;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_intent = a_intent;
        n->m_dummy = a_dummy;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct Var_t // Constructor
    {
        expr_t base;
        SymbolTable* m_symtab;
        var_t* m_v;
    };
    static inline asr_t* make_Var_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, var_t* a_v) {
        Var_t *n;
        n = al.make_new<Var_t>();
        n->base.type = exprType::Var;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        n->m_v = a_v;
        return (asr_t*)n;
    }

    struct Constant_t // Constructor
    {
        expr_t base;
        bool m_value;
        ttype_t* m_type;
    };
    static inline asr_t* make_Constant_t(Allocator &al, const Location &a_loc, bool a_value, ttype_t* a_type) {
        Constant_t *n;
        n = al.make_new<Constant_t>();
        n->base.type = exprType::Constant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_value = a_value;
        n->m_type = a_type;
        return (asr_t*)n;
    }



enum ttypeType // Types
{
    Integer, Real, Complex, Character, Logical, Derived
};

struct ttype_t // Sum
{
    asr_t base;
    ttypeType type;
};

    struct Integer_t // Constructor
    {
        ttype_t base;
        int m_kind;
        dimension_t* m_dims; size_t n_dims; // Sequence
    };
    static inline asr_t* make_Integer_t(Allocator &al, const Location &a_loc, int a_kind, dimension_t* a_dims, size_t n_dims) {
        Integer_t *n;
        n = al.make_new<Integer_t>();
        n->base.type = ttypeType::Integer;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        n->m_dims = a_dims;
        n->n_dims = n_dims;
        return (asr_t*)n;
    }

    struct Real_t // Constructor
    {
        ttype_t base;
        int m_kind;
        dimension_t* m_dims; size_t n_dims; // Sequence
    };
    static inline asr_t* make_Real_t(Allocator &al, const Location &a_loc, int a_kind, dimension_t* a_dims, size_t n_dims) {
        Real_t *n;
        n = al.make_new<Real_t>();
        n->base.type = ttypeType::Real;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        n->m_dims = a_dims;
        n->n_dims = n_dims;
        return (asr_t*)n;
    }

    struct Complex_t // Constructor
    {
        ttype_t base;
        int m_kind;
        dimension_t* m_dims; size_t n_dims; // Sequence
    };
    static inline asr_t* make_Complex_t(Allocator &al, const Location &a_loc, int a_kind, dimension_t* a_dims, size_t n_dims) {
        Complex_t *n;
        n = al.make_new<Complex_t>();
        n->base.type = ttypeType::Complex;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        n->m_dims = a_dims;
        n->n_dims = n_dims;
        return (asr_t*)n;
    }

    struct Character_t // Constructor
    {
        ttype_t base;
        int m_kind;
        dimension_t* m_dims; size_t n_dims; // Sequence
    };
    static inline asr_t* make_Character_t(Allocator &al, const Location &a_loc, int a_kind, dimension_t* a_dims, size_t n_dims) {
        Character_t *n;
        n = al.make_new<Character_t>();
        n->base.type = ttypeType::Character;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        n->m_dims = a_dims;
        n->n_dims = n_dims;
        return (asr_t*)n;
    }

    struct Logical_t // Constructor
    {
        ttype_t base;
        int m_kind;
        dimension_t* m_dims; size_t n_dims; // Sequence
    };
    static inline asr_t* make_Logical_t(Allocator &al, const Location &a_loc, int a_kind, dimension_t* a_dims, size_t n_dims) {
        Logical_t *n;
        n = al.make_new<Logical_t>();
        n->base.type = ttypeType::Logical;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        n->m_dims = a_dims;
        n->n_dims = n_dims;
        return (asr_t*)n;
    }

    struct Derived_t // Constructor
    {
        ttype_t base;
        char* m_name;
        dimension_t* m_dims; size_t n_dims; // Sequence
        char* m_module;
    };
    static inline asr_t* make_Derived_t(Allocator &al, const Location &a_loc, char* a_name, dimension_t* a_dims, size_t n_dims, char* a_module) {
        Derived_t *n;
        n = al.make_new<Derived_t>();
        n->base.type = ttypeType::Derived;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_dims = a_dims;
        n->n_dims = n_dims;
        n->m_module = a_module;
        return (asr_t*)n;
    }



enum attributeType // Types
{
    Attribute
};

struct attribute_t // Sum
{
    asr_t base;
    attributeType type;
};

    struct Attribute_t // Constructor
    {
        attribute_t base;
        char* m_name;
        attribute_arg_t* m_args; size_t n_args; // Sequence
    };
    static inline asr_t* make_Attribute_t(Allocator &al, const Location &a_loc, char* a_name, attribute_arg_t* a_args, size_t n_args) {
        Attribute_t *n;
        n = al.make_new<Attribute_t>();
        n->base.type = attributeType::Attribute;
        n->base.base.type = asrType::attribute;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        return (asr_t*)n;
    }



enum tbindType // Types
{
    Bind
};

struct tbind_t // Sum
{
    asr_t base;
    tbindType type;
};

    struct Bind_t // Constructor
    {
        tbind_t base;
        char* m_lang;
        char* m_name;
    };
    static inline asr_t* make_Bind_t(Allocator &al, const Location &a_loc, char* a_lang, char* a_name) {
        Bind_t *n;
        n = al.make_new<Bind_t>();
        n->base.type = tbindType::Bind;
        n->base.base.type = asrType::tbind;
        n->base.base.loc = a_loc;
        n->m_lang = a_lang;
        n->m_name = a_name;
        return (asr_t*)n;
    }



enum array_indexType // Types
{
    ArrayIndex
};

struct array_index_t // Sum
{
    asr_t base;
    array_indexType type;
};

    struct ArrayIndex_t // Constructor
    {
        array_index_t base;
        expr_t* m_left;
        expr_t* m_right;
        expr_t* m_step;
    };
    static inline asr_t* make_ArrayIndex_t(Allocator &al, const Location &a_loc, expr_t* a_left, expr_t* a_right, expr_t* a_step) {
        ArrayIndex_t *n;
        n = al.make_new<ArrayIndex_t>();
        n->base.type = array_indexType::ArrayIndex;
        n->base.base.type = asrType::array_index;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_right = a_right;
        n->m_step = a_step;
        return (asr_t*)n;
    }





/******************************************************************************/
// Visitor functions

template <class Visitor>
static void visit_unit_t(const unit_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == asrType::unit)
    switch (x.type) {
        case unitType::TranslationUnit: { v.visit_TranslationUnit((const TranslationUnit_t &)x); return; }
    }
}

template <class Visitor>
static void visit_prog_t(const prog_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == asrType::prog)
    switch (x.type) {
        case progType::Program: { v.visit_Program((const Program_t &)x); return; }
    }
}

template <class Visitor>
static void visit_mod_t(const mod_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == asrType::mod)
    switch (x.type) {
        case modType::Module: { v.visit_Module((const Module_t &)x); return; }
    }
}

template <class Visitor>
static void visit_sub_t(const sub_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == asrType::sub)
    switch (x.type) {
        case subType::Subroutine: { v.visit_Subroutine((const Subroutine_t &)x); return; }
    }
}

template <class Visitor>
static void visit_fn_t(const fn_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == asrType::fn)
    switch (x.type) {
        case fnType::Function: { v.visit_Function((const Function_t &)x); return; }
    }
}

template <class Visitor>
static void visit_var_t(const var_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == asrType::var)
    switch (x.type) {
        case varType::Variable: { v.visit_Variable((const Variable_t &)x); return; }
    }
}

template <class Visitor>
static void visit_stmt_t(const stmt_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == asrType::stmt)
    switch (x.type) {
        case stmtType::Assignment: { v.visit_Assignment((const Assignment_t &)x); return; }
        case stmtType::SubroutineCall: { v.visit_SubroutineCall((const SubroutineCall_t &)x); return; }
        case stmtType::BuiltinCall: { v.visit_BuiltinCall((const BuiltinCall_t &)x); return; }
        case stmtType::If: { v.visit_If((const If_t &)x); return; }
        case stmtType::Where: { v.visit_Where((const Where_t &)x); return; }
        case stmtType::Stop: { v.visit_Stop((const Stop_t &)x); return; }
        case stmtType::ErrorStop: { v.visit_ErrorStop((const ErrorStop_t &)x); return; }
        case stmtType::DoLoop: { v.visit_DoLoop((const DoLoop_t &)x); return; }
        case stmtType::Select: { v.visit_Select((const Select_t &)x); return; }
        case stmtType::Cycle: { v.visit_Cycle((const Cycle_t &)x); return; }
        case stmtType::Exit: { v.visit_Exit((const Exit_t &)x); return; }
        case stmtType::WhileLoop: { v.visit_WhileLoop((const WhileLoop_t &)x); return; }
        case stmtType::Print: { v.visit_Print((const Print_t &)x); return; }
    }
}

template <class Visitor>
static void visit_expr_t(const expr_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == asrType::expr)
    switch (x.type) {
        case exprType::BoolOp: { v.visit_BoolOp((const BoolOp_t &)x); return; }
        case exprType::BinOp: { v.visit_BinOp((const BinOp_t &)x); return; }
        case exprType::UnaryOp: { v.visit_UnaryOp((const UnaryOp_t &)x); return; }
        case exprType::Compare: { v.visit_Compare((const Compare_t &)x); return; }
        case exprType::FuncCall: { v.visit_FuncCall((const FuncCall_t &)x); return; }
        case exprType::ArrayRef: { v.visit_ArrayRef((const ArrayRef_t &)x); return; }
        case exprType::ArrayInitializer: { v.visit_ArrayInitializer((const ArrayInitializer_t &)x); return; }
        case exprType::Num: { v.visit_Num((const Num_t &)x); return; }
        case exprType::Str: { v.visit_Str((const Str_t &)x); return; }
        case exprType::VariableOld: { v.visit_VariableOld((const VariableOld_t &)x); return; }
        case exprType::Var: { v.visit_Var((const Var_t &)x); return; }
        case exprType::Constant: { v.visit_Constant((const Constant_t &)x); return; }
    }
}

template <class Visitor>
static void visit_ttype_t(const ttype_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == asrType::ttype)
    switch (x.type) {
        case ttypeType::Integer: { v.visit_Integer((const Integer_t &)x); return; }
        case ttypeType::Real: { v.visit_Real((const Real_t &)x); return; }
        case ttypeType::Complex: { v.visit_Complex((const Complex_t &)x); return; }
        case ttypeType::Character: { v.visit_Character((const Character_t &)x); return; }
        case ttypeType::Logical: { v.visit_Logical((const Logical_t &)x); return; }
        case ttypeType::Derived: { v.visit_Derived((const Derived_t &)x); return; }
    }
}

template <class Visitor>
static void visit_attribute_t(const attribute_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == asrType::attribute)
    switch (x.type) {
        case attributeType::Attribute: { v.visit_Attribute((const Attribute_t &)x); return; }
    }
}

template <class Visitor>
static void visit_tbind_t(const tbind_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == asrType::tbind)
    switch (x.type) {
        case tbindType::Bind: { v.visit_Bind((const Bind_t &)x); return; }
    }
}

template <class Visitor>
static void visit_array_index_t(const array_index_t &x, Visitor &v) {
    LFORTRAN_ASSERT(x.base.type == asrType::array_index)
    switch (x.type) {
        case array_indexType::ArrayIndex: { v.visit_ArrayIndex((const ArrayIndex_t &)x); return; }
    }
}



template <class Visitor>
static void visit_asr_t(const asr_t &x, Visitor &v) {
    switch (x.type) {
        case asrType::unit: { v.visit_unit((const unit_t &)x); return; }
        case asrType::prog: { v.visit_prog((const prog_t &)x); return; }
        case asrType::mod: { v.visit_mod((const mod_t &)x); return; }
        case asrType::sub: { v.visit_sub((const sub_t &)x); return; }
        case asrType::fn: { v.visit_fn((const fn_t &)x); return; }
        case asrType::var: { v.visit_var((const var_t &)x); return; }
        case asrType::stmt: { v.visit_stmt((const stmt_t &)x); return; }
        case asrType::expr: { v.visit_expr((const expr_t &)x); return; }
        case asrType::ttype: { v.visit_ttype((const ttype_t &)x); return; }
        case asrType::attribute: { v.visit_attribute((const attribute_t &)x); return; }
        case asrType::tbind: { v.visit_tbind((const tbind_t &)x); return; }
        case asrType::array_index: { v.visit_array_index((const array_index_t &)x); return; }
    }
}



/******************************************************************************/
// Visitor base class

template <class Derived>
class BaseVisitor
{
private:
    Derived& self() { return static_cast<Derived&>(*this); }
public:
    void visit_asr(const asr_t &b) { visit_asr_t(b, self()); }
    void visit_unit(const unit_t &b) { visit_unit_t(b, self()); }
        void visit_TranslationUnit(const TranslationUnit_t &x) { throw LFortran::LFortranException("visit_TranslationUnit() not implemented"); }
    void visit_prog(const prog_t &b) { visit_prog_t(b, self()); }
        void visit_Program(const Program_t &x) { throw LFortran::LFortranException("visit_Program() not implemented"); }
    void visit_mod(const mod_t &b) { visit_mod_t(b, self()); }
        void visit_Module(const Module_t &x) { throw LFortran::LFortranException("visit_Module() not implemented"); }
    void visit_sub(const sub_t &b) { visit_sub_t(b, self()); }
        void visit_Subroutine(const Subroutine_t &x) { throw LFortran::LFortranException("visit_Subroutine() not implemented"); }
    void visit_fn(const fn_t &b) { visit_fn_t(b, self()); }
        void visit_Function(const Function_t &x) { throw LFortran::LFortranException("visit_Function() not implemented"); }
    void visit_var(const var_t &b) { visit_var_t(b, self()); }
        void visit_Variable(const Variable_t &x) { throw LFortran::LFortranException("visit_Variable() not implemented"); }
    void visit_stmt(const stmt_t &b) { visit_stmt_t(b, self()); }
        void visit_Assignment(const Assignment_t &x) { throw LFortran::LFortranException("visit_Assignment() not implemented"); }
        void visit_SubroutineCall(const SubroutineCall_t &x) { throw LFortran::LFortranException("visit_SubroutineCall() not implemented"); }
        void visit_BuiltinCall(const BuiltinCall_t &x) { throw LFortran::LFortranException("visit_BuiltinCall() not implemented"); }
        void visit_If(const If_t &x) { throw LFortran::LFortranException("visit_If() not implemented"); }
        void visit_Where(const Where_t &x) { throw LFortran::LFortranException("visit_Where() not implemented"); }
        void visit_Stop(const Stop_t &x) { throw LFortran::LFortranException("visit_Stop() not implemented"); }
        void visit_ErrorStop(const ErrorStop_t &x) { throw LFortran::LFortranException("visit_ErrorStop() not implemented"); }
        void visit_DoLoop(const DoLoop_t &x) { throw LFortran::LFortranException("visit_DoLoop() not implemented"); }
        void visit_Select(const Select_t &x) { throw LFortran::LFortranException("visit_Select() not implemented"); }
        void visit_Cycle(const Cycle_t &x) { throw LFortran::LFortranException("visit_Cycle() not implemented"); }
        void visit_Exit(const Exit_t &x) { throw LFortran::LFortranException("visit_Exit() not implemented"); }
        void visit_WhileLoop(const WhileLoop_t &x) { throw LFortran::LFortranException("visit_WhileLoop() not implemented"); }
        void visit_Print(const Print_t &x) { throw LFortran::LFortranException("visit_Print() not implemented"); }
    void visit_expr(const expr_t &b) { visit_expr_t(b, self()); }
        void visit_BoolOp(const BoolOp_t &x) { throw LFortran::LFortranException("visit_BoolOp() not implemented"); }
        void visit_BinOp(const BinOp_t &x) { throw LFortran::LFortranException("visit_BinOp() not implemented"); }
        void visit_UnaryOp(const UnaryOp_t &x) { throw LFortran::LFortranException("visit_UnaryOp() not implemented"); }
        void visit_Compare(const Compare_t &x) { throw LFortran::LFortranException("visit_Compare() not implemented"); }
        void visit_FuncCall(const FuncCall_t &x) { throw LFortran::LFortranException("visit_FuncCall() not implemented"); }
        void visit_ArrayRef(const ArrayRef_t &x) { throw LFortran::LFortranException("visit_ArrayRef() not implemented"); }
        void visit_ArrayInitializer(const ArrayInitializer_t &x) { throw LFortran::LFortranException("visit_ArrayInitializer() not implemented"); }
        void visit_Num(const Num_t &x) { throw LFortran::LFortranException("visit_Num() not implemented"); }
        void visit_Str(const Str_t &x) { throw LFortran::LFortranException("visit_Str() not implemented"); }
        void visit_VariableOld(const VariableOld_t &x) { throw LFortran::LFortranException("visit_VariableOld() not implemented"); }
        void visit_Var(const Var_t &x) { throw LFortran::LFortranException("visit_Var() not implemented"); }
        void visit_Constant(const Constant_t &x) { throw LFortran::LFortranException("visit_Constant() not implemented"); }
    void visit_ttype(const ttype_t &b) { visit_ttype_t(b, self()); }
        void visit_Integer(const Integer_t &x) { throw LFortran::LFortranException("visit_Integer() not implemented"); }
        void visit_Real(const Real_t &x) { throw LFortran::LFortranException("visit_Real() not implemented"); }
        void visit_Complex(const Complex_t &x) { throw LFortran::LFortranException("visit_Complex() not implemented"); }
        void visit_Character(const Character_t &x) { throw LFortran::LFortranException("visit_Character() not implemented"); }
        void visit_Logical(const Logical_t &x) { throw LFortran::LFortranException("visit_Logical() not implemented"); }
        void visit_Derived(const Derived_t &x) { throw LFortran::LFortranException("visit_Derived() not implemented"); }
    void visit_attribute(const attribute_t &b) { visit_attribute_t(b, self()); }
        void visit_Attribute(const Attribute_t &x) { throw LFortran::LFortranException("visit_Attribute() not implemented"); }
    void visit_tbind(const tbind_t &b) { visit_tbind_t(b, self()); }
        void visit_Bind(const Bind_t &x) { throw LFortran::LFortranException("visit_Bind() not implemented"); }
    void visit_array_index(const array_index_t &b) { visit_array_index_t(b, self()); }
        void visit_ArrayIndex(const ArrayIndex_t &x) { throw LFortran::LFortranException("visit_ArrayIndex() not implemented"); }
};


/******************************************************************************/
// Walk Visitor base class

template <class Derived>
class BaseWalkVisitor : public BaseVisitor<Derived>
{
private:
    Derived& self() { return static_cast<Derived&>(*this); }
public:
    void visit_TranslationUnit(const TranslationUnit_t &x) {
    }
    void visit_Program(const Program_t &x) {
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_Module(const Module_t &x) {
    }
    void visit_Subroutine(const Subroutine_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        if (x.m_bind)
            self().visit_tbind(*x.m_bind);
    }
    void visit_Function(const Function_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        if (x.m_bind)
            self().visit_tbind(*x.m_bind);
        self().visit_expr(*x.m_return_var);
    }
    void visit_Variable(const Variable_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_Assignment(const Assignment_t &x) {
        self().visit_expr(*x.m_target);
        self().visit_expr(*x.m_value);
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        self().visit_sub(*x.m_name);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
    }
    void visit_BuiltinCall(const BuiltinCall_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
    }
    void visit_If(const If_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
        }
    }
    void visit_Where(const Where_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
        }
    }
    void visit_Stop(const Stop_t &x) {
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
    }
    void visit_DoLoop(const DoLoop_t &x) {
        self().visit_do_loop_head(x.m_head);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_Select(const Select_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_case_stmt(x.m_body[i]);
        }
        self().visit_case_default(x.m_default);
    }
    void visit_Cycle(const Cycle_t &x) {
    }
    void visit_Exit(const Exit_t &x) {
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_Print(const Print_t &x) {
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
    }
    void visit_BoolOp(const BoolOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
    }
    void visit_BinOp(const BinOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
    }
    void visit_UnaryOp(const UnaryOp_t &x) {
        self().visit_expr(*x.m_operand);
        self().visit_ttype(*x.m_type);
    }
    void visit_Compare(const Compare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
    }
    void visit_FuncCall(const FuncCall_t &x) {
        self().visit_fn(*x.m_func);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        for (size_t i=0; i<x.n_keywords; i++) {
            self().visit_keyword(x.m_keywords[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_ArrayRef(const ArrayRef_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_array_index(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_ArrayInitializer(const ArrayInitializer_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_Num(const Num_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_Str(const Str_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_VariableOld(const VariableOld_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_Var(const Var_t &x) {
        self().visit_var(*x.m_v);
    }
    void visit_Constant(const Constant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_Integer(const Integer_t &x) {
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
        }
    }
    void visit_Real(const Real_t &x) {
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
        }
    }
    void visit_Complex(const Complex_t &x) {
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
        }
    }
    void visit_Character(const Character_t &x) {
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
        }
    }
    void visit_Logical(const Logical_t &x) {
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
        }
    }
    void visit_Derived(const Derived_t &x) {
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
        }
    }
    void visit_dimension(const dimension_t &x) {
        if (x.m_start)
            self().visit_expr(*x.m_start);
        if (x.m_end)
            self().visit_expr(*x.m_end);
    }
    void visit_Attribute(const Attribute_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_attribute_arg(x.m_args[i]);
        }
    }
    void visit_attribute_arg(const attribute_arg_t &x) {
    }
    void visit_arg(const arg_t &x) {
    }
    void visit_keyword(const keyword_t &x) {
        self().visit_expr(*x.m_value);
    }
    void visit_Bind(const Bind_t &x) {
    }
    void visit_ArrayIndex(const ArrayIndex_t &x) {
        if (x.m_left)
            self().visit_expr(*x.m_left);
        if (x.m_right)
            self().visit_expr(*x.m_right);
        if (x.m_step)
            self().visit_expr(*x.m_step);
    }
    void visit_do_loop_head(const do_loop_head_t &x) {
        self().visit_expr(*x.m_v);
        self().visit_expr(*x.m_start);
        self().visit_expr(*x.m_end);
        if (x.m_increment)
            self().visit_expr(*x.m_increment);
    }
    void visit_case_stmt(const case_stmt_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_case_default(const case_default_t &x) {
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
};


/******************************************************************************/
// Walk Visitor base class

template <class Derived>
class PickleBaseVisitor : public BaseVisitor<Derived>
{
public:
    std::string s;
    bool use_colors;
public:
    PickleBaseVisitor() : use_colors(false) { s.reserve(100000); }
    void visit_TranslationUnit(const TranslationUnit_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TranslationUnit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("(SymbolTable ");
        s.append(x.m_global_scope->get_hash());
        s.append(" {");
        {
            size_t i = 0;
            for (auto &a : x.m_global_scope->scope) {
                s.append(a.first + ": ");
                this->visit_asr(*a.second);
                if (i < x.m_global_scope->scope.size()-1) s.append(", ");
                i++;
            }
        }
        s.append("})");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_items; i++) {
            this->visit_asr(*x.m_items[i]);
            if (i < x.n_items-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Program(const Program_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Program");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("(SymbolTable ");
        s.append(x.m_symtab->get_hash());
        s.append(" {");
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->scope) {
                s.append(a.first + ": ");
                this->visit_asr(*a.second);
                if (i < x.m_symtab->scope.size()-1) s.append(", ");
                i++;
            }
        }
        s.append("})");
        s.append(")");
    }
    void visit_Module(const Module_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Module");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append("Unimplementedobject");
        s.append(")");
    }
    void visit_Subroutine(const Subroutine_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Subroutine");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        if (x.m_bind) {
            this->visit_tbind(*x.m_bind);
        } else {
            s.append("()");
        }
        s.append(" ");
        s.append("(SymbolTable ");
        s.append(x.m_symtab->get_hash());
        s.append(" {");
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->scope) {
                s.append(a.first + ": ");
                this->visit_asr(*a.second);
                if (i < x.m_symtab->scope.size()-1) s.append(", ");
                i++;
            }
        }
        s.append("})");
        s.append(")");
    }
    void visit_Function(const Function_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Function");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        if (x.m_bind) {
            this->visit_tbind(*x.m_bind);
        } else {
            s.append("()");
        }
        s.append(" ");
        this->visit_expr(*x.m_return_var);
        s.append(" ");
        if (x.m_module) {
            s.append(x.m_module);
        } else {
            s.append("()");
        }
        s.append(" ");
        s.append("(SymbolTable ");
        s.append(x.m_symtab->get_hash());
        s.append(" {");
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->scope) {
                s.append(a.first + ": ");
                this->visit_asr(*a.second);
                if (i < x.m_symtab->scope.size()-1) s.append(", ");
                i++;
            }
        }
        s.append("})");
        s.append(")");
    }
    void visit_Variable(const Variable_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Variable");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append(std::to_string(x.m_intent));
        s.append(" ");
        this->visit_ttype(*x.m_type);
        s.append(")");
    }
    void visit_Assignment(const Assignment_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("=");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_target);
        s.append(" ");
        this->visit_expr(*x.m_value);
        s.append(")");
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SubroutineCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_sub(*x.m_name);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_BuiltinCall(const BuiltinCall_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BuiltinCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_If(const If_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("If");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_test);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_orelse; i++) {
            this->visit_stmt(*x.m_orelse[i]);
            if (i < x.n_orelse-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Where(const Where_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Where");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_test);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_orelse; i++) {
            this->visit_stmt(*x.m_orelse[i]);
            if (i < x.n_orelse-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Stop(const Stop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Stop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        if (x.m_code) {
            s.append(std::to_string(x.m_code));
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ErrorStop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
    }
    void visit_DoLoop(const DoLoop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DoLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        // Optional products not implemented yet:
            this->visit_do_loop_head(x.m_head);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Select(const Select_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Select");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_test);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_case_stmt(x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        // Optional products not implemented yet:
            this->visit_case_default(x.m_default);
        s.append(")");
    }
    void visit_Cycle(const Cycle_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Cycle");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
    }
    void visit_Exit(const Exit_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Exit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("WhileLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_test);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Print(const Print_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Print");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        if (x.m_fmt) {
            s.append(x.m_fmt);
        } else {
            s.append("()");
        }
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_values; i++) {
            this->visit_expr(*x.m_values[i]);
            if (i < x.n_values-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_BoolOp(const BoolOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BoolOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_left);
        s.append(" ");
        s.append("boolopType" + std::to_string(x.m_op));
        s.append(" ");
        this->visit_expr(*x.m_right);
        s.append(" ");
        this->visit_ttype(*x.m_type);
        s.append(")");
    }
    void visit_BinOp(const BinOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_left);
        s.append(" ");
        s.append("operatorType" + std::to_string(x.m_op));
        s.append(" ");
        this->visit_expr(*x.m_right);
        s.append(" ");
        this->visit_ttype(*x.m_type);
        s.append(")");
    }
    void visit_UnaryOp(const UnaryOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnaryOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("unaryopType" + std::to_string(x.m_op));
        s.append(" ");
        this->visit_expr(*x.m_operand);
        s.append(" ");
        this->visit_ttype(*x.m_type);
        s.append(")");
    }
    void visit_Compare(const Compare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Compare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_expr(*x.m_left);
        s.append(" ");
        s.append("cmpopType" + std::to_string(x.m_op));
        s.append(" ");
        this->visit_expr(*x.m_right);
        s.append(" ");
        this->visit_ttype(*x.m_type);
        s.append(")");
    }
    void visit_FuncCall(const FuncCall_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FuncCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        this->visit_fn(*x.m_func);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_keywords; i++) {
            this->visit_keyword(x.m_keywords[i]);
            if (i < x.n_keywords-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        this->visit_ttype(*x.m_type);
        s.append(")");
    }
    void visit_ArrayRef(const ArrayRef_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayRef");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_array_index(*x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        this->visit_ttype(*x.m_type);
        s.append(")");
    }
    void visit_ArrayInitializer(const ArrayInitializer_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayInitializer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        this->visit_ttype(*x.m_type);
        s.append(")");
    }
    void visit_Num(const Num_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Num");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("Unimplementedobject");
        s.append(" ");
        this->visit_ttype(*x.m_type);
        s.append(")");
    }
    void visit_Str(const Str_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Str");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("\"" + std::string(x.m_s) + "\"");
        s.append(" ");
        this->visit_ttype(*x.m_type);
        s.append(")");
    }
    void visit_VariableOld(const VariableOld_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("VariableOld");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        if (x.m_intent) {
            s.append(x.m_intent);
        } else {
            s.append("()");
        }
        s.append(" ");
        if (x.m_dummy) {
            s.append(std::to_string(x.m_dummy));
        } else {
            s.append("()");
        }
        s.append(" ");
        this->visit_ttype(*x.m_type);
        s.append(")");
    }
    void visit_Var(const Var_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Var");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("(SymbolTable ");
        s.append(x.m_symtab->get_hash());
        s.append(" {");
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->scope) {
                s.append(a.first + ": ");
                this->visit_asr(*a.second);
                if (i < x.m_symtab->scope.size()-1) s.append(", ");
                i++;
            }
        }
        s.append("})");
        s.append(" ");
        this->visit_var(*x.m_v);
        s.append(")");
    }
    void visit_Constant(const Constant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Constant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("Unimplementedconstant");
        s.append(" ");
        this->visit_ttype(*x.m_type);
        s.append(")");
    }
    void visit_Integer(const Integer_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Integer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(std::to_string(x.m_kind));
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dims; i++) {
            this->visit_dimension(x.m_dims[i]);
            if (i < x.n_dims-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Real(const Real_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Real");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(std::to_string(x.m_kind));
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dims; i++) {
            this->visit_dimension(x.m_dims[i]);
            if (i < x.n_dims-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Complex(const Complex_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Complex");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(std::to_string(x.m_kind));
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dims; i++) {
            this->visit_dimension(x.m_dims[i]);
            if (i < x.n_dims-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Character(const Character_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Character");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(std::to_string(x.m_kind));
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dims; i++) {
            this->visit_dimension(x.m_dims[i]);
            if (i < x.n_dims-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Logical(const Logical_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Logical");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(std::to_string(x.m_kind));
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dims; i++) {
            this->visit_dimension(x.m_dims[i]);
            if (i < x.n_dims-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_Derived(const Derived_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Derived");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dims; i++) {
            this->visit_dimension(x.m_dims[i]);
            if (i < x.n_dims-1) s.append(" ");
        }
        s.append("]");
        s.append(" ");
        if (x.m_module) {
            s.append(x.m_module);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_dimension(const dimension_t &x) {
        s.append("(");
        if (x.m_start) {
            this->visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        s.append(" ");
        if (x.m_end) {
            this->visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_Attribute(const Attribute_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Attribute");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(x.m_name);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            this->visit_attribute_arg(x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_attribute_arg(const attribute_arg_t &x) {
        s.append("(");
        s.append(x.m_arg);
        s.append(")");
    }
    void visit_arg(const arg_t &x) {
        s.append("(");
        s.append(x.m_arg);
        s.append(")");
    }
    void visit_keyword(const keyword_t &x) {
        s.append("(");
        if (x.m_arg) {
            s.append(x.m_arg);
        } else {
            s.append("()");
        }
        s.append(" ");
        this->visit_expr(*x.m_value);
        s.append(")");
    }
    void visit_Bind(const Bind_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Bind");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append("\"" + std::string(x.m_lang) + "\"");
        s.append(" ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(")");
    }
    void visit_ArrayIndex(const ArrayIndex_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayIndex");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        if (x.m_left) {
            this->visit_expr(*x.m_left);
        } else {
            s.append("()");
        }
        s.append(" ");
        if (x.m_right) {
            this->visit_expr(*x.m_right);
        } else {
            s.append("()");
        }
        s.append(" ");
        if (x.m_step) {
            this->visit_expr(*x.m_step);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_do_loop_head(const do_loop_head_t &x) {
        s.append("(");
        this->visit_expr(*x.m_v);
        s.append(" ");
        this->visit_expr(*x.m_start);
        s.append(" ");
        this->visit_expr(*x.m_end);
        s.append(" ");
        if (x.m_increment) {
            this->visit_expr(*x.m_increment);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_case_stmt(const case_stmt_t &x) {
        s.append("(");
        this->visit_expr(*x.m_test);
        s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
    void visit_case_default(const case_default_t &x) {
        s.append("(");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            this->visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) s.append(" ");
        }
        s.append("]");
        s.append(")");
    }
};


} // namespace LFortran::ASR

#endif // LFORTRAN_ASR_H
