# Generated by utils/asdl_py.py

class AST(object):
    _attrs_ = ['lineno', 'col_offset']

    def __init__(self):
        self._fields = ()
        self._type = None

    def walkabout(self, visitor):
        raise AssertionError("walkabout() implementation not provided")

    def mutate_over(self, visitor):
        raise AssertionError("mutate_over() implementation not provided")


class NodeVisitorNotImplemented(Exception):
    pass

def checkinstance(a, b, opt=False):
    if opt and a is None:
        return
    from ..ast.utils import dump
    if not isinstance(a, b):
        if isinstance(a, AST):
            a_dump = dump(a)
        else:
            a_dump = a
        print("Wrong instance: %s, types: a=%s; b=%s" % (a_dump, type(a), b))
    assert isinstance(a, b)

class unit(AST): # Sum
    pass


class TranslationUnit(unit): # Constructor

    def __init__(self, global_scope=None, items=[]):
        self.global_scope = global_scope
        checkinstance(global_scope, object, False)
        self.items = items
        assert isinstance(items, list)
        for x in items:
            checkinstance(x, AST, False)
        self._fields = ('global_scope', 'items')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_TranslationUnit(self)



class prog(AST): # Sum
    pass


class Program(prog): # Constructor

    def __init__(self, name=None, body=[], symtab=None):
        self.name = name
        checkinstance(name, str, False)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        self.symtab = symtab
        checkinstance(symtab, object, False)
        self._fields = ('name', 'body', 'symtab')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Program(self)



class mod(AST): # Sum
    pass


class Module(mod): # Constructor

    def __init__(self, name=None, symtab=None):
        self.name = name
        checkinstance(name, str, False)
        self.symtab = symtab
        checkinstance(symtab, object, False)
        self._fields = ('name', 'symtab')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Module(self)



class sub(AST): # Sum
    pass


class Subroutine(sub): # Constructor

    def __init__(self, name=None, args=[], body=[], bind=None, symtab=None):
        self.name = name
        checkinstance(name, str, False)
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, expr, False)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        self.bind = bind
        checkinstance(bind, tbind, True)
        self.symtab = symtab
        checkinstance(symtab, object, False)
        self._fields = ('name', 'args', 'body', 'bind', 'symtab')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Subroutine(self)



class fn(AST): # Sum
    pass


class Function(fn): # Constructor

    def __init__(self, name=None, args=[], body=[], bind=None, return_var=None, module=None, symtab=None):
        self.name = name
        checkinstance(name, str, False)
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, expr, False)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        self.bind = bind
        checkinstance(bind, tbind, True)
        self.return_var = return_var
        checkinstance(return_var, expr, False)
        self.module = module
        checkinstance(module, str, True)
        self.symtab = symtab
        checkinstance(symtab, object, False)
        self._fields = ('name', 'args', 'body', 'bind', 'return_var', 'module', 'symtab')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Function(self)



class var(AST): # Sum
    pass


class Variable(var): # Constructor

    def __init__(self, name=None, intent=0, type=None):
        self.name = name
        checkinstance(name, str, False)
        self.intent = intent
        checkinstance(intent, int, False)
        self.type = type
        checkinstance(type, ttype, False)
        self._fields = ('name', 'intent', 'type')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Variable(self)



class stmt(AST): # Sum
    pass


class Assignment(stmt): # Constructor

    def __init__(self, target=None, value=None):
        self.target = target
        checkinstance(target, expr, False)
        self.value = value
        checkinstance(value, expr, False)
        self._fields = ('target', 'value')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Assignment(self)



class SubroutineCall(stmt): # Constructor

    def __init__(self, name=None, args=[]):
        self.name = name
        checkinstance(name, sub, False)
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, expr, False)
        self._fields = ('name', 'args')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_SubroutineCall(self)



class BuiltinCall(stmt): # Constructor

    def __init__(self, name=None, args=[]):
        self.name = name
        checkinstance(name, str, False)
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, expr, False)
        self._fields = ('name', 'args')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_BuiltinCall(self)



class If(stmt): # Constructor

    def __init__(self, test=None, body=[], orelse=[]):
        self.test = test
        checkinstance(test, expr, False)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        self.orelse = orelse
        assert isinstance(orelse, list)
        for x in orelse:
            checkinstance(x, stmt, False)
        self._fields = ('test', 'body', 'orelse')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_If(self)



class Where(stmt): # Constructor

    def __init__(self, test=None, body=[], orelse=[]):
        self.test = test
        checkinstance(test, expr, False)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        self.orelse = orelse
        assert isinstance(orelse, list)
        for x in orelse:
            checkinstance(x, stmt, False)
        self._fields = ('test', 'body', 'orelse')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Where(self)



class Stop(stmt): # Constructor

    def __init__(self, code=0):
        self.code = code
        checkinstance(code, int, True)
        self._fields = ('code',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Stop(self)



class ErrorStop(stmt): # Constructor

    def __init__(self):
        self._fields = ()
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_ErrorStop(self)



class DoLoop(stmt): # Constructor

    def __init__(self, head=None, body=[]):
        self.head = head
        checkinstance(head, do_loop_head, True)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        self._fields = ('head', 'body')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_DoLoop(self)



class Select(stmt): # Constructor

    def __init__(self, test=None, body=[], default=None):
        self.test = test
        checkinstance(test, expr, False)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, case_stmt, False)
        self.default = default
        checkinstance(default, case_default, True)
        self._fields = ('test', 'body', 'default')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Select(self)



class Cycle(stmt): # Constructor

    def __init__(self):
        self._fields = ()
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Cycle(self)



class Exit(stmt): # Constructor

    def __init__(self):
        self._fields = ()
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Exit(self)



class WhileLoop(stmt): # Constructor

    def __init__(self, test=None, body=[]):
        self.test = test
        checkinstance(test, expr, False)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        self._fields = ('test', 'body')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_WhileLoop(self)



class Print(stmt): # Constructor

    def __init__(self, fmt=None, values=[]):
        self.fmt = fmt
        checkinstance(fmt, str, True)
        self.values = values
        assert isinstance(values, list)
        for x in values:
            checkinstance(x, expr, False)
        self._fields = ('fmt', 'values')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Print(self)



class expr(AST): # Sum
    pass


class BoolOp(expr): # Constructor

    def __init__(self, left=None, op=None, right=None, type=None):
        self.left = left
        checkinstance(left, expr, False)
        self.op = op
        checkinstance(op, boolop, False)
        self.right = right
        checkinstance(right, expr, False)
        self.type = type
        checkinstance(type, ttype, False)
        self._fields = ('left', 'op', 'right', 'type')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_BoolOp(self)



class BinOp(expr): # Constructor

    def __init__(self, left=None, op=None, right=None, type=None):
        self.left = left
        checkinstance(left, expr, False)
        self.op = op
        checkinstance(op, operator, False)
        self.right = right
        checkinstance(right, expr, False)
        self.type = type
        checkinstance(type, ttype, False)
        self._fields = ('left', 'op', 'right', 'type')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_BinOp(self)



class UnaryOp(expr): # Constructor

    def __init__(self, op=None, operand=None, type=None):
        self.op = op
        checkinstance(op, unaryop, False)
        self.operand = operand
        checkinstance(operand, expr, False)
        self.type = type
        checkinstance(type, ttype, False)
        self._fields = ('op', 'operand', 'type')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_UnaryOp(self)



class Compare(expr): # Constructor

    def __init__(self, left=None, op=None, right=None, type=None):
        self.left = left
        checkinstance(left, expr, False)
        self.op = op
        checkinstance(op, cmpop, False)
        self.right = right
        checkinstance(right, expr, False)
        self.type = type
        checkinstance(type, ttype, False)
        self._fields = ('left', 'op', 'right', 'type')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Compare(self)



class FuncCall(expr): # Constructor

    def __init__(self, func=None, args=[], keywords=[], type=None):
        self.func = func
        checkinstance(func, fn, False)
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, expr, False)
        self.keywords = keywords
        assert isinstance(keywords, list)
        for x in keywords:
            checkinstance(x, keyword, False)
        self.type = type
        checkinstance(type, ttype, False)
        self._fields = ('func', 'args', 'keywords', 'type')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_FuncCall(self)



class ArrayRef(expr): # Constructor

    def __init__(self, name=None, args=[], type=None):
        self.name = name
        checkinstance(name, str, False)
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, array_index, False)
        self.type = type
        checkinstance(type, ttype, False)
        self._fields = ('name', 'args', 'type')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_ArrayRef(self)



class ArrayInitializer(expr): # Constructor

    def __init__(self, args=[], type=None):
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, expr, False)
        self.type = type
        checkinstance(type, ttype, False)
        self._fields = ('args', 'type')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_ArrayInitializer(self)



class Num(expr): # Constructor

    def __init__(self, n=None, type=None):
        self.n = n
        checkinstance(n, object, False)
        self.type = type
        checkinstance(type, ttype, False)
        self._fields = ('n', 'type')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Num(self)



class Str(expr): # Constructor

    def __init__(self, s=None, type=None):
        self.s = s
        checkinstance(s, str, False)
        self.type = type
        checkinstance(type, ttype, False)
        self._fields = ('s', 'type')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Str(self)



class VariableOld(expr): # Constructor

    def __init__(self, name=None, intent=None, dummy=0, type=None):
        self.name = name
        checkinstance(name, str, False)
        self.intent = intent
        checkinstance(intent, str, True)
        self.dummy = dummy
        checkinstance(dummy, int, True)
        self.type = type
        checkinstance(type, ttype, False)
        self._fields = ('name', 'intent', 'dummy', 'type')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_VariableOld(self)



class Var(expr): # Constructor

    def __init__(self, symtab=None, v=None):
        self.symtab = symtab
        checkinstance(symtab, object, False)
        self.v = v
        checkinstance(v, var, False)
        self._fields = ('symtab', 'v')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Var(self)



class Constant(expr): # Constructor

    def __init__(self, value=None, type=None):
        self.value = value
        checkinstance(value, bool, False)
        self.type = type
        checkinstance(type, ttype, False)
        self._fields = ('value', 'type')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Constant(self)



class ttype(AST): # Sum
    pass


class Integer(ttype): # Constructor

    def __init__(self, kind=0, dims=[]):
        self.kind = kind
        checkinstance(kind, int, False)
        self.dims = dims
        assert isinstance(dims, list)
        for x in dims:
            checkinstance(x, dimension, False)
        self._fields = ('kind', 'dims')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Integer(self)



class Real(ttype): # Constructor

    def __init__(self, kind=0, dims=[]):
        self.kind = kind
        checkinstance(kind, int, False)
        self.dims = dims
        assert isinstance(dims, list)
        for x in dims:
            checkinstance(x, dimension, False)
        self._fields = ('kind', 'dims')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Real(self)



class Complex(ttype): # Constructor

    def __init__(self, kind=0, dims=[]):
        self.kind = kind
        checkinstance(kind, int, False)
        self.dims = dims
        assert isinstance(dims, list)
        for x in dims:
            checkinstance(x, dimension, False)
        self._fields = ('kind', 'dims')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Complex(self)



class Character(ttype): # Constructor

    def __init__(self, kind=0, dims=[]):
        self.kind = kind
        checkinstance(kind, int, False)
        self.dims = dims
        assert isinstance(dims, list)
        for x in dims:
            checkinstance(x, dimension, False)
        self._fields = ('kind', 'dims')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Character(self)



class Logical(ttype): # Constructor

    def __init__(self, kind=0, dims=[]):
        self.kind = kind
        checkinstance(kind, int, False)
        self.dims = dims
        assert isinstance(dims, list)
        for x in dims:
            checkinstance(x, dimension, False)
        self._fields = ('kind', 'dims')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Logical(self)



class Derived(ttype): # Constructor

    def __init__(self, name=None, dims=[], module=None):
        self.name = name
        checkinstance(name, str, False)
        self.dims = dims
        assert isinstance(dims, list)
        for x in dims:
            checkinstance(x, dimension, False)
        self.module = module
        checkinstance(module, str, True)
        self._fields = ('name', 'dims', 'module')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Derived(self)



class boolop(AST): # Sum
    pass


class And(boolop): # Type
    pass


class Or(boolop): # Type
    pass


class operator(AST): # Sum
    pass


class Add(operator): # Type
    pass


class Sub(operator): # Type
    pass


class Mul(operator): # Type
    pass


class Div(operator): # Type
    pass


class Pow(operator): # Type
    pass


class unaryop(AST): # Sum
    pass


class Invert(unaryop): # Type
    pass


class Not(unaryop): # Type
    pass


class UAdd(unaryop): # Type
    pass


class USub(unaryop): # Type
    pass


class cmpop(AST): # Sum
    pass


class Eq(cmpop): # Type
    pass


class NotEq(cmpop): # Type
    pass


class Lt(cmpop): # Type
    pass


class LtE(cmpop): # Type
    pass


class Gt(cmpop): # Type
    pass


class GtE(cmpop): # Type
    pass


class dimension(AST): # Product

    def __init__(self, start=None, end=None):
        self.start = start
        checkinstance(start, expr, True)
        self.end = end
        checkinstance(end, expr, True)
        self._fields = ('start', 'end')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_dimension(self)


class attribute(AST): # Sum
    pass


class Attribute(attribute): # Constructor

    def __init__(self, name=None, args=[]):
        self.name = name
        checkinstance(name, str, False)
        self.args = args
        assert isinstance(args, list)
        for x in args:
            checkinstance(x, attribute_arg, False)
        self._fields = ('name', 'args')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Attribute(self)



class attribute_arg(AST): # Product

    def __init__(self, arg=None):
        self.arg = arg
        checkinstance(arg, str, False)
        self._fields = ('arg',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_attribute_arg(self)


class arg(AST): # Product

    def __init__(self, arg=None):
        self.arg = arg
        checkinstance(arg, str, False)
        self._fields = ('arg',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_arg(self)


class keyword(AST): # Product

    def __init__(self, arg=None, value=None):
        self.arg = arg
        checkinstance(arg, str, True)
        self.value = value
        checkinstance(value, expr, False)
        self._fields = ('arg', 'value')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_keyword(self)


class tbind(AST): # Sum
    pass


class Bind(tbind): # Constructor

    def __init__(self, lang=None, name=None):
        self.lang = lang
        checkinstance(lang, str, False)
        self.name = name
        checkinstance(name, str, False)
        self._fields = ('lang', 'name')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_Bind(self)



class array_index(AST): # Sum
    pass


class ArrayIndex(array_index): # Constructor

    def __init__(self, left=None, right=None, step=None):
        self.left = left
        checkinstance(left, expr, True)
        self.right = right
        checkinstance(right, expr, True)
        self.step = step
        checkinstance(step, expr, True)
        self._fields = ('left', 'right', 'step')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_ArrayIndex(self)



class do_loop_head(AST): # Product

    def __init__(self, v=None, start=None, end=None, increment=None):
        self.v = v
        checkinstance(v, expr, False)
        self.start = start
        checkinstance(start, expr, False)
        self.end = end
        checkinstance(end, expr, False)
        self.increment = increment
        checkinstance(increment, expr, True)
        self._fields = ('v', 'start', 'end', 'increment')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_do_loop_head(self)


class case_stmt(AST): # Product

    def __init__(self, test=None, body=[]):
        self.test = test
        checkinstance(test, expr, False)
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        self._fields = ('test', 'body')
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_case_stmt(self)


class case_default(AST): # Product

    def __init__(self, body=[]):
        self.body = body
        assert isinstance(body, list)
        for x in body:
            checkinstance(x, stmt, False)
        self._fields = ('body',)
        self._type = None

    def walkabout(self, visitor):
        return visitor.visit_case_default(self)


class ASTVisitor(object):

    def visit_sequence(self, seq):
        if seq is not None:
            for node in seq:
                self.visit(node)

    def visit(self, node):
        return node.walkabout(self)

    def default_visitor(self, node):
        raise NodeVisitorNotImplemented

    def visit_TranslationUnit(self, node):
        return self.default_visitor(node)
    def visit_Program(self, node):
        return self.default_visitor(node)
    def visit_Module(self, node):
        return self.default_visitor(node)
    def visit_Subroutine(self, node):
        return self.default_visitor(node)
    def visit_Function(self, node):
        return self.default_visitor(node)
    def visit_Variable(self, node):
        return self.default_visitor(node)
    def visit_Assignment(self, node):
        return self.default_visitor(node)
    def visit_SubroutineCall(self, node):
        return self.default_visitor(node)
    def visit_BuiltinCall(self, node):
        return self.default_visitor(node)
    def visit_If(self, node):
        return self.default_visitor(node)
    def visit_Where(self, node):
        return self.default_visitor(node)
    def visit_Stop(self, node):
        return self.default_visitor(node)
    def visit_ErrorStop(self, node):
        return self.default_visitor(node)
    def visit_DoLoop(self, node):
        return self.default_visitor(node)
    def visit_Select(self, node):
        return self.default_visitor(node)
    def visit_Cycle(self, node):
        return self.default_visitor(node)
    def visit_Exit(self, node):
        return self.default_visitor(node)
    def visit_WhileLoop(self, node):
        return self.default_visitor(node)
    def visit_Print(self, node):
        return self.default_visitor(node)
    def visit_BoolOp(self, node):
        return self.default_visitor(node)
    def visit_BinOp(self, node):
        return self.default_visitor(node)
    def visit_UnaryOp(self, node):
        return self.default_visitor(node)
    def visit_Compare(self, node):
        return self.default_visitor(node)
    def visit_FuncCall(self, node):
        return self.default_visitor(node)
    def visit_ArrayRef(self, node):
        return self.default_visitor(node)
    def visit_ArrayInitializer(self, node):
        return self.default_visitor(node)
    def visit_Num(self, node):
        return self.default_visitor(node)
    def visit_Str(self, node):
        return self.default_visitor(node)
    def visit_VariableOld(self, node):
        return self.default_visitor(node)
    def visit_Var(self, node):
        return self.default_visitor(node)
    def visit_Constant(self, node):
        return self.default_visitor(node)
    def visit_Integer(self, node):
        return self.default_visitor(node)
    def visit_Real(self, node):
        return self.default_visitor(node)
    def visit_Complex(self, node):
        return self.default_visitor(node)
    def visit_Character(self, node):
        return self.default_visitor(node)
    def visit_Logical(self, node):
        return self.default_visitor(node)
    def visit_Derived(self, node):
        return self.default_visitor(node)
    def visit_dimension(self, node):
        return self.default_visitor(node)
    def visit_Attribute(self, node):
        return self.default_visitor(node)
    def visit_attribute_arg(self, node):
        return self.default_visitor(node)
    def visit_arg(self, node):
        return self.default_visitor(node)
    def visit_keyword(self, node):
        return self.default_visitor(node)
    def visit_Bind(self, node):
        return self.default_visitor(node)
    def visit_ArrayIndex(self, node):
        return self.default_visitor(node)
    def visit_do_loop_head(self, node):
        return self.default_visitor(node)
    def visit_case_stmt(self, node):
        return self.default_visitor(node)
    def visit_case_default(self, node):
        return self.default_visitor(node)

class GenericASTVisitor(ASTVisitor):

    def visit_TranslationUnit(self, node):
        pass

    def visit_Program(self, node):
        self.visit_sequence(node.body)

    def visit_Module(self, node):
        pass

    def visit_Subroutine(self, node):
        self.visit_sequence(node.args)
        self.visit_sequence(node.body)
        if node.bind:
            self.visit(node.bind)

    def visit_Function(self, node):
        self.visit_sequence(node.args)
        self.visit_sequence(node.body)
        if node.bind:
            self.visit(node.bind)
        self.visit(node.return_var)

    def visit_Variable(self, node):
        self.visit(node.type)

    def visit_Assignment(self, node):
        self.visit(node.target)
        self.visit(node.value)

    def visit_SubroutineCall(self, node):
        self.visit(node.name)
        self.visit_sequence(node.args)

    def visit_BuiltinCall(self, node):
        self.visit_sequence(node.args)

    def visit_If(self, node):
        self.visit(node.test)
        self.visit_sequence(node.body)
        self.visit_sequence(node.orelse)

    def visit_Where(self, node):
        self.visit(node.test)
        self.visit_sequence(node.body)
        self.visit_sequence(node.orelse)

    def visit_Stop(self, node):
        pass

    def visit_ErrorStop(self, node):
        pass

    def visit_DoLoop(self, node):
        if node.head:
            self.visit(node.head)
        self.visit_sequence(node.body)

    def visit_Select(self, node):
        self.visit(node.test)
        self.visit_sequence(node.body)
        if node.default:
            self.visit(node.default)

    def visit_Cycle(self, node):
        pass

    def visit_Exit(self, node):
        pass

    def visit_WhileLoop(self, node):
        self.visit(node.test)
        self.visit_sequence(node.body)

    def visit_Print(self, node):
        self.visit_sequence(node.values)

    def visit_BoolOp(self, node):
        self.visit(node.left)
        self.visit(node.right)
        self.visit(node.type)

    def visit_BinOp(self, node):
        self.visit(node.left)
        self.visit(node.right)
        self.visit(node.type)

    def visit_UnaryOp(self, node):
        self.visit(node.operand)
        self.visit(node.type)

    def visit_Compare(self, node):
        self.visit(node.left)
        self.visit(node.right)
        self.visit(node.type)

    def visit_FuncCall(self, node):
        self.visit(node.func)
        self.visit_sequence(node.args)
        self.visit_sequence(node.keywords)
        self.visit(node.type)

    def visit_ArrayRef(self, node):
        self.visit_sequence(node.args)
        self.visit(node.type)

    def visit_ArrayInitializer(self, node):
        self.visit_sequence(node.args)
        self.visit(node.type)

    def visit_Num(self, node):
        self.visit(node.type)

    def visit_Str(self, node):
        self.visit(node.type)

    def visit_VariableOld(self, node):
        self.visit(node.type)

    def visit_Var(self, node):
        self.visit(node.v)

    def visit_Constant(self, node):
        self.visit(node.type)

    def visit_Integer(self, node):
        self.visit_sequence(node.dims)

    def visit_Real(self, node):
        self.visit_sequence(node.dims)

    def visit_Complex(self, node):
        self.visit_sequence(node.dims)

    def visit_Character(self, node):
        self.visit_sequence(node.dims)

    def visit_Logical(self, node):
        self.visit_sequence(node.dims)

    def visit_Derived(self, node):
        self.visit_sequence(node.dims)

    def visit_dimension(self, node):
        if node.start:
            self.visit(node.start)
        if node.end:
            self.visit(node.end)

    def visit_Attribute(self, node):
        self.visit_sequence(node.args)

    def visit_attribute_arg(self, node):
        pass

    def visit_arg(self, node):
        pass

    def visit_keyword(self, node):
        self.visit(node.value)

    def visit_Bind(self, node):
        pass

    def visit_ArrayIndex(self, node):
        if node.left:
            self.visit(node.left)
        if node.right:
            self.visit(node.right)
        if node.step:
            self.visit(node.step)

    def visit_do_loop_head(self, node):
        self.visit(node.v)
        self.visit(node.start)
        self.visit(node.end)
        if node.increment:
            self.visit(node.increment)

    def visit_case_stmt(self, node):
        self.visit(node.test)
        self.visit_sequence(node.body)

    def visit_case_default(self, node):
        self.visit_sequence(node.body)


class NodeTransformerBase(ASTVisitor):

    def visit_TranslationUnit(self, node):
        global_scope = self.visit_object(node.global_scope)
        items = self.visit_object(node.items)
        return TranslationUnit(global_scope=global_scope, items=items)

    def visit_Program(self, node):
        name = self.visit_object(node.name)
        body = self.visit_sequence(node.body)
        symtab = self.visit_object(node.symtab)
        return Program(name=name, body=body, symtab=symtab)

    def visit_Module(self, node):
        name = self.visit_object(node.name)
        symtab = self.visit_object(node.symtab)
        return Module(name=name, symtab=symtab)

    def visit_Subroutine(self, node):
        name = self.visit_object(node.name)
        args = self.visit_sequence(node.args)
        body = self.visit_sequence(node.body)
        if node.bind:
            bind = self.visit(node.bind)
        else:
            bind = None
        symtab = self.visit_object(node.symtab)
        return Subroutine(name=name, args=args, body=body, bind=bind, symtab=symtab)

    def visit_Function(self, node):
        name = self.visit_object(node.name)
        args = self.visit_sequence(node.args)
        body = self.visit_sequence(node.body)
        if node.bind:
            bind = self.visit(node.bind)
        else:
            bind = None
        return_var = self.visit(node.return_var)
        module = self.visit_object(node.module)
        symtab = self.visit_object(node.symtab)
        return Function(name=name, args=args, body=body, bind=bind, return_var=return_var, module=module, symtab=symtab)

    def visit_Variable(self, node):
        name = self.visit_object(node.name)
        intent = self.visit_object(node.intent)
        type = self.visit(node.type)
        return Variable(name=name, intent=intent, type=type)

    def visit_Assignment(self, node):
        target = self.visit(node.target)
        value = self.visit(node.value)
        return Assignment(target=target, value=value)

    def visit_SubroutineCall(self, node):
        name = self.visit(node.name)
        args = self.visit_sequence(node.args)
        return SubroutineCall(name=name, args=args)

    def visit_BuiltinCall(self, node):
        name = self.visit_object(node.name)
        args = self.visit_sequence(node.args)
        return BuiltinCall(name=name, args=args)

    def visit_If(self, node):
        test = self.visit(node.test)
        body = self.visit_sequence(node.body)
        orelse = self.visit_sequence(node.orelse)
        return If(test=test, body=body, orelse=orelse)

    def visit_Where(self, node):
        test = self.visit(node.test)
        body = self.visit_sequence(node.body)
        orelse = self.visit_sequence(node.orelse)
        return Where(test=test, body=body, orelse=orelse)

    def visit_Stop(self, node):
        code = self.visit_object(node.code)
        return Stop(code=code)

    def visit_ErrorStop(self, node):
        return ErrorStop()

    def visit_DoLoop(self, node):
        if node.head:
            head = self.visit(node.head)
        else:
            head = None
        body = self.visit_sequence(node.body)
        return DoLoop(head=head, body=body)

    def visit_Select(self, node):
        test = self.visit(node.test)
        body = self.visit_sequence(node.body)
        if node.default:
            default = self.visit(node.default)
        else:
            default = None
        return Select(test=test, body=body, default=default)

    def visit_Cycle(self, node):
        return Cycle()

    def visit_Exit(self, node):
        return Exit()

    def visit_WhileLoop(self, node):
        test = self.visit(node.test)
        body = self.visit_sequence(node.body)
        return WhileLoop(test=test, body=body)

    def visit_Print(self, node):
        fmt = self.visit_object(node.fmt)
        values = self.visit_sequence(node.values)
        return Print(fmt=fmt, values=values)

    def visit_BoolOp(self, node):
        left = self.visit(node.left)
        op = self.visit_object(node.op)
        right = self.visit(node.right)
        type = self.visit(node.type)
        return BoolOp(left=left, op=op, right=right, type=type)

    def visit_BinOp(self, node):
        left = self.visit(node.left)
        op = self.visit_object(node.op)
        right = self.visit(node.right)
        type = self.visit(node.type)
        return BinOp(left=left, op=op, right=right, type=type)

    def visit_UnaryOp(self, node):
        op = self.visit_object(node.op)
        operand = self.visit(node.operand)
        type = self.visit(node.type)
        return UnaryOp(op=op, operand=operand, type=type)

    def visit_Compare(self, node):
        left = self.visit(node.left)
        op = self.visit_object(node.op)
        right = self.visit(node.right)
        type = self.visit(node.type)
        return Compare(left=left, op=op, right=right, type=type)

    def visit_FuncCall(self, node):
        func = self.visit(node.func)
        args = self.visit_sequence(node.args)
        keywords = self.visit_sequence(node.keywords)
        type = self.visit(node.type)
        return FuncCall(func=func, args=args, keywords=keywords, type=type)

    def visit_ArrayRef(self, node):
        name = self.visit_object(node.name)
        args = self.visit_sequence(node.args)
        type = self.visit(node.type)
        return ArrayRef(name=name, args=args, type=type)

    def visit_ArrayInitializer(self, node):
        args = self.visit_sequence(node.args)
        type = self.visit(node.type)
        return ArrayInitializer(args=args, type=type)

    def visit_Num(self, node):
        n = self.visit_object(node.n)
        type = self.visit(node.type)
        return Num(n=n, type=type)

    def visit_Str(self, node):
        s = self.visit_object(node.s)
        type = self.visit(node.type)
        return Str(s=s, type=type)

    def visit_VariableOld(self, node):
        name = self.visit_object(node.name)
        intent = self.visit_object(node.intent)
        dummy = self.visit_object(node.dummy)
        type = self.visit(node.type)
        return VariableOld(name=name, intent=intent, dummy=dummy, type=type)

    def visit_Var(self, node):
        symtab = self.visit_object(node.symtab)
        v = self.visit(node.v)
        return Var(symtab=symtab, v=v)

    def visit_Constant(self, node):
        value = self.visit_object(node.value)
        type = self.visit(node.type)
        return Constant(value=value, type=type)

    def visit_Integer(self, node):
        kind = self.visit_object(node.kind)
        dims = self.visit_sequence(node.dims)
        return Integer(kind=kind, dims=dims)

    def visit_Real(self, node):
        kind = self.visit_object(node.kind)
        dims = self.visit_sequence(node.dims)
        return Real(kind=kind, dims=dims)

    def visit_Complex(self, node):
        kind = self.visit_object(node.kind)
        dims = self.visit_sequence(node.dims)
        return Complex(kind=kind, dims=dims)

    def visit_Character(self, node):
        kind = self.visit_object(node.kind)
        dims = self.visit_sequence(node.dims)
        return Character(kind=kind, dims=dims)

    def visit_Logical(self, node):
        kind = self.visit_object(node.kind)
        dims = self.visit_sequence(node.dims)
        return Logical(kind=kind, dims=dims)

    def visit_Derived(self, node):
        name = self.visit_object(node.name)
        dims = self.visit_sequence(node.dims)
        module = self.visit_object(node.module)
        return Derived(name=name, dims=dims, module=module)

    def visit_dimension(self, node):
        if node.start:
            start = self.visit(node.start)
        else:
            start = None
        if node.end:
            end = self.visit(node.end)
        else:
            end = None
        return dimension(start=start, end=end)

    def visit_Attribute(self, node):
        name = self.visit_object(node.name)
        args = self.visit_sequence(node.args)
        return Attribute(name=name, args=args)

    def visit_attribute_arg(self, node):
        arg = self.visit_object(node.arg)
        return attribute_arg(arg=arg)

    def visit_arg(self, node):
        arg = self.visit_object(node.arg)
        return arg(arg=arg)

    def visit_keyword(self, node):
        arg = self.visit_object(node.arg)
        value = self.visit(node.value)
        return keyword(arg=arg, value=value)

    def visit_Bind(self, node):
        lang = self.visit_object(node.lang)
        name = self.visit_object(node.name)
        return Bind(lang=lang, name=name)

    def visit_ArrayIndex(self, node):
        if node.left:
            left = self.visit(node.left)
        else:
            left = None
        if node.right:
            right = self.visit(node.right)
        else:
            right = None
        if node.step:
            step = self.visit(node.step)
        else:
            step = None
        return ArrayIndex(left=left, right=right, step=step)

    def visit_do_loop_head(self, node):
        v = self.visit(node.v)
        start = self.visit(node.start)
        end = self.visit(node.end)
        if node.increment:
            increment = self.visit(node.increment)
        else:
            increment = None
        return do_loop_head(v=v, start=start, end=end, increment=increment)

    def visit_case_stmt(self, node):
        test = self.visit(node.test)
        body = self.visit_sequence(node.body)
        return case_stmt(test=test, body=body)

    def visit_case_default(self, node):
        body = self.visit_sequence(node.body)
        return case_default(body=body)


