# -*- coding: utf-8 -*-
from defs import SUBTYPES_R101

TAULA_CATEGORIA_SUJETO = [
    ('COM', 'Comercializadora'),
    ('DIS', 'Distribuidor'),
    ('TRA', 'Transportista'),
    ('CLI', 'Cliente Cualificado'),
    ('GTS', 'Gestor Técnico del Sistema'),
    ('OCS', 'Oficina de Cambio de Suministrador (OCSUM)'),
    ('GRE', 'Grupo Empresarial'),
]
TAULA_SUJETO = [
    ('0001', 'GAS NATURAL COMERCIALIZADORA, S.A.'),
    ('0002', 'EDP COMERCIALIZADORA, S.A.U.'),
    ('0004', 'EDP ENERGÍA, S.A.U.'),
    ('0005', 'BP GAS EUROPE, S.A.U.'),
    ('0006', 'COMERCIALIZADORA IBÉRICA DE GAS Y ENERGÍA ELÉCTRICA, S.A.U.'),
    ('0007', 'ENDESA ENERGÍA, S.A.'),
    ('0008', 'SHELL ESPAÑA, S.A.'),
    ('0009', 'CEPSA GAS COMERCIALIZADORA, S.A.'),
    ('0010', 'UNIÓN FENOSA GAS COMERCIALIZADORA, S.A.'),
    ('0016', 'CARBOEX, S.A.U.'),
    ('0028', 'INGENIERÍA Y COMERCIALIZACIÓN DEL GAS, S.A.'),
    ('0032', 'GDF SUEZ ENERGÍA ESPAÑA, S.A.U.'),
    ('0033', 'GAS NATURAL SERVICIOS SDG, S.A.'),
    ('0035', 'NEXUS ENERGÍA, S.A.'),
    ('0037', 'SHELL SPAIN LNG, S.A.'),
    ('0038', 'ENÉRGYA VM GESTIÓN DE ENERGÍA, S.L.U.'),
    ('0039', 'MULTISERVICIOS TECNOLÓGICOS, S.A.'),
    ('0041', 'BAHÍA DE BIZKAIA ELECTRICIDAD, S.L.'),
    ('0042', 'MOLGAS ENERGÍA, S.A.U.'),
    ('0043', 'LIQUID NATURAL GAZ, S.L.'),
    ('0044', 'VIESGO ENERGÍA, S.L.'),
    ('0045', 'SONATRACH GAS COMERCIALIZADORA, S.A.U.'),
    ('0047', 'EDF TRADING LIMITED'),
    ('0048', 'GALP ENERGÍA ESPAÑA, S.A.U.'),
    ('0049', 'AXPO IBERIA, S.L.'),
    ('0051', 'SAMPOL INGENIERÍA Y OBRAS, S.A.'),
    ('0052', 'GAS NATURAL S.U.R., SDG, S.A.'),
    ('0053', 'IBERDROLA GENERACIÓN, S.A.U.'),
    ('0054', 'IBERDROLA C.U.R., S.A.U.'),
    ('0057', 'MADRILEÑA SUMINISTRO DE GAS, S.L.'),
    ('0058', 'MADRILEÑA SUMINISTRO DE GAS S.U.R., S.L.'),
    ('0059', 'ENDESA ENERGÍA XXI, S.L.U.'),
    ('0060', 'EDP C.U.R., S.A.'),
    ('0061', 'SERVIGAS S. XXI, S.A.'),
    ('0062', 'ENOI S.P.A.'),
    ('0063', 'VILLAR MIR ENERGÍA, S.L.U.'),
    ('0064', 'E.ON GLOBAL COMMODITIES S.E.'),
    ('0066', 'FERTIBERIA, S.A.'),
    ('0068', 'FORTIA ENERGÍA, S.L.'),
    ('0069', 'EDP ENERGÍA GAS, S.L.'),
    ('0072', 'GUNVOR INTERNATIONAL B.V.'),
    ('0073', 'ALPIQ ENERGÍA ESPAÑA, S.A.U.'),
    ('0074', 'CENTROGAS GMBH'),
    ('0075', 'ORUS ENERGÍA, S.L.'),
    ('0076', 'ON DEMAND FACILITIES, S.L.'),
    ('0077', 'PETRONAVARRA, S.L.'),
    ('0080', 'GASINDUR, S.L.'),
    ('0081', 'STATOIL ASA'),
    ('0082', 'FACTOR ENERGÍA, S.A.'),
    ('0084', 'SWITCH ENERGY, S.L.'),
    ('0085', 'SOLVAY ENERGY SERVICES'),
    ('0086', 'CAPITAL ENERGY READ, S.L.'),
    ('0087', 'METHANE LOGISTICS, S.L.'),
    ('0088', 'CEPSA COMERCIAL PETRÓLEO, S.A.U.'),
    ('0089', 'CLIDOM ENERGY, S.L.'),
    ('0090', 'PRIMAGAS ENERGÍA, S.A.U.'),
    ('0091', 'VITOGAS ESPAÑA, S.A.U.'),
    ('0093', 'ENI S.P.A.'),
    ('0094', 'NOBLE CLEAN FUELS LIMITED'),
    ('0098', 'GOLD ENERGY-COMERCIALIZADORA DE ENERGÍA, S.A.'),
    ('0099', 'REPSOL LNG HOLDING, S.A.'),
    ('0100', 'ALPIQ AG'),
    ('0201', 'GAS DE ASTURIAS, S.A.'),
    ('0202', 'GAS DE FIGUERES, S.A.'),
    ('0203', 'GAS DIRECTO, S.A.'),
    ('0204', 'DISTRIBUIDORA REGIONAL DEL GAS, S.A.'),
    ('0205', 'REDEXIS GAS DISTRIBUCIÓN, S.A.U.'),
    ('0206', 'GAS ALICANTE, S.A.U.'),
    ('0207', 'DC GAS EXTREMADURA, S.A.'),
    ('0208', 'REDEXIS GAS ARAGÓN, S.A.'),
    ('0209', 'REDEXIS GAS BALEARES, S.A.'),
    ('0210', 'GAS DE EUSKADI, S.A.'),
    ('0211', 'BILBOGAS, S.A.'),
    ('0212', 'GAS Natural de Álava, S.A.'),
    ('0213', 'DONOSTI GAS, S.A.'),
    ('0214', 'GAS HERNANI, S.A.'),
    ('0215', 'GAS PASAIA, S.A.'),
    ('0216', 'TOLOSA GASA, S.A.'),
    ('0218', 'GAS ANDALUCIA, S.A.'),
    ('0219', 'GAS ENERGÍA DISTRIBUCIÓN CANTABRIA, S.A.'),
    ('0220', 'GAS CATILLA-LA MANCHA, S.A.'),
    ('0221', 'GAS CASTILLA Y LEON, S.A.'),
    ('0222', 'GAS NATURAL CEGAS, S.A.'),
    ('0223', 'GAS LA CORUÑA, S.A.'),
    ('0224', 'GAS GALICIA, S.A.'),
    ('0225', 'GAS NATURAL CEGAS, S.A.'),
    ('0226', 'GAS NAVARRA, S.A.'),
    ('0227', 'GAS RIOJA, S.A.'),
    ('0228', 'Gas Mérida, S.A.'),
    ('0229', 'Naturgas Energía Distribución, S.A.U.'),
    ('0230', 'GAS NATURAL CATALUNYA SDG, S.A.'),
    ('0231', 'IBERDROLA DISTRIBUCIÓN DE GAS, S.A.U.'),
    ('0232', 'GASIFICADORA REGIONAL CANARIA, S.A.'),
    ('0233', 'DISTRIBUIDORA SUREUROPEA DE GAS, S.A.'),
    ('0234', 'MADRILEÑA RED DE GAS, S.A.U.'),
    ('0235', 'TRANSMANCHEGA DE GAS, S.A.U.'),
    ('0236', 'MADRILEÑA RED DE GAS II, S.A.U.'),
    ('0237', 'GAS NATURAL MADRID SDG, S.A.'),
    ('0238', 'REDEXIS GAS, S.A.'),
    ('0239', 'GAS NATURAL ARAGÓN SDG, S.A.'),
    ('0240', 'GAS NATURAL REDES DISTRIBUCIÓN GAS SDG, S.A.'),
    ('0241', 'GAS NATURAL BALEARES, S.A.'),
    ('0242', 'EDP ESPAÑA DISTRIBUCIÓN GAS, S.A.U.'),
    ('0101', 'ENAGAS S.A.'),
    ('0102', 'Gas Natural SDG, S.A.'),
    ('0103', 'Transportista Regional del Gas, S.L.'),
    ('0104', 'Naturgas Energía Transporte, S.A.U..'),
    ('0105', 'Infraestructuras Gasistas de Navarra, S.L.'),
    ('0106', 'BBG'),
    ('0108', 'Planta de Regasificación de Sagunto, S.A.'),
    ('0111', 'GAS NATURAL TRANSPORTE SDG, S.L.'),
    ('0500', 'OCSUM'),
    ('0500', 'GASELA GMBH'),
    ('0501', 'COMPAÑÍA ESPAÑOLA DE PETRÓLEOS, S.A.U.'),
    ('0503', 'AUDAX ENERGÍA, S.A.'),
    ('0504', 'SOLVAY ENERGY SERVICES IBÉRICA, S.L.'),
    ('0505', 'AXEGAZ, S.A.S.'),
    ('0506', 'NOVAGAS CRIOGENIA, S.L.'),
    ('0507', 'KOCH COMMODITIES EUROPE LIMITED'),
    ('0509', 'DUFENERGY TRADING, S.A.'),
    ('0510', 'NEXT-E-ADVANCED ENERGY SERVICES, S.L.U.'),
    ('0511', 'NOVA COMERCIALIZADORA DE GAS, S.L.'),
    ('0512', 'GAS NATURAL EUROPE, S.A.S.'),
    ('0513', 'GAS MARINE BUNKER, S.L.'),
    ('0514', 'NEOELECTRA ENERGÍA, S.L.U.'),
    ('0515', 'VITOL, S.A.'),
    ('0516', 'GALP GAS NATURAL, S.A.'),
    ('0517', 'ECONGAS GMBH'),
    ('0518', 'CATGAS ENERGÍA, S.A.'),
    ('0519', 'CEPSA GAS Y ELECTRICIDAD, S.A.U.'),
    ('0520', 'GDF SUEZ, S.A.'),
    ('0521', 'ENI TRADING & SHIPPING, S.P.A.'),
    ('0522', 'LEGAS IBERIA, S.L.'),
    ('0523', 'GDF SUEZ TRADING'),
    ('0524', 'EDP GÁS.COM-COMÉRCIO DE GÁS NATURAL, S.A.'),
    ('0525', 'TRAFIGURA NAT GAS LIMITED'),
    ('0526', 'INVESTMENT SYNERGY GROUP ESPAÑA. S.L.U.'),
    ('0527', 'FENIE ENERGÍA, S.A.'),
    ('0528', 'GDF SUEZ ENERGY MANAGEMENT TRADING S.C.R.L.'),
    ('0529', 'IBERDROLA CLIENTES, S.A.U.'),
    ('0530', 'IBERDROLA GENERACIÓN ESPAÑA, S.A.U.'),
    ('0531', 'MULTIENERGÍA VERDE, S.L.'),
    ('0532', 'PETRO MEETING POINT, S.L.'),
    ('0533', 'SHELL ENERGY EUROPE LIMITED'),
    ('0534', 'PRIMA LNG N.V.'),
    ('0536', 'REPSOL BUTANO, S.A.'),
    ('0537', 'ALDRO ENERGÍA Y SOLUCIONES, S.L.U.'),
    ('0539', 'OGS ENERGÍA, S.L.'),
    ('0540', 'TRAFIGURA PTE, LTD'),
    ('0541', 'GAZPROM MARKETING & TRADING LIMITED'),
    ('0542', 'MET INTERNACIONAL AG'),
    ('0543', 'EURO GAS HOLDING, A.S.'),
    ('0544', 'GNERA ENERGÍA Y TECNOLOGÍA, S.L.'),
    ('0545', 'REPSOL COMERCIAL DE PRODUCTOS PETROLÍFEROS, S.A.'),
    ('0546', 'REMICA COMERCIALIZADORA, S.A.'),
    ('0547', 'BIROU GAS, S.L.'),
    ('0548', 'TRAILSTONE GMBH'),
    ('0549', 'WORLDENERGY, S.A.'),
    ('0550', 'PETROBRAS GLOBAL TRADING, B.V.'),
    ('0551', 'YADE JORMAN ESPAÑA, S.L.'),
    ('0552', 'ENERGY STROM XXI, S.L.'),
    ('0553', 'EDISON S.P.A.'),
    ('0554', 'POWERBRIDGE RESOURCES GROUP LTD'),
    ('0555', 'FUSIONA SOLUCIONES ENERGÉTICAS, S.A.'),
    ('0556', 'CRINGAS, S.L.'),
    ('0557', 'MACQUAIRE BANK LIMITED, LONDON BRANCH'),
    ('0558', 'AGENTE DEL MERCADO ELÉCTRICO, S.A.'),
    ('0559', 'GOLDMAN SACHS INTERNATIONAL'),
    ('0560', 'BETA RENOWABLE GROUP, S.A.'),
    ('0561', 'NUEVA COMERCIALIZADORA ESPAÑOLA, S.L.'),
    ('0562', 'FUTURA ENERGIA Y GAS, S.L.'),
    ('0563', 'DANSKE COMMODITIES A/S'),
    ('0564', 'ARCELORMITTAL ENERGY, S.C.A'),
    ('0565', 'CENTRICA LNG COMPANY LIMITED'),
    ('0566', 'VITA CAPITAL TRADING, S.L.'),
    ('0567', 'ADS ENERGY 8.0, S.L.'),
    ('0568', 'INSERIMOS ENERGÍA, S.L.'),
    ('0569', 'NINOBE SERVICIOS ENERGÉTICOS, S.L.'),
    ('0570', 'IGNIS ENERGÍA, S.L.'),
    ('0571', 'ELYGAS POWER, S.L.'),
    ('0572', 'ENERXIA GALEGA MAIS, S.L.'),
    ('0573', 'INTEGRACIÓN EUROPEA DE ENERGÍA, S.A.U.'),
    ('0574', 'ROLEAR - AUTOMATIZAÇOES, ESTUDOS E REPRESENTAÇOES, S.A.'),
    ('0575', 'MERRILL LYNCH INTERNATIONAL'),
    ('0576', 'ENERKIA ENERGÍA, S.L.'),
    ('0577', 'ENDESA GENERACIÓN, S.A.'),
    ('0578', 'COMERCIALIZADORA GONZÁLEZ ENERGÍA, S.L.'),
    ('0579', 'INER ENERGIA CASTILLA-LA MANCHA, S.L.'),
    ('0580', 'SWAP ENERGÍA, S.A.'),
    ('0582', 'WATIO WHOLESALE, S.L.'),
    ('0584', 'LABOIL ENERGÍA, S.L.'),
    ('0585', 'AURA ENERGÍA, S.L.'),
    ('0586', 'ANOTHER ENERGY OPTION, S.L.'),
    ('0587', 'PASO HONROSO, S.L.'),
    ('0588', 'FLIP ENERGÍA, S.L.'),
    ('0589', 'ENERCOTEC SERVICIOS, S.L.'),
    ('0590', 'DEVAL PETROLEUM, S.L.'),
    ('0591', 'ITAL REFINING, S.L.'),
    ('0592', 'MERIDIUM PETROLEUM, S.L.'),
    ('0593', 'PROT ENERGÍA COMERCIALIZACIÓN, S.L.'),
    ('0594', 'ELEGRAND ENERGÍA, S.L.'),
    ('0595', 'FUSIONA COMERCIALIZADORA, S.A.'),
    ('0596', 'ADELFAS ENERGIA, S.L.'),
    ('0597', 'FORTULUZ, S.L.U.'),
    ('0598', 'CENTRICA ENERGY LIMITED'),
    ('0600', 'MET ENERGÍA ESPAÑA, S.A'),
    ('0601', 'ALCANZIA ENERGÍA, S.L.'),
    ('0602', 'NEAS ENERGY, A/S'),
    ('0603', 'ECO NUEVOS DESARROLLOS ENERGETICOS, S.L.'),
    ('0604', 'LEDESMA COMERCIALIZADORA ELÉCTRICA, S.L.'),
    ('0605', 'XENERA COMPAÑÍA ELÉCTRICA, S.A.'),
    ('0606', 'GEO ALTERNATIVA, S.L.'),
    ('0607', 'GLENCORE ENERGY UK LTD'),
    ('0608', 'ENERPLUS ENERGÍA, S.A.'),
    ('0609', 'WATIUM, S.L.'),
    ('0610', 'TRAFIGURA TRADING (EUROPE), SARL'),
    ('0611', 'ANOTHER ENERGY OPTION, S.L.'),
    ('0612', 'INSIGNIA GAS, S.L.'),
    ('0613', 'IBERELÉCTRICA COMERCIALIZADORA, S.L.'),
    ('0614', 'VIVE ENERGÍA ELÉCTRICA, S.A.'),
    ('0615', 'VIVA ENERGÍA Y SOLUCIONES, S.L.'),
    ('0616', 'CHCUATRO GAS COMERCIALIZADORA, S.L.'),
    ('0617', 'A-DOS ENERGÍA, S.L.'),
    ('0618', 'COX ENERGÍA COMERCIALIZADORA ESPAÑA, S.L.U.'),
    ('0619', 'PETRONIEVES ENERGÍA 1, S.L.'),
    ('0620', 'EMASP SERVICIOS DE VALOR AÑADIDO, S.L.'),
    ('0621', 'HORIZON GAS COMERCIALIZADORA, S.L.'),
    ('0622', 'AGUAS DE BARBASTRO ENERGIA, S.L.'),
    ('0623', 'POTENZIA COMERCIALIZADORA, S.L.'),
    ('0624', 'SUMINISTRO DE GAS Y LUZ EUROPA,S.L.'),
    ('0625', 'ANTEA ENERGÍA COMERCIALIZADORA, S.L.'),
    ('0626', 'NEXT-E-ADVANCED SERVICES,S.L'),
]
TAULA_PROCESO = [
    ('02', 'Solicitud de Cambio'),
    ('03', 'Solicitud de Anulación'),
    ('04', 'Solicitud de Baja'),
    ('05', 'Solicitud de Modificación'),
    ('08', 'Mediciones'),
    ('09', 'Reparto ATR'),
    ('19', 'Solicitud de Anulación del distribuidor'),
    ('24', 'Comunicación de baja desde la distribuidora'),
    ('26', 'Comunicación Datos'),
    ('29', 'Solicitud de información de Producto/Contrato'),
    ('31', 'Facturación individual por CUPS'),
    ('32', 'Facturación agregada (datos por CUPS)'),
    ('33', 'Facturación agregada (datos por factura)'),
    ('36', 'Petición Datos CUPS sin contrato'),
    ('37', 'Petición Datos CUPS Disponible'),
    ('38', 'Puesta en Servicio Nuevos Suministros'),
    ('41', 'Cambio de Comercializador con Modificación de Datos'),
    ('42', 'Cambio de Comercializador con Nuevos Productos Adicionales'),
    ('43', 'Solicitud de Nuevo Producto/Contrato'),
    ('44', 'Actuaciones domiciliarias'),
    ('45', 'Comunicación operaciones iniciativa distribuidor'),
    ('46', 'Anulación de actuaciones domiciliarias'),
    ('48', 'Reclamaciones'),
    ('49', 'Desistimientos'),
    ('50', 'Traspaso a la CUR'),
    ('61', 'Notificación CUPS sin contrato en vigor disponibles para la contratación'),
]

TAULA_RESULTADO = [
    ('01', 'Aceptada'),
    ('05', 'Rechazada'),
    ('09', 'Realizada'),
    ('13', 'No Realizada'),
]

TAULA_MOTIVOS_DE_RECHAZO = [
    ('01', 'SCTD (GRE propietario o no propietario)'),
    ('02', 'Sistemas Propios (GRE propietario o DIS del mismo)'),
    ('03', 'Sistema del Comercializador'),
    ('04', 'Sistema del Transportista'),
    ('05', 'Sistema de OCSUM'),
]

# CAUSA DE COMUNICACIÓN no es fa. CAUSA_DE_COMUNICACIÓN

TAULA_TIPO_ENVIO = [
    ("P", "Provisional"),
    ("D", "Definitivo"),
]

TAULA_PERIODICIDAD_LECTURA = [
    ('01', 'Mensual'),
    ('02', 'Bimestral'),
    ('03', 'Anual'),
    ('04', 'Semestral'),
    ('05', 'Diaria (Telemedida)'),
]
TAULA_PERIODICIDAD_ALQUILER = [
    ('01', 'Mensual'),
    ('02', 'Bimestral'),
    ('03', 'Anual'),
    ('04', 'Semestral'),
    ('05', 'Diaria (Telemedida)'),
]
TAULA_PERIODICIDAD_CANON_IRC = [
    ('01', 'Mensual'),
    ('02', 'Bimestral'),
    ('03', 'Anual'),
    ('04', 'Semestral'),
    ('05', 'Diaria (Telemedida)'),
]
TAULA_PERIODICIDAD_RESTO_CONCEPTOS = [
    ('01', 'Mensual'),
    ('02', 'Bimestral'),
    ('03', 'Anual'),
    ('04', 'Semestral'),
    ('05', 'Diaria (Telemedida)'),
]
TAULA_PERIODICIDAD_FACTURACION = [
    ('01', 'MENSUAL'),
    ('02', 'BIMESTRAL'),
    ('03', 'ANUAL'),
    ('04', 'ÚNICA'),
]
TAULA_PROVINCIA = [
    ('01', 'ALAVA', '34'),
    ('02', 'ALBACETE', '34'),
    ('03', 'ALICANTE', '34'),
    ('04', 'ALMERIA', '34'),
    ('05', 'AVILA', '34'),
    ('06', 'BADAJOZ', '34'),
    ('07', 'BALEARES', '34'),
    ('08', 'BARCELONA', '34'),
    ('09', 'BURGOS', '34'),
    ('10', 'CACERES', '34'),
    ('11', 'CADIZ', '34'),
    ('12', 'CASTELLON', '34'),
    ('13', 'CIUDAD REAL', '34'),
    ('14', 'CORDOBA', '34'),
    ('15', 'LA CORUÑA', '34'),
    ('16', 'CUENCA', '34'),
    ('17', 'GERONA', '34'),
    ('18', 'GRANADA', '34'),
    ('19', 'GUADALAJARA', '34'),
    ('20', 'GUIPUZCOA', '34'),
    ('21', 'HUELVA', '34'),
    ('22', 'HUESCA', '34'),
    ('23', 'JAEN', '34'),
    ('24', 'LEON', '34'),
    ('25', 'LERIDA', '34'),
    ('26', 'LA RIOJA', '34'),
    ('27', 'LUGO', '34'),
    ('28', 'MADRID', '34'),
    ('29', 'MALAGA', '34'),
    ('30', 'MURCIA', '34'),
    ('31', 'NAVARRA', '34'),
    ('32', 'ORENSE', '34'),
    ('33', 'ASTURIAS', '34'),
    ('34', 'PALENCIA', '34'),
    ('35', 'LAS PALMAS', '34'),
    ('36', 'PONTEVEDRA', '34'),
    ('37', 'SALAMANCA', '34'),
    ('38', 'SANTA CRUZ DE TENERIFE', '34'),
    ('39', 'CANTABRIA', '34'),
    ('40', 'SEGOVIA', '34'),
    ('41', 'SEVILLA', '34'),
    ('42', 'SORIA', '34'),
    ('43', 'TARRAGONA', '34'),
    ('44', 'TERUEL', '34'),
    ('45', 'TOLEDO', '34'),
    ('46', 'VALENCIA', '34'),
    ('47', 'VALLADOLID', '34'),
    ('48', 'VIZCAYA', '34'),
    ('49', 'ZAMORA', '34'),
    ('50', 'ZARAGOZA', '34'),
    ('51', 'CEUTA', '34'),
    ('52', 'MELILLA', '34'),
]
TAULA_NACIONALIDAD = [
    ('SB', 'ISLAS SALOMON'),
    ('SC', 'ISL. SEYCHELLES'),
    ('SD', 'SUDAN'),
    ('SA', 'ARABIA SAUDI'),
    ('RE', 'REUNION'),
    ('QA', 'QATAR'),
    ('PY', 'PARAGUAY'),
    ('RW', 'RUANDA'),
    ('RU', 'FEDERACION RUSA'),
    ('RO', 'RUMANIA'),
    ('SM', 'SAN MARINO'),
    ('SL', 'SIERRA LEONA'),
    ('SN', 'SENEGAL'),
    ('SR', 'SURINAM'),
    ('SO', 'SOMALIA'),
    ('SK', 'ESLOVAQUIA'),
    ('SG', 'SINGAPUR'),
    ('SE', 'SUECIA'),
    ('SH', 'SANTA ELENA'),
    ('SJ', 'SVALBARD AND JAN MAYEN'),
    ('SI', 'ESLOVENIA'),
    ('PW', 'PALAU'),
    ('NU', 'ISLAS NIUE'),
    ('NR', 'NAURU'),
    ('NZ', 'NUEVA ZELANDA'),
    ('PA', 'PANAMA'),
    ('OM', 'OMAN'),
    ('NI', 'NICARAGUA'),
    ('NG', 'NIGERIA'),
    ('NL', 'HOLANDA'),
    ('NP', 'NEPAL'),
    ('NO', 'NORUEGA'),
    ('PE', 'PERU'),
    ('PN', 'ISLAS PITCAIRN'),
    ('PM', 'SAINT PIERRE AND MIQUELON'),
    ('PR', 'PUERTO RICO'),
    ('PT', 'PORTUGAL'),
    ('PS', 'PALESTINA, TERRITORIO OCUPADO DE'),
    ('PG', 'PAPUA NUEVA GUINEA'),
    ('PF', 'POLINESIA FRANCESA'),
    ('PH', 'FILIPINAS'),
    ('PL', 'POLONIA'),
    ('PK', 'PAQUISTAN'),
    ('VC', 'SAN VICENTE Y LAS GRANADINAS'),
    ('VA', 'CIUDAD DEL VATICANO'),
    ('VE', 'VENEZUELA'),
    ('VI', 'ISLAS VIRGENES (ESTADOUNIDENSES)'),
    ('VG', 'ISLAS VIRGENES (INGLESAS)'),
    ('UM', 'ISLAS MINOR OUTLYNG'),
    ('UG', 'UGANDA'),
    ('US', 'ESTADOS UNIDOS'),
    ('UZ', 'UZBEKISTAN'),
    ('UY', 'URUGUAY'),
    ('ZW', 'ZIMBABWE'),
    ('WS', 'SAMOA'),
    ('YE', 'YEMEN'),
    ('WF', 'WALLIS AND FUTUNA'),
    ('VN', 'VIETNAM'),
    ('VU', 'VANUATU'),
    ('ZM', 'ZAMBIA'),
    ('ZR', 'REPUBLICA DEMOCRATICA DEL CONGO'),
    ('ZA', 'SUDAFRICA'),
    ('YT', 'MAYOTTE'),
    ('YU', 'YUGOSLAVIA'),
    ('UA', 'UCRANIA'),
    ('TF', 'FRENCH SOUTHERN TERRITORIES'),
    ('TD', 'CHAD'),
    ('TG', 'TOGO'),
    ('TJ', 'TAYIKISTAN'),
    ('TH', 'TAILANDIA'),
    ('SV', 'EL SALVADOR'),
    ('ST', 'SANTO TOME Y PRINCIPE'),
    ('SY', 'SIRIA, REPUBLICA ARABE DE'),
    ('TC', 'ISLAS TURKS Y ISLA DE CAICOS'),
    ('SZ', 'SWAZILANDIA'),
    ('TK', 'ISLAS TOKELAU'),
    ('TT', 'TRINIDAD Y TOBAGO'),
    ('TR', 'TURQUIA'),
    ('TV', 'TUVALU'),
    ('TZ', 'TANZANIA, REPUBLICA DE'),
    ('TW', 'TAIWAN, PROVINCIA DE CHINA'),
    ('TM', 'TURKMENISTAN'),
    ('TL', 'TIMOR ORIENTAL'),
    ('TN', 'TUNEZ'),
    ('TP', 'TIMOR ORIENTAL'),
    ('TO', 'TONGA'),
    ('NF', 'ISLA DE NORFOLK'),
    ('BE', 'BELGICA'),
    ('BF', 'BURKINA FASO'),
    ('BB', 'BARBADOS, LAS'),
    ('BD', 'BANGLADESH'),
    ('BG', 'BULGARIA'),
    ('BJ', 'BENIN'),
    ('BM', 'BERMUDAS, LAS'),
    ('BH', 'BAHREIN'),
    ('BI', 'BURUNDI'),
    ('BA', 'BOSNIA Y HERZEGOVINA'),
    ('AQ', 'ANTARTICO'),
    ('AR', 'ARGENTINA'),
    ('AN', 'ANTILLAS HOLANDESAS'),
    ('AO', 'ANGOLA'),
    ('AS', 'SAMOA AMERICANA'),
    ('AW', 'ARUBA'),
    ('AZ', 'AZERBAIYAN'),
    ('AT', 'AUSTRIA'),
    ('AU', 'AUSTRALIA'),
    ('CF', 'REPUBLICA CENTRO – AFRICANA'),
    ('CG', 'CONGO'),
    ('CC', 'ISLAS COCO'),
    ('CD', 'REPUBLICA DEMOCRATICA DEL CONGO'),
    ('CH', 'SUIZA'),
    ('IO', 'TERRITORIOS BRITANICOS DEL OCEANO INDICO'),
    ('IQ', 'IRAK'),
    ('CI', 'COSTA DE MARFIL'),
    ('CK', 'ISLAS COOK'),
    ('CA', 'CANADA'),
    ('BR', 'BRASIL'),
    ('BS', 'BAHAMAS, LAS'),
    ('BN', 'BRUNEI (DARUSSALAM)'),
    ('BO', 'BOLIVIA'),
    ('BT', 'BUTAN'),
    ('BY', 'BIELORRUSIA'),
    ('BZ', 'BELICE'),
    ('BV', 'ISLAS BOUVET'),
    ('BW', 'BOTSWANA'),
    ('AM', 'ARMENIA'),
    ('GM', 'GAMBIA'),
    ('GN', 'GUINEA'),
    ('GI', 'GIBRALTAR'),
    ('GL', 'GROENLANDIA'),
    ('GP', 'GUADALUPE'),
    ('GS', 'GEORGIA DEL SUR Y LAS ISLAS SANDWICH'),
    ('GT', 'GUATEMALA'),
    ('GQ', 'GUINEA ECUATORIAL'),
    ('GR', 'GRECIA'),
    ('GH', 'GHANA'),
    ('FO', 'ISLAS FAROE'),
    ('FR', 'FRANCIA'),
    ('FK', 'ISLAS MALVINAS'),
    ('FM', 'MICRONESIA, ESTADOS FEDERALES DE'),
    ('GA', 'GABON'),
    ('GE', 'GEORGIA'),
    ('GF', 'GUAYANA FRANCESA'),
    ('GB', 'GRAN BRETAÑA'),
    ('GD', 'GRANADA'),
    ('IN', 'INDIA'),
    ('AD', 'ANDORRA'),
    ('IE', 'IRLANDA'),
    ('IL', 'ISRAEL'),
    ('AE', 'EMIRATOS ARABES (UNIDOS)'),
    ('AI', 'ANGUILLA'),
    ('AL', 'ALBANIA'),
    ('AF', 'AFGANISTAN'),
    ('AG', 'ANTIGUA Y BARBUDA'),
    ('ID', 'INDONESIA'),
    ('GY', 'GUAYANA'),
    ('HK', 'HONG KONG'),
    ('GU', 'GUAM'),
    ('GW', 'GUINEA-BISSAU'),
    ('HM', 'ISLA HEARD '),
    ('HT', 'HAITI'),
    ('HU', 'HUNGRIA'),
    ('HN', 'HONDURAS'),
    ('HR', 'CROACIA'),
    ('LV', 'LETONIA'),
    ('LY', 'LIBIA'),
    ('LT', 'LITUANIA'),
    ('LU', 'LUXEMBURGO'),
    ('MA', 'MARRUECOS'),
    ('MG', 'MADAGASCAR'),
    ('MH', 'ISLAS MARSHALL'),
    ('MC', 'MONACO'),
    ('MD', 'MOLDAVIA, REPUBLICA DE'),
    ('LS', 'LESOTHO'),
    ('KZ', 'KAZAJISTAN'),
    ('LA', 'LAOS, REPUBLICA POPULAR DEMOCRATICA DE'),
    ('KW', 'KUWAIT'),
    ('KY', 'ISLAS CAIMAN'),
    ('LB', 'LIBANO'),
    ('LK', 'SRI LANKA'),
    ('LR', 'LIBERIA'),
    ('LC', 'SANTA LUCIA'),
    ('LI', 'LIECHTENSTEIN'),
    ('MW', 'MALAWI'),
    ('MX', 'MEJICO'),
    ('MU', 'MAURICIO(ISL.)'),
    ('MV', 'MALDIVAS, LAS'),
    ('MY', 'MALASIA'),
    ('NC', 'NUEVA CALEDONIA'),
    ('NE', 'NIGER'),
    ('MZ', 'MOZAMBIQUE'),
    ('NA', 'NAMIBIA'),
    ('MT', 'MALTA'),
    ('MM', 'MYANMAR'),
    ('MN', 'MONGOLIA'),
    ('MK', 'MACEDONIA'),
    ('ML', 'MALI'),
    ('MO', 'MACAO'),
    ('MR', 'MAURITANIA'),
    ('MS', 'MONTSERRAT'),
    ('MP', 'ISLA N.MARIANA'),
    ('MQ', 'MARTINICA'),
    ('KR', 'COREA DEL SUR'),
    ('CL', 'CHILE'),
    ('CM', 'CAMERUN'),
    ('KM', 'COMORAS'),
    ('KN', 'SAINT KITTS AND NEVIS'),
    ('CN', 'CHINA'),
    ('CU', 'CUBA'),
    ('CV', 'CABO VERDE'),
    ('CO', 'COLOMBIA'),
    ('CR', 'COSTA RICA'),
    ('KI', 'KIRIBATI'),
    ('JP', 'JAPON'),
    ('JO', 'JORDANIA'),
    ('KG', 'KIRGUIZISTAN'),
    ('KE', 'KENIA'),
    ('JM', 'JAMAICA'),
    ('IR', 'IRAN, REPUBLICA ISLAMICA DE'),
    ('KH', 'CAMBOYA'),
    ('IT', 'ITALIA'),
    ('IS', 'ISLANDIA'),
    ('EH', 'SAHARA OCCIDENTAL'),
    ('ER', 'ERITREA'),
    ('EE', 'ESTONIA'),
    ('EG', 'EGIPTO'),
    ('ES', 'ESPAÑA'),
    ('FJ', 'ISLAS FIJI'),
    ('KP', 'COREA DEL NORTE'),
    ('ET', 'ETIOPIA'),
    ('FI', 'FINLANDIA'),
    ('EC', 'ECUADOR'),
    ('CZ', 'REPUBLICA CHECA'),
    ('DE', 'ALEMANIA'),
    ('CX', 'ISLAS NAVIDAD'),
    ('CY', 'CHIPRE'),
    ('DJ', 'DJIBOUTI'),
    ('DO', 'REPUBLICA DOMINICANA'),
    ('DZ', 'ARGELIA'),
    ('DK', 'DINAMARCA'),
    ('DM', 'DOMINICA'),
]
TAULA_TIPO_VIA = [
    ('ACCE', 'ACCES'),
    ('ACCES', 'ACCESO'),
    ('ACEQ', 'ACEQUIA'),
    ('ACERA', 'ACERA'),
    ('ALAM', 'ALAMEDA'),
    ('ALDAP', 'ALDAPA'),
    ('ALDEA', 'ALDEA'),
    ('ALQUE', 'ALQUERIA'),
    ('ALTO', 'ALTO', ), 
    ('ANDAD', 'ANDADOR', ), 
    ('ANGTA', 'ANGOSTA', ), 
    ('APTES', 'APARTAMENTS', ), 
    ('APTOS', 'APARTAMENTOS', ), 
    ('ARB', 'ARBOLEDA', ), 
    ('ARRAL', 'ARRABAL', ), 
    ('ARRY', 'ARROYO', ), 
    ('ASSEG', 'ASSEGADOR', ), 
    ('ATAJO', 'ATAJO', ), 
    ('ATAL', 'ATALL', ), 
    ('ATALL', 'ATALLO', ), 
    ('ATZUC', 'ATZUCAT', ), 
    ('AUTO', 'AUTOPISTA', ), 
    ('AUZO', 'AUZO', ), 
    ('AUZOT', 'AUZOTEGI', ), 
    ('AUZUN', 'AUZUNEA', ), 
    ('AV', 'AVINGUDA', ), 
    ('AVDA', 'AVENIDA', ), 
    ('AVGDA', 'AVINGUDA', ), 
    ('AVIA', 'AUTOVIA', ), 
    ('BARDA', 'BARRIADA', ), 
    ('BARRI', 'BARRI', ), 
    ('BARRO', 'BARRIO', ), 
    ('BDA', 'BAIXADA', ), 
    ('BELNA', 'BELENA', ), 
    ('BIDE', 'BIDE', ), 
    ('BIDEB', 'BIDEBIETA', ), 
    ('BJADA', 'BAJADA', ), 
    ('BLQUE', 'BLOQUE', ), 
    ('BRANC', 'BARRANCO', ), 
    ('BRDLA', 'BARREDUELA', ), 
    ('BRZAL', 'BRAZAL', ), 
    ('BULEV', 'BULEVAR', ), 
    ('BV', 'BULEVAR', ), 
    ('C', 'CARRER', ), 
    ('C.H.', 'CMNO HONDO', ), 
    ('C.N.', 'CMNO NUEVO', ), 
    ('C.V.', 'CMNO VIEJO', ), 
    ('C/', 'CARRER', ), 
    ('CÑADA', 'CAÑADA', ), 
    ('CALLE', 'CALLE', ), 
    ('CAMI', 'CAMI', ), 
    ('CAMIN', 'CAMIN', ), 
    ('CAMPA', 'CAMPA', ), 
    ('CANÑO', 'CANTIÑO', ), 
    ('CANAL', 'CANAL', ), 
    ('CANT', 'CANTON', ), 
    ('CANTO', 'CANTO', ), 
    ('CARRA', 'CARRERADA', ), 
    ('CARRE', 'CARRER', ), 
    ('CARRY', 'CARRERANY', ), 
    ('CBTIZ', 'COBERTIZO', ), 
    ('CELLA', 'CANELLA', ), 
    ('CERRO', 'CERRO', ), 
    ('CINT', 'CINTURO', ), 
    ('CINY', 'CINYELL', ), 
    ('CIRCU', 'CIRCUMVAL.LACIO', ), 
    ('CJLA', 'CALLEJUELA', ), 
    ('CJTO', 'CONJUNTO', ), 
    ('CLEYA', 'CALEYA', ), 
    ('CLLJA', 'CALLEJA', ), 
    ('CLLON', 'CALLEJON', ), 
    ('CLLZO', 'CALLIZO', ), 
    ('CLYON', 'CALEYON', ), 
    ('CMÑO', 'CAMIÑO', ), 
    ('CMNO', 'CAMINO', ), 
    ('COL', 'COLONIA', ), 
    ('COMPJ', 'COMPLEJO', ), 
    ('COMPX', 'COMPLEXO', ), 
    ('COSTA', 'COSTA', ), 
    ('CRA', 'CARRERA', ), 
    ('CRLLO', 'CORRILLO', ), 
    ('CRO', 'CARRERO', ), 
    ('CRRAL', 'CORRALO', ), 
    ('CRRCI', 'CORREDORCILLO', ), 
    ('CRRDA', 'CORREDOIRA', ), 
    ('CRRDE', 'CORREDERA', ), 
    ('CRRDO', 'CORREDOR', ), 
    ('CRRIL', 'CARRIL', ), 
    ('CRRLO', 'CORRALILLO', ), 
    ('CRROL', 'CORRIOL', ), 
    ('CRTIL', 'CARRETIL', ), 
    ('CRTJO', 'CORTIJO', ), 
    ('CSRIO', 'CASERIO', ), 
    ('CSTAN', 'COSTANILLA', ), 
    ('CTRA', 'CARRETERA', ), 
    ('CTRIN', 'CARRETERIN', ), 
    ('CUSTA', 'CUESTA', ), 
    ('CXON', 'CALEXON', ), 
    ('CXTO', 'CONXUNTO', ), 
    ('CZADA', 'CALZADA', ), 
    ('CZADS', 'CALZADAS', ), 
    ('DEMAR', 'DEMARCACIO', ), 
    ('DRERA', 'DRECERA', ), 
    ('EIRAD', 'EIRADO', ), 
    ('ENTD', 'ENTRADA', ), 
    ('EPTZA', 'ENPARANTZA', ), 
    ('ERREB', 'ERREBAL', ), 
    ('ERREK', 'ERREKA', ), 
    ('ERREP', 'ERREPIDE', ), 
    ('ERRIB', 'ERRIBERA', ), 
    ('ESCA', 'ESCALERA', ), 
    ('ESCAL', 'ESCALINATA', ), 
    ('ESLDA', 'ESPALDA', ), 
    ('ESTDA', 'ESTRADA', ), 
    ('ETDEA', 'ETORBIDE', ), 
    ('ETXAD', 'ETXADI', ), 
    ('ETXAR', 'ETXARTE', ), 
    ('ETXAT', 'ETXATZE', ), 
    ('EXPLA', 'EXPLANADA', ), 
    ('EXTRM', 'EXTRAMUROS', ), 
    ('EXTRR', 'EXTRARRADIO', ), 
    ('FALDA', 'FALDA', ), 
    ('FINCA', 'FINCA', ), 
    ('G.V.', 'GRAN VIA', ), 
    ('GAIN', 'GAIN', ), 
    ('GALE', 'GALERIA', ), 
    ('GORAB', 'GORABIDE', ), 
    ('GRUP', 'GRUPO', ), 
    ('GRUPO', 'GRUPO', ), 
    ('GTA', 'GLORIETA', ), 
    ('HEGI', 'HEGI', ), 
    ('HIRIB', 'HIRIBIDE', ), 
    ('HONDA', 'HONDARTZA', ), 
    ('HOYA', 'HOYA', ), 
    ('IBILB', 'IBILBIDE', ), 
    ('ILLA', 'ILLA', ), 
    ('INDA', 'INDA', ), 
    ('JARD', 'JARDI', ), 
    ('JDIN', 'JARDIN', ), 
    ('JDINS', 'JARDINES', ), 
    ('KAI', 'KAI', ), 
    ('KALE', 'KALE', ), 
    ('KARIK', 'KARRIKA', ), 
    ('KARRE', 'KARRERA', ), 
    ('KARRI', 'KARRICA', ), 
    ('KOSTA', 'KOSTA', ), 
    ('KRRIL', 'KARRIL', ), 
    ('LAGO', 'LAGO', ), 
    ('LASTE', 'LASTERBIDE', ), 
    ('LDERA', 'LADERA', ), 
    ('LEKU', 'LEKU', ), 
    ('LLOC', 'LLOC', ), 
    ('LOMA', 'LOMA', ), 
    ('LORAK', 'LORATEGIAK', ), 
    ('LORAT', 'LORATEGI', ), 
    ('LUGAR', 'LUGAR', ), 
    ('MALEC', 'MALECON', ), 
    ('MAZO', 'MAZO', ), 
    ('MENDI', 'MENDI', ), 
    ('MIRAD', 'MIRADOR', ), 
    ('MOLL', 'MOLL', ), 
    ('MONTE', 'MONTE', ), 
    ('MUELL', 'MUELLE', ), 
    ('ONDAR', 'ONDARTZA', ), 
    ('PAGO', 'PAGO', ), 
    ('PARC', 'PARQUE', ), 
    ('PARKE', 'PARKE', ), 
    ('PARTI', 'PARTICULAR', ), 
    ('PAS', 'PAS', ), 
    ('PASAI', 'PASAI', ), 
    ('PASEA', 'PASEABIDE', ), 
    ('PASEO', 'PASEO', ), 
    ('PBDO', 'POBLADO', ), 
    ('PDA', 'PUJADA', ), 
    ('PDIS', 'PASSADIS', ), 
    ('PG', 'PASSEIG', ), 
    ('PINAR', 'PINAR', ), 
    ('PISTA', 'PISTA', ), 
    ('PJDA', 'PUJADA, SUBIDA', ), 
    ('PL', 'PLACA', ), 
    ('PLA', 'PLA', ), 
    ('PLAÇA', 'PLAÇA', ), 
    ('PLAYA', 'PLAYA', ), 
    ('PLAZA', 'PLAZA', ), 
    ('PLCET', 'PLACETA', ), 
    ('PLLO', 'PASILLO', ), 
    ('PLZLA', 'PLAZUELA', ), 
    ('PNTE', 'PUENTE', ), 
    ('POLIG', 'POLIGONO', ), 
    ('PONT', 'PONT', ), 
    ('PONTE', 'PONTE', ), 
    ('PORT', 'PORT', ), 
    ('PQUE', 'PARQUE', ), 
    ('PRAÑA', 'PRACIÑA', ), 
    ('PRAGE', 'PARATGE', ), 
    ('PRAIA', 'PRAIA', ), 
    ('PRAJE', 'PARAJE', ), 
    ('PRAZA', 'PRAZA', ), 
    ('PROL', 'PORLONGACION', ), 
    ('PSAJE', 'PASAJE', ), 
    ('PSAXE', 'PARAXE', ), 
    ('PTDA', 'PARTIDA', ), 
    ('PTGE', 'PASSATGE', ), 
    ('PTLLO', 'PORTILLO', ), 
    ('PZO', 'PASADIZO', ), 
    ('PZTA', 'PLAZOLETA', ), 
    ('RABAL', 'RABAL', ), 
    ('RACDA', 'RACONADA', ), 
    ('RACO', 'RACO', ), 
    ('RAMAL', 'RAMAL', ), 
    ('RAMPA', 'RAMPA', ), 
    ('RAMPS', 'RAMPAS', ), 
    ('RAVAL', 'RAVAL', ), 
    ('RBLA', 'RAMBLA', ), 
    ('RBRA', 'RIBERA', ), 
    ('RCDA', 'RINCONADA', ), 
    ('RCON', 'RINCON', ), 
    ('RENTO', 'RECANTO', ), 
    ('RIERA', 'RIERA', ), 
    ('RONDA', 'RONDA', ), 
    ('RTDA', 'ROTONDA', ), 
    ('RUA', 'RUA', ), 
    ('RUELA', 'RUELA', ), 
    ('RUERO', 'RUEIRO', ), 
    ('SARBI', 'SARBIDE', ), 
    ('SBIDA', 'SUBIDA', ), 
    ('SECT', 'SECTOR', ), 
    ('SEDER', 'SENDER', ), 
    ('SEDRA', 'SENDERA', ), 
    ('SEKT', 'SEKTORE', ), 
    ('SEND', 'SENDERO', ), 
    ('SENDA', 'SENDA', ), 
    ('SVTIA', 'SERVENTIA', ), 
    ('TALDE', 'TALDE', ), 
    ('TOKI', 'TOKI', ), 
    ('TRANS', 'TRANSITO', ), 
    ('TRAS', 'TRASERA', ), 
    ('TRAV', 'TRAVESSERA', ), 
    ('TRRNT', 'TORRENT', ), 
    ('TRSSI', 'TRAVESSIA', ), 
    ('TRVA', 'TRAVESIA', ), 
    ('TRVAL', 'TRANSVERSAL', ), 
    ('URB', 'URBANIZACION', ), 
    ('URBAT', 'URBANITZACIO', ), 
    ('URBAZ', 'URBANIZAZIO', ), 
    ('VALLE', 'VALLE', ), 
    ('VCTO', 'VIADUCTO', ), 
    ('VEGA', 'VEGA', ), 
    ('VENAT', 'VEINAT', ), 
    ('VENLA', 'VENELA', ), 
    ('VIA', 'VIA', ), 
    ('VIAL', 'VIAL', ), 
    ('VIANY', 'VIARANY', ), 
    ('VREDA', 'VEREDA', ), 
    ('XDIN', 'XARDIN', ), 
    ('ZEHAR', 'ZEARKALETA', ), 
    ('ZONA', 'ZONA', ), 
    ('ZUBI', 'ZUBI', ), 
    ('ZUHAI', 'ZUHAIZTI', ), 
    ('ZUMAR', 'ZUMARDI', ), 
]

TAULA_ZONA_CLIMATICA = [
    ('1', 'Zona 1 (Sevilla)'),
    ('2', 'Zona 2 (Barcelona)'),
    ('3', 'Zona 3 (Madrid)'),
    ('4', 'Zona 4 (Valladolid)'),
]

TAULA_TIPO_DOCUMENTO = [
    ('01', 'NIF'),
    ('03', 'PASAPORTE'),
    ('04', 'Número de identificación de extranjeros'),
    ('07', 'NIVA'),
    ('08', 'Otros'),
]
TAULA_TIPO_PERSONA = [
    ('F', 'Física'),
    ('J', 'Jurídica'),
]
TAULA_MOTIVOS_DE_RECHAZO_CNMC = [
    ('R01', 'Cliente suministrado desde planta satélite.'),
    ('R03', 'El CUPS no está conectado al distribuidor que se '
            'indica en la solicitud.'),
    ('R04', 'Falta infraestructura.'),
    ('R07', 'Si el modelo fecha efecto que solicita es "03" o “04” debe '
            'cumplimentar el campo "Fecha efecto solicitada" '),
    ('R08', 'La fecha de efecto solicitada "@replace1@" no puede ser '
            'menor que la fecha "@replace2@" de la cabecera.'),
    ('R11', 'El municipio "@replace1@" no pertenece a la '
            'provincia "@replace2@".'),
    ('R12', 'Error de integridad: DNI no coherente con DNI del contrato en vigor en CUPS. '),
    ('R14', 'El día de la fecha efecto solicitada es errónea, tiene que ser el '
            '1, 11 ó 21 del mes. '),
    ('R19', 'Si el motivo de modificación es @replace1@, los '
            'campos @replace2@ tienen que ser distintos.'),
    ('R24', 'El nuevo peaje no puede coincidir con el peaje actual del '
            'contrato.'),
    ('R26', 'Nuevo Caudal Diario no puede coincidir con el '
            'Caudal Diario Actual del contrato.'),
    ('R29', 'CUPS inexistente.'),
    ('R32', 'Fecha efecto solicitada anterior a 30 días naturales respecto a la fecha de carga .'),
    ('R34', 'No existe contrato de ATR en vigor.'),
    ('R35', 'Existe una solicitud previa del tipo nuevo suministro del '
            'mismo comercializador.'),
    ('R36', 'Existe una solicitud previa del tipo baja del '
            'mismo comercializador.'),
    ('R37', 'Existe una solicitud previa de tipo cambio del '
            'mismo comercializador.'),
    ('R38', 'Existe una solicitud previa de tipo modificación del '
            'mismo comercializador.'),
    ('R39', 'Existe una solicitud previa de tipo anulación del '
            'mismo comercializador.'),
    ('R40', 'El comercializador no es la empresa titular del contrato ATR en '
            'vigor.'),
    ('R41', 'No existe una previa del comercializador que solicita la '
            'Anulación/Desistimiento.'),
    ('R42', 'La solicitud que se intenta anular ya está "en trámite" o '
            'formalizada.'),
    ('R43', 'El CUPS ya está activo con la comercializadora solicitante/receptora.'),
    ('R44', 'Existe una solicitud previa del tipo alta de '
            'otra Comercializadora.'),
    ('R45', 'Existe una solicitud previa de baja de otra comercializadora.'),
    ('R46', 'Existe una solicitud previa de cambio de otra comercializadora.'),
    ('R47', 'Existe una solicitud previa de modificación '),
    ('R48', 'Existe una solicitud previa de anulación de otra comercializadora.'),
    ('R49', 'Suministro a Presión superior a 16 bares. Debe presentarse la '
            'solicitud a través del transportista.'),
    ('R51', 'CUPS en servicio con otra comercializadora.'),
    ('R61', 'Si el motivo de modificación es @replace1@, se debe '
            'enviar alguno de los campos @replace2@.'),
    ('R62', 'Si la presión solicitada es mayor de 4 bares o el peaje es 3.5, '
            'es obligatorio que el campo Caudal Diario tenga un valor'),
    ('R64', 'El número de documento informado no cumple con las '
            'validaciones definidas sobre los documentos del tipo enviado'),
    ('R70', 'Otros motivos no contemplados en el resto del listado.'),
    ('R73', 'No se cumple período mínimo desde la última modificación de '
            'peaje o Qd'),
    ('R74', 'Error de integridad: @replace@'),
    ('R75', 'No se puede suspender el suministro Pobreza energética'),
    ('R76', 'Incidencia no subsanada en periodo máximo establecido'),
    ('R77', 'Comercializadora inactiva'),
    ('R78', 'El Código de Solicitud ya ha sido recibido con '
            'anterioridad para ese mismo agente'),
    ('R79', 'Existe una Solicitud de Actuación en '
            'curso del mismo comercializador'),
    ('R80', 'Existe una Solicitud de Actuación en '
            'curso de otro comercializador'),
    ('R81', 'Reclamación duplicada'),
    ('R82', 'Factura inexistente'),
    ('R83', 'Concurrencia con cambio/Traspaso CUR'),
    ('R84', 'Anomalía instalación'),
    ('R85', 'Corte Anulado'),
    ('R86', 'Cliente no quiere gas'),
    ('R87', 'Cliente quiere gas más adelante'),
    ('R88', 'Concurrencia Corte/Reapertura: @replace@'),
    ('R89', 'No se ha podido realizar la reapertura'),
    ('R90', 'No se puede suspender el suministro por esencialidad'),
    ('R91', 'No se puede suspender el suministro por trámites judiciales'),
    ('R92', 'Contrato de ATR en suspensión de suministro por motivos técnicos'),
    ('R93', 'Se rechaza por concurrencia con baja por impago/cese de actividad'),
    ('R94', 'No es posible solicitar un cambio/alta/modificación/baja a '
            'fecha fija para una fecha > 30 días naturales'),
    ('R95', 'Existe una solicitud previa de baja ya en campo o '
            'realizada (pendiente de activar) de otra comercializadora.'),
    ('R96', 'Tipo de activación solicita incoherente con el proceso solicitado'),
    ('R97', 'Impago previo'),
    ('R98', 'Código de solicitud de referencia no existe en la distribuidora'),
    ('R99', 'El desistimiento no aplica al proceso subyacente'),
    ('S01', 'Desistimiento solicitado por Persona Jurídica'),
    ('S02', 'Identificador del titular del proceso subyacente no coincide con el titular que pretende desistir'),
    ('S03', 'Desistimiento no necesario, proceso subyacente rechazado'),
    ('S04', 'Rechazo por Desistimiento de proceso subyacente anulable'),
    ('S05', 'Desistimiento sobre un proceso de contratación en curso'),
    ('S06', 'Desistimiento no posible por movimiento de contratación posterior'),
    ('S07', 'Punto de suministro con multicomercializador'),
    ('S08', 'Concurrencia con solicitud de modificación de cambio de titular por traspaso'),
    ('S09', 'Motivo de modificación no válido para el tipo de producto'),
    ('S10', 'No existirá contrato ATR en vigor en la fecha solicitada'),
    ('S11', 'Capacidad superior a la máxima permitida'),
    ('S12', 'El nuevo Caudal Diario debe ser mayor que el actual'),
    ('S13', 'CUPS sujeto a LOPD'),
    ('S14', 'Disponible sin contrato'),
    ('S15', 'Disponible pendiente finalización infraestructura'),
    ('S16', 'Desistimiento fuera de plazo (activación realizada hace más de un año)'),
    ('S17', 'Solo se podrá modificar (i) el tipo de identificador y el identificador o, (ii) nombre y apellidos (razón social)'),
    ('S18', 'Contrato ATR cortado por impago'),
    ('S19', 'No se puede solicitar más de un producto indefinido'),
    ('S20', 'Todos los peajes asociados al CUPS deben estar asociados al mismo grupo'),
    ('S21', 'No se pueden solicitar productos no indefinidos con fecha de activación anterior a la actual. Ni productos diarios con fecha igual a la actual'),
    ('S22', 'La fecha de inicio del producto no se corresponde con el día 1 del mes o trimestre'),
    ('S23', 'Rechazo por cambio de comercializador/baja sobre producto no activado'),
    ('S24', 'Tipo de producto 01 no permitido en nodo productlist'),
    ('S25', 'Telemedida obligatoria'),

]
TAULA_MOTIVO_RECHAZO_OCSUM = TAULA_MOTIVOS_DE_RECHAZO_CNMC
TAULA_MES = [
    ('01', 'Enero'),
    ('02', 'Febrero'),
    ('03', 'Marzo'),
    ('04', 'Abril'),
    ('05', 'Mayo'),
    ('06', 'Junio'),
    ('07', 'Julio'),
    ('08', 'Agosto'),
    ('09', 'Septiembre'),
    ('10', 'Octubre'),
    ('11', 'Noviembre'),
    ('12', 'Diciembre'),
]
TAULA_IDIOMA = [
    ('01', 'Castellano'),
    ('02', 'Català'),
    ('03', 'Galego'),
    ('04', 'Euskera'),
]
TAULA_RESULTADO_INSPECCION = [
    ('01', 'CORRECTO'),
    ('02', 'DEFECTOS NO CRITICOS, MENORES o SECUNDARIOS'),
    ('03', 'AUSENTE'),
    ('04', 'DEFECTOS CRITICOS Y NO DEJA CORTAR'),
    ('05', 'DEFECTOS CRITICOS'),
    ('06', 'NO DEJA PASAR'),
    ('07', 'NO FIRMA INSPECCION'),
    ('08', 'CORRECTO SIN VISITA'),
    ('09', 'SITUACION SINGULAR'),
    ('10', 'CERTIFICADO DE INSTALACIONES EN EDIF.HAB'),
    ('11', 'FINCA UNIFAMILIAR O COMERCIAL UNICA'),
    ('12', 'PROCESO DE INSPECCION EN CURSO'),
    ('13', 'DEFECTOS EN INSTALACIÓN '),
    ('14', 'DESHABITADO'),
]
TAULA_TIPO_DE_INFORMACION_INCIDENCIA = [
    ('002', 'Orden de Trabajo pendiente'),
    ('005', 'Orden de Trabajo creada'),
    ('031', 'Ausente'),
    ('041', 'Programado con el cliente en > 6 días'),
    ('050', 'Concertación de Visita'),
    ('051', 'Concertación anterior anulada. Pendiente concertar'),
    ('060', 'Actualización Fecha Prevista'),
    ('061', 'Sin infraestructura por ausencia de larga duración'),
    ('907', 'Teléfono erróneo/ Ilocalizable'),
    ('909', 'Deficiencia subsanable/ Trabajos pendientes '),
    ('910', 'Se retrasa visita a campo a petición del cliente'),
    ('911', 'Consumidor en campo informa del pago de la deuda'),
    ('912', 'Consumidor en campo informa que no quiere la baja por cese'),
]
TAULA_TIPO_DE_ACTIVACION = [
    ('001', 'Realizada puesta en servicio'),
    ('002', 'No realizada técnicamente en campo'),
]

TAULA_TIPO_MENSAJE = [
    ('A1', 'Envío de Solicitudes'),
    ('A2', 'Respuesta de Acepto/Rechazo de Solicitudes'),
    ('A2S', 'Aviso de Cambio a Comercializador saliente'),
    ('A3', 'Respuesta de Realización de Solicitudes'),
    ('A3S', 'Respuesta de Activación de Cambio a Comercializador saliente'),
    ('A4', 'Respuesta de rechazo tras actuaciones en campo de Solicitudes'),
    ('A4S', 'Notificación de rechazo tras actuaciones en campo a Comercializador saliente'),
    ('A5', 'Petición de Registro de Puntos de Suministro'),
    ('A6', 'Respuesta a Petición de Registro de Puntos de Suministro'),
    ('A7', 'Consulta de lecturas de clientes con consumo 3.4 y superior (fichero)'),
    ('A12', 'Notificación al COM/CC de Comunicaciones Contrato ATR'),
    ('A13', 'Recepción de Solicitud iniciada por la Distribuidora'),
    ('A14', 'Respuesta de COM de Acepto/Rechazo de Solicitudes'),
    ('A15', 'Respuesta de Realización de Solicitudes'),
    ('A15S', 'Respuesta de Realización de Solicitudes a Comercializador saliente'),
    ('A19', 'Notificación al COM/CC de Comunicaciones de Operaciones'),
    ('A20', 'Envío petición datos CUPS disponible'),
    ('A21', 'Extracción respuesta de petición datos CUPS disponible'),
    ('A25', 'Respuesta Estado Intervención/incidencia'),
    ('A26', 'Envío de información adicional reclamación'),
    ('B70', 'Facturación'),
    ('A61', 'Notificación CUPS sin contrato en vigor disponibles para la contratación'),
    ('A80', 'Notificación a COM de Repartos a nivel de CUPS'),
    ('A81', 'Notificación a COM de Repartos a nivel de PCTD'),
    ('A84', 'Notificación a COM de Repartos Mensual a nivel de CUPS'),
    ('A85', 'Notificación a COM de Repartos Mensual a nivel de PCTD'),
    ('A86', 'Notificación a COM del Número de Puntos de Suministro con Reparto Diario por PC y Peaje'),
]


TAULA_ANOMALIA_INSTALACION = [
    ('001', 'FUGA DE GAS'),
    ('002', 'APAR.CIRCUITO ABIERTO BAÑO-DORMITORIO'),
    ('003', 'TUBO FLEXIBLE VISIBLEMENTE DAÑADO'),
    ('004', 'FLEXIBLE NO METALICO CONTACTO P.CAL.HORN'),
    ('005', 'APAR. EN LOCAL <8M3 SIN ORIFICIO SALIDA'),
    ('006', 'DEFICIENCIA EN CONDUCTO EVACUACIÓN PDC.'),
    ('007', 'EXTRACTORES FORZADOS A OTROS COND.DE PDC'),
    ('008', 'INEX.COND.EVAC.EN APARATOS QUE PRECISAN.'),
    ('009', 'AP.TIPO B EN LOCAL <8M3 SIN VENTILACION.'),
    ('010', 'AP.TIPO B EN LOCAL >8M3 SIN VENTILACION.'),
    ('011', 'ESTADO GRAL. INSTAL.DEFECT. ? MAT.INADEC'),
    ('012', 'FLEXIBLE INADEC,DEFECT.O CONTACTO P.CAL.'),
    ('013', 'INCUMP.TRAZADO INST.POR ALT, SOTANOS,ETC'),
    ('014', 'LLAVES AP. SIN CONECT.Y NO CERR.NI TAPON'),
    ('015', 'LOCAL CON VENTILACION INADECUADA.'),
    ('016', 'LOCAL C/VOLUM.INSUF.SI CONSUMO>16KW/H'),
    ('017', 'FALTA SIST.DETECC.Y CORTE GAS S/ 60670-6'),
    ('018', 'REVOCO CONDUC.EVAC.O EXC.CO EN AMBIENTE'),
    ('019', 'COMBUSTION NO HIGIENICA DE LOS APARATOS'),
    ('020', 'INEX.DISP.CTROL.CONTAM.ATMOSFERA AS'),
    ('021', 'CONCENTRACION MODERADA CO AMB. EN LOCAL'),
    ('022', 'INTERF.CAMPANA EXTRACTORA EN FUNC.AP.GAS'),
    ('023', 'FUNC.INCORR.DISP.SEGURIDAD POR EXT.LLAMA'),
    ('024', 'IMPOSIBILIDAD COMPROB.PDC EN AP. TIPO B'),
    ('025', 'FUGA DE GAS'),
    ('026', 'FUGA DE GAS SECUNDARIA'),
    ('027', 'CONJ.REG.INTERIOR ARMARIO NO VENTILADO'),
    ('028', 'VENT.INCORR.REC.CENTRALIZACION CDORES.'),
    ('029', 'ESTADO GRAL.DEFECTUOSO MATERIALES INADE'),
    ('030', 'INCUMP.NORMATIVA TRAZADO ALT, SOT, ETC.'),
    ('031', 'MAL ESTADO CONSERVACION INSTAL.ELECTRICA'),
    ('032', 'INSTALACIONES AJENAS EN RECINTO CDORES.'),
    ('033', 'PUERTA O CERRADURA INCORR.ARMARIO REG.'),
    ('034', 'OTRAS ANOMALIAS'),
    ('035', 'FUNCIONAMIENTO INCORRECTO DISP SEGURIDAD'),
    ('036', 'ESTADO GRAL.DEFECTUOSO MAT.-TRAMOS INAD.'),
    ('037', 'INEXIST.O DIFICIL ACCESO VALVULA GENERAL'),
    ('038', 'ERM SIN TOMA TIERRA O J.DIELEC.'),
    ('039', 'VENTILACION RECINTO ERM INSUF.O INCORR.'),
    ('040', 'UBIC.RECINTO O DISTANCIAS MIN.INCORR.'),
    ('041', 'INEX.DETERIORO O CADUC. EXTINTOR P.SECO'),
    ('042', 'INST.ELECTRICA ERM INCUMPLE NORM.VIGENTE'),
    ('043', 'INEXISTENCIA SEÑALIZACION CORRESPONDIENT'),
    ('044', 'INCUMPL.REGLAM.DISCURRE ALT.TECH.CAM.SOT'),
    ('045', 'FALTA LIBRO MANT.O ACRE.LA REALIZACIÓN'),
    ('046', 'FUGA DE GAS'),
    ('047', 'INSTALACIÓN NO ESTANC(NIVEL FUGA 1y5 l/h'),
    ('048', 'EXISTENCIA DE GRIETAS, APRECIABLES VISUALMENTE, EN LAS '
            'PAREDES INTERIORES DEL RECINTO DE CONTADORES, REGULADORES O '
            'COLECTORES DE LLAVES, QUE POSIBILITEN CANALIZAR POTENCIALES '
            'FUGAS DE GAS A LA ESTRUCTURA DEL EDIFICIO [CS-9]'),
    ('053', 'AUSENCIA CERTIFICADO REVISIÓN'),
    ('064', 'NO INSPECCIONADO OBRAS'),
    ('065', 'NO INSPECCIONADO LOCAL PRECINTADO'),
    ('066', 'NO INSPECCIONADO BAJA GAS'),
    ('067', 'NO INSPECCIONADO INSTAL. PRECINTADA'),
    ('068', 'NO INSPECCIONADO OTRAS'),
    ('074', 'LOCAL CON APARATOS=>25,8TH S VENTILACION'),
    ('075', 'CONDUCCIONES DE OTROS SERVICIOS, DE ACUERDO A LO INDICADO EN EL '
            'APARTADO 4.3 DE LA NORMA UNE 60670-4:2014 EN CONTACTO CON '
            'CONDUCCIONES DE GAS [ISA-8]'),
    ('079', 'INCORRECTA REGULACIÓN DE LOS MÍNIMOS DE LOS '
            'QUEMADORES SUPERIORES DE COCINAS, ENCIMERAS ENCASTRABLES U '
            'OTROS APARATOS DE COCCIÓN [AS-7]'),
    ('080', 'INTERFERENCIA GRAVE DEL EXTRACTOR MECÁNICO O LA '
            'CAMPANA EXTRACTORA EN EL FUNCIONAMIENTO DE UN APARATO DE '
            'GAS [AP-4]'),
    ('081', 'INTERFERENCIA MODERADA DE LA CAMPANA EXTRACTORA EN EL '
            'FUNCIONAMIENTO DE UN APARATO DE GAS [AS-2]'),
    ('082', 'COMBUSTIÓN DEFICIENTE DE APARATOS DE GAS [AS-6]'),
    ('083', 'INCORRECTO FUNCIONAMIENTO DE LOS QUEMADORES DE LOS APARATOS DE '
            'COCCIÓN [AS-8]'),
    ('R1', 'FUGA DE GAS'),
    ('R10', 'CARENCIA DE VAINAS Y/O PROTEC EN TUBERÍA'),
    ('R11', 'TUB. VISTS. SIN ELEMTOS DE SUJE. ADECU'),
    ('R12', 'TUB-EMPOT-EN-PARD-CON-HUECS-O-MUROS-RES.'),
    ('R13', 'TUB-ENTERRDS-EN SUELOS DE VIVDAS O LOCAL'),
    ('R14', 'INST-SOTA-SEMIST. GARJ. APARC. '),
    ('R15', 'INEX-MALA-UBIC-FUNCTO. INCO. LLAVE CORTE'),
    ('R16', 'INEXISTENCIA DE TOMAS DE PRES NECESARIAS'),
    ('R17', 'APARJE-ELEC-REC-CONJ-REG. SIN MED. ADEC.'),
    ('R18', 'CON-RG-CAL-Y-AGU-CAL-MIS-RC-S.MED. ADC.'),
    ('R19', 'CONJ. REG. EN RECINTO INSUF. VENTILADO'),
    ('R2', 'APARATO CIR. ABIERTO EN LOCAL INAPROP.'),
    ('R20', 'UBICACIÓN EN ZONA INUNDABLE'),
    ('R21', 'CONJ-REG-Z-COMUN-SIN-PROT-ARM-CERRDO. V.'),
    ('R22', 'NO VAL. SEG. EXC. PRE. MOP > 150 mbar'),
    ('R23', 'NO-SEG-MIN-IND-NO-EXI-MSMA-SEG-EN-I-COM.'),
    ('R24', 'CONJ-REG-NO-DISP-PLAC-TARJ-O-ADHES-CORR.'),
    ('R25', 'AUSENCIA PRECINTO QUE IMPIDA MANIPUL.'),
    ('R26', 'VENTILACIÓN INCORRECTA DEL RECINTO'),
    ('R27', 'INSTALACIÓN CONTADOR INADECUADA'),
    ('R28', 'DISTCIA-INSUF-ENTRE-CONT-Y-APRTO-DE-GAS'),
    ('R29', 'APJE-MAQ-Y/O-CON-ELEC-DIST-INSUF-CON-GAS'),
    ('R3', 'VENTIL. AIRE LOCAL INCORR. O INEXIST.'),
    ('R30', 'EXIST-RCTO-MAQ-CUAD-CONT-MOT-TRANSF-ELEC'),
    ('R31', 'INST-ELEC. NO ACUER. CON NORMA UNE 60670'),
    ('R32', 'APAR. GAS QUE PRECIS. COND. EVAC. CARECE'),
    ('R33', 'AP. NO PRE. COND. EV. '),
    ('R34', 'CONEX. NO PERM. FLEX. NO HOM. CAD. ETC.'),
    ('R35', 'AP-FI-SIN CONEX RG-O TUB. FLE. Aº INOX '),
    ('R36', 'TUBO FLEXIBLE VISIBLEMENTE DAÑADO'),
    ('R37', 'BOQ-NO-NORM TUBO FLEX. CTO HORNO'),
    ('R38', 'DEFIC-APREC-CONDUC-EVAC-PRODUCT-COMBUST.'),
    ('R39', 'NO-DISPOS-SEG-EN-APAR-REGL-DEBEN LLEVAR'),
    ('R4', 'APAR. UBIC. LOC. VOLUMEN. INF. MINIMO'),
    ('R40', 'FUGA DE GAS'),
    ('R41', 'MAT. NO AUT. EN TUB. '),
    ('R42', 'CONTACTO TUBER. GAS CON OTRAS CONDUCCION'),
    ('R43', 'CARENCIA DE VAINAS Y/O PROTEC EN TUBERÍA'),
    ('R44', 'TUB. VISTS. SIN ELEMTOS DE SUJE. ADECU'),
    ('R45', 'TUB-EMPOT-EN-PARD-CON-HUECS-O-MUROS-RES.'),
    ('R46', 'TUB-ENTERRDS-EN SUELOS DE VIVDAS O LOCAL'),
    ('R47', 'INST-SOTA-SEMIST. GARJ. APARC. '),
    ('R48', 'INEX-MALA-UBIC-FUNCTO. INCO. LLAVE CORTE'),
    ('R49', 'INEXISTENCIA DE TOMAS DE PRES NECESARIAS'),
    ('R5', 'INEXIST. VENT. RAP. LOCAL.  REQUIERA'),
    ('R50', 'APARJE-ELEC-REC-CONJ-REG. SIN MED. ADEC.'),
    ('R51', 'CON-RG-CAL-Y-AGU-CAL-MIS-RC-S.MED. ADC.'),
    ('R52', 'CONJ. REG. EN RECINTO INSUF. VENTILADO'),
    ('R53', 'UBICACIÓN EN ZONA INUNDABLE'),
    ('R54', 'CONJ-REG-Z-COMUN-SIN-PROT-ARM-CERRDO. V.'),
    ('R55', 'NO VAL. SEG. EXC. PRE. MOP > 150 mbar'),
    ('R56', 'NO-SEG-MIN-IND-NO-EXI-MSMA-SEG-EN-I-COM.'),
    ('R57', 'INEX-LLAVE-CORTE-Y/O-TOMA-PRES-ANT-REG.'),
    ('R58', 'CONJ-REG-NO-DISP-PLAC-TARJ-O-ADHES-CORR.'),
    ('R59', 'AUSENCIA PRECINTO QUE IMPIDA MANIPUL.'),
    ('R6', 'EXTRACT. MEC. PROV, DEFIC, EVACUACIÓN'),
    ('R60', 'VENTILACIÓN INCORRECTA DEL RECINTO'),
    ('R61', 'P-ACCE-REC-NO-CERRADA-O-NO-NORM-EMP-DIST'),
    ('R62', 'APJE-MAQ-Y/O-CON-ELEC-DIST-INSUF-CON-GAS'),
    ('R63', 'EXIST-RCTO-MAQ-CUAD-CONT-MOT-TRANSF-ELEC'),
    ('R64', 'INST-ELEC. NO ACUER. CON NORMA UNE 60670'),
    ('R65', 'ILUMINACIÓN ELECTRICA NO REGLAMENTARIA'),
    ('R66', 'PUERTA DE ACCESO INADECUADA'),
    ('R67', 'CARENCIA DE SUPERFICIE NO RESISTENTE'),
    ('R68', 'INCUMP. EMPLAZ. ACCESOS O PROTEC. FUEGO'),
    ('R69', 'CARENCIA DE IDENTIFICACIÓN'),
    ('R7', 'PATIO DE VENTILACIÓN INADECUADO'),
    ('R70', 'DEFECTOS DE CARÁCTER DOCUMENTAL'),
    ('R71', 'OTRAS INADECUACIONES GRAVES'),
    ('R8', 'MAT. NO AUT. EN TUB. '),
    ('R9', 'CONTACTO TUBER. GAS CON OTRAS CONDUCCION'),
    ('A01', 'M - Fuga De Gas'),
    ('A02', 'M - Apar.Circuito Abierto BañO-Dormitorio'),
    ('A03', 'M - Tubo Flexible Visiblemente DañAdo'),
    ('A04', 'M - Flexible No Metalico Contacto P.Cal.Horn'),
    ('A05', 'M - Apar. En Local <8m3 Sin Orificio Salida'),
    ('A06', 'M - Deficiencia En Conducto Evacuación Pdc.'),
    ('A07', 'M - Extractores Forzados A Otros Cond.De Pdc'),
    ('A08', 'M - Inex.Cond.Evac.En Aparatos Que Precisan.'),
    ('A09', 'M - Ap.Tipo B En Local <8m3 Sin Ventilacion.'),
    ('A10', 'N - Ap.Tipo B En Local >8m3 Sin Ventilacion.'),
    ('A11', 'N - Estado Gral. Instal.Defect. ó Mat.Inadec'),
    ('A12', 'N - Flexible Inadec,Defect.O Contacto P.Cal.'),
    ('A13', 'N - Incump.Trazado Inst.Por Alt, Sotanos,Etc'),
    ('A14', 'N - Llaves Ap. Sin Conect.Y No Cerr.Ni Tapon'),
    ('A15', 'N - Local Con Ventilacion Inadecuada.'),
    ('A16', 'N - Local C/Volum.Insuf.Si Consumo>16kw/H'),
    ('A17', 'N - Falta Sist.Detecc.Y Corte Gas S/ 60670-6'),
    ('A18', 'M - Revoco Conduc.Evac.O Exc.Co En Ambiente'),
    ('A19', 'M - Combustion No Higienica De Los Aparatos'),
    ('A20', 'M - Inex.Disp.Ctrol.Contam.Atmosfera As'),
    ('A21', 'N - Concentracion Moderada Co Amb. En Local'),
    ('A22', 'N - Interf.Campana Extractora En Func.Ap.Gas'),
    ('A23', 'N - Func.Incorr.Disp.Seguridad Por Ext.Llama'),
    ('A24', 'N - Imposibilidad Comprob.Pdc En Ap. Tipo B'),
    ('A36', 'N - Estado Gral.Defectuoso Mat.-Tramos Inad.'),
    ('A37', 'N - Inexist.O Dificil Acceso Valvula General'),
    ('A38', 'N - Erm Sin Toma Tierra O J.Dielec.'),
    ('A39', 'N - Ventilacion Recinto Erm Insuf.O Incorr.'),
    ('A40', 'N - Ubic.Recinto O Distancias Min.Incorr.'),
    ('A41', 'N - Inex.Deterioro O Caduc. Extintor P.Seco'),
    ('A42', 'N - Inst.Electrica Erm Incumple Norm.Vigente'),
    ('A43', 'N - Inexistencia Señalizacion Correspondient'),
    ('A44', 'N - Incumpl.Reglam.Discurre Alt.Tech.Cam.Sot'),
    ('A45', 'FALTA LIBRO MANTO ACREDITE '),
    ('A46', 'M - Fuga De Gas'),
    ('A47', 'N - INSTALACIóN NO ESTANC(NIVEL FUGA 1y5 L/H'),
    ('A48', 'Existencia de grietas, apreciables visualmente, en las '
            'paredes interiores del recinto de contadores, reguladores o '
            'colectores de llaves, que posibiliten canalizar potenciales '
            'fugas de gas a la estructura del edificio [CS-9]'),
    ('A51', 'Falta orificio entrada aire'),
    ('A52', 'Entrada aire insuficiente,obstruído, etc'),
    ('A53', 'Entrada orificio entrada gases'),
    ('A54', 'Salida gases insuficiente, obstruída,etc'),
    ('A55', 'Local con volumen insuficiente'),
    ('A56', 'Ausencia ventilación rápida, necesaria'),
    ('A57', 'Distancia inadecuada caldera-cocina'),
    ('A60', 'Observaciones Acta Inspección'),
    ('A64', 'S - No Inspeccionado Obras'),
    ('A65', 'S - No Inspeccionado Local Precintado'),
    ('A66', 'S - No Inspeccionado Baja Gas'),
    ('A67', 'S - No Inspeccionado Instal. Precintada'),
    ('A68', 'S - No Inspeccionado Otras'),
    ('A69', 'Fuga de gas (>70KW)'),
    ('A70', 'Conservación o material inadecuado'),
    ('A71', 'Inexistencia válvula general del usuario'),
    ('A72', 'Incump. condicions reglamentarias > 70KW'),
    ('A73', 'Falta Certificado Mantto. y conserv > 70KW'),
    ('A74', 'Fuga de gas secundaria > 70KW'),
    ('A75', 'Conducciones de otros servicios, de acuerdo a lo indicado en el '
            'apartado 4.3 de la Norma UNE 60670-4:2014 en contacto con '
            'conducciones de gas [ISa-8]'),
    ('A79', 'Incorrecta regulación de los mínimos de '
            'los quemadores superiores de cocinas, encimeras encastrables u '
            'otros aparatos de cocción [AS-7]'),
    ('A80', 'Interferencia grave del extractor mecánico o la '
            'campana extractora en el funcionamiento de un aparato de '
            'gas [AP-4]'),
    ('A81', 'Interferencia moderada de la campana extractora en el '
            'funcionamiento de un aparato de gas [AS-2]'),
    ('A82', 'Combustión deficiente de aparatos de gas [AS-6]'),
    ('A83', 'Incorrecto funcionamiento de los quemadores de '
            'los aparatos de cocción [AS-8]'),
    ('D11', 'Fuga de gas '),
    ('D12', 'Fuga ligera de gas '),
    ('D13', 'Materiales tuberías, etc no autorizados '),
    ('D14', 'Llave corte general malas condiciones '),
    ('D15', 'Afección otras canalizaciones o instalac '),
    ('D16', 'Condiciones no reglamentarias cámaras '),
    ('D17', 'Defectuoso regulador o seguridad mínima '),
    ('D18', 'Toma aparato sin obturar '),
    ('D21', 'Flexible visiblemente dañado o agrietado'),
    ('D22', 'Flexible no adecuado '),
    ('D23', 'Flexible caducado '),
    ('D24', 'Flexible longitud inadecuada '),
    ('D25', 'Boquillas, abrazaderas o conex inadecuad '),
    ('D26', 'Flexible sometido a calor excesivo '),
    ('D31', 'Aparato a gas abierto en dormitorio, etc'),
    ('D32', 'CO amb>30 ppm + CO comb>1.000 ppm '),
    ('D33', 'Inexistencia/Incorrectos seguridad llama'),
    ('D34', 'CO amb entre 15-30/CO comb:400-1000 '),
    ('D35', 'No enclavamiento campana extractora '),
    ('D36', 'Imposibilidad comprobación emisiones '),
    ('D41', 'Revoco de gases al local '),
    ('D42', 'No conducto, siendo necesario o deficien'),
    ('D43', 'Campana o extractor a conducto evacuación'),
    ('D44', 'Conducto evacuación no estanco afectando '),
    ('D51', 'Falta orificio entrada aire '),
    ('D52', 'Entrada aire insuficiente, obstruído, etc '),
    ('D53', 'Falta orificio salida gases '),
    ('D54', 'Salida gases insuficiente, obstruída,etc '),
    ('D55', 'Local con volumen insuficiente '),
    ('D56', 'Ausencia ventilación rápida, necesaria '),
    ('D57', 'Distancia inadecuada caldera-cocina '),
    ('D60', 'Observaciones Acta Inspección '),
    ('D81', 'Estación de Regulación y/o Medida sin toma de tierra y/o '
            'juntas dieléctricas'),
    ('D82', 'Ventilación del recinto de ERM, insuficiente o incorrecta'),
    ('D83', 'Ubicación del recinto de ERM y/o distancias mínimas de '
            'seguridad incorrectas'),
    ('D84', 'Inexistencia, deterioro o caducidad de la revisión del '
            'extintor de polvo seco'),
    ('D85', 'La instalación eléctrica incumple la normativa vigente'),
    ('D86', 'Inexistencia de la señalización correspondiente'),
    ('B01', 'TUBERIAS Y ACCESORIOS'),
    ('B02', 'FLEXIBLE'),
    ('B03', 'APARATOS'),
    ('B04', 'EVACUACION DE GASES'),
    ('B05', 'LOCAL'),
    ('B10', 'TUBERIAS Y ACCESORIOS'),
    ('B11', 'G-Fuga de gas (caud > 5 L/ h)'),
    ('B12', 'Fuga ligera gas (caud entre 1-5 L/h)'),
    ('B13', 'Tuberías/soportes/uniones no aut o defic'),
    ('B14', 'Llave corte malas condic (gral, apar,..)'),
    ('B15', 'Contacto otras instalaci o canalizac'),
    ('B16', 'Cond no reglam en falsos techos, muros,.'),
    ('B17', 'Func defect regulador válvulas seguridad'),
    ('B18', 'Toma aparato sin obturar'),
    ('B19', 'Diseño / trazado tuberías'),
    ('B21', 'G-Flexibe visiblem dañado o '),
    ('B22', 'Flexible no adecuado(no norma UNE...)'),
    ('B23', 'Flexible caducado (cunado tenga fecha)'),
    ('B24', 'Long flexible inadecuada (corto o largo)'),
    ('B25', 'Boquillas, abrazaderas o conex inadecuad'),
    ('B26', 'Flexible sometido a calor excesivo'),
    ('B27', 'Flexible'),
    ('B30', 'APARATOS'),
    ('B31', 'G-Aparato circ abierto '),
    ('B32', 'G-Comb peligr CO ppm loc >30 y apa >1000'),
    ('B33', 'G-Func incorrec o inex detec falta llama'),
    ('B34', 'Mala CombCO ppm loc 15-30 apa 400-1000'),
    ('B35', 'Falta o no funciona encl campana extract'),
    ('B36', 'Imposib comprobac emisiones aparato'),
    ('B37', 'No realización mantenimiento aparato'),
    ('B38', 'inexistencia de disp.control atmosfera'),
    ('B39', 'NO HECHOS/DOCUMENTADOS CONTROLES DETEC GAS'),
    ('B40', 'EVACUACION DE GASES'),
    ('B41', 'G-Revoco de gases al local'),
    ('B42', 'G-No exist conduc '),
    ('B43', 'G-Extract conect a conduc apar tiro natu'),
    ('B44', 'NU-Conducto no estanco con afecc al local'),
    ('B45', 'NU-Aparato tiro forzado conec a cond no ade'),
    ('B46', 'NU-No cumple distancias'),
    ('B50', 'Local / Ventilaciones'),
    ('B51', 'NU-Falta orificio entrada aire'),
    ('B52', 'NU-Orif entrada aire insuf, obstruible/do'),
    ('B53', 'NU-Falta orificio para salida gases comb'),
    ('B54', 'Local ventil. incorre. Rejill.o cond PDC'),
    ('B55', 'Local con volumen insuficiente'),
    ('B56', 'Ausencia ventilación rápida (siendo nec)'),
    ('B57', 'Distancia inadecuada entre cocina-calder'),
    ('B58', 'Falla sistema detección y corte gas'),
    ('B60', 'Contadores'),
    ('B61', 'Fuga de gas '),
    ('B62', 'Instalación no estanca (entre 1 l/h y 5 l/h) '),
    ('B63', 'Estado Gral, Mat Uniones Diseño'),
    ('B70', 'Regulación'),
    ('B71', 'Inexistencia o accesibili. de la válvula'),
    ('B72', 'ERM sin toma d tierra y/o junta dieléct'),
    ('B73', 'Ventilación ERM insuficiente o incorrecta'),
    ('B74', 'Ubicación y/o distancias de seg. incorrectas '),
    ('B75', 'Inexistencia,deterioro o caduc extintor'),
    ('B76', 'Instalación eléctrica '),
    ('B77', 'Inexistencia de la señalización corresp.'),
    ('B90', 'Otros'),
    ('B95', 'Local deshabitado'),
    ('B96', 'IRI sin aparatos'),
    ('B97', 'Avería en aparato'),
    ('B99', 'Falta de los justificantes'),
    ('E00', 'Aparato a gas de tipo B que carece de c.e.p.c. o que '
            'disponiendo del mismo está ubicado en un local de V < 8 m3 que '
            'carece de orificio de ventilación [I-P-8]'),
    ('E01', 'La instalación tiene las siguientes '
            'anomalías principales (P< 70 kW) [IPa]'),
    ('E02', 'La instalación tiene las siguientes '
            'anomalías principales (P> 70 kW) [IPb]'),
    ('E03', 'Los aparatos tienen las siguientes anomalías principales [AP]'),
    ('E04', 'La instalación tiene las siguientes '
            'anomalías secundarias (P< 70 kW) [ISa]'),
    ('E05', 'La instalación tiene las siguientes '
            'anomalías secundarias (P> 70 kW) [ISb]'),
    ('E06', 'Los aparatos tienen las siguientes anomalías secundarias[AS]'),
    ('E07', 'Anomalía Principal Motivo Instalador'),
    ('E08', 'Anomalía Secundaria Motivo Instalador'),
    ('C10', 'Tuberías y accesorios'),
    ('C11', 'G-Fuga gas tram enterrado- interior edif'),
    ('C12', 'G-Fuga gas tramo aéreo ext (Q > 5 L/h)'),
    ('C13', 'Fuga gas tramo aéreo ext no grave'),
    ('C14', 'Mater tuberías,sopor o uniones no autori'),
    ('C15', 'Afección otras canaliz o instalaciones'),
    ('C16', 'Condic no reglam al atrav falsos techos'),
    ('C20', 'Regulación/ estabilizador/ seguridades'),
    ('C21', 'Ubicac en interior edif o armario no est'),
    ('C24', 'Sin protección adecuada'),
    ('C30', 'Contadores'),
    ('C31', 'Identificación incorrecta de usuarios'),
    ('C32', 'Ventilación inexistente o inadecuada'),
    ('C33', 'Instalación eléctrica deficiente'),
    ('C34', 'Existencia de instalaciones ajenas'),
    ('C35', 'Puerta o cerradura/ accesos incorrecta'),
    ('C36', 'Falta estanq.grietas techo centralizac'),
    ('C40', 'Cuarto de máquina'),
    ('C41', 'G-Incum requis ventilac o evac pr comb'),
    ('C42', 'Puerta o cerradura incorrecta cuadro m'),
    ('C43', 'Rótulos inexistentes'),
    ('C44', 'Falta libro mto o no consta última rev'),
    ('C45', 'Falta registro comprob.sist deteccion'),
    ('C50', 'Otros irc'),
    ('C55', 'Patios de ventilación (desbordamiento)'),
    ('B20', 'Flexible'),
    ('B98', 'Documentación / Otros'),
    ('C60', 'Tuberías y Accesorios en Instalaciones Industriales'),
    ('C70', 'Regulación en Instalaciones Industriales'),
    ('C98', 'Documentación / Otros'),
    ('D10', 'Tuberías y Accesorios'),
    ('D20', 'Flexible'),
    ('D30', 'Aparatos'),
    ('D40', 'Evacuación de Gases'),
    ('D50', 'Local / Ventilaciones'),
    ('D70', 'Regulación en Instalaciones Industriales'),
    ('D98', 'Documentación / Otros'),
]

TAULA_SI_NO = [
    ('S', 'Sí'),
    ('N', 'No'),
]
TAULA_INDICATIVO_SI = TAULA_SI_NO

TAULA_MODELO_FECHA_EFECTO = [
    ('01', 'Primer valor posible estimado (1/11/21)'),
    ('02', 'A ciclo de lectura'),
    ('03', 'Fecha de efecto estimada concreta (1/11/21)'),
    ('04', 'Fecha de efecto estimada concreta'),
    ('05', 'Cuanto antes'),
]
TAULA_MODELO_FECHA_EFECTO_PREVISTA = [
    ('01', 'Primer valor posible estimado (1/11/21)'),
    ('02', 'Primer valor posible de lectura (mensual/bimestral)'),
    ('03', 'Fecha de efecto estimada concreta (1/11/21)'),
    ('04', 'Fecha de efecto estimada concreta'),
    ('11', 'Fecha Fija por concurrencia con solicitud de Baja 01'),
    ('12', 'Fecha Fija por concurrencia con solicitud de Baja 02'),
    ('13', 'Fecha Fija por concurrencia con solicitud de Baja 04'),
    ('14', 'Fecha Fija por concurrencia con solicitud de Baja 05'),
    ('15', 'Fecha Fija por actuación de reapertura del PS '),
    ('16', 'Fecha fija por incumplimiento del plazo mínimo de preaviso'),
    ('17', 'Fecha Fija fin Infraestructura / Transformación'),
    ('18', 'Fecha fija por concurrencia con Traspaso al CUR'),
]

TAULA_TIPO_PRODUCTO = [
    ('01', 'Indefinido'),
    ('02', 'Anual'),
    ('03', 'Trimestral'),
    ('04', 'Mensual'),
    ('05', 'Diario'),
    ('06', 'Intradiario'),
]

TAULA_TIPO_SOLICITUD_PRODUCTO = [
    ('01', 'Nuevo producto consecutivo al existente manteniendo condiciones'),
    ('02', 'Nuevo producto consecutivo al existente modificando condiciones'),
    ('03', 'Nuevo producto'),
]

TAULA_TIPO_PEAJE = [
    ('11', '1.1 (11) - Presión > 60 bares y Consumo <= 200 GWh/año'),
    ('12', '1.2 (12) - Presión > de 60 bares y  200 GWh/año < Consumo <= 1000 GWh/año'),
    ('13', '1.3 (13) - Presión > 60 bares y  Consumo > 1000 GWh/año'),
    ('21', '2.1 (21) - 4 bares < Presión <= 60 bares y Consumo <= 500 MWh/año'),
    ('22', '2.2 (22) - 4 bares < Presión <= 60 bares y 500 MWh/año < Consumo <= 5000 MWh/año'),
    ('23', '2.3 (23) - 4 bares < Presión <= 60 bares y 5000 MWh/año < Consumo <= 30000 MWh/año'),
    ('24', '2.4 (24) - 4 bares < Presión <= 60 bares y 30000 MWh/año < Consumo <= 100000 MWh/año'),
    ('25', '2.5 (25) - 4 bares < Presión <= 60 bares y  100000 MWh/año < Consumo <= 500000 MWh/año'),
    ('26', '2.6 (26) - 4 bares < Presión <= 60 bares y  500000 MWh/año < Consumo'),
    ('1B', '2.1 bis (1B) - Presión <= 4 bares y  Consumo <= 500 MWh/año'),
    ('2B', '2.2 bis (2B) - Presión <= 4 bares y  500 MWh/año < Consumo <= 5000 MWh/año'),
    ('3B', '2.3 bis (3B) - Presión <= 4 bares y  5000 MWh/año < Consumo <= 30000 MWh/año'),
    ('4B', '2.4 bis (4B) - Presión <= 4 bares y  30000 MWh/año < Consumo <= 100000 MWh/año'),
    ('5B', '2.5 bis (5B) - Presión <= 4 bares y  100000 MWh/año < Consumo <= 500000 MWh/año'),
    ('6B', '2.6 bis (6B) - Presión <= 4 bares y  500000 MWh/año < Consumo'),
    ('31', '3.1 (31) - Presión <= 4 bares y  Consumo <= 5000 kWh/año'),
    ('32', '3.2 (32) - Presión <= 4 bares y  5000 kWh/año < Consumo <= 50000 kWh/año'),
    ('33', '3.3 (33) - Presión <= 4 bares y  50000 kWh/año < Consumo <= 100000 kWh/año'),
    ('34', '3.4 (34) - Presión <= 4 bares y 100000 Kwh/año < Consumo <= 100 Gwh/año'),
    ('35', '3.5 (35) - Presión <= 4 bares y 100 GWh/año < Consumo'),
    ('41', '4.1 (41) - Presión > 60 bares y consumo <= 200 GWh/año'),
    ('42', '4.2 (42) - Presión > 60 bares y  200 GWh/año < Consumo <=1.000 GWh/año'),
    ('43', '4.3 (43) - Presión > 60 bares y consumo > 1.000  GWh/año  '),
    ('44', '4.4 (44) - 4 bares < Presión <= 60 bares y 10 GWh/año < Consumo <= 30 GWh/año'),
    ('45', '4.5 (45) - 4 bares < Presión <= 60 bares y 30 GWh/año < Consumo <= 100 GWh/año'),
    ('46', '4.6 (46) - 4 bares < Presión <= 60 bares y 100 GWh/año < Consumo <= 500 GWh/año'),
    ('47', '4.7 (47) - 4 bares < Presión <= 60 bares y Consumo > 500 GWh/año'),
    ('A1', 'A1 (A1) - Presión > 60 bares y Consumo <= 200 GWh/año'),
    ('A2', 'A2 (A2) - Presión > de 60 bares y 200 GWh/año < Consumo <= 1000 GWh/año '),
    ('A3', 'A3 (A3) - Presión > 60 bares y Consumo > 1000 GWh/año '),
    ('B1', 'B1 (B1) - 4 bares < Presión <= 60 bares y 100000 MWh/año < Consumo <= 500000 MWh/año'),
    ('B2', 'B2 (B2) - 4 bares < Presión <= 60 bares y 500000 MWh/año < Consumo '),
    ('C1', 'C1 (C1) - Centrales de generación eléctrica (grupo 4)  con  4 bar < Presión  <= 60 bar'),
    ('C2', 'C2 (C2) - Centrales de generación eléctrica (grupo 4),  Presión >  60 bar'),
    ('D1', 'D1 (D1) - Resto clientes (grupo 4), 4  bar < Presión  <= 60 bar'),
    ('D2', 'D2 (D2) - Resto clientes (grupo 4), Presión >  60 bar'),
    ('M1', 'M1 (M1) - Materia Prima 1'),
    ('M2', 'M2 (M2) - Materia Prima 2'),
    ('R1', 'RL01 (R1) - Consumo igual o inferior a 5.000 kWh/año'),
    ('R2', 'RL02 (R2) - Consumo superior a 5.000 de kWh/año e inferior o igual a 15.000 de kWh/año'),
    ('R3', 'RL03 (R3) - Consumo superior a 15.000 de kWh/año e inferior o igual a 50.000 de kWh/año'),
    ('R4', 'RL04 (R4) - Consumo superior a 50.000 de kWh/año e inferior o igual a 300.000 de kWh/año'),
    ('R8', 'RL08 (R8) - Consumo superior a 15.000.000 de kWh/año e inferior o igual a 50.000.000 de kWh/año'),
    ('R9', 'RL09 (R9) - Consumo superior a 50.000.000 de kWh/año e inferior o igual a 150.000.000 de kWh/año.'),
    ('L0', 'RL10 (L0) - Consumo superior a 150.000.000 de kWh/año e inferior o igual a 500.000.000 de kWh/año.'),
    ('L1', 'RL11 (L1) - Consumo superior a 500.000.000 de kWh/año.'),
    ('A5', 'RLTA5 (A5) - Presión mayor a 4 Bar. Consumo superior a 300.000 de kWh/año e inferior o igual a 1.500.000 de kWh/año'),
    ('A6', 'RLTA6 (A6) - Presión mayor a 4 Bar. Consumo superior a 1.500.000 de kWh/año e inferior o igual a 5.000.000 de kWh/año'),
    ('A7', 'RLTA7 (A7) - Presión mayor a 4 Bar. Consumo superior a 5.000.000 de kWh/año e inferior o igual a 15.000.000 de kWh/año'),
    ('B5', 'RLTB5 (B5) - Presión menor o igual a 4 Bar. Consumo superior a 300.000 de kWh/año e inferior o igual a 1.500.000 de kWh/año'),
    ('B6', 'RLTB6 (B6) - Presión menor o igual a 4 Bar. Consumo superior a 1.500.000 de kWh/año e inferior o igual a 5.000.000 de kWh/año'),
    ('B7', 'RLTB7 (B7) - Presión menor o igual a 4 Bar. Consumo superior a 5.000.000 de kWh/año e inferior o igual a 15.000.000 de kWh/año.'),
    ('S1', 'RLPS1 (S1) - Planta Satélite. Consumo igual o inferior a 5.000 kWh/año'),
    ('S2', 'RLPS2 (S2) - Planta Satélite. Consumo superior a 5.000 de kWh/año e inferior o igual a 15.000 de kWh/año'),
    ('S3', 'RLPS3 (S3) - Planta Satélite. Consumo superior a 15.000 de kWh/año e inferior o igual a 50.000 de kWh/año'),
    ('S4', 'RLPS4 (S4) - Planta Satélite. Consumo superior a 50.000 de kWh/año e inferior o igual a 300.000 de kWh/año'),
    ('S5', 'RLPS5 (S5) - Planta Satélite. Consumo superior a 300.000 de kWh/año e inferior o igual a 1.500.000 de kWh/año'),
    ('S6', 'RLPS6 (S6) - Planta Satélite. Consumo superior a 1.500.000 de kWh/año e inferior o igual a 5.000.000 de kWh/año'),
    ('S7', 'RLPS7 (S7) - Planta Satélite. Consumo superior a 5.000.000 de kWh/año e inferior o igual a 15.000.000 de kWh/año'),
    ('S8', 'RLPS8 (S8) - Planta Satélite. Consumo superior a 15.000.000 de kWh/año e inferior o igual a 50.000.000 de kWh/año'),
    ('99', '99 (99) - Factura agregada D-C'),
]

TAULA_TIPOS_DE_USO_DEL_GAS = [
    ('01', 'Combustible'),
    ('02', 'Carburantes'),
    ('03', 'Motores Estacionarios'),
    ('04', 'Depósitos Fiscales'),
]
TAULA_TIPO_CORRECTOR = [
    ('01', 'PT'),
    ('02', 'PTZ'),
    ('03', 'Unidad Remota '),
    ('04', 'No aplica'),
    ('05', 'Energía'),
    ('06', 'Unidad Remota PTZ'),
]
TAULA_PROPIEDAD_CONTADOR_CORRECTOR = [
    ('04', 'PROPIO-CONTADO'),
    ('06', 'PROPIO-PLAZOS-6'),
    ('01', 'DEPOSITO'),
    ('02', 'ALQUILER'),
    ('11', 'SUSTITUCION'),
    ('12', 'NUEVO'),
    ('08', 'PROPIO-PLAZOS-12'),
    ('10', 'PROPIO'),
]
TAULA_PROPIEDAD_CONTADOR = TAULA_PROPIEDAD_CONTADOR_CORRECTOR

TAULA_PRESION_COMUNITARIA = [
    ('MP', 'ENTRE 0,4 Y BARS MAX. '),
    ('MPA', 'MEDIA PRESION A '),
    ('MPB', 'MEDIA PRESION B '),
    ('B5', 'HASTA 500 MM. C.A. '),
    ('BB', 'PRESION MAX. HASTA 270MMM '),
    ('AP', 'MAS 4 BARS PRES. MAX '),
    ('A12', 'ALTA PRESION 12 BAR '),
    ('A16', 'ALTA PRESION 16 BAR '),
    ('BC', 'PRESIONMAX. HASTA 270MM. C.A. CONREGU'),
    ('MAB', 'MPA DISE¦O MPB '),
    ('MB', 'DE 0,4 A 4 BARS MAX. '),
    ('MA', 'HASTA 1000 MM. C.A. '),
    ('BP', 'BAJA PRESION '),
    ('BV', 'PRESIONMAX. HASTA 270MM. C.A. CONVALV'),
]
TAULA_TIPO_LECTURA = [
    ('0', 'Estimada'),
    ('1', 'Real'),
    ('2', 'Facilitada por cliente'),
]
TAULA_MOTIVO_BAJA = [
    ('01', 'A petición del cliente por cese de su actividad'),
    ('02', 'A solicitud del comercializador por impago del cliente'),
    ('04', 'A solicitud del comercializador por problemas de '
           'seguridad derivados de inspección'),
    ('05', 'A solicitud del comercializador por fin de contrato de energía'),
    ('09', 'Baja de producto indefinido para gestión solo con productos temporales'),

]
TAULA_MOTIVO_MODIFICACION = [
    ('01', 'Cambio de Titular'),
    ('04', 'Correccion de Datos del Cliente'),
    ('09', 'Cambio Código CAE'),
    ('10', 'Cambio de dirección del titular'),
    ('11', 'Cambio de Peaje'),
    ('12', 'Cambio de Titular y Peaje'),
    ('13', 'Modificación de Capacidad'),
    ('14', 'Cambio de Titular y Modificación de Capacidad'),
    ('15', 'Cambio de Peaje y Modificación de Capacidad'),
    ('16', 'Cambio de Titular, Peaje y Modificación de Capacidad'),
    ('17', 'Cambio de Titular y Dirección de Titular'),
    ('18', 'Cambio de Peaje y Dirección de Titular'),
    ('19', 'Cambio de Titular, Dirección de Titular y Peaje'),
    ('20', 'Modificación de Capacidad y Cambio de Dirección de Titular'),
    ('21', 'Cambio de Titular, Dirección de Titular y Modificación de Capacidad'),
    ('22', 'Cambio de Peaje, Dirección de Titular y Modificación de Capacidad'),
    ('23', 'Cambio de Titular, Dirección de Titular, Peaje y Modificación de Capacidad'),
    ('24', 'Cambio de Dirección del Punto de Suministro'),
    ('25', 'Modificación Peaje circular Peaje 01102021'),
]
TAULA_MOTIVO_DE_MODIFICACION_EN_UN_CAMBIO_DE_COMERCIALIZADOR = [
    ('01', 'Cambio de Titular'),
    ('02', 'Ampliación de Caudal.'),
    ('03', 'Cambio de titular y Ampliación de Caudal.'),
]
TAULA_MOTIVO_ANULACION = [
    ('002', 'Anulación de Solicitud de Cambio de Comercializadora'),
    ('004', 'Anulación de Solicitud de Baja'),
    ('014', 'Anulación de Solicitud de Baja desde SCTD por '
            'concurrencia Baja / Cambio'),
    ('016', 'Anulación de Solicitud de Cambio desde SCTD por '
            'concurrencia A102 / B1625'),
    ('017', 'Anulación de Solicitud de Baja desde SCTD por '
            'concurrencia A104 / B1625'),
    ('018', 'Anulación de Solicitud de NNSS'),
    ('019', 'Anulación de Solicitud de Cambio de Comercializadora con '
            'Modificación de datos'),
    ('020', 'Anulación de Solicitud de Cambio con Modificación desde '
            'SCTD por concurrencia A141 / B1625'),
    ('022', 'Anulación de NNSS por plazo de fin de infraestructura/transformación excedido'),
    ('023', 'Anulación de NNSS por Anulación infraestructura/transformación en curso'),
    ('024', 'Anulación de NNSS por Ausente'),
    ('035', 'Anulación de solicitud de desistimiento'),
    ('036', 'Anulación de solicitud de traspaso a la CUR por concurrencia con cambio de comercializador/baja por cese/ alta de NNSS en transformación del GLP'),
    ('037', 'Anulación de Solicitud de Cambio de Comercializadora con nuevos productos adicionales'),
    ('038', 'Anulación de Solicitud de nuevo Producto/Contrato'),
    ('039', 'Anulación de solicitud de traspaso a la CUR por aceptación de anulación a iniciativa del comercializador sobre la solicitud que motivó tal traspaso'),
]
TAULA_ESTADO_PUNTO_DE_SUMINISTRO = [
    ('0', 'Sin servicio'),
    ('1', 'En servicio'),
]
TAULA_ESTADO_INFRAESTRUCTURA_SCR_TRANSFORMACION = [
    ('01', 'Creado/Planificado'),
    ('02', 'Anulado'),
    ('03', 'Ausente'),
    ('04', 'Finalizado'),
]
TAULA_ESTADO_RESERVA_CONTRATACION_COM = [
    ('01', 'Sin solicitudes recibidas'),
    ('02', 'Con Pre-Reserva para otra comercializadora'),
    ('03', 'Con Pre-Reserva por comercializadora que consulta'),
    ('04', 'Con Solicitud de NNSS de otra comercializadora'),
    ('05', 'Con Solicitud de NNSS por comercializadora que consulta'),
    ('06', 'No contratable por transformación/SCR anulada”'),
    ('07', 'Contratado'),
]
TAULA_ORIGEN_PS_SIN_CONTRATO = [
    ('00', 'Puntos de suministro consolidados'),
    ('01', 'Nuevo Punto de Suministro (SCR)'),
    ('02', 'Transformación de GLP'),
]
TAULA_DESISTIMIENTO = [
    ('01', 'Desistimiento en plazo máx. de 14 días naturales'),
    ('02', 'Desistimiento por incumplimiento de comercializador en contratación'),
]
TAULA_RESULTADO_ACTIVACION_DESISTIMIENTO = [
    ('01', 'Vuelta a la situación anterior'),
    ('02', 'Traspaso al CUR'),
    ('03', 'Baja del contrato por rechazo del CUR'),
    ('04', 'Baja por cese de actividad'),
    ('05', 'Activación de Cambio de Comercializador'),
]
TAULA_CONTESTACION_INCIDENCIA = [
    ('01', 'Nuevo teléfono de contacto.'),
    ('02', 'Deficiencia/Trabajos subsanada. Contactar con cliente'),
]
TAULA_MOTIVO_TRASPASO_A_CUR = [
    ('01', 'Solicitud de baja por fin de contrato de energía (A1_04 motivo 05,  Fin de contrato de energía)'),
    ('02', 'Solicitud de desistimiento a un cambio de comercializador de un nuevo titular'),
    ('03', 'Decisión fundada de la Dirección General de Política Energética y Minas, cautelar o definitivamente, se traspasan los puntos de suministro al CUR'),
    ('04', 'Punto de GLP transformado a GN que en el día de la transformación no ha contratado el suministro de gas natural con un comercializador.'),
]
TAULA_DIRECCION_FISCAL = [
    ('S', 'Si el domicilio fiscal coincide con el del Suministro'),
    ('F', 'Si el domicilio fiscal no coincide con el del Suministro'),
]
TAULA_RESULTADO_ULTIMA_REVISION = [
    ('01', 'Descripción 01'),
    ('02', 'Descripción 02'),
]
TAULA_RANGO_PRESION_DISENO = [
    ('01', 'Presión <= 4 bar'),
    ('02', '4 bar < Presión <= 60 bar'),
    ('03', 'Presión > 60 bar'),
]
TAULA_PERFIL_CONSUMO = [
    ('01', 'Mercado Doméstico'),
    ('02', 'Mercado Industrial'),
]
TAULA_TIPO_DE_APARATO = [
    ('CO', 'Contador'),
    ('CR', 'Corrector'),
    ('UR', 'Unidad Remota'),
]
TAULA_TIPO_DE_LECTURA_DE_NUMERADOR = [
    ('BR', 'Bruta'),
    ('CR', 'Corregida'),
]
TAULA_MOTIVO_DE_LECTURA = [
    ('01', 'Lectura Inicio'),
    ('02', 'Lectura Fin'),
    ('03', 'Lectura Intermedia'),
    ('04', 'Lectura Periódica o de Cálculo'),
]
TAULA_PERIODICIDAD_DE_DISCRIMINACION_HORARIA = [
    ('01', 'Punta + Llano'),
    ('03', 'Valle'),
    ('10', 'Totalizador'),
]
TAULA_TIPO_DE_DISCRIMINACION_HORARIA = [
    ('00', 'Dos períodos (Tarifa Nocturna)'),
    ('01', 'Sin discriminación horaria'),
]
TAULA_TIPO_DE_TELEMEDIDA = [
    ('N', 'No telemedido'),
    ('R', 'Telemedido, valor Real'),
    ('E', 'Telemedido, valor Estimado (por DIS)'),
    ('C', 'Telemedido, valor Estimado (por COM)'),
]
TAULA_TIPO_FACTURA = [
    ('01', 'Factura ATR Individual'),
    ('11', 'Pseudofactura'),
    ('99', 'Factura ATR Agregada'),
]
TAULA_CLASE_FACTURA_O_TIPO_DE_FACTURA_RECTIFICADORA = [
    ('N', 'Normal'),
    ('A', 'Anuladora'),
    ('R', 'Rectificadora'),
    ('B', 'Anuladora con sustituyente'),
]
TAULA_TIPO_FACTURACION = [
    ('1', 'Regular (periodo completo)'),
    ('2', 'Irregular (periodo incompleto)'),
]
TAULA_NIVEL_CONCEPTOS_FACTURACION = [
    ('0', 'Nivel de Factura'),
    ('1', 'Nivel de CUPS'),
    ('2', 'Nivel de Unidad de Medida'),
    ('3', 'Nivel de Aparato de Medida'),
]
TAULA_CONCEPTOS_FACTURACION = [
    ('0', '0000', 'Importe Total Factura'),
    ('0', '0001', 'SALDO FACTURA'),
    ('0', '0002', 'SALDO COBRO'),
    ('0', '0003', 'Importe Facturación de alquileres'),
    ('1', '0003', 'Importe Facturación de alquileres'),
    ('2', '0003', 'Importe Facturación de alquileres'),
    ('0', '0004', 'IMPORTE DE INTERESES'),
    ('0', '0005', 'CONCEPTO AÑADIDO CON BASE IMPUESTO ESPECIFICO E IVA'),
    ('0', '0006', 'CONCEPTO AÑADIDO CON BASE IVA'),
    ('0', '0007', 'Importe base imponible IVA-IGIC'),
    ('0', '0008', 'Importe impuesto IVA-IGIC'),
    ('0', '0009', 'IMPORTE BASE IMPONIBLE IVA-IGIC REDUCIDO'),
    ('0', '0010', 'IMPORTE IMPUESTO IVA-IGIC REDUCIDO'),
    ('0', '0011', 'BASE IMPONIBLE'),
    ('0', '0012', 'Importe alquiler corrector'),
    ('1', '0012', 'Importe alquiler corrector'),
    ('2', '0012', 'Importe alquiler corrector'),
    ('2', '0013', 'Importe alquiler unidad remota'),
    ('0', '0013', 'Importe alquiler unidad remota'),
    ('0', '0014', 'Importe cesión contador'),
    ('1', '0014', 'Importe cesión contador'),
    ('2', '0014', 'Importe cesión contador'),
    ('0', '0015', 'Importe Inspección I.R.G. Importe Inspección IRI'),
    ('1', '0015', 'Importe Inspección I.R.G. Importe Inspección IRI'),
    ('2', '0015', 'Importe Inspección I.R.G. Importe Inspección IRI'),
    ('0', '0016', 'Término fijo peaje'),
    ('0', '0017', 'Término variable peaje'),
    ('0', '0330', 'Descuento por Interrupción de Suministro'),
    ('1', '0330', 'Descuento por Interrupción de Suministro'),
    ('0', '0430', 'Intervención-Reparación Instalación'),
    ('1', '0430', 'Intervención-Reparación Instalación'),
    ('0', '0433', 'Operaciones y Servicios'),
    ('1', '0433', 'Operaciones y Servicios'),
    ('1', '0438', 'Visita Faliida'),
    ('0', '0490', 'Reapertura Suministro'),
    ('1', '0490', 'Reapertura Suministro'),
    ('1', '1023', 'COMPLEMENTO DE POTENCIA/CAUDAL'),
    ('1', '1024', 'SUPLEMENTO DE POTENCIA/CAUDAL'),
    ('1', '1031', 'COMP. DISCRIMINACION HORARIA'),
    ('1', '1032', 'COMP. DISCRIMINACION HORARIA *'),
    ('1', '1041', 'COMPLEMENTO INTERRUMPIBILIDAD'),
    ('1', '1042', 'DESCUENTO APORTACION POTENCIA/CAUDAL'),
    ('1', '1051', 'COMPLEMENTO DE ESTACIONALIDAD'),
    ('1', '1052', 'REGULARIZACION TERM. POTENCIA/CAUDAL'),
    ('1', '1053', 'REGULARIZACION COMPL. REACTIVA'),
    ('0', '1070', 'DESCUENTO SEGUN CONTRATO'),
    ('1', '1070', 'DESCUENTO SEGUN CONTRATO'),
    ('1', '1095', 'ALQ.AVISADOR CONSUMO ELECTRICO'),
    ('0', '1101', 'IMPORTE A SUMAR/RESTAR EN BASE IVA-OFI'),
    ('0', '1102', 'IMPORTE A SUMAR/RESTAR EN BASE IVA'),
    ('0', '1103', 'REPERCUSION DE CUOTAS OFICO'),
    ('0', '1104', 'REFACTURACION APLICADA'),
    ('0', '1105', 'IMPORTE REGULARIZADO SIN IVA'),
    ('0', '1106', 'PEAJE'),
    ('1', '1150', 'DESCUENTO POR GESTION DE EXPLOTACION'),
    ('2', '1201', 'ACONDICIONAMIENTO APARATO DE MEDIDA'),
    ('1', '1202', 'COMPROBACION DERIVACION A TIERRA'),
    ('1', '1203', 'REPERCUSION DE GASTOS FINANCIEROS'),
    ('1', '1204', 'INSTALACION CAJA DE FUSIBLES'),
    ('1', '1205', 'INSTALACION CERRADURA EN PL'),
    ('1', '1206', 'INSTALACION DISYUNTOR DIFERENCIAL'),
    ('1', '1207', 'INSTALACION DERIVACION INDIVIDUAL'),
    ('1', '1208', 'INSTALACION DE LAMPARAS'),
    ('1', '1209', 'INSTALACION LINEA REPARTIDORA'),
    ('1', '1210', 'Mantenimiento de instalaciones'),
    ('2', '1211', 'SUSTITUCION CARETA APARATO DE MEDIDA'),
    ('0', '1212', 'Intereses de demora'),
    ('0', '1213', 'CARGO POR ERROR DE FACTURACION'),
    ('0', '1214', 'ABONO POR ERROR DE FACTURACION'),
    ('2', '1215', 'CARGO EQUIPOS MEDIDA'),
    ('2', '1216', 'MODIFICACION MEMORIA APARATO MEDIDA'),
    ('0', '1217', 'ABONO MERCADO LIBERALIZADO'),
    ('0', '1218', 'CARGO MERCADO LIBERALIZADO'),
    ('2', '1219', 'PRECIO FINANCIACION DE INSTALACIONES'),
    ('2', '1220', 'CUOTA FINANCIACION DE INSTALACIONES'),
    ('2', '1221', 'COMPL. CURVA DE CARGA'),
    ('2', '1222', 'COMPL. VOLUMEN DE CONSUMO'),
    ('2', '1223', 'Compl. factor de utilización'),
    ('1', '1224', 'COMPLEMENTOS DE PRECIO'),
    ('1', '1225', 'ABONO EXTRAORDINARIO POR COMPLEMENTOS'),
    ('0', '1301', 'Indemnización'),
    ('1', '1302', 'Canon Finca'),
    ('1', '1303', 'IMPUESTO DE VALOR AÑADIDO'),
    ('0', '1310', 'Indemnización Cortes indebidos'),
    ('0', '1311', 'INDEMNIZACION GASTOS FINANCIEROS'),
    ('0', '1312', 'INDEMNIZACION OTROS COMERCIAL'),
    ('0', '1319', 'Indemnización Distribución'),
    ('1', '1319', 'Indemnización Distribución'),
    ('0', '1320', 'INCUMPLIM.EN CALIDAD DE ATENC. CONSUMIDOR'),
    ('0', '1330', 'INDEM. PRESUPUESTO NUEVOS SUMINISTROS'),
    ('0', '1331', 'INDEM. EJECUCION INSTALACIONES'),
    ('0', '1332', 'INDEM. INSTALACION EQUIPO MEDIDA'),
    ('0', '1333', 'INDEM. ATENCION A RECLAMACIONES'),
    ('0', '1334', 'INDEM. ENGANCHE DESPUES DE CORTE'),
    ('0', '1335', 'INDEM. EJECUCION INDEBIDA CORTE'),
    ('1', '1401', 'Derechos acometida de extensión'),
    ('1', '1402', 'Derechos acometida de acceso'),
    ('1', '1403', 'CARGO POR NO CESION DE LOCAL'),
    ('1', '1501', 'DESCUENTOS POR CESION DE LOCAL PARA CT'),
    ('1', '1502', 'TRABAJOS INSTALACIONES SOLIC POR CLIENTE'),
    ('1', '1503', 'BONIFIC SOBRE TRABAJOS EN INSTALACIONES'),
    ('1', '1601', 'Derechos de enganche'),
    ('1', '1602', 'Derechos de verificación instalaciones'),
    ('1', '1604', 'Devolución de fianza'),
    ('1', '1605', 'Derechos de acometida'),
    ('1', '1606', 'ACONDICIONAMIENTO INSTALACION 2.0N'),
    ('2', '1607', 'ACONDTO. INSTALAC. DOBLE TARIFA'),
    ('2', '1608', 'ACONDTO. INSTALAC. MEDIDA INDIRECTA BT'),
    ('3', '1609', 'Verificación aparato de medida'),
    ('1', '1609', 'Verificación Equipo'),
    ('1', '1611', 'BONIFICACION DERECHOS ACCESO'),
    ('1', '1612', 'BONIFICACION DERECHOS DE EXTENSION'),
    ('1', '1613', 'Fianza'),
    ('3', '1614', 'BONIFICACION ACONDICIONAMIENTO MEDIDA'),
    ('1', '1615', 'ACONDTO. INSTALAC. ST AT'),
    ('1', '1616', 'ACONDTO. INSTALAC. DT/TT AT'),
    ('1', '1617', 'ACONDTO. CAMBIO ST DT/TT AT'),
    ('1', '1618', 'COMPENSACION ART. 15 R.A.E. 2949/1982'),
    ('1', '1701', 'DESPRECINTE'),
    ('2', '1702', 'CAMBIO EMPLAZAMIENTO APARATO DE MEDIDA'),
    ('1', '1703', 'Derechos de reconexión'),
    ('0', '1801', 'CARGO POR SERVICIOS ATENCION TELEFONICA'),
    ('0', '1802', 'CARGO POR SERVICIOS DE SOPORTE COMERCIAL'),
    ('0', '1803', 'CARGO POR COMISIONES A SUMINISTRADORES'),
    ('0', '1804', 'CARGO POR SERVICIOS A CLIENTES'),
    ('3', '1805', 'CARGO POR ARRENDAMIENTO DE EQUIPOS'),
    ('0', '1806', 'Venta de productos y servicios a nivel de Factura'),
    ('1', '1806', 'Venta de productos y servicios a nivel de CUPS'),
    ('2', '1806', 'Venta de productos y servicios a nivel de Unidad de Medida'),
    ('3', '1806', 'Venta de productos y servicios a nivel de '
                  'Aparato de Medida'),
    ('0', '1901', 'Concepto extraordinarios 1 a nivel de Factura'),
    ('1', '1901', 'Concepto extraordinarios 1 a nivel de CUPS'),
    ('2', '1901', 'Concepto extraordinarios 1 a nivel de Unidad de Medida'),
    ('3', '1901', 'Concepto extraordinarios 1 a nivel de Aparato de Medida'),
    ('0', '1902', 'Concepto extraordinarios 2 a nivel de Factura'),
    ('1', '1902', 'Concepto extraordinarios 2 a nivel de CUPS'),
    ('2', '1902', 'Concepto extraordinarios 2 a nivel de Unidad de Medida'),
    ('3', '1902', 'Concepto extraordinarios 2 a nivel de Aparato de Medida'),
    ('0', '1903', 'Concepto extraordinarios 3 a nivel de Factura'),
    ('1', '1903', 'Concepto extraordinarios 3 a nivel de CUPS'),
    ('2', '1903', 'Concepto extraordinarios 3 a nivel de Unidad de Medida'),
    ('3', '1903', 'Concepto extraordinarios 3 a nivel de Aparato de Medida'),
    ('0', '1904', 'CONCEPTO EXTRAORDINARIOS 4'),
    ('1', '1904', 'CONCEPTO EXTRAORDINARIOS 4'),
    ('2', '1904', 'CONCEPTO EXTRAORDINARIOS 4'),
    ('3', '1904', 'CONCEPTO EXTRAORDINARIOS 4'),
    ('0', '1905', 'CONCEPTO EXTRAORDINARIOS 5'),
    ('1', '1905', 'CONCEPTO EXTRAORDINARIOS 5'),
    ('2', '1905', 'CONCEPTO EXTRAORDINARIOS 5'),
    ('3', '1905', 'CONCEPTO EXTRAORDINARIOS 5'),
    ('0', '1906', 'CONCEPTO EXTRAORDINARIOS 6'),
    ('1', '1906', 'CONCEPTO EXTRAORDINARIOS 6'),
    ('2', '1906', 'CONCEPTO EXTRAORDINARIOS 6'),
    ('3', '1906', 'CONCEPTO EXTRAORDINARIOS 6'),
    ('0', '1907', 'Revisión metrológica de equipo '),
    ('1', '1908', 'Gastos Derivados Visitas Inspección Previa Alta'),
    ('1', '1909', 'Gastos Administración'),
    ('1', '1910', 'Derechos de alta'),
    ('1', '1911', 'Canon IRC 1'),
    ('1', '1912', 'Canon IRC 2'),
    ('1', '1913', 'Canon Plan 10'),
    ('0', '1914', 'Impuesto especial sobre hidrocarburos'),
    ('0', '1915', 'Inspección periódica industrial'),
    ('0', '1916', 'Reapertura instalación gas a nivel de Factura'),
    ('1', '1916', 'Reapertura instalación gas a nivel de CUPS'),
    ('2', '1916', 'Reapertura instalación gas '),
    ('3', '1916', 'Reapertura instalación gas '),
    ('0', '1917', 'Reapertura suministro'),
    ('1', '1917', 'Reapertura suministro'),
    ('2', '1917', 'Reapertura suministro'),
    ('3', '1917', 'Reapertura suministro'),
    ('0', '1918', 'Desconexión contador a nivel de Factura'),
    ('1', '1918', 'Desconexión contador a nivel de CUPS'),
    ('2', '1918', 'Desconexión contador '),
    ('3', '1918', 'Desconexión contador '),
    ('0', '1919', 'Cambio contador a nivel de Factura'),
    ('1', '1919', 'Cambio contador a nivel de CUPS'),
    ('2', '1919', 'Cambio contador '),
    ('3', '1919', 'Cambio contador '),
    ('0', '1920', 'Comprobación contador y/o lectura a nivel de Factura'),
    ('1', '1920', 'Comprobación contador y/o lectura a nivel de CUPS'),
    ('2', '1920', 'Comprobación contador y/o lectura '),
    ('3', '1920', 'Comprobación contador y/o lectura'),
    ('0', '1921', 'Reapertura instalación gas con certificado a '
                  'nivel de Factura'),
    ('1', '1921', 'Reapertura instalación gas con certificado a nivel de CUPS'),
    ('2', '1921', 'Reapertura instalación gas con certificado '),
    ('3', '1921', 'Reapertura instalación gas con certificado '),
    ('0', '1922', 'Cierre por falta de pago'),
    ('1', '1922', 'Cierre por falta de pago'),
    ('2', '1922', 'Cierre por falta de pago'),
    ('3', '1922', 'Cierre por falta de pago'),
    ('0', '1923', 'INTERVENCION RAPIDA'),
    ('1', '1923', 'INTERVENCION RAPIDA'),
    ('2', '1923', 'INTERVENCION RAPIDA'),
    ('3', '1923', 'INTERVENCION RAPIDA'),
    ('0', '1924', 'INTERVENCION RAPIDA'),
    ('1', '1924', 'INTERVENCION RAPIDA'),
    ('2', '1924', 'INTERVENCION RAPIDA'),
    ('3', '1924', 'INTERVENCION RAPIDA'),
    ('0', '1925', 'INTERVENCION IRC'),
    ('1', '1925', 'INTERVENCION IRC'),
    ('2', '1925', 'INTERVENCION IRC'),
    ('3', '1925', 'INTERVENCION IRC'),
    ('0', '1926', 'INTERVENCION IRC'),
    ('1', '1926', 'INTERVENCION IRC'),
    ('2', '1926', 'INTERVENCION IRC'),
    ('3', '1926', 'INTERVENCION IRC'),
    ('0', '1927', 'MATERIALES UTILIZADOS EN INTERVENCION'),
    ('1', '1927', 'MATERIALES UTILIZADOS EN INTERVENCION'),
    ('2', '1927', 'MATERIALES UTILIZADOS EN INTERVENCION'),
    ('3', '1927', 'MATERIALES UTILIZADOS EN INTERVENCION'),
    ('1', '1928', 'CANON IRC 3'),
    ('1', '1929', 'INSPECCION PERIÓDICA IRC'),
    ('0', '1930', 'Gastos de gestión de Inspección Periódica de IRI de '
                  'la empresa distribuidora'),
    ('1', '1930', 'Gastos de gestión de Inspección Periódica de IRI de '
                  'la empresa distribuidora'),
    ('0', '1931', 'Gastos de gestión de Inspección Periódica de IRC de '
                  'la empresa distribuidora'),
    ('1', '1931', 'Gastos de gestión de Inspección Periódica de IRC de '
                  'la empresa distribuidora'),
    ('0', '1932', 'Gastos de inspección física de la '
                  'Inspección Periódica de IRI'),
    ('1', '1932', 'Gastos de inspección física de la '
                  'Inspección Periódica de IRI'),
    ('0', '1933', 'Gastos de inspección física de la '
                  'Inspección Periódica de IRC '),
    ('1', '1933', 'Gastos de inspección física de la '
                  'Inspección Periódica de IRC '),
    ('0', '1934', 'Presentación al cobro factura Inspección Periódica de '
                  'IRI realizada por empresa instaladora'),
    ('1', '1934', 'Presentación al cobro factura Inspección Periódica de '
                  'IRI realizada por empresa instaladora'),
    ('0', '1935', 'Presentación al cobro factura Inspección Periódica de '
                  'IRC realizada por empresa instaladora'),
    ('1', '1935', 'Presentación al cobro factura Inspección Periódica de '
                  'IRC realizada por empresa instaladora'),
    ('1', '1936', 'Canon IRC 4'),
]
TAULA_CONCEPTO_FACTURACION = [(a[1], a[2]) for a in TAULA_CONCEPTOS_FACTURACION]

TAULA_MOTIVO_REGULARIZACION_CONSUMO = [
    ('01', 'Verificación equipo de medida'),
    ('02', 'Avería en contador'),
    ('03', 'Avería en corrector'),
    ('04', 'Avería en unidad remota'),
    ('05', 'Avería en trafo de tensión'),
    ('06', 'Avería en trafo de intensidad'),
    ('07', 'Desbordamiento del registrador'),
    ('08', 'Problemas en la sincronización del registrador'),
    ('09', 'Pérdida de alimentación del registrador'),
    ('10', 'Manipulación de equipos'),
    ('11', 'Servicio directo (sin EM)'),
    ('12', 'Punto de medida inaccesible'),
    ('13', 'Punto de medida ilocalizable'),
    ('99', 'Otros'),
]
TAULA_TIPO_DE_IMPUESTO = [
    ('01', 'IVA'),
    ('02', 'Impuesto Especial de Hidrocarburos (IEH)'),
]
TAULA_TIPO_DISCRIMINACIoN_HORARIA = [
    ('00', 'Con discriminación horaria'),
    ('01', 'Sin discriminación horaria'),
]
TAULA_MOTIVO_LECTURA = [
    ('01', 'Lectura Inicio'),
    ('02', 'Lectura Fin'),
    ('03', 'Lectura Intermedia'),
    ('04', 'Lectura Periódica o de Cálculo'),
]
TAULA_PERIODICIDAD_LECTURA_FACTURACION = [
    ('M', 'Mensual'),
    ('B', 'Bimestral'),
    ('A', 'Anual'),
    ('S', 'Semestral'),
    ('D', 'Diaria'),
]
TAULA_TIPO_CIERRE = [
    ('001', 'La Actualización de Datos se ha realizado correctamente'),
    ('002', 'Operación Realizada'),
    ('003', 'Se facilita la información requerida'),
    ('004', 'Se ha gestionado y solucionado la Reclamación'),
    ('005', 'Se acepta Reclamación y se corrige valor'),
    ('006', 'Se acepta Reclamación y se procede al envío del mensaje'),
    ('007', 'Se ha gestionado y se ha vuelto al Concertar Visita'),
    ('008', 'Se ha rectificado Factura y se ha realizado el '
            'extorno correspondiente'),
    ('009', 'Se incorpora Documento aportado'),
    ('010', 'Se remite Documento solicitado'),
    ('011', 'Se ha creado Operación de IP ausente sobre el CUPS solicitado'),
    ('012', 'La Actualización de la Lectura se ha realizado correctamente'),
    ('013', 'La Solicitud recibida no es coherente'),
    ('014', 'No se puede modificar la información recibida'),
    ('015', 'No está autorizado para realizar esta solicitud'),
    ('016', 'Existe solicitud pendiente del mismo tipo en '
            'el punto de suministro'),
    ('017', 'Existe trabajo pendiente incompatible con la operación solicitada'),
    ('018', 'Existe trabajo pendiente del mismo tipo en el punto de suministro'),
    ('019', 'Existe solicitud pendiente incompatible en el punto de suministro'),
    ('020', 'Se ha recibido solicitud de cambio para el mismo CUPS'),
    ('021', 'Operación pendiente concertada'),
    ('022', 'Excedido tiempo máximo de la solicitud.'),
    ('023', 'Anulada por nueva petición de Comercializadora'),
    ('024', 'Anulada a petición de Comercializadora'),
    ('025', 'Se ha recibido solicitud de cese para el mismo CUPS'),
    ('026', 'El cliente está cesado'),
    ('027', 'No se ha podido contactar con el cliente'),
    ('028', 'No realizada por causas imputables al cliente'),
    ('029', 'No realizada por causas imputables al distribuidor'),
    ('030', 'Excedido el número máximo de visitas'),
    ('031', 'Excedido tiempo máximo de concertación'),
    ('032', 'Innecesario'),
    ('033', 'No consta Inspección Periódica para el CUPS indicado'),
    ('034', 'No se dispone del documento solicitado'),
    ('035', 'IP ya realizada'),
    ('036', 'Se envía Mail a Empresa de Inspección para su Reprogramación'),
    ('037', 'Se dispone de una Lectura Posterior'),
    ('038', 'No se dispone de la información solicitada'),
    ('039', 'Debe informar una Fecha/Hora de Reprogramación'),
    ('040', 'Consulte página Web de Distribución'),
    ('041', 'La Reclamación recibida no es responsabilidad de '
            'la Distribuidora'),
    ('042', 'Se ha gestionado la Reclamación pero no se ha detectado ningún '
            'comportamiento erróneo'),
    ('043', 'Rechazo aplicado correctamente'),
    ('044', 'No existe Solicitud para el CUPS y proceso indicados'),
    ('045', 'Se ha aclarado el Rechazo y el cliente queda de acuerdo'),
    ('046', 'Fecha efecto aplicada correctamente'),
    ('047', 'Lectura aplicada correctamente'),
    ('048', 'El peaje aplicado coincide con el solicitado'),
    ('049', 'El Qd aplicado coincide con el solicitado'),
    ('050', 'El Qh aplicado coincide con el solicitado'),
    ('051', 'El proceso ha sido anulado'),
    ('052', 'El mensaje ha sido enviado con anterioridad'),
    ('053', 'No se ha enviado acepto'),
    ('054', 'Activación en Curso con Fecha Efecto Futura'),
    ('055', 'No procede para el Peaje asociado al CUPS'),
    ('056', 'La Visita aún no ha sido concertada'),
    ('057', 'La Concertación inicial ha sido anulada'),
    ('058', 'La Visita se ha Realizado'),
    ('059', 'No se ha realizado la Baja del Contrato'),
    ('060', 'No procede cartel en la Finca'),
    ('061', 'No aplica Tarjeta de Ausencia'),
    ('062', 'Deshabitado'),
    ('063', 'Concertación fallida.'),
    ('064', 'No quiere gas'),
    ('065', 'Quiere gas más adelante.'),
]
TAULA_TIPO_INTERVENCION = [
    ('01', 'Retipificación'),
    ('02', 'Solicitud de Más Información'),
    ('03', 'Operación.'),
    ('04', 'Avance de información por parte de la Distribuidora.'),
    ('05', 'Solicitud de información necesaria para retipificar'),
]
TAULA_TIPOS_DE_SOLICITANTE_RECLAMANTE = [
    ('01', 'Cliente – Usuario final - Titular'),
    ('02', 'Representante legal'),
    ('03', 'Aseguradora'),
    ('04', 'Administraciones/ Organismos Públicos'),
    ('06', 'Comercializador'),
    ('07', 'Juzgados'),
    ('08', 'Afectado no titular ni usuario del punto de suministro'),
    ('09', 'Asociaciones de Consumidores'),
]
TAULA_TIPO_SOLICITANTE = TAULA_TIPOS_DE_SOLICITANTE_RECLAMANTE

TAULA_TIPOS_DE_DOCUMENTO = [
    ('CC', 'Carta de Conformidad'),
    ('01', 'Acta de puesta en marcha'),
    ('02', 'Acta de inspección'),
    ('03', 'Reclamación'),
    ('04', 'Respuesta a Reclamación'),
    ('05', 'Facturas'),
    ('06', 'Otra documentación del cliente'),
    ('99', 'Otros'),
]
TAULA_TIPOS_DOCUMENTOS_ANEXOS = TAULA_TIPOS_DE_DOCUMENTO

TAULA_ORIGEN_INSPECCION = [
    ('0', 'Distribuidor'),
    ('1', 'Comercializador'),
    ('2', 'Otros Instaladores'),
]
TAULA_MOTIVOS_DE_ANULACION_AT_COM = [
    ('101', 'Anulación de Actuación'),
    ('102', 'Anulación de Reclamación'),
]
TAULA_TIPO_OPERACION = [
    ('A10001', 'Reapertura IRI con certificado. ', 'AMBOS', 'I'),
    ('A10002', 'Reapertura IRI por pago deuda.', 'AMBOS', 'I'),
    ('A10003', 'Puesta en seguridad IRI (levantamiento de contador por obras).', 'AMBOS', 'I'),
    ('A10004', 'Cambio de contador', 'DIS', 'I'),
    ('A10005', 'Comprobar estado contador (comprobar si marca)', 'AMBOS', 'I'),
    ('A10006', 'Reapertura de IRC (sin certificado)', 'DIS', 'I'),
    ('A10007', 'Cierre para Finca', 'AMBOS', 'I'),
    ('A10008', 'Reapertura por reforma IRC (con certificado)', 'AMBOS', 'I'),
    ('A10009', 'Inspección periódica', 'DIS', 'I'),
    ('A10010', 'Cierre de suministro inspecciones', 'DIS', 'I'),
    ('A10011', 'Cierre por falta de pago', 'AMBOS', 'I'),
    ('A10012', 'Verificar finca', 'AMBOS', 'I'),
    ('A10013', 'Abrir finca para urgencias', 'AMBOS', 'I'),
    ('A10014', 'Verificación acumulación de consumo', 'AMBOS', 'I'),
    ('A10015', 'Reapertura IRI por Cierre Total consumo', 'DIS', 'I'),
    ('A10016', 'Reapertura IRC por Cierre Total consumo', 'DIS', 'I'),
    ('A10017', 'Op. Urgencias. Apertura piso', 'DIS', 'I'),
    ('A10018', 'Op. Urgencias. Comprobar y abrir', 'DIS', 'I'),
    ('A10019', 'Op. Urgencias. Comprobar instalación', 'DIS', 'I'),
    ('A10020', 'Op. Urgencias. Exceso presión', 'DIS', 'I'),
    ('A10021', 'Op. Urgencias. Fuga interior en domiciliaria', 'DIS', 'I'),
    ('A10022', 'Op. Urgencias. Fuga interior en zona comunitaria', 'DIS', 'I'),
    ('A10023', 'Op. Urgencias. Reapertura por deuda', 'AMBOS', 'I'),
    ('A10024', 'Op. Urgencias. Incendio explosión', 'DIS', 'I'),
    ('A10025', 'Op. Urgencias. Intoxicación', 'DIS', 'I'),
    ('A10026', 'Op. Urgencias. Otros', 'DIS', 'I'),
    ('A10027', 'Op. Urgencias. Revisión Sistemat. Cambio Contador', 'AMBOS', 'I'),
    ('A10028', 'Op. Urgencias. Sin gas', 'DIS', 'I'),
    ('A10029', 'Op. Urgencias. Visita sin actuación', 'DIS', 'I'),
    ('A10030', 'Reapertura IRI sin certificado. ', 'AMBOS', 'I'),
    ('A20001', 'Lectura facilitada', 'AMBOS', 'A'),
    ('A20002', 'Comunicación Reapertura por instalador', 'AMBOS', 'A'),
    ('A20003', 'Modificación en Estimación', 'AMBOS', 'A'),
    ('A20004', 'Baja de Telemedida', 'AMBOS', 'A'),
    ('A20006', 'Aviso posible fraude', 'AMBOS', 'A'),
]
TAULA_TIPO_ACTUACION = TAULA_TIPO_OPERACION
TAULA_TIPO_OPERACION_COMER = [(x[0], x[1]) for x in TAULA_TIPO_OPERACION if x[2] == 'AMBOS']
TAULA_TIPO_OPERACION_TODOS = [(x[0], x[1]) for x in TAULA_TIPO_OPERACION]

TAULA_SITUACION_SUMINISTRO = [
    ('00', 'PENDIENTE COMUNICACION DE OBRA CORRIENTE'),
    ('01', 'PENDIENTE DE PRIMERA FACTURACION'),
    ('02', 'EN SERVICIO'),
    ('03', 'EN SERVICIO/FRAUDE'),
    ('04', 'CONTADOR LEVANTADO POR OBRA'),
    ('05', 'CORTE POR FALTA DE PAGO'),
    ('06', 'CIERRE TEMPORAL A PETICION CLIENTE'),
    ('07', 'CIERRE TEMPORAL POR FUERZA MAYOR'),
    ('08', 'CESADO'),
    ('09', 'CERRADO POR CENSO'),
    ('10', 'CERRADO POR TRANSFORMACION'),
    ('11', 'CERRADO POR INSPECCION SISTEMATICA IRI'),
    ('12', 'CERRADO POR DEFECTO RECEPTORA COMUN'),
    ('13', 'CERRADO POR CCAU'),
    ('18', 'CESADO PENDIENTE DE FACTURACION'),
    ('20', 'CERRADO Y PRECINTADO'),
    ('30', 'CERRADO POR FRAUDE Y LEVANTADO'),
    ('50', 'EN SERVICIO POR CLIENTE'),
    ('99', 'POLIZA FICTICIA'),
]
TAULA_SITUACION_SERVICIO = [
    ('00', 'EN SERVICIO'),
    ('01', 'C.PARCIAL IRI POR INSPECCIONES'),
    ('02', 'C.PARCIAL IRI PREV. POR URG.'),
    ('03', 'C.PARCIAL IRI POR URGENCIAS'),
    ('04', 'IRI EN A.U.P POR INSPECCIONES'),
    ('05', 'IRI EN A.U.P PREV. POR URG.'),
    ('06', 'IRI EN A.U.P POR URGENCIAS'),
    ('07', 'C.TOTAL IRI POR INSPECCIONES'),
    ('08', 'C.TOTAL IRI PREV. POR URG.'),
    ('09', 'C.TOTAL IRI POR URGENCIAS'),
    ('10', 'C.TOTAL IRC POR INSPECCIONES'),
    ('11', 'C.TOTAL IRI POR CIERRE IRC IP'),
    ('20', 'C.TOTAL IRC PREV. POR URG.'),
    ('21', 'C.TOTAL IRI POR C.IRC PREV.URG'),
    ('30', 'C.TOTAL IRC POR URGENCIAS'),
    ('31', 'C.TOTAL IRI POR CIERRE IRC URG.'),
    ('40', 'IRC EN A.U.P POR INSP.PERIODICA'),
    ('50', 'IRC EN A.U.P POR URGENCIAS'),
    ('60', 'C.PARCIAL IRC POR INSPECCIONES'),
    ('70', 'C.PARCIAL IRC PREV. POR URG.'),
    ('80', 'C.PARCIAL IRC POR URGENCIAS'),
    ('95', 'ERROR - PSUM-IRC RECIEN CREADO'),
    ('96', 'ERROR EN SIT. SERVICIO (VERIFICAR P.SUM)'),
    ('97', 'PENDIENTE DE CALCULAR EN P.SUM. NUEVO'),
    ('98', 'PUNTO SUM. CON SIT.SERV. NO CONTEMPLADA'),
    ('99', 'SIN SERVICIO'),
]
TAULA_TIPO_DE_RECLAMACION = [
    ('01', 'ATENCIÓN PERSONAL'),
    ('02', 'FACTURACIÓN Y MEDIDA'),
    ('03', 'CONTRATACIÓN'),
    ('04', 'GESTIÓN DE ACOMETIDAS'),
    ('05', 'CALIDAD DE SUMINISTRO'),
    ('06', 'SITUACIÓN DE INSTALACIONES'),
    ('07', 'ATENCION REGLAMENTARIA'),
    ('08', 'OTROS DAÑOS GAS'),
    ('09', 'INSPECCIÓN PERIODICA GAS'),
]
TAULA_TIPOS_DE_ATENCION_INCORRECTA = [
    ('01', 'Por personal de canales de atención'),
    ('02', 'Por operarios de equipos de medida'),
    ('03', 'Por operarios de nuevos suministros'),
    ('04', 'Por operarios de inspección'),
    ('05', 'Por operaciones'),
    ('06', 'Por operarios de lecturas'),
    ('07', 'Por averías/ urgencias'),
]
TAULA_CONCEPTOS_FACTURADOS = [
    ('02', 'Cálculo penalización telemedida aplicado'),
    ('03', 'Cálculo Qd media / Qd aplicada'),
    ('04', 'General sobre el factor de conversión'),
    ('05', 'Alquiler equipos de medida'),
    ('06', 'Derechos de alta y acometida (acceso enganche y extensión)'),
    ('07', 'Importe de operación facturada'),
    ('08', 'Término fijo'),
    ('09', 'Canon de la IRC'),
    ('10', 'Impuestos'),
    ('11', 'Qf '),
    ('12', 'Verificación equipos de medida'),
    ('13', 'Derechos de corte y reconexión'),
    ('14', 'Refacturaciones regulatorias'),
    ('16', 'Componentes regulados'),
    ('17', 'Abono por calidad individual'),
    ('18', 'Canon individual'),
    ('19', 'Tipo de peaje'),
]
TAULA_CONCEPTOS_DE_CONTRATACION = [
    ('01', 'Fecha de efecto'),
    ('02', 'Peaje (grupo de peaje)'),
    ('03', 'Qd'),
    ('04', 'Qh'),
    ('05', 'Lectura de Traspaso'),
    ('06', 'Titular'),
    ('07', 'Propiedad equipo de medida'),
    ('08', 'Presión'),
    ('09', 'Periodicidad en la facturación'),
    ('10', 'Dirección Punto Suministro'),
]
TAULA_DETALLE_DE_RESOLUCION = [
    ('0010101', 'Se piden disculpas'),
    ('0010201', 'Desacuerdo con la reclamación. '
                'Se adjunta explicación en comentarios'),
    ('0020101', 'Se modifica estado Cliente Robinson/ Cliente'),
    ('0020102', 'Se indemniza al cliente'),
    ('0020201', 'No consta solicitud previa'),
    ('0020202', 'Ajeno a la distribuidora'),
    ('0020203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0030101', 'Equipo incorrecto. Incluye equipo desaparecido.'),
    ('0030102', 'Instalación incorrecta. Incluye relación de transformación'),
    ('0030103', 'Lectura errónea'),
    ('0030201', 'Equipo correcto'),
    ('0030202', 'Instalación correcta'),
    ('0030203', 'Histórico de consumos / lecturas coherente.'),
    ('0030204', 'Detectada anomalía en visita'),
    ('0030205', 'Expediente por anomalía en curso.'),
    ('0030206', 'Elemento externo responsabilidad de cliente'),
    ('0030207', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0030301', 'No se localiza al cliente'),
    ('0030302', 'No corresponde a distribuidora. '),
    ('0030303', 'Cliente no aporta información adicional.'),
    ('0030304', 'Acceso denegado'),
    ('0030305', 'Visita anulada por cliente'),
    ('0040101', 'Favorable'),
    ('0040201', 'Desfavorable con explicación de motivos en texto resultado '),
    ('0040202', 'Sin incidencia'),
    ('0040203', 'Incidencia que no justifica daños'),
    ('0040204', 'Trabajos programados que no justifican daños'),
    ('0040205', 'Avería instalación particular cliente'),
    ('0040206', 'Originada por terceros '),
    ('0040207', 'Tiempo de interrupción no justifica pérdida de perecederos'),
    ('0040208', 'Se reitera la respuesta anterior'),
    ('0040209', 'Detectada anomalía en visita'),
    ('0040210', 'Expediente por anomalía en curso'),
    ('0040301', 'Imposible por documentación pendiente por parte del cliente'),
    ('0040302', 'Imposible llegar a un acuerdo'),
    ('0040303', 'Acceso Impedido'),
    ('0040304', 'Cliente ausente'),
    ('0050101', 'Asignamos correctamente y refacturamos'),
    ('0050102', 'informamos correctamente el nº contador '
                '(no hay que refacturar)'),
    ('0050103', 'Inversión de contadores'),
    ('0050104', 'Corte realizado por distribuidora'),
    ('0050201', 'El contador es correcto'),
    ('0050202', 'Expediente por anomalía en curso'),
    ('0050203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0050301', 'No se localiza al cliente'),
    ('0050302', 'Acceso denegado'),
    ('0050303', 'Visita anulada por cliente'),
    ('0060101', 'Error del Sistema '),
    ('0060102', 'Incidencia: datos Concentrador Secundario /Telemedida '),
    ('0060103', 'Modificaciones contractuales pendientes (fuera de plazo) '),
    ('0060104', 'Contador interior '),
    ('0060105', 'Pendiente trabajo domicilio cliente '
                '(Facturado. Tarea de cliente realizada) '),
    ('0060201', 'No tomada medida real'),
    ('0060202', 'Modificaciones contractuales pendientes (dentro de plazo)'),
    ('0060203', 'Período legal de facturación'),
    ('0060204', 'Contrato Facturado '),
    ('0060205', 'Pendiente trabajo domicilio cliente '
                '(sigue pendiente tarea del cliente) '),
    ('0060206', 'Contrato en baja '),
    ('0060207', 'Contrato con otra comercializadora'),
    ('0060208', 'Cortado por inspección no realizada/ impago'),
    ('0060209', 'CUPS no vigente en periodo de factura'),
    ('0060210', 'Expediente por anomalía/fraude en curso'),
    ('0060211', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0070101', 'Se anula factura'),
    ('0070201', 'Facturación correcta. (incluir explicación en campo '
                'comentarios)'),
    ('0070202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0080101', 'Se refactura el concepto reclamado'),
    ('0080102', 'Se refacturan otros conceptos / varios conceptos'),
    ('0080201', 'Conceptos reclamados correctamente facturados '
                '(incluir explicación en campo comentarios)'),
    ('0080202', 'ICP no instalado'),
    ('0080203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0090101', 'Equipo de Medida con acceso y consumo acumulado más de un '
                'año se refactura '),
    ('0090102', 'Se anula estimación '),
    ('0090103', 'Error Lectura Montaje/Desmontaje '),
    ('0090104', 'Error lectura lector '),
    ('0090105', 'Perfil estimado curva de carga en gráfico factura '),
    ('0090106', 'Error en Telemedida / Telegestión'),
    ('0090107', 'No conforme aplicación reactiva'),
    ('0090108', 'Error cargo/abono realizado'),
    ('0090109', 'Se refactura lectura reclamada'),
    ('0090201', 'Equipo de Medida sin acceso más de un año, facturación '
                'correcta'),
    ('0090202', 'Consumo correcto '),
    ('0090203', 'Estimación correcta '),
    ('0090204', 'Lectura aportada errónea '),
    ('0090205', 'Consumo acumulado '),
    ('0090206', 'Contador interior '),
    ('0090207', 'Lectura real correcta '),
    ('0090208', 'Perfil estimado curva de carga en gráfico factura '),
    ('0090209', 'Aplicación reactiva correcta'),
    ('0090210', 'Cargo/Abono realizado correcto'),
    ('0090211', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0090301', 'Visita fallida '),
    ('0100101', 'Se refactura'),
    ('0100102', 'Se anula la factura'),
    ('0100201', 'Factura correcta según normativa'),
    ('0100202', 'Expediente en curso '),
    ('0100203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0110101', 'Se abona el duplicado'),
    ('0110102', 'Se refactura'),
    ('0110103', 'Se anula la factura'),
    ('0110201', 'Factura correcta'),
    ('0110202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0120101', 'Se refactura'),
    ('0120201', 'Factura ya estaba rectificada'),
    ('0120202', 'No procede la refacturación'),
    ('0120203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0130101', 'Corregido cambio de suministrador realizado'),
    ('0130201', 'Cambio de suministrador realizado correctamente'),
    ('0130202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0130203', 'No existe solicitud'),
    ('0140101', 'Se devuelve fianza'),
    ('0140102', 'Se corrige devolución errónea y se reenvía fianza'),
    ('0140201', 'La devolución se efectuó correctamente'),
    ('0140202', 'No procede devolver'),
    ('0140203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0150101', 'Corte ejecutado'),
    ('0150201', 'Corte ejecutado en plazo'),
    ('0150202', 'Corte ejecutado con retraso imputable a cliente'),
    ('0150203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0150204', 'No existe solicitud'),
    ('0150301', 'Imputable a cliente'),
    ('0150302', 'Requerimiento de la administración judicial / legal '
                '(incluye esencialidad)'),
    ('0180101', 'Se corrigen criterios económicos en presupuesto'),
    ('0180102', 'Se corrige factura emitida (datos de facturación, importe)'),
    ('0180201', 'Factura correcta'),
    ('0180202', 'Criterios económicos correctos'),
    ('0180203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0190101', 'Se modifican criterios técnicos '),
    ('0190102', 'Se reparan desperfectos/se indemnizan daños'),
    ('0190103', 'Licencia de obra/permisos particulares '
                'de obra no solicitados'),
    ('0190104', 'Ejecución incorrecta de obras'),
    ('0190105', 'Asesoramiento técnico erróneo en contestación'),
    ('0190201', 'Criterios técnicos/ejecución obra correctos'),
    ('0190202', 'Petición de suministro no finalizada'),
    ('0190203', 'Plazo correcto'),
    ('0190204', 'Pendiente de documentación del cliente'),
    ('0190205', 'Improcedente. Se adjunta explicación de comentarios'),
    ('0190301', 'Impedido acceso a la instalación por cliente'),
    ('0210101', 'Favorable'),
    ('0210201', 'Desfavorable con explicación de motivos en texto resultado '),
    ('0210202', 'Sin incidencia'),
    ('0210203', 'Incidencia que no justifica daños'),
    ('0210204', 'Trabajos programados que no justifican daños'),
    ('0210205', 'Avería instalación particular cliente'),
    ('0210206', 'Originada por terceros '),
    ('0210207', 'Tiempo de interrupción no justifica pérdida de perecederos'),
    ('0210208', 'Se actúa de acuerdo a la normativa de calidad individual y '
                'zonal vigente'),
    ('0210209', 'Se reitera la respuesta anterior'),
    ('0210210', 'Expediente anomalía/fraude en curso'),
    ('0210301', 'Imposible por documentación pendiente por parte del cliente'),
    ('0210302', 'Imposible llegar a un acuerdo'),
    ('0210303', 'Imposible por falta de acceso al cliente'),
    ('0220101', 'Se corrige situación'),
    ('0220201', 'Desfavorable con explicación de motivos en texto resultado '),
    ('0220202', 'Sin incidencia'),
    ('0220203', 'Trabajos programados'),
    ('0220204', 'Avería instalación particular cliente'),
    ('0220205', 'Originada por terceros '),
    ('0220206', 'Se reitera la respuesta anterior'),
    ('0220207', 'No legitimada. Relación extracontractual.'),
    ('0220208', 'Expediente por anomalía/fraude en curso'),
    ('0220209', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0220301', 'Imposible gestionar por falta de acceso al cliente'),
    ('0230101', 'Favorable'),
    ('0230201', 'Desfavorable con explicación de motivos en texto resultado '),
    ('0230202', 'No legitimada. Relación extracontractual.'),
    ('0230301', 'Imposible localizar al cliente'),
    ('0240101', 'Favorable. Se corrige o resarcen daños.'),
    ('0240201', 'Desfavorable con explicación de motivos en texto resultado '),
    ('0240202', 'No legitimada. Relación extracontractual.'),
    ('0240203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0250101', 'Se corrige la situación'),
    ('0250201', 'Instalación correcta'),
    ('0250202', 'No legitimada. Relación extracontractual'),
    ('0250203', 'Instalación ajena a la distribuidora'),
    ('0250204', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0250301', 'Imposible gestionar por faltar datos'),
    ('0260101', 'Corregimos situación'),
    ('0260201', 'Instalación correcta'),
    ('0260202', 'No legitimada. Relación extracontractual'),
    ('0260203', 'Instalación ajena a la distribuidora'),
    ('0260204', 'Expediente por anomalía/fraude en curso'),
    ('0260205', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0270101', 'Se corrige importe y se traslada al comercializador'),
    ('0270201', 'Cálculo y pago '),
    ('0270202', 'Cálculo correcto. No procede el abono'),
    ('0270203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0280101', 'Se reestablece el suministro'),
    ('0280102', 'Se reestablece el suministro con indemnización'),
    ('0280201', 'Corte correcto por solicitud del comercializador'),
    ('0280202', 'Corte correcto por cualquier motivo reconocido en la '
                'normativa vigente'),
    ('0280203', 'No existe corte realizado'),
    ('0280204', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0290101', 'Se indemniza incumplimiento de calidad de atención en '
                'próxima factura.'),
    ('0290201', 'Reclamación atendida en plazo'),
    ('0290202', 'Retraso imputable cliente/comercializadora'),
    ('0290203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0300101', 'Se indemniza incumplimiento de calidad de atención en '
                'próxima factura.'),
    ('0300201', 'Solicitud de información NNSS atendida en plazo'),
    ('0300202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0310101', 'Se indemniza incumplimiento de calidad de atención en '
                'próxima factura.'),
    ('0310201', 'Ejecución de NNSS atendido en plazo'),
    ('0310202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0320101', 'Se indemniza incumplimiento de calidad de atención en '
                'próxima factura'),
    ('0320201', 'Reconexión atendida en plazo'),
    ('0320202', 'Incumplimiento por causa imputable al cliente '),
    ('0320203', 'Plazo superado por motivos ajenos a la distribuidora '
                '(indicar motivo)'),
    ('0320204', 'Imposible ejecutar reenganche por causa ajena'),
    ('0320205', 'Expediente por anomalía/fraude en curso'),
    ('0320206', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0330101', 'Se indemniza'),
    ('0330201', 'No se han producido daños'),
    ('0330202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0330301', 'No corresponde a distribuidora'),
    ('0330302', 'Cliente no aporta la información necesaria'),
    ('0340101', 'Corregido parámetro '),
    ('0340102', 'Corregido parámetro potencia'),
    ('0340103', 'Corregido parámetro tensión'),
    ('0340104', 'Corregido parámetro tarifa'),
    ('0340105', 'Corregido parámetro caudal'),
    ('0340106', 'Corregido parámetro fecha activación'),
    ('0340107', 'Corregido parámetro dirección'),
    ('0340108', 'Corregido parámetro titular'),
    ('0340201', 'Contratación realizada según solicitud'),
    ('0340202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0340203', 'No existe solicitud'),
    ('0350101', 'Problema resuelto, reenviar solicitud.'),
    ('0350201', 'Solicitud correctamente rechazada.'),
    ('0350202', 'Imposible contactar con cliente'),
    ('0350203', 'Deficiencias en la instalación'),
    ('0350204', 'Falta documentación (CIE)'),
    ('0350205', 'Error de formato'),
    ('0350206', 'Datos ATR/ Peaje incoherentes'),
    ('0350207', 'Error en el cliente/NIF'),
    ('0350208', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0350209', 'No existe solicitud'),
    ('0360101', 'Se refactura con lectura aportada'),
    ('0360201', 'Lectura con integradores incorrectos '),
    ('0360202', 'Lectura anterior a la última real '),
    ('0360203', 'El suministro se liquida con curva de carga'),
    ('0360204', 'Periodo ajeno a esa comercializadora'),
    ('0360205', 'Estimacion superior a un año'),
    ('0360206', 'Lectura aportada adelantada'),
    ('0360207', 'Lectura aportada errónea '),
    ('0360208', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0370101', 'Se republica fichero'),
    ('0370201', 'Fichero correcto'),
    ('0370202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0380101', 'Alta/ baja cliente Robinson. Se modifican datos del cliente'),
    ('0380201', 'Cliente no consta en la base de datos'),
    ('0380202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0400101', 'Se envía duplicado solicitado'),
    ('0400201', 'No es posible enviar duplicado. (motivos en texto resultado)'),
    ('0400202', 'Periodo ajeno a esa comercializadora'),
    ('0400203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0450101', 'Dirección actualizada'),
    ('0450201', 'No procede, explicación en campo resultado'),
    ('0460101', 'Procede'),
    ('0460201', 'No procede, explicación en campo resultado'),
    ('0480101', 'Aclaración enviada'),
    ('0480201', 'No existe rechazo'),
    ('0480202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0480203', 'No existe solicitud'),
    ('0490101', 'Enviado fichero'),
    ('0490201', 'No existe fichero'),
    ('0490202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0500101', 'Se refactura el concepto reclamado'),
    ('0500201', 'Conceptos reclamados correctamente facturados '
                '(incluir explicación en campo comentarios)'),
    ('0500202', 'Inspección realizada'),
    ('0500203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0510101', 'Comportamiento técnico inadecuado'),
    ('0510201', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0520101', 'Inspección incompleta'),
    ('0520102', 'Inspección no realizada correctamente'),
    ('0520201', 'Inspección realizada correctamente'),
    ('0520202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0530101', 'Visita fallida'),
    ('0530102', 'Retraso en visita'),
    ('0530201', 'Visita en horario acordado'),
    ('0530202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0540101', 'Daños ocasionados en la instalación'),
    ('0540201', 'No procede indemnización'),
    ('0540202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0570101', 'Expediente anulado'),
    ('0570102', 'Expediente rectificado'),
    ('0570103', 'El cliente aporta documentación que justifica suministro '
                'sin actividad'),
    ('0570104', 'Error en periodo de recuperación'),
    ('0570105', 'Retraso en contratación con nuevo titular distinto del '
                'titular del expediente.'),
    ('0570201', 'Expediente correcto según normativa'),
    ('0570202', 'La distribuidora aporta prueba que justifican el '
                'expediente abierto'),
    ('0570203', 'No regularizado por impedimento del cliente'),
    ('0570204', 'El cliente no aporta documentación que justifica suministro '
                'sin actividad'),
    ('0570205', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0580101', 'Se gestiona la publicación del paso'),
    ('0580102', 'Movimiento realizado fuera de plazo'),
    ('0580201', 'No existe solicitud'),
    ('0580202', 'Movimiento realizado en plazo'),
    ('0580203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0590101', 'Se gestiona la publicación del paso'),
    ('0590102', 'Movimiento realizado fuera de plazo'),
    ('0590201', 'No existe solicitud'),
    ('0590202', 'Movimiento realizado en plazo'),
    ('0590203', 'Movimiento fuera de plazo imputable al cliente'),
    ('0590204', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0600101', 'Se gestiona la publicación del paso'),
    ('0600102', 'Movimiento realizado fuera de plazo'),
    ('0600201', 'No existe solicitud'),
    ('0600202', 'Movimiento realizado en plazo'),
    ('0600203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0610101', 'Se gestiona la publicación del paso'),
    ('0610102', 'Movimiento realizado fuera de plazo'),
    ('0610201', 'No existe solicitud'),
    ('0610202', 'Movimiento realizado en plazo'),
    ('0610203', 'Movimiento fuera de plazo imputable al cliente'),
    ('0610204', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0620101', 'Se gestiona la publicación del paso'),
    ('0620102', 'Movimiento realizado fuera de plazo'),
    ('0620201', 'No existe solicitud'),
    ('0620202', 'Movimiento realizado en plazo'),
    ('0620203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0630101', 'Se gestiona la publicación del paso'),
    ('0630102', 'Movimiento realizado fuera de plazo'),
    ('0630201', 'No existe solicitud'),
    ('0630202', 'Movimiento realizado en plazo'),
    ('0630203', 'Movimiento fuera de plazo imputable al cliente'),
    ('0630204', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0640101', 'Se gestiona la publicación del paso'),
    ('0640102', 'Movimiento realizado fuera de plazo'),
    ('0640201', 'No existe solicitud'),
    ('0640202', 'Movimiento realizado en plazo'),
    ('0640203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0650101', 'Se gestiona la publicación del paso'),
    ('0650102', 'Movimiento realizado fuera de plazo'),
    ('0650201', 'No existe solicitud'),
    ('0650202', 'Movimiento realizado en plazo'),
    ('0650203', 'Movimiento fuera de plazo imputable al cliente'),
    ('0650204', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0660101', 'Corregido parámetro'),
    ('0660102', 'Corregido parámetro potencia'),
    ('0660103', 'Corregido parámetro tensión'),
    ('0660104', 'Corregido parámetro tarifa'),
    ('0660105', 'Corregido parámetro caudal'),
    ('0660106', 'Corregido parámetro fecha activación'),
    ('0660107', 'Corregido parámetro dirección'),
    ('0660108', 'Corregido parámetro titular'),
    ('0660201', 'Contratación realizada según solicitud'),
    ('0660202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0670101', 'Equipo incorrecto. Incluye equipo desaparecido.'),
    ('0670102', 'Instalación incorrecta. Incluye relación de transformación'),
    ('0670103', 'Lectura errónea'),
    ('0670104', 'Contador parado'),
    ('0670105', 'Error programación EDM'),
    ('0670106', 'ICP inadecuado para la potencia contratada'),
    ('0670201', 'Equipo correcto'),
    ('0670202', 'Instalación correcta'),
    ('0670203', 'Histórico de consumos / lecturas coherente.'),
    ('0670204', 'Detectada anomalía en visita'),
    ('0670205', 'Expediente por anomalía en curso'),
    ('0670206', 'Elemento externo responsabilidad de cliente'),
    ('0670207', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0670301', 'No se localiza al cliente'),
    ('0670302', 'No corresponde a distribuidora. '),
    ('0670303', 'Cliente no aporta información adicional.'),
    ('0670304', 'Acceso denegado'),
    ('0670305', 'Visita anulada por cliente'),
    ('0680101', 'Se factura con PCS corregido'),
    ('0680201', 'PCS reclamado correctamente aplicado. '
                'Se adjunta explicación en comentarios.'),
    ('0680202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0700101', 'Procedente. Se agiliza trámite de reclamación'),
    ('0700201', 'Retraso imputable al cliente/comercializador'),
    ('0700202', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0710101', 'Se gestiona la publicación del paso'),
    ('0710102', 'Movimiento realizado fuera de plazo'),
    ('0710201', 'No existe solicitud'),
    ('0710202', 'Movimiento realizado en plazo'),
    ('0710203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0720101', 'Se gestiona la publicación del paso'),
    ('0720102', 'Procedente. Se agiliza trámite de desistimiento'),
    ('0720201', 'No existe solicitud'),
    ('0720202', 'Movimiento retrasado imputable al cliente. Se adjunta explicación en comentarios'),
    ('0720203', 'Improcedente. Se adjunta explicación en comentarios'),
    ('0740101', 'Se gestiona la publicación del paso'),
    ('0740102', 'Movimiento realizado fuera de plazo'),
    ('0740201', 'No existe solicitud'),
    ('0740202', 'Movimiento realizado en plazo'),
    ('0740203', 'Movimiento fuera de plazo imputable al cliente'),
    ('0740204', 'Improcedente. Se adjunta explicación en comentarios.'),
]
TAULA_RESULTADO_RECLAMACION = [
    ('01', 'Procedente / Favorable'),
    ('02', 'Improcedente / Desfavorable'),
    ('03', 'No gestionable'),
    ('05', 'Duplicada'),
]
TAULA_TIPO_INFORMACION_ADICIONAL = [
    ('01', 'Factura reparación'),
    ('02', 'Nuevos Datos de Contacto'),
    ('03', 'Documento oficial'),
    ('04', 'Contacto y documentos'),
    ('05', 'IBAN'),
    ('06', 'Información mínima incoherente'),
]
TAULA_TIPO_VARIABLE_APORTACION_INFORMACION = [
    ('01', 'Nuevo teléfono de contacto'),
    ('02', 'Nueva persona de contacto'),
    ('03', 'Nuevo email de contacto'),
    ('04', 'IBAN'),
]
TAULA_TIPO_INFORMACION_ADICIONAL_APORTADA = [
    ('01', 'A iniciativa del comercializador.'),
    ('02', 'Respuesta a Solicitud de Más Información'),
    ('03', 'Respuesta a Solicitud de información necesaria para retipificar'),
]
TAULA_PRIORIDAD = [
    ('0', 'Prioridad normal.'),
    ('1', 'Prioridad alta. '),
]

REFUND_RECTIFICATIVE_TYPES = ['A', 'B']  # 'R' ?

REQUIRE_REFERENCE_TYPES = [
    'A', 'B', 'R'
]

SIGN = {'N': 1, 'R': 1, 'A': -1, 'B': -1}

TIPUS_CONCEPTES = {
    '0000': 'informacio',
    '0001': 'informacio',
    '0002': 'informacio',
    '0003': 'lloguer',
    # '0004': 'altres',
    # '0005': 'altres',
    # '0006': 'altres',
    '0007': 'informacio',
    '0008': 'impost',
    '0009': 'informacio',
    '0010': 'impost',
    '0011': 'informacio',
    '0012': 'lloguer',
    '0013': 'lloguer',
    '0014': 'lloguer',
    # '0015': 'altres',
    '0016': 'tfixe',
    '0017': 'tvariable',
    '1212': 'demora',  # Es diferent perque no te impostos, s'ha de tractar per separat
    # '****': 'altres'
}

SUBTYPES_A1_48 = SUBTYPES_R101[:]

TAULA_TIPO_COMUNICACION_A12_26 = [
    ('01', "Corrección de errores puntuales"),
    ('05', "Actualización de datos: denominación de las calles, errores en los datos del cliente..."),
    ('06', "Reubicación tarifaria"),
]

TAULA_TIPO_COMUNICACION_A19_45 = [
    ('08', "Comunicación de fecha y resultado de las inspecciones periódicas"),
    ('09', "Comunicación de cortes y reinicios de actuación derivadas de inspección."),
    ('10', "Comunicación de cortes y reinicios de actuaciones en campo derivadas de operaciones de emergencias"),
    ('11', "Comunicación de actuación a petición del consumidor."),
]

TAULA_TIPO_COMUNICACION_A12_24 = [
    ('01', "Corrección de errores puntuales"),
    ('07', "Migración (excepcionalmente debido a movimientos societarios)"),
    ('13', "Comunicación de baja de un contrato de acceso en un punto de suministros susceptible de ser traspasado a la CUR cuando éste rechaza el traspaso"),
]

CONVERSION_TIPOVIA_GAS_ELEC = {
    'ACCE':'AC',
    'ACCES':'AC',
    'ACEQ':'OV',
    'ACERA':'OV',
    'ALAM':'AL',
    'ALDAP':'OV',
    'ALDEA':'AD',
    'ALQUE':'OV',
    'ALTO':'OV',
    'ANDAD':'OV',
    'ANGTA':'OV',
    'APTES':'OV',
    'APTOS':'OV',
    'ARB':'OV',
    'ARRAL':'AR',
    'ARRY':'OV',
    'ASSEG':'OV',
    'ATAJO':'OV',
    'ATAL':'OV',
    'ATALL':'OV',
    'ATZUC':'OV',
    'AUTO':'AU',
    'AUZO':'OV',
    'AUZOT':'OV',
    'AUZUN':'OV',
    'AV':'AV',
    'AVDA':'AV',
    'AVGDA':'AV',
    'AVIA':'AU',
    'BARDA':'BD',
    'BARRI':'BO',
    'BARRO':'BO',
    'BDA':'OV',
    'BELNA':'OV',
    'BIDE':'OV',
    'BIDEB':'OV',
    'BJADA':'OV',
    'BLQUE':'BL',
    'BRANC':'BC',
    'BRDLA':'OV',
    'BRZAL':'OV',
    'BULEV':'OV',
    'BV':'OV',
    'C':'CL',
    'C.H.':'CN',
    'C.N.':'CN',
    'C.V.':'CN',
    'C/':'CL',
    'CÑADA':'OV',
    'CALLE':'CL',
    'CAMI':'CN',
    'CAMIN':'CN',
    'CAMPA':'OV',
    'CANÑO':'OV',
    'CANAL':'OV',
    'CANT':'OV',
    'CANTO':'OV',
    'CARRA':'OV',
    'CARRE':'CL',
    'CARRY':'OV',
    'CBTIZ':'OV',
    'CELLA':'OV',
    'CERRO':'OV',
    'CINT':'OV',
    'CINY':'OV',
    'CIRCU':'OV',
    'CJLA':'OV',
    'CJTO':'OV',
    'CLEYA':'OV',
    'CLLJA':'CJ',
    'CLLON':'CF',
    'CLLZO':'OV',
    'CLYON':'OV',
    'CMÑO':'OV',
    'CMNO':'CN',
    'COL':'CA',
    'COMPJ':'CM',
    'COMPX':'CM',
    'COSTA':'OV',
    'CRA':'OV',
    'CRLLO':'OV',
    'CRO':'OV',
    'CRRAL':'OV',
    'CRRCI':'OV',
    'CRRDA':'OV',
    'CRRDE':'OV',
    'CRRDO':'OV',
    'CRRIL':'CI',
    'CRRLO':'OV',
    'CRROL':'OV',
    'CRTIL':'OV',
    'CRTJO':'OV',
    'CSRIO':'OV',
    'CSTAN':'OV',
    'CTRA':'CR',
    'CTRIN':'CR',
    'CUSTA':'CT',
    'CXON':'CF',
    'CXTO':'OV',
    'CZADA':'OV',
    'CZADS':'OV',
    'DEMAR':'OV',
    'DRERA':'OV',
    'EIRAD':'OV',
    'ENTD':'EN',
    'EPTZA':'OV',
    'ERREB':'OV',
    'ERREK':'OV',
    'ERREP':'OV',
    'ERRIB':'OV',
    'ESCA':'OV',
    'ESCAL':'OV',
    'ESLDA':'OV',
    'ESTDA':'OV',
    'ETDEA':'OV',
    'ETXAD':'OV',
    'ETXAR':'OV',
    'ETXAT':'OV',
    'EXPLA':'OV',
    'EXTRM':'OV',
    'EXTRR':'DI',
    'FALDA':'OV',
    'FINCA':'FC',
    'G.V.':'OV',
    'GAIN':'OV',
    'GALE':'OV',
    'GORAB':'OV',
    'GRUP':'GR',
    'GRUPO':'GR',
    'GTA':'GL',
    'HEGI':'OV',
    'HIRIB':'OV',
    'HONDA':'OV',
    'HOYA':'OV',
    'IBILB':'OV',
    'ILLA':'OV',
    'INDA':'OV',
    'JARD':'OV',
    'JDIN':'OV',
    'JDINS':'OV',
    'KAI':'OV',
    'KALE':'CL',
    'KARIK':'OV',
    'KARRE':'OV',
    'KARRI':'OV',
    'KOSTA':'OV',
    'KRRIL':'CI',
    'LAGO':'OV',
    'LASTE':'OV',
    'LDERA':'OV',
    'LEKU':'OV',
    'LLOC':'OV',
    'LOMA':'OV',
    'LORAK':'OV',
    'LORAT':'OV',
    'LUGAR':'LG',
    'MALEC':'OV',
    'MAZO':'OV',
    'MENDI':'OV',
    'MIRAD':'OV',
    'MOLL':'MU',
    'MONTE':'OV',
    'MUELL':'OV',
    'ONDAR':'OV',
    'PAGO':'OV',
    'PARC':'PA',
    'PARKE':'PA',
    'PARTI':'OV',
    'PAS':'OV',
    'PASAI':'OV',
    'PASEA':'OV',
    'PASEO':'PE',
    'PBDO':'PB',
    'PDA':'OV',
    'PDIS':'OV',
    'PG':'PE',
    'PINAR':'OV',
    'PISTA':'OV',
    'PJDA':'OV',
    'PL':'OV',
    'PLA':'OV',
    'PLAÇA':'PZ',
    'PLAYA':'PY',
    'PLAZA':'PZ',
    'PLCET':'OV',
    'PLLO':'OV',
    'PLZLA':'OV',
    'PNTE':'OV',
    'POLIG':'PO',
    'PONT':'OV',
    'PONTE':'OV',
    'PORT':'OV',
    'PQUE':'PA',
    'PRAÑA':'OV',
    'PRAGE':'PJ',
    'PRAIA':'OV',
    'PRAJE':'PJ',
    'PRAZA':'OV',
    'PROL':'PR',
    'PSAJE':'PS',
    'PSAXE':'PS',
    'PTDA':'PD',
    'PTGE':'PS',
    'PTLLO':'OV',
    'PZO':'OV',
    'PZTA':'PT',
    'RABAL':'OV',
    'RACDA':'OV',
    'RACO':'OV',
    'RAMAL':'OV',
    'RAMPA':'OV',
    'RAMPS':'OV',
    'RAVAL':'OV',
    'RBLA':'RA',
    'RBRA':'OV',
    'RCDA':'OV',
    'RCON':'OV',
    'RENTO':'OV',
    'RIERA':'OV',
    'RONDA':'RD',
    'RTDA':'OV',
    'RUA':'OV',
    'RUELA':'OV',
    'RUERO':'OV',
    'SARBI':'OV',
    'SBIDA':'OV',
    'SECT':'OV',
    'SEDER':'OV',
    'SEDRA':'OV',
    'SEKT':'OV',
    'SEND':'OV',
    'SENDA':'SD',
    'SVTIA':'OV',
    'TALDE':'OV',
    'TOKI':'LG',
    'TRANS':'OV',
    'TRAS':'OV',
    'TRAV':'TR',
    'TRRNT':'OV',
    'TRSSI':'TR',
    'TRVA':'TR',
    'TRVAL':'OV',
    'URB':'UR',
    'URBAT':'UR',
    'URBAZ':'UR',
    'VALLE':'OV',
    'VCTO':'OV',
    'VEGA':'OV',
    'VENAT':'OV',
    'VENLA':'OV',
    'VIA':'OV',
    'VIAL':'VI',
    'VIANY':'OV',
    'VREDA':'OV',
    'XDIN':'OV',
    'ZEHAR':'OV',
    'ZONA':'ZN',
    'ZUBI':'OV',
    'ZUHAI':'OV',
    'ZUMAR':'OV',
}