import logging

# we need to explicitly set a handler for the logging module to be happy
handler = logging.StreamHandler()
logging.getLogger("ossapi").addHandler(handler)
from importlib import metadata

from ossapi.ossapi import (
    OssapiV1,
    ReplayUnavailableException,
    InvalidKeyException,
    APIException,
)
from ossapi.ossapiv2 import Ossapi, Grant, Scope, Domain
from ossapi.models import (
    Beatmap,
    BeatmapCompact,
    BeatmapUserScore,
    ForumTopicAndPosts,
    Search,
    CommentBundle,
    Cursor,
    Score,
    BeatmapsetSearchResult,
    ModdingHistoryEventsBundle,
    User,
    Rankings,
    BeatmapScores,
    KudosuHistory,
    Beatmapset,
    BeatmapPlaycount,
    Spotlight,
    Spotlights,
    WikiPage,
    _Event,
    Event,
    BeatmapsetDiscussionPosts,
    Build,
    ChangelogListing,
    MultiplayerScores,
    BeatmapsetDiscussionVotes,
    CreatePMResponse,
    BeatmapsetDiscussions,
    UserCompact,
    BeatmapsetCompact,
    ForumPoll,
    Room,
    RoomPlaylistItem,
    RoomPlaylistItemMod,
    RoomLeaderboardScore,
    RoomLeaderboardUserScore,
    RoomLeaderboard,
    Match,
    Matches,
    MatchResponse,
    ScoreMatchInfo,
    MatchGame,
    MatchEventDetail,
    MatchEvent,
    ScoringType,
    TeamType,
    StatisticsVariant,
    Events,
    BeatmapPack,
    BeatmapPacks,
)
from ossapi.enums import (
    GameMode,
    ScoreType,
    RankingFilter,
    RankingType,
    UserBeatmapType,
    BeatmapDiscussionPostSort,
    UserLookupKey,
    BeatmapsetEventType,
    CommentableType,
    CommentSort,
    ForumTopicSort,
    SearchMode,
    MultiplayerScoresSort,
    BeatmapsetDiscussionVote,
    BeatmapsetDiscussionVoteSort,
    BeatmapsetStatus,
    MessageType,
    BeatmapsetSearchCategory,
    BeatmapsetSearchMode,
    BeatmapsetSearchExplicitContent,
    BeatmapsetSearchLanguage,
    BeatmapsetSearchGenre,
    NewsPostKey,
    BeatmapsetSearchSort,
    RoomType,
    RoomCategory,
    RoomSearchMode,
    MatchEventType,
    Variant,
    EventsSort,
    Statistics,
    Availability,
    Hype,
    Nominations,
    Nomination,
    Kudosu,
    KudosuGiver,
    KudosuPost,
    KudosuVote,
    EventUser,
    EventBeatmap,
    EventBeatmapset,
    EventAchivement,
    GithubUser,
    ChangelogSearch,
    NewsSearch,
    ForumPostBody,
    ForumPollText,
    ForumPollTitle,
    ReviewsConfig,
    RankHighest,
    UserMonthlyPlaycount,
    UserPage,
    UserLevel,
    UserGradeCounts,
    UserReplaysWatchedCount,
    UserProfileCustomization,
    RankHistory,
    Weight,
    Covers,
    UserGroup,
    GroupDescription,
    UserBadge,
    UserAccountHistory,
    ProfileBanner,
    Cover,
    Country,
    Ranking,
    Failtimes,
    BeatmapPackType,
    BeatmapPackUserCompletionData,
)
from ossapi.mod import Mod
from ossapi.replay import Replay
from ossapi.encoder import ModelEncoder, serialize_model
from ossapi.ossapiv2_async import OssapiAsync

from oauthlib.oauth2 import AccessDeniedError, TokenExpiredError
from oauthlib.oauth2.rfc6749.errors import InsufficientScopeError

__version__ = metadata.version(__package__)

__all__ = [
    # OssapiV1
    "OssapiV1",
    "ReplayUnavailableException",
    "InvalidKeyException",
    "APIException",
    # OssapiV2 core
    "Ossapi",
    "OssapiAsync",
    "Grant",
    "Scope",
    "Domain",
    # OssapiV2 models
    "Beatmap",
    "BeatmapCompact",
    "BeatmapUserScore",
    "ForumTopicAndPosts",
    "Search",
    "CommentBundle",
    "Cursor",
    "Score",
    "BeatmapsetSearchResult",
    "ModdingHistoryEventsBundle",
    "User",
    "Rankings",
    "BeatmapScores",
    "KudosuHistory",
    "Beatmapset",
    "BeatmapPlaycount",
    "Spotlight",
    "Spotlights",
    "WikiPage",
    "_Event",
    "Event",
    "BeatmapsetDiscussionPosts",
    "Build",
    "ChangelogListing",
    "MultiplayerScores",
    "BeatmapsetDiscussionVotes",
    "CreatePMResponse",
    "BeatmapsetDiscussions",
    "UserCompact",
    "BeatmapsetCompact",
    "ForumPoll",
    "Room",
    "RoomPlaylistItem",
    "RoomPlaylistItemMod",
    "RoomLeaderboardScore",
    "RoomLeaderboardUserScore",
    "RoomLeaderboard",
    "Match",
    "Matches",
    "MatchResponse",
    "ScoreMatchInfo",
    "MatchGame",
    "MatchEventDetail",
    "MatchEvent",
    "StatisticsVariant",
    "Events",
    "BeatmapPack",
    "BeatmapPacks",
    # OssapiV2 enums
    "GameMode",
    "ScoreType",
    "RankingFilter",
    "RankingType",
    "UserBeatmapType",
    "BeatmapDiscussionPostSort",
    "UserLookupKey",
    "BeatmapsetEventType",
    "CommentableType",
    "CommentSort",
    "ForumTopicSort",
    "SearchMode",
    "MultiplayerScoresSort",
    "BeatmapsetDiscussionVote",
    "BeatmapsetDiscussionVoteSort",
    "BeatmapsetStatus",
    "MessageType",
    "BeatmapsetSearchCategory",
    "BeatmapsetSearchMode",
    "BeatmapsetSearchExplicitContent",
    "BeatmapsetSearchLanguage",
    "BeatmapsetSearchGenre",
    "NewsPostKey",
    "BeatmapsetSearchSort",
    "RoomType",
    "RoomCategory",
    "RoomSearchMode",
    "MatchEventType",
    "ScoringType",
    "TeamType",
    "Variant",
    "EventsSort",
    "NewsSearch",
    "RankHighest",
    "Weight",
    "Statistics",
    "Availability",
    "Hype",
    "Nominations",
    "Nomination",
    "Kudosu",
    "KudosuGiver",
    "KudosuPost",
    "KudosuVote",
    "EventUser",
    "EventBeatmap",
    "EventBeatmapset",
    "EventAchivement",
    "GithubUser",
    "ChangelogSearch",
    "ForumPostBody",
    "ForumPollText",
    "ForumPollTitle",
    "ReviewsConfig",
    "UserMonthlyPlaycount",
    "UserPage",
    "UserLevel",
    "UserGradeCounts",
    "UserReplaysWatchedCount",
    "UserProfileCustomization",
    "RankHistory",
    "Covers",
    "UserGroup",
    "GroupDescription",
    "UserBadge",
    "UserAccountHistory",
    "ProfileBanner",
    "Cover",
    "Country",
    "Ranking",
    "Failtimes",
    "BeatmapPackType",
    "BeatmapPackUserCompletionData",
    # OssapiV2 exceptions
    "AccessDeniedError",
    "TokenExpiredError",
    "InsufficientScopeError",
    # misc
    "Mod",
    "Replay",
    "__version__",
    "ModelEncoder",
    "serialize_model",
]
