import { Construct } from 'constructs';
import { CrossRegionParameterProps } from './props';
export declare enum OnEvent {
    ON_CREATE = "onCreate",
    ON_UPDATE = "onUpdate",
    ON_DELETE = "onDelete"
}
/** Cross-Region SSM Parameter. */
export declare class CrossRegionParameter extends Construct {
    /**
     * Define a new Cross-Region SSM Parameter.
     *
     * @example
     * new CrossRegionParameter(this, 'SayHiToSweden', {
     *   region: 'eu-north-1',
     *   name: '/parameter/path/message',
     *   description: 'Some message for the Swedes',
     *   value: 'Hej då!',
     * });
     */
    constructor(scope: Construct, name: string, props: CrossRegionParameterProps);
    private definePhysicalResourceId;
    private defineCreateUpdateSdkCall;
    /** Ensure Parameter target region is not the same as the current "source" region. */
    private validateRegion;
    /** Convert CDK/JSII compatible TagPropList to SDK compatible TagList. */
    private tagPropsToTagParams;
    private defineDeleteSdkCall;
    private definePolicy;
}
