import os
import pytz

if os.getenv('QUOTESAGGREGATOR_DB_HOST') is None:
    print("It is not possible to run the program without all the defined environment variables:")
    print("QUOTESAGGREGATOR_DB_HOST, QUOTESAGGREGATOR_DB_PORT, QUOTESAGGREGATOR_DB_USER, "
          "QUOTESAGGREGATOR_DB_PASSWORD, QUOTESAGGREGATOR_DB_NAME")
    os.abort()

URI = "wss://api2.poloniex.com"
COMMAND = '{"command": "subscribe", "channel": 1002}'
DB_HOST = os.getenv('QUOTESAGGREGATOR_DB_HOST')
DB_PORT = os.getenv('QUOTESAGGREGATOR_DB_PORT')
DB_USER = os.getenv('QUOTESAGGREGATOR_DB_USER')
DB_PASSWORD = os.getenv('QUOTESAGGREGATOR_DB_PASSWORD')
DB_NAME = os.getenv('QUOTESAGGREGATOR_DB_NAME')

# Set timezone
TIMEZONE = pytz.timezone('America/Sao_Paulo')

# Currency list
# Comment or remove item to remove currency
currency_pair = {336: "BNB_BTC",
                 462: "BTC_AAVE",
                 438: "BTC_AKRO",
                 451: "BTC_AMP",
                 177: "BTC_ARDR",
                 253: "BTC_ATOM",
                 324: "BTC_AVA",
                 210: "BTC_BAT",
                 475: "BTC_BCH",
                 464: "BTC_BCHA",
                 238: "BTC_BCHSV",
                 468: "BTC_BID",
                 232: "BTC_BNT",
                 14: "BTC_BTS",
                 333: "BTC_CHR",
                 194: "BTC_CVC",
                 24: "BTC_DASH",
                 162: "BTC_DCR",
                 27: "BTC_DOGE",
                 496: "BTC_DOT",
                 201: "BTC_EOS",
                 171: "BTC_ETC",
                 148: "BTC_ETH",
                 266: "BTC_ETHBNT",
                 382: "BTC_EXE",
                 494: "BTC_FARM",
                 414: "BTC_FCT2",
                 246: "BTC_FOAM",
                 489: "BTC_FRONT",
                 432: "BTC_FUND",
                 317: "BTC_FXC",
                 544: "BTC_FIL",
                 198: "BTC_GAS",
                 482: "BTC_GLM",
                 436: "BTC_HGET",
                 473: "BTC_INJ",
                 207: "BTC_KNC",
                 553: "BTC_KLV",
                 351: "BTC_LEND",
                 275: "BTC_LINK",
                 213: "BTC_LOOM",
                 250: "BTC_LPT",
                 355: "BTC_LRC",
                 163: "BTC_LSK",
                 50: "BTC_LTC",
                 229: "BTC_MANA",
                 295: "BTC_MATIC",
                 342: "BTC_MDT",
                 302: "BTC_MKR",
                 309: "BTC_NEO",
                 248: "BTC_NMR",
                 69: "BTC_NXT",
                 196: "BTC_OMG",
                 249: "BTC_POLY",
                 221: "BTC_QTUM",
                 353: "BTC_REN",
                 445: "BTC_REPV2",
                 454: "BTC_SAND",
                 150: "BTC_SC",
                 478: "BTC_SENSO",
                 204: "BTC_SNT",
                 290: "BTC_SNX",
                 168: "BTC_STEEM",
                 200: "BTC_STORJ",
                 369: "BTC_STPT",
                 89: "BTC_STR",
                 379: "BTC_SWAP",
                 312: "BTC_SWFTC",
                 403: "BTC_SWINGBY",
                 364: "BTC_SXP",
                 523: "BTC_TRU",
                 263: "BTC_TRX",
                 514: "BTC_TUSD",
                 486: "BTC_WBTC",
                 359: "BTC_WRX",
                 112: "BTC_XEM",
                 114: "BTC_XMR",
                 117: "BTC_XRP",
                 277: "BTC_XTZ",
                 178: "BTC_ZEC",
                 192: "BTC_ZRX",
                 340: "BUSD_BNB",
                 341: "BUSD_BTC",
                 306: "DAI_BTC",
                 307: "DAI_ETH",
                 358: "ETH_BAL",
                 211: "ETH_BAT",
                 190: "ETH_BCH",
                 347: "ETH_COMP",
                 202: "ETH_EOS",
                 172: "ETH_ETC",
                 515: "ETH_TUSD",
                 179: "ETH_ZEC",
                 193: "ETH_ZRX",
                 284: "PAX_BTC",
                 285: "PAX_ETH",
                 453: "TRX_AMP",
                 326: "TRX_AVA",
                 339: "TRX_BNB",
                 538: "TRX_BRG",
                 271: "TRX_BTT",
                 335: "TRX_CHR",
                 267: "TRX_ETH",
                 431: "TRX_FUND",
                 319: "TRX_FXC",
                 316: "TRX_JST",
                 553: "TRX_KLV",
                 276: "TRX_LINK",
                 297: "TRX_MATIC",
                 344: "TRX_MDT",
                 311: "TRX_NEO",
                 422: "TRX_PEARL",
                 292: "TRX_SNX",
                 274: "TRX_STEEM",
                 371: "TRX_STPT",
                 498: "TRX_SUN",
                 314: "TRX_SWFTC",
                 405: "TRX_SWINGBY",
                 366: "TRX_SXP",
                 420: "TRX_TAI",
                 535: "TRX_VSP",
                 273: "TRX_WIN",
                 361: "TRX_WRX",
                 268: "TRX_XRP",
                 279: "TRX_XTZ",
                 527: "TUSD_BTC",
                 528: "TUSD_ETH",
                 254: "USDC_ATOM",
                 477: "USDC_BCH",
                 239: "USDC_BCHSV",
                 224: "USDC_BTC",
                 256: "USDC_DASH",
                 243: "USDC_DOGE",
                 257: "USDC_EOS",
                 258: "USDC_ETC",
                 225: "USDC_ETH",
                 252: "USDC_GRIN",
                 244: "USDC_LTC",
                 242: "USDC_STR",
                 264: "USDC_TRX",
                 513: "USDC_TUSD",
                 226: "USDC_USDT",
                 241: "USDC_XMR",
                 240: "USDC_XRP",
                 245: "USDC_ZEC",
                 288: "USDJ_BTC",
                 323: "USDJ_BTT",
                 289: "USDJ_TRX",
                 463: "USDT_AAVE",
                 516: "USDT_ADABEAR",
                 517: "USDT_ADABULL",
                 540: "USDT_ADD",
                 439: "USDT_ADEL",
                 437: "USDT_AKRO",
                 529: "USDT_ALPHA",
                 452: "USDT_AMP",
                 423: "USDT_ANK",
                 491: "USDT_API3",
                 255: "USDT_ATOM",
                 325: "USDT_AVA",
                 550: "USDT_AKITA",
                 504: "USDT_BAC",
                 493: "USDT_BADGER",
                 357: "USDT_BAL",
                 387: "USDT_BAND",
                 212: "USDT_BAT",
                 476: "USDT_BCH",
                 465: "USDT_BCHA",
                 298: "USDT_BCHBEAR",
                 299: "USDT_BCHBULL",
                 345: "USDT_BCHC",
                 259: "USDT_BCHSV",
                 320: "USDT_BCN",
                 539: "USDT_BDP",
                 280: "USDT_BEAR",
                 469: "USDT_BID",
                 401: "USDT_BLY",
                 337: "USDT_BNB",
                 509: "USDT_BOND",
                 457: "USDT_BREE",
                 537: "USDT_BRG",
                 293: "USDT_BSVBEAR",
                 294: "USDT_BSVBULL",
                 121: "USDT_BTC",
                 270: "USDT_BTT",
                 281: "USDT_BULL",
                 338: "USDT_BUSD",
                 304: "USDT_BVOL",
                 363: "USDT_BZRX",
                 542: "USDT_BTCST",
                 551: "USDT_B20",
                 334: "USDT_CHR",
                 511: "USDT_COMBO",
                 346: "USDT_COMP",
                 427: "USDT_CORN",
                 433: "USDT_CREAM",
                 425: "USDT_CRT",
                 397: "USDT_CRV",
                 508: "USDT_CUDOS",
                 350: "USDT_CUSDT",
                 443: "USDT_CVP",
                 308: "USDT_DAI",
                 122: "USDT_DASH",
                 374: "USDT_DEC",
                 395: "USDT_DEXT",
                 262: "USDT_DGB",
                 441: "USDT_DHT",
                 389: "USDT_DIA",
                 216: "USDT_DOGE",
                 388: "USDT_DOS",
                 407: "USDT_DOT",
                 561: "USDT_DEGO",
                 203: "USDT_EOS",
                 330: "USDT_EOSBEAR",
                 329: "USDT_EOSBULL",
                 500: "USDT_ESD",
                 173: "USDT_ETC",
                 149: "USDT_ETH",
                 300: "USDT_ETHBEAR",
                 301: "USDT_ETHBULL",
                 383: "USDT_EXE",
                 563: "USDT_ELON",
                 495: "USDT_FARM",
                 413: "USDT_FCT2",
                 490: "USDT_FRONT",
                 429: "USDT_FSW",
                 524: "USDT_FTT",
                 430: "USDT_FUND",
                 318: "USDT_FXC",
                 545: "USDT_FIL",
                 562: "USDT_FORTH",
                 385: "USDT_GEEQ",
                 444: "USDT_GHST",
                 483: "USDT_GLM",
                 261: "USDT_GRIN",
                 497: "USDT_GRT",
                 484: "USDT_HEGIC",
                 435: "USDT_HGET",
                 305: "USDT_IBVOL",
                 474: "USDT_INJ",
                 424: "USDT_JFI",
                 315: "USDT_JST",
                 480: "USDT_KP3R",
                 377: "USDT_KTON",
                 541: "USDT_KCS",
                 552: "USDT_KLV",
                 352: "USDT_LEND",
                 322: "USDT_LINK",
                 332: "USDT_LINKBEAR",
                 331: "USDT_LINKBULL",
                 526: "USDT_LPT",
                 505: "USDT_LON",
                 356: "USDT_LRC",
                 218: "USDT_LSK",
                 123: "USDT_LTC",
                 518: "USDT_LTCBEAR",
                 519: "USDT_LTCBULL",
                 548: "USDT_LIVE",
                 555: "USDT_LQTY",
                 556: "USDT_LUSD",
                 231: "USDT_MANA",
                 296: "USDT_MATIC",
                 396: "USDT_MCB",
                 343: "USDT_MDT",
                 442: "USDT_MEME",
                 448: "USDT_MEXP",
                 303: "USDT_MKR",
                 481: "USDT_MPH",
                 367: "USDT_MTA",
                 559: "USDT_MIR",
                 564: "USDT_MIST",
                 310: "USDT_NEO",
                 488: "USDT_NU",
                 558: "USDT_NFTX",
                 400: "USDT_OCEAN",
                 399: "USDT_OM",
                 501: "USDT_ONEINCH",
                 402: "USDT_OPT",
                 286: "USDT_PAX",
                 510: "USDT_PBTC35A",
                 421: "USDT_PEARL",
                 392: "USDT_PERX",
                 460: "USDT_POLS",
                 406: "USDT_PRQ",
                 223: "USDT_QTUM",
                 566: "USDT_QUICK",
                 447: "USDT_RARI",
                 502: "USDT_REEF",
                 354: "USDT_REN",
                 446: "USDT_REPV2",
                 456: "USDT_RFUEL",
                 378: "USDT_RING",
                 411: "USDT_RSR",
                 426: "USDT_SAL",
                 455: "USDT_SAND",
                 219: "USDT_SC",
                 479: "USDT_SENSO",
                 291: "USDT_SNX",
                 525: "USDT_SRM",
                 362: "USDT_STAKE",
                 321: "USDT_STEEM",
                 370: "USDT_STPT",
                 125: "USDT_STR",
                 434: "USDT_SUN",
                 415: "USDT_SUSHI",
                 380: "USDT_SWAP",
                 313: "USDT_SWFTC",
                 404: "USDT_SWINGBY",
                 428: "USDT_SWRV",
                 365: "USDT_SXP",
                 543: "USDT_SFI",
                 549: "USDT_SHIB",
                 419: "USDT_TAI",
                 381: "USDT_TEND",
                 384: "USDT_TRADE",
                 393: "USDT_TRB",
                 507: "USDT_TRU",
                 265: "USDT_TRX",
                 282: "USDT_TRXBEAR",
                 283: "USDT_TRXBULL",
                 512: "USDT_TUSD",
                 376: "USDT_UMA",
                 440: "USDT_UNI",
                 287: "USDT_USDJ",
                 560: "USDT_UST",
                 458: "USDT_VALUE",
                 534: "USDT_VSP",
                 487: "USDT_WBTC",
                 522: "USDT_WETH",
                 272: "USDT_WIN",
                 412: "USDT_WNXM",
                 360: "USDT_WRX",
                 557: "USDT_WHALE",
                 499: "USDT_XFLR",
                 520: "USDT_XLMBEAR",
                 521: "USDT_XLMBULL",
                 126: "USDT_XMR",
                 127: "USDT_XRP",
                 328: "USDT_XRPBEAR",
                 327: "USDT_XRPBULL",
                 278: "USDT_XTZ",
                 565: "USDT_XOR",
                 368: "USDT_YFI",
                 416: "USDT_YFII",
                 418: "USDT_YFL",
                 390: "USDT_ZAP",
                 180: "USDT_ZEC",
                 531: "USDT_ZKS",
                 485: "USDT_ZLOT",
                 220: "USDT_ZRX"
                 }
