# Generated by Django 3.2.8 on 2021-10-25 08:52

from django.db import migrations, models
import newsletter.generator.models


def newsletter_subscription(apps, schema):
    """
    Convert User.newsletter_accepted to Subscription.subscribed
    and
    User.partner.code to Subscription.newsletter.code
    """
    User = apps.get_model('user', 'User')
    Newsletter = apps.get_model('newsletter', 'Newsletter')
    Subscription = apps.get_model('newsletter', 'Subscription')
    Site = apps.get_model('sites', 'Site')
    if User.objects.exists():
        site = Site.objects.first()
    for user in User.objects.all():
        partner_code = getattr(user.partners.first(), 'code', 'default')
        newsletter = Newsletter.objects.get_or_create(
            slug=partner_code,
            defaults={
                'title': partner_code,
                #'site': site,
            }
        )[0]
        newsletter.site.add(site)
        Subscription.objects.get_or_create(
            newsletter=newsletter,
            user=user,
            defaults={
                'subscribed': user.old_newsletter_accepted,
            }
        )


class Migration(migrations.Migration):

    dependencies = [
        ('newsletter', '0008_longer_subscription_name'),
        ('user', '0010_rename_newsletter_accepted_user_old_newsletter_accepted'),
    ]

    operations = [
        migrations.AddField(
            model_name='newsletter',
            name='footer_template_html',
            field=models.TextField(blank=True, default=newsletter.generator.models.default_html, null=True, verbose_name='Footer Template (HTML)'),
        ),
        migrations.AddField(
            model_name='newsletter',
            name='footer_template_text',
            field=models.TextField(blank=True, default=newsletter.generator.models.default_text, null=True, verbose_name='Footer Template (Text)'),
        ),
        migrations.RunPython(newsletter_subscription, migrations.RunPython.noop),
    ]
