# AUTOGENERATED! DO NOT EDIT! File to edit: ../02_utils.ipynb.

# %% auto 0
__all__ = ['HEADERS', 'av_recommend', 'get_name', 'create_directory', 'deleteMp4', 'deleteM3u8', 'mergeMp4', 'scrape',
           'prepareCrawl', 'startCrawl', 'get_cover', 'better_format', 'av_download']

# %% ../02_utils.ipynb 2
import re
import os
import copy
import m3u8
import requests

# %% ../02_utils.ipynb 3
from bs4 import BeautifulSoup
from urllib.request import Request, urlopen
import cloudscraper
import urllib.request
from Crypto.Cipher import AES
from functools import partial
import concurrent.futures
from tqdm import tqdm
import ffmpeg

# %% ../02_utils.ipynb 4
HEADERS = {
    'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.97 Safari/537.36',
    }

# %% ../02_utils.ipynb 5
def av_recommend(vtype='hot'):
    headers = HEADERS

    if vtype == 'all':
        url = 'https://jable.tv/'
    elif vtype == 'hot':
        url = 'https://jable.tv/hot/'
    elif vtype == 'new':
        url = 'https://jable.tv/new-release/'
    else:
        raise ValueError('vtype must be all, hot or new')
    request = Request(url, headers=HEADERS)
    web_content = urlopen(request).read()
    soup = BeautifulSoup(web_content, 'html.parser')
    h6_tags = soup.find_all('h6', class_='title')
    av_list = re.findall(r'https://jable.tv/videos[^"]+', str(h6_tags))
    return av_list

# %% ../02_utils.ipynb 7
def get_name(url):
    dir_name = os.path.basename(os.path.dirname(url))
    return dir_name




# %% ../02_utils.ipynb 9
def create_directory(path):
    if not os.path.exists(path):
        os.makedirs(path,exist_ok=True)



# %% ../02_utils.ipynb 11
def deleteMp4(folderPath):
    files = os.listdir(folderPath)
    originFile = folderPath.split(os.path.sep)[-1] + '.mp4'
    for f in files:
        if f != originFile:
            os.remove(os.path.join(folderPath, f))


def deleteM3u8(folderPath):
    files = os.listdir(folderPath)
    for f in files:
        if f.endswith('.m3u8'):
            os.remove(os.path.join(folderPath, f))


# %% ../02_utils.ipynb 12
def mergeMp4(folderPath, tsList,tmp_mp4):
    video_name = folderPath.split(os.path.sep)[-1]
    with open(tmp_mp4, 'ab') as fout:
        for i in range(len(tsList)):
            f = tsList[i].split('/')[-1][0:-3] + '.mp4'
            full_path = os.path.join(folderPath, f)
            if os.path.exists(full_path):
                with open(full_path, 'rb') as fin:
                    fout.write(fin.read())
            else:
                raise FileNotFoundError(f + " 失敗 ")
  



# %% ../02_utils.ipynb 13
def _scrape(ci,folder_path,url):
    file_name = url.split(os.path.sep)[-1][0:-3]+'.mp4'
    file_path = f'{folder_path}/{file_name}'
    response = requests.get(url, headers=HEADERS, timeout=10)
    while response.status_code != 200:
        response = requests.get(url, headers=HEADERS, timeout=10)
    content_ts = response.content

    if ci:
        content_ts = ci.decrypt(content_ts)
    with open(f'{file_path}', 'ab') as f:
        f.write(content_ts)

def scrape(args):
    ci,folder_path,url = args
    _scrape(ci,folder_path,url)

def prepareCrawl(ci, folder_path, tsList,max_workers):
    downloadList = copy.deepcopy(tsList)
    startCrawl(ci, folder_path, downloadList,max_workers)




def startCrawl(ci, folder_path, downloadList,max_workers=8):
    with concurrent.futures.ThreadPoolExecutor(max_workers=max_workers) as executor:
        list(tqdm(executor.map(scrape, [(ci,folder_path,i) for i in downloadList]),desc='Downloading',total=len(downloadList)))
                                
     



# %% ../02_utils.ipynb 14
def get_cover(html_file, folder_path):
  # get cover
  soup = BeautifulSoup(html_file.text, "html.parser")
  cover_name = f"{os.path.basename(folder_path)}.jpg"
  cover_path = os.path.join(folder_path, cover_name)
  for meta in soup.find_all("meta"):
      meta_content = meta.get("content")
      if not meta_content:
          continue
      if "preview.jpg" not in meta_content:
          continue
      try:
          r = requests.get(meta_content)
          with open(cover_path, "wb") as cover_fh:
              r.raw.decode_content = True
              for chunk in r.iter_content(chunk_size=1024):
                  if chunk:
                      cover_fh.write(chunk)
      except Exception as e:
          print(f"unable to download cover: {e}")




# %% ../02_utils.ipynb 15
def better_format(tmp_mp4,final_mp4,threads=12):
    (
        ffmpeg
        .input(tmp_mp4)
        .output(final_mp4,vcodec='libx264', preset='veryfast', vb='3M',threads=threads)
        .run()
    )

# %% ../02_utils.ipynb 16
def av_download(av_url, directory='./',max_workers=10):
    htmlfile = cloudscraper.create_scraper(browser={
        'browser':'firefox',
        'mobile':False,
        'platform':'windows',

    },delay=10).get(av_url)
    dir_name = get_name(av_url)
    create_directory(os.path.join(directory, dir_name))
    folder_path = os.path.join(directory, dir_name)
    result = re.search("https://.+m3u8", htmlfile.text)
    m3u8url = result[0]
    m3u8urlList = m3u8url.split('/')
    m3u8urlList.pop(-1)
    downloadurl = '/'.join(m3u8urlList)
    m3u8file = os.path.join(directory, dir_name + '.m3u8')
    urllib.request.urlretrieve(m3u8url, m3u8file)
    m3u8obj = m3u8.load(m3u8file)
    m3u8uri = ''
    m3u8iv = ''

    for key in m3u8obj.keys:
        if key:
            m3u8uri = key.uri
            m3u8iv = key.iv

    # 儲存 ts網址 in tsList
    tsList = []
    for seg in m3u8obj.segments:
        tsUrl = downloadurl + '/' + seg.uri
        tsList.append(tsUrl)

    tsList = []
    for seg in m3u8obj.segments:
        tsUrl = downloadurl + '/' + seg.uri
        tsList.append(tsUrl)

    if m3u8uri:
        m3u8keyurl = downloadurl + '/' + m3u8uri  # 得到 key 的網址

        # 得到 key的內容
        response = requests.get(m3u8keyurl, headers=HEADERS, timeout=10)
        contentKey = response.content

        vt = m3u8iv.replace("0x", "")[:16].encode()  # IV取前16位

        ci = AES.new(contentKey, AES.MODE_CBC, vt)  # 建構解碼器
    else:
        ci = ''
    deleteM3u8(folder_path)
    os.remove(m3u8file)
    prepareCrawl(ci, folder_path, tsList,max_workers)
    tmp_mp4 = os.path.join(folder_path, 'tmp.mp4')
    final_mp4 = os.path.join(folder_path, f'{dir_name}.mp4')
    mergeMp4(folder_path, tsList,tmp_mp4)
    better_format(tmp_mp4,final_mp4)
    deleteMp4(folder_path)
    os.remove(tmp_mp4)
    get_cover(html_file=htmlfile, folder_path=folder_path)
