# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'API',
    'Calico',
    'Config',
    'ContainerImage',
    'ControllerManager',
    'DualStack',
    'Etcd',
    'Hook',
    'Hooks',
    'Host',
    'Images',
    'ImagesCalico',
    'ImagesKubeRouter',
    'InstallConfig',
    'InstallConfigUsers',
    'K0s',
    'K0sSpec',
    'Kine',
    'Konnectivity',
    'KubeProxy',
    'KubeRouter',
    'Localhost',
    'Metadata',
    'Network',
    'PodSecurityPolicy',
    'SSH',
    'Scheduler',
    'Spec',
    'Storage',
    'Telemetry',
    'UploadFile',
    'WinRM',
]

@pulumi.output_type
class API(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalAddress":
            suggest = "external_address"
        elif key == "extraArgs":
            suggest = "extra_args"
        elif key == "k0sApiPort":
            suggest = "k0s_api_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in API. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        API.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        API.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 external_address: Optional[str] = None,
                 extra_args: Optional[Mapping[str, str]] = None,
                 k0s_api_port: Optional[float] = None,
                 port: Optional[float] = None,
                 sans: Optional[Sequence[str]] = None):
        if address is not None:
            pulumi.set(__self__, "address", address)
        if external_address is not None:
            pulumi.set(__self__, "external_address", external_address)
        if extra_args is not None:
            pulumi.set(__self__, "extra_args", extra_args)
        if k0s_api_port is not None:
            pulumi.set(__self__, "k0s_api_port", k0s_api_port)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if sans is not None:
            pulumi.set(__self__, "sans", sans)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="externalAddress")
    def external_address(self) -> Optional[str]:
        return pulumi.get(self, "external_address")

    @property
    @pulumi.getter(name="extraArgs")
    def extra_args(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "extra_args")

    @property
    @pulumi.getter(name="k0sApiPort")
    def k0s_api_port(self) -> Optional[float]:
        return pulumi.get(self, "k0s_api_port")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def sans(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "sans")


@pulumi.output_type
class Calico(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flexVolumeDriverPath":
            suggest = "flex_volume_driver_path"
        elif key == "ipAutodetectionMethod":
            suggest = "ip_autodetection_method"
        elif key == "vxlanPort":
            suggest = "vxlan_port"
        elif key == "vxlanVNI":
            suggest = "vxlan_vni"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Calico. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Calico.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Calico.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flex_volume_driver_path: Optional[str] = None,
                 ip_autodetection_method: Optional[str] = None,
                 mode: Optional[str] = None,
                 mtu: Optional[float] = None,
                 overlay: Optional[str] = None,
                 vxlan_port: Optional[float] = None,
                 vxlan_vni: Optional[float] = None,
                 wireguard: Optional[bool] = None):
        if flex_volume_driver_path is not None:
            pulumi.set(__self__, "flex_volume_driver_path", flex_volume_driver_path)
        if ip_autodetection_method is not None:
            pulumi.set(__self__, "ip_autodetection_method", ip_autodetection_method)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if overlay is not None:
            pulumi.set(__self__, "overlay", overlay)
        if vxlan_port is not None:
            pulumi.set(__self__, "vxlan_port", vxlan_port)
        if vxlan_vni is not None:
            pulumi.set(__self__, "vxlan_vni", vxlan_vni)
        if wireguard is not None:
            pulumi.set(__self__, "wireguard", wireguard)

    @property
    @pulumi.getter(name="flexVolumeDriverPath")
    def flex_volume_driver_path(self) -> Optional[str]:
        return pulumi.get(self, "flex_volume_driver_path")

    @property
    @pulumi.getter(name="ipAutodetectionMethod")
    def ip_autodetection_method(self) -> Optional[str]:
        return pulumi.get(self, "ip_autodetection_method")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def mtu(self) -> Optional[float]:
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter
    def overlay(self) -> Optional[str]:
        return pulumi.get(self, "overlay")

    @property
    @pulumi.getter(name="vxlanPort")
    def vxlan_port(self) -> Optional[float]:
        return pulumi.get(self, "vxlan_port")

    @property
    @pulumi.getter(name="vxlanVNI")
    def vxlan_vni(self) -> Optional[float]:
        return pulumi.get(self, "vxlan_vni")

    @property
    @pulumi.getter
    def wireguard(self) -> Optional[bool]:
        return pulumi.get(self, "wireguard")


@pulumi.output_type
class Config(dict):
    def __init__(__self__, *,
                 metadata: Optional['outputs.Metadata'] = None,
                 spec: Optional['outputs.K0sSpec'] = None):
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> Optional['outputs.Metadata']:
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> Optional['outputs.K0sSpec']:
        return pulumi.get(self, "spec")


@pulumi.output_type
class ContainerImage(dict):
    def __init__(__self__, *,
                 image: Optional[str] = None,
                 version: Optional[str] = None):
        if image is not None:
            pulumi.set(__self__, "image", image)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class ControllerManager(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extraArgs":
            suggest = "extra_args"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControllerManager. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControllerManager.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControllerManager.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extra_args: Optional[Mapping[str, str]] = None):
        if extra_args is not None:
            pulumi.set(__self__, "extra_args", extra_args)

    @property
    @pulumi.getter(name="extraArgs")
    def extra_args(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "extra_args")


@pulumi.output_type
class DualStack(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "IPv6podCIDR":
            suggest = "i_pv6pod_cidr"
        elif key == "IPv6serviceCIDR":
            suggest = "i_pv6service_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DualStack. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DualStack.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DualStack.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 i_pv6pod_cidr: Optional[str] = None,
                 i_pv6service_cidr: Optional[str] = None,
                 enabled: Optional[bool] = None):
        if i_pv6pod_cidr is not None:
            pulumi.set(__self__, "i_pv6pod_cidr", i_pv6pod_cidr)
        if i_pv6service_cidr is not None:
            pulumi.set(__self__, "i_pv6service_cidr", i_pv6service_cidr)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="IPv6podCIDR")
    def i_pv6pod_cidr(self) -> Optional[str]:
        return pulumi.get(self, "i_pv6pod_cidr")

    @property
    @pulumi.getter(name="IPv6serviceCIDR")
    def i_pv6service_cidr(self) -> Optional[str]:
        return pulumi.get(self, "i_pv6service_cidr")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class Etcd(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "peerAddress":
            suggest = "peer_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Etcd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Etcd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Etcd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 peer_address: Optional[str] = None):
        if peer_address is not None:
            pulumi.set(__self__, "peer_address", peer_address)

    @property
    @pulumi.getter(name="peerAddress")
    def peer_address(self) -> Optional[str]:
        return pulumi.get(self, "peer_address")


@pulumi.output_type
class Hook(dict):
    def __init__(__self__, *,
                 after: Optional[Sequence[str]] = None,
                 before: Optional[Sequence[str]] = None):
        if after is not None:
            pulumi.set(__self__, "after", after)
        if before is not None:
            pulumi.set(__self__, "before", before)

    @property
    @pulumi.getter
    def after(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "after")

    @property
    @pulumi.getter
    def before(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "before")


@pulumi.output_type
class Hooks(dict):
    def __init__(__self__, *,
                 apply: Optional['outputs.Hook'] = None,
                 backup: Optional['outputs.Hook'] = None,
                 reset: Optional['outputs.Hook'] = None):
        if apply is not None:
            pulumi.set(__self__, "apply", apply)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if reset is not None:
            pulumi.set(__self__, "reset", reset)

    @property
    @pulumi.getter
    def apply(self) -> Optional['outputs.Hook']:
        return pulumi.get(self, "apply")

    @property
    @pulumi.getter
    def backup(self) -> Optional['outputs.Hook']:
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter
    def reset(self) -> Optional['outputs.Hook']:
        return pulumi.get(self, "reset")


@pulumi.output_type
class Host(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "installFlags":
            suggest = "install_flags"
        elif key == "k0sBinaryPath":
            suggest = "k0s_binary_path"
        elif key == "noTaints":
            suggest = "no_taints"
        elif key == "privateAddress":
            suggest = "private_address"
        elif key == "privateInterface":
            suggest = "private_interface"
        elif key == "uploadBinary":
            suggest = "upload_binary"
        elif key == "winRM":
            suggest = "win_rm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Host. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Host.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Host.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role: str,
                 environment: Optional[Mapping[str, str]] = None,
                 files: Optional[Sequence['outputs.UploadFile']] = None,
                 hooks: Optional['outputs.Hooks'] = None,
                 hostname: Optional[str] = None,
                 install_flags: Optional[Sequence[str]] = None,
                 k0s_binary_path: Optional[str] = None,
                 localhost: Optional['outputs.Localhost'] = None,
                 no_taints: Optional[bool] = None,
                 os: Optional[str] = None,
                 private_address: Optional[str] = None,
                 private_interface: Optional[str] = None,
                 ssh: Optional['outputs.SSH'] = None,
                 upload_binary: Optional[bool] = None,
                 win_rm: Optional['outputs.WinRM'] = None):
        pulumi.set(__self__, "role", role)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if hooks is not None:
            pulumi.set(__self__, "hooks", hooks)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if install_flags is not None:
            pulumi.set(__self__, "install_flags", install_flags)
        if k0s_binary_path is not None:
            pulumi.set(__self__, "k0s_binary_path", k0s_binary_path)
        if localhost is not None:
            pulumi.set(__self__, "localhost", localhost)
        if no_taints is not None:
            pulumi.set(__self__, "no_taints", no_taints)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if private_address is not None:
            pulumi.set(__self__, "private_address", private_address)
        if private_interface is not None:
            pulumi.set(__self__, "private_interface", private_interface)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)
        if upload_binary is not None:
            pulumi.set(__self__, "upload_binary", upload_binary)
        if win_rm is not None:
            pulumi.set(__self__, "win_rm", win_rm)

    @property
    @pulumi.getter
    def role(self) -> str:
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def files(self) -> Optional[Sequence['outputs.UploadFile']]:
        return pulumi.get(self, "files")

    @property
    @pulumi.getter
    def hooks(self) -> Optional['outputs.Hooks']:
        return pulumi.get(self, "hooks")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="installFlags")
    def install_flags(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "install_flags")

    @property
    @pulumi.getter(name="k0sBinaryPath")
    def k0s_binary_path(self) -> Optional[str]:
        return pulumi.get(self, "k0s_binary_path")

    @property
    @pulumi.getter
    def localhost(self) -> Optional['outputs.Localhost']:
        return pulumi.get(self, "localhost")

    @property
    @pulumi.getter(name="noTaints")
    def no_taints(self) -> Optional[bool]:
        return pulumi.get(self, "no_taints")

    @property
    @pulumi.getter
    def os(self) -> Optional[str]:
        return pulumi.get(self, "os")

    @property
    @pulumi.getter(name="privateAddress")
    def private_address(self) -> Optional[str]:
        return pulumi.get(self, "private_address")

    @property
    @pulumi.getter(name="privateInterface")
    def private_interface(self) -> Optional[str]:
        return pulumi.get(self, "private_interface")

    @property
    @pulumi.getter
    def ssh(self) -> Optional['outputs.SSH']:
        return pulumi.get(self, "ssh")

    @property
    @pulumi.getter(name="uploadBinary")
    def upload_binary(self) -> Optional[bool]:
        return pulumi.get(self, "upload_binary")

    @property
    @pulumi.getter(name="winRM")
    def win_rm(self) -> Optional['outputs.WinRM']:
        return pulumi.get(self, "win_rm")


@pulumi.output_type
class Images(dict):
    def __init__(__self__, *,
                 calico: Optional['outputs.ImagesCalico'] = None,
                 coredns: Optional['outputs.ContainerImage'] = None,
                 default_pull_policy: Optional[str] = None,
                 konnectivity: Optional['outputs.ContainerImage'] = None,
                 kubeproxy: Optional['outputs.ContainerImage'] = None,
                 kuberouter: Optional['outputs.ImagesKubeRouter'] = None,
                 metricsserver: Optional['outputs.ContainerImage'] = None):
        if calico is not None:
            pulumi.set(__self__, "calico", calico)
        if coredns is not None:
            pulumi.set(__self__, "coredns", coredns)
        if default_pull_policy is not None:
            pulumi.set(__self__, "default_pull_policy", default_pull_policy)
        if konnectivity is not None:
            pulumi.set(__self__, "konnectivity", konnectivity)
        if kubeproxy is not None:
            pulumi.set(__self__, "kubeproxy", kubeproxy)
        if kuberouter is not None:
            pulumi.set(__self__, "kuberouter", kuberouter)
        if metricsserver is not None:
            pulumi.set(__self__, "metricsserver", metricsserver)

    @property
    @pulumi.getter
    def calico(self) -> Optional['outputs.ImagesCalico']:
        return pulumi.get(self, "calico")

    @property
    @pulumi.getter
    def coredns(self) -> Optional['outputs.ContainerImage']:
        return pulumi.get(self, "coredns")

    @property
    @pulumi.getter
    def default_pull_policy(self) -> Optional[str]:
        return pulumi.get(self, "default_pull_policy")

    @property
    @pulumi.getter
    def konnectivity(self) -> Optional['outputs.ContainerImage']:
        return pulumi.get(self, "konnectivity")

    @property
    @pulumi.getter
    def kubeproxy(self) -> Optional['outputs.ContainerImage']:
        return pulumi.get(self, "kubeproxy")

    @property
    @pulumi.getter
    def kuberouter(self) -> Optional['outputs.ImagesKubeRouter']:
        return pulumi.get(self, "kuberouter")

    @property
    @pulumi.getter
    def metricsserver(self) -> Optional['outputs.ContainerImage']:
        return pulumi.get(self, "metricsserver")


@pulumi.output_type
class ImagesCalico(dict):
    def __init__(__self__, *,
                 cni: Optional['outputs.ContainerImage'] = None,
                 kubecontrollers: Optional['outputs.ContainerImage'] = None,
                 node: Optional['outputs.ContainerImage'] = None):
        if cni is not None:
            pulumi.set(__self__, "cni", cni)
        if kubecontrollers is not None:
            pulumi.set(__self__, "kubecontrollers", kubecontrollers)
        if node is not None:
            pulumi.set(__self__, "node", node)

    @property
    @pulumi.getter
    def cni(self) -> Optional['outputs.ContainerImage']:
        return pulumi.get(self, "cni")

    @property
    @pulumi.getter
    def kubecontrollers(self) -> Optional['outputs.ContainerImage']:
        return pulumi.get(self, "kubecontrollers")

    @property
    @pulumi.getter
    def node(self) -> Optional['outputs.ContainerImage']:
        return pulumi.get(self, "node")


@pulumi.output_type
class ImagesKubeRouter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cniInstaller":
            suggest = "cni_installer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImagesKubeRouter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImagesKubeRouter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImagesKubeRouter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cni: Optional['outputs.ContainerImage'] = None,
                 cni_installer: Optional['outputs.ContainerImage'] = None):
        if cni is not None:
            pulumi.set(__self__, "cni", cni)
        if cni_installer is not None:
            pulumi.set(__self__, "cni_installer", cni_installer)

    @property
    @pulumi.getter
    def cni(self) -> Optional['outputs.ContainerImage']:
        return pulumi.get(self, "cni")

    @property
    @pulumi.getter(name="cniInstaller")
    def cni_installer(self) -> Optional['outputs.ContainerImage']:
        return pulumi.get(self, "cni_installer")


@pulumi.output_type
class InstallConfig(dict):
    def __init__(__self__, *,
                 users: Optional['outputs.InstallConfigUsers'] = None):
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def users(self) -> Optional['outputs.InstallConfigUsers']:
        return pulumi.get(self, "users")


@pulumi.output_type
class InstallConfigUsers(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "etcdUser":
            suggest = "etcd_user"
        elif key == "kineUser":
            suggest = "kine_user"
        elif key == "konnectivityUser":
            suggest = "konnectivity_user"
        elif key == "kubeAPIserverUser":
            suggest = "kube_apiserver_user"
        elif key == "kubeSchedulerUser":
            suggest = "kube_scheduler_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstallConfigUsers. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstallConfigUsers.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstallConfigUsers.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etcd_user: Optional[str] = None,
                 kine_user: Optional[str] = None,
                 konnectivity_user: Optional[str] = None,
                 kube_apiserver_user: Optional[str] = None,
                 kube_scheduler_user: Optional[str] = None):
        if etcd_user is not None:
            pulumi.set(__self__, "etcd_user", etcd_user)
        if kine_user is not None:
            pulumi.set(__self__, "kine_user", kine_user)
        if konnectivity_user is not None:
            pulumi.set(__self__, "konnectivity_user", konnectivity_user)
        if kube_apiserver_user is not None:
            pulumi.set(__self__, "kube_apiserver_user", kube_apiserver_user)
        if kube_scheduler_user is not None:
            pulumi.set(__self__, "kube_scheduler_user", kube_scheduler_user)

    @property
    @pulumi.getter(name="etcdUser")
    def etcd_user(self) -> Optional[str]:
        return pulumi.get(self, "etcd_user")

    @property
    @pulumi.getter(name="kineUser")
    def kine_user(self) -> Optional[str]:
        return pulumi.get(self, "kine_user")

    @property
    @pulumi.getter(name="konnectivityUser")
    def konnectivity_user(self) -> Optional[str]:
        return pulumi.get(self, "konnectivity_user")

    @property
    @pulumi.getter(name="kubeAPIserverUser")
    def kube_apiserver_user(self) -> Optional[str]:
        return pulumi.get(self, "kube_apiserver_user")

    @property
    @pulumi.getter(name="kubeSchedulerUser")
    def kube_scheduler_user(self) -> Optional[str]:
        return pulumi.get(self, "kube_scheduler_user")


@pulumi.output_type
class K0s(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dynamicConfig":
            suggest = "dynamic_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in K0s. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        K0s.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        K0s.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: Optional['outputs.Config'] = None,
                 dynamic_config: Optional[bool] = None,
                 version: Optional[str] = None):
        if config is not None:
            pulumi.set(__self__, "config", config)
        if dynamic_config is not None:
            pulumi.set(__self__, "dynamic_config", dynamic_config)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def config(self) -> Optional['outputs.Config']:
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="dynamicConfig")
    def dynamic_config(self) -> Optional[bool]:
        return pulumi.get(self, "dynamic_config")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class K0sSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "controllerManager":
            suggest = "controller_manager"
        elif key == "installConfig":
            suggest = "install_config"
        elif key == "podSecurityPolicy":
            suggest = "pod_security_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in K0sSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        K0sSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        K0sSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api: Optional['outputs.API'] = None,
                 controller_manager: Optional['outputs.ControllerManager'] = None,
                 images: Optional['outputs.Images'] = None,
                 install_config: Optional['outputs.InstallConfig'] = None,
                 konnectivity: Optional['outputs.Konnectivity'] = None,
                 network: Optional['outputs.Network'] = None,
                 pod_security_policy: Optional['outputs.PodSecurityPolicy'] = None,
                 scheduler: Optional['outputs.Scheduler'] = None,
                 storage: Optional['outputs.Storage'] = None,
                 telemetry: Optional['outputs.Telemetry'] = None):
        if api is not None:
            pulumi.set(__self__, "api", api)
        if controller_manager is not None:
            pulumi.set(__self__, "controller_manager", controller_manager)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if install_config is not None:
            pulumi.set(__self__, "install_config", install_config)
        if konnectivity is not None:
            pulumi.set(__self__, "konnectivity", konnectivity)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if pod_security_policy is not None:
            pulumi.set(__self__, "pod_security_policy", pod_security_policy)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if telemetry is not None:
            pulumi.set(__self__, "telemetry", telemetry)

    @property
    @pulumi.getter
    def api(self) -> Optional['outputs.API']:
        return pulumi.get(self, "api")

    @property
    @pulumi.getter(name="controllerManager")
    def controller_manager(self) -> Optional['outputs.ControllerManager']:
        return pulumi.get(self, "controller_manager")

    @property
    @pulumi.getter
    def images(self) -> Optional['outputs.Images']:
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="installConfig")
    def install_config(self) -> Optional['outputs.InstallConfig']:
        return pulumi.get(self, "install_config")

    @property
    @pulumi.getter
    def konnectivity(self) -> Optional['outputs.Konnectivity']:
        return pulumi.get(self, "konnectivity")

    @property
    @pulumi.getter
    def network(self) -> Optional['outputs.Network']:
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="podSecurityPolicy")
    def pod_security_policy(self) -> Optional['outputs.PodSecurityPolicy']:
        return pulumi.get(self, "pod_security_policy")

    @property
    @pulumi.getter
    def scheduler(self) -> Optional['outputs.Scheduler']:
        return pulumi.get(self, "scheduler")

    @property
    @pulumi.getter
    def storage(self) -> Optional['outputs.Storage']:
        return pulumi.get(self, "storage")

    @property
    @pulumi.getter
    def telemetry(self) -> Optional['outputs.Telemetry']:
        return pulumi.get(self, "telemetry")


@pulumi.output_type
class Kine(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSource":
            suggest = "data_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Kine. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Kine.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Kine.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source: str):
        pulumi.set(__self__, "data_source", data_source)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> str:
        return pulumi.get(self, "data_source")


@pulumi.output_type
class Konnectivity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPort":
            suggest = "admin_port"
        elif key == "agentPort":
            suggest = "agent_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Konnectivity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Konnectivity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Konnectivity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_port: Optional[float] = None,
                 agent_port: Optional[float] = None):
        if admin_port is not None:
            pulumi.set(__self__, "admin_port", admin_port)
        if agent_port is not None:
            pulumi.set(__self__, "agent_port", agent_port)

    @property
    @pulumi.getter(name="adminPort")
    def admin_port(self) -> Optional[float]:
        return pulumi.get(self, "admin_port")

    @property
    @pulumi.getter(name="agentPort")
    def agent_port(self) -> Optional[float]:
        return pulumi.get(self, "agent_port")


@pulumi.output_type
class KubeProxy(dict):
    def __init__(__self__, *,
                 disabled: Optional[bool] = None,
                 mode: Optional[str] = None):
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        return pulumi.get(self, "mode")


@pulumi.output_type
class KubeRouter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoMTU":
            suggest = "auto_mtu"
        elif key == "peerRouterASNs":
            suggest = "peer_router_asns"
        elif key == "peerRouterIPs":
            suggest = "peer_router_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubeRouter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubeRouter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubeRouter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_mtu: Optional[bool] = None,
                 mtu: Optional[float] = None,
                 peer_router_asns: Optional[str] = None,
                 peer_router_ips: Optional[str] = None):
        if auto_mtu is not None:
            pulumi.set(__self__, "auto_mtu", auto_mtu)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if peer_router_asns is not None:
            pulumi.set(__self__, "peer_router_asns", peer_router_asns)
        if peer_router_ips is not None:
            pulumi.set(__self__, "peer_router_ips", peer_router_ips)

    @property
    @pulumi.getter(name="autoMTU")
    def auto_mtu(self) -> Optional[bool]:
        return pulumi.get(self, "auto_mtu")

    @property
    @pulumi.getter
    def mtu(self) -> Optional[float]:
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter(name="peerRouterASNs")
    def peer_router_asns(self) -> Optional[str]:
        return pulumi.get(self, "peer_router_asns")

    @property
    @pulumi.getter(name="peerRouterIPs")
    def peer_router_ips(self) -> Optional[str]:
        return pulumi.get(self, "peer_router_ips")


@pulumi.output_type
class Localhost(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class Metadata(dict):
    def __init__(__self__, *,
                 name: str):
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


@pulumi.output_type
class Network(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dualStack":
            suggest = "dual_stack"
        elif key == "kubeProxy":
            suggest = "kube_proxy"
        elif key == "podCIDR":
            suggest = "pod_cidr"
        elif key == "serviceCIDR":
            suggest = "service_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Network. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Network.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Network.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 calico: Optional['outputs.Calico'] = None,
                 dual_stack: Optional['outputs.DualStack'] = None,
                 kube_proxy: Optional['outputs.KubeProxy'] = None,
                 kuberouter: Optional['outputs.KubeRouter'] = None,
                 pod_cidr: Optional[str] = None,
                 provider: Optional[str] = None,
                 service_cidr: Optional[str] = None):
        if calico is not None:
            pulumi.set(__self__, "calico", calico)
        if dual_stack is not None:
            pulumi.set(__self__, "dual_stack", dual_stack)
        if kube_proxy is not None:
            pulumi.set(__self__, "kube_proxy", kube_proxy)
        if kuberouter is not None:
            pulumi.set(__self__, "kuberouter", kuberouter)
        if pod_cidr is not None:
            pulumi.set(__self__, "pod_cidr", pod_cidr)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)
        if service_cidr is not None:
            pulumi.set(__self__, "service_cidr", service_cidr)

    @property
    @pulumi.getter
    def calico(self) -> Optional['outputs.Calico']:
        return pulumi.get(self, "calico")

    @property
    @pulumi.getter(name="dualStack")
    def dual_stack(self) -> Optional['outputs.DualStack']:
        return pulumi.get(self, "dual_stack")

    @property
    @pulumi.getter(name="kubeProxy")
    def kube_proxy(self) -> Optional['outputs.KubeProxy']:
        return pulumi.get(self, "kube_proxy")

    @property
    @pulumi.getter
    def kuberouter(self) -> Optional['outputs.KubeRouter']:
        return pulumi.get(self, "kuberouter")

    @property
    @pulumi.getter(name="podCIDR")
    def pod_cidr(self) -> Optional[str]:
        return pulumi.get(self, "pod_cidr")

    @property
    @pulumi.getter
    def provider(self) -> Optional[str]:
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter(name="serviceCIDR")
    def service_cidr(self) -> Optional[str]:
        return pulumi.get(self, "service_cidr")


@pulumi.output_type
class PodSecurityPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultPolicy":
            suggest = "default_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PodSecurityPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PodSecurityPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PodSecurityPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_policy: Optional[str] = None):
        if default_policy is not None:
            pulumi.set(__self__, "default_policy", default_policy)

    @property
    @pulumi.getter(name="defaultPolicy")
    def default_policy(self) -> Optional[str]:
        return pulumi.get(self, "default_policy")


@pulumi.output_type
class SSH(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostKey":
            suggest = "host_key"
        elif key == "keyPath":
            suggest = "key_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SSH. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SSH.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SSH.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 bastion: Optional['outputs.SSH'] = None,
                 host_key: Optional[str] = None,
                 key_path: Optional[str] = None,
                 port: Optional[float] = None,
                 user: Optional[str] = None):
        pulumi.set(__self__, "address", address)
        if bastion is not None:
            pulumi.set(__self__, "bastion", bastion)
        if host_key is not None:
            pulumi.set(__self__, "host_key", host_key)
        if key_path is not None:
            pulumi.set(__self__, "key_path", key_path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def address(self) -> str:
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def bastion(self) -> Optional['outputs.SSH']:
        return pulumi.get(self, "bastion")

    @property
    @pulumi.getter(name="hostKey")
    def host_key(self) -> Optional[str]:
        return pulumi.get(self, "host_key")

    @property
    @pulumi.getter(name="keyPath")
    def key_path(self) -> Optional[str]:
        return pulumi.get(self, "key_path")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        return pulumi.get(self, "user")


@pulumi.output_type
class Scheduler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extraArgs":
            suggest = "extra_args"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Scheduler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Scheduler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Scheduler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extra_args: Optional[Mapping[str, str]] = None):
        if extra_args is not None:
            pulumi.set(__self__, "extra_args", extra_args)

    @property
    @pulumi.getter(name="extraArgs")
    def extra_args(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "extra_args")


@pulumi.output_type
class Spec(dict):
    def __init__(__self__, *,
                 hosts: Sequence['outputs.Host'],
                 k0s: Optional['outputs.K0s'] = None):
        pulumi.set(__self__, "hosts", hosts)
        if k0s is not None:
            pulumi.set(__self__, "k0s", k0s)

    @property
    @pulumi.getter
    def hosts(self) -> Sequence['outputs.Host']:
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def k0s(self) -> Optional['outputs.K0s']:
        return pulumi.get(self, "k0s")


@pulumi.output_type
class Storage(dict):
    def __init__(__self__, *,
                 etcd: Optional['outputs.Etcd'] = None,
                 kine: Optional['outputs.Kine'] = None,
                 type: Optional[str] = None):
        if etcd is not None:
            pulumi.set(__self__, "etcd", etcd)
        if kine is not None:
            pulumi.set(__self__, "kine", kine)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def etcd(self) -> Optional['outputs.Etcd']:
        return pulumi.get(self, "etcd")

    @property
    @pulumi.getter
    def kine(self) -> Optional['outputs.Kine']:
        return pulumi.get(self, "kine")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class Telemetry(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class UploadFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dirPerm":
            suggest = "dir_perm"
        elif key == "dstDir":
            suggest = "dst_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UploadFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UploadFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UploadFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dir_perm: Optional[float] = None,
                 dst: Optional[str] = None,
                 dst_dir: Optional[str] = None,
                 group: Optional[str] = None,
                 name: Optional[str] = None,
                 perm: Optional[float] = None,
                 src: Optional[str] = None,
                 user: Optional[str] = None):
        if dir_perm is not None:
            pulumi.set(__self__, "dir_perm", dir_perm)
        if dst is not None:
            pulumi.set(__self__, "dst", dst)
        if dst_dir is not None:
            pulumi.set(__self__, "dst_dir", dst_dir)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if perm is not None:
            pulumi.set(__self__, "perm", perm)
        if src is not None:
            pulumi.set(__self__, "src", src)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter(name="dirPerm")
    def dir_perm(self) -> Optional[float]:
        return pulumi.get(self, "dir_perm")

    @property
    @pulumi.getter
    def dst(self) -> Optional[str]:
        return pulumi.get(self, "dst")

    @property
    @pulumi.getter(name="dstDir")
    def dst_dir(self) -> Optional[str]:
        return pulumi.get(self, "dst_dir")

    @property
    @pulumi.getter
    def group(self) -> Optional[str]:
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def perm(self) -> Optional[float]:
        return pulumi.get(self, "perm")

    @property
    @pulumi.getter
    def src(self) -> Optional[str]:
        return pulumi.get(self, "src")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        return pulumi.get(self, "user")


@pulumi.output_type
class WinRM(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertPath":
            suggest = "ca_cert_path"
        elif key == "certPath":
            suggest = "cert_path"
        elif key == "keyPath":
            suggest = "key_path"
        elif key == "tlsServerName":
            suggest = "tls_server_name"
        elif key == "useHTTPS":
            suggest = "use_https"
        elif key == "useNTLM":
            suggest = "use_ntlm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WinRM. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WinRM.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WinRM.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 bastion: Optional['outputs.SSH'] = None,
                 ca_cert_path: Optional[str] = None,
                 cert_path: Optional[str] = None,
                 insecure: Optional[bool] = None,
                 key_path: Optional[str] = None,
                 password: Optional[str] = None,
                 port: Optional[float] = None,
                 tls_server_name: Optional[str] = None,
                 use_https: Optional[bool] = None,
                 use_ntlm: Optional[bool] = None,
                 user: Optional[str] = None):
        pulumi.set(__self__, "address", address)
        if bastion is not None:
            pulumi.set(__self__, "bastion", bastion)
        if ca_cert_path is not None:
            pulumi.set(__self__, "ca_cert_path", ca_cert_path)
        if cert_path is not None:
            pulumi.set(__self__, "cert_path", cert_path)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if key_path is not None:
            pulumi.set(__self__, "key_path", key_path)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if tls_server_name is not None:
            pulumi.set(__self__, "tls_server_name", tls_server_name)
        if use_https is not None:
            pulumi.set(__self__, "use_https", use_https)
        if use_ntlm is not None:
            pulumi.set(__self__, "use_ntlm", use_ntlm)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def address(self) -> str:
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def bastion(self) -> Optional['outputs.SSH']:
        return pulumi.get(self, "bastion")

    @property
    @pulumi.getter(name="caCertPath")
    def ca_cert_path(self) -> Optional[str]:
        return pulumi.get(self, "ca_cert_path")

    @property
    @pulumi.getter(name="certPath")
    def cert_path(self) -> Optional[str]:
        return pulumi.get(self, "cert_path")

    @property
    @pulumi.getter
    def insecure(self) -> Optional[bool]:
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="keyPath")
    def key_path(self) -> Optional[str]:
        return pulumi.get(self, "key_path")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="tlsServerName")
    def tls_server_name(self) -> Optional[str]:
        return pulumi.get(self, "tls_server_name")

    @property
    @pulumi.getter(name="useHTTPS")
    def use_https(self) -> Optional[bool]:
        return pulumi.get(self, "use_https")

    @property
    @pulumi.getter(name="useNTLM")
    def use_ntlm(self) -> Optional[bool]:
        return pulumi.get(self, "use_ntlm")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        return pulumi.get(self, "user")


