"""add bigquery

Revision ID: e55a51b354e3
Revises: 07014ff34eb2
Create Date: 2022-02-01 18:02:05.023599

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "e55a51b354e3"
down_revision = "07014ff34eb2"
branch_labels = None
depends_on = None


def upgrade():
    op.execute("alter type connectiontype add value 'bigquery'")


def downgrade():
    op.execute("delete from connectionconfig where connection_type in ('bigquery')")
    op.execute("alter type connectiontype rename to connectiontype_old")
    op.execute(
        "create type connectiontype as enum('postgres', 'mongodb', 'mysql', 'https', 'snowflake', 'redshift', 'mssql', 'mariadb')"
    )
    op.execute(
        (
            "alter table connectionconfig alter column connection_type type connectiontype using "
            "connection_type::text::connectiontype"
        )
    )
    op.execute("drop type connectiontype_old")
