# generated by datamodel-codegen:
#   filename:  https://raw.githubusercontent.com/uselotus/lotus/main/docs/openapi.yaml
#   timestamp: 2023-02-09T22:12:31+00:00

from __future__ import annotations

from datetime import date, datetime
from enum import Enum
from typing import Any, Dict, List, Optional
from uuid import UUID

from pydantic import AnyUrl, BaseModel, EmailStr, Field, confloat, conint, constr


class APIToken(BaseModel):
    name: Optional[constr(max_length=50)] = Field(
        None,
        description='A free-form name for the API key. Need not be unique. 50 characters max.',
    )
    prefix: str
    expiry_date: Optional[datetime] = Field(
        None,
        description='Once API key expires, clients cannot use it anymore.',
        title='Expires',
    )
    created: datetime


class APITokenCreateResponse(BaseModel):
    api_key: APIToken
    key: str


class APITokenRequest(BaseModel):
    name: Optional[constr(min_length=1, max_length=50)] = Field(
        None,
        description='A free-form name for the API key. Need not be unique. 50 characters max.',
    )
    expiry_date: Optional[datetime] = Field(
        None,
        description='Once API key expires, clients cannot use it anymore.',
        title='Expires',
    )


class APITokenRollResponse(BaseModel):
    api_key: APIToken
    key: str


class Action(BaseModel):
    id: int
    actor: str
    verb: constr(max_length=255)
    action_object: str
    target: str
    public: Optional[bool] = None
    description: Optional[str] = None
    timestamp: Optional[datetime] = None


class InvoiceWhen(Enum):
    invoice_on_attach = 'invoice_on_attach'
    invoice_on_subscription_end = 'invoice_on_subscription_end'


class BillingFrequency(Enum):
    one_time = 'one_time'
    recurring = 'recurring'


class AddonType(Enum):
    usage_based = 'usage_based'
    flat = 'flat'


class InvoiceWhen1(Enum):
    invoice_on_attach = 'invoice_on_attach'
    invoice_on_subscription_end = 'invoice_on_subscription_end'


class BillingFrequency1(Enum):
    one_time = 'one_time'
    recurring = 'recurring'


class InvoicingBehavior(Enum):
    add_to_next_invoice = 'add_to_next_invoice'
    invoice_now = 'invoice_now'


class AddonSubscriptionRecordUpdateRequest(BaseModel):
    invoicing_behavior: InvoicingBehavior = Field(
        'invoice_now',
        description='The invoicing behavior to use when changing the quantity. Invoice now will recalculate the amount due immediately, whereas add_to_next_invoice will wait until the end of the subscription to do the calculation.',
    )
    turn_off_auto_renew: Optional[bool] = Field(
        None, description='Turn off auto renew for the addon'
    )
    end_date: Optional[datetime] = Field(
        None, description='Change the end date for the addon.'
    )
    quantity: Optional[int] = Field(
        None, description='Change the quantity of the susbcription to be this number.'
    )


class Address(BaseModel):
    city: str = Field(..., description='City, district, suburb, town, or village')
    country: constr(min_length=2, max_length=2) = Field(
        ..., description='ISO 3166-1 alpha-2 country code'
    )
    line1: str = Field(
        ..., description='Address line 1 (e.g., street, PO Box, or company name)'
    )
    line2: Optional[str] = Field(
        None, description='Address line 2 (e.g., apartment, suite, unit, or building)'
    )
    postal_code: str = Field(..., description='ZIP or postal code')
    state: str = Field(..., description='State, county, province, or region')


class AddressRequest(BaseModel):
    city: constr(min_length=1) = Field(
        ..., description='City, district, suburb, town, or village'
    )
    country: constr(min_length=2, max_length=2) = Field(
        ..., description='ISO 3166-1 alpha-2 country code'
    )
    line1: constr(min_length=1) = Field(
        ..., description='Address line 1 (e.g., street, PO Box, or company name)'
    )
    line2: Optional[str] = Field(
        None, description='Address line 2 (e.g., apartment, suite, unit, or building)'
    )
    postal_code: constr(min_length=1) = Field(..., description='ZIP or postal code')
    state: constr(min_length=1) = Field(
        ..., description='State, county, province, or region'
    )


class Kpi(Enum):
    total_revenue = 'total_revenue'


class BacktestCreate(BaseModel):
    start_date: date
    end_date: date
    kpis: List[Kpi]
    backtest_name: constr(max_length=100)


class Kpi1(Enum):
    total_revenue = 'total_revenue'


class Status(Enum):
    running = 'running'
    completed = 'completed'
    failed = 'failed'


class BacktestSubstitutionMulti(BaseModel):
    new_plan: UUID
    original_plans: List[UUID]


class BacktestSubstitutionMultiRequest(BaseModel):
    new_plan: UUID
    original_plans: List[UUID]


class Status1(Enum):
    running = 'running'
    completed = 'completed'
    failed = 'failed'


class BacktestSummary(BaseModel):
    backtest_name: constr(max_length=100)
    start_date: date
    end_date: date
    time_created: Optional[datetime] = None
    kpis: Optional[Dict[str, Any]] = None
    status: Optional[Status1] = None
    backtest_id: str


class Operator(Enum):
    isin = 'isin'
    isnotin = 'isnotin'


class CategoricalFilter(BaseModel):
    property_name: constr(max_length=100)
    operator: Operator
    comparison_value: List[str]


class Operator1(Enum):
    isin = 'isin'
    isnotin = 'isnotin'


class CategoricalFilterRequest(BaseModel):
    property_name: constr(min_length=1, max_length=100)
    operator: Operator1
    comparison_value: List[constr(min_length=1)]


class ChangeUserOrganizationRequestRequest(BaseModel):
    transfer_to_organization_id: constr(min_length=1) = Field(
        ..., description='The organization ID to transfer to'
    )


class ComponentUsage(BaseModel):
    event_name: str = Field(
        ..., description='The name of the event you are checking access for.'
    )
    metric_name: str = Field(..., description='The name of the metric.')
    metric_id: str = Field(
        ...,
        description="The metric_id of the metric. This metric_id can be found in the Lotus frontend if you haven't seen it before.",
    )
    metric_usage: float = Field(
        ...,
        description='The current usage of the metric. Keep in mind the current usage of the metric can be different from the billable usage of the metric.',
    )
    metric_free_limit: Optional[float] = Field(
        ...,
        description='If you specified a free tier of usage for this metric, this is the amount of usage that is free. Will be null if you did not specify a free tier for this metric.',
    )
    metric_total_limit: Optional[float] = Field(
        ...,
        description='The total limit of the metric. Will be null if you did not specify a limit for this metric.',
    )


class ConfirmConnected(BaseModel):
    organization_id: str


class Status2(Enum):
    success = 'success'


class ConfirmIdemsReceived(BaseModel):
    status: Status2
    ids_not_found: List[str]


class Status3(Enum):
    failure = 'failure'


class ConfirmIdemsReceivedFailure(BaseModel):
    status: Status3
    error: str


class ConfirmIdemsReceivedRequestRequest(BaseModel):
    idempotency_ids: List[constr(min_length=1)]
    number_days_lookback: int = 30
    customer_id: Optional[constr(min_length=1)] = None


class CreditDrawdown(BaseModel):
    credit_id: str
    amount: confloat(le=0.0, gt=-10000000000.0)
    description: Optional[str] = None
    applied_at: datetime


class PaymentProviderEnum(Enum):
    stripe = 'stripe'


class PaymentProvider(BaseModel):
    __root__: Optional[PaymentProviderEnum] = None


class Timezone(Enum):
    Africa_Abidjan = 'Africa/Abidjan'
    Africa_Accra = 'Africa/Accra'
    Africa_Addis_Ababa = 'Africa/Addis_Ababa'
    Africa_Algiers = 'Africa/Algiers'
    Africa_Asmara = 'Africa/Asmara'
    Africa_Bamako = 'Africa/Bamako'
    Africa_Bangui = 'Africa/Bangui'
    Africa_Banjul = 'Africa/Banjul'
    Africa_Bissau = 'Africa/Bissau'
    Africa_Blantyre = 'Africa/Blantyre'
    Africa_Brazzaville = 'Africa/Brazzaville'
    Africa_Bujumbura = 'Africa/Bujumbura'
    Africa_Cairo = 'Africa/Cairo'
    Africa_Casablanca = 'Africa/Casablanca'
    Africa_Ceuta = 'Africa/Ceuta'
    Africa_Conakry = 'Africa/Conakry'
    Africa_Dakar = 'Africa/Dakar'
    Africa_Dar_es_Salaam = 'Africa/Dar_es_Salaam'
    Africa_Djibouti = 'Africa/Djibouti'
    Africa_Douala = 'Africa/Douala'
    Africa_El_Aaiun = 'Africa/El_Aaiun'
    Africa_Freetown = 'Africa/Freetown'
    Africa_Gaborone = 'Africa/Gaborone'
    Africa_Harare = 'Africa/Harare'
    Africa_Johannesburg = 'Africa/Johannesburg'
    Africa_Juba = 'Africa/Juba'
    Africa_Kampala = 'Africa/Kampala'
    Africa_Khartoum = 'Africa/Khartoum'
    Africa_Kigali = 'Africa/Kigali'
    Africa_Kinshasa = 'Africa/Kinshasa'
    Africa_Lagos = 'Africa/Lagos'
    Africa_Libreville = 'Africa/Libreville'
    Africa_Lome = 'Africa/Lome'
    Africa_Luanda = 'Africa/Luanda'
    Africa_Lubumbashi = 'Africa/Lubumbashi'
    Africa_Lusaka = 'Africa/Lusaka'
    Africa_Malabo = 'Africa/Malabo'
    Africa_Maputo = 'Africa/Maputo'
    Africa_Maseru = 'Africa/Maseru'
    Africa_Mbabane = 'Africa/Mbabane'
    Africa_Mogadishu = 'Africa/Mogadishu'
    Africa_Monrovia = 'Africa/Monrovia'
    Africa_Nairobi = 'Africa/Nairobi'
    Africa_Ndjamena = 'Africa/Ndjamena'
    Africa_Niamey = 'Africa/Niamey'
    Africa_Nouakchott = 'Africa/Nouakchott'
    Africa_Ouagadougou = 'Africa/Ouagadougou'
    Africa_Porto_Novo = 'Africa/Porto-Novo'
    Africa_Sao_Tome = 'Africa/Sao_Tome'
    Africa_Tripoli = 'Africa/Tripoli'
    Africa_Tunis = 'Africa/Tunis'
    Africa_Windhoek = 'Africa/Windhoek'
    America_Adak = 'America/Adak'
    America_Anchorage = 'America/Anchorage'
    America_Anguilla = 'America/Anguilla'
    America_Antigua = 'America/Antigua'
    America_Araguaina = 'America/Araguaina'
    America_Argentina_Buenos_Aires = 'America/Argentina/Buenos_Aires'
    America_Argentina_Catamarca = 'America/Argentina/Catamarca'
    America_Argentina_Cordoba = 'America/Argentina/Cordoba'
    America_Argentina_Jujuy = 'America/Argentina/Jujuy'
    America_Argentina_La_Rioja = 'America/Argentina/La_Rioja'
    America_Argentina_Mendoza = 'America/Argentina/Mendoza'
    America_Argentina_Rio_Gallegos = 'America/Argentina/Rio_Gallegos'
    America_Argentina_Salta = 'America/Argentina/Salta'
    America_Argentina_San_Juan = 'America/Argentina/San_Juan'
    America_Argentina_San_Luis = 'America/Argentina/San_Luis'
    America_Argentina_Tucuman = 'America/Argentina/Tucuman'
    America_Argentina_Ushuaia = 'America/Argentina/Ushuaia'
    America_Aruba = 'America/Aruba'
    America_Asuncion = 'America/Asuncion'
    America_Atikokan = 'America/Atikokan'
    America_Bahia = 'America/Bahia'
    America_Bahia_Banderas = 'America/Bahia_Banderas'
    America_Barbados = 'America/Barbados'
    America_Belem = 'America/Belem'
    America_Belize = 'America/Belize'
    America_Blanc_Sablon = 'America/Blanc-Sablon'
    America_Boa_Vista = 'America/Boa_Vista'
    America_Bogota = 'America/Bogota'
    America_Boise = 'America/Boise'
    America_Cambridge_Bay = 'America/Cambridge_Bay'
    America_Campo_Grande = 'America/Campo_Grande'
    America_Cancun = 'America/Cancun'
    America_Caracas = 'America/Caracas'
    America_Cayenne = 'America/Cayenne'
    America_Cayman = 'America/Cayman'
    America_Chicago = 'America/Chicago'
    America_Chihuahua = 'America/Chihuahua'
    America_Ciudad_Juarez = 'America/Ciudad_Juarez'
    America_Costa_Rica = 'America/Costa_Rica'
    America_Creston = 'America/Creston'
    America_Cuiaba = 'America/Cuiaba'
    America_Curacao = 'America/Curacao'
    America_Danmarkshavn = 'America/Danmarkshavn'
    America_Dawson = 'America/Dawson'
    America_Dawson_Creek = 'America/Dawson_Creek'
    America_Denver = 'America/Denver'
    America_Detroit = 'America/Detroit'
    America_Dominica = 'America/Dominica'
    America_Edmonton = 'America/Edmonton'
    America_Eirunepe = 'America/Eirunepe'
    America_El_Salvador = 'America/El_Salvador'
    America_Fort_Nelson = 'America/Fort_Nelson'
    America_Fortaleza = 'America/Fortaleza'
    America_Glace_Bay = 'America/Glace_Bay'
    America_Goose_Bay = 'America/Goose_Bay'
    America_Grand_Turk = 'America/Grand_Turk'
    America_Grenada = 'America/Grenada'
    America_Guadeloupe = 'America/Guadeloupe'
    America_Guatemala = 'America/Guatemala'
    America_Guayaquil = 'America/Guayaquil'
    America_Guyana = 'America/Guyana'
    America_Halifax = 'America/Halifax'
    America_Havana = 'America/Havana'
    America_Hermosillo = 'America/Hermosillo'
    America_Indiana_Indianapolis = 'America/Indiana/Indianapolis'
    America_Indiana_Knox = 'America/Indiana/Knox'
    America_Indiana_Marengo = 'America/Indiana/Marengo'
    America_Indiana_Petersburg = 'America/Indiana/Petersburg'
    America_Indiana_Tell_City = 'America/Indiana/Tell_City'
    America_Indiana_Vevay = 'America/Indiana/Vevay'
    America_Indiana_Vincennes = 'America/Indiana/Vincennes'
    America_Indiana_Winamac = 'America/Indiana/Winamac'
    America_Inuvik = 'America/Inuvik'
    America_Iqaluit = 'America/Iqaluit'
    America_Jamaica = 'America/Jamaica'
    America_Juneau = 'America/Juneau'
    America_Kentucky_Louisville = 'America/Kentucky/Louisville'
    America_Kentucky_Monticello = 'America/Kentucky/Monticello'
    America_Kralendijk = 'America/Kralendijk'
    America_La_Paz = 'America/La_Paz'
    America_Lima = 'America/Lima'
    America_Los_Angeles = 'America/Los_Angeles'
    America_Lower_Princes = 'America/Lower_Princes'
    America_Maceio = 'America/Maceio'
    America_Managua = 'America/Managua'
    America_Manaus = 'America/Manaus'
    America_Marigot = 'America/Marigot'
    America_Martinique = 'America/Martinique'
    America_Matamoros = 'America/Matamoros'
    America_Mazatlan = 'America/Mazatlan'
    America_Menominee = 'America/Menominee'
    America_Merida = 'America/Merida'
    America_Metlakatla = 'America/Metlakatla'
    America_Mexico_City = 'America/Mexico_City'
    America_Miquelon = 'America/Miquelon'
    America_Moncton = 'America/Moncton'
    America_Monterrey = 'America/Monterrey'
    America_Montevideo = 'America/Montevideo'
    America_Montserrat = 'America/Montserrat'
    America_Nassau = 'America/Nassau'
    America_New_York = 'America/New_York'
    America_Nome = 'America/Nome'
    America_Noronha = 'America/Noronha'
    America_North_Dakota_Beulah = 'America/North_Dakota/Beulah'
    America_North_Dakota_Center = 'America/North_Dakota/Center'
    America_North_Dakota_New_Salem = 'America/North_Dakota/New_Salem'
    America_Nuuk = 'America/Nuuk'
    America_Ojinaga = 'America/Ojinaga'
    America_Panama = 'America/Panama'
    America_Paramaribo = 'America/Paramaribo'
    America_Phoenix = 'America/Phoenix'
    America_Port_au_Prince = 'America/Port-au-Prince'
    America_Port_of_Spain = 'America/Port_of_Spain'
    America_Porto_Velho = 'America/Porto_Velho'
    America_Puerto_Rico = 'America/Puerto_Rico'
    America_Punta_Arenas = 'America/Punta_Arenas'
    America_Rankin_Inlet = 'America/Rankin_Inlet'
    America_Recife = 'America/Recife'
    America_Regina = 'America/Regina'
    America_Resolute = 'America/Resolute'
    America_Rio_Branco = 'America/Rio_Branco'
    America_Santarem = 'America/Santarem'
    America_Santiago = 'America/Santiago'
    America_Santo_Domingo = 'America/Santo_Domingo'
    America_Sao_Paulo = 'America/Sao_Paulo'
    America_Scoresbysund = 'America/Scoresbysund'
    America_Sitka = 'America/Sitka'
    America_St_Barthelemy = 'America/St_Barthelemy'
    America_St_Johns = 'America/St_Johns'
    America_St_Kitts = 'America/St_Kitts'
    America_St_Lucia = 'America/St_Lucia'
    America_St_Thomas = 'America/St_Thomas'
    America_St_Vincent = 'America/St_Vincent'
    America_Swift_Current = 'America/Swift_Current'
    America_Tegucigalpa = 'America/Tegucigalpa'
    America_Thule = 'America/Thule'
    America_Tijuana = 'America/Tijuana'
    America_Toronto = 'America/Toronto'
    America_Tortola = 'America/Tortola'
    America_Vancouver = 'America/Vancouver'
    America_Whitehorse = 'America/Whitehorse'
    America_Winnipeg = 'America/Winnipeg'
    America_Yakutat = 'America/Yakutat'
    America_Yellowknife = 'America/Yellowknife'
    Antarctica_Casey = 'Antarctica/Casey'
    Antarctica_Davis = 'Antarctica/Davis'
    Antarctica_DumontDUrville = 'Antarctica/DumontDUrville'
    Antarctica_Macquarie = 'Antarctica/Macquarie'
    Antarctica_Mawson = 'Antarctica/Mawson'
    Antarctica_McMurdo = 'Antarctica/McMurdo'
    Antarctica_Palmer = 'Antarctica/Palmer'
    Antarctica_Rothera = 'Antarctica/Rothera'
    Antarctica_Syowa = 'Antarctica/Syowa'
    Antarctica_Troll = 'Antarctica/Troll'
    Antarctica_Vostok = 'Antarctica/Vostok'
    Arctic_Longyearbyen = 'Arctic/Longyearbyen'
    Asia_Aden = 'Asia/Aden'
    Asia_Almaty = 'Asia/Almaty'
    Asia_Amman = 'Asia/Amman'
    Asia_Anadyr = 'Asia/Anadyr'
    Asia_Aqtau = 'Asia/Aqtau'
    Asia_Aqtobe = 'Asia/Aqtobe'
    Asia_Ashgabat = 'Asia/Ashgabat'
    Asia_Atyrau = 'Asia/Atyrau'
    Asia_Baghdad = 'Asia/Baghdad'
    Asia_Bahrain = 'Asia/Bahrain'
    Asia_Baku = 'Asia/Baku'
    Asia_Bangkok = 'Asia/Bangkok'
    Asia_Barnaul = 'Asia/Barnaul'
    Asia_Beirut = 'Asia/Beirut'
    Asia_Bishkek = 'Asia/Bishkek'
    Asia_Brunei = 'Asia/Brunei'
    Asia_Chita = 'Asia/Chita'
    Asia_Choibalsan = 'Asia/Choibalsan'
    Asia_Colombo = 'Asia/Colombo'
    Asia_Damascus = 'Asia/Damascus'
    Asia_Dhaka = 'Asia/Dhaka'
    Asia_Dili = 'Asia/Dili'
    Asia_Dubai = 'Asia/Dubai'
    Asia_Dushanbe = 'Asia/Dushanbe'
    Asia_Famagusta = 'Asia/Famagusta'
    Asia_Gaza = 'Asia/Gaza'
    Asia_Hebron = 'Asia/Hebron'
    Asia_Ho_Chi_Minh = 'Asia/Ho_Chi_Minh'
    Asia_Hong_Kong = 'Asia/Hong_Kong'
    Asia_Hovd = 'Asia/Hovd'
    Asia_Irkutsk = 'Asia/Irkutsk'
    Asia_Jakarta = 'Asia/Jakarta'
    Asia_Jayapura = 'Asia/Jayapura'
    Asia_Jerusalem = 'Asia/Jerusalem'
    Asia_Kabul = 'Asia/Kabul'
    Asia_Kamchatka = 'Asia/Kamchatka'
    Asia_Karachi = 'Asia/Karachi'
    Asia_Kathmandu = 'Asia/Kathmandu'
    Asia_Khandyga = 'Asia/Khandyga'
    Asia_Kolkata = 'Asia/Kolkata'
    Asia_Krasnoyarsk = 'Asia/Krasnoyarsk'
    Asia_Kuala_Lumpur = 'Asia/Kuala_Lumpur'
    Asia_Kuching = 'Asia/Kuching'
    Asia_Kuwait = 'Asia/Kuwait'
    Asia_Macau = 'Asia/Macau'
    Asia_Magadan = 'Asia/Magadan'
    Asia_Makassar = 'Asia/Makassar'
    Asia_Manila = 'Asia/Manila'
    Asia_Muscat = 'Asia/Muscat'
    Asia_Nicosia = 'Asia/Nicosia'
    Asia_Novokuznetsk = 'Asia/Novokuznetsk'
    Asia_Novosibirsk = 'Asia/Novosibirsk'
    Asia_Omsk = 'Asia/Omsk'
    Asia_Oral = 'Asia/Oral'
    Asia_Phnom_Penh = 'Asia/Phnom_Penh'
    Asia_Pontianak = 'Asia/Pontianak'
    Asia_Pyongyang = 'Asia/Pyongyang'
    Asia_Qatar = 'Asia/Qatar'
    Asia_Qostanay = 'Asia/Qostanay'
    Asia_Qyzylorda = 'Asia/Qyzylorda'
    Asia_Riyadh = 'Asia/Riyadh'
    Asia_Sakhalin = 'Asia/Sakhalin'
    Asia_Samarkand = 'Asia/Samarkand'
    Asia_Seoul = 'Asia/Seoul'
    Asia_Shanghai = 'Asia/Shanghai'
    Asia_Singapore = 'Asia/Singapore'
    Asia_Srednekolymsk = 'Asia/Srednekolymsk'
    Asia_Taipei = 'Asia/Taipei'
    Asia_Tashkent = 'Asia/Tashkent'
    Asia_Tbilisi = 'Asia/Tbilisi'
    Asia_Tehran = 'Asia/Tehran'
    Asia_Thimphu = 'Asia/Thimphu'
    Asia_Tokyo = 'Asia/Tokyo'
    Asia_Tomsk = 'Asia/Tomsk'
    Asia_Ulaanbaatar = 'Asia/Ulaanbaatar'
    Asia_Urumqi = 'Asia/Urumqi'
    Asia_Ust_Nera = 'Asia/Ust-Nera'
    Asia_Vientiane = 'Asia/Vientiane'
    Asia_Vladivostok = 'Asia/Vladivostok'
    Asia_Yakutsk = 'Asia/Yakutsk'
    Asia_Yangon = 'Asia/Yangon'
    Asia_Yekaterinburg = 'Asia/Yekaterinburg'
    Asia_Yerevan = 'Asia/Yerevan'
    Atlantic_Azores = 'Atlantic/Azores'
    Atlantic_Bermuda = 'Atlantic/Bermuda'
    Atlantic_Canary = 'Atlantic/Canary'
    Atlantic_Cape_Verde = 'Atlantic/Cape_Verde'
    Atlantic_Faroe = 'Atlantic/Faroe'
    Atlantic_Madeira = 'Atlantic/Madeira'
    Atlantic_Reykjavik = 'Atlantic/Reykjavik'
    Atlantic_South_Georgia = 'Atlantic/South_Georgia'
    Atlantic_St_Helena = 'Atlantic/St_Helena'
    Atlantic_Stanley = 'Atlantic/Stanley'
    Australia_Adelaide = 'Australia/Adelaide'
    Australia_Brisbane = 'Australia/Brisbane'
    Australia_Broken_Hill = 'Australia/Broken_Hill'
    Australia_Darwin = 'Australia/Darwin'
    Australia_Eucla = 'Australia/Eucla'
    Australia_Hobart = 'Australia/Hobart'
    Australia_Lindeman = 'Australia/Lindeman'
    Australia_Lord_Howe = 'Australia/Lord_Howe'
    Australia_Melbourne = 'Australia/Melbourne'
    Australia_Perth = 'Australia/Perth'
    Australia_Sydney = 'Australia/Sydney'
    Canada_Atlantic = 'Canada/Atlantic'
    Canada_Central = 'Canada/Central'
    Canada_Eastern = 'Canada/Eastern'
    Canada_Mountain = 'Canada/Mountain'
    Canada_Newfoundland = 'Canada/Newfoundland'
    Canada_Pacific = 'Canada/Pacific'
    Europe_Amsterdam = 'Europe/Amsterdam'
    Europe_Andorra = 'Europe/Andorra'
    Europe_Astrakhan = 'Europe/Astrakhan'
    Europe_Athens = 'Europe/Athens'
    Europe_Belgrade = 'Europe/Belgrade'
    Europe_Berlin = 'Europe/Berlin'
    Europe_Bratislava = 'Europe/Bratislava'
    Europe_Brussels = 'Europe/Brussels'
    Europe_Bucharest = 'Europe/Bucharest'
    Europe_Budapest = 'Europe/Budapest'
    Europe_Busingen = 'Europe/Busingen'
    Europe_Chisinau = 'Europe/Chisinau'
    Europe_Copenhagen = 'Europe/Copenhagen'
    Europe_Dublin = 'Europe/Dublin'
    Europe_Gibraltar = 'Europe/Gibraltar'
    Europe_Guernsey = 'Europe/Guernsey'
    Europe_Helsinki = 'Europe/Helsinki'
    Europe_Isle_of_Man = 'Europe/Isle_of_Man'
    Europe_Istanbul = 'Europe/Istanbul'
    Europe_Jersey = 'Europe/Jersey'
    Europe_Kaliningrad = 'Europe/Kaliningrad'
    Europe_Kirov = 'Europe/Kirov'
    Europe_Kyiv = 'Europe/Kyiv'
    Europe_Lisbon = 'Europe/Lisbon'
    Europe_Ljubljana = 'Europe/Ljubljana'
    Europe_London = 'Europe/London'
    Europe_Luxembourg = 'Europe/Luxembourg'
    Europe_Madrid = 'Europe/Madrid'
    Europe_Malta = 'Europe/Malta'
    Europe_Mariehamn = 'Europe/Mariehamn'
    Europe_Minsk = 'Europe/Minsk'
    Europe_Monaco = 'Europe/Monaco'
    Europe_Moscow = 'Europe/Moscow'
    Europe_Oslo = 'Europe/Oslo'
    Europe_Paris = 'Europe/Paris'
    Europe_Podgorica = 'Europe/Podgorica'
    Europe_Prague = 'Europe/Prague'
    Europe_Riga = 'Europe/Riga'
    Europe_Rome = 'Europe/Rome'
    Europe_Samara = 'Europe/Samara'
    Europe_San_Marino = 'Europe/San_Marino'
    Europe_Sarajevo = 'Europe/Sarajevo'
    Europe_Saratov = 'Europe/Saratov'
    Europe_Simferopol = 'Europe/Simferopol'
    Europe_Skopje = 'Europe/Skopje'
    Europe_Sofia = 'Europe/Sofia'
    Europe_Stockholm = 'Europe/Stockholm'
    Europe_Tallinn = 'Europe/Tallinn'
    Europe_Tirane = 'Europe/Tirane'
    Europe_Ulyanovsk = 'Europe/Ulyanovsk'
    Europe_Vaduz = 'Europe/Vaduz'
    Europe_Vatican = 'Europe/Vatican'
    Europe_Vienna = 'Europe/Vienna'
    Europe_Vilnius = 'Europe/Vilnius'
    Europe_Volgograd = 'Europe/Volgograd'
    Europe_Warsaw = 'Europe/Warsaw'
    Europe_Zagreb = 'Europe/Zagreb'
    Europe_Zurich = 'Europe/Zurich'
    GMT = 'GMT'
    Indian_Antananarivo = 'Indian/Antananarivo'
    Indian_Chagos = 'Indian/Chagos'
    Indian_Christmas = 'Indian/Christmas'
    Indian_Cocos = 'Indian/Cocos'
    Indian_Comoro = 'Indian/Comoro'
    Indian_Kerguelen = 'Indian/Kerguelen'
    Indian_Mahe = 'Indian/Mahe'
    Indian_Maldives = 'Indian/Maldives'
    Indian_Mauritius = 'Indian/Mauritius'
    Indian_Mayotte = 'Indian/Mayotte'
    Indian_Reunion = 'Indian/Reunion'
    Pacific_Apia = 'Pacific/Apia'
    Pacific_Auckland = 'Pacific/Auckland'
    Pacific_Bougainville = 'Pacific/Bougainville'
    Pacific_Chatham = 'Pacific/Chatham'
    Pacific_Chuuk = 'Pacific/Chuuk'
    Pacific_Easter = 'Pacific/Easter'
    Pacific_Efate = 'Pacific/Efate'
    Pacific_Fakaofo = 'Pacific/Fakaofo'
    Pacific_Fiji = 'Pacific/Fiji'
    Pacific_Funafuti = 'Pacific/Funafuti'
    Pacific_Galapagos = 'Pacific/Galapagos'
    Pacific_Gambier = 'Pacific/Gambier'
    Pacific_Guadalcanal = 'Pacific/Guadalcanal'
    Pacific_Guam = 'Pacific/Guam'
    Pacific_Honolulu = 'Pacific/Honolulu'
    Pacific_Kanton = 'Pacific/Kanton'
    Pacific_Kiritimati = 'Pacific/Kiritimati'
    Pacific_Kosrae = 'Pacific/Kosrae'
    Pacific_Kwajalein = 'Pacific/Kwajalein'
    Pacific_Majuro = 'Pacific/Majuro'
    Pacific_Marquesas = 'Pacific/Marquesas'
    Pacific_Midway = 'Pacific/Midway'
    Pacific_Nauru = 'Pacific/Nauru'
    Pacific_Niue = 'Pacific/Niue'
    Pacific_Norfolk = 'Pacific/Norfolk'
    Pacific_Noumea = 'Pacific/Noumea'
    Pacific_Pago_Pago = 'Pacific/Pago_Pago'
    Pacific_Palau = 'Pacific/Palau'
    Pacific_Pitcairn = 'Pacific/Pitcairn'
    Pacific_Pohnpei = 'Pacific/Pohnpei'
    Pacific_Port_Moresby = 'Pacific/Port_Moresby'
    Pacific_Rarotonga = 'Pacific/Rarotonga'
    Pacific_Saipan = 'Pacific/Saipan'
    Pacific_Tahiti = 'Pacific/Tahiti'
    Pacific_Tarawa = 'Pacific/Tarawa'
    Pacific_Tongatapu = 'Pacific/Tongatapu'
    Pacific_Wake = 'Pacific/Wake'
    Pacific_Wallis = 'Pacific/Wallis'
    US_Alaska = 'US/Alaska'
    US_Arizona = 'US/Arizona'
    US_Central = 'US/Central'
    US_Eastern = 'US/Eastern'
    US_Hawaii = 'US/Hawaii'
    US_Mountain = 'US/Mountain'
    US_Pacific = 'US/Pacific'
    UTC = 'UTC'


class Status4(Enum):
    active = 'active'
    inactive = 'inactive'


class CustomerBalanceAdjustmentCreateRequest(BaseModel):
    customer_id: constr(min_length=1) = Field(
        ...,
        description='The id provided when creating the customer, we suggest matching with your internal customer id in your backend',
    )
    amount: confloat(lt=10000000000.0, gt=-10000000000.0)
    currency_code: constr(min_length=1)
    description: Optional[str] = None
    effective_at: Optional[datetime] = None
    expires_at: Optional[datetime] = None
    amount_paid: Optional[confloat(ge=0.0, lt=10000000000.0)] = None
    amount_paid_currency_code: Optional[constr(min_length=1)] = None


class CustomerBalanceAdjustmentUpdateRequest(BaseModel):
    description: Optional[str] = None
    expires_at: Optional[datetime] = None


class PaymentProvider1(Enum):
    stripe = 'stripe'


class CustomerCreateRequest(BaseModel):
    customer_name: Optional[constr(max_length=100)] = Field(
        None, description='The display name of the customer'
    )
    customer_id: constr(regex=r'^[-a-zA-Z0-9_]+$', min_length=1, max_length=50) = Field(
        ...,
        description='The id provided when creating the customer, we suggest matching with your internal customer id in your backend',
    )
    email: EmailStr = Field(
        ...,
        description='The primary email address of the customer, must be the same as the email address used to create the customer in the payment provider',
    )
    payment_provider: Optional[PaymentProvider1] = Field(
        None,
        description='The payment provider this customer is associated with. Currently, only Stripe is supported.',
    )
    payment_provider_id: Optional[constr(min_length=1)] = Field(
        None,
        description="The customer's ID in the specified payment provider. Please note that payment_provider and payment_provider_id are mutually necessary.",
    )
    properties: Optional[Dict[str, Any]] = Field(
        None, description='Extra metadata for the customer'
    )
    default_currency_code: Optional[constr(min_length=1)] = Field(
        None,
        description="The currency code this customer will be invoiced in. Codes are 3 letters, e.g. 'USD'.",
    )
    address: Optional[AddressRequest] = None
    tax_rate: Optional[confloat(ge=0.0, le=999.9999)] = Field(
        None, description='Tax rate as percentage. For example, 10.5 for 10.5%'
    )


class CustomerStripeIntegration(BaseModel):
    stripe_id: str
    has_payment_method: bool


class Timezone1(Enum):
    Africa_Abidjan = 'Africa/Abidjan'
    Africa_Accra = 'Africa/Accra'
    Africa_Addis_Ababa = 'Africa/Addis_Ababa'
    Africa_Algiers = 'Africa/Algiers'
    Africa_Asmara = 'Africa/Asmara'
    Africa_Bamako = 'Africa/Bamako'
    Africa_Bangui = 'Africa/Bangui'
    Africa_Banjul = 'Africa/Banjul'
    Africa_Bissau = 'Africa/Bissau'
    Africa_Blantyre = 'Africa/Blantyre'
    Africa_Brazzaville = 'Africa/Brazzaville'
    Africa_Bujumbura = 'Africa/Bujumbura'
    Africa_Cairo = 'Africa/Cairo'
    Africa_Casablanca = 'Africa/Casablanca'
    Africa_Ceuta = 'Africa/Ceuta'
    Africa_Conakry = 'Africa/Conakry'
    Africa_Dakar = 'Africa/Dakar'
    Africa_Dar_es_Salaam = 'Africa/Dar_es_Salaam'
    Africa_Djibouti = 'Africa/Djibouti'
    Africa_Douala = 'Africa/Douala'
    Africa_El_Aaiun = 'Africa/El_Aaiun'
    Africa_Freetown = 'Africa/Freetown'
    Africa_Gaborone = 'Africa/Gaborone'
    Africa_Harare = 'Africa/Harare'
    Africa_Johannesburg = 'Africa/Johannesburg'
    Africa_Juba = 'Africa/Juba'
    Africa_Kampala = 'Africa/Kampala'
    Africa_Khartoum = 'Africa/Khartoum'
    Africa_Kigali = 'Africa/Kigali'
    Africa_Kinshasa = 'Africa/Kinshasa'
    Africa_Lagos = 'Africa/Lagos'
    Africa_Libreville = 'Africa/Libreville'
    Africa_Lome = 'Africa/Lome'
    Africa_Luanda = 'Africa/Luanda'
    Africa_Lubumbashi = 'Africa/Lubumbashi'
    Africa_Lusaka = 'Africa/Lusaka'
    Africa_Malabo = 'Africa/Malabo'
    Africa_Maputo = 'Africa/Maputo'
    Africa_Maseru = 'Africa/Maseru'
    Africa_Mbabane = 'Africa/Mbabane'
    Africa_Mogadishu = 'Africa/Mogadishu'
    Africa_Monrovia = 'Africa/Monrovia'
    Africa_Nairobi = 'Africa/Nairobi'
    Africa_Ndjamena = 'Africa/Ndjamena'
    Africa_Niamey = 'Africa/Niamey'
    Africa_Nouakchott = 'Africa/Nouakchott'
    Africa_Ouagadougou = 'Africa/Ouagadougou'
    Africa_Porto_Novo = 'Africa/Porto-Novo'
    Africa_Sao_Tome = 'Africa/Sao_Tome'
    Africa_Tripoli = 'Africa/Tripoli'
    Africa_Tunis = 'Africa/Tunis'
    Africa_Windhoek = 'Africa/Windhoek'
    America_Adak = 'America/Adak'
    America_Anchorage = 'America/Anchorage'
    America_Anguilla = 'America/Anguilla'
    America_Antigua = 'America/Antigua'
    America_Araguaina = 'America/Araguaina'
    America_Argentina_Buenos_Aires = 'America/Argentina/Buenos_Aires'
    America_Argentina_Catamarca = 'America/Argentina/Catamarca'
    America_Argentina_Cordoba = 'America/Argentina/Cordoba'
    America_Argentina_Jujuy = 'America/Argentina/Jujuy'
    America_Argentina_La_Rioja = 'America/Argentina/La_Rioja'
    America_Argentina_Mendoza = 'America/Argentina/Mendoza'
    America_Argentina_Rio_Gallegos = 'America/Argentina/Rio_Gallegos'
    America_Argentina_Salta = 'America/Argentina/Salta'
    America_Argentina_San_Juan = 'America/Argentina/San_Juan'
    America_Argentina_San_Luis = 'America/Argentina/San_Luis'
    America_Argentina_Tucuman = 'America/Argentina/Tucuman'
    America_Argentina_Ushuaia = 'America/Argentina/Ushuaia'
    America_Aruba = 'America/Aruba'
    America_Asuncion = 'America/Asuncion'
    America_Atikokan = 'America/Atikokan'
    America_Bahia = 'America/Bahia'
    America_Bahia_Banderas = 'America/Bahia_Banderas'
    America_Barbados = 'America/Barbados'
    America_Belem = 'America/Belem'
    America_Belize = 'America/Belize'
    America_Blanc_Sablon = 'America/Blanc-Sablon'
    America_Boa_Vista = 'America/Boa_Vista'
    America_Bogota = 'America/Bogota'
    America_Boise = 'America/Boise'
    America_Cambridge_Bay = 'America/Cambridge_Bay'
    America_Campo_Grande = 'America/Campo_Grande'
    America_Cancun = 'America/Cancun'
    America_Caracas = 'America/Caracas'
    America_Cayenne = 'America/Cayenne'
    America_Cayman = 'America/Cayman'
    America_Chicago = 'America/Chicago'
    America_Chihuahua = 'America/Chihuahua'
    America_Ciudad_Juarez = 'America/Ciudad_Juarez'
    America_Costa_Rica = 'America/Costa_Rica'
    America_Creston = 'America/Creston'
    America_Cuiaba = 'America/Cuiaba'
    America_Curacao = 'America/Curacao'
    America_Danmarkshavn = 'America/Danmarkshavn'
    America_Dawson = 'America/Dawson'
    America_Dawson_Creek = 'America/Dawson_Creek'
    America_Denver = 'America/Denver'
    America_Detroit = 'America/Detroit'
    America_Dominica = 'America/Dominica'
    America_Edmonton = 'America/Edmonton'
    America_Eirunepe = 'America/Eirunepe'
    America_El_Salvador = 'America/El_Salvador'
    America_Fort_Nelson = 'America/Fort_Nelson'
    America_Fortaleza = 'America/Fortaleza'
    America_Glace_Bay = 'America/Glace_Bay'
    America_Goose_Bay = 'America/Goose_Bay'
    America_Grand_Turk = 'America/Grand_Turk'
    America_Grenada = 'America/Grenada'
    America_Guadeloupe = 'America/Guadeloupe'
    America_Guatemala = 'America/Guatemala'
    America_Guayaquil = 'America/Guayaquil'
    America_Guyana = 'America/Guyana'
    America_Halifax = 'America/Halifax'
    America_Havana = 'America/Havana'
    America_Hermosillo = 'America/Hermosillo'
    America_Indiana_Indianapolis = 'America/Indiana/Indianapolis'
    America_Indiana_Knox = 'America/Indiana/Knox'
    America_Indiana_Marengo = 'America/Indiana/Marengo'
    America_Indiana_Petersburg = 'America/Indiana/Petersburg'
    America_Indiana_Tell_City = 'America/Indiana/Tell_City'
    America_Indiana_Vevay = 'America/Indiana/Vevay'
    America_Indiana_Vincennes = 'America/Indiana/Vincennes'
    America_Indiana_Winamac = 'America/Indiana/Winamac'
    America_Inuvik = 'America/Inuvik'
    America_Iqaluit = 'America/Iqaluit'
    America_Jamaica = 'America/Jamaica'
    America_Juneau = 'America/Juneau'
    America_Kentucky_Louisville = 'America/Kentucky/Louisville'
    America_Kentucky_Monticello = 'America/Kentucky/Monticello'
    America_Kralendijk = 'America/Kralendijk'
    America_La_Paz = 'America/La_Paz'
    America_Lima = 'America/Lima'
    America_Los_Angeles = 'America/Los_Angeles'
    America_Lower_Princes = 'America/Lower_Princes'
    America_Maceio = 'America/Maceio'
    America_Managua = 'America/Managua'
    America_Manaus = 'America/Manaus'
    America_Marigot = 'America/Marigot'
    America_Martinique = 'America/Martinique'
    America_Matamoros = 'America/Matamoros'
    America_Mazatlan = 'America/Mazatlan'
    America_Menominee = 'America/Menominee'
    America_Merida = 'America/Merida'
    America_Metlakatla = 'America/Metlakatla'
    America_Mexico_City = 'America/Mexico_City'
    America_Miquelon = 'America/Miquelon'
    America_Moncton = 'America/Moncton'
    America_Monterrey = 'America/Monterrey'
    America_Montevideo = 'America/Montevideo'
    America_Montserrat = 'America/Montserrat'
    America_Nassau = 'America/Nassau'
    America_New_York = 'America/New_York'
    America_Nome = 'America/Nome'
    America_Noronha = 'America/Noronha'
    America_North_Dakota_Beulah = 'America/North_Dakota/Beulah'
    America_North_Dakota_Center = 'America/North_Dakota/Center'
    America_North_Dakota_New_Salem = 'America/North_Dakota/New_Salem'
    America_Nuuk = 'America/Nuuk'
    America_Ojinaga = 'America/Ojinaga'
    America_Panama = 'America/Panama'
    America_Paramaribo = 'America/Paramaribo'
    America_Phoenix = 'America/Phoenix'
    America_Port_au_Prince = 'America/Port-au-Prince'
    America_Port_of_Spain = 'America/Port_of_Spain'
    America_Porto_Velho = 'America/Porto_Velho'
    America_Puerto_Rico = 'America/Puerto_Rico'
    America_Punta_Arenas = 'America/Punta_Arenas'
    America_Rankin_Inlet = 'America/Rankin_Inlet'
    America_Recife = 'America/Recife'
    America_Regina = 'America/Regina'
    America_Resolute = 'America/Resolute'
    America_Rio_Branco = 'America/Rio_Branco'
    America_Santarem = 'America/Santarem'
    America_Santiago = 'America/Santiago'
    America_Santo_Domingo = 'America/Santo_Domingo'
    America_Sao_Paulo = 'America/Sao_Paulo'
    America_Scoresbysund = 'America/Scoresbysund'
    America_Sitka = 'America/Sitka'
    America_St_Barthelemy = 'America/St_Barthelemy'
    America_St_Johns = 'America/St_Johns'
    America_St_Kitts = 'America/St_Kitts'
    America_St_Lucia = 'America/St_Lucia'
    America_St_Thomas = 'America/St_Thomas'
    America_St_Vincent = 'America/St_Vincent'
    America_Swift_Current = 'America/Swift_Current'
    America_Tegucigalpa = 'America/Tegucigalpa'
    America_Thule = 'America/Thule'
    America_Tijuana = 'America/Tijuana'
    America_Toronto = 'America/Toronto'
    America_Tortola = 'America/Tortola'
    America_Vancouver = 'America/Vancouver'
    America_Whitehorse = 'America/Whitehorse'
    America_Winnipeg = 'America/Winnipeg'
    America_Yakutat = 'America/Yakutat'
    America_Yellowknife = 'America/Yellowknife'
    Antarctica_Casey = 'Antarctica/Casey'
    Antarctica_Davis = 'Antarctica/Davis'
    Antarctica_DumontDUrville = 'Antarctica/DumontDUrville'
    Antarctica_Macquarie = 'Antarctica/Macquarie'
    Antarctica_Mawson = 'Antarctica/Mawson'
    Antarctica_McMurdo = 'Antarctica/McMurdo'
    Antarctica_Palmer = 'Antarctica/Palmer'
    Antarctica_Rothera = 'Antarctica/Rothera'
    Antarctica_Syowa = 'Antarctica/Syowa'
    Antarctica_Troll = 'Antarctica/Troll'
    Antarctica_Vostok = 'Antarctica/Vostok'
    Arctic_Longyearbyen = 'Arctic/Longyearbyen'
    Asia_Aden = 'Asia/Aden'
    Asia_Almaty = 'Asia/Almaty'
    Asia_Amman = 'Asia/Amman'
    Asia_Anadyr = 'Asia/Anadyr'
    Asia_Aqtau = 'Asia/Aqtau'
    Asia_Aqtobe = 'Asia/Aqtobe'
    Asia_Ashgabat = 'Asia/Ashgabat'
    Asia_Atyrau = 'Asia/Atyrau'
    Asia_Baghdad = 'Asia/Baghdad'
    Asia_Bahrain = 'Asia/Bahrain'
    Asia_Baku = 'Asia/Baku'
    Asia_Bangkok = 'Asia/Bangkok'
    Asia_Barnaul = 'Asia/Barnaul'
    Asia_Beirut = 'Asia/Beirut'
    Asia_Bishkek = 'Asia/Bishkek'
    Asia_Brunei = 'Asia/Brunei'
    Asia_Chita = 'Asia/Chita'
    Asia_Choibalsan = 'Asia/Choibalsan'
    Asia_Colombo = 'Asia/Colombo'
    Asia_Damascus = 'Asia/Damascus'
    Asia_Dhaka = 'Asia/Dhaka'
    Asia_Dili = 'Asia/Dili'
    Asia_Dubai = 'Asia/Dubai'
    Asia_Dushanbe = 'Asia/Dushanbe'
    Asia_Famagusta = 'Asia/Famagusta'
    Asia_Gaza = 'Asia/Gaza'
    Asia_Hebron = 'Asia/Hebron'
    Asia_Ho_Chi_Minh = 'Asia/Ho_Chi_Minh'
    Asia_Hong_Kong = 'Asia/Hong_Kong'
    Asia_Hovd = 'Asia/Hovd'
    Asia_Irkutsk = 'Asia/Irkutsk'
    Asia_Jakarta = 'Asia/Jakarta'
    Asia_Jayapura = 'Asia/Jayapura'
    Asia_Jerusalem = 'Asia/Jerusalem'
    Asia_Kabul = 'Asia/Kabul'
    Asia_Kamchatka = 'Asia/Kamchatka'
    Asia_Karachi = 'Asia/Karachi'
    Asia_Kathmandu = 'Asia/Kathmandu'
    Asia_Khandyga = 'Asia/Khandyga'
    Asia_Kolkata = 'Asia/Kolkata'
    Asia_Krasnoyarsk = 'Asia/Krasnoyarsk'
    Asia_Kuala_Lumpur = 'Asia/Kuala_Lumpur'
    Asia_Kuching = 'Asia/Kuching'
    Asia_Kuwait = 'Asia/Kuwait'
    Asia_Macau = 'Asia/Macau'
    Asia_Magadan = 'Asia/Magadan'
    Asia_Makassar = 'Asia/Makassar'
    Asia_Manila = 'Asia/Manila'
    Asia_Muscat = 'Asia/Muscat'
    Asia_Nicosia = 'Asia/Nicosia'
    Asia_Novokuznetsk = 'Asia/Novokuznetsk'
    Asia_Novosibirsk = 'Asia/Novosibirsk'
    Asia_Omsk = 'Asia/Omsk'
    Asia_Oral = 'Asia/Oral'
    Asia_Phnom_Penh = 'Asia/Phnom_Penh'
    Asia_Pontianak = 'Asia/Pontianak'
    Asia_Pyongyang = 'Asia/Pyongyang'
    Asia_Qatar = 'Asia/Qatar'
    Asia_Qostanay = 'Asia/Qostanay'
    Asia_Qyzylorda = 'Asia/Qyzylorda'
    Asia_Riyadh = 'Asia/Riyadh'
    Asia_Sakhalin = 'Asia/Sakhalin'
    Asia_Samarkand = 'Asia/Samarkand'
    Asia_Seoul = 'Asia/Seoul'
    Asia_Shanghai = 'Asia/Shanghai'
    Asia_Singapore = 'Asia/Singapore'
    Asia_Srednekolymsk = 'Asia/Srednekolymsk'
    Asia_Taipei = 'Asia/Taipei'
    Asia_Tashkent = 'Asia/Tashkent'
    Asia_Tbilisi = 'Asia/Tbilisi'
    Asia_Tehran = 'Asia/Tehran'
    Asia_Thimphu = 'Asia/Thimphu'
    Asia_Tokyo = 'Asia/Tokyo'
    Asia_Tomsk = 'Asia/Tomsk'
    Asia_Ulaanbaatar = 'Asia/Ulaanbaatar'
    Asia_Urumqi = 'Asia/Urumqi'
    Asia_Ust_Nera = 'Asia/Ust-Nera'
    Asia_Vientiane = 'Asia/Vientiane'
    Asia_Vladivostok = 'Asia/Vladivostok'
    Asia_Yakutsk = 'Asia/Yakutsk'
    Asia_Yangon = 'Asia/Yangon'
    Asia_Yekaterinburg = 'Asia/Yekaterinburg'
    Asia_Yerevan = 'Asia/Yerevan'
    Atlantic_Azores = 'Atlantic/Azores'
    Atlantic_Bermuda = 'Atlantic/Bermuda'
    Atlantic_Canary = 'Atlantic/Canary'
    Atlantic_Cape_Verde = 'Atlantic/Cape_Verde'
    Atlantic_Faroe = 'Atlantic/Faroe'
    Atlantic_Madeira = 'Atlantic/Madeira'
    Atlantic_Reykjavik = 'Atlantic/Reykjavik'
    Atlantic_South_Georgia = 'Atlantic/South_Georgia'
    Atlantic_St_Helena = 'Atlantic/St_Helena'
    Atlantic_Stanley = 'Atlantic/Stanley'
    Australia_Adelaide = 'Australia/Adelaide'
    Australia_Brisbane = 'Australia/Brisbane'
    Australia_Broken_Hill = 'Australia/Broken_Hill'
    Australia_Darwin = 'Australia/Darwin'
    Australia_Eucla = 'Australia/Eucla'
    Australia_Hobart = 'Australia/Hobart'
    Australia_Lindeman = 'Australia/Lindeman'
    Australia_Lord_Howe = 'Australia/Lord_Howe'
    Australia_Melbourne = 'Australia/Melbourne'
    Australia_Perth = 'Australia/Perth'
    Australia_Sydney = 'Australia/Sydney'
    Canada_Atlantic = 'Canada/Atlantic'
    Canada_Central = 'Canada/Central'
    Canada_Eastern = 'Canada/Eastern'
    Canada_Mountain = 'Canada/Mountain'
    Canada_Newfoundland = 'Canada/Newfoundland'
    Canada_Pacific = 'Canada/Pacific'
    Europe_Amsterdam = 'Europe/Amsterdam'
    Europe_Andorra = 'Europe/Andorra'
    Europe_Astrakhan = 'Europe/Astrakhan'
    Europe_Athens = 'Europe/Athens'
    Europe_Belgrade = 'Europe/Belgrade'
    Europe_Berlin = 'Europe/Berlin'
    Europe_Bratislava = 'Europe/Bratislava'
    Europe_Brussels = 'Europe/Brussels'
    Europe_Bucharest = 'Europe/Bucharest'
    Europe_Budapest = 'Europe/Budapest'
    Europe_Busingen = 'Europe/Busingen'
    Europe_Chisinau = 'Europe/Chisinau'
    Europe_Copenhagen = 'Europe/Copenhagen'
    Europe_Dublin = 'Europe/Dublin'
    Europe_Gibraltar = 'Europe/Gibraltar'
    Europe_Guernsey = 'Europe/Guernsey'
    Europe_Helsinki = 'Europe/Helsinki'
    Europe_Isle_of_Man = 'Europe/Isle_of_Man'
    Europe_Istanbul = 'Europe/Istanbul'
    Europe_Jersey = 'Europe/Jersey'
    Europe_Kaliningrad = 'Europe/Kaliningrad'
    Europe_Kirov = 'Europe/Kirov'
    Europe_Kyiv = 'Europe/Kyiv'
    Europe_Lisbon = 'Europe/Lisbon'
    Europe_Ljubljana = 'Europe/Ljubljana'
    Europe_London = 'Europe/London'
    Europe_Luxembourg = 'Europe/Luxembourg'
    Europe_Madrid = 'Europe/Madrid'
    Europe_Malta = 'Europe/Malta'
    Europe_Mariehamn = 'Europe/Mariehamn'
    Europe_Minsk = 'Europe/Minsk'
    Europe_Monaco = 'Europe/Monaco'
    Europe_Moscow = 'Europe/Moscow'
    Europe_Oslo = 'Europe/Oslo'
    Europe_Paris = 'Europe/Paris'
    Europe_Podgorica = 'Europe/Podgorica'
    Europe_Prague = 'Europe/Prague'
    Europe_Riga = 'Europe/Riga'
    Europe_Rome = 'Europe/Rome'
    Europe_Samara = 'Europe/Samara'
    Europe_San_Marino = 'Europe/San_Marino'
    Europe_Sarajevo = 'Europe/Sarajevo'
    Europe_Saratov = 'Europe/Saratov'
    Europe_Simferopol = 'Europe/Simferopol'
    Europe_Skopje = 'Europe/Skopje'
    Europe_Sofia = 'Europe/Sofia'
    Europe_Stockholm = 'Europe/Stockholm'
    Europe_Tallinn = 'Europe/Tallinn'
    Europe_Tirane = 'Europe/Tirane'
    Europe_Ulyanovsk = 'Europe/Ulyanovsk'
    Europe_Vaduz = 'Europe/Vaduz'
    Europe_Vatican = 'Europe/Vatican'
    Europe_Vienna = 'Europe/Vienna'
    Europe_Vilnius = 'Europe/Vilnius'
    Europe_Volgograd = 'Europe/Volgograd'
    Europe_Warsaw = 'Europe/Warsaw'
    Europe_Zagreb = 'Europe/Zagreb'
    Europe_Zurich = 'Europe/Zurich'
    GMT = 'GMT'
    Indian_Antananarivo = 'Indian/Antananarivo'
    Indian_Chagos = 'Indian/Chagos'
    Indian_Christmas = 'Indian/Christmas'
    Indian_Cocos = 'Indian/Cocos'
    Indian_Comoro = 'Indian/Comoro'
    Indian_Kerguelen = 'Indian/Kerguelen'
    Indian_Mahe = 'Indian/Mahe'
    Indian_Maldives = 'Indian/Maldives'
    Indian_Mauritius = 'Indian/Mauritius'
    Indian_Mayotte = 'Indian/Mayotte'
    Indian_Reunion = 'Indian/Reunion'
    Pacific_Apia = 'Pacific/Apia'
    Pacific_Auckland = 'Pacific/Auckland'
    Pacific_Bougainville = 'Pacific/Bougainville'
    Pacific_Chatham = 'Pacific/Chatham'
    Pacific_Chuuk = 'Pacific/Chuuk'
    Pacific_Easter = 'Pacific/Easter'
    Pacific_Efate = 'Pacific/Efate'
    Pacific_Fakaofo = 'Pacific/Fakaofo'
    Pacific_Fiji = 'Pacific/Fiji'
    Pacific_Funafuti = 'Pacific/Funafuti'
    Pacific_Galapagos = 'Pacific/Galapagos'
    Pacific_Gambier = 'Pacific/Gambier'
    Pacific_Guadalcanal = 'Pacific/Guadalcanal'
    Pacific_Guam = 'Pacific/Guam'
    Pacific_Honolulu = 'Pacific/Honolulu'
    Pacific_Kanton = 'Pacific/Kanton'
    Pacific_Kiritimati = 'Pacific/Kiritimati'
    Pacific_Kosrae = 'Pacific/Kosrae'
    Pacific_Kwajalein = 'Pacific/Kwajalein'
    Pacific_Majuro = 'Pacific/Majuro'
    Pacific_Marquesas = 'Pacific/Marquesas'
    Pacific_Midway = 'Pacific/Midway'
    Pacific_Nauru = 'Pacific/Nauru'
    Pacific_Niue = 'Pacific/Niue'
    Pacific_Norfolk = 'Pacific/Norfolk'
    Pacific_Noumea = 'Pacific/Noumea'
    Pacific_Pago_Pago = 'Pacific/Pago_Pago'
    Pacific_Palau = 'Pacific/Palau'
    Pacific_Pitcairn = 'Pacific/Pitcairn'
    Pacific_Pohnpei = 'Pacific/Pohnpei'
    Pacific_Port_Moresby = 'Pacific/Port_Moresby'
    Pacific_Rarotonga = 'Pacific/Rarotonga'
    Pacific_Saipan = 'Pacific/Saipan'
    Pacific_Tahiti = 'Pacific/Tahiti'
    Pacific_Tarawa = 'Pacific/Tarawa'
    Pacific_Tongatapu = 'Pacific/Tongatapu'
    Pacific_Wake = 'Pacific/Wake'
    Pacific_Wallis = 'Pacific/Wallis'
    US_Alaska = 'US/Alaska'
    US_Arizona = 'US/Arizona'
    US_Central = 'US/Central'
    US_Eastern = 'US/Eastern'
    US_Hawaii = 'US/Hawaii'
    US_Mountain = 'US/Mountain'
    US_Pacific = 'US/Pacific'
    UTC = 'UTC'


class CustomerUpdate(BaseModel):
    default_currency_code: str
    address: Optional[Address] = None
    tax_rate: Optional[confloat(ge=0.0, le=999.9999)] = Field(
        None, description='Tax rate as percentage. For example, 10.5 for 10.5%'
    )
    timezone: Timezone1


class CustomerWithRevenue(BaseModel):
    customer_id: Optional[constr(regex=r'^[-a-zA-Z0-9_]+$', max_length=50)] = Field(
        None,
        description='The id provided when creating the customer, we suggest matching with your internal customer id in your backend',
    )
    total_amount_due: float


class DayMetricUsage(BaseModel):
    date: date
    customer_usages: Dict[str, confloat(lt=10000000000.0, gt=-10000000000.0)]


class DemoLoginFailure(BaseModel):
    detail: str


class DemoLoginRequestRequest(BaseModel):
    username: constr(min_length=1)
    password: constr(min_length=1)


class DemoRegistrationDetailRequest(BaseModel):
    email: constr(min_length=1)
    password: constr(min_length=1)
    username: constr(min_length=1)


class DemoRegistrationFailure(BaseModel):
    detail: str


class DemoRegistrationRequest(BaseModel):
    register_: DemoRegistrationDetailRequest = Field(..., alias='register')


class EmailRequest(BaseModel):
    email: EmailStr


class Event(BaseModel):
    event_name: constr(max_length=100) = Field(
        ...,
        description='String name of the event, corresponds to definition in metrics',
    )
    properties: Optional[Dict[str, Any]] = Field(
        None,
        description='Extra metadata on the event that can be filtered and queried on in the metrics. All key value pairs should have string keys and values can be either strings or numbers. Place subscription filters in this object to specify which subscription the event should be tracked under',
    )
    time_created: datetime = Field(
        ...,
        description='The time that the event occured, represented as a datetime in ISO 8601 in the UTC timezome.',
    )
    idempotency_id: str = Field(
        ...,
        description='A unique identifier for the specific event being passed in. Passing in a unique id allows Lotus to make sure no double counting occurs. We recommend using a UUID4. You can use the same idempotency_id again after 7 days',
    )
    customer_id: str = Field(
        ...,
        description='The id of the customer that this event is associated with, usually the customer id in your backend',
    )


class EventRequest(BaseModel):
    event_name: constr(min_length=1, max_length=100) = Field(
        ...,
        description='String name of the event, corresponds to definition in metrics',
    )
    properties: Optional[Dict[str, Any]] = Field(
        None,
        description='Extra metadata on the event that can be filtered and queried on in the metrics. All key value pairs should have string keys and values can be either strings or numbers. Place subscription filters in this object to specify which subscription the event should be tracked under',
    )
    time_created: datetime = Field(
        ...,
        description='The time that the event occured, represented as a datetime in ISO 8601 in the UTC timezome.',
    )
    idempotency_id: constr(min_length=1) = Field(
        ...,
        description='A unique identifier for the specific event being passed in. Passing in a unique id allows Lotus to make sure no double counting occurs. We recommend using a UUID4. You can use the same idempotency_id again after 7 days',
    )
    customer_id: constr(min_length=1) = Field(
        ...,
        description='The id of the customer that this event is associated with, usually the customer id in your backend',
    )


class Source(Enum):
    stripe = 'stripe'


class ExternalPlanLink(BaseModel):
    source: Source
    external_plan_id: constr(max_length=100)


class Source1(Enum):
    stripe = 'stripe'


class ExternalPlanLinkRequest(BaseModel):
    plan_id: UUID
    source: Source1
    external_plan_id: constr(min_length=1, max_length=100)


class Feature(BaseModel):
    feature_id: str
    feature_name: str
    feature_description: Optional[str] = Field(...)


class FeatureCreateRequest(BaseModel):
    feature_name: constr(min_length=1, max_length=50)
    feature_description: Optional[str] = None


class GetInvoicePdfURLResponse(BaseModel):
    url: AnyUrl


class Status5(Enum):
    error = 'error'


class ImportCustomerFailure(BaseModel):
    status: Status5
    detail: str


class Status6(Enum):
    success = 'success'


class ImportCustomerSuccess(BaseModel):
    status: Status6
    detail: str


class Source2(Enum):
    stripe = 'stripe'


class ImportCustomersRequestRequest(BaseModel):
    source: Source2


class Status7(Enum):
    error = 'error'


class ImportPaymentObjectFailure(BaseModel):
    status: Status7
    detail: str


class Status8(Enum):
    success = 'success'


class ImportPaymentObjectSuccess(BaseModel):
    status: Status8
    detail: str


class Source3(Enum):
    stripe = 'stripe'


class ImportPaymentObjectsRequestRequest(BaseModel):
    source: Source3


class InitResetPasswordSuccess(BaseModel):
    email: str


class Source4(Enum):
    stripe = 'stripe'


class InitialExternalPlanLink(BaseModel):
    source: Source4
    external_plan_id: constr(max_length=100)


class Source5(Enum):
    stripe = 'stripe'


class InitialExternalPlanLinkRequest(BaseModel):
    source: Source5
    external_plan_id: constr(min_length=1, max_length=100)


class UsageBillingFrequencyEnum(Enum):
    monthly = 'monthly'
    quarterly = 'quarterly'
    end_of_period = 'end_of_period'
    field_ = ''


class UsageBillingFrequency(BaseModel):
    __root__: Optional[UsageBillingFrequencyEnum] = None


class InviteRequestRequest(BaseModel):
    email: EmailStr


class InviteResponse(BaseModel):
    email: EmailStr


class PaymentStatus(Enum):
    draft = 'draft'
    voided = 'voided'
    paid = 'paid'
    unpaid = 'unpaid'


class ExternalPaymentObjTypeEnum(Enum):
    stripe = 'stripe'


class ExternalPaymentObjType(BaseModel):
    __root__: Optional[ExternalPaymentObjTypeEnum] = None


class BillingTypeEnum(Enum):
    in_arrears = 'in_arrears'
    in_advance = 'in_advance'
    one_time = 'one_time'


class BillingType(BaseModel):
    __root__: Optional[BillingTypeEnum] = None


class BillingType1Enum(Enum):
    in_arrears = 'in_arrears'
    in_advance = 'in_advance'
    one_time = 'one_time'


class BillingType1(BaseModel):
    __root__: Optional[BillingType1Enum] = None


class InvoiceLineItemRequest(BaseModel):
    name: constr(min_length=1, max_length=100)
    start_date: datetime
    end_date: datetime
    quantity: Optional[confloat(ge=0.0, lt=10000000000.0)] = Field(...)
    subtotal: confloat(lt=10000000000.0, gt=-10000000000.0)
    billing_type: Optional[BillingType1] = Field(...)
    metadata: Optional[Dict[str, Any]] = Field(...)


class ExternalPaymentObjType1Enum(Enum):
    stripe = 'stripe'


class ExternalPaymentObjType1(BaseModel):
    __root__: Optional[ExternalPaymentObjType1Enum] = None


class PaymentStatus1(Enum):
    paid = 'paid'
    unpaid = 'unpaid'


class InvoiceUpdate(BaseModel):
    payment_status: PaymentStatus1


class AddonType1(Enum):
    flat = 'flat'
    usage_based = 'usage_based'


class BillingFrequency2(Enum):
    one_time = 'one_time'
    recurring = 'recurring'


class LightweightAddon(BaseModel):
    addon_name: str = Field(..., description='The name of the add-on plan.')
    addon_id: str = Field(..., description='The ID of the add-on plan.')
    addon_type: AddonType1
    billing_frequency: BillingFrequency2


class LightweightAddonRequest(BaseModel):
    addon_name: constr(min_length=1) = Field(
        ..., description='The name of the add-on plan.'
    )
    addon_id: constr(min_length=1) = Field(
        ..., description='The ID of the add-on plan.'
    )


class LightweightAddonSubscriptionRecord(BaseModel):
    start_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )
    end_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )
    addon: LightweightAddon
    fully_billed: bool = Field(
        ..., description='Whether the subscription has been fully billed and finalized.'
    )


class LightweightAddonSubscriptionRecordRequest(BaseModel):
    start_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )
    end_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )
    addon: LightweightAddonRequest
    fully_billed: bool = Field(
        ..., description='Whether the subscription has been fully billed and finalized.'
    )


class LightweightCustomer(BaseModel):
    customer_name: Optional[str] = Field(
        ..., description='The display name of the customer'
    )
    email: Optional[EmailStr] = Field(
        ...,
        description='The primary email address of the customer, must be the same as the email address used to create the customer in the payment provider',
    )
    customer_id: constr(regex=r'^[-a-zA-Z0-9_]+$') = Field(
        ...,
        description='The id provided when creating the customer, we suggest matching with your internal customer id in your backend',
    )


class LightweightCustomerSerializerForInvoice(BaseModel):
    customer_name: Optional[str] = Field(
        ..., description='The display name of the customer'
    )
    email: Optional[EmailStr] = Field(
        ...,
        description='The primary email address of the customer, must be the same as the email address used to create the customer in the payment provider',
    )
    customer_id: constr(regex=r'^[-a-zA-Z0-9_]+$') = Field(
        ...,
        description='The id provided when creating the customer, we suggest matching with your internal customer id in your backend',
    )
    address: Optional[Address] = None


class ExternalPaymentObjType2Enum(Enum):
    stripe = 'stripe'


class ExternalPaymentObjType2(BaseModel):
    __root__: Optional[ExternalPaymentObjType2Enum] = None


class PaymentStatus2(Enum):
    draft = 'draft'
    voided = 'voided'
    paid = 'paid'
    unpaid = 'unpaid'


class BillingType2Enum(Enum):
    in_arrears = 'in_arrears'
    in_advance = 'in_advance'
    one_time = 'one_time'


class BillingType2(BaseModel):
    __root__: Optional[BillingType2Enum] = None


class LightweightMetric(BaseModel):
    metric_id: str
    event_name: str = Field(
        ..., description='Name of the event that this metric is tracking.'
    )
    metric_name: str


class OrganizationType(Enum):
    Production = 'Production'
    Development = 'Development'
    Demo = 'Demo'
    Internal_Demo = 'Internal Demo'


class LightweightOrganization(BaseModel):
    organization_id: str
    organization_name: constr(max_length=100)
    organization_type: OrganizationType
    current: bool


class LightweightPlanVersion(BaseModel):
    plan_name: str
    plan_id: str
    version: int
    version_id: str


class LightweightPlanVersionRequest(BaseModel):
    plan_name: constr(min_length=1)
    plan_id: constr(min_length=1)


class LightweightSubscriptionRecordRequest(BaseModel):
    fully_billed: bool = Field(
        ..., description='Whether the subscription has been fully billed and finalized.'
    )
    addons: List[LightweightAddonSubscriptionRecordRequest]
    auto_renew: bool = Field(
        ...,
        description='Whether the subscription automatically renews. Defaults to true.',
    )
    is_new: bool = Field(
        ...,
        description='Whether this subscription came from a renewal or from a first-time. Defaults to true on creation.',
    )
    start_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )
    billing_plan: LightweightPlanVersionRequest
    end_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )


class LightweightUser(BaseModel):
    username: constr(regex=r'^[\w.@+-]+$', max_length=150) = Field(
        ...,
        description='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.',
    )
    email: EmailStr


class LoginFailure(BaseModel):
    detail: str


class LoginRequestRequest(BaseModel):
    username: constr(min_length=1)
    password: constr(min_length=1)


class LogoutFailure(BaseModel):
    detail: str


class LogoutSuccess(BaseModel):
    detail: str


class GranularityEnum(Enum):
    seconds = 'seconds'
    minutes = 'minutes'
    hours = 'hours'
    days = 'days'
    months = 'months'
    quarters = 'quarters'
    years = 'years'
    total = 'total'


class Granularity(BaseModel):
    __root__: Optional[GranularityEnum] = Field(
        None,
        description="The granularity of the metric. Only applies to metrics of type 'gauge' or 'rate'.",
    )


class EventTypeEnum(Enum):
    delta = 'delta'
    total = 'total'


class EventType(BaseModel):
    __root__: Optional[EventTypeEnum] = Field(
        None,
        description="Used only for metrics of type 'gauge'. Please refer to our documentation for an explanation of the different types.",
    )


class MetricType(Enum):
    counter = 'counter'
    rate = 'rate'
    custom = 'custom'
    gauge = 'gauge'


class ProrationEnum(Enum):
    seconds = 'seconds'
    minutes = 'minutes'
    hours = 'hours'
    days = 'days'
    months = 'months'
    quarters = 'quarters'
    years = 'years'
    total = 'total'


class Proration(BaseModel):
    __root__: Optional[ProrationEnum] = Field(
        None,
        description="The proration of the metric. Only applies to metrics of type 'gauge'.",
    )


class UsageAggregationTypeEnum(Enum):
    count = 'count'
    sum = 'sum'
    max = 'max'
    unique = 'unique'
    latest = 'latest'
    average = 'average'


class UsageAggregationType(BaseModel):
    __root__: Optional[UsageAggregationTypeEnum] = Field(
        None,
        description='The type of aggregation that should be used for this metric. Please refer to our documentation for an explanation of the different types.',
    )


class BillableAggregationTypeEnum(Enum):
    count = 'count'
    sum = 'sum'
    max = 'max'
    unique = 'unique'
    latest = 'latest'
    average = 'average'


class BillableAggregationType(BaseModel):
    __root__: Optional[BillableAggregationTypeEnum] = None


class Granularity1Enum(Enum):
    seconds = 'seconds'
    minutes = 'minutes'
    hours = 'hours'
    days = 'days'
    months = 'months'
    quarters = 'quarters'
    years = 'years'
    total = 'total'


class Granularity1(BaseModel):
    __root__: Optional[Granularity1Enum] = Field(
        None,
        description="The granularity of the metric. Only applies to metrics of type 'gauge' or 'rate'.",
    )


class EventType1Enum(Enum):
    delta = 'delta'
    total = 'total'


class EventType1(BaseModel):
    __root__: Optional[EventType1Enum] = Field(
        None,
        description="Used only for metrics of type 'gauge'. Please refer to our documentation for an explanation of the different types.",
    )


class MetricType1(Enum):
    counter = 'counter'
    rate = 'rate'
    custom = 'custom'
    gauge = 'gauge'


class Proration1Enum(Enum):
    seconds = 'seconds'
    minutes = 'minutes'
    hours = 'hours'
    days = 'days'
    months = 'months'
    quarters = 'quarters'
    years = 'years'
    total = 'total'


class Proration1(BaseModel):
    __root__: Optional[Proration1Enum] = Field(
        None,
        description="The proration of the metric. Only applies to metrics of type 'gauge'.",
    )


class MetricRevenue(BaseModel):
    metric_name: str
    original_plan_revenue: float
    new_plan_revenue: float


class Status9(Enum):
    active = 'active'
    archived = 'archived'


class MetricUpdate(BaseModel):
    billable_metric_name: Optional[constr(max_length=50)] = None
    status: Optional[Status9] = None


class Operator2(Enum):
    gte = 'gte'
    gt = 'gt'
    eq = 'eq'
    lt = 'lt'
    lte = 'lte'


class NumericFilter(BaseModel):
    property_name: constr(max_length=100)
    operator: Operator2
    comparison_value: float


class Operator3(Enum):
    gte = 'gte'
    gt = 'gt'
    eq = 'eq'
    lt = 'lt'
    lte = 'lte'


class NumericFilterRequest(BaseModel):
    property_name: constr(min_length=1, max_length=100)
    operator: Operator3
    comparison_value: float


class Timezone2(Enum):
    Africa_Abidjan = 'Africa/Abidjan'
    Africa_Accra = 'Africa/Accra'
    Africa_Addis_Ababa = 'Africa/Addis_Ababa'
    Africa_Algiers = 'Africa/Algiers'
    Africa_Asmara = 'Africa/Asmara'
    Africa_Bamako = 'Africa/Bamako'
    Africa_Bangui = 'Africa/Bangui'
    Africa_Banjul = 'Africa/Banjul'
    Africa_Bissau = 'Africa/Bissau'
    Africa_Blantyre = 'Africa/Blantyre'
    Africa_Brazzaville = 'Africa/Brazzaville'
    Africa_Bujumbura = 'Africa/Bujumbura'
    Africa_Cairo = 'Africa/Cairo'
    Africa_Casablanca = 'Africa/Casablanca'
    Africa_Ceuta = 'Africa/Ceuta'
    Africa_Conakry = 'Africa/Conakry'
    Africa_Dakar = 'Africa/Dakar'
    Africa_Dar_es_Salaam = 'Africa/Dar_es_Salaam'
    Africa_Djibouti = 'Africa/Djibouti'
    Africa_Douala = 'Africa/Douala'
    Africa_El_Aaiun = 'Africa/El_Aaiun'
    Africa_Freetown = 'Africa/Freetown'
    Africa_Gaborone = 'Africa/Gaborone'
    Africa_Harare = 'Africa/Harare'
    Africa_Johannesburg = 'Africa/Johannesburg'
    Africa_Juba = 'Africa/Juba'
    Africa_Kampala = 'Africa/Kampala'
    Africa_Khartoum = 'Africa/Khartoum'
    Africa_Kigali = 'Africa/Kigali'
    Africa_Kinshasa = 'Africa/Kinshasa'
    Africa_Lagos = 'Africa/Lagos'
    Africa_Libreville = 'Africa/Libreville'
    Africa_Lome = 'Africa/Lome'
    Africa_Luanda = 'Africa/Luanda'
    Africa_Lubumbashi = 'Africa/Lubumbashi'
    Africa_Lusaka = 'Africa/Lusaka'
    Africa_Malabo = 'Africa/Malabo'
    Africa_Maputo = 'Africa/Maputo'
    Africa_Maseru = 'Africa/Maseru'
    Africa_Mbabane = 'Africa/Mbabane'
    Africa_Mogadishu = 'Africa/Mogadishu'
    Africa_Monrovia = 'Africa/Monrovia'
    Africa_Nairobi = 'Africa/Nairobi'
    Africa_Ndjamena = 'Africa/Ndjamena'
    Africa_Niamey = 'Africa/Niamey'
    Africa_Nouakchott = 'Africa/Nouakchott'
    Africa_Ouagadougou = 'Africa/Ouagadougou'
    Africa_Porto_Novo = 'Africa/Porto-Novo'
    Africa_Sao_Tome = 'Africa/Sao_Tome'
    Africa_Tripoli = 'Africa/Tripoli'
    Africa_Tunis = 'Africa/Tunis'
    Africa_Windhoek = 'Africa/Windhoek'
    America_Adak = 'America/Adak'
    America_Anchorage = 'America/Anchorage'
    America_Anguilla = 'America/Anguilla'
    America_Antigua = 'America/Antigua'
    America_Araguaina = 'America/Araguaina'
    America_Argentina_Buenos_Aires = 'America/Argentina/Buenos_Aires'
    America_Argentina_Catamarca = 'America/Argentina/Catamarca'
    America_Argentina_Cordoba = 'America/Argentina/Cordoba'
    America_Argentina_Jujuy = 'America/Argentina/Jujuy'
    America_Argentina_La_Rioja = 'America/Argentina/La_Rioja'
    America_Argentina_Mendoza = 'America/Argentina/Mendoza'
    America_Argentina_Rio_Gallegos = 'America/Argentina/Rio_Gallegos'
    America_Argentina_Salta = 'America/Argentina/Salta'
    America_Argentina_San_Juan = 'America/Argentina/San_Juan'
    America_Argentina_San_Luis = 'America/Argentina/San_Luis'
    America_Argentina_Tucuman = 'America/Argentina/Tucuman'
    America_Argentina_Ushuaia = 'America/Argentina/Ushuaia'
    America_Aruba = 'America/Aruba'
    America_Asuncion = 'America/Asuncion'
    America_Atikokan = 'America/Atikokan'
    America_Bahia = 'America/Bahia'
    America_Bahia_Banderas = 'America/Bahia_Banderas'
    America_Barbados = 'America/Barbados'
    America_Belem = 'America/Belem'
    America_Belize = 'America/Belize'
    America_Blanc_Sablon = 'America/Blanc-Sablon'
    America_Boa_Vista = 'America/Boa_Vista'
    America_Bogota = 'America/Bogota'
    America_Boise = 'America/Boise'
    America_Cambridge_Bay = 'America/Cambridge_Bay'
    America_Campo_Grande = 'America/Campo_Grande'
    America_Cancun = 'America/Cancun'
    America_Caracas = 'America/Caracas'
    America_Cayenne = 'America/Cayenne'
    America_Cayman = 'America/Cayman'
    America_Chicago = 'America/Chicago'
    America_Chihuahua = 'America/Chihuahua'
    America_Ciudad_Juarez = 'America/Ciudad_Juarez'
    America_Costa_Rica = 'America/Costa_Rica'
    America_Creston = 'America/Creston'
    America_Cuiaba = 'America/Cuiaba'
    America_Curacao = 'America/Curacao'
    America_Danmarkshavn = 'America/Danmarkshavn'
    America_Dawson = 'America/Dawson'
    America_Dawson_Creek = 'America/Dawson_Creek'
    America_Denver = 'America/Denver'
    America_Detroit = 'America/Detroit'
    America_Dominica = 'America/Dominica'
    America_Edmonton = 'America/Edmonton'
    America_Eirunepe = 'America/Eirunepe'
    America_El_Salvador = 'America/El_Salvador'
    America_Fort_Nelson = 'America/Fort_Nelson'
    America_Fortaleza = 'America/Fortaleza'
    America_Glace_Bay = 'America/Glace_Bay'
    America_Goose_Bay = 'America/Goose_Bay'
    America_Grand_Turk = 'America/Grand_Turk'
    America_Grenada = 'America/Grenada'
    America_Guadeloupe = 'America/Guadeloupe'
    America_Guatemala = 'America/Guatemala'
    America_Guayaquil = 'America/Guayaquil'
    America_Guyana = 'America/Guyana'
    America_Halifax = 'America/Halifax'
    America_Havana = 'America/Havana'
    America_Hermosillo = 'America/Hermosillo'
    America_Indiana_Indianapolis = 'America/Indiana/Indianapolis'
    America_Indiana_Knox = 'America/Indiana/Knox'
    America_Indiana_Marengo = 'America/Indiana/Marengo'
    America_Indiana_Petersburg = 'America/Indiana/Petersburg'
    America_Indiana_Tell_City = 'America/Indiana/Tell_City'
    America_Indiana_Vevay = 'America/Indiana/Vevay'
    America_Indiana_Vincennes = 'America/Indiana/Vincennes'
    America_Indiana_Winamac = 'America/Indiana/Winamac'
    America_Inuvik = 'America/Inuvik'
    America_Iqaluit = 'America/Iqaluit'
    America_Jamaica = 'America/Jamaica'
    America_Juneau = 'America/Juneau'
    America_Kentucky_Louisville = 'America/Kentucky/Louisville'
    America_Kentucky_Monticello = 'America/Kentucky/Monticello'
    America_Kralendijk = 'America/Kralendijk'
    America_La_Paz = 'America/La_Paz'
    America_Lima = 'America/Lima'
    America_Los_Angeles = 'America/Los_Angeles'
    America_Lower_Princes = 'America/Lower_Princes'
    America_Maceio = 'America/Maceio'
    America_Managua = 'America/Managua'
    America_Manaus = 'America/Manaus'
    America_Marigot = 'America/Marigot'
    America_Martinique = 'America/Martinique'
    America_Matamoros = 'America/Matamoros'
    America_Mazatlan = 'America/Mazatlan'
    America_Menominee = 'America/Menominee'
    America_Merida = 'America/Merida'
    America_Metlakatla = 'America/Metlakatla'
    America_Mexico_City = 'America/Mexico_City'
    America_Miquelon = 'America/Miquelon'
    America_Moncton = 'America/Moncton'
    America_Monterrey = 'America/Monterrey'
    America_Montevideo = 'America/Montevideo'
    America_Montserrat = 'America/Montserrat'
    America_Nassau = 'America/Nassau'
    America_New_York = 'America/New_York'
    America_Nome = 'America/Nome'
    America_Noronha = 'America/Noronha'
    America_North_Dakota_Beulah = 'America/North_Dakota/Beulah'
    America_North_Dakota_Center = 'America/North_Dakota/Center'
    America_North_Dakota_New_Salem = 'America/North_Dakota/New_Salem'
    America_Nuuk = 'America/Nuuk'
    America_Ojinaga = 'America/Ojinaga'
    America_Panama = 'America/Panama'
    America_Paramaribo = 'America/Paramaribo'
    America_Phoenix = 'America/Phoenix'
    America_Port_au_Prince = 'America/Port-au-Prince'
    America_Port_of_Spain = 'America/Port_of_Spain'
    America_Porto_Velho = 'America/Porto_Velho'
    America_Puerto_Rico = 'America/Puerto_Rico'
    America_Punta_Arenas = 'America/Punta_Arenas'
    America_Rankin_Inlet = 'America/Rankin_Inlet'
    America_Recife = 'America/Recife'
    America_Regina = 'America/Regina'
    America_Resolute = 'America/Resolute'
    America_Rio_Branco = 'America/Rio_Branco'
    America_Santarem = 'America/Santarem'
    America_Santiago = 'America/Santiago'
    America_Santo_Domingo = 'America/Santo_Domingo'
    America_Sao_Paulo = 'America/Sao_Paulo'
    America_Scoresbysund = 'America/Scoresbysund'
    America_Sitka = 'America/Sitka'
    America_St_Barthelemy = 'America/St_Barthelemy'
    America_St_Johns = 'America/St_Johns'
    America_St_Kitts = 'America/St_Kitts'
    America_St_Lucia = 'America/St_Lucia'
    America_St_Thomas = 'America/St_Thomas'
    America_St_Vincent = 'America/St_Vincent'
    America_Swift_Current = 'America/Swift_Current'
    America_Tegucigalpa = 'America/Tegucigalpa'
    America_Thule = 'America/Thule'
    America_Tijuana = 'America/Tijuana'
    America_Toronto = 'America/Toronto'
    America_Tortola = 'America/Tortola'
    America_Vancouver = 'America/Vancouver'
    America_Whitehorse = 'America/Whitehorse'
    America_Winnipeg = 'America/Winnipeg'
    America_Yakutat = 'America/Yakutat'
    America_Yellowknife = 'America/Yellowknife'
    Antarctica_Casey = 'Antarctica/Casey'
    Antarctica_Davis = 'Antarctica/Davis'
    Antarctica_DumontDUrville = 'Antarctica/DumontDUrville'
    Antarctica_Macquarie = 'Antarctica/Macquarie'
    Antarctica_Mawson = 'Antarctica/Mawson'
    Antarctica_McMurdo = 'Antarctica/McMurdo'
    Antarctica_Palmer = 'Antarctica/Palmer'
    Antarctica_Rothera = 'Antarctica/Rothera'
    Antarctica_Syowa = 'Antarctica/Syowa'
    Antarctica_Troll = 'Antarctica/Troll'
    Antarctica_Vostok = 'Antarctica/Vostok'
    Arctic_Longyearbyen = 'Arctic/Longyearbyen'
    Asia_Aden = 'Asia/Aden'
    Asia_Almaty = 'Asia/Almaty'
    Asia_Amman = 'Asia/Amman'
    Asia_Anadyr = 'Asia/Anadyr'
    Asia_Aqtau = 'Asia/Aqtau'
    Asia_Aqtobe = 'Asia/Aqtobe'
    Asia_Ashgabat = 'Asia/Ashgabat'
    Asia_Atyrau = 'Asia/Atyrau'
    Asia_Baghdad = 'Asia/Baghdad'
    Asia_Bahrain = 'Asia/Bahrain'
    Asia_Baku = 'Asia/Baku'
    Asia_Bangkok = 'Asia/Bangkok'
    Asia_Barnaul = 'Asia/Barnaul'
    Asia_Beirut = 'Asia/Beirut'
    Asia_Bishkek = 'Asia/Bishkek'
    Asia_Brunei = 'Asia/Brunei'
    Asia_Chita = 'Asia/Chita'
    Asia_Choibalsan = 'Asia/Choibalsan'
    Asia_Colombo = 'Asia/Colombo'
    Asia_Damascus = 'Asia/Damascus'
    Asia_Dhaka = 'Asia/Dhaka'
    Asia_Dili = 'Asia/Dili'
    Asia_Dubai = 'Asia/Dubai'
    Asia_Dushanbe = 'Asia/Dushanbe'
    Asia_Famagusta = 'Asia/Famagusta'
    Asia_Gaza = 'Asia/Gaza'
    Asia_Hebron = 'Asia/Hebron'
    Asia_Ho_Chi_Minh = 'Asia/Ho_Chi_Minh'
    Asia_Hong_Kong = 'Asia/Hong_Kong'
    Asia_Hovd = 'Asia/Hovd'
    Asia_Irkutsk = 'Asia/Irkutsk'
    Asia_Jakarta = 'Asia/Jakarta'
    Asia_Jayapura = 'Asia/Jayapura'
    Asia_Jerusalem = 'Asia/Jerusalem'
    Asia_Kabul = 'Asia/Kabul'
    Asia_Kamchatka = 'Asia/Kamchatka'
    Asia_Karachi = 'Asia/Karachi'
    Asia_Kathmandu = 'Asia/Kathmandu'
    Asia_Khandyga = 'Asia/Khandyga'
    Asia_Kolkata = 'Asia/Kolkata'
    Asia_Krasnoyarsk = 'Asia/Krasnoyarsk'
    Asia_Kuala_Lumpur = 'Asia/Kuala_Lumpur'
    Asia_Kuching = 'Asia/Kuching'
    Asia_Kuwait = 'Asia/Kuwait'
    Asia_Macau = 'Asia/Macau'
    Asia_Magadan = 'Asia/Magadan'
    Asia_Makassar = 'Asia/Makassar'
    Asia_Manila = 'Asia/Manila'
    Asia_Muscat = 'Asia/Muscat'
    Asia_Nicosia = 'Asia/Nicosia'
    Asia_Novokuznetsk = 'Asia/Novokuznetsk'
    Asia_Novosibirsk = 'Asia/Novosibirsk'
    Asia_Omsk = 'Asia/Omsk'
    Asia_Oral = 'Asia/Oral'
    Asia_Phnom_Penh = 'Asia/Phnom_Penh'
    Asia_Pontianak = 'Asia/Pontianak'
    Asia_Pyongyang = 'Asia/Pyongyang'
    Asia_Qatar = 'Asia/Qatar'
    Asia_Qostanay = 'Asia/Qostanay'
    Asia_Qyzylorda = 'Asia/Qyzylorda'
    Asia_Riyadh = 'Asia/Riyadh'
    Asia_Sakhalin = 'Asia/Sakhalin'
    Asia_Samarkand = 'Asia/Samarkand'
    Asia_Seoul = 'Asia/Seoul'
    Asia_Shanghai = 'Asia/Shanghai'
    Asia_Singapore = 'Asia/Singapore'
    Asia_Srednekolymsk = 'Asia/Srednekolymsk'
    Asia_Taipei = 'Asia/Taipei'
    Asia_Tashkent = 'Asia/Tashkent'
    Asia_Tbilisi = 'Asia/Tbilisi'
    Asia_Tehran = 'Asia/Tehran'
    Asia_Thimphu = 'Asia/Thimphu'
    Asia_Tokyo = 'Asia/Tokyo'
    Asia_Tomsk = 'Asia/Tomsk'
    Asia_Ulaanbaatar = 'Asia/Ulaanbaatar'
    Asia_Urumqi = 'Asia/Urumqi'
    Asia_Ust_Nera = 'Asia/Ust-Nera'
    Asia_Vientiane = 'Asia/Vientiane'
    Asia_Vladivostok = 'Asia/Vladivostok'
    Asia_Yakutsk = 'Asia/Yakutsk'
    Asia_Yangon = 'Asia/Yangon'
    Asia_Yekaterinburg = 'Asia/Yekaterinburg'
    Asia_Yerevan = 'Asia/Yerevan'
    Atlantic_Azores = 'Atlantic/Azores'
    Atlantic_Bermuda = 'Atlantic/Bermuda'
    Atlantic_Canary = 'Atlantic/Canary'
    Atlantic_Cape_Verde = 'Atlantic/Cape_Verde'
    Atlantic_Faroe = 'Atlantic/Faroe'
    Atlantic_Madeira = 'Atlantic/Madeira'
    Atlantic_Reykjavik = 'Atlantic/Reykjavik'
    Atlantic_South_Georgia = 'Atlantic/South_Georgia'
    Atlantic_St_Helena = 'Atlantic/St_Helena'
    Atlantic_Stanley = 'Atlantic/Stanley'
    Australia_Adelaide = 'Australia/Adelaide'
    Australia_Brisbane = 'Australia/Brisbane'
    Australia_Broken_Hill = 'Australia/Broken_Hill'
    Australia_Darwin = 'Australia/Darwin'
    Australia_Eucla = 'Australia/Eucla'
    Australia_Hobart = 'Australia/Hobart'
    Australia_Lindeman = 'Australia/Lindeman'
    Australia_Lord_Howe = 'Australia/Lord_Howe'
    Australia_Melbourne = 'Australia/Melbourne'
    Australia_Perth = 'Australia/Perth'
    Australia_Sydney = 'Australia/Sydney'
    Canada_Atlantic = 'Canada/Atlantic'
    Canada_Central = 'Canada/Central'
    Canada_Eastern = 'Canada/Eastern'
    Canada_Mountain = 'Canada/Mountain'
    Canada_Newfoundland = 'Canada/Newfoundland'
    Canada_Pacific = 'Canada/Pacific'
    Europe_Amsterdam = 'Europe/Amsterdam'
    Europe_Andorra = 'Europe/Andorra'
    Europe_Astrakhan = 'Europe/Astrakhan'
    Europe_Athens = 'Europe/Athens'
    Europe_Belgrade = 'Europe/Belgrade'
    Europe_Berlin = 'Europe/Berlin'
    Europe_Bratislava = 'Europe/Bratislava'
    Europe_Brussels = 'Europe/Brussels'
    Europe_Bucharest = 'Europe/Bucharest'
    Europe_Budapest = 'Europe/Budapest'
    Europe_Busingen = 'Europe/Busingen'
    Europe_Chisinau = 'Europe/Chisinau'
    Europe_Copenhagen = 'Europe/Copenhagen'
    Europe_Dublin = 'Europe/Dublin'
    Europe_Gibraltar = 'Europe/Gibraltar'
    Europe_Guernsey = 'Europe/Guernsey'
    Europe_Helsinki = 'Europe/Helsinki'
    Europe_Isle_of_Man = 'Europe/Isle_of_Man'
    Europe_Istanbul = 'Europe/Istanbul'
    Europe_Jersey = 'Europe/Jersey'
    Europe_Kaliningrad = 'Europe/Kaliningrad'
    Europe_Kirov = 'Europe/Kirov'
    Europe_Kyiv = 'Europe/Kyiv'
    Europe_Lisbon = 'Europe/Lisbon'
    Europe_Ljubljana = 'Europe/Ljubljana'
    Europe_London = 'Europe/London'
    Europe_Luxembourg = 'Europe/Luxembourg'
    Europe_Madrid = 'Europe/Madrid'
    Europe_Malta = 'Europe/Malta'
    Europe_Mariehamn = 'Europe/Mariehamn'
    Europe_Minsk = 'Europe/Minsk'
    Europe_Monaco = 'Europe/Monaco'
    Europe_Moscow = 'Europe/Moscow'
    Europe_Oslo = 'Europe/Oslo'
    Europe_Paris = 'Europe/Paris'
    Europe_Podgorica = 'Europe/Podgorica'
    Europe_Prague = 'Europe/Prague'
    Europe_Riga = 'Europe/Riga'
    Europe_Rome = 'Europe/Rome'
    Europe_Samara = 'Europe/Samara'
    Europe_San_Marino = 'Europe/San_Marino'
    Europe_Sarajevo = 'Europe/Sarajevo'
    Europe_Saratov = 'Europe/Saratov'
    Europe_Simferopol = 'Europe/Simferopol'
    Europe_Skopje = 'Europe/Skopje'
    Europe_Sofia = 'Europe/Sofia'
    Europe_Stockholm = 'Europe/Stockholm'
    Europe_Tallinn = 'Europe/Tallinn'
    Europe_Tirane = 'Europe/Tirane'
    Europe_Ulyanovsk = 'Europe/Ulyanovsk'
    Europe_Vaduz = 'Europe/Vaduz'
    Europe_Vatican = 'Europe/Vatican'
    Europe_Vienna = 'Europe/Vienna'
    Europe_Vilnius = 'Europe/Vilnius'
    Europe_Volgograd = 'Europe/Volgograd'
    Europe_Warsaw = 'Europe/Warsaw'
    Europe_Zagreb = 'Europe/Zagreb'
    Europe_Zurich = 'Europe/Zurich'
    GMT = 'GMT'
    Indian_Antananarivo = 'Indian/Antananarivo'
    Indian_Chagos = 'Indian/Chagos'
    Indian_Christmas = 'Indian/Christmas'
    Indian_Cocos = 'Indian/Cocos'
    Indian_Comoro = 'Indian/Comoro'
    Indian_Kerguelen = 'Indian/Kerguelen'
    Indian_Mahe = 'Indian/Mahe'
    Indian_Maldives = 'Indian/Maldives'
    Indian_Mauritius = 'Indian/Mauritius'
    Indian_Mayotte = 'Indian/Mayotte'
    Indian_Reunion = 'Indian/Reunion'
    Pacific_Apia = 'Pacific/Apia'
    Pacific_Auckland = 'Pacific/Auckland'
    Pacific_Bougainville = 'Pacific/Bougainville'
    Pacific_Chatham = 'Pacific/Chatham'
    Pacific_Chuuk = 'Pacific/Chuuk'
    Pacific_Easter = 'Pacific/Easter'
    Pacific_Efate = 'Pacific/Efate'
    Pacific_Fakaofo = 'Pacific/Fakaofo'
    Pacific_Fiji = 'Pacific/Fiji'
    Pacific_Funafuti = 'Pacific/Funafuti'
    Pacific_Galapagos = 'Pacific/Galapagos'
    Pacific_Gambier = 'Pacific/Gambier'
    Pacific_Guadalcanal = 'Pacific/Guadalcanal'
    Pacific_Guam = 'Pacific/Guam'
    Pacific_Honolulu = 'Pacific/Honolulu'
    Pacific_Kanton = 'Pacific/Kanton'
    Pacific_Kiritimati = 'Pacific/Kiritimati'
    Pacific_Kosrae = 'Pacific/Kosrae'
    Pacific_Kwajalein = 'Pacific/Kwajalein'
    Pacific_Majuro = 'Pacific/Majuro'
    Pacific_Marquesas = 'Pacific/Marquesas'
    Pacific_Midway = 'Pacific/Midway'
    Pacific_Nauru = 'Pacific/Nauru'
    Pacific_Niue = 'Pacific/Niue'
    Pacific_Norfolk = 'Pacific/Norfolk'
    Pacific_Noumea = 'Pacific/Noumea'
    Pacific_Pago_Pago = 'Pacific/Pago_Pago'
    Pacific_Palau = 'Pacific/Palau'
    Pacific_Pitcairn = 'Pacific/Pitcairn'
    Pacific_Pohnpei = 'Pacific/Pohnpei'
    Pacific_Port_Moresby = 'Pacific/Port_Moresby'
    Pacific_Rarotonga = 'Pacific/Rarotonga'
    Pacific_Saipan = 'Pacific/Saipan'
    Pacific_Tahiti = 'Pacific/Tahiti'
    Pacific_Tarawa = 'Pacific/Tarawa'
    Pacific_Tongatapu = 'Pacific/Tongatapu'
    Pacific_Wake = 'Pacific/Wake'
    Pacific_Wallis = 'Pacific/Wallis'
    US_Alaska = 'US/Alaska'
    US_Arizona = 'US/Arizona'
    US_Central = 'US/Central'
    US_Eastern = 'US/Eastern'
    US_Hawaii = 'US/Hawaii'
    US_Mountain = 'US/Mountain'
    US_Pacific = 'US/Pacific'
    UTC = 'UTC'


class OrganizationType1(Enum):
    development = 'development'
    production = 'production'


class OrganizationCreateRequest(BaseModel):
    organization_name: constr(min_length=1, max_length=100)
    default_currency_code: Optional[constr(min_length=1)] = None
    organization_type: OrganizationType1 = 'development'


class SettingName(Enum):
    generate_customer_after_creating_in_lotus = (
        'generate_customer_after_creating_in_lotus'
    )
    subscription_filter_keys = 'subscription_filter_keys'
    payment_grace_period = 'payment_grace_period'


class SettingGroup(Enum):
    stripe = 'stripe'
    billing = 'billing'


class OrganizationSetting(BaseModel):
    setting_id: str
    setting_name: SettingName
    setting_values: Dict[str, Any]
    setting_group: Optional[SettingGroup] = None


class OrganizationSettingUpdate(BaseModel):
    setting_values: Optional[Dict[str, Any]] = None


class Status10(Enum):
    Active = 'Active'
    Invited = 'Invited'


class OrganizationUser(BaseModel):
    username: constr(regex=r'^[\w.@+-]+$', max_length=150) = Field(
        ...,
        description='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.',
    )
    email: EmailStr
    role: str
    status: Status10 = 'Active'


class PaginatedActionList(BaseModel):
    next: Optional[str] = None
    previous: Optional[str] = None
    results: Optional[List[Action]] = None


class PaginatedEventList(BaseModel):
    next: Optional[str] = None
    previous: Optional[str] = None
    results: Optional[List[Event]] = None


class Timezone3(Enum):
    Africa_Abidjan = 'Africa/Abidjan'
    Africa_Accra = 'Africa/Accra'
    Africa_Addis_Ababa = 'Africa/Addis_Ababa'
    Africa_Algiers = 'Africa/Algiers'
    Africa_Asmara = 'Africa/Asmara'
    Africa_Bamako = 'Africa/Bamako'
    Africa_Bangui = 'Africa/Bangui'
    Africa_Banjul = 'Africa/Banjul'
    Africa_Bissau = 'Africa/Bissau'
    Africa_Blantyre = 'Africa/Blantyre'
    Africa_Brazzaville = 'Africa/Brazzaville'
    Africa_Bujumbura = 'Africa/Bujumbura'
    Africa_Cairo = 'Africa/Cairo'
    Africa_Casablanca = 'Africa/Casablanca'
    Africa_Ceuta = 'Africa/Ceuta'
    Africa_Conakry = 'Africa/Conakry'
    Africa_Dakar = 'Africa/Dakar'
    Africa_Dar_es_Salaam = 'Africa/Dar_es_Salaam'
    Africa_Djibouti = 'Africa/Djibouti'
    Africa_Douala = 'Africa/Douala'
    Africa_El_Aaiun = 'Africa/El_Aaiun'
    Africa_Freetown = 'Africa/Freetown'
    Africa_Gaborone = 'Africa/Gaborone'
    Africa_Harare = 'Africa/Harare'
    Africa_Johannesburg = 'Africa/Johannesburg'
    Africa_Juba = 'Africa/Juba'
    Africa_Kampala = 'Africa/Kampala'
    Africa_Khartoum = 'Africa/Khartoum'
    Africa_Kigali = 'Africa/Kigali'
    Africa_Kinshasa = 'Africa/Kinshasa'
    Africa_Lagos = 'Africa/Lagos'
    Africa_Libreville = 'Africa/Libreville'
    Africa_Lome = 'Africa/Lome'
    Africa_Luanda = 'Africa/Luanda'
    Africa_Lubumbashi = 'Africa/Lubumbashi'
    Africa_Lusaka = 'Africa/Lusaka'
    Africa_Malabo = 'Africa/Malabo'
    Africa_Maputo = 'Africa/Maputo'
    Africa_Maseru = 'Africa/Maseru'
    Africa_Mbabane = 'Africa/Mbabane'
    Africa_Mogadishu = 'Africa/Mogadishu'
    Africa_Monrovia = 'Africa/Monrovia'
    Africa_Nairobi = 'Africa/Nairobi'
    Africa_Ndjamena = 'Africa/Ndjamena'
    Africa_Niamey = 'Africa/Niamey'
    Africa_Nouakchott = 'Africa/Nouakchott'
    Africa_Ouagadougou = 'Africa/Ouagadougou'
    Africa_Porto_Novo = 'Africa/Porto-Novo'
    Africa_Sao_Tome = 'Africa/Sao_Tome'
    Africa_Tripoli = 'Africa/Tripoli'
    Africa_Tunis = 'Africa/Tunis'
    Africa_Windhoek = 'Africa/Windhoek'
    America_Adak = 'America/Adak'
    America_Anchorage = 'America/Anchorage'
    America_Anguilla = 'America/Anguilla'
    America_Antigua = 'America/Antigua'
    America_Araguaina = 'America/Araguaina'
    America_Argentina_Buenos_Aires = 'America/Argentina/Buenos_Aires'
    America_Argentina_Catamarca = 'America/Argentina/Catamarca'
    America_Argentina_Cordoba = 'America/Argentina/Cordoba'
    America_Argentina_Jujuy = 'America/Argentina/Jujuy'
    America_Argentina_La_Rioja = 'America/Argentina/La_Rioja'
    America_Argentina_Mendoza = 'America/Argentina/Mendoza'
    America_Argentina_Rio_Gallegos = 'America/Argentina/Rio_Gallegos'
    America_Argentina_Salta = 'America/Argentina/Salta'
    America_Argentina_San_Juan = 'America/Argentina/San_Juan'
    America_Argentina_San_Luis = 'America/Argentina/San_Luis'
    America_Argentina_Tucuman = 'America/Argentina/Tucuman'
    America_Argentina_Ushuaia = 'America/Argentina/Ushuaia'
    America_Aruba = 'America/Aruba'
    America_Asuncion = 'America/Asuncion'
    America_Atikokan = 'America/Atikokan'
    America_Bahia = 'America/Bahia'
    America_Bahia_Banderas = 'America/Bahia_Banderas'
    America_Barbados = 'America/Barbados'
    America_Belem = 'America/Belem'
    America_Belize = 'America/Belize'
    America_Blanc_Sablon = 'America/Blanc-Sablon'
    America_Boa_Vista = 'America/Boa_Vista'
    America_Bogota = 'America/Bogota'
    America_Boise = 'America/Boise'
    America_Cambridge_Bay = 'America/Cambridge_Bay'
    America_Campo_Grande = 'America/Campo_Grande'
    America_Cancun = 'America/Cancun'
    America_Caracas = 'America/Caracas'
    America_Cayenne = 'America/Cayenne'
    America_Cayman = 'America/Cayman'
    America_Chicago = 'America/Chicago'
    America_Chihuahua = 'America/Chihuahua'
    America_Ciudad_Juarez = 'America/Ciudad_Juarez'
    America_Costa_Rica = 'America/Costa_Rica'
    America_Creston = 'America/Creston'
    America_Cuiaba = 'America/Cuiaba'
    America_Curacao = 'America/Curacao'
    America_Danmarkshavn = 'America/Danmarkshavn'
    America_Dawson = 'America/Dawson'
    America_Dawson_Creek = 'America/Dawson_Creek'
    America_Denver = 'America/Denver'
    America_Detroit = 'America/Detroit'
    America_Dominica = 'America/Dominica'
    America_Edmonton = 'America/Edmonton'
    America_Eirunepe = 'America/Eirunepe'
    America_El_Salvador = 'America/El_Salvador'
    America_Fort_Nelson = 'America/Fort_Nelson'
    America_Fortaleza = 'America/Fortaleza'
    America_Glace_Bay = 'America/Glace_Bay'
    America_Goose_Bay = 'America/Goose_Bay'
    America_Grand_Turk = 'America/Grand_Turk'
    America_Grenada = 'America/Grenada'
    America_Guadeloupe = 'America/Guadeloupe'
    America_Guatemala = 'America/Guatemala'
    America_Guayaquil = 'America/Guayaquil'
    America_Guyana = 'America/Guyana'
    America_Halifax = 'America/Halifax'
    America_Havana = 'America/Havana'
    America_Hermosillo = 'America/Hermosillo'
    America_Indiana_Indianapolis = 'America/Indiana/Indianapolis'
    America_Indiana_Knox = 'America/Indiana/Knox'
    America_Indiana_Marengo = 'America/Indiana/Marengo'
    America_Indiana_Petersburg = 'America/Indiana/Petersburg'
    America_Indiana_Tell_City = 'America/Indiana/Tell_City'
    America_Indiana_Vevay = 'America/Indiana/Vevay'
    America_Indiana_Vincennes = 'America/Indiana/Vincennes'
    America_Indiana_Winamac = 'America/Indiana/Winamac'
    America_Inuvik = 'America/Inuvik'
    America_Iqaluit = 'America/Iqaluit'
    America_Jamaica = 'America/Jamaica'
    America_Juneau = 'America/Juneau'
    America_Kentucky_Louisville = 'America/Kentucky/Louisville'
    America_Kentucky_Monticello = 'America/Kentucky/Monticello'
    America_Kralendijk = 'America/Kralendijk'
    America_La_Paz = 'America/La_Paz'
    America_Lima = 'America/Lima'
    America_Los_Angeles = 'America/Los_Angeles'
    America_Lower_Princes = 'America/Lower_Princes'
    America_Maceio = 'America/Maceio'
    America_Managua = 'America/Managua'
    America_Manaus = 'America/Manaus'
    America_Marigot = 'America/Marigot'
    America_Martinique = 'America/Martinique'
    America_Matamoros = 'America/Matamoros'
    America_Mazatlan = 'America/Mazatlan'
    America_Menominee = 'America/Menominee'
    America_Merida = 'America/Merida'
    America_Metlakatla = 'America/Metlakatla'
    America_Mexico_City = 'America/Mexico_City'
    America_Miquelon = 'America/Miquelon'
    America_Moncton = 'America/Moncton'
    America_Monterrey = 'America/Monterrey'
    America_Montevideo = 'America/Montevideo'
    America_Montserrat = 'America/Montserrat'
    America_Nassau = 'America/Nassau'
    America_New_York = 'America/New_York'
    America_Nome = 'America/Nome'
    America_Noronha = 'America/Noronha'
    America_North_Dakota_Beulah = 'America/North_Dakota/Beulah'
    America_North_Dakota_Center = 'America/North_Dakota/Center'
    America_North_Dakota_New_Salem = 'America/North_Dakota/New_Salem'
    America_Nuuk = 'America/Nuuk'
    America_Ojinaga = 'America/Ojinaga'
    America_Panama = 'America/Panama'
    America_Paramaribo = 'America/Paramaribo'
    America_Phoenix = 'America/Phoenix'
    America_Port_au_Prince = 'America/Port-au-Prince'
    America_Port_of_Spain = 'America/Port_of_Spain'
    America_Porto_Velho = 'America/Porto_Velho'
    America_Puerto_Rico = 'America/Puerto_Rico'
    America_Punta_Arenas = 'America/Punta_Arenas'
    America_Rankin_Inlet = 'America/Rankin_Inlet'
    America_Recife = 'America/Recife'
    America_Regina = 'America/Regina'
    America_Resolute = 'America/Resolute'
    America_Rio_Branco = 'America/Rio_Branco'
    America_Santarem = 'America/Santarem'
    America_Santiago = 'America/Santiago'
    America_Santo_Domingo = 'America/Santo_Domingo'
    America_Sao_Paulo = 'America/Sao_Paulo'
    America_Scoresbysund = 'America/Scoresbysund'
    America_Sitka = 'America/Sitka'
    America_St_Barthelemy = 'America/St_Barthelemy'
    America_St_Johns = 'America/St_Johns'
    America_St_Kitts = 'America/St_Kitts'
    America_St_Lucia = 'America/St_Lucia'
    America_St_Thomas = 'America/St_Thomas'
    America_St_Vincent = 'America/St_Vincent'
    America_Swift_Current = 'America/Swift_Current'
    America_Tegucigalpa = 'America/Tegucigalpa'
    America_Thule = 'America/Thule'
    America_Tijuana = 'America/Tijuana'
    America_Toronto = 'America/Toronto'
    America_Tortola = 'America/Tortola'
    America_Vancouver = 'America/Vancouver'
    America_Whitehorse = 'America/Whitehorse'
    America_Winnipeg = 'America/Winnipeg'
    America_Yakutat = 'America/Yakutat'
    America_Yellowknife = 'America/Yellowknife'
    Antarctica_Casey = 'Antarctica/Casey'
    Antarctica_Davis = 'Antarctica/Davis'
    Antarctica_DumontDUrville = 'Antarctica/DumontDUrville'
    Antarctica_Macquarie = 'Antarctica/Macquarie'
    Antarctica_Mawson = 'Antarctica/Mawson'
    Antarctica_McMurdo = 'Antarctica/McMurdo'
    Antarctica_Palmer = 'Antarctica/Palmer'
    Antarctica_Rothera = 'Antarctica/Rothera'
    Antarctica_Syowa = 'Antarctica/Syowa'
    Antarctica_Troll = 'Antarctica/Troll'
    Antarctica_Vostok = 'Antarctica/Vostok'
    Arctic_Longyearbyen = 'Arctic/Longyearbyen'
    Asia_Aden = 'Asia/Aden'
    Asia_Almaty = 'Asia/Almaty'
    Asia_Amman = 'Asia/Amman'
    Asia_Anadyr = 'Asia/Anadyr'
    Asia_Aqtau = 'Asia/Aqtau'
    Asia_Aqtobe = 'Asia/Aqtobe'
    Asia_Ashgabat = 'Asia/Ashgabat'
    Asia_Atyrau = 'Asia/Atyrau'
    Asia_Baghdad = 'Asia/Baghdad'
    Asia_Bahrain = 'Asia/Bahrain'
    Asia_Baku = 'Asia/Baku'
    Asia_Bangkok = 'Asia/Bangkok'
    Asia_Barnaul = 'Asia/Barnaul'
    Asia_Beirut = 'Asia/Beirut'
    Asia_Bishkek = 'Asia/Bishkek'
    Asia_Brunei = 'Asia/Brunei'
    Asia_Chita = 'Asia/Chita'
    Asia_Choibalsan = 'Asia/Choibalsan'
    Asia_Colombo = 'Asia/Colombo'
    Asia_Damascus = 'Asia/Damascus'
    Asia_Dhaka = 'Asia/Dhaka'
    Asia_Dili = 'Asia/Dili'
    Asia_Dubai = 'Asia/Dubai'
    Asia_Dushanbe = 'Asia/Dushanbe'
    Asia_Famagusta = 'Asia/Famagusta'
    Asia_Gaza = 'Asia/Gaza'
    Asia_Hebron = 'Asia/Hebron'
    Asia_Ho_Chi_Minh = 'Asia/Ho_Chi_Minh'
    Asia_Hong_Kong = 'Asia/Hong_Kong'
    Asia_Hovd = 'Asia/Hovd'
    Asia_Irkutsk = 'Asia/Irkutsk'
    Asia_Jakarta = 'Asia/Jakarta'
    Asia_Jayapura = 'Asia/Jayapura'
    Asia_Jerusalem = 'Asia/Jerusalem'
    Asia_Kabul = 'Asia/Kabul'
    Asia_Kamchatka = 'Asia/Kamchatka'
    Asia_Karachi = 'Asia/Karachi'
    Asia_Kathmandu = 'Asia/Kathmandu'
    Asia_Khandyga = 'Asia/Khandyga'
    Asia_Kolkata = 'Asia/Kolkata'
    Asia_Krasnoyarsk = 'Asia/Krasnoyarsk'
    Asia_Kuala_Lumpur = 'Asia/Kuala_Lumpur'
    Asia_Kuching = 'Asia/Kuching'
    Asia_Kuwait = 'Asia/Kuwait'
    Asia_Macau = 'Asia/Macau'
    Asia_Magadan = 'Asia/Magadan'
    Asia_Makassar = 'Asia/Makassar'
    Asia_Manila = 'Asia/Manila'
    Asia_Muscat = 'Asia/Muscat'
    Asia_Nicosia = 'Asia/Nicosia'
    Asia_Novokuznetsk = 'Asia/Novokuznetsk'
    Asia_Novosibirsk = 'Asia/Novosibirsk'
    Asia_Omsk = 'Asia/Omsk'
    Asia_Oral = 'Asia/Oral'
    Asia_Phnom_Penh = 'Asia/Phnom_Penh'
    Asia_Pontianak = 'Asia/Pontianak'
    Asia_Pyongyang = 'Asia/Pyongyang'
    Asia_Qatar = 'Asia/Qatar'
    Asia_Qostanay = 'Asia/Qostanay'
    Asia_Qyzylorda = 'Asia/Qyzylorda'
    Asia_Riyadh = 'Asia/Riyadh'
    Asia_Sakhalin = 'Asia/Sakhalin'
    Asia_Samarkand = 'Asia/Samarkand'
    Asia_Seoul = 'Asia/Seoul'
    Asia_Shanghai = 'Asia/Shanghai'
    Asia_Singapore = 'Asia/Singapore'
    Asia_Srednekolymsk = 'Asia/Srednekolymsk'
    Asia_Taipei = 'Asia/Taipei'
    Asia_Tashkent = 'Asia/Tashkent'
    Asia_Tbilisi = 'Asia/Tbilisi'
    Asia_Tehran = 'Asia/Tehran'
    Asia_Thimphu = 'Asia/Thimphu'
    Asia_Tokyo = 'Asia/Tokyo'
    Asia_Tomsk = 'Asia/Tomsk'
    Asia_Ulaanbaatar = 'Asia/Ulaanbaatar'
    Asia_Urumqi = 'Asia/Urumqi'
    Asia_Ust_Nera = 'Asia/Ust-Nera'
    Asia_Vientiane = 'Asia/Vientiane'
    Asia_Vladivostok = 'Asia/Vladivostok'
    Asia_Yakutsk = 'Asia/Yakutsk'
    Asia_Yangon = 'Asia/Yangon'
    Asia_Yekaterinburg = 'Asia/Yekaterinburg'
    Asia_Yerevan = 'Asia/Yerevan'
    Atlantic_Azores = 'Atlantic/Azores'
    Atlantic_Bermuda = 'Atlantic/Bermuda'
    Atlantic_Canary = 'Atlantic/Canary'
    Atlantic_Cape_Verde = 'Atlantic/Cape_Verde'
    Atlantic_Faroe = 'Atlantic/Faroe'
    Atlantic_Madeira = 'Atlantic/Madeira'
    Atlantic_Reykjavik = 'Atlantic/Reykjavik'
    Atlantic_South_Georgia = 'Atlantic/South_Georgia'
    Atlantic_St_Helena = 'Atlantic/St_Helena'
    Atlantic_Stanley = 'Atlantic/Stanley'
    Australia_Adelaide = 'Australia/Adelaide'
    Australia_Brisbane = 'Australia/Brisbane'
    Australia_Broken_Hill = 'Australia/Broken_Hill'
    Australia_Darwin = 'Australia/Darwin'
    Australia_Eucla = 'Australia/Eucla'
    Australia_Hobart = 'Australia/Hobart'
    Australia_Lindeman = 'Australia/Lindeman'
    Australia_Lord_Howe = 'Australia/Lord_Howe'
    Australia_Melbourne = 'Australia/Melbourne'
    Australia_Perth = 'Australia/Perth'
    Australia_Sydney = 'Australia/Sydney'
    Canada_Atlantic = 'Canada/Atlantic'
    Canada_Central = 'Canada/Central'
    Canada_Eastern = 'Canada/Eastern'
    Canada_Mountain = 'Canada/Mountain'
    Canada_Newfoundland = 'Canada/Newfoundland'
    Canada_Pacific = 'Canada/Pacific'
    Europe_Amsterdam = 'Europe/Amsterdam'
    Europe_Andorra = 'Europe/Andorra'
    Europe_Astrakhan = 'Europe/Astrakhan'
    Europe_Athens = 'Europe/Athens'
    Europe_Belgrade = 'Europe/Belgrade'
    Europe_Berlin = 'Europe/Berlin'
    Europe_Bratislava = 'Europe/Bratislava'
    Europe_Brussels = 'Europe/Brussels'
    Europe_Bucharest = 'Europe/Bucharest'
    Europe_Budapest = 'Europe/Budapest'
    Europe_Busingen = 'Europe/Busingen'
    Europe_Chisinau = 'Europe/Chisinau'
    Europe_Copenhagen = 'Europe/Copenhagen'
    Europe_Dublin = 'Europe/Dublin'
    Europe_Gibraltar = 'Europe/Gibraltar'
    Europe_Guernsey = 'Europe/Guernsey'
    Europe_Helsinki = 'Europe/Helsinki'
    Europe_Isle_of_Man = 'Europe/Isle_of_Man'
    Europe_Istanbul = 'Europe/Istanbul'
    Europe_Jersey = 'Europe/Jersey'
    Europe_Kaliningrad = 'Europe/Kaliningrad'
    Europe_Kirov = 'Europe/Kirov'
    Europe_Kyiv = 'Europe/Kyiv'
    Europe_Lisbon = 'Europe/Lisbon'
    Europe_Ljubljana = 'Europe/Ljubljana'
    Europe_London = 'Europe/London'
    Europe_Luxembourg = 'Europe/Luxembourg'
    Europe_Madrid = 'Europe/Madrid'
    Europe_Malta = 'Europe/Malta'
    Europe_Mariehamn = 'Europe/Mariehamn'
    Europe_Minsk = 'Europe/Minsk'
    Europe_Monaco = 'Europe/Monaco'
    Europe_Moscow = 'Europe/Moscow'
    Europe_Oslo = 'Europe/Oslo'
    Europe_Paris = 'Europe/Paris'
    Europe_Podgorica = 'Europe/Podgorica'
    Europe_Prague = 'Europe/Prague'
    Europe_Riga = 'Europe/Riga'
    Europe_Rome = 'Europe/Rome'
    Europe_Samara = 'Europe/Samara'
    Europe_San_Marino = 'Europe/San_Marino'
    Europe_Sarajevo = 'Europe/Sarajevo'
    Europe_Saratov = 'Europe/Saratov'
    Europe_Simferopol = 'Europe/Simferopol'
    Europe_Skopje = 'Europe/Skopje'
    Europe_Sofia = 'Europe/Sofia'
    Europe_Stockholm = 'Europe/Stockholm'
    Europe_Tallinn = 'Europe/Tallinn'
    Europe_Tirane = 'Europe/Tirane'
    Europe_Ulyanovsk = 'Europe/Ulyanovsk'
    Europe_Vaduz = 'Europe/Vaduz'
    Europe_Vatican = 'Europe/Vatican'
    Europe_Vienna = 'Europe/Vienna'
    Europe_Vilnius = 'Europe/Vilnius'
    Europe_Volgograd = 'Europe/Volgograd'
    Europe_Warsaw = 'Europe/Warsaw'
    Europe_Zagreb = 'Europe/Zagreb'
    Europe_Zurich = 'Europe/Zurich'
    GMT = 'GMT'
    Indian_Antananarivo = 'Indian/Antananarivo'
    Indian_Chagos = 'Indian/Chagos'
    Indian_Christmas = 'Indian/Christmas'
    Indian_Cocos = 'Indian/Cocos'
    Indian_Comoro = 'Indian/Comoro'
    Indian_Kerguelen = 'Indian/Kerguelen'
    Indian_Mahe = 'Indian/Mahe'
    Indian_Maldives = 'Indian/Maldives'
    Indian_Mauritius = 'Indian/Mauritius'
    Indian_Mayotte = 'Indian/Mayotte'
    Indian_Reunion = 'Indian/Reunion'
    Pacific_Apia = 'Pacific/Apia'
    Pacific_Auckland = 'Pacific/Auckland'
    Pacific_Bougainville = 'Pacific/Bougainville'
    Pacific_Chatham = 'Pacific/Chatham'
    Pacific_Chuuk = 'Pacific/Chuuk'
    Pacific_Easter = 'Pacific/Easter'
    Pacific_Efate = 'Pacific/Efate'
    Pacific_Fakaofo = 'Pacific/Fakaofo'
    Pacific_Fiji = 'Pacific/Fiji'
    Pacific_Funafuti = 'Pacific/Funafuti'
    Pacific_Galapagos = 'Pacific/Galapagos'
    Pacific_Gambier = 'Pacific/Gambier'
    Pacific_Guadalcanal = 'Pacific/Guadalcanal'
    Pacific_Guam = 'Pacific/Guam'
    Pacific_Honolulu = 'Pacific/Honolulu'
    Pacific_Kanton = 'Pacific/Kanton'
    Pacific_Kiritimati = 'Pacific/Kiritimati'
    Pacific_Kosrae = 'Pacific/Kosrae'
    Pacific_Kwajalein = 'Pacific/Kwajalein'
    Pacific_Majuro = 'Pacific/Majuro'
    Pacific_Marquesas = 'Pacific/Marquesas'
    Pacific_Midway = 'Pacific/Midway'
    Pacific_Nauru = 'Pacific/Nauru'
    Pacific_Niue = 'Pacific/Niue'
    Pacific_Norfolk = 'Pacific/Norfolk'
    Pacific_Noumea = 'Pacific/Noumea'
    Pacific_Pago_Pago = 'Pacific/Pago_Pago'
    Pacific_Palau = 'Pacific/Palau'
    Pacific_Pitcairn = 'Pacific/Pitcairn'
    Pacific_Pohnpei = 'Pacific/Pohnpei'
    Pacific_Port_Moresby = 'Pacific/Port_Moresby'
    Pacific_Rarotonga = 'Pacific/Rarotonga'
    Pacific_Saipan = 'Pacific/Saipan'
    Pacific_Tahiti = 'Pacific/Tahiti'
    Pacific_Tarawa = 'Pacific/Tarawa'
    Pacific_Tongatapu = 'Pacific/Tongatapu'
    Pacific_Wake = 'Pacific/Wake'
    Pacific_Wallis = 'Pacific/Wallis'
    US_Alaska = 'US/Alaska'
    US_Arizona = 'US/Arizona'
    US_Central = 'US/Central'
    US_Eastern = 'US/Eastern'
    US_Hawaii = 'US/Hawaii'
    US_Mountain = 'US/Mountain'
    US_Pacific = 'US/Pacific'
    UTC = 'UTC'


class PatchedCustomerUpdateRequest(BaseModel):
    default_currency_code: Optional[constr(min_length=1)] = None
    address: Optional[AddressRequest] = None
    tax_rate: Optional[confloat(ge=0.0, le=999.9999)] = Field(
        None, description='Tax rate as percentage. For example, 10.5 for 10.5%'
    )
    timezone: Optional[Timezone3] = None


class PaymentStatus3(Enum):
    paid = 'paid'
    unpaid = 'unpaid'


class PatchedInvoiceUpdateRequest(BaseModel):
    payment_status: Optional[PaymentStatus3] = None


class Status11(Enum):
    active = 'active'
    archived = 'archived'


class PatchedMetricUpdateRequest(BaseModel):
    billable_metric_name: Optional[constr(max_length=50)] = None
    status: Optional[Status11] = None


class PatchedOrganizationSettingUpdateRequest(BaseModel):
    setting_values: Optional[Dict[str, Any]] = None


class Timezone4(Enum):
    Africa_Abidjan = 'Africa/Abidjan'
    Africa_Accra = 'Africa/Accra'
    Africa_Addis_Ababa = 'Africa/Addis_Ababa'
    Africa_Algiers = 'Africa/Algiers'
    Africa_Asmara = 'Africa/Asmara'
    Africa_Bamako = 'Africa/Bamako'
    Africa_Bangui = 'Africa/Bangui'
    Africa_Banjul = 'Africa/Banjul'
    Africa_Bissau = 'Africa/Bissau'
    Africa_Blantyre = 'Africa/Blantyre'
    Africa_Brazzaville = 'Africa/Brazzaville'
    Africa_Bujumbura = 'Africa/Bujumbura'
    Africa_Cairo = 'Africa/Cairo'
    Africa_Casablanca = 'Africa/Casablanca'
    Africa_Ceuta = 'Africa/Ceuta'
    Africa_Conakry = 'Africa/Conakry'
    Africa_Dakar = 'Africa/Dakar'
    Africa_Dar_es_Salaam = 'Africa/Dar_es_Salaam'
    Africa_Djibouti = 'Africa/Djibouti'
    Africa_Douala = 'Africa/Douala'
    Africa_El_Aaiun = 'Africa/El_Aaiun'
    Africa_Freetown = 'Africa/Freetown'
    Africa_Gaborone = 'Africa/Gaborone'
    Africa_Harare = 'Africa/Harare'
    Africa_Johannesburg = 'Africa/Johannesburg'
    Africa_Juba = 'Africa/Juba'
    Africa_Kampala = 'Africa/Kampala'
    Africa_Khartoum = 'Africa/Khartoum'
    Africa_Kigali = 'Africa/Kigali'
    Africa_Kinshasa = 'Africa/Kinshasa'
    Africa_Lagos = 'Africa/Lagos'
    Africa_Libreville = 'Africa/Libreville'
    Africa_Lome = 'Africa/Lome'
    Africa_Luanda = 'Africa/Luanda'
    Africa_Lubumbashi = 'Africa/Lubumbashi'
    Africa_Lusaka = 'Africa/Lusaka'
    Africa_Malabo = 'Africa/Malabo'
    Africa_Maputo = 'Africa/Maputo'
    Africa_Maseru = 'Africa/Maseru'
    Africa_Mbabane = 'Africa/Mbabane'
    Africa_Mogadishu = 'Africa/Mogadishu'
    Africa_Monrovia = 'Africa/Monrovia'
    Africa_Nairobi = 'Africa/Nairobi'
    Africa_Ndjamena = 'Africa/Ndjamena'
    Africa_Niamey = 'Africa/Niamey'
    Africa_Nouakchott = 'Africa/Nouakchott'
    Africa_Ouagadougou = 'Africa/Ouagadougou'
    Africa_Porto_Novo = 'Africa/Porto-Novo'
    Africa_Sao_Tome = 'Africa/Sao_Tome'
    Africa_Tripoli = 'Africa/Tripoli'
    Africa_Tunis = 'Africa/Tunis'
    Africa_Windhoek = 'Africa/Windhoek'
    America_Adak = 'America/Adak'
    America_Anchorage = 'America/Anchorage'
    America_Anguilla = 'America/Anguilla'
    America_Antigua = 'America/Antigua'
    America_Araguaina = 'America/Araguaina'
    America_Argentina_Buenos_Aires = 'America/Argentina/Buenos_Aires'
    America_Argentina_Catamarca = 'America/Argentina/Catamarca'
    America_Argentina_Cordoba = 'America/Argentina/Cordoba'
    America_Argentina_Jujuy = 'America/Argentina/Jujuy'
    America_Argentina_La_Rioja = 'America/Argentina/La_Rioja'
    America_Argentina_Mendoza = 'America/Argentina/Mendoza'
    America_Argentina_Rio_Gallegos = 'America/Argentina/Rio_Gallegos'
    America_Argentina_Salta = 'America/Argentina/Salta'
    America_Argentina_San_Juan = 'America/Argentina/San_Juan'
    America_Argentina_San_Luis = 'America/Argentina/San_Luis'
    America_Argentina_Tucuman = 'America/Argentina/Tucuman'
    America_Argentina_Ushuaia = 'America/Argentina/Ushuaia'
    America_Aruba = 'America/Aruba'
    America_Asuncion = 'America/Asuncion'
    America_Atikokan = 'America/Atikokan'
    America_Bahia = 'America/Bahia'
    America_Bahia_Banderas = 'America/Bahia_Banderas'
    America_Barbados = 'America/Barbados'
    America_Belem = 'America/Belem'
    America_Belize = 'America/Belize'
    America_Blanc_Sablon = 'America/Blanc-Sablon'
    America_Boa_Vista = 'America/Boa_Vista'
    America_Bogota = 'America/Bogota'
    America_Boise = 'America/Boise'
    America_Cambridge_Bay = 'America/Cambridge_Bay'
    America_Campo_Grande = 'America/Campo_Grande'
    America_Cancun = 'America/Cancun'
    America_Caracas = 'America/Caracas'
    America_Cayenne = 'America/Cayenne'
    America_Cayman = 'America/Cayman'
    America_Chicago = 'America/Chicago'
    America_Chihuahua = 'America/Chihuahua'
    America_Ciudad_Juarez = 'America/Ciudad_Juarez'
    America_Costa_Rica = 'America/Costa_Rica'
    America_Creston = 'America/Creston'
    America_Cuiaba = 'America/Cuiaba'
    America_Curacao = 'America/Curacao'
    America_Danmarkshavn = 'America/Danmarkshavn'
    America_Dawson = 'America/Dawson'
    America_Dawson_Creek = 'America/Dawson_Creek'
    America_Denver = 'America/Denver'
    America_Detroit = 'America/Detroit'
    America_Dominica = 'America/Dominica'
    America_Edmonton = 'America/Edmonton'
    America_Eirunepe = 'America/Eirunepe'
    America_El_Salvador = 'America/El_Salvador'
    America_Fort_Nelson = 'America/Fort_Nelson'
    America_Fortaleza = 'America/Fortaleza'
    America_Glace_Bay = 'America/Glace_Bay'
    America_Goose_Bay = 'America/Goose_Bay'
    America_Grand_Turk = 'America/Grand_Turk'
    America_Grenada = 'America/Grenada'
    America_Guadeloupe = 'America/Guadeloupe'
    America_Guatemala = 'America/Guatemala'
    America_Guayaquil = 'America/Guayaquil'
    America_Guyana = 'America/Guyana'
    America_Halifax = 'America/Halifax'
    America_Havana = 'America/Havana'
    America_Hermosillo = 'America/Hermosillo'
    America_Indiana_Indianapolis = 'America/Indiana/Indianapolis'
    America_Indiana_Knox = 'America/Indiana/Knox'
    America_Indiana_Marengo = 'America/Indiana/Marengo'
    America_Indiana_Petersburg = 'America/Indiana/Petersburg'
    America_Indiana_Tell_City = 'America/Indiana/Tell_City'
    America_Indiana_Vevay = 'America/Indiana/Vevay'
    America_Indiana_Vincennes = 'America/Indiana/Vincennes'
    America_Indiana_Winamac = 'America/Indiana/Winamac'
    America_Inuvik = 'America/Inuvik'
    America_Iqaluit = 'America/Iqaluit'
    America_Jamaica = 'America/Jamaica'
    America_Juneau = 'America/Juneau'
    America_Kentucky_Louisville = 'America/Kentucky/Louisville'
    America_Kentucky_Monticello = 'America/Kentucky/Monticello'
    America_Kralendijk = 'America/Kralendijk'
    America_La_Paz = 'America/La_Paz'
    America_Lima = 'America/Lima'
    America_Los_Angeles = 'America/Los_Angeles'
    America_Lower_Princes = 'America/Lower_Princes'
    America_Maceio = 'America/Maceio'
    America_Managua = 'America/Managua'
    America_Manaus = 'America/Manaus'
    America_Marigot = 'America/Marigot'
    America_Martinique = 'America/Martinique'
    America_Matamoros = 'America/Matamoros'
    America_Mazatlan = 'America/Mazatlan'
    America_Menominee = 'America/Menominee'
    America_Merida = 'America/Merida'
    America_Metlakatla = 'America/Metlakatla'
    America_Mexico_City = 'America/Mexico_City'
    America_Miquelon = 'America/Miquelon'
    America_Moncton = 'America/Moncton'
    America_Monterrey = 'America/Monterrey'
    America_Montevideo = 'America/Montevideo'
    America_Montserrat = 'America/Montserrat'
    America_Nassau = 'America/Nassau'
    America_New_York = 'America/New_York'
    America_Nome = 'America/Nome'
    America_Noronha = 'America/Noronha'
    America_North_Dakota_Beulah = 'America/North_Dakota/Beulah'
    America_North_Dakota_Center = 'America/North_Dakota/Center'
    America_North_Dakota_New_Salem = 'America/North_Dakota/New_Salem'
    America_Nuuk = 'America/Nuuk'
    America_Ojinaga = 'America/Ojinaga'
    America_Panama = 'America/Panama'
    America_Paramaribo = 'America/Paramaribo'
    America_Phoenix = 'America/Phoenix'
    America_Port_au_Prince = 'America/Port-au-Prince'
    America_Port_of_Spain = 'America/Port_of_Spain'
    America_Porto_Velho = 'America/Porto_Velho'
    America_Puerto_Rico = 'America/Puerto_Rico'
    America_Punta_Arenas = 'America/Punta_Arenas'
    America_Rankin_Inlet = 'America/Rankin_Inlet'
    America_Recife = 'America/Recife'
    America_Regina = 'America/Regina'
    America_Resolute = 'America/Resolute'
    America_Rio_Branco = 'America/Rio_Branco'
    America_Santarem = 'America/Santarem'
    America_Santiago = 'America/Santiago'
    America_Santo_Domingo = 'America/Santo_Domingo'
    America_Sao_Paulo = 'America/Sao_Paulo'
    America_Scoresbysund = 'America/Scoresbysund'
    America_Sitka = 'America/Sitka'
    America_St_Barthelemy = 'America/St_Barthelemy'
    America_St_Johns = 'America/St_Johns'
    America_St_Kitts = 'America/St_Kitts'
    America_St_Lucia = 'America/St_Lucia'
    America_St_Thomas = 'America/St_Thomas'
    America_St_Vincent = 'America/St_Vincent'
    America_Swift_Current = 'America/Swift_Current'
    America_Tegucigalpa = 'America/Tegucigalpa'
    America_Thule = 'America/Thule'
    America_Tijuana = 'America/Tijuana'
    America_Toronto = 'America/Toronto'
    America_Tortola = 'America/Tortola'
    America_Vancouver = 'America/Vancouver'
    America_Whitehorse = 'America/Whitehorse'
    America_Winnipeg = 'America/Winnipeg'
    America_Yakutat = 'America/Yakutat'
    America_Yellowknife = 'America/Yellowknife'
    Antarctica_Casey = 'Antarctica/Casey'
    Antarctica_Davis = 'Antarctica/Davis'
    Antarctica_DumontDUrville = 'Antarctica/DumontDUrville'
    Antarctica_Macquarie = 'Antarctica/Macquarie'
    Antarctica_Mawson = 'Antarctica/Mawson'
    Antarctica_McMurdo = 'Antarctica/McMurdo'
    Antarctica_Palmer = 'Antarctica/Palmer'
    Antarctica_Rothera = 'Antarctica/Rothera'
    Antarctica_Syowa = 'Antarctica/Syowa'
    Antarctica_Troll = 'Antarctica/Troll'
    Antarctica_Vostok = 'Antarctica/Vostok'
    Arctic_Longyearbyen = 'Arctic/Longyearbyen'
    Asia_Aden = 'Asia/Aden'
    Asia_Almaty = 'Asia/Almaty'
    Asia_Amman = 'Asia/Amman'
    Asia_Anadyr = 'Asia/Anadyr'
    Asia_Aqtau = 'Asia/Aqtau'
    Asia_Aqtobe = 'Asia/Aqtobe'
    Asia_Ashgabat = 'Asia/Ashgabat'
    Asia_Atyrau = 'Asia/Atyrau'
    Asia_Baghdad = 'Asia/Baghdad'
    Asia_Bahrain = 'Asia/Bahrain'
    Asia_Baku = 'Asia/Baku'
    Asia_Bangkok = 'Asia/Bangkok'
    Asia_Barnaul = 'Asia/Barnaul'
    Asia_Beirut = 'Asia/Beirut'
    Asia_Bishkek = 'Asia/Bishkek'
    Asia_Brunei = 'Asia/Brunei'
    Asia_Chita = 'Asia/Chita'
    Asia_Choibalsan = 'Asia/Choibalsan'
    Asia_Colombo = 'Asia/Colombo'
    Asia_Damascus = 'Asia/Damascus'
    Asia_Dhaka = 'Asia/Dhaka'
    Asia_Dili = 'Asia/Dili'
    Asia_Dubai = 'Asia/Dubai'
    Asia_Dushanbe = 'Asia/Dushanbe'
    Asia_Famagusta = 'Asia/Famagusta'
    Asia_Gaza = 'Asia/Gaza'
    Asia_Hebron = 'Asia/Hebron'
    Asia_Ho_Chi_Minh = 'Asia/Ho_Chi_Minh'
    Asia_Hong_Kong = 'Asia/Hong_Kong'
    Asia_Hovd = 'Asia/Hovd'
    Asia_Irkutsk = 'Asia/Irkutsk'
    Asia_Jakarta = 'Asia/Jakarta'
    Asia_Jayapura = 'Asia/Jayapura'
    Asia_Jerusalem = 'Asia/Jerusalem'
    Asia_Kabul = 'Asia/Kabul'
    Asia_Kamchatka = 'Asia/Kamchatka'
    Asia_Karachi = 'Asia/Karachi'
    Asia_Kathmandu = 'Asia/Kathmandu'
    Asia_Khandyga = 'Asia/Khandyga'
    Asia_Kolkata = 'Asia/Kolkata'
    Asia_Krasnoyarsk = 'Asia/Krasnoyarsk'
    Asia_Kuala_Lumpur = 'Asia/Kuala_Lumpur'
    Asia_Kuching = 'Asia/Kuching'
    Asia_Kuwait = 'Asia/Kuwait'
    Asia_Macau = 'Asia/Macau'
    Asia_Magadan = 'Asia/Magadan'
    Asia_Makassar = 'Asia/Makassar'
    Asia_Manila = 'Asia/Manila'
    Asia_Muscat = 'Asia/Muscat'
    Asia_Nicosia = 'Asia/Nicosia'
    Asia_Novokuznetsk = 'Asia/Novokuznetsk'
    Asia_Novosibirsk = 'Asia/Novosibirsk'
    Asia_Omsk = 'Asia/Omsk'
    Asia_Oral = 'Asia/Oral'
    Asia_Phnom_Penh = 'Asia/Phnom_Penh'
    Asia_Pontianak = 'Asia/Pontianak'
    Asia_Pyongyang = 'Asia/Pyongyang'
    Asia_Qatar = 'Asia/Qatar'
    Asia_Qostanay = 'Asia/Qostanay'
    Asia_Qyzylorda = 'Asia/Qyzylorda'
    Asia_Riyadh = 'Asia/Riyadh'
    Asia_Sakhalin = 'Asia/Sakhalin'
    Asia_Samarkand = 'Asia/Samarkand'
    Asia_Seoul = 'Asia/Seoul'
    Asia_Shanghai = 'Asia/Shanghai'
    Asia_Singapore = 'Asia/Singapore'
    Asia_Srednekolymsk = 'Asia/Srednekolymsk'
    Asia_Taipei = 'Asia/Taipei'
    Asia_Tashkent = 'Asia/Tashkent'
    Asia_Tbilisi = 'Asia/Tbilisi'
    Asia_Tehran = 'Asia/Tehran'
    Asia_Thimphu = 'Asia/Thimphu'
    Asia_Tokyo = 'Asia/Tokyo'
    Asia_Tomsk = 'Asia/Tomsk'
    Asia_Ulaanbaatar = 'Asia/Ulaanbaatar'
    Asia_Urumqi = 'Asia/Urumqi'
    Asia_Ust_Nera = 'Asia/Ust-Nera'
    Asia_Vientiane = 'Asia/Vientiane'
    Asia_Vladivostok = 'Asia/Vladivostok'
    Asia_Yakutsk = 'Asia/Yakutsk'
    Asia_Yangon = 'Asia/Yangon'
    Asia_Yekaterinburg = 'Asia/Yekaterinburg'
    Asia_Yerevan = 'Asia/Yerevan'
    Atlantic_Azores = 'Atlantic/Azores'
    Atlantic_Bermuda = 'Atlantic/Bermuda'
    Atlantic_Canary = 'Atlantic/Canary'
    Atlantic_Cape_Verde = 'Atlantic/Cape_Verde'
    Atlantic_Faroe = 'Atlantic/Faroe'
    Atlantic_Madeira = 'Atlantic/Madeira'
    Atlantic_Reykjavik = 'Atlantic/Reykjavik'
    Atlantic_South_Georgia = 'Atlantic/South_Georgia'
    Atlantic_St_Helena = 'Atlantic/St_Helena'
    Atlantic_Stanley = 'Atlantic/Stanley'
    Australia_Adelaide = 'Australia/Adelaide'
    Australia_Brisbane = 'Australia/Brisbane'
    Australia_Broken_Hill = 'Australia/Broken_Hill'
    Australia_Darwin = 'Australia/Darwin'
    Australia_Eucla = 'Australia/Eucla'
    Australia_Hobart = 'Australia/Hobart'
    Australia_Lindeman = 'Australia/Lindeman'
    Australia_Lord_Howe = 'Australia/Lord_Howe'
    Australia_Melbourne = 'Australia/Melbourne'
    Australia_Perth = 'Australia/Perth'
    Australia_Sydney = 'Australia/Sydney'
    Canada_Atlantic = 'Canada/Atlantic'
    Canada_Central = 'Canada/Central'
    Canada_Eastern = 'Canada/Eastern'
    Canada_Mountain = 'Canada/Mountain'
    Canada_Newfoundland = 'Canada/Newfoundland'
    Canada_Pacific = 'Canada/Pacific'
    Europe_Amsterdam = 'Europe/Amsterdam'
    Europe_Andorra = 'Europe/Andorra'
    Europe_Astrakhan = 'Europe/Astrakhan'
    Europe_Athens = 'Europe/Athens'
    Europe_Belgrade = 'Europe/Belgrade'
    Europe_Berlin = 'Europe/Berlin'
    Europe_Bratislava = 'Europe/Bratislava'
    Europe_Brussels = 'Europe/Brussels'
    Europe_Bucharest = 'Europe/Bucharest'
    Europe_Budapest = 'Europe/Budapest'
    Europe_Busingen = 'Europe/Busingen'
    Europe_Chisinau = 'Europe/Chisinau'
    Europe_Copenhagen = 'Europe/Copenhagen'
    Europe_Dublin = 'Europe/Dublin'
    Europe_Gibraltar = 'Europe/Gibraltar'
    Europe_Guernsey = 'Europe/Guernsey'
    Europe_Helsinki = 'Europe/Helsinki'
    Europe_Isle_of_Man = 'Europe/Isle_of_Man'
    Europe_Istanbul = 'Europe/Istanbul'
    Europe_Jersey = 'Europe/Jersey'
    Europe_Kaliningrad = 'Europe/Kaliningrad'
    Europe_Kirov = 'Europe/Kirov'
    Europe_Kyiv = 'Europe/Kyiv'
    Europe_Lisbon = 'Europe/Lisbon'
    Europe_Ljubljana = 'Europe/Ljubljana'
    Europe_London = 'Europe/London'
    Europe_Luxembourg = 'Europe/Luxembourg'
    Europe_Madrid = 'Europe/Madrid'
    Europe_Malta = 'Europe/Malta'
    Europe_Mariehamn = 'Europe/Mariehamn'
    Europe_Minsk = 'Europe/Minsk'
    Europe_Monaco = 'Europe/Monaco'
    Europe_Moscow = 'Europe/Moscow'
    Europe_Oslo = 'Europe/Oslo'
    Europe_Paris = 'Europe/Paris'
    Europe_Podgorica = 'Europe/Podgorica'
    Europe_Prague = 'Europe/Prague'
    Europe_Riga = 'Europe/Riga'
    Europe_Rome = 'Europe/Rome'
    Europe_Samara = 'Europe/Samara'
    Europe_San_Marino = 'Europe/San_Marino'
    Europe_Sarajevo = 'Europe/Sarajevo'
    Europe_Saratov = 'Europe/Saratov'
    Europe_Simferopol = 'Europe/Simferopol'
    Europe_Skopje = 'Europe/Skopje'
    Europe_Sofia = 'Europe/Sofia'
    Europe_Stockholm = 'Europe/Stockholm'
    Europe_Tallinn = 'Europe/Tallinn'
    Europe_Tirane = 'Europe/Tirane'
    Europe_Ulyanovsk = 'Europe/Ulyanovsk'
    Europe_Vaduz = 'Europe/Vaduz'
    Europe_Vatican = 'Europe/Vatican'
    Europe_Vienna = 'Europe/Vienna'
    Europe_Vilnius = 'Europe/Vilnius'
    Europe_Volgograd = 'Europe/Volgograd'
    Europe_Warsaw = 'Europe/Warsaw'
    Europe_Zagreb = 'Europe/Zagreb'
    Europe_Zurich = 'Europe/Zurich'
    GMT = 'GMT'
    Indian_Antananarivo = 'Indian/Antananarivo'
    Indian_Chagos = 'Indian/Chagos'
    Indian_Christmas = 'Indian/Christmas'
    Indian_Cocos = 'Indian/Cocos'
    Indian_Comoro = 'Indian/Comoro'
    Indian_Kerguelen = 'Indian/Kerguelen'
    Indian_Mahe = 'Indian/Mahe'
    Indian_Maldives = 'Indian/Maldives'
    Indian_Mauritius = 'Indian/Mauritius'
    Indian_Mayotte = 'Indian/Mayotte'
    Indian_Reunion = 'Indian/Reunion'
    Pacific_Apia = 'Pacific/Apia'
    Pacific_Auckland = 'Pacific/Auckland'
    Pacific_Bougainville = 'Pacific/Bougainville'
    Pacific_Chatham = 'Pacific/Chatham'
    Pacific_Chuuk = 'Pacific/Chuuk'
    Pacific_Easter = 'Pacific/Easter'
    Pacific_Efate = 'Pacific/Efate'
    Pacific_Fakaofo = 'Pacific/Fakaofo'
    Pacific_Fiji = 'Pacific/Fiji'
    Pacific_Funafuti = 'Pacific/Funafuti'
    Pacific_Galapagos = 'Pacific/Galapagos'
    Pacific_Gambier = 'Pacific/Gambier'
    Pacific_Guadalcanal = 'Pacific/Guadalcanal'
    Pacific_Guam = 'Pacific/Guam'
    Pacific_Honolulu = 'Pacific/Honolulu'
    Pacific_Kanton = 'Pacific/Kanton'
    Pacific_Kiritimati = 'Pacific/Kiritimati'
    Pacific_Kosrae = 'Pacific/Kosrae'
    Pacific_Kwajalein = 'Pacific/Kwajalein'
    Pacific_Majuro = 'Pacific/Majuro'
    Pacific_Marquesas = 'Pacific/Marquesas'
    Pacific_Midway = 'Pacific/Midway'
    Pacific_Nauru = 'Pacific/Nauru'
    Pacific_Niue = 'Pacific/Niue'
    Pacific_Norfolk = 'Pacific/Norfolk'
    Pacific_Noumea = 'Pacific/Noumea'
    Pacific_Pago_Pago = 'Pacific/Pago_Pago'
    Pacific_Palau = 'Pacific/Palau'
    Pacific_Pitcairn = 'Pacific/Pitcairn'
    Pacific_Pohnpei = 'Pacific/Pohnpei'
    Pacific_Port_Moresby = 'Pacific/Port_Moresby'
    Pacific_Rarotonga = 'Pacific/Rarotonga'
    Pacific_Saipan = 'Pacific/Saipan'
    Pacific_Tahiti = 'Pacific/Tahiti'
    Pacific_Tarawa = 'Pacific/Tarawa'
    Pacific_Tongatapu = 'Pacific/Tongatapu'
    Pacific_Wake = 'Pacific/Wake'
    Pacific_Wallis = 'Pacific/Wallis'
    US_Alaska = 'US/Alaska'
    US_Arizona = 'US/Arizona'
    US_Central = 'US/Central'
    US_Eastern = 'US/Eastern'
    US_Hawaii = 'US/Hawaii'
    US_Mountain = 'US/Mountain'
    US_Pacific = 'US/Pacific'
    UTC = 'UTC'


class Status12(Enum):
    active = 'active'
    archived = 'archived'


class Status13(Enum):
    active = 'active'
    archived = 'archived'


class MakeActiveType(Enum):
    replace_immediately = 'replace_immediately'
    replace_on_active_version_renewal = 'replace_on_active_version_renewal'
    grandfather_active = 'grandfather_active'


class ReplaceImmediatelyType(Enum):
    end_current_subscription_and_bill = 'end_current_subscription_and_bill'
    end_current_subscription_dont_bill = 'end_current_subscription_dont_bill'
    change_subscription_plan = 'change_subscription_plan'


class PatchedPlanVersionUpdateRequest(BaseModel):
    description: Optional[str] = None
    status: Optional[Status13] = None
    make_active_type: Optional[MakeActiveType] = None
    replace_immediately_type: Optional[ReplaceImmediatelyType] = None
    transition_to_plan_id: Optional[UUID] = None


class PaymentProcessor(Enum):
    stripe = 'stripe'


class PaymentProviderPostDataRequest(BaseModel):
    payment_processor: PaymentProcessor
    data: Dict[str, Any]


class PaymentProviderPostRequestRequest(BaseModel):
    pp_info: PaymentProviderPostDataRequest


class PaymentProcessor1(Enum):
    stripe = 'stripe'


class PaymentProviderPostResponse(BaseModel):
    payment_processor: PaymentProcessor1
    success: bool
    details: str


class PeriodMetricRevenueResponse(BaseModel):
    total_revenue_period_1: confloat(lt=10000000000.0, gt=-10000000000.0)
    total_revenue_period_2: confloat(lt=10000000000.0, gt=-10000000000.0)
    earned_revenue_period_1: confloat(lt=10000000000.0, gt=-10000000000.0)
    earned_revenue_period_2: confloat(lt=10000000000.0, gt=-10000000000.0)


class PeriodSingleMetricUsage(BaseModel):
    data: List[DayMetricUsage]


class PeriodSubscriptionsResponse(BaseModel):
    period_1_total_subscriptions: int
    period_1_new_subscriptions: int
    period_2_total_subscriptions: int
    period_2_new_subscriptions: int


class PlanDurationEnum(Enum):
    monthly = 'monthly'
    quarterly = 'quarterly'
    yearly = 'yearly'


class PlanDuration(BaseModel):
    __root__: Optional[PlanDurationEnum] = Field(
        None, description='Duration of the plan'
    )


class Status14(Enum):
    active = 'active'
    archived = 'archived'
    experimental = 'experimental'


class PlanDuration1Enum(Enum):
    monthly = 'monthly'
    quarterly = 'quarterly'
    yearly = 'yearly'


class PlanDuration1(BaseModel):
    __root__: Optional[PlanDuration1Enum] = Field(
        None, description='Duration of the plan'
    )


class Status15(Enum):
    active = 'active'
    archived = 'archived'
    experimental = 'experimental'


class PlanDuration2Enum(Enum):
    monthly = 'monthly'
    quarterly = 'quarterly'
    yearly = 'yearly'


class PlanDuration2(BaseModel):
    __root__: Optional[PlanDuration2Enum] = Field(
        None, description='Duration of the plan'
    )


class Status16(Enum):
    active = 'active'
    archived = 'archived'
    experimental = 'experimental'


class PlanNameAndID(BaseModel):
    plan_name: constr(max_length=100) = Field(..., description='Name of the plan')
    plan_id: str


class PlanRepresentation(BaseModel):
    plan_name: str
    plan_id: str
    plan_revenue: float


class Status17(Enum):
    active = 'active'
    archived = 'archived'


class FlatFeeBillingType(Enum):
    in_advance = 'in_advance'
    in_arrears = 'in_arrears'


class UsageBillingFrequency1Enum(Enum):
    monthly = 'monthly'
    quarterly = 'quarterly'
    end_of_period = 'end_of_period'


class UsageBillingFrequency1(BaseModel):
    __root__: Optional[UsageBillingFrequency1Enum] = None


class Status18(Enum):
    active = 'active'
    retiring = 'retiring'
    grandfathered = 'grandfathered'
    archived = 'archived'
    inactive = 'inactive'


class UsageBillingFrequency2Enum(Enum):
    monthly = 'monthly'
    quarterly = 'quarterly'
    end_of_period = 'end_of_period'
    field_ = ''


class UsageBillingFrequency2(BaseModel):
    __root__: Optional[UsageBillingFrequency2Enum] = None


class MakeActiveType1(Enum):
    replace_immediately = 'replace_immediately'
    replace_on_active_version_renewal = 'replace_on_active_version_renewal'
    grandfather_active = 'grandfather_active'


class ReplaceImmediatelyType1(Enum):
    end_current_subscription_and_bill = 'end_current_subscription_and_bill'
    end_current_subscription_dont_bill = 'end_current_subscription_dont_bill'
    change_subscription_plan = 'change_subscription_plan'


class FlatFeeBillingType1(Enum):
    in_advance = 'in_advance'
    in_arrears = 'in_arrears'


class UsageBillingFrequency3Enum(Enum):
    monthly = 'monthly'
    quarterly = 'quarterly'
    end_of_period = 'end_of_period'


class UsageBillingFrequency3(BaseModel):
    __root__: Optional[UsageBillingFrequency3Enum] = None


class Status19(Enum):
    active = 'active'
    retiring = 'retiring'
    grandfathered = 'grandfathered'
    archived = 'archived'
    inactive = 'inactive'


class Status20(Enum):
    active = 'active'
    archived = 'archived'


class MakeActiveType2(Enum):
    replace_immediately = 'replace_immediately'
    replace_on_active_version_renewal = 'replace_on_active_version_renewal'
    grandfather_active = 'grandfather_active'


class ReplaceImmediatelyType2(Enum):
    end_current_subscription_and_bill = 'end_current_subscription_and_bill'
    end_current_subscription_dont_bill = 'end_current_subscription_dont_bill'
    change_subscription_plan = 'change_subscription_plan'


class PlanVersionUpdate(BaseModel):
    description: Optional[str] = None
    status: Optional[Status20] = None
    make_active_type: Optional[MakeActiveType2] = None
    replace_immediately_type: Optional[ReplaceImmediatelyType2] = None


class Status21(Enum):
    success = 'success'


class PriceAdjustmentType(Enum):
    percentage = 'percentage'
    fixed = 'fixed'
    price_override = 'price_override'


class PriceAdjustment(BaseModel):
    price_adjustment_name: constr(max_length=100)
    price_adjustment_description: Optional[str] = Field(...)
    price_adjustment_type: PriceAdjustmentType
    price_adjustment_amount: confloat(lt=10000000000.0, gt=-10000000000.0)


class PriceAdjustmentType1(Enum):
    percentage = 'percentage'
    fixed = 'fixed'
    price_override = 'price_override'


class PriceAdjustmentRequest(BaseModel):
    price_adjustment_name: constr(min_length=1) = ''
    price_adjustment_description: Optional[str] = None
    price_adjustment_type: PriceAdjustmentType1
    price_adjustment_amount: confloat(lt=10000000000.0, gt=-10000000000.0)


class Type(Enum):
    flat = 'flat'
    per_unit = 'per_unit'
    free = 'free'


class BatchRoundingType(Enum):
    round_up = 'round_up'
    round_down = 'round_down'
    round_nearest = 'round_nearest'
    no_rounding = 'no_rounding'
    NoneType_None = None


class PriceTier(BaseModel):
    type: Type
    range_start: confloat(ge=0.0, lt=10000000000.0)
    range_end: Optional[confloat(ge=0.0, lt=10000000000.0)] = Field(...)
    cost_per_batch: Optional[confloat(ge=0.0, lt=10000000000.0)] = Field(...)
    metric_units_per_batch: Optional[confloat(ge=0.0, lt=10000000000.0)] = Field(...)
    batch_rounding_type: Optional[BatchRoundingType] = Field(...)


class Type1(Enum):
    flat = 'flat'
    per_unit = 'per_unit'
    free = 'free'


class BatchRoundingType1Enum(Enum):
    round_up = 'round_up'
    round_down = 'round_down'
    round_nearest = 'round_nearest'
    no_rounding = 'no_rounding'


class BatchRoundingType1(BaseModel):
    __root__: Optional[BatchRoundingType1Enum] = 'no_rounding'


class PriceTierCreateRequest(BaseModel):
    type: Type1
    range_start: confloat(ge=0.0, lt=10000000000.0)
    range_end: Optional[confloat(ge=0.0, lt=10000000000.0)] = None
    cost_per_batch: Optional[confloat(ge=0.0, lt=10000000000.0)] = None
    metric_units_per_batch: Optional[confloat(ge=0.0, lt=10000000000.0)] = None
    batch_rounding_type: Optional[BatchRoundingType1] = 'no_rounding'


class PricingUnit(BaseModel):
    code: constr(max_length=10)
    name: constr(max_length=100)
    symbol: constr(max_length=10)


class PricingUnitRequest(BaseModel):
    code: constr(min_length=1, max_length=10)
    name: constr(min_length=1, max_length=100)
    symbol: constr(min_length=1, max_length=10)


class Status22(Enum):
    active = 'active'
    archived = 'archived'


class Product(BaseModel):
    name: constr(max_length=100)
    description: Optional[str] = None
    product_id: Optional[constr(regex=r'^[-a-zA-Z0-9_]+$', max_length=100)] = None
    status: Status22


class Status23(Enum):
    active = 'active'
    archived = 'archived'


class ProductRequest(BaseModel):
    name: constr(min_length=1, max_length=100)
    description: Optional[str] = None
    product_id: Optional[
        constr(regex=r'^[-a-zA-Z0-9_]+$', min_length=1, max_length=100)
    ] = None
    status: Status23


class ChargeTiming(Enum):
    in_advance = 'in_advance'
    in_arrears = 'in_arrears'


class ChargeBehavior(Enum):
    prorate = 'prorate'
    full = 'full'


class RecurringCharge(BaseModel):
    name: str
    charge_timing: ChargeTiming
    charge_behavior: ChargeBehavior
    amount: confloat(ge=0.0, lt=10000000000.0)
    pricing_unit: PricingUnit


class ChargeTiming1(Enum):
    in_advance = 'in_advance'
    in_arrears = 'in_arrears'


class ChargeBehavior1(Enum):
    prorate = 'prorate'
    full = 'full'


class RecurringChargeCreateRequest(BaseModel):
    name: constr(min_length=1)
    charge_timing: ChargeTiming1
    charge_behavior: ChargeBehavior1 = 'prorate'
    amount: confloat(ge=0.0, lt=10000000000.0)
    pricing_unit_code: Optional[constr(min_length=1)] = None


class RegistrationDetailRequest(BaseModel):
    organization_name: str
    industry: str
    email: constr(min_length=1)
    password: constr(min_length=1)
    username: constr(min_length=1)


class RegistrationFailure(BaseModel):
    detail: str


class RegistrationRequest(BaseModel):
    register_: RegistrationDetailRequest = Field(..., alias='register')


class ResetPasswordRequestRequest(BaseModel):
    userId: constr(min_length=1)
    password: constr(min_length=1)
    token: constr(min_length=1)


class ResetPasswordSuccess(BaseModel):
    detail: str
    token: str


class RevenueDate(BaseModel):
    date: date
    original_plan_revenue: float
    new_plan_revenue: float


class Seller(BaseModel):
    name: str
    address: Optional[Address] = None
    phone: Optional[constr(max_length=20)] = None
    email: Optional[EmailStr] = None


class SellerRequest(BaseModel):
    name: constr(min_length=1)
    phone: Optional[constr(max_length=20)] = None
    email: Optional[EmailStr] = None


class SessionSuccess(BaseModel):
    isAuthenticated: bool


class SingleCustomerValue(BaseModel):
    customer_id: str
    customer_name: str
    value: float


class SinglePaymentProvider(BaseModel):
    payment_provider_name: str
    connected: bool
    redirect_url: AnyUrl


class SinglePlanNumCustomers(BaseModel):
    plan_name: str
    num_customers: int
    percent_total: float


class SubscriptionCategoricalFilter(BaseModel):
    value: str
    property_name: str = Field(
        ...,
        description="The string name of the property to filter on. Example: 'product_id'",
    )


class SubscriptionCategoricalFilterRequest(BaseModel):
    value: constr(min_length=1)
    property_name: constr(min_length=1) = Field(
        ...,
        description="The string name of the property to filter on. Example: 'product_id'",
    )


class SubscriptionCustomerSummary(BaseModel):
    billing_plan_name: str
    plan_version: str
    end_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )
    auto_renew: Optional[bool] = Field(
        None,
        description='Whether the subscription automatically renews. Defaults to true.',
    )


class SubscriptionRecord(BaseModel):
    start_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )
    end_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )
    auto_renew: bool = Field(
        ...,
        description='Whether the subscription automatically renews. Defaults to true.',
    )
    is_new: bool = Field(
        ...,
        description='Whether this subscription came from a renewal or from a first-time. Defaults to true on creation.',
    )
    subscription_filters: List[SubscriptionCategoricalFilter]
    customer: LightweightCustomer
    billing_plan: LightweightPlanVersion
    fully_billed: bool = Field(
        ..., description='Whether the subscription has been fully billed and finalized.'
    )
    addons: List[LightweightAddonSubscriptionRecord]


class FlatFeeBehaviorEnum(Enum):
    refund = 'refund'
    charge_prorated = 'charge_prorated'
    charge_full = 'charge_full'


class FlatFeeBehavior(BaseModel):
    __root__: Optional[FlatFeeBehaviorEnum] = Field(
        None,
        description="When canceling a subscription, the behavior used to calculate the flat fee. If null or not provided, the charge's default behavior will be used according to the subscription's start and end dates. If charge_full, the full flat fee will be charged, regardless of the duration of teh subscription. If refund, the flat fee will not be charged. If charge_prorated, the prorated flat fee will be charged.",
    )


class UsageBehavior(Enum):
    bill_full = 'bill_full'
    bill_none = 'bill_none'


class InvoicingBehavior1(Enum):
    add_to_next_invoice = 'add_to_next_invoice'
    invoice_now = 'invoice_now'


class SubscriptionRecordCancelRequest(BaseModel):
    flat_fee_behavior: Optional[FlatFeeBehavior] = Field(
        None,
        description="When canceling a subscription, the behavior used to calculate the flat fee. If null or not provided, the charge's default behavior will be used according to the subscription's start and end dates. If charge_full, the full flat fee will be charged, regardless of the duration of teh subscription. If refund, the flat fee will not be charged. If charge_prorated, the prorated flat fee will be charged.",
    )
    usage_behavior: UsageBehavior = Field(
        'bill_full',
        description='If bill_full, current usage will be billed on the invoice. If bill_none, current unbilled usage will be dropped from the invoice. Defaults to bill_full.',
    )
    invoicing_behavior: InvoicingBehavior1 = Field(
        'invoice_now',
        description='Whether to invoice now or invoice at the end of the billing period. Defaults to invoice now.',
    )


class SubscriptionRecordCreateRequest(BaseModel):
    start_date: datetime = Field(
        ...,
        description='The date the subscription starts. This should be a string in YYYY-MM-DD format of the date in UTC time.',
    )
    end_date: Optional[datetime] = Field(
        None,
        description='The date the subscription ends. This should be a string in YYYY-MM-DD format of the date in UTC time. If you don’t set it (recommended), we will use the information in the billing plan to automatically calculate this.',
    )
    auto_renew: Optional[bool] = Field(
        None,
        description='Whether the subscription automatically renews. Defaults to true.',
    )
    is_new: Optional[bool] = None
    subscription_filters: Optional[List[SubscriptionCategoricalFilterRequest]] = Field(
        None,
        description='Add filter key, value pairs that define which events will be applied to this plan subscription.',
    )
    customer_id: constr(min_length=1) = Field(
        ..., description='The id provided when creating the customer'
    )
    plan_id: UUID = Field(
        ..., description='The Lotus plan_id, found in the billing plan object'
    )


class SubscriptionRecordRequest(BaseModel):
    start_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )
    end_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )
    auto_renew: bool = Field(
        ...,
        description='Whether the subscription automatically renews. Defaults to true.',
    )
    is_new: bool = Field(
        ...,
        description='Whether this subscription came from a renewal or from a first-time. Defaults to true on creation.',
    )
    subscription_filters: List[SubscriptionCategoricalFilterRequest]
    billing_plan: LightweightPlanVersionRequest
    fully_billed: bool = Field(
        ..., description='Whether the subscription has been fully billed and finalized.'
    )
    addons: List[LightweightAddonSubscriptionRecordRequest]


class InvoicingBehavior2(Enum):
    add_to_next_invoice = 'add_to_next_invoice'
    invoice_now = 'invoice_now'


class UsageBehavior1(Enum):
    transfer_to_new_subscription = 'transfer_to_new_subscription'
    keep_separate = 'keep_separate'


class SubscriptionRecordUpdateRequest(BaseModel):
    replace_plan_id: Optional[UUID] = Field(
        None,
        description="If provided, will replace the current subscription's plan with this plan. If this is provided,turn_off_auto_renew and end_date will be ignored. The provided plan must have the same duration as the current plan.",
    )
    invoicing_behavior: InvoicingBehavior2 = Field(
        'invoice_now',
        description='The invoicing behavior to use when replacing the plan. Invoice now will invoice the customer for the prorated difference of the old plan and the new plan, whereas add_to_next_invoice will wait until the end of the subscription to do the calculation.',
    )
    usage_behavior: UsageBehavior1 = Field(
        'transfer_to_new_subscription',
        description='The usage behavior to use when replacing the plan. Transfer to new subscription will transfer the usage from the old subscription to the new subscription, whereas reset_usage will reset the usage to 0 for the new subscription, while keeping the old usage on the old subscription and charging for that appropriately at the end of the month.',
    )
    turn_off_auto_renew: Optional[bool] = Field(
        None, description='Turn off auto renew for the subscription'
    )
    end_date: Optional[datetime] = Field(
        None, description='Change the end date for the subscription.'
    )


class Tag(BaseModel):
    tag_name: constr(max_length=50)
    tag_hex: Optional[constr(max_length=7)] = None
    tag_color: Optional[constr(max_length=20)] = None


class TagRequest(BaseModel):
    tag_name: constr(min_length=1, max_length=50)
    tag_hex: Optional[constr(min_length=1, max_length=7)] = None
    tag_color: Optional[constr(min_length=1, max_length=20)] = None


class TimezonesResponse(BaseModel):
    timezones: List[str]


class TopCustomers(BaseModel):
    original_plan_revenue: List[SingleCustomerValue]
    new_plan_revenue: List[SingleCustomerValue]
    biggest_pct_increase: List[SingleCustomerValue]
    biggest_pct_decrease: List[SingleCustomerValue]


class Success(Enum):
    none = 'none'


class TrackEventFailure(BaseModel):
    success: Success
    failed_events: Dict[str, Any]


class Success1(Enum):
    all = 'all'
    some = 'some'


class TrackEventSuccess(BaseModel):
    success: Success1
    failed_events: Dict[str, Any]


class Status24(Enum):
    error = 'error'


class TransferSubscriptionsFailure(BaseModel):
    status: Status24
    detail: str


class Source6(Enum):
    stripe = 'stripe'


class TransferSubscriptionsRequestRequest(BaseModel):
    source: Source6
    end_now: bool


class Status25(Enum):
    success = 'success'


class TransferSubscriptionsSuccess(BaseModel):
    status: Status25
    detail: str


class UsageAlertCreate(BaseModel):
    metric_id: UUID
    plan_version_id: UUID
    threshold: confloat(lt=10000000000.0, gt=-10000000000.0)


class UsageAlertCreateRequest(BaseModel):
    metric_id: UUID
    plan_version_id: UUID
    threshold: confloat(lt=10000000000.0, gt=-10000000000.0)


class User(BaseModel):
    username: constr(regex=r'^[\w.@+-]+$', max_length=150) = Field(
        ...,
        description='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.',
    )
    email: EmailStr
    organization_name: str
    organization_id: str


class UserRequest(BaseModel):
    username: constr(regex=r'^[\w.@+-]+$', min_length=1, max_length=150) = Field(
        ...,
        description='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.',
    )
    email: EmailStr
    organization_name: constr(min_length=1)
    organization_id: constr(min_length=1)


class TriggersInEnum(Enum):
    invoice_created = 'invoice.created'
    invoice_paid = 'invoice.paid'
    usage_alert_triggered = 'usage_alert.triggered'


class WebhookEndpointRequest(BaseModel):
    name: Optional[constr(max_length=100)] = None
    webhook_url: constr(min_length=1, max_length=100)
    triggers_in: List[TriggersInEnum]


class TriggerName(Enum):
    invoice_created = 'invoice.created'
    invoice_paid = 'invoice.paid'
    usage_alert_triggered = 'usage_alert.triggered'


class WebhookTrigger(BaseModel):
    trigger_name: TriggerName


class TriggerName1(Enum):
    invoice_created = 'invoice.created'
    invoice_paid = 'invoice.paid'
    usage_alert_triggered = 'usage_alert.triggered'


class WebhookTriggerRequest(BaseModel):
    trigger_name: TriggerName1


class AccessMethodsSubscriptionRecord(BaseModel):
    start_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )
    end_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )
    subscription_filters: List[SubscriptionCategoricalFilter]
    plan: LightweightPlanVersion


class AddOnSubscriptionRecordCreateRequest(BaseModel):
    attach_to_customer_id: constr(min_length=1) = Field(
        ..., description="The add-on will be applied to this customer's subscription."
    )
    attach_to_plan_id: UUID = Field(
        ...,
        description='The add-on will be applied to the subscription with this plan ID.',
    )
    attach_to_subscription_filters: Optional[
        List[SubscriptionCategoricalFilterRequest]
    ] = Field(
        None,
        description='In the case the customer has multiple subscriptions with the same plan ID, the subscription filters should be used to specify which subscription to apply the add-on to.',
    )
    addon_id: UUID = Field(
        ..., description='The add-on to be applied to the subscription.'
    )
    quantity: conint(ge=1) = Field(
        1,
        description='The quantity of the add-on to be applied to the subscription. Flat fees of add-ons will be multiplied by this quantity. Usage-based components of add-ons will be unaffected by the quantity.',
    )


class BacktestCreateRequest(BaseModel):
    start_date: date
    end_date: date
    substitutions: List[BacktestSubstitutionMultiRequest]
    kpis: List[Kpi1]
    backtest_name: constr(min_length=1, max_length=100)


class BatchEventRequest(BaseModel):
    batch: List[EventRequest]


class CustomerBalanceAdjustment(BaseModel):
    credit_id: str
    customer: LightweightCustomer
    amount: confloat(ge=0.0, lt=10000000000.0)
    amount_remaining: confloat(ge=0.0, lt=10000000000.0)
    currency: PricingUnit
    description: Optional[str] = Field(...)
    effective_at: datetime
    expires_at: Optional[datetime] = Field(...)
    status: Status4
    amount_paid: confloat(lt=10000000000.0, gt=-10000000000.0)
    amount_paid_currency: Optional[PricingUnit] = Field(...)
    drawdowns: List[CreditDrawdown]


class CustomerIntegrations(BaseModel):
    stripe: Optional[CustomerStripeIntegration] = None


class CustomerSummary(BaseModel):
    customer_name: Optional[constr(max_length=100)] = Field(
        None, description='The display name of the customer'
    )
    customer_id: Optional[constr(regex=r'^[-a-zA-Z0-9_]+$', max_length=50)] = Field(
        None,
        description='The id provided when creating the customer, we suggest matching with your internal customer id in your backend',
    )
    subscriptions: List[SubscriptionCustomerSummary]


class DemoLoginSuccess(BaseModel):
    detail: str
    token: str
    user: User


class DemoRegistrationSuccess(BaseModel):
    detail: str
    token: str
    user: User


class FeatureAccessPerSubscription(BaseModel):
    subscription: AccessMethodsSubscriptionRecord
    access: bool


class FeatureAccessResponse(BaseModel):
    customer: LightweightCustomer
    access: bool = Field(
        ...,
        description="Whether or not the customer has access to this feature. The default behavior for this is whether any of the customer's plans have access to this feature. If you have specified subscription filters, then this will be whether any of the customer's plans that match the subscription filters have access to this feature. You can customize the behavior of this flag by setting a policy in your Organization settings in the frontend.",
    )
    feature: Feature
    access_per_subscription: List[FeatureAccessPerSubscription]


class GetEventAccess(BaseModel):
    plan_id: str = Field(
        ...,
        description='The plan_id of the plan we are checking that has access to this feature.',
    )
    subscription_filters: List[SubscriptionCategoricalFilter] = Field(
        ...,
        description="The subscription filters that are applied to this plan's relationship with the customer. If your billing model does not have the ability multiple plans or subscriptions per customer, this is likely not relevant for you.",
    )
    usage_per_component: List[ComponentUsage] = Field(
        ...,
        description="The usage of each component of the plan the customer is on. Only components that match the request will be included: If metric_id is provided, this will be a list of length 1. If event_name is provided, this will be a list of length 1 or more depending on how many components of the customer's plan use this event.",
    )


class GetFeatureAccess(BaseModel):
    feature_name: str = Field(
        ..., description='Name of the feature to check access for.'
    )
    plan_id: str = Field(
        ...,
        description='The plan_id of the plan we are checking that has access to this feature.',
    )
    subscription_filters: List[SubscriptionCategoricalFilter] = Field(
        ...,
        description="The subscription filters that are applied to this plan's relationship with the customer. If your billing model does not have the ability multiple plans or subscriptions per customer, this is likely not relevant for you.",
    )
    access: bool = Field(
        ...,
        description="Whether or not the plan has access to this feature. If your customer can have multiple plans or subscriptions, then you must check the 'access' across all returned plans to determine if the customer can access this feature.",
    )


class InvoiceLineItem(BaseModel):
    name: constr(max_length=100)
    start_date: datetime
    end_date: datetime
    quantity: Optional[confloat(ge=0.0, lt=10000000000.0)] = Field(...)
    subtotal: confloat(lt=10000000000.0, gt=-10000000000.0)
    billing_type: Optional[BillingType] = Field(...)
    metadata: Optional[Dict[str, Any]] = Field(...)
    plan: Optional[LightweightPlanVersion] = Field(...)
    subscription_filters: Optional[List[SubscriptionCategoricalFilter]] = Field(...)


class InvoiceRequest(BaseModel):
    invoice_id: constr(min_length=1)
    currency: PricingUnitRequest
    external_payment_obj_type: Optional[ExternalPaymentObjType1] = Field(...)
    line_items: List[InvoiceLineItemRequest]
    seller: SellerRequest


class LightweightInvoice(BaseModel):
    external_payment_obj_type: Optional[ExternalPaymentObjType2] = Field(...)
    invoice_number: str
    external_payment_obj_id: Optional[str] = Field(...)
    payment_status: PaymentStatus2
    seller: Seller
    issue_date: datetime
    cost_due: confloat(lt=10000000000.0, gt=-10000000000.0)
    start_date: date
    invoice_pdf: Optional[AnyUrl] = Field(...)
    invoice_id: str
    end_date: date
    due_date: Optional[datetime] = Field(...)
    currency: PricingUnit


class LightweightInvoiceLineItem(BaseModel):
    plan: Optional[LightweightPlanVersion] = Field(...)
    name: constr(max_length=100)
    subscription_filters: Optional[List[SubscriptionCategoricalFilter]] = Field(...)
    subtotal: confloat(lt=10000000000.0, gt=-10000000000.0)
    quantity: Optional[confloat(ge=0.0, lt=10000000000.0)] = Field(...)
    start_date: datetime
    end_date: datetime
    billing_type: Optional[BillingType2] = Field(...)


class LightweightSubscriptionRecord(BaseModel):
    fully_billed: bool = Field(
        ..., description='Whether the subscription has been fully billed and finalized.'
    )
    customer: LightweightCustomer
    addons: List[LightweightAddonSubscriptionRecord]
    auto_renew: bool = Field(
        ...,
        description='Whether the subscription automatically renews. Defaults to true.',
    )
    subscription_filters: List[SubscriptionCategoricalFilter]
    is_new: bool = Field(
        ...,
        description='Whether this subscription came from a renewal or from a first-time. Defaults to true on creation.',
    )
    start_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )
    billing_plan: LightweightPlanVersion
    end_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )
    plan_detail: LightweightPlanVersion


class LoginSuccess(BaseModel):
    detail: str
    token: str
    user: User


class Metric(BaseModel):
    metric_id: str
    event_name: str = Field(
        ..., description='Name of the event that this metric is tracking.'
    )
    property_name: Optional[str] = Field(
        ...,
        description="The name of the property of the event that should be used for this metric. Doesn't apply if the metric is of type 'counter' with an aggregation of count.",
    )
    aggregation_type: str
    granularity: Optional[Granularity] = Field(
        ...,
        description="The granularity of the metric. Only applies to metrics of type 'gauge' or 'rate'.",
    )
    event_type: Optional[EventType] = Field(
        ...,
        description="Used only for metrics of type 'gauge'. Please refer to our documentation for an explanation of the different types.",
    )
    metric_type: MetricType = Field(
        ...,
        description='The type of metric that this is. Please refer to our documentation for an explanation of the different types.',
    )
    metric_name: str
    numeric_filters: List[NumericFilter]
    categorical_filters: List[CategoricalFilter]
    is_cost_metric: bool = Field(
        ...,
        description='Whether or not this metric is a cost metric (used to track costs to your business).',
    )
    custom_sql: Optional[str] = Field(
        ...,
        description='A custom SQL query that can be used to define the metric. Please refer to our documentation for more information.',
    )
    proration: Optional[Proration] = Field(
        ...,
        description="The proration of the metric. Only applies to metrics of type 'gauge'.",
    )


class MetricAccessPerSubscription(BaseModel):
    subscription: AccessMethodsSubscriptionRecord
    metric_usage: confloat(ge=0.0, lt=10000000000.0) = Field(
        ...,
        description='The current usage of the metric. Keep in mind the current usage of the metric can be different from the billable usage of the metric. For examnple, for a gauge metric, the `metric_usage` is the current value of the gauge, while the billable usage is the accumulated tiem at each gauge level at the end of the subscription.',
    )
    metric_free_limit: Optional[confloat(ge=0.0, lt=10000000000.0)] = Field(
        ...,
        description="If you specified a free tier of usage for this metric, this is the amount of usage that is free. Will be 0 if you didn't specify a free limit for this metric or this subscription doesn't have access to this metric, and null if the free tier is unlimited.",
    )
    metric_total_limit: Optional[confloat(ge=0.0, lt=10000000000.0)] = Field(
        ...,
        description="The total limit of the metric. Will be 0 if this subscription doesn't have access to this metric, and null if there is no limit to this metric.",
    )


class MetricAccessResponse(BaseModel):
    customer: LightweightCustomer
    access: bool = Field(
        ...,
        description="Whether or not the customer has access to this metric. The default behavior for this is whether all of the customer's plans (that have access to the metric) are below the total limit of the metric. If you have specified subscription filters, then this will be whether all of the customer's plans that match the subscription filters are below the total limit of the metric. You can customize the behavior of this flag by setting a policy in your Organization settings in the frontend.",
    )
    metric: LightweightMetric
    access_per_subscription: List[MetricAccessPerSubscription]


class MetricCreateRequest(BaseModel):
    event_name: Optional[constr(min_length=1, max_length=50)] = Field(
        None, description='Name of the event that this metric is tracking.'
    )
    property_name: Optional[constr(min_length=1, max_length=50)] = Field(
        None,
        description="The name of the property of the event that should be used for this metric. Doesn't apply if the metric is of type 'counter' with an aggregation of count.",
    )
    usage_aggregation_type: Optional[UsageAggregationType] = Field(
        None,
        description='The type of aggregation that should be used for this metric. Please refer to our documentation for an explanation of the different types.',
    )
    billable_aggregation_type: Optional[BillableAggregationType] = None
    granularity: Optional[Granularity1] = Field(
        None,
        description="The granularity of the metric. Only applies to metrics of type 'gauge' or 'rate'.",
    )
    event_type: Optional[EventType1] = Field(
        None,
        description="Used only for metrics of type 'gauge'. Please refer to our documentation for an explanation of the different types.",
    )
    metric_type: MetricType1 = Field(
        ...,
        description='The type of metric that this is. Please refer to our documentation for an explanation of the different types.',
    )
    metric_name: constr(min_length=1)
    proration: Optional[Proration1] = Field(
        None,
        description="The proration of the metric. Only applies to metrics of type 'gauge'.",
    )
    properties: Optional[Dict[str, Any]] = None
    is_cost_metric: bool = Field(
        False,
        description='Whether or not this metric is a cost metric (used to track costs to your business).',
    )
    custom_sql: Optional[str] = Field(
        None,
        description='A custom SQL query that can be used to define the metric. Please refer to our documentation for more information.',
    )
    categorical_filters: Optional[List[CategoricalFilterRequest]] = None
    numeric_filters: Optional[List[NumericFilterRequest]] = None


class MetricRequest(BaseModel):
    metric_id: constr(min_length=1)
    aggregation_type: constr(min_length=1)
    metric_name: constr(min_length=1)
    numeric_filters: List[NumericFilterRequest]
    categorical_filters: List[CategoricalFilterRequest]


class Organization(BaseModel):
    organization_id: str
    organization_name: constr(max_length=100)
    payment_provider_ids: Optional[Dict[str, Any]] = None
    users: List[OrganizationUser]
    default_currency: PricingUnit
    available_currencies: List[PricingUnit]
    plan_tags: List[Tag]
    tax_rate: Optional[confloat(ge=0.0, le=999.9999)] = Field(
        None, description='Tax rate as percentage. For example, 10.5 for 10.5%'
    )
    payment_grace_period: Optional[conint(ge=0, le=365)] = Field(...)
    linked_organizations: List[LightweightOrganization]
    current_user: LightweightUser
    address: Optional[Address] = Field(...)
    team_name: str
    subscription_filter_keys: List[str]
    timezone: Timezone2


class PatchedOrganizationUpdateRequest(BaseModel):
    default_currency_code: Optional[constr(min_length=1)] = None
    address: Optional[AddressRequest] = None
    tax_rate: Optional[confloat(ge=0.0, le=999.9999)] = Field(
        None, description='Tax rate as percentage. For example, 10.5 for 10.5%'
    )
    payment_grace_period: Optional[conint(ge=0, le=365)] = None
    plan_tags: Optional[List[TagRequest]] = None
    subscription_filter_keys: Optional[List[constr(min_length=1)]] = None
    timezone: Optional[Timezone4] = None


class PatchedPlanUpdateRequest(BaseModel):
    plan_name: Optional[constr(min_length=1, max_length=100)] = Field(
        None, description='Name of the plan'
    )
    status: Optional[Status12] = None
    tags: Optional[List[TagRequest]] = None


class PeriodMetricUsageResponse(BaseModel):
    metrics: Dict[str, PeriodSingleMetricUsage]


class PlanComponent(BaseModel):
    billable_metric: Metric
    tiers: List[PriceTier]
    pricing_unit: PricingUnit


class PlanComponentCreateRequest(BaseModel):
    metric_id: UUID
    tiers: Optional[List[PriceTierCreateRequest]] = None


class PlanUpdate(BaseModel):
    plan_name: Optional[constr(max_length=100)] = Field(
        None, description='Name of the plan'
    )
    status: Optional[Status17] = None
    tags: Optional[List[Tag]] = None


class PlanVersion(BaseModel):
    description: Optional[str] = Field(...)
    flat_fee_billing_type: FlatFeeBillingType
    flat_rate: confloat(ge=0.0, lt=10000000000.0)
    recurring_charges: List[RecurringCharge]
    components: List[PlanComponent]
    features: List[Feature]
    price_adjustment: Optional[PriceAdjustment] = Field(...)
    usage_billing_frequency: Optional[UsageBillingFrequency1] = Field(...)
    version: int
    status: Status18
    plan_name: str
    currency: PricingUnit


class PlanVersionCreateRequest(BaseModel):
    description: Optional[str] = None
    plan_id: Optional[UUID] = None
    recurring_charges: Optional[List[RecurringChargeCreateRequest]] = None
    components: Optional[List[PlanComponentCreateRequest]] = None
    features: Optional[List[UUID]] = None
    price_adjustment: Optional[PriceAdjustmentRequest] = None
    usage_billing_frequency: Optional[UsageBillingFrequency2] = None
    day_anchor: Optional[conint(ge=1, le=31)] = None
    month_anchor: Optional[conint(ge=1, le=12)] = None
    make_active: bool
    make_active_type: Optional[MakeActiveType1] = None
    replace_immediately_type: Optional[ReplaceImmediatelyType1] = None
    transition_to_plan_id: Optional[UUID] = None
    currency_code: Optional[constr(min_length=1)] = None


class PlansByNumCustomers(BaseModel):
    results: List[SinglePlanNumCustomers]
    status: Status21


class RegistrationSuccess(BaseModel):
    detail: str
    token: str
    user: User


class SingleMetricCost(BaseModel):
    metric: Metric
    cost: confloat(lt=10000000000.0, gt=-10000000000.0)


class SingleSubstitutionResults(BaseModel):
    cumulative_revenue: List[RevenueDate]
    revenue_by_metric: List[MetricRevenue]
    top_customers: TopCustomers


class UsageAlert(BaseModel):
    usage_alert_id: str
    metric: Metric
    plan_version: LightweightPlanVersion
    threshold: confloat(lt=10000000000.0, gt=-10000000000.0)


class UsageAlertRequest(BaseModel):
    metric: MetricRequest
    plan_version: LightweightPlanVersionRequest
    threshold: confloat(lt=10000000000.0, gt=-10000000000.0)


class WebhookEndpoint(BaseModel):
    webhook_endpoint_id: str
    name: Optional[constr(max_length=100)] = None
    webhook_url: constr(max_length=100)
    webhook_secret: str
    triggers: List[WebhookTrigger]


class AddOn(BaseModel):
    addon_name: str = Field(..., description='The name of the add-on plan.')
    addon_id: str = Field(..., description='The ID of the add-on plan.')
    description: str = Field(..., description='The description of the add-on plan.')
    flat_rate: confloat(ge=0.0, lt=10000000000.0)
    components: List[PlanComponent]
    features: List[Feature]
    currency: PricingUnit = Field(
        ...,
        description='Currency of the plan. Can only be null if the flat fee is 0 and all components are of type free.',
    )
    active_instances: int = Field(
        ..., description='The number of active instances of the add-on plan.'
    )
    invoice_when: InvoiceWhen
    billing_frequency: BillingFrequency
    addon_type: AddonType


class AddOnCreateRequest(BaseModel):
    addon_name: constr(min_length=1) = Field(
        ..., description='The name of the add-on plan.'
    )
    description: Optional[constr(min_length=1)] = Field(
        ..., description='The description of the add-on plan.'
    )
    recurring_charges: Optional[List[RecurringChargeCreateRequest]] = None
    components: Optional[List[PlanComponentCreateRequest]] = None
    features: Optional[List[UUID]] = None
    currency_code: Optional[constr(min_length=1)] = None
    invoice_when: InvoiceWhen1
    billing_frequency: BillingFrequency1


class AddOnSubscriptionRecord(BaseModel):
    customer: LightweightCustomer
    addon: LightweightAddon
    start_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )
    end_date: datetime = Field(
        ...,
        description='The time the subscription starts. This will be a string in yyyy-mm-dd HH:mm:ss format in UTC time.',
    )
    parent: LightweightSubscriptionRecord
    fully_billed: bool = Field(
        ..., description='Whether the subscription has been fully billed and finalized.'
    )
    auto_renew: bool = Field(
        ...,
        description='Whether the subscription automatically renews. Defaults to true.',
    )


class Customer(BaseModel):
    customer_id: str
    email: EmailStr
    customer_name: str
    invoices: List[LightweightInvoice]
    total_amount_due: float
    subscriptions: List[SubscriptionRecord]
    integrations: CustomerIntegrations = Field(
        ...,
        description="A dictionary containing the customer's integrations. Keys are the integration type, and the value is a dictionary containing the integration's properties, which can vary by integration.",
    )
    default_currency: PricingUnit
    payment_provider: Optional[PaymentProvider] = Field(...)
    payment_provider_id: Optional[str] = Field(...)
    has_payment_method: bool
    address: Optional[Address] = None
    tax_rate: Optional[confloat(lt=1000.0, gt=-1000.0)] = Field(
        ..., description='Tax rate as percentage. For example, 10.5 for 10.5%'
    )
    timezone: Timezone


class GroupedLineItem(BaseModel):
    plan_name: str
    subscription_filters: List[SubscriptionCategoricalFilter]
    subtotal: confloat(lt=100000000.0, gt=-100000000.0)
    start_date: datetime
    end_date: datetime
    sub_items: List[LightweightInvoiceLineItem]


class InitialPlanVersionRequest(BaseModel):
    month_anchor: Optional[conint(ge=1, le=12)] = None
    transition_to_plan_id: Optional[UUID] = None
    components: Optional[List[PlanComponentCreateRequest]] = None
    recurring_charges: Optional[List[RecurringChargeCreateRequest]] = None
    currency_code: Optional[constr(min_length=1)] = None
    features: Optional[List[UUID]] = None
    usage_billing_frequency: Optional[UsageBillingFrequency] = None
    day_anchor: Optional[conint(ge=1, le=31)] = None
    description: Optional[str] = None
    price_adjustment: Optional[PriceAdjustmentRequest] = None


class Invoice(BaseModel):
    invoice_id: str
    invoice_number: str
    cost_due: confloat(lt=10000000000.0, gt=-10000000000.0)
    currency: PricingUnit
    issue_date: datetime
    payment_status: PaymentStatus
    external_payment_obj_id: Optional[str] = Field(...)
    external_payment_obj_type: Optional[ExternalPaymentObjType] = Field(...)
    line_items: List[InvoiceLineItem]
    customer: LightweightCustomerSerializerForInvoice
    due_date: Optional[datetime] = Field(...)
    start_date: date
    end_date: date
    seller: Seller
    invoice_pdf: Optional[AnyUrl] = Field(...)


class InvoiceCreatedRequest(BaseModel):
    payload: InvoiceRequest


class InvoicePaidRequest(BaseModel):
    payload: InvoiceRequest


class Plan(BaseModel):
    plan_name: constr(max_length=100) = Field(..., description='Name of the plan')
    plan_duration: Optional[PlanDuration] = Field(
        ..., description='Duration of the plan'
    )
    status: Status14
    external_links: List[InitialExternalPlanLink] = Field(
        ..., description='The external links that this plan has.'
    )
    plan_id: str
    parent_plan: Optional[PlanNameAndID] = Field(...)
    target_customer: Optional[LightweightCustomer] = Field(...)
    display_version: PlanVersion
    num_versions: int = Field(
        ..., description='The number of versions that this plan has.'
    )
    active_subscriptions: int = Field(
        ...,
        description='The number of active subscriptions that this plan has across all versions.',
    )
    tags: List[Tag] = Field(..., description='The tags that this plan has.')


class PlanCreateRequest(BaseModel):
    plan_name: constr(min_length=1, max_length=100) = Field(
        ..., description='Name of the plan'
    )
    plan_duration: Optional[PlanDuration1] = Field(
        None, description='Duration of the plan'
    )
    status: Optional[Status15] = None
    initial_external_links: Optional[List[InitialExternalPlanLinkRequest]] = None
    initial_version: InitialPlanVersionRequest
    parent_plan_id: Optional[UUID] = None
    target_customer_id: Optional[constr(min_length=1)] = Field(
        None,
        description='The id provided when creating the customer, we suggest matching with your internal customer id in your backend',
    )
    tags: Optional[List[TagRequest]] = None


class PlanVersionDetail(BaseModel):
    description: Optional[str] = Field(...)
    flat_fee_billing_type: FlatFeeBillingType1
    flat_rate: confloat(ge=0.0, lt=10000000000.0)
    recurring_charges: List[RecurringCharge]
    components: List[PlanComponent]
    features: List[Feature]
    price_adjustment: Optional[PriceAdjustment] = Field(...)
    usage_billing_frequency: Optional[UsageBillingFrequency3] = Field(...)
    version: int
    status: Status19
    plan_name: str
    currency: PricingUnit
    version_id: str
    plan_id: str
    alerts: List[UsageAlert]


class SingleDayCostAnalysis(BaseModel):
    date: date
    cost_data: List[SingleMetricCost]
    revenue: confloat(lt=10000000000.0, gt=-10000000000.0)


class SingleSubstitution(BaseModel):
    substitution_name: str
    original_plan: PlanRepresentation
    new_plan: PlanRepresentation
    pct_revenue_change: Optional[float] = Field(...)
    results: SingleSubstitutionResults


class UsageAlertPayloadRequest(BaseModel):
    subscription: LightweightSubscriptionRecordRequest
    usage_alert: UsageAlertRequest
    usage: confloat(lt=10000000000.0, gt=-10000000000.0)
    time_triggered: datetime


class UsageAlertTriggeredRequest(BaseModel):
    payload: UsageAlertPayloadRequest


class AllSubstitutionResults(BaseModel):
    substitution_results: Optional[List[SingleSubstitution]] = None
    original_plans_revenue: Optional[float] = None
    new_plans_revenue: Optional[float] = None
    pct_revenue_change: Optional[float] = None


class BacktestSubstitution(BaseModel):
    new_plan: PlanVersionDetail
    original_plan: PlanVersionDetail


class CostAnalysis(BaseModel):
    per_day: List[SingleDayCostAnalysis]
    total_cost: confloat(lt=10000000000.0, gt=-10000000000.0)
    total_revenue: confloat(lt=10000000000.0, gt=-10000000000.0)
    margin: confloat(lt=10000000000.0, gt=-10000000000.0)


class DraftInvoice(BaseModel):
    cost_due: confloat(lt=10000000000.0, gt=-10000000000.0)
    line_items: List[GroupedLineItem]
    start_date: date
    currency: PricingUnit
    invoice_id: str
    end_date: date
    due_date: Optional[datetime] = Field(...)
    issue_date: datetime


class DraftInvoiceResponse(BaseModel):
    invoice: Optional[List[DraftInvoice]] = None


class PlanDetail(BaseModel):
    plan_name: constr(max_length=100) = Field(..., description='Name of the plan')
    plan_duration: Optional[PlanDuration2] = Field(
        ..., description='Duration of the plan'
    )
    status: Status16
    external_links: List[InitialExternalPlanLink] = Field(
        ..., description='The external links that this plan has.'
    )
    plan_id: str
    parent_plan: Optional[PlanNameAndID] = Field(...)
    target_customer: Optional[LightweightCustomer] = Field(...)
    display_version: PlanVersionDetail
    num_versions: int = Field(
        ..., description='The number of versions that this plan has.'
    )
    active_subscriptions: int = Field(
        ...,
        description='The number of active subscriptions that this plan has across all versions.',
    )
    tags: List[Tag] = Field(..., description='The tags that this plan has.')
    versions: List[PlanVersionDetail]


class BacktestDetail(BaseModel):
    backtest_substitutions: List[BacktestSubstitution]
    backtest_results: AllSubstitutionResults
    kpis: Optional[Dict[str, Any]] = None
    time_created: Optional[datetime] = None
    backtest_name: constr(max_length=100)
    backtest_id: str
    status: Optional[Status] = None
    start_date: date
    end_date: date
