Description
==============

The emerging field of topological signal processing brings methods from Topological Data Analysis (TDA) to create new tools for signal processing by incorporating aspects of shape.
This python package, teaspoon for tsp or topological signal processing, brings together available software for computing persistent homology, the main workhorse of TDA, with modules that expand the functionality of teaspoon as a state-of-the-art topological signal processing tool.
These modules include methods for incorporating tools from machine learning, complex networks, information, and parameter selection along with a dynamical systems library to streamline the creation and benchmarking of new methods.
All code is open source with up to date documentation, making the code easy to use, in particular for signal processing experts with limited experience in topological methods.


Full documentation of this package is available [here](http://elizabethmunch.com/code/teaspoon/index.html). The full documentation includes information about installation, module documentation with examples, contributing, the license, and citing teaspoon.

The code is a compilation of work done by [Elizabeth Munch](http://www.elizabethmunch.com) and [Firas Khasawneh](http://www.firaskhasawneh.com/) along with her students and collaborators.  People who have contributed to teaspoon include:

- [Audun Myers](https://github.com/myersau3)
- Melih Yesilli
- [Sarah Tymochko](https://www.egr.msu.edu/~tymochko/)

Installation
=============
The teaspoon package is available through pip install with version details found [here](https://test.pypi.org/project/teaspoon/).
The package can be installed using the following pip installation::

	pip install -i https://test.pypi.org/simple/ teaspoon

The software will soon be available on PyPI!

Contacts
=============
* Liz Munch: [muncheli@msu.edu](mailto:muncheli@msu.edu).
* Firas Khasawneh: [khasawn3@egr.msu.edu](mailto:khasawn3@egr.msu.edu).
