"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeInstrumentationVersion = exports.DotnetInstrumentationVersion = exports.PythonInstrumentationVersion = exports.JavaInstrumentationVersion = exports.InstrumentationVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Base class for instrumentation versions.
 * Provides functionality to generate image URIs for different instrumentation types.
 */
class InstrumentationVersion {
    constructor(imageRepo, version, memoryLimit) {
        this.imageRepo = imageRepo;
        this.version = version;
        this.memoryLimit = memoryLimit;
    }
    /**
     * Get the image URI for the instrumentation version.
     * @returns The image URI.
     */
    imageURI() {
        return `${this.imageRepo}:${this.version}`;
    }
    /**
     * Get the memory limit in MiB for the instrumentation version.
     * @returns The memory limit
     */
    memoryLimitMiB() {
        return this.memoryLimit;
    }
}
exports.InstrumentationVersion = InstrumentationVersion;
_a = JSII_RTTI_SYMBOL_1;
InstrumentationVersion[_a] = { fqn: "@aws-cdk/aws-applicationsignals-alpha.InstrumentationVersion", version: "2.209.1-alpha.0" };
/**
 * Available versions for Java instrumentation.
 */
class JavaInstrumentationVersion extends InstrumentationVersion {
}
exports.JavaInstrumentationVersion = JavaInstrumentationVersion;
_b = JSII_RTTI_SYMBOL_1;
JavaInstrumentationVersion[_b] = { fqn: "@aws-cdk/aws-applicationsignals-alpha.JavaInstrumentationVersion", version: "2.209.1-alpha.0" };
/**
 * The image repository for Java instrumentation.
 */
JavaInstrumentationVersion.IMAGE_REPO = 'public.ecr.aws/aws-observability/adot-autoinstrumentation-java';
/**
 * The default memory limit of the Java instrumentation.
 */
JavaInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB = 64;
/**
 * ADOT Java Instrumentation version 2.10.0
 */
JavaInstrumentationVersion.V2_10_0 = new JavaInstrumentationVersion(JavaInstrumentationVersion.IMAGE_REPO, 'v2.10.0', JavaInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB);
/**
 * ADOT Java Instrumentation version 1.33.0
 */
JavaInstrumentationVersion.V1_33_0 = new JavaInstrumentationVersion(JavaInstrumentationVersion.IMAGE_REPO, 'v1.33.0', JavaInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB);
/**
 * ADOT Java Instrumentation version 1.32.6
 */
JavaInstrumentationVersion.V1_32_6 = new JavaInstrumentationVersion(JavaInstrumentationVersion.IMAGE_REPO, 'v1.32.6', JavaInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB);
/**
 * Available versions for .NET instrumentation.
 */
/**
 * Available versions for Python instrumentation.
 */
class PythonInstrumentationVersion extends InstrumentationVersion {
}
exports.PythonInstrumentationVersion = PythonInstrumentationVersion;
_c = JSII_RTTI_SYMBOL_1;
PythonInstrumentationVersion[_c] = { fqn: "@aws-cdk/aws-applicationsignals-alpha.PythonInstrumentationVersion", version: "2.209.1-alpha.0" };
/**
 * The image repository for Python instrumentation.
 */
PythonInstrumentationVersion.IMAGE_REPO = 'public.ecr.aws/aws-observability/adot-autoinstrumentation-python';
/**
 * The default memory limit of the Python instrumentation.
 */
PythonInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB = 32;
/**
 * ADOT Python Instrumentation version 0.8.0
 */
PythonInstrumentationVersion.V0_8_0 = new PythonInstrumentationVersion(PythonInstrumentationVersion.IMAGE_REPO, 'v0.8.0', PythonInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB);
/**
 * ADOT Python Instrumentation version 0.8.0
 */
PythonInstrumentationVersion.V0_9_0 = new PythonInstrumentationVersion(PythonInstrumentationVersion.IMAGE_REPO, 'v0.9.0', PythonInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB);
/**
 * Available versions for .NET instrumentation.
 */
class DotnetInstrumentationVersion extends InstrumentationVersion {
}
exports.DotnetInstrumentationVersion = DotnetInstrumentationVersion;
_d = JSII_RTTI_SYMBOL_1;
DotnetInstrumentationVersion[_d] = { fqn: "@aws-cdk/aws-applicationsignals-alpha.DotnetInstrumentationVersion", version: "2.209.1-alpha.0" };
/**
 * The image repository for .NET instrumentation.
 */
DotnetInstrumentationVersion.IMAGE_REPO = 'public.ecr.aws/aws-observability/adot-autoinstrumentation-dotnet';
/**
 * The default memory limit of the .NET instrumentation.
 */
DotnetInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB = 128;
/**
 * ADOT .NET Instrumentation version 1.6.0
 */
DotnetInstrumentationVersion.V1_6_0 = new DotnetInstrumentationVersion(DotnetInstrumentationVersion.IMAGE_REPO, 'v1.6.0', DotnetInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB);
/**
 * ADOT .NET Instrumentation version 1.6.0 for Windows 2022
 */
DotnetInstrumentationVersion.V1_6_0_WINDOWS2022 = new DotnetInstrumentationVersion(DotnetInstrumentationVersion.IMAGE_REPO, 'v1.6.0-windows2022', DotnetInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB);
/**
 * ADOT .NET Instrumentation version 1.6.0 for Windows 2019
 */
DotnetInstrumentationVersion.V1_6_0_WINDOWS2019 = new DotnetInstrumentationVersion(DotnetInstrumentationVersion.IMAGE_REPO, 'v1.6.0-windows2019', DotnetInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB);
/**
 * ADOT .NET Instrumentation version 1.7.0
 */
DotnetInstrumentationVersion.V1_7_0 = new DotnetInstrumentationVersion(DotnetInstrumentationVersion.IMAGE_REPO, 'v1.7.0', DotnetInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB);
/**
 * ADOT .NET Instrumentation version 1.7.0 for Windows 2022
 */
DotnetInstrumentationVersion.V1_7_0_WINDOWS2022 = new DotnetInstrumentationVersion(DotnetInstrumentationVersion.IMAGE_REPO, 'v1.7.0-windows2022', DotnetInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB);
/**
 * ADOT .NET Instrumentation version 1.7.0 for Windows 2019
 */
DotnetInstrumentationVersion.V1_7_0_WINDOWS2019 = new DotnetInstrumentationVersion(DotnetInstrumentationVersion.IMAGE_REPO, 'v1.7.0-windows2019', DotnetInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB);
/**
 * Available versions for Node.js instrumentation.
 */
class NodeInstrumentationVersion extends InstrumentationVersion {
}
exports.NodeInstrumentationVersion = NodeInstrumentationVersion;
_e = JSII_RTTI_SYMBOL_1;
NodeInstrumentationVersion[_e] = { fqn: "@aws-cdk/aws-applicationsignals-alpha.NodeInstrumentationVersion", version: "2.209.1-alpha.0" };
/**
 * The image repository for Node.js instrumentation.
 */
NodeInstrumentationVersion.IMAGE_REPO = 'public.ecr.aws/aws-observability/adot-autoinstrumentation-node';
/**
 * The default memory limit of the Node.js instrumentation.
 */
NodeInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB = 128;
/**
 * ADOT Node.js Instrumentation version 0.5.0
 */
NodeInstrumentationVersion.V0_5_0 = new NodeInstrumentationVersion(NodeInstrumentationVersion.IMAGE_REPO, 'v0.5.0', NodeInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB);
/**
 * ADOT Node.js Instrumentation version 0.6.0
 */
NodeInstrumentationVersion.V0_6_0 = new NodeInstrumentationVersion(NodeInstrumentationVersion.IMAGE_REPO, 'v0.6.0', NodeInstrumentationVersion.DEFAULT_MEMORY_LIMIT_MIB);
//# sourceMappingURL=data:application/json;base64,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